from gtkmvc.controller import Controller
from gtk import mainquit


class ExampleController (Controller):
    """The only one controller. Handles the button clicked signal, and
    notifications about one observable property."""

    def __init__(self, model):
        """Contructor. model will be accessible via the member 'self.model'.
        Registration is also performed."""
        Controller.__init__(self, model)
        return

    def registerView(self, view):
        Controller.registerView(self, view) # Calls the overloaded method

        # Connects the exiting signal:
        view.get_top_widget().connect("destroy", mainquit)
        return

    # Signal
    def on_button1_clicked(self, button):
        """Handles the signal clicked for button1. Changes the model."""
        self.model.set_next_message()
        return

    # Observables notifications:
    def property_message_index_change_notification(self, model, old, new):
        """The model is changed and the view must be updated"""

        print "Controller: property 'message_index' changed"
        msg = model.get_message(new)
        
        self.view['label_text'].set_text(msg)
        self.view['label_text_len'].set_text(str(len(msg)))
        return
    
    pass # end of class

