/*
Bitstream Vera Fonts Copyright

The fonts have a generous copyright, allowing derivative works (as
long as "Bitstream" or "Vera" are not in the names), and full
redistribution (so long as they are not *sold* by themselves). They
can be be bundled, redistributed and sold with any software.

The fonts are distributed under the following copyright:

Copyright
=========

Copyright (c) 2003 by Bitstream, Inc. All Rights Reserved. Bitstream
Vera is a trademark of Bitstream, Inc.

Permission is hereby granted, free of charge, to any person obtaining
a copy of the fonts accompanying this license ("Fonts") and associated
documentation files (the "Font Software"), to reproduce and distribute
the Font Software, including without limitation the rights to use,
copy, merge, publish, distribute, and/or sell copies of the Font
Software, and to permit persons to whom the Font Software is furnished
to do so, subject to the following conditions:

The above copyright and trademark notices and this permission notice
shall be included in all copies of one or more of the Font Software
typefaces.

The Font Software may be modified, altered, or added to, and in
particular the designs of glyphs or characters in the Fonts may be
modified and additional glyphs or characters may be added to the
Fonts, only if the fonts are renamed to names not containing either
the words "Bitstream" or the word "Vera".

This License becomes null and void to the extent applicable to Fonts
or Font Software that has been modified and is distributed under the
"Bitstream Vera" names.

The Font Software may be sold as part of a larger software package but
no copy of one or more of the Font Software typefaces may be sold by
itself.

THE FONT SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO ANY WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
OF COPYRIGHT, PATENT, TRADEMARK, OR OTHER RIGHT. IN NO EVENT SHALL
BITSTREAM OR THE GNOME FOUNDATION BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, INCLUDING ANY GENERAL, SPECIAL, INDIRECT, INCIDENTAL,
OR CONSEQUENTIAL DAMAGES, WHETHER IN AN ACTION OF CONTRACT, TORT OR
OTHERWISE, ARISING FROM, OUT OF THE USE OR INABILITY TO USE THE FONT
SOFTWARE OR FROM OTHER DEALINGS IN THE FONT SOFTWARE.

Except as contained in this notice, the names of Gnome, the Gnome
Foundation, and Bitstream Inc., shall not be used in advertising or
otherwise to promote the sale, use or other dealings in this Font
Software without prior written authorization from the Gnome Foundation
or Bitstream Inc., respectively. For further information, contact:
fonts at gnome dot org.

Copyright FAQ
=============

   1. I don't understand the resale restriction... What gives?

      Bitstream is giving away these fonts, but wishes to ensure its
      competitors can't just drop the fonts as is into a font sale system
      and sell them as is. It seems fair that if Bitstream can't make money
      from the Bitstream Vera fonts, their competitors should not be able to
      do so either. You can sell the fonts as part of any software package,
      however.

   2. I want to package these fonts separately for distribution and
      sale as part of a larger software package or system.  Can I do so?

      Yes. A RPM or Debian package is a "larger software package" to begin 
      with, and you aren't selling them independently by themselves. 
      See 1. above.

   3. Are derivative works allowed?
      Yes!

   4. Can I change or add to the font(s)?
      Yes, but you must change the name(s) of the font(s).

   5. Under what terms are derivative works allowed?

      You must change the name(s) of the fonts. This is to ensure the
      quality of the fonts, both to protect Bitstream and Gnome. We want to
      ensure that if an application has opened a font specifically of these
      names, it gets what it expects (though of course, using fontconfig,
      substitutions could still could have occurred during font
      opening). You must include the Bitstream copyright. Additional
      copyrights can be added, as per copyright law. Happy Font Hacking!

   6. If I have improvements for Bitstream Vera, is it possible they might get 
       adopted in future versions?

      Yes. The contract between the Gnome Foundation and Bitstream has
      provisions for working with Bitstream to ensure quality additions to
      the Bitstream Vera font family. Please contact us if you have such
      additions. Note, that in general, we will want such additions for the
      entire family, not just a single font, and that you'll have to keep
      both Gnome and Jim Lyles, Vera's designer, happy! To make sense to add
      glyphs to the font, they must be stylistically in keeping with Vera's
      design. Vera cannot become a "ransom note" font. Jim Lyles will be
      providing a document describing the design elements used in Vera, as a
      guide and aid for people interested in contributing to Vera.

   7. I want to sell a software package that uses these fonts: Can I do so?

      Sure. Bundle the fonts with your software and sell your software
      with the fonts. That is the intent of the copyright.

   8. If applications have built the names "Bitstream Vera" into them, 
      can I override this somehow to use fonts of my choosing?

      This depends on exact details of the software. Most open source
      systems and software (e.g., Gnome, KDE, etc.) are now converting to
      use fontconfig (see www.fontconfig.org) to handle font configuration,
      selection and substitution; it has provisions for overriding font
      names and subsituting alternatives. An example is provided by the
      supplied local.conf file, which chooses the family Bitstream Vera for
      "sans", "serif" and "monospace".  Other software (e.g., the XFree86
      core server) has other mechanisms for font substitution.



list = [
    "Vera.ttf",
    "VeraIt.ttf",
    "VeraBI.ttf",
    "VeraBd.ttf",
    "VeraMono.ttf",
    "VeraMoIt.ttf",
    "VeraMoBd.ttf",
    "VeraMoBI.ttf",
    "VeraSe.ttf",
    "VeraSeBd.ttf"]

out = open("FontTTF.h",'w')
out.write("/"+"*\n")
out.write(open("COPYRIGHT.TXT").read())
out.write(open("FontTTF.py").read())
out.write("*"+"/\n\n")

for name in list:
    prefix = name[:-4]
    inp = open(name)
    d = inp.read()
    l = len(d)
    out.write("static unsigned int TTF_%s_len = %d;\n"%(prefix,l))
    out.write("static unsigned char TTF_%s_dat[] = {\n"%prefix)
    for a in range(0,l):
        if a:
            out.write(",")
        if (a & 0xF) == 0:
            out.write("\n")
        out.write("%3d"%ord(d[a]))
    out.write("\n")
    out.write("};\n")

out.close()


    

*/

static unsigned int TTF_Vera_len = 65932;
static unsigned char TTF_Vera_dat[] = {

  0,  1,  0,  0,  0, 17,  1,  0,  0,  4,  0, 16, 79, 83, 47, 50,
180, 95,244, 99,  0,  0,235,112,  0,  0,  0, 86, 80, 67, 76, 84,
209,138, 94,151,  0,  0,235,200,  0,  0,  0, 54, 99,109, 97,112,
164,195,232,160,  0,  0,177,108,  0,  0,  3, 88, 99,118,116, 32,
255,211, 29, 57,  0,  0, 30,252,  0,  0,  1,252,102,112,103,109,
231,180,241,196,  0,  0, 38, 96,  0,  0,  0,139,103, 97,115,112,
  0,  7,  0,  7,  0,  1,  1, 72,  0,  0,  0, 12,103,108,121,102,
 12,116, 65,207,  0,  0, 38,236,  0,  0,138,126,104,100,109,120,
 52,240, 33, 14,  0,  0,236,  0,  0,  0, 21, 72,104,101, 97,100,
221,132,162,208,  0,  1,  1, 84,  0,  0,  0, 54,104,104,101, 97,
 16, 69,  8,111,  0,  0,235, 76,  0,  0,  0, 36,104,109,116,120,
  9,198,142,178,  0,  0,180,196,  0,  0,  4, 48,107,101,114,110,
220, 82,213,153,  0,  0,189,160,  0,  0, 45,138,108,111, 99, 97,
243,203,210, 61,  0,  0,187,132,  0,  0,  2, 26,109, 97,120,112,
  5, 71,  6, 58,  0,  0,235, 44,  0,  0,  0, 32,110, 97,109,101,
217,188,200,181,  0,  0,  1, 28,  0,  0, 29,223,112,111,115,116,
180, 90, 47,187,  0,  0,184,244,  0,  0,  2,142,112,114,101,112,
 59,  7,241,  0,  0,  0, 32,248,  0,  0,  5,104,  0,  0,  0, 22,
  1, 14,  0,  1,  0,  0,  0,  0,  0,  0,  0, 58,  0,  0,  0,  1,
  0,  0,  0,  0,  0,  1,  0, 19,  0, 58,  0,  1,  0,  0,  0,  0,
  0,  2,  0,  5,  0, 95,  0,  1,  0,  0,  0,  0,  0,  3,  0, 19,
  0, 58,  0,  1,  0,  0,  0,  0,  0,  4,  0, 19,  0, 58,  0,  1,
  0,  0,  0,  0,  0,  5,  0, 12,  0,100,  0,  1,  0,  0,  0,  0,
  0,  6,  0, 23,  0, 77,  0,  1,  0,  0,  0,  0,  0,  7,  0, 48,
  0,173,  0,  1,  0,  0,  0,  0,  0,  8,  0, 14,  8,108,  0,  1,
  0,  0,  0,  0,  0, 11,  0, 24,  9,131,  0,  1,  0,  0,  0,  0,
  0, 13,  9, 19,  0,112,  0,  3,  0,  1,  4,  9,  0,  0,  0,116,
  9,155,  0,  3,  0,  1,  4,  9,  0,  1,  0, 38, 10, 15,  0,  3,
  0,  1,  4,  9,  0,  2,  0, 10, 10, 89,  0,  3,  0,  1,  4,  9,
  0,  3,  0, 38, 10, 15,  0,  3,  0,  1,  4,  9,  0,  4,  0, 38,
 10, 15,  0,  3,  0,  1,  4,  9,  0,  5,  0, 24, 10, 99,  0,  3,
  0,  1,  4,  9,  0,  6,  0, 46, 10, 53,  0,  3,  0,  1,  4,  9,
  0,  7,  0, 96, 10,245,  0,  3,  0,  1,  4,  9,  0,  8,  0, 28,
 26,115,  0,  3,  0,  1,  4,  9,  0, 11,  0, 48, 28,161,  0,  3,
  0,  1,  4,  9,  0, 13, 18, 38, 10,123, 67,111,112,121,114,105,
103,104,116, 32, 40, 99, 41, 32, 50, 48, 48, 51, 32, 98,121, 32,
 66,105,116,115,116,114,101, 97,109, 44, 32, 73,110, 99, 46, 32,
 65,108,108, 32, 82,105,103,104,116,115, 32, 82,101,115,101,114,
118,101,100, 46, 66,105,116,115,116,114,101, 97,109, 32, 86,101,
114, 97, 32, 83, 97,110,115, 66,105,116,115,116,114,101, 97,109,
 86,101,114, 97, 83, 97,110,115, 45, 82,111,109, 97,110, 82,101,
108,101, 97,115,101, 32, 49, 46, 49, 48, 67,111,112,121,114,105,
103,104,116, 32, 40, 99, 41, 32, 50, 48, 48, 51, 32, 98,121, 32,
 66,105,116,115,116,114,101, 97,109, 44, 32, 73,110, 99, 46, 13,
 10, 65,108,108, 32, 82,105,103,104,116,115, 32, 82,101,115,101,
114,118,101,100, 46, 13, 10, 66,105,116,115,116,114,101, 97,109,
 32, 86,101,114, 97, 32,105,115, 32, 97, 32,116,114, 97,100,101,
109, 97,114,107, 32,111,102, 32, 66,105,116,115,116,114,101, 97,
109, 44, 32, 73,110, 99, 46, 13, 10, 13, 10, 80,101,114,109,105,
115,115,105,111,110, 32,105,115, 32,104,101,114,101, 98,121, 32,
103,114, 97,110,116,101,100, 44, 32,102,114,101,101, 32,111,102,
 32, 99,104, 97,114,103,101, 44, 32,116,111, 32, 97,110,121, 32,
112,101,114,115,111,110, 32,111, 98,116, 97,105,110,105,110,103,
 32, 97, 32, 99,111,112,121, 32,111,102, 32,116,104,101, 32,102,
111,110,116,115, 32, 97, 99, 99,111,109,112, 97,110,121,105,110,
103, 32,116,104,105,115, 32,108,105, 99,101,110,115,101, 32, 40,
 34, 70,111,110,116,115, 34, 41, 32, 97,110,100, 32, 97,115,115,
111, 99,105, 97,116,101,100, 32,100,111, 99,117,109,101,110,116,
 97,116,105,111,110, 32,102,105,108,101,115, 32, 40,116,104,101,
 32, 34, 70,111,110,116, 32, 83,111,102,116,119, 97,114,101, 34,
 41, 44, 32,116,111, 32,114,101,112,114,111,100,117, 99,101, 32,
 97,110,100, 32,100,105,115,116,114,105, 98,117,116,101, 32,116,
104,101, 32, 70,111,110,116, 32, 83,111,102,116,119, 97,114,101,
 44, 32,105,110, 99,108,117,100,105,110,103, 32,119,105,116,104,
111,117,116, 32,108,105,109,105,116, 97,116,105,111,110, 32,116,
104,101, 32,114,105,103,104,116,115, 32,116,111, 32,117,115,101,
 44, 32, 99,111,112,121, 44, 32,109,101,114,103,101, 44, 32,112,
117, 98,108,105,115,104, 44, 32,100,105,115,116,114,105, 98,117,
116,101, 44, 32, 97,110,100, 47,111,114, 32,115,101,108,108, 32,
 99,111,112,105,101,115, 32,111,102, 32,116,104,101, 32, 70,111,
110,116, 32, 83,111,102,116,119, 97,114,101, 44, 32, 97,110,100,
 32,116,111, 32,112,101,114,109,105,116, 32,112,101,114,115,111,
110,115, 32,116,111, 32,119,104,111,109, 32,116,104,101, 32, 70,
111,110,116, 32, 83,111,102,116,119, 97,114,101, 32,105,115, 32,
102,117,114,110,105,115,104,101,100, 32,116,111, 32,100,111, 32,
115,111, 44, 32,115,117, 98,106,101, 99,116, 32,116,111, 32,116,
104,101, 32,102,111,108,108,111,119,105,110,103, 32, 99,111,110,
100,105,116,105,111,110,115, 58, 13, 10, 13, 10, 84,104,101, 32,
 97, 98,111,118,101, 32, 99,111,112,121,114,105,103,104,116, 32,
 97,110,100, 32,116,114, 97,100,101,109, 97,114,107, 32,110,111,
116,105, 99,101,115, 32, 97,110,100, 32,116,104,105,115, 32,112,
101,114,109,105,115,115,105,111,110, 32,110,111,116,105, 99,101,
 32,115,104, 97,108,108, 32, 98,101, 32,105,110, 99,108,117,100,
101,100, 32,105,110, 32, 97,108,108, 32, 99,111,112,105,101,115,
 32,111,102, 32,111,110,101, 32,111,114, 32,109,111,114,101, 32,
111,102, 32,116,104,101, 32, 70,111,110,116, 32, 83,111,102,116,
119, 97,114,101, 32,116,121,112,101,102, 97, 99,101,115, 46, 13,
 10, 13, 10, 84,104,101, 32, 70,111,110,116, 32, 83,111,102,116,
119, 97,114,101, 32,109, 97,121, 32, 98,101, 32,109,111,100,105,
102,105,101,100, 44, 32, 97,108,116,101,114,101,100, 44, 32,111,
114, 32, 97,100,100,101,100, 32,116,111, 44, 32, 97,110,100, 32,
105,110, 32,112, 97,114,116,105, 99,117,108, 97,114, 32,116,104,
101, 32,100,101,115,105,103,110,115, 32,111,102, 32,103,108,121,
112,104,115, 32,111,114, 32, 99,104, 97,114, 97, 99,116,101,114,
115, 32,105,110, 32,116,104,101, 32, 70,111,110,116,115, 32,109,
 97,121, 32, 98,101, 32,109,111,100,105,102,105,101,100, 32, 97,
110,100, 32, 97,100,100,105,116,105,111,110, 97,108, 32,103,108,
121,112,104,115, 32,111,114, 32, 99,104, 97,114, 97, 99,116,101,
114,115, 32,109, 97,121, 32, 98,101, 32, 97,100,100,101,100, 32,
116,111, 32,116,104,101, 32, 70,111,110,116,115, 44, 32,111,110,
108,121, 32,105,102, 32,116,104,101, 32,102,111,110,116,115, 32,
 97,114,101, 32,114,101,110, 97,109,101,100, 32,116,111, 32,110,
 97,109,101,115, 32,110,111,116, 32, 99,111,110,116, 97,105,110,
105,110,103, 32,101,105,116,104,101,114, 32,116,104,101, 32,119,
111,114,100,115, 32, 34, 66,105,116,115,116,114,101, 97,109, 34,
 32,111,114, 32,116,104,101, 32,119,111,114,100, 32, 34, 86,101,
114, 97, 34, 46, 13, 10, 13, 10, 84,104,105,115, 32, 76,105, 99,
101,110,115,101, 32, 98,101, 99,111,109,101,115, 32,110,117,108,
108, 32, 97,110,100, 32,118,111,105,100, 32,116,111, 32,116,104,
101, 32,101,120,116,101,110,116, 32, 97,112,112,108,105, 99, 97,
 98,108,101, 32,116,111, 32, 70,111,110,116,115, 32,111,114, 32,
 70,111,110,116, 32, 83,111,102,116,119, 97,114,101, 32,116,104,
 97,116, 32,104, 97,115, 32, 98,101,101,110, 32,109,111,100,105,
102,105,101,100, 32, 97,110,100, 32,105,115, 32,100,105,115,116,
114,105, 98,117,116,101,100, 32,117,110,100,101,114, 32,116,104,
101, 32, 34, 66,105,116,115,116,114,101, 97,109, 32, 86,101,114,
 97, 34, 32,110, 97,109,101,115, 46, 13, 10, 13, 10, 84,104,101,
 32, 70,111,110,116, 32, 83,111,102,116,119, 97,114,101, 32,109,
 97,121, 32, 98,101, 32,115,111,108,100, 32, 97,115, 32,112, 97,
114,116, 32,111,102, 32, 97, 32,108, 97,114,103,101,114, 32,115,
111,102,116,119, 97,114,101, 32,112, 97, 99,107, 97,103,101, 32,
 98,117,116, 32,110,111, 32, 99,111,112,121, 32,111,102, 32,111,
110,101, 32,111,114, 32,109,111,114,101, 32,111,102, 32,116,104,
101, 32, 70,111,110,116, 32, 83,111,102,116,119, 97,114,101, 32,
116,121,112,101,102, 97, 99,101,115, 32,109, 97,121, 32, 98,101,
 32,115,111,108,100, 32, 98,121, 32,105,116,115,101,108,102, 46,
 13, 10, 13, 10, 84, 72, 69, 32, 70, 79, 78, 84, 32, 83, 79, 70,
 84, 87, 65, 82, 69, 32, 73, 83, 32, 80, 82, 79, 86, 73, 68, 69,
 68, 32, 34, 65, 83, 32, 73, 83, 34, 44, 32, 87, 73, 84, 72, 79,
 85, 84, 32, 87, 65, 82, 82, 65, 78, 84, 89, 32, 79, 70, 32, 65,
 78, 89, 32, 75, 73, 78, 68, 44, 32, 69, 88, 80, 82, 69, 83, 83,
 32, 79, 82, 32, 73, 77, 80, 76, 73, 69, 68, 44, 32, 73, 78, 67,
 76, 85, 68, 73, 78, 71, 32, 66, 85, 84, 32, 78, 79, 84, 32, 76,
 73, 77, 73, 84, 69, 68, 32, 84, 79, 32, 65, 78, 89, 32, 87, 65,
 82, 82, 65, 78, 84, 73, 69, 83, 32, 79, 70, 32, 77, 69, 82, 67,
 72, 65, 78, 84, 65, 66, 73, 76, 73, 84, 89, 44, 32, 70, 73, 84,
 78, 69, 83, 83, 32, 70, 79, 82, 32, 65, 32, 80, 65, 82, 84, 73,
 67, 85, 76, 65, 82, 32, 80, 85, 82, 80, 79, 83, 69, 32, 65, 78,
 68, 32, 78, 79, 78, 73, 78, 70, 82, 73, 78, 71, 69, 77, 69, 78,
 84, 32, 79, 70, 32, 67, 79, 80, 89, 82, 73, 71, 72, 84, 44, 32,
 80, 65, 84, 69, 78, 84, 44, 32, 84, 82, 65, 68, 69, 77, 65, 82,
 75, 44, 32, 79, 82, 32, 79, 84, 72, 69, 82, 32, 82, 73, 71, 72,
 84, 46, 32, 73, 78, 32, 78, 79, 32, 69, 86, 69, 78, 84, 32, 83,
 72, 65, 76, 76, 32, 66, 73, 84, 83, 84, 82, 69, 65, 77, 32, 79,
 82, 32, 84, 72, 69, 32, 71, 78, 79, 77, 69, 32, 70, 79, 85, 78,
 68, 65, 84, 73, 79, 78, 32, 66, 69, 32, 76, 73, 65, 66, 76, 69,
 32, 70, 79, 82, 32, 65, 78, 89, 32, 67, 76, 65, 73, 77, 44, 32,
 68, 65, 77, 65, 71, 69, 83, 32, 79, 82, 32, 79, 84, 72, 69, 82,
 32, 76, 73, 65, 66, 73, 76, 73, 84, 89, 44, 32, 73, 78, 67, 76,
 85, 68, 73, 78, 71, 32, 65, 78, 89, 32, 71, 69, 78, 69, 82, 65,
 76, 44, 32, 83, 80, 69, 67, 73, 65, 76, 44, 32, 73, 78, 68, 73,
 82, 69, 67, 84, 44, 32, 73, 78, 67, 73, 68, 69, 78, 84, 65, 76,
 44, 32, 79, 82, 32, 67, 79, 78, 83, 69, 81, 85, 69, 78, 84, 73,
 65, 76, 32, 68, 65, 77, 65, 71, 69, 83, 44, 32, 87, 72, 69, 84,
 72, 69, 82, 32, 73, 78, 32, 65, 78, 32, 65, 67, 84, 73, 79, 78,
 32, 79, 70, 32, 67, 79, 78, 84, 82, 65, 67, 84, 44, 32, 84, 79,
 82, 84, 32, 79, 82, 32, 79, 84, 72, 69, 82, 87, 73, 83, 69, 44,
 32, 65, 82, 73, 83, 73, 78, 71, 32, 70, 82, 79, 77, 44, 32, 79,
 85, 84, 32, 79, 70, 32, 84, 72, 69, 32, 85, 83, 69, 32, 79, 82,
 32, 73, 78, 65, 66, 73, 76, 73, 84, 89, 32, 84, 79, 32, 85, 83,
 69, 32, 84, 72, 69, 32, 70, 79, 78, 84, 32, 83, 79, 70, 84, 87,
 65, 82, 69, 32, 79, 82, 32, 70, 82, 79, 77, 32, 79, 84, 72, 69,
 82, 32, 68, 69, 65, 76, 73, 78, 71, 83, 32, 73, 78, 32, 84, 72,
 69, 32, 70, 79, 78, 84, 32, 83, 79, 70, 84, 87, 65, 82, 69, 46,
 13, 10, 13, 10, 69,120, 99,101,112,116, 32, 97,115, 32, 99,111,
110,116, 97,105,110,101,100, 32,105,110, 32,116,104,105,115, 32,
110,111,116,105, 99,101, 44, 32,116,104,101, 32,110, 97,109,101,
115, 32,111,102, 32, 71,110,111,109,101, 44, 32,116,104,101, 32,
 71,110,111,109,101, 32, 70,111,117,110,100, 97,116,105,111,110,
 44, 32, 97,110,100, 32, 66,105,116,115,116,114,101, 97,109, 32,
 73,110, 99, 46, 44, 32,115,104, 97,108,108, 32,110,111,116, 32,
 98,101, 32,117,115,101,100, 32,105,110, 32, 97,100,118,101,114,
116,105,115,105,110,103, 32,111,114, 32,111,116,104,101,114,119,
105,115,101, 32,116,111, 32,112,114,111,109,111,116,101, 32,116,
104,101, 32,115, 97,108,101, 44, 32,117,115,101, 32,111,114, 32,
111,116,104,101,114, 32,100,101, 97,108,105,110,103,115, 32,105,
110, 32,116,104,105,115, 32, 70,111,110,116, 32, 83,111,102,116,
119, 97,114,101, 32,119,105,116,104,111,117,116, 32,112,114,105,
111,114, 32,119,114,105,116,116,101,110, 32, 97,117,116,104,111,
114,105,122, 97,116,105,111,110, 32,102,114,111,109, 32,116,104,
101, 32, 71,110,111,109,101, 32, 70,111,117,110,100, 97,116,105,
111,110, 32,111,114, 32, 66,105,116,115,116,114,101, 97,109, 32,
 73,110, 99, 46, 44, 32,114,101,115,112,101, 99,116,105,118,101,
108,121, 46, 32, 70,111,114, 32,102,117,114,116,104,101,114, 32,
105,110,102,111,114,109, 97,116,105,111,110, 44, 32, 99,111,110,
116, 97, 99,116, 58, 32,102,111,110,116,115, 32, 97,116, 32,103,
110,111,109,101, 32,100,111,116, 32,111,114,103, 46,104,116,116,
112, 58, 47, 47,119,119,119, 46, 98,105,116,115,116,114,101, 97,
109, 46, 99,111,109,  0, 67,  0,111,  0,112,  0,121,  0,114,  0,
105,  0,103,  0,104,  0,116,  0, 32,  0, 40,  0, 99,  0, 41,  0,
 32,  0, 50,  0, 48,  0, 48,  0, 51,  0, 32,  0, 98,  0,121,  0,
 32,  0, 66,  0,105,  0,116,  0,115,  0,116,  0,114,  0,101,  0,
 97,  0,109,  0, 44,  0, 32,  0, 73,  0,110,  0, 99,  0, 46,  0,
 32,  0, 65,  0,108,  0,108,  0, 32,  0, 82,  0,105,  0,103,  0,
104,  0,116,  0,115,  0, 32,  0, 82,  0,101,  0,115,  0,101,  0,
114,  0,118,  0,101,  0,100,  0, 46,  0, 66,  0,105,  0,116,  0,
115,  0,116,  0,114,  0,101,  0, 97,  0,109,  0, 32,  0, 86,  0,
101,  0,114,  0, 97,  0, 32,  0, 83,  0, 97,  0,110,  0,115,  0,
 66,  0,105,  0,116,  0,115,  0,116,  0,114,  0,101,  0, 97,  0,
109,  0, 86,  0,101,  0,114,  0, 97,  0, 83,  0, 97,  0,110,  0,
115,  0, 45,  0, 82,  0,111,  0,109,  0, 97,  0,110,  0, 82,  0,
101,  0,108,  0,101,  0, 97,  0,115,  0,101,  0, 32,  0, 49,  0,
 46,  0, 49,  0, 48,  0, 67,  0,111,  0,112,  0,121,  0,114,  0,
105,  0,103,  0,104,  0,116,  0, 32,  0, 40,  0, 99,  0, 41,  0,
 32,  0, 50,  0, 48,  0, 48,  0, 51,  0, 32,  0, 98,  0,121,  0,
 32,  0, 66,  0,105,  0,116,  0,115,  0,116,  0,114,  0,101,  0,
 97,  0,109,  0, 44,  0, 32,  0, 73,  0,110,  0, 99,  0, 46,  0,
 13,  0, 10,  0, 65,  0,108,  0,108,  0, 32,  0, 82,  0,105,  0,
103,  0,104,  0,116,  0,115,  0, 32,  0, 82,  0,101,  0,115,  0,
101,  0,114,  0,118,  0,101,  0,100,  0, 46,  0, 13,  0, 10,  0,
 66,  0,105,  0,116,  0,115,  0,116,  0,114,  0,101,  0, 97,  0,
109,  0, 32,  0, 86,  0,101,  0,114,  0, 97,  0, 32,  0,105,  0,
115,  0, 32,  0, 97,  0, 32,  0,116,  0,114,  0, 97,  0,100,  0,
101,  0,109,  0, 97,  0,114,  0,107,  0, 32,  0,111,  0,102,  0,
 32,  0, 66,  0,105,  0,116,  0,115,  0,116,  0,114,  0,101,  0,
 97,  0,109,  0, 44,  0, 32,  0, 73,  0,110,  0, 99,  0, 46,  0,
 13,  0, 10,  0, 13,  0, 10,  0, 80,  0,101,  0,114,  0,109,  0,
105,  0,115,  0,115,  0,105,  0,111,  0,110,  0, 32,  0,105,  0,
115,  0, 32,  0,104,  0,101,  0,114,  0,101,  0, 98,  0,121,  0,
 32,  0,103,  0,114,  0, 97,  0,110,  0,116,  0,101,  0,100,  0,
 44,  0, 32,  0,102,  0,114,  0,101,  0,101,  0, 32,  0,111,  0,
102,  0, 32,  0, 99,  0,104,  0, 97,  0,114,  0,103,  0,101,  0,
 44,  0, 32,  0,116,  0,111,  0, 32,  0, 97,  0,110,  0,121,  0,
 32,  0,112,  0,101,  0,114,  0,115,  0,111,  0,110,  0, 32,  0,
111,  0, 98,  0,116,  0, 97,  0,105,  0,110,  0,105,  0,110,  0,
103,  0, 32,  0, 97,  0, 32,  0, 99,  0,111,  0,112,  0,121,  0,
 32,  0,111,  0,102,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0,
102,  0,111,  0,110,  0,116,  0,115,  0, 32,  0, 97,  0, 99,  0,
 99,  0,111,  0,109,  0,112,  0, 97,  0,110,  0,121,  0,105,  0,
110,  0,103,  0, 32,  0,116,  0,104,  0,105,  0,115,  0, 32,  0,
108,  0,105,  0, 99,  0,101,  0,110,  0,115,  0,101,  0, 32,  0,
 40,  0, 34,  0, 70,  0,111,  0,110,  0,116,  0,115,  0, 34,  0,
 41,  0, 32,  0, 97,  0,110,  0,100,  0, 32,  0, 97,  0,115,  0,
115,  0,111,  0, 99,  0,105,  0, 97,  0,116,  0,101,  0,100,  0,
 32,  0,100,  0,111,  0, 99,  0,117,  0,109,  0,101,  0,110,  0,
116,  0, 97,  0,116,  0,105,  0,111,  0,110,  0, 32,  0,102,  0,
105,  0,108,  0,101,  0,115,  0, 32,  0, 40,  0,116,  0,104,  0,
101,  0, 32,  0, 34,  0, 70,  0,111,  0,110,  0,116,  0, 32,  0,
 83,  0,111,  0,102,  0,116,  0,119,  0, 97,  0,114,  0,101,  0,
 34,  0, 41,  0, 44,  0, 32,  0,116,  0,111,  0, 32,  0,114,  0,
101,  0,112,  0,114,  0,111,  0,100,  0,117,  0, 99,  0,101,  0,
 32,  0, 97,  0,110,  0,100,  0, 32,  0,100,  0,105,  0,115,  0,
116,  0,114,  0,105,  0, 98,  0,117,  0,116,  0,101,  0, 32,  0,
116,  0,104,  0,101,  0, 32,  0, 70,  0,111,  0,110,  0,116,  0,
 32,  0, 83,  0,111,  0,102,  0,116,  0,119,  0, 97,  0,114,  0,
101,  0, 44,  0, 32,  0,105,  0,110,  0, 99,  0,108,  0,117,  0,
100,  0,105,  0,110,  0,103,  0, 32,  0,119,  0,105,  0,116,  0,
104,  0,111,  0,117,  0,116,  0, 32,  0,108,  0,105,  0,109,  0,
105,  0,116,  0, 97,  0,116,  0,105,  0,111,  0,110,  0, 32,  0,
116,  0,104,  0,101,  0, 32,  0,114,  0,105,  0,103,  0,104,  0,
116,  0,115,  0, 32,  0,116,  0,111,  0, 32,  0,117,  0,115,  0,
101,  0, 44,  0, 32,  0, 99,  0,111,  0,112,  0,121,  0, 44,  0,
 32,  0,109,  0,101,  0,114,  0,103,  0,101,  0, 44,  0, 32,  0,
112,  0,117,  0, 98,  0,108,  0,105,  0,115,  0,104,  0, 44,  0,
 32,  0,100,  0,105,  0,115,  0,116,  0,114,  0,105,  0, 98,  0,
117,  0,116,  0,101,  0, 44,  0, 32,  0, 97,  0,110,  0,100,  0,
 47,  0,111,  0,114,  0, 32,  0,115,  0,101,  0,108,  0,108,  0,
 32,  0, 99,  0,111,  0,112,  0,105,  0,101,  0,115,  0, 32,  0,
111,  0,102,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0, 70,  0,
111,  0,110,  0,116,  0, 32,  0, 83,  0,111,  0,102,  0,116,  0,
119,  0, 97,  0,114,  0,101,  0, 44,  0, 32,  0, 97,  0,110,  0,
100,  0, 32,  0,116,  0,111,  0, 32,  0,112,  0,101,  0,114,  0,
109,  0,105,  0,116,  0, 32,  0,112,  0,101,  0,114,  0,115,  0,
111,  0,110,  0,115,  0, 32,  0,116,  0,111,  0, 32,  0,119,  0,
104,  0,111,  0,109,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0,
 70,  0,111,  0,110,  0,116,  0, 32,  0, 83,  0,111,  0,102,  0,
116,  0,119,  0, 97,  0,114,  0,101,  0, 32,  0,105,  0,115,  0,
 32,  0,102,  0,117,  0,114,  0,110,  0,105,  0,115,  0,104,  0,
101,  0,100,  0, 32,  0,116,  0,111,  0, 32,  0,100,  0,111,  0,
 32,  0,115,  0,111,  0, 44,  0, 32,  0,115,  0,117,  0, 98,  0,
106,  0,101,  0, 99,  0,116,  0, 32,  0,116,  0,111,  0, 32,  0,
116,  0,104,  0,101,  0, 32,  0,102,  0,111,  0,108,  0,108,  0,
111,  0,119,  0,105,  0,110,  0,103,  0, 32,  0, 99,  0,111,  0,
110,  0,100,  0,105,  0,116,  0,105,  0,111,  0,110,  0,115,  0,
 58,  0, 13,  0, 10,  0, 13,  0, 10,  0, 84,  0,104,  0,101,  0,
 32,  0, 97,  0, 98,  0,111,  0,118,  0,101,  0, 32,  0, 99,  0,
111,  0,112,  0,121,  0,114,  0,105,  0,103,  0,104,  0,116,  0,
 32,  0, 97,  0,110,  0,100,  0, 32,  0,116,  0,114,  0, 97,  0,
100,  0,101,  0,109,  0, 97,  0,114,  0,107,  0, 32,  0,110,  0,
111,  0,116,  0,105,  0, 99,  0,101,  0,115,  0, 32,  0, 97,  0,
110,  0,100,  0, 32,  0,116,  0,104,  0,105,  0,115,  0, 32,  0,
112,  0,101,  0,114,  0,109,  0,105,  0,115,  0,115,  0,105,  0,
111,  0,110,  0, 32,  0,110,  0,111,  0,116,  0,105,  0, 99,  0,
101,  0, 32,  0,115,  0,104,  0, 97,  0,108,  0,108,  0, 32,  0,
 98,  0,101,  0, 32,  0,105,  0,110,  0, 99,  0,108,  0,117,  0,
100,  0,101,  0,100,  0, 32,  0,105,  0,110,  0, 32,  0, 97,  0,
108,  0,108,  0, 32,  0, 99,  0,111,  0,112,  0,105,  0,101,  0,
115,  0, 32,  0,111,  0,102,  0, 32,  0,111,  0,110,  0,101,  0,
 32,  0,111,  0,114,  0, 32,  0,109,  0,111,  0,114,  0,101,  0,
 32,  0,111,  0,102,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0,
 70,  0,111,  0,110,  0,116,  0, 32,  0, 83,  0,111,  0,102,  0,
116,  0,119,  0, 97,  0,114,  0,101,  0, 32,  0,116,  0,121,  0,
112,  0,101,  0,102,  0, 97,  0, 99,  0,101,  0,115,  0, 46,  0,
 13,  0, 10,  0, 13,  0, 10,  0, 84,  0,104,  0,101,  0, 32,  0,
 70,  0,111,  0,110,  0,116,  0, 32,  0, 83,  0,111,  0,102,  0,
116,  0,119,  0, 97,  0,114,  0,101,  0, 32,  0,109,  0, 97,  0,
121,  0, 32,  0, 98,  0,101,  0, 32,  0,109,  0,111,  0,100,  0,
105,  0,102,  0,105,  0,101,  0,100,  0, 44,  0, 32,  0, 97,  0,
108,  0,116,  0,101,  0,114,  0,101,  0,100,  0, 44,  0, 32,  0,
111,  0,114,  0, 32,  0, 97,  0,100,  0,100,  0,101,  0,100,  0,
 32,  0,116,  0,111,  0, 44,  0, 32,  0, 97,  0,110,  0,100,  0,
 32,  0,105,  0,110,  0, 32,  0,112,  0, 97,  0,114,  0,116,  0,
105,  0, 99,  0,117,  0,108,  0, 97,  0,114,  0, 32,  0,116,  0,
104,  0,101,  0, 32,  0,100,  0,101,  0,115,  0,105,  0,103,  0,
110,  0,115,  0, 32,  0,111,  0,102,  0, 32,  0,103,  0,108,  0,
121,  0,112,  0,104,  0,115,  0, 32,  0,111,  0,114,  0, 32,  0,
 99,  0,104,  0, 97,  0,114,  0, 97,  0, 99,  0,116,  0,101,  0,
114,  0,115,  0, 32,  0,105,  0,110,  0, 32,  0,116,  0,104,  0,
101,  0, 32,  0, 70,  0,111,  0,110,  0,116,  0,115,  0, 32,  0,
109,  0, 97,  0,121,  0, 32,  0, 98,  0,101,  0, 32,  0,109,  0,
111,  0,100,  0,105,  0,102,  0,105,  0,101,  0,100,  0, 32,  0,
 97,  0,110,  0,100,  0, 32,  0, 97,  0,100,  0,100,  0,105,  0,
116,  0,105,  0,111,  0,110,  0, 97,  0,108,  0, 32,  0,103,  0,
108,  0,121,  0,112,  0,104,  0,115,  0, 32,  0,111,  0,114,  0,
 32,  0, 99,  0,104,  0, 97,  0,114,  0, 97,  0, 99,  0,116,  0,
101,  0,114,  0,115,  0, 32,  0,109,  0, 97,  0,121,  0, 32,  0,
 98,  0,101,  0, 32,  0, 97,  0,100,  0,100,  0,101,  0,100,  0,
 32,  0,116,  0,111,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0,
 70,  0,111,  0,110,  0,116,  0,115,  0, 44,  0, 32,  0,111,  0,
110,  0,108,  0,121,  0, 32,  0,105,  0,102,  0, 32,  0,116,  0,
104,  0,101,  0, 32,  0,102,  0,111,  0,110,  0,116,  0,115,  0,
 32,  0, 97,  0,114,  0,101,  0, 32,  0,114,  0,101,  0,110,  0,
 97,  0,109,  0,101,  0,100,  0, 32,  0,116,  0,111,  0, 32,  0,
110,  0, 97,  0,109,  0,101,  0,115,  0, 32,  0,110,  0,111,  0,
116,  0, 32,  0, 99,  0,111,  0,110,  0,116,  0, 97,  0,105,  0,
110,  0,105,  0,110,  0,103,  0, 32,  0,101,  0,105,  0,116,  0,
104,  0,101,  0,114,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0,
119,  0,111,  0,114,  0,100,  0,115,  0, 32,  0, 34,  0, 66,  0,
105,  0,116,  0,115,  0,116,  0,114,  0,101,  0, 97,  0,109,  0,
 34,  0, 32,  0,111,  0,114,  0, 32,  0,116,  0,104,  0,101,  0,
 32,  0,119,  0,111,  0,114,  0,100,  0, 32,  0, 34,  0, 86,  0,
101,  0,114,  0, 97,  0, 34,  0, 46,  0, 13,  0, 10,  0, 13,  0,
 10,  0, 84,  0,104,  0,105,  0,115,  0, 32,  0, 76,  0,105,  0,
 99,  0,101,  0,110,  0,115,  0,101,  0, 32,  0, 98,  0,101,  0,
 99,  0,111,  0,109,  0,101,  0,115,  0, 32,  0,110,  0,117,  0,
108,  0,108,  0, 32,  0, 97,  0,110,  0,100,  0, 32,  0,118,  0,
111,  0,105,  0,100,  0, 32,  0,116,  0,111,  0, 32,  0,116,  0,
104,  0,101,  0, 32,  0,101,  0,120,  0,116,  0,101,  0,110,  0,
116,  0, 32,  0, 97,  0,112,  0,112,  0,108,  0,105,  0, 99,  0,
 97,  0, 98,  0,108,  0,101,  0, 32,  0,116,  0,111,  0, 32,  0,
 70,  0,111,  0,110,  0,116,  0,115,  0, 32,  0,111,  0,114,  0,
 32,  0, 70,  0,111,  0,110,  0,116,  0, 32,  0, 83,  0,111,  0,
102,  0,116,  0,119,  0, 97,  0,114,  0,101,  0, 32,  0,116,  0,
104,  0, 97,  0,116,  0, 32,  0,104,  0, 97,  0,115,  0, 32,  0,
 98,  0,101,  0,101,  0,110,  0, 32,  0,109,  0,111,  0,100,  0,
105,  0,102,  0,105,  0,101,  0,100,  0, 32,  0, 97,  0,110,  0,
100,  0, 32,  0,105,  0,115,  0, 32,  0,100,  0,105,  0,115,  0,
116,  0,114,  0,105,  0, 98,  0,117,  0,116,  0,101,  0,100,  0,
 32,  0,117,  0,110,  0,100,  0,101,  0,114,  0, 32,  0,116,  0,
104,  0,101,  0, 32,  0, 34,  0, 66,  0,105,  0,116,  0,115,  0,
116,  0,114,  0,101,  0, 97,  0,109,  0, 32,  0, 86,  0,101,  0,
114,  0, 97,  0, 34,  0, 32,  0,110,  0, 97,  0,109,  0,101,  0,
115,  0, 46,  0, 13,  0, 10,  0, 13,  0, 10,  0, 84,  0,104,  0,
101,  0, 32,  0, 70,  0,111,  0,110,  0,116,  0, 32,  0, 83,  0,
111,  0,102,  0,116,  0,119,  0, 97,  0,114,  0,101,  0, 32,  0,
109,  0, 97,  0,121,  0, 32,  0, 98,  0,101,  0, 32,  0,115,  0,
111,  0,108,  0,100,  0, 32,  0, 97,  0,115,  0, 32,  0,112,  0,
 97,  0,114,  0,116,  0, 32,  0,111,  0,102,  0, 32,  0, 97,  0,
 32,  0,108,  0, 97,  0,114,  0,103,  0,101,  0,114,  0, 32,  0,
115,  0,111,  0,102,  0,116,  0,119,  0, 97,  0,114,  0,101,  0,
 32,  0,112,  0, 97,  0, 99,  0,107,  0, 97,  0,103,  0,101,  0,
 32,  0, 98,  0,117,  0,116,  0, 32,  0,110,  0,111,  0, 32,  0,
 99,  0,111,  0,112,  0,121,  0, 32,  0,111,  0,102,  0, 32,  0,
111,  0,110,  0,101,  0, 32,  0,111,  0,114,  0, 32,  0,109,  0,
111,  0,114,  0,101,  0, 32,  0,111,  0,102,  0, 32,  0,116,  0,
104,  0,101,  0, 32,  0, 70,  0,111,  0,110,  0,116,  0, 32,  0,
 83,  0,111,  0,102,  0,116,  0,119,  0, 97,  0,114,  0,101,  0,
 32,  0,116,  0,121,  0,112,  0,101,  0,102,  0, 97,  0, 99,  0,
101,  0,115,  0, 32,  0,109,  0, 97,  0,121,  0, 32,  0, 98,  0,
101,  0, 32,  0,115,  0,111,  0,108,  0,100,  0, 32,  0, 98,  0,
121,  0, 32,  0,105,  0,116,  0,115,  0,101,  0,108,  0,102,  0,
 46,  0, 13,  0, 10,  0, 13,  0, 10,  0, 84,  0, 72,  0, 69,  0,
 32,  0, 70,  0, 79,  0, 78,  0, 84,  0, 32,  0, 83,  0, 79,  0,
 70,  0, 84,  0, 87,  0, 65,  0, 82,  0, 69,  0, 32,  0, 73,  0,
 83,  0, 32,  0, 80,  0, 82,  0, 79,  0, 86,  0, 73,  0, 68,  0,
 69,  0, 68,  0, 32,  0, 34,  0, 65,  0, 83,  0, 32,  0, 73,  0,
 83,  0, 34,  0, 44,  0, 32,  0, 87,  0, 73,  0, 84,  0, 72,  0,
 79,  0, 85,  0, 84,  0, 32,  0, 87,  0, 65,  0, 82,  0, 82,  0,
 65,  0, 78,  0, 84,  0, 89,  0, 32,  0, 79,  0, 70,  0, 32,  0,
 65,  0, 78,  0, 89,  0, 32,  0, 75,  0, 73,  0, 78,  0, 68,  0,
 44,  0, 32,  0, 69,  0, 88,  0, 80,  0, 82,  0, 69,  0, 83,  0,
 83,  0, 32,  0, 79,  0, 82,  0, 32,  0, 73,  0, 77,  0, 80,  0,
 76,  0, 73,  0, 69,  0, 68,  0, 44,  0, 32,  0, 73,  0, 78,  0,
 67,  0, 76,  0, 85,  0, 68,  0, 73,  0, 78,  0, 71,  0, 32,  0,
 66,  0, 85,  0, 84,  0, 32,  0, 78,  0, 79,  0, 84,  0, 32,  0,
 76,  0, 73,  0, 77,  0, 73,  0, 84,  0, 69,  0, 68,  0, 32,  0,
 84,  0, 79,  0, 32,  0, 65,  0, 78,  0, 89,  0, 32,  0, 87,  0,
 65,  0, 82,  0, 82,  0, 65,  0, 78,  0, 84,  0, 73,  0, 69,  0,
 83,  0, 32,  0, 79,  0, 70,  0, 32,  0, 77,  0, 69,  0, 82,  0,
 67,  0, 72,  0, 65,  0, 78,  0, 84,  0, 65,  0, 66,  0, 73,  0,
 76,  0, 73,  0, 84,  0, 89,  0, 44,  0, 32,  0, 70,  0, 73,  0,
 84,  0, 78,  0, 69,  0, 83,  0, 83,  0, 32,  0, 70,  0, 79,  0,
 82,  0, 32,  0, 65,  0, 32,  0, 80,  0, 65,  0, 82,  0, 84,  0,
 73,  0, 67,  0, 85,  0, 76,  0, 65,  0, 82,  0, 32,  0, 80,  0,
 85,  0, 82,  0, 80,  0, 79,  0, 83,  0, 69,  0, 32,  0, 65,  0,
 78,  0, 68,  0, 32,  0, 78,  0, 79,  0, 78,  0, 73,  0, 78,  0,
 70,  0, 82,  0, 73,  0, 78,  0, 71,  0, 69,  0, 77,  0, 69,  0,
 78,  0, 84,  0, 32,  0, 79,  0, 70,  0, 32,  0, 67,  0, 79,  0,
 80,  0, 89,  0, 82,  0, 73,  0, 71,  0, 72,  0, 84,  0, 44,  0,
 32,  0, 80,  0, 65,  0, 84,  0, 69,  0, 78,  0, 84,  0, 44,  0,
 32,  0, 84,  0, 82,  0, 65,  0, 68,  0, 69,  0, 77,  0, 65,  0,
 82,  0, 75,  0, 44,  0, 32,  0, 79,  0, 82,  0, 32,  0, 79,  0,
 84,  0, 72,  0, 69,  0, 82,  0, 32,  0, 82,  0, 73,  0, 71,  0,
 72,  0, 84,  0, 46,  0, 32,  0, 73,  0, 78,  0, 32,  0, 78,  0,
 79,  0, 32,  0, 69,  0, 86,  0, 69,  0, 78,  0, 84,  0, 32,  0,
 83,  0, 72,  0, 65,  0, 76,  0, 76,  0, 32,  0, 66,  0, 73,  0,
 84,  0, 83,  0, 84,  0, 82,  0, 69,  0, 65,  0, 77,  0, 32,  0,
 79,  0, 82,  0, 32,  0, 84,  0, 72,  0, 69,  0, 32,  0, 71,  0,
 78,  0, 79,  0, 77,  0, 69,  0, 32,  0, 70,  0, 79,  0, 85,  0,
 78,  0, 68,  0, 65,  0, 84,  0, 73,  0, 79,  0, 78,  0, 32,  0,
 66,  0, 69,  0, 32,  0, 76,  0, 73,  0, 65,  0, 66,  0, 76,  0,
 69,  0, 32,  0, 70,  0, 79,  0, 82,  0, 32,  0, 65,  0, 78,  0,
 89,  0, 32,  0, 67,  0, 76,  0, 65,  0, 73,  0, 77,  0, 44,  0,
 32,  0, 68,  0, 65,  0, 77,  0, 65,  0, 71,  0, 69,  0, 83,  0,
 32,  0, 79,  0, 82,  0, 32,  0, 79,  0, 84,  0, 72,  0, 69,  0,
 82,  0, 32,  0, 76,  0, 73,  0, 65,  0, 66,  0, 73,  0, 76,  0,
 73,  0, 84,  0, 89,  0, 44,  0, 32,  0, 73,  0, 78,  0, 67,  0,
 76,  0, 85,  0, 68,  0, 73,  0, 78,  0, 71,  0, 32,  0, 65,  0,
 78,  0, 89,  0, 32,  0, 71,  0, 69,  0, 78,  0, 69,  0, 82,  0,
 65,  0, 76,  0, 44,  0, 32,  0, 83,  0, 80,  0, 69,  0, 67,  0,
 73,  0, 65,  0, 76,  0, 44,  0, 32,  0, 73,  0, 78,  0, 68,  0,
 73,  0, 82,  0, 69,  0, 67,  0, 84,  0, 44,  0, 32,  0, 73,  0,
 78,  0, 67,  0, 73,  0, 68,  0, 69,  0, 78,  0, 84,  0, 65,  0,
 76,  0, 44,  0, 32,  0, 79,  0, 82,  0, 32,  0, 67,  0, 79,  0,
 78,  0, 83,  0, 69,  0, 81,  0, 85,  0, 69,  0, 78,  0, 84,  0,
 73,  0, 65,  0, 76,  0, 32,  0, 68,  0, 65,  0, 77,  0, 65,  0,
 71,  0, 69,  0, 83,  0, 44,  0, 32,  0, 87,  0, 72,  0, 69,  0,
 84,  0, 72,  0, 69,  0, 82,  0, 32,  0, 73,  0, 78,  0, 32,  0,
 65,  0, 78,  0, 32,  0, 65,  0, 67,  0, 84,  0, 73,  0, 79,  0,
 78,  0, 32,  0, 79,  0, 70,  0, 32,  0, 67,  0, 79,  0, 78,  0,
 84,  0, 82,  0, 65,  0, 67,  0, 84,  0, 44,  0, 32,  0, 84,  0,
 79,  0, 82,  0, 84,  0, 32,  0, 79,  0, 82,  0, 32,  0, 79,  0,
 84,  0, 72,  0, 69,  0, 82,  0, 87,  0, 73,  0, 83,  0, 69,  0,
 44,  0, 32,  0, 65,  0, 82,  0, 73,  0, 83,  0, 73,  0, 78,  0,
 71,  0, 32,  0, 70,  0, 82,  0, 79,  0, 77,  0, 44,  0, 32,  0,
 79,  0, 85,  0, 84,  0, 32,  0, 79,  0, 70,  0, 32,  0, 84,  0,
 72,  0, 69,  0, 32,  0, 85,  0, 83,  0, 69,  0, 32,  0, 79,  0,
 82,  0, 32,  0, 73,  0, 78,  0, 65,  0, 66,  0, 73,  0, 76,  0,
 73,  0, 84,  0, 89,  0, 32,  0, 84,  0, 79,  0, 32,  0, 85,  0,
 83,  0, 69,  0, 32,  0, 84,  0, 72,  0, 69,  0, 32,  0, 70,  0,
 79,  0, 78,  0, 84,  0, 32,  0, 83,  0, 79,  0, 70,  0, 84,  0,
 87,  0, 65,  0, 82,  0, 69,  0, 32,  0, 79,  0, 82,  0, 32,  0,
 70,  0, 82,  0, 79,  0, 77,  0, 32,  0, 79,  0, 84,  0, 72,  0,
 69,  0, 82,  0, 32,  0, 68,  0, 69,  0, 65,  0, 76,  0, 73,  0,
 78,  0, 71,  0, 83,  0, 32,  0, 73,  0, 78,  0, 32,  0, 84,  0,
 72,  0, 69,  0, 32,  0, 70,  0, 79,  0, 78,  0, 84,  0, 32,  0,
 83,  0, 79,  0, 70,  0, 84,  0, 87,  0, 65,  0, 82,  0, 69,  0,
 46,  0, 13,  0, 10,  0, 13,  0, 10,  0, 69,  0,120,  0, 99,  0,
101,  0,112,  0,116,  0, 32,  0, 97,  0,115,  0, 32,  0, 99,  0,
111,  0,110,  0,116,  0, 97,  0,105,  0,110,  0,101,  0,100,  0,
 32,  0,105,  0,110,  0, 32,  0,116,  0,104,  0,105,  0,115,  0,
 32,  0,110,  0,111,  0,116,  0,105,  0, 99,  0,101,  0, 44,  0,
 32,  0,116,  0,104,  0,101,  0, 32,  0,110,  0, 97,  0,109,  0,
101,  0,115,  0, 32,  0,111,  0,102,  0, 32,  0, 71,  0,110,  0,
111,  0,109,  0,101,  0, 44,  0, 32,  0,116,  0,104,  0,101,  0,
 32,  0, 71,  0,110,  0,111,  0,109,  0,101,  0, 32,  0, 70,  0,
111,  0,117,  0,110,  0,100,  0, 97,  0,116,  0,105,  0,111,  0,
110,  0, 44,  0, 32,  0, 97,  0,110,  0,100,  0, 32,  0, 66,  0,
105,  0,116,  0,115,  0,116,  0,114,  0,101,  0, 97,  0,109,  0,
 32,  0, 73,  0,110,  0, 99,  0, 46,  0, 44,  0, 32,  0,115,  0,
104,  0, 97,  0,108,  0,108,  0, 32,  0,110,  0,111,  0,116,  0,
 32,  0, 98,  0,101,  0, 32,  0,117,  0,115,  0,101,  0,100,  0,
 32,  0,105,  0,110,  0, 32,  0, 97,  0,100,  0,118,  0,101,  0,
114,  0,116,  0,105,  0,115,  0,105,  0,110,  0,103,  0, 32,  0,
111,  0,114,  0, 32,  0,111,  0,116,  0,104,  0,101,  0,114,  0,
119,  0,105,  0,115,  0,101,  0, 32,  0,116,  0,111,  0, 32,  0,
112,  0,114,  0,111,  0,109,  0,111,  0,116,  0,101,  0, 32,  0,
116,  0,104,  0,101,  0, 32,  0,115,  0, 97,  0,108,  0,101,  0,
 44,  0, 32,  0,117,  0,115,  0,101,  0, 32,  0,111,  0,114,  0,
 32,  0,111,  0,116,  0,104,  0,101,  0,114,  0, 32,  0,100,  0,
101,  0, 97,  0,108,  0,105,  0,110,  0,103,  0,115,  0, 32,  0,
105,  0,110,  0, 32,  0,116,  0,104,  0,105,  0,115,  0, 32,  0,
 70,  0,111,  0,110,  0,116,  0, 32,  0, 83,  0,111,  0,102,  0,
116,  0,119,  0, 97,  0,114,  0,101,  0, 32,  0,119,  0,105,  0,
116,  0,104,  0,111,  0,117,  0,116,  0, 32,  0,112,  0,114,  0,
105,  0,111,  0,114,  0, 32,  0,119,  0,114,  0,105,  0,116,  0,
116,  0,101,  0,110,  0, 32,  0, 97,  0,117,  0,116,  0,104,  0,
111,  0,114,  0,105,  0,122,  0, 97,  0,116,  0,105,  0,111,  0,
110,  0, 32,  0,102,  0,114,  0,111,  0,109,  0, 32,  0,116,  0,
104,  0,101,  0, 32,  0, 71,  0,110,  0,111,  0,109,  0,101,  0,
 32,  0, 70,  0,111,  0,117,  0,110,  0,100,  0, 97,  0,116,  0,
105,  0,111,  0,110,  0, 32,  0,111,  0,114,  0, 32,  0, 66,  0,
105,  0,116,  0,115,  0,116,  0,114,  0,101,  0, 97,  0,109,  0,
 32,  0, 73,  0,110,  0, 99,  0, 46,  0, 44,  0, 32,  0,114,  0,
101,  0,115,  0,112,  0,101,  0, 99,  0,116,  0,105,  0,118,  0,
101,  0,108,  0,121,  0, 46,  0, 32,  0, 70,  0,111,  0,114,  0,
 32,  0,102,  0,117,  0,114,  0,116,  0,104,  0,101,  0,114,  0,
 32,  0,105,  0,110,  0,102,  0,111,  0,114,  0,109,  0, 97,  0,
116,  0,105,  0,111,  0,110,  0, 44,  0, 32,  0, 99,  0,111,  0,
110,  0,116,  0, 97,  0, 99,  0,116,  0, 58,  0, 32,  0,102,  0,
111,  0,110,  0,116,  0,115,  0, 32,  0, 97,  0,116,  0, 32,  0,
103,  0,110,  0,111,  0,109,  0,101,  0, 32,  0,100,  0,111,  0,
116,  0, 32,  0,111,  0,114,  0,103,  0, 46,  0,104,  0,116,  0,
116,  0,112,  0, 58,  0, 47,  0, 47,  0,119,  0,119,  0,119,  0,
 46,  0, 98,  0,105,  0,116,  0,115,  0,116,  0,114,  0,101,  0,
 97,  0,109,  0, 46,  0, 99,  0,111,  0,109,  0,  1, 53,  0,184,
  0,203,  0,203,  0,193,  0,170,  0,156,  1,166,  0,184,  0,102,
  0,  0,  0,113,  0,203,  0,160,  2,178,  0,133,  0,117,  0,184,
  0,195,  1,203,  1,137,  2, 45,  0,203,  0,166,  0,240,  0,211,
  0,170,  0,135,  0,203,  3,170,  4,  0,  1, 74,  0, 51,  0,203,
  0,  0,  0,217,  5,  2,  0,244,  1, 84,  0,180,  0,156,  1, 57,
  1, 20,  1, 57,  7,  6,  4,  0,  4, 78,  4,180,  4, 82,  4,184,
  4,231,  4,205,  0, 55,  4,115,  4,205,  4, 96,  4,115,  1, 51,
  3,162,  5, 86,  5,166,  5, 86,  5, 57,  3,197,  2, 18,  0,201,
  0, 31,  0,184,  1,223,  0,115,  0,186,  3,233,  3, 51,  3,188,
  4, 68,  4, 14,  0,223,  3,205,  3,170,  0,229,  3,170,  4,  4,
  0,  0,  0,203,  0,143,  0,164,  0,123,  0,184,  0, 20,  1,111,
  0,127,  2,123,  2, 82,  0,143,  0,199,  5,205,  0,154,  0,154,
  0,111,  0,203,  0,205,  1,158,  1,211,  0,240,  0,186,  1,131,
  0,213,  0,152,  3,  4,  2, 72,  0,158,  1,213,  0,193,  0,203,
  0,246,  0,131,  3, 84,  2,127,  0,  0,  3, 51,  2,102,  0,211,
  0,199,  0,164,  0,205,  0,143,  0,154,  0,115,  4,  0,  5,213,
  1, 10,  0,254,  2, 43,  0,164,  0,180,  0,156,  0,  0,  0, 98,
  0,156,  0,  0,  0, 29,  3, 45,  5,213,  5,213,  5,213,  5,240,
  0,127,  0,123,  0, 84,  0,164,  6,184,  6, 20,  7, 35,  1,211,
  0,184,  0,203,  0,166,  1,195,  1,236,  6,147,  0,160,  0,211,
  3, 92,  3,113,  3,219,  1,133,  4, 35,  4,168,  4, 72,  0,143,
  1, 57,  1, 20,  1, 57,  3, 96,  0,143,  5,213,  1,154,  6, 20,
  7, 35,  6,102,  1,121,  4, 96,  4, 96,  4, 96,  4,123,  0,156,
  0,  0,  2,119,  4, 96,  1,170,  0,233,  4, 96,  7, 98,  0,123,
  0,197,  0,127,  2,123,  0,  0,  0,180,  2, 82,  5,205,  0,102,
  0,188,  0,102,  0,119,  6, 16,  0,205,  1, 59,  1,133,  3,137,
  0,143,  0,123,  0,  0,  0, 29,  0,205,  7, 74,  4, 47,  0,156,
  0,156,  0,  0,  7,125,  0,111,  0,  0,  0,111,  3, 53,  0,106,
  0,111,  0,123,  0,174,  0,178,  0, 45,  3,150,  0,143,  2,123,
  0,246,  0,131,  3, 84,  6, 55,  5,246,  0,143,  0,156,  4,225,
  2,102,  0,143,  1,141,  2,246,  0,205,  3, 68,  0, 41,  0,102,
  4,238,  0,115,  0,  0, 20,  0,184,  2,128, 64,255,251,254,  3,
250, 20,  3,249, 37,  3,248, 50,  3,247,150,  3,246, 14,  3,245,
254,  3,244,254,  3,243, 37,  3,242, 14,  3,241,150,  3,240, 37,
  3,239,138, 65,  5,239,254,  3,238,150,  3,237,150,  3,236,250,
  3,235,250,  3,234,254,  3,233, 58,  3,232, 66,  3,231,254,  3,
230, 50,  3,229,228, 83,  5,229,150,  3,228,138, 65,  5,228, 83,
  3,227,226, 47,  5,227,250,  3,226, 47,  3,225,254,  3,224,254,
  3,223, 50,  3,222, 20,  3,221,150,  3,220,254,  3,219, 18,  3,
218,125,  3,217,187,  3,216,254,  3,214,138, 65,  5,214,125,  3,
213,212, 71,  5,213,125,  3,212, 71,  3,211,210, 27,  5,211,254,
  3,210, 27,  3,209,254,  3,208,254,  3,207,254,  3,206,254,  3,
205,150,  3,204,203, 30,  5,204,254,  3,203, 30,  3,202, 50,  3,
201,254,  3,198,133, 17,  5,198, 28,  3,197, 22,  3,196,254,  3,
195,254,  3,194,254,  3,193,254,  3,192,254,  3,191,254,  3,190,
254,  3,189,254,  3,188,254,  3,187,254,  3,186, 17,  3,185,134,
 37,  5,185,254,  3,184,183,187,  5,184,254,  3,183,182, 93,  5,
183,187,  3,183,128,  4,182,181, 37,  5,182, 93, 64,255,  3,182,
 64,  4,181, 37,  3,180,254,  3,179,150,  3,178,254,  3,177,254,
  3,176,254,  3,175,254,  3,174,100,  3,173, 14,  3,172,171, 37,
  5,172,100,  3,171,170, 18,  5,171, 37,  3,170, 18,  3,169,138,
 65,  5,169,250,  3,168,254,  3,167,254,  3,166,254,  3,165, 18,
  3,164,254,  3,163,162, 14,  5,163, 50,  3,162, 14,  3,161,100,
  3,160,138, 65,  5,160,150,  3,159,254,  3,158,157, 12,  5,158,
254,  3,157, 12,  3,156,155, 25,  5,156,100,  3,155,154, 16,  5,
155, 25,  3,154, 16,  3,153, 10,  3,152,254,  3,151,150, 13,  5,
151,254,  3,150, 13,  3,149,138, 65,  5,149,150,  3,148,147, 14,
  5,148, 40,  3,147, 14,  3,146,250,  3,145,144,187,  5,145,254,
  3,144,143, 93,  5,144,187,  3,144,128,  4,143,142, 37,  5,143,
 93,  3,143, 64,  4,142, 37,  3,141,254,  3,140,139, 46,  5,140,
254,  3,139, 46,  3,138,134, 37,  5,138, 65,  3,137,136, 11,  5,
137, 20,  3,136, 11,  3,135,134, 37,  5,135,100,  3,134,133, 17,
  5,134, 37,  3,133, 17,  3,132,254,  3,131,130, 17,  5,131,254,
  3,130, 17,  3,129,254,  3,128,254,  3,127,254,  3, 64,255,126,
125,125,  5,126,254,  3,125,125,  3,124,100,  3,123, 84, 21,  5,
123, 37,  3,122,254,  3,121,254,  3,120, 14,  3,119, 12,  3,118,
 10,  3,117,254,  3,116,250,  3,115,250,  3,114,250,  3,113,250,
  3,112,254,  3,111,254,  3,110,254,  3,108, 33,  3,107,254,  3,
106, 17, 66,  5,106, 83,  3,105,254,  3,104,125,  3,103, 17, 66,
  5,102,254,  3,101,254,  3,100,254,  3, 99,254,  3, 98,254,  3,
 97, 58,  3, 96,250,  3, 94, 12,  3, 93,254,  3, 91,254,  3, 90,
254,  3, 89, 88, 10,  5, 89,250,  3, 88, 10,  3, 87, 22, 25,  5,
 87, 50,  3, 86,254,  3, 85, 84, 21,  5, 85, 66,  3, 84, 21,  3,
 83,  1, 16,  5, 83, 24,  3, 82, 20,  3, 81, 74, 19,  5, 81,254,
  3, 80, 11,  3, 79,254,  3, 78, 77, 16,  5, 78,254,  3, 77, 16,
  3, 76,254,  3, 75, 74, 19,  5, 75,254,  3, 74, 73, 16,  5, 74,
 19,  3, 73, 29, 13,  5, 73, 16,  3, 72, 13,  3, 71,254,  3, 70,
150,  3, 69,150,  3, 68,254,  3, 67,  2, 45,  5, 67,250,  3, 66,
187,  3, 65, 75,  3, 64,254,  3, 63,254,  3, 62, 61, 18,  5, 62,
 20,  3, 61, 60, 15,  5, 61, 18,  3, 60, 59, 13,  5, 60, 64,255,
 15,  3, 59, 13,  3, 58,254,  3, 57,254,  3, 56, 55, 20,  5, 56,
250,  3, 55, 54, 16,  5, 55, 20,  3, 54, 53, 11,  5, 54, 16,  3,
 53, 11,  3, 52, 30,  3, 51, 13,  3, 50, 49, 11,  5, 50,254,  3,
 49, 11,  3, 48, 47, 11,  5, 48, 13,  3, 47, 11,  3, 46, 45,  9,
  5, 46, 16,  3, 45,  9,  3, 44, 50,  3, 43, 42, 37,  5, 43,100,
  3, 42, 41, 18,  5, 42, 37,  3, 41, 18,  3, 40, 39, 37,  5, 40,
 65,  3, 39, 37,  3, 38, 37, 11,  5, 38, 15,  3, 37, 11,  3, 36,
254,  3, 35,254,  3, 34, 15,  3, 33,  1, 16,  5, 33, 18,  3, 32,
100,  3, 31,250,  3, 30, 29, 13,  5, 30,100,  3, 29, 13,  3, 28,
 17, 66,  5, 28,254,  3, 27,250,  3, 26, 66,  3, 25, 17, 66,  5,
 25,254,  3, 24,100,  3, 23, 22, 25,  5, 23,254,  3, 22,  1, 16,
  5, 22, 25,  3, 21,254,  3, 20,254,  3, 19,254,  3, 18, 17, 66,
  5, 18,254,  3, 17,  2, 45,  5, 17, 66,  3, 16,125,  3, 15,100,
  3, 14,254,  3, 13, 12, 22,  5, 13,254,  3, 12,  1, 16,  5, 12,
 22,  3, 11,254,  3, 10, 16,  3,  9,254,  3,  8,  2, 45,  5,  8,
254,  3,  7, 20,  3,  6,100,  3,  4,  1, 16,  5,  4,254,  3, 64,
 21,  3,  2, 45,  5,  3,254,  3,  2,  1, 16,  5,  2, 45,  3,  1,
 16,  3,  0,254,  3,  1,184,  1,100,133,141,  1, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43,  0, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 29,
182,  6,  5,  4,  3,  2,  1,  0, 44, 32, 16,176,  2, 37, 73,100,
176, 64, 81, 88, 32,200, 89, 33, 45, 44,176,  2, 37, 73,100,176,
 64, 81, 88, 32,200, 89, 33, 45, 44, 32, 16,  7, 32,176,  0, 80,
176, 13,121, 32,184,255,255, 80, 88,  4, 27,  5, 89,176,  5, 28,
176,  3, 37,  8,176,  4, 37, 35,225, 32,176,  0, 80,176, 13,121,
 32,184,255,255, 80, 88,  4, 27,  5, 89,176,  5, 28,176,  3, 37,
  8,225, 45, 44, 75, 80, 88, 32,176,253, 69, 68, 89, 33, 45, 44,
176,  2, 37, 69, 96, 68, 45, 44, 75, 83, 88,176,  2, 37,176,  2,
 37, 69, 68, 89, 33, 33, 45, 44, 69, 68, 45,  0,  0,  2,  0,102,
254,150,  4,102,  5,164,  0,  3,  0,  7,  0, 26, 64, 12,  4,251,
  0,  6,251,  1,  8,  5,127,  2,  4,  0, 47,196,212,236, 49,  0,
 16,212,236,212,236, 48, 19, 17, 33, 17, 37, 33, 17, 33,102,  4,
  0,252,115,  3, 27,252,229,254,150,  7, 14,248,242,114,  6, 41,
  0,  2,  1, 53,  0,  0,  2,  0,  5,213,  0,  3,  0,  9,  0, 64,
 64, 15,  7,  0,131,  4,129,  2,  8,  7,  5,  1,  3,  4,  0,  0,
 10, 16,252, 60,236, 50, 57, 57, 49,  0, 47,228,252,204, 48,  1,
 75,176, 11, 84, 88,189,  0, 10,  0, 64,  0,  1,  0, 10,  0, 10,
255,192, 56, 17, 55, 56, 89,182,  0, 11, 32, 11, 80, 11,  3, 93,
 37, 51, 21, 35, 17, 51, 17,  3, 35,  3,  1, 53,203,203,203, 20,
162, 21,254,254,  5,213,253,113,254,155,  1,101,  0,  2,  0,197,
  3,170,  2,233,  5,213,  0,  3,  0,  7,  0, 77, 64, 15,  5,  1,
132,  4,  0,129,  8,  4,  5,  6,  0,  5,  2,  4,  8, 16,252,252,
220,236, 49,  0, 16,244, 60,236, 50, 48,  1, 75,176, 18, 84, 75,
176, 19, 84, 91, 88,189,  0,  8,  0, 64,  0,  1,  0,  8,  0,  8,
255,192, 56, 17, 55, 56, 89, 64, 15, 48,  9, 64,  9, 80,  9, 96,
  9,112,  9,160,  9,191,  9,  7, 93,  1, 17, 35, 17, 33, 17, 35,
 17,  1,111,170,  2, 36,170,  5,213,253,213,  2, 43,253,213,  2,
 43,  0,  0,  2,  0,158,  0,  0,  6, 23,  5,190,  0,  3,  0, 31,
  0, 96, 64, 49, 27, 11,  0,135,  7,  4, 29,  9,  5, 25, 13,  2,
135, 23, 19, 15, 21, 17, 31, 30, 28, 27, 26, 23, 22, 21, 20, 19,
 18, 17, 16, 14, 13, 12,  9,  8,  7,  6,  5,  4,  3,  2,  1,  0,
 26, 10, 24,  6, 32, 16,252,204, 23, 57, 49,  0, 47, 60,212, 60,
 60,252, 60, 60,212, 60, 60,196, 50,236, 50, 50, 48, 64, 17, 11,
  1, 11,  2, 11, 12, 11, 13, 20,  4, 26, 17, 26, 18, 20, 31,  8,
  1, 93,  1, 33,  3, 33, 11,  1, 33, 19, 51,  3, 33, 21, 33,  3,
 33, 21, 33,  3, 35, 19, 33,  3, 35, 19, 33, 53, 33, 19, 33, 53,
 33, 19,  4, 23,254,221, 84,  1, 37, 68,104,  1, 36,105,160,103,
  1, 56,254,161, 82,  1, 62,254,155,104,160,103,254,219,103,161,
104,254,197,  1, 96, 84,254,190,  1,105,102,  3,133,254,178,  3,
135,254, 97,  1,159,254, 97,154,254,178,153,254, 98,  1,158,254,
 98,  1,158,153,  1, 78,154,  1,159,  0,  0,  3,  0,170,254,211,
  4,109,  6, 20,  0, 33,  0, 40,  0, 47,  0,213, 64, 85, 34,  2,
 10, 11, 10, 39,  1, 38, 40,  2, 11, 11, 10, 29,  1, 30, 28,  2,
 47, 41, 47, 27,  2, 41, 41, 47, 66, 19, 17, 16, 34, 10, 27, 41,
  4, 23,  6,  9, 42, 33,  5,  2, 23,134, 22,  6,134,  5, 17, 35,
 26,138, 22,137, 16,  0, 42,138,  5,137,  2, 45,  8, 22, 10, 30,
  7, 41, 26, 18,  3,  0,  9, 34, 16,  9,  3,  1,  7, 38,  8, 13,
  5,  6, 48, 16,252, 60,236,244, 23, 60,252, 23, 60,244,228,236,
 49,  0, 47,228,236,196,212,228,236, 50,196, 16,238, 16,238, 17,
 18, 57, 17, 57, 17, 18, 23, 57, 17, 18, 57, 48, 75, 83, 88,  7,
 16,  4,237,  7, 16, 14,237, 17, 23, 57,  7, 16, 14,237, 17, 23,
 57,  7, 16,  4,237, 89, 34,  1, 75,176,  9, 84, 88,189,  0, 48,
  0, 64,  0,  1,  0, 48,  0, 48,255,192, 56, 17, 55, 56, 89,  1,
 75,176, 12, 84, 75,176, 16, 84, 91, 75,176, 15, 84, 91, 88,189,
  0, 48,255,192,  0,  1,  0, 48,  0, 48,  0, 64, 56, 17, 55, 56,
 89,  1, 35,  3, 46,  1, 39, 53, 30,  1, 23, 17, 46,  1, 53, 52,
 54, 55, 53, 51, 21, 30,  1, 23, 21, 46,  1, 39, 17, 30,  1, 21,
 20,  6,  7,  3, 17, 14,  1, 21, 20, 22, 23, 17, 62,  1, 53, 52,
 38,  2,180,100,  1,105,210,106,102,209,111,221,201,218,204,100,
 93,174, 83, 83,175, 92,227,214,227,214,100,116,122,113,225,127,
129,123,254,211,  1, 45,  2, 45, 45,180, 64, 65,  1,  1,200, 36,
172,150,163,188, 14,235,232,  4, 31, 27,175, 42, 46,  4,254, 85,
 35,180,156,169,195, 15,  3,  0,  1,154, 13,106, 88, 86, 96,213,
254, 79, 17,110, 90, 88,104,  0,  0,  5,  0,113,255,227,  7, 41,
  5,240,  0, 11,  0, 23,  0, 35,  0, 39,  0, 51,  0,149, 64, 54,
 36, 15, 37, 38, 37, 38, 15, 39, 36, 39, 66,  0,146, 12, 30,146,
 46,141, 24,146, 36,  6,146, 12,141, 38, 18,140, 40, 36,145, 52,
 39, 33, 27, 37,  9,  3, 13, 21, 14,  9, 13, 15, 33, 13, 43, 14,
 27, 13, 15, 49, 11, 52, 16,252,196,236,244,236, 16,238,246,238,
 17, 57, 17, 18, 57, 49,  0, 16,228, 50,244, 60,228,236, 16,238,
246,238, 16,238, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237,
 89, 34,  1, 75,176,  9, 84, 75,176, 11, 84, 91, 75,176, 12, 84,
 91, 75,176, 20, 84, 91, 75,176, 14, 84, 91, 75,176, 13, 84, 91,
 88,189,  0, 52,  0, 64,  0,  1,  0, 52,  0, 52,255,192, 56, 17,
 55, 56, 89,  1, 34,  6, 21, 20, 22, 51, 50, 54, 53, 52, 38, 39,
 50, 22, 21, 20,  6, 35, 34, 38, 53, 52, 54,  1, 34,  6, 21, 20,
 22, 51, 50, 54, 53, 52, 38, 37, 51,  1, 35, 19, 50, 22, 21, 20,
  6, 35, 34, 38, 53, 52, 54,  5,209, 87, 99, 99, 87, 85, 99, 99,
 85,158,186,187,157,160,186,187,252,151, 86, 99, 98, 87, 87, 99,
100,  3, 49,160,252, 90,160, 31,158,188,187,159,159,185,186,  2,
145,148,132,130,149,149,130,131,149,127,220,187,187,219,219,187,
188,219,  2, 97,149,130,132,148,148,132,129,150,127,249,243,  6,
 13,219,187,189,218,219,188,186,220,  0,  0,  2,  0,129,255,227,
  5,254,  5,240,  0,  9,  0, 48,  1,205, 64,150, 13,  1, 14, 12,
134, 17, 18, 17, 11,134, 10, 11, 18, 18, 17,  9,134,  0,  9, 21,
 22, 21,  7,  1,  6,  8,134, 22, 22, 21,  2,  1,  3,  1,134, 29,
 30, 29,  0,134,  9,  0, 30, 30, 29, 32, 31,  2, 33, 30, 17, 10,
 19, 10, 23, 22, 21,  3, 24, 20, 17, 19, 10,  7,  8,  2,  6,  9,
 17, 19, 19, 10,  2,  1,  2,  3,  0, 17, 10, 19, 10, 23, 22,  2,
 24, 21, 17, 19, 10, 20, 17, 19, 19, 10, 66, 18, 11,  9,  3,  6,
  0, 10, 30,  3, 40, 21, 14,  6, 40, 39,  6,149, 24, 43,149, 39,
148, 36,145, 24,140, 14, 19, 10, 46, 11, 14,  9,  0, 46, 18, 21,
 39, 14, 30,  3, 46, 18, 39, 33, 14, 17, 15, 19, 33,  3, 18, 27,
 16, 49, 16,252,236,196,212,212,236, 16,198,238, 17, 57, 17, 18,
 57, 57, 17, 57, 57, 17, 57, 17, 57, 49,  0, 47,198,228,246,230,
238, 16,238, 16,198, 17, 18, 57, 17, 23, 57, 17, 23, 57, 48, 75,
 83, 88,  7, 16,  5,237,  7,  5,237, 17, 23, 57,  7, 16,  5,237,
 17, 23, 57,  7, 16,  5,237, 17, 23, 57,  7,  5,237, 17, 23, 57,
  7, 16,  5,237, 17, 23, 57,  7, 16,  8,237,  7, 16, 14,237, 17,
 23, 57,  7, 16, 14,237, 17, 23, 57,  7, 16,  8,237,  7, 16,  8,
237,  7, 16, 14,237, 17, 23, 57, 89, 34,178, 15, 50,  1,  1, 93,
 64,178,  7, 11,  5, 34,  9, 41, 28,  0, 28,  1, 31,  2, 23, 11,
 42,  0, 42,  1, 38, 18, 58,  0, 52, 18, 68, 11, 94,  0, 89,  1,
 90, 10, 85, 18, 90, 26, 90, 31, 89, 48,103, 30,123,  0,155,  0,
154,  1,153,  2,151,  8,149, 11,147, 21,149, 22,149, 34,153, 45,
 31,  9, 11,  9, 12,  8, 17, 12, 39, 12, 40, 24,  2, 27,  9, 25,
 11, 25, 12, 25, 17, 28, 20, 28, 21, 22, 29, 31, 50, 39,  0, 39,
  1, 41,  9, 35, 18, 42, 19, 42, 20, 40, 21, 47, 50, 59,  9, 52,
 18, 57, 19, 63, 50, 74,  9, 76, 20, 75, 21, 70, 25, 79, 50, 86,
  1, 90,  9, 89, 12, 85, 18, 89, 19, 92, 31, 95, 50,106, 12,105,
 17, 96, 50,117,  1,121, 12,122, 17,147,  0,147,  1,151,  2,149,
  5,156,  7,156,  8,159,  8,154,  9,155, 11,154, 12,144, 50,160,
 50,176, 50, 57, 93,  0, 93,  1, 14,  1, 21, 20, 22, 51, 50, 54,
 55,  9,  1, 62,  1, 55, 51,  6,  2,  7,  1, 35, 39, 14,  1, 35,
 34,  0, 53, 52, 54, 55, 46,  1, 53, 52, 54, 51, 50, 22, 23, 21,
 46,  1, 35, 34,  6, 21, 20, 22,  1,242, 91, 85,212,160, 95,166,
 73,254,123,  1,252, 59, 66,  6,186, 12,104, 93,  1, 23,252,143,
104,228,131,241,254,206,134,134, 48, 50,222,184, 83,165, 85, 87,
158, 68,105,131, 59,  3, 35, 81,161, 88,146,194, 63, 64,  2,143,
253,248, 89,203,114,132,254,254,126,254,227,147, 89, 87,  1, 19,
215,128,225, 99, 63,125, 60,162,197, 36, 36,182, 47, 49,111, 88,
 51,103,  0,  1,  0,197,  3,170,  1,111,  5,213,  0,  3,  0, 66,
 64, 10,  1,132,  0,129,  4,  0,  5,  2,  4,  4, 16,252,236, 49,
  0, 16,244,236, 48,  1, 75,176, 18, 84, 75,176, 19, 84, 91, 88,
189,  0,  4,  0, 64,  0,  1,  0,  4,  0,  4,255,192, 56, 17, 55,
 56, 89, 64, 13, 64,  5, 80,  5, 96,  5,112,  5,144,  5,160,  5,
  6, 93,  1, 17, 35, 17,  1,111,170,  5,213,253,213,  2, 43,  0,
  0,  1,  0,176,254,242,  2,123,  6, 18,  0, 13,  0, 79, 64, 15,
  6,152,  0,151, 14, 13,  7,  0,  3, 18,  6,  0, 19, 10, 14, 16,
220,228, 50,236, 17, 57, 57, 49,  0, 16,252,236, 48,  1, 75,176,
 19, 84, 88,189,  0, 14,  0, 64,  0,  1,  0, 14,  0, 14,255,192,
 56, 17, 55, 56, 89,  1, 75,176, 15, 84, 88,189,  0, 14,255,192,
  0,  1,  0, 14,  0, 14,  0, 64, 56, 17, 55, 56, 89,  1,  6,  2,
 21, 20, 18, 23, 35, 38,  2, 53, 52, 18, 55,  2,123,134,130,131,
133,160,150,149,148,151,  6, 18,230,254, 62,231,231,254, 59,229,
235,  1,198,224,223,  1,196,236,  0,  1,  0,164,254,242,  2,111,
  6, 18,  0, 13,  0, 31, 64, 15,  7,152,  0,151, 14,  7,  1,  0,
 11, 18,  4, 19,  8,  0, 14, 16,220, 60,244,236, 17, 57, 57, 49,
  0, 16,252,236, 48, 19, 51, 22, 18, 21, 20,  2,  7, 35, 54, 18,
 53, 52,  2,164,160,150,149,149,150,160,133,131,131,  6, 18,236,
254, 60,223,224,254, 58,235,229,  1,197,231,231,  1,194,  0,  1,
  0, 61,  2, 74,  3,195,  5,240,  0, 17,  0, 78, 64, 44, 16, 13,
 11,  0,  4, 12,  9,  7,  4,  2,  4,  8,  3,153,  5, 17, 12,153,
 10,  1, 14,145, 18,  8, 12, 10,  3,  9,  6, 17,  3,  1,  3,  2,
  0, 20, 15,  4, 11,  9, 20, 13,  6, 18, 16,212, 60,228, 50,220,
 60,228, 50, 23, 57, 17, 18, 23, 57, 49,  0, 16,244,212, 60,236,
 50,196,236, 50, 23, 57, 18, 23, 57, 48,  1,  5,  5,  7, 37, 17,
 35, 17,  5, 39, 37, 37, 55,  5, 17, 51, 17, 37,  3,195,254,153,
  1,103, 58,254,176,114,254,176, 58,  1,103,254,153, 58,  1, 80,
114,  1, 80,  4,223,194,195, 98,203,254,135,  1,121,203, 98,195,
194, 99,203,  1,121,254,135,203,  0,  1,  0,217,  0,  0,  5,219,
  5,  4,  0, 11,  0, 35, 64, 17,  0,  9,  1,156,  7,  3,  5,  2,
 21,  4,  0, 23, 10,  6, 21,  8, 12, 16,220,252, 60,252, 60,236,
 49,  0, 47,212, 60,252, 60,196, 48,  1, 17, 33, 21, 33, 17, 35,
 17, 33, 53, 33, 17,  3,174,  2, 45,253,211,168,253,211,  2, 45,
  5,  4,253,211,170,253,211,  2, 45,170,  2, 45,  0,  1,  0,158,
255, 18,  1,195,  0,254,  0,  5,  0, 25, 64, 12,  3,158,  0,131,
  6,  3,  4,  1, 25,  0, 24,  6, 16,252,236,212,204, 49,  0, 16,
252,236, 48, 55, 51, 21,  3, 35, 19,240,211,164,129, 82,254,172,
254,192,  1, 64,  0,  1,  0,100,  1,223,  2,127,  2,131,  0,  3,
  0, 17,182,  0,156,  2,  4,  1,  0,  4, 16,220,204, 49,  0, 16,
212,236, 48, 19, 33, 21, 33,100,  2, 27,253,229,  2,131,164,  0,
  0,  1,  0,219,  0,  0,  1,174,  0,254,  0,  3,  0, 17,183,  0,
131,  2,  1, 25,  0, 24,  4, 16,252,236, 49,  0, 47,236, 48, 55,
 51, 21, 35,219,211,211,254,254,  0,  1,  0,  0,255, 66,  2,178,
  5,213,  0,  3,  0, 45, 64, 20,  0, 26,  1,  2,  1,  2, 26,  3,
  0,  3, 66,  2,159,  0,129,  4,  2,  0,  1,  3, 47,196, 57, 57,
 49,  0, 16,244,236, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,
237, 89, 34,  1, 51,  1, 35,  2,  8,170,253,248,170,  5,213,249,
109,  0,  0,  2,  0,135,255,227,  4,143,  5,240,  0, 11,  0, 23,
  0, 35, 64, 19,  6,160, 18,  0,160, 12,145, 18,140, 24,  9, 28,
 15, 30,  3, 28, 21, 27, 24, 16,252,236,244,236, 49,  0, 16,228,
244,236, 16,238, 48,  1, 34,  2, 17, 16, 18, 51, 50, 18, 17, 16,
  2, 39, 50,  0, 17, 16,  0, 35, 34,  0, 17, 16,  0,  2,139,156,
157,157,156,157,157,157,157,251,  1,  9,254,247,251,251,254,247,
  1,  9,  5, 80,254,205,254,204,254,205,254,205,  1, 51,  1, 51,
  1, 52,  1, 51,160,254,115,254,134,254,135,254,115,  1,141,  1,
121,  1,122,  1,141,  0,  0,  1,  0,225,  0,  0,  4, 90,  5,213,
  0, 10,  0, 75, 64, 21, 66,  3,160,  4,  2,160,  5,129,  7,  0,
160,  9,  8, 31,  6, 28,  3,  0, 31,  1, 11, 16,212,236,196,252,
236, 49,  0, 47,236, 50,244,236,212,236, 48, 75, 83, 88, 89, 34,
  1, 75,176, 15, 84, 88,189,  0, 11,255,192,  0,  1,  0, 11,  0,
 11,  0, 64, 56, 17, 55, 56, 89,180, 15,  3, 15,  4,  2, 93, 55,
 33, 17,  5, 53, 37, 51, 17, 33, 21, 33,254,  1, 74,254,153,  1,
101,202,  1, 74,252,164,170,  4,115, 72,184, 72,250,213,170,  0,
  0,  1,  0,150,  0,  0,  4, 74,  5,240,  0, 28,  0,165, 64, 39,
 25, 26, 27,  3, 24, 28, 17,  5,  4,  0, 17,  5,  5,  4, 66, 16,
161, 17,148, 13,160, 20,145,  4,  0,160,  2,  0, 16, 10,  2,  1,
 10, 28, 23, 16,  3,  6, 29, 16,252,196,212,236,192,192, 17, 18,
 57, 49,  0, 47,236, 50,244,236,244,236, 48, 75, 83, 88,  7, 16,
  5,237,  7,  5,237, 17, 23, 57, 89, 34,  1, 75,176, 21, 84, 75,
176, 22, 84, 91, 75,176, 20, 84, 91, 88,189,  0, 29,  0, 64,  0,
  1,  0, 29,  0, 29,255,192, 56, 17, 55, 56, 89, 64, 50, 85,  4,
 86,  5, 86,  7,122,  4,122,  5,118, 27,135, 25,  7,  4,  0,  4,
 25,  4, 26,  4, 27,  5, 28,116,  0,118,  6,117, 26,115, 27,116,
 28,130,  0,134, 25,130, 26,130, 27,130, 28,168,  0,168, 27, 17,
 93,  0, 93, 37, 33, 21, 33, 53, 54,  0, 55, 62,  1, 53, 52, 38,
 35, 34,  6,  7, 53, 62,  1, 51, 50,  4, 21, 20,  6,  7,  6,  0,
  1,137,  2,193,252, 76,115,  1,141, 51, 97, 77,167,134, 95,211,
120,122,212, 88,232,  1, 20, 69, 91, 25,254,244,170,170,170,119,
  1,145, 58,109,151, 73,119,150, 66, 67,204, 49, 50,232,194, 92,
165,112, 29,254,235,  0,  0,  1,  0,156,255,227,  4,115,  5,240,
  0, 40,  0,123, 64, 46,  0, 21, 19, 10,134,  9, 31,134, 32, 19,
160, 21, 13,160,  9,147,  6, 28,160, 32,147, 35,145,  6,140, 21,
163, 41, 22, 28, 19,  0,  3, 20, 25, 28, 38, 32, 16, 28,  3, 20,
 31,  9,  6, 41, 16,252,196,196,212,236,244,236, 17, 23, 57, 57,
 49,  0, 16,236,228,244,228,236, 16,230,238, 16,238, 16,238, 16,
238, 17, 18, 57, 48,  1, 75,176, 22, 84, 75,176, 20, 84, 91, 88,
189,  0, 41,  0, 64,  0,  1,  0, 41,  0, 41,255,192, 56, 17, 55,
 56, 89, 64,  9,100, 30, 97, 31, 97, 32,100, 33,  4,  0, 93,  1,
 30,  1, 21, 20,  4, 33, 34, 38, 39, 53, 30,  1, 51, 50, 54, 53,
 52, 38, 43,  1, 53, 51, 50, 54, 53, 52, 38, 35, 34,  6,  7, 53,
 62,  1, 51, 50,  4, 21, 20,  6,  3, 63,145,163,254,208,254,232,
 94,199,106, 84,200,109,190,199,185,165,174,182,149,158,163,152,
 83,190,114,115,201, 89,230,  1, 12,142,  3, 37, 31,196,144,221,
242, 37, 37,195, 49, 50,150,143,132,149,166,119,112,115,123, 36,
 38,180, 32, 32,209,178,124,171,  0,  2,  0,100,  0,  0,  4,164,
  5,213,  0,  2,  0, 13,  0,140, 64, 29,  1, 13,  3, 13,  0,  3,
  3, 13, 66,  0,  3, 11,  7,160,  5,  1,  3,129,  9,  1, 12, 10,
  0, 28,  6,  8,  4, 12, 14, 16,220,212, 60,196,236, 50, 17, 57,
 49,  0, 47,228,212, 60,236, 50, 18, 57, 48, 75, 83, 88,  7, 16,
  4,201,  7, 16,  5,201, 89, 34,  1, 75,176, 11, 84, 75,176, 13,
 84, 91, 88,189,  0, 14,  0, 64,  0,  1,  0, 14,  0, 14,255,192,
 56, 17, 55, 56, 89, 64, 42, 11,  0, 42,  0, 72,  0, 89,  0,105,
  0,119,  0,138,  0,  7, 22,  1, 43,  0, 38,  1, 43,  3, 54,  1,
 78,  1, 79, 12, 79, 13, 86,  1,102,  1,117,  1,122,  3,133,  1,
 13, 93,  0, 93,  9,  1, 33,  3, 51, 17, 51, 21, 35, 17, 35, 17,
 33, 53,  3,  6,254,  2,  1,254, 53,254,213,213,201,253, 94,  5,
 37,252,227,  3,205,252, 51,168,254,160,  1, 96,195,  0,  0,  1,
  0,158,255,227,  4,100,  5,213,  0, 29,  0,117, 64, 35,  4, 26,
  7, 17,134, 16, 29, 26,160,  7, 20,160, 16,137, 13,  2,160,  0,
129, 13,140,  7,164, 30, 23, 28,  1, 10,  3, 28,  0, 10, 16,  6,
 30, 16,252,196,212,236, 16,196,238, 49,  0, 16,228,228,244,236,
 16,230,238, 16,254,196, 16,238, 17, 18, 57, 48,  1, 75,176, 22,
 84, 75,176, 20, 84, 91, 88,189,  0, 30,  0, 64,  0,  1,  0, 30,
  0, 30,255,192, 56, 17, 55, 56, 89,  1, 75,176, 15, 84, 88,189,
  0, 30,255,192,  0,  1,  0, 30,  0, 30,  0, 64, 56, 17, 55, 56,
 89, 19, 33, 21, 33, 17, 62,  1, 51, 50,  0, 21, 20,  0, 33, 34,
 38, 39, 53, 30,  1, 51, 50, 54, 53, 52, 38, 35, 34,  6,  7,221,
  3, 25,253,160, 44, 88, 44,250,  1, 36,254,212,254,239, 94,195,
104, 90,192,107,173,202,202,173, 81,161, 84,  5,213,170,254,146,
 15, 15,254,238,234,241,254,245, 32, 32,203, 49, 48,182,156,156,
182, 36, 38,  0,  0,  2,  0,143,255,227,  4,150,  5,240,  0, 11,
  0, 36,  0, 88, 64, 36, 19,  6,  0, 13,134, 12,  0,160, 22,  6,
160, 28, 22,165, 16,160, 12,137, 34,145, 28,140, 37, 12, 34,  9,
 28, 25, 30, 19, 28,  3, 33, 31, 27, 37, 16,252,236,236,244,236,
228, 49,  0, 16,228,244,228,252,228, 16,238, 16,238, 16,238, 17,
 18, 57, 48, 64, 20,203,  0,203,  1,205,  2,205,  3,205,  4,203,
  5,203,  6,  7,164, 30,178, 30,  2, 93,  1, 93,  1, 34,  6, 21,
 20, 22, 51, 50, 54, 53, 52, 38,  1, 21, 46,  1, 35, 34,  2,  3,
 62,  1, 51, 50,  0, 21, 20,  0, 35, 32,  0, 17, 16,  0, 33, 50,
 22,  2,164,136,159,159,136,136,159,159,  1,  9, 76,155, 76,200,
211, 15, 59,178,107,225,  1,  5,254,240,226,254,253,254,238,  1,
 80,  1, 27, 76,155,  3, 59,186,162,161,187,187,161,162,186,  2,
121,184, 36, 38,254,242,254,239, 87, 93,254,239,235,230,254,234,
  1,141,  1,121,  1, 98,  1,165, 30,  0,  0,  1,  0,168,  0,  0,
  4,104,  5,213,  0,  6,  0, 99, 64, 24,  5, 17,  2,  3,  2,  3,
 17,  4,  5,  4, 66,  5,160,  0,129,  3,  5,  3,  1,  4,  1,  0,
  6,  7, 16,252,204,196, 17, 57, 57, 49,  0, 47,244,236, 48, 75,
 83, 88,  7, 16,  5,237,  7, 16,  5,237, 89, 34,  1, 75,176, 22,
 84, 88,189,  0,  7,  0, 64,  0,  1,  0,  7,  0,  7,255,192, 56,
 17, 55, 56, 89, 64, 18, 88,  2,  1,  6,  3, 26,  5, 57,  5, 72,
  5,103,  3,176,  0,176,  6,  7, 93,  0, 93, 19, 33, 21,  1, 35,
  1, 33,168,  3,192,253,226,211,  1,254,253, 51,  5,213, 86,250,
129,  5, 43,  0,  0,  3,  0,139,255,227,  4,139,  5,240,  0, 11,
  0, 35,  0, 47,  0, 67, 64, 37, 24, 12,  0,160, 39,  6,160, 30,
 45,160, 18,145, 30,140, 39,163, 48, 24, 12, 36, 42, 28, 21, 36,
 28, 15,  9, 28, 21, 27, 30,  3, 28, 15, 33, 27, 48, 16,252,196,
236,244,196,236, 16,238, 16,238, 17, 57, 57, 49,  0, 16,236,228,
244,236, 16,238, 16,238, 57, 57, 48,  1, 34,  6, 21, 20, 22, 51,
 50, 54, 53, 52, 38, 37, 38, 38, 53, 52, 54, 51, 50, 22, 21, 20,
  6,  7, 22, 22, 21, 20,  4, 35, 34, 36, 53, 52, 54, 19, 20, 22,
 51, 50, 54, 53, 52, 38, 35, 34,  6,  2,139,144,165,165,144,144,
166,165,254,165,130,145,255,222,223,254,145,129,146,163,254,247,
247,247,254,247,164, 72,145,131,130,147,147,130,131,145,  2,197,
154,135,135,154,155,134,135,154, 86, 32,178,128,179,208,208,179,
128,178, 32, 34,198,143,217,232,232,217,143,198,  1, 97,116,130,
130,116,116,130,130,  0,  0,  2,  0,129,255,227,  4,135,  5,240,
  0, 24,  0, 36,  0, 88, 64, 35,  7, 31, 25,  1,134,  0, 25,160,
 10,165,  4,160,  0,137, 22, 31,160, 16,145, 22,140, 37,  7, 28,
 28, 33, 19, 30,  0, 34, 34, 28, 13, 27, 37, 16,252,236,228,244,
236,236, 49,  0, 16,228,244,236, 16,230,254,245,238, 16,238, 17,
 18, 57, 48, 64, 22,196, 25,194, 26,192, 27,192, 28,192, 29,194,
 30,196, 31,  7,170, 18,188, 18,233, 18,  3, 93,  1, 93, 55, 53,
 30,  1, 51, 50, 18, 19, 14,  1, 35, 34,  0, 53, 52,  0, 51, 32,
  0, 17, 16,  0, 33, 34, 38,  1, 50, 54, 53, 52, 38, 35, 34,  6,
 21, 20, 22,225, 76,156, 75,200,211, 15, 58,178,108,224,254,251,
  1, 16,226,  1,  3,  1, 17,254,177,254,229, 76,156,  1, 62,136,
159,159,136,136,159,159, 31,184, 36, 38,  1, 13,  1, 18, 86, 92,
  1, 15,235,230,  1, 22,254,115,254,134,254,159,254, 91, 30,  2,
151,186,162,161,187,187,161,162,186,  0,  0,  2,  0,240,  0,  0,
  1,195,  4, 35,  0,  3,  0,  7,  0, 28, 64, 14,  6,131,  4,166,
  0,131,  2,  5,  1,  3,  4,  0, 24,  8, 16,252, 60,236, 50, 49,
  0, 47,236,244,236, 48, 55, 51, 21, 35, 17, 51, 21, 35,240,211,
211,211,211,254,254,  4, 35,254,  0,  2,  0,158,255, 18,  1,195,
  4, 35,  0,  3,  0,  9,  0, 37, 64, 19,  2,131,  0,  7,158,  4,
131,  0,166, 10,  7,  8,  5,  1, 25,  4,  0, 24, 10, 16,252, 60,
236, 50,212,204, 49,  0, 16,228,252,236, 16,238, 48, 19, 51, 21,
 35, 17, 51, 21,  3, 35, 19,240,211,211,211,164,129, 82,  4, 35,
254,253,217,172,254,192,  1, 64,  0,  1,  0,217,  0, 94,  5,219,
  4,166,  0,  6,  0, 77, 64, 42,  2,156,  3,  4,  3,  1,156,  0,
  1,  4,  4,  3,  1,156,  2,  1,  5,  6,  5,  0,156,  6,  5, 66,
  5,  4,  2,  1,  0,  5,  3,168,  6,167,  7,  1,  2,  0, 36,  4,
 35,  7, 16,252,236, 50, 57, 49,  0, 16,244,236, 23, 57, 48, 75,
 83, 88,  7,  4,237,  7, 16,  8,237,  7, 16,  8,237,  7, 16,  4,
237, 89, 34,  9,  2, 21,  1, 53,  1,  5,219,251,248,  4,  8,250,
254,  5,  2,  3,240,254,145,254,147,182,  1,209,166,  1,209,  0,
  0,  2,  0,217,  1, 96,  5,219,  3,162,  0,  3,  0,  7,  0, 28,
 64, 13,  0,156,  2,  6,156,  4,  8,  5,  1,  4,  0, 35,  8, 16,
252, 60,196, 50, 49,  0, 16,212,236,212,236, 48, 19, 33, 21, 33,
 21, 33, 21, 33,217,  5,  2,250,254,  5,  2,250,254,  3,162,168,
240,170,  0,  1,  0,217,  0, 94,  5,219,  4,166,  0,  6,  0, 79,
 64, 43,  6,156,  0,  6,  3,  4,  3,  5,156,  4,  4,  3,  0,156,
  1,  2,  1,  6,156,  5,  6,  2,  2,  1, 66,  6,  5,  3,  2,  0,
  5,  4,168,  1,167,  7,  6,  2, 36,  4,  0, 35,  7, 16,252, 60,
236, 57, 49,  0, 16,244,236, 23, 57, 48, 75, 83, 88,  7, 16,  8,
237,  7, 16,  4,237,  7, 16,  4,237,  7, 16,  8,237, 89, 34, 19,
 53,  1, 21,  1, 53,  1,217,  5,  2,250,254,  4,  6,  3,240,182,
254, 47,166,254, 47,182,  1,109,  0,  2,  0,147,  0,  0,  3,176,
  5,240,  0,  3,  0, 36,  0,112, 64, 43, 36, 30,  9,  6,  4, 10,
 29, 19,  4,  0, 20,134, 19,136, 16,149, 23,145,  0,131,  2, 29,
 26, 13,  9,  5,  4, 10, 30,  1, 13, 28, 26,  4, 28,  5,  1,  3,
  0, 38, 26, 19, 37, 16,220,196,252,236,212,236, 16,238, 17, 57,
 57, 17, 18, 57, 17, 18, 57, 49,  0, 47,238,246,254,244,238, 16,
205, 17, 57, 57, 23, 57, 48,  1, 75,176, 12, 84, 88,189,  0, 37,
  0, 64,  0,  1,  0, 37,  0, 37,255,192, 56, 17, 55, 56, 89,182,
121,  9,122, 10,122, 32,  3, 93, 37, 51, 21, 35, 19, 35, 53, 52,
 54, 63,  1, 62,  1, 53, 52, 38, 35, 34,  6,  7, 53, 62,  1, 51,
 50, 22, 21, 20,  6, 15,  1, 14,  1,  7, 14,  1, 21,  1,135,203,
203,197,191, 56, 90, 90, 57, 51,131,108, 79,179, 97, 94,193,103,
184,223, 72, 90, 88, 47, 39,  8,  6,  6,254,254,  1,145,154,101,
130, 86, 89, 53, 94, 49, 89,110, 70, 67,188, 57, 56,194,159, 76,
137, 86, 86, 47, 53, 25, 21, 60, 52,  0,  0,  2,  0,135,254,156,
  7,113,  5,162,  0, 11,  0, 76,  0,149, 64, 50, 24, 12,  3,  9,
169, 25, 21, 27,  3,169, 76, 15, 52, 51, 15,172, 48,169, 55, 21,
172, 36,169, 55, 67, 77, 51, 52, 30, 26,  0, 40, 18,  6, 24, 12,
 40, 26, 43, 30, 40, 73, 18, 43, 42, 40, 73, 44, 61, 77, 16,220,
236,252,236, 16,254,253,254, 60,198, 16,238, 17, 18, 57, 57, 49,
  0, 16,212,196,252,236, 16,254,237,212,198, 16,197,238, 50, 16,
196,238, 17, 57, 57, 48,  0, 75,176,  9, 84, 75,176, 12, 84, 91,
 75,176, 16, 84, 91, 75,176, 19, 84, 91, 75,176, 20, 84, 91, 88,
189,  0, 77,255,192,  0,  1,  0, 77,  0, 77,  0, 64, 56, 17, 55,
 56, 89, 64,  9, 15, 78, 31, 78, 47, 78, 63, 78,  4,  1, 93,  1,
 20, 22, 51, 50, 54, 53, 52, 38, 35, 34,  6,  1, 14,  1, 35, 34,
 38, 53, 52, 54, 51, 50, 22, 23, 53, 51, 17, 62,  1, 53, 52, 38,
 39, 38, 36, 35, 34,  6,  7,  6,  2, 21, 20, 18, 23, 22,  4, 51,
 50, 54, 55, 23,  6,  4, 35, 34, 36, 39, 38,  2, 53, 52, 18, 55,
 54, 36, 51, 50,  4, 23, 30,  1, 21, 16,  0,  5,  2,250,142,124,
123,141,144,122,121,143,  2, 33, 60,155,103,172,215,216,171,103,
156, 59,143,146,165, 63, 64,104,254,213,176,123,226, 96,157,177,
115,109,105,  1, 20,157,129,249,104, 90,125,254,217,152,185,254,
184,128,128,134,136,126,129,  1, 82,189,212,  1,107,123, 75, 79,
254,194,254,232,  2, 25,143,163,164,142,140,165,164,254, 72, 77,
 73,249,200,200,250, 75, 76,131,253, 32, 22,223,177,107,188, 80,
131,139, 65, 64,102,254,181,193,159,254,234,106,104,109, 87, 81,
111, 97,103,131,125,125,  1, 73,189,182,  1, 74,125,127,135,174,
160, 98,230,123,254,249,254,208,  6,  0,  0,  2,  0, 16,  0,  0,
  5,104,  5,213,  0,  2,  0, 10,  0,186, 64, 65,  0, 17,  1,  0,
  4,  5,  4,  2, 17,  5,  5,  4,  1, 17, 10,  3, 10,  0, 17,  2,
  0,  3,  3, 10,  7, 17,  5,  4,  6, 17,  5,  5,  4,  9, 17,  3,
 10,  8, 17, 10,  3, 10, 66,  0,  3,  7,149,  1,  3,129,  9,  5,
  9,  8,  7,  6,  4,  3,  2,  1,  0,  9,  5, 10, 11, 16,212,196,
 23, 57, 49,  0, 47, 60,228,212,236, 18, 57, 48, 75, 83, 88,  7,
 16,  5,237,  7,  5,237,  7, 16,  5,237,  7,  5,237,  7, 16,  8,
237,  7, 16,  5,237,  7, 16,  5,237,  7, 16,  8,237, 89, 34,178,
 32, 12,  1,  1, 93, 64, 58, 15,  0, 88,  0,118,  0,112,  0,140,
  0,  5,  7,  1,  8,  2,  6,  3,  9,  4, 22,  1, 25,  2, 86,  1,
 88,  2, 80, 12,103,  1,104,  2,120,  1,118,  2,124,  3,114,  4,
119,  7,120,  8,135,  1,136,  2,128, 12,152,  2,153,  3,150,  4,
 23, 93,  0, 93,  9,  1, 33,  1, 51,  1, 35,  3, 33,  3, 35,  2,
188,254,238,  2, 37,254,123,229,  2, 57,210,136,253, 95,136,213,
  5, 14,253, 25,  3,174,250, 43,  1,127,254,129,  0,  3,  0,201,
  0,  0,  4,236,  5,213,  0,  8,  0, 17,  0, 32,  0, 67, 64, 35,
 25,  0,149, 10,  9,149, 18,129,  1,149, 10,173, 31, 17, 11,  8,
  2, 19, 25, 31,  5,  0, 14, 28, 22,  5, 25, 28, 46,  9,  0, 28,
 18,  4, 33, 16,252,236, 50,252,236,212,236, 17, 23, 57, 57, 57,
 49,  0, 47,236,236,244,236, 16,238, 57, 48,178, 15, 34,  1,  1,
 93,  1, 17, 33, 50, 54, 53, 52, 38, 35,  1, 17, 33, 50, 54, 53,
 52, 38, 35, 37, 33, 50, 22, 21, 20,  6,  7, 30,  1, 21, 20,  4,
 35, 33,  1,147,  1, 68,163,157,157,163,254,188,  1, 43,148,145,
145,148,254, 11,  2,  4,231,250,128,124,149,165,254,240,251,253,
232,  2,201,253,221,135,139,140,133,  2,102,254, 62,111,114,113,
112,166,192,177,137,162, 20, 32,203,152,200,218,  0,  1,  0,115,
255,227,  5, 39,  5,240,  0, 25,  0, 54, 64, 26, 13,161, 14,174,
 10,149, 17,  1,161,  0,174,  4,149, 23,145, 17,140, 26,  7, 25,
 13,  0, 48, 20, 16, 26, 16,252,236, 50,236, 49,  0, 16,228,244,
236,244,236, 16,238,246,238, 48,180, 15, 27, 31, 27,  2,  1, 93,
  1, 21, 46,  1, 35, 32,  0, 17, 16,  0, 33, 50, 54, 55, 21, 14,
  1, 35, 32,  0, 17, 16,  0, 33, 50, 22,  5, 39,102,231,130,255,
  0,254,240,  1, 16,  1,  0,130,231,102,106,237,132,254,173,254,
122,  1,134,  1, 83,134,237,  5, 98,213, 95, 94,254,199,254,216,
254,217,254,199, 94, 95,211, 72, 72,  1,159,  1,103,  1,104,  1,
159, 71,  0,  2,  0,201,  0,  0,  5,176,  5,213,  0,  8,  0, 17,
  0, 46, 64, 21,  0,149,  9,129,  1,149, 16,  8,  2, 16, 10,  0,
  5, 25, 13, 50,  0, 28,  9,  4, 18, 16,252,236,244,236, 17, 57,
 57, 57, 57, 49,  0, 47,236,244,236, 48,178, 96, 19,  1,  1, 93,
  1, 17, 51, 32,  0, 17, 16,  0, 33, 37, 33, 32,  0, 17, 16,  0,
 41,  1,  1,147,244,  1, 53,  1, 31,254,225,254,203,254, 66,  1,
159,  1,178,  1,150,254,104,254, 80,254, 97,  5, 47,251,119,  1,
 24,  1, 46,  1, 44,  1, 23,166,254,151,254,128,254,126,254,150,
  0,  1,  0,201,  0,  0,  4,139,  5,213,  0, 11,  0, 46, 64, 21,
  6,149,  4,  2,149,  0,129,  8,149,  4,173, 10,  5,  1,  9,  7,
  3, 28,  0,  4, 12, 16,252,236, 50,212,196,196, 49,  0, 47,236,
236,244,236, 16,238, 48,178, 31, 13,  1,  1, 93, 19, 33, 21, 33,
 17, 33, 21, 33, 17, 33, 21, 33,201,  3,176,253, 26,  2,199,253,
 57,  2,248,252, 62,  5,213,170,254, 70,170,253,227,170,  0,  1,
  0,201,  0,  0,  4, 35,  5,213,  0,  9,  0, 41, 64, 18,  6,149,
  4,  2,149,  0,129,  4,173,  8,  5,  1,  7,  3, 28,  0,  4, 10,
 16,252,236, 50,212,196, 49,  0, 47,236,244,236, 16,238, 48,178,
 15, 11,  1,  1, 93, 19, 33, 21, 33, 17, 33, 21, 33, 17, 35,201,
  3, 90,253,112,  2, 80,253,176,202,  5,213,170,254, 72,170,253,
 55,  0,  0,  1,  0,115,255,227,  5,139,  5,240,  0, 29,  0, 57,
 64, 32,  0,  5, 27,  1,149,  3, 27,149,  8, 18,161, 17,174, 21,
149, 14,145,  8,140, 30,  2,  0, 28, 17, 52,  4, 51, 24, 25, 11,
 16, 30, 16,252,236,252,228,252,196, 49,  0, 16,228,244,236,244,
236, 16,254,212,238, 17, 57, 57, 48, 37, 17, 33, 53, 33, 17,  6,
  4, 35, 32,  0, 17, 16,  0, 33, 50,  4, 23, 21, 38, 38, 35, 32,
  0, 17, 16,  0, 33, 50, 54,  4,195,254,182,  2, 18,117,254,230,
160,254,162,254,117,  1,139,  1, 94,146,  1,  7,111,112,252,139,
254,238,254,237,  1, 19,  1, 18,107,168,213,  1,145,166,253,127,
 83, 85,  1,153,  1,109,  1,110,  1,153, 72, 70,215, 95, 96,254,
206,254,209,254,210,254,206, 37,  0,  1,  0,201,  0,  0,  5, 59,
  5,213,  0, 11,  0, 44, 64, 20,  8,149,  2,173,  4,  0,129, 10,
  6,  7,  3, 28,  5, 56,  9,  1, 28,  0,  4, 12, 16,252,236, 50,
252,236, 50, 49,  0, 47, 60,228, 50,252,236, 48,178, 80, 13,  1,
  1, 93, 19, 51, 17, 33, 17, 51, 17, 35, 17, 33, 17, 35,201,202,
  2,222,202,202,253, 34,202,  5,213,253,156,  2,100,250, 43,  2,
199,253, 57,  0,  0,  1,  0,201,  0,  0,  1,147,  5,213,  0,  3,
  0, 57,183,  0,175,  2,  1, 28,  0,  4,  4, 16,252,236, 49,  0,
 47,236, 48,  1, 75,176, 16, 84, 88,189,  0,  4,255,192,  0,  1,
  0,  4,  0,  4,  0, 64, 56, 17, 55, 56, 89, 64, 13, 48,  5, 64,
  5, 80,  5, 96,  5,143,  5,159,  5,  6, 93, 19, 51, 17, 35,201,
202,202,  5,213,250, 43,  0,  1,255,150,254,102,  1,147,  5,213,
  0, 11,  0, 77, 64, 19, 11,  2,  0,  7,149,  5,176,  0,129, 12,
  5,  8,  6, 57,  1, 28,  0,  4, 12, 16,252,236,228, 57, 57, 49,
  0, 16,228,252,236, 17, 57, 57, 48,  1, 75,176, 16, 84, 88,189,
  0, 12,255,192,  0,  1,  0, 12,  0, 12,  0, 64, 56, 17, 55, 56,
 89, 64, 13, 48, 13, 64, 13, 80, 13, 96, 13,143, 13,159, 13,  6,
 93, 19, 51, 17, 16,  6, 43,  1, 53, 51, 50, 54, 53,201,202,205,
227, 77, 63,134,110,  5,213,250,147,254,242,244,170,150,194,  0,
  0,  1,  0,201,  0,  0,  5,106,  5,213,  0, 10,  0,239, 64, 40,
  8, 17,  5,  6,  5,  7, 17,  6,  6,  5,  3, 17,  4,  5,  4,  2,
 17,  5,  5,  4, 66,  8,  5,  2,  3,  3,  0,175,  9,  6,  5,  1,
  4,  6,  8,  1, 28,  0,  4, 11, 16,252,236, 50,212,196, 17, 57,
 49,  0, 47, 60,236, 50, 23, 57, 48, 75, 83, 88,  7, 16,  4,237,
  7, 16,  5,237,  7, 16,  5,237,  7, 16,  4,237, 89, 34,178,  8,
  3,  1,  1, 93, 64,146, 20,  2,  1,  4,  2,  9,  8, 22,  2, 40,
  5, 40,  8, 55,  2, 54,  5, 52,  8, 71,  2, 70,  5, 67,  8, 85,
  2,103,  2,118,  2,119,  5,131,  2,136,  5,143,  8,148,  2,155,
  8,231,  2, 21,  6,  3,  9,  5,  9,  6, 27,  3, 25,  7,  5, 10,
  3, 10,  7, 24,  3, 40,  5, 43,  6, 42,  7, 54,  4, 54,  5, 54,
  6, 53,  7, 48, 12, 65,  3, 64,  4, 69,  5, 64,  6, 64,  7, 64,
 12, 98,  3, 96,  4,104,  5,103,  7,119,  5,112, 12,139,  3,139,
  5,142,  6,143,  7,143, 12,154,  3,157,  6,157,  7,182,  3,181,
  7,197,  3,197,  7,215,  3,214,  7,232,  3,233,  4,232,  5,234,
  6,247,  3,248,  5,249,  6, 44, 93,113,  0, 93,113, 19, 51, 17,
  1, 33,  9,  1, 33,  1, 17, 35,201,202,  2,158,  1,  4,253, 27,
  3, 26,254,246,253, 51,202,  5,213,253,137,  2,119,253, 72,252,
227,  2,207,253, 49,  0,  0,  1,  0,201,  0,  0,  4,106,  5,213,
  0,  5,  0, 37, 64, 12,  2,149,  0,129,  4,  1, 28,  3, 58,  0,
  4,  6, 16,252,236,236, 49,  0, 47,228,236, 48, 64,  9, 48,  7,
 80,  7,128,  3,128,  4,  4,  1, 93, 19, 51, 17, 33, 21, 33,201,
202,  2,215,252, 95,  5,213,250,213,170,  0,  1,  0,201,  0,  0,
  6, 31,  5,213,  0, 12,  0,191, 64, 52,  3, 17,  7,  8,  7,  2,
 17,  1,  2,  8,  8,  7,  2, 17,  3,  2,  9, 10,  9,  1, 17, 10,
 10,  9, 66, 10,  7,  2,  3,  8,  3,  0,175,  8, 11,  5,  9,  8,
  3,  2,  1,  5, 10,  6, 28,  4, 62, 10, 28,  0,  4, 13, 16,252,
236,252,236, 17, 23, 57, 49,  0, 47, 60,196,236, 50, 17, 23, 57,
 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  8,237,  7, 16,  8,237,
  7, 16,  5,237, 89, 34,178,112, 14,  1,  1, 93, 64, 86,  3,  7,
 15,  8, 15,  9,  2, 10, 21,  2, 20,  7, 19, 10, 38,  2, 38,  7,
 32,  7, 38, 10, 32, 10, 52,  7, 53, 10,105,  2,124,  2,123,  7,
121, 10,128,  2,130,  7,130, 10,144,  2, 22,  4,  1, 11,  3, 19,
  1, 27,  3, 35,  1, 44,  3, 39,  8, 40,  9, 52,  1, 60,  3, 86,
  8, 89,  9,101,  8,106,  9,118,  8,121,  9,129,  1,141,  3,149,
  1,155,  3, 20, 93,  0, 93, 19, 33,  9,  1, 33, 17, 35, 17,  1,
 35,  1, 17, 35,201,  1, 45,  1,125,  1,127,  1, 45,197,254,127,
203,254,127,196,  5,213,252,  8,  3,248,250, 43,  5, 31,252,  0,
  4,  0,250,225,  0,  1,  0,201,  0,  0,  5, 51,  5,213,  0,  9,
  0,121, 64, 30,  7, 17,  1,  2,  1,  2, 17,  6,  7,  6, 66,  7,
  2,  3,  0,175,  8,  5,  6,  1,  7,  2, 28,  4, 54,  7, 28,  0,
  4, 10, 16,252,236,252,236, 17, 57, 57, 49,  0, 47, 60,236, 50,
 57, 57, 48, 75, 83, 88,  7, 16,  4,237,  7, 16,  4,237, 89, 34,
178, 31, 11,  1,  1, 93, 64, 48, 54,  2, 56,  7, 72,  2, 71,  7,
105,  2,102,  7,128,  2,  7,  6,  1,  9,  6, 21,  1, 26,  6, 70,
  1, 73,  6, 87,  1, 88,  6,101,  1,105,  6,121,  6,133,  1,138,
  6,149,  1,154,  6,159, 11, 16, 93,  0, 93, 19, 33,  1, 17, 51,
 17, 33,  1, 17, 35,201,  1, 16,  2,150,196,254,240,253,106,196,
  5,213,251, 31,  4,225,250, 43,  4,225,251, 31,  0,  2,  0,115,
255,227,  5,217,  5,240,  0, 11,  0, 23,  0, 35, 64, 19,  6,149,
 18,  0,149, 12,145, 18,140, 24,  9, 25, 15, 51,  3, 25, 21, 16,
 24, 16,252,236,252,236, 49,  0, 16,228,244,236, 16,238, 48,  1,
 34,  0, 17, 16,  0, 51, 50,  0, 17, 16,  0, 39, 32,  0, 17, 16,
  0, 33, 32,  0, 17, 16,  0,  3, 39,220,254,253,  1,  3,220,220,
  1,  1,254,255,220,  1, 58,  1,120,254,136,254,198,254,197,254,
135,  1,121,  5, 76,254,184,254,229,254,230,254,184,  1, 72,  1,
 26,  1, 27,  1, 72,164,254, 91,254,158,254,159,254, 91,  1,164,
  1, 98,  1, 98,  1,165,  0,  2,  0,201,  0,  0,  4,141,  5,213,
  0,  8,  0, 19,  0, 58, 64, 24,  1,149, 16,  0,149,  9,129, 18,
 16, 10,  8,  2,  4,  0,  5, 25, 13, 63, 17,  0, 28,  9,  4, 20,
 16,252,236, 50,252,236, 17, 23, 57, 49,  0, 47,244,236,212,236,
 48, 64, 11, 15, 21, 31, 21, 63, 21, 95, 21,175, 21,  5,  1, 93,
  1, 17, 51, 50, 54, 53, 52, 38, 35, 37, 33, 50,  4, 21, 20,  4,
 43,  1, 17, 35,  1,147,254,141,154,154,141,254, 56,  1,200,251,
  1,  1,254,255,251,254,202,  5, 47,253,207,146,135,134,146,166,
227,219,221,226,253,168,  0,  2,  0,115,254,248,  5,217,  5,240,
  0, 11,  0, 29,  0, 82, 64, 42, 17, 16,  2, 15,  1, 12, 13, 12,
 14,  1, 13, 13, 12, 66, 15, 30, 12,  6,149, 18,  0,149, 24,145,
 18,140, 13, 30, 13, 27, 15, 12,  3,  9, 25, 27, 51,  3, 25, 21,
 16, 30, 16,252,236,252,236, 17, 57, 57, 17, 57, 49,  0, 16,196,
228,244,236, 16,238, 57, 18, 57, 48, 75, 83, 88,  7, 16,  5,237,
  7, 16,  5,237, 23, 57, 89, 34,  1, 34,  0, 17, 16,  0, 51, 50,
  0, 17, 16,  0, 19,  1, 35, 39,  6,  6, 35, 32,  0, 17, 16,  0,
 33, 32,  0, 17, 16,  2,  3, 39,220,254,253,  1,  3,220,220,  1,
  1,254,255, 63,  1, 10,244,221, 33, 35, 16,254,197,254,135,  1,
121,  1, 59,  1, 58,  1,120,209,  5, 76,254,184,254,229,254,230,
254,184,  1, 72,  1, 26,  1, 27,  1, 72,250,207,254,221,239,  2,
  2,  1,165,  1, 97,  1, 98,  1,165,254, 91,254,158,254,252,254,
142,  0,  0,  2,  0,201,  0,  0,  5, 84,  5,213,  0, 19,  0, 28,
  0,177, 64, 53,  9,  8,  7,  3, 10,  6, 17,  3,  4,  3,  5, 17,
  4,  4,  3, 66,  6,  4,  0, 21,  3,  4, 21,149,  9, 20,149, 13,
129, 11,  4,  5,  6,  3, 17,  9,  0, 28, 22, 14,  5, 10, 25, 25,
  4, 17, 63, 20, 10, 28, 12,  4, 29, 16,252,236, 50,252,196,236,
 17, 23, 57, 17, 57, 57, 57, 49,  0, 47, 60,244,236,212,236, 18,
 57, 18, 57, 18, 57, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,
237, 17, 23, 57, 89, 34,178, 64, 30,  1,  1, 93, 64, 66,122, 19,
  1,  5,  0,  5,  1,  5,  2,  6,  3,  7,  4, 21,  0, 21,  1, 20,
  2, 22,  3, 23,  4, 37,  0, 37,  1, 37,  2, 38,  3, 39,  6, 38,
  7, 38,  8, 38,  9, 32, 30, 54,  1, 54,  2, 70,  1, 70,  2,104,
  5,117,  4,117,  5,119, 19,136,  6,136,  7,152,  6,152,  7, 31,
 93,  0, 93,  1, 30,  1, 23, 19, 35,  3, 46,  1, 43,  1, 17, 35,
 17, 33, 32, 22, 21, 20,  6,  1, 17, 51, 50, 54, 53, 52, 38, 35,
  3,141, 65,123, 62,205,217,191, 74,139,120,220,202,  1,200,  1,
  0,252,131,253,137,254,146,149,149,146,  2,188, 22,144,126,254,
104,  1,127,150, 98,253,137,  5,213,214,216,141,186,  2, 79,253,
238,135,131,131,133,  0,  0,  1,  0,135,255,227,  4,162,  5,240,
  0, 39,  0,126, 64, 60, 13, 12,  2, 14, 11,  2, 30, 31, 30,  8,
  9,  2,  7, 10,  2, 31, 31, 30, 66, 10, 11, 30, 31,  4, 21,  1,
  0, 21,161, 20,148, 24,149, 17,  4,149,  0,148, 37,145, 17,140,
 40, 30, 10, 11, 31, 27,  7,  0, 34, 27, 25, 14, 45,  7, 25, 20,
 34, 40, 16,220,196,236,252,236,228, 17, 18, 57, 57, 57, 57, 49,
  0, 16,228,244,228,236, 16,238,246,238, 16,198, 17, 23, 57, 48,
 75, 83, 88,  7, 16, 14,237, 17, 23, 57,  7, 16, 14,237, 17, 23,
 57, 89, 34,178, 15, 41,  1,  1, 93,182, 31, 41, 47, 41, 79, 41,
  3, 93,  1, 21, 46,  1, 35, 34,  6, 21, 20, 22, 31,  1, 30,  1,
 21, 20,  4, 33, 34, 38, 39, 53, 30,  1, 51, 50, 54, 53, 52, 38,
 47,  1, 46,  1, 53, 52, 36, 51, 50, 22,  4, 72,115,204, 95,165,
179,119,166,122,226,215,254,221,254,231,106,239,128,123,236,114,
173,188,135,154,123,226,202,  1, 23,245,105,218,  5,164,197, 55,
 54,128,118, 99,101, 31, 25, 43,217,182,217,224, 48, 47,208, 69,
 70,136,126,110,124, 31, 24, 45,192,171,198,228, 38,  0,  0,  1,
255,250,  0,  0,  4,233,  5,213,  0,  7,  0, 74, 64, 14,  6,  2,
149,  0,129,  4,  1, 64,  3, 28,  0, 64,  5,  8, 16,212,228,252,
228, 49,  0, 47,244,236, 50, 48,  1, 75,176, 10, 84, 88,189,  0,
  8,  0, 64,  0,  1,  0,  8,  0,  8,255,192, 56, 17, 55, 56, 89,
 64, 19,  0,  9, 31,  0, 16,  1, 16,  2, 31,  7, 16,  9, 64,  9,
112,  9,159,  9,  9, 93,  3, 33, 21, 33, 17, 35, 17, 33,  6,  4,
239,253,238,203,253,238,  5,213,170,250,213,  5, 43,  0,  0,  1,
  0,178,255,227,  5, 41,  5,213,  0, 17,  0, 75, 64, 22,  8,  2,
 17, 11,  0,  5,149, 14,140,  9,  0,129, 18,  8, 28, 10, 56,  1,
 28,  0, 65, 18, 16,252,236,252,236, 49,  0, 16,228, 50,244,236,
 17, 57, 57, 57, 57, 48,  1, 75,176, 16, 84, 88,189,  0, 18,  0,
 64,  0,  1,  0, 18,  0, 18,255,192, 56, 17, 55, 56, 89,182, 31,
 19,143, 19,159, 19,  3, 93, 19, 51, 17, 20, 22, 51, 50, 54, 53,
 17, 51, 17, 16,  0, 33, 32,  0, 17,178,203,174,195,194,174,203,
254,223,254,230,254,229,254,223,  5,213,252,117,240,211,211,240,
  3,139,252, 92,254,220,254,214,  1, 42,  1, 36,  0,  1,  0, 16,
  0,  0,  5,104,  5,213,  0,  6,  0,183, 64, 39,  4, 17,  5,  6,
  5,  3, 17,  2,  3,  6,  6,  5,  3, 17,  4,  3,  0,  1,  0,  2,
 17,  1,  1,  0, 66,  3,  4,  1,175,  0,  6,  4,  3,  2,  0,  5,
  5,  1,  7, 16,212,196, 23, 57, 49,  0, 47,236, 50, 57, 48, 75,
 83, 88,  7, 16,  5,237,  7, 16,  8,237,  7, 16,  8,237,  7, 16,
  5,237, 89, 34,178, 80,  8,  1,  1, 93, 64, 98,  0,  3, 42,  3,
 71,  4, 71,  5, 90,  3,125,  3,131,  3,  7,  6,  0,  7,  2,  8,
  4,  9,  6, 21,  1, 20,  2, 26,  4, 26,  5, 42,  0, 38,  1, 38,
  2, 41,  4, 41,  5, 37,  6, 32,  8, 56,  0, 51,  1, 51,  2, 60,
  4, 60,  5, 55,  6, 72,  0, 69,  1, 69,  2, 73,  4, 73,  5, 71,
  6, 89,  0, 86,  6,102,  2,105,  4,105,  5,122,  0,118,  1,118,
  2,121,  4,121,  5,117,  6,128,  8,152,  0,151,  6, 41, 93,  0,
 93, 33,  1, 51,  9,  1, 51,  1,  2, 74,253,198,211,  1,217,  1,
218,210,253,199,  5,213,251, 23,  4,233,250, 43,  0,  1,  0, 68,
  0,  0,  7,166,  5,213,  0, 12,  1,123, 64, 73,  5, 26,  6,  5,
  9, 10,  9,  4, 26, 10,  9,  3, 26, 10, 11, 10,  2, 26,  1,  2,
 11, 11, 10,  6, 17,  7,  8,  7,  5, 17,  4,  5,  8,  8,  7,  2,
 17,  3,  2, 12,  0, 12,  1, 17,  0,  0, 12, 66, 10,  5,  2,  3,
  6,  3,  0,175, 11,  8, 12, 11, 10,  9,  8,  6,  5,  4,  3,  2,
  1, 11,  7,  0, 13, 16,212,204, 23, 57, 49,  0, 47, 60,236, 50,
 50, 23, 57, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  8,237,  7,
 16,  8,237,  7, 16,  5,237,  7, 16,  8,237,  7, 16,  5,237,  7,
  5,237,  7, 16,  8,237, 89, 34,178,  0, 14,  1,  1, 93, 64,242,
  6,  2,  6,  5,  2, 10,  0, 10,  0, 10, 18, 10, 40,  5, 36, 10,
 32, 10, 62,  2, 62,  5, 52, 10, 48, 10, 76,  2, 77,  5, 66, 10,
 64, 10, 89,  2,106,  2,107,  5,103, 10, 96, 10,123,  2,127,  2,
124,  5,127,  5,128, 10,150,  2,149,  5, 29,  7,  0,  9,  2,  8,
  3,  0,  4,  6,  5,  0,  5,  0,  6,  1,  7,  4,  8,  0,  8,  7,
  9,  0,  9,  4, 10, 10, 12,  0, 14, 26,  3, 21,  4, 21,  8, 25,
 12, 16, 14, 32,  4, 33,  5, 32,  6, 32,  7, 32,  8, 35,  9, 36,
 10, 37, 11, 32, 14, 32, 14, 60,  2, 58,  3, 53,  4, 51,  5, 48,
  8, 54,  9, 57, 11, 63, 12, 48, 14, 70,  0, 70,  1, 74,  2, 64,
  4, 69,  5, 64,  5, 66,  6, 66,  7, 66,  8, 64,  8, 64,  9, 68,
 10, 77, 12, 64, 14, 64, 14, 88,  2, 86,  8, 89, 12, 80, 14,102,
  2,103,  3, 97,  4, 98,  5, 96,  6, 96,  7, 96,  8,100,  9,100,
 10,100, 11,119,  0,118,  1,123,  2,120,  3,119,  4,116,  5,121,
  6,121,  7,119,  8,112,  8,120, 12,127, 12,127, 14,134,  2,135,
  3,136,  4,137,  5,133,  9,138, 11,143, 14,151,  4,159, 14,175,
 14, 91, 93,  0, 93, 19, 51,  9,  1, 51,  9,  1, 51,  1, 35,  9,
  1, 35, 68,204,  1, 58,  1, 57,227,  1, 58,  1, 57,205,254,137,
254,254,197,254,194,254,  5,213,251, 18,  4,238,251, 18,  4,238,
250, 43,  5, 16,250,240,  0,  1,  0, 61,  0,  0,  5, 59,  5,213,
  0, 11,  1, 93, 64, 70,  9, 17, 10, 11, 10,  8, 17,  7,  8, 11,
 11, 10,  8, 17,  9,  8,  5,  6,  5,  7, 17,  6,  6,  5,  3, 17,
  4,  5,  4,  2, 17,  1,  2,  5,  5,  4,  2, 17,  3,  2, 11,  0,
 11,  1, 17,  0,  0, 11, 66, 11,  8,  5,  2,  4,  3,  0,175,  9,
  6, 11,  8,  5,  2,  4,  0,  4,  6,  0, 10, 12, 16,212,196,220,
196, 17, 23, 57, 49,  0, 47, 60,236, 50, 23, 57, 48, 75, 83, 88,
  7, 16,  5,237,  7, 16,  8,237,  7, 16,  8,237,  7, 16,  5,237,
  7, 16,  5,237,  7, 16,  8,237,  7, 16,  8,237,  7, 16,  5,237,
 89, 34,  1, 75,176, 12, 84, 75,176, 13, 84, 91, 75,176, 14, 84,
 91, 88,189,  0, 12,255,192,  0,  1,  0, 12,  0, 12,  0, 64, 56,
 17, 55, 56, 89, 64,184,  7,  2,  8,  8, 22,  2, 25,  8, 23, 11,
 39,  8, 39, 11, 52,  2, 56,  8, 54, 11, 75,  8, 88,  5, 91,  8,
102,  2,107,  8,119,  2,119, 11,134,  2,128,  2,135,  5,139,  8,
133, 11,148,  2,144,  2,151,  5,157,  8,150, 11, 27,  6,  1,  9,
  3,  8,  7,  7,  9, 22,  1, 25,  3, 25,  7, 23,  9, 16, 13, 38,
  1, 40,  2, 41,  3, 38,  5, 40,  7, 39,  9, 41, 11, 32, 13, 53,
  0, 52,  1, 60,  3, 59,  4, 58,  6, 59,  7, 52,  9, 52, 10, 56,
 11, 63, 13, 72,  9, 79, 13, 88, 11, 95, 13,101,  0,101,  1,106,
  3,106,  4,104,  5,105,  6,105,  7,108,  9,108, 10,120,  3,121,
  6,121,  7,120,  8,125,  9,127, 10,120, 11,128,  0,128,  1,131,
  2,136,  3,133,  5,132,  8,131, 11,143, 13,144,  0,144,  1,148,
  2,151,  5,151,  6,149,  8,147, 11,159, 13,175, 13, 64, 93,  0,
 93, 19, 51,  9,  1, 51,  9,  1, 35,  9,  1, 35,  1,129,217,  1,
115,  1,117,217,254, 32,  2,  0,217,254, 92,254, 89,218,  2, 21,
  5,213,253,213,  2, 43,253, 51,252,248,  2,123,253,133,  3, 29,
  0,  1,255,252,  0,  0,  4,231,  5,213,  0,  8,  0,148, 64, 40,
  3, 17,  4,  5,  4,  2, 17,  1,  2,  5,  5,  4,  2, 17,  3,  2,
  8,  0,  8,  1, 17,  0,  0,  8, 66,  2,  3,  0,175,  6,  2,  7,
  4, 64,  5, 28,  0, 64,  7,  9, 16,212,228,252,228, 18, 57, 49,
  0, 47,236, 50, 57, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  8,
237,  7, 16,  8,237,  7, 16,  5,237, 89, 34,178,  0, 10,  1,  1,
 93, 64, 60,  5,  2, 20,  2, 53,  2, 48,  2, 48,  5, 48,  8, 70,
  2, 64,  2, 64,  5, 64,  8, 81,  2, 81,  5, 81,  8,101,  2,132,
  2,147,  2, 16, 22,  1, 26,  3, 31, 10, 38,  1, 41,  3, 55,  1,
 56,  3, 64, 10,103,  1,104,  3,120,  3,112, 10,159, 10, 13, 93,
  0, 93,  3, 51,  9,  1, 51,  1, 17, 35, 17,  4,217,  1,158,  1,
155,217,253,240,203,  5,213,253,154,  2,102,252,242,253, 57,  2,
199,  0,  0,  1,  0, 92,  0,  0,  5, 31,  5,213,  0,  9,  0,155,
 64, 27,  3, 17,  7,  8,  7,  8, 17,  2,  3,  2, 66,  8,149,  0,
129,  3,149,  5,  8,  3,  0,  1, 66,  4,  0,  6, 10, 16,220,196,
212,228, 17, 57, 57, 49,  0, 47,236,244,236, 48, 75, 83, 88,  7,
 16,  5,237,  7, 16,  5,237, 89, 34,  1, 75,176,  9, 84, 75,176,
 10, 84, 91, 88,189,  0, 10,  0, 64,  0,  1,  0, 10,  0, 10,255,
192, 56, 17, 55, 56, 89, 64, 64,  5,  2, 10,  7, 24,  7, 41,  2,
 38,  7, 56,  7, 72,  2, 71,  7, 72,  8,  9,  5,  3, 11,  8,  0,
 11, 22,  3, 26,  8, 16, 11, 47, 11, 53,  3, 57,  8, 63, 11, 71,
  3, 74,  8, 79, 11, 85,  3, 89,  8,102,  3,105,  8,111, 11,119,
  3,120,  8,127, 11,159, 11, 22, 93,  0, 93, 19, 33, 21,  1, 33,
 21, 33, 53,  1, 33,115,  4,149,252, 80,  3,199,251, 61,  3,176,
252,103,  5,213,154,251,111,170,154,  4,145,  0,  0,  1,  0,176,
254,242,  2, 88,  6, 20,  0,  7,  0, 83, 64, 15,  4,169,  6,178,
  2,169,  0,177,  8,  5,  1,  3, 67,  0,  8, 16,220,252,204, 50,
 49,  0, 16,252,236,244,236, 48,  1, 75,176, 12, 84, 88,189,  0,
  8,255,192,  0,  1,  0,  8,  0,  8,  0, 64, 56, 17, 55, 56, 89,
  1, 75,176, 18, 84, 75,176, 19, 84, 91, 88,189,  0,  8,  0, 64,
  0,  1,  0,  8,  0,  8,255,192, 56, 17, 55, 56, 89, 19, 33, 21,
 35, 17, 51, 21, 33,176,  1,168,240,240,254, 88,  6, 20,143,249,
252,143,  0,  1,  0,  0,255, 66,  2,178,  5,213,  0,  3,  0, 45,
 64, 20,  2, 26,  1,  1,  0,  0, 26,  3,  3,  2, 66,  1,159,  0,
129,  4,  2,  0,  1,  3, 47,196, 57, 57, 49,  0, 16,244,236, 48,
 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237, 89, 34, 19,  1, 35,
  1,170,  2,  8,170,253,248,  5,213,249,109,  6,147,  0,  0,  1,
  0,199,254,242,  2,111,  6, 20,  0,  7,  0, 60, 64, 16,  3,169,
  1,178,  5,169,  0,177,  8,  0, 67,  4,  6,  2,  4,  8, 16,252,
 60,220,236, 49,  0, 16,252,236,244,236, 48,  1, 75,176, 15, 84,
 75,176, 16, 84, 91, 88,189,  0,  8,255,192,  0,  1,  0,  8,  0,
  8,  0, 64, 56, 17, 55, 56, 89,  1, 17, 33, 53, 51, 17, 35, 53,
  2,111,254, 88,239,239,  6, 20,248,222,143,  6,  4,143,  0,  1,
  0,217,  3,168,  5,219,  5,213,  0,  6,  0, 24, 64, 10,  3,  4,
  1,  0,129,  7,  3,  1,  5,  7, 16,220,204, 57, 49,  0, 16,244,
204, 50, 57, 48,  1,  1, 35,  1,  1, 35,  1,  3,188,  2, 31,201,
254, 72,254, 72,201,  2, 31,  5,213,253,211,  1,139,254,117,  2,
 45,  0,  0,  1,255,236,254, 29,  4, 20,254,172,  0,  3,  0, 15,
181,  0,169,  1,  0,  2,  4, 16,196,196, 49,  0,212,236, 48,  1,
 21, 33, 53,  4, 20,251,216,254,172,143,143,  0,  0,  1,  0,170,
  4,240,  2,137,  6,102,  0,  3,  0, 49, 64,  9,  1,180,  0,179,
  4,  3, 68,  1,  4, 16,220,236, 49,  0, 16,244,236, 48,  0, 75,
176,  9, 84, 75,176, 14, 84, 91, 88,189,  0,  4,255,192,  0,  1,
  0,  4,  0,  4,  0, 64, 56, 17, 55, 56, 89,  9,  1, 35,  1,  1,
111,  1, 26,153,254,186,  6,102,254,138,  1,118,  0,  2,  0,123,
255,227,  4, 45,  4,123,  0, 10,  0, 37,  0,188, 64, 39, 25, 31,
 11, 23,  9, 14,  0,169, 23,  6,185, 14, 17, 32,134, 31,186, 28,
185, 35,184, 17,140, 23, 12,  0, 23,  3, 24, 13,  9,  8, 11, 31,
  3,  8, 20, 69, 38, 16,252,236,204,212,236, 50, 50, 17, 57, 57,
 49,  0, 47,196,228,244,252,244,236, 16,198,238, 16,238, 17, 57,
 17, 57, 18, 57, 48, 64,110, 48, 29, 48, 30, 48, 31, 48, 32, 48,
 33, 48, 34, 63, 39, 64, 29, 64, 30, 64, 31, 64, 32, 64, 33, 64,
 34, 80, 29, 80, 30, 80, 31, 80, 32, 80, 33, 80, 34, 80, 39,112,
 39,133, 29,135, 30,135, 31,135, 32,135, 33,133, 34,144, 39,160,
 39,240, 39, 30, 48, 30, 48, 31, 48, 32, 48, 33, 64, 30, 64, 31,
 64, 32, 64, 33, 80, 30, 80, 31, 80, 32, 80, 33, 96, 30, 96, 31,
 96, 32, 96, 33,112, 30,112, 31,112, 32,112, 33,128, 30,128, 31,
128, 32,128, 33, 24, 93,  1, 93,  1, 34,  6, 21, 20, 22, 51, 50,
 54, 61,  1, 55, 17, 35, 53, 14,  1, 35, 34, 38, 53, 52, 54, 51,
 33, 53, 52, 38, 35, 34,  6,  7, 53, 62,  1, 51, 50, 22,  2,190,
223,172,129,111,153,185,184,184, 63,188,136,172,203,253,251,  1,
  2,167,151, 96,182, 84,101,190, 90,243,240,  2, 51,102,123, 98,
115,217,180, 41, 76,253,129,170,102, 97,193,162,189,192, 18,127,
139, 46, 46,170, 39, 39,252,  0,  0,  2,  0,186,255,227,  4,164,
  6, 20,  0, 11,  0, 28,  0, 56, 64, 25,  3,185, 12, 15,  9,185,
 24, 21,140, 15,184, 27,151, 25,  0, 18, 18, 71, 24, 12,  6,  8,
 26, 70, 29, 16,252,236, 50, 50,244,236, 49,  0, 47,236,228,244,
196,236, 16,198,238, 48,182, 96, 30,128, 30,160, 30,  3,  1, 93,
  1, 52, 38, 35, 34,  6, 21, 20, 22, 51, 50, 54,  1, 62,  1, 51,
 50, 18, 17, 16,  2, 35, 34, 38, 39, 21, 35, 17, 51,  3,229,167,
146,146,167,167,146,146,167,253,142, 58,177,123,204,255,255,204,
123,177, 58,185,185,  2, 47,203,231,231,203,203,231,231,  2, 82,
100, 97,254,188,254,248,254,248,254,188, 97,100,168,  6, 20,  0,
  0,  1,  0,113,255,227,  3,231,  4,123,  0, 25,  0, 63, 64, 27,
  0,134,  1,136,  4, 14,134, 13,136, 10,185, 17,  4,185, 23,184,
 17,140, 26,  7, 18, 13,  0, 72, 20, 69, 26, 16,252,228, 50,236,
 49,  0, 16,228,244,236, 16,254,244,238, 16,245,238, 48, 64, 11,
 15, 27, 16, 27,128, 27,144, 27,160, 27,  5,  1, 93,  1, 21, 46,
  1, 35, 34,  6, 21, 20, 22, 51, 50, 54, 55, 21, 14,  1, 35, 34,
  0, 17, 16,  0, 33, 50, 22,  3,231, 78,157, 80,179,198,198,179,
 80,157, 78, 77,165, 93,253,254,214,  1, 45,  1,  6, 85,162,  4,
 53,172, 43, 43,227,205,205,227, 43, 43,170, 36, 36,  1, 62,  1,
 14,  1, 18,  1, 58, 35,  0,  2,  0,113,255,227,  4, 90,  6, 20,
  0, 16,  0, 28,  0, 56, 64, 25, 26,185,  0, 14, 20,185,  5,  8,
140, 14,184,  1,151,  3, 23,  4,  0,  8,  2, 71, 17, 18, 11, 69,
 29, 16,252,236,244,236, 50, 50, 49,  0, 47,236,228,244,196,236,
 16,196,238, 48,182, 96, 30,128, 30,160, 30,  3,  1, 93,  1, 17,
 51, 17, 35, 53, 14,  1, 35, 34,  2, 17, 16, 18, 51, 50, 22,  1,
 20, 22, 51, 50, 54, 53, 52, 38, 35, 34,  6,  3,162,184,184, 58,
177,124,203,255,255,203,124,177,253,199,167,146,146,168,168,146,
146,167,  3,182,  2, 94,249,236,168,100, 97,  1, 68,  1,  8,  1,
  8,  1, 68, 97,254, 21,203,231,231,203,203,231,231,  0,  0,  2,
  0,113,255,227,  4,127,  4,123,  0, 20,  0, 27,  0,112, 64, 36,
  0, 21,  1,  9,134,  8,136,  5, 21,169,  1,  5,185, 12,  1,187,
 24,185, 18,184, 12,140, 28, 27, 21,  2,  8, 21,  8,  0, 75,  2,
 18, 15, 69, 28, 16,252,236,244,236,196, 17, 18, 57, 49,  0, 16,
228,244,236,228, 16,238, 16,238, 16,244,238, 17, 18, 57, 48, 64,
 41, 63, 29,112, 29,160, 29,208, 29,240, 29,  5, 63,  0, 63,  1,
 63,  2, 63, 21, 63, 27,  5, 44,  7, 47,  8, 47,  9, 44, 10,111,
  0,111,  1,111,  2,111, 21,111, 27,  9, 93,113,  1, 93,  1, 21,
 33, 30,  1, 51, 50, 54, 55, 21, 14,  1, 35, 32,  0, 17, 16,  0,
 51, 50,  0,  7, 46,  1, 35, 34,  6,  7,  4,127,252,178, 12,205,
183,106,199, 98, 99,208,107,254,244,254,199,  1, 41,252,226,  1,
  7,184,  2,165,136,154,185, 14,  2, 94, 90,190,199, 52, 52,174,
 42, 44,  1, 56,  1, 10,  1, 19,  1, 67,254,221,196,151,180,174,
158,  0,  0,  1,  0, 47,  0,  0,  2,248,  6, 20,  0, 19,  0,112,
 64, 28,  5, 16,  1, 12,  8,169,  6,  1,135,  0,151, 14,  6,188,
 10,  2, 19,  7,  0,  7,  9,  5,  8, 13, 15, 11, 76, 20, 16,252,
 60,196,252, 60,196,196, 18, 57, 57, 49,  0, 47,228, 50,252,236,
 16,238, 50, 18, 57, 57, 48,  1, 75,176, 10, 84, 88,189,  0, 20,
255,192,  0,  1,  0, 20,  0, 20,  0, 64, 56, 17, 55, 56, 89,  1,
 75,176, 14, 84, 88,189,  0, 20,  0, 64,  0,  1,  0, 20,  0, 20,
255,192, 56, 17, 55, 56, 89,182, 64, 21, 80, 21,160, 21,  3, 93,
  1, 21, 35, 34,  6, 29,  1, 33, 21, 33, 17, 35, 17, 35, 53, 51,
 53, 52, 54, 51,  2,248,176, 99, 77,  1, 47,254,209,185,176,176,
174,189,  6, 20,153, 80,104, 99,143,252, 47,  3,209,143, 78,187,
171,  0,  0,  2,  0,113,254, 86,  4, 90,  4,123,  0, 11,  0, 40,
  0, 74, 64, 35, 25, 12, 29,  9, 18,134, 19, 22,185, 15,  3,185,
 38, 35,184, 39,188,  9,185, 15,189, 26, 29, 38, 25,  0,  8, 12,
 71,  6, 18, 18, 32, 69, 41, 16,252,196,236,244,236, 50, 50, 49,
  0, 47,196,228,236,228,244,196,236, 16,254,213,238, 17, 18, 57,
 57, 48,182, 96, 42,128, 42,160, 42,  3,  1, 93,  1, 52, 38, 35,
 34,  6, 21, 20, 22, 51, 50, 54, 23, 16,  2, 33, 34, 38, 39, 53,
 30,  1, 51, 50, 54, 61,  1, 14,  1, 35, 34,  2, 17, 16, 18, 51,
 50, 22, 23, 53, 51,  3,162,165,149,148,165,165,148,149,165,184,
254,254,250, 97,172, 81, 81,158, 82,181,180, 57,178,124,206,252,
252,206,124,178, 57,184,  2, 61,200,220,220,200,199,220,220,235,
254,226,254,233, 29, 30,179, 44, 42,189,191, 91, 99, 98,  1, 58,
  1,  3,  1,  4,  1, 58, 98, 99,170,  0,  0,  1,  0,186,  0,  0,
  4,100,  6, 20,  0, 19,  0, 52, 64, 25,  3,  9,  0,  3, 14,  1,
  6,135, 14, 17,184, 12,151, 10,  1,  2,  8,  0, 78, 13,  9,  8,
 11, 70, 20, 16,252,236, 50,244,236, 49,  0, 47, 60,236,244,196,
236, 17, 18, 23, 57, 48,178, 96, 21,  1,  1, 93,  1, 17, 35, 17,
 52, 38, 35, 34,  6, 21, 17, 35, 17, 51, 17, 62,  1, 51, 50, 22,
  4,100,184,124,124,149,172,185,185, 66,179,117,193,198,  2,164,
253, 92,  2,158,159,158,190,164,253,135,  6, 20,253,158,101,100,
239,  0,  0,  2,  0,193,  0,  0,  1,121,  6, 20,  0,  3,  0,  7,
  0, 43, 64, 14,  6,190,  4,177,  0,188,  2,  5,  1,  8,  4,  0,
 70,  8, 16,252, 60,236, 50, 49,  0, 47,228,252,236, 48, 64, 11,
 16,  9, 64,  9, 80,  9, 96,  9,112,  9,  5,  1, 93, 19, 51, 17,
 35, 17, 51, 21, 35,193,184,184,184,184,  4, 96,251,160,  6, 20,
233,  0,  0,  2,255,219,254, 86,  1,121,  6, 20,  0, 11,  0, 15,
  0, 68, 64, 28, 11,  2,  7,  0, 14,190, 12,  7,135,  5,189,  0,
188, 12,177, 16,  8, 16,  5,  6, 79, 13,  1,  8, 12,  0, 70, 16,
 16,252, 60,236, 50,228, 57, 18, 57, 49,  0, 16,236,228,244,236,
 16,238, 17, 18, 57, 57, 48, 64, 11, 16, 17, 64, 17, 80, 17, 96,
 17,112, 17,  5,  1, 93, 19, 51, 17, 20,  6, 43,  1, 53, 51, 50,
 54, 53, 17, 51, 21, 35,193,184,163,181, 70, 49,105, 76,184,184,
  4, 96,251,140,214,192,156, 97,153,  6, 40,233,  0,  1,  0,186,
  0,  0,  4,156,  6, 20,  0, 10,  0,188, 64, 41,  8, 17,  5,  6,
  5,  7, 17,  6,  6,  5,  3, 17,  4,  5,  4,  2, 17,  5,  5,  4,
 66,  8,  5,  2,  3,  3,188,  0,151,  9,  6,  5,  1,  4,  6,  8,
  1,  8,  0, 70, 11, 16,252,236, 50,212,196, 17, 57, 49,  0, 47,
 60,236,228, 23, 57, 48, 75, 83, 88,  7, 16,  4,237,  7, 16,  5,
237,  7, 16,  5,237,  7, 16,  4,237, 89, 34,178, 16, 12,  1,  1,
 93, 64, 95,  4,  2, 10,  8, 22,  2, 39,  2, 41,  5, 43,  8, 86,
  2,102,  2,103,  8,115,  2,119,  5,130,  2,137,  5,142,  8,147,
  2,150,  5,151,  8,163,  2, 18,  9,  5,  9,  6,  2, 11,  3, 10,
  7, 40,  3, 39,  4, 40,  5, 43,  6, 43,  7, 64, 12,104,  3, 96,
 12,137,  3,133,  4,137,  5,141,  6,143,  7,154,  3,151,  7,170,
  3,167,  5,182,  7,197,  7,214,  7,247,  3,240,  3,247,  4,240,
  4, 26, 93,113,  0, 93, 19, 51, 17,  1, 51,  9,  1, 35,  1, 17,
 35,186,185,  2, 37,235,253,174,  2,107,240,253,199,185,  6, 20,
252,105,  1,227,253,244,253,172,  2, 35,253,221,  0,  1,  0,193,
  0,  0,  1,121,  6, 20,  0,  3,  0, 34,183,  0,151,  2,  1,  8,
  0, 70,  4, 16,252,236, 49,  0, 47,236, 48, 64, 13, 16,  5, 64,
  5, 80,  5, 96,  5,112,  5,240,  5,  6,  1, 93, 19, 51, 17, 35,
193,184,184,  6, 20,249,236,  0,  0,  1,  0,186,  0,  0,  7, 29,
  4,123,  0, 34,  0, 90, 64, 38,  6, 18,  9, 24, 15,  0,  6, 29,
  7, 21, 12,135, 29, 32,  3,184, 27,188, 25, 16,  7,  0, 17, 15,
  8,  8,  6, 80, 17,  8, 15, 80, 28, 24,  8, 26, 70, 35, 16,252,
236, 50,252,252,252,236, 17, 18, 57, 49,  0, 47, 60, 60,228,244,
 60,196,236, 50, 17, 18, 23, 57, 48, 64, 19, 48, 36, 80, 36,112,
 36,144, 36,160, 36,160, 36,191, 36,223, 36,255, 36,  9,  1, 93,
  1, 62,  1, 51, 50, 22, 21, 17, 35, 17, 52, 38, 35, 34,  6, 21,
 17, 35, 17, 52, 38, 35, 34,  6, 21, 17, 35, 17, 51, 21, 62,  1,
 51, 50, 22,  4, 41, 69,192,130,175,190,185,114,117,143,166,185,
114,119,141,166,185,185, 63,176,121,122,171,  3,137,124,118,245,
226,253, 92,  2,158,161,156,190,164,253,135,  2,158,162,155,191,
163,253,135,  4, 96,174,103, 98,124,  0,  0,  1,  0,186,  0,  0,
  4,100,  4,123,  0, 19,  0, 54, 64, 25,  3,  9,  0,  3, 14,  1,
  6,135, 14, 17,184, 12,188, 10,  1,  2,  8,  0, 78, 13,  9,  8,
 11, 70, 20, 16,252,236, 50,244,236, 49,  0, 47, 60,228,244,196,
236, 17, 18, 23, 57, 48,180, 96, 21,207, 21,  2,  1, 93,  1, 17,
 35, 17, 52, 38, 35, 34,  6, 21, 17, 35, 17, 51, 21, 62,  1, 51,
 50, 22,  4,100,184,124,124,149,172,185,185, 66,179,117,193,198,
  2,164,253, 92,  2,158,159,158,190,164,253,135,  4, 96,174,101,
100,239,  0,  2,  0,113,255,227,  4,117,  4,123,  0, 11,  0, 23,
  0, 74, 64, 19,  6,185, 18,  0,185, 12,184, 18,140, 24,  9, 18,
 15, 81,  3, 18, 21, 69, 24, 16,252,236,244,236, 49,  0, 16,228,
244,236, 16,238, 48, 64, 35, 63, 25,123,  0,123,  6,127,  7,127,
  8,127,  9,127, 10,127, 11,123, 12,127, 13,127, 14,127, 15,127,
 16,127, 17,123, 18,160, 25,240, 25, 17,  1, 93,  1, 34,  6, 21,
 20, 22, 51, 50, 54, 53, 52, 38, 39, 50,  0, 17, 16,  0, 35, 34,
  0, 17, 16,  0,  2,115,148,172,171,149,147,172,172,147,240,  1,
 18,254,238,240,241,254,239,  1, 17,  3,223,231,201,201,231,232,
200,199,233,156,254,200,254,236,254,237,254,199,  1, 57,  1, 19,
  1, 20,  1, 56,  0,  2,  0,186,254, 86,  4,164,  4,123,  0, 16,
  0, 28,  0, 62, 64, 27, 26,185,  0, 14, 20,185,  5,  8,184, 14,
140,  1,189,  3,188, 29, 17, 18, 11, 71, 23,  4,  0,  8,  2, 70,
 29, 16,252,236, 50, 50,244,236, 49,  0, 16,228,228,228,244,196,
236, 16,196,238, 48, 64,  9, 96, 30,128, 30,160, 30,224, 30,  4,
  1, 93, 37, 17, 35, 17, 51, 21, 62,  1, 51, 50, 18, 17, 16,  2,
 35, 34, 38,  1, 52, 38, 35, 34,  6, 21, 20, 22, 51, 50, 54,  1,
115,185,185, 58,177,123,204,255,255,204,123,177,  2, 56,167,146,
146,167,167,146,146,167,168,253,174,  6, 10,170,100, 97,254,188,
254,248,254,248,254,188, 97,  1,235,203,231,231,203,203,231,231,
  0,  2,  0,113,254, 86,  4, 90,  4,123,  0, 11,  0, 28,  0, 62,
 64, 27,  3,185, 12, 15,  9,185, 24, 21,184, 15,140, 27,189, 25,
188, 29, 24, 12,  6,  8, 26, 71,  0, 18, 18, 69, 29, 16,252,236,
244,236, 50, 50, 49,  0, 16,228,228,228,244,196,236, 16,198,238,
 48, 64,  9, 96, 30,128, 30,160, 30,224, 30,  4,  1, 93,  1, 20,
 22, 51, 50, 54, 53, 52, 38, 35, 34,  6,  1, 14,  1, 35, 34,  2,
 17, 16, 18, 51, 50, 22, 23, 53, 51, 17, 35,  1, 47,167,146,146,
168,168,146,146,167,  2,115, 58,177,124,203,255,255,203,124,177,
 58,184,184,  2, 47,203,231,231,203,203,231,231,253,174,100, 97,
  1, 68,  1,  8,  1,  8,  1, 68, 97,100,170,249,246,  0,  0,  1,
  0,186,  0,  0,  3, 74,  4,123,  0, 17,  0, 48, 64, 20,  6, 11,
  7,  0, 17, 11,  3,135, 14,184,  9,188,  7, 10,  6,  8,  0,  8,
 70, 18, 16,252,196,236, 50, 49,  0, 47,228,244,236,196,212,204,
 17, 18, 57, 48,180, 80, 19,159, 19,  2,  1, 93,  1, 46,  1, 35,
 34,  6, 21, 17, 35, 17, 51, 21, 62,  1, 51, 50, 22, 23,  3, 74,
 31, 73, 44,156,167,185,185, 58,186,133, 19, 46, 28,  3,180, 18,
 17,203,190,253,178,  4, 96,174,102, 99,  5,  5,  0,  1,  0,111,
255,227,  3,199,  4,123,  0, 39,  0,231, 64, 60, 13, 12,  2, 14,
 11, 83, 31, 30,  8,  9,  2,  7, 10, 83, 30, 31, 30, 66, 10, 11,
 30, 31,  4, 21,  0,134,  1,137,  4, 20,134, 21,137, 24,185, 17,
  4,185, 37,184, 17,140, 40, 30, 10, 11, 31, 27,  7,  0, 82, 27,
  8, 14,  7,  8, 20, 34, 69, 40, 16,252,196,236,212,236,228, 17,
 18, 57, 57, 57, 57, 49,  0, 16,228,244,236, 16,254,245,238, 16,
245,238, 18, 23, 57, 48, 75, 83, 88,  7, 16, 14,237, 17, 23, 57,
  7, 14,237, 17, 23, 57, 89, 34,178,  0, 39,  1,  1, 93, 64,109,
 28, 10, 28, 11, 28, 12, 46,  9, 44, 10, 44, 11, 44, 12, 59,  9,
 59, 10, 59, 11, 59, 12, 11, 32,  0, 32,  1, 36,  2, 40, 10, 40,
 11, 42, 19, 47, 20, 47, 21, 42, 22, 40, 30, 40, 31, 41, 32, 41,
 33, 36, 39,134, 10,134, 11,134, 12,134, 13, 18,  0,  0,  0,  1,
  2,  2,  6, 10,  6, 11,  3, 12,  3, 13,  3, 14,  3, 15,  3, 16,
  3, 25,  3, 26,  3, 27,  3, 28,  4, 29,  9, 39, 47, 41, 63, 41,
 95, 41,127, 41,128, 41,144, 41,160, 41,240, 41, 24, 93,  0, 93,
113,  1, 21, 46,  1, 35, 34,  6, 21, 20, 22, 31,  1, 30,  1, 21,
 20,  6, 35, 34, 38, 39, 53, 30,  1, 51, 50, 54, 53, 52, 38, 47,
  1, 46,  1, 53, 52, 54, 51, 50, 22,  3,139, 78,168, 90,137,137,
 98,148, 63,196,165,247,216, 90,195,108,102,198, 97,130,140,101,
171, 64,171,152,224,206,102,180,  4, 63,174, 40, 40, 84, 84, 64,
 73, 33, 14, 42,153,137,156,182, 35, 35,190, 53, 53, 89, 81, 75,
 80, 37, 15, 36,149,130,158,172, 30,  0,  0,  1,  0, 55,  0,  0,
  2,242,  5,158,  0, 19,  0, 56, 64, 25, 14,  5,  8, 15,  3,169,
  0, 17,  1,188,  8,135, 10, 11,  8,  9,  2,  4,  0,  8, 16, 18,
 14, 70, 20, 16,252, 60,196,252, 60,196, 50, 57, 57, 49,  0, 47,
236,244, 60,196,236, 50, 17, 57, 57, 48,178,175, 21,  1,  1, 93,
  1, 17, 33, 21, 33, 17, 20, 22, 59,  1, 21, 35, 34, 38, 53, 17,
 35, 53, 51, 17,  1,119,  1,123,254,133, 75,115,189,189,213,162,
135,135,  5,158,254,194,143,253,160,137, 78,154,159,210,  2, 96,
143,  1, 62,  0,  0,  1,  0,174,255,227,  4, 88,  4, 96,  0, 19,
  0, 54, 64, 25,  3,  9,  0,  3, 14,  1,  6,135, 14, 17,140, 10,
  1,188, 12, 13,  9,  8, 11, 78,  2,  8,  0, 70, 20, 16,252,236,
244,236, 50, 49,  0, 47,228, 50,244,196,236, 17, 18, 23, 57, 48,
180, 96, 21,207, 21,  2,  1, 93, 19, 17, 51, 17, 20, 22, 51, 50,
 54, 53, 17, 51, 17, 35, 53, 14,  1, 35, 34, 38,174,184,124,124,
149,173,184,184, 67,177,117,193,200,  1,186,  2,166,253, 97,159,
159,190,164,  2,123,251,160,172,102, 99,240,  0,  0,  1,  0, 61,
  0,  0,  4,127,  4, 96,  0,  6,  1, 18, 64, 39,  3, 17,  4,  5,
  4,  2, 17,  1,  2,  5,  5,  4,  2, 17,  3,  2,  6,  0,  6,  1,
 17,  0,  0,  6, 66,  2,  3,  0,191,  5,  6,  5,  3,  2,  1,  5,
  4,  0,  7, 16,212,196, 23, 57, 49,  0, 47,236, 50, 57, 48, 75,
 83, 88,  7, 16,  5,237,  7, 16,  8,237,  7, 16,  8,237,  7, 16,
  5,237, 89, 34,  1, 75,176, 10, 84, 88,189,  0,  7,255,192,  0,
  1,  0,  7,  0,  7,  0, 64, 56, 17, 55, 56, 89,  1, 75,176, 20,
 84, 75,176, 21, 84, 91, 88,189,  0,  7,  0, 64,  0,  1,  0,  7,
  0,  7,255,192, 56, 17, 55, 56, 89, 64,142, 72,  2,106,  2,123,
  2,127,  2,134,  2,128,  2,145,  2,164,  2,  8,  6,  0,  6,  1,
  9,  3,  9,  4, 21,  0, 21,  1, 26,  3, 26,  4, 38,  0, 38,  1,
 41,  3, 41,  4, 32,  8, 53,  0, 53,  1, 58,  3, 58,  4, 48,  8,
 70,  0, 70,  1, 73,  3, 73,  4, 70,  5, 72,  6, 64,  8, 86,  0,
 86,  1, 89,  3, 89,  4, 80,  8,102,  0,102,  1,105,  3,105,  4,
103,  5,104,  6, 96,  8,117,  0,116,  1,123,  3,123,  4,117,  5,
122,  6,133,  0,133,  1,137,  3,137,  4,137,  5,134,  6,150,  0,
150,  1,151,  2,154,  3,152,  4,152,  5,151,  6,168,  5,167,  6,
176,  8,192,  8,223,  8,255,  8, 62, 93,  0, 93, 19, 51,  9,  1,
 51,  1, 35, 61,195,  1, 94,  1, 94,195,254, 92,250,  4, 96,252,
 84,  3,172,251,160,  0,  0,  1,  0, 86,  0,  0,  6, 53,  4, 96,
  0, 12,  2,  1, 64, 73,  5, 85,  6,  5,  9, 10,  9,  4, 85, 10,
  9,  3, 85, 10, 11, 10,  2, 85,  1,  2, 11, 11, 10,  6, 17,  7,
  8,  7,  5, 17,  4,  5,  8,  8,  7,  2, 17,  3,  2, 12,  0, 12,
  1, 17,  0,  0, 12, 66, 10,  5,  2,  3,  6,  3,  0,191, 11,  8,
 12, 11, 10,  9,  8,  6,  5,  4,  3,  2,  1, 11,  7,  0, 13, 16,
212,204, 23, 57, 49,  0, 47, 60,236, 50, 50, 23, 57, 48, 75, 83,
 88,  7, 16,  5,237,  7, 16,  8,237,  7, 16,  8,237,  7, 16,  5,
237,  7, 16,  8,237,  7, 16,  5,237,  7,  5,237,  7, 16,  8,237,
 89, 34,  1, 75,176, 10, 84, 75,176, 17, 84, 91, 75,176, 18, 84,
 91, 75,176, 19, 84, 91, 75,176, 11, 84, 91, 88,189,  0, 13,255,
192,  0,  1,  0, 13,  0, 13,  0, 64, 56, 17, 55, 56, 89,  1, 75,
176, 12, 84, 75,176, 13, 84, 91, 75,176, 16, 84, 91, 88,189,  0,
 13,  0, 64,  0,  1,  0, 13,  0, 13,255,192, 56, 17, 55, 56, 89,
 64,255,  5,  2, 22,  2, 22,  5, 34, 10, 53, 10, 73,  2, 73,  5,
 70, 10, 64, 10, 91,  2, 91,  5, 85, 10, 80, 10,110,  2,110,  5,
102, 10,121,  2,127,  2,121,  5,127,  5,135,  2,153,  2,152,  5,
148, 10,188,  2,188,  5,206,  2,199,  3,207,  5, 29,  5,  2,  9,
  3,  6,  4, 11,  5, 10,  8, 11,  9,  4, 11,  5, 12, 21,  2, 25,
  3, 22,  4, 26,  5, 27,  8, 27,  9, 20, 11, 21, 12, 37,  0, 37,
  1, 35,  2, 39,  3, 33,  4, 37,  5, 34,  6, 34,  7, 37,  8, 39,
  9, 36, 10, 33, 11, 35, 12, 57,  3, 54,  4, 54,  8, 57, 12, 48,
 14, 70,  2, 72,  3, 70,  4, 64,  4, 66,  5, 64,  6, 64,  7, 64,
  8, 68,  9, 68, 10, 68, 11, 64, 14, 64, 14, 86,  0, 86,  1, 86,
  2, 80,  4, 81,  5, 82,  6, 82,  7, 80,  8, 83,  9, 84, 10, 85,
 11, 99,  0,100,  1,101,  2,106,  3,101,  4,106,  5,106,  6,106,
  7,110,  9, 97, 11,103, 12,111, 14,117,  0,117,  1,121,  2,125,
  3,120,  4,125,  5,122,  6,127,  6,122,  7,127,  7,120,  8,121,
  9,127,  9,123, 10,118, 11,125, 12,135,  2,136,  5,143, 14,151,
  0,151,  1,148,  2,147,  3,156,  4,155,  5,152,  6,152,  7,153,
  8, 64, 47,150, 12,159, 14,166,  0,166,  1,164,  2,164,  3,171,
  4,171,  5,169,  6,169,  7,171,  8,164, 12,175, 14,181,  2,177,
  3,189,  4,187,  5,184,  9,191, 14,196,  2,195,  3,204,  4,202,
  5,121, 93,  0, 93, 19, 51, 27,  1, 51, 27,  1, 51,  1, 35, 11,
  1, 35, 86,184,230,229,217,230,229,184,254,219,217,241,242,217,
  4, 96,252,150,  3,106,252,150,  3,106,251,160,  3,150,252,106,
  0,  1,  0, 59,  0,  0,  4,121,  4, 96,  0, 11,  1, 90, 64, 70,
  5, 17,  6,  7,  6,  4, 17,  3,  4,  7,  7,  6,  4, 17,  5,  4,
  1,  2,  1,  3, 17,  2,  2,  1, 11, 17,  0,  1,  0, 10, 17,  9,
 10,  1,  1,  0, 10, 17, 11, 10,  7,  8,  7,  9, 17,  8,  8,  7,
 66, 10,  7,  4,  1,  4,  8,  0,191,  5,  2, 10,  7,  4,  1,  4,
  8,  0,  2,  8,  6, 12, 16,212,196,212,196, 17, 23, 57, 49,  0,
 47, 60,236, 50, 23, 57, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,
  8,237,  7, 16,  8,237,  7, 16,  5,237,  7, 16,  5,237,  7, 16,
  8,237,  7, 16,  8,237,  7, 16,  5,237, 89, 34,  1, 75,176, 10,
 84, 75,176, 15, 84, 91, 75,176, 16, 84, 91, 75,176, 17, 84, 91,
 88,189,  0, 12,255,192,  0,  1,  0, 12,  0, 12,  0, 64, 56, 17,
 55, 56, 89,  1, 75,176, 20, 84, 88,189,  0, 12,  0, 64,  0,  1,
  0, 12,  0, 12,255,192, 56, 17, 55, 56, 89, 64,152, 10,  4,  4,
 10, 26,  4, 21, 10, 38, 10, 61,  4, 49, 10, 85,  4, 87,  7, 88,
 10,102, 10,118,  1,122,  4,118,  7,116, 10,141,  4,130, 10,153,
  4,159,  4,151,  7,146, 10,144, 10,166,  1,169,  4,175,  4,165,
  7,163, 10,160, 10, 28, 10,  3,  4,  5,  5,  9, 10, 11, 26,  3,
 21,  5, 21,  9, 26, 11, 41,  3, 38,  5, 37,  9, 42, 11, 32, 13,
 58,  1, 57,  3, 55,  5, 52,  7, 54,  9, 57, 11, 48, 13, 73,  3,
 70,  5, 69,  9, 74, 11, 64, 13, 89,  0, 86,  1, 89,  2, 89,  3,
 87,  5, 86,  6, 89,  7, 86,  8, 86,  9, 89, 11, 80, 13,111, 13,
120,  1,127, 13,155,  1,148,  7,171,  1,164,  7,176, 13,207, 13,
223, 13,255, 13, 47, 93,  0, 93,  9,  2, 35,  9,  1, 35,  9,  1,
 51,  9,  1,  4,100,254,107,  1,170,217,254,186,254,186,217,  1,
179,254,114,217,  1, 41,  1, 41,  4, 96,253,223,253,193,  1,184,
254, 72,  2, 74,  2, 22,254,113,  1,143,  0,  1,  0, 61,254, 86,
  4,127,  4, 96,  0, 15,  1,162, 64, 67,  7,  8,  2,  9, 17,  0,
 15, 10, 17, 11, 10,  0,  0, 15, 14, 17, 15,  0, 15, 13, 17, 12,
 13,  0,  0, 15, 13, 17, 14, 13, 10, 11, 10, 12, 17, 11, 11, 10,
 66, 13, 11,  9, 16,  0, 11,  5,135,  3,189, 14, 11,188, 16, 14,
 13, 12, 10,  9,  6,  3,  0,  8, 15,  4, 15, 11, 16, 16,212,196,
196, 17, 23, 57, 49,  0, 16,228, 50,244,236, 17, 57, 17, 57, 18,
 57, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  8,237,  7, 16,  8,
237,  7, 16,  5,237,  7, 16,  8,237,  7,  5,237, 23, 50, 89, 34,
  1, 75,176, 10, 84, 75,176,  8, 84, 91, 88,189,  0, 16,255,192,
  0,  1,  0, 16,  0, 16,  0, 64, 56, 17, 55, 56, 89,  1, 75,176,
 20, 84, 88,189,  0, 16,  0, 64,  0,  1,  0, 16,  0, 16,255,192,
 56, 17, 55, 56, 89, 64,240,  6,  0,  5,  8,  6,  9,  3, 13, 22,
 10, 23, 13, 16, 13, 35, 13, 53, 13, 73, 10, 79, 10, 78, 13, 90,
  9, 90, 10,106, 10,135, 13,128, 13,147, 13, 18, 10,  0, 10,  9,
  6, 11,  5, 12, 11, 14, 11, 15, 23,  1, 21,  2, 16,  4, 16,  5,
 23, 10, 20, 11, 20, 12, 26, 14, 26, 15, 39,  0, 36,  1, 36,  2,
 32,  4, 32,  5, 41,  8, 40,  9, 37, 10, 36, 11, 36, 12, 39, 13,
 42, 14, 42, 15, 32, 17, 55,  0, 53,  1, 53,  2, 48,  4, 48,  5,
 56, 10, 54, 11, 54, 12, 56, 13, 57, 14, 57, 15, 48, 17, 65,  0,
 64,  1, 64,  2, 64,  3, 64,  4, 64,  5, 64,  6, 64,  7, 64,  8,
 66,  9, 69, 10, 71, 13, 73, 14, 73, 15, 64, 17, 84,  0, 81,  1,
 81,  2, 85,  3, 80,  4, 80,  5, 86,  6, 85,  7, 86,  8, 87,  9,
 87, 10, 85, 11, 85, 12, 89, 14, 89, 15, 80, 17,102,  1,102,  2,
104, 10,105, 14,105, 15, 96, 17,123,  8,120, 14,120, 15,137,  0,
138,  9,133, 11,133, 12,137, 13,137, 14,137, 15,153,  9,149, 11,
149, 12,154, 14,154, 15,164, 11,164, 12,171, 14,171, 15,176, 17,
207, 17,223, 17,255, 17,101, 93,  0, 93,  5, 14,  1, 43,  1, 53,
 51, 50, 54, 63,  1,  1, 51,  9,  1, 51,  2,147, 78,148,124,147,
108, 76, 84, 51, 33,254, 59,195,  1, 94,  1, 94,195,104,200,122,
154, 72,134, 84,  4, 78,252,148,  3,108,  0,  1,  0, 88,  0,  0,
  3,219,  4, 96,  0,  9,  0,180, 64, 26,  8, 17,  2,  3,  2,  3,
 17,  7,  8,  7, 66,  8,169,  0,188,  3,169,  5,  8,  3,  1,  0,
  4,  1,  6, 10, 16,220,196, 50,196, 17, 57, 57, 49,  0, 47,236,
244,236, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237, 89, 34,
  1, 75,176, 11, 84, 75,176, 12, 84, 91, 88,189,  0, 10,  0, 64,
  0,  1,  0, 10,  0, 10,255,192, 56, 17, 55, 56, 89,  1, 75,176,
 19, 84, 88,189,  0, 10,255,192,  0,  1,  0, 10,  0, 10,  0, 64,
 56, 17, 55, 56, 89, 64, 66,  5,  2, 22,  2, 38,  2, 71,  2, 73,
  7,  5, 11,  8, 15, 11, 24,  3, 27,  8, 43,  8, 32, 11, 54,  3,
 57,  8, 48, 11, 64,  1, 64,  2, 69,  3, 64,  4, 64,  5, 67,  8,
 87,  3, 89,  8, 95, 11, 96,  1, 96,  2,102,  3, 96,  4, 96,  5,
 98,  8,127, 11,128, 11,175, 11, 27, 93,  0, 93, 19, 33, 21,  1,
 33, 21, 33, 53,  1, 33,113,  3,106,253, 76,  2,180,252,125,  2,
180,253,101,  4, 96,168,252,219,147,168,  3, 37,  0,  1,  1,  0,
254,178,  4, 23,  6, 20,  0, 36,  0,130, 64, 52, 25, 15, 21, 11,
  6, 37,  9, 26, 16, 21, 29, 11,  5, 32, 33,  3,  0, 11,169,  9,
  0,169,  1,192,  9, 21,169, 19,177, 37, 12,  9, 10,  5, 36, 22,
 25,  0, 29, 10,  5, 19,  2, 20,  0, 32, 25, 67, 10, 15,  5, 37,
 16,212, 60,196,252, 60,196, 50, 57, 57, 17, 18, 57, 17, 18, 57,
 57, 17, 18, 57, 57, 49,  0, 16,252,236,196,244,236, 16,238, 18,
 23, 57, 18, 57, 17, 57, 57, 17, 18, 57, 17, 18, 57, 57, 48,  1,
 75,176, 12, 84, 88,189,  0, 37,255,192,  0,  1,  0, 37,  0, 37,
  0, 64, 56, 17, 55, 56, 89,178,  0, 38,  1, 93,  5, 21, 35, 34,
 38, 61,  1, 52, 38, 43,  1, 53, 51, 50, 54, 61,  1, 52, 54, 59,
  1, 21, 35, 34,  6, 29,  1, 20,  6,  7, 30,  1, 29,  1, 20, 22,
 51,  4, 23, 62,249,169,108,142, 61, 61,143,107,169,249, 62, 68,
141, 86, 91,110,111, 90, 86,141,190,144,148,221,239,151,116,143,
115,149,240,221,147,143, 88,141,248,157,142, 25, 27,142,156,248,
141, 88,  0,  1,  1,  4,254, 29,  1,174,  6, 29,  0,  3,  0, 18,
183,  1,  0,177,  4,  0,  5,  2,  4, 16,212,236, 49,  0, 16,252,
204, 48,  1, 17, 35, 17,  1,174,170,  6, 29,248,  0,  8,  0,  0,
  0,  1,  1,  0,254,178,  4, 23,  6, 20,  0, 36,  0,158, 64, 54,
 31, 37, 27, 22, 12, 15,  8, 27, 11, 21, 25, 15,  4,  5, 32,  3,
  0, 25,169, 27,  0,169, 35,192, 27, 15,169, 17,177, 37, 28, 25,
 26, 21, 15,  1,  4,  0,  8, 26, 21, 35, 18,  4,  0, 26, 31, 21,
 67, 16,  0, 11,  4, 37, 16,212, 60,196, 50,252, 60,196, 17, 18,
 57, 57, 17, 18, 57, 17, 18, 57, 57, 17, 18, 57, 57, 49,  0, 16,
252,236,196,244,236, 16,238, 18, 23, 57, 17, 18, 57, 57, 17, 57,
 17, 57, 57, 17, 18, 57, 48,  1, 75,176, 10, 84, 88,189,  0, 37,
  0, 64,  0,  1,  0, 37,  0, 37,255,192, 56, 17, 55, 56, 89,  1,
 75,176, 14, 84, 88,189,  0, 37,255,192,  0,  1,  0, 37,  0, 37,
  0, 64, 56, 17, 55, 56, 89,178,  0, 38,  1, 93,  5, 51, 50, 54,
 61,  1, 52, 54, 55, 46,  1, 61,  1, 52, 38, 43,  1, 53, 51, 50,
 22, 29,  1, 20, 22, 59,  1, 21, 35, 34,  6, 29,  1, 20,  6, 43,
  1,  1,  0, 70,140, 85, 90,111,111, 90, 85,140, 70, 63,249,167,
108,142, 62, 62,142,108,167,249, 63,190, 86,143,248,156,142, 27,
 25,142,157,248,142, 87,143,147,221,240,149,115,143,116,151,239,
221,148,  0,  1,  0,217,  1,211,  5,219,  3, 49,  0, 29,  0, 35,
 64, 16,  1, 16, 27, 12,  0, 19,  4,156, 27, 19,156, 12, 30,  0,
 15, 30, 16,212,196, 49,  0, 16,212,252,212,236, 16,192, 17, 18,
 57, 57, 48,  1, 21,  6,  6, 35, 34, 39, 38, 39, 38, 39, 38, 35,
 34,  6,  7, 53, 54, 54, 51, 50, 23, 22, 23, 22, 23, 22, 51, 50,
 54,  5,219,105,179, 97,110,146, 11,  5,  7, 15,155, 94, 88,172,
 98,105,179, 97,110,147, 10,  5,  8, 14,155, 94, 86,169,  3, 49,
178, 79, 68, 59,  4,  2,  3,  5, 62, 77, 83,178, 79, 69, 60,  4,
  2,  3,  5, 62, 76,  0,255,255,  0, 16,  0,  0,  5,104,  7, 78,
  2, 39,  0, 36,  0,  0,  0,  0,  0,  7,  1,  3,  0,188,  1,117,
  0,  3,  0, 16,  0,  0,  5,104,  7,109,  0, 11,  0, 14,  0, 33,
  0,203, 64, 84, 12, 17, 13, 12, 27, 28, 27, 14, 17, 28, 27, 30,
 17, 28, 27, 29, 17, 28, 28, 27, 13, 17, 33, 15, 33, 12, 17, 14,
 12, 15, 15, 33, 32, 17, 15, 33, 31, 17, 33, 15, 33, 66, 12, 27,
 15, 13,  9,  3,193, 21,  9, 30,149, 13,  9,142, 32, 28, 30, 29,
 28, 24, 32, 31, 33, 13, 18,  6, 14, 24, 12,  6, 27,  0, 86, 24,
 28, 15,  6, 86, 18, 28, 33, 34, 16,212,196,212,236, 50, 16,212,
238, 50, 17, 57, 17, 57, 17, 18, 57, 17, 57, 57, 17, 18, 57, 57,
 49,  0, 47, 60,230,214,238, 16,212,238, 17, 18, 57, 57, 57, 48,
 75, 83, 88,  7, 16,  5,237,  7,  5,237,  7, 16,  8,237,  7, 16,
  5,237,  7, 16,  5,237,  7,  5,237,  7,  5,237,  7, 16,  8,237,
 89, 34,178, 32, 35,  1,  1, 93, 64, 32, 26, 12,115, 12,155, 12,
  3,  7, 15,  8, 27, 80, 35,102, 13,105, 14,117, 13,123, 14,121,
 28,121, 29,118, 32,118, 33,128, 35, 12, 93,  0, 93,  1, 52, 38,
 35, 34,  6, 21, 20, 22, 51, 50, 54,  3,  1, 33,  1, 46,  1, 53,
 52, 54, 51, 50, 22, 21, 20,  6,  7,  1, 35,  3, 33,  3, 35,  3,
 84, 89, 63, 64, 87, 88, 63, 63, 89,152,254,240,  2, 33,254, 88,
 61, 62,159,115,114,161, 63, 60,  2, 20,210,136,253, 95,136,213,
  6, 90, 63, 89, 87, 65, 63, 88, 88,254,243,253, 25,  3, 78, 41,
115, 73,115,160,161,114, 70,118, 41,250,139,  1,127,254,129,  0,
255,255,  0,115,254,117,  5, 39,  5,240,  2, 39,  0, 38,  0,  0,
  0,  0,  0,  7,  0,221,  1, 45,  0,  0,255,255,  0,201,  0,  0,
  4,139,  7,107,  2, 39,  0, 40,  0,  0,  0,  0,  0,  7,  1,  4,
  0,158,  1,117,255,255,  0,201,  0,  0,  5, 51,  7, 94,  2, 39,
  0, 49,  0,  0,  0,  0,  0,  7,  1,  5,  0,254,  1,117,255,255,
  0,115,255,227,  5,217,  7, 78,  2, 39,  0, 50,  0,  0,  0,  0,
  0,  7,  1,  3,  1, 39,  1,117,255,255,  0,178,255,227,  5, 41,
  7, 78,  2, 39,  0, 56,  0,  0,  0,  0,  0,  7,  1,  3,  0,238,
  1,117,255,255,  0,123,255,227,  4, 45,  6,102,  2, 39,  0, 68,
  0,  0,  0,  0,  0,  7,  0,141,  0, 82,  0,  0,255,255,  0,123,
255,227,  4, 45,  6,102,  2, 39,  0, 68,  0,  0,  0,  0,  0,  7,
  0, 67,  0, 82,  0,  0,255,255,  0,123,255,227,  4, 45,  6,102,
  2, 39,  0, 68,  0,  0,  0,  0,  0,  7,  0,215,  0, 82,  0,  0,
255,255,  0,123,255,227,  4, 45,  6, 16,  2, 39,  0, 68,  0,  0,
  0,  0,  0,  7,  0,142,  0, 82,  0,  0,255,255,  0,123,255,227,
  4, 45,  6, 55,  2, 39,  0, 68,  0,  0,  0,  0,  0,  7,  0,216,
  0, 82,  0,  0,255,255,  0,123,255,227,  4, 45,  7,  6,  2, 39,
  0, 68,  0,  0,  0,  0,  0,  7,  0,220,  0, 82,  0,  0,255,255,
  0,113,254,117,  3,231,  4,123,  2, 39,  0, 70,  0,  0,  0,  0,
  0,  7,  0,221,  0,143,  0,  0,255,255,  0,113,255,227,  4,127,
  6,102,  2, 39,  0, 72,  0,  0,  0,  0,  0,  7,  0,141,  0,139,
  0,  0,255,255,  0,113,255,227,  4,127,  6,102,  2, 39,  0, 72,
  0,  0,  0,  0,  0,  7,  0, 67,  0,139,  0,  0,255,255,  0,113,
255,227,  4,127,  6,102,  2, 39,  0, 72,  0,  0,  0,  0,  0,  7,
  0,215,  0,139,  0,  0,255,255,  0,113,255,227,  4,127,  6, 16,
  2, 39,  0, 72,  0,  0,  0,  0,  0,  7,  0,142,  0,139,  0,  0,
255,255,  0,144,  0,  0,  2,111,  6,102,  2, 39,  0,214,  0,  0,
  0,  0,  0,  7,  0,141,255, 29,  0,  0,255,255,255,199,  0,  0,
  1,166,  6,102,  2, 39,  0,214,  0,  0,  0,  0,  0,  7,  0, 67,
255, 29,  0,  0,255,255,255,222,  0,  0,  2, 92,  6,102,  2, 39,
  0,214,  0,  0,  0,  0,  0,  7,  0,215,255, 29,  0,  0,255,255,
255,244,  0,  0,  2, 70,  6, 16,  2, 39,  0,214,  0,  0,  0,  0,
  0,  7,  0,142,255, 29,  0,  0,255,255,  0,186,  0,  0,  4,100,
  6, 55,  2, 39,  0, 81,  0,  0,  0,  0,  0,  7,  0,216,  0,152,
  0,  0,255,255,  0,113,255,227,  4,117,  6,102,  2, 39,  0, 82,
  0,  0,  0,  0,  0,  7,  0,141,  0,115,  0,  0,255,255,  0,113,
255,227,  4,117,  6,102,  2, 39,  0, 82,  0,  0,  0,  0,  0,  7,
  0, 67,  0,115,  0,  0,255,255,  0,113,255,227,  4,117,  6,102,
  2, 39,  0, 82,  0,  0,  0,  0,  0,  7,  0,215,  0,115,  0,  0,
255,255,  0,113,255,227,  4,117,  6, 16,  2, 39,  0, 82,  0,  0,
  0,  0,  0,  7,  0,142,  0,115,  0,  0,255,255,  0,113,255,227,
  4,117,  6, 55,  2, 39,  0, 82,  0,  0,  0,  0,  0,  7,  0,216,
  0,115,  0,  0,255,255,  0,174,255,227,  4, 88,  6,102,  2, 39,
  0, 88,  0,  0,  0,  0,  0,  7,  0,141,  0,123,  0,  0,255,255,
  0,174,255,227,  4, 88,  6,102,  2, 39,  0, 88,  0,  0,  0,  0,
  0,  7,  0, 67,  0,123,  0,  0,255,255,  0,174,255,227,  4, 88,
  6,102,  2, 39,  0, 88,  0,  0,  0,  0,  0,  7,  0,215,  0,123,
  0,  0,255,255,  0,174,255,227,  4, 88,  6, 16,  2, 39,  0, 88,
  0,  0,  0,  0,  0,  7,  0,142,  0,123,  0,  0,  0,  1,  0, 57,
255, 59,  3,199,  5,213,  0, 11,  0, 39, 64, 20,  8,  4,185, 10,
  2,  0,129,  6,194, 12,  3, 89,  5,  1, 87,  9, 89,  7,  0, 12,
 16,212, 60,236,252, 60,236, 49,  0, 16,228,244,212, 60,236, 50,
 48,  1, 51, 17, 33, 21, 33, 17, 35, 17, 33, 53, 33,  1,168,176,
  1,111,254,145,176,254,145,  1,111,  5,213,254, 92,153,251,163,
  4, 93,153,  0,  0,  2,  0,195,  3,117,  3, 61,  5,240,  0, 11,
  0, 26,  0, 32, 64, 17,  6,195, 21,196,  0,195, 12,145, 27,  9,
 90, 18, 91,  3, 90, 24, 27, 16,220,236,252,236, 49,  0, 16,244,
236,252,236, 48,  1, 34,  6, 21, 20, 22, 51, 50, 54, 53, 52, 38,
 39, 50, 22, 23, 22, 22, 21, 20,  6, 35, 34, 38, 53, 52, 54,  2,
  0, 80,110,110, 80, 80,110,111, 79, 64,118, 43, 46, 46,185,134,
135,180,184,  5,111,111, 80, 79,109,109, 79, 79,112,129, 49, 46,
 45,114, 66,132,183,180,135,134,186,  0,  0,  2,  0,172,254,199,
  4, 35,  5,152,  0,  6,  0, 33,  0, 81, 64, 43, 19, 22, 20,  0,
 15, 12,  1, 11,  7,134,  8,136, 11, 16,134, 15,136, 12,185, 20,
 22, 11,185, 29, 31, 28,184, 22,140, 34, 28, 21,  0,  9, 30, 19,
 11, 15,  7,  4, 18, 25, 34, 16,220,236,212, 60,212, 60, 60,236,
 50, 50, 49,  0, 16,228,244, 60,196,236, 16,196,254,244,238, 16,
245,238, 18, 57, 17, 18, 57, 17, 18, 57, 48, 37, 17,  6,  6, 21,
 20, 22,  1, 21, 38, 38, 39,  3, 54, 54, 55, 21,  6,  6,  7, 17,
 35, 17, 38,  0, 17, 16,  0, 55, 17, 51, 19, 22, 22,  2,166,147,
164,164,  2, 16, 74,136, 68,  1, 70,137, 72, 65,137, 77,102,241,
254,247,  1,  9,241,102,  1, 73,137,131,  3, 88, 18,226,184,185,
226,  3,161,172, 41, 42,  3,252,160,  5, 42, 39,170, 30, 35,  7,
254,228,  1, 32, 20,  1, 51,  1,  1,  1,  2,  1, 50, 22,  1, 31,
254,225,  4, 33,  0,  1,  0,129,  0,  0,  4, 98,  5,240,  0, 27,
  0, 96, 64, 33,  7, 22,  8,  1,134,  0, 18, 10,169, 20,  8, 12,
  4,160,  0,148, 25,145, 16, 12,160, 14,  0, 13,  9, 11,  7, 28,
 19, 15, 21, 17, 28, 16,220, 60,204,204,252, 60,196,212,196, 49,
  0, 47,236, 50,244,228,236, 16,212, 60,238, 50, 16,238, 17, 57,
 57, 48,  1, 75,176, 12, 84, 88,189,  0, 28,255,192,  0,  1,  0,
 28,  0, 28,  0, 64, 56, 17, 55, 56, 89,180, 54,  1, 54,  2,  2,
  0, 93,  1, 21, 46,  1, 35, 34,  6, 29,  1, 33, 21, 33, 17, 33,
 21, 33, 53, 51, 17, 35, 53, 51, 53, 16, 54, 51, 50, 22,  4, 78,
 76,136, 61,148,116,  1,135,254,121,  2, 45,252, 31,236,199,199,
214,232, 61,151,  5,180,182, 41, 41,155,212,215,143,254, 47,170,
170,  1,209,143,238,  1,  5,243, 31,  0,  0,  2,  0, 92,255, 61,
  3,162,  5,240,  0, 11,  0, 62,  0,145, 64, 60, 47, 48, 42,  6,
  0, 23, 29, 48, 54,  4, 13, 39,138, 38, 13,138, 12, 42,198, 38,
197, 35, 16,198, 12,197, 60,145, 35, 63, 47,  6,  0, 23, 48,  4,
 19, 29, 45,  9, 54,  3, 19, 87, 57, 45, 87, 32,  9, 87, 12, 34,
 26, 57, 38, 34,  3, 87, 51, 63, 16,220,236,228,196,212,228,236,
212,236, 16,238, 17, 57, 17, 18, 57, 17, 23, 57, 57, 49,  0, 16,
196,244,228,236, 16,230,238, 16,238, 16,238, 17, 23, 57, 57, 57,
 17, 18, 57, 48,  1, 75,176, 10, 84, 75,176, 11, 84, 91, 75,176,
 12, 84, 91, 75,176, 14, 84, 91, 88,189,  0, 63,  0, 64,  0,  1,
  0, 63,  0, 63,255,192, 56, 17, 55, 56, 89,  1, 14,  1, 21, 20,
 22, 23, 62,  1, 53, 52, 38, 19, 21, 46,  1, 35, 34,  6, 21, 20,
 23, 22, 23, 30,  1, 21, 20,  6,  7, 30,  1, 21, 20,  6, 35, 34,
 38, 39, 53, 30,  1, 51, 50, 54, 53, 52, 47,  1, 46,  1, 53, 52,
 54, 55, 46,  1, 53, 52, 54, 51, 50, 22,  1,123, 63, 62,139,250,
 63, 62,143,204, 83,143, 56, 97,108,206, 26, 14,211,131, 92, 93,
 62, 57,204,173, 73,154, 88, 87,148, 58,102,113,221, 25,214,128,
 93, 91, 59, 59,200,166, 73,153,  3,168, 46, 90, 46, 76,133,135,
 45, 91, 46, 75,136,  2,147,164, 39, 39, 80, 71, 90,115, 15,  8,
119,154,101, 90,140, 53, 52,109, 64,142,168, 29, 29,164, 39, 39,
 84, 76,102,123, 14,120,153,102, 91,143, 49, 44,112, 69,130,159,
 29,  0,  0,  1,  1, 51,  1,209,  3,133,  4, 33,  0, 11,  0, 18,
183,  9,199,  3, 12,  6, 92,  0, 12, 16,212,236, 49,  0, 16,212,
236, 48,  1, 52, 54, 51, 50, 22, 21, 20,  6, 35, 34, 38,  1, 51,
173,126,124,171,172,125,125,172,  2,250,124,171,171,124,125,172,
172,  0,  0,  1,  0,158,255, 59,  4, 57,  5,213,  0, 13,  0, 37,
 64, 18,  8,  2,  4,193,  0,129,  6,  2, 14,  0,  7, 93,  5,  3,
 93,  1, 11, 14, 16,212,212,252,220,236, 57, 49,  0, 16,196, 50,
244,236, 17, 57, 48,  1, 33, 17, 35, 17, 35, 17, 35, 17, 38, 38,
 53, 52, 36,  2,121,  1,192,141,190,142,215,235,  1,  4,  5,213,
249,102,  6, 31,249,225,  3, 78, 17,221,184,190,232,  0,  0,  1,
  0,186,255,227,  4,172,  6, 20,  0, 47,  0,154, 64, 48, 45, 39,
 33, 12,  4,  6, 13, 32,  0,  4, 42, 22,134, 23, 26,185, 19, 42,
185,  3,151, 19,140, 46, 12,  9, 13, 29, 32, 33, 39,  9,  8, 36,
 39,  8,  6, 29,  8, 36, 16, 22, 45,  8, 16,  0, 70, 48, 16,252,
196,252,204, 16,198,238,212,238, 16,238, 17, 57, 57, 18, 57, 18,
 57, 49,  0, 47,228,254,238, 16,254,213,238, 18, 23, 57, 23, 57,
 48, 64, 64, 15,  5, 15,  6, 15,  7, 15, 39, 15, 40,138, 12,138,
 13,  7, 10,  6, 10,  7, 10, 11, 10, 12, 10, 13, 10, 31, 13, 32,
 10, 33, 12, 34,  4, 38, 25, 13, 25, 31, 25, 32, 58, 32, 58, 33,
 77, 31, 77, 32, 73, 33, 73, 34,106, 31,106, 32,165,  6,165,  7,
166, 32, 24, 93,  1, 93, 19, 52, 54, 51, 50, 22, 23, 14,  1, 21,
 20, 22, 31,  1, 30,  1, 21, 20,  6, 35, 34, 38, 39, 53, 30,  1,
 51, 50, 54, 53, 52, 38, 47,  1, 46,  1, 53, 52, 54, 55, 46,  1,
 35, 34,  6, 21, 17, 35,186,239,218,208,219,  3,151,168, 58, 65,
 57,166, 96,225,211, 64,136, 73, 80,140, 65,116,120, 59,101, 92,
 96, 87,167,151,  8,131,113,130,136,187,  4,113,200,219,232,224,
  8,115, 96, 47, 81, 42, 37,106,142,100,172,183, 25, 24,164, 30,
 29, 95, 91, 63, 84, 62, 55, 59,135, 91,127,172, 29,103,112,139,
131,251,147,  0,  0,  4,  1, 27,  0,  0,  6,229,  5,205,  0, 23,
  0, 47,  0, 56,  0, 76,  0, 96, 64, 54, 69, 66, 67, 63, 50,201,
 72, 48,201, 57, 74, 67,202, 12, 57,202,  0,201, 24,200, 12,201,
 36, 72, 69, 51, 48,  4, 49, 66, 60, 63, 57, 54, 73, 49, 96, 75,
 54, 96, 67, 60, 94, 18,  9, 30, 75, 94,  6,  9, 30, 95, 42, 77,
 16,220,228,252,236, 16,254,253,196,238, 16,238, 50, 17, 57, 57,
 18, 57, 18, 23, 57, 49,  0, 47,238,246,254,237, 16,237, 50, 16,
238,214,238, 57, 18, 57, 57, 48,  1, 34,  6,  7,  6,  6, 21, 20,
 22, 23, 22, 22, 51, 50, 54, 55, 54, 54, 53, 52, 38, 39, 38, 38,
 39, 50,  4, 23, 22, 18, 21, 20,  2,  7,  6,  4, 35, 34, 36, 39,
 38,  2, 53, 52, 18, 55, 54, 36, 19, 35, 17, 51, 50, 54, 53, 52,
 38, 39, 50, 22, 21, 20,  6,  7, 22, 22, 23, 23, 35, 39, 38, 38,
 35, 35, 17, 35, 17,  4,  0,131,226, 94, 94, 96, 96, 94, 94,226,
131,132,227, 94, 93, 93, 94, 92, 94,227,132,152,  1,  7,109,109,
108,108,109,109,254,249,152,152,254,249,109,109,108,108,109,109,
  1,  7,125,123,123,110, 87, 88,102,176,174,105, 96, 24, 67, 46,
137,172,129, 59, 73, 54, 66,155,  5,102, 94, 94, 94,229,130,129,
227, 94, 94, 95, 95, 94, 93,226,131,133,227, 93, 94, 94,103,110,
109,109,254,250,154,152,254,251,109,109,110,110,109,109,  1,  5,
152,154,  1,  6,109,109,110,254, 98,254,236, 62, 75, 76, 63,103,
119,121, 86,112, 17,  8, 77, 73,223,209, 96, 51,254,156,  3, 68,
  0,  3,  1, 27,  0,  0,  6,229,  5,205,  0, 23,  0, 47,  0, 73,
  0, 67, 64, 38, 61,203, 62, 58,204, 65,202, 36, 49,203, 48, 52,
204, 71,202, 24,201,  0,200, 36,201, 12, 55, 97, 68, 61, 48, 94,
 42,  9,  6, 68, 94, 30,  9,  6, 18, 74, 16,220,204,252,236, 16,
254,237, 50, 16,238, 49,  0, 47,238,246,254,253,238,214,238, 16,
253,238,214,238, 48,  1, 50,  4, 23, 22, 18, 21, 20,  2,  7,  6,
  4, 35, 34, 36, 39, 38,  2, 53, 52, 18, 55, 54, 36, 23, 34,  6,
  7,  6,  6, 21, 20, 22, 23, 22, 22, 51, 50, 54, 55, 54, 54, 53,
 52, 38, 39, 38, 38, 23, 21, 38, 38, 35, 34,  6, 21, 20, 22, 51,
 50, 54, 55, 21,  6,  6, 35, 34, 38, 53, 52, 54, 51, 50, 22,  4,
  0,152,  1,  7,109,109,108,108,109,109,254,249,152,152,254,249,
109,109,108,108,109,109,  1,  7,152,131,226, 94, 94, 96, 96, 94,
 94,226,131,132,227, 94, 93, 93, 94, 92, 94,227,167, 66,130, 66,
149,167,171,155, 64,122, 66, 67,137, 70,216,251,251,216, 73,136,
  5,205,110,109,109,254,250,154,152,254,251,109,109,110,110,109,
109,  1,  5,152,154,  1,  6,109,109,110,103, 94, 94, 94,229,130,
129,227, 94, 94, 95, 95, 94, 93,226,131,133,227, 93, 94, 94,245,
129, 33, 32,175,157,159,174, 31, 34,127, 29, 28,244,208,209,242,
 28,  0,  0,  2,  1, 39,  3,147,  6, 70,  5,213,  0, 12,  0, 20,
  0, 62, 64, 33,  1,  6,  7, 16, 10,  4, 18, 14,  9,  3,  6,201,
 13,  2,  0,129, 21,  1,  9,  5, 98,  3,  9, 98, 11, 13, 99, 15,
 98, 19, 99, 17, 21, 16,212,228,252,228,212,236,212,236, 17, 57,
 49,  0, 16,244, 60, 60,236, 23, 50,212, 60, 60,196, 17, 57, 48,
  1, 19, 19, 51, 17, 35, 17,  3, 35,  3, 17, 35, 17, 35, 21, 35,
 17, 35, 17, 35, 53,  4, 74,174,164,170,113,195, 55,203,114,113,
203,114,201,  5,213,255,  0,  1,  0,253,190,  1,228,254,209,  1,
 47,254, 28,  2, 66, 94,254, 28,  1,228, 94,  0,  0,  1,  1,115,
  4,238,  3, 82,  6,102,  0,  3,  0, 49, 64,  9,  2,180,  0,179,
  4,  3, 68,  1,  4, 16,212,236, 49,  0, 16,244,236, 48,  0, 75,
176,  9, 84, 75,176, 14, 84, 91, 88,189,  0,  4,255,192,  0,  1,
  0,  4,  0,  4,  0, 64, 56, 17, 55, 56, 89,  1, 51,  1, 35,  2,
139,199,254,186,153,  6,102,254,136,  0,  0,  2,  0,215,  5, 70,
  3, 41,  6, 16,  0,  3,  0,  7,  0,146, 64, 14,  6,  2,206,  4,
  0,205,  8,  1,100,  0,  5,100,  4,  8, 16,220,252,212,236, 49,
  0, 16,252, 60,236, 50, 48,  0, 75,176, 10, 84, 75,176, 13, 84,
 91, 88,189,  0,  8,  0, 64,  0,  1,  0,  8,  0,  8,255,192, 56,
 17, 55, 56, 89,  1, 75,176, 12, 84, 75,176, 13, 84, 91, 75,176,
 14, 84, 91, 75,176, 23, 84, 91, 88,189,  0,  8,255,192,  0,  1,
  0,  8,  0,  8,  0, 64, 56, 17, 55, 56, 89,  1, 75,176, 15, 84,
 75,176, 25, 84, 91, 88,189,  0,  8,  0, 64,  0,  1,  0,  8,  0,
  8,255,192, 56, 17, 55, 56, 89, 64, 17, 96,  1, 96,  2, 96,  5,
 96,  6,112,  1,112,  2,112,  5,112,  6,  8, 93,  1, 51, 21, 35,
 37, 51, 21, 35,  2, 94,203,203,254,121,203,203,  6, 16,202,202,
202,  0,  0,  1,  0,217,  0, 39,  5,219,  4,221,  0, 19,  0, 62,
 64, 34, 13, 12, 10,  3,  2,207,  4,  0,156,  6, 12,207, 14, 10,
156, 18,  6, 16,  8, 20, 18, 14, 13, 12,  8,  4,  3,  2,  8,  9,
  5, 15,  0, 20, 16,220, 60,196, 50, 23, 57, 49,  0, 16,212, 60,
204, 50,252, 60,236, 16,254, 60,236, 57, 17, 18, 57, 48, 19, 33,
  1, 23,  7, 33, 21, 33,  7, 33, 21, 33,  1, 39, 55, 33, 53, 33,
 55, 33,217,  3,  4,  1,  0,125,174,  1, 47,254, 72,195,  2,123,
252,250,254,254,125,174,254,213,  1,182,195,253,135,  3,162,  1,
 59,102,213,168,240,170,254,199,102,211,170,240,  0,  2,  0,  8,
  0,  0,  7, 72,  5,213,  0, 15,  0, 19,  0,135, 64, 57, 17, 17,
 14, 15, 14, 16, 17, 15, 15, 14, 13, 17, 15, 14, 12, 17, 14, 15,
 14, 66,  5,149,  3, 11,149, 17,  1,149, 16,149,  0,129, 17,  7,
149,  3,173, 13,  9, 17, 16, 15, 13, 12,  5, 14, 10,  0,  4,  8,
  6,  2, 28, 18, 10, 14, 20, 16,212,212, 60,236, 50,212,196,196,
 17, 18, 23, 57, 49,  0, 47, 60,236,236,196,244,236,236, 16,238,
 16,238, 48, 75, 83, 88,  7, 16,  5,237,  7,  5,237,  7, 16,  5,
237,  7, 16,  5,237, 89, 34,178,128, 21,  1,  1, 93, 64, 19,103,
 17,119, 16,119, 17,134, 12,133, 16,150, 17,144, 21,160, 21,191,
 21,  9, 93,  1, 21, 33, 17, 33, 21, 33, 17, 33, 21, 33, 17, 33,
  3, 35,  1, 23,  1, 33, 17,  7, 53,253, 27,  2,199,253, 57,  2,
248,252, 61,253,240,160,205,  2,113,139,254,182,  1,203,  5,213,
170,254, 70,170,253,227,170,  1,127,254,129,  5,213,158,252,240,
  3, 16,  0,  3,  0,102,255,186,  5,229,  6, 23,  0,  9,  0, 19,
  0, 43,  0,158, 64, 60, 29, 31, 26, 13, 43, 44, 19, 10,  1,  0,
  4, 13, 41, 38, 32, 20, 13,  4, 42, 38, 30, 26,  4,149, 38, 13,
149, 26,145, 38,140, 44, 43, 44, 42, 20, 23, 16, 32, 30, 35, 19,
 10,  1,  0,  4, 29, 41, 16,  7, 31,  7, 25, 35, 51, 16, 25, 23,
 16, 44, 16,252,236,252,236,192, 17, 18, 57, 57, 23, 57, 18, 57,
 57, 17, 18, 57, 57, 17, 57, 49,  0, 16,228,244,236, 16,238, 16,
192, 16,192, 17, 18, 57, 57, 18, 57, 18, 23, 57, 18, 57, 17, 18,
 57, 57, 48, 64, 42, 87,  0, 90, 21, 87, 25, 85, 33,106, 21,101,
 33,123, 21,118, 28,117, 33,  9, 70, 19, 89,  0, 86, 19,106,  0,
100, 19,100, 28,106, 40,124,  0,115, 19,118, 28,122, 40, 11, 93,
  1, 93,  9,  1, 30,  1, 51, 50,  0, 17, 52, 38, 39, 46,  1, 35,
 34,  0, 17, 20, 22, 23,  7, 38,  2, 53, 16,  0, 33, 50, 22, 23,
 55, 23,  7, 22, 18, 21, 16,  0, 33, 34, 38, 39,  7, 39,  4,182,
253, 51, 62,161, 95,220,  1,  1, 39,121, 61,161, 95,220,254,253,
 39, 39,134, 78, 79,  1,121,  1, 59,130,221, 87,162,102,170, 78,
 80,254,136,254,198,128,221, 91,162,103,  4, 88,252,178, 64, 67,
  1, 72,  1, 26,112,184,184, 64, 67,254,184,254,229,112,188, 68,
158,102,  1,  8,160,  1, 98,  1,165, 77, 75,191, 89,198,103,254,
246,158,254,159,254, 91, 75, 75,191, 88,  0,  3,  0,221,  0,221,
  5,207,  3,238,  0, 11,  0, 23,  0, 47,  0,255, 64, 29, 45, 27,
 21,  9, 33,  3,  0, 36, 24,  4, 21, 15, 39, 33, 21, 27, 15, 33,
 48, 12,  0, 36, 24, 18,  6, 42, 18, 30, 48, 16,212,196,212,196,
 17, 57, 57, 57, 57, 49,  0, 16,212,196,212,196, 16,192, 17, 18,
 23, 57, 18, 57, 17, 18, 57, 48, 64,190,  5,  2,  5,  3,  5,  4,
  0,  5,  0,  6,  0,  7,  5,  8,  5,  9,  5, 10, 10, 16, 15, 17,
 15, 18, 15, 19, 10, 20, 21,  2, 21,  3, 21,  4, 16,  5, 16,  6,
 16,  7, 21,  8, 21,  9, 21, 10, 26, 14, 26, 15, 26, 16, 31, 17,
 31, 18, 31, 19, 26, 20, 26, 21, 26, 22, 36,  2, 36,  3, 36,  4,
 32,  5, 32,  6, 32,  7, 36,  8, 36,  9, 36, 10, 42, 14, 42, 15,
 42, 16, 47, 17, 47, 18, 47, 19, 42, 20, 42, 21, 42, 22, 53,  2,
 53,  3, 53,  4, 48,  5, 48,  6, 48,  7, 53,  8, 53,  9, 53, 10,
 58, 14, 58, 15, 58, 16, 63, 17, 63, 18, 63, 19, 58, 20, 58, 21,
 58, 22, 69,  2, 69,  3, 69,  4, 64,  5, 64,  6, 64,  7, 69,  8,
 69,  9, 69, 10, 74, 14, 74, 15, 74, 16, 79, 17, 79, 18, 79, 19,
 74, 20, 74, 21, 74, 22, 86,180, 31,176, 32,176, 33,176, 34,176,
 38,176, 39,176, 40,180, 41,  8, 93,  1, 93,  1, 30,  1, 51, 50,
 54, 53, 52, 38, 35, 34,  6,  7, 46,  1, 35, 34,  6, 21, 20, 22,
 51, 50, 54, 23, 14,  1, 35, 34, 38, 53, 52, 54, 51, 50, 22, 23,
 62,  1, 51, 50, 22, 21, 20,  6, 35, 34, 38,  3,147, 49,134, 84,
101,128,118, 89, 82,133,196, 49,133, 85,102,127,118, 89, 82,134,
144, 70,157, 94,136,186,167,134, 95,153, 72, 68,158, 97,134,188,
167,134, 94,149,  2, 47, 88, 90,135,105,101,134,135, 55, 88, 88,
132,106,101,134,136, 22,135,127,223,166,175,216,126,138,138,131,
225,167,175,214,119,  0,  0,  2,  0,217,  0,  0,  5,219,  5,  4,
  0, 11,  0, 15,  0, 46, 64, 24,  5,208,  7,  3,156,  0,208,  9,
  1, 12,156, 14, 13,  2, 21,  4,  0, 23, 12,  8, 21, 10,  6, 16,
 16,212, 60,236, 50,252, 60,236, 50, 49,  0, 47,236,212, 60,236,
252, 60,236, 48,  1, 17, 33, 21, 33, 17, 35, 17, 33, 53, 33, 17,
  1, 33, 21, 33,  3,174,  2, 45,253,211,168,253,211,  2, 45,253,
211,  5,  2,250,254,  5,  4,254,125,170,254,125,  1,131,170,  1,
131,251,166,170,  0,  2,  0,217,  0,  0,  5,219,  4,168,  0,  6,
  0, 10,  0, 84, 64, 46,  2,156,  3,  4,  3,  1,156,  0,  1,  4,
  4,  3,  1,156,  2,  1,  5,  6,  5,  0,156,  6,  5, 66,  5,  4,
  2,  1,  0,  5,  3,209,  6,167,  7,156,  9,  1,  8,  2,  0, 36,
  7,  4, 35, 11, 16,252, 60,236, 50, 50, 57, 49,  0, 47,236,244,
236, 23, 57, 48, 75, 83, 88,  7,  4,237,  7, 16,  8,237,  7, 16,
  8,237,  7, 16,  4,237, 89, 34,  9,  2, 21,  1, 53,  1,  1, 33,
 21, 33,  5,219,252, 64,  3,192,250,254,  5,  2,250,254,  5,  2,
250,254,  3,248,254,235,254,238,178,  1,112,170,  1,111,252,  2,
170,  0,  0,  2,  0,217,  0,  0,  5,219,  4,168,  0,  6,  0, 10,
  0, 86, 64, 47,  6,156,  0,  6,  3,  4,  3,  5,156,  4,  4,  3,
  0,156,  1,  2,  1,  6,156,  5,  6,  2,  2,  1, 66,  6,  5,  3,
  2,  0,  5,  4,209,  1,167,  7,156,  8,  6,  7,  2, 36,  9,  4,
  0, 35, 11, 16,252, 60, 60,236, 50, 57, 49,  0, 47,236,244,236,
 23, 57, 48, 75, 83, 88,  7, 16,  8,237,  7, 16,  4,237,  7, 16,
  4,237,  7, 16,  8,237, 89, 34, 19, 53,  1, 21,  1, 53,  1,  1,
 21, 33, 53,217,  5,  2,250,254,  3,193,  1, 65,250,254,  3,248,
176,254,145,170,254,144,178,  1, 18,253,199,170,170,  0,  0,  1,
  0, 82,  0,  0,  4,195,  5,213,  0, 24,  0,198, 64, 70, 16,  2,
 17, 22, 17, 15,  2, 14, 15, 22, 22, 17, 15,  2, 16, 15,  8, 13,
  8, 14,  2, 13, 13,  8, 66, 15, 11,  9,  4,  0,211, 23,  6, 18,
 11,211, 20,  9, 16, 13,129,  2, 12,  9, 14,  3,  5, 22, 15,  3,
 21, 18, 16,  3,  0, 17,102, 19,  0,101,  1, 28, 13,102, 10,  5,
101,  7,  3, 25, 16,212, 60,236, 50,236,252,236, 50,236, 18, 23,
 57, 18, 57, 57, 17, 23, 57, 49,  0, 47,228, 50,212, 60,236, 50,
212, 60,236, 50, 17, 18, 57, 48, 75, 83, 88,  7, 16,  5,237,  7,
 16,  8,237,  7, 16,  8,237,  7, 16,  5,237, 89, 34,  1, 75,176,
 12, 84, 88,189,  0, 25,255,192,  0,  1,  0, 25,  0, 25,  0, 64,
 56, 17, 55, 56, 89, 64, 40,134, 15,144, 15,166, 15,160, 15,181,
 15,  5, 39, 12, 39, 13, 39, 14, 41, 16, 40, 17, 40, 18, 55, 14,
 57, 16,135, 12,136, 18,166, 13,165, 14,170, 16,169, 17, 14, 93,
  0, 93,  1, 33, 17, 35, 17, 33, 53, 33, 53, 39, 33, 53, 33,  1,
 51,  9,  1, 51,  1, 33, 21, 33,  7, 21, 33,  4,141,254, 99,201,
254, 96,  1,160, 84,254,180,  1,  8,254,195,190,  1,123,  1,121,
191,254,194,  1,  8,254,181, 84,  1,159,  1,199,254, 57,  1,199,
123, 51,155,123,  2, 74,253, 68,  2,188,253,182,123,155, 51,  0,
  0,  1,  0,174,254, 86,  4,229,  4, 96,  0, 32,  0, 77, 64, 37,
 19, 25, 31,  3, 22,  6,  3,  9, 12,  3,  1, 18, 15,  6,135, 28,
 22,140, 10,  1,188,  0,189, 33, 25,  9, 18,  9,  8, 11, 78, 31,
  2,  8,  0, 70, 33, 16,252,236, 50,244,236,196, 18, 57, 49,  0,
 16,228,228, 50,244, 60,236,220,196, 17, 23, 57, 17, 18, 23, 57,
 48,182, 31, 34, 96, 34,207, 34,  3,  1, 93, 19, 17, 51, 17, 20,
 22, 51, 50, 54, 53, 17, 51, 17, 20, 22, 51, 50, 54, 55, 21, 14,
  1, 35, 34, 38, 39, 14,  1, 35, 34, 38, 39, 17,174,184,138,135,
148,149,184, 35, 37,  9, 32, 28, 41, 73, 35, 69, 82, 15, 50,145,
 98,102,143, 42,254, 86,  6, 10,253, 72,145,148,168,168,  2,141,
252,162, 60, 57, 11, 12,148, 23, 22, 78, 80, 79, 79, 78, 78,253,
215,  0,  0,  2,  0,104,255,231,  3,193,  5, 45,  0, 29,  0, 41,
  0, 98, 64, 25,  0, 39, 33,  9, 27,  6, 39, 21,  6, 15, 33, 27,
 15, 21,213, 42, 12, 36,  3,  0, 30, 18, 36, 24, 42, 16,212,204,
220,204, 57, 57, 17, 57, 49,  0, 16,228,204,220,204, 16,206, 16,
206, 17, 18, 57, 17, 18, 57, 48,  1, 75,176, 12, 84, 75,176, 11,
 84, 91, 75,176, 14, 84, 91, 75,176, 16, 84, 91, 75,176, 20, 84,
 91, 88,189,  0, 42,  0, 64,  0,  1,  0, 42,  0, 42,255,192, 56,
 17, 55, 56, 89,  1, 62,  1, 53, 52, 38, 35, 34,  6, 35, 34, 38,
 53, 52, 54, 51, 50, 18, 17, 16,  0, 35, 34, 38, 53, 52, 18, 51,
 50, 22,  7, 52, 38, 35, 34,  2, 21, 20, 22, 51, 50, 18,  2,244,
 15, 15, 73, 72, 55,144, 36, 36, 48,144,101,180,214,254,223,213,
152,203,221,162,101,130, 11, 87, 79,109,141, 86, 80,109,141,  2,
109, 87,163, 75,129,131,116, 44, 31, 62, 98,254,202,254,249,254,
177,254, 70,216,163,198,  1,  1, 91,224,116,125,254,254,207,116,
123,  1,  4,  0,  0,  1,  0, 25,254,119,  5, 59,  5,193,  0, 11,
  0, 93, 64, 20, 10,  4, 12,  2,  5,  7,  2,  0,  7, 12, 10,  5,
  4,  3,  1,  0,  6,  6,  8, 12, 16,212,196, 23, 57, 49,  0, 16,
196,212,204, 16,206, 17, 18, 57, 57, 48, 64, 48, 81,  3, 86,  5,
 80,  5, 90, 10,115,  3,112,  3,118,  4,117,  5,112,  5,122, 10,
128,  3,128,  5, 12, 90,  9,127,  2,127,  3,112,  5,112,  6,123,
  9,116, 11,143,  2,143,  3,128,  5,128,  6, 11, 93,  1, 93, 19,
 33, 21, 33,  9,  1, 33, 21, 33, 53,  9,  1, 55,  4,234,252, 65,
  2,160,253, 74,  3,239,250,222,  2,213,253, 73,  5,193,193,253,
 51,253,  4,192,149,  3, 33,  2,227,  0,  0,  1,  0,156,254,119,
  5,113,  5,193,  0,  7,  0, 30, 64, 15,  6,  2,215,  4,214,  0,
175,  8,  3,103,  1,  5,103,  0,  8, 16,212,236,212,236, 49,  0,
 16,252,236,236, 50, 48, 19, 33, 17, 35, 17, 33, 17, 35,156,  4,
213,240,253, 10,239,  5,193,248,182,  6,125,249,131,  0,  0,  1,
255,225,255,240,  4,170,  4, 47,  0, 35,  0,203, 64, 49, 11,  2,
 21, 31, 30,  3,  0,  8,218, 15, 26, 22,  0,217, 34,216, 15,213,
 24, 12, 30, 27, 26, 25, 24, 23,  6, 36, 18,  1,  0, 11,  2,  4,
 35, 22, 21,  5, 34, 31, 18, 12, 35, 18,104,  5, 35, 31, 36, 16,
212,212,212,236, 18, 57, 17, 18, 57, 18, 57, 57, 17, 23, 57, 17,
 18, 23, 57, 49,  0, 47, 60,228,244,236, 50, 50, 16,238, 17, 23,
 57, 57, 57, 48,  1, 75,176, 10, 84, 88,189,  0, 36,255,192,  0,
  1,  0, 36,  0, 36,  0, 64, 56, 17, 55, 56, 89, 64, 86, 24, 30,
 24, 31,  2,  9,  0,  9,  1, 13,  2, 13,  3, 15,  4, 15,  5, 15,
  6, 15,  7, 15,  8, 15,  9, 15, 10, 15, 11, 15, 12, 15, 13, 15,
 14, 15, 15, 15, 16, 15, 17, 15, 18, 15, 19, 14, 20, 13, 21,  9,
 22, 11, 23,  8, 24, 15, 24, 13, 25,  8, 26,  9, 35, 17,  0, 17,
  1, 22,  2, 22,  3, 23, 20, 22, 21, 17, 22, 23, 23, 28, 24, 28,
 25, 17, 35, 40, 93,  0, 93,  1, 35,  3, 14,  1, 21, 20, 22, 51,
 50, 54, 55,  7, 14,  1, 35, 34, 38, 53, 52, 54, 55, 19, 33,  3,
 35, 19, 35, 34,  6,  7, 35, 62,  1, 51, 33,  4,135,182,105, 15,
 15, 47, 55, 17, 46, 37, 30, 30, 55, 26,118,121, 21, 34, 80,254,
186,194,181,195, 41, 54, 60,  9,160, 28,143,165,  3,121,  3,145,
254, 25, 74, 92, 22, 58, 49,  5,  5,141,  8,  8,102,100, 46,144,
161,  1,120,252,111,  3,145, 64, 69,166,125,  0,  0,  1,  0, 47,
254,141,  3,250,  6, 14,  0, 37,  0, 38, 64, 20, 32,219,  0, 26,
 13,219, 19, 26,220,  7,177, 38, 10,105, 23,106, 29,105,  4, 38,
 16,220,236,252,236, 49,  0, 16,252,236,220,228, 16,222,228, 48,
  1, 50, 19, 54, 55, 18, 18, 51, 50, 22, 21, 20,  6, 35, 34, 38,
 39, 38, 38, 35, 34,  3,  6,  7,  2,  2, 35, 34, 38, 53, 52, 54,
 51, 50, 22, 23, 22, 22,  1, 55,106, 14,  2,  1, 12,190,202, 80,
100, 64, 55, 42, 56, 12,  6,  9, 16,107, 14,  4,  4, 17,189,196,
 79,101, 68, 61, 33, 48, 15, 10, 10,254,250,  2,176,108, 57,  2,
  3,  1,188, 84, 65, 54, 63, 38, 35, 15, 72,253,149,193,110,254,
 33,254, 98, 83, 65, 56, 63, 29, 28, 18, 83,  0,  0,  3,  0,115,
  1,213,  3, 59,  5,240,  0,  3,  0, 30,  0, 41,  0, 95, 64, 51,
 40,  7, 37,  4, 31, 18, 24, 16,  2,227,  0, 31,221, 16,  0,225,
 37,221,  5, 10, 25,223, 24,222, 21,221, 10,224, 28,145, 42,  0,
 24, 13, 31, 16, 34,  6,  2,  1, 40, 17,  6,107,  4,108, 24, 34,
107, 13, 42, 16,220,236,204,252,236, 50, 50,192,192, 17, 18, 57,
 57, 17, 18, 57, 49,  0, 16,244,228,252,244,236, 16,196,238,237,
214,238, 16,238, 17, 18, 57, 18, 57, 17, 57, 57, 48, 19, 33, 21,
 33,  1, 17, 35, 53,  6,  6, 35, 34, 38, 53, 52, 54, 51, 51, 53,
 52, 38, 35, 34,  6,  7, 53, 54, 54, 51, 50, 22,  5, 34,  6, 21,
 20, 22, 51, 50, 54, 53, 53,139,  2,176,253, 80,  2,174,149, 44,
144, 93,128,152,191,188,182,117,117, 62,136, 68, 73,145, 69,183,
179,254,236,161,126, 98, 82,104,130,  2, 80,123,  2,184,254, 64,
112, 63, 68,135,113,135,138,  4, 91, 91, 34, 34,127, 28, 28,176,
240, 67, 79, 64, 77,144,114, 29,  0,  3,  0, 96,  1,213,  3,100,
  5,240,  0,  3,  0, 15,  0, 27,  0, 46, 64, 25,  2,227,  0,225,
 22,221, 10,224, 16,221,  4,145, 28,  0, 19, 13,  1, 25,107,  7,
108, 19,107, 13, 28, 16,220,236,252,236, 57, 17, 18, 57, 49,  0,
 16,244,236,244,236,252,236, 48, 19, 33, 21, 33,  1, 50, 22, 21,
 20,  6, 35, 34, 38, 53, 52, 54, 23, 34,  6, 21, 20, 22, 51, 50,
 54, 53, 52, 38,139,  2,176,253, 80,  1, 88,179,206,206,179,179,
208,208,179,105,126,127,104,105,125,124,  2, 80,123,  4, 27,221,
191,191,219,220,190,191,221,115,161,136,133,160,160,133,137,160,
  0,  1,  0, 78,  0,  0,  5,207,  5,231,  0, 31,  0, 64, 64, 34,
  9,229, 25,145, 18, 15,  3,  3,  0,229, 16,  1, 17, 32, 22, 19,
 15, 12, 31,  6,  2,  1,  0,  2,109,  6, 28, 28, 15,109, 12, 28,
 22, 32, 16,212,236,236,212,236,236,192,192, 17, 18, 57, 17, 18,
 57, 17, 18, 57, 49,  0, 47, 60,236, 23, 50,244,236, 48, 37, 21,
 33, 53, 54, 18, 53, 52,  0, 35, 34,  0, 21, 20, 18, 23, 21, 33,
 53, 33, 38,  2, 53, 16,  0, 33, 32,  0, 17, 20,  2,  7,  5,207,
253,168,177,198,254,248,216,216,254,247,199,178,253,168,  1, 63,
158,145,  1,127,  1, 49,  1, 47,  1,129,142,161,178,178,178, 97,
  1, 76,202,240,  1, 34,254,221,239,202,254,180, 97,178,178,139,
  1, 42,184,  1, 62,  1,138,254,119,254,203,194,254,216,141,  0,
  0,  3,  0,123,255,227,  7,111,  4,123,  0,  6,  0, 51,  0, 62,
  1,  3, 64, 67, 39, 45, 37, 61, 14, 13,  0, 52,169, 37, 22,134,
 21,136, 18,  0,169, 14, 58, 18,185, 28, 25, 46,134, 45,186, 42,
  3,185, 14,187,  7, 49, 10,184, 31, 25,140, 37, 63, 52, 55, 38,
  6, 15,  0, 37, 55, 28,  7, 38, 15, 21,  0,  8, 13, 61, 38,  8,
 15, 45, 55,  8, 34, 69, 63, 16,252,236,204,212,252, 60,212,236,
196, 17, 18, 57, 57, 17, 57, 17, 18, 57, 17, 18, 57, 49,  0, 16,
196,228, 50,244, 60,196,228,252, 60,244,236, 16,196,238, 50, 16,
238, 16,244,238, 16,238, 17, 57, 17, 57, 17, 18, 57, 48, 64,129,
 48, 43, 48, 44, 48, 45, 48, 46, 48, 47, 48, 48, 64, 43, 64, 44,
 64, 45, 64, 46, 64, 47, 64, 48, 80, 43, 80, 44, 80, 45, 80, 46,
 80, 47, 80, 48,133, 43,133, 48,128, 64,144, 64,160, 64,176, 64,
192, 64,208, 64,224, 64,224, 64,240, 64, 29, 63,  0, 63,  6, 63,
 13, 63, 14, 63, 15,  5, 48, 44, 48, 45, 48, 46, 48, 47, 64, 44,
 64, 45, 64, 46, 64, 47, 80, 44, 80, 45, 80, 46, 80, 47,111,  0,
111,  6,111, 13,111, 14,111, 15, 96, 44, 96, 45, 96, 46, 96, 47,
112, 44,112, 45,112, 46,112, 47,128, 44,128, 45,128, 46,128, 47,
 29, 93,113,  1, 93,  1, 46,  1, 35, 34,  6,  7,  3, 62,  1, 51,
 50,  0, 29,  1, 33, 30,  1, 51, 50, 54, 55, 21, 14,  1, 35, 34,
 38, 39, 14,  1, 35, 34, 38, 53, 52, 54, 51, 33, 53, 52, 38, 35,
 34,  6,  7, 53, 62,  1, 51, 50, 22,  3, 34,  6, 21, 20, 22, 51,
 50, 54, 61,  1,  6,182,  1,165,137,153,185, 14, 68, 74,212,132,
226,  1,  8,252,178, 12,204,183,104,200,100,100,208,106,167,248,
 77, 73,216,143,189,210,253,251,  1,  2,167,151, 96,182, 84,101,
190, 90,142,213,239,223,172,129,111,153,185,  2,148,151,180,174,
158,  1, 48, 90, 94,254,221,250, 90,191,200, 53, 53,174, 42, 44,
121,119,120,120,187,168,189,192, 18,127,139, 46, 46,170, 39, 39,
 96,254, 24,102,123, 98,115,217,180, 41,  0,  3,  0, 72,255,162,
  4,156,  4,188,  0,  9,  0, 19,  0, 43,  0,228, 64, 60, 43, 44,
 38, 31, 29, 26, 19, 10,  1,  0,  4, 13, 41, 38, 32, 20, 13,  4,
 42, 38, 30, 26,  4,185, 38, 13,185, 26,184, 38,140, 44, 43, 44,
 42, 20, 23, 16, 32, 30, 35, 19, 10,  1,  0,  4, 16,  7, 31, 29,
  7, 18, 35, 81, 41, 16, 18, 23, 69, 44, 16,252,236, 50,244,236,
 50,192, 17, 18, 23, 57, 18, 57, 57, 17, 18, 57, 57, 17, 57, 49,
  0, 16,228,244,236, 16,238, 16,192, 16,192, 17, 18, 57, 57, 18,
 57, 18, 23, 57, 17, 57, 57, 17, 18, 57, 48, 64,112, 40,  1, 63,
 45, 89, 20, 86, 28, 85, 29, 86, 32,106, 21,102, 33,127,  0,123,
  4,127,  5,127,  6,127,  7,127,  8,127,  9,127, 10,127, 11,127,
 12,123, 13,122, 21,123, 26,127, 27,127, 28,127, 29,127, 30,127,
 31,127, 32,123, 33,127, 34,127, 35,127, 36,127, 37,123, 38,155,
 25,149, 37,168, 25,160, 45,240, 45, 38, 89,  0, 86, 19, 85, 29,
 90, 40,105,  0,102, 19,101, 28,106, 40,122,  0,116, 19,118, 28,
122, 40,137, 30,149, 24,154, 36,162, 24,173, 36, 17, 93,  1, 93,
  9,  1, 30,  1, 51, 50, 54, 53, 52, 38, 39, 46,  1, 35, 34,  6,
 21, 20, 22, 23,  7, 46,  1, 53, 16,  0, 51, 50, 22, 23, 55, 23,
  7, 30,  1, 21, 16,  0, 35, 34, 38, 39,  7, 39,  3,137,254, 25,
 41,103, 65,147,172, 20, 92, 42,103, 62,151,169, 19, 20,125, 54,
 54,  1, 17,241, 93,159, 67,139, 95,146, 53, 54,254,238,240, 96,
161, 63,139, 96,  3, 33,253,176, 42, 40,232,200, 79,117,154, 41,
 41,235,211, 72,110, 46,151, 77,197,119,  1, 20,  1, 56, 51, 52,
168, 79,179, 77,198,120,254,237,254,199, 52, 51,168, 78,  0,  2,
  0,143,255,227,  3,172,  5,213,  0, 32,  0, 36,  0,134, 64, 47,
 32, 26,  5,  2,  4,  6, 25,  0, 16,134, 15,136, 12,  0, 33,131,
 35, 12,149, 19,140, 35,129, 37,  6, 34, 25, 22,  9,  5,  1,  0,
 26, 34,  9,  0, 28,  1, 34, 28, 33, 38, 15,  9, 28, 22, 37, 16,
220,236,212,252,236,212,236, 17, 18, 57, 17, 18, 57, 17, 18, 57,
 18, 57, 49,  0, 16,228,244,236, 16,254,205, 16,244,238, 18, 57,
 57, 23, 57, 48,  1, 75,176, 16, 84, 75,176, 18, 84, 91, 75,176,
 19, 84, 91, 88,189,  0, 37,255,192,  0,  1,  0, 37,  0, 37,  0,
 64, 56, 17, 55, 56, 89, 64, 11,116,  4,116,  5,116,  6,116,  7,
118, 28,  5, 93,  1, 51, 21, 20,  6, 15,  1, 14,  1, 21, 20, 22,
 51, 50, 54, 55, 21, 14,  1, 35, 34, 38, 53, 52, 54, 63,  1, 62,
  1, 55, 62,  1, 53, 19, 35, 53, 51,  1,244,190, 55, 90, 90, 58,
 51,131,109, 78,180, 96, 94,192,103,184,224, 73, 89, 88, 48, 38,
  8,  7,  6,196,202,202,  4, 68,156,101,130, 87, 88, 53, 94, 49,
 89,110, 70, 67,188, 57, 56,194,159, 76,137, 86, 86, 47, 53, 25,
 21, 60, 54,  1, 14,254,  0,  2,  1, 53,  0,  0,  2,  0,  5,213,
  0,  3,  0,  9,  0, 98, 64, 15,  7,  0,131,  2,129,  4,  8,  7,
  4,  0,  3,  5,  1,  0, 10, 16,252, 60,236, 50, 57, 57, 49,  0,
 47,244,252,204, 48,  1, 75,176, 11, 84, 88,189,  0, 10,  0, 64,
  0,  1,  0, 10,  0, 10,255,192, 56, 17, 55, 56, 89,  1, 75,176,
 15, 84, 75,176, 16, 84, 91, 75,176, 19, 84, 91, 88,189,  0, 10,
255,192,  0,  1,  0, 10,  0, 10,  0, 64, 56, 17, 55, 56, 89,182,
  0, 11, 32, 11, 80, 11,  3, 93,  1, 35, 53, 51, 17, 35, 17, 19,
 51, 19,  2,  0,203,203,203, 21,162, 20,  4,215,254,250, 43,  2,
143,  1,101,254,155,  0,  0,  1,  0,217,  1, 31,  5,219,  3, 94,
  0,  5,  0, 23, 64, 10,  4,156,  2,  0,  6,  3, 23,  1,  0,  6,
 16,220,212,236, 49,  0, 16,212,196,236, 48, 19, 33, 17, 35, 17,
 33,217,  5,  2,168,251,166,  3, 94,253,193,  1,149,  0,  0,  1,
  0, 61,255,215,  5, 25,  6,125,  0, 10,  0, 42, 64, 24, 10,  9,
  8,  7,  6,  5, 11,  2,  4,  2,  0, 11, 10,  9,  7,  6,  5,  4,
  3,  0,  8,  1,  8, 11, 16,212,204, 23, 57, 49,  0, 16,212,204,
196, 17, 18, 23, 57, 48,  1, 51, 21, 35,  1, 35,  1,  7, 39, 37,
  1,  4, 92,189,115,253,174, 66,254,193,125, 25,  1, 27,  1,  0,
  6,125, 96,249,186,  3,115, 45, 80, 98,253, 59,  0,  1,  0, 31,
254, 86,  5,  2,  6, 20,  0, 35,  0,138, 64, 64, 14, 13,  2, 15,
 12, 17, 25, 30, 25, 11, 10,  9,  8,  4,  7, 17, 30, 30, 25, 66,
 25, 12, 19, 10,  7, 30,  1, 26, 10,169,  8, 19,138, 18,230, 22,
169, 15,  1,138,  0,230,  4,169, 33,151, 15, 28,  8, 36, 30, 29,
 27, 26, 25, 12, 11,  9,  8,  7, 10,  0, 18, 36, 16,212,204, 23,
 57, 49,  0, 16,196, 50,196,252,236,244,236, 16,238,246,238, 16,
238, 50, 18, 57, 57, 17, 18, 57, 57, 48, 75, 83, 88,  7, 16,  5,
237, 23, 50,  7, 16,  5,237, 17, 23, 57, 89, 34,  1, 75,176, 12,
 84, 88,189,  0, 36,255,192,  0,  1,  0, 36,  0, 36,  0, 64, 56,
 17, 55, 56, 89,  1, 21, 46,  1, 35, 34,  6,  7,  3, 33, 21, 33,
  3,  2,  6, 35, 34, 38, 39, 53, 30,  1, 51, 50, 54, 55, 19, 35,
 53, 33, 19, 62,  1, 51, 50, 22,  5,  2, 38, 80, 44, 96,114, 25,
 60,  1, 31,254,195,127, 58,188,186, 58,100, 47, 52, 97, 47, 97,
109, 34,137,248,  1, 23, 63, 36,198,151, 53,100,  5,240,164, 29,
 28,122,132,254,201,143,253,133,254,227,211, 21, 22,166, 33, 33,
137,166,  2,173,143,  1, 74,183,195, 18,  0,  2,  0,217,  1, 16,
  5,219,  3,244,  0, 29,  0, 59,  0, 63, 64, 31, 46, 31, 57, 42,
  0, 45, 34, 19,  1, 16, 27, 12, 30, 42,156, 49, 57,156, 34,  4,
156, 27, 12,156, 19, 60, 30,  0, 45, 15, 60, 16,212, 60,196, 50,
 49,  0, 16,212,236,212,236,220,252,212,236,192, 17, 18, 57, 57,
 17, 18, 57, 57, 17, 18, 57, 57, 48,  1, 21,  6,  6, 35, 34, 39,
 38, 39, 38, 39, 38, 35, 34,  6,  7, 53, 54, 54, 51, 50, 23, 22,
 23, 22, 23, 22, 51, 50, 54, 19, 21,  6,  6, 35, 34, 39, 38, 39,
 38, 39, 38, 35, 34,  6,  7, 53, 54, 54, 51, 50, 23, 22, 23, 22,
 23, 22, 51, 50, 54,  5,219,105,179, 97,110,146, 10,  7,  6, 15,
155, 94, 88,172, 98,105,179, 97,110,147, 11,  5,  6, 15,155, 94,
 86,169,103,105,179, 97,110,146, 10,  7,  6, 15,155, 94, 88,172,
 98,105,179, 97,110,147, 10,  5,  7, 15,155, 94, 86,169,  2,111,
179, 78, 69, 59,  4,  3,  2,  6, 61, 76, 84,179, 78, 69, 59,  5,
  2,  2,  6, 61, 75,  1,218,178, 79, 69, 59,  4,  3,  2,  6, 61,
 76, 83,178, 78, 69, 59,  4,  2,  3,  6, 61, 75,  0,  2,255,250,
  0,  0,  5, 96,  5,193,  0,  2,  0,  6,  0, 56, 64, 15,  0,  3,
  1,  3,  5,  4,  3,  2,  1,  0,  5,  7,  5,  6,  7, 16,212,204,
 17, 23, 57, 49,  0, 47,196,204, 17, 57, 48, 64, 20, 99,  1,109,
  2,112,  1,120,  2,127,  2,121,  5,118,  6,  7,110,  0,127,  0,
  2, 93,  1, 93,  9,  1, 33,  1, 51,  1, 33,  2,172,254, 94,  3,
 68,253,239,224,  2, 67,250,154,  4,238,251,196,  5, 15,250, 63,
  0,  2,  0,158,  0,141,  4, 37,  4, 35,  0,  6,  0, 13,  0,134,
 64, 73,  3,232,  4,  5,  4,  2,232,  1,  2,  5,  5,  4,  2,232,
  3,  2,  6,  0,  6,  1,232,  0,  0,  6, 10,232, 11, 12, 11,  9,
232,  8,  9, 12, 12, 11,  9,232, 10,  9, 13,  7, 13,  8,232,  7,
  7, 13, 66,  9,  2, 11,  4,231,  7,  0,166, 14,  9, 12,  5,  2,
  7,  3,  0,111,  5, 10,  7,111, 12,110, 14, 16,252,252, 60,212,
236, 50, 17, 57, 17, 18, 57, 49,  0, 16,244, 60,236, 50, 57, 57,
 48, 75, 83, 88,  7, 16,  4,237,  7, 16,  8,237,  7, 16,  8,237,
  7, 16,  4,237,  7, 16,  4,237,  7, 16,  8,237,  7, 16,  8,237,
  7, 16,  4,237, 89, 34,  1, 21,  1,  1, 21,  1, 53, 19, 21,  1,
  1, 21,  1, 53,  4, 37,254,211,  1, 45,254, 43, 35,254,211,  1,
 45,254, 43,  4, 35,191,254,244,254,244,191,  1,162, 82,  1,162,
191,254,244,254,244,191,  1,162, 82,  0,  0,  2,  0,193,  0,141,
  4, 72,  4, 35,  0,  6,  0, 13,  0,134, 64, 73, 12,232, 13, 12,
  9, 10,  9, 11,232, 10, 10,  9, 13,232,  7,  8,  7, 12,232, 11,
 12,  8,  8,  7,  5,232,  6,  5,  2,  3,  2,  4,232,  3,  3,  2,
  6,232,  0,  1,  0,  5,232,  4,  5,  1,  1,  0, 66, 12,  5, 10,
  3,231,  7,  0,166, 14, 12,  8,  1,  5,  0,  8,111, 10,  7,  1,
111,  3,  0,112, 14, 16,252, 60,252,212, 60,236, 18, 57, 17, 18,
 57, 49,  0, 16,244, 60,236, 50, 57, 57, 48, 75, 83, 88,  7, 16,
  8,237,  7, 16,  4,237,  7, 16,  4,237,  7, 16,  8,237,  7, 16,
  8,237,  7, 16,  4,237,  7, 16,  4,237,  7, 16,  8,237, 89, 34,
 19,  1, 21,  1, 53,  1,  1, 37,  1, 21,  1, 53,  1,  1,193,  1,
213,254, 43,  1, 45,254,211,  1,178,  1,213,254, 43,  1, 45,254,
211,  4, 35,254, 94, 82,254, 94,191,  1, 12,  1, 12,191,254, 94,
 82,254, 94,191,  1, 12,  1, 12,  0,  3,  0,236,  0,  0,  7, 20,
  0,254,  0,  3,  0,  7,  0, 11,  0, 35, 64, 17,  8,  4,  0,131,
 10,  6,  2,  4, 25,  5,  0, 25,  1,  9, 25,  8, 12, 16,212,252,
212,236,212,236, 49,  0, 47, 60, 60,236, 50, 50, 48, 37, 51, 21,
 35, 37, 51, 21, 35, 37, 51, 21, 35,  3,150,212,212,  2,169,213,
213,250,173,213,213,254,254,254,254,254,254,  0,255,255,  0, 16,
  0,  0,  5,104,  7,107,  2, 39,  0, 36,  0,  0,  0,  0,  0,  7,
  1,  6,  0,188,  1,117,255,255,  0, 16,  0,  0,  5,104,  7, 94,
  2, 39,  0, 36,  0,  0,  0,  0,  0,  7,  1,  5,  0,188,  1,117,
255,255,  0,115,255,227,  5,217,  7, 94,  2, 39,  0, 50,  0,  0,
  0,  0,  0,  7,  1,  5,  1, 39,  1,117,  0,  2,  0,115,  0,  0,
  8, 12,  5,213,  0, 16,  0, 25,  0, 59, 64, 31,  5,149,  3, 17,
  1,149,  0,129, 24,  7,149,  3,173,  9, 24, 18, 16, 10, 21,  6,
  2, 28, 17,  0,  4,  8, 21, 25, 13, 16, 26, 16,252,236,212,196,
196,212,236, 50, 18, 57, 57, 57, 57, 49,  0, 47,236,236, 50,244,
236, 50, 16,238, 48,  1, 21, 33, 17, 33, 21, 33, 17, 33, 21, 33,
 32,  0, 17, 16,  0, 33, 23, 35, 32,  0, 17, 16,  0, 33, 51,  7,
250,253, 26,  2,199,253, 57,  2,248,251,215,254, 79,254, 65,  1,
191,  1,177,103,129,254,191,254,192,  1, 64,  1, 65,129,  5,213,
170,254, 70,170,253,227,170,  1,124,  1,112,  1,109,  1,124,170,
254,225,254,224,254,223,254,223,  0,  3,  0,113,255,227,  7,195,
  4,123,  0,  6,  0, 39,  0, 51,  0,132, 64, 49,  7,  8,  0, 16,
134, 15,136, 12,  0,169,  8, 46, 12,185, 22, 19, 40,  3,185,  8,
187, 34, 37, 31,184, 25, 19,140, 52,  6,  0, 22, 34, 49,  9, 15,
  0,  8,  7, 75, 49, 18,  9, 81, 43, 18, 28, 69, 52, 16,252,236,
244,252,244,236,196, 17, 18, 57, 57, 18, 57, 49,  0, 16,228, 50,
244, 60,196,228,236, 50, 16,196,238, 50, 16,238, 16,244,238, 17,
 18, 57, 48, 64, 37, 63, 53, 95, 53,112, 53,159, 53,207, 53,208,
 53,240, 53,  7, 63,  0, 63,  6, 63,  7, 63,  8, 63,  9,  5,111,
  0,111,  6,111,  7,111,  8,111,  9,  5, 93,113,  1, 93,  1, 46,
  1, 35, 34,  6,  7,  5, 21, 33, 30,  1, 51, 50, 54, 55, 21, 14,
  1, 35, 34, 38, 39, 14,  1, 35, 34,  0, 17, 16,  0, 51, 50, 22,
 23, 62,  1, 51, 50,  0, 37, 34,  6, 21, 20, 22, 51, 50, 54, 53,
 52, 38,  7, 10,  2,164,137,153,185, 14,  3, 72,252,178, 12,204,
183,106,200, 98,100,208,106,160,242, 81, 71,209,140,241,254,239,
  1, 17,241,140,211, 66, 78,232,143,226,  1,  8,250,176,148,172,
171,149,147,172,172,  2,148,152,179,174,158, 53, 90,190,199, 52,
 52,174, 42, 44,110,109,110,109,  1, 57,  1, 19,  1, 20,  1, 56,
111,108,107,112,254,221,135,231,201,201,231,232,200,199,233,  0,
  0,  1,  0,  0,  1,233,  4,  0,  2,121,  0,  3,  0, 16,182,  2,
169,  0,233,  4,  1,  0, 47,198, 49,  0, 16,252,236, 48, 17, 33,
 21, 33,  4,  0,252,  0,  2,121,144,  0,  0,  1,  0,  0,  1,233,
  8,  0,  2,121,  0,  3,  0, 15,181,  2,169,  0,  4,  1,  0, 47,
204, 49,  0, 16,212,236, 48, 17, 33, 21, 33,  8,  0,248,  0,  2,
121,144,  0,  2,  0,174,  3,233,  3,109,  5,213,  0,  5,  0, 11,
  0, 39, 64, 19,  6,  0,158,  9,  3,129, 12,  9, 10,  6, 25,  7,
  3,  4,  7,  0, 25,  1, 12, 16,220,252,204,212,204, 16,254,212,
206, 49,  0, 16,244, 60,236, 50, 48,  1, 35, 53, 19, 51,  3,  5,
 35, 53, 19, 51,  3,  1,129,211,164,129, 82,  1,154,211,164,129,
 82,  3,233,173,  1, 63,254,193,173,173,  1, 63,254,193,  0,  2,
  0,174,  3,233,  3,109,  5,213,  0,  5,  0, 11,  0, 39, 64, 19,
  9,  3,158,  6,  0,129, 12,  9, 10,  7, 25,  6,  1,  3,  4,  1,
 25,  0, 12, 16,220,236,212,204, 16,220,238,212,206, 49,  0, 16,
244, 60,236, 50, 48,  1, 51, 21,  3, 35, 19, 37, 51, 21,  3, 35,
 19,  1,  0,211,164,129, 82,  1,154,211,164,129, 82,  5,213,172,
254,192,  1, 64,172,172,254,192,  1, 64,  0,  1,  0,174,  3,233,
  1,211,  5,213,  0,  5,  0, 24, 64, 11,  0,158,  3,129,  6,  3,
  4,  0, 25,  1,  6, 16,220,252,212,204, 49,  0, 16,244,236, 48,
  1, 35, 53, 19, 51,  3,  1,129,211,164,129, 82,  3,233,173,  1,
 63,254,193,  0,  0,  1,  0,178,  3,254,  1,215,  5,213,  0,  5,
  0, 24, 64, 11,  3,158,  0,129,  6,  3,  4,  1,113,  0,  6, 16,
220,236,212,204, 49,  0, 16,244,236, 48,  1, 51, 21,  3, 35, 19,
  1,  4,211,164,129, 82,  5,213,152,254,193,  1, 63,  0,  0,  3,
  0,217,  0,150,  5,219,  4,111,  0,  3,  0,  7,  0, 11,  0, 41,
 64, 20,  0,234,  2,  6,234,  4,  2,  8,156,  4, 10, 12,  9,  5,
  1,114,  4,  0,  8, 12, 16,220,212, 60,252, 60,196, 49,  0, 16,
212,196,252,196, 16,238, 16,238, 48,  1, 51, 21, 35, 17, 51, 21,
 35,  1, 33, 21, 33,  2,223,246,246,246,246,253,250,  5,  2,250,
254,  4,111,246,254, 18,245,  2, 65,170,  0,  2,  0,  6,254, 35,
  3,238,  6,117,  0,  3,  0,  7,  0, 34, 64, 17,  2,  6,  0,  8,
  4,  6,  8,  6,  4,  3,  2,  1,  0,  6,  5,  7,  8, 16,212,204,
 23, 57, 49,  0, 16,212,204, 17, 57, 18, 57, 48,  9,  7,  1,250,
254,127,  1,129,  1,129,254,127,  1,244,254, 12,254, 12,  5,129,
252,207,252,199,  3, 57,  4, 37,251,219,251,211,  4, 45,255,255,
  0, 61,254, 86,  4,127,  6, 16,  2, 39,  0, 92,  0,  0,  0,  0,
  0,  7,  0,142,  0, 94,  0,  0,255,255,255,252,  0,  0,  4,231,
  7, 78,  2, 39,  0, 60,  0,  0,  0,  0,  0,  7,  1,  3,  0,115,
  1,117,  0,  1,254,137,255,227,  2,205,  5,240,  0,  3,  0, 43,
 64, 19,  0, 15,  1,  2,  1,  2, 15,  3,  0,  3, 66,  2,140,  0,
145,  4,  1,  3,  4, 16,212,204, 49,  0, 16,228,228, 48, 75, 83,
 88,  7, 16,  5,237,  7, 16,  5,237, 89, 34,  1, 51,  1, 35,  2,
 45,160,252, 92,160,  5,240,249,243,  0,  0,  2,  0, 94,  0, 82,
  4,188,  4,178,  0, 35,  0, 47,  0,131, 64, 73,  3,  9, 27, 21,
  4, 45, 30,  0, 39, 28,  2, 33, 29, 12, 18, 45, 20, 11, 10,  3,
 19, 15,  1, 29, 45,185, 19,235, 15,236, 39,185, 29,235, 33, 48,
 30, 12,  0, 18,  4, 42, 36, 20, 48, 28, 21, 27, 42, 29, 19, 28,
 24,  9,  3, 36, 11, 10,  1,  3,  2, 36, 40,  2,115,  6,116, 42,
 40, 28,115, 24, 48, 16,220,228,236,244,228,236, 18, 23, 57, 18,
 57, 57, 17, 18, 57, 57, 18, 57, 57, 17, 18, 57, 17, 18, 23, 57,
 49,  0, 16,212,228,236,244,228,236, 16,192, 17, 18, 23, 57, 18,
 57, 57, 17, 18, 57, 57, 17, 57, 57, 18, 23, 57, 48,  1, 55, 23,
  7, 22, 22, 21, 20,  6,  7, 23,  7, 39,  6,  6, 35, 34, 38, 39,
  7, 39, 55, 38, 38, 53, 52, 54, 55, 39, 55, 23, 54, 54, 51, 50,
 22, 19, 52, 38, 35, 34,  6, 21, 20, 22, 51, 50, 54,  3,123,207,
114,206, 37, 36, 38, 40,209,114,207, 59,116, 61, 58,120, 61,207,
113,207, 37, 37, 38, 38,207,115,207, 55,116, 64, 60,117, 92,155,
114,112,158,157,113,113,156,  3,225,209,115,206, 59,119, 62, 63,
115, 57,207,113,207, 40, 38, 37, 37,207,115,206, 62,118, 58, 64,
116, 56,206,115,207, 39, 37, 36,254,124,112,154,154,112,114,156,
157,  0,  0,  1,  0,158,  0,141,  2,115,  4, 35,  0,  6,  0, 71,
 64, 37,  3,232,  4,  5,  4,  2,232,  1,  2,  5,  5,  4,  2,232,
  3,  2,  6,  0,  6,  1,232,  0,  6, 66,  2,  4,231,  0,166,  7,
  2,  3,  0,111,  5,110,  7, 16,252,236, 50, 57, 49,  0, 16,244,
236, 57, 48, 75, 83, 88,  7,  4,237,  7, 16,  8,237,  7, 16,  8,
237,  7, 16,  4,237, 89, 34,  1, 21,  1,  1, 21,  1, 53,  2,115,
254,211,  1, 45,254, 43,  4, 35,191,254,244,254,244,191,  1,162,
 82,  0,  0,  1,  0,193,  0,141,  2,150,  4, 35,  0,  6,  0, 73,
 64, 38,  5,232,  6,  5,  2,  3,  2,  4,232,  3,  3,  2,  6,232,
  0,  1,  0,  5,232,  4,  5,  1,  1,  0, 66,  5,  3,231,  0,166,
  7,  5,  1,111,  3,  0,112,  7, 16,252, 60,236, 57, 49,  0, 16,
244,236, 57, 48, 75, 83, 88,  7, 16,  8,237,  7, 16,  4,237,  7,
 16,  4,237,  7, 16,  8,237, 89, 34, 19,  1, 21,  1, 53,  1,  1,
193,  1,213,254, 43,  1, 45,254,211,  4, 35,254, 94, 82,254, 94,
191,  1, 12,  1, 12,  0,  0,  2,  0, 47,  0,  0,  4, 74,  6, 20,
  0, 21,  0, 25,  0,155, 64, 40, 11, 20, 24,  7,  3,169,  0, 16,
135, 14, 24,190, 22,177, 14,151,  9,  0,188,  5,  1, 17, 14, 15,
  4, 22,  2,  8,  0, 15, 20,  4,  8,  8, 23,  0, 10,  6, 76, 26,
 16,252, 60,196, 50,196,252, 60,196, 16,238, 50, 17, 18, 57, 57,
 49,  0, 47, 60,230, 50,238,254,238, 16,238, 16,238, 50, 18, 57,
 57, 48,  1, 75,176, 10, 84, 88,189,  0, 26,255,192,  0,  1,  0,
 26,  0, 26,  0, 64, 56, 17, 55, 56, 89,  1, 75,176, 14, 84, 88,
189,  0, 26,  0, 64,  0,  1,  0, 26,  0, 26,255,192, 56, 17, 55,
 56, 89, 64, 26, 16, 22, 16, 23, 16, 24, 16, 25,  4, 48, 27, 80,
 27,128, 15,128, 16,128, 27,160, 27,208, 27,239, 27,  8, 93,  0,
 93,  1, 17, 35, 17, 33, 17, 35, 17, 35, 53, 51, 53, 52, 54, 59,
  1, 21, 35, 34,  6, 29,  1,  1, 51, 21, 35,  4, 74,185,254,  7,
185,176,176,173,179,185,176, 99, 77,  1,249,185,185,  4, 96,251,
160,  3,209,252, 47,  3,209,143, 78,183,175,153, 80,104, 99,  1,
178,233,  0,  1,  0, 47,  0,  0,  4, 74,  6, 20,  0, 21,  0,132,
 64, 33,  8, 19,  4, 15, 11,169,  9,  4,135,  0,151, 17,  9,188,
 13,  2,  5,  0, 10,  8,  3,  8,  1, 10, 12,  8,  8, 16,  1, 18,
 14, 76, 22, 16,252, 60,196,196,252, 60,196, 16,238, 17, 18, 57,
 57, 49,  0, 47, 60,230, 50,254,238, 16,238, 50, 18, 57, 57, 48,
  1, 75,176, 10, 84, 88,189,  0, 22,255,192,  0,  1,  0, 22,  0,
 22,  0, 64, 56, 17, 55, 56, 89,  1, 75,176, 14, 84, 88,189,  0,
 22,  0, 64,  0,  1,  0, 22,  0, 22,255,192, 56, 17, 55, 56, 89,
 64, 17, 48, 23, 80, 23,128, 10,128, 11,128, 23,160, 23,208, 23,
239, 23,  8, 93,  1, 33, 17, 35, 17, 33, 34,  6, 29,  1, 33, 21,
 33, 17, 35, 17, 35, 53, 51, 53, 52, 54,  2, 74,  2,  0,185,254,
183, 99, 77,  1, 47,254,209,185,176,176,174,  6, 20,249,236,  5,
123, 80,104, 99,143,252, 47,  3,209,143, 78,187,171,  0,  0,  1,
  0, 57,255, 59,  3,199,  5,213,  0, 19,  0, 62, 64, 32, 18,  6,
185,  0, 16,  8,185, 10,  4,  0,  2, 14, 10, 12,129,  2,194, 20,
 15,  0, 89, 17, 13,  1, 87,  9,  5, 89, 11,  7,  3, 20, 16,212,
 60, 60,236, 50,252, 60, 60,236, 50, 49,  0, 16,228,244,196, 50,
 16,196, 50, 16,238, 50, 16,238, 50, 48, 37, 33, 17, 35, 17, 33,
 53, 33, 17, 33, 53, 33, 17, 51, 17, 33, 21, 33, 17, 33,  3,199,
254,145,176,254,145,  1,111,254,145,  1,111,176,  1,111,254,145,
  1,111,223,254, 92,  1,164,154,  2, 31,153,  1,164,254, 92,153,
253,225,  0,  1,  0,219,  2, 72,  1,174,  3, 70,  0,  3,  0, 18,
183,  2,131,  0,  4,  1, 25,  0,  4, 16,212,236, 49,  0, 16,212,
236, 48, 19, 51, 21, 35,219,211,211,  3, 70,254,  0,  1,  0,174,
255, 18,  1,211,  0,254,  0,  5,  0, 24, 64, 11,  3,158,  0,131,
  6,  3,  4,  1, 25,  0,  6, 16,212,236,212,204, 49,  0, 16,252,
236, 48, 37, 51, 21,  3, 35, 19,  1,  0,211,164,129, 82,254,172,
254,192,  1, 64,  0,  2,  0,174,255, 18,  3,109,  0,254,  0,  5,
  0, 11,  0, 39, 64, 19,  9,  3,158,  6,  0,131, 12,  3,  4,  1,
 25,  0,  7,  9, 10,  7, 25,  6, 12, 16,220,236,212,204, 16,220,
238,212,206, 49,  0, 16,252, 60,236, 50, 48, 37, 51, 21,  3, 35,
 19, 37, 51, 21,  3, 35, 19,  2,154,211,164,129, 82,254,102,211,
164,129, 82,254,172,254,192,  1, 64,172,172,254,192,  1, 64,  0,
  0,  7,  0,113,255,227, 10, 76,  5,240,  0, 11,  0, 23,  0, 35,
  0, 39,  0, 51,  0, 63,  0, 75,  0,174, 64, 68, 36, 15, 37, 38,
 37, 38, 15, 39, 36, 39, 66, 64,  0,146, 12, 46,146, 30,141, 40,
146, 24, 70,  6,146, 52, 12,141, 58, 38, 18,140, 36, 24,145, 76,
 37, 73, 67, 39, 49, 43, 67, 13, 61,  9, 13, 15, 14,  3, 13, 21,
 49, 13, 27, 61, 14, 73, 13, 21, 55, 43, 13, 27, 14, 33, 11, 76,
 16,252,228,236,212,196,236,228, 16,238, 16,238,246,238, 16,238,
 17, 18, 57, 17, 18, 57, 49,  0, 16,228, 50,244, 60, 60,228, 50,
236, 50, 16,238,246,238, 16,238, 50, 48, 75, 83, 88,  7, 16,  5,
237,  7, 16,  5,237, 89, 34,  1, 75,176, 20, 84, 75,176,  9, 84,
 91, 75,176, 11, 84, 91, 75,176, 12, 84, 91, 75,176, 13, 84, 91,
 75,176, 14, 84, 91, 88,189,  0, 76,  0, 64,  0,  1,  0, 76,  0,
 76,255,192, 56, 17, 55, 56, 89,  1, 34,  6, 21, 20, 22, 51, 50,
 54, 53, 52, 38, 39, 50, 22, 21, 20,  6, 35, 34, 38, 53, 52, 54,
  1, 50, 22, 21, 20,  6, 35, 34, 38, 53, 52, 54, 33, 51,  1, 35,
 19, 34,  6, 21, 20, 22, 51, 50, 54, 53, 52, 38,  1, 50, 22, 21,
 20,  6, 35, 34, 38, 53, 52, 54, 23, 34,  6, 21, 20, 22, 51, 50,
 54, 53, 52, 38,  8,244, 87,100,100, 87, 85, 99, 99, 85,158,186,
187,157,160,186,187,249,116,158,188,187,159,159,185,186,  4, 37,
160,252, 90,160, 31, 86, 99, 98, 87, 87, 99,100,  3,178,158,186,
187,157,160,186,187,159, 87, 99, 99, 87, 85, 99, 99,  2,145,148,
132,130,149,149,130,131,149,127,220,187,187,219,219,187,188,219,
  2,224,219,187,189,218,219,188,186,220,249,243,  5,142,149,130,
132,148,148,132,129,150,253,159,220,187,187,219,219,187,188,219,
127,148,132,130,149,149,130,131,149,  0,255,255,  0, 16,  0,  0,
  5,104,  7,109,  2, 39,  0, 36,  0,  0,  0,  0,  0,  7,  1,  7,
  0,188,  1,117,255,255,  0,201,  0,  0,  4,139,  7,109,  2, 39,
  0, 40,  0,  0,  0,  0,  0,  7,  1,  7,  0,158,  1,117,255,255,
  0, 16,  0,  0,  5,104,  7,107,  2, 39,  0, 36,  0,  0,  0,  0,
  0,  7,  1,  4,  0,188,  1,117,255,255,  0,201,  0,  0,  4,139,
  7, 78,  2, 39,  0, 40,  0,  0,  0,  0,  0,  7,  1,  3,  0,158,
  1,117,255,255,  0,201,  0,  0,  4,139,  7,107,  2, 39,  0, 40,
  0,  0,  0,  0,  0,  7,  1,  6,  0,158,  1,117,255,255,  0,162,
  0,  0,  2, 31,  7,107,  2, 39,  0, 44,  0,  0,  0,  0,  0,  7,
  1,  4,255, 47,  1,117,255,255,255,254,  0,  0,  2, 96,  7,109,
  2, 39,  0, 44,  0,  0,  0,  0,  0,  7,  1,  7,255, 47,  1,117,
255,255,  0,  6,  0,  0,  2, 88,  7, 78,  2, 39,  0, 44,  0,  0,
  0,  0,  0,  7,  1,  3,255, 47,  1,117,255,255,  0, 59,  0,  0,
  1,186,  7,107,  2, 39,  0, 44,  0,  0,  0,  0,  0,  7,  1,  6,
255, 47,  1,117,255,255,  0,115,255,227,  5,217,  7,107,  2, 39,
  0, 50,  0,  0,  0,  0,  0,  7,  1,  4,  1, 39,  1,117,255,255,
  0,115,255,227,  5,217,  7,109,  2, 39,  0, 50,  0,  0,  0,  0,
  0,  7,  1,  7,  1, 39,  1,117,255,255,  0,115,255,227,  5,217,
  7,107,  2, 39,  0, 50,  0,  0,  0,  0,  0,  7,  1,  6,  1, 39,
  1,117,255,255,  0,178,255,227,  5, 41,  7,107,  2, 39,  0, 56,
  0,  0,  0,  0,  0,  7,  1,  4,  0,238,  1,117,255,255,  0,178,
255,227,  5, 41,  7,109,  2, 39,  0, 56,  0,  0,  0,  0,  0,  7,
  1,  7,  0,238,  1,117,255,255,  0,178,255,227,  5, 41,  7,107,
  2, 39,  0, 56,  0,  0,  0,  0,  0,  7,  1,  6,  0,238,  1,117,
  0,  1,  0,193,  0,  0,  1,121,  4, 96,  0,  3,  0, 32,183,  0,
191,  2,  1,  8,  0, 70,  4, 16,252,236, 49,  0, 47,236, 48, 64,
 11, 16,  5, 64,  5, 80,  5, 96,  5,112,  5,  5,  1, 93, 19, 51,
 17, 35,193,184,184,  4, 96,251,160,  0,  0,  1,  0,193,  4,238,
  3, 63,  6,102,  0,  6,  0, 55, 64, 12,  4,  5,  2,180,  0,179,
  7,  4,  2,117,  6,  7, 16,220,236, 57, 49,  0, 16,244,236, 50,
 57, 48,  0, 75,176,  9, 84, 75,176, 14, 84, 91, 88,189,  0,  7,
255,192,  0,  1,  0,  7,  0,  7,  0, 64, 56, 17, 55, 56, 89,  1,
 51, 19, 35, 39,  7, 35,  1,182,148,245,139,180,180,139,  6,102,
254,136,245,245,  0,  1,  0,182,  5, 29,  3, 74,  6, 55,  0, 27,
  0, 99, 64, 36,  0, 18,  7, 14, 11,  4,  1, 18,  7, 15, 11,  4,
 18,195, 25,  7,  4,195, 21, 11,237, 28, 15,  1, 14,  0,  7, 21,
 86, 22,119,  7, 86,  8,118, 28, 16,244,236,252,236, 17, 57, 57,
 57, 57, 49,  0, 16,252, 60,252,212, 60,236, 17, 18, 57, 17, 18,
 57, 17, 18, 57, 17, 18, 57, 48,  0, 75,176,  9, 84, 75,176, 12,
 84, 91, 88,189,  0, 28,255,192,  0,  1,  0, 28,  0, 28,  0, 64,
 56, 17, 55, 56, 89,  1, 39, 46,  1, 35, 34,  6,  7, 35, 62,  1,
 51, 50, 22, 31,  1, 30,  1, 51, 50, 54, 55, 51, 14,  1, 35, 34,
 38,  1,252, 57, 22, 33, 13, 38, 36,  2,125,  2,102, 91, 38, 64,
 37, 57, 22, 33, 13, 38, 36,  2,125,  2,102, 91, 38, 64,  5, 90,
 55, 20, 19, 73, 82,135,147, 28, 33, 55, 20, 19, 73, 82,135,147,
 28,  0,  0,  1,  0,213,  5, 98,  3, 43,  5,246,  0,  3,  0, 47,
183,  2,239,  0,238,  4,  1,  0,  4, 16,212,204, 49,  0, 16,252,
236, 48,  0, 75,176,  9, 84, 75,176, 14, 84, 91, 88,189,  0,  4,
255,192,  0,  1,  0,  4,  0,  4,  0, 64, 56, 17, 55, 56, 89, 19,
 33, 21, 33,213,  2, 86,253,170,  5,246,148,  0,  0,  1,  0,199,
  5, 41,  3, 57,  6, 72,  0, 13,  0, 87, 64, 14, 11,240,  4,  7,
  0,179, 14,  7, 86,  8,  1, 86,  0, 14, 16,220,236,212,236, 49,
  0, 16,244, 60,212,236, 48,  0, 75,176,  9, 84, 88,189,  0, 14,
255,192,  0,  1,  0, 14,  0, 14,  0, 64, 56, 17, 55, 56, 89,  0,
 75,176, 15, 84, 75,176, 16, 84, 91, 75,176, 17, 84, 91, 88,189,
  0, 14,  0, 64,  0,  1,  0, 14,  0, 14,255,192, 56, 17, 55, 56,
 89, 19, 51, 30,  1, 51, 50, 54, 55, 51, 14,  1, 35, 34, 38,199,
118, 11, 97, 87, 86, 96, 13,118, 10,158,145,145,158,  6, 72, 75,
 75, 74, 76,143,144,144,  0,  1,  1,154,  5, 68,  2,102,  6, 16,
  0,  3,  0, 44, 64,  9,  2,206,  0,205,  4,  1,100,  0,  4, 16,
212,236, 49,  0, 16,252,236, 48,  0, 75,176,  9, 84, 88,189,  0,
  4,255,192,  0,  1,  0,  4,  0,  4,  0, 64, 56, 17, 55, 56, 89,
  1, 51, 21, 35,  1,154,204,204,  6, 16,204,  0,  0,  2,  0,238,
  4,225,  3, 18,  7,  6,  0, 11,  0, 23,  0, 95, 64, 17,  3,193,
 21,242,  9,193, 15,241, 24,  0, 86, 12,120,  6, 86, 18, 24, 16,
212,236,244,236, 49,  0, 16,244,236,244,236, 48,  0, 75,176,  9,
 84, 75,176, 12, 84, 91, 88,189,  0, 24,255,192,  0,  1,  0, 24,
  0, 24,  0, 64, 56, 17, 55, 56, 89,  1, 75,176, 10, 84, 75,176,
 11, 84, 91, 75,176, 12, 84, 91, 88,189,  0, 24,255,192,  0,  1,
  0, 24,  0, 24,  0, 64, 56, 17, 55, 56, 89,  1, 52, 38, 35, 34,
  6, 21, 20, 22, 51, 50, 54, 55, 20,  6, 35, 34, 38, 53, 52, 54,
 51, 50, 22,  2,152, 88, 64, 65, 87, 87, 65, 64, 88,122,159,115,
115,159,159,115,115,159,  5,244, 63, 88, 87, 64, 65, 87, 88, 64,
115,160,160,115,115,159,159,  0,  0,  1,  1, 35,254,117,  2,193,
  0,  0,  0, 19,  0, 31, 64, 14,  9,  6, 10, 13,243,  6,  0, 19,
  0, 16, 39,  3,  9, 20, 16,220,212,236,212,204, 49,  0, 47,212,
252,196, 18, 57, 48, 33, 22, 22, 21, 20,  6, 35, 34, 38, 39, 53,
 22, 22, 51, 50, 54, 53, 52, 38, 39,  2, 84, 55, 54,120,118, 46,
 87, 43, 34, 74, 47, 59, 60, 43, 45, 62,105, 48, 89, 91, 12, 12,
131, 17, 15, 48, 46, 30, 87, 61,  0,  2,  0,240,  4,238,  3,174,
  6,102,  0,  3,  0,  7,  0, 66, 64, 17,  6,  2,180,  4,  0,179,
  8,  4,  7,  3,  0,  5,  1,  3,  5,  7,  8, 16,212,220,212,204,
 17, 57, 17, 18, 57, 49,  0, 16,244, 60,236, 50, 48,  0, 75,176,
  9, 84, 75,176, 14, 84, 91, 88,189,  0,  8,255,192,  0,  1,  0,
  8,  0,  8,  0, 64, 56, 17, 55, 56, 89,  1, 51,  3, 35,  3, 51,
  3, 35,  2,252,178,248,135,129,170,223,137,  6,102,254,136,  1,
120,254,136,  0,  0,  1,  1, 76,254,117,  2,193,  0,  0,  0, 19,
  0, 32, 64, 15, 11, 14, 10,  7,243, 14,244,  0,  1,  0, 10,  4,
 39, 17, 20, 16,212,236,196,212,204, 49,  0, 47,252,252,196, 18,
 57, 48, 33, 51,  6,  6, 21, 20, 22, 51, 50, 54, 55, 21,  6,  6,
 35, 34, 38, 53, 52, 54,  1,184,119, 45, 43, 55, 54, 32, 62, 31,
 38, 68, 30,122,115, 53, 61, 88, 31, 46, 46, 15, 15,133, 10, 10,
 87, 93, 48,105,  0,  1,  0,193,  4,238,  3, 63,  6,102,  0,  6,
  0, 55, 64, 12,  3,  0,180,  4,  1,179,  7,  3,  5,117,  1,  7,
 16,220,236, 57, 49,  0, 16,244, 60,236, 57, 48,  0, 75,176,  9,
 84, 75,176, 14, 84, 91, 88,189,  0,  7,255,192,  0,  1,  0,  7,
  0,  7,  0, 64, 56, 17, 55, 56, 89,  1,  3, 51, 23, 55, 51,  3,
  1,182,245,139,180,180,139,245,  4,238,  1,120,245,245,254,136,
  0,  1,255,242,  0,  0,  4,117,  5,213,  0, 13,  0, 63, 64, 30,
 12, 11, 10,  4,  3,  2,  6,  0,  6,149,  0,129,  8,  3,  4,  1,
 11, 14,  0,  4,  5,  1, 28, 12,  7, 58,  9,  0,121, 14, 16,244,
 60,236,196,252, 60,196, 17, 18, 57, 17, 18, 57, 49,  0, 47,228,
236, 17, 23, 57, 48,180, 48, 15, 80, 15,  2,  1, 93, 19, 51, 17,
 37, 23,  1, 17, 33, 21, 33, 17,  7, 39, 55,211,203,  1, 57, 80,
254,119,  2,215,252, 94,148, 77,225,  5,213,253,152,219,111,254,
238,253,227,170,  2, 59,106,110,158,  0,  0,  1,  0,  2,  0,  0,
  2, 72,  6, 20,  0, 11,  0, 94, 64, 26, 10,  9,  8,  4,  3,  2,
  6,  0,151,  6,  3,  4,  1,  9, 10,  0,  4,122,  5,  1,  8, 10,
122,  7,  0, 12, 16,212, 60,228,252, 60,228, 17, 18, 57, 17, 18,
 57, 49,  0, 47,236, 23, 57, 48,  1, 75,176, 16, 84, 88,189,  0,
 12,  0, 64,  0,  1,  0, 12,  0, 12,255,192, 56, 17, 55, 56, 89,
 64, 19, 16, 13, 64, 13, 80, 13, 96, 13,115,  4,122, 10,112, 13,
224, 13,240, 13,  9, 93, 19, 51, 17, 55, 23,  7, 17, 35, 17,  7,
 39, 55,199,184,125, 76,201,184,123, 74,197,  6, 20,253,166, 90,
106,141,252,227,  2,154, 88,106,141,  0,255,255,  0,135,255,227,
  4,162,  7,109,  2, 39,  0, 54,  0,  0,  0,  0,  0,  7,  1,  8,
  0,139,  1,117,255,255,  0,111,255,227,  3,199,  6,102,  2, 39,
  0, 86,  0,  0,  0,  0,  0,  7,  0,224,  0, 23,  0,  0,255,255,
  0, 92,  0,  0,  5, 31,  7,109,  2, 39,  0, 61,  0,  0,  0,  0,
  0,  7,  1,  8,  0,190,  1,117,255,255,  0, 88,  0,  0,  3,219,
  6,102,  2, 39,  0, 93,  0,  0,  0,  0,  0,  7,  0,224,  0, 27,
  0,  0,  0,  2,  1,  4,254,162,  1,174,  5,152,  0,  3,  0,  7,
  0, 28, 64, 13,  1,245,  0,  4,245,  5,  8,  4,  0,  5,  6,  2,
  8, 16,220, 60,236, 50, 49,  0, 16,212,236,212,236, 48,  1, 17,
 35, 17, 19, 17, 35, 17,  1,174,170,170,170,  1,152,253, 10,  2,
246,  4,  0,253, 10,  2,246,  0,  0,  2,  0, 10,  0,  0,  5,186,
  5,213,  0, 12,  0, 25,  0,103, 64, 32, 16,  9,169, 11, 13,149,
  0,129, 18,149, 14, 11,  7,  7,  1, 25, 19,  4, 15, 13, 22, 25,
  4, 50, 10, 17, 13, 28,  8,  0,121, 26, 16,244, 60,236, 50,196,
244,236, 16,196, 23, 57, 49,  0, 47,198, 50,238,246,238, 16,238,
 50, 48, 64, 40, 32, 27,127, 27,176, 27,  3,159,  9,159, 10,159,
 11,159, 12,159, 14,159, 15,159, 16,159, 17,191,  9,191, 10,191,
 11,191, 12,191, 14,191, 15,191, 16,191, 17, 16, 93,  1, 93, 19,
 33, 32,  0, 17, 16,  0, 41,  1, 17, 35, 53, 51, 19, 17, 33, 21,
 33, 17, 51, 32,  0, 17, 16,  0, 33,211,  1,160,  1,177,  1,150,
254,105,254, 80,254, 96,201,201,203,  1, 80,254,176,243,  1, 53,
  1, 31,254,225,254,203,  5,213,254,151,254,128,254,126,254,150,
  2,188,144,  1,227,254, 29,144,253,234,  1, 24,  1, 46,  1, 44,
  1, 23,  0,  2,  0,113,255,227,  4,117,  6, 20,  0, 14,  0, 40,
  1, 39, 64, 94, 37,123, 38, 37, 30, 35, 30, 36,123, 35, 35, 30,
 15,123, 35, 30, 40,123, 39, 40, 30, 35, 30, 38, 39, 40, 39, 37,
 36, 37, 40, 40, 39, 34, 35, 34, 31, 32, 31, 33, 32, 32, 31, 66,
 40, 39, 38, 37, 34, 33, 32, 31,  8, 35, 30,  3, 15, 35,  3,185,
 27,  9,185, 21,140, 27, 35,177, 41, 38, 39, 18, 12, 33, 32, 24,
 40, 37, 35, 34, 31,  5, 30, 15,  6, 12, 18, 18, 81,  6, 18, 24,
 69, 41, 16,252,236,244,236, 17, 57, 57, 23, 57, 18, 57, 57, 17,
 18, 57, 57, 49,  0, 16,236,196,244,236, 16,238, 18, 57, 18, 57,
 18, 23, 57, 48, 75, 83, 88,  7, 16, 14,201,  7, 16,  8,201,  7,
 16,  8,201,  7, 16, 14,201,  7, 16,  8,237,  7, 14,237,  7, 16,
  5,237,  7, 16,  8,237, 89, 34,178, 63, 42,  1,  1, 93, 64,118,
 22, 37, 43, 31, 40, 34, 47, 35, 47, 36, 41, 37, 45, 38, 45, 39,
 42, 40, 54, 37, 70, 37, 88, 32, 88, 33, 96, 32, 96, 33,102, 34,
117, 32,117, 33,117, 34, 19, 37, 35, 37, 36, 38, 38, 38, 39, 39,
 40, 54, 36, 54, 37, 70, 36, 69, 37, 90, 32, 90, 33, 98, 32, 98,
 33,127,  0,127,  1,127,  2,122,  3,123,  9,127, 10,127, 11,127,
 12,127, 13,127, 14,127, 15,127, 16,127, 17,127, 18,127, 19,127,
 20,123, 21,122, 27,122, 28,127, 29,127, 30,118, 32,118, 33,120,
 34,160, 42,240, 42, 39, 93,  0, 93,  1, 46,  1, 35, 34,  6, 21,
 20, 22, 51, 50, 54, 53, 52, 38, 19, 22, 18, 21, 20,  0, 35, 34,
  0, 53, 52,  0, 51, 50, 22, 23, 39,  5, 39, 37, 39, 51, 23, 37,
 23,  5,  3, 70, 50, 88, 41,167,185,174,146,145,174, 54,  9,126,
114,254,228,230,231,254,229,  1, 20,221, 18, 52, 42,159,254,193,
 33,  1, 25,181,228,127,  1, 77, 33,254,217,  3,147, 17, 16,216,
195,188,222,222,188,122,188,  1, 38,143,254,224,173,255,254,201,
  1, 55,255,250,  1, 55,  5,  5,180,107, 99, 92,204,145,111, 97,
 98,  0,255,255,255,252,  0,  0,  4,231,  7,107,  2, 39,  0, 60,
  0,  0,  0,  0,  0,  7,  1,  4,  0,115,  1,117,255,255,  0, 61,
254, 86,  4,127,  6,102,  2, 39,  0, 92,  0,  0,  0,  0,  0,  7,
  0,141,  0, 94,  0,  0,  0,  2,  0,201,  0,  0,  4,141,  5,213,
  0, 12,  0, 21,  0, 61, 64, 27, 14,149,  9, 13,149,  2,246,  0,
129, 11, 21, 15,  9,  3,  4,  1, 18, 25,  6, 63, 13, 10,  1, 28,
  0,  4, 22, 16,252,236, 50, 50,252,236, 17, 23, 57, 49,  0, 47,
244,252,236,212,236, 48, 64,  9, 15, 23, 31, 23, 63, 23, 95, 23,
  4,  1, 93, 19, 51, 17, 51, 50,  4, 21, 20,  4, 43,  1, 17, 35,
 19, 17, 51, 50, 54, 53, 52, 38, 35,201,202,254,251,  1,  1,254,
255,251,254,202,202,254,141,154,153,142,  5,213,254,248,225,220,
220,226,254,174,  4, 39,253,209,146,134,134,145,  0,  2,  0,186,
254, 86,  4,164,  6, 20,  0, 16,  0, 28,  0, 62, 64, 27, 20,185,
  5,  8, 26,185,  0, 14,140,  8,184,  1,189,  3,151, 29, 17, 18,
 11, 71, 23,  4,  0,  8,  2, 70, 29, 16,252,236, 50, 50,244,236,
 49,  0, 16,236,228,228,244,196,236, 16,198,238, 48, 64,  9, 96,
 30,128, 30,160, 30,224, 30,  4,  1, 93, 37, 17, 35, 17, 51, 17,
 62,  1, 51, 50, 18, 17, 16,  2, 35, 34, 38,  1, 52, 38, 35, 34,
  6, 21, 20, 22, 51, 50, 54,  1,115,185,185, 58,177,123,204,255,
255,204,123,177,  2, 56,167,146,146,167,167,146,146,167,168,253,
174,  7,190,253,162,100, 97,254,188,254,248,254,248,254,188, 97,
  1,235,203,231,231,203,203,231,231,  0,  0,  1,  0,217,  2, 45,
  5,219,  2,215,  0,  3,  0, 17,182,  0,156,  2,  4,  1,  0,  4,
 16,212,196, 49,  0, 16,212,236, 48, 19, 33, 21, 33,217,  5,  2,
250,254,  2,215,170,  0,  0,  1,  1, 25,  0, 63,  5,156,  4,197,
  0, 11,  0,133, 64, 77, 10,156, 11, 10,  7,  8,  7,  9,156,  8,
  8,  7,  4,156,  3,  4,  7,  7,  6,  5,156,  6,  7,  6,  4,156,
  5,  4,  1,  2,  1,  3,156,  2,  2,  1, 11,156,  0,  1,  0, 10,
156,  9, 10,  1,  1,  0, 66, 10,  8,  7,  6,  4,  2,  1,  0,  8,
  5,  3, 11,  9, 12, 11, 10,  9,  7,  5,  4,  3,  1,  8,  2,  0,
  8,  6, 12, 16,212, 60,204, 50, 23, 57, 49,  0, 16,212, 60,204,
 50, 23, 57, 48, 75, 83, 88,  7, 16,  8,237,  7, 16,  5,237,  7,
 16,  5,237,  7, 16,  8,237,  7, 16,  5,237,  7, 16,  8,237,  7,
 16,  5,237,  7, 16,  8,237, 89, 34,  9,  2,  7,  1,  1, 39,  1,
  1, 55,  1,  1,  5,156,254, 55,  1,201,119,254, 53,254, 53,118,
  1,200,254, 56,118,  1,203,  1,203,  4, 76,254, 53,254, 55,121,
  1,203,254, 53,121,  1,201,  1,203,121,254, 53,  1,203,  0,  1,
  0,137,  2,156,  2,197,  5,223,  0, 10,  0, 44, 64, 24,  7,  0,
221,  9,  3,221,  4,  2,221,  9,247,  5,145, 11,  8,124,  6, 93,
  3,124,  1,124,  0, 11, 16,220,244,228,252,228, 49,  0, 16,244,
236,236,212,236, 16,238, 50, 48, 19, 51, 17,  7, 53, 55, 51, 17,
 51, 21, 33,156,204,223,230,137,205,253,215,  3, 10,  2, 99, 41,
116, 39,253, 43,110,  0,  0,  1,  0, 94,  2,156,  2,180,  5,240,
  0, 24,  0, 74, 64, 36,  0,125,  6,  4,  0, 23,125,  6,  6,  4,
 66,  4,  2,  0, 14,221, 15,  0,221,  2,247, 11,221, 15, 18,145,
 25,  0, 14,  8,126,  1, 21, 14,  3, 25, 16,220,196,212,196,236,
 17, 57, 49,  0, 16,244,196,236,252,236, 16,238, 17, 18, 57, 48,
 75, 83, 88,  7, 16,  5,237, 23, 50,  7,  5,237, 89, 34,  1, 33,
 21, 33, 53, 54, 55,  0, 53, 52, 38, 35, 34,  6,  7, 53, 54, 54,
 51, 50, 22, 21, 20,  1,  6,  1, 12,  1,168,253,170, 34, 63,  1,
 88,104, 85, 52,122, 72, 77,133, 57,145,174,254,181, 56,  3, 14,
114,110, 31, 56,  1, 49, 94, 66, 81, 35, 35,123, 28, 28,132,108,
139,254,228, 48,  0,  1,  0, 98,  2,141,  2,205,  5,240,  0, 40,
  0, 72, 64, 39,  0, 21, 19, 10,221,  9, 31,221, 32, 19,221, 21,
 13,221,  9,248,  6,247, 28,221, 32,248, 35,145, 41, 22, 19,  0,
 20, 25,126, 38, 16,126,  3, 20, 31,  9, 41, 16,220,196,196,212,
236,212,236, 17, 57, 57, 57, 49,  0, 16,244,228,236,252,228,236,
212,236, 16,238, 16,238, 17, 18, 57, 48,  1, 22, 22, 21, 20,  6,
 35, 34, 38, 39, 53, 22, 22, 51, 50, 54, 53, 52, 38, 35, 35, 53,
 51, 50, 54, 53, 52, 38, 35, 34,  6,  7, 53, 54, 54, 51, 50, 22,
 21, 20,  6,  2, 12, 92,101,190,177, 57,125, 70, 52,119, 67,109,
120,111,108, 86, 94, 94, 97,100, 95, 40,102, 81, 73,128, 55,144,
169, 90,  4, 96, 18,109, 82,124,134, 21, 20,121, 27, 26, 79, 70,
 74, 76,108, 63, 60, 58, 61, 18, 23,115, 17, 18,118, 99, 69, 96,
255,255,  0,137,255,227,  7,127,  5,240,  0, 39,  0,240,  0,  0,
  0,  0,  0, 39,  0,188,  3, 53,  0,  0,  0,  7,  1,  9,  4,139,
253,100,255,255,  0,137,255,227,  7, 63,  5,240,  0, 39,  0,240,
  0,  0,  0,  0,  0, 39,  0,188,  3, 53,  0,  0,  0,  7,  0,241,
  4,139,253,100,255,255,  0, 98,255,227,  7,127,  5,240,  0, 39,
  0,242,  0,  0,  0,  0,  0, 39,  0,188,  3, 53,  0,  0,  0,  7,
  1,  9,  4,139,253,100,255,255,  0,115,255,227,  5,139,  7,109,
  2, 39,  0, 42,  0,  0,  0,  0,  0,  7,  1, 10,  1, 27,  1,117,
255,255,  0,113,254, 86,  4, 90,  6, 72,  2, 39,  0, 74,  0,  0,
  0,  0,  0,  7,  0,218,  0,139,  0,  0,255,255,  0,201,  0,  0,
  1,149,  7, 80,  2, 39,  0, 44,  0,  0,  0,  0,  0,  7,  1, 11,
255, 47,  1,117,255,255,  0,135,254,117,  4,162,  5,240,  2, 39,
  0, 54,  0,  0,  0,  0,  0,  7,  0,221,  0,139,  0,  0,255,255,
  0,111,254,117,  3,199,  4,123,  2, 39,  0, 86,  0,  0,  0,  0,
  0,  7,  0,221,  0, 23,  0,  0,255,255,  0,115,255,227,  5, 39,
  7,107,  2, 39,  0, 38,  0,  0,  0,  0,  0,  7,  1,  4,  1, 45,
  1,117,255,255,  0,113,255,227,  3,231,  6,102,  2, 39,  0, 70,
  0,  0,  0,  0,  0,  7,  0,141,  0,137,  0,  0,255,255,  0,115,
255,227,  5, 39,  7,109,  2, 39,  0, 38,  0,  0,  0,  0,  0,  7,
  1,  8,  1, 45,  1,117,255,255,  0,113,255,227,  3,231,  6,102,
  2, 39,  0, 70,  0,  0,  0,  0,  0,  7,  0,224,  0,137,  0,  0,
  0,  2,  0,113,255,227,  4,244,  6, 20,  0, 24,  0, 36,  0, 74,
 64, 36,  7,  3,211,  9,  1,249, 34,185,  0, 22, 28,185, 13, 16,
140, 22,184,  5,151, 11,  2, 31, 12,  4,  3,  0,  8,  8, 10,  6,
 71, 25, 18, 19, 69, 37, 16,252,236,244, 60,196,252, 23, 60,196,
 49,  0, 47,236,228,244,196,236, 16,196,238,253, 60,238, 50, 48,
182, 96, 38,128, 38,160, 38,  3,  1, 93,  1, 17, 33, 53, 33, 53,
 51, 21, 51, 21, 35, 17, 35, 53, 14,  1, 35, 34,  2, 17, 16, 18,
 51, 50, 22,  1, 20, 22, 51, 50, 54, 53, 52, 38, 35, 34,  6,  3,
162,254,186,  1, 70,184,154,154,184, 58,177,124,203,255,255,203,
124,177,253,199,167,146,146,168,168,146,146,167,  3,182,  1, 78,
125,147,147,125,250,252,168,100, 97,  1, 68,  1,  8,  1,  8,  1,
 68, 97,254, 21,203,231,231,203,203,231,231,  0,  0,  1,  0,100,
  1,223,  2,127,  2,131,  0,  3,  0, 17,182,  0,156,  2,  4,  1,
  0,  4, 16,220,204, 49,  0, 16,212,236, 48, 19, 33, 21, 33,100,
  2, 27,253,229,  2,131,164,  0,  0,  1,  0,219,  2, 72,  1,174,
  3, 70,  0,  3,  0, 18,183,  2,131,  0,  4,  1, 25,  0,  4, 16,
212,236, 49,  0, 16,212,236, 48, 19, 51, 21, 35,219,211,211,  3,
 70,254,  0,  1,  0,  0,255,227,  4,143,  5,240,  0, 49,  1, 28,
 64, 58, 32, 18,211, 34, 16, 43,  7,211,  9, 25,161, 26,174, 22,
149, 29,  1,161,  0,174,  4,149, 47,145, 29,140, 41,  9, 50, 43,
 34, 33, 41, 35, 38, 18, 16, 10,  3, 13,  9, 17,  8, 44, 32, 38,
 19,  7, 17,  8, 17, 13, 28, 25,  0, 38, 42, 33, 47, 60,212,196,
 50,252,196,196, 18, 57, 57, 18, 57, 57, 17, 18, 57, 17, 23, 57,
 18, 57, 57, 17, 57, 57, 49,  0, 16,196, 50,228,244,236,244,236,
 16,238,246,238, 16,238, 50,221, 60,238, 50, 48,  1, 75,176,  9,
 84, 75,176, 12, 84, 91, 75,176, 13, 84, 91, 75,176, 15, 84, 91,
 75,176, 23, 84, 91, 75,176, 24, 84, 91, 88,189,  0, 50,255,192,
  0,  1,  0, 50,  0, 50,  0, 64, 56, 17, 55, 56, 89, 64,122, 14,
  0, 14,  1, 11,  2, 11, 49, 84, 20,105, 12,108, 14,110, 15,111,
 16,111, 17,111, 18,111, 19,105, 20,107, 31,111, 32,111, 33,111,
 34,111, 35,110, 36,108, 37,105, 39,105, 45,159,  7,159,  8,159,
  9,159, 10,159, 11,159, 12,159, 13,159, 14,159, 15,159, 16,159,
 17,159, 18,159, 19,150, 31,159, 32,159, 33,159, 34,159, 35,159,
 36,159, 37,159, 38,159, 39,159, 40,159, 41,159, 42,159, 43,159,
 44,157, 45, 50,  0,  8,  0,  9, 16,  8, 16,  9, 32,  8, 32,  9,
 85, 21, 83, 30,106, 21,103, 31, 10, 93,  0, 93,  1, 21, 46,  1,
 35, 34,  6,  7, 33,  7, 33, 14,  1, 21, 20, 22, 23, 33,  7, 33,
 30,  1, 51, 50, 54, 55, 21, 14,  1, 35, 34,  0,  3, 35, 55, 51,
 52, 38, 53, 52, 54, 53, 35, 55, 51, 18,  0, 51, 50, 22,  4,143,
 91,169,102,157,202, 32,  2, 65, 55,253,230,  2,  1,  1,  2,  1,
190, 56,254,138, 32,202,157,102,169, 91, 89,185, 96,237,254,203,
 40,211, 55,139,  1,  1,194, 55,156, 40,  1, 54,236, 98,185,  5,
 98,213,105, 90,200,187,123, 24, 46, 35, 32, 46, 24,123,187,202,
 90,105,211, 72, 72,  1, 34,  1,  3,123, 23, 47, 32, 35, 47, 23,
123,  1,  1,  1, 34, 71,  0,  2,  0,215,  5, 14,  3, 41,  5,217,
  0,  3,  0,  7,  0,165, 64, 13,  4,  0,206,  6,  2,  8,  1,100,
  0,  5,100,  4,  8, 16,212,252,220,236, 49,  0, 16,212, 60,236,
 50, 48,  0, 75,176, 14, 84, 75,176, 17, 84, 91, 88,189,  0,  8,
  0, 64,  0,  1,  0,  8,  0,  8,255,192, 56, 17, 55, 56, 89,  1,
 75,176, 14, 84, 75,176, 13, 84, 91, 75,176, 23, 84, 91, 88,189,
  0,  8,255,192,  0,  1,  0,  8,  0,  8,  0, 64, 56, 17, 55, 56,
 89,  1, 75,176, 17, 84, 75,176, 25, 84, 91, 88,189,  0,  8,  0,
 64,  0,  1,  0,  8,  0,  8,255,192, 56, 17, 55, 56, 89,  0, 75,
176, 24, 84, 88,189,  0,  8,255,192,  0,  1,  0,  8,  0,  8,  0,
 64, 56, 17, 55, 56, 89, 64, 17, 96,  1, 96,  2, 96,  5, 96,  6,
112,  1,112,  2,112,  5,112,  6,  8,  1, 93,  1, 51, 21, 35, 37,
 51, 21, 35,  2, 94,203,203,254,121,203,203,  5,217,203,203,203,
  0,  1,  1,115,  4,238,  2,240,  5,246,  0,  3,  0,127, 64, 17,
  2,  3,  0,  3,  1,  0,  0,  3, 66,  0,  2,250,  4,  1,  3,  3,
  4, 16,196, 16,192, 49,  0, 16,244,204, 48, 75, 83, 88,  7, 16,
  5,201,  7, 16,  5,201, 89, 34,  0, 75,176, 12, 84, 88,189,  0,
  4,255,192,  0,  1,  0,  4,  0,  4,  0, 64, 56, 17, 55, 56, 89,
  0, 75,176, 14, 84, 88,189,  0,  4,  0, 64,  0,  1,  0,  4,  0,
  4,255,192, 56, 17, 55, 56, 89, 64, 32,  6,  2, 21,  2, 37,  1,
 37,  2, 54,  2, 70,  2, 86,  2,106,  1,103,  2,  9, 15,  0, 15,
  1, 31,  0, 31,  1, 47,  0, 47,  1,  6, 93,  1, 93,  1, 51,  3,
 35,  2, 55,185,228,153,  5,246,254,248,  0,  1,  0,182,  5, 14,
  3, 74,  5,233,  0, 29,  0,117, 64, 33, 22, 16, 15,  3, 19, 12,
  7,  1,  0,  3,  8, 23, 12,195,  4, 19,195, 27,  8,250, 30, 16,
  1, 15,  0,  7, 22, 86, 24,  7, 86,  9, 30, 16,212,236,212,236,
 17, 57, 57, 57, 57, 49,  0, 16,244, 60,236,212,236, 50, 18, 23,
 57, 17, 18, 23, 57, 48,  0, 75,176, 12, 84, 88,189,  0, 30,255,
192,  0,  1,  0, 30,  0, 30,  0, 64, 56, 17, 55, 56, 89,  0, 75,
176, 14, 84, 88,189,  0, 30,  0, 64,  0,  1,  0, 30,  0, 30,255,
192, 56, 17, 55, 56, 89,180, 16, 11, 31, 26,  2, 93,  1, 39, 46,
  1, 35, 34,  6, 29,  1, 35, 52, 54, 51, 50, 22, 31,  1, 30,  1,
 51, 50, 54, 61,  1, 51, 14,  1, 35, 34, 38,  1,252, 57, 25, 31,
 12, 36, 40,125,103, 86, 36, 61, 48, 57, 23, 34, 15, 32, 40,125,
  2,103, 84, 34, 59,  5, 57, 33, 14, 11, 50, 45,  6,101,118, 16,
 27, 30, 13, 12, 51, 41,  6,100,119, 16,  0,  1,  1, 12,  4,238,
  2,139,  5,246,  0,  3,  0,137, 64, 17,  1,  2,  3,  2,  0,  3,
  3,  2, 66,  0,  1,250,  4,  1,  3,  3,  4, 16,196, 16,192, 49,
  0, 16,244,204, 48, 75, 83, 88,  7, 16,  5,201,  7, 16,  5,201,
 89, 34,  0, 75,176, 12, 84, 88,189,  0,  4,255,192,  0,  1,  0,
  4,  0,  4,  0, 64, 56, 17, 55, 56, 89,  0, 75,176, 14, 84, 88,
189,  0,  4,  0, 64,  0,  1,  0,  4,  0,  4,255,192, 56, 17, 55,
 56, 89, 64, 42,  6,  0,  6,  1, 22,  0, 18,  1, 36,  0, 36,  1,
 53,  1, 67,  1, 85,  0, 85,  1,159,  0,159,  1,175,  0,175,  1,
 14, 15,  0, 15,  3, 31,  0, 31,  3, 47,  0, 47,  3,  6, 93,  1,
 93,  1, 19, 35,  3,  1,199,196,153,230,  5,246,254,248,  1,  8,
  0,  1,  0,207,  4,238,  3, 49,  5,248,  0,  6,  0,119, 64, 10,
  4,  0,  5,  2,250,  7,  4,  2,  6,  7, 16,212,196, 57, 49,  0,
 16,244, 60,196, 57, 48,  0, 75,176, 12, 84, 88,189,  0,  7,255,
192,  0,  1,  0,  7,  0,  7,  0, 64, 56, 17, 55, 56, 89,  0, 75,
176, 14, 84, 88,189,  0,  7,  0, 64,  0,  1,  0,  7,  0,  7,255,
192, 56, 17, 55, 56, 89,  1, 75,176, 14, 84, 88,189,  0,  7,255,
192,  0,  1,  0,  7,  0,  7,  0, 64, 56, 17, 55, 56, 89, 64, 19,
 15,  0, 15,  1, 12,  4, 31,  0, 31,  1, 29,  4, 47,  0, 47,  1,
 45,  4,  9,  0, 93,  1, 51, 19, 35, 39,  7, 35,  1,162,188,211,
139,166,166,139,  5,248,254,246,178,178,  0,  1,  0,207,  4,238,
  3, 49,  5,248,  0,  6,  0,134, 64, 10,  3,  4,  1,  0,250,  7,
  3,  5,  1,  7, 16,212,196, 57, 49,  0, 16,244,196, 50, 57, 48,
  0, 75,176, 12, 84, 75,176,  9, 84, 91, 75,176, 10, 84, 91, 75,
176, 11, 84, 91, 88,189,  0,  7,255,192,  0,  1,  0,  7,  0,  7,
  0, 64, 56, 17, 55, 56, 89,  0, 75,176, 14, 84, 88,189,  0,  7,
  0, 64,  0,  1,  0,  7,  0,  7,255,192, 56, 17, 55, 56, 89,  1,
 75,176, 14, 84, 88,189,  0,  7,255,192,  0,  1,  0,  7,  0,  7,
  0, 64, 56, 17, 55, 56, 89, 64, 19,  0,  0,  3,  3,  0,  6, 16,
  0, 18,  3, 16,  6, 32,  0, 34,  3, 32,  6,  9,  0, 93,  1,  3,
 51, 23, 55, 51,  3,  1,162,211,139,166,166,139,211,  4,238,  1,
 10,178,178,254,246,  0,  0,  2,  0, 63,  2,156,  2,244,  5,223,
  0,  2,  0, 13,  0,212, 64, 22,  0,  3, 11,  7,221,  5,  1,  9,
247,  3,145, 14,  1, 12, 10,  0, 93,  6,  8,  4, 12, 14, 16,220,
212, 60,196,236, 50, 17, 57, 49,  0, 16,244,252,212, 60,236, 50,
 18, 57, 48,  1, 75,176, 14, 84, 75,176, 15, 84, 91, 75,176, 16,
 84, 91, 75,176, 17, 84, 91, 75,176, 11, 84, 91, 75,176, 10, 84,
 91, 88,189,  0, 14,  0, 64,  0,  1,  0, 14,  0, 14,255,192, 56,
 17, 55, 56, 89,  0, 75,176, 17, 84, 75,176, 14, 84, 91, 88,189,
  0, 14,255,192,  0,  1,  0, 14,  0, 14,  0, 64, 56, 17, 55, 56,
 89, 64, 84, 11,  1, 29,  1, 47,  1, 57,  1, 73,  1, 70,  3, 89,
  3,105,  3,139,  3,171,  3,187,  3, 11,  1,  0, 15,  1, 15,  2,
 15,  5, 15,  6, 15,  7, 15,  8, 15, 11, 15, 12, 15, 13, 19,  0,
 31,  1, 31,  2, 31,  5, 31,  6, 31,  7, 31,  8, 31, 11, 31, 12,
 31, 13, 34,  0, 53,  0, 71,  0, 75, 13, 83,  0, 91, 13,101,  0,
132,  0,165,  0,181,  0, 30, 93,  1, 93,  9,  1, 33,  3, 51, 17,
 51, 21, 35, 21, 35, 53, 33, 53,  1,221,254,203,  1, 53, 22,166,
135,135,144,254, 98,  5,102,254, 93,  2, 28,253,228,109,186,186,
121,  0,  0,  1,  0,199,  5,  6,  3, 57,  5,248,  0, 13,  0,106,
 64, 14,  7,  0,  4,195, 11,250, 14,  7, 86,  8,  1, 86,  0, 14,
 16,212,236,212,236, 49,  0, 16,244,252,196, 50, 48,  0, 75,176,
 12, 84, 88,189,  0, 14,255,192,  0,  1,  0, 14,  0, 14,  0, 64,
 56, 17, 55, 56, 89,  0, 75,176, 14, 84, 88,189,  0, 14,  0, 64,
  0,  1,  0, 14,  0, 14,255,192, 56, 17, 55, 56, 89,  1, 75,176,
 14, 84, 75,176, 15, 84, 91, 88,189,  0, 14,255,192,  0,  1,  0,
 14,  0, 14,  0, 64, 56, 17, 55, 56, 89, 19, 51, 30,  1, 51, 50,
 54, 55, 51, 14,  1, 35, 34, 38,199,118, 13, 99, 83, 82, 97, 16,
118, 10,160,143,144,159,  5,248, 54, 57, 55, 56,119,123,122,  0,
  0,  1,  1,154,  5, 14,  2,102,  5,219,  0,  3,  0, 17,182,  0,
  2,250,  4,  1,  0,  4, 16,212,204, 49,  0, 16,244,204, 48,  1,
 51, 21, 35,  1,154,204,204,  5,219,205,  0,  0,  0,  0,  0,  2,
  0,  1,  0,  0,  0,  0,  0, 20,  0,  3,  0,  1,  0,  0,  1, 26,
  0,  0,  1,  6,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  1,  3,
  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  1,  0,  0,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12,
 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44,
 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60,
 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76,
 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92,
 93, 94, 95, 96, 97,  0, 98, 99,100,101,102,103,104,105,106,107,
108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,
124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,
140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,
156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,
172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,
188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,
204,205,206,207,208,209,  0,210,211,212,213,214,215,216,217,218,
219,220,221,222,223,224,  0,  4,  2, 62,  0,  0,  0, 58,  0, 32,
  0,  4,  0, 26,  0,126,  0,255,  1,  7,  1, 17,  1, 31,  1, 49,
  1, 66,  1, 83,  1, 97,  1,120,  1,126,  1,146,  2,199,  2,221,
  3,169,  3,192, 32, 38, 32, 48, 32, 58, 32,172, 33, 34, 34,  6,
 34, 30, 34, 43, 34, 72, 34,101, 37,202,251,  2,255,255,  0,  0,
  0, 32,  0,160,  1,  6,  1, 12,  1, 30,  1, 48,  1, 65,  1, 82,
  1, 94,  1,120,  1,125,  1,146,  2,198,  2,216,  3,169,  3,192,
 32, 19, 32, 48, 32, 57, 32,172, 33, 34, 34,  2, 34, 15, 34, 43,
 34, 72, 34, 96, 37,202,251,  1,255,255,255,227,  0,  0,255,245,
  0,  0,255,216,  0,  0,255,160,255, 94,  0,  0,255, 67,255,104,
255, 20,  0,  0,  0,  0,252,246,252,219,  0,  0,224,150,224,133,
224, 86,223,106,  0,  0,  0,  0,222,113,222, 95,  0,  0,218,239,
  5,191,  0,  1,  0,  0,  0, 56,  0,  0,  0,244,  0,  0,  0,252,
  0,  0,  0,  0,  0,250,  0,  0,  0,  0,  0,  0,  0,250,  0,252,
  0,  0,  0,  0,  1,  2,  0,  0,  0,  0,  0,  0,  0,  0,  1, 32,
  1, 40,  0,  0,  0,  0,  1, 66,  0,  0,  0,  0,  0,  0,  0,172,
  0,163,  0,132,  0,133,  0,189,  0,150,  0,231,  0,134,  0,142,
  0,139,  0,157,  0,169,  0,164,  1,  0,  0,138,  0,217,  0,131,
  0,147,  0,241,  0,242,  0,141,  0,151,  0,136,  0,195,  0,221,
  0,240,  0,158,  0,170,  0,243,  0,244,  0,245,  0,162,  0,173,
  0,201,  0,199,  0,174,  0, 98,  0, 99,  0,144,  0,100,  0,203,
  0,101,  0,200,  0,202,  0,207,  0,204,  0,205,  0,206,  0,232,
  0,102,  0,210,  0,208,  0,209,  0,175,  0,103,  0,239,  0,145,
  0,213,  0,211,  0,212,  0,104,  0,234,  0,236,  0,137,  0,106,
  0,105,  0,107,  0,109,  0,108,  0,110,  0,160,  0,111,  0,113,
  0,112,  0,114,  0,115,  0,117,  0,116,  0,118,  0,119,  0,233,
  0,120,  0,122,  0,121,  0,123,  0,125,  0,124,  0,184,  0,161,
  0,127,  0,126,  0,128,  0,129,  0,235,  0,237,  0,186,  0,253,
  0,254,  0,  0,  0,  0,  0,  0,  0,255,  0,248,  0,214,  0,249,
  0,250,  0,227,  0,228,  0,215,  0,224,  0,218,  0,219,  0,220,
  0,223,  0,216,  0,222,  0,178,  0,179,  0,  0,  0,  0,  0,  0,
  0,182,  0,183,  0,196,  0,  0,  0,180,  0,181,  0,197,  0,  0,
  0,130,  0,194,  0,135,  0,  0,  0,  0,  0,  0,  0,171,  0,152,
  0,  0,  0,  0,  0,  0,  0,168,  0,154,  0,  0,  0,153,  0,238,
  0,  0,  0,  0,  0,188,  0,  0,  0,  0,  0,  0,  1,  1,  0,165,
  0,  0,  0,  0,  0,  0,  0,146,  0,143,  0,  0,  0,  0,  0,  0,
  0,148,  0,149,  4,205,  0,102,  0,  0,  0,  0,  2,139,  0,  0,
  2,139,  0,  0,  3, 53,  1, 53,  3,174,  0,197,  6,180,  0,158,
  5, 23,  0,170,  7,154,  0,113,  6, 61,  0,129,  2, 51,  0,197,
  3, 31,  0,176,  3, 31,  0,164,  4,  0,  0, 61,  6,180,  0,217,
  2,139,  0,158,  2,227,  0,100,  2,139,  0,219,  2,178,  0,  0,
  5, 23,  0,135,  5, 23,  0,225,  5, 23,  0,150,  5, 23,  0,156,
  5, 23,  0,100,  5, 23,  0,158,  5, 23,  0,143,  5, 23,  0,168,
  5, 23,  0,139,  5, 23,  0,129,  2,178,  0,240,  2,178,  0,158,
  6,180,  0,217,  6,180,  0,217,  6,180,  0,217,  4, 63,  0,147,
  8,  0,  0,135,  5,121,  0, 16,  5,125,  0,201,  5,150,  0,115,
  6, 41,  0,201,  5, 14,  0,201,  4,154,  0,201,  6, 51,  0,115,
  6,  4,  0,201,  2, 92,  0,201,  2, 92,255,150,  5, 63,  0,201,
  4,117,  0,201,  6,231,  0,201,  5,252,  0,201,  6, 76,  0,115,
  4,211,  0,201,  6, 76,  0,115,  5,143,  0,201,  5, 20,  0,135,
  4,227,255,250,  5,219,  0,178,  5,121,  0, 16,  7,233,  0, 68,
  5,123,  0, 61,  4,227,255,252,  5,123,  0, 92,  3, 31,  0,176,
  2,178,  0,  0,  3, 31,  0,199,  6,180,  0,217,  4,  0,255,236,
  4,  0,  0,170,  4,231,  0,123,  5, 20,  0,186,  4,102,  0,113,
  5, 20,  0,113,  4,236,  0,113,  2,209,  0, 47,  5, 20,  0,113,
  5, 18,  0,186,  2, 57,  0,193,  2, 57,255,219,  4,162,  0,186,
  2, 57,  0,193,  7,203,  0,186,  5, 18,  0,186,  4,229,  0,113,
  5, 20,  0,186,  5, 20,  0,113,  3, 74,  0,186,  4, 43,  0,111,
  3, 35,  0, 55,  5, 18,  0,174,  4,188,  0, 61,  6,139,  0, 86,
  4,188,  0, 59,  4,188,  0, 61,  4, 51,  0, 88,  5, 23,  1,  0,
  2,178,  1,  4,  5, 23,  1,  0,  6,180,  0,217,  5,121,  0, 16,
  5,121,  0, 16,  5,150,  0,115,  5, 14,  0,201,  5,252,  0,201,
  6, 76,  0,115,  5,219,  0,178,  4,231,  0,123,  4,231,  0,123,
  4,231,  0,123,  4,231,  0,123,  4,231,  0,123,  4,231,  0,123,
  4,102,  0,113,  4,236,  0,113,  4,236,  0,113,  4,236,  0,113,
  4,236,  0,113,  2, 57,  0,144,  2, 57,255,199,  2, 57,255,222,
  2, 57,255,244,  5, 18,  0,186,  4,229,  0,113,  4,229,  0,113,
  4,229,  0,113,  4,229,  0,113,  4,229,  0,113,  5, 18,  0,174,
  5, 18,  0,174,  5, 18,  0,174,  5, 18,  0,174,  4,  0,  0, 57,
  4,  0,  0,195,  5, 23,  0,172,  5, 23,  0,129,  4,  0,  0, 92,
  4,184,  1, 51,  5, 23,  0,158,  5, 10,  0,186,  8,  0,  1, 27,
  8,  0,  1, 27,  8,  0,  1, 39,  4,  0,  1,115,  4,  0,  0,215,
  6,180,  0,217,  7,203,  0,  8,  6, 76,  0,102,  6,170,  0,221,
  6,180,  0,217,  6,180,  0,217,  6,180,  0,217,  5, 23,  0, 82,
  5, 23,  0,174,  4, 35,  0,104,  5,100,  0, 25,  6, 14,  0,156,
  4,182,255,225,  4, 43,  0, 47,  3,197,  0,115,  3,197,  0, 96,
  6, 29,  0, 78,  7,219,  0,123,  4,229,  0, 72,  4, 63,  0,143,
  3, 53,  1, 53,  6,180,  0,217,  5, 25,  0, 61,  5, 23,  0, 31,
  6,180,  0,217,  5, 90,255,250,  4,229,  0,158,  4,229,  0,193,
  8,  0,  0,236,  5, 23,  0,  0,  5,121,  0, 16,  5,121,  0, 16,
  6, 76,  0,115,  8,143,  0,115,  8, 47,  0,113,  4,  0,  0,  0,
  8,  0,  0,  0,  4, 37,  0,174,  4, 37,  0,174,  2,139,  0,174,
  2,139,  0,178,  6,180,  0,217,  3,244,  0,  6,  4,188,  0, 61,
  4,227,255,252,  1, 86,254,137,  5, 23,  0, 94,  3, 51,  0,158,
  3, 51,  0,193,  5, 10,  0, 47,  5, 10,  0, 47,  4,  0,  0, 57,
  2,139,  0,219,  2,139,  0,174,  4, 37,  0,174, 10,188,  0,113,
  5,121,  0, 16,  5, 14,  0,201,  5,121,  0, 16,  5, 14,  0,201,
  5, 14,  0,201,  2, 92,  0,162,  2, 92,255,254,  2, 92,  0,  6,
  2, 92,  0, 59,  6, 76,  0,115,  6, 76,  0,115,  6, 76,  0,115,
  5,219,  0,178,  5,219,  0,178,  5,219,  0,178,  2, 57,  0,193,
  4,  0,  0,193,  4,  0,  0,182,  4,  0,  0,213,  4,  0,  0,199,
  4,  0,  1,154,  4,  0,  0,238,  4,  0,  1, 35,  4,  0,  0,240,
  4,  0,  1, 76,  4,  0,  0,193,  4,127,255,242,  2, 70,  0,  2,
  5, 20,  0,135,  4, 43,  0,111,  5,123,  0, 92,  4, 51,  0, 88,
  2,178,  1,  4,  6, 51,  0, 10,  4,229,  0,113,  4,227,255,252,
  4,188,  0, 61,  4,215,  0,201,  5, 20,  0,186,  6,180,  0,217,
  6,180,  1, 25,  3, 53,  0,137,  3, 53,  0, 94,  3, 53,  0, 98,
  7,193,  0,137,  7,193,  0,137,  7,193,  0, 98,  6, 51,  0,115,
  5, 20,  0,113,  2, 92,  0,201,  5, 20,  0,135,  4, 43,  0,111,
  5,150,  0,115,  4,102,  0,113,  5,150,  0,115,  4,102,  0,113,
  5, 20,  0,113,  2,227,  0,100,  2,139,  0,219,  5, 23,  0,  0,
  4,  0,  0,215,  4,  0,  1,115,  4,  0,  0,182,  4,  0,  1, 12,
  4,  0,  0,207,  4,  0,  0,207,  3, 53,  0, 63,  4,  0,  0,199,
  4,  0,  1,154,  0,  2,  0,  0,  0,  0,  0,  0,255, 43,  0,143,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  1, 12,  0,  0,  0,  1,  0,  2,  0,  3,  0,  4,
  0,  5,  0,  6,  0,  7,  0,  8,  0,  9,  0, 10,  0, 11,  0, 12,
  0, 13,  0, 14,  0, 15,  0, 16,  0, 17,  0, 18,  0, 19,  0, 20,
  0, 21,  0, 22,  0, 23,  0, 24,  0, 25,  0, 26,  0, 27,  0, 28,
  0, 29,  0, 30,  0, 31,  0, 32,  0, 33,  0, 34,  0, 35,  0, 36,
  0, 37,  0, 38,  0, 39,  0, 40,  0, 41,  0, 42,  0, 43,  0, 44,
  0, 45,  0, 46,  0, 47,  0, 48,  0, 49,  0, 50,  0, 51,  0, 52,
  0, 53,  0, 54,  0, 55,  0, 56,  0, 57,  0, 58,  0, 59,  0, 60,
  0, 61,  0, 62,  0, 63,  0, 64,  0, 65,  0, 66,  0, 67,  0, 68,
  0, 69,  0, 70,  0, 71,  0, 72,  0, 73,  0, 74,  0, 75,  0, 76,
  0, 77,  0, 78,  0, 79,  0, 80,  0, 81,  0, 82,  0, 83,  0, 84,
  0, 85,  0, 86,  0, 87,  0, 88,  0, 89,  0, 90,  0, 91,  0, 92,
  0, 93,  0, 94,  0, 95,  0, 96,  0, 97,  0, 98,  0, 99,  0,100,
  0,101,  0,102,  0,103,  0,104,  0,105,  0,106,  0,107,  0,108,
  0,109,  0,110,  0,111,  0,112,  0,113,  0,114,  0,115,  0,116,
  0,117,  0,118,  0,119,  0,120,  0,121,  0,122,  0,123,  0,124,
  0,125,  0,126,  0,127,  0,128,  0,129,  0,130,  0,131,  0,132,
  0,133,  0,134,  0,135,  0,136,  0,137,  0,138,  0,139,  0,140,
  0,141,  0,142,  0,143,  0,144,  0,145,  0,146,  0,147,  0,148,
  0,149,  0,150,  0,151,  0,152,  0,153,  0,154,  0,155,  0,156,
  0,157,  0,158,  0,159,  0,160,  0,161,  0,162,  0,163,  0,164,
  0,165,  0,166,  0,167,  0,168,  0,169,  0,170,  0,171,  0,172,
  0,173,  0,174,  0,175,  0,176,  0,177,  0,178,  0,179,  0,180,
  0,181,  0,182,  0,183,  0,184,  0,185,  0,186,  0,187,  0,188,
  0,189,  0,190,  0,191,  0,192,  0,193,  0,194,  0,195,  0,196,
  0,197,  0,198,  0,199,  0,200,  0,201,  0,202,  0,203,  0,204,
  0,205,  0,206,  0,207,  0,208,  0,209,  0,211,  0,212,  0,213,
  0,214,  0,215,  0,216,  0,217,  0,218,  0,219,  0,220,  0,221,
  0,222,  0,223,  0,224,  0,225,  0,226,  0,227,  0,228,  0,229,
  0,230,  0,231,  0,232,  0,233,  0,234,  0,235,  0,236,  0,237,
  0,238,  0,239,  0,240,  0,241,  0,242,  0,243,  0,245,  0,244,
  0,246,  0,248,  0,249,  0,250,  0,251,  0,252,  0,253,  0,254,
  0,255,  1,  0,  1,  1,  1,  2,  1,  3,  1,  4,  1,  5,  1,  6,
  1,  7,  1,  8,  1,  9,  1, 10,  1, 11,  1, 12,  1, 13,  9,115,
102,116,104,121,112,104,101,110, 14,112,101,114,105,111,100, 99,
101,110,116,101,114,101,100,  4, 69,117,114,111,  5, 99, 54, 52,
 53, 57,  5, 99, 54, 52, 54, 48,  5, 99, 54, 52, 54, 49,  5, 99,
 54, 52, 54, 50,  5, 99, 54, 52, 54, 51,  5, 99, 54, 52, 54, 54,
  5, 99, 54, 52, 54, 55,  5, 99, 54, 52, 54, 56,  5, 99, 54, 52,
 54, 57,  0,  0,  0,  0,  0, 34,  0, 34,  0, 34,  0, 34,  0, 88,
  0,147,  0,255,  1,182,  2, 79,  3,131,  3,178,  3,246,  4, 33,
  4,110,  4,152,  4,180,  4,202,  4,222,  5,  3,  5, 69,  5,130,
  6,  5,  6,126,  6,225,  7, 76,  7,183,  7,252,  8,101,  8,207,
  8,238,  9, 22,  9, 82,  9,115,  9,174, 10, 31, 10,223, 11, 88,
 11,176, 11,251, 12, 58, 12,105, 12,147, 12,230, 13, 20, 13, 61,
 13,122, 14, 13, 14, 47, 14,172, 15,  0, 15, 69, 15,133, 15,235,
 16,117, 16,241, 17, 41, 17,112, 17,224, 18,189, 19,138, 19,235,
 20, 80, 20,139, 20,177, 20,225, 21,  3, 21, 24, 21, 64, 21,214,
 22, 34, 22,109, 22,185, 23, 35, 23,123, 23,223, 24, 27, 24, 67,
 24,128, 24,248, 25, 22, 25,119, 25,179, 26,  4, 26, 82, 26,161,
 26,216, 27,135, 27,196, 28,  0, 28,157, 29,186, 30,135, 31,119,
 31,232, 32, 91, 32,114, 32,243, 33, 53, 33, 66, 33,226, 33,239,
 33,252, 34,  9, 34, 22, 34, 35, 34, 48, 34, 61, 34, 74, 34, 87,
 34,100, 34,113, 34,126, 34,139, 34,152, 34,165, 34,178, 34,191,
 34,204, 34,217, 34,230, 34,243, 35,  0, 35, 13, 35, 26, 35, 39,
 35, 52, 35, 65, 35, 78, 35, 91, 35,104, 35,148, 35,207, 36, 52,
 36,143, 37, 51, 37, 83, 37,129, 38, 20, 38,186, 39, 75, 39,144,
 39,183, 40, 19, 40, 88, 40,195, 41, 95, 42, 37, 42, 92, 42,163,
 42,233, 43,122, 43,211, 44, 68, 44,143, 44,177, 45, 80, 45,160,
 46, 14, 46, 82, 46,170, 47,135, 48, 65, 48,189, 49,  5, 49, 33,
 49, 80, 49,207, 50, 72, 50,122, 50,223, 51, 70, 51,112, 51,112,
 51,125, 51,138, 51,151, 51,230, 52,122, 52,143, 52,163, 52,209,
 52,255, 53, 28, 53, 57, 53,103, 53,145, 53,158, 53,171, 53,207,
 54, 91, 54,147, 54,205, 55, 67, 55,169, 55,235, 56,  0, 56, 28,
 56, 74, 57, 15, 57, 28, 57, 41, 57, 54, 57, 67, 57, 80, 57, 93,
 57,106, 57,119, 57,132, 57,145, 57,158, 57,171, 57,184, 57,197,
 57,210, 57,239, 58, 28, 58,123, 58,160, 58,229, 59,  8, 59, 94,
 59,142, 59,196, 59,244, 60, 34, 60, 95, 60,167, 60,180, 60,193,
 60,206, 60,219, 60,254, 61, 99, 62, 59, 62, 72, 62, 85, 62,152,
 62,231, 62,253, 63, 97, 63,141, 63,220, 64, 58, 64, 75, 64, 92,
 64,109, 64,122, 64,135, 64,148, 64,161, 64,174, 64,187, 64,200,
 64,213, 64,226, 65, 64, 65, 86, 65,107, 66, 69, 66,170, 66,247,
 67, 95, 67,178, 67,255, 68, 85, 68,219, 69, 42, 69, 63,  0,  0,
  0,  0,  0,  1,  0,  0, 45,134,  0,  1,  7,148, 24,  0,  0, 10,
 21,120,  0, 16,  0, 36,255,211,  0, 16,  0, 37,255,183,  0, 16,
  0, 38,  0,  0,  0, 16,  0, 39,  0,  0,  0, 16,  0, 41,  0,  0,
  0, 16,  0, 42,  0, 75,  0, 16,  0, 43,  0,  0,  0, 16,  0, 45,
  0,114,  0, 16,  0, 46,  0,  0,  0, 16,  0, 47,  0,  0,  0, 16,
  0, 50,  0, 57,  0, 16,  0, 51,  0,  0,  0, 16,  0, 52,  0, 75,
  0, 16,  0, 53,  0,  0,  0, 16,  0, 55,255, 68,  0, 16,  0, 57,
255,136,  0, 16,  0, 58,255,173,  0, 16,  0, 59,255,154,  0, 16,
  0, 60,255, 13,  0, 16,  0, 61,  0,  0,  0, 16,  0, 73,  0,  0,
  0, 16,  0, 81,  0,  0,  0, 16,  0, 82,  0, 38,  0, 16,  0, 85,
  0,  0,  0, 16,  0, 89,255,201,  0, 16,  0, 90,  0,  0,  0, 16,
  0, 92,255,220,  0, 16,  0, 98,255,211,  0, 16,  0,100,  0,  0,
  0, 16,  0,103,  0, 57,  0, 16,  0,120,  0,  0,  0, 16,  0,121,
  0, 38,  0, 16,  0,122,  0, 38,  0, 16,  0,123,  0, 38,  0, 16,
  0,124,  0, 38,  0, 16,  0,125,  0, 38,  0, 16,  0,137,  0,  0,
  0, 16,  0,144,  0,  0,  0, 16,  0,173,255,211,  0, 16,  0,174,
255,211,  0, 16,  0,175,  0, 57,  0, 16,  0,186,255,220,  0, 16,
  0,187,255, 13,  0, 16,  0,199,255,211,  0, 16,  0,201,255,211,
  0, 16,  0,208,  0, 57,  0, 16,  0,209,  0, 57,  0, 16,  0,210,
  0, 57,  0, 16,  0,229,  0,  0,  0, 16,  0,233,  0,  0,  0, 16,
  0,234,255, 13,  0, 16,  0,235,255,220,  0, 16,  0,236,  0,  0,
  0, 16,  0,246,  0, 75,  0, 16,  0,251,  0,  0,  0, 16,  0,253,
  0,  0,  0, 36,  0, 16,255,211,  0, 36,  0, 17,255,220,  0, 36,
  0, 29,255,220,  0, 36,  0, 36,  0, 57,  0, 36,  0, 38,255,220,
  0, 36,  0, 42,255,220,  0, 36,  0, 50,255,220,  0, 36,  0, 52,
255,220,  0, 36,  0, 54,  0,  0,  0, 36,  0, 55,255, 97,  0, 36,
  0, 56,  0,  0,  0, 36,  0, 57,255,125,  0, 36,  0, 58,255,144,
  0, 36,  0, 59,  0,  0,  0, 36,  0, 60,255, 97,  0, 36,  0, 70,
255,220,  0, 36,  0, 71,255,220,  0, 36,  0, 72,255,220,  0, 36,
  0, 73,255,183,  0, 36,  0, 82,255,220,  0, 36,  0, 84,255,220,
  0, 36,  0, 87,255,220,  0, 36,  0, 88,  0,  0,  0, 36,  0, 89,
255,136,  0, 36,  0, 90,255,173,  0, 36,  0, 92,255,117,  0, 36,
  0, 98,  0, 57,  0, 36,  0,100,255,220,  0, 36,  0,103,255,220,
  0, 36,  0,104,  0,  0,  0, 36,  0,111,255,220,  0, 36,  0,112,
255,220,  0, 36,  0,113,255,220,  0, 36,  0,114,255,220,  0, 36,
  0,115,255,220,  0, 36,  0,121,255,220,  0, 36,  0,122,255,220,
  0, 36,  0,123,255,220,  0, 36,  0,124,255,220,  0, 36,  0,125,
255,220,  0, 36,  0,126,  0,  0,  0, 36,  0,127,  0,  0,  0, 36,
  0,128,  0,  0,  0, 36,  0,129,  0,  0,  0, 36,  0,169,255,183,
  0, 36,  0,170,  0,  0,  0, 36,  0,173,  0, 57,  0, 36,  0,174,
  0, 57,  0, 36,  0,175,255,220,  0, 36,  0,180,254,248,  0, 36,
  0,181,255,  3,  0, 36,  0,186,255,117,  0, 36,  0,187,255, 97,
  0, 36,  0,197,  0, 47,  0, 36,  0,199,  0, 57,  0, 36,  0,201,
  0, 57,  0, 36,  0,208,255,220,  0, 36,  0,209,255,220,  0, 36,
  0,210,255,220,  0, 36,  0,211,  0,  0,  0, 36,  0,212,  0,  0,
  0, 36,  0,213,  0,  0,  0, 36,  0,227,  0,  0,  0, 36,  0,234,
255, 97,  0, 36,  0,235,255,117,  0, 36,  0,246,255,220,  0, 36,
  0,249,  0,  0,  0, 36,  0,251,255,220,  0, 36,  0,252,255,220,
  0, 36,  0,253,255,220,  0, 36,  0,254,255,220,  0, 37,  0, 16,
  0,  0,  0, 37,  0, 38,255,220,  0, 37,  0, 42,255,220,  0, 37,
  0, 50,255,220,  0, 37,  0, 54,255,220,  0, 37,  0, 57,255,193,
  0, 37,  0, 58,255,183,  0, 37,  0, 60,255,144,  0, 37,  0,100,
255,220,  0, 37,  0,103,255,220,  0, 37,  0,169,255,193,  0, 37,
  0,170,255,220,  0, 37,  0,175,255,220,  0, 37,  0,180,255,144,
  0, 37,  0,181,255,144,  0, 37,  0,187,255,144,  0, 37,  0,197,
255,173,  0, 37,  0,208,255,220,  0, 37,  0,209,255,220,  0, 37,
  0,210,255,220,  0, 37,  0,227,255,220,  0, 37,  0,234,255,144,
  0, 37,  0,246,255,220,  0, 37,  0,249,255,220,  0, 37,  0,251,
255,220,  0, 37,  0,253,255,220,  0, 38,  0, 16,  0,  0,  0, 38,
  0, 36,  0,  0,  0, 38,  0, 54,  0,  0,  0, 38,  0, 60,255,220,
  0, 38,  0, 98,  0,  0,  0, 38,  0,169,255,220,  0, 38,  0,170,
255,220,  0, 38,  0,173,  0,  0,  0, 38,  0,174,  0,  0,  0, 38,
  0,180,  0,  0,  0, 38,  0,181,  0, 38,  0, 38,  0,187,255,220,
  0, 38,  0,197,  0,  0,  0, 38,  0,199,  0,  0,  0, 38,  0,201,
  0,  0,  0, 38,  0,227,  0,  0,  0, 38,  0,234,255,220,  0, 38,
  0,249,  0,  0,  0, 39,  0, 16,  0,  0,  0, 39,  0, 36,255,220,
  0, 39,  0, 57,255,220,  0, 39,  0, 58,  0,  0,  0, 39,  0, 60,
255,144,  0, 39,  0, 98,255,220,  0, 39,  0,169,255,220,  0, 39,
  0,170,255,220,  0, 39,  0,173,255,220,  0, 39,  0,174,255,220,
  0, 39,  0,180,255,211,  0, 39,  0,181,255,201,  0, 39,  0,187,
255,144,  0, 39,  0,197,255, 68,  0, 39,  0,199,255,220,  0, 39,
  0,201,255,220,  0, 39,  0,234,255,144,  0, 41,  0, 16,  0,  0,
  0, 41,  0, 17,254,183,  0, 41,  0, 29,255, 97,  0, 41,  0, 36,
255, 68,  0, 41,  0, 54,255,220,  0, 41,  0, 55,255,220,  0, 41,
  0, 68,255, 68,  0, 41,  0, 72,255,144,  0, 41,  0, 76,255,107,
  0, 41,  0, 82,255,183,  0, 41,  0, 85,255,107,  0, 41,  0, 88,
255,144,  0, 41,  0, 92,255, 68,  0, 41,  0, 98,255, 68,  0, 41,
  0,105,255, 68,  0, 41,  0,106,255, 68,  0, 41,  0,107,255, 68,
  0, 41,  0,108,255, 68,  0, 41,  0,109,255, 68,  0, 41,  0,110,
255, 68,  0, 41,  0,112,255,144,  0, 41,  0,113,255,144,  0, 41,
  0,114,255,144,  0, 41,  0,115,255,144,  0, 41,  0,121,255,183,
  0, 41,  0,122,255,183,  0, 41,  0,123,255,183,  0, 41,  0,124,
255,183,  0, 41,  0,125,255,183,  0, 41,  0,126,255,144,  0, 41,
  0,127,255,144,  0, 41,  0,128,255,144,  0, 41,  0,129,255,144,
  0, 41,  0,169,  0,  0,  0, 41,  0,170,  0,  0,  0, 41,  0,173,
255, 68,  0, 41,  0,174,255, 68,  0, 41,  0,180,255,211,  0, 41,
  0,181,  0,  0,  0, 41,  0,186,255, 68,  0, 41,  0,197,254,136,
  0, 41,  0,199,255, 68,  0, 41,  0,201,255, 68,  0, 41,  0,227,
255,220,  0, 41,  0,235,255, 68,  0, 41,  0,249,255,220,  0, 42,
  0, 16,  0,  0,  0, 42,  0, 36,  0,  0,  0, 42,  0, 55,255,183,
  0, 42,  0, 58,  0,  0,  0, 42,  0, 60,255,154,  0, 42,  0, 98,
  0,  0,  0, 42,  0,169,255,220,  0, 42,  0,170,255,220,  0, 42,
  0,173,  0,  0,  0, 42,  0,174,  0,  0,  0, 42,  0,180,255,211,
  0, 42,  0,181,255,211,  0, 42,  0,187,255,154,  0, 42,  0,197,
255,201,  0, 42,  0,199,  0,  0,  0, 42,  0,201,  0,  0,  0, 42,
  0,234,255,154,  0, 43,  0, 16,  0,  0,  0, 43,  0, 17,255,220,
  0, 43,  0, 29,  0,  0,  0, 43,  0,169,  0,  0,  0, 43,  0,170,
  0,  0,  0, 43,  0,180,255,183,  0, 43,  0,181,255,193,  0, 43,
  0,197,255,183,  0, 45,  0, 16,255,183,  0, 45,  0, 36,255,220,
  0, 45,  0, 98,255,220,  0, 45,  0,169,255,220,  0, 45,  0,170,
255,220,  0, 45,  0,173,255,220,  0, 45,  0,174,255,220,  0, 45,
  0,180,255,183,  0, 45,  0,181,255,193,  0, 45,  0,197,255,144,
  0, 45,  0,199,255,220,  0, 45,  0,201,255,220,  0, 46,  0, 16,
255, 41,  0, 46,  0, 36,255,220,  0, 46,  0, 38,255,144,  0, 46,
  0, 50,255,144,  0, 46,  0, 55,255, 97,  0, 46,  0, 56,255,201,
  0, 46,  0, 58,255,183,  0, 46,  0, 60,255,183,  0, 46,  0, 68,
255,220,  0, 46,  0, 72,255,154,  0, 46,  0, 82,255,154,  0, 46,
  0, 88,255,154,  0, 46,  0, 92,255,107,  0, 46,  0, 98,255,220,
  0, 46,  0,100,255,144,  0, 46,  0,103,255,144,  0, 46,  0,104,
255,201,  0, 46,  0,105,255,220,  0, 46,  0,106,255,220,  0, 46,
  0,107,255,220,  0, 46,  0,108,255,220,  0, 46,  0,109,255,220,
  0, 46,  0,110,255,220,  0, 46,  0,112,255,154,  0, 46,  0,113,
255,154,  0, 46,  0,114,255,154,  0, 46,  0,115,255,154,  0, 46,
  0,121,255,154,  0, 46,  0,122,255,154,  0, 46,  0,123,255,154,
  0, 46,  0,124,255,154,  0, 46,  0,125,255,154,  0, 46,  0,126,
255,154,  0, 46,  0,127,255,154,  0, 46,  0,128,255,154,  0, 46,
  0,129,255,154,  0, 46,  0,169,255,125,  0, 46,  0,170,  0,  0,
  0, 46,  0,173,255,220,  0, 46,  0,174,255,220,  0, 46,  0,175,
255,144,  0, 46,  0,180,255,193,  0, 46,  0,181,255,193,  0, 46,
  0,186,255,107,  0, 46,  0,187,255,183,  0, 46,  0,197,  0,  0,
  0, 46,  0,199,255,220,  0, 46,  0,201,255,220,  0, 46,  0,208,
255,144,  0, 46,  0,209,255,144,  0, 46,  0,210,255,144,  0, 46,
  0,211,255,201,  0, 46,  0,212,255,201,  0, 46,  0,213,255,201,
  0, 46,  0,234,255,183,  0, 46,  0,235,255,107,  0, 46,  0,251,
255,144,  0, 46,  0,253,255,144,  0, 47,  0, 16,255,220,  0, 47,
  0, 36,  0, 47,  0, 47,  0, 50,255,183,  0, 47,  0, 55,254,230,
  0, 47,  0, 56,255,154,  0, 47,  0, 57,255, 31,  0, 47,  0, 58,
255, 68,  0, 47,  0, 60,254,240,  0, 47,  0, 68,  0,  0,  0, 47,
  0, 72,255,220,  0, 47,  0, 82,255,220,  0, 47,  0, 88,255,220,
  0, 47,  0, 92,255, 68,  0, 47,  0, 98,  0, 47,  0, 47,  0,103,
255,183,  0, 47,  0,104,255,154,  0, 47,  0,105,  0,  0,  0, 47,
  0,106,  0,  0,  0, 47,  0,107,  0,  0,  0, 47,  0,108,  0,  0,
  0, 47,  0,109,  0,  0,  0, 47,  0,110,  0,  0,  0, 47,  0,112,
255,220,  0, 47,  0,113,255,220,  0, 47,  0,114,255,220,  0, 47,
  0,115,255,220,  0, 47,  0,121,255,220,  0, 47,  0,122,255,220,
  0, 47,  0,123,255,220,  0, 47,  0,124,255,220,  0, 47,  0,125,
255,220,  0, 47,  0,126,255,220,  0, 47,  0,127,255,220,  0, 47,
  0,128,255,220,  0, 47,  0,129,255,220,  0, 47,  0,169,  0,  0,
  0, 47,  0,170,  0,  0,  0, 47,  0,173,  0, 47,  0, 47,  0,174,
  0, 47,  0, 47,  0,175,255,183,  0, 47,  0,180,254, 97,  0, 47,
  0,181,253,230,  0, 47,  0,186,255, 68,  0, 47,  0,187,254,240,
  0, 47,  0,197,  0,  0,  0, 47,  0,199,  0, 47,  0, 47,  0,201,
  0, 47,  0, 47,  0,208,255,183,  0, 47,  0,209,255,183,  0, 47,
  0,210,255,183,  0, 47,  0,211,255,154,  0, 47,  0,212,255,154,
  0, 47,  0,213,255,154,  0, 47,  0,234,254,240,  0, 47,  0,235,
255, 68,  0, 50,  0, 16,  0, 57,  0, 50,  0, 17,255,173,  0, 50,
  0, 29,255,220,  0, 50,  0, 36,255,220,  0, 50,  0, 57,255,220,
  0, 50,  0, 59,255,125,  0, 50,  0, 60,255,144,  0, 50,  0, 98,
255,220,  0, 50,  0,169,255,220,  0, 50,  0,170,  0,  0,  0, 50,
  0,173,255,220,  0, 50,  0,174,255,220,  0, 50,  0,180,255,211,
  0, 50,  0,181,255,220,  0, 50,  0,187,255,144,  0, 50,  0,197,
255, 68,  0, 50,  0,199,255,220,  0, 50,  0,201,255,220,  0, 50,
  0,234,255,144,  0, 51,  0, 16,255,211,  0, 51,  0, 17,254,193,
  0, 51,  0, 29,  0,  0,  0, 51,  0, 36,255,125,  0, 51,  0, 56,
  0,  0,  0, 51,  0, 58,  0,  0,  0, 51,  0, 60,255,211,  0, 51,
  0, 68,255,164,  0, 51,  0, 72,255,183,  0, 51,  0, 76,255,211,
  0, 51,  0, 81,255,220,  0, 51,  0, 82,255,183,  0, 51,  0, 85,
255,220,  0, 51,  0, 86,255,220,  0, 51,  0, 88,255,220,  0, 51,
  0, 92,  0,  0,  0, 51,  0, 98,255,125,  0, 51,  0,104,  0,  0,
  0, 51,  0,105,255,164,  0, 51,  0,106,255,164,  0, 51,  0,107,
255,164,  0, 51,  0,108,255,164,  0, 51,  0,109,255,164,  0, 51,
  0,110,255,164,  0, 51,  0,112,255,183,  0, 51,  0,113,255,183,
  0, 51,  0,114,255,183,  0, 51,  0,115,255,183,  0, 51,  0,120,
255,220,  0, 51,  0,121,255,183,  0, 51,  0,122,255,183,  0, 51,
  0,123,255,183,  0, 51,  0,124,255,183,  0, 51,  0,125,255,183,
  0, 51,  0,126,255,220,  0, 51,  0,127,255,220,  0, 51,  0,128,
255,220,  0, 51,  0,129,255,220,  0, 51,  0,169,255,220,  0, 51,
  0,170,  0,  0,  0, 51,  0,173,255,125,  0, 51,  0,174,255,125,
  0, 51,  0,180,  0, 38,  0, 51,  0,181,  0, 38,  0, 51,  0,186,
  0,  0,  0, 51,  0,187,255,211,  0, 51,  0,197,254,183,  0, 51,
  0,199,255,125,  0, 51,  0,201,255,125,  0, 51,  0,211,  0,  0,
  0, 51,  0,212,  0,  0,  0, 51,  0,213,  0,  0,  0, 51,  0,228,
255,220,  0, 51,  0,234,255,211,  0, 51,  0,235,  0,  0,  0, 51,
  0,250,255,220,  0, 52,  0, 16,  0, 57,  0, 52,  0,169,  0,  0,
  0, 52,  0,170,  0,  0,  0, 52,  0,180,255,211,  0, 52,  0,181,
255,220,  0, 52,  0,197,255,125,  0, 53,  0, 16,255,173,  0, 53,
  0, 17,255,183,  0, 53,  0, 29,255,193,  0, 53,  0, 36,255,173,
  0, 53,  0, 38,255,154,  0, 53,  0, 55,255,107,  0, 53,  0, 57,
255,144,  0, 53,  0, 58,255,173,  0, 53,  0, 60,255,125,  0, 53,
  0, 68,255,211,  0, 53,  0, 72,255,164,  0, 53,  0, 82,255,164,
  0, 53,  0, 88,255,164,  0, 53,  0, 92,255,144,  0, 53,  0, 98,
255,173,  0, 53,  0,100,255,154,  0, 53,  0,105,255,211,  0, 53,
  0,106,255,211,  0, 53,  0,107,255,211,  0, 53,  0,108,255,211,
  0, 53,  0,109,255,211,  0, 53,  0,110,255,211,  0, 53,  0,112,
255,164,  0, 53,  0,113,255,164,  0, 53,  0,114,255,164,  0, 53,
  0,115,255,164,  0, 53,  0,121,255,164,  0, 53,  0,122,255,164,
  0, 53,  0,123,255,164,  0, 53,  0,124,255,164,  0, 53,  0,125,
255,164,  0, 53,  0,126,255,164,  0, 53,  0,127,255,164,  0, 53,
  0,128,255,164,  0, 53,  0,129,255,164,  0, 53,  0,169,255,144,
  0, 53,  0,170,255,220,  0, 53,  0,173,255,173,  0, 53,  0,174,
255,173,  0, 53,  0,180,255,107,  0, 53,  0,181,255,125,  0, 53,
  0,186,255,144,  0, 53,  0,187,255,125,  0, 53,  0,197,255,220,
  0, 53,  0,199,255,173,  0, 53,  0,201,255,173,  0, 53,  0,234,
255,125,  0, 53,  0,235,255,144,  0, 53,  0,251,255,154,  0, 53,
  0,253,255,154,  0, 54,  0, 36,  0, 38,  0, 54,  0, 38,  0,  0,
  0, 54,  0, 42,  0,  0,  0, 54,  0, 50,  0,  0,  0, 54,  0, 52,
  0,  0,  0, 54,  0, 54,  0,  0,  0, 54,  0, 98,  0, 38,  0, 54,
  0,100,  0,  0,  0, 54,  0,103,  0,  0,  0, 54,  0,173,  0, 38,
  0, 54,  0,174,  0, 38,  0, 54,  0,175,  0,  0,  0, 54,  0,199,
  0, 38,  0, 54,  0,201,  0, 38,  0, 54,  0,208,  0,  0,  0, 54,
  0,209,  0,  0,  0, 54,  0,210,  0,  0,  0, 54,  0,227,  0,  0,
  0, 54,  0,246,  0,  0,  0, 54,  0,249,  0,  0,  0, 54,  0,251,
  0,  0,  0, 54,  0,253,  0,  0,  0, 55,  0, 16,255, 68,  0, 55,
  0, 17,255, 13,  0, 55,  0, 29,255, 31,  0, 55,  0, 36,255, 97,
  0, 55,  0, 38,255,136,  0, 55,  0, 55,255,220,  0, 55,  0, 68,
254,173,  0, 55,  0, 70,254,164,  0, 55,  0, 72,254,164,  0, 55,
  0, 76,255,193,  0, 55,  0, 82,254,164,  0, 55,  0, 85,254,211,
  0, 55,  0, 86,254,173,  0, 55,  0, 88,254,201,  0, 55,  0, 90,
254,173,  0, 55,  0, 92,254,193,  0, 55,  0, 98,255, 97,  0, 55,
  0,100,255,136,  0, 55,  0,105,254,173,  0, 55,  0,106,254,173,
  0, 55,  0,107,254,173,  0, 55,  0,108,254,173,  0, 55,  0,109,
254,173,  0, 55,  0,110,254,173,  0, 55,  0,111,254,164,  0, 55,
  0,112,254,164,  0, 55,  0,113,254,164,  0, 55,  0,114,254,164,
  0, 55,  0,115,254,164,  0, 55,  0,121,254,164,  0, 55,  0,122,
254,164,  0, 55,  0,123,254,164,  0, 55,  0,124,254,164,  0, 55,
  0,125,254,164,  0, 55,  0,126,254,201,  0, 55,  0,127,254,201,
  0, 55,  0,128,254,201,  0, 55,  0,129,254,201,  0, 55,  0,169,
255, 68,  0, 55,  0,170,255,144,  0, 55,  0,173,255, 97,  0, 55,
  0,174,255, 97,  0, 55,  0,180,  0,  0,  0, 55,  0,181,255,211,
  0, 55,  0,186,254,193,  0, 55,  0,197,254,248,  0, 55,  0,199,
255, 97,  0, 55,  0,201,255, 97,  0, 55,  0,228,254,173,  0, 55,
  0,235,254,193,  0, 55,  0,250,254,173,  0, 55,  0,251,255,136,
  0, 55,  0,252,254,164,  0, 55,  0,253,255,136,  0, 55,  0,254,
254,164,  0, 56,  0, 36,  0,  0,  0, 56,  0, 45,  0,  0,  0, 56,
  0, 61,255,220,  0, 56,  0, 98,  0,  0,  0, 56,  0,173,  0,  0,
  0, 56,  0,174,  0,  0,  0, 56,  0,199,  0,  0,  0, 56,  0,201,
  0,  0,  0, 56,  0,229,255,220,  0, 57,  0, 16,255,136,  0, 57,
  0, 17,254,248,  0, 57,  0, 29,255, 89,  0, 57,  0, 36,255,125,
  0, 57,  0, 50,255,220,  0, 57,  0, 68,255, 97,  0, 57,  0, 72,
255, 97,  0, 57,  0, 76,255,211,  0, 57,  0, 82,255, 97,  0, 57,
  0, 88,255,117,  0, 57,  0, 92,255,201,  0, 57,  0, 98,255,125,
  0, 57,  0,103,255,220,  0, 57,  0,105,255, 97,  0, 57,  0,106,
255, 97,  0, 57,  0,107,255, 97,  0, 57,  0,108,255, 97,  0, 57,
  0,109,255, 97,  0, 57,  0,110,255, 97,  0, 57,  0,112,255, 97,
  0, 57,  0,113,255, 97,  0, 57,  0,114,255, 97,  0, 57,  0,115,
255, 97,  0, 57,  0,121,255, 97,  0, 57,  0,122,255, 97,  0, 57,
  0,123,255, 97,  0, 57,  0,124,255, 97,  0, 57,  0,125,255, 97,
  0, 57,  0,126,255,117,  0, 57,  0,127,255,117,  0, 57,  0,128,
255,117,  0, 57,  0,129,255,117,  0, 57,  0,169,255, 78,  0, 57,
  0,170,255,144,  0, 57,  0,173,255,125,  0, 57,  0,174,255,125,
  0, 57,  0,175,255,220,  0, 57,  0,180,  0,  0,  0, 57,  0,181,
  0,  0,  0, 57,  0,186,255,201,  0, 57,  0,197,254,230,  0, 57,
  0,199,255,125,  0, 57,  0,201,255,125,  0, 57,  0,208,255,220,
  0, 57,  0,209,255,220,  0, 57,  0,210,255,220,  0, 57,  0,235,
255,201,  0, 58,  0, 16,255,173,  0, 58,  0, 17,255, 21,  0, 58,
  0, 29,255,136,  0, 58,  0, 36,255,144,  0, 58,  0, 68,255,125,
  0, 58,  0, 72,255,136,  0, 58,  0, 76,255,211,  0, 58,  0, 82,
255,136,  0, 58,  0, 85,255,164,  0, 58,  0, 88,255,183,  0, 58,
  0, 92,255,220,  0, 58,  0, 98,255,144,  0, 58,  0,105,255,125,
  0, 58,  0,106,255,125,  0, 58,  0,107,255,125,  0, 58,  0,108,
255,125,  0, 58,  0,109,255,125,  0, 58,  0,110,255,125,  0, 58,
  0,112,255,136,  0, 58,  0,113,255,136,  0, 58,  0,114,255,136,
  0, 58,  0,115,255,136,  0, 58,  0,121,255,136,  0, 58,  0,122,
255,136,  0, 58,  0,123,255,136,  0, 58,  0,124,255,136,  0, 58,
  0,125,255,136,  0, 58,  0,126,255,183,  0, 58,  0,127,255,183,
  0, 58,  0,128,255,183,  0, 58,  0,129,255,183,  0, 58,  0,169,
255,144,  0, 58,  0,170,255,220,  0, 58,  0,173,255,144,  0, 58,
  0,174,255,144,  0, 58,  0,180,255,220,  0, 58,  0,181,  0,  0,
  0, 58,  0,186,255,220,  0, 58,  0,197,254,248,  0, 58,  0,199,
255,144,  0, 58,  0,201,255,144,  0, 58,  0,235,255,220,  0, 59,
  0, 16,255,154,  0, 59,  0, 36,  0,  0,  0, 59,  0, 38,255,107,
  0, 59,  0, 50,255,125,  0, 59,  0, 55,255,220,  0, 59,  0, 72,
255,164,  0, 59,  0, 98,  0,  0,  0, 59,  0,100,255,107,  0, 59,
  0,103,255,125,  0, 59,  0,112,255,164,  0, 59,  0,113,255,164,
  0, 59,  0,114,255,164,  0, 59,  0,115,255,164,  0, 59,  0,169,
255,144,  0, 59,  0,170,  0,  0,  0, 59,  0,173,  0,  0,  0, 59,
  0,174,  0,  0,  0, 59,  0,175,255,125,  0, 59,  0,180,255, 97,
  0, 59,  0,181,255,173,  0, 59,  0,197,255,211,  0, 59,  0,199,
  0,  0,  0, 59,  0,201,  0,  0,  0, 59,  0,208,255,125,  0, 59,
  0,209,255,125,  0, 59,  0,210,255,125,  0, 59,  0,251,255,107,
  0, 59,  0,253,255,107,  0, 60,  0, 16,255, 13,  0, 60,  0, 17,
254, 97,  0, 60,  0, 29,254,240,  0, 60,  0, 36,255, 97,  0, 60,
  0, 38,255,144,  0, 60,  0, 50,255,144,  0, 60,  0, 68,254,230,
  0, 60,  0, 72,254,240,  0, 60,  0, 76,255,183,  0, 60,  0, 82,
254,240,  0, 60,  0, 88,255, 21,  0, 60,  0, 98,255, 97,  0, 60,
  0,100,255,144,  0, 60,  0,103,255,144,  0, 60,  0,105,254,230,
  0, 60,  0,106,254,230,  0, 60,  0,107,254,230,  0, 60,  0,108,
254,230,  0, 60,  0,109,254,230,  0, 60,  0,110,254,230,  0, 60,
  0,112,254,240,  0, 60,  0,113,254,240,  0, 60,  0,114,254,240,
  0, 60,  0,115,254,240,  0, 60,  0,121,254,240,  0, 60,  0,122,
254,240,  0, 60,  0,123,254,240,  0, 60,  0,124,254,240,  0, 60,
  0,125,254,240,  0, 60,  0,126,255, 21,  0, 60,  0,127,255, 21,
  0, 60,  0,128,255, 21,  0, 60,  0,129,255, 21,  0, 60,  0,169,
255, 31,  0, 60,  0,170,255,107,  0, 60,  0,173,255, 97,  0, 60,
  0,174,255, 97,  0, 60,  0,175,255,144,  0, 60,  0,180,255,144,
  0, 60,  0,181,255,220,  0, 60,  0,197,254,248,  0, 60,  0,199,
255, 97,  0, 60,  0,201,255, 97,  0, 60,  0,208,255,144,  0, 60,
  0,209,255,144,  0, 60,  0,210,255,144,  0, 60,  0,251,255,144,
  0, 60,  0,253,255,144,  0, 61,  0, 16,255,220,  0, 61,  0,169,
  0,  0,  0, 61,  0,170,  0,  0,  0, 61,  0,180,255,220,  0, 61,
  0,181,255,220,  0, 61,  0,197,255,220,  0, 72,  0, 91,255,220,
  0, 73,  0, 16,255,144,  0, 73,  0, 17,255,107,  0, 73,  0, 29,
255,183,  0, 73,  0, 87,255,220,  0, 73,  0, 90,255,220,  0, 73,
  0, 92,255,220,  0, 73,  0,169,255,183,  0, 73,  0,170,255,220,
  0, 73,  0,180,  0, 65,  0, 73,  0,181,  0,  0,  0, 73,  0,186,
255,220,  0, 73,  0,197,255, 21,  0, 73,  0,235,255,220,  0, 78,
  0, 68,255,220,  0, 78,  0, 72,255,183,  0, 78,  0, 82,255,183,
  0, 78,  0, 88,255,193,  0, 78,  0, 92,255,183,  0, 78,  0,105,
255,220,  0, 78,  0,106,255,220,  0, 78,  0,107,255,220,  0, 78,
  0,108,255,220,  0, 78,  0,109,255,220,  0, 78,  0,110,255,220,
  0, 78,  0,112,255,183,  0, 78,  0,113,255,183,  0, 78,  0,114,
255,183,  0, 78,  0,115,255,183,  0, 78,  0,121,255,183,  0, 78,
  0,122,255,183,  0, 78,  0,123,255,183,  0, 78,  0,124,255,183,
  0, 78,  0,125,255,183,  0, 78,  0,126,255,193,  0, 78,  0,127,
255,193,  0, 78,  0,128,255,193,  0, 78,  0,129,255,193,  0, 78,
  0,186,255,183,  0, 78,  0,235,255,183,  0, 81,  0, 16,  0,  0,
  0, 81,  0, 17,  0,  0,  0, 81,  0, 29,  0,  0,  0, 81,  0,169,
  0,  0,  0, 81,  0,170,  0,  0,  0, 81,  0,180,255,107,  0, 81,
  0,181,255,144,  0, 81,  0,197,255,164,  0, 82,  0, 16,  0, 38,
  0, 82,  0, 17,255,220,  0, 82,  0, 29,  0,  0,  0, 82,  0, 91,
255,193,  0, 82,  0,169,  0,  0,  0, 82,  0,170,  0,  0,  0, 82,
  0,180,255,107,  0, 82,  0,181,255,183,  0, 82,  0,197,255,125,
  0, 85,  0, 16,255,125,  0, 85,  0, 17,255, 68,  0, 85,  0, 29,
255,220,  0, 85,  0, 70,255,211,  0, 85,  0, 71,255,220,  0, 85,
  0, 72,255,211,  0, 85,  0, 73,  0,  0,  0, 85,  0, 74,255,220,
  0, 85,  0, 75,255,220,  0, 85,  0, 80,255,220,  0, 85,  0, 81,
255,220,  0, 85,  0, 82,255,211,  0, 85,  0, 84,255,220,  0, 85,
  0, 85,255,220,  0, 85,  0, 88,  0,  0,  0, 85,  0, 89,  0,  0,
  0, 85,  0, 90,  0,  0,  0, 85,  0, 91,255,201,  0, 85,  0, 92,
  0,  0,  0, 85,  0, 93,  0,  0,  0, 85,  0,111,255,211,  0, 85,
  0,112,255,211,  0, 85,  0,113,255,211,  0, 85,  0,114,255,211,
  0, 85,  0,115,255,211,  0, 85,  0,120,255,220,  0, 85,  0,121,
255,211,  0, 85,  0,122,255,211,  0, 85,  0,123,255,211,  0, 85,
  0,124,255,211,  0, 85,  0,125,255,211,  0, 85,  0,126,  0,  0,
  0, 85,  0,127,  0,  0,  0, 85,  0,128,  0,  0,  0, 85,  0,129,
  0,  0,  0, 85,  0,169,255,183,  0, 85,  0,170,  0,  0,  0, 85,
  0,180,  0,  0,  0, 85,  0,181,  0, 86,  0, 85,  0,186,  0,  0,
  0, 85,  0,197,254,201,  0, 85,  0,230,  0,  0,  0, 85,  0,235,
  0,  0,  0, 85,  0,247,255,220,  0, 85,  0,252,255,211,  0, 85,
  0,254,255,211,  0, 89,  0, 16,255,201,  0, 89,  0, 17,255, 97,
  0, 89,  0, 29,255,144,  0, 89,  0,169,255,220,  0, 89,  0,170,
255,220,  0, 89,  0,180,  0,  0,  0, 89,  0,181,255,220,  0, 89,
  0,197,254,240,  0, 90,  0, 16,  0,  0,  0, 90,  0, 17,255, 68,
  0, 90,  0, 29,255,144,  0, 90,  0,169,255,220,  0, 90,  0,170,
255,220,  0, 90,  0,180,  0,  0,  0, 90,  0,181,  0,  0,  0, 90,
  0,197,255, 41,  0, 91,  0, 70,255,220,  0, 91,  0, 72,255,193,
  0, 91,  0, 82,255,193,  0, 91,  0,111,255,220,  0, 91,  0,112,
255,193,  0, 91,  0,113,255,193,  0, 91,  0,114,255,193,  0, 91,
  0,115,255,193,  0, 91,  0,121,255,193,  0, 91,  0,122,255,193,
  0, 91,  0,123,255,193,  0, 91,  0,124,255,193,  0, 91,  0,125,
255,193,  0, 91,  0,252,255,220,  0, 91,  0,254,255,220,  0, 92,
  0, 16,255,220,  0, 92,  0, 17,254,220,  0, 92,  0, 29,255,107,
  0, 92,  0,169,255,220,  0, 92,  0,170,255,220,  0, 92,  0,180,
  0,  0,  0, 92,  0,181,  0,  0,  0, 92,  0,197,254,211,  0, 98,
  0, 16,255,211,  0, 98,  0, 17,255,220,  0, 98,  0, 29,255,220,
  0, 98,  0, 36,  0, 57,  0, 98,  0, 38,255,220,  0, 98,  0, 42,
255,220,  0, 98,  0, 50,255,220,  0, 98,  0, 52,255,220,  0, 98,
  0, 54,  0,  0,  0, 98,  0, 55,255, 97,  0, 98,  0, 56,  0,  0,
  0, 98,  0, 57,255,125,  0, 98,  0, 58,255,144,  0, 98,  0, 59,
  0,  0,  0, 98,  0, 60,255, 97,  0, 98,  0, 70,255,220,  0, 98,
  0, 71,255,220,  0, 98,  0, 72,255,220,  0, 98,  0, 73,255,183,
  0, 98,  0, 82,255,220,  0, 98,  0, 84,255,220,  0, 98,  0, 87,
255,220,  0, 98,  0, 88,  0,  0,  0, 98,  0, 89,255,136,  0, 98,
  0, 90,255,173,  0, 98,  0, 92,255,117,  0, 98,  0, 98,  0, 57,
  0, 98,  0,100,255,220,  0, 98,  0,103,255,220,  0, 98,  0,104,
  0,  0,  0, 98,  0,111,255,220,  0, 98,  0,112,255,220,  0, 98,
  0,113,255,220,  0, 98,  0,114,255,220,  0, 98,  0,115,255,220,
  0, 98,  0,121,255,220,  0, 98,  0,122,255,220,  0, 98,  0,123,
255,220,  0, 98,  0,124,255,220,  0, 98,  0,125,255,220,  0, 98,
  0,126,  0,  0,  0, 98,  0,127,  0,  0,  0, 98,  0,128,  0,  0,
  0, 98,  0,129,  0,  0,  0, 98,  0,169,255,183,  0, 98,  0,170,
  0,  0,  0, 98,  0,173,  0, 57,  0, 98,  0,174,  0, 57,  0, 98,
  0,175,255,220,  0, 98,  0,180,254,248,  0, 98,  0,181,255,  3,
  0, 98,  0,186,255,117,  0, 98,  0,187,255, 97,  0, 98,  0,197,
  0, 47,  0, 98,  0,199,  0, 57,  0, 98,  0,201,  0, 57,  0, 98,
  0,208,255,220,  0, 98,  0,209,255,220,  0, 98,  0,210,255,220,
  0, 98,  0,211,  0,  0,  0, 98,  0,212,  0,  0,  0, 98,  0,213,
  0,  0,  0, 98,  0,227,  0,  0,  0, 98,  0,234,255, 97,  0, 98,
  0,235,255,117,  0, 98,  0,246,255,220,  0, 98,  0,249,  0,  0,
  0, 98,  0,251,255,220,  0, 98,  0,252,255,220,  0, 98,  0,253,
255,220,  0, 98,  0,254,255,220,  0,100,  0, 16,  0,  0,  0,100,
  0, 36,  0,  0,  0,100,  0, 54,  0,  0,  0,100,  0, 60,255,220,
  0,100,  0, 98,  0,  0,  0,100,  0,169,255,220,  0,100,  0,170,
255,220,  0,100,  0,173,  0,  0,  0,100,  0,174,  0,  0,  0,100,
  0,180,  0,  0,  0,100,  0,181,  0, 38,  0,100,  0,187,255,220,
  0,100,  0,197,  0,  0,  0,100,  0,199,  0,  0,  0,100,  0,201,
  0,  0,  0,100,  0,227,  0,  0,  0,100,  0,234,255,220,  0,100,
  0,249,  0,  0,  0,103,  0, 16,  0, 57,  0,103,  0, 17,255,173,
  0,103,  0, 29,255,220,  0,103,  0, 36,255,220,  0,103,  0, 57,
255,220,  0,103,  0, 59,255,125,  0,103,  0, 60,255,144,  0,103,
  0, 98,255,220,  0,103,  0,169,255,220,  0,103,  0,170,  0,  0,
  0,103,  0,173,255,220,  0,103,  0,174,255,220,  0,103,  0,180,
255,211,  0,103,  0,181,255,220,  0,103,  0,187,255,144,  0,103,
  0,197,255, 68,  0,103,  0,199,255,220,  0,103,  0,201,255,220,
  0,103,  0,234,255,144,  0,104,  0, 36,  0,  0,  0,104,  0, 45,
  0,  0,  0,104,  0, 61,255,220,  0,104,  0, 98,  0,  0,  0,104,
  0,173,  0,  0,  0,104,  0,174,  0,  0,  0,104,  0,199,  0,  0,
  0,104,  0,201,  0,  0,  0,104,  0,229,255,220,  0,112,  0, 91,
255,220,  0,113,  0, 91,255,220,  0,114,  0, 91,255,220,  0,115,
  0, 91,255,220,  0,120,  0, 16,  0,  0,  0,120,  0, 17,  0,  0,
  0,120,  0, 29,  0,  0,  0,120,  0,169,  0,  0,  0,120,  0,170,
  0,  0,  0,120,  0,180,255,107,  0,120,  0,181,255,144,  0,120,
  0,197,255,164,  0,121,  0, 16,  0, 38,  0,121,  0, 17,255,220,
  0,121,  0, 29,  0,  0,  0,121,  0, 91,255,193,  0,121,  0,169,
  0,  0,  0,121,  0,170,  0,  0,  0,121,  0,180,255,107,  0,121,
  0,181,255,183,  0,121,  0,197,255,125,  0,122,  0, 16,  0, 38,
  0,122,  0, 17,255,220,  0,122,  0, 29,  0,  0,  0,122,  0, 91,
255,193,  0,122,  0,169,  0,  0,  0,122,  0,170,  0,  0,  0,122,
  0,180,255,107,  0,122,  0,181,255,183,  0,122,  0,197,255,125,
  0,123,  0, 16,  0, 38,  0,123,  0, 17,255,220,  0,123,  0, 29,
  0,  0,  0,123,  0, 91,255,193,  0,123,  0,169,  0,  0,  0,123,
  0,170,  0,  0,  0,123,  0,180,255,107,  0,123,  0,181,255,183,
  0,123,  0,197,255,125,  0,124,  0, 16,  0, 38,  0,124,  0, 17,
255,220,  0,124,  0, 29,  0,  0,  0,124,  0, 91,255,193,  0,124,
  0,169,  0,  0,  0,124,  0,170,  0,  0,  0,124,  0,180,255,107,
  0,124,  0,181,255,183,  0,124,  0,197,255,125,  0,125,  0, 16,
  0, 38,  0,125,  0, 17,255,220,  0,125,  0, 29,  0,  0,  0,125,
  0, 91,255,193,  0,125,  0,169,  0,  0,  0,125,  0,170,  0,  0,
  0,125,  0,180,255,107,  0,125,  0,181,255,183,  0,125,  0,197,
255,125,  0,137,  0, 16,  0, 38,  0,137,  0,169,  0,  0,  0,137,
  0,170,  0,  0,  0,137,  0,180,255,144,  0,137,  0,181,255,144,
  0,137,  0,197,255,173,  0,144,  0, 16,  0,  0,  0,144,  0,169,
  0,  0,  0,144,  0,170,  0,  0,  0,144,  0,180,255,173,  0,144,
  0,181,255,164,  0,144,  0,197,255,144,  0,169,  0, 36,  0,  0,
  0,169,  0, 37,255,220,  0,169,  0, 38,255,220,  0,169,  0, 39,
255,220,  0,169,  0, 41,  0,  0,  0,169,  0, 42,255,220,  0,169,
  0, 43,  0,  0,  0,169,  0, 45,255,220,  0,169,  0, 46,  0,  0,
  0,169,  0, 47,  0,  0,  0,169,  0, 50,  0,  0,  0,169,  0, 51,
  0,  0,  0,169,  0, 52,  0,  0,  0,169,  0, 53,  0,  0,  0,169,
  0, 55,255,144,  0,169,  0, 57,255,144,  0,169,  0, 58,255,220,
  0,169,  0, 59,  0,  0,  0,169,  0, 60,255,107,  0,169,  0, 61,
  0,  0,  0,169,  0, 73,  0,  0,  0,169,  0, 81,  0,  0,  0,169,
  0, 82,  0,  0,  0,169,  0, 85,  0,  0,  0,169,  0, 89,255,220,
  0,169,  0, 90,255,220,  0,169,  0, 92,255,220,  0,169,  0, 98,
  0,  0,  0,169,  0,100,255,220,  0,169,  0,103,  0,  0,  0,169,
  0,120,  0,  0,  0,169,  0,121,  0,  0,  0,169,  0,122,  0,  0,
  0,169,  0,123,  0,  0,  0,169,  0,124,  0,  0,  0,169,  0,125,
  0,  0,  0,169,  0,137,  0,  0,  0,169,  0,144,  0,151,  0,169,
  0,173,  0,  0,  0,169,  0,174,  0,  0,  0,169,  0,175,  0,  0,
  0,169,  0,186,255,220,  0,169,  0,187,255,107,  0,169,  0,199,
  0,  0,  0,169,  0,201,  0,  0,  0,169,  0,208,  0,  0,  0,169,
  0,209,  0,  0,  0,169,  0,210,  0,  0,  0,169,  0,229,  0,  0,
  0,169,  0,233,  0,  0,  0,169,  0,234,255,107,  0,169,  0,235,
255,220,  0,169,  0,236,  0,  0,  0,169,  0,246,255,220,  0,169,
  0,251,255,220,  0,169,  0,253,255,220,  0,170,  0, 36,255,183,
  0,170,  0, 37,255,183,  0,170,  0, 38,255,220,  0,170,  0, 39,
255,220,  0,170,  0, 41,  0,  0,  0,170,  0, 42,  0,  0,  0,170,
  0, 43,  0,  0,  0,170,  0, 45,255,220,  0,170,  0, 46,  0,  0,
  0,170,  0, 47,  0,  0,  0,170,  0, 50,255,220,  0,170,  0, 51,
  0,  0,  0,170,  0, 52,  0,  0,  0,170,  0, 53,  0,  0,  0,170,
  0, 55,255, 68,  0,170,  0, 57,255, 78,  0,170,  0, 58,255,144,
  0,170,  0, 59,255,144,  0,170,  0, 60,255, 31,  0,170,  0, 61,
  0,  0,  0,170,  0, 73,  0,  0,  0,170,  0, 81,  0,  0,  0,170,
  0, 82,  0,  0,  0,170,  0, 85,  0,  0,  0,170,  0, 89,255,220,
  0,170,  0, 90,255,220,  0,170,  0, 92,255,220,  0,170,  0, 98,
255,183,  0,170,  0,100,255,220,  0,170,  0,103,255,220,  0,170,
  0,120,  0,  0,  0,170,  0,121,  0,  0,  0,170,  0,122,  0,  0,
  0,170,  0,123,  0,  0,  0,170,  0,124,  0,  0,  0,170,  0,125,
  0,  0,  0,170,  0,137,  0,  0,  0,170,  0,144,  0,  0,  0,170,
  0,173,255,183,  0,170,  0,174,255,183,  0,170,  0,175,255,220,
  0,170,  0,186,255,220,  0,170,  0,187,255, 31,  0,170,  0,199,
255,183,  0,170,  0,201,255,183,  0,170,  0,208,255,220,  0,170,
  0,209,255,220,  0,170,  0,210,255,220,  0,170,  0,229,  0,  0,
  0,170,  0,233,  0,  0,  0,170,  0,234,255, 31,  0,170,  0,235,
255,220,  0,170,  0,236,  0,  0,  0,170,  0,246,  0,  0,  0,170,
  0,251,255,220,  0,170,  0,253,255,220,  0,173,  0, 16,255,211,
  0,173,  0, 17,255,220,  0,173,  0, 29,255,220,  0,173,  0, 36,
  0, 57,  0,173,  0, 38,255,220,  0,173,  0, 42,255,220,  0,173,
  0, 50,255,220,  0,173,  0, 52,255,220,  0,173,  0, 54,  0,  0,
  0,173,  0, 55,255, 97,  0,173,  0, 56,  0,  0,  0,173,  0, 57,
255,125,  0,173,  0, 58,255,144,  0,173,  0, 59,  0,  0,  0,173,
  0, 60,255, 97,  0,173,  0, 70,255,220,  0,173,  0, 71,255,220,
  0,173,  0, 72,255,220,  0,173,  0, 73,255,183,  0,173,  0, 82,
255,220,  0,173,  0, 84,255,220,  0,173,  0, 87,255,220,  0,173,
  0, 88,  0,  0,  0,173,  0, 89,255,136,  0,173,  0, 90,255,173,
  0,173,  0, 92,255,117,  0,173,  0, 98,  0, 57,  0,173,  0,100,
255,220,  0,173,  0,103,255,220,  0,173,  0,104,  0,  0,  0,173,
  0,111,255,220,  0,173,  0,112,255,220,  0,173,  0,113,255,220,
  0,173,  0,114,255,220,  0,173,  0,115,255,220,  0,173,  0,121,
255,220,  0,173,  0,122,255,220,  0,173,  0,123,255,220,  0,173,
  0,124,255,220,  0,173,  0,125,255,220,  0,173,  0,126,  0,  0,
  0,173,  0,127,  0,  0,  0,173,  0,128,  0,  0,  0,173,  0,129,
  0,  0,  0,173,  0,169,255,183,  0,173,  0,170,  0,  0,  0,173,
  0,173,  0, 57,  0,173,  0,174,  0, 57,  0,173,  0,175,255,220,
  0,173,  0,180,254,248,  0,173,  0,181,255,  3,  0,173,  0,186,
255,117,  0,173,  0,187,255, 97,  0,173,  0,197,  0, 47,  0,173,
  0,199,  0, 57,  0,173,  0,201,  0, 57,  0,173,  0,208,255,220,
  0,173,  0,209,255,220,  0,173,  0,210,255,220,  0,173,  0,211,
  0,  0,  0,173,  0,212,  0,  0,  0,173,  0,213,  0,  0,  0,173,
  0,227,  0,  0,  0,173,  0,234,255, 97,  0,173,  0,235,255,117,
  0,173,  0,246,255,220,  0,173,  0,249,  0,  0,  0,173,  0,251,
255,220,  0,173,  0,252,255,220,  0,173,  0,253,255,220,  0,173,
  0,254,255,220,  0,174,  0, 16,255,211,  0,174,  0, 17,255,220,
  0,174,  0, 29,255,220,  0,174,  0, 36,  0, 57,  0,174,  0, 38,
255,220,  0,174,  0, 42,255,220,  0,174,  0, 50,255,220,  0,174,
  0, 52,255,220,  0,174,  0, 54,  0,  0,  0,174,  0, 55,255, 97,
  0,174,  0, 56,  0,  0,  0,174,  0, 57,255,125,  0,174,  0, 58,
255,144,  0,174,  0, 59,  0,  0,  0,174,  0, 60,255, 97,  0,174,
  0, 70,255,220,  0,174,  0, 71,255,220,  0,174,  0, 72,255,220,
  0,174,  0, 73,255,183,  0,174,  0, 82,255,220,  0,174,  0, 84,
255,220,  0,174,  0, 87,255,220,  0,174,  0, 88,  0,  0,  0,174,
  0, 89,255,136,  0,174,  0, 90,255,173,  0,174,  0, 92,255,117,
  0,174,  0, 98,  0, 57,  0,174,  0,100,255,220,  0,174,  0,103,
255,220,  0,174,  0,104,  0,  0,  0,174,  0,111,255,220,  0,174,
  0,112,255,220,  0,174,  0,113,255,220,  0,174,  0,114,255,220,
  0,174,  0,115,255,220,  0,174,  0,121,255,220,  0,174,  0,122,
255,220,  0,174,  0,123,255,220,  0,174,  0,124,255,220,  0,174,
  0,125,255,220,  0,174,  0,126,  0,  0,  0,174,  0,127,  0,  0,
  0,174,  0,128,  0,  0,  0,174,  0,129,  0,  0,  0,174,  0,169,
255,183,  0,174,  0,170,  0,  0,  0,174,  0,173,  0, 57,  0,174,
  0,174,  0, 57,  0,174,  0,175,255,220,  0,174,  0,180,254,248,
  0,174,  0,181,255,  3,  0,174,  0,186,255,117,  0,174,  0,187,
255, 97,  0,174,  0,197,  0, 47,  0,174,  0,199,  0, 57,  0,174,
  0,201,  0, 57,  0,174,  0,208,255,220,  0,174,  0,209,255,220,
  0,174,  0,210,255,220,  0,174,  0,211,  0,  0,  0,174,  0,212,
  0,  0,  0,174,  0,213,  0,  0,  0,174,  0,227,  0,  0,  0,174,
  0,234,255, 97,  0,174,  0,235,255,117,  0,174,  0,246,255,220,
  0,174,  0,249,  0,  0,  0,174,  0,251,255,220,  0,174,  0,252,
255,220,  0,174,  0,253,255,220,  0,174,  0,254,255,220,  0,175,
  0, 16,  0, 57,  0,175,  0, 17,255,173,  0,175,  0, 29,255,220,
  0,175,  0, 36,255,220,  0,175,  0, 57,255,220,  0,175,  0, 59,
255,125,  0,175,  0, 60,255,144,  0,175,  0, 98,255,220,  0,175,
  0,169,255,220,  0,175,  0,170,  0,  0,  0,175,  0,173,255,220,
  0,175,  0,174,255,220,  0,175,  0,180,255,211,  0,175,  0,181,
255,220,  0,175,  0,187,255,144,  0,175,  0,197,255, 68,  0,175,
  0,199,255,220,  0,175,  0,201,255,220,  0,175,  0,234,255,144,
  0,180,  0, 36,254,248,  0,180,  0, 37,255,193,  0,180,  0, 38,
255,183,  0,180,  0, 39,255,193,  0,180,  0, 41,255,193,  0,180,
  0, 42,255,183,  0,180,  0, 43,255,193,  0,180,  0, 45,255,193,
  0,180,  0, 46,255,193,  0,180,  0, 47,255,193,  0,180,  0, 50,
255,183,  0,180,  0, 51,255,193,  0,180,  0, 52,255,183,  0,180,
  0, 53,255,193,  0,180,  0, 55,  0,  0,  0,180,  0, 57,  0,  0,
  0,180,  0, 58,  0,  0,  0,180,  0, 59,255,136,  0,180,  0, 60,
  0,  0,  0,180,  0, 61,255,220,  0,180,  0, 73,255,183,  0,180,
  0, 81,255,144,  0,180,  0, 82,255,107,  0,180,  0, 85,255,144,
  0,180,  0, 89,255,183,  0,180,  0, 90,255,183,  0,180,  0, 92,
255,183,  0,180,  0, 98,254,248,  0,180,  0,100,255,183,  0,180,
  0,103,255,183,  0,180,  0,120,255,144,  0,180,  0,121,255,107,
  0,180,  0,122,255,107,  0,180,  0,123,255,107,  0,180,  0,124,
255,107,  0,180,  0,125,255,107,  0,180,  0,137,255,193,  0,180,
  0,144,254,125,  0,180,  0,173,254,248,  0,180,  0,174,254,248,
  0,180,  0,175,255,183,  0,180,  0,186,255,183,  0,180,  0,187,
  0,  0,  0,180,  0,199,254,248,  0,180,  0,201,254,248,  0,180,
  0,208,255,183,  0,180,  0,209,255,183,  0,180,  0,210,255,183,
  0,180,  0,229,255,220,  0,180,  0,233,255,183,  0,180,  0,234,
  0,  0,  0,180,  0,235,255,183,  0,180,  0,236,255,193,  0,180,
  0,246,255,183,  0,180,  0,251,255,183,  0,180,  0,253,255,183,
  0,186,  0, 16,255,220,  0,186,  0, 17,254,220,  0,186,  0, 29,
255,107,  0,186,  0,169,255,220,  0,186,  0,170,255,220,  0,186,
  0,180,  0,  0,  0,186,  0,181,  0,  0,  0,186,  0,197,254,211,
  0,187,  0, 16,255, 13,  0,187,  0, 17,254, 97,  0,187,  0, 29,
254,240,  0,187,  0, 36,255, 97,  0,187,  0, 38,255,144,  0,187,
  0, 50,255,144,  0,187,  0, 68,254,230,  0,187,  0, 72,254,240,
  0,187,  0, 76,255,183,  0,187,  0, 82,254,240,  0,187,  0, 88,
255, 21,  0,187,  0, 98,255, 97,  0,187,  0,100,255,144,  0,187,
  0,103,255,144,  0,187,  0,105,254,230,  0,187,  0,106,254,230,
  0,187,  0,107,254,230,  0,187,  0,108,254,230,  0,187,  0,109,
254,230,  0,187,  0,110,254,230,  0,187,  0,112,254,240,  0,187,
  0,113,254,240,  0,187,  0,114,254,240,  0,187,  0,115,254,240,
  0,187,  0,121,254,240,  0,187,  0,122,254,240,  0,187,  0,123,
254,240,  0,187,  0,124,254,240,  0,187,  0,125,254,240,  0,187,
  0,126,255, 21,  0,187,  0,127,255, 21,  0,187,  0,128,255, 21,
  0,187,  0,129,255, 21,  0,187,  0,169,255, 31,  0,187,  0,170,
255,107,  0,187,  0,173,255, 97,  0,187,  0,174,255, 97,  0,187,
  0,175,255,144,  0,187,  0,180,255,144,  0,187,  0,181,255,220,
  0,187,  0,197,254,248,  0,187,  0,199,255, 97,  0,187,  0,201,
255, 97,  0,187,  0,208,255,144,  0,187,  0,209,255,144,  0,187,
  0,210,255,144,  0,187,  0,251,255,144,  0,187,  0,253,255,144,
  0,197,  0, 36,  0, 38,  0,197,  0, 37,255,183,  0,197,  0, 38,
255,144,  0,197,  0, 39,255,183,  0,197,  0, 41,255,183,  0,197,
  0, 42,255,183,  0,197,  0, 43,255,183,  0,197,  0, 45,  0, 47,
  0,197,  0, 46,255,183,  0,197,  0, 47,255,183,  0,197,  0, 50,
255,144,  0,197,  0, 51,255,183,  0,197,  0, 52,255,144,  0,197,
  0, 53,255,183,  0,197,  0, 55,254,230,  0,197,  0, 57,254,136,
  0,197,  0, 58,255,  3,  0,197,  0, 59,255,183,  0,197,  0, 60,
254,136,  0,197,  0, 61,  0,  0,  0,197,  0, 73,255,220,  0,197,
  0, 81,255,183,  0,197,  0, 82,255,183,  0,197,  0, 85,255,183,
  0,197,  0, 89,255, 21,  0,197,  0, 90,255, 60,  0,197,  0, 92,
255,144,  0,197,  0, 98,  0, 38,  0,197,  0,100,255,144,  0,197,
  0,103,255,144,  0,197,  0,120,255,183,  0,197,  0,121,255,183,
  0,197,  0,122,255,183,  0,197,  0,123,255,183,  0,197,  0,124,
255,183,  0,197,  0,125,255,183,  0,197,  0,137,255,183,  0,197,
  0,144,  0, 38,  0,197,  0,173,  0, 38,  0,197,  0,174,  0, 38,
  0,197,  0,175,255,144,  0,197,  0,186,255,144,  0,197,  0,187,
254,136,  0,197,  0,199,  0, 38,  0,197,  0,201,  0, 38,  0,197,
  0,208,255,144,  0,197,  0,209,255,144,  0,197,  0,210,255,144,
  0,197,  0,229,  0,  0,  0,197,  0,233,255,183,  0,197,  0,234,
254,136,  0,197,  0,235,255,144,  0,197,  0,236,255,183,  0,197,
  0,246,255,183,  0,197,  0,251,255,144,  0,197,  0,253,255,144,
  0,199,  0, 16,255,211,  0,199,  0, 17,255,220,  0,199,  0, 29,
255,220,  0,199,  0, 36,  0, 57,  0,199,  0, 38,255,220,  0,199,
  0, 42,255,220,  0,199,  0, 50,255,220,  0,199,  0, 52,255,220,
  0,199,  0, 54,  0,  0,  0,199,  0, 55,255, 97,  0,199,  0, 56,
  0,  0,  0,199,  0, 57,255,125,  0,199,  0, 58,255,144,  0,199,
  0, 59,  0,  0,  0,199,  0, 60,255, 97,  0,199,  0, 70,255,220,
  0,199,  0, 71,255,220,  0,199,  0, 72,255,220,  0,199,  0, 73,
255,183,  0,199,  0, 82,255,220,  0,199,  0, 84,255,220,  0,199,
  0, 87,255,220,  0,199,  0, 88,  0,  0,  0,199,  0, 89,255,136,
  0,199,  0, 90,255,173,  0,199,  0, 92,255,117,  0,199,  0, 98,
  0, 57,  0,199,  0,100,255,220,  0,199,  0,103,255,220,  0,199,
  0,104,  0,  0,  0,199,  0,111,255,220,  0,199,  0,112,255,220,
  0,199,  0,113,255,220,  0,199,  0,114,255,220,  0,199,  0,115,
255,220,  0,199,  0,121,255,220,  0,199,  0,122,255,220,  0,199,
  0,123,255,220,  0,199,  0,124,255,220,  0,199,  0,125,255,220,
  0,199,  0,126,  0,  0,  0,199,  0,127,  0,  0,  0,199,  0,128,
  0,  0,  0,199,  0,129,  0,  0,  0,199,  0,169,255,183,  0,199,
  0,170,  0,  0,  0,199,  0,173,  0, 57,  0,199,  0,174,  0, 57,
  0,199,  0,175,255,220,  0,199,  0,180,254,248,  0,199,  0,181,
255,  3,  0,199,  0,186,255,117,  0,199,  0,187,255, 97,  0,199,
  0,197,  0, 47,  0,199,  0,199,  0, 57,  0,199,  0,201,  0, 57,
  0,199,  0,208,255,220,  0,199,  0,209,255,220,  0,199,  0,210,
255,220,  0,199,  0,211,  0,  0,  0,199,  0,212,  0,  0,  0,199,
  0,213,  0,  0,  0,199,  0,227,  0,  0,  0,199,  0,234,255, 97,
  0,199,  0,235,255,117,  0,199,  0,246,255,220,  0,199,  0,249,
  0,  0,  0,199,  0,251,255,220,  0,199,  0,252,255,220,  0,199,
  0,253,255,220,  0,199,  0,254,255,220,  0,201,  0, 16,255,211,
  0,201,  0, 17,255,220,  0,201,  0, 29,255,220,  0,201,  0, 36,
  0, 57,  0,201,  0, 38,255,220,  0,201,  0, 42,255,220,  0,201,
  0, 50,255,220,  0,201,  0, 52,255,220,  0,201,  0, 54,  0,  0,
  0,201,  0, 55,255, 97,  0,201,  0, 56,  0,  0,  0,201,  0, 57,
255,125,  0,201,  0, 58,255,144,  0,201,  0, 59,  0,  0,  0,201,
  0, 60,255, 97,  0,201,  0, 70,255,220,  0,201,  0, 71,255,220,
  0,201,  0, 72,255,220,  0,201,  0, 73,255,183,  0,201,  0, 82,
255,220,  0,201,  0, 84,255,220,  0,201,  0, 87,255,220,  0,201,
  0, 88,  0,  0,  0,201,  0, 89,255,136,  0,201,  0, 90,255,173,
  0,201,  0, 92,255,117,  0,201,  0, 98,  0, 57,  0,201,  0,100,
255,220,  0,201,  0,103,255,220,  0,201,  0,104,  0,  0,  0,201,
  0,111,255,220,  0,201,  0,112,255,220,  0,201,  0,113,255,220,
  0,201,  0,114,255,220,  0,201,  0,115,255,220,  0,201,  0,121,
255,220,  0,201,  0,122,255,220,  0,201,  0,123,255,220,  0,201,
  0,124,255,220,  0,201,  0,125,255,220,  0,201,  0,126,  0,  0,
  0,201,  0,127,  0,  0,  0,201,  0,128,  0,  0,  0,201,  0,129,
  0,  0,  0,201,  0,169,255,183,  0,201,  0,170,  0,  0,  0,201,
  0,173,  0, 57,  0,201,  0,174,  0, 57,  0,201,  0,175,255,220,
  0,201,  0,180,254,248,  0,201,  0,181,255,  3,  0,201,  0,186,
255,117,  0,201,  0,187,255, 97,  0,201,  0,197,  0, 47,  0,201,
  0,199,  0, 57,  0,201,  0,201,  0, 57,  0,201,  0,208,255,220,
  0,201,  0,209,255,220,  0,201,  0,210,255,220,  0,201,  0,211,
  0,  0,  0,201,  0,212,  0,  0,  0,201,  0,213,  0,  0,  0,201,
  0,227,  0,  0,  0,201,  0,234,255, 97,  0,201,  0,235,255,117,
  0,201,  0,246,255,220,  0,201,  0,249,  0,  0,  0,201,  0,251,
255,220,  0,201,  0,252,255,220,  0,201,  0,253,255,220,  0,201,
  0,254,255,220,  0,208,  0, 16,  0, 57,  0,208,  0, 17,255,173,
  0,208,  0, 29,255,220,  0,208,  0, 36,255,220,  0,208,  0, 57,
255,220,  0,208,  0, 59,255,125,  0,208,  0, 60,255,144,  0,208,
  0, 98,255,220,  0,208,  0,169,255,220,  0,208,  0,170,  0,  0,
  0,208,  0,173,255,220,  0,208,  0,174,255,220,  0,208,  0,180,
255,211,  0,208,  0,181,255,220,  0,208,  0,187,255,144,  0,208,
  0,197,255, 68,  0,208,  0,199,255,220,  0,208,  0,201,255,220,
  0,208,  0,234,255,144,  0,209,  0, 16,  0, 57,  0,209,  0, 17,
255,173,  0,209,  0, 29,255,220,  0,209,  0, 36,255,220,  0,209,
  0, 57,255,220,  0,209,  0, 59,255,125,  0,209,  0, 60,255,144,
  0,209,  0, 98,255,220,  0,209,  0,169,255,220,  0,209,  0,170,
  0,  0,  0,209,  0,173,255,220,  0,209,  0,174,255,220,  0,209,
  0,180,255,211,  0,209,  0,181,255,220,  0,209,  0,187,255,144,
  0,209,  0,197,255, 68,  0,209,  0,199,255,220,  0,209,  0,201,
255,220,  0,209,  0,234,255,144,  0,210,  0, 16,  0, 57,  0,210,
  0, 17,255,173,  0,210,  0, 29,255,220,  0,210,  0, 36,255,220,
  0,210,  0, 57,255,220,  0,210,  0, 59,255,125,  0,210,  0, 60,
255,144,  0,210,  0, 98,255,220,  0,210,  0,169,255,220,  0,210,
  0,170,  0,  0,  0,210,  0,173,255,220,  0,210,  0,174,255,220,
  0,210,  0,180,255,211,  0,210,  0,181,255,220,  0,210,  0,187,
255,144,  0,210,  0,197,255, 68,  0,210,  0,199,255,220,  0,210,
  0,201,255,220,  0,210,  0,234,255,144,  0,211,  0, 36,  0,  0,
  0,211,  0, 45,  0,  0,  0,211,  0, 61,255,220,  0,211,  0, 98,
  0,  0,  0,211,  0,173,  0,  0,  0,211,  0,174,  0,  0,  0,211,
  0,199,  0,  0,  0,211,  0,201,  0,  0,  0,211,  0,229,255,220,
  0,212,  0, 36,  0,  0,  0,212,  0, 45,  0,  0,  0,212,  0, 61,
255,220,  0,212,  0, 98,  0,  0,  0,212,  0,173,  0,  0,  0,212,
  0,174,  0,  0,  0,212,  0,199,  0,  0,  0,212,  0,201,  0,  0,
  0,212,  0,229,255,220,  0,213,  0, 36,  0,  0,  0,213,  0, 45,
  0,  0,  0,213,  0, 61,255,220,  0,213,  0, 98,  0,  0,  0,213,
  0,173,  0,  0,  0,213,  0,174,  0,  0,  0,213,  0,199,  0,  0,
  0,213,  0,201,  0,  0,  0,213,  0,229,255,220,  0,227,  0, 36,
  0, 38,  0,227,  0, 38,  0,  0,  0,227,  0, 42,  0,  0,  0,227,
  0, 50,  0,  0,  0,227,  0, 52,  0,  0,  0,227,  0, 54,  0,  0,
  0,227,  0, 98,  0, 38,  0,227,  0,100,  0,  0,  0,227,  0,103,
  0,  0,  0,227,  0,173,  0, 38,  0,227,  0,174,  0, 38,  0,227,
  0,175,  0,  0,  0,227,  0,199,  0, 38,  0,227,  0,201,  0, 38,
  0,227,  0,208,  0,  0,  0,227,  0,209,  0,  0,  0,227,  0,210,
  0,  0,  0,227,  0,227,  0,  0,  0,227,  0,246,  0,  0,  0,227,
  0,249,  0,  0,  0,227,  0,251,  0,  0,  0,227,  0,253,  0,  0,
  0,229,  0, 16,255,220,  0,229,  0,169,  0,  0,  0,229,  0,170,
  0,  0,  0,229,  0,180,255,220,  0,229,  0,181,255,220,  0,229,
  0,197,255,220,  0,233,  0, 16,  0,  0,  0,233,  0,169,  0,  0,
  0,233,  0,170,  0,  0,  0,233,  0,180,255,164,  0,233,  0,181,
255,144,  0,233,  0,197,255,183,  0,234,  0, 16,255, 13,  0,234,
  0, 17,254, 97,  0,234,  0, 29,254,240,  0,234,  0, 36,255, 97,
  0,234,  0, 38,255,144,  0,234,  0, 50,255,144,  0,234,  0, 68,
254,230,  0,234,  0, 72,254,240,  0,234,  0, 76,255,183,  0,234,
  0, 82,254,240,  0,234,  0, 88,255, 21,  0,234,  0, 98,255, 97,
  0,234,  0,100,255,144,  0,234,  0,103,255,144,  0,234,  0,105,
254,230,  0,234,  0,106,254,230,  0,234,  0,107,254,230,  0,234,
  0,108,254,230,  0,234,  0,109,254,230,  0,234,  0,110,254,230,
  0,234,  0,112,254,240,  0,234,  0,113,254,240,  0,234,  0,114,
254,240,  0,234,  0,115,254,240,  0,234,  0,121,254,240,  0,234,
  0,122,254,240,  0,234,  0,123,254,240,  0,234,  0,124,254,240,
  0,234,  0,125,254,240,  0,234,  0,126,255, 21,  0,234,  0,127,
255, 21,  0,234,  0,128,255, 21,  0,234,  0,129,255, 21,  0,234,
  0,169,255, 31,  0,234,  0,170,255,107,  0,234,  0,173,255, 97,
  0,234,  0,174,255, 97,  0,234,  0,175,255,144,  0,234,  0,180,
255,144,  0,234,  0,181,255,220,  0,234,  0,197,254,248,  0,234,
  0,199,255, 97,  0,234,  0,201,255, 97,  0,234,  0,208,255,144,
  0,234,  0,209,255,144,  0,234,  0,210,255,144,  0,234,  0,251,
255,144,  0,234,  0,253,255,144,  0,235,  0, 16,255,220,  0,235,
  0, 17,254,220,  0,235,  0, 29,255,107,  0,235,  0,169,255,220,
  0,235,  0,170,255,220,  0,235,  0,180,  0,  0,  0,235,  0,181,
  0,  0,  0,235,  0,197,254,211,  0,236,  0, 16,  0,  0,  0,236,
  0, 17,255,107,  0,236,  0, 29,255,183,  0,236,  0,169,  0,  0,
  0,236,  0,170,  0,  0,  0,236,  0,180,255,220,  0,236,  0,181,
  0,  0,  0,236,  0,197,255, 68,  0,246,  0, 16,  0,  0,  0,246,
  0, 36,  0,  0,  0,246,  0, 55,255,183,  0,246,  0, 58,  0,  0,
  0,246,  0, 60,255,154,  0,246,  0, 98,  0,  0,  0,246,  0,169,
255,220,  0,246,  0,170,255,220,  0,246,  0,173,  0,  0,  0,246,
  0,174,  0,  0,  0,246,  0,180,255,211,  0,246,  0,181,255,211,
  0,246,  0,187,255,154,  0,246,  0,197,255,201,  0,246,  0,199,
  0,  0,  0,246,  0,201,  0,  0,  0,246,  0,234,255,154,  0,249,
  0, 36,  0, 38,  0,249,  0, 38,  0,  0,  0,249,  0, 42,  0,  0,
  0,249,  0, 50,  0,  0,  0,249,  0, 52,  0,  0,  0,249,  0, 54,
  0,  0,  0,249,  0, 98,  0, 38,  0,249,  0,100,  0,  0,  0,249,
  0,103,  0,  0,  0,249,  0,173,  0, 38,  0,249,  0,174,  0, 38,
  0,249,  0,175,  0,  0,  0,249,  0,199,  0, 38,  0,249,  0,201,
  0, 38,  0,249,  0,208,  0,  0,  0,249,  0,209,  0,  0,  0,249,
  0,210,  0,  0,  0,249,  0,227,  0,  0,  0,249,  0,246,  0,  0,
  0,249,  0,249,  0,  0,  0,249,  0,251,  0,  0,  0,249,  0,253,
  0,  0,  0,251,  0, 16,  0,  0,  0,251,  0, 36,  0,  0,  0,251,
  0, 54,  0,  0,  0,251,  0, 60,255,220,  0,251,  0, 98,  0,  0,
  0,251,  0,169,255,220,  0,251,  0,170,255,220,  0,251,  0,173,
  0,  0,  0,251,  0,174,  0,  0,  0,251,  0,180,  0,  0,  0,251,
  0,181,  0, 38,  0,251,  0,187,255,220,  0,251,  0,197,  0,  0,
  0,251,  0,199,  0,  0,  0,251,  0,201,  0,  0,  0,251,  0,227,
  0,  0,  0,251,  0,234,255,220,  0,251,  0,249,  0,  0,  0,253,
  0, 16,  0,  0,  0,253,  0, 36,  0,  0,  0,253,  0, 54,  0,  0,
  0,253,  0, 60,255,220,  0,253,  0, 98,  0,  0,  0,253,  0,169,
255,220,  0,253,  0,170,255,220,  0,253,  0,173,  0,  0,  0,253,
  0,174,  0,  0,  0,253,  0,180,  0,  0,  0,253,  0,181,  0, 38,
  0,253,  0,187,255,220,  0,253,  0,197,  0,  0,  0,253,  0,199,
  0,  0,  0,253,  0,201,  0,  0,  0,253,  0,227,  0,  0,  0,253,
  0,234,255,220,  0,253,  0,249,  0,  0,  0,  0,  0,  1,  0,  0,
  1, 12,  0, 77,  0,  7,  0, 66,  0,  4,  0,  2,  0, 16,  0, 64,
  0,  7,  0,  0,  4, 21,  5,104,  0,  3,  0,  1,  0,  1,  0,  0,
  7,109,254, 29,  0,  0, 10,188,254,137,254,137, 10, 76,  0,  1,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1, 12,
  0,  1,  4, 14,  1,144,  0,  5,  0,  4,  5, 71,  4,204,  0,  0,
254, 66,  5, 71,  4,204,  0,  0,  2, 83,  0,143,  2,102,  8,  2,
  2, 11,  6,  3,  3,  8,  4,  2,  2,  4,128,  0,  0,175, 16,  0,
 32, 74,  0,  0,  0,  0,  0,  0,  0,  0, 66,105,116,115,  0, 64,
  0, 32,251,  2,  6, 20,254, 20,  1,154,  7,109,  1,227,  0,  0,
  0,  1,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0, 66,  0, 29,177,
  2,139,  4, 96,  0,  0, 35, 99,  5,213,  0,  0, 86,101,114, 97,
 83, 97,110,115,  0,  0,  0,  0,  0,  0,  0,  0,255,255,255,255,
 54,255,255,254, 54, 50, 56, 82, 48, 48,  0,  0, 64,  0,  0,  0,
  0,  0,  0, 20,  0,  0,  1, 16,  9, 12,  5,  0,  3,  3,  3,  4,
  8,  6,  9,  8,  2,  4,  4,  5,  8,  3,  3,  3,  3,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  3,  3,  8,  8,  8,  5, 10,  6,  7,
  7,  7,  6,  6,  7,  7,  3,  3,  6,  5,  8,  7,  7,  6,  7,  6,
  7,  5,  7,  6,  7,  6,  5,  5,  4,  3,  4,  8,  5,  5,  6,  6,
  6,  6,  6,  3,  6,  6,  3,  3,  5,  3,  9,  6,  6,  6,  6,  4,
  5,  4,  6,  5,  7,  5,  5,  6,  5,  3,  5,  8,  6,  6,  7,  6,
  7,  7,  7,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  3,  3,
  3,  3,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  5,  5,  6,  6,
  5,  5,  6,  6,  9,  9,  9,  5,  5,  8,  9,  7,  8,  8,  8,  8,
  6,  6,  5,  6,  7,  5,  5,  4,  4,  7,  9,  6,  5,  3,  8,  6,
  6,  8,  6,  6,  6,  9,  6,  6,  6,  7, 10,  9,  5,  9,  5,  5,
  3,  3,  8,  4,  5,  5,  2,  6,  4,  4,  6,  6,  5,  3,  3,  5,
 12,  6,  6,  6,  6,  6,  3,  3,  3,  3,  7,  7,  7,  7,  7,  7,
  3,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  3,  7,  5,  5,
  6,  3,  7,  6,  5,  5,  6,  6,  8,  8,  4,  4,  4,  9,  9,  9,
  7,  6,  3,  7,  5,  7,  6,  7,  6,  6,  3,  3,  6,  5,  5,  5,
  5,  5,  5,  4,  5,  5,  0,  0, 10, 13,  6,  0,  3,  3,  4,  5,
  8,  6, 10,  9,  3,  4,  4,  5,  8,  3,  4,  3,  3,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  3,  3,  8,  8,  8,  5, 11,  7,  7,
  8,  8,  7,  6,  8,  8,  3,  3,  7,  6,  9,  8,  8,  7,  8,  7,
  7,  5,  8,  7,  9,  6,  7,  6,  4,  3,  4,  8,  5,  5,  6,  6,
  5,  6,  6,  4,  6,  6,  2,  2,  5,  2, 10,  6,  6,  6,  6,  4,
  5,  4,  6,  6,  8,  6,  6,  5,  6,  3,  6,  8,  7,  7,  8,  7,
  8,  8,  8,  6,  6,  6,  6,  6,  6,  5,  6,  6,  6,  6,  2,  2,
  2,  2,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  5,  5,  6,  6,
  5,  6,  6,  6, 10, 10, 10,  5,  5,  8, 10,  8,  8,  8,  8,  8,
  6,  7,  5,  7,  8,  6,  5,  5,  5,  8, 10,  6,  5,  4,  8,  6,
  6,  8,  7,  6,  6, 10,  6,  7,  7,  8, 11, 10,  5, 10,  5,  5,
  3,  3,  8,  5,  6,  7,  2,  6,  4,  4,  6,  6,  5,  3,  3,  5,
 13,  7,  7,  7,  7,  7,  3,  3,  3,  3,  8,  8,  8,  8,  8,  8,
  2,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  6,  2,  7,  5,  6,
  5,  3,  8,  6,  7,  6,  7,  6,  8,  8,  4,  4,  4, 10, 10, 10,
  8,  6,  3,  7,  5,  8,  5,  8,  5,  6,  4,  3,  6,  5,  5,  5,
  5,  5,  5,  4,  5,  5,  0,  0, 11, 15,  7,  0,  3,  3,  3,  5,
  9,  7, 10, 10,  3,  4,  4,  6,  9,  4,  4,  4,  4,  7,  7,  7,
  7,  7,  7,  7,  7,  7,  7,  4,  4,  9,  9,  9,  6, 12,  7,  8,
  8,  8,  7,  6,  9,  8,  3,  3,  7,  6,  9,  8,  9,  7,  9,  7,
  8,  7,  8,  7,  9,  7,  7,  9,  4,  4,  4,  9,  6,  6,  7,  7,
  6,  7,  7,  4,  7,  7,  3,  3,  6,  3, 11,  7,  7,  7,  7,  5,
  7,  4,  7,  6,  9,  6,  6,  5,  7,  4,  7,  9,  7,  7,  8,  7,
  8,  9,  8,  7,  7,  7,  7,  7,  7,  6,  7,  7,  7,  7,  3,  3,
  3,  3,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  6,  6,  7,  7,
  6,  6,  7,  7, 11, 11, 11,  6,  6,  9, 11,  9,  9,  9,  9,  9,
  7,  7,  6,  7,  8,  6,  6,  5,  5,  8, 11,  7,  6,  3,  9,  7,
  7,  9,  7,  7,  7, 11,  7,  7,  7,  9, 12, 11,  6, 11,  6,  6,
  4,  4,  9,  5,  6,  7,  2,  7,  4,  4,  7,  7,  6,  4,  4,  6,
 15,  7,  7,  7,  7,  7,  3,  3,  3,  3,  9,  9,  9,  8,  8,  8,
  3,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  3,  8,  7,  9,
  5,  4,  8,  7,  7,  6,  7,  7,  9,  9,  4,  4,  4, 11, 11, 11,
  9,  7,  3,  8,  7,  8,  6,  8,  6,  7,  4,  4,  7,  6,  6,  6,
  6,  6,  6,  4,  6,  6,  0,  0, 12, 16,  7,  0,  4,  4,  5,  5,
 10,  8, 11, 10,  3,  5,  5,  6, 10,  4,  4,  4,  4,  8,  8,  8,
  8,  8,  8,  8,  8,  8,  8,  4,  4, 10, 10, 10,  6, 13,  8,  8,
  8,  9,  8,  7,  9,  9,  3,  3,  7,  6, 10,  9,  9,  8,  9,  8,
  8,  7,  9,  8, 11,  9,  7,  9,  5,  4,  5, 10,  6,  6,  8,  8,
  7,  8,  8,  4,  8,  8,  3,  3,  7,  3, 11,  8,  8,  8,  8,  5,
  7,  5,  8,  6,  9,  6,  6,  5,  8,  4,  8, 10,  8,  8,  8,  8,
  9,  9,  9,  8,  8,  8,  8,  8,  8,  7,  8,  8,  8,  8,  3,  3,
  3,  3,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  6,  6,  8,  8,
  6,  7,  8,  8, 12, 12, 12,  6,  6, 10, 12,  9, 10, 10, 10, 10,
  8,  8,  6,  8,  9,  7,  6,  6,  6,  9, 12,  8,  6,  5, 10,  8,
  8, 10,  8,  7,  7, 12,  8,  8,  8,  9, 13, 13,  6, 12,  6,  6,
  4,  4, 10,  6,  6,  7,  2,  8,  5,  5,  7,  7,  6,  4,  4,  6,
 16,  8,  8,  8,  8,  8,  3,  3,  3,  3,  9,  9,  9,  9,  9,  9,
  3,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  3,  8,  7,  9,
  5,  4,  9,  8,  7,  6,  8,  8, 10, 10,  5,  5,  5, 12, 12, 12,
  9,  8,  3,  8,  7,  8,  7,  8,  7,  8,  4,  4,  8,  6,  6,  6,
  6,  6,  6,  5,  6,  6,  0,  0, 13, 17,  8,  0,  4,  4,  5,  5,
 11,  8, 12, 11,  3,  5,  5,  7, 11,  4,  5,  4,  4,  8,  8,  8,
  8,  8,  8,  8,  8,  8,  8,  4,  4, 11, 11, 11,  7, 13,  9,  9,
  9, 10,  8,  7, 10, 10,  3,  3,  8,  7, 11, 10, 10,  8, 10,  8,
  9,  7, 10,  9, 11, 10,  7, 10,  5,  4,  5, 11,  7,  7,  8,  8,
  7,  8,  8,  4,  8,  8,  3,  3,  7,  3, 13,  8,  8,  8,  8,  5,
  7,  5,  8,  7,  9,  7,  7,  7,  8,  4,  8, 11,  9,  9,  9,  8,
 10, 10, 10,  8,  8,  8,  8,  8,  8,  7,  8,  8,  8,  8,  3,  3,
  3,  3,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  7,  7,  8,  8,
  7,  8,  8,  8, 13, 13, 13,  7,  7, 11, 13, 10, 11, 11, 11, 11,
  8,  8,  7,  9, 10,  8,  7,  6,  6, 10, 13,  8,  7,  5, 11,  8,
  8, 11,  9,  8,  8, 13,  8,  9,  9, 10, 14, 13,  7, 13,  7,  7,
  4,  4, 11,  6,  7,  7,  2,  8,  5,  5,  8,  8,  7,  4,  4,  7,
 17,  9,  8,  9,  8,  8,  3,  3,  3,  3, 10, 10, 10, 10, 10, 10,
  3,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  3,  9,  7, 10,
  7,  4, 10,  8,  7,  7,  8,  8, 11, 11,  5,  5,  5, 13, 13, 13,
 10,  8,  3,  9,  7,  9,  7,  9,  7,  8,  5,  4,  8,  7,  7,  7,
  7,  7,  7,  5,  7,  7,  0,  0, 14, 19,  8,  0,  4,  4,  5,  5,
 12,  9, 13, 12,  3,  5,  5,  7, 12,  4,  5,  4,  5,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  5,  5, 12, 12, 12,  7, 14,  9, 10,
 10, 11,  9,  8, 11, 10,  3,  3,  9,  7, 12, 10, 11,  9, 11, 10,
  9,  9, 10,  9, 13, 11,  9, 10,  5,  5,  5, 12,  7,  7,  8,  9,
  8,  9,  9,  4,  9,  9,  3,  3,  8,  3, 13,  9,  9,  9,  9,  5,
  8,  5,  9,  7, 11,  7,  7,  8,  9,  5,  9, 12,  9,  9, 10,  9,
 10, 11, 10,  8,  8,  8,  8,  8,  8,  8,  9,  9,  9,  9,  3,  3,
  3,  3,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  7,  7,  9,  9,
  7,  8,  9,  9, 14, 14, 14,  7,  7, 12, 14, 11, 12, 12, 12, 12,
  9,  9,  7,  9, 11,  8,  7,  7,  7, 11, 14,  9,  7,  5, 12,  9,
  9, 12,  9,  9,  9, 14,  9,  9,  9, 11, 15, 15,  7, 14,  7,  7,
  4,  4, 12,  7,  7,  9,  2,  9,  6,  6,  8,  8,  7,  4,  4,  7,
 19,  9,  9,  9,  9,  9,  3,  3,  3,  3, 11, 11, 11, 10, 10, 10,
  3,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  3,  9,  8, 10,
  8,  5, 11,  9,  9,  7,  9,  9, 12, 12,  6,  6,  6, 14, 14, 14,
 11,  9,  3,  9,  8, 10,  8, 10,  8,  9,  5,  4,  9,  7,  7,  7,
  7,  7,  7,  6,  7,  7,  0,  0, 15, 20,  9,  0,  5,  5,  6,  6,
 13, 10, 14, 11,  3,  6,  6,  8, 13,  5,  5,  5,  5, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10,  5,  5, 13, 13, 13,  8, 15, 10, 10,
 10, 11,  9,  9, 12, 11,  3,  3, 10,  8, 13, 11, 12,  9, 12, 10,
 10,  9, 11, 10, 15, 10,  9, 11,  6,  5,  6, 13,  8,  8,  9,  9,
  8,  9,  9,  5,  9,  9,  3,  3,  8,  3, 15,  9,  9,  9,  9,  6,
  8,  6,  9,  8, 13, 10,  8,  8, 10,  5, 10, 13, 10, 10, 10,  9,
 11, 12, 11,  9,  9,  9,  9,  9,  9,  8,  9,  9,  9,  9,  3,  3,
  3,  3,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  8,  8, 10, 10,
  8,  9, 10,  9, 15, 15, 15,  8,  8, 13, 15, 12, 13, 13, 13, 13,
 10,  9,  8, 10, 11,  9,  8,  7,  7, 11, 15,  9,  8,  6, 13, 10,
 10, 13, 10,  9,  9, 15, 10, 10, 10, 12, 16, 15,  8, 15,  8,  8,
  5,  5, 13,  7,  8,  9,  3, 10,  6,  6,  9,  9,  8,  5,  5,  8,
 20, 10,  9, 10,  9,  9,  3,  3,  3,  3, 12, 12, 12, 11, 11, 11,
  3,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  3, 10,  8, 11,
  8,  5, 12,  9,  9,  8,  9,  9, 13, 13,  6,  6,  6, 15, 15, 15,
 12,  9,  3, 10,  8, 10,  8, 10,  8,  9,  5,  5, 10,  8,  8,  8,
  8,  8,  8,  6,  8,  8,  0,  0, 16, 21, 10,  0,  5,  5,  6,  6,
 13, 10, 15, 12,  3,  6,  6,  8, 13,  5,  6,  5,  5, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10,  5,  5, 13, 13, 13,  9, 16, 11, 11,
 11, 12, 10,  9, 12, 12,  5,  5, 10,  9, 13, 12, 13, 10, 13, 11,
 10,  9, 12, 11, 17, 11,  9, 12,  6,  5,  6, 13,  8,  8,  9, 10,
  9, 10,  9,  6, 10, 10,  3,  3,  9,  3, 15, 10, 10, 10, 10,  7,
  9,  6, 10,  9, 13, 10,  9,  9, 10,  5, 10, 13, 11, 11, 11, 10,
 12, 13, 12,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  3,  3,
  3,  3, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,  8,  8, 10, 10,
  8,  9, 10, 10, 16, 16, 16,  8,  8, 13, 16, 13, 13, 13, 13, 13,
 10, 10,  8, 11, 12,  9,  8,  8,  8, 12, 16, 10,  9,  6, 13, 10,
 10, 13, 11, 10, 10, 16, 10, 11, 11, 13, 17, 15,  8, 16,  8,  8,
  5,  5, 13,  8,  9,  9,  3, 10,  6,  6, 10, 10,  8,  5,  5,  8,
 21, 11, 10, 11, 10, 10,  5,  5,  5,  5, 13, 13, 13, 12, 12, 12,
  3,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  9,  4, 10,  9, 12,
  9,  5, 13, 10,  9,  9, 10, 10, 13, 13,  6,  6,  6, 16, 16, 16,
 12, 10,  5, 10,  9, 11,  9, 11,  9, 10,  6,  5, 10,  8,  8,  8,
  8,  8,  8,  6,  8,  8,  0,  0, 17, 23, 10,  0,  5,  5,  7,  8,
 14, 11, 16, 13,  5,  7,  7,  9, 14,  5,  6,  5,  6, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11,  6,  6, 14, 14, 14,  9, 17, 11, 12,
 12, 13, 11, 10, 13, 13,  6,  6, 12,  9, 15, 13, 13, 10, 13, 12,
 11, 10, 13, 11, 18, 13, 10, 12,  7,  6,  7, 14,  9,  9, 10, 10,
  8, 10, 10,  6, 10, 11,  5,  5, 10,  5, 17, 11, 10, 10, 10,  7,
  8,  7, 11, 10, 15, 10, 10,  8, 11,  6, 11, 14, 11, 11, 12, 11,
 13, 13, 13, 10, 10, 10, 10, 10, 10,  8, 10, 10, 10, 10,  5,  5,
  5,  5, 11, 10, 10, 10, 10, 10, 11, 11, 11, 11,  9,  9, 11, 11,
  9, 10, 11, 11, 17, 17, 17,  9,  9, 14, 16, 13, 14, 14, 14, 14,
 11, 11,  9, 11, 13, 10,  9,  8,  8, 13, 16, 10,  9,  7, 14, 11,
 11, 14, 11, 10, 10, 17, 11, 11, 11, 13, 18, 17,  9, 17,  9,  9,
  5,  5, 14,  8, 10, 10,  3, 11,  7,  7, 10, 10,  9,  5,  5,  9,
 23, 11, 11, 11, 11, 11,  6,  6,  6,  6, 13, 13, 13, 13, 13, 13,
  5,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9, 10,  5, 11,  8, 12,
  8,  6, 13, 10, 10, 10, 10, 10, 14, 14,  7,  7,  7, 16, 16, 16,
 13, 10,  6, 11,  8, 12,  8, 12,  8, 10,  6,  5, 11,  9,  9,  9,
  9,  9,  9,  7,  9,  9,  0,  0, 18, 24, 11,  0,  6,  6,  7,  8,
 15, 11, 17, 13,  4,  7,  7,  9, 15,  6,  7,  6,  6, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11,  6,  6, 15, 15, 15, 10, 18, 12, 12,
 13, 14, 11, 10, 14, 14,  6,  6, 12, 10, 16, 14, 14, 11, 14, 13,
 11, 12, 14, 12, 19, 13, 12, 13,  7,  6,  7, 15,  9,  9, 10, 11,
  9, 11, 11,  6, 11, 11,  5,  5, 10,  5, 17, 11, 11, 11, 11,  8,
  8,  7, 11, 11, 16, 11, 11,  9, 11,  6, 11, 15, 12, 12, 13, 11,
 14, 14, 14, 10, 10, 10, 10, 10, 10,  9, 11, 11, 11, 11,  5,  5,
  5,  5, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,  9,  9, 11, 11,
  9, 11, 11, 11, 18, 18, 18,  9,  9, 15, 17, 14, 15, 15, 15, 15,
 11, 11,  9, 12, 14, 11,  9,  8,  8, 14, 17, 11, 10,  7, 15, 11,
 11, 15, 12, 11, 11, 18, 11, 12, 12, 14, 19, 19,  9, 18,  9,  9,
  6,  6, 15,  9, 11, 12,  3, 11,  7,  7, 11, 11,  9,  6,  6,  9,
 24, 12, 11, 12, 11, 11,  6,  6,  6,  6, 14, 14, 14, 14, 14, 14,
  5,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9, 10,  5, 11,  8, 13,
  9,  6, 14, 11, 12, 11, 11, 11, 15, 15,  7,  7,  7, 17, 17, 17,
 14, 11,  6, 11,  8, 13,  9, 13,  9, 11,  7,  6, 11,  9,  9,  9,
  9,  9,  9,  7,  9,  9,  0,  0, 19, 26, 11,  0,  6,  6,  8,  8,
 16, 12, 18, 14,  4,  7,  7, 10, 16,  6,  7,  6,  6, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12,  6,  6, 16, 16, 16, 10, 19, 13, 13,
 13, 15, 12, 11, 15, 14,  6,  6, 12, 11, 16, 14, 15, 12, 15, 13,
 12, 12, 14, 13, 20, 14, 12, 13,  7,  6,  7, 16, 10, 10, 11, 11,
  9, 11, 11,  6, 11, 12,  5,  5, 11,  5, 17, 12, 11, 11, 11,  8,
  9,  8, 12, 11, 17, 11, 11, 11, 12,  6, 12, 16, 13, 13, 13, 12,
 14, 15, 14, 11, 11, 11, 11, 11, 11,  9, 11, 11, 11, 11,  5,  5,
  5,  5, 12, 11, 11, 11, 11, 11, 12, 12, 12, 12, 10, 10, 12, 12,
 10, 11, 12, 12, 19, 19, 19, 10, 10, 16, 18, 15, 16, 16, 16, 16,
 12, 12, 10, 13, 14, 11, 10,  9,  9, 15, 18, 11, 10,  8, 16, 12,
 12, 16, 13, 12, 12, 19, 12, 13, 13, 15, 20, 19, 10, 19, 10, 10,
  6,  6, 16,  9, 11, 12,  3, 12,  8,  8, 11, 11, 10,  6,  6, 10,
 26, 13, 12, 13, 12, 12,  6,  6,  6,  6, 15, 15, 15, 14, 14, 14,
  5, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11,  5, 12,  9, 13,
 11,  6, 15, 11, 12, 11, 12, 11, 16, 16,  8,  8,  8, 18, 18, 18,
 15, 11,  6, 12,  9, 13,  9, 13,  9, 11,  7,  6, 12, 10, 10, 10,
 10, 10, 10,  8, 10, 10,  0,  0, 20, 27, 12,  0,  6,  6,  8, 10,
 17, 13, 19, 15,  6,  8,  8, 10, 17,  6,  7,  6,  7, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13,  7,  7, 17, 17, 17, 11, 20, 14, 14,
 14, 15, 13, 12, 16, 15,  6,  6, 13, 11, 17, 15, 16, 12, 16, 14,
 13, 12, 15, 14, 20, 14, 12, 14,  8,  7,  8, 17, 10, 10, 12, 13,
 11, 13, 12,  7, 13, 13,  6,  6, 12,  6, 20, 13, 12, 13, 13,  8,
 10,  8, 13, 11, 17, 11, 11, 11, 13,  7, 13, 17, 14, 14, 14, 13,
 15, 16, 15, 12, 12, 12, 12, 12, 12, 11, 12, 12, 12, 12,  6,  6,
  6,  6, 13, 12, 12, 12, 12, 12, 13, 13, 13, 13, 10, 10, 13, 13,
 10, 12, 13, 13, 20, 20, 20, 10, 10, 17, 20, 16, 17, 17, 17, 17,
 13, 13, 10, 13, 15, 12, 10,  9,  9, 15, 19, 12, 11,  8, 17, 13,
 13, 17, 13, 12, 12, 20, 13, 14, 14, 16, 21, 20, 10, 20, 10, 10,
  6,  6, 17, 10, 11, 12,  3, 13,  8,  8, 13, 13, 10,  6,  6, 10,
 27, 14, 13, 14, 13, 13,  6,  6,  6,  6, 16, 16, 16, 15, 15, 15,
  6, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11,  6, 13, 10, 14,
 11,  7, 15, 12, 12, 11, 12, 13, 17, 17,  8,  8,  8, 19, 19, 19,
 16, 13,  6, 13, 10, 14, 11, 14, 11, 13,  7,  6, 13, 10, 10, 10,
 10, 10, 10,  8, 10, 10,  0,  0, 21, 28, 13,  0,  7,  7,  8, 10,
 18, 13, 20, 16,  6,  8,  8, 11, 18,  7,  8,  7,  7, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13,  7,  7, 18, 18, 18, 11, 21, 14, 14,
 15, 16, 13, 12, 16, 16,  6,  6, 14, 12, 18, 16, 17, 13, 17, 15,
 13, 13, 15, 14, 21, 14, 13, 14,  8,  7,  8, 18, 11, 11, 13, 13,
 12, 13, 13,  7, 13, 13,  6,  6, 12,  6, 20, 14, 13, 13, 13,  9,
 11,  8, 14, 11, 17, 13, 13, 11, 13,  7, 13, 18, 14, 14, 15, 13,
 16, 17, 15, 13, 13, 13, 13, 13, 13, 12, 13, 13, 13, 13,  6,  6,
  6,  6, 14, 13, 13, 13, 13, 13, 14, 14, 14, 14, 11, 11, 13, 13,
 11, 12, 13, 13, 21, 21, 21, 11, 11, 18, 20, 17, 18, 18, 18, 18,
 13, 14, 11, 14, 16, 12, 11, 10, 10, 16, 20, 13, 11,  8, 18, 13,
 13, 18, 14, 13, 13, 21, 13, 14, 14, 17, 22, 22, 11, 21, 11, 11,
  7,  7, 18, 10, 13, 13,  4, 13,  8,  8, 13, 13, 11,  7,  7, 11,
 28, 14, 13, 14, 13, 13,  6,  6,  6,  6, 17, 17, 17, 15, 15, 15,
  6, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12,  6, 13, 11, 14,
 11,  7, 16, 13, 13, 13, 13, 13, 18, 18,  8,  8,  8, 20, 20, 20,
 16, 13,  6, 13, 11, 15, 12, 15, 12, 13,  8,  7, 13, 11, 11, 11,
 11, 11, 11,  8, 11, 11,  0,  0, 22, 30, 13,  0,  7,  7,  9, 10,
 18, 14, 21, 17,  6,  9,  9, 11, 18,  7,  8,  7,  7, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14,  7,  7, 18, 18, 18, 12, 22, 15, 15,
 15, 17, 14, 13, 17, 17,  6,  6, 14, 12, 19, 16, 17, 13, 17, 15,
 14, 13, 16, 15, 22, 15, 13, 15,  9,  7,  9, 18, 11, 11, 13, 14,
 12, 14, 13,  8, 14, 14,  6,  6, 13,  6, 22, 14, 13, 14, 14,  9,
 11,  9, 14, 14, 18, 14, 14, 12, 14,  7, 14, 18, 15, 15, 15, 14,
 16, 17, 16, 13, 13, 13, 13, 13, 13, 12, 13, 13, 13, 13,  6,  6,
  6,  6, 14, 13, 13, 13, 13, 13, 14, 14, 14, 14, 11, 11, 14, 14,
 11, 13, 14, 14, 22, 22, 22, 11, 11, 18, 21, 17, 18, 18, 18, 18,
 14, 14, 11, 15, 17, 13, 11, 10, 10, 17, 21, 13, 12,  9, 18, 14,
 14, 18, 15, 13, 13, 22, 14, 15, 15, 17, 24, 22, 11, 22, 11, 11,
  7,  7, 18, 11, 14, 13,  4, 14,  9,  9, 13, 13, 11,  7,  7, 11,
 30, 15, 14, 15, 14, 14,  6,  6,  6,  6, 17, 17, 17, 16, 16, 16,
  6, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12,  6, 14, 11, 15,
 12,  7, 17, 13, 13, 14, 13, 14, 18, 18,  9,  9,  9, 21, 21, 21,
 17, 14,  6, 14, 11, 15, 12, 15, 12, 14,  8,  7, 14, 11, 11, 11,
 11, 11, 11,  9, 11, 11,  0,  0, 23, 31, 14,  0,  7,  7,  9, 11,
 19, 15, 22, 18,  6,  9,  9, 12, 19,  7,  8,  7,  8, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15,  8,  8, 19, 19, 19, 12, 23, 16, 16,
 16, 18, 15, 13, 18, 17,  7,  7, 15, 13, 20, 17, 18, 14, 18, 16,
 15, 14, 17, 16, 23, 16, 14, 16,  9,  8,  9, 19, 12, 12, 14, 15,
 13, 15, 14,  8, 15, 15,  6,  6, 13,  6, 22, 15, 14, 14, 14,  9,
 12,  9, 15, 14, 19, 14, 14, 12, 15,  8, 15, 19, 16, 16, 16, 15,
 17, 18, 17, 14, 14, 14, 14, 14, 14, 13, 14, 14, 14, 14,  6,  6,
  6,  6, 15, 14, 14, 14, 14, 14, 15, 15, 15, 15, 12, 12, 15, 15,
 12, 14, 15, 14, 23, 23, 23, 12, 12, 19, 22, 18, 19, 19, 19, 19,
 15, 15, 12, 16, 17, 14, 12, 11, 11, 18, 21, 14, 12,  9, 19, 15,
 15, 19, 15, 14, 14, 23, 15, 16, 16, 18, 25, 24, 12, 23, 12, 12,
  7,  7, 19, 11, 14, 14,  4, 15,  9,  9, 15, 15, 12,  7,  7, 12,
 31, 16, 15, 16, 15, 15,  7,  7,  7,  7, 18, 18, 18, 17, 17, 17,
  6, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13,  6, 15, 12, 16,
 12,  8, 18, 14, 14, 14, 14, 14, 19, 19,  9,  9,  9, 22, 22, 22,
 18, 15,  7, 15, 12, 16, 13, 16, 13, 15,  8,  7, 15, 12, 12, 12,
 12, 12, 12,  9, 12, 12,  0,  0, 24, 32, 14,  0,  8,  8, 10, 11,
 20, 15, 23, 19,  7,  9,  9, 12, 20,  8,  9,  8,  8, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15,  8,  8, 20, 20, 20, 13, 24, 16, 16,
 17, 18, 15, 14, 19, 18,  7,  7, 16, 13, 21, 18, 19, 14, 19, 17,
 15, 15, 18, 16, 24, 16, 15, 16,  9,  8,  9, 20, 12, 12, 14, 15,
 13, 15, 14,  8, 15, 15,  7,  7, 14,  6, 24, 15, 14, 15, 15, 10,
 12,  9, 15, 15, 20, 15, 15, 13, 15,  8, 15, 20, 16, 16, 17, 15,
 18, 19, 18, 14, 14, 14, 14, 14, 14, 13, 14, 14, 14, 14,  7,  7,
  7,  7, 15, 14, 14, 14, 14, 14, 15, 15, 15, 15, 12, 12, 15, 15,
 12, 14, 15, 15, 24, 24, 24, 12, 12, 20, 23, 19, 20, 20, 20, 20,
 15, 15, 12, 16, 18, 14, 13, 11, 11, 18, 23, 14, 13, 10, 20, 15,
 15, 20, 16, 15, 15, 24, 15, 16, 16, 19, 26, 24, 12, 24, 12, 12,
  8,  8, 20, 12, 15, 15,  4, 15, 10, 10, 15, 15, 12,  8,  8, 12,
 32, 16, 15, 16, 15, 15,  7,  7,  7,  7, 19, 19, 19, 18, 18, 18,
  7, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13,  6, 15, 12, 16,
 13,  8, 19, 14, 15, 15, 15, 15, 20, 20, 10, 10, 10, 23, 23, 23,
 19, 15,  7, 15, 12, 17, 13, 17, 13, 15,  9,  8, 15, 12, 12, 12,
 12, 12, 12, 10, 12, 12,  0,  0, 25, 34, 15,  0,  8,  8, 10, 12,
 21, 16, 24, 20,  7, 10, 10, 13, 21,  8,  9,  8,  8, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16,  8,  8, 21, 21, 21, 13, 25, 17, 17,
 17, 19, 16, 14, 19, 19,  7,  7, 16, 14, 22, 19, 20, 15, 20, 17,
 16, 15, 18, 17, 25, 17, 15, 17, 10,  8, 10, 21, 13, 13, 15, 16,
 14, 16, 15,  9, 16, 16,  7,  7, 14,  7, 24, 16, 15, 16, 16, 10,
 13, 10, 16, 15, 20, 15, 15, 13, 16,  8, 16, 21, 17, 17, 17, 16,
 19, 20, 18, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15,  7,  7,
  7,  7, 16, 15, 15, 15, 15, 15, 16, 16, 16, 16, 13, 13, 16, 16,
 13, 15, 16, 16, 25, 25, 25, 13, 13, 21, 24, 20, 21, 21, 21, 21,
 16, 16, 13, 17, 19, 15, 13, 12, 12, 19, 25, 15, 13, 10, 21, 16,
 16, 21, 17, 15, 15, 25, 16, 17, 17, 20, 27, 26, 13, 25, 13, 13,
  8,  8, 21, 12, 15, 15,  4, 16, 10, 10, 16, 16, 13,  8,  8, 13,
 34, 17, 16, 17, 16, 16,  7,  7,  7,  7, 20, 20, 20, 18, 18, 18,
  7, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14,  7, 16, 13, 17,
 13,  8, 19, 15, 15, 15, 15, 16, 21, 21, 10, 10, 10, 24, 24, 24,
 19, 16,  7, 16, 13, 17, 14, 17, 14, 16,  9,  8, 16, 13, 13, 13,
 13, 13, 13, 10, 13, 13,  0,  0, 26, 35, 16,  0,  8,  8, 10, 12,
 22, 17, 25, 20,  7, 10, 10, 13, 22,  8,  9,  8,  9, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17,  9,  9, 22, 22, 22, 14, 26, 18, 18,
 18, 20, 16, 15, 20, 20,  8,  8, 17, 14, 22, 19, 20, 16, 20, 18,
 17, 16, 19, 18, 26, 18, 16, 18, 10,  9, 10, 22, 13, 13, 16, 17,
 14, 17, 16,  9, 17, 16,  7,  7, 15,  7, 25, 16, 16, 17, 17, 11,
 14, 10, 16, 15, 21, 15, 15, 14, 17,  9, 17, 22, 18, 18, 18, 16,
 19, 20, 19, 16, 16, 16, 16, 16, 16, 14, 16, 16, 16, 16,  7,  7,
  7,  7, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 13, 13, 17, 17,
 13, 15, 17, 16, 26, 26, 26, 13, 13, 22, 25, 20, 22, 22, 22, 22,
 17, 17, 13, 18, 20, 15, 14, 12, 12, 20, 26, 16, 14, 10, 22, 17,
 17, 22, 17, 16, 16, 26, 17, 18, 18, 20, 28, 27, 13, 26, 13, 13,
  8,  8, 22, 13, 15, 16,  4, 17, 10, 10, 16, 16, 13,  8,  8, 13,
 35, 18, 16, 18, 16, 16,  8,  8,  8,  8, 20, 20, 20, 19, 19, 19,
  7, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 15,  7, 17, 14, 18,
 14,  9, 20, 16, 16, 15, 16, 17, 22, 22, 10, 10, 10, 25, 25, 25,
 20, 17,  8, 17, 14, 18, 14, 18, 14, 17,  9,  8, 17, 13, 13, 13,
 13, 13, 13, 10, 13, 13,  0,  0, 27, 36, 16,  0,  9,  9, 11, 12,
 23, 17, 26, 21,  7, 11, 11, 14, 23,  9, 10,  9,  9, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17,  9,  9, 23, 23, 23, 14, 27, 18, 19,
 19, 21, 17, 16, 21, 20,  8,  8, 18, 15, 23, 20, 21, 16, 21, 19,
 17, 17, 20, 18, 27, 19, 17, 19, 11,  9, 11, 23, 14, 14, 17, 17,
 15, 17, 17, 10, 17, 17,  8,  8, 16,  8, 26, 17, 17, 17, 17, 11,
 14, 11, 17, 16, 22, 16, 16, 14, 17,  9, 17, 23, 18, 18, 19, 17,
 20, 21, 20, 17, 17, 17, 17, 17, 17, 15, 17, 17, 17, 17,  8,  8,
  8,  8, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 14, 14, 17, 17,
 14, 16, 17, 17, 27, 27, 27, 14, 14, 23, 26, 21, 22, 23, 23, 23,
 17, 17, 14, 18, 20, 16, 14, 13, 13, 21, 27, 17, 14, 11, 23, 17,
 17, 23, 18, 17, 17, 27, 17, 18, 18, 21, 29, 28, 14, 27, 14, 14,
  9,  9, 23, 13, 16, 17,  5, 17, 11, 11, 17, 17, 14,  9,  9, 14,
 36, 18, 17, 18, 17, 17,  8,  8,  8,  8, 21, 21, 21, 20, 20, 20,
  8, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15,  8, 17, 14, 19,
 14,  9, 21, 17, 17, 16, 16, 17, 23, 23, 11, 11, 11, 26, 26, 26,
 21, 17,  8, 17, 14, 19, 15, 19, 15, 17, 10,  9, 17, 14, 14, 14,
 14, 14, 14, 11, 14, 14,  0,  0, 28, 38, 17,  0,  9,  9, 11, 13,
 23, 18, 27, 22,  8, 11, 11, 14, 23,  9, 10,  9,  9, 18, 18, 18,
 18, 18, 18, 18, 18, 18, 18,  9,  9, 23, 23, 23, 15, 28, 19, 19,
 20, 22, 18, 16, 22, 21,  8,  8, 18, 16, 24, 21, 22, 17, 22, 19,
 18, 17, 21, 19, 28, 19, 17, 19, 11,  9, 11, 23, 14, 14, 17, 18,
 15, 18, 17, 10, 18, 18,  8,  8, 16,  8, 27, 18, 17, 18, 18, 12,
 15, 11, 18, 17, 23, 17, 17, 15, 18,  9, 18, 23, 19, 19, 20, 18,
 21, 22, 21, 17, 17, 17, 17, 17, 17, 15, 17, 17, 17, 17,  8,  8,
  8,  8, 18, 17, 17, 17, 17, 17, 18, 18, 18, 18, 14, 14, 18, 18,
 14, 17, 18, 18, 28, 28, 28, 14, 14, 23, 27, 22, 23, 23, 23, 23,
 18, 18, 14, 19, 21, 16, 15, 13, 13, 21, 28, 17, 15, 11, 23, 18,
 18, 23, 19, 17, 17, 28, 18, 19, 19, 22, 30, 29, 14, 28, 15, 15,
  9,  9, 23, 14, 17, 17,  5, 18, 11, 11, 18, 18, 14,  9,  9, 15,
 38, 19, 18, 19, 18, 18,  8,  8,  8,  8, 22, 22, 22, 21, 21, 21,
  8, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 16,  8, 18, 15, 19,
 15,  9, 22, 17, 17, 17, 17, 18, 23, 23, 11, 11, 11, 27, 27, 27,
 22, 18,  8, 18, 15, 20, 15, 20, 15, 18, 10,  9, 18, 14, 14, 14,
 14, 14, 14, 11, 14, 14,  0,  0,  0,  0,  0,  2,  0,  8,  0,  2,
255,255,  0,  3,  0,  1,  0,  0,  0,  2,  0,  0, 12, 80, 10,236,
 95, 15, 60,245,  0, 31,  8,  0,  0,  0,  0,  0,186,185,240,184,
  0,  0,  0,  0,186,194,103,145,254,137,254, 29, 10, 76,  7,109,
  0,  0,  0,  8,  0,  1,  0,  0,  0,  0,  0,  0
};
static unsigned int TTF_VeraIt_len = 63684;
static unsigned char TTF_VeraIt_dat[] = {

  0,  1,  0,  0,  0, 17,  1,  0,  0,  4,  0, 16, 79, 83, 47, 50,
180, 90,244, 45,  0,  0,226,168,  0,  0,  0, 86, 80, 67, 76, 84,
 32,237, 94,143,  0,  0,227,  0,  0,  0,  0, 54, 99,109, 97,112,
164,195,232,160,  0,  0,199, 88,  0,  0,  3, 88, 99,118,116, 32,
157,  9,176, 17,  0,  0, 31, 28,  0,  0,  1,104,102,112,103,109,
231,106,241,196,  0,  0, 36,144,  0,  0,  0,139,103, 97,115,112,
  0,  7,  0,  7,  0,  0,248,128,  0,  0,  0, 12,103,108,121,102,
168,235,188,198,  0,  0, 37, 28,  0,  0,162, 58,104,100,109,120,
104,  7, 72, 54,  0,  0,227, 56,  0,  0, 21, 72,104,101, 97,100,
104,142,133,116,  0,  0,248,140,  0,  0,  0, 54,104,104,101, 97,
 15,105,  7,224,  0,  0,226,132,  0,  0,  0, 36,104,109,116,120,
 10,118,108,179,  0,  0,202,176,  0,  0,  4, 48,107,101,114,110,
165, 94,167,153,  0,  0,211,140,  0,  0, 14,214,108,111, 99, 97,
 61, 99, 21,145,  0,  0,209,112,  0,  0,  2, 26,109, 97,120,112,
  4, 64,  4,228,  0,  0,226,100,  0,  0,  0, 32,110, 97,109,101,
246, 20, 74, 82,  0,  0,  1, 28,  0,  0, 29,253,112,111,115,116,
180, 79, 47,187,  0,  0,206,224,  0,  0,  2,142,112,114,101,112,
146,145,  2, 34,  0,  0, 32,132,  0,  0,  4, 12,  0,  0,  0, 22,
  1, 14,  0,  1,  0,  0,  0,  0,  0,  0,  0, 58,  0,  0,  0,  1,
  0,  0,  0,  0,  0,  1,  0, 19,  0, 58,  0,  1,  0,  0,  0,  0,
  0,  2,  0,  7,  0, 78,  0,  1,  0,  0,  0,  0,  0,  3,  0, 27,
  0, 58,  0,  1,  0,  0,  0,  0,  0,  4,  0, 27,  0, 58,  0,  1,
  0,  0,  0,  0,  0,  5,  0, 12,  0, 85,  0,  1,  0,  0,  0,  0,
  0,  6,  0, 25,  0, 97,  0,  1,  0,  0,  0,  0,  0,  7,  0, 48,
  0,183,  0,  1,  0,  0,  0,  0,  0,  8,  0, 14,  8,118,  0,  1,
  0,  0,  0,  0,  0, 11,  0, 24,  9,141,  0,  1,  0,  0,  0,  0,
  0, 13,  9, 19,  0,122,  0,  3,  0,  1,  4,  9,  0,  0,  0,116,
  9,165,  0,  3,  0,  1,  4,  9,  0,  1,  0, 38, 10, 25,  0,  3,
  0,  1,  4,  9,  0,  2,  0, 14, 10, 65,  0,  3,  0,  1,  4,  9,
  0,  3,  0, 54, 10, 25,  0,  3,  0,  1,  4,  9,  0,  4,  0, 54,
 10, 25,  0,  3,  0,  1,  4,  9,  0,  5,  0, 24, 10, 79,  0,  3,
  0,  1,  4,  9,  0,  6,  0, 50, 10,103,  0,  3,  0,  1,  4,  9,
  0,  7,  0, 96, 11, 19,  0,  3,  0,  1,  4,  9,  0,  8,  0, 28,
 26,145,  0,  3,  0,  1,  4,  9,  0, 11,  0, 48, 28,191,  0,  3,
  0,  1,  4,  9,  0, 13, 18, 38, 10,153, 67,111,112,121,114,105,
103,104,116, 32, 40, 99, 41, 32, 50, 48, 48, 51, 32, 98,121, 32,
 66,105,116,115,116,114,101, 97,109, 44, 32, 73,110, 99, 46, 32,
 65,108,108, 32, 82,105,103,104,116,115, 32, 82,101,115,101,114,
118,101,100, 46, 66,105,116,115,116,114,101, 97,109, 32, 86,101,
114, 97, 32, 83, 97,110,115, 32, 79, 98,108,105,113,117,101, 82,
101,108,101, 97,115,101, 32, 49, 46, 49, 48, 66,105,116,115,116,
114,101, 97,109, 86,101,114, 97, 83, 97,110,115, 45, 79, 98,108,
105,113,117,101, 67,111,112,121,114,105,103,104,116, 32, 40, 99,
 41, 32, 50, 48, 48, 51, 32, 98,121, 32, 66,105,116,115,116,114,
101, 97,109, 44, 32, 73,110, 99, 46, 13, 10, 65,108,108, 32, 82,
105,103,104,116,115, 32, 82,101,115,101,114,118,101,100, 46, 13,
 10, 66,105,116,115,116,114,101, 97,109, 32, 86,101,114, 97, 32,
105,115, 32, 97, 32,116,114, 97,100,101,109, 97,114,107, 32,111,
102, 32, 66,105,116,115,116,114,101, 97,109, 44, 32, 73,110, 99,
 46, 13, 10, 13, 10, 80,101,114,109,105,115,115,105,111,110, 32,
105,115, 32,104,101,114,101, 98,121, 32,103,114, 97,110,116,101,
100, 44, 32,102,114,101,101, 32,111,102, 32, 99,104, 97,114,103,
101, 44, 32,116,111, 32, 97,110,121, 32,112,101,114,115,111,110,
 32,111, 98,116, 97,105,110,105,110,103, 32, 97, 32, 99,111,112,
121, 32,111,102, 32,116,104,101, 32,102,111,110,116,115, 32, 97,
 99, 99,111,109,112, 97,110,121,105,110,103, 32,116,104,105,115,
 32,108,105, 99,101,110,115,101, 32, 40, 34, 70,111,110,116,115,
 34, 41, 32, 97,110,100, 32, 97,115,115,111, 99,105, 97,116,101,
100, 32,100,111, 99,117,109,101,110,116, 97,116,105,111,110, 32,
102,105,108,101,115, 32, 40,116,104,101, 32, 34, 70,111,110,116,
 32, 83,111,102,116,119, 97,114,101, 34, 41, 44, 32,116,111, 32,
114,101,112,114,111,100,117, 99,101, 32, 97,110,100, 32,100,105,
115,116,114,105, 98,117,116,101, 32,116,104,101, 32, 70,111,110,
116, 32, 83,111,102,116,119, 97,114,101, 44, 32,105,110, 99,108,
117,100,105,110,103, 32,119,105,116,104,111,117,116, 32,108,105,
109,105,116, 97,116,105,111,110, 32,116,104,101, 32,114,105,103,
104,116,115, 32,116,111, 32,117,115,101, 44, 32, 99,111,112,121,
 44, 32,109,101,114,103,101, 44, 32,112,117, 98,108,105,115,104,
 44, 32,100,105,115,116,114,105, 98,117,116,101, 44, 32, 97,110,
100, 47,111,114, 32,115,101,108,108, 32, 99,111,112,105,101,115,
 32,111,102, 32,116,104,101, 32, 70,111,110,116, 32, 83,111,102,
116,119, 97,114,101, 44, 32, 97,110,100, 32,116,111, 32,112,101,
114,109,105,116, 32,112,101,114,115,111,110,115, 32,116,111, 32,
119,104,111,109, 32,116,104,101, 32, 70,111,110,116, 32, 83,111,
102,116,119, 97,114,101, 32,105,115, 32,102,117,114,110,105,115,
104,101,100, 32,116,111, 32,100,111, 32,115,111, 44, 32,115,117,
 98,106,101, 99,116, 32,116,111, 32,116,104,101, 32,102,111,108,
108,111,119,105,110,103, 32, 99,111,110,100,105,116,105,111,110,
115, 58, 13, 10, 13, 10, 84,104,101, 32, 97, 98,111,118,101, 32,
 99,111,112,121,114,105,103,104,116, 32, 97,110,100, 32,116,114,
 97,100,101,109, 97,114,107, 32,110,111,116,105, 99,101,115, 32,
 97,110,100, 32,116,104,105,115, 32,112,101,114,109,105,115,115,
105,111,110, 32,110,111,116,105, 99,101, 32,115,104, 97,108,108,
 32, 98,101, 32,105,110, 99,108,117,100,101,100, 32,105,110, 32,
 97,108,108, 32, 99,111,112,105,101,115, 32,111,102, 32,111,110,
101, 32,111,114, 32,109,111,114,101, 32,111,102, 32,116,104,101,
 32, 70,111,110,116, 32, 83,111,102,116,119, 97,114,101, 32,116,
121,112,101,102, 97, 99,101,115, 46, 13, 10, 13, 10, 84,104,101,
 32, 70,111,110,116, 32, 83,111,102,116,119, 97,114,101, 32,109,
 97,121, 32, 98,101, 32,109,111,100,105,102,105,101,100, 44, 32,
 97,108,116,101,114,101,100, 44, 32,111,114, 32, 97,100,100,101,
100, 32,116,111, 44, 32, 97,110,100, 32,105,110, 32,112, 97,114,
116,105, 99,117,108, 97,114, 32,116,104,101, 32,100,101,115,105,
103,110,115, 32,111,102, 32,103,108,121,112,104,115, 32,111,114,
 32, 99,104, 97,114, 97, 99,116,101,114,115, 32,105,110, 32,116,
104,101, 32, 70,111,110,116,115, 32,109, 97,121, 32, 98,101, 32,
109,111,100,105,102,105,101,100, 32, 97,110,100, 32, 97,100,100,
105,116,105,111,110, 97,108, 32,103,108,121,112,104,115, 32,111,
114, 32, 99,104, 97,114, 97, 99,116,101,114,115, 32,109, 97,121,
 32, 98,101, 32, 97,100,100,101,100, 32,116,111, 32,116,104,101,
 32, 70,111,110,116,115, 44, 32,111,110,108,121, 32,105,102, 32,
116,104,101, 32,102,111,110,116,115, 32, 97,114,101, 32,114,101,
110, 97,109,101,100, 32,116,111, 32,110, 97,109,101,115, 32,110,
111,116, 32, 99,111,110,116, 97,105,110,105,110,103, 32,101,105,
116,104,101,114, 32,116,104,101, 32,119,111,114,100,115, 32, 34,
 66,105,116,115,116,114,101, 97,109, 34, 32,111,114, 32,116,104,
101, 32,119,111,114,100, 32, 34, 86,101,114, 97, 34, 46, 13, 10,
 13, 10, 84,104,105,115, 32, 76,105, 99,101,110,115,101, 32, 98,
101, 99,111,109,101,115, 32,110,117,108,108, 32, 97,110,100, 32,
118,111,105,100, 32,116,111, 32,116,104,101, 32,101,120,116,101,
110,116, 32, 97,112,112,108,105, 99, 97, 98,108,101, 32,116,111,
 32, 70,111,110,116,115, 32,111,114, 32, 70,111,110,116, 32, 83,
111,102,116,119, 97,114,101, 32,116,104, 97,116, 32,104, 97,115,
 32, 98,101,101,110, 32,109,111,100,105,102,105,101,100, 32, 97,
110,100, 32,105,115, 32,100,105,115,116,114,105, 98,117,116,101,
100, 32,117,110,100,101,114, 32,116,104,101, 32, 34, 66,105,116,
115,116,114,101, 97,109, 32, 86,101,114, 97, 34, 32,110, 97,109,
101,115, 46, 13, 10, 13, 10, 84,104,101, 32, 70,111,110,116, 32,
 83,111,102,116,119, 97,114,101, 32,109, 97,121, 32, 98,101, 32,
115,111,108,100, 32, 97,115, 32,112, 97,114,116, 32,111,102, 32,
 97, 32,108, 97,114,103,101,114, 32,115,111,102,116,119, 97,114,
101, 32,112, 97, 99,107, 97,103,101, 32, 98,117,116, 32,110,111,
 32, 99,111,112,121, 32,111,102, 32,111,110,101, 32,111,114, 32,
109,111,114,101, 32,111,102, 32,116,104,101, 32, 70,111,110,116,
 32, 83,111,102,116,119, 97,114,101, 32,116,121,112,101,102, 97,
 99,101,115, 32,109, 97,121, 32, 98,101, 32,115,111,108,100, 32,
 98,121, 32,105,116,115,101,108,102, 46, 13, 10, 13, 10, 84, 72,
 69, 32, 70, 79, 78, 84, 32, 83, 79, 70, 84, 87, 65, 82, 69, 32,
 73, 83, 32, 80, 82, 79, 86, 73, 68, 69, 68, 32, 34, 65, 83, 32,
 73, 83, 34, 44, 32, 87, 73, 84, 72, 79, 85, 84, 32, 87, 65, 82,
 82, 65, 78, 84, 89, 32, 79, 70, 32, 65, 78, 89, 32, 75, 73, 78,
 68, 44, 32, 69, 88, 80, 82, 69, 83, 83, 32, 79, 82, 32, 73, 77,
 80, 76, 73, 69, 68, 44, 32, 73, 78, 67, 76, 85, 68, 73, 78, 71,
 32, 66, 85, 84, 32, 78, 79, 84, 32, 76, 73, 77, 73, 84, 69, 68,
 32, 84, 79, 32, 65, 78, 89, 32, 87, 65, 82, 82, 65, 78, 84, 73,
 69, 83, 32, 79, 70, 32, 77, 69, 82, 67, 72, 65, 78, 84, 65, 66,
 73, 76, 73, 84, 89, 44, 32, 70, 73, 84, 78, 69, 83, 83, 32, 70,
 79, 82, 32, 65, 32, 80, 65, 82, 84, 73, 67, 85, 76, 65, 82, 32,
 80, 85, 82, 80, 79, 83, 69, 32, 65, 78, 68, 32, 78, 79, 78, 73,
 78, 70, 82, 73, 78, 71, 69, 77, 69, 78, 84, 32, 79, 70, 32, 67,
 79, 80, 89, 82, 73, 71, 72, 84, 44, 32, 80, 65, 84, 69, 78, 84,
 44, 32, 84, 82, 65, 68, 69, 77, 65, 82, 75, 44, 32, 79, 82, 32,
 79, 84, 72, 69, 82, 32, 82, 73, 71, 72, 84, 46, 32, 73, 78, 32,
 78, 79, 32, 69, 86, 69, 78, 84, 32, 83, 72, 65, 76, 76, 32, 66,
 73, 84, 83, 84, 82, 69, 65, 77, 32, 79, 82, 32, 84, 72, 69, 32,
 71, 78, 79, 77, 69, 32, 70, 79, 85, 78, 68, 65, 84, 73, 79, 78,
 32, 66, 69, 32, 76, 73, 65, 66, 76, 69, 32, 70, 79, 82, 32, 65,
 78, 89, 32, 67, 76, 65, 73, 77, 44, 32, 68, 65, 77, 65, 71, 69,
 83, 32, 79, 82, 32, 79, 84, 72, 69, 82, 32, 76, 73, 65, 66, 73,
 76, 73, 84, 89, 44, 32, 73, 78, 67, 76, 85, 68, 73, 78, 71, 32,
 65, 78, 89, 32, 71, 69, 78, 69, 82, 65, 76, 44, 32, 83, 80, 69,
 67, 73, 65, 76, 44, 32, 73, 78, 68, 73, 82, 69, 67, 84, 44, 32,
 73, 78, 67, 73, 68, 69, 78, 84, 65, 76, 44, 32, 79, 82, 32, 67,
 79, 78, 83, 69, 81, 85, 69, 78, 84, 73, 65, 76, 32, 68, 65, 77,
 65, 71, 69, 83, 44, 32, 87, 72, 69, 84, 72, 69, 82, 32, 73, 78,
 32, 65, 78, 32, 65, 67, 84, 73, 79, 78, 32, 79, 70, 32, 67, 79,
 78, 84, 82, 65, 67, 84, 44, 32, 84, 79, 82, 84, 32, 79, 82, 32,
 79, 84, 72, 69, 82, 87, 73, 83, 69, 44, 32, 65, 82, 73, 83, 73,
 78, 71, 32, 70, 82, 79, 77, 44, 32, 79, 85, 84, 32, 79, 70, 32,
 84, 72, 69, 32, 85, 83, 69, 32, 79, 82, 32, 73, 78, 65, 66, 73,
 76, 73, 84, 89, 32, 84, 79, 32, 85, 83, 69, 32, 84, 72, 69, 32,
 70, 79, 78, 84, 32, 83, 79, 70, 84, 87, 65, 82, 69, 32, 79, 82,
 32, 70, 82, 79, 77, 32, 79, 84, 72, 69, 82, 32, 68, 69, 65, 76,
 73, 78, 71, 83, 32, 73, 78, 32, 84, 72, 69, 32, 70, 79, 78, 84,
 32, 83, 79, 70, 84, 87, 65, 82, 69, 46, 13, 10, 13, 10, 69,120,
 99,101,112,116, 32, 97,115, 32, 99,111,110,116, 97,105,110,101,
100, 32,105,110, 32,116,104,105,115, 32,110,111,116,105, 99,101,
 44, 32,116,104,101, 32,110, 97,109,101,115, 32,111,102, 32, 71,
110,111,109,101, 44, 32,116,104,101, 32, 71,110,111,109,101, 32,
 70,111,117,110,100, 97,116,105,111,110, 44, 32, 97,110,100, 32,
 66,105,116,115,116,114,101, 97,109, 32, 73,110, 99, 46, 44, 32,
115,104, 97,108,108, 32,110,111,116, 32, 98,101, 32,117,115,101,
100, 32,105,110, 32, 97,100,118,101,114,116,105,115,105,110,103,
 32,111,114, 32,111,116,104,101,114,119,105,115,101, 32,116,111,
 32,112,114,111,109,111,116,101, 32,116,104,101, 32,115, 97,108,
101, 44, 32,117,115,101, 32,111,114, 32,111,116,104,101,114, 32,
100,101, 97,108,105,110,103,115, 32,105,110, 32,116,104,105,115,
 32, 70,111,110,116, 32, 83,111,102,116,119, 97,114,101, 32,119,
105,116,104,111,117,116, 32,112,114,105,111,114, 32,119,114,105,
116,116,101,110, 32, 97,117,116,104,111,114,105,122, 97,116,105,
111,110, 32,102,114,111,109, 32,116,104,101, 32, 71,110,111,109,
101, 32, 70,111,117,110,100, 97,116,105,111,110, 32,111,114, 32,
 66,105,116,115,116,114,101, 97,109, 32, 73,110, 99, 46, 44, 32,
114,101,115,112,101, 99,116,105,118,101,108,121, 46, 32, 70,111,
114, 32,102,117,114,116,104,101,114, 32,105,110,102,111,114,109,
 97,116,105,111,110, 44, 32, 99,111,110,116, 97, 99,116, 58, 32,
102,111,110,116,115, 32, 97,116, 32,103,110,111,109,101, 32,100,
111,116, 32,111,114,103, 46,104,116,116,112, 58, 47, 47,119,119,
119, 46, 98,105,116,115,116,114,101, 97,109, 46, 99,111,109,  0,
 67,  0,111,  0,112,  0,121,  0,114,  0,105,  0,103,  0,104,  0,
116,  0, 32,  0, 40,  0, 99,  0, 41,  0, 32,  0, 50,  0, 48,  0,
 48,  0, 51,  0, 32,  0, 98,  0,121,  0, 32,  0, 66,  0,105,  0,
116,  0,115,  0,116,  0,114,  0,101,  0, 97,  0,109,  0, 44,  0,
 32,  0, 73,  0,110,  0, 99,  0, 46,  0, 32,  0, 65,  0,108,  0,
108,  0, 32,  0, 82,  0,105,  0,103,  0,104,  0,116,  0,115,  0,
 32,  0, 82,  0,101,  0,115,  0,101,  0,114,  0,118,  0,101,  0,
100,  0, 46,  0, 66,  0,105,  0,116,  0,115,  0,116,  0,114,  0,
101,  0, 97,  0,109,  0, 32,  0, 86,  0,101,  0,114,  0, 97,  0,
 32,  0, 83,  0, 97,  0,110,  0,115,  0, 32,  0, 79,  0, 98,  0,
108,  0,105,  0,113,  0,117,  0,101,  0, 82,  0,101,  0,108,  0,
101,  0, 97,  0,115,  0,101,  0, 32,  0, 49,  0, 46,  0, 49,  0,
 48,  0, 66,  0,105,  0,116,  0,115,  0,116,  0,114,  0,101,  0,
 97,  0,109,  0, 86,  0,101,  0,114,  0, 97,  0, 83,  0, 97,  0,
110,  0,115,  0, 45,  0, 79,  0, 98,  0,108,  0,105,  0,113,  0,
117,  0,101,  0, 67,  0,111,  0,112,  0,121,  0,114,  0,105,  0,
103,  0,104,  0,116,  0, 32,  0, 40,  0, 99,  0, 41,  0, 32,  0,
 50,  0, 48,  0, 48,  0, 51,  0, 32,  0, 98,  0,121,  0, 32,  0,
 66,  0,105,  0,116,  0,115,  0,116,  0,114,  0,101,  0, 97,  0,
109,  0, 44,  0, 32,  0, 73,  0,110,  0, 99,  0, 46,  0, 13,  0,
 10,  0, 65,  0,108,  0,108,  0, 32,  0, 82,  0,105,  0,103,  0,
104,  0,116,  0,115,  0, 32,  0, 82,  0,101,  0,115,  0,101,  0,
114,  0,118,  0,101,  0,100,  0, 46,  0, 13,  0, 10,  0, 66,  0,
105,  0,116,  0,115,  0,116,  0,114,  0,101,  0, 97,  0,109,  0,
 32,  0, 86,  0,101,  0,114,  0, 97,  0, 32,  0,105,  0,115,  0,
 32,  0, 97,  0, 32,  0,116,  0,114,  0, 97,  0,100,  0,101,  0,
109,  0, 97,  0,114,  0,107,  0, 32,  0,111,  0,102,  0, 32,  0,
 66,  0,105,  0,116,  0,115,  0,116,  0,114,  0,101,  0, 97,  0,
109,  0, 44,  0, 32,  0, 73,  0,110,  0, 99,  0, 46,  0, 13,  0,
 10,  0, 13,  0, 10,  0, 80,  0,101,  0,114,  0,109,  0,105,  0,
115,  0,115,  0,105,  0,111,  0,110,  0, 32,  0,105,  0,115,  0,
 32,  0,104,  0,101,  0,114,  0,101,  0, 98,  0,121,  0, 32,  0,
103,  0,114,  0, 97,  0,110,  0,116,  0,101,  0,100,  0, 44,  0,
 32,  0,102,  0,114,  0,101,  0,101,  0, 32,  0,111,  0,102,  0,
 32,  0, 99,  0,104,  0, 97,  0,114,  0,103,  0,101,  0, 44,  0,
 32,  0,116,  0,111,  0, 32,  0, 97,  0,110,  0,121,  0, 32,  0,
112,  0,101,  0,114,  0,115,  0,111,  0,110,  0, 32,  0,111,  0,
 98,  0,116,  0, 97,  0,105,  0,110,  0,105,  0,110,  0,103,  0,
 32,  0, 97,  0, 32,  0, 99,  0,111,  0,112,  0,121,  0, 32,  0,
111,  0,102,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0,102,  0,
111,  0,110,  0,116,  0,115,  0, 32,  0, 97,  0, 99,  0, 99,  0,
111,  0,109,  0,112,  0, 97,  0,110,  0,121,  0,105,  0,110,  0,
103,  0, 32,  0,116,  0,104,  0,105,  0,115,  0, 32,  0,108,  0,
105,  0, 99,  0,101,  0,110,  0,115,  0,101,  0, 32,  0, 40,  0,
 34,  0, 70,  0,111,  0,110,  0,116,  0,115,  0, 34,  0, 41,  0,
 32,  0, 97,  0,110,  0,100,  0, 32,  0, 97,  0,115,  0,115,  0,
111,  0, 99,  0,105,  0, 97,  0,116,  0,101,  0,100,  0, 32,  0,
100,  0,111,  0, 99,  0,117,  0,109,  0,101,  0,110,  0,116,  0,
 97,  0,116,  0,105,  0,111,  0,110,  0, 32,  0,102,  0,105,  0,
108,  0,101,  0,115,  0, 32,  0, 40,  0,116,  0,104,  0,101,  0,
 32,  0, 34,  0, 70,  0,111,  0,110,  0,116,  0, 32,  0, 83,  0,
111,  0,102,  0,116,  0,119,  0, 97,  0,114,  0,101,  0, 34,  0,
 41,  0, 44,  0, 32,  0,116,  0,111,  0, 32,  0,114,  0,101,  0,
112,  0,114,  0,111,  0,100,  0,117,  0, 99,  0,101,  0, 32,  0,
 97,  0,110,  0,100,  0, 32,  0,100,  0,105,  0,115,  0,116,  0,
114,  0,105,  0, 98,  0,117,  0,116,  0,101,  0, 32,  0,116,  0,
104,  0,101,  0, 32,  0, 70,  0,111,  0,110,  0,116,  0, 32,  0,
 83,  0,111,  0,102,  0,116,  0,119,  0, 97,  0,114,  0,101,  0,
 44,  0, 32,  0,105,  0,110,  0, 99,  0,108,  0,117,  0,100,  0,
105,  0,110,  0,103,  0, 32,  0,119,  0,105,  0,116,  0,104,  0,
111,  0,117,  0,116,  0, 32,  0,108,  0,105,  0,109,  0,105,  0,
116,  0, 97,  0,116,  0,105,  0,111,  0,110,  0, 32,  0,116,  0,
104,  0,101,  0, 32,  0,114,  0,105,  0,103,  0,104,  0,116,  0,
115,  0, 32,  0,116,  0,111,  0, 32,  0,117,  0,115,  0,101,  0,
 44,  0, 32,  0, 99,  0,111,  0,112,  0,121,  0, 44,  0, 32,  0,
109,  0,101,  0,114,  0,103,  0,101,  0, 44,  0, 32,  0,112,  0,
117,  0, 98,  0,108,  0,105,  0,115,  0,104,  0, 44,  0, 32,  0,
100,  0,105,  0,115,  0,116,  0,114,  0,105,  0, 98,  0,117,  0,
116,  0,101,  0, 44,  0, 32,  0, 97,  0,110,  0,100,  0, 47,  0,
111,  0,114,  0, 32,  0,115,  0,101,  0,108,  0,108,  0, 32,  0,
 99,  0,111,  0,112,  0,105,  0,101,  0,115,  0, 32,  0,111,  0,
102,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0, 70,  0,111,  0,
110,  0,116,  0, 32,  0, 83,  0,111,  0,102,  0,116,  0,119,  0,
 97,  0,114,  0,101,  0, 44,  0, 32,  0, 97,  0,110,  0,100,  0,
 32,  0,116,  0,111,  0, 32,  0,112,  0,101,  0,114,  0,109,  0,
105,  0,116,  0, 32,  0,112,  0,101,  0,114,  0,115,  0,111,  0,
110,  0,115,  0, 32,  0,116,  0,111,  0, 32,  0,119,  0,104,  0,
111,  0,109,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0, 70,  0,
111,  0,110,  0,116,  0, 32,  0, 83,  0,111,  0,102,  0,116,  0,
119,  0, 97,  0,114,  0,101,  0, 32,  0,105,  0,115,  0, 32,  0,
102,  0,117,  0,114,  0,110,  0,105,  0,115,  0,104,  0,101,  0,
100,  0, 32,  0,116,  0,111,  0, 32,  0,100,  0,111,  0, 32,  0,
115,  0,111,  0, 44,  0, 32,  0,115,  0,117,  0, 98,  0,106,  0,
101,  0, 99,  0,116,  0, 32,  0,116,  0,111,  0, 32,  0,116,  0,
104,  0,101,  0, 32,  0,102,  0,111,  0,108,  0,108,  0,111,  0,
119,  0,105,  0,110,  0,103,  0, 32,  0, 99,  0,111,  0,110,  0,
100,  0,105,  0,116,  0,105,  0,111,  0,110,  0,115,  0, 58,  0,
 13,  0, 10,  0, 13,  0, 10,  0, 84,  0,104,  0,101,  0, 32,  0,
 97,  0, 98,  0,111,  0,118,  0,101,  0, 32,  0, 99,  0,111,  0,
112,  0,121,  0,114,  0,105,  0,103,  0,104,  0,116,  0, 32,  0,
 97,  0,110,  0,100,  0, 32,  0,116,  0,114,  0, 97,  0,100,  0,
101,  0,109,  0, 97,  0,114,  0,107,  0, 32,  0,110,  0,111,  0,
116,  0,105,  0, 99,  0,101,  0,115,  0, 32,  0, 97,  0,110,  0,
100,  0, 32,  0,116,  0,104,  0,105,  0,115,  0, 32,  0,112,  0,
101,  0,114,  0,109,  0,105,  0,115,  0,115,  0,105,  0,111,  0,
110,  0, 32,  0,110,  0,111,  0,116,  0,105,  0, 99,  0,101,  0,
 32,  0,115,  0,104,  0, 97,  0,108,  0,108,  0, 32,  0, 98,  0,
101,  0, 32,  0,105,  0,110,  0, 99,  0,108,  0,117,  0,100,  0,
101,  0,100,  0, 32,  0,105,  0,110,  0, 32,  0, 97,  0,108,  0,
108,  0, 32,  0, 99,  0,111,  0,112,  0,105,  0,101,  0,115,  0,
 32,  0,111,  0,102,  0, 32,  0,111,  0,110,  0,101,  0, 32,  0,
111,  0,114,  0, 32,  0,109,  0,111,  0,114,  0,101,  0, 32,  0,
111,  0,102,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0, 70,  0,
111,  0,110,  0,116,  0, 32,  0, 83,  0,111,  0,102,  0,116,  0,
119,  0, 97,  0,114,  0,101,  0, 32,  0,116,  0,121,  0,112,  0,
101,  0,102,  0, 97,  0, 99,  0,101,  0,115,  0, 46,  0, 13,  0,
 10,  0, 13,  0, 10,  0, 84,  0,104,  0,101,  0, 32,  0, 70,  0,
111,  0,110,  0,116,  0, 32,  0, 83,  0,111,  0,102,  0,116,  0,
119,  0, 97,  0,114,  0,101,  0, 32,  0,109,  0, 97,  0,121,  0,
 32,  0, 98,  0,101,  0, 32,  0,109,  0,111,  0,100,  0,105,  0,
102,  0,105,  0,101,  0,100,  0, 44,  0, 32,  0, 97,  0,108,  0,
116,  0,101,  0,114,  0,101,  0,100,  0, 44,  0, 32,  0,111,  0,
114,  0, 32,  0, 97,  0,100,  0,100,  0,101,  0,100,  0, 32,  0,
116,  0,111,  0, 44,  0, 32,  0, 97,  0,110,  0,100,  0, 32,  0,
105,  0,110,  0, 32,  0,112,  0, 97,  0,114,  0,116,  0,105,  0,
 99,  0,117,  0,108,  0, 97,  0,114,  0, 32,  0,116,  0,104,  0,
101,  0, 32,  0,100,  0,101,  0,115,  0,105,  0,103,  0,110,  0,
115,  0, 32,  0,111,  0,102,  0, 32,  0,103,  0,108,  0,121,  0,
112,  0,104,  0,115,  0, 32,  0,111,  0,114,  0, 32,  0, 99,  0,
104,  0, 97,  0,114,  0, 97,  0, 99,  0,116,  0,101,  0,114,  0,
115,  0, 32,  0,105,  0,110,  0, 32,  0,116,  0,104,  0,101,  0,
 32,  0, 70,  0,111,  0,110,  0,116,  0,115,  0, 32,  0,109,  0,
 97,  0,121,  0, 32,  0, 98,  0,101,  0, 32,  0,109,  0,111,  0,
100,  0,105,  0,102,  0,105,  0,101,  0,100,  0, 32,  0, 97,  0,
110,  0,100,  0, 32,  0, 97,  0,100,  0,100,  0,105,  0,116,  0,
105,  0,111,  0,110,  0, 97,  0,108,  0, 32,  0,103,  0,108,  0,
121,  0,112,  0,104,  0,115,  0, 32,  0,111,  0,114,  0, 32,  0,
 99,  0,104,  0, 97,  0,114,  0, 97,  0, 99,  0,116,  0,101,  0,
114,  0,115,  0, 32,  0,109,  0, 97,  0,121,  0, 32,  0, 98,  0,
101,  0, 32,  0, 97,  0,100,  0,100,  0,101,  0,100,  0, 32,  0,
116,  0,111,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0, 70,  0,
111,  0,110,  0,116,  0,115,  0, 44,  0, 32,  0,111,  0,110,  0,
108,  0,121,  0, 32,  0,105,  0,102,  0, 32,  0,116,  0,104,  0,
101,  0, 32,  0,102,  0,111,  0,110,  0,116,  0,115,  0, 32,  0,
 97,  0,114,  0,101,  0, 32,  0,114,  0,101,  0,110,  0, 97,  0,
109,  0,101,  0,100,  0, 32,  0,116,  0,111,  0, 32,  0,110,  0,
 97,  0,109,  0,101,  0,115,  0, 32,  0,110,  0,111,  0,116,  0,
 32,  0, 99,  0,111,  0,110,  0,116,  0, 97,  0,105,  0,110,  0,
105,  0,110,  0,103,  0, 32,  0,101,  0,105,  0,116,  0,104,  0,
101,  0,114,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0,119,  0,
111,  0,114,  0,100,  0,115,  0, 32,  0, 34,  0, 66,  0,105,  0,
116,  0,115,  0,116,  0,114,  0,101,  0, 97,  0,109,  0, 34,  0,
 32,  0,111,  0,114,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0,
119,  0,111,  0,114,  0,100,  0, 32,  0, 34,  0, 86,  0,101,  0,
114,  0, 97,  0, 34,  0, 46,  0, 13,  0, 10,  0, 13,  0, 10,  0,
 84,  0,104,  0,105,  0,115,  0, 32,  0, 76,  0,105,  0, 99,  0,
101,  0,110,  0,115,  0,101,  0, 32,  0, 98,  0,101,  0, 99,  0,
111,  0,109,  0,101,  0,115,  0, 32,  0,110,  0,117,  0,108,  0,
108,  0, 32,  0, 97,  0,110,  0,100,  0, 32,  0,118,  0,111,  0,
105,  0,100,  0, 32,  0,116,  0,111,  0, 32,  0,116,  0,104,  0,
101,  0, 32,  0,101,  0,120,  0,116,  0,101,  0,110,  0,116,  0,
 32,  0, 97,  0,112,  0,112,  0,108,  0,105,  0, 99,  0, 97,  0,
 98,  0,108,  0,101,  0, 32,  0,116,  0,111,  0, 32,  0, 70,  0,
111,  0,110,  0,116,  0,115,  0, 32,  0,111,  0,114,  0, 32,  0,
 70,  0,111,  0,110,  0,116,  0, 32,  0, 83,  0,111,  0,102,  0,
116,  0,119,  0, 97,  0,114,  0,101,  0, 32,  0,116,  0,104,  0,
 97,  0,116,  0, 32,  0,104,  0, 97,  0,115,  0, 32,  0, 98,  0,
101,  0,101,  0,110,  0, 32,  0,109,  0,111,  0,100,  0,105,  0,
102,  0,105,  0,101,  0,100,  0, 32,  0, 97,  0,110,  0,100,  0,
 32,  0,105,  0,115,  0, 32,  0,100,  0,105,  0,115,  0,116,  0,
114,  0,105,  0, 98,  0,117,  0,116,  0,101,  0,100,  0, 32,  0,
117,  0,110,  0,100,  0,101,  0,114,  0, 32,  0,116,  0,104,  0,
101,  0, 32,  0, 34,  0, 66,  0,105,  0,116,  0,115,  0,116,  0,
114,  0,101,  0, 97,  0,109,  0, 32,  0, 86,  0,101,  0,114,  0,
 97,  0, 34,  0, 32,  0,110,  0, 97,  0,109,  0,101,  0,115,  0,
 46,  0, 13,  0, 10,  0, 13,  0, 10,  0, 84,  0,104,  0,101,  0,
 32,  0, 70,  0,111,  0,110,  0,116,  0, 32,  0, 83,  0,111,  0,
102,  0,116,  0,119,  0, 97,  0,114,  0,101,  0, 32,  0,109,  0,
 97,  0,121,  0, 32,  0, 98,  0,101,  0, 32,  0,115,  0,111,  0,
108,  0,100,  0, 32,  0, 97,  0,115,  0, 32,  0,112,  0, 97,  0,
114,  0,116,  0, 32,  0,111,  0,102,  0, 32,  0, 97,  0, 32,  0,
108,  0, 97,  0,114,  0,103,  0,101,  0,114,  0, 32,  0,115,  0,
111,  0,102,  0,116,  0,119,  0, 97,  0,114,  0,101,  0, 32,  0,
112,  0, 97,  0, 99,  0,107,  0, 97,  0,103,  0,101,  0, 32,  0,
 98,  0,117,  0,116,  0, 32,  0,110,  0,111,  0, 32,  0, 99,  0,
111,  0,112,  0,121,  0, 32,  0,111,  0,102,  0, 32,  0,111,  0,
110,  0,101,  0, 32,  0,111,  0,114,  0, 32,  0,109,  0,111,  0,
114,  0,101,  0, 32,  0,111,  0,102,  0, 32,  0,116,  0,104,  0,
101,  0, 32,  0, 70,  0,111,  0,110,  0,116,  0, 32,  0, 83,  0,
111,  0,102,  0,116,  0,119,  0, 97,  0,114,  0,101,  0, 32,  0,
116,  0,121,  0,112,  0,101,  0,102,  0, 97,  0, 99,  0,101,  0,
115,  0, 32,  0,109,  0, 97,  0,121,  0, 32,  0, 98,  0,101,  0,
 32,  0,115,  0,111,  0,108,  0,100,  0, 32,  0, 98,  0,121,  0,
 32,  0,105,  0,116,  0,115,  0,101,  0,108,  0,102,  0, 46,  0,
 13,  0, 10,  0, 13,  0, 10,  0, 84,  0, 72,  0, 69,  0, 32,  0,
 70,  0, 79,  0, 78,  0, 84,  0, 32,  0, 83,  0, 79,  0, 70,  0,
 84,  0, 87,  0, 65,  0, 82,  0, 69,  0, 32,  0, 73,  0, 83,  0,
 32,  0, 80,  0, 82,  0, 79,  0, 86,  0, 73,  0, 68,  0, 69,  0,
 68,  0, 32,  0, 34,  0, 65,  0, 83,  0, 32,  0, 73,  0, 83,  0,
 34,  0, 44,  0, 32,  0, 87,  0, 73,  0, 84,  0, 72,  0, 79,  0,
 85,  0, 84,  0, 32,  0, 87,  0, 65,  0, 82,  0, 82,  0, 65,  0,
 78,  0, 84,  0, 89,  0, 32,  0, 79,  0, 70,  0, 32,  0, 65,  0,
 78,  0, 89,  0, 32,  0, 75,  0, 73,  0, 78,  0, 68,  0, 44,  0,
 32,  0, 69,  0, 88,  0, 80,  0, 82,  0, 69,  0, 83,  0, 83,  0,
 32,  0, 79,  0, 82,  0, 32,  0, 73,  0, 77,  0, 80,  0, 76,  0,
 73,  0, 69,  0, 68,  0, 44,  0, 32,  0, 73,  0, 78,  0, 67,  0,
 76,  0, 85,  0, 68,  0, 73,  0, 78,  0, 71,  0, 32,  0, 66,  0,
 85,  0, 84,  0, 32,  0, 78,  0, 79,  0, 84,  0, 32,  0, 76,  0,
 73,  0, 77,  0, 73,  0, 84,  0, 69,  0, 68,  0, 32,  0, 84,  0,
 79,  0, 32,  0, 65,  0, 78,  0, 89,  0, 32,  0, 87,  0, 65,  0,
 82,  0, 82,  0, 65,  0, 78,  0, 84,  0, 73,  0, 69,  0, 83,  0,
 32,  0, 79,  0, 70,  0, 32,  0, 77,  0, 69,  0, 82,  0, 67,  0,
 72,  0, 65,  0, 78,  0, 84,  0, 65,  0, 66,  0, 73,  0, 76,  0,
 73,  0, 84,  0, 89,  0, 44,  0, 32,  0, 70,  0, 73,  0, 84,  0,
 78,  0, 69,  0, 83,  0, 83,  0, 32,  0, 70,  0, 79,  0, 82,  0,
 32,  0, 65,  0, 32,  0, 80,  0, 65,  0, 82,  0, 84,  0, 73,  0,
 67,  0, 85,  0, 76,  0, 65,  0, 82,  0, 32,  0, 80,  0, 85,  0,
 82,  0, 80,  0, 79,  0, 83,  0, 69,  0, 32,  0, 65,  0, 78,  0,
 68,  0, 32,  0, 78,  0, 79,  0, 78,  0, 73,  0, 78,  0, 70,  0,
 82,  0, 73,  0, 78,  0, 71,  0, 69,  0, 77,  0, 69,  0, 78,  0,
 84,  0, 32,  0, 79,  0, 70,  0, 32,  0, 67,  0, 79,  0, 80,  0,
 89,  0, 82,  0, 73,  0, 71,  0, 72,  0, 84,  0, 44,  0, 32,  0,
 80,  0, 65,  0, 84,  0, 69,  0, 78,  0, 84,  0, 44,  0, 32,  0,
 84,  0, 82,  0, 65,  0, 68,  0, 69,  0, 77,  0, 65,  0, 82,  0,
 75,  0, 44,  0, 32,  0, 79,  0, 82,  0, 32,  0, 79,  0, 84,  0,
 72,  0, 69,  0, 82,  0, 32,  0, 82,  0, 73,  0, 71,  0, 72,  0,
 84,  0, 46,  0, 32,  0, 73,  0, 78,  0, 32,  0, 78,  0, 79,  0,
 32,  0, 69,  0, 86,  0, 69,  0, 78,  0, 84,  0, 32,  0, 83,  0,
 72,  0, 65,  0, 76,  0, 76,  0, 32,  0, 66,  0, 73,  0, 84,  0,
 83,  0, 84,  0, 82,  0, 69,  0, 65,  0, 77,  0, 32,  0, 79,  0,
 82,  0, 32,  0, 84,  0, 72,  0, 69,  0, 32,  0, 71,  0, 78,  0,
 79,  0, 77,  0, 69,  0, 32,  0, 70,  0, 79,  0, 85,  0, 78,  0,
 68,  0, 65,  0, 84,  0, 73,  0, 79,  0, 78,  0, 32,  0, 66,  0,
 69,  0, 32,  0, 76,  0, 73,  0, 65,  0, 66,  0, 76,  0, 69,  0,
 32,  0, 70,  0, 79,  0, 82,  0, 32,  0, 65,  0, 78,  0, 89,  0,
 32,  0, 67,  0, 76,  0, 65,  0, 73,  0, 77,  0, 44,  0, 32,  0,
 68,  0, 65,  0, 77,  0, 65,  0, 71,  0, 69,  0, 83,  0, 32,  0,
 79,  0, 82,  0, 32,  0, 79,  0, 84,  0, 72,  0, 69,  0, 82,  0,
 32,  0, 76,  0, 73,  0, 65,  0, 66,  0, 73,  0, 76,  0, 73,  0,
 84,  0, 89,  0, 44,  0, 32,  0, 73,  0, 78,  0, 67,  0, 76,  0,
 85,  0, 68,  0, 73,  0, 78,  0, 71,  0, 32,  0, 65,  0, 78,  0,
 89,  0, 32,  0, 71,  0, 69,  0, 78,  0, 69,  0, 82,  0, 65,  0,
 76,  0, 44,  0, 32,  0, 83,  0, 80,  0, 69,  0, 67,  0, 73,  0,
 65,  0, 76,  0, 44,  0, 32,  0, 73,  0, 78,  0, 68,  0, 73,  0,
 82,  0, 69,  0, 67,  0, 84,  0, 44,  0, 32,  0, 73,  0, 78,  0,
 67,  0, 73,  0, 68,  0, 69,  0, 78,  0, 84,  0, 65,  0, 76,  0,
 44,  0, 32,  0, 79,  0, 82,  0, 32,  0, 67,  0, 79,  0, 78,  0,
 83,  0, 69,  0, 81,  0, 85,  0, 69,  0, 78,  0, 84,  0, 73,  0,
 65,  0, 76,  0, 32,  0, 68,  0, 65,  0, 77,  0, 65,  0, 71,  0,
 69,  0, 83,  0, 44,  0, 32,  0, 87,  0, 72,  0, 69,  0, 84,  0,
 72,  0, 69,  0, 82,  0, 32,  0, 73,  0, 78,  0, 32,  0, 65,  0,
 78,  0, 32,  0, 65,  0, 67,  0, 84,  0, 73,  0, 79,  0, 78,  0,
 32,  0, 79,  0, 70,  0, 32,  0, 67,  0, 79,  0, 78,  0, 84,  0,
 82,  0, 65,  0, 67,  0, 84,  0, 44,  0, 32,  0, 84,  0, 79,  0,
 82,  0, 84,  0, 32,  0, 79,  0, 82,  0, 32,  0, 79,  0, 84,  0,
 72,  0, 69,  0, 82,  0, 87,  0, 73,  0, 83,  0, 69,  0, 44,  0,
 32,  0, 65,  0, 82,  0, 73,  0, 83,  0, 73,  0, 78,  0, 71,  0,
 32,  0, 70,  0, 82,  0, 79,  0, 77,  0, 44,  0, 32,  0, 79,  0,
 85,  0, 84,  0, 32,  0, 79,  0, 70,  0, 32,  0, 84,  0, 72,  0,
 69,  0, 32,  0, 85,  0, 83,  0, 69,  0, 32,  0, 79,  0, 82,  0,
 32,  0, 73,  0, 78,  0, 65,  0, 66,  0, 73,  0, 76,  0, 73,  0,
 84,  0, 89,  0, 32,  0, 84,  0, 79,  0, 32,  0, 85,  0, 83,  0,
 69,  0, 32,  0, 84,  0, 72,  0, 69,  0, 32,  0, 70,  0, 79,  0,
 78,  0, 84,  0, 32,  0, 83,  0, 79,  0, 70,  0, 84,  0, 87,  0,
 65,  0, 82,  0, 69,  0, 32,  0, 79,  0, 82,  0, 32,  0, 70,  0,
 82,  0, 79,  0, 77,  0, 32,  0, 79,  0, 84,  0, 72,  0, 69,  0,
 82,  0, 32,  0, 68,  0, 69,  0, 65,  0, 76,  0, 73,  0, 78,  0,
 71,  0, 83,  0, 32,  0, 73,  0, 78,  0, 32,  0, 84,  0, 72,  0,
 69,  0, 32,  0, 70,  0, 79,  0, 78,  0, 84,  0, 32,  0, 83,  0,
 79,  0, 70,  0, 84,  0, 87,  0, 65,  0, 82,  0, 69,  0, 46,  0,
 13,  0, 10,  0, 13,  0, 10,  0, 69,  0,120,  0, 99,  0,101,  0,
112,  0,116,  0, 32,  0, 97,  0,115,  0, 32,  0, 99,  0,111,  0,
110,  0,116,  0, 97,  0,105,  0,110,  0,101,  0,100,  0, 32,  0,
105,  0,110,  0, 32,  0,116,  0,104,  0,105,  0,115,  0, 32,  0,
110,  0,111,  0,116,  0,105,  0, 99,  0,101,  0, 44,  0, 32,  0,
116,  0,104,  0,101,  0, 32,  0,110,  0, 97,  0,109,  0,101,  0,
115,  0, 32,  0,111,  0,102,  0, 32,  0, 71,  0,110,  0,111,  0,
109,  0,101,  0, 44,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0,
 71,  0,110,  0,111,  0,109,  0,101,  0, 32,  0, 70,  0,111,  0,
117,  0,110,  0,100,  0, 97,  0,116,  0,105,  0,111,  0,110,  0,
 44,  0, 32,  0, 97,  0,110,  0,100,  0, 32,  0, 66,  0,105,  0,
116,  0,115,  0,116,  0,114,  0,101,  0, 97,  0,109,  0, 32,  0,
 73,  0,110,  0, 99,  0, 46,  0, 44,  0, 32,  0,115,  0,104,  0,
 97,  0,108,  0,108,  0, 32,  0,110,  0,111,  0,116,  0, 32,  0,
 98,  0,101,  0, 32,  0,117,  0,115,  0,101,  0,100,  0, 32,  0,
105,  0,110,  0, 32,  0, 97,  0,100,  0,118,  0,101,  0,114,  0,
116,  0,105,  0,115,  0,105,  0,110,  0,103,  0, 32,  0,111,  0,
114,  0, 32,  0,111,  0,116,  0,104,  0,101,  0,114,  0,119,  0,
105,  0,115,  0,101,  0, 32,  0,116,  0,111,  0, 32,  0,112,  0,
114,  0,111,  0,109,  0,111,  0,116,  0,101,  0, 32,  0,116,  0,
104,  0,101,  0, 32,  0,115,  0, 97,  0,108,  0,101,  0, 44,  0,
 32,  0,117,  0,115,  0,101,  0, 32,  0,111,  0,114,  0, 32,  0,
111,  0,116,  0,104,  0,101,  0,114,  0, 32,  0,100,  0,101,  0,
 97,  0,108,  0,105,  0,110,  0,103,  0,115,  0, 32,  0,105,  0,
110,  0, 32,  0,116,  0,104,  0,105,  0,115,  0, 32,  0, 70,  0,
111,  0,110,  0,116,  0, 32,  0, 83,  0,111,  0,102,  0,116,  0,
119,  0, 97,  0,114,  0,101,  0, 32,  0,119,  0,105,  0,116,  0,
104,  0,111,  0,117,  0,116,  0, 32,  0,112,  0,114,  0,105,  0,
111,  0,114,  0, 32,  0,119,  0,114,  0,105,  0,116,  0,116,  0,
101,  0,110,  0, 32,  0, 97,  0,117,  0,116,  0,104,  0,111,  0,
114,  0,105,  0,122,  0, 97,  0,116,  0,105,  0,111,  0,110,  0,
 32,  0,102,  0,114,  0,111,  0,109,  0, 32,  0,116,  0,104,  0,
101,  0, 32,  0, 71,  0,110,  0,111,  0,109,  0,101,  0, 32,  0,
 70,  0,111,  0,117,  0,110,  0,100,  0, 97,  0,116,  0,105,  0,
111,  0,110,  0, 32,  0,111,  0,114,  0, 32,  0, 66,  0,105,  0,
116,  0,115,  0,116,  0,114,  0,101,  0, 97,  0,109,  0, 32,  0,
 73,  0,110,  0, 99,  0, 46,  0, 44,  0, 32,  0,114,  0,101,  0,
115,  0,112,  0,101,  0, 99,  0,116,  0,105,  0,118,  0,101,  0,
108,  0,121,  0, 46,  0, 32,  0, 70,  0,111,  0,114,  0, 32,  0,
102,  0,117,  0,114,  0,116,  0,104,  0,101,  0,114,  0, 32,  0,
105,  0,110,  0,102,  0,111,  0,114,  0,109,  0, 97,  0,116,  0,
105,  0,111,  0,110,  0, 44,  0, 32,  0, 99,  0,111,  0,110,  0,
116,  0, 97,  0, 99,  0,116,  0, 58,  0, 32,  0,102,  0,111,  0,
110,  0,116,  0,115,  0, 32,  0, 97,  0,116,  0, 32,  0,103,  0,
110,  0,111,  0,109,  0,101,  0, 32,  0,100,  0,111,  0,116,  0,
 32,  0,111,  0,114,  0,103,  0, 46,  0,104,  0,116,  0,116,  0,
112,  0, 58,  0, 47,  0, 47,  0,119,  0,119,  0,119,  0, 46,  0,
 98,  0,105,  0,116,  0,115,  0,116,  0,114,  0,101,  0, 97,  0,
109,  0, 46,  0, 99,  0,111,  0,109,  0,  0,  0,  0,  0,  1, 35,
  1, 47,  0,184,  0,203,  0,184,  0,193,  0,170,  0,199,  2,199,
  0,160,  0, 55,  0, 55,  0, 82,  0,190,  1,137,  2, 45,  0,203,
  0,166,  0,135,  0,217,  5,  2,  0,180,  0,156,  1, 57,  1, 20,
  1, 57,  0, 55,  0,211,  6, 20,  6,121,  5,133,  5,168,  0,203,
  0, 92,  0,184,  0, 72,  1, 47,  0,217,  0,147,  0,  0,  0,203,
  0,184,  0,184,  0,127,  2,123,  2, 80,  0,102,  0,199,  5,205,
  0,154,  0,154,  0,111,  0,203,  0,184,  0,240,  0,186,  1,131,
  0,213,  0,152,  0,203,  2, 72,  0,246,  0,131,  3, 84,  0,143,
  0,143,  0,154,  0,115,  4,  0,  5,213,  1, 10,  0,254,  2, 43,
  0,164,  0,180,  0,156,  0,156,  0,  0,  0, 98,  0,  0,  0, 29,
  3, 45,  5,213,  5,213,  5,213,  5,240,  0,127,  0,123,  0, 84,
  0,164,  6,184,  6, 20,  1,211,  0,184,  0,203,  0,166,  1,195,
  1,236,  0,233,  0,160,  0,211,  3, 92,  3,113,  0, 98,  0,156,
  0,168,  1,133,  4, 35,  4,168,  4, 72,  0,143,  1, 57,  1, 20,
  1, 57,  3, 96,  0,143,  2,131,  1,154,  4, 96,  4, 96,  4, 96,
  4,123,  0,  0,  2,119,  0,156,  4, 96,  1,170,  6, 20,  0,197,
  0,127,  2,123,  0,  0,  2, 80,  5,205,  0,102,  0,188,  0,102,
  0,119,  0,205,  1, 59,  1,133,  3,137,  0,143,  0,123,  0,  0,
  0, 29,  5,213,  0,205,  7, 74,  4, 47,  0,156,  0,156,  0,  0,
  7,125,  3, 53,  0,111,  0,  0,  0,111,  0,174,  0,178,  0, 45,
  3,150,  2,123,  0,246,  0,131,  3, 84,  6,102,  0,156,  2,102,
  0,143,  2,246,  3,113,  0,205,  3, 68,  0, 41,  0,102,  0,115,
  0,  0, 20,  0,184,  2,128, 64,255,177,254,  3,176, 37,  3,175,
 50,  3,174,150,  3,173, 14,  3,172,115, 14,  5,172, 50,  3,171,
254,  3,170, 37,  3,169, 14,  3,168, 37,  3,167,150,  3,166,250,
  3,165,250,  3,164,254,  3,163, 58,  3,162,254,  3,161, 50,  3,
160,159, 83,  5,160,150,  3,159, 77, 65,  5,159, 83,  3,158, 50,
  3,157, 20,  3,156,150,  3,155, 10,  3,154,254,  3,153, 18,  3,
152,125,  3,151,187,  3,150,254,  3,148, 77, 65,  5,148,125,  3,
147,254,  3,146,145, 71,  5,146,125,  3,145, 71,  3,144,143, 27,
  5,144,254,  3,143, 27,  3,142,254,  3,141,254,  3,140,254,  3,
139,254,  3,138,137, 30,  5,138,254,  3,137, 30,  3,136, 50,  3,
135,254,  3,132, 22,  3,131,254,  3,130,254,  3,129,254,  3,128,
254,  3,127,254,  3,126,254,  3,125, 75, 37,  5,125,100,  3,124,
254,  3,123, 17,  3,122,121,187,  5,122,254,  3,121,120, 93,  5,
121,187,  3,121,128,  4,120,119, 37,  5,120, 93,  3,120, 64,  4,
119, 37,  3,118,254,  3,117,150,  3,116,100,  3,115, 14,  3,114,
113, 37,  5,114,100,  3,113,112, 18,  5,113, 37,  3,112, 18,  3,
111, 77, 65,  5,111,250,  3,110, 64,255,254,  3,109,254,  3,108,
254,  3,107, 22,  3,106,105, 58,  5,106,100,  3,105, 75, 37,  5,
105, 58,  3,104, 78, 11,  5,104, 24,  3,103,102, 14,  5,103, 50,
  3,102, 14,  3,101,100,  3,100, 77, 65,  5,100,150,  3, 99,254,
  3, 98, 97, 12,  5, 98,254,  3, 97, 12,  3, 96, 95, 25,  5, 96,
100,  3, 95, 94, 16,  5, 95, 25,  3, 94, 16,  3, 93, 10,  3, 92,
 91, 13,  5, 92,254,  3, 91, 13,  3, 90, 77, 65,  5, 90,150,  3,
 89, 88, 14,  5, 89, 40,  3, 88, 14,  3, 87,250,  3, 86, 85,187,
  5, 86,254,  3, 85, 84, 93,  5, 85,187,  3, 85,128,  4, 84, 83,
 37,  5, 84, 93,  3, 84, 64,  4, 83, 37,  3, 82,254,  3, 81, 80,
 46,  5, 81,254,  3, 80, 46,  3, 79, 78, 11,  5, 79, 20,  3, 78,
 11,  3, 77, 75, 37,  5, 77, 65,  3, 76, 75, 37,  5, 76,254,  3,
 75, 74, 17,  5, 75, 37,  3, 74, 17,  3, 73,254,  3, 72, 71, 17,
  5, 72,254,  3, 71, 17,  3, 70,254,  3, 69,254,  3, 68,254,  3,
 67, 66,125,  5, 67,254,  3, 66,125,  3, 65,254,  3, 64,250,  3,
 63,250,  3, 62,250,  3, 60, 54, 66,  5, 60,254,  3, 59,200,  3,
 58, 54, 66,  5, 58, 83,  3, 57,254, 64,112,  3, 56,125,  3, 55,
 54, 66,  5, 54,  4, 45,  5, 54, 66,  3, 53,254,  3, 52,254,  3,
 51, 58,  3, 50,250,  3, 48, 12,  3, 47,254,  3, 45,254,  3, 44,
254,  3, 43,  4, 45,  5, 43, 49,  3, 42, 16,  3, 41,  3, 16,  5,
 41, 35,  3, 40, 30,  3, 39, 38, 14,  5, 39,100,  3, 38, 14,  3,
 37,  1, 10,  5, 37, 50,  3, 36, 12, 24,  5, 36,125,  3, 35,  5,
 58,  5, 35,254,  3, 34, 12, 24,  5, 34,187,  3, 33,  3, 16,  5,
 33, 27,  3, 32, 31, 11,  5, 32, 15,  3, 32,184,255,192, 64,154,
  4, 31, 11,  3, 30,  9,  3, 30, 64,  4, 29, 16,  3, 28,  5, 58,
  5, 28,150,  3, 27,150,  3, 26, 25, 37,  5, 26,100,  3, 25, 24,
 18,  5, 25, 37,  3, 24, 18,  3, 23, 22, 37,  5, 23, 65,  3, 22,
 37,  3, 21,254,  3, 20,254,  3, 19,250,  3, 18, 17, 25,  5, 18,
254,  3, 17,  3, 16,  5, 17, 25,  3, 16,254,  3, 15,254,  3, 14,
  5, 58,  5, 14,150,  3, 13, 12, 24,  5, 13,125,  3, 12, 11, 12,
  5, 12, 24,  3, 11, 12,  3, 10,254,  3,  8,  5, 58,  5,  8,150,
  3,  6,  3, 16,  5,  6,254,  3,  5,  4, 45,  5,  5, 58,  3,  4,
  3, 16,  5,  4, 45,  3,  3, 16,  3,  2,  1, 10,  5,  2, 24,  3,
  1, 10,  3,  1, 64,  4,  0, 28,  3,  1,184,  1,100,133,141,  1,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,  0,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 29,
182,  6,  5,  4,  3,  2,  1,  0, 44, 32, 16,176,  2, 37, 73,100,
176, 64, 81, 88, 32,200, 89, 33, 45, 44,176,  2, 37, 73,100,176,
 64, 81, 88, 32,200, 89, 33, 45, 44, 32, 16,  7, 32,176,  0, 80,
176, 13,121, 32,184,255,255, 80, 88,  4, 27,  5, 89,176,  5, 28,
176,  3, 37,  8,176,  4, 37, 35,225, 32,176,  0, 80,176, 13,121,
 32,184,255,255, 80, 88,  4, 27,  5, 89,176,  5, 28,176,  3, 37,
  8,225, 45, 44, 75, 80, 88, 32,176,179, 69, 68, 89, 33, 45, 44,
176,  2, 37, 69, 96, 68, 45, 44, 75, 83, 88,176,  2, 37,176,  2,
 37, 69, 68, 89, 33, 33, 45, 44, 69, 68, 45,  0,  0,  2,  0,102,
254,150,  4,102,  5,164,  0,  3,  0,  7,  0, 26, 64, 12,  4,177,
  0,  6,177,  1,  8,  5, 68,  2,  4,  0, 47,196,212,236, 49,  0,
 16,212,236,212,236, 48, 19, 17, 33, 17, 37, 33, 17, 33,102,  4,
  0,252,115,  3, 27,252,229,254,150,  7, 14,248,242,114,  6, 41,
  0,  2,  0,162,  0,  0,  2,143,  5,213,  0,  5,  0,  9,  0,127,
 64, 45,  4,  3,  2,  5,  2,  5,  5,  0,  5,  1,  5,  0,  0,  5,
  8,  5,  9,  6,  9,  7,  5,  6,  9, 58,  3,  6, 72,  0, 70,  8,
  4,  6,  8,  7,  3,  3,  5,  1,  5,  0,  2,  6,  0,  9, 10, 16,
212,228,244,196,192, 18, 23, 57, 17, 57, 49,  0, 47,228,252,204,
 48, 75, 83, 88,  7,  5,237,  7, 16,  5,237,  7, 16,  5,237,  7,
 16,  5,237, 17, 23, 57, 89, 34,  1, 75,176,  9, 84, 75,176, 10,
 84, 91, 75,176, 17, 84, 91, 75,176, 18, 84, 91, 88,189,  0, 10,
  0, 64,  0,  1,  0, 10,  0, 10,255,192, 56, 17, 55, 56, 89,  1,
 51, 11,  1, 35, 19,  3, 51,  7, 35,  1,197,202,127, 90,162, 50,
113,203, 49,205,  5,213,253,113,254,155,  1,101,253,184,254,  0,
  0,  2,  0,197,  3,170,  2,233,  5,213,  0,  3,  0,  7,  0, 30,
 64, 15,  5,  1, 73,  4,  0, 70,  8,  4,  7,  6,  0,  7,  2,  6,
  8, 16,252,252,220,236, 49,  0, 16,244, 60,236, 50, 48,  1, 17,
 35, 17, 33, 17, 35, 17,  1,111,170,  2, 36,170,  5,213,253,213,
  2, 43,253,213,  2, 43,  0,  2,  0,143,  0,  0,  6, 47,  5,190,
  0, 27,  0, 31,  0, 78, 64, 52, 28, 23,  7, 76,  3,  0, 25,  5,
  1, 30, 21,  9, 76, 19, 15, 11, 17, 13, 31, 30, 29, 28, 27, 26,
 25, 24, 23, 22, 21, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10,  9,
  8,  7,  5,  4,  3,  2,  1,  0, 30,  6, 20, 32, 16,212,204, 23,
 57, 49,  0, 47, 60,212, 60, 60,252, 60, 60,212, 60, 60,196, 50,
236, 50, 50, 48,  1,  3, 33, 19, 51,  3, 33,  7, 33,  3, 33,  7,
 33,  3, 35, 19, 33,  3, 35, 19, 33, 55, 33, 19, 33, 55, 33, 19,
  1, 33,  3, 33,  3,129,104,  1, 36,105,160,103,  1, 80, 39,254,
176, 82,  1, 84, 36,254,169,104,160,103,254,219,103,161,104,254,
182, 37,  1, 74, 84,254,176, 39,  1, 80,102,  1, 56,254,221, 84,
  1, 37,  5,190,254, 97,  1,159,254, 97,154,254,178,153,254, 98,
  1,158,254, 98,  1,158,153,  1, 78,154,  1,159,253,199,254,178,
  0,  3,  0, 68,254,211,  4,143,  6, 20,  0,  6,  0, 13,  0, 47,
  0, 96, 64, 57,  6, 13, 19, 36,  4, 32, 15, 75, 14, 79, 18,  7,
 77, 43, 42, 32, 75, 31, 35,  0, 77, 45, 42, 31, 26, 28, 25, 27,
 39, 44, 43, 26, 13,  7,  6,  0,  7, 45, 18, 19, 25, 35, 36, 42,
 28,  8, 10,  3, 15, 14,  3,  8, 22, 10,  8, 39, 48, 16,212,236,
212,236,192,192, 17, 18, 23, 57, 23, 57, 17, 57, 49,  0, 47, 60,
196,196,196, 50,252,196, 16,238, 16,198,238, 50,246,238, 17, 23,
 57, 48, 37, 54, 54, 53, 52, 38, 39, 19,  6,  6, 21, 20, 22, 23,
  1,  7, 38, 38, 39,  3, 22, 22, 21, 20,  4,  7,  3, 35, 19, 38,
 38, 39, 55, 22, 22, 23, 19, 38, 38, 53, 52, 36, 55, 55, 51,  7,
 22, 22,  2, 88,139,162,102,115, 16,132,150, 95,108,  2, 34, 34,
 86,167, 79, 84,184,193,254,226,237, 59,100, 59,116,204, 83, 34,
 92,200,106, 88,189,172,  1, 19,225, 47,100, 44, 90,171,145,  6,
129,103, 84, 92, 19,  2, 90, 14,128,100, 70, 79, 19,  1,236,181,
 46, 50,  2,254, 85, 29,172,135,175,229, 12,254,211,  1, 45,  3,
 47, 42,184, 62, 68,  4,  1,200, 36,149,126,166,230, 18,233,233,
  3, 31,  0,  5,  0,186,255,227,  6,223,  5,240,  0, 11,  0, 23,
  0, 35,  0, 47,  0, 51,  0, 79, 64, 44, 27, 87, 42, 21, 87,  0,
 82, 15, 87,  6, 33, 87, 42, 82, 49, 36, 81, 48,  6, 86, 52, 48,
 45, 24, 50, 18,  3, 30, 10, 39, 12, 10,  9, 24, 10, 39,  9, 45,
 18, 10,  9,  9,  3, 52, 16,212,236,236,212,236,236, 16,238, 16,
238, 17, 18, 57, 17, 18, 57, 49,  0, 16,228, 50,244, 60,228,236,
 16,238,246,238, 16,238, 48,  1, 34, 38, 53, 52, 18, 51, 50, 22,
 21, 20,  2, 19, 52, 38, 35, 34,  6, 21, 20, 22, 51, 50, 54,  1,
 52, 38, 35, 34,  6, 21, 20, 22, 51, 50, 54,  1, 34, 38, 53, 52,
 18, 51, 50, 22, 21, 20,  2, 19,  1, 35,  1,  1,225,136,159,232,
186,136,159,232, 72, 78, 77,112,126, 81, 75,107,130,  3, 92, 76,
 77,111,127, 81, 75,107,128,255,  0,136,158,231,186,136,157,231,
155,251, 46,160,  4,211,  2,195,177,152,216,  1, 12,179,153,214,
254,245,  1,219,105,106,194,173, 92,100,190,253,190,107,106,195,
173, 93,100,190,254,195,178,152,216,  1, 11,176,153,215,254,243,
  6, 13,249,243,  6, 13,  0,  2,  0, 96,255,227,  5,227,  5,240,
  0,  9,  0, 51,  0,251, 64, 84,  3,  2,  2,  4,  1,  5, 47, 14,
 47,  8,  9,  2,  7,  0,  5, 14, 47, 18, 17,  2, 19, 16,  5, 14,
 47, 15,  5, 14, 14, 47, 58, 48, 13,  0,  3,  7,  1, 47, 25,  3,
 38, 16, 10,  7, 90, 19, 38, 37, 89, 41, 90, 34, 86, 19, 81, 10,
 14, 48, 47, 38,  3, 44, 14, 10, 37,  0, 16, 13,  4, 51,  1, 25,
 44, 14, 28, 51,  5, 10, 28,  4, 14, 22, 13, 52, 16,244,236,196,
212,236, 16,238, 57, 57, 17, 23, 57, 18, 57, 18, 23, 57, 49,  0,
 47,196,228,246,238,246,206, 16,238, 17, 57, 18, 23, 57, 18, 23,
 57, 48, 75, 83, 88,  7, 16,  5,237,  7,  4,237, 17, 23, 57,  7,
  5,237, 17, 23, 57,  7, 16,  4,237, 17, 23, 57, 89, 34,178,  8,
 15,  1,  1, 93, 64, 88, 11, 16, 25,  1, 26, 16, 42,  1, 58, 12,
 73,  0,116,  1,136,  1,142, 17,150,  0,149,  9,156, 17, 12, 15,
  0, 11, 14, 10, 15, 10, 16,  9, 37,  9, 38, 26,  0, 24,  1, 22,
 13, 22, 16, 25, 37, 25, 38, 43,  0, 41,  1, 42, 37, 42, 38, 54,
 13, 57, 37, 57, 38, 54, 47, 75,  0, 73,  1,107,  0,120,  1,117,
 47,137,  1,138, 15,138, 16,158,  0,154, 15,154, 16, 31, 93,  0,
 93,  9,  1, 14,  1, 21, 20, 22, 51, 50, 54,  1,  6,  2,  7, 19,
 35, 39, 14,  1, 35, 34, 36, 53, 52, 18, 55, 46,  1, 53, 52, 54,
 55, 62,  1, 51, 50, 22, 23,  7, 46,  1, 35, 34,  6, 21, 20, 22,
 23,  1, 62,  1, 55,  3,199,254, 86,121,125,171,142, 94,183,  2,
110, 45,147,103,209,252,106,106,244,133,221,254,249,185,182, 31,
 29, 46, 43, 69,208,120, 78,158, 81, 35, 75,149, 70,124,155, 38,
 69,  1,151, 75,106, 28,  1,  4,  2, 31, 88,198,103,127,154, 65,
  2, 91,159,254,248,108,254,242,139, 83, 85,218,180,154,  1, 18,
116, 46, 95, 54, 68,122, 50, 82, 90, 36, 36,182, 47, 49,129,100,
 44, 86, 88,253,248, 79,205,122,  0,  1,  0,197,  3,170,  1,111,
  5,213,  0,  3,  0, 21, 64, 10,  1, 73,  0, 70,  4,  0,  7,  2,
  6,  4, 16,252,236, 49,  0, 16,244,236, 48,  1, 17, 35, 17,  1,
111,170,  5,213,253,213,  2, 43,  0,  1,  0,158,254,242,  3,106,
  6, 18,  0, 13,  0, 29, 64, 13,  6,  0, 92, 14,  7, 10,  6, 13,
  0,  3, 14, 10, 14, 16,212,252,196, 57, 57, 18, 57, 49,  0, 16,
252,204, 48,  1,  0,  0, 17, 20, 18, 23, 35, 38,  2, 53, 16,  0,
  1,  3,106,254,247,254,251, 76, 76,160, 92, 90,  1, 19,  1, 22,
  6, 18,254,181,253,173,254,236,158,254,201,153,172,  1, 69,156,
  1, 41,  2, 71,  1, 35,  0,  1,255,129,254,242,  2, 78,  6, 18,
  0, 13,  0, 33, 64, 15,  0,  6, 92, 14,  6, 14,  7, 10, 13,  0,
 10, 14,  0,  3, 14, 16,212,196,236, 18, 57, 18, 57, 18, 57, 49,
  0, 16,252,204, 48,  3,  0,  0, 17, 52,  2, 39, 51, 22, 18, 21,
 16,  0,  1,127,  1, 10,  1,  4, 75, 76,160, 92, 90,254,235,254,
236,254,242,  1, 75,  2, 83,  1, 20,158,  1, 55,153,173,254,190,
156,254,214,253,181,254,224,  0,  0,  1,  0, 61,  2, 74,  3,195,
  5,240,  0, 17,  0, 78, 64, 44, 16, 13, 11,  0,  4, 12,  9,  7,
  4,  2,  4,  8,  3, 93,  5, 17, 12, 93, 10,  1, 14, 86, 18,  8,
 12, 10,  3,  9,  6, 17,  3,  1,  3,  2,  0, 15, 15,  4, 11,  9,
 15, 13,  6, 18, 16,212, 60,228, 50,220, 60,228, 50, 23, 57, 17,
 18, 23, 57, 49,  0, 16,244,212, 60,236, 50,196,236, 50, 23, 57,
 18, 23, 57, 48,  1,  5,  5,  7, 37, 17, 35, 17,  5, 39, 37, 37,
 55,  5, 17, 51, 17, 37,  3,195,254,153,  1,103, 58,254,176,114,
254,176, 58,  1,103,254,153, 58,  1, 80,114,  1, 80,  4,223,194,
195, 98,203,254,135,  1,121,203, 98,195,194, 99,203,  1,121,254,
135,203,  0,  1,  0,217,  0,  0,  5,219,  5,  4,  0, 11,  0, 35,
 64, 17,  0,  9,  1, 96,  7,  3,  5,  2, 16,  4,  0, 18, 10,  6,
 16,  8, 12, 16,220,252, 60,252, 60,236, 49,  0, 47,212, 60,252,
 60,196, 48,  1, 17, 33, 21, 33, 17, 35, 17, 33, 53, 33, 17,  3,
174,  2, 45,253,211,168,253,211,  2, 45,  5,  4,253,211,170,253,
211,  2, 45,170,  2, 45,  0,  1,  0,  6,255, 18,  1,139,  0,254,
  0,  5,  0,134, 64, 25,  4,  3,  2,  5,  2,  5,  5,  0,  5,  1,
  5,  0,  5, 58,  3, 98,  0, 72,  6,  1,  4,  5,  0,  0,  6, 16,
212,228,196,192, 49,  0, 16,252,236, 48, 75, 83, 88,  7,  5,237,
  7, 16,  5,237, 17, 23, 57, 89, 34,  1, 75,176,  9, 84, 75,176,
 10, 84, 91, 88,189,  0,  6,  0, 64,  0,  1,  0,  6,  0,  6,255,
192, 56, 17, 55, 56, 89, 64, 25,  5,  3,  5,  4, 21,  3, 21,  4,
 37,  3, 37,  4, 53,  3, 53,  4, 70,  3, 70,  4, 86,  3, 86,  4,
 12, 93,  1, 75,176, 17, 84, 88,189,  0,  6,  0,128,  0,  1,  0,
  6,  0,  6,255,128, 56, 17, 55, 56, 89, 55, 51,  7,  3, 35, 19,
184,211, 33,227,129,144,254,172,254,192,  1, 64,  0,  1,  0, 92,
  1,223,  2,152,  2,131,  0,  3,  0, 63, 64,  9,  2, 99,  0,  4,
  2,  0,  1,  3,  4, 16,212,204, 57, 57, 49,  0, 16,212,236, 48,
  1, 75,176, 14, 84, 88,189,  0,  4,  0, 64,  0,  1,  0,  4,  0,
  4,255,192, 56, 17, 55, 56, 89, 64, 13, 95,  2, 95,  3,111,  2,
111,  3,127,  2,127,  3,  6,  0, 93, 19, 33,  7, 33,125,  2, 27,
 31,253,227,  2,131,164,  0,  1,  0,119,  0,  0,  1,123,  0,254,
  0,  3,  0, 81, 64, 21,  2,  5,  3,  0,  3,  1,  5,  0,  0,  3,
 58,  0, 72,  2,  2,  1,  0,  0,  0,  3,  4, 16,212,228, 16,192,
 57, 49,  0, 47,236, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,
237, 89, 34,  1, 75,176,  9, 84, 75,176, 10, 84, 91, 75,176, 17,
 84, 91, 88,189,  0,  4,  0, 64,  0,  1,  0,  4,  0,  4,255,192,
 56, 17, 55, 56, 89, 55, 51,  7, 35,168,211, 49,211,254,254,  0,
  0,  1,255,106,255, 66,  3,106,  5,213,  0,  3,  0, 46, 64, 19,
  2,  3,  0,  3,  1,  0,  3, 58,  2,  0, 70,  4,  2,  4,  1,  0,
  0,  3,  4, 16,212,196, 16,192, 18, 57, 49,  0, 16,244,204, 48,
 75, 83, 88,  7,  5,201,  7, 16,  5,201, 89, 34,  1, 51,  1, 35,
  2,184,178,252,177,177,  5,213,249,109,  0,  2,  0,102,255,227,
  4,176,  5,240,  0, 17,  0, 35,  0, 68, 64, 18, 27,100,  9, 18,
100,  0, 86,  9, 81, 36, 33,  8,  3, 24,  8, 12, 19, 36, 16,244,
236,212,236, 49,  0, 16,228,244,236, 16,238, 48,  1, 75,176,  9,
 84, 75,176, 10, 84, 91, 75,176, 11, 84, 91, 88,189,  0, 36,  0,
 64,  0,  1,  0, 36,  0, 36,255,192, 56, 17, 55, 56, 89,  1, 50,
 18, 21, 20,  2,  7, 14,  1, 35, 34,  2, 53, 52, 18, 55, 62,  1,
 23, 34,  6,  7,  6,  2, 21, 20, 22, 51, 50, 54, 55, 54, 18, 53,
 52, 38,  3, 14,203,215,101, 91, 93,251,152,196,214,103, 92, 92,
247,134, 76,137, 55, 92,109,117,114, 80,136, 55, 91,107,117,  5,
240,254,242,253,192,254,133,150,150,155,  1, 16,251,190,  1,125,
149,150,156,160, 81, 79,132,254,117,208,165,169, 81, 79,131,  1,
139,209,165,169,  0,  1,  0,100,  0,  0,  3,225,  5,213,  0, 10,
  0, 84, 64, 42,  9,  8,  2,  7,  5,  1,  5,  1,  6,  5,  5,  5,
  1, 58,  3,100,  4,  2,100,  5, 70,  7,  0,100,  9,  9,  6,  8,
  2,  0,  4,  3,  3, 10,  7,  1,  8,  2,  2,  1, 10, 11, 16,212,
212,196, 16,192, 18, 57, 17, 23, 57, 17, 18, 57, 57, 49,  0, 47,
236, 50,244,236,212,236, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,
  5,237, 23, 50, 89, 34, 55, 33, 19,  5, 55, 37, 51,  1, 33,  7,
 33,133,  1, 74,223,254,139, 35,  1,115,203,254,254,  1, 73, 32,
252,163,170,  4,125, 72,174, 72,250,213,170,  0,  0,  1,  0,  8,
  0,  0,  4,152,  5,240,  0, 24,  0,155, 64, 44,  1,  4,  5,  6,
  5, 23, 24,  2, 22,  0,  4,  6,  6,  5, 58,  6,  0,  1, 15,101,
 16, 89, 12,100, 19, 86,  1,100,  3,  3,  2, 22, 15,  6,  1,  3,
 16,  0,  4,  9,  8, 22,  4, 25, 16,212,212,236, 17, 57, 57, 23,
 57, 17, 57, 57, 49,  0, 47,236,244,236,244,236, 17, 57, 57, 48,
 75, 83, 88,  7, 16,  5,237, 17, 23, 57,  7, 16,  5,237, 89, 34,
  1, 75,176, 10, 84, 88,189,  0, 25,  0, 64,  0,  1,  0, 25,  0,
 25,255,192, 56, 17, 55, 56, 89, 64, 40, 10,  0, 10, 24, 25,  0,
 25, 24, 44,  0, 44, 24,101,  8,121,  0,117,  5,120,  6,121, 24,
 11,  5,  1, 18,  1, 21,  6, 39,  6, 52,  1, 85,  1, 99,  1,118,
  1,  8, 93,  0, 93,  9,  1, 33,  7, 33, 55,  1, 62,  1, 53, 52,
 38, 35, 34,  6,  7, 55, 62,  1, 51, 50, 22, 21, 20,  6,  3,176,
253,123,  2,201, 35,252, 55, 33,  2,162,135,113,136,110, 95,232,
132, 37,124,226, 96,196,239,114,  2,209,253,215,168,170,  2, 66,
117,177, 93, 97,122, 68, 65,200, 49, 50,208,169,114,207,  0,  1,
  0,  4,255,227,  4,147,  5,240,  0, 43,  0,150, 64, 43,  9, 31,
100, 33, 22, 75, 21, 88, 25,100, 18, 43, 75,  0, 88, 40,100,  3,
 86, 18, 81, 33,103, 44, 33, 32, 31, 22,  4,  9, 34, 43,  0,  4,
 21, 28,  8, 12, 37,  8,  6, 21, 44, 16,212,212,236,212,236, 17,
 23, 57, 23, 57, 49,  0, 16,236,228,244,236,244,236, 16,238,246,
238, 16,238, 57, 48,  1, 75,176, 10, 84, 88,189,  0, 44,  0, 64,
  0,  1,  0, 44,  0, 44,255,192, 56, 17, 55, 56, 89,  1, 75,176,
 13, 84, 75,176, 14, 84, 91, 75,176, 16, 84, 91, 88,189,  0, 44,
255,192,  0,  1,  0, 44,  0, 44,  0, 64, 56, 17, 55, 56, 89, 64,
 14, 97,  0,102,  1,102, 42, 97, 43,  4, 22,  0, 22, 43,  2, 93,
  0, 93,  1, 62,  1, 51, 50, 22, 21, 20,  6,  7, 30,  1, 21, 20,
  6,  7, 14,  1, 35, 34, 38, 39, 55, 30,  1, 51, 50, 54, 53, 52,
 38, 43,  1, 55, 51, 50, 54, 53, 52, 38, 35, 34,  6,  7,  1, 68,
110,207,100,198,232,183,161,126,118,115,108, 82,228,149, 94,192,
 99, 37, 94,191,100,197,245,156,145,174, 31,184,166,191,140,127,
 96,201,108,  5,176, 32, 32,176,148,145,208, 38, 36,152,125,120,
210, 76, 58, 57, 37, 37,191, 52, 51,203,162,104,113,164,152,130,
 94,103, 41, 41,  0,  2,  0, 37,  0,  0,  4,133,  5,213,  0, 10,
  0, 13,  0,200, 64, 59, 12, 10,  0, 10, 11, 13, 11,  0,  0, 10,
 11,  5, 12, 11,  1,  6,  1, 13,  5,  6,  1,  8,  5,  6,  1,  7,
  5,  6,  6,  1, 58, 11,  0,  8,  4,100, 12,  2,  0, 70,  6, 13,
 12,  7,  8,  4,  9, 11,  5,  4,  2,  4,  6,  3,  6,  2,  1,  9,
 14, 16,212,212,228,192, 18, 23, 57, 17, 23, 57, 49,  0, 47,228,
212, 60,236, 50, 18, 57, 48, 75, 83, 88,  7, 16,  5,237,  7,  5,
237,  7,  5,237,  7, 16,  8,237,  7, 16,  8,201,  7, 16,  5,201,
 89, 34,  1, 75,176, 12, 84, 75,176, 13, 84, 91, 75,176, 14, 84,
 91, 75,176, 15, 84, 91, 75,176, 16, 84, 91, 75,176, 17, 84, 91,
 88,189,  0, 14,255,192,  0,  1,  0, 14,  0, 14,  0, 64, 56, 17,
 55, 56, 89, 64, 36, 58, 11,  1,  9,  0, 25,  0, 43,  0, 42,  1,
 41, 11, 58,  0, 56,  1, 57, 11, 54, 12,102, 12,121,  0,117, 12,
136,  0,133, 12,154,  0,150, 12, 16, 93,  0, 93,  1, 51,  3, 51,
  7, 35,  3, 35, 19, 33, 55,  9,  1, 33,  3,113,254,191,213, 33,
213, 67,201, 68,253, 94, 39,  3, 55,253,102,  1,254,  5,213,252,
 51,168,254,160,  1, 96,195,  3,  2,252,227,  0,  0,  1,  0, 41,
255,227,  4,166,  5,213,  0, 32,  0,137, 64, 54,  5,  4,  2,  3,
  5, 31, 32, 31,  2,  5, 32, 32, 31, 58,  3,  6, 31, 28,100,  6,
 19, 75, 18, 79, 22,100, 15,  1,100,  0, 70, 15, 81,  6, 33, 32,
 31, 19,  2,  4, 25, 18,  1,  9,  0,  3, 25, 18,  0, 25,  8,  9,
 18, 33, 16,212,212,236,192, 17, 18, 57, 17, 18, 57, 17, 18, 23,
 57, 49,  0, 16,196,228,244,236, 16,238,246,238, 16,254,196, 18,
 57, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237, 23, 50, 89,
 34,  1, 75,176, 12, 84, 75,176, 14, 84, 91, 75,176, 16, 84, 91,
 88,189,  0, 33,255,192,  0,  1,  0, 33,  0, 33,  0, 64, 56, 17,
 55, 56, 89,  1,  7, 33,  3, 62,  1, 51, 50, 22, 21, 20,  6,  7,
 14,  1, 35, 34, 38, 39, 55, 30,  1, 51, 50, 54, 53, 52, 38, 35,
 34,  6,  7, 19,  4,166, 31,253,150, 72, 46, 95, 49,207,240,123,
113, 80,231,137, 90,188,103, 37, 92,185, 94,195,255,167,150, 79,
171, 90,145,  5,213,168,254,143, 15, 14,222,190,133,244, 92, 64,
 69, 32, 32,188, 45, 45,234,176,130,144, 37, 37,  2,238,  0,  2,
  0,129,255,227,  4,188,  5,240,  0, 11,  0, 42,  0,189, 64, 35,
 19,  9,  3,100, 22,  9,100, 31, 22,107, 16, 13, 75, 12,104, 16,
106, 40, 86, 31, 81, 43, 19,  6,  0, 13, 12,  0,  8, 25,  6,  8,
 34, 19, 43, 16,244,236,212,236,192,192, 17, 18, 57, 49,  0, 16,
228,244,236,244,236, 16,229, 16,238, 16,238, 17, 57, 48,  1, 75,
176, 10, 84, 88,189,  0, 43,  0, 64,  0,  1,  0, 43,  0, 43,255,
192, 56, 17, 55, 56, 89, 64, 96,122,  4,123,  5,  2, 74, 12, 74,
 13, 74, 14, 74, 42, 90, 12, 90, 13, 90, 14, 90, 42,106, 12,106,
 13,106, 14,106, 42,122, 12,122, 13,122, 14,121, 18,122, 42,138,
 12,138, 13,138, 14,138, 42,153, 12,153, 13,153, 14,153, 42,169,
 12,169, 13,169, 14,169, 42,185, 12,185, 13,185, 14,185, 42,201,
 12,201, 13,201, 14,201, 42,217, 12,217, 13,217, 14,217, 42,233,
 12,233, 13,233, 14,233, 42, 45, 93,  0, 93,  1, 52, 38, 35, 34,
  6, 21, 20, 22, 51, 50, 54,  1,  7, 46,  1, 35, 34,  2,  3, 62,
  1, 51, 50, 22, 21, 20,  6,  7, 14,  1, 35, 34,  2, 53, 52, 18,
 55, 54, 36, 51, 50, 22,  3,172,130,112,155,211,129,114,156,209,
  1, 16, 34, 58,150, 85,207,251, 62, 73,193,112,183,217,107,102,
 70,186,105,206,238,109, 98,103,  1, 37,177, 78,152,  2, 41,127,
147,239,176,132,149,245,  4, 58,184, 38, 40,254,252,254,235, 85,
 87,211,178,146,251, 95, 65, 70,  1,  6,228,212,  1,137,144,152,
158, 31,  0,  1,  0,190,  0,  0,  5,  4,  5,213,  0,  6,  0,129,
 64, 23,  5,  5,  2,  3,  2,  3,  5,  4,  5,  4, 58,  5,100,  0,
 70,  3,  5,  0,  1,  6,  1,  4,  7, 16,212,204,196, 17, 57, 57,
 49,  0, 47,244,236, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,
237, 89, 34,  1, 75,176, 10, 84, 88,189,  0,  7,  0, 64,  0,  1,
  0,  7,  0,  7,255,192, 56, 17, 55, 56, 89,  1, 75,176, 12, 84,
 75,176, 14, 84, 91, 75,176, 16, 84, 91, 88,189,  0,  7,255,192,
  0,  1,  0,  7,  0,  7,  0, 64, 56, 17, 55, 56, 89, 64, 17,  9,
  5, 26,  5, 39,  3, 41,  5, 90,  5,104,  5,120,  4,121,  5,  8,
 93,  1, 33,  7,  1, 35,  1, 33,  1,  6,  3,254, 18,252,170,222,
  3, 39,253,  0,  5,213, 86,250,129,  5, 43,  0,  0,  3,  0, 68,
255,227,  4,190,  5,240,  0, 11,  0, 23,  0, 47,  0, 99, 64, 35,
 36, 24,  3,100, 21,  9,100, 30, 15,100, 42, 86, 30, 81, 21,103,
 48, 36, 24, 18,  0,  8, 27, 18,  8, 39, 27, 12,  8, 45,  6,  8,
 39, 33, 48, 16,212,196,236,212,236,196, 16,238, 16,238, 17, 57,
 57, 49,  0, 16,236,228,244,236, 16,238, 16,238, 57, 57, 48,  1,
 75,176, 12, 84, 75,176, 13, 84, 91, 75,176, 14, 84, 91, 88,189,
  0, 48,255,192,  0,  1,  0, 48,  0, 48,  0, 64, 56, 17, 55, 56,
 89,  1, 52, 38, 35, 34,  6, 21, 20, 22, 51, 50, 54, 19, 52, 38,
 35, 34,  6, 21, 20, 22, 51, 50, 54,  7, 30,  1, 21, 20,  0, 35,
 34, 38, 53, 52, 54, 55, 46,  1, 53, 52, 36, 51, 50, 22, 21, 20,
  6,  3,143,158,128,156,203,155,132,157,201,103,140,116,137,177,
139,115,138,178,137,113,120,254,192,253,215,254,218,175,105,110,
  1, 45,231,193,243,181,  1,197,113,143,187,143,114,134,182,  3,
 68, 95,116,154,116,100,122,159,241, 43,174,123,207,254,244,211,
176,160,249, 34, 36,151,108,181,243,197,152,132,207,  0,  0,  2,
  0, 90,255,227,  4,152,  5,240,  0, 30,  0, 42,  0,156, 64, 31,
  7, 40, 34,  1, 75,  0, 34,100, 10,107,  4,106,  0,104, 28, 40,
100, 19, 86, 28, 81, 43,  7, 31, 37,  8, 22, 31,  8, 13, 43, 16,
220,236,212,236, 17, 57, 49,  0, 16,228,244,236, 16,230,254,245,
238, 16,238, 17, 18, 57, 48,  1, 75,176, 10, 84, 88,189,  0, 43,
  0, 64,  0,  1,  0, 43,  0, 43,255,192, 56, 17, 55, 56, 89,  1,
 75,176, 13, 84, 75,176, 14, 84, 91, 75,176, 15, 84, 91, 75,176,
 16, 84, 91, 75,176, 17, 84, 91, 75,176, 18, 84, 91, 88,189,  0,
 43,255,192,  0,  1,  0, 43,  0, 43,  0, 64, 56, 17, 55, 56, 89,
 64, 23, 70,  0, 70,  1, 70,  2,100,  0,100,  1,100,  2,100, 30,
149,  0,149,  1,149,  2,149, 30, 11, 93, 63,  1, 30,  1, 51, 50,
 18, 19, 14,  1, 35, 34, 38, 53, 52, 54, 55, 62,  1, 51, 50, 18,
 21, 20,  2,  7,  6,  4, 35, 34, 38, 19, 20, 22, 51, 50, 54, 53,
 52, 38, 35, 34,  6, 90, 37, 58,148, 85,207,253, 62, 74,195,112,
182,215,106,103, 70,184,104,207,240,111, 98,104,254,220,178, 77,
153,199,132,112,155,210,130,114,155,210, 33,184, 38, 40,  1,  6,
  1, 21, 85, 89,211,178,146,251, 94, 66, 70,254,249,227,211,254,
118,144,152,158, 31,  3,170,127,149,238,177,132,149,243,  0,  2,
  0,106,  0,  0,  2, 12,  4, 35,  0,  3,  0,  7,  0,107, 64, 40,
  2,  5,  3,  0,  3,  1,  5,  0,  0,  3,  6,  5,  7,  4,  7,  5,
  5,  4,  4,  7, 58,  2, 72,  0,108,  4, 72,  6,  6,  5,  2,  3,
  1,  3,  0,  0,  4,  0,  7,  8, 16,212,228,212,228,192, 23, 57,
 49,  0, 47,236,244,236, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,
  5,237,  7, 16,  5,237,  7, 16,  5,237, 89, 34,  1, 75,176, 10,
 84, 75,176, 17, 84, 91, 88,189,  0,  8,  0, 64,  0,  1,  0,  8,
  0,  8,255,192, 56, 17, 55, 56, 89,  1, 51,  7, 35,  3, 51,  7,
 35,  1, 57,211, 49,211,108,211, 50,211,  4, 35,254,253,217,254,
  0,  2,  0,  2,255, 18,  2, 35,  4, 35,  0,  5,  0,  9,  0,161,
 64, 46,  8,  5,  9,  6,  9,  7,  5,  6,  6,  9,  4,  3,  2,  5,
  2,  5,  5,  0,  5,  1,  5,  0,  0,  5, 58,  8, 72,  6,  3, 98,
  0, 72,  6,108, 10,  8,  1,  7,  9,  0,  6,  4,  5,  0,  0, 10,
 16,212,228,196,212,228,192, 57, 57, 49,  0, 16,228,252,236, 16,
238, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237, 17, 23, 57,
  7, 16,  5,237,  7, 16,  5,237, 89, 34,178,  7,  4,  1,  1, 93,
180,  5,  3,  6,  4,  2, 93,  1, 75,176,  9, 84, 75,176, 10, 84,
 91, 75,176, 17, 84, 91, 88,189,  0, 10,  0, 64,  0,  1,  0, 10,
  0, 10,255,192, 56, 17, 55, 56, 89, 64, 21, 20,  3, 20,  4, 37,
  3, 37,  4, 53,  3, 53,  4, 70,  3, 70,  4, 86,  3, 86,  4, 10,
 93, 55, 51,  7,  3, 35, 27,  1, 51,  7, 35,180,211, 35,225,129,
143,191,211, 49,211,254,172,254,192,  1, 64,  3,209,254,  0,  1,
  0,217,  0, 94,  5,219,  4,166,  0,  6,  0, 77, 64, 42,  2, 96,
  3,  4,  3,  1, 96,  0,  1,  4,  4,  3,  1, 96,  2,  1,  5,  6,
  5,  0, 96,  6,  5, 58,  5,  4,  2,  1,  0,  5,  3,110,  6,109,
  7,  1,  2,  0, 21,  4, 20,  7, 16,252,236, 50, 57, 49,  0, 16,
244,236, 23, 57, 48, 75, 83, 88,  7,  4,237,  7, 16,  8,237,  7,
 16,  8,237,  7, 16,  4,237, 89, 34,  9,  2, 21,  1, 53,  1,  5,
219,251,248,  4,  8,250,254,  5,  2,  3,240,254,145,254,147,182,
  1,209,166,  1,209,  0,  0,  2,  0,217,  1, 96,  5,219,  3,162,
  0,  3,  0,  7,  0, 28, 64, 13,  0, 96,  2,  6, 96,  4,  8,  5,
  1,  4,  0, 20,  8, 16,252, 60,196, 50, 49,  0, 16,212,236,212,
236, 48, 19, 33, 21, 33, 21, 33, 21, 33,217,  5,  2,250,254,  5,
  2,250,254,  3,162,168,240,170,  0,  1,  0,217,  0, 94,  5,219,
  4,166,  0,  6,  0, 79, 64, 43,  6, 96,  0,  6,  3,  4,  3,  5,
 96,  4,  4,  3,  0, 96,  1,  2,  1,  6, 96,  5,  6,  2,  2,  1,
 58,  6,  5,  3,  2,  0,  5,  4,110,  1,109,  7,  6,  2, 21,  4,
  0, 20,  7, 16,252, 60,236, 57, 49,  0, 16,244,236, 23, 57, 48,
 75, 83, 88,  7, 16,  8,237,  7, 16,  4,237,  7, 16,  4,237,  7,
 16,  8,237, 89, 34, 19, 53,  1, 21,  1, 53,  1,217,  5,  2,250,
254,  4,  6,  3,240,182,254, 47,166,254, 47,182,  1,109,  0,  2,
  0,252,  0,  0,  4, 23,  5,240,  0,  3,  0, 33,  0,160, 64, 70,
 18,  5, 19, 20, 19, 11, 12, 13, 14, 15, 16,  6, 10, 17,  5, 20,
 20, 19,  1,  5,  2,  3,  2,  0,  5,  3,  3,  2, 58, 23, 20, 17,
 14,  4, 13, 24, 18,  4, 75, 33, 78, 30, 90,  7, 18,  0, 72,  7,
 86,  1, 24, 23, 20, 19, 18, 17, 14,  3,  1,  0, 10, 13,  4,  2,
 27,  5, 10, 33,  2, 34, 16,212,212,212,236, 17, 57, 57, 23, 57,
 49,  0, 47,228,252,204, 16,254,244,238, 18, 57, 57, 23, 57, 48,
 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237,  7, 16,  5,237, 17,
 23, 57,  7, 16,  5,237, 89, 34,  1, 75,176, 12, 84, 88,189,  0,
 34,  0, 64,  0,  1,  0, 34,  0, 34,255,192, 56, 17, 55, 56, 89,
 64, 11,116, 12,116, 13,116, 14,116, 15,116, 16,  5, 93, 37,  7,
 35, 55,  3, 62,  1, 51, 50, 22, 21, 20,  6, 15,  1, 14,  1, 15,
  1, 35, 55, 62,  1, 63,  1, 62,  1, 53, 52, 38, 35, 34,  6,  7,
  1,254, 49,203, 49, 18,102,203,106,161,186,107,121,104, 84, 56,
 18, 25,190, 31, 18, 78,111,106, 84, 68,109, 96, 80,197,104,254,
254,254,  4,129, 57, 56,150,129,103,180, 98, 84, 66, 94, 92,123,
154, 94,131, 92, 89, 70,106, 57, 76, 86, 71, 66,  0,  2,  0,119,
254,158,  7,154,  5,160,  0, 52,  0, 64,  0, 90, 64, 51, 12,  0,
 53, 15, 34, 33, 52, 59, 15,111,  3,114, 33, 30,111, 37, 53,111,
 13,  9,114, 21,111, 37, 46, 65, 62, 15, 14, 13,  4, 12, 33, 34,
 52,  0,  5, 18, 56, 23,  6, 18, 23, 49,  6, 26, 27, 23, 49, 40,
 65, 16,212,196,252,236, 16,238, 16,238, 17, 23, 57, 23, 57, 49,
  0, 16,212,196,252,252,196,236, 16,254,196,253,238, 50,197, 16,
198, 17, 18, 57, 57, 48, 37,  6,  6, 35, 34, 38, 53, 52,  0, 51,
 50, 22, 23, 55, 51,  3, 54, 18, 53, 52,  0, 33, 34,  4,  7,  6,
  2, 21, 16,  0, 33, 50, 54, 55, 23,  6,  4, 35, 32,  0, 17, 52,
 18, 55, 54, 36, 51, 32,  0, 17, 16,  0,  5,  3, 34,  6, 21, 20,
 22, 51, 50, 54, 53, 52, 38,  4,229, 69,161, 87,147,193,  1, 41,
199, 92,145, 39, 27,143,143,177,228,254,182,254,250,178,254,180,
127,145,162,  1, 93,  1, 14,129,250,137, 82,135,254,199,165,254,
190,254, 85,209,188,139,  1,104,189,  1, 65,  1,165,254,105,254,
196,129,141,197,114,101,142,192,115,238, 74, 76,198,152,220,  1,
 73, 80, 71,131,253, 30, 28,  1, 48,209,233,  1, 39,125,114,134,
254,160,184,254,251,254,171, 87, 93,114,102,105,  1,172,  1, 71,
225,  1,165,153,114,126,254,134,254,228,254,217,254,119,  6,  2,
250,223,156,112,126,228,166,102,121,  0,  0,  2,255,147,  0,  0,
  4,236,  5,213,  0,  7,  0, 10,  0,163, 64, 64,  8,  5,  9,  8,
  1,  2,  1, 10,  5,  2,  1,  4,  5,  2,  1,  3,  5,  2,  2,  1,
  9,  5,  7,  0,  7,  8,  5, 10,  8,  0,  0,  7,  6,  5,  0,  7,
  5,  5,  7,  0,  7, 58,  8,  0,  4, 90,  9,  0, 70,  6,  2, 10,
  9,  8,  6,  5,  4,  3,  1,  8, 11,  2,  7, 11, 16,212,204, 17,
 23, 57, 49,  0, 47, 60,228,212,236, 18, 57, 48, 75, 83, 88,  7,
 16,  5,237,  7,  5,237,  7, 16,  8,237,  7, 16,  5,237,  7, 16,
  5,237,  7,  5,237,  7,  5,237,  7, 16,  8,237, 89, 34,178,  7,
  8,  1,  1, 93, 64, 36,  8,  8,137,  8,  2,  8,  0,  8,  8,  8,
 10, 26,  0, 23,  6, 42,  0, 72,  0, 73,  1, 72,  4, 71,  6, 87,
  5,104,  0,103,  5,119,  5,136,  8, 15, 93,  0, 93,  1, 51,  1,
 35,  3, 33,  3, 35,  9,  1, 33,  2,242,229,  1, 21,211, 62,253,
 96,211,213,  3,168,254, 93,  2, 36,  5,213,250, 43,  1,127,254,
129,  5, 14,253, 25,  0,  0,  3,  0, 55,  0,  0,  5,  0,  5,213,
  0, 14,  0, 23,  0, 32,  0,108, 64, 60, 25,  5,  0, 14, 24,  5,
  0,  0, 14, 16,  5, 14,  0, 14, 15,  5,  0,  0, 14, 58,  7, 15,
 90, 25, 24, 90,  0, 70, 16, 90, 25,115, 13, 25, 24, 23, 17, 15,
  5, 20, 16, 14,  1,  7, 13, 26, 32,  5,  0, 20, 28, 10, 29, 28,
  4,  0,  2, 14, 27, 33, 16,244,228,212,236,212,236, 17, 23, 57,
 18, 57, 18, 23, 57, 49,  0, 47,236,236,244,236, 16,238, 57, 48,
 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237,  7, 16,  5,237,  7,
  5,237, 89, 34,  1, 33, 50, 22, 21, 20,  6,  7, 22, 22, 21, 20,
  0, 33, 33,  1,  3, 33, 50, 54, 53, 52, 38, 35,  3,  3, 33, 50,
 54, 53, 52, 38, 35,  1, 90,  2,  4,210,208,179,145,124,124,254,
179,254,223,253,241,  1, 84,106,  1, 69,183,198,131,145,205, 88,
  1, 45,161,181,122,134,  5,213,156,157,144,209, 22, 28,158,132,
225,254,250,  2,201,253,221,168,153,118,108,  2,102,254, 62,140,
124, 97, 89,  0,  0,  1,  0, 86,255,227,  5,143,  5,240,  0, 31,
  0, 83, 64, 26, 16, 17, 13, 90, 20,  1,101,  0,116,  4, 90, 29,
 86, 20, 81, 32, 16,  1, 17,  0, 10, 28,  0, 23, 13, 32, 16,244,
196,236, 17, 57, 57, 57, 49,  0, 16,228,244,236,244,236, 16,238,
214,198, 48,  1, 75,176, 13, 84, 75,176, 15, 84, 91, 88,189,  0,
 32,255,192,  0,  1,  0, 32,  0, 32,  0, 64, 56, 17, 55, 56, 89,
178,111, 33,  1, 93,  1,  7, 46,  1, 35, 34,  4,  7, 14,  1, 21,
 20, 22, 51, 50, 36, 55,  7, 14,  1, 35, 32,  0, 17, 52, 18, 55,
 54, 36, 51, 50, 22,  5,143, 41, 96,215,125,171,254,253, 94, 60,
 63,211,201,139,  1,  0,121, 47,119,243,122,254,225,254,189,123,
115,122,  1, 57,208,128,229,  5, 98,213, 97, 94,164,168,108,241,
122,204,214, 89, 89,239, 51, 52,  1, 56,  1, 22,178,  1, 88,142,
151,144, 71,  0,  0,  2,  0, 55,  0,  0,  5,199,  5,213,  0, 11,
  0, 20,  0, 69, 64, 35, 13,  5, 11,  0, 11, 12,  5,  0, 11, 58,
 12, 90,  0, 70, 13, 90, 10, 20, 14, 12,  3, 17, 13, 11,  1, 10,
  0, 17, 28,  4,  0,  2, 11, 27, 21, 16,244,228,212,236, 17, 57,
 57, 18, 57, 18, 23, 57, 49,  0, 47,236,244,236, 48, 75, 83, 88,
  7,  5,237,  7, 16,  5,237, 89, 34,  1, 33, 32,  0, 17, 20,  2,
  7,  6,  4, 35, 33,  1,  3, 33, 32,  0, 17, 52, 38, 33,  1, 90,
  1,178,  1, 90,  1, 97,134,118,119,254,146,250,254, 75,  1,205,
225,  1,  8,  1, 83,  1,116,240,255,  0,  5,213,254,219,254,223,
191,254,159,121,124,122,  5, 47,251,119,  1,134,  1, 99,215,201,
  0,  1,  0, 55,  0,  0,  5, 10,  5,213,  0, 11,  0, 89, 64, 49,
  8,  5, 11,  0, 11,  7,  5,  0, 11,  4,  5,  0, 11,  3,  5,  0,
  0, 11, 58,  6, 90,  4,  2, 90,  0, 70,  8, 90,  4,115, 10,  8,
 11, 10,  9,  7,  6,  5,  4,  3,  2,  8,  0,  1,  0,  2, 11, 27,
 12, 16,244,228,204, 17, 23, 57, 18, 57, 49,  0, 47,236,236,244,
236, 16,238, 48, 75, 83, 88,  7, 16,  5,237,  7,  5,237,  7,  5,
237,  7, 16,  5,237, 89, 34,  1, 33,  7, 33,  3, 33,  7, 33,  3,
 33,  7, 33,  1, 90,  3,176, 33,253, 25, 86,  2,201, 33,253, 55,
104,  2,248, 33,252, 61,  5,213,170,254, 70,170,253,227,170,  0,
  0,  1,  0, 55,  0,  0,  4,178,  5,213,  0,  9,  0, 84, 64, 45,
  8,  5,  9,  0,  9,  7,  5,  0,  9,  4,  5,  0,  9,  3,  5,  0,
  0,  9, 58,  6, 90,  4,  2, 90,  0, 70,  4,115,  8,  8,  9,  7,
  6,  5,  4,  3,  2,  6,  0,  1,  0,  2,  9, 27, 10, 16,244,228,
204, 17, 23, 57, 18, 57, 49,  0, 47,236,244,236, 16,238, 48, 75,
 83, 88,  7, 16,  5,237,  7,  5,237,  7,  5,237,  7, 16,  5,237,
 89, 34,  1, 33,  7, 33,  3, 33,  7, 33,  3, 35,  1, 90,  3, 88,
 33,253,113, 86,  2, 80, 33,253,176,139,201,  5,213,170,254, 72,
170,253, 55,  0,  0,  1,  0, 92,255,227,  5,205,  5,240,  0, 35,
  0,128, 64, 53,  1,  5,  4,  5,  4, 34, 35,  2, 33,  0,  5,  5,
  5,  4, 58,  0,  1,  5, 33,  8,  1, 90,  3,117, 33, 90,  8, 21,
101, 20,116, 24, 90, 17, 86,  8, 81, 36,  3,  2,  1,  0,  4,  5,
 30, 21,  4, 20, 30, 28, 11, 13, 36, 16,244,236,212,196, 57, 17,
 57, 23, 57, 49,  0, 16,228,244,236,244,236, 16,254,252,238, 17,
 18, 57, 17, 57, 48, 75, 83, 88,  7, 16,  5,237, 17, 23, 57,  7,
 16,  5,237, 89, 34,  1, 75,176, 13, 84, 75,176, 15, 84, 91, 88,
189,  0, 36,255,192,  0,  1,  0, 36,  0, 36,  0, 64, 56, 17, 55,
 56, 89, 37, 19, 33, 55, 33,  3,  6,  4, 35, 32,  0, 17, 52, 18,
 55, 62,  1, 51, 50,  4, 23,  7, 46,  1, 35, 34,  6,  7,  6,  2,
 21, 20, 22, 51, 50, 54,  4, 94, 78,254,180, 31,  2, 18,129,133,
254,198,159,254,231,254,195,193,170,107,254,155,140,  1,  1,117,
 41, 90,242,137,159,242, 95, 81, 93,214,212,106,198,223,  1,135,
166,253,111, 73, 79,  1, 56,  1, 22,231,  1,161,139, 87, 85, 71,
 71,215, 94, 99,121,127,108,254,219,152,209,211, 45,  0,  0,  1,
  0, 55,  0,  0,  5,205,  5,213,  0, 11,  0,125, 64, 68,  8,  5,
  6,  5,  7,  5,  6,  6,  5,  4,  5,  6,  5,  3,  5,  5,  6,  5,
 10,  5, 11,  0, 11,  9,  5,  0, 11,  2,  5,  0, 11,  1,  5,  0,
  0, 11, 58,  8, 90,  2,115,  4,  0, 70, 10,  6,  4,  6,  5, 10,
 11,  9,  8,  7,  3,  2,  1,  6,  0,  6,  2,  5, 29,  0,  2, 11,
 27, 12, 16,244,228,244,228, 17, 23, 57, 18, 57, 17, 18, 57, 49,
  0, 47, 60,228, 50,252,236, 48, 75, 83, 88,  7, 16,  5,237,  7,
  5,237,  7,  5,237,  7, 16,  5,237,  7, 16,  5,237,  7,  5,237,
  7, 16,  5,237,  7,  5,237, 89, 34,  1, 51,  3, 33, 19, 51,  1,
 35, 19, 33,  3, 35,  1, 90,203,119,  2,221,119,203,254,221,203,
139,253, 35,139,203,  5,213,253,156,  2,100,250, 43,  2,199,253,
 57,  0,  0,  1,  0, 55,  0,  0,  2, 37,  5,213,  0,  3,  0, 50,
 64, 23,  2,  5,  3,  0,  3,  1,  5,  0,  0,  3, 58,  0, 70,  2,
  2,  3,  1,  0,  0,  2,  3, 27,  4, 16,244,228, 16,192, 18, 57,
 49,  0, 47,228, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237,
 89, 34,  1, 51,  1, 35,  1, 90,203,254,221,203,  5,213,250, 43,
  0,  1,254,176,254,102,  2, 33,  5,213,  0, 11,  0, 75, 64, 38,
  0,  5,  1,  2,  1,  8,  9, 10,  3,  7, 11,  5,  2,  2,  1, 58,
 11,  2,  0,  7, 90,  5,118,  0, 70, 12,  7,  6,  0, 12,  2,  5,
 11,  8,  4,  1,  6, 12, 16,212,204, 23, 57, 17, 57, 18, 57, 49,
  0, 16,228,252,236, 17, 57, 57, 48, 75, 83, 88,  7, 16,  5,237,
 17, 23, 57,  7, 16,  5,237, 89, 34,  1, 51,  1,  2,  6, 35, 35,
 55, 51, 50, 54, 55,  1, 86,203,254,241, 53,251,226, 80, 33, 63,
135,140, 37,  5,213,250,147,254,241,243,170,154,190,  0,  0,  1,
  0, 55,  0,  0,  5,199,  5,213,  0, 10,  0,243, 64, 71,  6,  4,
  7,  8,  7,  5,  4,  4,  5,  8,  8,  7,  3,  3,  4,  5,  4,  2,
  3,  1,  2,  5,  5,  4,  9,  5, 10,  0, 10,  8,  5,  7,  8,  0,
 10,  2,  5,  3,  2,  0, 10,  1,  5,  0,  0, 10, 58,  8,  5,  2,
  3,  3,  0, 70,  9,  6,  9, 10,  8,  6,  5,  2,  1,  5,  0,  4,
  0,  2, 10, 27, 11, 16,244,228,204, 17, 23, 57, 18, 57, 49,  0,
 47, 60,228, 50, 23, 57, 48, 75, 83, 88,  7, 16,  5,237,  7,  8,
237,  7,  8,237,  7, 16,  5,237,  7, 16,  8,237,  7, 16,  5,237,
  7, 16,  8,237,  7, 16,  5,237, 89, 34,178,  8,  3,  1,  1, 93,
 64,106,  5,  2,  7,  5, 22,  2, 36,  2, 37,  5, 35,  8, 54,  2,
 55,  5, 53,  8, 72,  5, 88,  5,107,  2,105,  5,120,  5,120,  8,
154,  2, 16, 10,  3,  9,  4,  7,  6, 23,  2, 24,  3, 24,  6, 24,
  7, 38,  5, 38,  6, 37,  7, 39,  8, 55,  2, 56,  3, 55,  5, 61,
  6, 60,  7, 73,  3, 71,  4, 70,  5, 89,  3, 88,  5, 92,  6, 91,
  7,104,  2,102,  5, 98,  6, 98,  7,122,  3,120,  4,120,  5,126,
  6,126,  7,133,  3,135,  4,137,  5,148,  3, 36, 93,  0, 93,  1,
 51,  3,  1, 33,  9,  1, 35,  1,  3, 35,  1, 90,203,123,  3, 16,
  1, 13,252,137,  2,137,246,253,172,141,203,  5,213,253,139,  2,
117,253, 55,252,244,  2,215,253, 41,  0,  0,  1,  0, 55,  0,  0,
  3,250,  5,213,  0,  5,  0, 57, 64, 27,  2,  5,  5,  0,  5,  1,
  5,  0,  0,  5, 58,  2, 90,  0, 70,  4,  2,  5,  4,  1,  0,  3,
  0,  2,  5, 27,  6, 16,244,228,204, 17, 57, 57, 18, 57, 49,  0,
 47,228,236, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237, 89,
 34,  1, 51,  1, 33,  7, 33,  1, 88,203,255,  0,  2,215, 33,252,
 94,  5,213,250,211,168,  0,  1,  0, 55,  0,  0,  6,176,  5,213,
  0, 12,  1, 29, 64, 81,  2,  3,  3,  2,  9, 10,  9,  1,  3, 10,
 10,  9,  3,  3,  7,  8,  7,  2,  3,  1,  2,  8,  8,  7,  7,  5,
  4,  5,  4,  6,  5,  5,  5,  4, 11,  5, 12,  0, 12, 10,  5,  9,
 10,  0,  0, 12, 58, 10,  7,  2,  3,  8,  3,  0, 70,  8, 11,  5,
  7,  5,  4, 11, 12, 10,  9,  8,  6,  3,  2,  1,  7,  0,  5,  2,
  4, 30,  0,  2, 12, 27, 13, 16,244,228,244,228, 17, 23, 57, 18,
 57, 17, 18, 57, 49,  0, 47, 60,196,228, 50, 17, 23, 57, 48, 75,
 83, 88,  7, 16,  8,237,  7, 16,  5,237,  7, 16,  5,237,  7, 16,
  5,237,  7, 16,  8,237,  7, 16,  5,237,  7, 16,  5,237,  7, 16,
  8,237, 89, 34,178,  7,  8,  1,  1, 93, 64,130,  2,  7, 15,  8,
 15,  9, 23,  2, 20,  7, 31,  8, 31,  9, 41,  7, 55,  2, 48, 10,
 74,  2, 67, 10,120,  7,139,  2,135,  7,135, 10,152,  2,159,  2,
148,  7,149, 10,173,  2,175,  2, 22,  5,  1,  7,  2, 14,  3, 21,
  1, 23,  2, 30,  3, 16, 14, 38,  1, 41,  3, 40,  7, 39,  8, 41,
  9, 50,  1, 53,  2, 52,  8, 55,  9, 53, 10, 68,  1, 71,  2, 74,
  3, 67,  8, 73,  9, 70, 10, 88,  0, 89,  3, 87,  4,104,  3,102,
  8,119,  8,139,  1,135,  2,135,  3,136,  7,135,  9,135, 10,150,
  1,153,  2,148,  3,153,  7,166,  1,170,  2,163,  3, 42, 93,  0,
 93,  1, 33, 19,  1, 33,  1, 35, 19,  1, 35, 11,  1, 35,  1, 90,
  1, 47,174,  2, 66,  1, 55,254,221,196,254,253,182,197,190,254,
197,  5,213,252, 18,  3,238,250, 43,  5, 29,252,  2,  4,  2,250,
223,  0,  0,  1,  0, 55,  0,  0,  5,197,  5,213,  0,  9,  0,211,
 64, 64,  2,  3,  3,  2,  6,  7,  6,  1,  3,  7,  7,  6,  3,  5,
  4,  5,  4,  2,  5,  1,  2,  5,  5,  4,  8,  5,  9,  0,  9,  7,
  5,  6,  7,  0,  0,  9, 58,  7,  2,  3,  0, 70,  8,  5,  2,  6,
  3,  5,  4,  8,  9,  7,  1,  0,  6,  5,  2,  4, 29,  0,  2,  9,
 27, 10, 16,244,228,244,244,196, 17, 57, 57, 18, 57, 17, 18, 57,
 17, 57, 49,  0, 47, 60,228, 50, 57, 57, 48, 75, 83, 88,  7, 16,
  8,237,  7, 16,  5,237,  7, 16,  8,237,  7, 16,  5,237,  7, 16,
  5,237,  7, 16,  8,237, 89, 34,178,  7,  1,  1,  1, 93, 64, 80,
 18,  7, 39,  7, 32,  7, 63,  2, 54,  7, 72,  2, 91,  2,106,  2,
138,  2,132,  7, 10,  6,  1, 20,  1, 16,  2, 16,  3, 16,  4, 16,
  5, 17,  6, 22,  7, 34,  1, 41,  6, 38,  7, 53,  1, 58,  2, 61,
  6, 55,  7, 73,  6, 87,  1, 89,  6, 95, 11,104,  2,107,  6,119,
  1,138,  1,136,  2,134,  6,135,  7,173,  1,169,  6,175, 11, 29,
 93,  0, 93,  1, 33,  1, 19, 51,  1, 33,  1,  3, 35,  1, 90,  1,
 16,  1,156,250,197,254,221,254,239,254,101,250,197,  5,213,251,
  0,  5,  0,250, 43,  5,  8,250,248,  0,  0,  2,  0, 82,255,227,
  5,250,  5,240,  0, 17,  0, 35,  0, 80, 64, 19,  9, 90, 18,  0,
 90, 27, 86, 18, 81, 36, 15, 28, 30, 32,  6, 28, 21, 13, 36, 16,
244,236,244,236, 49,  0, 16,228,244,236, 16,238, 48,178, 48, 37,
  1,  1, 93,  1, 75,176, 14, 84, 75,176, 13, 84, 91, 75,176, 15,
 84, 91, 75,176, 16, 84, 91, 88,189,  0, 36,255,192,  0,  1,  0,
 36,  0, 36,  0, 64, 56, 17, 55, 56, 89,  1, 34,  6,  7, 14,  1,
 21, 20, 22, 51, 50, 36, 55, 62,  1, 53, 52, 38,  1, 32,  0, 17,
 52, 18, 55, 54, 36, 51, 32,  0, 17, 20,  2,  7,  6,  4,  3,166,
166,254, 94, 60, 63,199,182,164,  1,  1, 91, 61, 64,200,254, 69,
254,237,254,197,123,108,127,  1, 56,188,  1, 18,  1, 60,120,112,
128,254,203,  5, 76,161,165,105,236,120,208,226,163,161,108,237,
118,207,227,250,151,  1, 70,  1, 27,162,  1, 82,132,155,153,254,
189,254,233,172,254,180,135,156,152,  0,  0,  2,  0, 55,  0,  0,
  4,207,  5,213,  0, 10,  0, 19,  0, 95, 64, 47, 12,  5,  0, 10,
 11,  5,  0,  0, 10,  9,  5,  0, 10,  8,  5, 10,  0, 10, 58, 12,
 90,  7, 11, 90,  0, 70,  9, 19, 13, 12, 11,  8,  5, 16,  9, 10,
  1,  7,  0, 16, 28,  4,  0,  2, 10, 27, 20, 16,244,228,212,236,
 17, 57, 57, 18, 57, 18, 23, 57, 49,  0, 47,244,236,212,236, 48,
 75, 83, 88,  7, 16,  5,237,  7,  5,237,  7, 16,  5,237,  7,  5,
237, 89, 34,178,175, 21,  1,  1, 93,  1, 33, 50, 22, 21, 20,  0,
 33, 35,  3, 35,  1,  3, 51, 50, 54, 53, 52, 38, 35,  1, 90,  1,
211,204,214,254,196,254,226,254,117,203,  1,205,108,254,172,184,
125,113,  5,213,190,183,246,254,238,253,168,  5, 47,253,207,176,
164,105,116,  0,  0,  2,  0, 84,254,248,  5,250,  5,240,  0, 20,
  0, 38,  0,138, 64, 44, 19, 33, 20,  0, 20, 16, 17,  2, 15, 18,
 33,  0,  0, 20, 58,  0, 39, 18, 30, 90,  3, 21, 90, 12, 86, 19,
  3, 81, 39, 19, 21, 18,  0,  3, 27, 36, 28, 15, 32, 27, 28,  6,
 13, 39, 16,244,236,244,236, 17, 23, 57, 57, 49,  0, 16,228,196,
244,236, 16,238, 57, 18, 57, 48, 75, 83, 88,  7, 16, 14,237, 17,
 23, 57,  7, 16,  5,237, 89, 34,178, 48, 40,  1,  1, 93,  1, 75,
176, 13, 84, 75,176, 14, 84, 91, 75,176, 15, 84, 91, 75,176, 16,
 84, 91, 88,189,  0, 39,255,192,  0,  1,  0, 39,  0, 39,  0, 64,
 56, 17, 55, 56, 89,182, 86, 18,122,  0,122, 19,  3, 93,  5, 14,
  1, 35, 32,  0, 17, 52, 18, 55, 54, 36, 51, 32,  0, 17, 16,  0,
  5, 19, 35, 19, 34,  6,  7, 14,  1, 21, 20, 22, 51, 50, 36, 55,
 62,  1, 53, 52, 38,  2,227, 11, 24, 24,254,232,254,196,121,108,
125,  1, 57,189,  1, 18,  1, 60,254,182,254,246,203,226, 23,166,
254, 94, 60, 63,199,182,164,  1,  1, 91, 61, 64,200, 27,  1,  1,
  1, 65,  1, 27,167,  1, 80,134,154,154,254,189,254,233,254,211,
254, 12,103,254,234,  6, 84,161,165,105,236,120,208,226,163,161,
108,237,118,207,227,  0,  0,  2,  0, 55,  0,  0,  4,205,  5,213,
  0,  8,  0, 28,  0,142, 64, 60,  1,  5, 22, 21,  0,  5, 22, 22,
 21, 20,  5, 22, 21, 19,  5, 21, 22, 21, 58, 15, 12, 13,  9,  1,
 90, 18,  0, 90, 22, 70, 20, 13, 20, 22, 21, 13, 26, 19, 18, 15,
 14,  8,  2,  1,  0,  8, 22, 12, 26, 23,  9, 22,  5, 28, 26, 22,
  2, 21, 27, 29, 16,244,228,212,236, 17, 57, 57, 17, 57, 17, 23,
 57, 17, 57, 17, 18, 57, 49,  0, 47, 60,244,236,212,236, 57, 18,
 57, 57, 48, 75, 83, 88,  7, 16,  5,237,  7,  5,237,  7, 16,  5,
237,  7,  5,237, 89, 34,178, 88, 15,  1,  1, 93, 64, 21, 88, 15,
 89, 16, 89, 17, 89, 18,107, 15,107, 16,107, 17,123, 15,123, 16,
123, 17, 10, 93,  1,  3, 33, 50, 54, 53, 52, 38, 35, 19, 30,  1,
 23, 19, 35,  3, 46,  1, 43,  1,  3, 35,  1, 33, 50, 22, 21, 20,
  6,  2,  4,102,  1,  4,153,189,127,119,117, 64, 85, 56,127,213,
117, 45,118,122,223,123,203,  1, 35,  1,199,207,221,188,  5, 47,
253,238,169,136,109,116,253,158, 15,118,176,254,104,  1,127,148,
100,253,137,  5,213,187,176,156,228,  0,  0,  1,  0, 12,255,227,
  4,211,  5,240,  0, 39,  0,148, 64, 55, 12,  1, 13, 11,  5, 30,
 31, 30,  9,  1,  8, 10,  5, 31, 31, 30, 58, 10, 11, 30, 31,  4,
  1, 21,101, 20, 89, 24, 90, 17,  1,  0, 89,  4, 90, 37, 86, 17,
 81, 40, 30, 10, 31, 11, 27,  7,  1,  0, 27, 28, 14,  7, 28, 34,
 40, 16,212,236,212,236,192,192, 17, 18, 57, 57, 57, 57, 49,  0,
 16,228,244,236,244,196, 16,238,246,238, 17, 23, 57, 48, 75, 83,
 88,  7, 16, 14,237, 17, 23, 57,  7, 16, 14,237, 17, 23, 57, 89,
 34,178, 27,  9,  1,  0, 93, 64, 32, 11,  0,  6, 12, 26,  1, 19,
 20, 41,  0, 41,  1, 57,  0, 57,  1, 51, 19, 51, 20, 51, 21, 51,
 22, 12, 20,  9,137, 21,137, 22,  3, 93,  1, 93,  1,  7, 46,  1,
 35, 34,  6, 21, 20, 22, 31,  1, 30,  1, 21, 20,  0, 33, 34, 38,
 39, 55, 30,  1, 51, 50, 54, 53, 52, 38, 47,  1, 46,  1, 53, 52,
  0, 33, 50, 22,  4,211, 39,101,199, 93,181,214, 79,164,121,205,
160,254,157,254,222,119,240,121, 41,111,223,111,189,228, 91,150,
121,207,151,  1, 87,  1, 19,107,210,  5,164,197, 54, 55,158,131,
 72, 77, 44, 30, 53,163,147,226,254,228, 47, 48,208, 69, 70,168,
135, 90, 93, 38, 31, 54,141,127,223,  1, 29, 38,  0,  1,  0, 88,
  0,  0,  5,104,  5,213,  0,  7,  0,115, 64, 33,  4,  5,  5,  6,
  5,  1,  2,  2,  3,  5,  6,  6,  5, 58,  6,  2, 90,  0, 70,  4,
  0,  7,  4,  5,  3,  2,  6,  1,  7,  6,  2,  5,  8, 16,212,228,
212,196, 17, 57, 57, 18, 57, 17, 57, 49,  0, 47,244,236, 50, 48,
 75, 83, 88,  7, 16,  5,237, 23, 50,  7, 16,  5,237, 89, 34,178,
  7,  2,  1,  1, 93, 64, 37,  6,  1,  7,  2,  7,  3,  7,  4, 23,
  3, 23,  4, 37,  1, 37,  2, 62,  0, 62,  7, 79,  0, 79,  7, 93,
  1, 93,  2, 96,  1, 96,  2,175,  0,175,  7, 18, 93, 19, 33,  7,
 33,  1, 35,  1, 33,121,  4,239, 32,253,235,255,  0,203,  1,  0,
253,240,  5,213,170,250,213,  5, 43,  0,  0,  1,  0,119,255,227,
  5,180,  5,213,  0, 23,  0,179, 64, 60, 12,  5, 13, 14, 13,  9,
 10,  2, 11,  5, 14, 14, 13,  7,  6,  5,  4,  3,  5,  8,  2,  5,
 23,  0, 23,  1,  5,  0,  0, 23, 58, 11,  2, 23, 14,  0,  8, 90,
 17, 81, 12,  0, 70, 24, 23,  0, 20, 12, 11,  2,  1,  4, 13, 14,
 13,  5,  5, 28, 20, 24, 16,212,236, 16,192,192, 18, 23, 57, 18,
 57, 57, 49,  0, 16,228, 50,244,236, 17, 57, 57, 57, 57, 48, 75,
 83, 88,  7, 16,  5,237,  7, 16,  5,237, 17, 23, 57,  7, 16,  5,
237, 23, 57,  7, 16,  5,237, 89, 34,  1, 64, 33, 21,  9, 21, 10,
 21, 11, 21, 12, 21, 13, 21, 14, 21, 15, 21, 16, 52,  9, 52, 10,
 52, 11, 52, 12, 52, 13, 52, 14, 52, 15, 52, 16, 16, 93,  1, 75,
176,  9, 84, 88,189,  0, 24,  0, 64,  0,  1,  0, 24,  0, 24,255,
192, 56, 17, 55, 56, 89,178,  0, 25,  1, 93,  1, 51,  3, 14,  1,
 21, 20, 22, 51, 50, 54, 55, 19, 51,  3,  2,  0, 33, 34, 36, 53,
 52, 54, 55,  1, 61,203,176, 11,  9,154,149,193,215, 46,176,203,
180, 59,254,182,254,225,224,254,251, 10, 10,  5,213,252,117, 61,
 79, 30,138,143,212,239,  3,139,252, 92,254,210,254,224,225,193,
 35, 87, 50,  0,  0,  1,  0,160,  0,  0,  5,240,  5,213,  0,  6,
  0,132, 64, 38,  4,  5,  5,  6,  5,  3,  5,  2,  3,  6,  6,  5,
  3,  5,  4,  3,  0,  1,  0,  2,  5,  1,  1,  0, 58,  3,  4,  1,
 70,  0,  4,  3,  2,  0,  4,  5,  1,  7, 16,212,204, 23, 57, 49,
  0, 47,228, 50, 57, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  8,
237,  7, 16,  8,237,  7, 16,  5,237, 89, 34,178,  7,  3,  1,  0,
 93, 64, 48, 25,  6, 42,  0, 40,  4, 56,  4, 71,  3, 71,  6, 88,
  4, 87,  6,103,  3,105,  4,101,  6,121,  4,121,  5,119,  6,136,
  4,170,  0,169,  2,168,  3, 18,  6,  3, 20,  3,104,  3,134,  3,
169,  3,  5, 93,  1, 93, 33,  1, 51, 19,  1, 51,  1,  1,166,254,
250,198,217,  2,213,220,252,161,  5,213,250,252,  5,  4,250, 43,
  0,  1,  0,197,  0,  0,  8, 41,  5,213,  0, 12,  1, 11, 64, 73,
  5,  3,  6,  5,  9, 10,  9,  4,  3, 10,  9,  3,  3, 10, 11, 10,
  2,  3,  1,  2, 11, 11, 10,  6,  5,  7,  8,  7,  5,  5,  4,  5,
  8,  8,  7,  2,  5,  3,  2, 12,  0, 12,  1,  5,  0,  0, 12, 58,
 10,  5,  2,  3,  6,  3,  0, 70, 11,  8, 12, 11, 10,  9,  8,  6,
  5,  4,  3,  2,  1, 11,  7,  0, 13, 16,212,204, 23, 57, 49,  0,
 47, 60,228, 50, 50, 23, 57, 48, 75, 83, 88,  7, 16,  5,237,  7,
 16,  8,237,  7, 16,  8,237,  7, 16,  5,237,  7, 16,  8,237,  7,
 16,  5,237,  7,  5,237,  7, 16,  8,237, 89, 34,178,  7, 11,  1,
  1, 93, 64,130,  9, 10, 40,  2, 41,  5, 38, 10, 59,  2, 59,  5,
 51, 10, 75,  5, 70, 10,138,  2,129, 10,128, 10,159,  2,153,  5,
159,  5, 15,  6,  2,  7,  3,  7, 10,  7, 11, 24,  2, 23,  8, 25,
 12, 39,  1, 41,  2, 36,  4, 41,  5, 43,  6, 42,  7, 40,  8, 45,
  9, 38, 10, 42, 12, 54,  4, 55,  5, 53,  8, 54, 10, 54, 11, 56,
 12, 75,  3, 71,  5, 67,  8, 72, 10, 71, 11, 86,  8, 86, 11,103,
  2,105,  3,104,  6,103, 11,103, 12,121,  3,120,  6,132,  2,135,
  3,136,  4,134,  8,133,  9,132, 10,151,  2,153,  3,155,  5,170,
  3,168,  5,167,  8, 49, 93,  0, 93, 19, 51, 19,  1, 51, 19,  1,
 51,  1, 35,  3,  1, 35,197,196, 72,  2, 51,225, 74,  2, 45,205,
253,104,254, 69,253,209,254,  5,213,251, 10,  4,246,251, 10,  4,
246,250, 43,  4,221,251, 35,  0,  0,  1,255,168,  0,  0,  5,160,
  5,213,  0, 11,  1, 77, 64, 73,  6,  5,  7,  8,  7,  5,  5,  4,
  5,  8,  8,  7,  3,  5,  4,  5,  4,  2,  5,  1,  2,  5,  5,  4,
  2,  5,  3,  2, 11,  0, 11,  1,  5,  0,  0, 11,  9,  5, 10, 11,
 10,  8,  5,  7,  8, 11, 11, 10, 58, 11,  8,  5,  2,  4,  3,  0,
 70,  9,  6, 11,  8,  7,  6,  5,  2,  1,  0,  8, 12,  4, 10, 10,
 12, 16,196, 16,192, 17, 23, 57, 49,  0, 47, 60,228, 50, 23, 57,
 48, 75, 83, 88,  7, 16,  8,237,  7, 16,  5,237,  7, 16,  5,237,
  7, 16,  8,237,  7, 16,  8,237,  7, 16,  5,237,  7, 16,  8,237,
  7, 16,  5,237, 89, 34,178,  7,  1,  1,  1, 93, 64,194,  4,  2,
  9,  8, 25,  8, 41,  5, 43,  8, 41, 11, 58,  2, 56,  8, 59, 11,
 73,  5, 74,  8, 73, 11, 89,  5, 90,  8,104,  2,104,  5,104, 11,
121,  5,128,  2,140,  8,150,  2,151,  5,168,  5, 23,  5,  0,  6,
  1,  8,  7,  6,  9, 21,  9, 21, 10, 39,  0, 39,  1, 40,  2, 41,
  3, 40,  5, 41,  6, 41,  7, 38,  9, 40, 11, 56,  2, 58,  3, 58,
  4, 54,  5, 54,  8, 53,  9, 53, 10, 56, 11, 70,  0, 70,  1, 71,
  2, 71,  5, 68,  9, 70, 10, 72, 11, 89,  6, 89,  7, 88,  8, 84,
  9, 84, 10, 88, 11,102,  0,102,  1,101,  2,104,  3,102,  5,103,
  6,103,  7,102,  8,101,  9,101, 10,102, 11,122,  3,122,  4,122,
  6,121,  7,117,  9,117, 10,135,  0,134,  1,139,  3,143,  3,143,
  4,137,  7,135,  8,130,  9,149,  0,151,  1,151,  5,153,  6,152,
  8,159,  9,159, 10,164,  0,168,  5,171,  6,175,  9,175, 10, 73,
 93,  0, 93,  1, 51,  9,  1, 51,  9,  1, 35,  9,  1, 35,  1,  1,
 25,204,  1,  0,  1,207,236,253,153,  1,115,203,254,211,253,223,
235,  2,186,  5,213,253,229,  2, 27,253, 55,252,244,  2,117,253,
139,  3, 35,  0,  0,  1,  0,129,  0,  0,  5,104,  5,213,  0,  8,
  0,175, 64, 55,  3,  5,  4,  5,  4,  2,  5,  1,  2,  5,  5,  4,
  2,  5,  3,  2,  8,  0,  8,  1,  5,  0,  0,  8,  6,  5,  7,  8,
  7,  5,  5,  4,  5,  8,  8,  7, 58,  2,  3,  0, 70,  6,  6,  2,
  8,  4,  1,  7,  0,  4,  8,  8,  0,  7,  9, 16,212,196,196, 16,
192, 17, 18, 57, 17, 18, 57, 57, 49,  0, 47,228, 50, 57, 48, 75,
 83, 88,  7, 16,  8,237,  7, 16,  5,237,  7, 16,  5,237,  7, 16,
  8,237,  7, 16,  8,237,  7, 16,  5,237, 89, 34,178,  7,  2,  1,
  0, 93, 64, 58,  6,  3,  5,  4, 40,  2, 57,  3, 73,  0, 73,  1,
 90,  3, 89,  4,123,  3,121,  4,140,  3,153,  2,151,  4,151,  5,
168,  2,169,  8, 16,  7,  2, 23,  2, 36,  2, 53,  2, 86,  2,106,
  5,131,  2,147,  2,146,  5,167,  2,166,  5,168,  8, 12, 93,  1,
 93, 19, 51,  9,  1, 51,  1,  3, 35, 19,129,217,  1, 23,  2, 20,
227,253, 91,138,202,137,  5,213,253,154,  2,102,252,242,253, 57,
  2,199,  0,  1,255,211,  0,  0,  5,160,  5,213,  0,  9,  0, 80,
 64, 29,  8,  5,  2,  3,  2,  3,  5,  7,  8,  7, 58,  8, 90,  0,
 70,  3, 90,  5,  9,  8,  5,  4,  3,  0,  6, 10,  1,  6, 10, 16,
212,204, 17, 23, 57, 49,  0, 47,236,244,236, 48, 75, 83, 88,  7,
 16,  5,237,  7, 16,  5,237, 89, 34,178,120,  2,  1,  0, 93, 64,
 12,132,  3,137,  8,167,  0,168,  5,  4,119,  7,  1, 93,  1, 93,
  1, 33,  7,  1, 33,  7, 33, 55,  1, 33,  1, 12,  4,148, 29,251,
123,  3,184, 32,251, 61, 29,  4,133,252,119,  5,213,154,251,111,
170,154,  4,145,  0,  1,  0, 82,254,242,  3, 92,  6, 20,  0,  7,
  0, 81, 64, 33,  4,  3,  7,  0,  7,  3,  3,  0,  0,  7, 58,  4,
111,  6,  2,111,  0, 92,  8,  3,  5,  2,  4,  7,  0,  2,  1,  0,
  5,  6,  0,  7,  8, 16,212,196,212,196, 16,214,198, 17, 18, 57,
 17, 18, 57, 49,  0, 16,252,236,212,236, 48, 75, 83, 88,  7, 16,
  5,237,  7, 16,  5,237, 89, 34,178,136,  4,  1,  1, 93,178,140,
  4,  1, 93,  1, 33,  7, 35,  1, 51,  7, 33,  1,180,  1,168, 29,
239,254,213,239, 26,254, 88,  6, 20,143,249,252,143,  0,  0,  1,
  0,174,255, 66,  2, 25,  5,213,  0,  3,  0, 48, 64, 20,  1,  2,
  3,  2,  0,  3,  3,  2, 58,  1,  0, 70,  4,  0,  3,  1,  2,  2,
  3,  4, 16,212,196, 16,192, 18, 57, 49,  0, 16,244,204, 48, 75,
 83, 88,  7, 16,  5,201,  7, 16,  5,201, 89, 34,  1, 19, 35,  3,
  1, 88,193,168,195,  5,213,249,109,  6,147,  0,  0,  1,255,178,
254,242,  2,188,  6, 20,  0,  7,  0, 68, 64, 32,  5,  3,  0,  1,
  0,  4,  3,  1,  0, 58,  3,111,  1,  5,111,  0, 92,  8,  4,  8,
  6,  5,  1,  0,  7,  6,  0,  3,  2,  0,  1,  8, 16,212,196,212,
196, 16,214,198, 17, 18, 57, 17, 18, 57, 49,  0, 16,252,236,212,
236, 48, 75, 83, 88,  7,  5,237,  7, 16,  5,237, 89, 34,  1,  1,
 33, 55, 51,  1, 35, 55,  2,188,254,158,254, 88, 27,239,  1, 43,
237, 26,  6, 20,248,222,143,  6,  4,143,  0,  1,  0,217,  3,168,
  5,219,  5,213,  0,  6,  0, 24, 64, 10,  3,  4,  1,  0, 70,  7,
  3,  1,  5,  7, 16,220,204, 57, 49,  0, 16,244,204, 50, 57, 48,
  1,  1, 35,  1,  1, 35,  1,  3,188,  2, 31,201,254, 72,254, 72,
201,  2, 31,  5,213,253,211,  1,139,254,117,  2, 45,  0,  0,  1,
255,236,254, 29,  4, 20,254,172,  0,  3,  0, 17,182,  0,111,  1,
  4,  0,  2,  4, 16,212,204, 49,  0, 16,212,236, 48,  1, 21, 33,
 53,  4, 20,251,216,254,172,143,143,  0,  0,  1,  1,133,  4,240,
  3, 27,  6,102,  0,  3,  0,107,182,  1,  0,  4,  0,  1,  3,  4,
 16,212,204, 57, 49,  0, 16,212,204, 48,  0, 75,176,  9, 84, 75,
176, 14, 84, 91, 88,189,  0,  4,255,192,  0,  1,  0,  4,  0,  4,
  0, 64, 56, 17, 55, 56, 89,  1, 75,176,  9, 84, 75,176, 10, 84,
 91, 75,176, 14, 84, 91, 75,176, 15, 84, 91, 75,176, 16, 84, 91,
 88,189,  0,  4,  0, 64,  0,  1,  0,  4,  0,  4,255,192, 56, 17,
 55, 56, 89, 64, 13, 68,  0, 68,  1, 85,  0,103,  2,118,  2,134,
  2,  6, 93,  1, 19, 35,  3,  2, 74,209,154,252,  6,102,254,138,
  1,118,  0,  2,  0, 84,255,227,  4, 96,  4,123,  0, 32,  0, 43,
  1, 25, 64,100, 19, 18, 17, 16, 15,  5, 20, 14,  5,  1,  0, 11,
 12,  2, 10, 13,  5,  1,  0, 35, 34,  2, 36, 33,  5,  1,  0, 41,
 42,  2, 40, 43,  5,  0,  1,  0,  5,  4,  2,  6,  3,  5,  1,  0,
  2,  5,  1,  1,  0, 58, 43,  3, 40,  0, 33, 14, 23, 33,111, 12,
 40, 76,  6, 24, 75, 23,123, 20, 76, 27,122,  6, 81, 12,  1, 43,
 34, 33, 23, 14, 13,  2,  7, 37,  1,  0, 30,  3, 12, 24,  3, 37,
 17, 35, 30, 37, 14,  9, 34, 44, 16,244,236,212,236, 17, 23, 57,
 17, 57, 57, 17, 23, 57, 49,  0, 47,196,228,244,252,244,236, 16,
238, 16,238, 18, 57, 18, 57, 17, 57, 57, 48, 75, 83, 88,  7, 16,
  5,237,  7,  5,237, 17, 23, 57,  7, 16,  5,237, 17, 23, 57,  7,
  5,237, 17, 23, 57,  7,  5,237, 17, 23, 57,  7,  5,237, 17, 23,
 57, 89, 34,178, 48, 23,  1,  0, 93, 64, 46, 60, 24, 60, 25, 79,
 24, 91, 24, 91, 25,106, 24,106, 25,122, 24,122, 25,139, 24,137,
 25, 11, 50, 22, 67, 22, 64, 23, 84, 22, 80, 23,100, 22, 96, 23,
116, 22,112, 23,131, 22,128, 23, 11, 93,  1, 93,  1, 75,176, 18,
 84, 88,189,  0, 44,255,192,  0,  1,  0, 44,  0, 44,  0, 64, 56,
 17, 55, 56, 89, 64, 19,165, 10,160, 11,160, 12,160, 13,160, 33,
160, 34,160, 35,165, 36,160, 43,  9,  0, 93,  1,  3, 35, 55, 14,
  1, 35, 34, 38, 53, 52, 36, 41,  1, 55, 62,  1, 53, 52, 38, 35,
 34,  6,  7, 55, 62,  1, 51, 50, 22, 21, 20,  6,  7, 35, 34,  6,
 21, 20, 22, 51, 50, 54, 55,  4, 76,125,184, 34, 81,207,127,143,
183,  1, 57,  1, 19,  1,  0, 10,  2,  2,145,131, 90,189,100, 32,
104,199, 93,198,207, 10,209,184,226,217,111, 98,150,224, 36,  2,
127,253,129,170,100, 99,175,137,196,228, 49,  8, 19, 20, 89, 99,
 46, 46,170, 39, 39,172,164, 33, 89,126,121,127, 88,100,215,180,
  0,  2,  0, 74,255,227,  4,178,  6, 20,  0, 17,  0, 37,  0,178,
 64, 77, 11, 10,  2, 12,  9,  5, 36, 35,  4,  5,  6,  7,  4,  3,
  8,  5, 36, 35, 34,  5, 36, 35, 31, 32,  2, 30, 33,  5, 35, 36,
 35, 20, 19,  2, 21, 18,  5, 36, 35, 37,  5, 36, 36, 35, 58, 33,
 18, 12,  3, 76, 21, 12, 76, 30, 81, 21,122, 36, 92, 34, 34, 35,
 37,  0,  9, 33, 35, 18, 36,  0, 14, 24, 36, 37, 35, 36, 38, 16,
244,228,212,236, 17, 57, 18, 57, 57, 18, 57, 18, 57, 49,  0, 47,
236,228,244,236, 16,238, 17, 57, 57, 48, 75, 83, 88,  7, 16,  5,
237,  7,  5,237, 17, 23, 57,  7, 16,  5,237, 17, 23, 57,  7,  5,
237,  7,  5,237, 17, 23, 57,  7,  5,237, 17, 23, 57, 89, 34,178,
 96, 39,  1,  1, 93,  1, 75,176, 18, 84, 88,189,  0, 38,255,192,
  0,  1,  0, 38,  0, 38,  0, 64, 56, 17, 55, 56, 89,178,159, 39,
  1, 93,  1, 52, 38, 35, 34,  6,  7, 14,  1, 21, 20, 22, 51, 50,
 54, 55, 62,  1,  1, 62,  1, 51, 50, 22, 21, 20,  2,  7, 14,  1,
 35, 34, 38, 39,  7, 35,  1, 51,  3,246,133,117, 85,149, 55, 58,
 67,131,115, 87,148, 56, 57, 70,253,196, 68,205,112,172,203,119,
110, 72,188,103,109,160, 50, 33,184,  1, 47,184,  2,172,145,164,
 83, 79, 83,219,109,138,157, 81, 79, 82,218,  1,109, 92,105,232,
198,162,254,208,118, 78, 84,100, 99,170,  6, 20,  0,  1,  0, 94,
255,227,  4, 74,  4,123,  0, 31,  0, 75, 64, 28, 17, 75, 16, 78,
 13, 76, 20,  0, 75,  1, 78,  4, 76, 29,122, 20, 81, 32, 16,  1,
 17,  0, 10, 14,  0, 23, 34, 32, 16,244,196,236, 17, 57, 57, 57,
 49,  0, 16,228,244,252,244,236, 16,254,244,238, 48,  1, 75,176,
 18, 84, 88,189,  0, 32,255,192,  0,  1,  0, 32,  0, 32,  0, 64,
 56, 17, 55, 56, 89,  1,  7, 46,  1, 35, 34,  6,  7, 14,  1, 21,
 20, 22, 51, 50, 54, 55,  7, 14,  1, 35, 34, 38, 53, 52, 18, 55,
 62,  1, 51, 50, 22,  4, 74, 37, 66,149, 80, 88,159, 54, 86, 94,
151,154, 76,171, 93, 35, 80,169, 89,223,240,125,123, 84,226,134,
 78,154,  4, 53,182, 48, 48, 62, 57, 87,234,125,151,148, 46, 46,
182, 33, 33,223,207,174,  1, 37,117, 80, 82, 35,  0,  2,  0, 94,
255,227,  5, 29,  6, 20,  0, 19,  0, 37,  0,171, 64, 76, 31, 30,
  2, 32, 29,  5, 18, 17, 24, 25, 26, 27,  4, 23, 28,  5, 18, 17,
  2,  1,  2,  3,  0,  5, 18, 17, 19,  5, 18, 18, 17, 16,  5, 18,
 17, 13, 14,  2, 12, 15,  5, 17, 18, 17, 58, 15,  0, 23, 32, 76,
 12, 23, 76,  3, 81, 12,122, 16, 92, 18, 29, 19, 20, 16, 17, 15,
  0, 20, 18, 37, 17, 20, 14,  6, 34, 38, 16,244,236,212,228, 17,
 57, 57, 17, 57, 17, 57, 57, 49,  0, 47,236,228,244,236, 16,238,
 17, 57, 57, 48, 75, 83, 88,  7, 16,  5,237, 17, 23, 57,  7,  5,
237,  7, 16,  5,237,  7,  5,237, 17, 23, 57,  7,  5,237, 17, 23,
 57,  7,  5,237, 17, 23, 57, 89, 34,178, 96, 39,  1,  1, 93,  1,
 75,176, 18, 84, 88,189,  0, 38,255,192,  0,  1,  0, 38,  0, 38,
  0, 64, 56, 17, 55, 56, 89, 37, 14,  1, 35, 34, 38, 53, 52, 18,
 55, 62,  1, 51, 50, 22, 23, 19, 51,  1, 35,  1, 20, 22, 51, 50,
 54, 55, 62,  1, 53, 52, 38, 35, 34,  6,  7, 14,  1,  3, 88, 74,
202,123,168,195,118,112, 74,186,102,108,165, 45,120,185,254,209,
185,253,232,131,116, 86,147, 56, 59, 68,131,115, 87,150, 53, 58,
 69,168, 97,100,229,199,166,  1, 45,119, 79, 83,104, 97,  2, 98,
249,236,  1,176,145,162, 83, 81, 84,220,107,139,156, 82, 77, 83,
220,  0,  0,  2,  0, 94,255,227,  4,145,  4,123,  0,  9,  0, 38,
  0,143, 64, 36,  0,111, 10, 21, 75, 20, 78, 17, 76, 24, 10,124,
  6, 76, 33,122, 24, 81, 39, 10, 36, 11,  9,  0,  3, 14, 20, 21,
  3, 35, 36, 14, 35, 27, 34, 39, 16,244,236,212,236, 57, 57, 17,
 23, 57, 17, 57, 49,  0, 16,228,244,236,228, 16,254,244,238, 16,
238, 48,178,112, 40,  1,  1, 93,  1, 75,176, 18, 84, 88,189,  0,
 39,255,192,  0,  1,  0, 39,  0, 39,  0, 64, 56, 17, 55, 56, 89,
 64, 44,111,  0,111,  1,111,  2,111,  3,108,  8,111,  9,111, 10,
111, 11,111, 36,111, 37,111, 38,138, 19,138, 20,153, 19,153, 20,
 15,143, 19,143, 20,143, 21,143, 22,154, 19,154, 20,  6, 93,  0,
 93,  1, 62,  1, 53, 52, 38, 35, 34,  6,  7,  5, 33, 14,  1, 21,
 20, 22, 51, 50, 54, 55,  7, 14,  1, 35, 34, 38, 53, 52, 18, 55,
 62,  1, 51, 50, 22, 21, 20,  6,  3,217,  3,  3,143,123,137,210,
 54,  3, 53,252,168,  6,  4,171,156,120,214, 92, 35, 99,211,109,
233,251,125,121, 78,215,121,190,225, 12,  2,148, 16, 34, 17,122,
142,173,159,143, 38, 44, 16,139,152, 54, 52,182, 40, 40,223,205,
175,  1, 45,118, 74, 80,228,192, 46,105,  0,  1,  0,139,  0,  0,
  3,211,  6, 20,  0, 19,  0,167, 64, 60, 10,  5, 11, 15, 11,  9,
  5, 15, 11,  6,  5, 15, 11,  2,  3,  4,  3,  1,  5,  5, 15, 15,
 11, 58,  5, 16,  1, 12,  8,111,  6,  1,125,  0, 92, 14,  6,126,
 10, 12, 10, 14, 13,  4, 11, 19, 16,  9,  8,  7,  6,  5,  2,  1,
  9, 15,  0, 15, 11, 20, 16,212,196,204, 17, 23, 57, 18, 23, 57,
 49,  0, 47,228, 50,252,236, 16,238, 50, 18, 57, 57, 48, 75, 83,
 88,  7, 16,  5,237, 17, 23, 57,  7,  5,237,  7,  5,237,  7, 16,
  5,237, 89, 34,  1, 75,176,  9, 84, 75,176, 10, 84, 91, 75,176,
 11, 84, 91, 75,176, 12, 84, 91, 75,176, 14, 84, 91, 75,176, 15,
 84, 91, 75,176, 16, 84, 91, 75,176, 17, 84, 91, 88,189,  0, 20,
  0, 64,  0,  1,  0, 20,  0, 20,255,192, 56, 17, 55, 56, 89,  1,
  7, 35, 34,  6, 15,  1, 33,  7, 33,  3, 35, 19, 35, 55, 51, 55,
 62,  1, 51,  3,211, 29,176,100, 91, 22, 20,  1, 47, 27,254,209,
190,185,191,176, 26,176, 15, 38,191,205,  6, 20,153, 79,105, 99,
143,252, 47,  3,209,143, 78,198,160,  0,  0,  2,  0, 66,254, 86,
  4,197,  4,123,  0, 31,  0, 46,  0,193, 64, 88, 34,  1, 35, 33,
  5,  1,  0, 45, 46,  2, 44, 32,  5,  0,  1,  0, 17, 16,  2, 18,
 15,  5,  1,  0, 12, 13,  2, 11, 14,  5,  1,  1,  0, 31,  5,  1,
  0, 28, 29,  2, 27, 30,  5,  0,  1,  0, 58, 15, 30, 35,  1, 14,
 44, 18,  7, 75,  8, 11, 76,  4, 35, 76, 27,122, 44, 76,  4,127,
  0,126, 18, 32, 31,  0,  8, 21, 14, 15, 30,  1,  4,  0, 41, 14,
  0, 21, 34, 47, 16,244,196,236, 17, 23, 57, 17, 57, 17, 57, 57,
 49,  0, 47,228,228,236,244,236, 16,254,213,238, 17, 18, 57, 57,
 17, 57, 57, 48, 75, 83, 88,  7, 16,  5,237, 17, 23, 57,  7,  5,
237,  7, 16,  5,237, 17, 23, 57,  7,  5,237, 17, 23, 57,  7, 16,
  5,237, 17, 23, 57,  7,  5,237, 17, 23, 57, 89, 34,178, 96, 48,
  1,  1, 93,  1, 75,176, 18, 84, 88,189,  0, 47,255,192,  0,  1,
  0, 47,  0, 47,  0, 64, 56, 17, 55, 56, 89,  1,  3,  2,  0, 33,
 34, 38, 39, 55, 30,  1, 51, 50, 54, 63,  1, 14,  1, 35, 34, 38,
 53, 52, 18, 55, 62,  1, 51, 50, 22, 23, 55,  3, 52, 38, 35, 34,
  6,  7, 14,  1, 21, 20, 22, 51, 50, 18,  4,197,191, 55,254,201,
254,249, 97,166, 72, 34, 68,152, 86,175,225, 36, 16, 77,204,118,
170,195,118,107, 71,189,103,113,168, 41, 32, 92,128,118, 73,132,
 47, 76, 85,129,121,175,234,  4, 96,252, 43,254,227,254,232, 29,
 30,179, 44, 42,191,179, 84, 88, 92,225,197,155,  1, 41,115, 76,
 82,105, 96,174,254,101,136,148, 58, 52, 86,233,124,138,148,  1,
 61,  0,  0,  1,  0, 72,  0,  0,  4,135,  6, 20,  0, 25,  0,181,
 64, 77,  8,  7,  6,  5,  4,  5,  3,  5,  0,  1,  0,  2,  5,  1,
  1,  0, 13,  5, 15, 14, 10, 11,  2,  9, 12,  5, 14, 15, 14, 19,
 18,  2, 20, 17,  5, 15, 14, 16,  5, 15, 15, 14, 58, 12,  3, 17,
  0,  1,  9, 76, 20,122, 15, 92, 13,  1, 13, 15, 14,  0, 23, 16,
 12,  6,  3,  2,  5, 17, 15,  1, 39, 23, 15, 37, 14, 36, 26, 16,
244,228,212,236, 17, 57, 23, 57, 17, 57, 17, 18, 57, 49,  0, 47,
 60,236,244,236, 17, 57, 57, 57, 57, 48, 75, 83, 88,  7, 16,  5,
237,  7,  5,237, 17, 23, 57,  7, 16,  5,237, 17, 23, 57,  7,  5,
237,  7, 16,  5,237,  7, 16,  5,237, 23, 57, 89, 34,178, 48, 27,
  1,  1, 93,178, 96, 27,  1, 93,  1, 75,176, 18, 84, 88,189,  0,
 26,255,192,  0,  1,  0, 26,  0, 26,  0, 64, 56, 17, 55, 56, 89,
178,159, 27,  1, 93,  1,  3, 35, 19, 62,  1, 53, 52, 38, 35, 34,
  6,  7,  3, 35,  1, 51,  3, 62,  1, 51, 50, 22, 21, 20,  6,  4,
117,131,185,131,  9, 10,106, 95,148,217, 32,121,184,  1, 47,184,
119, 70,218,120,148,163,  9,  2,164,253, 92,  2,157, 47, 72, 21,
 84, 94,200,166,253,147,  6, 20,253,156, 94,109,160,145, 36, 82,
  0,  2,  0, 72,  0,  0,  2, 47,  6, 20,  0,  3,  0,  7,  0,113,
 64, 42,  2,  5,  3,  0,  3,  1,  5,  0,  0,  3,  6,  5,  7,  4,
  7,  5,  5,  4,  4,  7, 58,  2, 99,  0, 92,  4,126,  6,  6,  7,
  4,  5,  2,  1,  3, 40,  0, 37,  4,  7, 36,  8, 16,244,196,244,
228,192, 57, 57, 17, 18, 57, 49,  0, 47,228,252,236, 48, 75, 83,
 88,  7, 16,  5,237,  7, 16,  5,237,  7, 16,  5,237,  7, 16,  5,
237, 89, 34,178, 64,  9,  1,  1, 93,  1, 75,176, 18, 84, 88,189,
  0,  8,255,192,  0,  1,  0,  8,  0,  8,  0, 64, 56, 17, 55, 56,
 89,  1, 51,  7, 35,  7, 51,  3, 35,  1,119,184, 45,184, 39,184,
219,184,  6, 20,233,203,251,160,  0,  2,255, 25,254, 86,  2, 55,
  6, 20,  0, 14,  0, 18,  0,181, 64, 65, 17,  5, 18, 15, 18, 16,
  5, 15, 15, 18,  8,  7,  6,  5,  4,  3,  6,  9,  2,  5, 14,  0,
 14,  1,  5,  0,  0, 14, 58,  3,  8,  2, 14,  2, 10,  0, 17, 99,
 15, 10,125,  8,127,  0,126, 15, 92, 19, 17,  1, 16, 15, 10, 19,
  9, 16, 15,  8, 11,  9, 18, 40, 15,  0, 19, 16,212,212,228, 46,
 46, 46, 16,192, 17, 18, 57, 17, 18, 57, 57, 49,  0, 16,236,228,
244,236, 16,238, 17, 18, 57, 57, 17, 18, 57, 48, 75, 83, 88,  7,
 16,  5,237,  7, 16,  5,237, 17, 23, 57,  7, 16,  5,237,  7, 16,
  5,237, 89, 34,  1, 75,176, 12, 84, 75,176, 11, 84, 91, 88,189,
  0, 19,  0, 64,  0,  1,  0, 19,  0, 19,255,192, 56, 17, 55, 56,
 89, 64, 25, 47, 15, 47, 16, 47, 17, 47, 18, 80, 15, 80, 16, 80,
 17, 80, 18, 96, 15, 96, 16, 96, 17, 96, 18, 12, 93,  1, 51,  3,
  7,  6,  7, 14,  1, 43,  1, 55, 51, 50, 54, 55,  1, 51,  7, 35,
  1, 41,184,221,  1, 37, 48, 45,173,118, 69, 30, 47,108, 91, 31,
  1, 51,184, 45,184,  4, 96,251,140,  5,191, 71, 67, 72,156, 90,
160,  6, 40,233,  0,  1,  0, 72,  0,  0,  4,229,  6, 20,  0, 10,
  0,225, 64, 72,  6,  5,  7,  8,  7,  5,  5,  4,  5,  8,  8,  7,
  3, 41,  4,  5,  4,  2, 41,  1,  2,  5,  5,  4,  9,  5,  0, 10,
  8,  5,  7,  8,  0, 10,  2,  5,  3,  2, 10,  0, 10,  1,  5,  0,
  0, 10, 58,  8,  5,  2,  3,  3,126,  0, 92,  9,  6,  9,  8, 10,
  6,  5,  2,  1,  4,  0,  4,  0, 37, 10, 36, 11, 16,244,228,204,
 17, 23, 57, 18, 57, 57, 49,  0, 47, 60,236,228, 23, 57, 48, 75,
 83, 88,  7, 16,  5,237,  7, 16,  8,237,  7,  8,237,  7,  5,237,
  7, 16,  8,237,  7, 16,  5,237,  7, 16,  8,237,  7, 16,  5,237,
 89, 34,178,  8,  4,  1,  1, 93, 64, 62,  5,  2, 22,  2, 54,  2,
 83,  2, 84,  5, 84,  8,104,  5,105,  8,128,  2,147,  2, 10, 12,
  3,  8,  4, 58,  6, 58,  7, 64, 12, 88,  3, 88,  5, 87,  7, 87,
  8,105,  5,108,  6,106,  7,121,  3,121,  6,121,  7,133,  2,142,
  3,137,  6,138,  7,154,  3, 20, 93,  0, 93,  1, 75,176, 18, 84,
 88,189,  0, 11,255,192,  0,  1,  0, 11,  0, 11,  0, 64, 56, 17,
 55, 56, 89,  1, 51,  3,  1, 51,  9,  1, 35,  1,  3, 35,  1,119,
184,176,  2,119,239,253, 64,  2,  2,223,254, 34,106,184,  6, 20,
252,117,  1,215,253,232,253,184,  2, 35,253,221,  0,  1,  0, 72,
  0,  0,  2, 47,  6, 20,  0,  3,  0, 85, 64, 23,  2,  5,  3,  0,
  3,  1,  5,  0,  0,  3, 58,  0, 92,  2,  2,  3,  1,  0,  0, 37,
  3, 36,  4, 16,244,228, 16,192, 18, 57, 49,  0, 47,236, 48, 75,
 83, 88,  7, 16,  5,237,  7, 16,  5,237, 89, 34,178, 64,  5,  1,
  1, 93,178, 96,  5,  1, 93,  1, 75,176, 18, 84, 88,189,  0,  4,
255,192,  0,  1,  0,  4,  0,  4,  0, 64, 56, 17, 55, 56, 89,  1,
 51,  1, 35,  1,119,184,254,209,184,  6, 20,249,236,  0,  0,  1,
  0, 72,  0,  0,  7, 63,  4,123,  0, 43,  0,244, 64,115, 20, 19,
 18, 17, 16,  5, 21, 15,  5, 12, 13, 12, 14,  5, 13, 13, 12,  8,
  7,  6,  5,  4,  5,  9,  3,  5,  0,  1,  0,  2,  5,  1,  1,  0,
 25,  5, 26, 27, 26, 22, 23,  2, 21, 24,  5, 27, 26, 31, 30,  2,
 32, 29,  5, 27, 26, 28,  5, 27, 27, 26, 58, 24, 15, 12,  3,  4,
 29, 35,  0,  3,  1, 21,  9, 76, 38, 32,122, 27,126, 25, 13,  1,
 25, 26, 28, 24, 18, 15, 14,  5, 27, 13,  3,  2, 35,  6,  0, 41,
  1, 12, 35, 29, 27, 13, 39, 35,  1, 39,  6,  5, 41, 27, 26, 36,
 44, 16,244,196,212,236,236,212,236, 17, 57, 17, 57, 17, 18, 57,
 17, 18, 57, 57, 17, 18, 23, 57, 17, 57, 49,  0, 47, 60, 60,228,
244, 60,236, 50, 17, 23, 57, 23, 57, 48, 75, 83, 88,  7, 16,  5,
237,  7,  5,237, 17, 23, 57,  7,  5,237, 17, 23, 57,  7, 16,  5,
237,  7, 16,  5,237,  7, 16,  5,237, 17, 23, 57,  7, 16,  5,237,
  7, 16,  5,237, 17, 23, 57, 89, 34,178, 48, 45,  1,  1, 93,182,
 64, 45, 96, 45,112, 45,  3, 93,  1, 75,176, 18, 84, 88,189,  0,
 44,255,192,  0,  1,  0, 44,  0, 44,  0, 64, 56, 17, 55, 56, 89,
  1,  3, 35, 19, 62,  1, 53, 52, 38, 35, 34,  6,  7,  3, 35, 19,
 62,  1, 53, 52, 38, 35, 34,  6,  7,  3, 35, 19, 51,  7, 62,  1,
 51, 50, 22, 23, 62,  1, 51, 50, 22, 21, 20,  6,  7, 47,131,184,
129,  8,  8,100, 90,134,210, 31,123,184,131,  8,  8,100, 88,136,
210, 31,123,184,219,184, 35, 75,201,115,122,157, 16, 84,221,123,
144,157,  8,  2,164,253, 92,  2,158, 43, 62, 22, 90,100,201,161,
253,143,  2,158, 37, 63, 25, 91,101,201,161,253,143,  4, 96,174,
 98,103,128,114,118,124,166,152, 33, 79,  0,  1,  0, 72,  0,  0,
  4,135,  4,123,  0, 25,  0,181, 64, 77,  8,  7,  6,  5,  4,  5,
  3,  5,  0,  1,  0,  2,  5,  1,  1,  0, 13,  5, 14, 15, 14, 10,
 11,  2,  9, 12,  5, 15, 14, 19, 18,  2, 20, 17,  5, 15, 14, 16,
  5, 15, 15, 14, 58, 12,  3, 17,  0,  1,  9, 76, 20,122, 15,126,
 13,  1, 13, 15, 14,  0, 23, 16, 12,  6,  3,  2,  5, 17, 15,  1,
 39, 23, 15, 42, 14, 36, 26, 16,244,228,212,236, 17, 57, 23, 57,
 17, 57, 17, 18, 57, 49,  0, 47, 60,228,244,236, 17, 57, 57, 57,
 57, 48, 75, 83, 88,  7, 16,  5,237,  7,  5,237, 17, 23, 57,  7,
  5,237, 17, 23, 57,  7, 16,  5,237,  7, 16,  5,237,  7, 16,  5,
237, 23, 57, 89, 34,178, 48, 27,  1,  1, 93,178, 96, 27,  1, 93,
  1, 75,176, 18, 84, 88,189,  0, 26,255,192,  0,  1,  0, 26,  0,
 26,  0, 64, 56, 17, 55, 56, 89,178,159, 27,  1, 93,  1,  3, 35,
 19, 62,  1, 53, 52, 38, 35, 34,  6,  7,  3, 35, 19, 51,  7, 62,
  1, 51, 50, 22, 21, 20,  6,  4,117,131,185,131,  9, 10,106, 95,
148,214, 33,123,184,217,184, 37, 77,216,119,148,163,  9,  2,164,
253, 92,  2,157, 47, 72, 21, 84, 94,197,169,253,147,  4, 96,176,
 97,106,160,145, 36, 82,  0,  2,  0, 94,255,227,  4,135,  4,123,
  0, 17,  0, 32,  0, 63, 64, 18, 21, 76,  0, 27, 76,  9,122,  0,
 81, 33, 24, 14, 12, 18, 14,  3, 34, 33, 16,244,236,212,236, 49,
  0, 16,228,244,236, 16,238, 48,  1, 75,176, 18, 84, 88,189,  0,
 33,255,192,  0,  1,  0, 33,  0, 33,  0, 64, 56, 17, 55, 56, 89,
178,112, 34,  1, 93,  5, 34, 38, 53, 52, 54, 55, 62,  1, 51, 50,
 22, 21, 20,  2,  7, 14,  1,  1, 20, 22, 51, 50, 18, 53, 52, 38,
 35, 34,  6,  7, 14,  1,  2,  8,197,229, 79, 63, 99,244,154,191,
235, 78, 63, 98,244,254,121,127,129,185,243,130,126,104,162, 64,
 47, 51, 29,243,210,122,253, 86,134,128,238,192,133,254,248, 87,
134,128,  1,203,152,151,  1, 67,248,145,148, 97, 99, 74,190,  0,
  0,  2,255,250,254, 86,  4,182,  4,123,  0, 17,  0, 37,  0,200,
 64, 79, 11, 10,  2, 12,  9,  5, 36, 35,  4,  5,  6,  7,  4,  3,
  8,  5, 36, 36, 35, 34,  5, 36, 35, 31, 32,  2, 30, 33,  5, 35,
 36, 35, 20, 19,  2, 21, 18,  5, 36, 35, 37,  5, 36, 36, 35, 58,
 33, 18,  3, 12, 76, 30,  3, 76, 21,122, 30, 81, 34,127, 36,126,
 38, 34, 38, 37,  9,  0, 33, 35, 18, 36,  0, 14, 24, 36, 37, 35,
 38, 16,212,228,212,236, 17, 57, 18, 57, 18, 57, 57, 18, 57, 49,
  0, 16,228,228,228,244,236, 16,238, 17, 57, 57, 48, 75, 83, 88,
  7, 16,  5,237,  7,  5,237, 17, 23, 57,  7, 16,  5,237, 17, 23,
 57,  7,  5,237,  7, 16,  5,237, 17, 23, 57,  7,  5,237, 17, 23,
 57, 89, 34,  1, 75,176, 10, 84, 75,176, 13, 84, 91, 75,176, 14,
 84, 91, 75,176, 15, 84, 91, 75,176, 16, 84, 91, 88,189,  0, 38,
  0, 64,  0,  1,  0, 38,  0, 38,255,192, 56, 17, 55, 56, 89,182,
 96, 39,112, 39,159, 39,  3, 93,  1, 52, 38, 35, 34,  6,  7, 14,
  1, 21, 20, 22, 51, 50, 54, 55, 62,  1,  1, 62,  1, 51, 50, 22,
 21, 20,  2,  7, 14,  1, 35, 34, 38, 39,  3, 35,  1, 51,  3,248,
128,120, 82,149, 58, 57, 68,128,118, 87,149, 53, 57, 70,253,198,
 74,201,123,172,190,118,111, 74,186,103,119,162, 40,115,184,  1,
 45,184,  2,178,147,156, 84, 80, 79,224,110,140,151, 82, 78, 82,
222,  1,105, 97,100,225,203,166,254,211,119, 79, 83, 99, 98,253,
174,  6, 10,  0,  0,  2,  0, 94,254, 90,  4,199,  4,123,  0, 19,
  0, 34,  0,178, 64, 76, 28,  1, 29, 27,  5, 18, 17, 24, 25,  2,
 23, 26,  5, 17, 18, 17,  2,  1,  2,  3,  0,  5, 18, 17, 19,  5,
 18, 18, 17, 16,  5, 18, 17, 13, 14,  2, 12, 15,  5, 17, 18, 17,
 58, 15,  0, 29, 23, 76,  3, 29, 76, 12,122,  3, 81, 18,127, 16,
126, 35, 19, 20, 16, 17,  0, 20, 15, 26, 18, 37, 17, 20, 14,  6,
 34, 35, 16,244,236,212,228, 57, 57, 17, 57, 17, 57, 17, 57, 49,
  0, 16,228,228,228,244,236, 16,238, 17, 57, 57, 48, 75, 83, 88,
  7, 16,  5,237, 17, 23, 57,  7,  5,237,  7, 16,  5,237,  7,  5,
237, 17, 23, 57,  7, 16,  5,237, 17, 23, 57,  7,  5,237, 17, 23,
 57, 89, 34,178, 96, 36,  1,  1, 93,178,128, 36,  1, 93,  1, 75,
176, 18, 84, 88,189,  0, 35,255,192,  0,  1,  0, 35,  0, 35,  0,
 64, 56, 17, 55, 56, 89, 37, 14,  1, 35, 34, 38, 53, 52, 18, 55,
 62,  1, 51, 50, 22, 23, 55, 51,  1, 35,  1, 20, 22, 51, 50, 18,
 53, 52, 38, 35, 34,  6,  7, 14,  1,  3, 86, 74,201,122,170,193,
119,111, 72,187,103,124,160, 36, 32,185,254,213,185,254, 58,124,
117,174,246,127,119, 87,148, 55, 58, 67,168, 97,100,229,201,162,
  1, 46,120, 78, 84, 98, 99,168,249,252,  3, 82,148,155,  1, 77,
238,144,153, 81, 78, 82,220,  0,  0,  1,  0, 72,  0,  0,  3,180,
  4,123,  0, 17,  0,169, 64, 52,  7,  5,  8,  9,  8,  4,  5,  2,
  3,  6,  5,  9,  8, 13, 12,  2, 14, 11,  5,  9,  8, 10,  5,  9,
  9,  8, 58,  6, 11,  7,  0, 17,  3, 76, 14,122,  9,126,  7, 11,
 10,  0,  6,  4, 17,  7,  9, 17,  9,  8, 36, 18, 16,244,196,204,
 18, 57, 17, 23, 57, 49,  0, 47,228,244,236,212,204, 17, 57, 57,
 48, 75, 83, 88,  7, 16,  5,237,  7,  5,237, 17, 23, 57,  7,  5,
237, 17, 23, 57,  7, 16,  5,237, 89, 34,178, 79, 19,  1,  1, 93,
 64, 12, 84, 11,  1, 93,  5, 91,  6, 95,  7, 95,  8,  4, 93,  0,
 93,  1, 75,176, 14, 84, 88,189,  0, 18,  0, 64,  0,  1,  0, 18,
  0, 18,255,192, 56, 17, 55, 56, 89, 64, 19, 64,  0, 64,  1, 64,
  2, 64, 14, 64, 15, 64, 16, 64, 17, 64, 19, 80, 19,  9, 93,  1,
 46,  1, 35, 34,  6,  7,  3, 35, 19, 51,  7, 62,  1, 51, 50, 22,
 23,  3,145, 28, 72, 41,147,220, 36,113,184,219,184, 35, 73,203,
115, 30, 58, 29,  3,182, 15, 16,223,187,253,197,  4, 96,174, 97,
104,  7,  8,  0,  0,  1,  0, 23,255,227,  4,  0,  4,123,  0, 40,
  0,194, 64, 63, 14, 13,  2, 15, 12,  5, 32, 31,  8,  9, 10,  3,
  7, 11,  5, 31, 32, 31, 58, 30, 31, 25, 11, 12, 31, 32,  4,  1,
 21, 75, 22, 79, 25, 76, 18,  0, 75,  1, 79,  4, 76, 38,122, 18,
 81, 41, 30, 11, 25, 12, 32,  3, 28,  7,  1,  0, 28, 14, 15,  7,
  5, 35, 41, 16,212,236,212,236,192,192, 17, 18, 23, 57, 57, 57,
 49,  0, 16,228,244,252,244,236, 16,254,245,238, 18, 23, 57, 17,
 18, 57, 48, 75, 83, 88,  7, 16, 14,237, 17, 23, 57,  7, 14,237,
 17, 23, 57, 89, 34,  1, 75,176, 10, 84, 75,176, 18, 84, 91, 75,
176, 14, 84, 91, 88,189,  0, 41,  0, 64,  0,  1,  0, 41,  0, 41,
255,192, 56, 17, 55, 56, 89, 64, 40, 32,  0, 32,  1, 47, 21, 47,
 22, 41, 23, 88,  9, 88, 10, 88, 11, 88, 12, 88, 30, 88, 31, 11,
 41,  0, 41,  1, 57,  0, 57,  1, 74,  0, 74,  1, 89,  0, 89,  1,
  8, 93,  0, 93,  1,  7, 46,  1, 35, 34,  6, 21, 20, 23, 22, 31,
  1, 30,  1, 21, 20,  4, 35, 34, 38, 39, 55, 30,  1, 51, 50, 54,
 53, 52, 47,  2, 46,  1, 53, 52, 36, 51, 50, 22,  4,  0, 35, 73,
162, 86,145,167,194, 15,  7, 59,184,123,254,229,229, 89,196,118,
 36,101,196, 90,135,169,222, 19, 63,140,130,  1, 13,231, 91,173,
  4, 63,174, 40, 40, 99, 85, 99, 53,  4,  2, 18, 51,112, 97,178,
224, 34, 36,190, 52, 54,116, 89, 96, 59,  5, 16, 37,121, 94,179,
210, 30,  0,  1,  0,131,  0,  0,  3, 98,  5,158,  0, 25,  0,166,
 64, 62,  9,  8,  7,  6,  5,  4,  6, 10,  3,  5, 18, 23, 18,  2,
  5, 23, 18, 25,  5, 23, 18, 24,  5, 23, 23, 18, 58, 18,  3,  9,
 19,  1,111, 23, 21,  0,126,  9,125, 11, 20, 26, 25, 24, 23, 22,
 21, 19, 18, 12, 11, 10,  9,  6,  3,  2,  1, 15,  0, 15, 15, 26,
 16,196, 16,192, 23, 57, 18, 57, 49,  0, 47,236,244, 60,196,236,
 50, 17, 57, 57, 48, 75, 83, 88,  7, 16,  5,237,  7,  5,237,  7,
  5,237,  7, 16,  5,237, 17, 23, 57, 89, 34,178, 24, 19,  1,  1,
 93, 64, 11, 25,  2, 24, 19,103, 24,121, 22,121, 25,  5, 93,  1,
 75,176,  9, 84, 75,176, 10, 84, 91, 75,176, 14, 84, 91, 75,176,
 11, 84, 91, 88,189,  0, 26,  0, 64,  0,  1,  0, 26,  0, 26,255,
192, 56, 17, 55, 56, 89,  1,  7, 33,  3, 14,  1, 21, 20, 22, 59,
  1,  7, 35, 34, 38, 53, 52, 54, 55, 19, 35, 55, 51, 19, 51,  3,
  3, 98, 28,254,145,119,  6,  6, 77, 85,186, 31,176,164,161,  6,
  6,119,156, 29,153, 62,184, 61,  4, 96,143,253,160, 34, 46, 13,
 64, 58,154,128,130, 23, 55, 33,  2, 96,143,  1, 62,254,194,  0,
  0,  1,  0,117,255,227,  4,182,  4, 96,  0, 25,  0,195, 64, 76,
 19, 18,  2, 20, 17,  5, 15, 14, 16,  5, 15, 15, 14, 13,  5, 14,
 15, 14, 10, 11,  2, 12,  5, 15, 15, 14,  8,  7,  6,  5,  4,  5,
  9,  3,  5,  0,  1,  0,  2,  5,  1,  1,  0, 58, 12,  3, 17,  0,
  1,  9, 76, 20, 81, 13,  1,126, 15, 13, 15, 14,  0, 23, 16, 12,
  6,  3,  2,  5, 17,  1, 15, 14,  1, 39, 23, 26, 16,212,236,212,
196, 17, 57, 23, 57, 18, 57, 17, 18, 57, 49,  0, 47,228, 50,244,
236, 17, 57, 57, 57, 57, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,
  5,237, 17, 23, 57,  7, 16,  5,237, 23, 57,  7, 16,  5,237,  7,
 16,  5,237,  7,  5,237, 17, 23, 57, 89, 34,  1, 75,176,  9, 84,
 75,176, 10, 84, 91, 75,176, 13, 84, 91, 75,176, 14, 84, 91, 75,
176, 15, 84, 91, 75,176, 16, 84, 91, 88,189,  0, 26,  0, 64,  0,
  1,  0, 26,  0, 26,255,192, 56, 17, 55, 56, 89,178, 96, 27,  1,
 93, 27,  1, 51,  3, 14,  1, 21, 20, 22, 51, 50, 54, 55, 19, 51,
  3, 35, 55, 14,  1, 35, 34, 38, 53, 52, 54,137,131,185,131, 10,
  9,104, 95,148,216, 33,123,184,217,184, 37, 78,215,121,147,164,
 10,  1,188,  2,164,253, 99, 49, 70, 23, 85, 93,200,169,  2,108,
251,160,176, 98,107,161,144, 30, 90,  0,  0,  1,  0,147,  0,  0,
  4,213,  4, 96,  0,  6,  0,185, 64, 39,  3, 43,  4,  5,  4,  2,
 43,  1,  2,  5,  5,  4,  2, 43,  3,  2,  6,  0,  6,  1, 43,  0,
  0,  6, 58,  2,  3,  0,126,  5,  6,  5,  3,  2,  1,  5,  4,  0,
  7, 16,212,204, 23, 57, 49,  0, 47,228, 50, 57, 48, 75, 83, 88,
  7, 16,  5,237,  7, 16,  8,237,  7, 16,  8,237,  7, 16,  5,237,
 89, 34,178,  7,  5,  1,  1, 93, 64, 44,120,  2,133,  2,128,  2,
  3,  7,  2,  8,  3,  7,  5,  8,  6, 22,  5, 37,  5, 55,  2, 53,
  5, 73,  3, 73,  4,103,  2,102,  5,116,  2,115,  5,117,  6,135,
  2,137,  3,139,  5, 18, 93,  0, 93,  1, 75,176,  9, 84, 75,176,
 13, 84, 91, 75,176, 12, 84, 91, 75,176, 14, 84, 91, 75,176, 16,
 84, 91, 75,176, 17, 84, 91, 88,189,  0,  7,  0, 64,  0,  1,  0,
  7,  0,  7,255,192, 56, 17, 55, 56, 89,180, 48,  8,144,  8,  2,
 93, 19, 51, 19,  1, 51,  1, 35,147,195,164,  2, 24,195,253,131,
248,  4, 96,252, 72,  3,184,251,160,  0,  0,  1,  0,174,  0,  0,
  6,141,  4, 96,  0, 12,  1,120, 64, 74,  6, 43,  7,  8,  7,  5,
 43,  4,  5,  8,  8,  7, 10,  3, 11, 10,  4,  5,  4,  9,  3,  5,
  5,  4,  3,  3, 10, 11, 10,  2,  3,  1,  2, 11, 11, 10,  2, 43,
  3,  2, 12,  0, 12,  1, 43,  0,  0, 12, 58, 10,  5,  2,  3,  6,
  3,  0,126, 11,  8, 12, 11, 10,  9,  8,  6,  5,  4,  3,  2,  1,
 11,  7,  0, 13, 16,212,204, 23, 57, 49,  0, 47, 60,228, 50, 50,
 23, 57, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  8,237,  7, 16,
  8,237,  7, 16,  5,237,  7, 16,  5,237,  7, 16,  8,237,  7, 16,
  8,237,  7, 16,  5,237, 89, 34,178,  7, 11,  1,  1, 93, 64,152,
 53, 10, 69,  5, 68, 10, 83,  5, 84, 10,103,  2,100,  5,118,  5,
116, 10,130,  5,135, 10,128, 10,147, 10,144, 10, 14,  9,  3,  6,
  5,  4,  8,  6, 11, 25,  3, 22,  5, 20,  8, 21, 11, 44,  3, 38,
  8, 40,  9, 41, 10, 36, 11, 54,  2, 61,  3, 55,  5, 54,  8, 56,
 10, 51, 11, 54, 12, 76,  3, 72,  5, 74,  6, 74,  7, 73,  8, 73,
  9, 72, 10, 70, 11, 91,  3, 88,  5, 90,  6, 89,  7, 90,  8, 88,
 10,102,  2,101,  4,101,  5,100,  6,100,  7,102,  8, 96,  9,102,
 12,118,  2,123,  3,122,  6,121,  7,118, 11,118, 12,137,  5,140,
  6,137,  7,135,  9,134, 10,138, 11,136, 12,155,  4,152,  5,155,
  6,155,  7,149,  9,154, 11, 61, 93,  0, 93,  1, 75,176, 18, 84,
 75,176,  9, 84, 91, 75,176, 14, 84, 91, 88,189,  0, 13,  0, 64,
  0,  1,  0, 13,  0, 13,255,192, 56, 17, 55, 56, 89, 64, 46,171,
  2,165,  5,161, 10,160, 10,184,  2,191,  2,178,  5,178, 10,176,
 10,176, 10, 10,144, 14,167,  2,166,  3,168,  4,167,  5,164, 10,
169, 11,182,  2,183,  5,182,  8,178, 10,183, 12, 12, 93,  0, 93,
 19, 51, 19,  1, 51, 19,  1, 51,  1, 35,  3,  1, 35,174,182, 47,
  1,162,213, 62,  1,141,184,254,  0,215, 55,254, 84,217,  4, 96,
252,123,  3,133,252,123,  3,133,251,160,  3,160,252, 96,  0,  1,
255,203,  0,  0,  4,205,  4, 96,  0, 11,  1,137, 64, 72,  4, 43,
  5,  4,  1,  2,  1,  3, 43,  2,  2,  1, 11, 43,  0,  1,  0, 10,
 43,  9, 10,  1,  1,  0, 10, 43, 11, 10,  7,  8,  7,  9, 43,  8,
  8,  7,  5, 43,  6,  7,  6,  4, 43,  3,  4,  7,  7,  6, 58, 10,
  7,  4,  1,  4,  8,  0,126,  5,  2, 10,  9,  8,  7,  4,  3,  2,
  1,  8, 12,  0,  6, 12, 16,212,204, 17, 23, 57, 49,  0, 47, 60,
228, 50, 23, 57, 48, 75, 83, 88,  7, 16,  8,237,  7, 16,  5,237,
  7, 16,  5,237,  7, 16,  8,237,  7, 16,  8,237,  7, 16,  5,237,
  7, 16,  5,237,  7, 16,  8,237, 89, 34,178,  8,  4,  1,  0, 93,
 64,212,  5,  0,  6,  1,  7,  4,  5,  5, 22,  1, 22,  4, 20,  5,
 42,  0, 41,  1, 38,  2, 39,  3, 37,  5, 38,  6, 41,  8, 41,  9,
 41, 10, 43, 11, 58,  0, 56,  1, 54,  4, 53,  5, 53,  6, 55,  7,
 57, 10, 59, 11, 74,  0, 73,  1, 71,  4, 69,  5, 69,  6, 71,  7,
 73, 10, 74, 11, 86,  0, 86,  1, 85,  5, 86,  6, 88,  7, 87,  9,
102,  0,102,  1,102,  2,102,  3,101,  5,102,  6,103,  9,102, 10,
102, 11,118,  0,117,  1,118,  4,117,  5,117,  6,119, 10,118, 11,
137,  3,135,  4,129,  5,132,  6,135,  7,134,  9,135, 10,138, 11,
149,  0,150,  1,152,  3,151,  4,146,  5,150,  6,151, 10,165,  0,
165, 11,183,  3,183,  6, 74,  9,  4,  9,  7,  6, 10, 26,  4, 38,
  1, 43,  4, 41,  7, 38, 10, 54,  1, 56,  4, 56,  7, 54, 10, 70,
  1, 73,  4, 73,  7, 70, 10, 88,  1,105,  1,104,  7,104, 10,119,
  4,120, 10,140,  4,137,  7,133, 10,154,  1,157,  4,153,  7,150,
 10,184,  7,200,  7, 31, 93,  1, 93,  1, 75,176, 12, 84, 75,176,
 14, 84, 91, 75,176, 16, 84, 91, 75,176, 17, 84, 91, 88,189,  0,
 12,  0, 64,  0,  1,  0, 12,  0, 12,255,192, 56, 17, 55, 56, 89,
178,144, 13,  1, 93,  9,  2, 35,  3,  1, 35,  9,  1, 51, 19,  1,
  4,205,253,254,  1, 59,211,237,254,100,223,  2, 39,254,219,211,
215,  1,119,  4, 96,253,219,253,197,  1,188,254, 68,  2, 78,  2,
 18,254,107,  1,149,  0,  0,  1,255,205,254, 86,  4,211,  4, 96,
  0, 15,  1, 50, 64, 70, 10, 43, 11, 10,  0, 15,  6,  7,  8,  3,
  5,  9, 43,  0,  0, 15, 14, 43, 15,  0, 15, 13, 43, 12, 13,  0,
  0, 15, 13, 43, 14, 13, 10, 11, 10, 12, 43, 11, 11, 10, 58, 13,
 11,  9, 16,  0, 11,  5,125,  3,127, 14, 11,126, 16, 13, 12, 11,
 10,  9,  6,  0,  3,  8, 15,  5, 16, 15,  4, 16, 16,212,204, 18,
 57, 17, 23, 57, 49,  0, 16,228, 50,244,236, 17, 57, 17, 57, 18,
 57, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  8,237,  7, 16,  8,
237,  7, 16,  5,237,  7, 16,  5,237, 17, 23, 57,  7,  8,237, 89,
 34,178,  7,  2,  1,  1, 93, 64,102, 38, 13, 55, 13, 70, 13,118,
  9,119, 10,118, 13,134, 13,147, 13,  8,  6,  0,  5,  1,  8,  2,
  8, 14, 22,  0, 21,  1, 24, 14, 38,  0, 36,  1, 36,  2, 41, 14,
 57,  9, 57, 10, 57, 14, 56, 15, 73,  9, 73, 10, 72, 13, 72, 14,
119,  0,119,  1,119,  2,120,  9,120, 10,118, 11,118, 12,121, 14,
121, 15,138,  8,139,  9,137, 10,132, 11,132, 12,137, 13,136, 14,
150,  0,150,  1,150,  2,150, 10,148, 11,148, 12,150, 13, 42, 93,
  0, 93,  1, 75,176,  9, 84, 75,176, 12, 84, 91, 75,176, 14, 84,
 91, 75,176, 16, 84, 91, 75,176, 17, 84, 91, 88,189,  0, 16,  0,
 64,  0,  1,  0, 16,  0, 16,255,192, 56, 17, 55, 56, 89,  1, 75,
176, 18, 84, 88,189,  0, 16,255,192,  0,  1,  0, 16,  0, 16,  0,
 64, 56, 17, 55, 56, 89,  5, 14,  1, 43,  1, 55, 51, 50, 54, 63,
  1,  3, 51, 19,  1, 51,  1,252,128,161,125,145, 31,106, 77,108,
 67, 57,248,195,186,  2,  2,193,104,215,107,154, 84,122,107,  4,
 55,252,166,  3, 90,  0,  0,  1,255,250,  0,  0,  4, 88,  4, 96,
  0,  9,  0,127, 64, 29,  8, 43,  2,  3,  2,  3, 43,  7,  8,  7,
 58,  8,111,  0,126,  3,111,  5,  9,  8,  5,  4,  3,  0,  6, 10,
  1,  6, 10, 16,212,204, 17, 23, 57, 49,  0, 47,236,244,236, 48,
 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237, 89, 34,178,120,  2,
  1,  0, 93, 64, 20,133,  3,135,  7,138,  8,145,  3,153,  8,  5,
120,  2,119,  7,139,  2,131,  7,  4, 93,  1, 93,  1, 75,176, 12,
 84, 75,176, 14, 84, 91, 75,176, 16, 84, 91, 75,176, 17, 84, 91,
 88,189,  0, 10,  0, 64,  0,  1,  0, 10,  0, 10,255,192, 56, 17,
 55, 56, 89, 19, 33,  7,  1, 33,  7, 33, 55,  1, 33,238,  3,106,
 33,252,181,  2,184, 29,252,115, 33,  3, 75,253,107,  4, 96,168,
252,219,147,168,  3, 37,  0,  1,  0,248,254,178,  4,215,  6, 20,
  0, 52,  1,  3, 64,102,  8,  7,  2,  9,  6,  5, 45, 46, 45,  2,
  3,  4,  3,  1,  5,  5, 46, 46, 45, 22, 21, 20, 19, 18, 17,  6,
 23, 16,  5, 31, 32, 31, 10, 11, 12, 13, 14,  5,  9, 15,  5, 32,
 32, 31, 58, 32, 53, 39, 45,  5,  1,  9, 41, 31, 15, 16,  3, 39,
 22,  6, 46,  1, 41,111, 39, 22,111, 24,  1,111, 39,  0, 92, 53,
 41, 40, 53, 52, 46, 32, 31, 25, 24, 23, 22, 19, 16, 15, 12,  9,
  6,  5,  2,  1, 17,  0, 36, 45,  0, 28, 28, 53, 16,196, 16,192,
192,192, 18, 23, 57, 18, 57, 57, 49,  0, 16,252,196,236,212,236,
 16,238, 17, 57, 57, 17, 18, 23, 57, 17, 57, 18, 57, 57, 17, 18,
 57, 48, 75, 83, 88,  7, 16, 14,237, 17, 23, 57,  7, 16, 14,237,
 17, 23, 57,  7, 16, 14,237, 17, 23, 57,  7, 16, 14,237, 17, 23,
 57, 89, 34,178,  7, 15,  1,  1, 93, 64, 75,  5, 11,  5, 12,  5,
 13,  4, 14,  5, 15, 21, 11, 21, 12, 21, 13, 21, 14, 21, 15, 37,
 11, 37, 12, 37, 13, 37, 14, 37, 15, 53, 11, 53, 12, 53, 13, 53,
 14, 53, 15, 72, 11, 72, 12, 72, 13, 72, 14, 72, 15, 75, 32, 75,
 33, 75, 34, 75, 35, 75, 36, 75, 37, 90, 32, 90, 33, 90, 34, 90,
 35, 90, 36, 90, 37, 37, 93,  1,  7, 35, 34,  6, 15,  1, 14,  1,
  7, 30,  1, 21, 20,  6, 15,  1, 14,  1, 21, 20, 22, 59,  1,  7,
 35, 34, 38, 53, 52, 54, 63,  1, 52, 55, 54, 53, 52, 38, 43,  1,
 55, 51, 50, 54, 63,  1, 62,  1, 55, 62,  1, 51,  4,215, 29, 77,
136, 94, 31, 51, 32,121,111, 73, 81,  8,  7, 47,  5,  5, 85, 97,
 78, 29, 71,188,162,  7,  7, 45,  2, 10, 98,113, 61, 28, 62,144,
127, 32, 47, 26, 71, 55, 46,138,133,  6, 20,143, 79,150,252,160,
145, 21, 18,103, 75, 24, 66, 38,244, 31, 53, 24, 63, 57,144,109,
123, 32, 68, 37,235,  3,  9, 50, 45, 85, 75,147,109,151,244,123,
143, 39, 34, 29,  0,  1,  1,  4,254, 29,  1,174,  6, 29,  0,  3,
  0, 18,183,  1,  0,128,  4,  0,  7,  2,  4, 16,212,236, 49,  0,
 16,252,204, 48,  1, 17, 35, 17,  1,174,170,  6, 29,248,  0,  8,
  0,  0,  0,  1,  0, 14,254,178,  3,238,  6, 20,  0, 52,  0,174,
 64,102,  8,  7,  2,  9,  6,  5, 45, 46, 45,  2,  3,  4,  3,  1,
  5,  5, 46, 46, 45, 22, 21, 20, 19, 18, 17,  6, 23, 16,  5, 31,
 32, 31, 10, 11, 12, 13, 14,  5,  9, 15,  5, 32, 32, 31, 58, 45,
 53, 41, 32, 16, 22,  9, 41, 15, 31, 39, 22,  5,  6, 46,  3,  1,
 39,111, 41,  1,111,  0, 41, 22,111, 24, 92, 53, 52, 46,  0, 32,
 31, 25, 24, 23, 22, 19, 16, 15, 12,  9,  6,  5,  2,  1, 18, 53,
 41, 40, 39, 42, 40, 28, 28, 53, 16,196, 16,192,192,192, 18, 57,
 18, 23, 57, 49,  0, 16,252,236,196,212,236, 16,238, 18, 23, 57,
 17, 18, 57, 57, 17, 57, 17, 57, 57, 17, 18, 57, 48, 75, 83, 88,
  7, 16, 14,237, 17, 23, 57,  7, 16, 14,237, 17, 23, 57,  7, 16,
 14,237, 17, 23, 57,  7, 16, 14,237, 17, 23, 57, 89, 34, 19, 55,
 51, 50, 54, 55, 55, 54, 54, 55, 38, 38, 53, 52, 54, 55, 55, 54,
 54, 53, 52, 38, 35, 35, 55, 51, 50, 22, 21, 20,  6,  7,  7, 20,
  7,  6, 21, 20, 22, 51, 51,  7, 35, 34,  6,  7,  7,  6,  6,  7,
  6,  6, 35, 14, 29, 78,136, 94, 30, 51, 33,120,111, 73, 80,  7,
  7, 47,  6,  4, 85, 97, 78, 27, 74,187,163,  7,  8, 45,  2, 10,
 98,113, 62, 29, 62,144,126, 29, 53, 26, 70, 53, 47,138,133,254,
178,144, 79,150,252,160,145, 20, 19,102, 76, 25, 64, 38,243, 34,
 50, 25, 64, 57,143,108,123, 31, 68, 39,235,  3,  9, 49, 45, 86,
 74,147,110,150,244,126,141, 38, 34, 30,  0,  1,  0,217,  1,211,
  5,219,  3, 49,  0, 29,  0, 35, 64, 16,  1, 16, 27, 12,  0, 19,
  4, 96, 27, 19, 96, 12, 30,  0, 15, 30, 16,212,196, 49,  0, 16,
212,252,212,236, 16,192, 17, 18, 57, 57, 48,  1, 21,  6,  6, 35,
 34, 39, 38, 39, 38, 39, 38, 35, 34,  6,  7, 53, 54, 54, 51, 50,
 23, 22, 23, 22, 23, 22, 51, 50, 54,  5,219,105,179, 97,110,146,
 11,  5,  7, 15,155, 94, 88,172, 98,105,179, 97,110,147, 10,  5,
  8, 14,155, 94, 86,169,  3, 49,178, 79, 68, 59,  4,  2,  3,  5,
 62, 77, 83,178, 79, 69, 60,  4,  2,  3,  5, 62, 76,  0,255,255,
255,147,  0,  0,  4,236,  7, 78,  2, 39,  0, 36,  0,  0,  0,  0,
  0,  7,  1,  3,  0,217,  1,117,  0,  3,255,147,  0,  0,  4,236,
  7,109,  0, 11,  0, 30,  0, 33,  0,218, 64, 80, 31,  5, 32, 31,
 24, 25, 24, 33,  5, 25, 24, 27,  5, 25, 24, 26,  5, 25, 25, 24,
 32,  5, 30, 12, 30, 31,  5, 33, 31, 12, 12, 30, 29,  5, 12, 30,
 28,  5, 30, 12, 30, 58, 31, 24, 12, 32,  9,  3, 18, 27, 90, 32,
  9, 83, 18, 29, 25, 29, 32, 28,  3, 34, 12, 15,  6, 26, 21, 33,
 31, 27,  3, 24,  0,  6, 15,  0, 21, 25, 30, 34, 16,212,212,212,
196,212,196, 17, 57, 23, 57, 18, 57, 17, 18, 57, 17, 23, 57, 49,
  0, 47, 60,196,228,212,236, 16,198, 17, 18, 57, 57, 57, 48, 75,
 83, 88,  7, 16,  5,237,  7,  5,237,  7, 16,  8,237,  7, 16,  5,
237,  7, 16,  5,237,  7,  5,237,  7,  5,237,  7, 16,  8,237, 89,
 34,178,  7, 32,  1,  1, 93, 64, 56, 23, 12, 38, 12, 57, 31, 77,
 31, 87, 24,137, 31,  6,  7, 32, 26, 12, 24, 26, 24, 27, 40, 12,
 57, 24, 56, 31, 72, 24, 71, 29, 72, 31, 87, 24, 91, 25, 89, 26,
 88, 27, 88, 33,103, 28,119, 31,119, 32,138, 12,136, 27,137, 31,
 21, 93,  0, 93,  1, 52, 38, 35, 34,  6, 21, 20, 22, 51, 50, 54,
  5, 46,  1, 53, 52, 54, 51, 50, 22, 21, 20,  6,  7,  1, 35,  3,
 33,  3, 35,  9,  1, 33,  3,252, 89, 63, 64, 87, 87, 64, 63, 89,
254,197, 54, 57,160,114,114,161, 73, 69,  1,  3,211, 62,253, 96,
211,213,  3,168,254, 93,  2, 36,  6, 90, 63, 89, 87, 65, 63, 88,
 88,156, 37,113, 69,114,161,161,114, 79,122, 36,250,147,  1,127,
254,129,  5, 14,253, 25,255,255,  0, 86,254,117,  5,143,  5,240,
  2, 39,  0, 38,  0,  0,  0,  0,  0,  7,  0,221,  1, 14,  0,  0,
255,255,  0, 55,  0,  0,  5, 10,  7,107,  2, 39,  0, 40,  0,  0,
  0,  0,  0,  7,  1,  4,  0,160,  1,117,255,255,  0, 55,  0,  0,
  5,197,  7, 94,  2, 39,  0, 49,  0,  0,  0,  0,  0,  7,  1,  5,
  0,254,  1,117,255,255,  0, 82,255,227,  5,250,  7, 78,  2, 39,
  0, 50,  0,  0,  0,  0,  0,  7,  1,  3,  1, 84,  1,117,255,255,
  0,119,255,227,  5,180,  7, 78,  2, 39,  0, 56,  0,  0,  0,  0,
  0,  7,  1,  3,  0,250,  1,117,255,255,  0, 84,255,227,  4,145,
  6,102,  2, 39,  0, 68,  0,  0,  0,  0,  0,  7,  0,141,  0,100,
  0,  0,255,255,  0, 84,255,227,  4, 96,  6,102,  2, 39,  0, 68,
  0,  0,  0,  0,  0,  7,  0, 67,  0,100,  0,  0,255,255,  0, 84,
255,227,  4, 96,  6,102,  2, 39,  0, 68,  0,  0,  0,  0,  0,  7,
  0,215,  0,100,  0,  0,255,255,  0, 84,255,227,  4, 96,  6, 16,
  2, 39,  0, 68,  0,  0,  0,  0,  0,  7,  0,142,  0,100,  0,  0,
255,255,  0, 84,255,227,  4,127,  6, 55,  2, 39,  0, 68,  0,  0,
  0,  0,  0,  7,  0,216,  0,100,  0,  0,255,255,  0, 84,255,227,
  4, 96,  7,  6,  2, 39,  0, 68,  0,  0,  0,  0,  0,  7,  0,220,
  0,100,  0,  0,255,255,  0, 94,254,117,  4, 74,  4,123,  2, 39,
  0, 70,  0,  0,  0,  0,  0,  7,  0,221,  0,119,  0,  0,255,255,
  0, 94,255,227,  4,156,  6,102,  2, 39,  0, 72,  0,  0,  0,  0,
  0,  7,  0,141,  0,111,  0,  0,255,255,  0, 94,255,227,  4,145,
  6,102,  2, 39,  0, 72,  0,  0,  0,  0,  0,  7,  0, 67,  0,111,
  0,  0,255,255,  0, 94,255,227,  4,145,  6,102,  2, 39,  0, 72,
  0,  0,  0,  0,  0,  7,  0,215,  0,111,  0,  0,255,255,  0, 94,
255,227,  4,145,  6, 16,  2, 39,  0, 72,  0,  0,  0,  0,  0,  7,
  0,142,  0,111,  0,  0,255,255,  0, 72,  0,  0,  3, 43,  6,102,
  2, 39,  0,214,  0,  0,  0,  0,  0,  7,  0,141,254,254,  0,  0,
255,255,  0, 72,  0,  0,  2, 25,  6,102,  2, 39,  0,214,  0,  0,
  0,  0,  0,  7,  0, 67,254,254,  0,  0,255,255,  0, 72,  0,  0,
  2,207,  6,102,  2, 39,  0,214,  0,  0,  0,  0,  0,  7,  0,215,
254,254,  0,  0,255,255,  0, 72,  0,  0,  2,240,  6, 16,  2, 39,
  0,214,  0,  0,  0,  0,  0,  7,  0,142,254,254,  0,  0,255,255,
  0, 72,  0,  0,  4,164,  6, 55,  2, 39,  0, 81,  0,  0,  0,  0,
  0,  7,  0,216,  0,137,  0,  0,255,255,  0, 94,255,227,  4,160,
  6,102,  2, 39,  0, 82,  0,  0,  0,  0,  0,  7,  0,141,  0,115,
  0,  0,255,255,  0, 94,255,227,  4,135,  6,102,  2, 39,  0, 82,
  0,  0,  0,  0,  0,  7,  0, 67,  0,115,  0,  0,255,255,  0, 94,
255,227,  4,135,  6,102,  2, 39,  0, 82,  0,  0,  0,  0,  0,  7,
  0,215,  0,115,  0,  0,255,255,  0, 94,255,227,  4,135,  6, 16,
  2, 39,  0, 82,  0,  0,  0,  0,  0,  7,  0,142,  0,115,  0,  0,
255,255,  0, 94,255,227,  4,142,  6, 55,  2, 39,  0, 82,  0,  0,
  0,  0,  0,  7,  0,216,  0,115,  0,  0,255,255,  0,117,255,227,
  4,182,  6,102,  2, 39,  0, 88,  0,  0,  0,  0,  0,  7,  0,141,
  0,106,  0,  0,255,255,  0,117,255,227,  4,182,  6,102,  2, 39,
  0, 88,  0,  0,  0,  0,  0,  7,  0, 67,  0,106,  0,  0,255,255,
  0,117,255,227,  4,182,  6,102,  2, 39,  0, 88,  0,  0,  0,  0,
  0,  7,  0,215,  0,106,  0,  0,255,255,  0,117,255,227,  4,182,
  6, 16,  2, 39,  0, 88,  0,  0,  0,  0,  0,  7,  0,142,  0,106,
  0,  0,  0,  1,  0, 86,255, 59,  4,  2,  5,213,  0, 11,  0, 89,
 64, 46,  6,  5,  7,  0,  7,  5,  5,  0,  7,  2,  5,  0,  7,  1,
  5,  0,  0,  7, 58,  8,  4, 76, 10,  2,  0, 70,  6,129, 12,  9,
 10, 12,  6,  7, 11,  5,  4,  2,  1,  0,  6,  3,  8,  8,  7, 12,
 16,212,196, 16,192, 23, 57, 18, 57, 17, 57, 57, 49,  0, 16,228,
244,212, 60,236, 50, 48, 75, 83, 88,  7, 16,  5,237,  7,  5,237,
  7,  5,237,  7, 16,  5,237, 89, 34,  1, 51,  3, 33,  7, 33,  3,
 35, 19, 33, 55, 33,  2, 53,174, 80,  1,111, 31,254,146,217,176,
217,254,145, 29,  1,112,  5,213,254, 92,153,251,163,  4, 93,153,
  0,  2,  0,195,  3,117,  3, 61,  5,240,  0, 11,  0, 26,  0, 32,
 64, 17,  6,130, 21,131,  0,130, 12, 86, 27,  9, 44, 18, 45,  3,
 44, 24, 27, 16,220,236,252,236, 49,  0, 16,244,236,252,236, 48,
  1, 34,  6, 21, 20, 22, 51, 50, 54, 53, 52, 38, 39, 50, 22, 23,
 22, 22, 21, 20,  6, 35, 34, 38, 53, 52, 54,  2,  0, 80,110,110,
 80, 80,110,111, 79, 64,118, 43, 46, 46,185,134,135,180,184,  5,
111,111, 80, 79,109,109, 79, 79,112,129, 49, 46, 45,114, 66,132,
183,180,135,134,186,  0,  0,  2,  0,152,254,199,  4,129,  5,150,
  0,  6,  0, 33,  0,164, 64, 91, 17, 16,  2, 18, 15,  6,  0,  6,
 12, 13,  2, 11, 14,  0,  0,  6,  9,  8,  2, 10,  7, 31, 32, 31,
 33, 32, 32, 31, 23, 24, 25, 24, 20, 21,  2, 19, 22, 25, 25, 24,
 58, 10, 75, 11, 78, 14, 19, 75, 18, 78, 15, 76,  6, 76, 23, 22,
 32, 14, 76,  0, 76, 31,  7,122, 25, 22, 81, 34, 33, 32, 24, 23,
 22, 19, 18, 15, 14, 11,  7,  6,  0, 13, 10, 25, 31, 10,  3,  3,
  8, 28, 34, 16,212,236, 16,192,192,192, 18, 23, 57, 49,  0, 16,
228, 50,244, 60,236,236,196, 16,198,238,254,244,238, 16,245,238,
 48, 75, 83, 88,  7, 16,  5,201, 17, 23, 57,  7, 16,  5,201,  7,
 16,  5,201,  7, 16,  5,201, 17, 23, 57,  7, 16,  5,201, 17, 23,
 57,  7, 16,  5,201, 17, 23, 57, 89, 34,  1,  6,  2, 21, 20, 22,
 23,  1, 22, 22, 23,  7, 38, 38, 39,  3, 54, 54, 55,  7,  6,  6,
  7,  3, 35, 19, 38, 38, 53, 16,  0, 37, 19, 51,  2,246,178,240,
122,128,  1, 43, 73,129, 62, 35, 47,124, 89,168, 66,148, 83, 35,
 65,146, 77, 60,100, 59,197,214,  1, 98,  1, 26, 56,100,  3,217,
 23,254,191,215,134,147, 20,  3,252,  7, 33, 28,182, 37, 45, 12,
252,162,  5, 45, 42,182, 28, 33,  5,254,228,  1, 28, 13,223,194,
  1, 50,  1,159, 23,  1, 29,  0,  0,  1,  0, 49,  0,  0,  5, 25,
  5,240,  0, 27,  0,128, 64, 69, 12,  5, 17, 22, 17, 11,  5, 22,
 17,  8,  5, 22, 17,  5,  6,  2,  4,  7,  5, 22, 22, 17, 58,  7,
 22,  1, 18, 10,111, 20,  8, 12,  1, 75,  0,  4,100, 25, 86, 16,
 12,100, 14, 18, 21, 17, 16, 19, 15, 22, 14, 13, 12, 11, 10,  9,
  8,  7,  1, 10,  0, 21, 21, 17, 20, 19, 17, 15, 28, 16,212,196,
212,196, 16,196, 16,192, 23, 57, 17, 18, 57, 17, 18, 57, 49,  0,
 47,238, 50,246,238,214,238, 16,212, 60,238, 50, 18, 57, 57, 48,
 75, 83, 88,  7, 16,  5,237, 17, 23, 57,  7,  5,237,  7,  5,237,
  7, 16,  5,237, 89, 34,  1,  7, 38, 38, 35, 34,  6,  7,  7, 33,
  7, 33,  3, 33,  7, 33, 55, 51, 19, 35, 55, 51, 55, 18, 36, 51,
 50, 22,  5, 25, 35, 61,131, 64,147,148, 41, 41,  1,135, 29,254,
121, 90,  2, 25, 33,252, 51, 33,235, 91,199, 29,198, 45, 52,  1,
  5,232, 70,140,  5,180,182, 40, 42,159,208,215,143,254, 47,170,
170,  1,209,143,238,  1,  6,242, 30,  0,  0,  2,  0, 25,255, 61,
  3,225,  5,240,  0, 13,  0, 66,  0,130, 64, 74, 50, 51, 45, 52,
 26, 13,  7,  6,  0,  6, 32, 51, 58, 25,  4, 15, 42, 77, 41,132,
 45,111, 38, 15, 77, 14,132, 18,111, 64, 86, 38, 67, 50, 51, 48,
  7, 21, 10,  0,  3,  6, 13, 48, 58, 51, 52,  3, 21, 10, 32, 25,
 26,  3, 48,  3, 15, 14, 29, 48,  5, 35, 21,  5, 61, 10, 35,  3,
  4, 29, 10,  4, 55, 67, 16,212,236,212,252,196, 16,214,238, 16,
238, 16,192,192, 17, 18, 23, 57, 17, 18, 23, 57, 17, 57, 57, 18,
 57, 17, 18, 57, 17, 18, 57, 49,  0, 16,196,244,236,244,236, 16,
238,246,238, 17, 23, 57, 23, 57, 17, 18, 57, 48,  1, 54, 54, 53,
 52, 38, 39, 39,  6,  6, 21, 20, 22, 23,  1,  7, 38, 38, 35, 34,
  6, 21, 20, 23, 22, 23, 23, 22, 22, 21, 20,  6,  7, 22, 22, 21,
 20,  6, 35, 34, 38, 39, 55, 22, 22, 51, 50, 54, 53, 52, 47,  2,
 38, 38, 53, 52, 54, 55, 38, 38, 53, 52, 54, 51, 50, 22,  2, 90,
 82, 86,107,143, 80, 81, 85, 85,126,  1,252, 32, 72,137, 58,103,
132,135, 30, 17, 88,122, 85,132,114, 41, 41,243,199, 69,154, 82,
 32, 76,144, 59,112,134,180, 15, 76,123, 82,128,118, 43, 39,243,
187, 71,145,  1,154, 49,111, 57, 54,113, 91, 51, 51,112, 56, 50,
 97, 83,  3,207,164, 39, 39, 97, 73, 79, 90, 20, 11, 60, 85,117,
 70,101,180, 53, 35, 90, 55,157,198, 29, 29,164, 38, 40, 95, 79,
 98,121, 10, 51, 84,113, 74, 96,173, 63, 38, 81, 51,147,197, 29,
  0,  1,  1, 51,  1,209,  3,131,  4, 33,  0, 11,  0, 18,183,  3,
133,  9, 12,  6, 46,  0, 12, 16,212,236, 49,  0, 16,212,236, 48,
  1, 52, 54, 51, 50, 22, 21, 20,  6, 35, 34, 38,  1, 51,174,123,
122,173,175,122,123,172,  2,250,123,172,173,122,122,175,174,  0,
  0,  1,  0,160,255, 59,  4,150,  5,213,  0, 13,  0,105, 64, 50,
 10,  9,  2, 11,  8,  5,  6,  5,  7,  6,  6,  5,  2,  3,  4,  3,
  1,  4,  4,  3, 58,  8,  2,  4,  0, 70,  6,  2, 14,  7, 11,  6,
  2,  5,  4,  8,  6,  0,  5,  3,  1,  4,  4, 37,  3,  5, 37,  6,
 11, 14, 16,212,212,228,212,228, 16,192, 17, 18, 57, 18, 57, 17,
 18, 57, 17, 18, 57, 49,  0, 16,196, 50,244,204, 17, 57, 48, 75,
 83, 88,  7, 16,  5,201,  7, 16,  5,201,  7, 16,  5,201,  7, 16,
  5,201, 17, 23, 57, 89, 34,  1, 33,  1, 35,  1, 35,  1, 35, 19,
 38, 38, 53, 52,  0,  3,  0,  1,150,254,184,139,  1, 49,191,254,
207,141,164,178,201,  1, 88,  5,213,249,102,  6, 31,249,225,  3,
 78,  6,188,158,211,  1, 25,  0,  0,  1,  0, 96,255,227,  4,184,
  6, 20,  0, 53,  1,  3, 64, 92, 18, 17,  2, 19, 16,  4, 35, 36,
 35, 13, 14,  2, 12, 15,  4, 36, 36, 35, 52,  5, 53,  0, 53, 49,
 50,  2, 48, 51,  5,  0,  0, 53, 58, 51, 42, 36, 15,  4,  9, 16,
 35,  0,  4, 48, 25, 75, 26, 29, 76, 22, 48, 76,  3, 92, 22, 81,
 52, 52, 53, 36, 39, 35, 15, 32, 12,  0, 51, 25, 26,  4, 53, 39,
 42, 45, 16, 32, 12,  9, 19,  6, 12, 14, 39, 32, 14, 19, 39, 45,
 35,  6, 53, 54, 16,212,212,236,196,212,236, 16,238, 17, 18, 57,
 17, 18, 57, 17, 57, 17, 18, 23, 57, 17, 18, 57, 57, 18, 57, 17,
 57, 49,  0, 47,228,254,238, 16,254,213,238, 18, 23, 57, 23, 57,
 48, 75, 83, 88,  7, 16,  5,237, 17, 23, 57,  7, 16,  5,237,  7,
 16, 14,237, 17, 23, 57,  7, 16, 14,237, 17, 23, 57, 89, 34,178,
  0, 18,  1,  1, 93, 64, 20,  5, 17,  0, 17,  5, 18,  0, 18,  4,
  4, 17,  0, 17,  0, 17,  4, 18,  0, 18,  5, 93,  0, 93,  1, 75,
176, 11, 84, 75,176, 12, 84, 91, 75,176, 13, 84, 91, 75,176, 14,
 84, 91, 75,176, 15, 84, 91, 75,176, 16, 84, 91, 75,176, 17, 84,
 91, 75,176, 18, 84, 91, 88,189,  0, 54,  0, 64,  0,  1,  0, 54,
  0, 54,255,192, 56, 17, 55, 56, 89,  1, 54, 36, 51, 50, 22, 21,
 20,  6,  7, 14,  1, 21, 20, 22, 31,  1, 30,  1, 21, 20,  4, 35,
 34, 38, 39, 55, 30,  1, 51, 50, 54, 53, 52, 38, 47,  1, 46,  1,
 53, 52, 54, 55, 62,  1, 53, 52, 38, 35, 34,  6,  7,  3, 35,  1,
 61, 38,  1,  9,197,174,217,  6,  6,162,200, 42, 48, 49,119, 82,
254,234,218, 76,140, 63, 31, 65,139, 71,124,154, 47, 78, 51, 97,
 67,212,173,  2,  2,113,100,133,160, 26,219,185,  4,113,197,222,
186,147, 25, 61, 37,  8,135, 97, 40, 72, 37, 39, 94,131, 80,172,
224, 25, 24,164, 29, 30,114, 91, 45, 78, 67, 43, 82,111, 67,126,
202, 37,  8, 20, 19, 78, 90,136,134,251,147,  0,  0,  4,  1, 27,
  0,  0,  6,229,  5,205,  0, 23,  0, 47,  0, 56,  0, 76,  0, 96,
 64, 54, 69, 66, 67, 63, 50,135, 72, 48,135, 57, 74, 67,136, 12,
 57,136,  0,135, 24,134, 12,135, 36, 72, 69, 51, 48,  4, 49, 66,
 60, 63, 57, 54, 73, 49, 50, 75, 54, 50, 67, 60, 48, 18, 47, 30,
 75, 48,  6, 47, 30, 49, 42, 77, 16,220,228,252,236, 16,254,253,
196,238, 16,238, 50, 17, 57, 57, 18, 57, 18, 23, 57, 49,  0, 47,
238,246,254,237, 16,237, 50, 16,238,214,238, 57, 18, 57, 57, 48,
  1, 34,  6,  7,  6,  6, 21, 20, 22, 23, 22, 22, 51, 50, 54, 55,
 54, 54, 53, 52, 38, 39, 38, 38, 39, 50,  4, 23, 22, 18, 21, 20,
  2,  7,  6,  4, 35, 34, 36, 39, 38,  2, 53, 52, 18, 55, 54, 36,
 19, 35, 17, 51, 50, 54, 53, 52, 38, 39, 50, 22, 21, 20,  6,  7,
 22, 22, 23, 23, 35, 39, 38, 38, 35, 35, 17, 35, 17,  4,  0,131,
226, 94, 94, 96, 96, 94, 94,226,131,132,227, 94, 93, 93, 94, 92,
 94,227,132,152,  1,  7,109,109,108,108,109,109,254,249,152,152,
254,249,109,109,108,108,109,109,  1,  7,125,123,123,110, 87, 88,
102,176,174,105, 96, 24, 67, 46,137,172,129, 59, 73, 54, 66,155,
  5,102, 94, 94, 94,229,130,129,227, 94, 94, 95, 95, 94, 93,226,
131,133,227, 93, 94, 94,103,110,109,109,254,250,154,152,254,251,
109,109,110,110,109,109,  1,  5,152,154,  1,  6,109,109,110,254,
 98,254,236, 62, 75, 76, 63,103,119,121, 86,112, 17,  8, 77, 73,
223,209, 96, 51,254,156,  3, 68,  0,  3,  1, 27,  0,  0,  6,229,
  5,205,  0, 23,  0, 47,  0, 73,  0, 67, 64, 38, 61,137, 62, 58,
138, 65,136, 36, 49,137, 48, 52,138, 71,136, 24,135,  0,134, 36,
135, 12, 55, 51, 68, 61, 48, 48, 42, 47,  6, 68, 48, 30, 47,  6,
 18, 74, 16,220,204,252,236, 16,254,237, 50, 16,238, 49,  0, 47,
238,246,254,253,238,214,238, 16,253,238,214,238, 48,  1, 50,  4,
 23, 22, 18, 21, 20,  2,  7,  6,  4, 35, 34, 36, 39, 38,  2, 53,
 52, 18, 55, 54, 36, 23, 34,  6,  7,  6,  6, 21, 20, 22, 23, 22,
 22, 51, 50, 54, 55, 54, 54, 53, 52, 38, 39, 38, 38, 23, 21, 38,
 38, 35, 34,  6, 21, 20, 22, 51, 50, 54, 55, 21,  6,  6, 35, 34,
 38, 53, 52, 54, 51, 50, 22,  4,  0,152,  1,  7,109,109,108,108,
109,109,254,249,152,152,254,249,109,109,108,108,109,109,  1,  7,
152,131,226, 94, 94, 96, 96, 94, 94,226,131,132,227, 94, 93, 93,
 94, 92, 94,227,167, 66,130, 66,149,167,171,155, 64,122, 66, 67,
137, 70,216,251,251,216, 73,136,  5,205,110,109,109,254,250,154,
152,254,251,109,109,110,110,109,109,  1,  5,152,154,  1,  6,109,
109,110,103, 94, 94, 94,229,130,129,227, 94, 94, 95, 95, 94, 93,
226,131,133,227, 93, 94, 94,245,129, 33, 32,175,157,159,174, 31,
 34,127, 29, 28,244,208,209,242, 28,  0,  0,  2,  1, 39,  3,147,
  6, 70,  5,213,  0, 12,  0, 20,  0, 62, 64, 33,  1,  6,  7, 16,
 10,  4, 18, 14,  9,  3,  6,135, 13,  2,  0, 70, 21,  1,  9,  5,
 52,  3,  9, 52, 11, 13, 53, 15, 52, 19, 53, 17, 21, 16,212,228,
252,228,212,236,212,236, 17, 57, 49,  0, 16,244, 60, 60,236, 23,
 50,212, 60, 60,196, 17, 57, 48,  1, 19, 19, 51, 17, 35, 17,  3,
 35,  3, 17, 35, 17, 35, 21, 35, 17, 35, 17, 35, 53,  4, 74,174,
164,170,113,195, 55,203,114,113,203,114,201,  5,213,255,  0,  1,
  0,253,190,  1,228,254,209,  1, 47,254, 28,  2, 66, 94,254, 28,
  1,228, 94,  0,  0,  1,  2,  4,  4,238,  4, 45,  6,102,  0,  3,
  0,133,181,  2,  0,  4,  1,  3,  4, 16,212,204, 49,  0, 16,212,
204, 48,  0, 75,176,  9, 84, 75,176, 14, 84, 91, 88,189,  0,  4,
255,192,  0,  1,  0,  4,  0,  4,  0, 64, 56, 17, 55, 56, 89,  1,
 75,176,  9, 84, 75,176, 14, 84, 91, 75,176, 13, 84, 91, 75,176,
 15, 84, 91, 75,176, 16, 84, 91, 88,189,  0,  4,  0, 64,  0,  1,
  0,  4,  0,  4,255,192, 56, 17, 55, 56, 89,  1, 75,176, 10, 84,
 88,189,  0,  4,  0,128,  0,  1,  0,  4,  0,  4,255,128, 56, 17,
 55, 56, 89, 64, 17, 86,  1, 86,  2,133,  0,133,  3,149,  0,149,
  3,165,  0,165,  3,  8, 93,  1, 51,  1, 35,  3,102,199,254,113,
154,  6,102,254,136,  0,  0,  2,  1,121,  5, 70,  3,242,  6, 16,
  0,  3,  0,  7,  0,154, 64, 19,  6,  2,139,  4,  0,  8,  6,  4,
  7,  5,  2,  0,  3,  1,  5,  7,  1,  3,  8, 16,212,220,212,204,
 17, 18, 57, 57, 17, 18, 57, 57, 49,  0, 16,212, 60,236, 50, 48,
  1, 75,176,  9, 84, 75,176, 10, 84, 91, 75,176, 14, 84, 91, 75,
176, 16, 84, 91, 75,176, 15, 84, 91, 88,189,  0,  8,  0, 64,  0,
  1,  0,  8,  0,  8,255,192, 56, 17, 55, 56, 89,  0, 75,176, 10,
 84, 75,176, 13, 84, 91, 88,189,  0,  8,  0, 64,  0,  1,  0,  8,
  0,  8,255,192, 56, 17, 55, 56, 89, 64, 34, 64,  1, 64,  2, 64,
  5, 64,  6, 81,  1, 81,  2, 81,  5, 81,  6,  8, 79,  0, 79,  1,
 79,  4, 79,  5, 80,  2, 80,  3, 80,  6, 80,  7,  8, 93,  1, 93,
  1, 51,  7, 35, 37, 51,  7, 35,  1,160,205, 41,203,  1,174,203,
 39,203,  6, 16,202,202,202,  0,  0,  1,  0,217,  0, 39,  5,219,
  4,221,  0, 19,  0, 62, 64, 34, 13, 12, 10,  3,  2,140,  4,  0,
 96,  6, 12,140, 14, 10, 96, 18,  6, 16,  8, 20, 18, 14, 13, 12,
  8,  4,  3,  2,  8,  9,  5, 15,  0, 20, 16,220, 60,196, 50, 23,
 57, 49,  0, 16,212, 60,204, 50,252, 60,236, 16,254, 60,236, 57,
 17, 18, 57, 48, 19, 33,  1, 23,  7, 33, 21, 33,  7, 33, 21, 33,
  1, 39, 55, 33, 53, 33, 55, 33,217,  3,  4,  1,  0,125,174,  1,
 47,254, 72,195,  2,123,252,250,254,254,125,174,254,213,  1,182,
195,253,135,  3,162,  1, 59,102,213,168,240,170,254,199,102,211,
170,240,  0,  2,255,164,  0,  0,  7,244,  5,213,  0,  3,  0, 19,
  0,187, 64, 76, 11,  5, 14,  3, 14, 10,  5,  3, 14,  7,  5,  3,
 14,  6,  5,  3,  3, 14,  1,  5, 18, 19, 18,  0,  5, 19, 19, 18,
 17,  5, 19, 18, 16,  5, 18, 19, 18, 58,  9, 90,  7, 15, 90,  1,
  0, 90,  5, 90,  4, 70, 11, 90,  1,  7,115, 17, 13, 15, 14, 13,
 12, 11, 10,  9,  8,  7,  6,  5,  3,  2,  1, 14, 20,  4, 18, 20,
 16,212,196, 17, 23, 57, 49,  0, 47, 60,236,196,236,244,236,236,
 16,238, 16,238, 48, 75, 83, 88,  7, 16,  5,237,  7,  5,237,  7,
 16,  5,237,  7, 16,  5,237,  7, 16,  5,237,  7,  5,237,  7,  5,
237,  7, 16,  5,237, 89, 34,178,  7,  1,  1,  1, 93, 64, 45,  6,
  0,  9,  3, 10,  6,  9,  7, 22,  0, 71,  0, 73,  3, 73,  6, 73,
 15, 71, 17, 87, 17, 88, 19,103,  0,102,  1,119,  1,117, 16,119,
 17,119, 18,121, 19,134,  0,134,  1,134, 16, 22, 93,  9,  1, 33,
 19, 37,  7, 33,  3, 33,  7, 33,  3, 33,  7, 33, 19, 33,  3, 35,
  1,  3,164,254, 29,  1,202,154,  3,207, 33,253, 27, 88,  2,200,
 33,253, 56,105,  2,248, 33,252, 62, 73,253,242,235,205,  3,147,
  5, 55,252,240,  3, 16,158,170,254, 70,170,253,227,170,  1,127,
254,129,  5,213,  0,  3,255,186,255,190,  6,121,  6, 23,  0, 12,
  0, 25,  0, 55,  1,  4, 64, 66, 55, 56, 17, 40, 38, 35, 14, 13,
 12,  0,  4, 41, 53, 26,  3, 17,  3, 54, 50, 39, 35, 17, 90, 50,
  3, 90, 35, 86, 50, 81, 56, 39, 44, 40, 54, 56, 29, 41, 44, 23,
 26, 29, 14, 13, 12,  0,  4,  9, 38, 44, 23, 53, 29,  9, 40, 44,
 55, 23, 28, 44, 32,  9, 28, 29, 13, 56, 16,244,236,244,236, 46,
 16,192, 17, 18, 57, 17, 18, 57, 18, 23, 57, 17, 57, 17, 18, 57,
 17, 18, 57, 17, 18, 57, 49,  0, 16,228,244,236, 16,238, 16,192,
 16,192, 17, 18, 23, 57, 23, 57, 18, 57, 57, 17, 18, 57, 48, 64,
 28,  6,  0, 22,  0, 36, 55, 55, 53, 52, 55, 48, 57,  6,  9, 38,
  5, 53, 26, 38, 21, 53, 39, 12, 41, 55, 54, 53,  7, 93,  1, 93,
  1, 75,176, 13, 84, 75,176, 14, 84, 91, 75,176, 15, 84, 91, 75,
176, 16, 84, 91, 88,189,  0, 56,255,192,  0,  1,  0, 56,  0, 56,
  0, 64, 56, 17, 55, 56, 89, 64, 62, 73,  0, 74, 13, 74, 55, 89,
  0, 90, 13,100, 12,106, 13,103, 14,117, 12,123, 13,119, 14,133,
 26,137, 41,152,  0,150, 13,151, 14, 16, 68, 54, 67, 55, 87,  0,
 83, 54, 83, 55, 96, 54, 96, 55,119, 13,113, 54,113, 55,133, 54,
133, 55,148, 54,148, 55, 14, 93,  0, 93,  1, 46,  1, 35, 34,  6,
  7, 14,  1, 21, 20, 22, 23,  9,  1, 30,  1, 51, 50, 36, 55, 62,
  1, 53, 52, 38,  1, 46,  1, 53, 52, 18, 55, 54, 36, 51, 50, 22,
 23, 55, 23,  7, 30,  1, 21, 20,  2,  7,  6,  4, 35, 34, 38, 39,
  7, 39,  4,199, 45,146, 98,165,255, 92, 62, 65, 12, 12,  3,201,
252,117, 51,147, 99,164,  1,  1, 91, 62, 63, 13,251,138, 39, 39,
122,109,125,  1, 57,189,130,210, 84,203, 90,209, 40, 40,118,112,
128,254,203,189,139,217, 76,220, 90,  4,211, 60, 61,162,162,109,
238,114, 45, 87, 44,  2,209,252,178, 68, 67,163,161,112,235,122,
 56, 93,252,193, 80,164, 85,166,  1, 80,135,154,154, 77, 77,193,
 99,198, 73,169, 98,177,254,181,135,156,152, 84, 82,203, 99,  0,
  0,  3,  0,221,  0,221,  5,207,  3,238,  0, 11,  0, 23,  0, 47,
  0, 60, 64, 29, 45, 27, 21,  9, 33,  3,  0, 36, 24,  4, 21, 15,
 39, 33, 21, 27, 15, 33, 48, 12,  0, 36, 24, 18,  6, 42, 18, 30,
 48, 16,212,196,212,196, 17, 57, 57, 57, 57, 49,  0, 16,212,196,
212,196, 16,192, 17, 18, 23, 57, 18, 57, 17, 18, 57, 48,  1, 22,
 22, 51, 50, 54, 53, 52, 38, 35, 34,  6,  7, 38, 38, 35, 34,  6,
 21, 20, 22, 51, 50, 54, 23,  6,  6, 35, 34, 38, 53, 52, 54, 51,
 50, 22, 23, 54, 54, 51, 50, 22, 21, 20,  6, 35, 34, 38,  3,147,
 49,134, 84,101,128,118, 89, 82,133,196, 49,133, 85,102,127,118,
 89, 82,134,144, 70,157, 94,136,186,167,134, 95,153, 72, 68,158,
 97,134,188,167,134, 94,149,  2, 47, 88, 90,135,105,101,134,135,
 55, 88, 88,132,106,101,134,136, 22,135,127,223,166,175,216,126,
138,138,131,225,167,175,214,119,  0,  2,  0,217,  0,  0,  5,219,
  5,  4,  0, 11,  0, 15,  0, 46, 64, 24,  5,141,  7,  3, 96,  0,
141,  9,  1, 12, 96, 14, 13,  2, 16,  4,  0, 18, 12,  8, 16, 10,
  6, 16, 16,212, 60,236, 50,252, 60,236, 50, 49,  0, 47,236,212,
 60,236,252, 60,236, 48,  1, 17, 33, 21, 33, 17, 35, 17, 33, 53,
 33, 17,  1, 33, 21, 33,  3,174,  2, 45,253,211,168,253,211,  2,
 45,253,211,  5,  2,250,254,  5,  4,254,125,170,254,125,  1,131,
170,  1,131,251,166,170,  0,  2,  0,217,  0,  0,  5,219,  4,168,
  0,  6,  0, 10,  0, 84, 64, 46,  2, 96,  3,  4,  3,  1, 96,  0,
  1,  4,  4,  3,  1, 96,  2,  1,  5,  6,  5,  0, 96,  6,  5, 58,
  5,  4,  2,  1,  0,  5,  3,142,  6,109,  7, 96,  9,  1,  8,  2,
  0, 21,  7,  4, 20, 11, 16,252, 60,236, 50, 50, 57, 49,  0, 47,
236,244,236, 23, 57, 48, 75, 83, 88,  7,  4,237,  7, 16,  8,237,
  7, 16,  8,237,  7, 16,  4,237, 89, 34,  9,  2, 21,  1, 53,  1,
  1, 33, 21, 33,  5,219,252, 64,  3,192,250,254,  5,  2,250,254,
  5,  2,250,254,  3,248,254,235,254,238,178,  1,112,170,  1,111,
252,  2,170,  0,  0,  2,  0,217,  0,  0,  5,219,  4,168,  0,  6,
  0, 10,  0, 86, 64, 47,  6, 96,  0,  6,  3,  4,  3,  5, 96,  4,
  4,  3,  0, 96,  1,  2,  1,  6, 96,  5,  6,  2,  2,  1, 58,  6,
  5,  3,  2,  0,  5,  4,142,  1,109,  7, 96,  8,  6,  7,  2, 21,
  9,  4,  0, 20, 11, 16,252, 60, 60,236, 50, 57, 49,  0, 47,236,
244,236, 23, 57, 48, 75, 83, 88,  7, 16,  8,237,  7, 16,  4,237,
  7, 16,  4,237,  7, 16,  8,237, 89, 34, 19, 53,  1, 21,  1, 53,
  1,  1, 21, 33, 53,217,  5,  2,250,254,  3,193,  1, 65,250,254,
  3,248,176,254,145,170,254,144,178,  1, 18,253,199,170,170,  0,
  0,  1,  0, 92,  0,  0,  5, 98,  5,213,  0, 24,  0,229, 64, 93,
 16,  5, 17, 22, 17, 15,  5, 14, 15, 22, 22, 17, 15,  5, 16, 15,
  8, 13,  8, 14,  5, 13, 13,  8,  2,  5,  3,  8,  3,  1,  5,  8,
  3, 23,  5,  8,  3, 22,  5, 21, 22,  8,  8,  3, 58, 15, 11,  9,
  4,  0,144, 23,  6, 18, 11,144, 20,  9, 16, 13, 70,  2, 24, 23,
 20, 19, 18, 15,  0,  2,  1,  9, 17,  8,  6, 13,  5, 11, 10,  5,
 25, 14, 12,  9,  7,  4,  5,  3, 17,  8,  8,  3, 25, 16,212,196,
 16,192, 18, 23, 57, 17, 23, 57, 17, 18, 23, 57, 49,  0, 47,228,
 50,212, 60,236, 50,212, 60,236, 50, 17, 18, 57, 48, 75, 83, 88,
  7, 16,  8,237,  7,  5,237,  7,  5,237,  7, 16,  5,237,  7, 16,
  5,237,  7, 16,  8,237,  7, 16,  8,237,  7, 16,  5,237, 89, 34,
178, 24, 16,  1,  1, 93, 64, 56, 21, 15, 53, 15, 69, 15, 83, 15,
119, 16,119, 17,128, 15,  7, 10, 16, 10, 17, 25, 16, 38,  1, 38,
  4, 38, 18, 58, 16, 58, 17, 71, 14, 70, 21, 87, 16, 85, 17, 84,
 21, 96, 16, 96, 17,118, 13,118, 14,117, 16,117, 17,138, 16, 20,
 93,  0, 93,  1, 33,  3, 35, 19, 33, 55, 33, 55, 39, 33, 55, 33,
  3, 51, 19,  1, 51,  1, 33,  7, 33, 15,  1, 33,  4, 98,254,101,
 88,203, 88,254, 96, 23,  1,161, 11, 54,254,179, 24,  1, 10,204,
190,240,  2,  0,194,254, 82,  1,  6, 24,254,184,113, 10,  1,154,
  1,199,254, 57,  1,199,123, 51,155,123,  2, 74,253, 68,  2,188,
253,182,123,155, 51,  0,  0,  1,255,229,254, 86,  4,188,  4, 96,
  0, 38,  0,154, 64, 88, 13,  5, 14, 15, 14, 10, 11,  2,  9, 12,
  5, 15, 15, 14, 38,  5,  1,  0, 35, 36,  2, 34, 37,  5,  0,  1,
  0,  8,  7,  6,  5,  4,  5,  9,  3,  5,  1,  0,  2,  5,  1,  1,
  0, 58, 24, 21, 15, 12,  3,  5,  1, 25, 31, 37,  3,  9, 76, 34,
 28, 81,  0,127, 13,  1,126, 39, 38, 39, 25, 24, 18, 15, 13, 12,
  6,  3,  2,  9, 14, 37,  0, 31, 14,  1,  1, 37,  0, 39, 16,212,
228, 16,192,192, 18, 57, 18, 23, 57, 18, 57, 49,  0, 16,228, 50,
228,244, 60,236, 23, 57, 17, 23, 57, 48, 75, 83, 88,  7, 16,  5,
237,  7,  5,237, 17, 23, 57,  7, 16,  5,237, 17, 23, 57,  7,  5,
237,  7, 16,  5,237, 17, 23, 57,  7, 16,  5,237, 89, 34,  3,  1,
 51,  3,  6,  6, 21, 20, 22, 51, 50, 54, 55, 19, 51,  3,  6,  6,
 21, 20, 22, 51, 50, 54, 55,  7,  6,  6, 35, 34, 38, 53,  6,  6,
 35, 34, 38, 39,  3, 27,  1, 45,185,136,  4,  6,117,109,148,182,
 32,127,184,167,  4,  3, 25, 27, 10, 35, 32, 28, 44, 80, 38, 66,
 75, 56,155,105, 93,139, 22,108,254, 86,  6, 10,253, 71, 21, 52,
 26, 93,100,168,168,  2,141,252,163, 19, 28, 11, 31, 29, 10, 13,
148, 22, 23, 84, 74, 80, 78, 86, 70,253,215,  0,  0,  2,  0,104,
255,231,  3,193,  5, 45,  0, 29,  0, 41,  0, 54, 64, 25,  0, 39,
 33,  9, 27,  6, 39, 21,  6, 15, 33, 27, 15, 21,146, 42, 12, 36,
  3,  0, 30, 18, 36, 24, 42, 16,212,204,220,204, 57, 57, 17, 57,
 49,  0, 16,228,204,220,204, 16,206, 16,206, 17, 18, 57, 17, 18,
 57, 48,  1, 54, 54, 53, 52, 38, 35, 34,  6, 35, 34, 38, 53, 52,
 54, 51, 50, 18, 17, 16,  0, 35, 34, 38, 53, 52, 18, 51, 50, 22,
  7, 52, 38, 35, 34,  2, 21, 20, 22, 51, 50, 18,  2,244, 15, 15,
 73, 72, 55,144, 36, 36, 48,144,101,180,214,254,223,213,152,203,
221,162,101,130, 11, 87, 79,109,141, 86, 80,109,141,  2,109, 87,
163, 75,129,131,116, 44, 31, 62, 98,254,202,254,249,254,177,254,
 70,216,163,198,  1,  1, 91,224,116,125,254,254,207,116,123,  1,
  4,  0,  0,  1,  0, 25,254,119,  5, 59,  5,193,  0, 11,  0, 91,
 64, 20, 10,  4, 12,  2,  5,  7,  2,  0,  7, 12, 10,  5,  4,  3,
  1,  0,  6,  6,  8, 12, 16,212,196, 23, 57, 49,  0, 16,196,212,
204, 16,206, 17, 18, 57, 57, 48, 64, 46, 85,  3, 80,  3, 81,  4,
 86,  5, 80,  5, 98,  3, 96,  3,103,  4, 96,  4,101,  5, 96,  5,
116,  3,112,  3,112,  4,117,  5,112,  5,120, 10, 17, 86, 11,127,
  2,127,  3,112,  5,112,  6,  5, 93,  1, 93, 19, 33, 21, 33,  9,
  1, 33, 21, 33, 53,  9,  1, 55,  4,234,252, 65,  2,160,253, 74,
  3,239,250,222,  2,213,253, 73,  5,193,193,253, 51,253,  4,192,
149,  3, 33,  2,227,  0,  0,  1,  0,156,254,119,  5,113,  5,193,
  0,  7,  0, 30, 64, 15,  6,  2,149,  4,148,  0,147,  8,  3, 55,
  1,  5, 55,  0,  8, 16,212,236,212,236, 49,  0, 16,252,236,236,
 50, 48, 19, 33, 17, 35, 17, 33, 17, 35,156,  4,213,240,253, 10,
239,  5,193,248,182,  6,125,249,131,  0,  0,  1,255,225,255,240,
  4,170,  4, 47,  0, 35,  0,105, 64, 49, 11,  2, 21, 31, 30,  3,
  0,  8,152, 15, 26, 22,  0,151, 34,150, 15,146, 24, 12, 30, 27,
 26, 25, 24, 23,  6, 36, 18,  1,  0, 11,  2,  4, 35, 22, 21,  5,
 34, 31, 18, 12, 35, 18, 56,  5, 35, 31, 36, 16,212,212,212,236,
 18, 57, 17, 18, 57, 18, 57, 57, 17, 23, 57, 17, 18, 23, 57, 49,
  0, 47, 60,228,244,236, 50, 50, 16,238, 17, 23, 57, 57, 57, 48,
 64, 12, 26, 24, 26, 25,  2, 27, 29, 27, 30, 27, 31,  3, 93,  1,
 93,  1, 35,  3, 14,  1, 21, 20, 22, 51, 50, 54, 55,  7, 14,  1,
 35, 34, 38, 53, 52, 54, 55, 19, 33,  3, 35, 19, 35, 34,  6,  7,
 35, 62,  1, 51, 33,  4,135,182,105, 15, 15, 47, 55, 17, 46, 37,
 30, 30, 55, 26,118,121, 21, 34, 80,254,186,194,181,195, 41, 54,
 60,  9,160, 28,143,165,  3,121,  3,145,254, 25, 74, 92, 22, 58,
 49,  5,  5,141,  8,  8,102,100, 46,144,161,  1,120,252,111,  3,
145, 64, 69,166,125,  0,  0,  1,  0, 47,254,141,  3,250,  6, 14,
  0, 37,  0, 38, 64, 20, 32,153,  0, 26, 13,153, 19, 26,154,  7,
128, 38, 10, 57, 23, 58, 29, 57,  4, 38, 16,220,236,252,236, 49,
  0, 16,252,236,220,228, 16,222,228, 48,  1, 50, 19, 54, 55, 18,
 18, 51, 50, 22, 21, 20,  6, 35, 34, 38, 39, 38, 38, 35, 34,  3,
  6,  7,  2,  2, 35, 34, 38, 53, 52, 54, 51, 50, 22, 23, 22, 22,
  1, 55,106, 14,  2,  1, 12,190,202, 80,100, 64, 55, 42, 56, 12,
  6,  9, 16,107, 14,  4,  4, 17,189,196, 79,101, 68, 61, 33, 48,
 15, 10, 10,254,250,  2,176,108, 57,  2,  3,  1,188, 84, 65, 54,
 63, 38, 35, 15, 72,253,149,193,110,254, 33,254, 98, 83, 65, 56,
 63, 29, 28, 18, 83,  0,  0,  3,  0, 82,  1,213,  3,145,  5,240,
  0, 10,  0, 43,  0, 47,  0,114, 64, 64,  9,  6,  0, 25, 34, 11,
 23, 14,  6,  0,156, 23, 46,156, 44, 35,158, 34,157, 31, 12,  6,
156, 44, 23, 17,155, 31,156, 38, 86, 48, 12, 46, 45, 11,  4, 41,
 28, 47, 44, 48, 20, 24, 13, 10,  9,  0,  5, 14, 23, 35,  3, 28,
 34, 20,  3, 28, 59, 41,  3, 59, 20, 48, 16,212,236,212,236, 17,
 18, 57, 18, 23, 57, 23, 57, 17, 18, 57, 57, 17, 18, 23, 57, 49,
  0, 16,244,236,252,196,204,236,196, 16,244,238, 16,238, 16,238,
 17, 57, 17, 57, 18, 57, 17, 18, 57, 48,  1, 34,  6, 21, 20, 22,
 51, 50, 54, 63,  2,  3, 35, 55,  6,  6, 35, 34, 38, 53, 52, 54,
 51, 51, 53, 54, 54, 53, 52, 38, 35, 34,  6,  7, 55, 54, 54, 51,
 50, 22, 21, 20,  6,  1, 33,  7, 33,  2, 82,157,142, 76, 65,115,
157, 27,  6,162, 88,149, 22, 58,153, 96,107,131,231,208,182,  2,
  2, 93,100, 70,145, 73, 24, 79,152, 68,150,153,  5,252,220,  2,
177, 23,253, 80,  4, 80, 75, 83, 59, 70,135,123, 29, 61,254, 64,
112, 65, 66,122,100,140,159,  4, 19, 21,  7, 70, 65, 34, 34,127,
 28, 28,124,120, 27, 55,253,166,123,  0,  0,  3,  0, 82,  1,213,
  3,178,  5,240,  0, 11,  0, 26,  0, 30,  0, 52, 64, 27, 29,156,
 27,  9,156, 18,155,  3,156, 12, 86, 31, 30, 27, 31, 21, 28, 15,
 29,  6,  0, 59, 15,  6, 59, 21, 31, 16,212,236,212,236, 17, 57,
 17, 57, 17, 18, 57, 57, 49,  0, 16,244,236,252,236,220,236, 48,
  1, 52, 38, 35, 34,  6, 21, 20, 22, 51, 50, 54,  3, 50, 22, 21,
 20,  0, 35, 34, 38, 53, 52, 54, 55, 54, 54,  1, 33,  7, 33,  3,
 20, 99, 97,116,169, 99, 92,122,168,167,148,177,254,246,203,150,
175, 38, 37, 62,208,254,119,  2,177, 23,253, 80,  4,156,110,115,
214,151,109,118,211,  1,240,172,144,220,254,226,180,154, 68,133,
 63,106,118,252, 96,123,  0,  1,  0, 78,  0,  0,  5,207,  5,231,
  0, 31,  0, 64, 64, 34,  9,160, 25, 86, 18, 15,  3,  3,  0,160,
 16,  1, 17, 32, 22, 19, 15, 12, 31,  6,  2,  1,  0,  2, 61,  6,
 60, 28, 15, 61, 12, 60, 22, 32, 16,212,236,236,212,236,236,192,
192, 17, 18, 57, 17, 18, 57, 17, 18, 57, 49,  0, 47, 60,236, 23,
 50,244,236, 48, 37, 21, 33, 53, 54, 18, 53, 52,  0, 35, 34,  0,
 21, 20, 18, 23, 21, 33, 53, 33, 38,  2, 53, 16,  0, 33, 32,  0,
 17, 20,  2,  7,  5,207,253,168,177,198,254,248,216,216,254,247,
199,178,253,168,  1, 63,158,145,  1,127,  1, 49,  1, 47,  1,129,
142,161,178,178,178, 97,  1, 76,202,240,  1, 34,254,221,239,202,
254,180, 97,178,178,139,  1, 42,184,  1, 62,  1,138,254,119,254,
203,194,254,216,141,  0,  0,  3,  0, 84,255,227,  7,156,  4,123,
  0,  9,  0, 62,  0, 73,  1, 23, 64, 84, 53, 62, 51, 42, 35, 32,
 73, 63, 25, 16, 62,  6, 63,111, 51,  0,111, 25, 36, 75, 35, 78,
 70, 32, 76, 39, 10, 75, 62,123, 59,  6, 76, 25,124, 19, 13,122,
 45, 39, 81, 51, 74, 73, 64, 67, 53, 52, 26,  3, 63,  9, 25, 22,
  0,  9,  3, 62, 51, 10,  3, 67, 56, 29, 16, 42,  4, 63,  9, 35,
 36, 22,  3,  9, 14, 63,  3,  5, 22, 67, 14, 48, 34, 74, 16,244,
236,212,236,212,236, 17, 18, 57, 57, 17, 18, 23, 57, 17, 23, 57,
 17, 18, 57, 18, 57, 17, 18, 23, 57, 17, 57, 57, 49,  0, 16,196,
228, 50,244, 60,228,252, 60,244,236, 16,254, 60,244,238, 16,238,
 16,238, 17, 18, 57, 17, 18, 57, 17, 18, 57, 17, 18, 57, 48, 64,
 50, 59, 10, 59, 11, 75, 10, 75, 11, 92, 10, 92, 11,107, 10,107,
 11,123, 10,123, 11,139, 10,139, 11, 12, 51, 61, 48, 62, 68, 61,
 64, 62, 84, 61, 80, 62, 99, 61, 96, 62,116, 61,112, 62,131, 61,
128, 62, 12, 93,  1, 93,  1, 75,176, 18, 84, 88,189,  0, 74,255,
192,  0,  1,  0, 74,  0, 74,  0, 64, 56, 17, 55, 56, 89, 64, 44,
111,  0,111,  1,111,  2,111,  3,108,  8,111,  9,111, 22,111, 23,
111, 24,111, 25,111, 26,165, 49,160, 50,160, 51,160, 52,160, 63,
160, 64,160, 65,165, 66, 19,150, 34,153, 35,  2, 93,  0, 93,  1,
 62,  1, 53, 52, 38, 35, 34,  6,  7,  1, 62,  1, 51, 50, 22, 23,
 62,  1, 51, 50, 22, 21, 20,  6,  7, 33, 14,  1, 21, 20, 22, 51,
 50, 54, 55,  7, 14,  1, 35, 34, 38, 39, 14,  1, 35, 34, 38, 53,
 52, 36, 41,  1, 55, 62,  1, 53, 52, 38, 35, 34,  6,  7,  1, 35,
 34,  6, 21, 20, 22, 51, 50, 54, 55,  6,227,  3,  3,142,124,137,
210, 54,252,241,104,199, 93,144,186, 45, 86,224,132,190,226, 13,
 12,252,168,  6,  4,171,156,120,215, 91, 34,100,211,109,168,227,
 56,102,220,132,174,193,  1, 57,  1, 19,  1,  0, 10,  2,  2,145,
131, 90,189,100,  2,102,184,226,217,111, 98,150,224, 36,  2,148,
 16, 34, 17,122,142,173,159,  1,154, 39, 39, 90, 92, 90, 92,228,
192, 46,105, 60, 38, 44, 16,139,152, 54, 52,182, 40, 40,115,113,
118,110,164,148,196,228, 49,  8, 19, 20, 89, 99, 46, 46,254,176,
121,127, 88,100,215,180,  0,  3,255,227,255,162,  4,250,  4,184,
  0,  9,  0, 39,  0, 49,  0,233, 64, 66, 39, 50, 34, 41, 40,  9,
  0,  4, 44, 24, 22, 19,  3, 37, 34, 25, 10, 44,  3, 38, 34, 23,
 19, 44, 76, 34,  3, 76, 19,122, 34, 81, 50, 25, 47, 23, 28, 24,
 38, 50, 13, 41, 40,  0,  9,  4, 47, 10, 13,  6, 22, 47, 28, 37,
 13,  6, 24, 47, 14, 28,  6, 14, 39, 13, 34, 50, 16,244,196,236,
212,236,192, 17, 18, 57, 17, 18, 57, 17, 18, 57, 18, 23, 57, 17,
 18, 57, 17, 18, 57, 17, 57, 49,  0, 16,228,244,236, 16,238, 16,
192, 16,192, 17, 18, 57, 57, 17, 57, 17, 18, 57, 57, 18, 23, 57,
 17, 18, 57, 48, 64, 68, 74, 10, 72, 11, 69, 25, 71, 26, 86, 37,
 85, 38, 88, 41,107, 23,107, 24,103, 37, 98, 38,102, 39,115, 38,
119, 39,112, 51,134, 25, 16, 73, 10, 73, 11, 70, 25, 70, 26, 85,
  9, 86, 22, 87, 23, 87, 24, 89, 40,102, 22,104, 37,117,  0,118,
 22,120, 37,121, 38,121, 39,121, 41, 17, 93,  1, 93,  1, 75,176,
 18, 84, 88,189,  0, 50,255,192,  0,  1,  0, 50,  0, 50,  0, 64,
 56, 17, 55, 56, 89,183,149,  9,153, 40,  2,152, 41,  1, 93,  0,
 93,  1, 46,  1, 35, 34,  2, 21, 20, 22, 23,  7, 46,  1, 53, 52,
 54, 55, 62,  1, 51, 50, 22, 23, 55, 23,  7, 30,  1, 21, 20,  2,
  7, 14,  1, 35, 34, 38, 39,  7, 39,  9,  1, 30,  1, 51, 50, 18,
 17, 52, 38,  3,133, 37, 93, 58,186,240,  3,  5,141, 30, 30, 79,
 63, 98,243,156, 87,148, 58,162, 86,172, 28, 29, 79, 62, 97,243,
158, 87,147, 57,172, 86,  3,222,253,159, 39, 91, 59,189,239,  4,
  3,154, 35, 34,254,191,250, 47, 41, 17,143, 49,126, 75,122,255,
 86,134,128, 52, 51,164, 86,172, 55,125, 68,124,254,253, 86,134,
128, 53, 52,170, 84,  3, 51,253,158, 37, 35,  1, 71,  1,  7, 39,
 38,  0,  0,  2,  0, 76,255,229,  3,102,  5,213,  0,  3,  0, 33,
  0,189, 64, 73, 18,  5, 19, 20, 19, 11, 12, 13, 14, 15, 16,  6,
 10, 17,  5, 20, 20, 19,  1,  5,  2,  3,  2,  0,  5,  3,  3,  2,
 58, 23, 20, 17, 14,  4, 13, 24, 33, 18,  0, 72,  1,  4, 75, 33,
 78, 30, 90,  7, 81,  1, 70, 34, 24, 23, 20, 19, 18, 17, 14,  1,
  0,  9, 13, 27,  4,  3,  2, 33, 27,  5, 10, 36, 34, 16,244,236,
212,212,196, 57, 17, 57, 23, 57, 49,  0, 16,228,244,252,244,236,
 16,254,204, 17, 57, 57, 23, 57, 48, 75, 83, 88,  7, 16,  5,237,
  7, 16,  5,237,  7, 16,  5,237, 17, 23, 57,  7, 16,  5,237, 89,
 34,  1, 75,176, 16, 84, 88,189,  0, 34,255,192,  0,  1,  0, 34,
  0, 34,  0, 64, 56, 17, 55, 56, 89, 64, 35,100, 16,100, 17,100,
 18,100, 19,100, 20,100, 21,100, 22,127,  0,127,  1,127,  2,127,
  3,122, 12,121, 13,122, 16,122, 17,122, 20,122, 21, 17, 93,  1,
 55, 51,  7, 19, 14,  1, 35, 34, 38, 53, 52, 54, 63,  1, 62,  1,
 63,  1, 51,  7, 14,  1, 15,  1, 14,  1, 21, 20, 22, 51, 50, 54,
 55,  2,100, 50,202, 49, 19,103,202,107,161,185,107,120,103, 85,
 57, 17, 25,190, 30, 19, 78,110,107, 84, 67,109, 95, 81,196,104,
  4,215,254,254,251,127, 57, 56,150,129,103,180, 98, 84, 68, 94,
 90,123,154, 94,131, 92, 89, 70,106, 57, 76, 86, 71, 66,  0,  2,
  0,174,  0,  0,  2,156,  5,213,  0,  5,  0,  9,  0,107, 64, 47,
  6,  5,  7,  8,  7,  9,  5,  8,  8,  7,  0,  5,  1,  2,  1,  3,
  4,  2,  2,  5,  5,  2,  2,  1, 58,  3,  6, 72,  8, 70,  0,  6,
  4,  9,  8,  3,  0,  7,  2,  9,  7,  0,  8,  2,  2,  1, 10, 16,
212,196,244,228,192, 17, 18, 57, 57, 17, 18, 57, 57, 49,  0, 47,
244,252,204, 48, 75, 83, 88,  7, 16,  5,237, 17, 23, 57,  7, 16,
  5,237,  7, 16,  5,237,  7, 16,  5,237, 89, 34,178,  7,  0,  1,
  1, 93,180,  7,  0, 22,  0,  2, 93, 33, 35, 27,  1, 51,  3, 19,
 35, 55, 51,  1,121,203,127, 90,162, 49,112,202, 49,205,  2,143,
  1,101,254,155,  2, 72,254,  0,  0,  1,  0,217,  1, 31,  5,219,
  3, 94,  0,  5,  0, 23, 64, 10,  4, 96,  2,  0,  6,  3, 18,  1,
  0,  6, 16,220,212,236, 49,  0, 16,212,196,236, 48, 19, 33, 17,
 35, 17, 33,217,  5,  2,168,251,166,  3, 94,253,193,  1,149,  0,
  0,  1,  0, 61,255,215,  5, 25,  6,125,  0, 10,  0, 42, 64, 24,
 10,  9,  8,  7,  6,  5, 11,  2,  4,  2,  0, 11, 10,  9,  7,  6,
  5,  4,  3,  0,  8,  1,  8, 11, 16,212,204, 23, 57, 49,  0, 16,
212,204,196, 17, 18, 23, 57, 48,  1, 51, 21, 35,  1, 35,  1,  7,
 39, 37,  1,  4, 92,189,115,253,174, 66,254,193,125, 25,  1, 27,
  1,  0,  6,125, 96,249,186,  3,115, 45, 80, 98,253, 59,  0,  1,
255,209,254, 86,  4,242,  6, 20,  0, 35,  0,142, 64, 80, 32, 31,
  2, 33, 30,  5, 12,  7, 29,  5, 12,  7, 26,  5,  7, 12,  7, 23,
 24,  2, 22, 25,  5, 12, 12,  7, 58, 25, 12, 19, 10,  7, 30,  8,
  1, 18, 77, 19,161, 22, 26, 10,111,  8, 22,111, 15,  1, 77,  0,
161,  4,111, 33, 92, 15,127, 28,  8, 36, 30, 29, 28, 27, 26, 11,
 10,  9,  8,  7,  1, 11, 36, 12, 25, 19,  3,  0, 18, 36, 16,212,
204, 23, 57, 17, 23, 57, 49,  0, 16,196, 50,228,252,236,244,236,
 16,238, 16,238, 50, 16,245,238, 17, 18, 57, 57, 17, 18, 57, 57,
 48, 75, 83, 88,  7, 16,  5,237, 17, 23, 57,  7, 16,  5,237,  7,
  5,237,  7,  5,237, 17, 23, 57, 89, 34,  1,  7, 38, 38, 35, 34,
  6,  7,  3, 33,  7, 33,  3,  2,  6, 35, 34, 38, 39, 55, 22, 22,
 51, 50, 54, 55, 19, 33, 55, 33, 19, 54, 54, 51, 50, 22,  4,242,
 31, 38, 80, 44, 96,114, 25, 60,  1, 62, 31,254,195,127, 57,186,
173, 74,123, 55, 31, 52, 97, 47, 97,109, 34,137,254,234, 30,  1,
 23, 63, 37,202,169, 46, 99,  5,229,153, 29, 28,122,132,254,201,
143,253,133,254,233,217, 25, 26,158, 33, 33,137,166,  2,173,143,
  1, 74,191,187, 22,  0,  0,  2,  0,217,  1, 16,  5,219,  3,244,
  0, 29,  0, 59,  0, 63, 64, 31, 46, 31, 57, 42,  0, 45, 34, 19,
  1, 16, 27, 12, 30, 42, 96, 49, 57, 96, 34,  4, 96, 27, 12, 96,
 19, 60, 30,  0, 45, 15, 60, 16,212, 60,196, 50, 49,  0, 16,212,
236,212,236,220,252,212,236,192, 17, 18, 57, 57, 17, 18, 57, 57,
 17, 18, 57, 57, 48,  1, 21,  6,  6, 35, 34, 39, 38, 39, 38, 39,
 38, 35, 34,  6,  7, 53, 54, 54, 51, 50, 23, 22, 23, 22, 23, 22,
 51, 50, 54, 19, 21,  6,  6, 35, 34, 39, 38, 39, 38, 39, 38, 35,
 34,  6,  7, 53, 54, 54, 51, 50, 23, 22, 23, 22, 23, 22, 51, 50,
 54,  5,219,105,179, 97,110,146, 10,  7,  6, 15,155, 94, 88,172,
 98,105,179, 97,110,147, 11,  5,  6, 15,155, 94, 86,169,103,105,
179, 97,110,146, 10,  7,  6, 15,155, 94, 88,172, 98,105,179, 97,
110,147, 10,  5,  7, 15,155, 94, 86,169,  2,111,179, 78, 69, 59,
  4,  3,  2,  6, 61, 76, 84,179, 78, 69, 59,  5,  2,  2,  6, 61,
 75,  1,218,178, 79, 69, 59,  4,  3,  2,  6, 61, 76, 83,178, 78,
 69, 59,  4,  2,  3,  6, 61, 75,  0,  2,255,250,  0,  0,  5, 96,
  5,193,  0,  2,  0,  6,  0, 31, 64, 15,  0,  3,  1,  3,  5,  4,
  3,  2,  1,  0,  5,  7,  5,  6,  7, 16,212,204, 17, 23, 57, 49,
  0, 47,196,204, 17, 57, 48,  1,  1, 33,  1, 51,  1, 33,  2,172,
254, 94,  3, 68,253,239,224,  2, 67,250,154,  4,238,251,196,  5,
 15,250, 63,  0,  0,  2,  0,127,  0,141,  4,113,  4, 35,  0,  6,
  0, 13,  0, 49, 64, 25,  9,  2, 11,  4,162,  7,  0,108, 14,  4,
  3,  2,  3, 12,  5, 11, 10,  9,  3,  0,  7, 12,  0,  5, 14, 16,
212,212,212,204, 17, 23, 57, 17, 18, 23, 57, 49,  0, 16,244, 60,
236, 50, 57, 57, 48,  1,  7,  1, 19,  7,  1, 55,  1,  7,  1, 19,
  7,  1, 55,  2,180, 39,254,158,252, 37,254,125, 16,  3,226, 39,
254,157,252, 37,254,125, 17,  4, 35,201,254,242,254,246,181,  1,
162, 82,  1,162,201,254,242,254,246,181,  1,162, 82,  0,  0,  2,
  0,127,  0,141,  4,111,  4, 35,  0,  6,  0, 13,  0, 49, 64, 25,
  9,  2,  7,  0,162, 11,  4,108, 14,  4,  3,  2,  3, 12,  5, 11,
 10,  9,  3,  7,  5,  0, 12,  7, 14, 16,212,220,212,204, 18, 23,
 57, 17, 18, 23, 57, 49,  0, 16,244, 60,236, 50, 57, 57, 48, 37,
 55,  1,  3, 55,  1,  7,  1, 55,  1,  3, 55,  1,  7,  2, 57, 39,
  1, 99,252, 39,  1,129, 15,252, 31, 39,  1, 96,250, 37,  1,129,
 14,141,201,  1, 14,  1, 11,180,254, 94, 82,254, 94,201,  1, 14,
  1, 11,180,254, 94, 82,  0,  3,  0,133,  0,  0,  6,223,  0,254,
  0,  3,  0,  7,  0, 11,  0,118, 64, 58,  6,  5,  7,  4,  7,  5,
  5,  4,  4,  7, 10,  5, 11,  8, 11,  9,  5,  8,  8, 11,  2,  5,
  3,  0,  3,  1,  5,  0,  0,  3, 58,  8,  4,  0, 72, 10,  6,  2,
 10,  9,  8,  7,  6,  5,  4,  2,  1, 11,  0,  5,  4,  4,  7,  8,
 11,  0,  3, 12, 16,212,196,212,196,212,196, 16,192, 17, 18, 57,
 57, 17, 18, 57, 17, 18, 57, 57, 49,  0, 47, 60, 60,236, 50, 50,
 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237,  7, 16,  5,237,
  7, 16,  5,237,  7, 16,  5,237,  7, 16,  5,237, 89, 34, 55, 51,
  7, 35, 37, 51,  7, 35, 37, 51,  7, 35,182,211, 49,211,  5,135,
211, 49,211,253,133,211, 49,211,254,254,254,254,254,254,255,255,
255,147,  0,  0,  4,236,  7,107,  2, 39,  0, 36,  0,  0,  0,  0,
  0,  7,  1,  6,  0,217,  1,117,255,255,255,147,  0,  0,  4,240,
  7, 94,  2, 39,  0, 36,  0,  0,  0,  0,  0,  7,  1,  5,  0,217,
  1,117,255,255,  0, 82,255,227,  5,250,  7, 94,  2, 39,  0, 50,
  0,  0,  0,  0,  0,  7,  1,  5,  1, 84,  1,117,  0,  2,  0, 94,
  0,  0,  8,137,  5,213,  0, 12,  0, 35,  0,139, 64, 57, 20,  5,
 12,  0, 12, 19,  5,  0, 12, 16,  5,  0, 12, 15,  5,  0,  0, 12,
 58, 18, 90, 16, 14,  0, 90, 13, 70, 20, 10, 90, 16,115, 22, 22,
 21, 20, 19, 18, 17, 16, 15, 14, 12, 10,  1,  0, 13, 13, 23, 35,
 13,  7,  7, 28, 29, 13, 36, 16,244,236, 16,192,192,192, 18, 23,
 57, 49,  0, 47,236,236, 50,244,236, 50, 16,238, 48, 75, 83, 88,
  7, 16,  5,237,  7,  5,237,  7,  5,237,  7, 16,  5,237, 89, 34,
  1, 75,176, 14, 84, 75,176, 13, 84, 91, 75,176, 16, 84, 91, 75,
176, 15, 84, 91, 88,189,  0, 36,255,192,  0,  1,  0, 36,  0, 36,
  0, 64, 56, 17, 55, 56, 89,  1, 35, 34,  4,  7,  6,  2, 21, 20,
 22, 59,  2,  1,  7, 33,  3, 33,  7, 33,  3, 33,  7, 33, 34, 38,
 39, 38,  2, 53, 52, 18, 55, 54, 36, 51,  4,186,120,166,254,253,
 87,133,138,253,247, 49,129,  4,176, 33,253, 29, 88,  2,199, 33,
253, 57,104,  2,248, 33,251,190,162,177, 78,157,157,185,172,123,
  1, 94,225,  5, 43, 76, 73,110,254,211,181,203,209,  5, 43,170,
254, 70,170,253,227,170, 31, 35, 70,  1,  2,188,209,  1,116,135,
 98, 97,  0,  3,  0, 94,255,227,  7,223,  4,123,  0, 40,  0, 50,
  0, 65,  0,184, 64, 57, 32, 47, 41, 17, 10,  7, 41,111,  0, 11,
 75, 10, 78, 54,  7, 76, 14,  0,124, 60, 47, 76, 35, 29,122, 20,
 14, 81, 66,  1, 57, 41, 50,  0, 44, 38, 17,  4, 32,  3, 57, 50,
 10, 11, 44, 38, 50, 14, 57, 44,  5, 38, 51, 14, 23, 34, 66, 16,
244,236,212,236,212,236, 17, 18, 57, 57, 17, 18, 23, 57, 17, 18,
 57, 17, 57, 18, 57, 49,  0, 16,228, 50,244, 60,236, 50,228, 16,
254, 60,244,238, 16,238, 17, 18, 57, 17, 18, 57, 48,  1, 75,176,
 18, 84, 88,189,  0, 66,255,192,  0,  1,  0, 66,  0, 66,  0, 64,
 56, 17, 55, 56, 89, 64, 50,111,  0,111,  1,104, 17,111, 38,111,
 39,111, 40,111, 41,111, 42,111, 43,111, 44,107, 49,111, 50,137,
  6,138,  9,138, 10,153,  9,153, 10, 17,143,  9,143, 10,143, 11,
138, 15,138, 16,154,  9,154, 10,  7, 93,  0, 93,  1, 33, 14,  1,
 21, 20, 22, 51, 50, 54, 55,  7, 14,  1, 35, 34, 38, 39, 14,  1,
 35, 34, 38, 53, 52, 18, 55, 62,  1, 51, 50, 22, 23, 62,  1, 51,
 50, 22, 21, 20,  6, 39, 62,  1, 53, 52, 38, 35, 34,  6,  7,  5,
 20, 22, 51, 50, 18, 53, 52, 38, 35, 34,  6,  7, 14,  1,  7,199,
252,168,  4,  5,170,156,120,217, 91, 37, 99,210,109,161,230, 47,
101,231,135,191,235, 76, 66, 99,244,154,130,199, 54, 99,242,142,
191,225, 12,172,  3,  3,143,123,138,209, 55,252,140,127,129,185,
243,129,127,104,162, 64, 47, 51,  2,  4, 27, 50, 21,139,152, 54,
 52,182, 39, 41,110, 99,105,104,238,192,137,  1,  3, 88,134,128,
117,108,112,113,228,192, 46,105, 84, 16, 34, 17,122,142,173,159,
229,152,151,  1, 64,249,147,148, 97, 99, 74,190,  0,  1,255,242,
  1,233,  4, 14,  2,121,  0,  3,  0, 25, 64, 11,  2,111,  0,163,
  4,  2,  0,  4,  1,  3,  4, 16,212,204, 17, 57, 57, 49,  0, 16,
252,236, 48, 19, 33,  7, 33, 14,  4,  0, 28,252,  0,  2,121,144,
  0,  1,255,242,  1,233,  8, 14,  2,121,  0,  3,  0, 24, 64, 10,
  2,111,  0,  4,  2,  0,  4,  1,  3,  4, 16,212,204, 17, 57, 57,
 49,  0, 16,212,236, 48, 19, 33,  7, 33, 14,  8,  0, 28,248,  0,
  2,121,144,  0,  0,  2,  1, 12,  3,233,  4, 43,  5,213,  0,  5,
  0, 11,  0,151, 64, 49, 10,  9,  2, 11,  8,  5, 11,  6, 11,  7,
  5,  6,  6, 11,  4,  3,  2,  5,  2,  5,  5,  0,  5,  1,  5,  0,
  0,  5, 58,  6,  0, 98,  9,  3, 70, 12,  7,  6,  4,  1, 12,  0,
 10, 11,  6,  4,  5,  0, 12, 16,212,196,196,212,196,196, 17, 18,
 57, 17, 18, 57, 49,  0, 16,244, 60,236, 50, 48, 75, 83, 88,  7,
 16,  5,237,  7, 16,  5,237, 17, 23, 57,  7, 16,  5,237,  7, 16,
  5,237, 17, 23, 57, 89, 34, 64, 49, 10,  3, 10,  4, 10,  9, 10,
 10, 26,  3, 26,  4, 26,  9, 26, 10, 42,  3, 42,  4, 42,  9, 42,
 10, 58,  3, 58,  4, 58,  9, 58, 10, 73,  3, 73,  4, 73,  9, 73,
 10, 89,  3, 89,  4, 89,  9, 89, 10, 24, 93,  1, 35, 55, 19, 51,
  3,  5, 35, 55, 19, 51,  3,  1,223,211, 35,225,129,143,  1,119,
211, 35,225,129,143,  3,233,173,  1, 63,254,193,173,173,  1, 63,
254,193,  0,  2,  1, 20,  3,233,  4, 51,  5,213,  0,  5,  0, 11,
  0,151, 64, 46, 10,  9,  2, 11,  8,  5, 11,  6, 11,  7,  5,  6,
  6, 11,  4,  3,  2,  5,  2,  5,  5,  0,  5,  1,  5,  0,  5, 58,
  9,  3, 98,  6,  0, 70, 12,  1, 10,  0,  7, 10, 11,  6,  4,  5,
  0, 12, 16,212,196,196,212,196,196,192, 17, 18, 57, 49,  0, 16,
244, 60,236, 50, 48, 75, 83, 88,  7,  5,237,  7, 16,  5,237, 17,
 23, 57,  7, 16,  5,237,  7, 16,  5,237, 17, 23, 57, 89, 34,178,
  7, 10,  1,  1, 93, 64, 49,  5,  3,  5,  4,  5,  9,  6, 10, 21,
  3, 21,  4, 21,  9, 21, 10, 37,  3, 37,  4, 37,  9, 37, 10, 54,
  3, 54,  4, 54,  9, 54, 10, 70,  3, 70,  4, 70,  9, 70, 10, 85,
  3, 85,  4, 85,  9, 85, 10, 24, 93,  1, 51,  7,  3, 35, 19, 37,
 51,  7,  3, 35, 19,  1,199,211, 35,225,130,144,  1,188,211, 35,
225,129,143,  5,213,172,254,192,  1, 64,172,172,254,192,  1, 64,
  0,  1,  1, 12,  3,233,  2,145,  5,213,  0,  5,  0, 84, 64, 26,
  4,  3,  2,  5,  2,  5,  5,  0,  5,  1,  5,  0,  0,  5, 58,  0,
 98,  3, 70,  6,  1,  6,  4,  5,  0,  6, 16,212,196,196, 18, 57,
 49,  0, 16,244,236, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,
237, 17, 23, 57, 89, 34, 64, 25, 11,  3, 11,  4, 26,  3, 26,  4,
 42,  3, 42,  4, 57,  3, 57,  4, 73,  3, 73,  4, 89,  3, 89,  4,
 12, 93,  1, 35, 55, 19, 51,  3,  1,223,211, 35,225,129,143,  3,
233,173,  1, 63,254,193,  0,  1,  1, 20,  3,233,  2,154,  5,213,
  0,  5,  0, 86, 64, 24,  4,  3,  2,  5,  2,  5,  5,  0,  5,  1,
  5,  0,  5, 58,  3, 98,  0, 70,  6,  1,  4,  5,  0,  6, 16,212,
196,196,192, 49,  0, 16,244,236, 48, 75, 83, 88,  7,  5,237,  7,
 16,  5,237, 17, 23, 57, 89, 34,178,  7,  4,  1,  1, 93, 64, 25,
  4,  3,  5,  4, 21,  3, 21,  4, 37,  3, 37,  4, 54,  3, 54,  4,
 70,  3, 70,  4, 86,  3, 86,  4, 12, 93,  1, 51,  7,  3, 35, 19,
  1,199,211, 33,227,130,144,  5,213,172,254,192,  1, 64,  0,  3,
  0,217,  0,150,  5,219,  4,111,  0,  3,  0,  7,  0, 11,  0, 41,
 64, 20,  0,164,  2,  6,164,  4,  2,  8, 96,  4, 10, 12,  9,  5,
  1, 62,  4,  0,  8, 12, 16,220,212, 60,252, 60,196, 49,  0, 16,
212,196,252,196, 16,238, 16,238, 48,  1, 51, 21, 35, 17, 51, 21,
 35,  1, 33, 21, 33,  2,223,246,246,246,246,253,250,  5,  2,250,
254,  4,111,246,254, 18,245,  2, 65,170,  0,  2,  0,  6,254, 35,
  3,238,  6,117,  0,  3,  0,  7,  0, 34, 64, 17,  2,  6,  0,  8,
  4,  6,  8,  6,  4,  3,  2,  1,  0,  6,  5,  7,  8, 16,212,204,
 23, 57, 49,  0, 16,212,204, 17, 57, 18, 57, 48,  9,  7,  1,250,
254,127,  1,129,  1,129,254,127,  1,244,254, 12,254, 12,  5,129,
252,207,252,199,  3, 57,  4, 37,251,219,251,211,  4, 45,255,255,
255,205,254, 86,  4,211,  6, 16,  2, 39,  0, 92,  0,  0,  0,  0,
  0,  7,  0,142,  0, 94,  0,  0,255,255,  0,129,  0,  0,  5,104,
  7, 78,  2, 39,  0, 60,  0,  0,  0,  0,  0,  7,  1,  3,  0,127,
  1,117,  0,  1,253,231,255,227,  3,109,  5,240,  0,  3,  0, 95,
 64, 19,  2,  3,  0,  3,  1,  0,  0,  3, 58,  2, 81,  0, 86,  4,
  1,  0,  0,  3,  4, 16,212,196, 16,192, 49,  0, 16,228,228, 48,
 75, 83, 88,  7, 16,  5,201,  7, 16,  5,201, 89, 34,178,  7,  2,
  1,  1, 93, 64, 41,  9,  0,  6,  2, 21,  2, 37,  2, 56,  0, 54,
  2, 69,  2, 89,  0, 86,  2,105,  0,101,  2,120,  0,117,  1,117,
  2,136,  0,133,  1,132,  2,153,  0,155,  1,152,  2, 20, 93,  1,
 51,  1, 35,  2,186,179,251, 47,181,  5,240,249,243,  0,  0,  2,
  0, 94,  0, 82,  4,188,  4,178,  0, 35,  0, 47,  0,131, 64, 73,
  3,  9, 27, 21,  4, 45, 30,  0, 39, 28,  2, 33, 29, 12, 18, 45,
 20, 11, 10,  3, 19, 15,  1, 29, 45, 76, 19,165, 15,166, 39, 76,
 29,165, 33, 48, 30, 12,  0, 18,  4, 42, 36, 20, 48, 28, 21, 27,
 42, 29, 19, 28, 24,  9,  3, 36, 11, 10,  1,  3,  2, 36, 23,  2,
 63,  6, 64, 42, 23, 28, 63, 24, 48, 16,220,228,236,244,228,236,
 18, 23, 57, 18, 57, 57, 17, 18, 57, 57, 18, 57, 57, 17, 18, 57,
 17, 18, 23, 57, 49,  0, 16,212,228,236,244,228,236, 16,192, 17,
 18, 23, 57, 18, 57, 57, 17, 18, 57, 57, 17, 57, 57, 18, 23, 57,
 48,  1, 55, 23,  7, 22, 22, 21, 20,  6,  7, 23,  7, 39,  6,  6,
 35, 34, 38, 39,  7, 39, 55, 38, 38, 53, 52, 54, 55, 39, 55, 23,
 54, 54, 51, 50, 22, 19, 52, 38, 35, 34,  6, 21, 20, 22, 51, 50,
 54,  3,123,207,114,206, 37, 36, 38, 40,209,114,207, 59,116, 61,
 58,120, 61,207,113,207, 37, 37, 38, 38,207,115,207, 55,116, 64,
 60,117, 92,155,114,112,158,157,113,113,156,  3,225,209,115,206,
 59,119, 62, 63,115, 57,207,113,207, 40, 38, 37, 37,207,115,206,
 62,118, 58, 64,116, 56,206,115,207, 39, 37, 36,254,124,112,154,
154,112,114,156,157,  0,  0,  1,  0,127,  0,141,  2,180,  4, 35,
  0,  6,  0, 27, 64, 13,  2,  4,162,  0,108,  7,  4,  3,  2,  3,
  0,  5,  7, 16,212,204, 23, 57, 49,  0, 16,244,236, 57, 48,  1,
  7,  1, 19,  7,  1, 55,  2,180, 37,254,156,252, 37,254,125, 16,
  4, 35,201,254,242,254,246,181,  1,162, 82,  0,  0,  1,  0,127,
  0,141,  2,180,  4, 35,  0,  6,  0, 27, 64, 13,  2,  0,162,  4,
108,  7,  4,  3,  2,  3,  5,  0,  7, 16,212,204, 23, 57, 49,  0,
 16,244,236, 57, 48, 55, 55,  1,  3, 55,  1,  7,127, 39,  1,100,
252, 35,  1,131, 14,141,201,  1, 14,  1, 11,180,254, 94, 82,  0,
  0,  3,  0,139,  0,  0,  5, 33,  6, 20,  0,  3,  0,  7,  0, 27,
  0,231, 64, 98,  4,  5,  5,  6,  5,  7,  5,  6,  6,  5,  0,  5,
  1,  2,  1,  3,  5,  2,  2,  1, 18,  5, 19, 23, 19, 17,  5, 23,
 19, 14,  5, 23, 19, 10, 11, 12,  3,  9, 13,  5, 23, 23, 19, 58,
 13, 24,  6, 20, 16,111,  0,  9,125,  6, 99,  8,  4, 92, 22, 14,
  0,126, 18,  2, 20, 18, 22, 21,  4, 19, 27, 24, 17, 16, 15, 14,
 13, 10,  9,  8,  3, 11, 23,  7,  4,  0,  3,  2,  1,  6, 40,  5,
 37,  2,  1, 23, 19, 28, 16,212,196,212,212,244,228, 17, 18, 23,
 57, 17, 23, 57, 18, 23, 57, 49,  0, 47, 60,228, 50, 50,252, 60,
236,236, 16,238, 50, 18, 57, 57, 48, 75, 83, 88,  7, 16,  5,237,
 17, 23, 57,  7,  5,237,  7,  5,237,  7, 16,  5,237,  7, 16,  5,
237,  7, 16,  5,237,  7, 16,  5,237,  7, 16,  5,237, 89, 34,  1,
 75,176,  9, 84, 75,176, 10, 84, 91, 75,176, 13, 84, 91, 75,176,
 14, 84, 91, 75,176, 16, 84, 91, 75,176, 17, 84, 91, 88,189,  0,
 28,  0, 64,  0,  1,  0, 28,  0, 28,255,192, 56, 17, 55, 56, 89,
182, 95,  2, 95,  3,128, 29,  3, 93,  1, 51,  3, 35,  1, 51,  7,
 35, 39,  7, 35, 34,  6, 15,  1, 33,  7, 33,  3, 35, 19, 35, 55,
 51, 55, 62,  1, 51,  4, 18,187,219,185,  1, 47,185, 45,185,104,
 29,176,100, 91, 22, 20,  1, 47, 27,254,209,190,185,191,176, 26,
176, 15, 38,191,205,  4, 96,251,160,  6, 20,233,233,153, 79,105,
 99,143,252, 47,  3,209,143, 78,198,160,  0,  1,  0,139,  0,  0,
  5, 33,  6, 20,  0, 21,  0,212, 64, 74,  4,  5,  1,  2,  1,  3,
  5,  2,  2,  1, 13,  5, 14, 18, 14, 12,  5, 18, 14,  9,  5, 18,
 14,  5,  6,  7,  3,  4,  8,  5, 18, 18, 14, 58,  8, 19,  4, 15,
 11,111,  9,  4,125,  0, 92, 17,  9,126, 13,  2, 13, 17, 16, 15,
  4, 14, 19, 12, 11, 10,  9,  8,  5,  0,  3,  9, 18,  4,  2, 37,
  1, 18, 14, 22, 16,212,196,220,228, 57, 17, 23, 57, 18, 23, 57,
 49,  0, 47, 60,228, 50,252,236, 16,238, 50, 18, 57, 57, 48, 75,
 83, 88,  7, 16,  5,237, 17, 23, 57,  7,  5,237,  7,  5,237,  7,
 16,  5,237,  7, 16,  5,237,  7, 16,  5,237, 89, 34,  1, 75,176,
  9, 84, 75,176, 10, 84, 91, 75,176, 13, 84, 91, 75,176, 14, 84,
 91, 75,176, 16, 84, 91, 75,176, 17, 84, 91, 88,189,  0, 22,  0,
 64,  0,  1,  0, 22,  0, 22,255,192, 56, 17, 55, 56, 89, 64, 27,
 15,  1, 15,  2, 15,  3, 15,  4, 13, 10, 13, 11, 96,  1, 96,  2,
 96,  3, 96,  4, 96, 10, 96, 11,128, 23, 13, 93,  1, 33,  1, 35,
  1, 33, 34,  6, 15,  1, 33,  7, 33,  3, 35, 19, 35, 55, 51, 55,
 62,  1,  3, 37,  1,252,254,209,185,  1, 23,254,182,100, 91, 22,
 20,  1, 47, 27,254,209,190,185,191,176, 26,176, 15, 38,190,  6,
 20,249,236,  5,123, 79,105, 99,143,252, 47,  3,209,143, 78,199,
159,  0,  0,  1,255,221,255, 59,  4, 16,  5,213,  0, 19,  0,134,
 64, 73,  2,  5, 12,  3,  1,  5, 12,  3, 18,  5,  3, 12,  3, 17,
  5, 12,  3, 14,  5, 12,  3, 13,  5, 12, 12,  3, 58, 18,  6, 76,
  0, 16,  8, 76, 14, 10, 12,  4,  0,  2,129, 12, 70, 20, 19, 18,
 17, 16, 14, 13, 12, 11,  1,  0, 10, 15,  8,  6,  5, 10,  9, 20,
  7,  4,  2,  3,  3, 15,  8,  5,  8,  3, 20, 16,212,196, 46, 16,
192, 18, 23, 57, 17, 57, 57, 18, 57, 17, 18, 23, 57, 49,  0, 16,
228,244,196, 50, 16,212, 60,238, 50, 16,238, 50, 48, 75, 83, 88,
  7, 16,  5,237,  7,  5,237,  7,  5,237,  7, 16,  5,237,  7,  5,
237,  7,  5,237, 89, 34, 37, 33,  3, 35, 19, 33, 55, 33, 19, 33,
 55, 33, 19, 51,  3, 33,  7, 33,  3, 33,  3,106,254,146, 82,176,
 82,254,145, 29,  1,110,107,254,145, 29,  1,111, 82,176, 82,  1,
112, 30,254,145,106,  1,110,223,254, 92,  1,164,154,  2, 31,153,
  1,164,254, 92,153,253,225,  0,  0,  1,  0,233,  2, 72,  1,238,
  3, 70,  0,  3,  0, 47, 64, 21,  2,  5,  3,  0,  3,  1,  5,  0,
  3, 58,  2, 72,  0,  4,  2,  1,  0,  0,  0,  3,  4, 16,212,228,
 16,192, 57, 49,  0, 16,212,236, 48, 75, 83, 88,  7,  5,237,  7,
 16,  5,237, 89, 34,  1, 51,  7, 35,  1, 27,211, 50,211,  3, 70,
254,  0,  0,  1,  0,  6,255, 18,  1,139,  0,254,  0,  5,  0, 52,
 64, 24,  4,  3,  2,  5,  2,  5,  5,  0,  5,  1,  5,  0,  5, 58,
  3, 98,  0, 72,  6,  1,  4,  5,  0,  6, 16,212,196,196,192, 49,
  0, 16,252,236, 48, 75, 83, 88,  7,  5,237,  7, 16,  5,237, 17,
 23, 57, 89, 34, 55, 51,  7,  3, 35, 19,184,211, 35,225,129,144,
254,172,254,192,  1, 64,  0,  2,  0,  6,255, 18,  3, 37,  0,254,
  0,  5,  0, 11,  0, 93, 64, 46, 10,  9,  2, 11,  8,  5, 11,  6,
 11,  7,  5,  6,  6, 11,  4,  3,  2,  5,  2,  5,  5,  0,  5,  1,
  5,  0,  5, 58,  9,  3, 98,  6,  0, 72, 12,  1, 10,  0,  7, 10,
 11,  6,  4,  5,  0, 12, 16,212,196,196,212,196,196,192, 17, 18,
 57, 49,  0, 16,252, 60,236, 50, 48, 75, 83, 88,  7,  5,237,  7,
 16,  5,237, 17, 23, 57,  7, 16,  5,237,  7, 16,  5,237, 17, 23,
 57, 89, 34, 55, 51,  7,  3, 35, 19, 37, 51,  7,  3, 35, 19,184,
211, 35,225,129,144,  1,188,211, 35,225,129,143,254,172,254,192,
  1, 64,172,172,254,192,  1, 64,  0,  7,  0,186,255,227, 10, 18,
  5,240,  0, 11,  0, 23,  0, 35,  0, 47,  0, 59,  0, 71,  0, 75,
  0,100, 64, 56, 51, 15, 87,  6, 45, 87, 24, 82, 39, 87, 30, 57,
 21, 87, 66,  6, 82, 73, 60,  0, 81, 72, 30, 86, 76, 72, 69, 48,
 74, 42, 27, 54, 10, 63, 12, 10,  9,  9, 18, 10,  3, 36, 10, 33,
  3, 48, 10, 63,  9, 69, 42, 10, 33,  9, 27, 76, 16,212,236,236,
212,236,236,196, 16,238, 16,238,254,238, 16,238, 17, 18, 57, 17,
 18, 57, 49,  0, 16,228, 50,244, 60, 60,228, 50,236, 50, 16,238,
246,238, 16,238, 50, 48,  5, 34, 38, 53, 52, 18, 51, 50, 22, 21,
 20,  2, 19, 52, 38, 35, 34,  6, 21, 20, 22, 51, 50, 54,  1, 34,
 38, 53, 52, 18, 51, 50, 22, 21, 20,  2, 19, 52, 38, 35, 34,  6,
 21, 20, 22, 51, 50, 54,  1, 52, 38, 35, 34,  6, 21, 20, 22, 51,
 50, 54,  1, 34, 38, 53, 52, 18, 51, 50, 22, 21, 20,  2, 19,  1,
 35,  1,  8,115,137,158,231,187,135,157,231, 72, 77, 77,111,126,
 80, 75,107,129,248,110,136,159,232,186,136,159,232, 72, 78, 77,
112,126, 81, 75,107,130,  3, 92, 76, 77,111,127, 81, 75,107,128,
255,  0,136,158,231,186,136,157,231,155,251, 46,160,  4,211, 29,
178,152,216,  1, 11,176,153,215,254,243,  1,219,107,106,195,173,
 93,100,190,  1,163,177,152,216,  1, 12,179,153,214,254,245,  1,
219,105,106,194,173, 92,100,190,253,190,107,106,195,173, 93,100,
190,254,195,178,152,216,  1, 11,176,153,215,254,243,  6, 13,249,
243,  6, 13,  0,255,255,255,147,  0,  0,  4,236,  7,109,  2, 39,
  0, 36,  0,  0,  0,  0,  0,  7,  1,  7,  0,217,  1,117,255,255,
  0, 55,  0,  0,  5, 10,  7,109,  2, 39,  0, 40,  0,  0,  0,  0,
  0,  7,  1,  7,  0,160,  1,117,255,255,255,147,  0,  0,  4,236,
  7,107,  2, 39,  0, 36,  0,  0,  0,  0,  0,  7,  1,  4,  0,217,
  1,117,255,255,  0, 55,  0,  0,  5, 10,  7, 78,  2, 39,  0, 40,
  0,  0,  0,  0,  0,  7,  1,  3,  0,160,  1,117,255,255,  0, 55,
  0,  0,  5, 10,  7,107,  2, 39,  0, 40,  0,  0,  0,  0,  0,  7,
  1,  6,  0,160,  1,117,255,255,  0, 55,  0,  0,  3, 16,  7,107,
  2, 39,  0, 44,  0,  0,  0,  0,  0,  7,  1,  4,255, 59,  1,117,
255,255,  0, 55,  0,  0,  3,  8,  7,109,  2, 39,  0, 44,  0,  0,
  0,  0,  0,  7,  1,  7,255, 59,  1,117,255,255,  0, 55,  0,  0,
  3, 34,  7, 78,  2, 39,  0, 44,  0,  0,  0,  0,  0,  7,  1,  3,
255, 59,  1,117,255,255,  0, 55,  0,  0,  2, 86,  7,107,  2, 39,
  0, 44,  0,  0,  0,  0,  0,  7,  1,  6,255, 59,  1,117,255,255,
  0, 82,255,227,  5,250,  7,107,  2, 39,  0, 50,  0,  0,  0,  0,
  0,  7,  1,  4,  1, 84,  1,117,255,255,  0, 82,255,227,  5,250,
  7,109,  2, 39,  0, 50,  0,  0,  0,  0,  0,  7,  1,  7,  1, 84,
  1,117,255,255,  0, 82,255,227,  5,250,  7,107,  2, 39,  0, 50,
  0,  0,  0,  0,  0,  7,  1,  6,  1, 84,  1,117,255,255,  0,119,
255,227,  5,180,  7,107,  2, 39,  0, 56,  0,  0,  0,  0,  0,  7,
  1,  4,  0,250,  1,117,255,255,  0,119,255,227,  5,180,  7,109,
  2, 39,  0, 56,  0,  0,  0,  0,  0,  7,  1,  7,  0,250,  1,117,
255,255,  0,119,255,227,  5,180,  7,107,  2, 39,  0, 56,  0,  0,
  0,  0,  0,  7,  1,  6,  0,250,  1,117,  0,  1,  0, 72,  0,  0,
  1,219,  4, 96,  0,  3,  0, 79, 64, 22,  2,  5,  3,  0,  3,  1,
  5,  0,  0,  3, 58,  0,126,  2,  2,  3,  1,  0,  0,  3, 36,  4,
 16,244,196, 16,192, 18, 57, 49,  0, 47,228, 48, 75, 83, 88,  7,
 16,  5,237,  7, 16,  5,237, 89, 34,178, 64,  5,  1,  1, 93,  1,
 75,176, 18, 84, 88,189,  0,  4,255,192,  0,  1,  0,  4,  0,  4,
  0, 64, 56, 17, 55, 56, 89,  1, 51,  3, 35,  1, 35,184,219,184,
  4, 96,251,160,  0,  1,  1, 82,  4,238,  3,209,  6,102,  0,  6,
  0,100, 64, 12,  4,  5,  2,  0,  7,  4,  3,  1,  3,  2,  6,  7,
 16,212,204, 23, 57, 49,  0, 16,212,204, 50, 57, 48,  0, 75,176,
  9, 84, 75,176, 14, 84, 91, 88,189,  0,  7,255,192,  0,  1,  0,
  7,  0,  7,  0, 64, 56, 17, 55, 56, 89,  1, 75,176, 10, 84, 75,
176, 13, 84, 91, 75,176, 12, 84, 91, 75,176, 16, 84, 91, 75,176,
 15, 84, 91, 88,189,  0,  7,  0, 64,  0,  1,  0,  7,  0,  7,255,
192, 56, 17, 55, 56, 89,  1, 51, 19, 35, 39,  7, 35,  2,145,148,
172,139,127,234,139,  6,102,254,136,237,237,  0,  0,  1,  1, 80,
  5, 29,  4, 27,  6, 55,  0, 27,  0,246, 64, 31,  0, 18,  7, 14,
 11,  4,  1, 18,  7, 15, 11,  4, 18,130, 25,  7,  4,130, 21, 11,
 28, 21, 15, 14,  7,  1,  0,  6, 22,  8, 28, 16,212,204, 23, 57,
 49,  0, 16,212, 60,252,212, 60,236, 17, 18, 57, 17, 18, 57, 17,
 18, 57, 17, 18, 57, 48,  0, 75,176,  9, 84, 75,176, 12, 84, 91,
 88,189,  0, 28,255,192,  0,  1,  0, 28,  0, 28,  0, 64, 56, 17,
 55, 56, 89, 64, 24,  8,  0, 10, 10,  9, 11,  9, 12, 15, 18, 15,
 19, 15, 20, 15, 21, 15, 22, 15, 23, 10, 10,  0,  1, 93,  1, 93,
  1, 75,176,  9, 84, 75,176, 12, 84, 91, 75,176, 13, 84, 91, 75,
176, 16, 84, 91, 88,189,  0, 28,  0, 64,  0,  1,  0, 28,  0, 28,
255,192, 56, 17, 55, 56, 89, 64, 33, 25,  0, 28, 10, 28, 11, 28,
 12, 28, 13, 28, 14, 28, 15, 28, 16, 28, 17, 28, 18, 28, 19, 31,
 20, 31, 21, 31, 22, 31, 23, 25, 27, 16, 93,  1, 75,176, 10, 84,
 88,189,  0, 28,  0,128,  0,  1,  0, 28,  0, 28,255,128, 56, 17,
 55, 56, 89,  0, 75,176, 15, 84, 75,176, 19, 84, 91, 88,189,  0,
 28,  0, 64,  0,  1,  0, 28,  0, 28,255,192, 56, 17, 55, 56, 89,
  1, 39, 46,  1, 39, 34,  6,  7, 35, 62,  1, 51, 50, 22, 31,  1,
 30,  1, 23, 50, 54, 55, 51, 14,  1, 35, 34, 38,  2,162, 45, 13,
 32, 16, 39, 51, 17,125, 30,129, 91, 37, 64, 26, 47, 12, 28, 19,
 38, 49, 20,125, 29,129, 92, 38, 66,  5, 90, 55, 16, 20,  3, 73,
 82,137,145, 31, 30, 55, 16, 18,  5, 71, 84,137,145, 31,  0,  1,
  1,125,  5, 98,  3,240,  5,246,  0,  3,  0,100, 64,  9,  2,111,
  0,  4,  2,  0,  1,  3,  4, 16,212,204, 57, 57, 49,  0, 16,212,
236, 48,  1, 75,176,  9, 84, 75,176, 10, 84, 91, 75,176, 13, 84,
 91, 75,176, 12, 84, 91, 75,176, 16, 84, 91, 75,176, 15, 84, 91,
 88,189,  0,  4,  0, 64,  0,  1,  0,  4,  0,  4,255,192, 56, 17,
 55, 56, 89,  0, 75,176, 15, 84, 75,176, 16, 84, 91, 88,189,  0,
  4,  0, 64,  0,  1,  0,  4,  0,  4,255,192, 56, 17, 55, 56, 89,
  1, 33,  7, 33,  1,154,  2, 86, 29,253,170,  5,246,148,  0,  1,
  1,154,  5, 41,  4, 14,  6, 72,  0, 17,  0,149, 64, 17,  2,  0,
 12,168,  5,  8,  0,167, 18,  0, 15,  1,  8,  9,  1, 15, 18, 16,
212,204,212,204, 17, 18, 57, 49,  0, 16,244, 60,212,236, 18, 57,
 48,  0, 75,176,  9, 84, 88,189,  0, 18,255,192,  0,  1,  0, 18,
  0, 18,  0, 64, 56, 17, 55, 56, 89,  1, 75,176,  9, 84, 75,176,
 10, 84, 91, 75,176, 13, 84, 91, 75,176, 12, 84, 91, 75,176, 16,
 84, 91, 75,176, 15, 84, 91, 88,189,  0, 18,  0, 64,  0,  1,  0,
 18,  0, 18,255,192, 56, 17, 55, 56, 89,  0, 75,176, 15, 84, 75,
176, 16, 84, 91, 75,176, 17, 84, 91, 75,176, 19, 84, 91, 88,189,
  0, 18,  0, 64,  0,  1,  0, 18,  0, 18,255,192, 56, 17, 55, 56,
 89,  1, 51, 21, 20, 22, 51, 50, 54, 55, 51, 14,  1, 35, 34, 38,
 53, 52, 54,  1,156,114, 84, 86, 85,110, 31,116, 32,190,146,128,
132,  2,  6, 72, 15, 68, 67, 73, 77,139,148,129,125,  6, 22,  0,
  0,  1,  2, 59,  5, 68,  3, 47,  6, 16,  0,  3,  0,135, 64, 17,
  2,  3,  0,  3,  1,  0,  3, 58,  2,  0,  4,  2,  0,  1,  3,  3,
  4, 16,196, 16,192, 57, 57, 49,  0, 16,212,204, 48, 75, 83, 88,
  7,  5,201,  7, 16,  5,201, 89, 34,  1, 75,176,  9, 84, 75,176,
 10, 84, 91, 75,176, 13, 84, 91, 75,176, 12, 84, 91, 75,176, 16,
 84, 91, 75,176, 15, 84, 91, 88,189,  0,  4,  0, 64,  0,  1,  0,
  4,  0,  4,255,192, 56, 17, 55, 56, 89, 64, 14, 79,  0, 79,  1,
 80,  2, 80,  3,  4, 85,  1, 85,  2,  2, 93,  0, 93,  0, 75,176,
 13, 84, 88,189,  0,  4,  0, 64,  0,  1,  0,  4,  0,  4,255,192,
 56, 17, 55, 56, 89,  1, 51,  7, 35,  2,100,203, 39,205,  6, 16,
204,  0,  0,  2,  1,172,  4,225,  3,209,  7,  6,  0, 11,  0, 23,
  0,213, 64, 11, 15,  9,169, 21,  3, 24, 12,  0, 18,  6, 24, 16,
212,204,212,204, 49,  0, 16,212,204,244,204, 48,  0, 75,176,  9,
 84, 75,176, 12, 84, 91, 88,189,  0, 24,255,192,  0,  1,  0, 24,
  0, 24,  0, 64, 56, 17, 55, 56, 89, 64, 11,  6,  7,  0,  8,  0,
  9,  0, 10,  6, 11,  5, 93,  1, 75,176, 10, 84, 75,176, 12, 84,
 91, 75,176, 16, 84, 91, 75,176, 15, 84, 91, 75,176, 14, 84, 91,
 88,189,  0, 24,  0, 64,  0,  1,  0, 24,  0, 24,255,192, 56, 17,
 55, 56, 89, 64, 73, 52,  2, 52,  3, 52,  4, 48,  5, 48,  6, 48,
  7, 52,  8, 52,  9, 52, 10, 52, 14, 52, 15, 52, 16, 48, 17, 48,
 18, 48, 19, 52, 20, 52, 21, 52, 22, 79,  0, 79,  1, 75,  2, 75,
  3, 75,  4, 75,  8, 75,  9, 75, 10, 79, 11, 79, 12, 79, 13, 75,
 14, 75, 15, 75, 16, 75, 20, 75, 21, 75, 22, 79, 23, 36, 93,  1,
 75,176, 13, 84, 88,189,  0, 24,  0,128,  0,  1,  0, 24,  0, 24,
255,128, 56, 17, 55, 56, 89,  1, 20,  6, 35, 34, 38, 53, 52, 54,
 51, 50, 22,  7, 52, 38, 35, 34,  6, 21, 20, 22, 51, 50, 54,  3,
209,159,116,115,159,159,115,116,159,123, 87, 65, 66, 85, 85, 66,
 67, 85,  5,244,115,160,160,115,116,158,158,116, 64, 87, 85, 66,
 66, 86, 86,  0,  0,  1,  0,100,254,117,  2, 35,  0,  0,  0, 19,
  0, 38, 64, 17,  9,  6, 10, 13,170,  6,  0,  0, 16,  3, 10,  9,
 19, 16,  9,  3, 20, 16,212,196,220,196, 17, 57, 17, 18, 57, 49,
  0, 47,212,252,196, 18, 57, 48, 33, 22, 22, 21, 20,  6, 35, 34,
 38, 39, 55, 22, 22, 51, 50, 54, 53, 52, 38, 39,  1,221, 36, 34,
147,128, 43, 86, 43, 23, 39, 79, 42, 60, 71, 25, 31, 51, 87, 42,
100,115, 12, 12,131, 16, 16, 61, 53, 29, 72, 57,  0,  2,  1,129,
  4,238,  4,137,  6,102,  0,  3,  0,  7,  0,127, 64, 10,  6,  2,
  4,  0,  8,  5,  7,  1,  3,  8, 16,212,220,212,204, 49,  0, 16,
212, 60,204, 50, 48,  0, 75,176,  9, 84, 88,189,  0,  8,255,192,
  0,  1,  0,  8,  0,  8,  0, 64, 56, 17, 55, 56, 89, 64, 45,  0,
  0,  0,  1,  0,  2,  0,  3, 16,  0, 16,  1, 16,  2, 16,  3, 32,
  0, 32,  1, 32,  2, 32,  3, 50,  0, 50,  1, 50,  2, 50,  3, 66,
  0, 66,  1, 66,  2, 66,  3,123,  4,123,  7, 22,  1, 93,  1, 75,
176, 16, 84, 75,176, 15, 84, 91, 88,189,  0,  8,  0, 64,  0,  1,
  0,  8,  0,  8,255,192, 56, 17, 55, 56, 89,  1, 51,  1, 35,  1,
 51,  1, 35,  2,137,170,254,215,137,  2, 86,178,254,191,135,  6,
102,254,136,  1,120,254,136,  0,  0,  1,  0,201,254,115,  2, 59,
  0,  0,  0, 19,  0, 65, 64, 16, 11, 14, 10,  7,170, 14,  0,  1,
 10, 11,  0, 10,  4,  4, 17, 20, 16,212,204, 16,192,192,192, 18,
 57, 49,  0, 47,212,252,196, 18, 57, 48, 64, 25, 73,  0, 73,  1,
 73,  2, 73, 19, 89,  0, 89,  1, 89,  2, 89, 19,105,  0,105,  1,
105,  2,105, 19, 12,  1, 93, 33, 51, 14,  1, 21, 20, 22, 51, 50,
 54, 55,  7, 14,  1, 35, 34, 38, 53, 52, 54,  1, 98,119, 64, 63,
 45, 45, 29, 69, 37, 24, 37, 71, 31,103,104, 77, 67,101, 35, 35,
 34, 15, 15,132, 12, 11, 76, 75, 52,123,  0,  1,  1,154,  4,238,
  4, 25,  6,102,  0,  6,  0,100, 64, 12,  4,  0,  5,  2,  7,  4,
  3,  1,  3,  6,  2,  7, 16,212,204, 23, 57, 49,  0, 16,212, 60,
204, 57, 48,  0, 75,176,  9, 84, 88,189,  0,  7,255,192,  0,  1,
  0,  7,  0,  7,  0, 64, 56, 17, 55, 56, 89,  1, 75,176,  9, 84,
 75,176, 10, 84, 91, 75,176, 13, 84, 91, 75,176, 12, 84, 91, 75,
176, 16, 84, 91, 75,176, 15, 84, 91, 88,189,  0,  7,  0, 64,  0,
  1,  0,  7,  0,  7,255,192, 56, 17, 55, 56, 89,  1, 35,  3, 51,
 23, 55, 51,  2,217,147,172,141,127,231,140,  4,238,  1,120,237,
237,  0,  0,  1,255,215,  0,  0,  4,  4,  5,213,  0, 13,  0, 98,
 64, 55,  6,  5,  0,  9,  5,  5,  4,  5,  9,  0,  9,  2,  5,  3,
  2,  0,  9,  1,  5,  0,  0,  9, 58, 12, 11, 10,  4,  3,  2,  6,
  0,  6, 90,  0, 70,  8, 11, 14, 10,  6,  9,  8,  4,  3,  2,  1,
  5,  0, 12,  7,  0,  2,  9, 27, 14, 16,244,228,204, 46, 17, 23,
 57, 18, 57, 57, 17, 57, 49,  0, 47,228,236, 17, 23, 57, 48, 75,
 83, 88,  7, 16,  5,237,  7,  8,237,  7, 16,  8,237,  7,  5,237,
 89, 34,  1, 51,  3, 37, 23,  5,  3, 33,  7, 33, 19,  7, 39, 55,
  1, 98,203,125,  1, 96, 56,254, 73,100,  2,215, 33,252, 95,114,
164, 57,252,  5,213,253,135,156,125,193,253,238,168,  2, 88, 76,
123,113,  0,  1,  0, 35,  0,  0,  2,139,  6, 20,  0, 11,  0,106,
 64, 51,  6,  5,  7,  0,  7,  5,  5,  4,  5,  0,  7,  2,  5,  3,
  2,  0,  7,  1,  5,  0,  0,  7, 58, 10,  9,  8,  4,  3,  2,  6,
  0, 92,  6, 10, 12,  9,  8,  6,  3,  7,  3,  2,  1,  3,  4,  0,
  0, 37,  7, 36, 12, 16,244,228, 16,192, 23, 57, 18, 23, 57, 17,
 57, 49,  0, 47,236, 23, 57, 48, 75, 83, 88,  7, 16,  5,237,  7,
  8,237,  7,  8,237,  7, 16,  5,237, 89, 34,178,112, 13,  1,  1,
 93,182,101,  3,100,  4, 96, 13,  3, 93,  1, 51,  3, 55, 23,  7,
  3, 35, 19,  7, 39, 55,  1,133,184,116,141, 53,223,158,184,137,
135, 53,219,  6, 20,253,162, 64,119,102,252,231,  2,188, 61,119,
 98,  0,255,255,  0, 12,255,227,  4,211,  7,109,  2, 39,  0, 54,
  0,  0,  0,  0,  0,  7,  1,  8,  0,152,  1,117,255,255,  0, 23,
255,227,  4, 48,  6,102,  2, 39,  0, 86,  0,  0,  0,  0,  0,  7,
  0,224,  0, 23,  0,  0,255,255,255,211,  0,  0,  5,160,  7,109,
  2, 39,  0, 61,  0,  0,  0,  0,  0,  7,  1,  8,  0,203,  1,117,
255,255,255,250,  0,  0,  4, 88,  6,102,  2, 39,  0, 93,  0,  0,
  0,  0,  0,  7,  0,224,  0, 27,  0,  0,  0,  2,  1,  4,254,162,
  1,174,  5,152,  0,  3,  0,  7,  0, 28, 64, 13,  1,171,  0,  4,
171,  5,  8,  4,  0,  7,  6,  2,  8, 16,220, 60,236, 50, 49,  0,
 16,212,236,212,236, 48,  1, 17, 35, 17, 19, 17, 35, 17,  1,174,
170,170,170,  1,152,253, 10,  2,246,  4,  0,253, 10,  2,246,  0,
  0,  2,  0,  0,  0,  0,  5,209,  5,213,  0, 15,  0, 28,  0,111,
 64, 61, 21,  5,  0, 11, 20,  5, 11,  0, 11, 17,  5,  0, 11, 16,
  5,  0,  0, 11, 58, 19, 12,111, 14, 16, 90,  0, 70, 21, 90, 17,
 14,172, 10, 14, 13, 11, 28, 22, 16, 20, 19, 18, 17,  7, 25, 21,
 15, 12,  3, 11,  1, 10,  0, 25, 28,  4,  0,  2, 11, 27, 13, 47,
244,230,214,238, 17, 57, 57, 18, 23, 57, 18, 23, 57, 17, 18, 57,
 49,  0, 47,238, 50,238,246,238, 16,238, 50, 48, 75, 83, 88,  7,
 16,  5,237,  7,  5,237,  7, 16,  5,237,  7,  5,237, 89, 34,  1,
 33, 32,  0, 17, 20,  2,  7,  6,  4, 35, 33, 19, 35, 55, 51,  1,
  3, 33,  7, 33,  3, 33, 32,  0, 17, 52, 38, 33,  1,100,  1,179,
  1, 89,  1, 97,135,119,119,254,148,250,254, 76,135,201, 29,200,
  1, 41, 94,  1, 80, 29,254,176,102,  1,  8,  1, 84,  1,115,240,
255,  0,  5,213,254,219,254,223,190,254,159,122,124,122,  2,188,
144,  1,227,254, 29,144,253,234,  1,134,  1, 99,215,201,  0,  2,
  0, 92,255,227,  4,178,  6, 20,  0, 31,  0, 46,  0,192, 64, 96,
 29, 30, 31, 30, 28, 27, 28, 31, 31, 30, 25, 26, 25, 22, 23, 22,
 24, 23, 23, 22, 26,  5,  0, 27, 25,  5, 24, 25,  0, 27, 22,  5,
 23, 22, 27,  0, 27, 19, 20,  2, 21,  5,  0,  0, 27, 58, 21, 35,
 31, 30, 29, 28, 25, 24, 23, 22,  8,  0, 26, 35, 76, 18, 41, 76,
  9, 81, 18, 26, 92, 47, 31, 22, 28, 26, 25, 24, 23,  7, 38,  0,
 44, 29, 30,  3, 21, 44, 38, 30, 44, 14,  3, 38, 14, 12, 34, 47,
 16,244,236,212,236,192, 17, 18, 57, 17, 18, 57, 18, 57, 17, 23,
 57, 49,  0, 16,236,196,244,236, 16,238, 18, 57, 23, 57, 18, 57,
 48, 75, 83, 88,  7, 16,  5,237, 23, 57,  7, 16,  8,237,  7,  8,
237,  7,  5,237,  7, 16, 14,201,  7, 16,  8,201,  7, 16,  8,201,
  7, 16, 14,201, 89, 34,  1, 75,176, 18, 84, 88,189,  0, 47,255,
192,  0,  1,  0, 47,  0, 47,  0, 64, 56, 17, 55, 56, 89,  1, 30,
  1, 21, 20,  6,  7, 14,  1, 35, 34, 38, 53, 52, 54, 55, 62,  1,
 51, 50, 22, 23, 39,  5, 39, 37, 39, 51, 23, 37, 23,  5, 19, 46,
  1, 35, 34,  2, 21, 20, 22, 51, 50, 18, 53, 52, 38,  3,248, 68,
 69, 79, 75, 84,245,144,198,236, 82, 76, 88,242,139, 20, 58, 40,
124,254,161, 32,  1, 71,139,217, 96,  1, 80, 35,254,199, 24, 43,
 87, 44,202,254,131,127,182,244, 26,  4,117,102,221,118,136,253,
100,116,124,235,195,120,236,101,116,124,  5,  5,180,107, 94, 97,
204,145,109, 95, 98,254,100, 17, 16,254,211,239,138,143,  1, 67,
244, 68,108,  0,255,255,  0,129,  0,  0,  5,104,  7,107,  2, 39,
  0, 60,  0,  0,  0,  0,  0,  7,  1,  4,  0,127,  1,117,255,255,
255,205,254, 86,  4,211,  6,102,  2, 39,  0, 92,  0,  0,  0,  0,
  0,  7,  0,141,  0, 94,  0,  0,  0,  2,  0, 55,  0,  0,  4,158,
  5,213,  0, 12,  0, 21,  0,113, 64, 61, 14,  5,  3,  4,  3, 13,
  5,  4,  4,  3,  2,  5,  4,  3,  1,  5,  3,  4,  3,  6,  5,  4,
  3,  5,  5,  4,  4,  3, 58, 14, 90,  0, 13, 90,  6,173,  4, 70,
  2, 21, 15, 14, 13,  6,  5,  6, 18,  2,  1,  3,  7,  0,  4, 18,
 28, 10,  4,  2,  3, 27, 22, 16,244,228,212,236, 17, 57, 57, 18,
 57, 57, 18, 23, 57, 49,  0, 47,244,252,236,212,236, 48, 75, 83,
 88,  7, 16,  5,237,  7,  5,237,  7, 16,  5,237,  7,  5,237,  7,
 16,  5,237,  7, 16,  5,237, 89, 34,  1, 33,  3, 35,  1, 51,  3,
 33, 50, 22, 21, 20,  0,  1,  3, 51, 50, 54, 53, 52, 38, 35,  2,
 68,255,  0, 66,203,  1, 35,203, 51,  1, 10,204,214,254,196,254,
113,109,254,172,185,124,114,  1, 82,254,174,  5,213,254,248,190,
183,246,254,240,  2,213,253,209,175,165,104,115,  0,  2,255,250,
254, 86,  4,182,  6, 20,  0, 17,  0, 37,  0,196, 64, 76, 11, 10,
  2, 12,  9,  5, 36, 35,  4,  5,  6,  7,  4,  3,  8,  5, 36, 35,
 34,  5, 36, 35, 31, 32,  2, 30, 33,  5, 35, 36, 35, 20, 19,  2,
 21, 18,  5, 36, 35, 37,  5, 36, 36, 35, 58, 33, 18, 12,  3, 76,
 21, 12, 76, 30, 81, 21,122, 34, 36, 92, 38, 34, 38, 37,  0,  9,
 33, 35, 18, 36,  0, 14, 24, 36, 35, 38, 16,212,196,212,236, 17,
 57, 18, 57, 57, 18, 57, 18, 57, 49,  0, 16,236,196,228,244,236,
 16,238, 17, 57, 57, 48, 75, 83, 88,  7, 16,  5,237,  7,  5,237,
 17, 23, 57,  7, 16,  5,237, 17, 23, 57,  7,  5,237,  7,  5,237,
 17, 23, 57,  7,  5,237, 17, 23, 57, 89, 34,  1, 75,176, 10, 84,
 75,176, 13, 84, 91, 75,176, 14, 84, 91, 75,176, 15, 84, 91, 75,
176, 16, 84, 91, 88,189,  0, 38,  0, 64,  0,  1,  0, 38,  0, 38,
255,192, 56, 17, 55, 56, 89,182, 96, 39,112, 39,159, 39,  3, 93,
  1, 52, 38, 35, 34,  6,  7, 14,  1, 21, 20, 22, 51, 50, 54, 55,
 62,  1,  1, 62,  1, 51, 50, 22, 21, 20,  2,  7, 14,  1, 35, 34,
 38, 39,  3, 35,  1, 51,  3,248,128,120, 82,149, 58, 57, 68,128,
118, 87,149, 53, 57, 70,253,198, 74,201,123,172,190,118,111, 74,
186,103,119,162, 40,115,184,  1,125,184,  2,178,147,156, 84, 80,
 79,224,110,140,151, 82, 78, 82,222,  1,105, 97,100,225,203,166,
254,211,119, 79, 83, 99, 98,253,174,  7,190,  0,  0,  1,  0,217,
  2, 45,  5,219,  2,215,  0,  3,  0, 17,182,  0, 96,  2,  4,  1,
  0,  4, 16,212,196, 49,  0, 16,212,236, 48, 19, 33, 21, 33,217,
  5,  2,250,254,  2,215,170,  0,  0,  1,  1, 25,  0, 63,  5,156,
  4,197,  0, 11,  0,133, 64, 77, 10, 96, 11, 10,  7,  8,  7,  9,
 96,  8,  8,  7,  4, 96,  3,  4,  7,  7,  6,  5, 96,  6,  7,  6,
  4, 96,  5,  4,  1,  2,  1,  3, 96,  2,  2,  1, 11, 96,  0,  1,
  0, 10, 96,  9, 10,  1,  1,  0, 58, 10,  8,  7,  6,  4,  2,  1,
  0,  8,  5,  3, 11,  9, 12, 11, 10,  9,  7,  5,  4,  3,  1,  8,
  2,  0,  8,  6, 12, 16,212, 60,204, 50, 23, 57, 49,  0, 16,212,
 60,204, 50, 23, 57, 48, 75, 83, 88,  7, 16,  8,237,  7, 16,  5,
237,  7, 16,  5,237,  7, 16,  8,237,  7, 16,  5,237,  7, 16,  8,
237,  7, 16,  5,237,  7, 16,  8,237, 89, 34,  9,  2,  7,  1,  1,
 39,  1,  1, 55,  1,  1,  5,156,254, 55,  1,201,119,254, 53,254,
 53,118,  1,200,254, 56,118,  1,203,  1,203,  4, 76,254, 53,254,
 55,121,  1,203,254, 53,121,  1,201,  1,203,121,254, 53,  1,203,
  0,  1,  0,135,  2,156,  2,199,  5,223,  0, 10,  0,130, 64, 47,
  9,  8,  2,  7, 65,  1,  2,  1,  6, 65,  2,  2,  1, 58,  7,  0,
156,  9,  3,156,  4,  9,174,  2,156,  5, 86, 11,  6,  9,  7,  3,
  8,  5, 10,  4,  3,  0,  4, 11,  2,  1,  8,  5,  5,  1, 11, 16,
212,196, 16,192, 18, 57, 17, 23, 57, 17, 18, 23, 57, 49,  0, 16,
244,236,236,212,236, 16,238, 50, 48, 75, 83, 88,  7, 16,  5,237,
  7, 16,  5,237, 23, 50, 89, 34,178, 15,  4,  1,  1, 93, 64, 31,
 15,  3,  4,  8,  4,  9, 31,  3, 31,  4, 21,  8, 21,  9, 47,  3,
 47,  4, 63,  3, 63,  4, 79,  3, 79,  4, 95,  3, 95,  4, 15, 93,
 19, 51, 19,  7, 63,  1, 51,  3, 51,  7, 33,156,204,119,229, 22,
230,145,141,205, 23,253,215,  3, 10,  2, 99, 41,116, 39,253, 43,
110,  0,  0,  1,  0, 74,  2,156,  3, 20,  5,240,  0, 24,  0,213,
 64, 47,  1, 65,  5,  6,  5, 23, 24,  2, 22,  0, 65,  6,  6,  5,
 58,  6,  0, 15,  1,156,  3, 15,156, 16, 12,156,  3,174, 19, 86,
 25,  2,  0,  3,  3, 22, 15,  6,  1,  3, 16,  4,  9, 67, 22,  4,
 25, 16,212,212,236, 17, 57, 23, 57, 17, 23, 57, 49,  0, 16,244,
236,236,212,236, 16,238, 17, 57, 57, 48, 75, 83, 88,  7, 16,  5,
237, 17, 23, 57,  7, 16,  5,237, 89, 34,178,  8,  3,  1,  1, 93,
 64, 17,  9,  2,  8,  3, 26,  2, 26,  3, 41,  2, 41,  3, 44,  4,
 44,  5,  8, 93,  1, 75,176, 11, 84, 75,176, 13, 84, 91, 75,176,
 14, 84, 91, 75,176, 15, 84, 91, 75,176, 16, 84, 91, 75,176, 17,
 84, 91, 75,176, 18, 84, 91, 75,176, 19, 84, 91, 88,189,  0, 25,
  0, 64,  0,  1,  0, 25,  0, 25,255,192, 56, 17, 55, 56, 89, 64,
 35, 54,  0, 57,  2, 57,  3, 70,  0, 79,  4, 79,  5, 76, 14, 76,
 15, 76, 16, 76, 17, 70, 24, 89,  6, 89,  7,106,  6,106,  7,122,
  6,122,  7, 17, 93,  9,  1, 33,  7, 33, 55,  1, 62,  1, 53, 52,
 38, 35, 34,  6,  7, 55, 62,  1, 51, 50, 22, 21, 20,  6,  2,147,
254,127,  1,185, 23,253,150, 22,  1,166, 59, 58, 84, 70, 55,132,
 83, 25, 76,136, 64,123,153, 64,  4, 66,254,204,114,110,  1, 84,
 46, 86, 40, 54, 67, 34, 36,123, 28, 28,114, 89, 62,113,  0,  1,
  0, 33,  2,141,  2,242,  5,240,  0, 40,  0,107, 64, 42,  9, 28,
156, 30, 19,156, 18,175, 30, 22,156, 15, 40,156,  0,175, 37,156,
 15,174,  3, 86, 41, 30, 29, 28, 19,  4,  9, 31, 40,  0,  4, 18,
 25, 67, 12, 34, 67,  6, 18, 41, 16,212,212,236,212,236, 17, 23,
 57, 23, 57, 49,  0, 16,244,236,236,244,236, 16,238,198,246,238,
 16,238, 57, 48, 64, 30,  4,  0,  4, 40,  2, 10,  5, 10,  6, 10,
  7, 15,  8, 15,  9, 13, 10, 15, 27, 15, 28, 15, 29, 15, 30, 15,
 31, 15, 32, 12, 93,  1, 93, 19, 62,  1, 51, 50, 22, 21, 20,  6,
  7, 30,  1, 21, 20,  6, 35, 34, 38, 39, 55, 30,  1, 51, 50, 54,
 53, 52, 38, 43,  1, 55, 51, 50, 54, 53, 52, 38, 35, 34,  6,  7,
215, 83,126, 55,125,150,114, 97, 75, 80,223,184, 64,130, 64, 24,
 53,112, 63,123,139, 97, 98, 86, 23, 92,102,115, 82, 82, 56,124,
 61,  5,205, 18, 17,105, 86, 77,114, 18, 16, 94, 72,127,158, 21,
 20,121, 27, 26, 92, 82, 62, 63,108, 72, 64, 53, 53, 21, 20,  0,
255,255,  0,135,255,227,  7,170,  5,240,  0, 39,  0,240,  0,  0,
  0,  0,  0, 39,  0,188,  3, 53,  0,  0,  0,  7,  1,  9,  4,139,
253,100,255,255,  0,135,255,227,  7,159,  5,240,  0, 39,  0,240,
  0,  0,  0,  0,  0, 39,  0,188,  3, 53,  0,  0,  0,  7,  0,241,
  4,139,253,100,255,255,  0, 33,255,227,  7,170,  5,240,  0, 39,
  0,242,  0,  0,  0,  0,  0, 39,  0,188,  3, 53,  0,  0,  0,  7,
  1,  9,  4,139,253,100,255,255,  0, 92,255,227,  5,205,  7,109,
  2, 39,  0, 42,  0,  0,  0,  0,  0,  7,  1, 10,  1, 39,  1,117,
255,255,  0, 66,254, 86,  4,197,  6, 72,  2, 39,  0, 74,  0,  0,
  0,  0,  0,  7,  0,218,  0,139,  0,  0,255,255,  0, 55,  0,  0,
  2, 96,  7, 80,  2, 39,  0, 44,  0,  0,  0,  0,  0,  7,  1, 11,
255, 59,  1,117,255,255,  0, 12,254,117,  4,211,  5,240,  2, 39,
  0, 54,  0,  0,  0,  0,  0,  7,  0,221,  0,100,  0,  0,255,255,
  0, 23,254,117,  4,  0,  4,123,  2, 39,  0, 86,  0,  0,  0,  0,
  0,  7,  0,221,  0, 23,  0,  0,255,255,  0, 86,255,227,  5,143,
  7,107,  2, 39,  0, 38,  0,  0,  0,  0,  0,  7,  1,  4,  1, 45,
  1,117,255,255,  0, 94,255,227,  4,164,  6,102,  2, 39,  0, 70,
  0,  0,  0,  0,  0,  7,  0,141,  0,119,  0,  0,255,255,  0, 86,
255,227,  5,143,  7,109,  2, 39,  0, 38,  0,  0,  0,  0,  0,  7,
  1,  8,  1, 45,  1,117,255,255,  0, 94,255,227,  4,144,  6,102,
  2, 39,  0, 70,  0,  0,  0,  0,  0,  7,  0,224,  0,119,  0,  0,
  0,  2,  0, 94,255,227,  5,156,  6, 20,  0, 27,  0, 45,  0,218,
 64,105, 39, 38,  2, 40, 37,  5, 26, 21, 32, 33, 34, 35,  4, 31,
 36,  5, 26, 26, 21, 20,  5, 26, 21, 19,  5, 26, 21, 16,  5, 26,
 21, 13, 14,  2, 12, 15,  5, 21, 26, 21,  2,  1,  2,  3,  0,  5,
 26, 21, 27,  5, 26, 26, 21, 58, 15,  0, 40, 31, 22, 18,144, 24,
 16,176, 40, 76, 12, 31, 76,  3, 81, 12,122, 20, 92, 26, 37, 27,
 17, 18,  4, 28, 25, 16, 22, 20, 19,  5, 26, 24, 23, 21, 15,  0,
 28, 26, 23, 26, 37, 21, 28, 14,  6, 34, 46, 16,244,236,212,228,
192, 17, 18, 57, 57, 17, 18, 57, 18, 23, 57, 17, 23, 57, 49,  0,
 47,236,228,244,236, 16,238,253, 60,238, 50, 17, 18, 57, 57, 48,
 75, 83, 88,  7, 16,  5,237,  7,  5,237, 17, 23, 57,  7, 16,  5,
237, 17, 23, 57,  7,  5,237,  7,  5,237,  7,  5,237,  7, 16,  5,
237, 17, 23, 57,  7,  5,237, 17, 23, 57, 89, 34,178, 96, 47,  1,
  1, 93,  1, 75,176, 18, 84, 88,189,  0, 46,255,192,  0,  1,  0,
 46,  0, 46,  0, 64, 56, 17, 55, 56, 89, 37, 14,  1, 35, 34, 38,
 53, 52, 18, 55, 62,  1, 51, 50, 22, 23, 19, 33, 55, 33, 55, 51,
  7, 51,  7, 35,  3, 35,  1, 20, 22, 51, 50, 54, 55, 62,  1, 53,
 52, 38, 35, 34,  6,  7, 14,  1,  3, 88, 74,202,123,168,195,118,
112, 74,186,102,108,165, 45, 67,254,186, 27,  1, 70, 26,185, 27,
154, 27,154,249,185,253,232,131,116, 86,147, 56, 59, 68,131,115,
 87,150, 53, 58, 69,168, 97,100,229,199,166,  1, 45,119, 79, 83,
104, 97,  1, 82,123,149,149,123,250,252,  1,176,145,162, 83, 81,
 84,220,107,139,156, 82, 77, 83,220,  0,  0,  1,  0, 92,  1,223,
  2,152,  2,131,  0,  3,  0, 22, 64,  9,  2, 99,  0,  4,  2,  0,
  1,  3,  4, 16,212,204, 57, 57, 49,  0, 16,212,236, 48, 19, 33,
  7, 33,125,  2, 27, 31,253,227,  2,131,164,  0,  0,  1,  0,233,
  2, 72,  1,238,  3, 70,  0,  3,  0, 47, 64, 21,  2,  5,  3,  0,
  3,  1,  5,  0,  3, 58,  2, 72,  0,  4,  2,  1,  0,  0,  0,  3,
  4, 16,212,228, 16,192, 57, 49,  0, 16,212,236, 48, 75, 83, 88,
  7,  5,237,  7, 16,  5,237, 89, 34,  1, 51,  7, 35,  1, 27,211,
 50,211,  3, 70,254,  0,  0,  1,255,217,255,227,  4,219,  5,240,
  0, 43,  0,140, 64, 62, 29, 15,144, 13, 22, 23, 19, 90, 26,  1,
101,  0,116,  4, 90, 41, 37,  7,144, 31, 13, 35,  9, 41, 86, 26,
 81, 44, 31, 44, 37, 36, 35, 32, 29, 15, 13, 10,  3, 16,  9, 14,
  8, 38, 29,  7, 16, 14,  1, 22, 23,  3,  0,  8, 14, 16,  8, 30,
 36,  0, 29, 44, 16,212,196,196,196,252,196,196, 17, 23, 57, 17,
 18, 57, 17, 57, 17, 18, 57, 17, 23, 57, 18, 57, 57, 17, 57, 18,
 57, 49,  0, 16,228,228,212, 60,204, 50,236, 50, 16,238,246,238,
 16,238,214,198, 16,238, 50, 48, 64, 21,111, 12,111, 13,111, 14,
111, 15,111, 16,111, 29,111, 30,111, 31,111, 32,111, 33, 10, 93,
  1,  7, 46,  1, 35, 34,  6,  7, 33,  7, 33, 14,  1,  7, 33,  7,
 33, 30,  1, 51, 50, 54, 55,  7, 14,  1, 35, 34,  0,  3, 35, 55,
 51, 62,  1, 55, 35, 55, 51, 18,  0, 51, 50, 22,  4,219, 33, 83,
167, 96,143,216, 71,  2,  8, 53,254,  8, 12, 16,  4,  1,188, 55,
254,119,  9,159,151,109,192,102, 39, 94,198, 97,223,254,249, 10,
198, 55,145,  5, 16, 11,173, 56,151, 97,  1, 64,228,103,185,  5,
 98,213,101, 94,195,192,123, 50,102, 55,123,195,194, 86, 96,239,
 51, 52,  1, 36,  1,  1,123, 55,103, 49,123,  1, 20,  1, 15, 71,
  0,  2,  1,111,  5, 14,  3,231,  5,217,  0,  3,  0,  7,  0,178,
 64, 19,  4,  0,139,  6,  2,  8,  6,  4,  7,  5,  2,  0,  3,  1,
  5,  7,  1,  3,  8, 16,212,220,212,204, 17, 18, 57, 57, 17, 18,
 57, 57, 49,  0, 16,212, 60,236, 50, 48, 64, 34, 64,  1, 64,  2,
 64,  5, 64,  6, 80,  1, 80,  2, 80,  5, 80,  6,  8, 79,  0, 79,
  1, 79,  4, 79,  5, 95,  0, 95,  1, 95,  4, 95,  5,  8, 93,  1,
 93,  1, 75,176, 14, 84, 75,176, 15, 84, 91, 75,176, 16, 84, 91,
 75,176,  9, 84, 91, 88,189,  0,  8,  0, 64,  0,  1,  0,  8,  0,
  8,255,192, 56, 17, 55, 56, 89,  0, 75,176, 17, 84, 75,176, 14,
 84, 91, 88,189,  0,  8,  0, 64,  0,  1,  0,  8,  0,  8,255,192,
 56, 17, 55, 56, 89,  1, 75,176, 18, 84, 75,176, 19, 84, 91, 88,
189,  0,  8,255,192,  0,  1,  0,  8,  0,  8,  0, 64, 56, 17, 55,
 56, 89,  1, 51,  7, 35, 37, 51,  7, 35,  1,150,204, 41,202,  1,
174,202, 38,203,  5,217,203,203,203,  0,  0,  1,  2,  4,  4,238,
  3,213,  5,246,  0,  3,  0,194,181,  0,  2,  4,  1,  3,  4, 16,
212,196, 49,  0, 16,212,196, 48, 64,  9, 11,  0, 11,  1, 11,  2,
 11,  3,  4,  1, 93,  1, 75,176, 10, 84, 75,176,  9, 84, 91, 75,
176, 11, 84, 91, 75,176, 18, 84, 91, 88,189,  0,  4,  0, 64,  0,
  1,  0,  4,  0,  4,255,192, 56, 17, 55, 56, 89, 64,  9, 25,  0,
 25,  1, 29,  2, 27,  3,  4, 93,  0, 75,176, 12, 84, 88,189,  0,
  4,255,192,  0,  1,  0,  4,  0,  4,  0, 64, 56, 17, 55, 56, 89,
 64, 40, 15,  0, 15,  1, 31,  0, 31,  1, 42,  0, 42,  1, 41,  3,
 54,  1, 54,  2, 71,  1, 71,  2, 87,  1, 87,  2, 13, 15,  0, 15,
  1, 31,  0, 31,  1, 47,  0, 47,  1,  6, 93,  1, 93,  0, 75,176,
 14, 84, 88,189,  0,  4,  0, 64,  0,  1,  0,  4,  0,  4,255,192,
 56, 17, 55, 56, 89, 64, 17,102,  1,102,  2,138,  1,138,  2,156,
  1,156,  2,175,  1,175,  2,  8,  1, 93,  1, 51,  1, 35,  3,  6,
207,254,205,158,  5,246,254,248,  0,  1,  1, 76,  5, 14,  4, 23,
  5,233,  0, 27,  0,110, 64, 28, 15, 14, 18, 11,  2,  1,  0,  3,
  7,  4, 87, 21, 11, 18, 87, 25,  7, 28, 21, 15, 14,  7,  2,  0,
  6, 22,  8, 28, 16,212,196, 23, 57, 49,  0, 16,212, 60,252,212,
 60,236, 17, 23, 57, 17, 18, 57, 57, 48,  0, 75,176, 17, 84, 75,
176, 14, 84, 91, 88,189,  0, 28,  0, 64,  0,  1,  0, 28,  0, 28,
255,192, 56, 17, 55, 56, 89,  1, 75,176, 17, 84, 75,176, 11, 84,
 91, 88,189,  0, 28,  0, 64,  0,  1,  0, 28,  0, 28,255,192, 56,
 17, 55, 56, 89,  1, 47,  1, 38, 35, 34,  6,  7, 35, 62,  1, 51,
 50, 22, 31,  1, 30,  1, 51, 50, 54, 55, 51, 14,  1, 35, 34, 38,
  2,168, 35,  1, 43, 38, 34, 54, 18,125, 35,123, 85, 35, 61, 36,
 32, 18, 38, 20, 39, 57, 11,125, 33,125, 92, 31, 55,  5, 57, 25,
  1, 32, 51, 50,109,110, 22, 25, 26, 14, 13, 54, 46,109,110, 21,
  0,  1,  1,209,  4,238,  3, 27,  5,246,  0,  3,  0,136,182,  0,
  1,  4,  0,  1,  3,  4, 16,212,196, 57, 49,  0, 16,212,196, 48,
  0, 75,176, 12, 84, 88,189,  0,  4,255,192,  0,  1,  0,  4,  0,
  4,  0, 64, 56, 17, 55, 56, 89, 64, 20,  3,  0, 10,  1,  0,  3,
  3, 15,  0, 15,  3, 31,  0, 31,  3, 47,  0, 47,  3,  6, 93,  1,
 93,  0, 75,176, 14, 84, 88,189,  0,  4,  0, 64,  0,  1,  0,  4,
  0,  4,255,192, 56, 17, 55, 56, 89,  1, 75,176, 11, 84, 75,176,
 17, 84, 91, 88,189,  0,  4,  0, 64,  0,  1,  0,  4,  0,  4,255,
192, 56, 17, 55, 56, 89, 64, 13,116,  0,116,  1,134,  0,136,  1,
138,  2,135,  3,  6, 93,  1, 19, 35,  3,  2,135,148,140,190,  5,
246,254,248,  1,  8,  0,  0,  1,  1, 82,  4,238,  3,205,  5,248,
  0,  6,  0,143, 64,  9,  4,  0,  5,  2,  7,  4,  2,  6,  7, 16,
212,196, 57, 49,  0, 16,212, 60,196, 57, 48,  0, 75,176,  9, 84,
 75,176, 10, 84, 91, 75,176, 11, 84, 91, 75,176, 12, 84, 91, 88,
189,  0,  7,255,192,  0,  1,  0,  7,  0,  7,  0, 64, 56, 17, 55,
 56, 89, 64, 25,  0,  2,  0,  3,  0,  5,  0,  6, 16,  2, 16,  3,
 16,  5, 16,  6, 32,  2, 32,  3, 32,  5, 32,  6, 12, 93,  0, 75,
176, 14, 84, 88,189,  0,  7,  0, 64,  0,  1,  0,  7,  0,  7,255,
192, 56, 17, 55, 56, 89,  1, 75,176, 16, 84, 75,176, 17, 84, 91,
 88,189,  0,  7,  0, 64,  0,  1,  0,  7,  0,  7,255,192, 56, 17,
 55, 56, 89,  1, 51, 19, 35, 39,  7, 35,  2, 88,215,158,135,140,
209,151,  5,248,254,246,178,178,  0,  1,  1,145,  4,238,  4, 10,
  5,248,  0,  6,  0, 99, 64,  9,  4,  5,  2,  0,  7,  4,  6,  2,
  7, 16,212,196, 57, 49,  0, 16,212,196, 50, 57, 48, 64, 25, 15,
  2, 15,  3, 15,  5, 15,  6, 31,  2, 31,  3, 31,  5, 31,  6, 47,
  2, 47,  3, 47,  5, 47,  6, 12, 93,  0, 75,176, 12, 84, 88,189,
  0,  7,255,192,  0,  1,  0,  7,  0,  7,  0, 64, 56, 17, 55, 56,
 89,  0, 75,176, 14, 84, 88,189,  0,  7,  0, 64,  0,  1,  0,  7,
  0,  7,255,192, 56, 17, 55, 56, 89,  1, 35,  3, 51, 23, 55, 51,
  3,  4,213,158,134,139,209,151,  4,238,  1, 10,178,178,  0,  2,
  0, 84,  2,156,  3, 31,  5,223,  0,  2,  0, 13,  0,210, 64, 42,
  2, 65,  9,  4, 11, 65,  9,  4, 10, 65,  9,  9,  4, 58,  0,  3,
  5,  1,156, 11,  7,  9,174,  3, 86, 14, 11, 10,  2,  1,  0,  5,
 12,  8,  5,  9,  7,  6,  9,  4, 12, 14, 16,212,212,196,192, 57,
 18, 57, 57, 17, 23, 57, 49,  0, 16,244,252,212, 60,236, 50, 17,
 57, 48, 75, 83, 88,  7, 16,  5,237,  7,  5,237,  7,  5,237, 89,
 34,  1, 75,176, 13, 84, 75,176, 12, 84, 91, 75,176, 11, 84, 91,
 75,176, 10, 84, 91, 75,176, 20, 84, 91, 75,176, 19, 84, 91, 75,
176, 18, 84, 91, 88,189,  0, 14,  0, 64,  0,  1,  0, 14,  0, 14,
255,192, 56, 17, 55, 56, 89, 64, 31, 14,  1, 30,  1, 27,  6, 27,
  7, 41,  0, 43,  1, 47,  1, 45,  6, 45,  7, 47, 12, 47, 13, 54,
  3, 70,  3,121,  3,172,  0, 15, 93,  1, 75,176, 17, 84, 75,176,
 15, 84, 91, 75,176, 14, 84, 91, 75,176, 16, 84, 91, 88,189,  0,
 14,  0,128,  0,  1,  0, 14,  0, 14,255,128, 56, 17, 55, 56, 89,
  9,  1, 33, 19, 51,  3, 51,  7, 35,  7, 35, 55, 33, 55,  2, 90,
254,119,  1, 55, 82,166,106,137, 21,137, 37,141, 37,254, 96, 25,
  5, 98,254, 97,  2, 28,253,228,109,186,186,131,  0,  1,  1,133,
  5,  6,  3,248,  5,248,  0, 13,  0, 79, 64, 11,  7,  0,  4,168,
 11, 14,  7,  8,  1,  0, 14, 16,212,204,212,204, 49,  0, 16,212,
252,196, 50, 48,  0, 75,176, 17, 84, 75,176, 14, 84, 91, 88,189,
  0, 14,  0, 64,  0,  1,  0, 14,  0, 14,255,192, 56, 17, 55, 56,
 89,  1, 75,176, 17, 84, 88,189,  0, 14,255,192,  0,  1,  0, 14,
  0, 14,  0, 64, 56, 17, 55, 56, 89,  1, 51, 30,  1, 51, 50, 54,
 55, 51, 14,  1, 35, 34, 38,  1,133,119, 12, 78, 76, 86,108, 29,
119, 34,184,128,121,140,  5,248, 61, 54, 55, 60,113,129,121,  0,
  0,  1,  2, 49,  5, 14,  3, 37,  5,219,  0,  3,  0,108, 64, 18,
  2,  3,  0,  3,  1,  0,  0,  3, 58,  0,  2,  4,  2,  0,  1,  3,
  3,  4, 16,196, 16,192, 57, 57, 49,  0, 16,212,204, 48, 75, 83,
 88,  7, 16,  5,201,  7, 16,  5,201, 89, 34,  0, 75,176, 14, 84,
 88,189,  0,  4,  0, 64,  0,  1,  0,  4,  0,  4,255,192, 56, 17,
 55, 56, 89, 64, 10, 83,  1, 83,  2,  2, 95,  0, 95,  1,  2, 93,
  1, 93,  1, 75,176, 11, 84, 88,189,  0,  4,  0, 64,  0,  1,  0,
  4,  0,  4,255,192, 56, 17, 55, 56, 89,  1, 51,  7, 35,  2, 90,
203, 39,205,  5,219,205,  0,  0,  0,  0,  0,  2,  0,  1,  0,  0,
  0,  0,  0, 20,  0,  3,  0,  1,  0,  0,  1, 26,  0,  0,  1,  6,
  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  1,  3,  0,  0,  0,  2,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,
  0,  0,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16,
 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96,
 97,  0, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,
112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
208,209,  0,210,211,212,213,214,215,216,217,218,219,220,221,222,
223,224,  0,  4,  2, 62,  0,  0,  0, 58,  0, 32,  0,  4,  0, 26,
  0,126,  0,255,  1,  7,  1, 17,  1, 31,  1, 49,  1, 66,  1, 83,
  1, 97,  1,120,  1,126,  1,146,  2,199,  2,221,  3,169,  3,192,
 32, 38, 32, 48, 32, 58, 32,172, 33, 34, 34,  6, 34, 30, 34, 43,
 34, 72, 34,101, 37,202,251,  2,255,255,  0,  0,  0, 32,  0,160,
  1,  6,  1, 12,  1, 30,  1, 48,  1, 65,  1, 82,  1, 94,  1,120,
  1,125,  1,146,  2,198,  2,216,  3,169,  3,192, 32, 19, 32, 48,
 32, 57, 32,172, 33, 34, 34,  2, 34, 15, 34, 43, 34, 72, 34, 96,
 37,202,251,  1,255,255,255,227,  0,  0,255,245,  0,  0,255,216,
  0,  0,255,160,255, 94,  0,  0,255, 67,255,104,255, 20,  0,  0,
  0,  0,252,246,252,219,  0,  0,224,150,224,133,224, 86,223,106,
  0,  0,  0,  0,222,113,222, 95,  0,  0,218,239,  5,191,  0,  1,
  0,  0,  0, 56,  0,  0,  0,244,  0,  0,  0,252,  0,  0,  0,  0,
  0,250,  0,  0,  0,  0,  0,  0,  0,250,  0,252,  0,  0,  0,  0,
  1,  2,  0,  0,  0,  0,  0,  0,  0,  0,  1, 32,  1, 40,  0,  0,
  0,  0,  1, 66,  0,  0,  0,  0,  0,  0,  0,172,  0,163,  0,132,
  0,133,  0,189,  0,150,  0,231,  0,134,  0,142,  0,139,  0,157,
  0,169,  0,164,  1,  0,  0,138,  0,217,  0,131,  0,147,  0,241,
  0,242,  0,141,  0,151,  0,136,  0,195,  0,221,  0,240,  0,158,
  0,170,  0,243,  0,244,  0,245,  0,162,  0,173,  0,201,  0,199,
  0,174,  0, 98,  0, 99,  0,144,  0,100,  0,203,  0,101,  0,200,
  0,202,  0,207,  0,204,  0,205,  0,206,  0,232,  0,102,  0,210,
  0,208,  0,209,  0,175,  0,103,  0,239,  0,145,  0,213,  0,211,
  0,212,  0,104,  0,234,  0,236,  0,137,  0,106,  0,105,  0,107,
  0,109,  0,108,  0,110,  0,160,  0,111,  0,113,  0,112,  0,114,
  0,115,  0,117,  0,116,  0,118,  0,119,  0,233,  0,120,  0,122,
  0,121,  0,123,  0,125,  0,124,  0,184,  0,161,  0,127,  0,126,
  0,128,  0,129,  0,235,  0,237,  0,186,  0,253,  0,254,  0,  0,
  0,  0,  0,  0,  0,255,  0,248,  0,214,  0,249,  0,250,  0,227,
  0,228,  0,215,  0,224,  0,218,  0,219,  0,220,  0,223,  0,216,
  0,222,  0,178,  0,179,  0,  0,  0,  0,  0,  0,  0,182,  0,183,
  0,196,  0,  0,  0,180,  0,181,  0,197,  0,  0,  0,130,  0,194,
  0,135,  0,  0,  0,  0,  0,  0,  0,171,  0,152,  0,  0,  0,  0,
  0,  0,  0,168,  0,154,  0,  0,  0,153,  0,238,  0,  0,  0,  0,
  0,188,  0,  0,  0,  0,  0,  0,  1,  1,  0,165,  0,  0,  0,  0,
  0,  0,  0,146,  0,143,  0,  0,  0,  0,  0,  0,  0,148,  0,149,
  4,205,  0,102,  0,  0,  0,  0,  2,139,  0,  0,  2,139,  0,  0,
  3, 53,  0,162,  3,174,  0,197,  6,180,  0,143,  5, 23,  0, 68,
  7,154,  0,186,  6, 61,  0, 96,  2, 51,  0,197,  3, 31,  0,158,
  3, 31,255,129,  4,  0,  0, 61,  6,180,  0,217,  2,139,  0,  6,
  2,227,  0, 92,  2,139,  0,119,  2,178,255,106,  5, 23,  0,102,
  5, 23,  0,100,  5, 23,  0,  8,  5, 23,  0,  4,  5, 23,  0, 37,
  5, 23,  0, 41,  5, 23,  0,129,  5, 23,  0,190,  5, 23,  0, 68,
  5, 23,  0, 90,  2,178,  0,106,  2,178,  0,  2,  6,180,  0,217,
  6,180,  0,217,  6,180,  0,217,  4, 63,  0,252,  8,  0,  0,119,
  5,121,255,147,  5,125,  0, 55,  5,150,  0, 86,  6, 41,  0, 55,
  5, 14,  0, 55,  4,154,  0, 55,  6, 51,  0, 92,  6,  4,  0, 55,
  2, 92,  0, 55,  2, 92,254,176,  5, 63,  0, 55,  4,117,  0, 55,
  6,231,  0, 55,  5,252,  0, 55,  6, 76,  0, 82,  4,211,  0, 55,
  6, 76,  0, 84,  5,143,  0, 55,  5, 20,  0, 12,  4,227,  0, 88,
  5,219,  0,119,  5,121,  0,160,  7,233,  0,197,  5,123,255,168,
  4,227,  0,129,  5,123,255,211,  3, 31,  0, 82,  2,178,  0,174,
  3, 31,255,178,  6,180,  0,217,  4,  0,255,236,  4,  0,  1,133,
  4,231,  0, 84,  5, 20,  0, 74,  4,102,  0, 94,  5, 20,  0, 94,
  4,236,  0, 94,  2,209,  0,139,  5, 20,  0, 66,  5, 18,  0, 72,
  2, 57,  0, 72,  2, 57,255, 25,  4,162,  0, 72,  2, 57,  0, 72,
  7,203,  0, 72,  5, 18,  0, 72,  4,229,  0, 94,  5, 20,255,250,
  5, 20,  0, 94,  3, 74,  0, 72,  4, 43,  0, 23,  3, 35,  0,131,
  5, 18,  0,117,  4,188,  0,147,  6,139,  0,174,  4,188,255,203,
  4,188,255,205,  4, 51,255,250,  5, 23,  0,248,  2,178,  1,  4,
  5, 23,  0, 14,  6,180,  0,217,  5,121,255,147,  5,121,255,147,
  5,150,  0, 86,  5, 14,  0, 55,  5,252,  0, 55,  6, 76,  0, 82,
  5,219,  0,119,  4,231,  0, 84,  4,231,  0, 84,  4,231,  0, 84,
  4,231,  0, 84,  4,231,  0, 84,  4,231,  0, 84,  4,102,  0, 94,
  4,236,  0, 94,  4,236,  0, 94,  4,236,  0, 94,  4,236,  0, 94,
  2, 57,  0, 72,  2, 57,  0, 72,  2, 57,  0, 72,  2, 57,  0, 72,
  5, 18,  0, 72,  4,229,  0, 94,  4,229,  0, 94,  4,229,  0, 94,
  4,229,  0, 94,  4,229,  0, 94,  5, 18,  0,117,  5, 18,  0,117,
  5, 18,  0,117,  5, 18,  0,117,  4,  0,  0, 86,  4,  0,  0,195,
  5, 23,  0,152,  5, 23,  0, 49,  4,  0,  0, 25,  4,184,  1, 51,
  5, 23,  0,160,  5, 10,  0, 96,  8,  0,  1, 27,  8,  0,  1, 27,
  8,  0,  1, 39,  4,  0,  2,  4,  4,  0,  1,121,  6,180,  0,217,
  7,203,255,164,  6, 76,255,186,  6,170,  0,221,  6,180,  0,217,
  6,180,  0,217,  6,180,  0,217,  5, 23,  0, 92,  5, 23,255,229,
  4, 35,  0,104,  5,100,  0, 25,  6, 14,  0,156,  4,182,255,225,
  4, 43,  0, 47,  3,197,  0, 82,  3,197,  0, 82,  6, 29,  0, 78,
  7,246,  0, 84,  4,229,255,227,  4, 63,  0, 76,  3, 53,  0,174,
  6,180,  0,217,  5, 25,  0, 61,  5, 23,255,209,  6,180,  0,217,
  5, 90,255,250,  4,240,  0,127,  4,240,  0,127,  8,  0,  0,133,
  5, 23,  0,  0,  5,121,255,147,  5,121,255,147,  6, 76,  0, 82,
  8,143,  0, 94,  8, 57,  0, 94,  4,  0,255,242,  8,  0,255,242,
  4, 37,  1, 12,  4, 37,  1, 20,  2,139,  1, 12,  2,139,  1, 20,
  6,180,  0,217,  3,244,  0,  6,  4,188,255,205,  4,227,  0,129,
  1, 86,253,231,  5, 23,  0, 94,  3, 51,  0,127,  3, 51,  0,127,
  5, 43,  0,139,  5, 43,  0,139,  4,  0,255,221,  2,139,  0,233,
  2,139,  0,  6,  4, 37,  0,  6, 10,205,  0,186,  5,121,255,147,
  5, 14,  0, 55,  5,121,255,147,  5, 14,  0, 55,  5, 14,  0, 55,
  2, 92,  0, 55,  2, 92,  0, 55,  2, 92,  0, 55,  2, 92,  0, 55,
  6, 76,  0, 82,  6, 76,  0, 82,  6, 76,  0, 82,  5,219,  0,119,
  5,219,  0,119,  5,219,  0,119,  2, 57,  0, 72,  4,  0,  1, 82,
  4,  0,  1, 80,  4,  0,  1,125,  4,  0,  1,154,  4,  0,  2, 59,
  4,  0,  1,172,  4,  0,  0,100,  4,  0,  1,129,  4,  0,  0,201,
  4,  0,  1,154,  4,127,255,215,  2, 76,  0, 35,  5, 20,  0, 12,
  4, 43,  0, 23,  5,123,255,211,  4, 51,255,250,  2,178,  1,  4,
  6, 51,  0,  0,  4,229,  0, 92,  4,227,  0,129,  4,188,255,205,
  4,221,  0, 55,  5, 20,255,250,  6,180,  0,217,  6,180,  1, 25,
  3, 53,  0,135,  3, 53,  0, 74,  3, 53,  0, 33,  7,193,  0,135,
  7,193,  0,135,  7,193,  0, 33,  6, 51,  0, 92,  5, 20,  0, 66,
  2, 92,  0, 55,  5, 20,  0, 12,  4, 43,  0, 23,  5,150,  0, 86,
  4,102,  0, 94,  5,150,  0, 86,  4,102,  0, 94,  5, 20,  0, 94,
  2,227,  0, 92,  2,139,  0,233,  5, 23,255,217,  4,  0,  1,111,
  4,  0,  2,  4,  4,  0,  1, 76,  4,  0,  1,209,  4,  0,  1, 82,
  4,  0,  1,145,  3, 53,  0, 84,  4,  0,  1,133,  4,  0,  2, 49,
  0,  2,  0,  0,255,245,  0,  0,255, 43,  0,143,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  1, 12,  0,  0,  0,  1,  0,  2,  0,  3,  0,  4,  0,  5,  0,  6,
  0,  7,  0,  8,  0,  9,  0, 10,  0, 11,  0, 12,  0, 13,  0, 14,
  0, 15,  0, 16,  0, 17,  0, 18,  0, 19,  0, 20,  0, 21,  0, 22,
  0, 23,  0, 24,  0, 25,  0, 26,  0, 27,  0, 28,  0, 29,  0, 30,
  0, 31,  0, 32,  0, 33,  0, 34,  0, 35,  0, 36,  0, 37,  0, 38,
  0, 39,  0, 40,  0, 41,  0, 42,  0, 43,  0, 44,  0, 45,  0, 46,
  0, 47,  0, 48,  0, 49,  0, 50,  0, 51,  0, 52,  0, 53,  0, 54,
  0, 55,  0, 56,  0, 57,  0, 58,  0, 59,  0, 60,  0, 61,  0, 62,
  0, 63,  0, 64,  0, 65,  0, 66,  0, 67,  0, 68,  0, 69,  0, 70,
  0, 71,  0, 72,  0, 73,  0, 74,  0, 75,  0, 76,  0, 77,  0, 78,
  0, 79,  0, 80,  0, 81,  0, 82,  0, 83,  0, 84,  0, 85,  0, 86,
  0, 87,  0, 88,  0, 89,  0, 90,  0, 91,  0, 92,  0, 93,  0, 94,
  0, 95,  0, 96,  0, 97,  0, 98,  0, 99,  0,100,  0,101,  0,102,
  0,103,  0,104,  0,105,  0,106,  0,107,  0,108,  0,109,  0,110,
  0,111,  0,112,  0,113,  0,114,  0,115,  0,116,  0,117,  0,118,
  0,119,  0,120,  0,121,  0,122,  0,123,  0,124,  0,125,  0,126,
  0,127,  0,128,  0,129,  0,130,  0,131,  0,132,  0,133,  0,134,
  0,135,  0,136,  0,137,  0,138,  0,139,  0,140,  0,141,  0,142,
  0,143,  0,144,  0,145,  0,146,  0,147,  0,148,  0,149,  0,150,
  0,151,  0,152,  0,153,  0,154,  0,155,  0,156,  0,157,  0,158,
  0,159,  0,160,  0,161,  0,162,  0,163,  0,164,  0,165,  0,166,
  0,167,  0,168,  0,169,  0,170,  0,171,  0,172,  0,173,  0,174,
  0,175,  0,176,  0,177,  0,178,  0,179,  0,180,  0,181,  0,182,
  0,183,  0,184,  0,185,  0,186,  0,187,  0,188,  0,189,  0,190,
  0,191,  0,192,  0,193,  0,194,  0,195,  0,196,  0,197,  0,198,
  0,199,  0,200,  0,201,  0,202,  0,203,  0,204,  0,205,  0,206,
  0,207,  0,208,  0,209,  0,211,  0,212,  0,213,  0,214,  0,215,
  0,216,  0,217,  0,218,  0,219,  0,220,  0,221,  0,222,  0,223,
  0,224,  0,225,  0,226,  0,227,  0,228,  0,229,  0,230,  0,231,
  0,232,  0,233,  0,234,  0,235,  0,236,  0,237,  0,238,  0,239,
  0,240,  0,241,  0,242,  0,243,  0,245,  0,244,  0,246,  0,248,
  0,249,  0,250,  0,251,  0,252,  0,253,  0,254,  0,255,  1,  0,
  1,  1,  1,  2,  1,  3,  1,  4,  1,  5,  1,  6,  1,  7,  1,  8,
  1,  9,  1, 10,  1, 11,  1, 12,  1, 13,  9,115,102,116,104,121,
112,104,101,110, 14,112,101,114,105,111,100, 99,101,110,116,101,
114,101,100,  4, 69,117,114,111,  5, 99, 54, 52, 53, 57,  5, 99,
 54, 52, 54, 48,  5, 99, 54, 52, 54, 49,  5, 99, 54, 52, 54, 50,
  5, 99, 54, 52, 54, 51,  5, 99, 54, 52, 54, 54,  5, 99, 54, 52,
 54, 55,  5, 99, 54, 52, 54, 56,  5, 99, 54, 52, 54, 57,  0,  0,
  0,  0,  0, 34,  0, 34,  0, 34,  0, 34,  0,122,  0,157,  1,  2,
  1,131,  1,253,  2,206,  2,230,  3, 21,  3, 70,  3,147,  3,189,
  4, 16,  4, 61,  4,114,  4,151,  4,244,  5, 56,  5,177,  6, 60,
  6,192,  7, 57,  7,219,  8, 48,  8,169,  9, 57,  9,130,  9,233,
 10, 37, 10, 70, 10,129, 11,  8, 11,159, 12, 13, 12,124, 12,220,
 13, 42, 13,114, 13,180, 14, 49, 14,139, 14,178, 14,241, 15,135,
 15,181, 16, 99, 16,231, 17, 79, 17,164, 18, 45, 18,167, 19, 48,
 19,127, 20,  4, 20, 90, 20,254, 21,196, 22, 51, 22,116, 22,177,
 22,216, 23, 15, 23, 49, 23, 71, 23,139, 24, 90, 24,240, 25, 72,
 25,219, 26, 95, 26,215, 27,131, 28, 10, 28, 86, 28,212, 29, 96,
 29,153, 30, 87, 30,221, 31, 50, 31,212, 32,102, 32,220, 33,123,
 33,250, 34,135, 34,247, 35,209, 36,181, 37,109, 37,197, 38,148,
 38,171, 39, 79, 39,145, 39,158, 40, 69, 40, 82, 40, 95, 40,108,
 40,121, 40,134, 40,147, 40,160, 40,173, 40,186, 40,199, 40,212,
 40,225, 40,238, 40,251, 41,  8, 41, 21, 41, 34, 41, 47, 41, 60,
 41, 73, 41, 86, 41, 99, 41,112, 41,125, 41,138, 41,151, 41,164,
 41,177, 41,190, 41,203, 42, 18, 42, 77, 42,222, 43, 79, 43,242,
 44, 18, 44,102, 45, 56, 45,222, 46,111, 46,180, 47,  5, 47,102,
 47,171, 48, 52, 49, 18, 49,118, 49,173, 49,244, 50, 58, 50,221,
 51,104, 51,195, 52, 13, 52, 47, 52,157, 52,237, 53,111, 53,189,
 54, 21, 55, 13, 55,211, 56,105, 56,182, 56,210, 57,  1, 57,133,
 57,254, 58, 36, 58, 97, 58,157, 58,241, 58,241, 58,254, 59, 11,
 59, 24, 59,155, 60, 88, 60,114, 60,140, 60,243, 61, 90, 61,149,
 61,209, 61,255, 62, 41, 62, 54, 62, 67, 62,129, 63, 13, 63, 48,
 63, 82, 63,247, 64,139, 64,246, 65, 27, 65, 69, 65,142, 66, 52,
 66, 65, 66, 78, 66, 91, 66,104, 66,117, 66,130, 66,143, 66,156,
 66,169, 66,182, 66,195, 66,208, 66,221, 66,234, 66,247, 67, 44,
 67,112, 68, 25, 68, 89, 68,194, 69, 19, 69,164, 69,216, 70, 46,
 70,111, 70,179, 71,  3, 71, 83, 71, 96, 71,109, 71,122, 71,135,
 71,170, 72, 25, 72,196, 72,209, 72,222, 73, 64, 73,224, 73,246,
 74, 90, 74,179, 75, 73, 75,186, 75,203, 75,220, 75,237, 75,250,
 76,  7, 76, 20, 76, 33, 76, 46, 76, 59, 76, 72, 76, 85, 76, 98,
 77, 23, 77, 48, 77, 85, 77,226, 78, 79, 78,190, 79, 34, 79,117,
 79,206, 80, 17, 80,152, 80,218, 81, 29,  0,  0,  0,  0,  0,  1,
  0,  0, 14,210,  0,  1,  2,118, 12,  0,  0,  9,  2,196,  0, 16,
  0, 55,255,107,  0, 16,  0, 57,255,173,  0, 16,  0, 58,255,220,
  0, 16,  0, 59,255,183,  0, 16,  0, 60,255,107,  0, 16,  0,187,
255,107,  0, 16,  0,234,255,107,  0, 36,  0, 15,  0, 38,  0, 36,
  0, 17,  0, 38,  0, 36,  0, 29,  0, 38,  0, 36,  0, 30,  0, 38,
  0, 36,  0, 55,255,107,  0, 36,  0, 57,255,154,  0, 36,  0, 58,
255,220,  0, 36,  0,181,254,240,  0, 36,  0,183,254,240,  0, 37,
  0, 16,255,220,  0, 37,  0, 60,255,220,  0, 37,  0,187,255,220,
  0, 37,  0,234,255,220,  0, 38,  0, 54,  0, 38,  0, 38,  0,181,
255,211,  0, 38,  0,183,255,211,  0, 38,  0,227,  0, 38,  0, 38,
  0,249,  0, 38,  0, 41,  0, 15,254,248,  0, 41,  0, 16,255,144,
  0, 41,  0, 17,254,248,  0, 41,  0, 29,255,183,  0, 41,  0, 30,
255,183,  0, 41,  0, 36,255,136,  0, 41,  0, 88,255,173,  0, 41,
  0, 98,255,136,  0, 41,  0,126,255,173,  0, 41,  0,127,255,173,
  0, 41,  0,128,255,173,  0, 41,  0,129,255,173,  0, 41,  0,173,
255,136,  0, 41,  0,174,255,136,  0, 41,  0,199,255,136,  0, 41,
  0,201,255,136,  0, 46,  0, 16,255, 50,  0, 46,  0, 38,255,201,
  0, 46,  0, 50,255,201,  0, 46,  0, 56,255,220,  0, 46,  0, 68,
255,183,  0, 46,  0, 72,255,183,  0, 46,  0, 82,255,183,  0, 46,
  0, 88,255,201,  0, 46,  0, 92,255,201,  0, 46,  0,100,255,201,
  0, 46,  0,103,255,201,  0, 46,  0,104,255,220,  0, 46,  0,105,
255,183,  0, 46,  0,106,255,183,  0, 46,  0,107,255,183,  0, 46,
  0,108,255,183,  0, 46,  0,109,255,183,  0, 46,  0,110,255,183,
  0, 46,  0,112,255,183,  0, 46,  0,113,255,183,  0, 46,  0,114,
255,183,  0, 46,  0,115,255,183,  0, 46,  0,121,255,183,  0, 46,
  0,122,255,183,  0, 46,  0,123,255,183,  0, 46,  0,124,255,183,
  0, 46,  0,125,255,183,  0, 46,  0,126,255,201,  0, 46,  0,127,
255,201,  0, 46,  0,128,255,201,  0, 46,  0,129,255,201,  0, 46,
  0,145,255,201,  0, 46,  0,160,255,220,  0, 46,  0,161,255,164,
  0, 46,  0,175,255,201,  0, 46,  0,176,255,201,  0, 46,  0,177,
255,164,  0, 46,  0,186,255,201,  0, 46,  0,208,255,201,  0, 46,
  0,209,255,201,  0, 46,  0,210,255,201,  0, 46,  0,211,255,220,
  0, 46,  0,212,255,220,  0, 46,  0,213,255,220,  0, 46,  0,235,
255,201,  0, 46,  0,251,255,201,  0, 46,  0,253,255,201,  0, 47,
  0, 16,255, 97,  0, 47,  0, 50,255,193,  0, 47,  0, 55,255,117,
  0, 47,  0, 57,255,107,  0, 47,  0, 58,255,173,  0, 47,  0, 60,
255, 60,  0, 47,  0, 92,255,183,  0, 47,  0,103,255,193,  0, 47,
  0,145,255,193,  0, 47,  0,175,255,193,  0, 47,  0,176,255,193,
  0, 47,  0,180,255, 68,  0, 47,  0,181,254,144,  0, 47,  0,182,
255, 68,  0, 47,  0,183,254,144,  0, 47,  0,186,255,183,  0, 47,
  0,187,255, 60,  0, 47,  0,208,255,193,  0, 47,  0,209,255,193,
  0, 47,  0,210,255,193,  0, 47,  0,234,255, 60,  0, 47,  0,235,
255,183,  0, 50,  0, 15,255,173,  0, 50,  0, 17,255,173,  0, 50,
  0, 29,  0, 38,  0, 50,  0, 30,  0, 38,  0, 50,  0, 59,255,201,
  0, 51,  0, 15,254,230,  0, 51,  0, 16,255,144,  0, 51,  0, 17,
254,230,  0, 51,  0, 29,255,220,  0, 51,  0, 30,255,220,  0, 51,
  0, 36,255,154,  0, 51,  0, 98,255,154,  0, 51,  0,173,255,154,
  0, 51,  0,174,255,154,  0, 51,  0,199,255,154,  0, 51,  0,201,
255,154,  0, 52,  0, 16,  0, 38,  0, 54,  0, 54,255,183,  0, 54,
  0,227,255,183,  0, 54,  0,249,255,183,  0, 55,  0, 15,255, 13,
  0, 55,  0, 16,254,220,  0, 55,  0, 17,255, 13,  0, 55,  0, 29,
255, 68,  0, 55,  0, 30,255, 68,  0, 55,  0, 36,255, 68,  0, 55,
  0, 68,255, 41,  0, 55,  0, 70,255,  3,  0, 55,  0, 72,255,  3,
  0, 55,  0, 82,255,  3,  0, 55,  0, 85,255, 97,  0, 55,  0, 86,
255, 13,  0, 55,  0, 88,255, 50,  0, 55,  0, 90,255, 89,  0, 55,
  0, 92,255, 78,  0, 55,  0, 98,255, 68,  0, 55,  0,105,255, 41,
  0, 55,  0,106,255, 41,  0, 55,  0,107,255, 41,  0, 55,  0,108,
255, 41,  0, 55,  0,109,255, 41,  0, 55,  0,110,255, 41,  0, 55,
  0,111,255,  3,  0, 55,  0,112,255,  3,  0, 55,  0,113,255,  3,
  0, 55,  0,114,255,  3,  0, 55,  0,115,255,  3,  0, 55,  0,121,
255,  3,  0, 55,  0,122,255,  3,  0, 55,  0,123,255,  3,  0, 55,
  0,124,255,  3,  0, 55,  0,125,255,  3,  0, 55,  0,126,255, 50,
  0, 55,  0,127,255, 50,  0, 55,  0,128,255, 50,  0, 55,  0,129,
255, 50,  0, 55,  0,160,255,  3,  0, 55,  0,161,255,  3,  0, 55,
  0,173,255, 68,  0, 55,  0,174,255, 68,  0, 55,  0,177,255,  3,
  0, 55,  0,186,255, 78,  0, 55,  0,199,255, 68,  0, 55,  0,201,
255, 68,  0, 55,  0,228,255, 13,  0, 55,  0,235,255, 78,  0, 55,
  0,250,255, 13,  0, 55,  0,252,255,  3,  0, 55,  0,254,255,  3,
  0, 57,  0, 15,255, 21,  0, 57,  0, 16,255, 78,  0, 57,  0, 17,
255, 21,  0, 57,  0, 29,255,201,  0, 57,  0, 30,255,201,  0, 57,
  0, 36,255,117,  0, 57,  0, 68,255,125,  0, 57,  0, 72,255,136,
  0, 57,  0, 82,255,136,  0, 57,  0, 88,255,220,  0, 57,  0, 98,
255,117,  0, 57,  0,105,255,125,  0, 57,  0,106,255,125,  0, 57,
  0,107,255,125,  0, 57,  0,108,255,125,  0, 57,  0,109,255,125,
  0, 57,  0,110,255,125,  0, 57,  0,112,255,136,  0, 57,  0,113,
255,136,  0, 57,  0,114,255,136,  0, 57,  0,115,255,136,  0, 57,
  0,121,255,136,  0, 57,  0,122,255,136,  0, 57,  0,123,255,136,
  0, 57,  0,124,255,136,  0, 57,  0,125,255,136,  0, 57,  0,126,
255,220,  0, 57,  0,127,255,220,  0, 57,  0,128,255,220,  0, 57,
  0,129,255,220,  0, 57,  0,160,255,107,  0, 57,  0,161,255,136,
  0, 57,  0,173,255,117,  0, 57,  0,174,255,117,  0, 57,  0,177,
255,136,  0, 57,  0,199,255,117,  0, 57,  0,201,255,117,  0, 58,
  0, 15,255, 89,  0, 58,  0, 16,255, 97,  0, 58,  0, 17,255, 89,
  0, 58,  0, 36,255,154,  0, 58,  0, 68,255,144,  0, 58,  0, 85,
255,220,  0, 58,  0, 98,255,154,  0, 58,  0,105,255,144,  0, 58,
  0,106,255,144,  0, 58,  0,107,255,144,  0, 58,  0,108,255,144,
  0, 58,  0,109,255,144,  0, 58,  0,110,255,144,  0, 58,  0,160,
255,144,  0, 58,  0,173,255,154,  0, 58,  0,174,255,154,  0, 58,
  0,181,255,220,  0, 58,  0,183,255,220,  0, 58,  0,199,255,154,
  0, 58,  0,201,255,154,  0, 59,  0, 16,255, 68,  0, 59,  0, 38,
255,220,  0, 59,  0, 50,255,183,  0, 59,  0,100,255,220,  0, 59,
  0,103,255,183,  0, 59,  0,145,255,220,  0, 59,  0,175,255,183,
  0, 59,  0,176,255,201,  0, 59,  0,208,255,183,  0, 59,  0,209,
255,183,  0, 59,  0,210,255,183,  0, 59,  0,251,255,220,  0, 59,
  0,253,255,220,  0, 60,  0, 15,254,248,  0, 60,  0, 16,254,230,
  0, 60,  0, 17,254,248,  0, 60,  0, 29,255, 78,  0, 60,  0, 30,
255, 78,  0, 60,  0, 36,255, 97,  0, 60,  0, 38,255,220,  0, 60,
  0, 50,255,220,  0, 60,  0, 68,255, 68,  0, 60,  0, 72,255, 31,
  0, 60,  0, 76,255,220,  0, 60,  0, 82,255, 31,  0, 60,  0, 88,
255, 68,  0, 60,  0, 98,255, 97,  0, 60,  0,100,255,220,  0, 60,
  0,103,255,220,  0, 60,  0,105,255, 68,  0, 60,  0,106,255, 68,
  0, 60,  0,107,255, 68,  0, 60,  0,108,255, 68,  0, 60,  0,109,
255, 68,  0, 60,  0,110,255, 68,  0, 60,  0,112,255, 31,  0, 60,
  0,113,255, 31,  0, 60,  0,114,255, 31,  0, 60,  0,115,255, 31,
  0, 60,  0,121,255, 31,  0, 60,  0,122,255, 31,  0, 60,  0,123,
255, 31,  0, 60,  0,124,255, 31,  0, 60,  0,125,255, 31,  0, 60,
  0,126,255, 68,  0, 60,  0,127,255, 68,  0, 60,  0,128,255, 68,
  0, 60,  0,129,255, 68,  0, 60,  0,145,255,220,  0, 60,  0,160,
255, 68,  0, 60,  0,161,255, 31,  0, 60,  0,173,255, 97,  0, 60,
  0,174,255, 97,  0, 60,  0,175,255,220,  0, 60,  0,176,255,220,
  0, 60,  0,177,255, 31,  0, 60,  0,180,255,211,  0, 60,  0,182,
255,211,  0, 60,  0,199,255, 97,  0, 60,  0,201,255, 97,  0, 60,
  0,208,255,220,  0, 60,  0,209,255,220,  0, 60,  0,210,255,220,
  0, 60,  0,251,255,220,  0, 60,  0,253,255,220,  0, 61,  0, 16,
255,154,  0, 73,  0, 15,255,220,  0, 73,  0, 16,255,220,  0, 73,
  0, 17,255,220,  0, 73,  0,180,  0,141,  0, 73,  0,181,  0, 94,
  0, 73,  0,182,  0,141,  0, 73,  0,183,  0, 94,  0, 85,  0, 15,
255, 68,  0, 85,  0, 16,255,144,  0, 85,  0, 17,255, 68,  0, 89,
  0, 15,255, 89,  0, 89,  0, 17,255, 89,  0, 90,  0, 15,255,125,
  0, 90,  0, 17,255,125,  0, 92,  0, 15,255, 97,  0, 92,  0, 16,
255,183,  0, 92,  0, 17,255, 97,  0, 98,  0, 15,  0, 38,  0, 98,
  0, 17,  0, 38,  0, 98,  0, 29,  0, 38,  0, 98,  0, 30,  0, 38,
  0, 98,  0, 55,255,107,  0, 98,  0, 57,255,154,  0, 98,  0, 58,
255,220,  0, 98,  0,181,254,240,  0, 98,  0,183,254,240,  0,100,
  0, 54,  0, 38,  0,100,  0,181,255,211,  0,100,  0,183,255,211,
  0,100,  0,227,  0, 38,  0,100,  0,249,  0, 38,  0,103,  0, 15,
255,173,  0,103,  0, 17,255,173,  0,103,  0, 29,  0, 38,  0,103,
  0, 30,  0, 38,  0,103,  0, 59,255,201,  0,144,  0, 16,255,220,
  0,145,  0, 15,255,173,  0,145,  0, 16,  0, 38,  0,145,  0, 17,
255,173,  0,145,  0, 29,  0, 38,  0,145,  0, 30,  0, 38,  0,145,
  0, 59,255,220,  0,173,  0, 15,  0, 38,  0,173,  0, 17,  0, 38,
  0,173,  0, 29,  0, 38,  0,173,  0, 30,  0, 38,  0,173,  0, 55,
255,107,  0,173,  0, 57,255,154,  0,173,  0, 58,255,220,  0,173,
  0,181,254,240,  0,173,  0,183,254,240,  0,174,  0, 15,  0, 38,
  0,174,  0, 17,  0, 38,  0,174,  0, 29,  0, 38,  0,174,  0, 30,
  0, 38,  0,174,  0, 55,255,107,  0,174,  0, 57,255,154,  0,174,
  0, 58,255,220,  0,174,  0,181,254,240,  0,174,  0,183,254,240,
  0,175,  0, 15,255,173,  0,175,  0, 17,255,173,  0,175,  0, 29,
  0, 38,  0,175,  0, 30,  0, 38,  0,175,  0, 59,255,201,  0,180,
  0, 36,255, 13,  0,180,  0, 57,  0, 75,  0,180,  0, 60,  0, 47,
  0,180,  0, 98,255, 13,  0,180,  0,144,254,211,  0,180,  0,173,
255, 13,  0,180,  0,174,255, 13,  0,180,  0,187,  0, 47,  0,180,
  0,199,255, 13,  0,180,  0,201,255, 13,  0,180,  0,234,  0, 47,
  0,182,  0, 36,255, 13,  0,182,  0, 57,  0, 75,  0,182,  0, 60,
  0, 47,  0,182,  0, 98,255, 13,  0,182,  0,144,254,211,  0,182,
  0,173,255, 13,  0,182,  0,174,255, 13,  0,182,  0,187,  0, 47,
  0,182,  0,199,255, 13,  0,182,  0,201,255, 13,  0,182,  0,234,
  0, 47,  0,186,  0, 15,255, 97,  0,186,  0, 16,255,183,  0,186,
  0, 17,255, 97,  0,187,  0, 15,254,248,  0,187,  0, 16,254,230,
  0,187,  0, 17,254,248,  0,187,  0, 29,255, 78,  0,187,  0, 30,
255, 78,  0,187,  0, 36,255, 97,  0,187,  0, 38,255,220,  0,187,
  0, 50,255,220,  0,187,  0, 68,255, 68,  0,187,  0, 72,255, 31,
  0,187,  0, 76,255,220,  0,187,  0, 82,255, 31,  0,187,  0, 88,
255, 68,  0,187,  0, 98,255, 97,  0,187,  0,100,255,220,  0,187,
  0,103,255,220,  0,187,  0,105,255, 68,  0,187,  0,106,255, 68,
  0,187,  0,107,255, 68,  0,187,  0,108,255, 68,  0,187,  0,109,
255, 68,  0,187,  0,110,255, 68,  0,187,  0,112,255, 31,  0,187,
  0,113,255, 31,  0,187,  0,114,255, 31,  0,187,  0,115,255, 31,
  0,187,  0,121,255, 31,  0,187,  0,122,255, 31,  0,187,  0,123,
255, 31,  0,187,  0,124,255, 31,  0,187,  0,125,255, 31,  0,187,
  0,126,255, 68,  0,187,  0,127,255, 68,  0,187,  0,128,255, 68,
  0,187,  0,129,255, 68,  0,187,  0,145,255,220,  0,187,  0,160,
255, 68,  0,187,  0,161,255, 31,  0,187,  0,173,255, 97,  0,187,
  0,174,255, 97,  0,187,  0,175,255,220,  0,187,  0,176,255,220,
  0,187,  0,177,255, 31,  0,187,  0,180,255,211,  0,187,  0,182,
255,211,  0,187,  0,199,255, 97,  0,187,  0,201,255, 97,  0,187,
  0,208,255,220,  0,187,  0,209,255,220,  0,187,  0,210,255,220,
  0,187,  0,251,255,220,  0,187,  0,253,255,220,  0,196,  0, 38,
255,183,  0,196,  0, 50,255,183,  0,196,  0, 52,255,183,  0,196,
  0, 55,255, 31,  0,196,  0, 57,254,248,  0,196,  0, 58,255,107,
  0,196,  0, 60,254,173,  0,196,  0, 73,255,183,  0,196,  0, 89,
255,144,  0,196,  0, 90,255,183,  0,196,  0, 92,255,164,  0,196,
  0,100,255,183,  0,196,  0,103,255,183,  0,196,  0,145,255,201,
  0,196,  0,175,255,183,  0,196,  0,176,255,183,  0,196,  0,186,
255,164,  0,196,  0,187,254,173,  0,196,  0,192,255,183,  0,196,
  0,193,255,183,  0,196,  0,208,255,183,  0,196,  0,209,255,183,
  0,196,  0,210,255,183,  0,196,  0,234,254,173,  0,196,  0,235,
255,164,  0,196,  0,251,255,183,  0,196,  0,253,255,183,  0,197,
  0, 38,255,183,  0,197,  0, 50,255,183,  0,197,  0, 52,255,183,
  0,197,  0, 55,255, 31,  0,197,  0, 57,254,248,  0,197,  0, 58,
255,107,  0,197,  0, 60,254,173,  0,197,  0, 73,255,183,  0,197,
  0, 89,255,107,  0,197,  0, 90,255,183,  0,197,  0, 92,255,144,
  0,197,  0,100,255,183,  0,197,  0,103,255,183,  0,197,  0,145,
255,201,  0,197,  0,175,255,183,  0,197,  0,176,255,183,  0,197,
  0,186,255,144,  0,197,  0,187,254,173,  0,197,  0,192,255,183,
  0,197,  0,193,255,183,  0,197,  0,208,255,183,  0,197,  0,209,
255,183,  0,197,  0,210,255,183,  0,197,  0,234,254,173,  0,197,
  0,235,255,144,  0,197,  0,251,255,183,  0,197,  0,253,255,183,
  0,199,  0, 15,  0, 38,  0,199,  0, 17,  0, 38,  0,199,  0, 29,
  0, 38,  0,199,  0, 30,  0, 38,  0,199,  0, 55,255,107,  0,199,
  0, 57,255,154,  0,199,  0, 58,255,220,  0,199,  0,181,254,240,
  0,199,  0,183,254,240,  0,201,  0, 15,  0, 38,  0,201,  0, 17,
  0, 38,  0,201,  0, 29,  0, 38,  0,201,  0, 30,  0, 38,  0,201,
  0, 55,255,107,  0,201,  0, 57,255,154,  0,201,  0, 58,255,220,
  0,201,  0,181,254,240,  0,201,  0,183,254,240,  0,208,  0, 15,
255,173,  0,208,  0, 17,255,173,  0,208,  0, 29,  0, 38,  0,208,
  0, 30,  0, 38,  0,208,  0, 59,255,201,  0,209,  0, 15,255,173,
  0,209,  0, 17,255,173,  0,209,  0, 29,  0, 38,  0,209,  0, 30,
  0, 38,  0,209,  0, 59,255,201,  0,210,  0, 15,255,173,  0,210,
  0, 17,255,173,  0,210,  0, 29,  0, 38,  0,210,  0, 30,  0, 38,
  0,210,  0, 59,255,201,  0,225,  0, 16,255, 97,  0,225,  0, 50,
255,193,  0,225,  0, 55,255,117,  0,225,  0, 57,255,107,  0,225,
  0, 58,255,173,  0,225,  0, 60,255, 60,  0,225,  0, 92,255,183,
  0,225,  0,103,255,193,  0,225,  0,145,255,193,  0,225,  0,175,
255,193,  0,225,  0,176,255,193,  0,225,  0,180,255, 68,  0,225,
  0,181,254,144,  0,225,  0,182,255, 68,  0,225,  0,183,254,144,
  0,225,  0,186,255,183,  0,225,  0,187,255, 60,  0,225,  0,208,
255,193,  0,225,  0,209,255,193,  0,225,  0,210,255,193,  0,225,
  0,234,255, 60,  0,225,  0,235,255,183,  0,227,  0, 54,255,183,
  0,227,  0,227,255,183,  0,227,  0,249,255,183,  0,229,  0, 16,
255,154,  0,232,  0, 16,  0, 38,  0,234,  0, 15,254,248,  0,234,
  0, 16,254,230,  0,234,  0, 17,254,248,  0,234,  0, 29,255, 78,
  0,234,  0, 30,255, 78,  0,234,  0, 36,255, 97,  0,234,  0, 38,
255,220,  0,234,  0, 50,255,220,  0,234,  0, 68,255, 68,  0,234,
  0, 72,255, 31,  0,234,  0, 76,255,220,  0,234,  0, 82,255, 31,
  0,234,  0, 88,255, 68,  0,234,  0, 98,255, 97,  0,234,  0,100,
255,220,  0,234,  0,103,255,220,  0,234,  0,105,255, 68,  0,234,
  0,106,255, 68,  0,234,  0,107,255, 68,  0,234,  0,108,255, 68,
  0,234,  0,109,255, 68,  0,234,  0,110,255, 68,  0,234,  0,112,
255, 31,  0,234,  0,113,255, 31,  0,234,  0,114,255, 31,  0,234,
  0,115,255, 31,  0,234,  0,121,255, 31,  0,234,  0,122,255, 31,
  0,234,  0,123,255, 31,  0,234,  0,124,255, 31,  0,234,  0,125,
255, 31,  0,234,  0,126,255, 68,  0,234,  0,127,255, 68,  0,234,
  0,128,255, 68,  0,234,  0,129,255, 68,  0,234,  0,145,255,220,
  0,234,  0,160,255, 68,  0,234,  0,161,255, 31,  0,234,  0,173,
255, 97,  0,234,  0,174,255, 97,  0,234,  0,175,255,220,  0,234,
  0,176,255,220,  0,234,  0,177,255, 31,  0,234,  0,180,255,211,
  0,234,  0,182,255,211,  0,234,  0,199,255, 97,  0,234,  0,201,
255, 97,  0,234,  0,208,255,220,  0,234,  0,209,255,220,  0,234,
  0,210,255,220,  0,234,  0,251,255,220,  0,234,  0,253,255,220,
  0,235,  0, 15,255, 97,  0,235,  0, 16,255,183,  0,235,  0, 17,
255, 97,  0,236,  0, 15,255,107,  0,236,  0, 16,  0, 75,  0,236,
  0, 17,255,107,  0,249,  0, 54,255,183,  0,249,  0,227,255,183,
  0,249,  0,249,255,183,  0,251,  0, 54,  0, 38,  0,251,  0,181,
255,211,  0,251,  0,183,255,211,  0,251,  0,227,  0, 38,  0,251,
  0,249,  0, 38,  0,253,  0, 54,  0, 38,  0,253,  0,181,255,211,
  0,253,  0,183,255,211,  0,253,  0,227,  0, 38,  0,253,  0,249,
  0, 38,  0,  0,  0,  1,  0,  0,  1, 12,  0, 77,  0,  7,  0, 72,
  0,  4,  0,  2,  0, 16,  0, 64,  0,  7,  0,  0,  3, 14,  4, 12,
  0,  3,  0,  1,  0,  1,  0,  0,  7,109,254, 29,  0,  0, 10,205,
253,231,253,233, 10, 18,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  1, 12,  0,  1,  4, 14,  1,144,  0,  5,
  0,  4,  5, 71,  4,204,  0,  0,254, 66,  5, 71,  4,204,  0,  0,
  2, 83,  0,143,  2,102,  8,  2,  2, 11,  6,  3,  3,  3,  4, 11,
  2,  4,128,  0,  0,175, 16,  0, 32, 74,  0,  0,  0,  0,  0,  0,
  0,  0, 66,105,116,115,  0,  1,  0, 32,251,  2,  6, 20,254, 20,
  1,154,  7,109,  1,227,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,
  0,  1,  0,  0, 66,  0, 29,178,  2,139,  4, 96,  0,  1, 35, 99,
  5,213,  0,  0, 86,101,114, 97, 83, 97,110,115, 79, 98,  0,  0,
  0,  0,  0,  0,255,255,255,255, 54,255,255,254, 54, 50, 56, 73,
 48, 48,  0,  0, 64,  0,  0,  0,  0,  0,  0, 20,  0,  0,  1, 16,
  9, 12,  5,  0,  3,  3,  4,  4,  8,  6,  9,  7,  2,  4,  4,  5,
  8,  3,  3,  3,  3,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  3,
  3,  8,  8,  8,  5,  9,  6,  6,  6,  7,  6,  5,  7,  7,  3,  3,
  6,  5,  8,  7,  7,  5,  7,  6,  6,  6,  6,  6,  9,  6,  6,  6,
  4,  3,  4,  8,  5,  5,  6,  6,  5,  6,  6,  3,  6,  6,  3,  3,
  5,  3,  9,  6,  6,  6,  6,  4,  5,  4,  6,  5,  7,  5,  5,  5,
  6,  3,  6,  8,  6,  6,  6,  6,  7,  7,  6,  6,  6,  6,  6,  6,
  6,  5,  6,  6,  6,  6,  3,  3,  3,  3,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  5,  5,  6,  6,  5,  5,  6,  6,  9,  9,  9,  5,
  5,  8,  9,  7,  8,  8,  8,  8,  6,  6,  5,  6,  7,  5,  5,  4,
  4,  7,  9,  6,  5,  4,  8,  6,  6,  8,  6,  6,  6,  9,  6,  6,
  6,  7, 10,  9,  5,  9,  5,  5,  3,  3,  8,  4,  5,  6,  2,  6,
  4,  4,  6,  6,  5,  3,  3,  5, 12,  6,  6,  6,  6,  6,  3,  3,
  3,  3,  7,  7,  7,  6,  6,  6,  3,  5,  5,  5,  5,  5,  5,  5,
  5,  5,  5,  5,  3,  6,  5,  6,  5,  3,  7,  6,  6,  5,  5,  6,
  8,  8,  4,  4,  4,  9,  9,  9,  7,  6,  3,  6,  5,  6,  5,  6,
  5,  6,  3,  3,  6,  5,  5,  5,  5,  5,  5,  4,  5,  5,  0,  0,
 10, 14,  6,  0,  3,  3,  4,  5,  8,  6, 10,  8,  3,  4,  4,  5,
  8,  3,  4,  3,  3,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  3,
  3,  8,  8,  8,  5, 10,  7,  7,  7,  8,  6,  6,  8,  8,  3,  3,
  7,  6,  8,  7,  8,  6,  8,  7,  6,  6,  7,  7, 10,  7,  6,  7,
  4,  3,  4,  8,  5,  5,  6,  6,  6,  6,  6,  4,  6,  6,  3,  3,
  6,  3, 10,  6,  6,  6,  6,  4,  5,  4,  6,  6,  8,  6,  6,  5,
  6,  3,  6,  8,  7,  7,  7,  6,  7,  8,  7,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  3,  3,  3,  3,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  5,  5,  6,  6,  5,  6,  6,  6, 10, 10, 10,  5,
  5,  8, 10,  8,  8,  8,  8,  8,  6,  6,  5,  7,  8,  6,  5,  5,
  5,  8, 10,  6,  5,  4,  8,  6,  6,  8,  7,  6,  6, 10,  6,  7,
  7,  8, 11, 10,  5, 10,  5,  5,  3,  3,  8,  5,  6,  6,  2,  6,
  4,  4,  6,  6,  5,  3,  3,  5, 14,  7,  6,  7,  6,  6,  3,  3,
  3,  3,  8,  8,  8,  7,  7,  7,  3,  5,  5,  5,  5,  5,  5,  5,
  5,  5,  5,  6,  3,  6,  5,  7,  5,  3,  8,  6,  6,  6,  6,  6,
  8,  8,  4,  4,  4, 10, 10, 10,  8,  6,  3,  6,  5,  7,  6,  7,
  6,  6,  4,  3,  6,  5,  5,  5,  5,  5,  5,  4,  5,  5,  0,  0,
 11, 15,  7,  0,  3,  3,  4,  5,  9,  7, 10,  9,  3,  4,  4,  6,
  9,  4,  4,  4,  4,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  4,
  4,  9,  9,  9,  6, 11,  8,  8,  8,  8,  7,  6,  9,  8,  3,  3,
  7,  6,  9,  8,  9,  7,  9,  8,  7,  7,  8,  8, 11,  8,  7,  8,
  4,  4,  4,  9,  6,  6,  7,  7,  6,  7,  7,  4,  7,  7,  3,  3,
  6,  3, 11,  7,  7,  7,  7,  5,  6,  4,  7,  7,  9,  7,  7,  6,
  7,  4,  7,  9,  8,  8,  8,  7,  8,  9,  8,  7,  7,  7,  7,  7,
  7,  6,  7,  7,  7,  7,  3,  3,  3,  3,  7,  7,  7,  7,  7,  7,
  7,  7,  7,  7,  6,  6,  7,  7,  6,  6,  7,  7, 11, 11, 11,  6,
  6,  9, 11,  9,  9,  9,  9,  9,  7,  7,  6,  7,  8,  6,  6,  5,
  5,  8, 11,  7,  6,  4,  9,  7,  7,  9,  7,  7,  7, 11,  7,  8,
  8,  9, 12, 11,  6, 11,  6,  6,  4,  4,  9,  5,  7,  7,  2,  7,
  4,  4,  7,  7,  6,  4,  4,  6, 15,  8,  7,  8,  7,  7,  3,  3,
  3,  3,  9,  9,  9,  8,  8,  8,  3,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  3,  7,  6,  8,  6,  4,  9,  7,  7,  7,  7,  7,
  9,  9,  4,  4,  4, 11, 11, 11,  9,  7,  3,  7,  6,  8,  6,  8,
  6,  7,  4,  4,  7,  6,  6,  6,  6,  6,  6,  4,  6,  6,  0,  0,
 12, 16,  7,  0,  4,  4,  5,  6, 10,  8, 11,  9,  3,  5,  5,  6,
 10,  4,  4,  4,  4,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  4,
  4, 10, 10, 10,  6, 12,  8,  8,  8,  9,  8,  7,  9,  9,  4,  4,
  8,  7, 10,  9,  8,  7,  8,  8,  8,  7,  9,  8, 12,  8,  7,  8,
  5,  4,  5, 10,  6,  6,  7,  8,  7,  8,  7,  4,  8,  7,  3,  3,
  7,  3, 11,  7,  7,  8,  8,  5,  6,  5,  8,  6, 10,  7,  7,  6,
  8,  4,  8, 10,  8,  8,  8,  8,  9,  8,  9,  7,  7,  7,  7,  7,
  7,  7,  7,  7,  7,  7,  3,  3,  3,  3,  7,  7,  7,  7,  7,  7,
  8,  8,  8,  8,  6,  6,  8,  8,  6,  7,  8,  8, 12, 12, 12,  6,
  6, 10, 12,  8, 10, 10, 10, 10,  8,  8,  6,  8,  9,  7,  6,  6,
  6,  9, 12,  7,  6,  5, 10,  8,  8, 10,  8,  7,  7, 12,  8,  8,
  8,  8, 13, 12,  6, 12,  6,  6,  4,  4, 10,  6,  7,  7,  2,  8,
  5,  5,  8,  8,  6,  4,  4,  6, 16,  8,  8,  8,  8,  8,  4,  4,
  4,  4,  8,  8,  8,  9,  9,  9,  3,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  7,  3,  8,  6,  8,  6,  4,  9,  7,  7,  7,  7,  8,
 10, 10,  5,  5,  5, 12, 12, 12,  9,  8,  4,  8,  6,  8,  7,  8,
  7,  8,  4,  4,  8,  6,  6,  6,  6,  6,  6,  5,  6,  6,  0,  0,
 13, 18,  8,  0,  4,  4,  5,  6, 11,  8, 12, 10,  4,  5,  5,  7,
 11,  4,  5,  4,  4,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  4,
  4, 11, 11, 11,  7, 13,  9,  9,  9, 10,  8,  7, 10, 10,  4,  4,
  9,  7, 11, 10, 10,  8, 10,  9,  8,  8, 10,  9, 13,  9,  8,  9,
  5,  4,  5, 11,  7,  7,  8,  8,  7,  8,  8,  5,  8,  8,  3,  4,
  7,  3, 12,  8,  8,  8,  8,  5,  7,  5,  8,  8, 11,  8,  8,  7,
  8,  4,  8, 11,  9,  9,  9,  8, 10, 10, 10,  8,  8,  8,  8,  8,
  8,  7,  8,  8,  8,  8,  3,  3,  3,  3,  8,  8,  8,  8,  8,  8,
  8,  8,  8,  8,  7,  7,  8,  8,  7,  8,  8,  8, 13, 13, 13,  7,
  7, 11, 13, 10, 11, 11, 11, 11,  8,  8,  7,  9, 10,  8,  7,  6,
  6, 10, 13,  8,  7,  5, 11,  8,  8, 11,  9,  8,  8, 13,  8,  9,
  9, 10, 14, 13,  7, 13,  7,  7,  4,  4, 11,  6,  8,  8,  2,  8,
  5,  5,  8,  8,  7,  4,  4,  7, 18,  9,  8,  9,  8,  8,  4,  4,
  4,  4, 10, 10, 10, 10, 10, 10,  3,  7,  7,  7,  7,  7,  7,  7,
  7,  7,  7,  7,  4,  8,  7,  9,  7,  4, 10,  8,  8,  8,  8,  8,
 11, 11,  5,  5,  5, 13, 13, 13, 10,  8,  4,  8,  7,  9,  7,  9,
  7,  8,  5,  4,  8,  7,  7,  7,  7,  7,  7,  5,  7,  7,  0,  0,
 14, 19,  8,  0,  4,  4,  6,  6, 12,  9, 13, 11,  4,  5,  5,  7,
 12,  4,  5,  4,  5,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  5,
  5, 12, 12, 12,  7, 14, 10, 10, 10, 11,  9,  8, 11, 11,  4,  4,
  9,  8, 12, 11, 11,  8, 11, 10,  9,  9, 10, 10, 14, 10,  9, 10,
  5,  5,  5, 12,  7,  7,  9,  9,  8,  9,  9,  5,  9,  9,  4,  4,
  8,  4, 14,  9,  9,  9,  9,  5,  7,  5,  9,  8, 11,  8,  8,  7,
  9,  5,  9, 12, 10, 10, 10,  9, 11, 11, 10,  9,  9,  9,  9,  9,
  9,  8,  9,  9,  9,  9,  4,  4,  4,  4,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  7,  7,  9,  9,  7,  8,  9,  9, 14, 14, 14,  7,
  7, 12, 14, 11, 12, 12, 12, 12,  9,  9,  7,  9, 11,  8,  7,  7,
  7, 11, 14,  9,  7,  6, 12,  9,  9, 12,  9,  9,  9, 14,  9, 10,
 10, 11, 15, 14,  7, 14,  7,  7,  4,  4, 12,  7,  8,  9,  2,  9,
  6,  6,  9,  9,  7,  4,  4,  7, 19, 10,  9, 10,  9,  9,  4,  4,
  4,  4, 11, 11, 11, 10, 10, 10,  4,  7,  7,  7,  7,  7,  7,  7,
  7,  7,  7,  8,  4,  9,  7, 10,  7,  5, 11,  9,  9,  8,  9,  9,
 12, 12,  6,  6,  6, 14, 14, 14, 11,  9,  4,  9,  7, 10,  8, 10,
  8,  9,  5,  4,  9,  7,  7,  7,  7,  7,  7,  6,  7,  7,  0,  0,
 15, 20,  9,  0,  5,  5,  6,  7, 13, 10, 14, 12,  4,  6,  6,  8,
 13,  5,  5,  5,  5, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,  5,
  5, 13, 13, 13,  8, 15, 10, 10, 11, 12,  9,  9, 12, 11,  4,  4,
 10,  8, 13, 11, 12,  9, 12, 10, 10,  9, 11, 10, 15, 10,  9, 10,
  6,  5,  6, 13,  8,  8,  9,  9,  8,  9,  9,  5,  9,  9,  4,  4,
  9,  3, 14,  9,  9,  9,  9,  6,  8,  6,  9,  9, 12,  9,  9,  8,
 10,  5, 10, 13, 10, 10, 11,  9, 11, 12, 11,  9,  9,  9,  9,  9,
  9,  8,  9,  9,  9,  9,  4,  4,  4,  4,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  8,  8, 10, 10,  8,  9, 10,  9, 15, 15, 15,  8,
  8, 13, 15, 12, 13, 13, 13, 13, 10, 10,  8, 10, 11,  9,  8,  7,
  7, 11, 15,  9,  8,  6, 13, 10, 10, 13, 10,  9,  9, 15, 10, 10,
 10, 12, 16, 15,  8, 15,  8,  8,  5,  5, 13,  7,  9,  9,  3, 10,
  6,  6, 10, 10,  8,  5,  5,  8, 20, 10,  9, 10,  9,  9,  4,  4,
  4,  4, 12, 12, 12, 11, 11, 11,  4,  8,  8,  8,  8,  8,  8,  8,
  8,  8,  8,  8,  3, 10,  8, 10,  8,  5, 12,  9,  9,  9,  9,  9,
 13, 13,  6,  6,  6, 15, 15, 15, 12,  9,  4, 10,  8, 11,  8, 11,
  8,  9,  5,  5, 10,  8,  8,  8,  8,  8,  8,  6,  8,  8,  0,  0,
 16, 22, 10,  0,  5,  5,  6,  7, 13, 10, 15, 12,  4,  6,  6,  8,
 13,  5,  6,  5,  5, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,  5,
  5, 13, 13, 13,  9, 16, 11, 11, 11, 12, 10,  9, 12, 12,  5,  5,
 11,  9, 14, 12, 13, 10, 13, 11, 10, 10, 12, 11, 16, 11, 10, 11,
  6,  5,  6, 13,  8,  8, 10, 10,  9, 10,  9,  6, 10, 10,  4,  4,
  9,  4, 15, 10,  9,  9, 10,  7,  8,  6, 10,  9, 13,  9,  9,  8,
 10,  5, 10, 13, 11, 11, 11, 10, 12, 13, 12, 10, 10, 10, 10, 10,
 10,  9,  9,  9,  9,  9,  4,  4,  4,  4, 10,  9,  9,  9,  9,  9,
 10, 10, 10, 10,  8,  8, 10, 10,  8,  9, 10, 10, 16, 16, 16,  8,
  8, 13, 16, 13, 13, 13, 13, 13, 10, 10,  8, 11, 12,  9,  8,  8,
  8, 12, 16,  9,  9,  6, 13, 10, 10, 13, 11, 10, 10, 16, 10, 11,
 11, 13, 17, 16,  8, 16,  8,  8,  5,  5, 13,  8,  9, 10,  3, 10,
  6,  6, 10, 10,  8,  5,  5,  8, 22, 11, 10, 11, 10, 10,  5,  5,
  5,  5, 13, 13, 13, 12, 12, 12,  4,  8,  8,  8,  8,  8,  8,  8,
  8,  8,  8,  9,  4, 10,  8, 11,  8,  5, 12, 10, 10,  9, 10,  9,
 13, 13,  6,  6,  6, 16, 16, 16, 12, 10,  5, 10,  8, 11,  9, 11,
  9, 10,  6,  5, 10,  8,  8,  8,  8,  8,  8,  6,  8,  8,  0,  0,
 17, 23, 10,  0,  5,  5,  7,  8, 14, 11, 16, 13,  5,  7,  7,  9,
 14,  5,  6,  5,  6, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,  6,
  6, 14, 14, 14,  9, 17, 12, 12, 12, 13, 11, 10, 13, 13,  5,  5,
 11,  9, 15, 13, 13, 10, 13, 12, 11, 10, 12, 12, 17, 12, 10, 12,
  7,  6,  7, 14,  9,  9, 10, 11,  9, 11, 10,  6, 11, 11,  5,  5,
 10,  5, 17, 11, 10, 11, 10,  7,  9,  7, 11, 10, 14, 10, 10,  9,
 11,  6, 11, 14, 12, 12, 12, 11, 13, 13, 12, 10, 10, 10, 10, 10,
 10,  9, 10, 10, 10, 10,  5,  5,  5,  5, 11, 10, 10, 10, 10, 10,
 11, 11, 11, 11,  9,  9, 11, 11,  9, 10, 11, 11, 17, 17, 17,  9,
  9, 14, 17, 13, 14, 14, 14, 14, 11, 11,  9, 11, 13, 10,  9,  8,
  8, 13, 17, 10,  9,  7, 14, 11, 11, 14, 11, 11, 11, 17, 11, 12,
 12, 13, 18, 17,  9, 17,  9,  9,  5,  5, 14,  8, 10, 10,  3, 11,
  7,  7, 10, 10,  9,  5,  5,  9, 23, 12, 11, 12, 11, 11,  5,  5,
  5,  5, 13, 13, 13, 12, 12, 12,  5,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9, 10,  5, 11,  9, 12,  9,  6, 13, 10, 10, 10, 10, 11,
 14, 14,  7,  7,  7, 16, 16, 16, 13, 11,  5, 11,  9, 12,  9, 12,
  9, 11,  6,  5, 11,  9,  9,  9,  9,  9,  9,  7,  9,  9,  0,  0,
 18, 24, 11,  0,  6,  6,  7,  8, 15, 11, 17, 14,  5,  7,  7,  9,
 15,  6,  7,  6,  6, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,  6,
  6, 15, 15, 15, 10, 18, 12, 12, 13, 14, 11, 10, 14, 14,  5,  5,
 12, 10, 16, 13, 14, 11, 14, 13, 11, 11, 13, 12, 18, 12, 11, 12,
  7,  6,  7, 15,  9,  9, 11, 12, 10, 11, 11,  6, 11, 12,  5,  5,
 10,  5, 18, 12, 11, 12, 11,  7,  9,  7, 11, 10, 14, 10, 11,  9,
 11,  6, 11, 15, 12, 12, 13, 11, 13, 14, 13, 11, 11, 11, 11, 11,
 11, 10, 11, 11, 11, 11,  5,  5,  5,  5, 12, 11, 11, 11, 11, 11,
 11, 11, 11, 11,  9,  9, 11, 11,  9, 11, 11, 11, 18, 18, 18,  9,
  9, 15, 18, 14, 15, 15, 15, 15, 11, 11,  9, 12, 14, 11,  9,  8,
  8, 14, 18, 11, 10,  7, 15, 11, 11, 15, 12, 11, 11, 18, 11, 12,
 12, 14, 19, 19,  9, 18,  9,  9,  6,  6, 15,  9, 11, 11,  3, 11,
  7,  7, 12, 12,  9,  6,  6,  9, 24, 12, 11, 12, 11, 11,  5,  5,
  5,  5, 14, 14, 14, 13, 13, 13,  5,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9, 10,  5, 11,  9, 12,  9,  6, 14, 11, 11, 11, 11, 12,
 15, 15,  7,  7,  7, 17, 17, 17, 14, 11,  5, 11,  9, 13, 10, 13,
 10, 11,  7,  6, 11,  9,  9,  9,  9,  9,  9,  7,  9,  9,  0,  0,
 19, 26, 11,  0,  6,  6,  8,  9, 16, 12, 18, 15,  5,  7,  7, 10,
 16,  6,  7,  6,  6, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,  6,
  6, 16, 16, 16, 10, 19, 13, 13, 13, 15, 12, 11, 15, 14,  6,  6,
 12, 11, 16, 15, 15, 12, 15, 13, 12, 12, 14, 13, 19, 13, 12, 13,
  7,  6,  7, 16, 10, 10, 12, 12, 10, 12, 12,  7, 12, 12,  5,  5,
 11,  5, 19, 12, 12, 12, 12,  8, 10,  7, 12, 11, 16, 11, 11, 10,
 12,  6, 12, 16, 13, 13, 13, 12, 15, 15, 14, 12, 12, 12, 12, 12,
 12, 10, 12, 12, 12, 12,  5,  5,  5,  5, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 10, 10, 12, 12, 10, 11, 12, 12, 19, 19, 19, 10,
 10, 16, 19, 15, 16, 16, 16, 16, 12, 12, 10, 13, 14, 11, 10,  9,
  9, 15, 19, 12, 10,  8, 16, 12, 12, 16, 13, 12, 12, 19, 12, 13,
 13, 15, 20, 20, 10, 19, 10, 10,  6,  6, 16,  9, 11, 12,  3, 12,
  8,  8, 12, 12, 10,  6,  6, 10, 26, 13, 12, 13, 12, 12,  6,  6,
  6,  6, 15, 15, 15, 14, 14, 14,  5, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 11,  5, 12, 10, 13, 10,  6, 15, 12, 12, 11, 12, 12,
 16, 16,  8,  8,  8, 18, 18, 18, 15, 12,  6, 12, 10, 13, 10, 13,
 10, 12,  7,  6, 12, 10, 10, 10, 10, 10, 10,  8, 10, 10,  0,  0,
 20, 27, 12,  0,  6,  6,  8,  9, 17, 13, 19, 16,  6,  8,  8, 10,
 17,  6,  7,  6,  7, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,  7,
  7, 17, 17, 17, 11, 20, 14, 14, 14, 15, 13, 12, 16, 15,  6,  6,
 13, 11, 17, 15, 16, 12, 16, 14, 13, 12, 15, 14, 20, 14, 12, 14,
  8,  7,  8, 17, 10, 10, 12, 13, 11, 13, 12,  7, 13, 13,  6,  6,
 12,  6, 19, 13, 12, 13, 13,  8, 10,  8, 13, 12, 16, 12, 12, 11,
 13,  7, 13, 17, 14, 14, 14, 13, 15, 16, 15, 12, 12, 12, 12, 12,
 12, 11, 12, 12, 12, 12,  6,  6,  6,  6, 13, 12, 12, 12, 12, 12,
 13, 13, 13, 13, 10, 10, 13, 13, 10, 12, 13, 13, 20, 20, 20, 10,
 10, 17, 19, 16, 17, 17, 17, 17, 13, 13, 10, 13, 15, 12, 10,  9,
  9, 15, 20, 12, 11,  8, 17, 13, 13, 17, 13, 12, 12, 20, 13, 14,
 14, 16, 21, 21, 10, 20, 10, 10,  6,  6, 17, 10, 12, 12,  3, 13,
  8,  8, 13, 13, 10,  6,  6, 10, 27, 14, 13, 14, 13, 13,  6,  6,
  6,  6, 16, 16, 16, 15, 15, 15,  6, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 11,  6, 13, 10, 14, 11,  7, 16, 12, 12, 12, 12, 13,
 17, 17,  8,  8,  8, 19, 19, 19, 16, 13,  6, 13, 10, 14, 11, 14,
 11, 13,  7,  6, 13, 10, 10, 10, 10, 10, 10,  8, 10, 10,  0,  0,
 21, 28, 13,  0,  7,  7,  8, 10, 18, 13, 20, 16,  6,  8,  8, 11,
 18,  7,  8,  7,  7, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,  7,
  7, 18, 18, 18, 11, 21, 14, 14, 15, 16, 13, 12, 16, 16,  6,  6,
 14, 12, 18, 16, 17, 13, 17, 15, 13, 13, 15, 14, 21, 14, 13, 14,
  8,  7,  8, 18, 11, 11, 13, 13, 12, 13, 13,  7, 13, 13,  6,  6,
 12,  6, 20, 13, 13, 13, 13,  9, 11,  8, 13, 12, 17, 12, 12, 11,
 13,  7, 13, 18, 14, 14, 15, 13, 16, 17, 15, 13, 13, 13, 13, 13,
 13, 12, 13, 13, 13, 13,  6,  6,  6,  6, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 11, 11, 13, 13, 11, 12, 13, 13, 21, 21, 21, 11,
 11, 18, 20, 17, 18, 18, 18, 18, 13, 13, 11, 14, 16, 12, 11, 10,
 10, 16, 21, 13, 11,  8, 18, 13, 13, 18, 14, 13, 13, 21, 13, 14,
 14, 17, 22, 22, 11, 21, 11, 11,  7,  7, 18, 10, 12, 13,  4, 13,
  8,  8, 14, 14, 11,  7,  7, 11, 28, 14, 13, 14, 13, 13,  6,  6,
  6,  6, 17, 17, 17, 15, 15, 15,  6, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 12,  6, 13, 11, 14, 11,  7, 16, 13, 13, 12, 13, 13,
 18, 18,  8,  8,  8, 20, 20, 20, 16, 13,  6, 13, 11, 15, 12, 15,
 12, 13,  8,  7, 13, 11, 11, 11, 11, 11, 11,  8, 11, 11,  0,  0,
 22, 30, 13,  0,  7,  7,  9, 10, 18, 14, 21, 17,  6,  9,  9, 11,
 18,  7,  8,  7,  7, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,  7,
  7, 18, 18, 18, 12, 22, 15, 15, 15, 17, 14, 13, 17, 17,  6,  6,
 14, 12, 19, 16, 17, 13, 17, 15, 14, 13, 16, 15, 22, 15, 13, 15,
  9,  7,  9, 18, 11, 11, 13, 14, 12, 14, 14,  8, 14, 14,  6,  6,
 13,  6, 21, 14, 13, 14, 14,  9, 11,  9, 14, 13, 18, 13, 13, 12,
 14,  7, 14, 18, 15, 15, 15, 14, 16, 17, 16, 13, 13, 13, 13, 13,
 13, 12, 14, 14, 14, 14,  6,  6,  6,  6, 14, 13, 13, 13, 13, 13,
 14, 14, 14, 14, 11, 11, 14, 14, 11, 13, 14, 14, 22, 22, 22, 11,
 11, 18, 21, 17, 18, 18, 18, 18, 14, 14, 11, 15, 17, 13, 11, 10,
 10, 17, 22, 13, 12,  9, 18, 14, 14, 18, 15, 14, 14, 22, 14, 15,
 15, 17, 24, 23, 11, 22, 11, 11,  7,  7, 18, 11, 13, 13,  4, 14,
  9,  9, 14, 14, 11,  7,  7, 11, 30, 15, 14, 15, 14, 14,  6,  6,
  6,  6, 17, 17, 17, 16, 16, 16,  6, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 12,  6, 14, 11, 15, 12,  7, 17, 13, 13, 13, 13, 14,
 18, 18,  9,  9,  9, 21, 21, 21, 17, 14,  6, 14, 11, 15, 12, 15,
 12, 14,  8,  7, 14, 11, 11, 11, 11, 11, 11,  9, 11, 11,  0,  0,
 23, 31, 14,  0,  7,  7,  9, 11, 19, 15, 22, 18,  6,  9,  9, 12,
 19,  7,  8,  7,  8, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,  8,
  8, 19, 19, 19, 12, 23, 16, 16, 16, 18, 15, 13, 18, 17,  7,  7,
 15, 13, 20, 17, 18, 14, 18, 16, 15, 14, 17, 16, 23, 16, 14, 16,
  9,  8,  9, 19, 12, 12, 14, 15, 13, 15, 14,  8, 15, 15,  6,  6,
 13,  6, 22, 15, 14, 15, 15,  9, 12,  9, 15, 14, 19, 14, 14, 12,
 15,  8, 15, 19, 16, 16, 16, 15, 17, 18, 17, 14, 14, 14, 14, 14,
 14, 13, 14, 14, 14, 14,  6,  6,  6,  6, 15, 14, 14, 14, 14, 14,
 15, 15, 15, 15, 12, 12, 15, 15, 12, 14, 15, 14, 23, 23, 23, 12,
 12, 19, 22, 18, 19, 19, 19, 19, 15, 15, 12, 16, 17, 14, 12, 11,
 11, 18, 23, 14, 12,  9, 19, 15, 15, 19, 15, 14, 14, 23, 15, 16,
 16, 18, 25, 24, 12, 23, 12, 12,  7,  7, 19, 11, 14, 14,  4, 15,
  9,  9, 15, 15, 12,  7,  7, 12, 31, 16, 15, 16, 15, 15,  7,  7,
  7,  7, 18, 18, 18, 17, 17, 17,  6, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 13,  7, 15, 12, 16, 12,  8, 18, 14, 14, 14, 14, 15,
 19, 19,  9,  9,  9, 22, 22, 22, 18, 15,  7, 15, 12, 16, 13, 16,
 13, 15,  8,  7, 15, 12, 12, 12, 12, 12, 12,  9, 12, 12,  0,  0,
 24, 32, 14,  0,  8,  8, 10, 11, 20, 15, 23, 19,  7,  9,  9, 12,
 20,  8,  9,  8,  8, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,  8,
  8, 20, 20, 20, 13, 24, 16, 16, 17, 18, 15, 14, 19, 18,  7,  7,
 16, 13, 21, 18, 19, 14, 19, 17, 15, 15, 18, 16, 24, 16, 15, 16,
  9,  8,  9, 20, 12, 12, 15, 15, 13, 15, 15,  8, 15, 15,  7,  7,
 14,  7, 23, 15, 15, 15, 15, 10, 13,  9, 15, 14, 20, 14, 14, 13,
 15,  8, 15, 20, 16, 16, 17, 15, 18, 19, 18, 15, 15, 15, 15, 15,
 15, 13, 15, 15, 15, 15,  7,  7,  7,  7, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 12, 12, 15, 15, 12, 14, 15, 15, 24, 24, 24, 12,
 12, 20, 23, 19, 20, 20, 20, 20, 15, 15, 12, 16, 18, 14, 13, 11,
 11, 18, 24, 15, 13, 10, 20, 15, 15, 20, 16, 15, 15, 24, 15, 16,
 16, 19, 26, 25, 12, 24, 12, 12,  8,  8, 20, 12, 14, 15,  4, 15,
 10, 10, 16, 16, 12,  8,  8, 12, 32, 16, 15, 16, 15, 15,  7,  7,
  7,  7, 19, 19, 19, 18, 18, 18,  7, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 13,  7, 15, 13, 16, 13,  8, 19, 15, 15, 14, 15, 15,
 20, 20, 10, 10, 10, 23, 23, 23, 19, 15,  7, 15, 13, 17, 13, 17,
 13, 15,  9,  8, 15, 12, 12, 12, 12, 12, 12, 10, 12, 12,  0,  0,
 25, 34, 15,  0,  8,  8, 10, 12, 21, 16, 24, 20,  7, 10, 10, 13,
 21,  8,  9,  8,  8, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,  8,
  8, 21, 21, 21, 13, 25, 17, 17, 17, 19, 16, 14, 19, 19,  7,  7,
 16, 14, 22, 19, 20, 15, 20, 17, 16, 15, 18, 17, 25, 17, 15, 17,
 10,  8, 10, 21, 13, 13, 15, 16, 14, 16, 15,  9, 16, 16,  7,  7,
 14,  7, 24, 16, 15, 16, 16, 10, 13, 10, 16, 15, 20, 15, 15, 13,
 16,  8, 16, 21, 17, 17, 17, 16, 19, 20, 18, 15, 15, 15, 15, 15,
 15, 14, 15, 15, 15, 15,  7,  7,  7,  7, 16, 15, 15, 15, 15, 15,
 16, 16, 16, 16, 13, 13, 16, 16, 13, 15, 16, 16, 25, 25, 25, 13,
 13, 21, 24, 20, 21, 21, 21, 21, 16, 16, 13, 17, 19, 15, 13, 12,
 12, 19, 25, 15, 13, 10, 21, 16, 16, 21, 17, 15, 15, 25, 16, 17,
 17, 20, 27, 26, 13, 25, 13, 13,  8,  8, 21, 12, 15, 15,  4, 16,
 10, 10, 16, 16, 13,  8,  8, 13, 34, 17, 16, 17, 16, 16,  7,  7,
  7,  7, 20, 20, 20, 18, 18, 18,  7, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 14,  7, 16, 13, 17, 13,  8, 19, 15, 15, 15, 15, 16,
 21, 21, 10, 10, 10, 24, 24, 24, 19, 16,  7, 16, 13, 17, 14, 17,
 14, 16,  9,  8, 16, 13, 13, 13, 13, 13, 13, 10, 13, 13,  0,  0,
 26, 35, 16,  0,  8,  8, 10, 12, 22, 17, 25, 20,  7, 10, 10, 13,
 22,  8,  9,  8,  9, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,  9,
  9, 22, 22, 22, 14, 26, 18, 18, 18, 20, 16, 15, 20, 20,  8,  8,
 17, 14, 22, 19, 20, 16, 20, 18, 17, 16, 19, 18, 26, 18, 16, 18,
 10,  9, 10, 22, 13, 13, 16, 17, 14, 17, 16,  9, 17, 16,  7,  7,
 15,  7, 25, 16, 16, 17, 17, 11, 14, 10, 16, 15, 21, 15, 15, 14,
 17,  9, 17, 22, 18, 18, 18, 16, 19, 20, 19, 16, 16, 16, 16, 16,
 16, 14, 16, 16, 16, 16,  7,  7,  7,  7, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 13, 13, 17, 17, 13, 15, 17, 16, 26, 26, 26, 13,
 13, 22, 25, 20, 22, 22, 22, 22, 17, 17, 13, 18, 20, 15, 14, 12,
 12, 20, 26, 16, 14, 10, 22, 17, 17, 22, 17, 16, 16, 26, 17, 18,
 18, 20, 28, 27, 13, 26, 13, 13,  8,  8, 22, 13, 15, 16,  4, 17,
 10, 10, 17, 17, 13,  8,  8, 13, 35, 18, 16, 18, 16, 16,  8,  8,
  8,  8, 20, 20, 20, 19, 19, 19,  7, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 15,  7, 17, 14, 18, 14,  9, 20, 16, 16, 15, 16, 17,
 22, 22, 10, 10, 10, 25, 25, 25, 20, 17,  8, 17, 14, 18, 14, 18,
 14, 17,  9,  8, 17, 13, 13, 13, 13, 13, 13, 10, 13, 13,  0,  0,
 27, 36, 16,  0,  9,  9, 11, 12, 23, 17, 26, 21,  7, 11, 11, 14,
 23,  9, 10,  9,  9, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,  9,
  9, 23, 23, 23, 14, 27, 18, 19, 19, 21, 17, 16, 21, 20,  8,  8,
 18, 15, 23, 20, 21, 16, 21, 19, 17, 17, 20, 18, 27, 19, 17, 19,
 11,  9, 11, 23, 14, 14, 17, 17, 15, 17, 17, 10, 17, 17,  8,  8,
 16,  8, 26, 17, 17, 17, 17, 11, 14, 11, 17, 16, 22, 16, 16, 14,
 17,  9, 17, 23, 18, 18, 19, 17, 20, 21, 20, 17, 17, 17, 17, 17,
 17, 15, 17, 17, 17, 17,  8,  8,  8,  8, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 14, 14, 17, 17, 14, 16, 17, 17, 27, 27, 27, 14,
 14, 23, 26, 21, 22, 23, 23, 23, 17, 17, 14, 18, 20, 16, 14, 13,
 13, 21, 27, 17, 14, 11, 23, 17, 17, 23, 18, 17, 17, 27, 17, 18,
 18, 21, 29, 28, 14, 27, 14, 14,  9,  9, 23, 13, 16, 17,  5, 17,
 11, 11, 17, 17, 14,  9,  9, 14, 36, 18, 17, 18, 17, 17,  8,  8,
  8,  8, 21, 21, 21, 20, 20, 20,  8, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 15,  8, 17, 14, 19, 14,  9, 21, 17, 17, 16, 16, 17,
 23, 23, 11, 11, 11, 26, 26, 26, 21, 17,  8, 17, 14, 19, 15, 19,
 15, 17, 10,  9, 17, 14, 14, 14, 14, 14, 14, 11, 14, 14,  0,  0,
 28, 38, 17,  0,  9,  9, 11, 13, 23, 18, 27, 22,  8, 11, 11, 14,
 23,  9, 10,  9,  9, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,  9,
  9, 23, 23, 23, 15, 28, 19, 19, 20, 22, 18, 16, 22, 21,  8,  8,
 18, 16, 24, 21, 22, 17, 22, 19, 18, 17, 21, 19, 28, 19, 17, 19,
 11,  9, 11, 23, 14, 14, 17, 18, 15, 18, 17, 10, 18, 18,  8,  8,
 16,  8, 27, 18, 17, 18, 18, 12, 15, 11, 18, 17, 23, 17, 17, 15,
 18,  9, 18, 23, 19, 19, 20, 18, 21, 22, 21, 17, 17, 17, 17, 17,
 17, 15, 17, 17, 17, 17,  8,  8,  8,  8, 18, 17, 17, 17, 17, 17,
 18, 18, 18, 18, 14, 14, 18, 18, 14, 17, 18, 18, 28, 28, 28, 14,
 14, 23, 27, 22, 23, 23, 23, 23, 18, 18, 14, 19, 21, 16, 15, 13,
 13, 21, 28, 17, 15, 11, 23, 18, 18, 23, 19, 17, 17, 28, 18, 19,
 19, 22, 30, 29, 14, 28, 15, 15,  9,  9, 23, 14, 17, 17,  5, 18,
 11, 11, 18, 18, 14,  9,  9, 15, 38, 19, 18, 19, 18, 18,  8,  8,
  8,  8, 22, 22, 22, 21, 21, 21,  8, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 16,  8, 18, 15, 19, 15,  9, 22, 17, 17, 17, 17, 18,
 23, 23, 11, 11, 11, 27, 27, 27, 22, 18,  8, 18, 15, 20, 15, 20,
 15, 18, 10,  9, 18, 14, 14, 14, 14, 14, 14, 11, 14, 14,  0,  0,
  0,  0,  0,  2,  0,  8,  0,  2,255,255,  0,  3,  0,  1,  0,  0,
  0,  2,  0,  0,255,240,  0,  0, 95, 15, 60,245,  0, 31,  8,  0,
  0,  0,  0,  0,186,178, 86,250,  0,  0,  0,  0,186,188,148, 97,
253,231,254, 29, 10, 18,  7,109,  0,  2,  0,  8,  0,  1,  0,  0,
  0,  0,  0,  0
};
static unsigned int TTF_VeraBI_len = 63208;
static unsigned char TTF_VeraBI_dat[] = {

  0,  1,  0,  0,  0, 17,  1,  0,  0,  4,  0, 16, 79, 83, 47, 50,
181,134,247, 71,  0,  0,224,204,  0,  0,  0, 86, 80, 67, 76, 84,
 20, 45,180,244,  0,  0,225, 36,  0,  0,  0, 54, 99,109, 97,112,
164,195,232,160,  0,  0,189,  0,  0,  0,  3, 88, 99,118,116, 32,
 12,115,227,133,  0,  0, 31, 52,  0,  0,  1,194,102,112,103,109,
231,151,241,196,  0,  0, 38,100,  0,  0,  0,139,103, 97,115,112,
  0,  7,  0,  7,  0,  0,246,164,  0,  0,  0, 12,103,108,121,102,
 87,107, 71,187,  0,  0, 38,240,  0,  0,150, 14,104,100,109,120,
 39, 58,239, 29,  0,  0,225, 92,  0,  0, 21, 72,104,101, 97,100,
221,174,196,203,  0,  0,246,176,  0,  0,  0, 54,104,104,101, 97,
 16,108,  8,146,  0,  0,224,168,  0,  0,  0, 36,104,109,116,120,
122,128, 87,150,  0,  0,192, 88,  0,  0,  4, 44,107,101,114,110,
246, 16,236, 13,  0,  0,201, 36,  0,  0, 23,100,108,111, 99, 97,
255, 60, 37, 88,  0,  0,199, 12,  0,  0,  2, 24,109, 97,120,112,
  5, 74,  6, 68,  0,  0,224,136,  0,  0,  0, 32,110, 97,109,101,
 50,105, 43,232,  0,  0,  1, 28,  0,  0, 30, 24,112,111,115,116,
248,150,120,250,  0,  0,196,132,  0,  0,  2,134,112,114,101,112,
124,233,164,150,  0,  0, 32,248,  0,  0,  5,107,  0,  0,  0, 22,
  1, 14,  0,  1,  0,  0,  0,  0,  0,  0,  0, 58,  0,  0,  0,  1,
  0,  0,  0,  0,  0,  1,  0, 19,  0, 58,  0,  1,  0,  0,  0,  0,
  0,  2,  0, 12,  0, 78,  0,  1,  0,  0,  0,  0,  0,  3,  0, 32,
  0, 58,  0,  1,  0,  0,  0,  0,  0,  4,  0, 32,  0, 58,  0,  1,
  0,  0,  0,  0,  0,  5,  0, 12,  0, 90,  0,  1,  0,  0,  0,  0,
  0,  6,  0, 29,  0,102,  0,  1,  0,  0,  0,  0,  0,  7,  0, 48,
  0,192,  0,  1,  0,  0,  0,  0,  0,  8,  0, 14,  8,127,  0,  1,
  0,  0,  0,  0,  0, 11,  0, 24,  9,150,  0,  1,  0,  0,  0,  0,
  0, 13,  9, 19,  0,131,  0,  3,  0,  1,  4,  9,  0,  0,  0,116,
  9,174,  0,  3,  0,  1,  4,  9,  0,  1,  0, 38, 10, 34,  0,  3,
  0,  1,  4,  9,  0,  2,  0, 24, 10, 74,  0,  3,  0,  1,  4,  9,
  0,  3,  0, 64, 10, 34,  0,  3,  0,  1,  4,  9,  0,  4,  0, 64,
 10, 34,  0,  3,  0,  1,  4,  9,  0,  5,  0, 24, 10, 98,  0,  3,
  0,  1,  4,  9,  0,  6,  0, 58, 10,122,  0,  3,  0,  1,  4,  9,
  0,  7,  0, 96, 11, 46,  0,  3,  0,  1,  4,  9,  0,  8,  0, 28,
 26,172,  0,  3,  0,  1,  4,  9,  0, 11,  0, 48, 28,218,  0,  3,
  0,  1,  4,  9,  0, 13, 18, 38, 10,180, 67,111,112,121,114,105,
103,104,116, 32, 40, 99, 41, 32, 50, 48, 48, 51, 32, 98,121, 32,
 66,105,116,115,116,114,101, 97,109, 44, 32, 73,110, 99, 46, 32,
 65,108,108, 32, 82,105,103,104,116,115, 32, 82,101,115,101,114,
118,101,100, 46, 66,105,116,115,116,114,101, 97,109, 32, 86,101,
114, 97, 32, 83, 97,110,115, 32, 66,111,108,100, 32, 79, 98,108,
105,113,117,101, 82,101,108,101, 97,115,101, 32, 49, 46, 49, 48,
 66,105,116,115,116,114,101, 97,109, 86,101,114, 97, 83, 97,110,
115, 45, 66,111,108,100, 79, 98,108,105,113,117,101, 67,111,112,
121,114,105,103,104,116, 32, 40, 99, 41, 32, 50, 48, 48, 51, 32,
 98,121, 32, 66,105,116,115,116,114,101, 97,109, 44, 32, 73,110,
 99, 46, 13, 10, 65,108,108, 32, 82,105,103,104,116,115, 32, 82,
101,115,101,114,118,101,100, 46, 13, 10, 66,105,116,115,116,114,
101, 97,109, 32, 86,101,114, 97, 32,105,115, 32, 97, 32,116,114,
 97,100,101,109, 97,114,107, 32,111,102, 32, 66,105,116,115,116,
114,101, 97,109, 44, 32, 73,110, 99, 46, 13, 10, 13, 10, 80,101,
114,109,105,115,115,105,111,110, 32,105,115, 32,104,101,114,101,
 98,121, 32,103,114, 97,110,116,101,100, 44, 32,102,114,101,101,
 32,111,102, 32, 99,104, 97,114,103,101, 44, 32,116,111, 32, 97,
110,121, 32,112,101,114,115,111,110, 32,111, 98,116, 97,105,110,
105,110,103, 32, 97, 32, 99,111,112,121, 32,111,102, 32,116,104,
101, 32,102,111,110,116,115, 32, 97, 99, 99,111,109,112, 97,110,
121,105,110,103, 32,116,104,105,115, 32,108,105, 99,101,110,115,
101, 32, 40, 34, 70,111,110,116,115, 34, 41, 32, 97,110,100, 32,
 97,115,115,111, 99,105, 97,116,101,100, 32,100,111, 99,117,109,
101,110,116, 97,116,105,111,110, 32,102,105,108,101,115, 32, 40,
116,104,101, 32, 34, 70,111,110,116, 32, 83,111,102,116,119, 97,
114,101, 34, 41, 44, 32,116,111, 32,114,101,112,114,111,100,117,
 99,101, 32, 97,110,100, 32,100,105,115,116,114,105, 98,117,116,
101, 32,116,104,101, 32, 70,111,110,116, 32, 83,111,102,116,119,
 97,114,101, 44, 32,105,110, 99,108,117,100,105,110,103, 32,119,
105,116,104,111,117,116, 32,108,105,109,105,116, 97,116,105,111,
110, 32,116,104,101, 32,114,105,103,104,116,115, 32,116,111, 32,
117,115,101, 44, 32, 99,111,112,121, 44, 32,109,101,114,103,101,
 44, 32,112,117, 98,108,105,115,104, 44, 32,100,105,115,116,114,
105, 98,117,116,101, 44, 32, 97,110,100, 47,111,114, 32,115,101,
108,108, 32, 99,111,112,105,101,115, 32,111,102, 32,116,104,101,
 32, 70,111,110,116, 32, 83,111,102,116,119, 97,114,101, 44, 32,
 97,110,100, 32,116,111, 32,112,101,114,109,105,116, 32,112,101,
114,115,111,110,115, 32,116,111, 32,119,104,111,109, 32,116,104,
101, 32, 70,111,110,116, 32, 83,111,102,116,119, 97,114,101, 32,
105,115, 32,102,117,114,110,105,115,104,101,100, 32,116,111, 32,
100,111, 32,115,111, 44, 32,115,117, 98,106,101, 99,116, 32,116,
111, 32,116,104,101, 32,102,111,108,108,111,119,105,110,103, 32,
 99,111,110,100,105,116,105,111,110,115, 58, 13, 10, 13, 10, 84,
104,101, 32, 97, 98,111,118,101, 32, 99,111,112,121,114,105,103,
104,116, 32, 97,110,100, 32,116,114, 97,100,101,109, 97,114,107,
 32,110,111,116,105, 99,101,115, 32, 97,110,100, 32,116,104,105,
115, 32,112,101,114,109,105,115,115,105,111,110, 32,110,111,116,
105, 99,101, 32,115,104, 97,108,108, 32, 98,101, 32,105,110, 99,
108,117,100,101,100, 32,105,110, 32, 97,108,108, 32, 99,111,112,
105,101,115, 32,111,102, 32,111,110,101, 32,111,114, 32,109,111,
114,101, 32,111,102, 32,116,104,101, 32, 70,111,110,116, 32, 83,
111,102,116,119, 97,114,101, 32,116,121,112,101,102, 97, 99,101,
115, 46, 13, 10, 13, 10, 84,104,101, 32, 70,111,110,116, 32, 83,
111,102,116,119, 97,114,101, 32,109, 97,121, 32, 98,101, 32,109,
111,100,105,102,105,101,100, 44, 32, 97,108,116,101,114,101,100,
 44, 32,111,114, 32, 97,100,100,101,100, 32,116,111, 44, 32, 97,
110,100, 32,105,110, 32,112, 97,114,116,105, 99,117,108, 97,114,
 32,116,104,101, 32,100,101,115,105,103,110,115, 32,111,102, 32,
103,108,121,112,104,115, 32,111,114, 32, 99,104, 97,114, 97, 99,
116,101,114,115, 32,105,110, 32,116,104,101, 32, 70,111,110,116,
115, 32,109, 97,121, 32, 98,101, 32,109,111,100,105,102,105,101,
100, 32, 97,110,100, 32, 97,100,100,105,116,105,111,110, 97,108,
 32,103,108,121,112,104,115, 32,111,114, 32, 99,104, 97,114, 97,
 99,116,101,114,115, 32,109, 97,121, 32, 98,101, 32, 97,100,100,
101,100, 32,116,111, 32,116,104,101, 32, 70,111,110,116,115, 44,
 32,111,110,108,121, 32,105,102, 32,116,104,101, 32,102,111,110,
116,115, 32, 97,114,101, 32,114,101,110, 97,109,101,100, 32,116,
111, 32,110, 97,109,101,115, 32,110,111,116, 32, 99,111,110,116,
 97,105,110,105,110,103, 32,101,105,116,104,101,114, 32,116,104,
101, 32,119,111,114,100,115, 32, 34, 66,105,116,115,116,114,101,
 97,109, 34, 32,111,114, 32,116,104,101, 32,119,111,114,100, 32,
 34, 86,101,114, 97, 34, 46, 13, 10, 13, 10, 84,104,105,115, 32,
 76,105, 99,101,110,115,101, 32, 98,101, 99,111,109,101,115, 32,
110,117,108,108, 32, 97,110,100, 32,118,111,105,100, 32,116,111,
 32,116,104,101, 32,101,120,116,101,110,116, 32, 97,112,112,108,
105, 99, 97, 98,108,101, 32,116,111, 32, 70,111,110,116,115, 32,
111,114, 32, 70,111,110,116, 32, 83,111,102,116,119, 97,114,101,
 32,116,104, 97,116, 32,104, 97,115, 32, 98,101,101,110, 32,109,
111,100,105,102,105,101,100, 32, 97,110,100, 32,105,115, 32,100,
105,115,116,114,105, 98,117,116,101,100, 32,117,110,100,101,114,
 32,116,104,101, 32, 34, 66,105,116,115,116,114,101, 97,109, 32,
 86,101,114, 97, 34, 32,110, 97,109,101,115, 46, 13, 10, 13, 10,
 84,104,101, 32, 70,111,110,116, 32, 83,111,102,116,119, 97,114,
101, 32,109, 97,121, 32, 98,101, 32,115,111,108,100, 32, 97,115,
 32,112, 97,114,116, 32,111,102, 32, 97, 32,108, 97,114,103,101,
114, 32,115,111,102,116,119, 97,114,101, 32,112, 97, 99,107, 97,
103,101, 32, 98,117,116, 32,110,111, 32, 99,111,112,121, 32,111,
102, 32,111,110,101, 32,111,114, 32,109,111,114,101, 32,111,102,
 32,116,104,101, 32, 70,111,110,116, 32, 83,111,102,116,119, 97,
114,101, 32,116,121,112,101,102, 97, 99,101,115, 32,109, 97,121,
 32, 98,101, 32,115,111,108,100, 32, 98,121, 32,105,116,115,101,
108,102, 46, 13, 10, 13, 10, 84, 72, 69, 32, 70, 79, 78, 84, 32,
 83, 79, 70, 84, 87, 65, 82, 69, 32, 73, 83, 32, 80, 82, 79, 86,
 73, 68, 69, 68, 32, 34, 65, 83, 32, 73, 83, 34, 44, 32, 87, 73,
 84, 72, 79, 85, 84, 32, 87, 65, 82, 82, 65, 78, 84, 89, 32, 79,
 70, 32, 65, 78, 89, 32, 75, 73, 78, 68, 44, 32, 69, 88, 80, 82,
 69, 83, 83, 32, 79, 82, 32, 73, 77, 80, 76, 73, 69, 68, 44, 32,
 73, 78, 67, 76, 85, 68, 73, 78, 71, 32, 66, 85, 84, 32, 78, 79,
 84, 32, 76, 73, 77, 73, 84, 69, 68, 32, 84, 79, 32, 65, 78, 89,
 32, 87, 65, 82, 82, 65, 78, 84, 73, 69, 83, 32, 79, 70, 32, 77,
 69, 82, 67, 72, 65, 78, 84, 65, 66, 73, 76, 73, 84, 89, 44, 32,
 70, 73, 84, 78, 69, 83, 83, 32, 70, 79, 82, 32, 65, 32, 80, 65,
 82, 84, 73, 67, 85, 76, 65, 82, 32, 80, 85, 82, 80, 79, 83, 69,
 32, 65, 78, 68, 32, 78, 79, 78, 73, 78, 70, 82, 73, 78, 71, 69,
 77, 69, 78, 84, 32, 79, 70, 32, 67, 79, 80, 89, 82, 73, 71, 72,
 84, 44, 32, 80, 65, 84, 69, 78, 84, 44, 32, 84, 82, 65, 68, 69,
 77, 65, 82, 75, 44, 32, 79, 82, 32, 79, 84, 72, 69, 82, 32, 82,
 73, 71, 72, 84, 46, 32, 73, 78, 32, 78, 79, 32, 69, 86, 69, 78,
 84, 32, 83, 72, 65, 76, 76, 32, 66, 73, 84, 83, 84, 82, 69, 65,
 77, 32, 79, 82, 32, 84, 72, 69, 32, 71, 78, 79, 77, 69, 32, 70,
 79, 85, 78, 68, 65, 84, 73, 79, 78, 32, 66, 69, 32, 76, 73, 65,
 66, 76, 69, 32, 70, 79, 82, 32, 65, 78, 89, 32, 67, 76, 65, 73,
 77, 44, 32, 68, 65, 77, 65, 71, 69, 83, 32, 79, 82, 32, 79, 84,
 72, 69, 82, 32, 76, 73, 65, 66, 73, 76, 73, 84, 89, 44, 32, 73,
 78, 67, 76, 85, 68, 73, 78, 71, 32, 65, 78, 89, 32, 71, 69, 78,
 69, 82, 65, 76, 44, 32, 83, 80, 69, 67, 73, 65, 76, 44, 32, 73,
 78, 68, 73, 82, 69, 67, 84, 44, 32, 73, 78, 67, 73, 68, 69, 78,
 84, 65, 76, 44, 32, 79, 82, 32, 67, 79, 78, 83, 69, 81, 85, 69,
 78, 84, 73, 65, 76, 32, 68, 65, 77, 65, 71, 69, 83, 44, 32, 87,
 72, 69, 84, 72, 69, 82, 32, 73, 78, 32, 65, 78, 32, 65, 67, 84,
 73, 79, 78, 32, 79, 70, 32, 67, 79, 78, 84, 82, 65, 67, 84, 44,
 32, 84, 79, 82, 84, 32, 79, 82, 32, 79, 84, 72, 69, 82, 87, 73,
 83, 69, 44, 32, 65, 82, 73, 83, 73, 78, 71, 32, 70, 82, 79, 77,
 44, 32, 79, 85, 84, 32, 79, 70, 32, 84, 72, 69, 32, 85, 83, 69,
 32, 79, 82, 32, 73, 78, 65, 66, 73, 76, 73, 84, 89, 32, 84, 79,
 32, 85, 83, 69, 32, 84, 72, 69, 32, 70, 79, 78, 84, 32, 83, 79,
 70, 84, 87, 65, 82, 69, 32, 79, 82, 32, 70, 82, 79, 77, 32, 79,
 84, 72, 69, 82, 32, 68, 69, 65, 76, 73, 78, 71, 83, 32, 73, 78,
 32, 84, 72, 69, 32, 70, 79, 78, 84, 32, 83, 79, 70, 84, 87, 65,
 82, 69, 46, 13, 10, 13, 10, 69,120, 99,101,112,116, 32, 97,115,
 32, 99,111,110,116, 97,105,110,101,100, 32,105,110, 32,116,104,
105,115, 32,110,111,116,105, 99,101, 44, 32,116,104,101, 32,110,
 97,109,101,115, 32,111,102, 32, 71,110,111,109,101, 44, 32,116,
104,101, 32, 71,110,111,109,101, 32, 70,111,117,110,100, 97,116,
105,111,110, 44, 32, 97,110,100, 32, 66,105,116,115,116,114,101,
 97,109, 32, 73,110, 99, 46, 44, 32,115,104, 97,108,108, 32,110,
111,116, 32, 98,101, 32,117,115,101,100, 32,105,110, 32, 97,100,
118,101,114,116,105,115,105,110,103, 32,111,114, 32,111,116,104,
101,114,119,105,115,101, 32,116,111, 32,112,114,111,109,111,116,
101, 32,116,104,101, 32,115, 97,108,101, 44, 32,117,115,101, 32,
111,114, 32,111,116,104,101,114, 32,100,101, 97,108,105,110,103,
115, 32,105,110, 32,116,104,105,115, 32, 70,111,110,116, 32, 83,
111,102,116,119, 97,114,101, 32,119,105,116,104,111,117,116, 32,
112,114,105,111,114, 32,119,114,105,116,116,101,110, 32, 97,117,
116,104,111,114,105,122, 97,116,105,111,110, 32,102,114,111,109,
 32,116,104,101, 32, 71,110,111,109,101, 32, 70,111,117,110,100,
 97,116,105,111,110, 32,111,114, 32, 66,105,116,115,116,114,101,
 97,109, 32, 73,110, 99, 46, 44, 32,114,101,115,112,101, 99,116,
105,118,101,108,121, 46, 32, 70,111,114, 32,102,117,114,116,104,
101,114, 32,105,110,102,111,114,109, 97,116,105,111,110, 44, 32,
 99,111,110,116, 97, 99,116, 58, 32,102,111,110,116,115, 32, 97,
116, 32,103,110,111,109,101, 32,100,111,116, 32,111,114,103, 46,
104,116,116,112, 58, 47, 47,119,119,119, 46, 98,105,116,115,116,
114,101, 97,109, 46, 99,111,109,  0, 67,  0,111,  0,112,  0,121,
  0,114,  0,105,  0,103,  0,104,  0,116,  0, 32,  0, 40,  0, 99,
  0, 41,  0, 32,  0, 50,  0, 48,  0, 48,  0, 51,  0, 32,  0, 98,
  0,121,  0, 32,  0, 66,  0,105,  0,116,  0,115,  0,116,  0,114,
  0,101,  0, 97,  0,109,  0, 44,  0, 32,  0, 73,  0,110,  0, 99,
  0, 46,  0, 32,  0, 65,  0,108,  0,108,  0, 32,  0, 82,  0,105,
  0,103,  0,104,  0,116,  0,115,  0, 32,  0, 82,  0,101,  0,115,
  0,101,  0,114,  0,118,  0,101,  0,100,  0, 46,  0, 66,  0,105,
  0,116,  0,115,  0,116,  0,114,  0,101,  0, 97,  0,109,  0, 32,
  0, 86,  0,101,  0,114,  0, 97,  0, 32,  0, 83,  0, 97,  0,110,
  0,115,  0, 32,  0, 66,  0,111,  0,108,  0,100,  0, 32,  0, 79,
  0, 98,  0,108,  0,105,  0,113,  0,117,  0,101,  0, 82,  0,101,
  0,108,  0,101,  0, 97,  0,115,  0,101,  0, 32,  0, 49,  0, 46,
  0, 49,  0, 48,  0, 66,  0,105,  0,116,  0,115,  0,116,  0,114,
  0,101,  0, 97,  0,109,  0, 86,  0,101,  0,114,  0, 97,  0, 83,
  0, 97,  0,110,  0,115,  0, 45,  0, 66,  0,111,  0,108,  0,100,
  0, 79,  0, 98,  0,108,  0,105,  0,113,  0,117,  0,101,  0, 67,
  0,111,  0,112,  0,121,  0,114,  0,105,  0,103,  0,104,  0,116,
  0, 32,  0, 40,  0, 99,  0, 41,  0, 32,  0, 50,  0, 48,  0, 48,
  0, 51,  0, 32,  0, 98,  0,121,  0, 32,  0, 66,  0,105,  0,116,
  0,115,  0,116,  0,114,  0,101,  0, 97,  0,109,  0, 44,  0, 32,
  0, 73,  0,110,  0, 99,  0, 46,  0, 13,  0, 10,  0, 65,  0,108,
  0,108,  0, 32,  0, 82,  0,105,  0,103,  0,104,  0,116,  0,115,
  0, 32,  0, 82,  0,101,  0,115,  0,101,  0,114,  0,118,  0,101,
  0,100,  0, 46,  0, 13,  0, 10,  0, 66,  0,105,  0,116,  0,115,
  0,116,  0,114,  0,101,  0, 97,  0,109,  0, 32,  0, 86,  0,101,
  0,114,  0, 97,  0, 32,  0,105,  0,115,  0, 32,  0, 97,  0, 32,
  0,116,  0,114,  0, 97,  0,100,  0,101,  0,109,  0, 97,  0,114,
  0,107,  0, 32,  0,111,  0,102,  0, 32,  0, 66,  0,105,  0,116,
  0,115,  0,116,  0,114,  0,101,  0, 97,  0,109,  0, 44,  0, 32,
  0, 73,  0,110,  0, 99,  0, 46,  0, 13,  0, 10,  0, 13,  0, 10,
  0, 80,  0,101,  0,114,  0,109,  0,105,  0,115,  0,115,  0,105,
  0,111,  0,110,  0, 32,  0,105,  0,115,  0, 32,  0,104,  0,101,
  0,114,  0,101,  0, 98,  0,121,  0, 32,  0,103,  0,114,  0, 97,
  0,110,  0,116,  0,101,  0,100,  0, 44,  0, 32,  0,102,  0,114,
  0,101,  0,101,  0, 32,  0,111,  0,102,  0, 32,  0, 99,  0,104,
  0, 97,  0,114,  0,103,  0,101,  0, 44,  0, 32,  0,116,  0,111,
  0, 32,  0, 97,  0,110,  0,121,  0, 32,  0,112,  0,101,  0,114,
  0,115,  0,111,  0,110,  0, 32,  0,111,  0, 98,  0,116,  0, 97,
  0,105,  0,110,  0,105,  0,110,  0,103,  0, 32,  0, 97,  0, 32,
  0, 99,  0,111,  0,112,  0,121,  0, 32,  0,111,  0,102,  0, 32,
  0,116,  0,104,  0,101,  0, 32,  0,102,  0,111,  0,110,  0,116,
  0,115,  0, 32,  0, 97,  0, 99,  0, 99,  0,111,  0,109,  0,112,
  0, 97,  0,110,  0,121,  0,105,  0,110,  0,103,  0, 32,  0,116,
  0,104,  0,105,  0,115,  0, 32,  0,108,  0,105,  0, 99,  0,101,
  0,110,  0,115,  0,101,  0, 32,  0, 40,  0, 34,  0, 70,  0,111,
  0,110,  0,116,  0,115,  0, 34,  0, 41,  0, 32,  0, 97,  0,110,
  0,100,  0, 32,  0, 97,  0,115,  0,115,  0,111,  0, 99,  0,105,
  0, 97,  0,116,  0,101,  0,100,  0, 32,  0,100,  0,111,  0, 99,
  0,117,  0,109,  0,101,  0,110,  0,116,  0, 97,  0,116,  0,105,
  0,111,  0,110,  0, 32,  0,102,  0,105,  0,108,  0,101,  0,115,
  0, 32,  0, 40,  0,116,  0,104,  0,101,  0, 32,  0, 34,  0, 70,
  0,111,  0,110,  0,116,  0, 32,  0, 83,  0,111,  0,102,  0,116,
  0,119,  0, 97,  0,114,  0,101,  0, 34,  0, 41,  0, 44,  0, 32,
  0,116,  0,111,  0, 32,  0,114,  0,101,  0,112,  0,114,  0,111,
  0,100,  0,117,  0, 99,  0,101,  0, 32,  0, 97,  0,110,  0,100,
  0, 32,  0,100,  0,105,  0,115,  0,116,  0,114,  0,105,  0, 98,
  0,117,  0,116,  0,101,  0, 32,  0,116,  0,104,  0,101,  0, 32,
  0, 70,  0,111,  0,110,  0,116,  0, 32,  0, 83,  0,111,  0,102,
  0,116,  0,119,  0, 97,  0,114,  0,101,  0, 44,  0, 32,  0,105,
  0,110,  0, 99,  0,108,  0,117,  0,100,  0,105,  0,110,  0,103,
  0, 32,  0,119,  0,105,  0,116,  0,104,  0,111,  0,117,  0,116,
  0, 32,  0,108,  0,105,  0,109,  0,105,  0,116,  0, 97,  0,116,
  0,105,  0,111,  0,110,  0, 32,  0,116,  0,104,  0,101,  0, 32,
  0,114,  0,105,  0,103,  0,104,  0,116,  0,115,  0, 32,  0,116,
  0,111,  0, 32,  0,117,  0,115,  0,101,  0, 44,  0, 32,  0, 99,
  0,111,  0,112,  0,121,  0, 44,  0, 32,  0,109,  0,101,  0,114,
  0,103,  0,101,  0, 44,  0, 32,  0,112,  0,117,  0, 98,  0,108,
  0,105,  0,115,  0,104,  0, 44,  0, 32,  0,100,  0,105,  0,115,
  0,116,  0,114,  0,105,  0, 98,  0,117,  0,116,  0,101,  0, 44,
  0, 32,  0, 97,  0,110,  0,100,  0, 47,  0,111,  0,114,  0, 32,
  0,115,  0,101,  0,108,  0,108,  0, 32,  0, 99,  0,111,  0,112,
  0,105,  0,101,  0,115,  0, 32,  0,111,  0,102,  0, 32,  0,116,
  0,104,  0,101,  0, 32,  0, 70,  0,111,  0,110,  0,116,  0, 32,
  0, 83,  0,111,  0,102,  0,116,  0,119,  0, 97,  0,114,  0,101,
  0, 44,  0, 32,  0, 97,  0,110,  0,100,  0, 32,  0,116,  0,111,
  0, 32,  0,112,  0,101,  0,114,  0,109,  0,105,  0,116,  0, 32,
  0,112,  0,101,  0,114,  0,115,  0,111,  0,110,  0,115,  0, 32,
  0,116,  0,111,  0, 32,  0,119,  0,104,  0,111,  0,109,  0, 32,
  0,116,  0,104,  0,101,  0, 32,  0, 70,  0,111,  0,110,  0,116,
  0, 32,  0, 83,  0,111,  0,102,  0,116,  0,119,  0, 97,  0,114,
  0,101,  0, 32,  0,105,  0,115,  0, 32,  0,102,  0,117,  0,114,
  0,110,  0,105,  0,115,  0,104,  0,101,  0,100,  0, 32,  0,116,
  0,111,  0, 32,  0,100,  0,111,  0, 32,  0,115,  0,111,  0, 44,
  0, 32,  0,115,  0,117,  0, 98,  0,106,  0,101,  0, 99,  0,116,
  0, 32,  0,116,  0,111,  0, 32,  0,116,  0,104,  0,101,  0, 32,
  0,102,  0,111,  0,108,  0,108,  0,111,  0,119,  0,105,  0,110,
  0,103,  0, 32,  0, 99,  0,111,  0,110,  0,100,  0,105,  0,116,
  0,105,  0,111,  0,110,  0,115,  0, 58,  0, 13,  0, 10,  0, 13,
  0, 10,  0, 84,  0,104,  0,101,  0, 32,  0, 97,  0, 98,  0,111,
  0,118,  0,101,  0, 32,  0, 99,  0,111,  0,112,  0,121,  0,114,
  0,105,  0,103,  0,104,  0,116,  0, 32,  0, 97,  0,110,  0,100,
  0, 32,  0,116,  0,114,  0, 97,  0,100,  0,101,  0,109,  0, 97,
  0,114,  0,107,  0, 32,  0,110,  0,111,  0,116,  0,105,  0, 99,
  0,101,  0,115,  0, 32,  0, 97,  0,110,  0,100,  0, 32,  0,116,
  0,104,  0,105,  0,115,  0, 32,  0,112,  0,101,  0,114,  0,109,
  0,105,  0,115,  0,115,  0,105,  0,111,  0,110,  0, 32,  0,110,
  0,111,  0,116,  0,105,  0, 99,  0,101,  0, 32,  0,115,  0,104,
  0, 97,  0,108,  0,108,  0, 32,  0, 98,  0,101,  0, 32,  0,105,
  0,110,  0, 99,  0,108,  0,117,  0,100,  0,101,  0,100,  0, 32,
  0,105,  0,110,  0, 32,  0, 97,  0,108,  0,108,  0, 32,  0, 99,
  0,111,  0,112,  0,105,  0,101,  0,115,  0, 32,  0,111,  0,102,
  0, 32,  0,111,  0,110,  0,101,  0, 32,  0,111,  0,114,  0, 32,
  0,109,  0,111,  0,114,  0,101,  0, 32,  0,111,  0,102,  0, 32,
  0,116,  0,104,  0,101,  0, 32,  0, 70,  0,111,  0,110,  0,116,
  0, 32,  0, 83,  0,111,  0,102,  0,116,  0,119,  0, 97,  0,114,
  0,101,  0, 32,  0,116,  0,121,  0,112,  0,101,  0,102,  0, 97,
  0, 99,  0,101,  0,115,  0, 46,  0, 13,  0, 10,  0, 13,  0, 10,
  0, 84,  0,104,  0,101,  0, 32,  0, 70,  0,111,  0,110,  0,116,
  0, 32,  0, 83,  0,111,  0,102,  0,116,  0,119,  0, 97,  0,114,
  0,101,  0, 32,  0,109,  0, 97,  0,121,  0, 32,  0, 98,  0,101,
  0, 32,  0,109,  0,111,  0,100,  0,105,  0,102,  0,105,  0,101,
  0,100,  0, 44,  0, 32,  0, 97,  0,108,  0,116,  0,101,  0,114,
  0,101,  0,100,  0, 44,  0, 32,  0,111,  0,114,  0, 32,  0, 97,
  0,100,  0,100,  0,101,  0,100,  0, 32,  0,116,  0,111,  0, 44,
  0, 32,  0, 97,  0,110,  0,100,  0, 32,  0,105,  0,110,  0, 32,
  0,112,  0, 97,  0,114,  0,116,  0,105,  0, 99,  0,117,  0,108,
  0, 97,  0,114,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0,100,
  0,101,  0,115,  0,105,  0,103,  0,110,  0,115,  0, 32,  0,111,
  0,102,  0, 32,  0,103,  0,108,  0,121,  0,112,  0,104,  0,115,
  0, 32,  0,111,  0,114,  0, 32,  0, 99,  0,104,  0, 97,  0,114,
  0, 97,  0, 99,  0,116,  0,101,  0,114,  0,115,  0, 32,  0,105,
  0,110,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0, 70,  0,111,
  0,110,  0,116,  0,115,  0, 32,  0,109,  0, 97,  0,121,  0, 32,
  0, 98,  0,101,  0, 32,  0,109,  0,111,  0,100,  0,105,  0,102,
  0,105,  0,101,  0,100,  0, 32,  0, 97,  0,110,  0,100,  0, 32,
  0, 97,  0,100,  0,100,  0,105,  0,116,  0,105,  0,111,  0,110,
  0, 97,  0,108,  0, 32,  0,103,  0,108,  0,121,  0,112,  0,104,
  0,115,  0, 32,  0,111,  0,114,  0, 32,  0, 99,  0,104,  0, 97,
  0,114,  0, 97,  0, 99,  0,116,  0,101,  0,114,  0,115,  0, 32,
  0,109,  0, 97,  0,121,  0, 32,  0, 98,  0,101,  0, 32,  0, 97,
  0,100,  0,100,  0,101,  0,100,  0, 32,  0,116,  0,111,  0, 32,
  0,116,  0,104,  0,101,  0, 32,  0, 70,  0,111,  0,110,  0,116,
  0,115,  0, 44,  0, 32,  0,111,  0,110,  0,108,  0,121,  0, 32,
  0,105,  0,102,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0,102,
  0,111,  0,110,  0,116,  0,115,  0, 32,  0, 97,  0,114,  0,101,
  0, 32,  0,114,  0,101,  0,110,  0, 97,  0,109,  0,101,  0,100,
  0, 32,  0,116,  0,111,  0, 32,  0,110,  0, 97,  0,109,  0,101,
  0,115,  0, 32,  0,110,  0,111,  0,116,  0, 32,  0, 99,  0,111,
  0,110,  0,116,  0, 97,  0,105,  0,110,  0,105,  0,110,  0,103,
  0, 32,  0,101,  0,105,  0,116,  0,104,  0,101,  0,114,  0, 32,
  0,116,  0,104,  0,101,  0, 32,  0,119,  0,111,  0,114,  0,100,
  0,115,  0, 32,  0, 34,  0, 66,  0,105,  0,116,  0,115,  0,116,
  0,114,  0,101,  0, 97,  0,109,  0, 34,  0, 32,  0,111,  0,114,
  0, 32,  0,116,  0,104,  0,101,  0, 32,  0,119,  0,111,  0,114,
  0,100,  0, 32,  0, 34,  0, 86,  0,101,  0,114,  0, 97,  0, 34,
  0, 46,  0, 13,  0, 10,  0, 13,  0, 10,  0, 84,  0,104,  0,105,
  0,115,  0, 32,  0, 76,  0,105,  0, 99,  0,101,  0,110,  0,115,
  0,101,  0, 32,  0, 98,  0,101,  0, 99,  0,111,  0,109,  0,101,
  0,115,  0, 32,  0,110,  0,117,  0,108,  0,108,  0, 32,  0, 97,
  0,110,  0,100,  0, 32,  0,118,  0,111,  0,105,  0,100,  0, 32,
  0,116,  0,111,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0,101,
  0,120,  0,116,  0,101,  0,110,  0,116,  0, 32,  0, 97,  0,112,
  0,112,  0,108,  0,105,  0, 99,  0, 97,  0, 98,  0,108,  0,101,
  0, 32,  0,116,  0,111,  0, 32,  0, 70,  0,111,  0,110,  0,116,
  0,115,  0, 32,  0,111,  0,114,  0, 32,  0, 70,  0,111,  0,110,
  0,116,  0, 32,  0, 83,  0,111,  0,102,  0,116,  0,119,  0, 97,
  0,114,  0,101,  0, 32,  0,116,  0,104,  0, 97,  0,116,  0, 32,
  0,104,  0, 97,  0,115,  0, 32,  0, 98,  0,101,  0,101,  0,110,
  0, 32,  0,109,  0,111,  0,100,  0,105,  0,102,  0,105,  0,101,
  0,100,  0, 32,  0, 97,  0,110,  0,100,  0, 32,  0,105,  0,115,
  0, 32,  0,100,  0,105,  0,115,  0,116,  0,114,  0,105,  0, 98,
  0,117,  0,116,  0,101,  0,100,  0, 32,  0,117,  0,110,  0,100,
  0,101,  0,114,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0, 34,
  0, 66,  0,105,  0,116,  0,115,  0,116,  0,114,  0,101,  0, 97,
  0,109,  0, 32,  0, 86,  0,101,  0,114,  0, 97,  0, 34,  0, 32,
  0,110,  0, 97,  0,109,  0,101,  0,115,  0, 46,  0, 13,  0, 10,
  0, 13,  0, 10,  0, 84,  0,104,  0,101,  0, 32,  0, 70,  0,111,
  0,110,  0,116,  0, 32,  0, 83,  0,111,  0,102,  0,116,  0,119,
  0, 97,  0,114,  0,101,  0, 32,  0,109,  0, 97,  0,121,  0, 32,
  0, 98,  0,101,  0, 32,  0,115,  0,111,  0,108,  0,100,  0, 32,
  0, 97,  0,115,  0, 32,  0,112,  0, 97,  0,114,  0,116,  0, 32,
  0,111,  0,102,  0, 32,  0, 97,  0, 32,  0,108,  0, 97,  0,114,
  0,103,  0,101,  0,114,  0, 32,  0,115,  0,111,  0,102,  0,116,
  0,119,  0, 97,  0,114,  0,101,  0, 32,  0,112,  0, 97,  0, 99,
  0,107,  0, 97,  0,103,  0,101,  0, 32,  0, 98,  0,117,  0,116,
  0, 32,  0,110,  0,111,  0, 32,  0, 99,  0,111,  0,112,  0,121,
  0, 32,  0,111,  0,102,  0, 32,  0,111,  0,110,  0,101,  0, 32,
  0,111,  0,114,  0, 32,  0,109,  0,111,  0,114,  0,101,  0, 32,
  0,111,  0,102,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0, 70,
  0,111,  0,110,  0,116,  0, 32,  0, 83,  0,111,  0,102,  0,116,
  0,119,  0, 97,  0,114,  0,101,  0, 32,  0,116,  0,121,  0,112,
  0,101,  0,102,  0, 97,  0, 99,  0,101,  0,115,  0, 32,  0,109,
  0, 97,  0,121,  0, 32,  0, 98,  0,101,  0, 32,  0,115,  0,111,
  0,108,  0,100,  0, 32,  0, 98,  0,121,  0, 32,  0,105,  0,116,
  0,115,  0,101,  0,108,  0,102,  0, 46,  0, 13,  0, 10,  0, 13,
  0, 10,  0, 84,  0, 72,  0, 69,  0, 32,  0, 70,  0, 79,  0, 78,
  0, 84,  0, 32,  0, 83,  0, 79,  0, 70,  0, 84,  0, 87,  0, 65,
  0, 82,  0, 69,  0, 32,  0, 73,  0, 83,  0, 32,  0, 80,  0, 82,
  0, 79,  0, 86,  0, 73,  0, 68,  0, 69,  0, 68,  0, 32,  0, 34,
  0, 65,  0, 83,  0, 32,  0, 73,  0, 83,  0, 34,  0, 44,  0, 32,
  0, 87,  0, 73,  0, 84,  0, 72,  0, 79,  0, 85,  0, 84,  0, 32,
  0, 87,  0, 65,  0, 82,  0, 82,  0, 65,  0, 78,  0, 84,  0, 89,
  0, 32,  0, 79,  0, 70,  0, 32,  0, 65,  0, 78,  0, 89,  0, 32,
  0, 75,  0, 73,  0, 78,  0, 68,  0, 44,  0, 32,  0, 69,  0, 88,
  0, 80,  0, 82,  0, 69,  0, 83,  0, 83,  0, 32,  0, 79,  0, 82,
  0, 32,  0, 73,  0, 77,  0, 80,  0, 76,  0, 73,  0, 69,  0, 68,
  0, 44,  0, 32,  0, 73,  0, 78,  0, 67,  0, 76,  0, 85,  0, 68,
  0, 73,  0, 78,  0, 71,  0, 32,  0, 66,  0, 85,  0, 84,  0, 32,
  0, 78,  0, 79,  0, 84,  0, 32,  0, 76,  0, 73,  0, 77,  0, 73,
  0, 84,  0, 69,  0, 68,  0, 32,  0, 84,  0, 79,  0, 32,  0, 65,
  0, 78,  0, 89,  0, 32,  0, 87,  0, 65,  0, 82,  0, 82,  0, 65,
  0, 78,  0, 84,  0, 73,  0, 69,  0, 83,  0, 32,  0, 79,  0, 70,
  0, 32,  0, 77,  0, 69,  0, 82,  0, 67,  0, 72,  0, 65,  0, 78,
  0, 84,  0, 65,  0, 66,  0, 73,  0, 76,  0, 73,  0, 84,  0, 89,
  0, 44,  0, 32,  0, 70,  0, 73,  0, 84,  0, 78,  0, 69,  0, 83,
  0, 83,  0, 32,  0, 70,  0, 79,  0, 82,  0, 32,  0, 65,  0, 32,
  0, 80,  0, 65,  0, 82,  0, 84,  0, 73,  0, 67,  0, 85,  0, 76,
  0, 65,  0, 82,  0, 32,  0, 80,  0, 85,  0, 82,  0, 80,  0, 79,
  0, 83,  0, 69,  0, 32,  0, 65,  0, 78,  0, 68,  0, 32,  0, 78,
  0, 79,  0, 78,  0, 73,  0, 78,  0, 70,  0, 82,  0, 73,  0, 78,
  0, 71,  0, 69,  0, 77,  0, 69,  0, 78,  0, 84,  0, 32,  0, 79,
  0, 70,  0, 32,  0, 67,  0, 79,  0, 80,  0, 89,  0, 82,  0, 73,
  0, 71,  0, 72,  0, 84,  0, 44,  0, 32,  0, 80,  0, 65,  0, 84,
  0, 69,  0, 78,  0, 84,  0, 44,  0, 32,  0, 84,  0, 82,  0, 65,
  0, 68,  0, 69,  0, 77,  0, 65,  0, 82,  0, 75,  0, 44,  0, 32,
  0, 79,  0, 82,  0, 32,  0, 79,  0, 84,  0, 72,  0, 69,  0, 82,
  0, 32,  0, 82,  0, 73,  0, 71,  0, 72,  0, 84,  0, 46,  0, 32,
  0, 73,  0, 78,  0, 32,  0, 78,  0, 79,  0, 32,  0, 69,  0, 86,
  0, 69,  0, 78,  0, 84,  0, 32,  0, 83,  0, 72,  0, 65,  0, 76,
  0, 76,  0, 32,  0, 66,  0, 73,  0, 84,  0, 83,  0, 84,  0, 82,
  0, 69,  0, 65,  0, 77,  0, 32,  0, 79,  0, 82,  0, 32,  0, 84,
  0, 72,  0, 69,  0, 32,  0, 71,  0, 78,  0, 79,  0, 77,  0, 69,
  0, 32,  0, 70,  0, 79,  0, 85,  0, 78,  0, 68,  0, 65,  0, 84,
  0, 73,  0, 79,  0, 78,  0, 32,  0, 66,  0, 69,  0, 32,  0, 76,
  0, 73,  0, 65,  0, 66,  0, 76,  0, 69,  0, 32,  0, 70,  0, 79,
  0, 82,  0, 32,  0, 65,  0, 78,  0, 89,  0, 32,  0, 67,  0, 76,
  0, 65,  0, 73,  0, 77,  0, 44,  0, 32,  0, 68,  0, 65,  0, 77,
  0, 65,  0, 71,  0, 69,  0, 83,  0, 32,  0, 79,  0, 82,  0, 32,
  0, 79,  0, 84,  0, 72,  0, 69,  0, 82,  0, 32,  0, 76,  0, 73,
  0, 65,  0, 66,  0, 73,  0, 76,  0, 73,  0, 84,  0, 89,  0, 44,
  0, 32,  0, 73,  0, 78,  0, 67,  0, 76,  0, 85,  0, 68,  0, 73,
  0, 78,  0, 71,  0, 32,  0, 65,  0, 78,  0, 89,  0, 32,  0, 71,
  0, 69,  0, 78,  0, 69,  0, 82,  0, 65,  0, 76,  0, 44,  0, 32,
  0, 83,  0, 80,  0, 69,  0, 67,  0, 73,  0, 65,  0, 76,  0, 44,
  0, 32,  0, 73,  0, 78,  0, 68,  0, 73,  0, 82,  0, 69,  0, 67,
  0, 84,  0, 44,  0, 32,  0, 73,  0, 78,  0, 67,  0, 73,  0, 68,
  0, 69,  0, 78,  0, 84,  0, 65,  0, 76,  0, 44,  0, 32,  0, 79,
  0, 82,  0, 32,  0, 67,  0, 79,  0, 78,  0, 83,  0, 69,  0, 81,
  0, 85,  0, 69,  0, 78,  0, 84,  0, 73,  0, 65,  0, 76,  0, 32,
  0, 68,  0, 65,  0, 77,  0, 65,  0, 71,  0, 69,  0, 83,  0, 44,
  0, 32,  0, 87,  0, 72,  0, 69,  0, 84,  0, 72,  0, 69,  0, 82,
  0, 32,  0, 73,  0, 78,  0, 32,  0, 65,  0, 78,  0, 32,  0, 65,
  0, 67,  0, 84,  0, 73,  0, 79,  0, 78,  0, 32,  0, 79,  0, 70,
  0, 32,  0, 67,  0, 79,  0, 78,  0, 84,  0, 82,  0, 65,  0, 67,
  0, 84,  0, 44,  0, 32,  0, 84,  0, 79,  0, 82,  0, 84,  0, 32,
  0, 79,  0, 82,  0, 32,  0, 79,  0, 84,  0, 72,  0, 69,  0, 82,
  0, 87,  0, 73,  0, 83,  0, 69,  0, 44,  0, 32,  0, 65,  0, 82,
  0, 73,  0, 83,  0, 73,  0, 78,  0, 71,  0, 32,  0, 70,  0, 82,
  0, 79,  0, 77,  0, 44,  0, 32,  0, 79,  0, 85,  0, 84,  0, 32,
  0, 79,  0, 70,  0, 32,  0, 84,  0, 72,  0, 69,  0, 32,  0, 85,
  0, 83,  0, 69,  0, 32,  0, 79,  0, 82,  0, 32,  0, 73,  0, 78,
  0, 65,  0, 66,  0, 73,  0, 76,  0, 73,  0, 84,  0, 89,  0, 32,
  0, 84,  0, 79,  0, 32,  0, 85,  0, 83,  0, 69,  0, 32,  0, 84,
  0, 72,  0, 69,  0, 32,  0, 70,  0, 79,  0, 78,  0, 84,  0, 32,
  0, 83,  0, 79,  0, 70,  0, 84,  0, 87,  0, 65,  0, 82,  0, 69,
  0, 32,  0, 79,  0, 82,  0, 32,  0, 70,  0, 82,  0, 79,  0, 77,
  0, 32,  0, 79,  0, 84,  0, 72,  0, 69,  0, 82,  0, 32,  0, 68,
  0, 69,  0, 65,  0, 76,  0, 73,  0, 78,  0, 71,  0, 83,  0, 32,
  0, 73,  0, 78,  0, 32,  0, 84,  0, 72,  0, 69,  0, 32,  0, 70,
  0, 79,  0, 78,  0, 84,  0, 32,  0, 83,  0, 79,  0, 70,  0, 84,
  0, 87,  0, 65,  0, 82,  0, 69,  0, 46,  0, 13,  0, 10,  0, 13,
  0, 10,  0, 69,  0,120,  0, 99,  0,101,  0,112,  0,116,  0, 32,
  0, 97,  0,115,  0, 32,  0, 99,  0,111,  0,110,  0,116,  0, 97,
  0,105,  0,110,  0,101,  0,100,  0, 32,  0,105,  0,110,  0, 32,
  0,116,  0,104,  0,105,  0,115,  0, 32,  0,110,  0,111,  0,116,
  0,105,  0, 99,  0,101,  0, 44,  0, 32,  0,116,  0,104,  0,101,
  0, 32,  0,110,  0, 97,  0,109,  0,101,  0,115,  0, 32,  0,111,
  0,102,  0, 32,  0, 71,  0,110,  0,111,  0,109,  0,101,  0, 44,
  0, 32,  0,116,  0,104,  0,101,  0, 32,  0, 71,  0,110,  0,111,
  0,109,  0,101,  0, 32,  0, 70,  0,111,  0,117,  0,110,  0,100,
  0, 97,  0,116,  0,105,  0,111,  0,110,  0, 44,  0, 32,  0, 97,
  0,110,  0,100,  0, 32,  0, 66,  0,105,  0,116,  0,115,  0,116,
  0,114,  0,101,  0, 97,  0,109,  0, 32,  0, 73,  0,110,  0, 99,
  0, 46,  0, 44,  0, 32,  0,115,  0,104,  0, 97,  0,108,  0,108,
  0, 32,  0,110,  0,111,  0,116,  0, 32,  0, 98,  0,101,  0, 32,
  0,117,  0,115,  0,101,  0,100,  0, 32,  0,105,  0,110,  0, 32,
  0, 97,  0,100,  0,118,  0,101,  0,114,  0,116,  0,105,  0,115,
  0,105,  0,110,  0,103,  0, 32,  0,111,  0,114,  0, 32,  0,111,
  0,116,  0,104,  0,101,  0,114,  0,119,  0,105,  0,115,  0,101,
  0, 32,  0,116,  0,111,  0, 32,  0,112,  0,114,  0,111,  0,109,
  0,111,  0,116,  0,101,  0, 32,  0,116,  0,104,  0,101,  0, 32,
  0,115,  0, 97,  0,108,  0,101,  0, 44,  0, 32,  0,117,  0,115,
  0,101,  0, 32,  0,111,  0,114,  0, 32,  0,111,  0,116,  0,104,
  0,101,  0,114,  0, 32,  0,100,  0,101,  0, 97,  0,108,  0,105,
  0,110,  0,103,  0,115,  0, 32,  0,105,  0,110,  0, 32,  0,116,
  0,104,  0,105,  0,115,  0, 32,  0, 70,  0,111,  0,110,  0,116,
  0, 32,  0, 83,  0,111,  0,102,  0,116,  0,119,  0, 97,  0,114,
  0,101,  0, 32,  0,119,  0,105,  0,116,  0,104,  0,111,  0,117,
  0,116,  0, 32,  0,112,  0,114,  0,105,  0,111,  0,114,  0, 32,
  0,119,  0,114,  0,105,  0,116,  0,116,  0,101,  0,110,  0, 32,
  0, 97,  0,117,  0,116,  0,104,  0,111,  0,114,  0,105,  0,122,
  0, 97,  0,116,  0,105,  0,111,  0,110,  0, 32,  0,102,  0,114,
  0,111,  0,109,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0, 71,
  0,110,  0,111,  0,109,  0,101,  0, 32,  0, 70,  0,111,  0,117,
  0,110,  0,100,  0, 97,  0,116,  0,105,  0,111,  0,110,  0, 32,
  0,111,  0,114,  0, 32,  0, 66,  0,105,  0,116,  0,115,  0,116,
  0,114,  0,101,  0, 97,  0,109,  0, 32,  0, 73,  0,110,  0, 99,
  0, 46,  0, 44,  0, 32,  0,114,  0,101,  0,115,  0,112,  0,101,
  0, 99,  0,116,  0,105,  0,118,  0,101,  0,108,  0,121,  0, 46,
  0, 32,  0, 70,  0,111,  0,114,  0, 32,  0,102,  0,117,  0,114,
  0,116,  0,104,  0,101,  0,114,  0, 32,  0,105,  0,110,  0,102,
  0,111,  0,114,  0,109,  0, 97,  0,116,  0,105,  0,111,  0,110,
  0, 44,  0, 32,  0, 99,  0,111,  0,110,  0,116,  0, 97,  0, 99,
  0,116,  0, 58,  0, 32,  0,102,  0,111,  0,110,  0,116,  0,115,
  0, 32,  0, 97,  0,116,  0, 32,  0,103,  0,110,  0,111,  0,109,
  0,101,  0, 32,  0,100,  0,111,  0,116,  0, 32,  0,111,  0,114,
  0,103,  0, 46,  0,104,  0,116,  0,116,  0,112,  0, 58,  0, 47,
  0, 47,  0,119,  0,119,  0,119,  0, 46,  0, 98,  0,105,  0,116,
  0,115,  0,116,  0,114,  0,101,  0, 97,  0,109,  0, 46,  0, 99,
  0,111,  0,109,  0,  0,  1, 35,  1, 47,  1,102,  1, 51,  1,102,
  0,188,  0,233,  0,  0,  0,  0,  1, 61,  0,250,  3, 59,  0, 43,
  1,102,  1,102,  1, 84,  0,236,  1,129,  1,125,  4,205,  4,102,
  1,188,  0,186,  0,229,  0, 43,  1,129,  1,150,  6, 92,  6, 57,
  5,215,  1, 47,  1, 47,  1,117,  4,252,  4,205,  0,217,  0,147,
  0,184,  4,154,  4,236,  4,184,  1, 76,  1,102,  1, 76,  0,154,
  2,154,  1, 68,  1, 25,  1, 68,  2,205,  1,154,  1, 59,  5,203,
  5,203,  0,213,  0,213,  1, 80,  0,172,  0,172,  0,119,  2, 10,
  1, 47,  1, 88,  1,178,  1, 35,  0,246,  0,246,  1, 31,  1, 47,
  1, 53,  2, 53,  2, 27,  1,231,  1, 51,  0,152,  0,209,  3, 88,
  4,102,  0,229,  0,242,  0,115,  4,  0,  5,213,  1,131,  0,143,
  2, 43,  5,213,  0,195,  0,225,  0,215,  0,229,  0,  0,  0,106,
  1,  2,  0,  0,  0, 29,  3, 45,  5,213,  5,213,  5,240,  0,168,
  0,106,  0,236,  0,225,  1,  2,  5,213,  6, 20,  7, 33,  4,102,
  2,248,  0,236,  2,166,  2,248,  1, 35,  1,  2,  1,  2,  1, 18,
  1, 31,  3, 31,  0, 94,  3,205,  4, 96,  4,199,  4,137,  0,236,
  1,188,  0,186,  1,  2,  3, 51,  3, 31,  3, 66,  3, 51,  3, 92,
  1, 18,  1, 31,  0,154,  0,225,  6,102,  1,121,  4, 96,  4, 96,
  4, 96,  4,123,  0,  0,  0,236,  2,195,  2,184,  2,205,  0,221,
  0,213,  0,  0,  0,106,  2, 92,  2,123,  2,154,  0,221,  1,174,
  1,186,  1, 18,  0,  0,  0,133,  1,174,  6,154,  4, 88,  0,238,
  0,154,  2,154,  0,209,  2,205,  1,154,  1, 80,  5,203,  5,203,
  0,139,  0,139,  4,  6,  0,240,  3, 76,  1, 96,  4,168,  0,193,
  0,  0,  0, 37,  5,193,  1,  0,  1, 33,  7, 74,  6, 18,  0,150,
  1, 74,  7,131,  3, 55,  0,  0,  0,123,  0,201,  0,168,  1,  0,
  5,193,  5,193,  5,193,  5,193,  1,  0,  1,  8,  6, 29,  0,150,
  0,236,  1,  2,  2,125,  1, 51,  0,152,  0,209,  3, 88,  0,205,
  1,121,  2, 57,  0,156,  3, 98,  0,156,  0,147,  1,184,  0,184,
  0,115,  0,  0, 20,  0,  0,  0,184,  2,128, 64,255,222,254,  3,
221, 17,  3,220, 22,  3,219,218, 58,  5,219,254,  3,218, 58,  3,
217,100,  3,216,187,  3,215,254,  3,214, 30,  3,213, 25,  3,212,
254,  3,211,254,  3,210,254,  3,209,254,  3,208,254,  3,207,206,
 14,  5,207,254,  3,206, 14,  3,203,202,125,  5,203,254,  3,202,
125,  3,201,200,140,  5,201,254,  3,201,192,  4,200,199, 89,  5,
200,140,  3,200,128,  4,199,198, 38,  5,199, 89,  3,199, 64,  4,
198, 38,  3,197,254,  3,196,250,  3,195,254,  3,194,250,  3,193,
 12,  3,193,128,  4,192,254,  3,191,250,  3,190,125,  3,189, 62,
  3,188,254,  3,186,185, 44,  5,186,254,  3,185, 44,  3,184,254,
  3,183,182, 71,  5,183,125,  3,182, 71,  3,181,250,  3,180,254,
  3,179,254,  3,178,254,  3,177,187,  3,176,254,  3,175, 30,  3,
174,254,  3,173,172, 10,  5,173,254,  3,172, 10,  3,172, 64,  4,
171,170, 10,  5,171, 50,  3,170, 10,  3,169,250,  3,168, 89, 22,
  5,168,254,  3,167,250,  3,166,250,  3,165, 89, 22,  5,165,254,
  3,164,254,  3,163,254,  3,162,250,  3,161,160, 24,  5,161,100,
  3,160, 24,  3,159,104, 30,  5,159,100,  3,158, 64,255,157, 37,
  5,158,250,  3,157, 37,  3,156, 89, 22,  5,156,250,  3,155,154,
 20,  5,155, 22,  3,154,153, 16,  5,154, 20,  3,153, 16,  3,152,
151, 11,  5,152, 32,  3,151, 11,  3,150,149, 37,  5,150,250,  3,
149, 89, 22,  5,149, 37,  3,148,147, 20,  5,148, 38,  3,147,146,
 18,  5,147, 20,  3,146, 18,  3,145, 89, 22,  5,145, 29,  3,144,
 20,  3,143,142,187,  5,143,254,  3,142,141, 93,  5,142,187,  3,
142,128,  4,141,140, 37,  5,141, 93,  3,141, 64,  4,140, 37,  3,
139,254,  3,138,100,  3,137, 88, 16,  5,137,254,  3,136, 28,  3,
135,134, 58,  5,135,250,  3,134,116, 27,  5,134, 58,  3,133,132,
 26,  5,133, 50,  3,132,131, 17,  5,132, 26,  3,131,130, 15,  5,
131, 17,  3,130,129, 12,  5,130, 15,  3,129, 12,  3,128, 89, 22,
  5,128,254,  3,127,254,  3,126, 21,  3,125, 18,  3,124,254,  3,
123,254,  3,122,254,  3,121, 23,  3,120, 25,  3,119, 22,  3,118,
116, 27,  5,118,250,  3,117,116, 27,  5,117,250,  3,116, 89, 22,
  5,116, 27,  3,115, 89, 22,  5,115,125,  3,114,254,  3,113, 38,
  3,112,254,  3,111,254,  3,110,254,  3,109, 10,  3, 64,255,108,
254,  3,107,106, 14,  5,107,254,  3,106, 14,  3,106, 64,  4,105,
104, 30,  5,105,250,  3,104, 89, 22,  5,104, 30,  3,103, 89, 22,
  5,103,250,  3,102, 92, 12,  5,102, 28,  3,101,254,  3,100, 99,
187,  5,100,254,  3, 99, 98, 93,  5, 99,187,  3, 99,128,  4, 98,
 87, 37,  5, 98, 93,  3, 98, 64,  4, 97,254,  3, 96, 95, 46,  5,
 96,254,  3, 95, 46,  3, 94, 89, 22,  5, 94, 30,  3, 93, 92, 12,
  5, 93, 32,  3, 92, 12,  3, 91, 89, 22,  5, 91, 75,  3, 90, 89,
 22,  5, 90,254,  3, 89, 88, 16,  5, 89, 22,  3, 88, 16,  3, 87,
 37,  3, 86,254,  3, 85,254,  3, 84,254,  3, 83,254,  3, 82,254,
  3, 81,254,  3, 80, 79, 37,  5, 80,150,  3, 79, 37,  3, 78, 16,
  3, 77,254,  3, 76,254,  3, 75,254,  3, 74,250,  3, 73,250,  3,
 72,  9,  3, 72, 64,  4, 70, 69,166,  5, 70,254,  3, 69,166,  3,
 68, 67, 27,  5, 68,250,  3, 67, 27,  3, 67, 64,  4, 66,100,  3,
 66, 64,  4, 65,125,  3, 64,254,  3, 63, 62, 44,  5, 62, 44,  3,
 61,250,  3, 60,254,  3, 59,254,  3, 58,254,  3, 57, 52, 12,  5,
 57, 50,  3, 56,254,  3, 55, 50,  3, 54, 53, 10,  5, 54, 64,255,
254,  3, 53, 10,  3, 53, 64,  4, 52, 51, 10,  5, 52, 12,  3, 51,
 10,  3, 50,254,  3, 49,  4, 17,  5, 49,125,  3, 48, 47, 27,  5,
 48,100,  3, 47,  4, 17,  5, 47, 27,  3, 46,254,  3, 45,250,  3,
 44, 43, 25,  5, 44, 75,  3, 43,  4, 17,  5, 43, 25,  3, 42,  4,
 17,  5, 42, 75,  3, 41, 40, 14,  5, 41, 24,  3, 40, 39, 10,  5,
 40, 14,  3, 39, 10,  3, 38, 16,  3, 37, 36, 14,  5, 37, 50,  3,
 36, 14,  3, 35, 34, 16,  5, 35, 20,  3, 34, 16,  3, 33, 15, 37,
  5, 33,250,  3, 32,  1, 10,  5, 32, 50,  3, 31, 24,  3, 31, 64,
  4, 30, 29, 10,  5, 30, 15,  3, 29, 10,  3, 28,  9,  3, 28, 64,
  4, 27, 18, 58,  5, 27,150,  3, 26, 15, 37,  5, 26,100,  3, 25,
254,  3, 24,100,  3, 23,254,  3, 22, 21,  3, 21, 20, 14,  5, 21,
 17,  3, 20, 14,  3, 19, 18, 58,  5, 19,150,  3, 18, 15, 37,  5,
 18, 58,  3, 17,254,  3, 16,  4, 17,  5, 16,254,  3, 15,  4, 17,
  5, 15, 37,  3, 14,  4, 17,  5, 14, 75,  3, 13, 24,  3, 12,254,
  3, 11,254,  3, 10,  9, 10,  5, 10,150,  3,  9, 10,  3,  9, 64,
  4,  7,250,  3,  6,100,  3,  5,  4, 17,  5,  5, 58,  3,  4, 64,
 26,  3, 14,  5,  4, 17,  3,  3, 14,  3,  2,  1, 10,  5,  2, 24,
  3,  1, 10,  3,  1, 64,  4,  0, 23,  3,  1,184,  1,100,133,141,
  1, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43,  0, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 29,  0,182,  6,  5,  4,  3,  2,  1,  0, 44, 32, 16,176,
  2, 37, 73,100,176, 64, 81, 88, 32,200, 89, 33, 45, 44,176,  2,
 37, 73,100,176, 64, 81, 88, 32,200, 89, 33, 45, 44, 32, 16,  7,
 32,176,  0, 80,176, 13,121, 32,184,255,255, 80, 88,  4, 27,  5,
 89,176,  5, 28,176,  3, 37,  8,176,  4, 37, 35,225, 32,176,  0,
 80,176, 13,121, 32,184,255,255, 80, 88,  4, 27,  5, 89,176,  5,
 28,176,  3, 37,  8,225, 45, 44, 75, 80, 88, 32,176,224, 69, 68,
 89, 33, 45, 44,176,  2, 37, 69, 96, 68, 45, 44, 75, 83, 88,176,
  2, 37,176,  2, 37, 69, 68, 89, 33, 33, 45, 44, 69, 68, 45,  0,
  0,  2,  0,102,254,150,  4,102,  5,164,  0,  3,  0,  7,  0, 26,
 64, 12,  4,222,  0,  6,222,  1,  8,  5, 81,  2,  4,  0, 47,196,
212,236, 49,  0, 16,212,236,212,236, 48, 19, 17, 33, 17, 37, 33,
 17, 33,102,  4,  0,252,115,  3, 27,252,229,254,150,  7, 14,248,
242,114,  6, 41,  0,  2,  0,141,  0,  0,  3, 25,  5,213,  0,  5,
  0,  9,  0, 89, 64, 46,  4,  3,  2,  5,  2,  5,  5,  0,  5,  1,
  5,  0,  0,  5,  8,  5,  9,  6,  9,  7,  5,  6,  9, 58,  3, 85,
  6, 84,  0, 83,  8,  4,  6,  5,  8,  7,  3,  3,  1,  5,  0,  2,
  6,  0,  9, 10, 16,212,228,244,196,192, 23, 57, 17, 18, 57, 49,
  0, 47,228,252,236, 48, 75, 83, 88,  7,  5,237,  7, 16,  5,237,
  7, 16,  5,237,  7, 16,  5,237, 17, 23, 57, 89, 34,  1, 33,  3,
  3, 33, 19,  3, 33,  3, 33,  1,176,  1,105,113,131,254,254, 28,
108,  1,104, 69,254,151,  5,213,253,195,254, 94,  1,162,253,204,
254,156,  0,  2,  0,195,  3,170,  3,104,  5,213,  0,  3,  0,  7,
  0, 30, 64, 15,  5,  1, 86,  4,  0, 83,  8,  0,  7,  2,  4,  7,
  6,  6,  8, 16,252,252,220,236, 49,  0, 16,244, 60,236, 50, 48,
  1, 17, 35, 17, 35, 17, 35, 17,  3,104,237,203,237,  5,213,253,
213,  2, 43,253,213,  2, 43,  0,  0,  2,  0,133,  0,  0,  6, 61,
  5,190,  0,  3,  0, 31,  0, 80, 64, 54, 29,  9,  5, 90, 27, 11,
  0, 23, 19, 15, 90, 25, 13,  2,  7,  4, 87, 21, 17, 31, 30, 29,
 28, 27, 26, 25, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12,
 11,  9,  8,  7,  6,  5,  4,  3,  2,  1,  0, 30, 10, 24,  8, 32,
 16,244,204, 23, 57, 49,  0, 47, 60,228, 50,212, 60, 60,236, 50,
 50,212, 60, 60,236, 50, 50, 48,  1, 33,  3, 33,  3,  3, 33, 19,
 51,  3, 33,  7, 33,  3, 33,  7, 33,  3, 35, 19, 33,  3, 35, 19,
 33, 55, 33, 19, 33, 55, 33, 19,  4,  0,254,248, 70,  1,  8, 43,
 96,  1,  8, 97,221, 97,  1, 41, 53,254,215, 69,  1, 41, 54,254,
217, 96,221, 96,254,248, 96,223, 96,254,227, 53,  1, 25, 70,254,
229, 53,  1, 29, 96,  3,104,254,238,  3,104,254,127,  1,129,254,
127,213,254,238,215,254,129,  1,127,254,129,  1,127,215,  1, 18,
213,  1,129,  0,  0,  3,  0, 55,254,211,  5, 10,  6, 20,  0, 33,
  0, 40,  0, 47,  0,118, 64, 67, 35, 26, 23, 16, 22, 19, 10, 27,
 34, 41,  4, 23,  5, 94,  6, 93,  9, 22, 94, 23, 93, 26, 91, 17,
 19, 42,  9, 91,  0, 33,  2, 42, 41, 35, 34,  0, 17,  6, 38, 18,
 45, 30,  1, 13,  9, 10, 16, 33, 26, 27,  6, 38, 19, 45, 30,  2,
 38, 13, 23, 22, 45, 10, 30, 38, 10, 13, 48, 16,212,236,212,236,
192,192, 17, 18, 57, 17, 18, 57, 17, 23, 57, 18, 57, 17, 18, 57,
 17, 23, 57, 49,  0, 47, 60,196,236, 50,212,196,252,244,236, 16,
245,238, 18, 23, 57, 17, 18, 57, 17, 18, 57, 48,  1, 35, 19, 38,
 38, 39, 19, 22, 22, 23, 19, 38, 38, 53, 52, 36, 55, 55, 51,  7,
 22, 22, 23,  7, 38, 38, 39,  3, 22, 22, 21, 20,  4,  5, 19, 19,
  6,  6, 21, 20, 22, 19,  3, 54, 54, 53, 52, 38,  2, 84,162, 59,
127,218, 93, 49, 96,217,120, 61,210,191,  1, 43,255, 44,161, 43,
101,188, 88, 49, 63,191,119, 57,213,205,254,211,254,238,  1, 51,
 84,100, 65,167, 55, 99,107, 73,254,211,  1, 45,  5, 43, 38,  1,
  6, 55, 61,  4,  1, 55, 31,161,143,199,245,  9,229,227,  6, 34,
 27,254, 37, 47,  7,254,224, 36,162,134,220,250,  9,  3, 68,  1,
  6,  8, 81, 61, 48, 55,254,179,254,227,  5, 86, 75, 51, 57,  0,
  0,  5,  0,113,255,227,  7,147,  5,240,  0, 11,  0, 23,  0, 27,
  0, 39,  0, 51,  0, 77, 64, 43,  0,101, 12, 46,101, 34, 97, 40,
101, 26,  6,101, 12, 97, 24, 18, 96, 28, 26,100, 52, 25, 43, 37,
 27, 15,  9,  3, 11, 21, 12,  9, 11, 15, 49, 11, 31, 12, 15, 43,
 11, 37, 52, 16,212,236,196,252,236, 16,238,254,238, 17, 18, 57,
 17, 18, 57, 49,  0, 16,228, 50,244, 60,236,236, 16,238,254,238,
 16,238, 48,  1, 34,  6, 21, 20, 22, 51, 50, 54, 53, 52, 38, 39,
 50, 22, 21, 20,  0, 35, 34, 38, 53, 52,  0,  1, 35,  1, 51, 33,
 50, 22, 21, 20,  0, 35, 34, 38, 53, 52,  0, 23, 34,  6, 21, 20,
 22, 51, 50, 54, 53, 52, 38,  6, 29, 86,111, 61, 62, 87,110, 63,
 32,157,189,254,247,214,157,189,  1,  9,252,177,245,  4,211,245,
251,107,156,190,254,245,214,157,189,  1, 11,183, 86,110, 61, 61,
 87,110, 63,  2,104,168,133, 87, 87,168,135, 85, 87,168,171,140,
224,254,234,173,141,222,  1, 21,252,211,  6, 13,172,140,223,254,
234,170,141,222,  1, 24,168,169,132, 88, 89,170,136, 84, 88,  0,
  0,  2,  0, 57,255,227,  6,129,  5,240,  0, 38,  0, 48,  1, 17,
 64, 91,  9, 15, 10, 11, 10,  6,  7,  2,  5,  8, 15, 11, 11, 10,
  3,  2,  2,  4,  1, 15, 48, 39, 48, 37, 38,  2, 36,  0, 15, 39,
 39, 48, 58, 48, 39,  8,  1,  4,  4, 11, 45,  9, 20,  0, 30,  4,
 45,105, 14, 30, 89, 29,102, 33,103, 26,100, 14, 96,  4,  9, 39,
 42, 30,  0,  1,  3, 36,  9,  5,  4, 20, 42,  8, 11, 29, 48,  4,
  4, 36, 14, 23,  4,  4,  5, 42, 14, 23, 17, 13, 49, 16,244,196,
236,212,236, 16,238, 17, 23, 57, 17, 57, 17, 18, 57, 18, 23, 57,
 17, 57, 49,  0, 47,198,228,246,238,246,238, 16,238, 17, 18, 57,
 57, 17, 18, 57, 17, 23, 57, 48, 75, 83, 88,  7, 16, 14,237, 17,
 23, 57,  7, 16, 14,237, 17, 23, 57,  7, 16, 14,237, 17, 23, 57,
  7, 16,  5,237, 89, 34,178,  7,  0,  1,  1, 93, 64, 96,  9, 11,
 26, 11, 42, 11, 57, 11, 75, 11, 75, 39, 91, 11, 92, 39, 98,  1,
109, 11,110, 39, 11,  7,  0, 15,  3, 15,  4, 15, 29, 15, 30, 22,
  0, 27, 10, 28, 11, 22, 38, 25, 48, 39, 10, 39, 11, 43, 39, 43,
 48, 59, 39, 59, 48, 73,  2, 73,  3, 73, 10, 72, 11, 72, 39, 74,
 48, 90,  2, 90,  3, 92, 10, 92, 11, 92, 24, 92, 35, 88, 39,104,
  1,111,  1,110,  2,107,  3,105, 10,105, 11,108, 48, 36, 93,  0,
 93,  9,  1, 62,  1, 55, 33,  6,  2,  7,  1, 33, 39, 14,  1, 35,
 34, 36, 53, 52, 54, 55, 46,  1, 53, 52, 36, 51, 50, 22, 23,  3,
 46,  1, 35, 34,  6, 21, 20, 22,  7, 14,  1, 21, 20, 22, 51, 50,
 54, 55,  3,109,  1, 41, 62, 90, 28,  1, 55, 43,159,120,  1,  0,
254, 74, 84,118,236,123,245,254,214,191,201, 26, 26,  1, 46,239,
 91,191,101, 53, 87,158, 79, 86,100, 60,243, 80, 83,152,114, 60,
118, 59,  3,147,254,138, 63,176,115,175,254,226,112,254,190,106,
 68, 67,246,199,151,253,114, 44, 90, 48,176,228, 29, 29,254,234,
 48, 46, 72, 61, 38,117,247, 51,133, 76,107,147, 42, 42,  0,  1,
  0,195,  3,170,  1,176,  5,213,  0,  3,  0, 21, 64, 10,  1, 86,
  0, 83,  4,  0,  7,  2,  6,  4, 16,252,236, 49,  0, 16,244,236,
 48,  1, 17, 35, 17,  1,176,237,  5,213,253,213,  2, 43,  0,  1,
  0,158,254,242,  3,190,  6, 18,  0, 13,  0, 32, 64, 15,  0,108,
  7,107, 14,  0,  8,  1,  4,  7,  8, 11, 16,  4, 14, 16,212,252,
196, 57, 18, 57, 18, 57, 49,  0, 16,252,236, 48,  1, 33, 38,  2,
 53, 16, 18,  1, 33,  2,  2, 17, 20, 18,  2, 92,254,221, 78, 77,
254,  1,  0,  1, 34,233,229, 54,254,242,166,  1, 63,158,  1, 39,
  2, 77,  1, 41,254,202,253,161,254,207,150,254,213,  0,  0,  1,
255,201,254,242,  2,233,  6, 18,  0, 13,  0, 30, 64, 14,  7,108,
  0,107, 14,  7,  8,  0,  1,  4, 16,  8, 11, 14, 16,212,196,252,
212,196, 17, 57, 49,  0, 16,252,236, 48,  1, 33, 22, 18, 21, 16,
  2,  3, 33, 18, 18, 17, 52,  2,  1, 43,  1, 37, 77, 76,253,254,
254,219,233,230, 54,  6, 18,164,254,193,160,254,214,253,179,254,
218,  1, 54,  2, 96,  1, 50,150,  1, 41,  0,  1,  0, 41,  2, 57,
  4,  6,  5,240,  0, 17,  0, 70, 64, 40, 16, 13, 11, 10,  9,  7,
  4,  2,  1,  0, 10, 12,  8,  3,  5,109, 17, 12, 14,100, 18,  8,
 12, 10,  3,  9,  6, 17,  3,  1,  3,  2,  0, 15,  4, 11,  9, 13,
  6, 18, 16,212, 60,196, 50,220, 60,196, 50, 23, 57, 17, 18, 23,
 57, 49,  0, 16,244,196, 50,244,196, 50, 17, 23, 57, 48,  1,  5,
  5,  7, 37, 17, 35, 17,  5, 39, 37, 37, 55,  5, 17, 51, 17, 37,
  4,  6,254,182,  1, 74, 76,254,179,170,254,178, 76,  1, 78,254,
178, 76,  1, 78,170,  1, 77,  4,193,173,174,141,184,254,168,  1,
 88,184,141,174,173,141,182,  1, 88,254,168,182,  0,  1,  0,217,
  0,  0,  5,219,  5,  4,  0, 11,  0, 34, 64, 16,  0,  7,  3,111,
  9,  1,110,  5,  8,  4,  0, 17,  2, 10,  6, 12, 16,212, 60,196,
252, 60,196, 49,  0, 47,244, 60,252, 60,196, 48,  1, 17, 33, 21,
 33, 17, 35, 17, 33, 53, 33, 17,  3,209,  2, 10,253,246,238,253,
246,  2, 10,  5,  4,253,244,236,253,244,  2, 12,236,  2, 12,  0,
  0,  1,255,186,254,221,  2, 12,  1,131,  0,  5,  0, 53, 64, 25,
  4,  3,  2,  5,  2,  5,  5,  0,  5,  1,  5,  0,  5, 58,  3,112,
  0, 84,  6,  1,  5,  0,  4,  0,  6, 16,212,196,228,192, 49,  0,
 16,252,236, 48, 75, 83, 88,  7,  5,237,  7, 16,  5,237, 17, 23,
 57, 89, 34, 19, 33,  3,  1, 35, 19,164,  1,104, 59,254,190,213,
174,  1,131,254,207,254,139,  1,117,  0,  0,  1,  0, 51,  1,188,
  2,225,  2,223,  0,  3,  0, 23, 64, 10,  2,114,  0,113,  4,  2,
  0,  1,  3,  4, 16,212,204, 57, 57, 49,  0, 16,244,236, 48, 19,
 33,  3, 33,109,  2,116, 57,253,139,  2,223,254,221,  0,  0,  1,
  0, 94,  0,  0,  2, 18,  1,131,  0,  3,  0, 47, 64, 21,  2,  5,
  3,  0,  3,  1,  5,  0,  0,  3, 58,  0, 84,  2,  2,  1,  0,  0,
  0,  3,  4, 16,212,228, 16,192, 57, 49,  0, 47,236, 48, 75, 83,
 88,  7, 16,  5,237,  7, 16,  5,237, 89, 34, 19, 33,  3, 33,170,
  1,104, 75,254,151,  1,131,254,125,  0,  0,  1,255, 59,255, 66,
  3,121,  5,213,  0,  3,  0, 46, 64, 19,  2,  3,  0,  3,  1,  0,
  3, 58,  2,  0, 83,  4,  2,  4,  1,  0,  0,  3,  4, 16,212,196,
 16,192, 18, 57, 49,  0, 16,244,196, 48, 75, 83, 88,  7,  5,201,
  7, 16,  5,201, 89, 34,  1, 51,  1, 35,  2,145,232,252,170,232,
  5,213,249,109,  0,  2,  0, 74,255,227,  5, 72,  5,240,  0, 23,
  0, 41,  0, 34, 64, 18,  0,115, 30, 12,115, 39,100, 30, 96, 42,
  9, 19, 24, 21, 21, 19, 33, 42, 16,220,236,244,236, 49,  0, 16,
228,244,236, 16,238, 48, 37, 50, 54, 55, 54, 54, 55, 54, 54, 53,
 52, 38, 35, 34,  6,  7,  6,  6,  7,  6,  6, 21, 20, 22,  1, 20,
  2,  7,  6,  4, 35, 34,  0, 17, 52, 18, 55, 54, 36, 51, 50,  0,
  2,100, 77,119, 40, 28, 46, 20, 17, 18, 80, 84, 78,118, 39, 30,
 49, 18, 17, 18, 82,  3, 56,110, 99,101,254,226,176,245,254,251,
109, 98,103,  1, 28,178,243,  1,  7,233, 92, 89, 63,161,110, 89,
150, 53,112,105, 89, 91, 65,166, 98, 90,154, 53,111,107,  2,238,
199,254,136,142,146,149,  1, 22,  1,  5,196,  1,121,140,147,150,
254,233,  0,  1,  0, 88,  0,  0,  4,160,  5,213,  0, 10,  0,116,
 64, 45, 10,  9,  8,  3,  0,  7, 18,  1,  2,  1,  6, 18,  2,  2,
  1, 58,  3,117,  4,  2,117,  5, 83,  7,  0,117,  9,  9,  7,  6,
  3,  8,  2,  4,  3,  0,  3, 10,  1,  8,  2,  2,  1, 10, 11, 16,
212,212,196, 16,192, 17, 18, 23, 57, 17, 18, 23, 57, 49,  0, 47,
236, 50,244,236,212,236, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,
  5,237, 17, 23, 57, 89, 34,  1, 75,176, 10, 84, 75,176, 11, 84,
 91, 88,189,  0, 11,255,192,  0,  1,  0, 11,  0, 11,  0, 64, 56,
 17, 55, 56, 89, 19, 33, 19,  5, 19, 37, 33,  3, 33,  3, 33,141,
  1, 84,187,254,149, 51,  1,105,  1,110,237,  1, 82, 51,251,235,
  1, 10,  3,197, 72,  1,  6, 72,251, 53,254,246,  0,  1,  0, 16,
  0,  0,  5, 31,  5,240,  0, 24,  0,124, 64, 41,  0,  4,  5,  4,
 22, 23,  2, 21, 24,  5,  5,  4, 58,  5, 24,  0, 14, 88, 15, 11,
115, 18,100,  0,118,  2,  2,  1, 21, 14,  5,  0,  3, 15, 24,  3,
  8, 18, 21,  3, 25, 16,212,212,236, 17, 57, 57, 23, 57, 17, 57,
 57, 49,  0, 47,236,244,236,212,236, 17, 57, 57, 48, 75, 83, 88,
  7, 16,  5,201, 17, 23, 57,  7, 16,  5,201, 89, 34,  1, 75,176,
 10, 84, 75,176, 11, 84, 91, 75,176, 13, 84, 91, 88,189,  0, 25,
255,192,  0,  1,  0, 25,  0, 25,  0, 64, 56, 17, 55, 56, 89,180,
  5,  5,  5,  6,  2, 93,  1, 33,  3, 33, 19,  1, 62,  1, 53, 52,
 38, 35, 34,  6,  7, 19, 54, 36, 51, 50,  4, 21, 20,  6,  5,  1,
250,  2,137, 55,251,196, 56,  2,123,104,109,112,101, 95,234,147,
 64,136,  1,  6,128,228,  1,  6,160,254,240,  1, 27,254,229,  1,
 29,  1,223, 80,164, 77, 82, 90, 75, 78,  1, 61, 50, 49,197,170,
146,240,204,  0,  0,  1,  0,  0,255,227,  5, 25,  5,240,  0, 40,
  0,105, 64, 44,  0, 21,115, 19,  9, 94, 10,120, 13,115,  6, 32,
 94, 31,120, 28,115, 19,119, 35,100,  6, 96, 41, 21, 20, 19, 10,
  4, 22, 31, 32,  3, 16,  9,  0, 25, 16, 19,  3, 25, 19, 38,  9,
 47,212,236,212,236, 18, 57, 17, 18, 23, 57, 23, 57, 49,  0, 16,
228,244,228,252,244,236, 16,254,245,238, 16,238, 57, 48,  1, 75,
176, 11, 84, 75,176, 13, 84, 91, 88,189,  0, 41,255,192,  0,  1,
  0, 41,  0, 41,  0, 64, 56, 17, 55, 56, 89,  1, 30,  1, 21, 20,
  0, 33, 34, 38, 39, 19, 30,  1, 51, 50, 54, 53, 52, 38, 43,  1,
 55, 51, 50, 54, 53, 52, 38, 35, 34,  6,  7, 19, 62,  1, 51, 50,
 22, 21, 20,  6,  3,199,113,126,254,119,254,168,130,235,104, 57,
 89,210,105,169,197,150,151,153, 49,162,157,183,127,121, 85,200,
108, 55,118,229,112,253,255,177,  3, 37, 26,158,115,248,254,225,
 37, 37,  1, 41, 52, 57,127,107, 89, 89,248,114, 97, 76, 80, 44,
 42,  1, 26, 32, 32,168,166,149,199,  0,  0,  2,255,254,  0,  0,
  5, 20,  5,213,  0,  2,  0, 13,  0,161, 64, 59,  1, 13,  3, 13,
  0,  2,  0,  3,  3, 13,  0,  5,  1,  0,  4,  9,  4,  2,  5,  9,
  4, 11,  5,  9,  4, 10,  5,  9,  9,  4, 58,  0,  3, 11,  7,117,
  5,  1,  3, 83,  9, 11, 10,  2,  1,  0,  5, 14,  8,  7,  5,  3,
  9,  6,  9,  2,  4, 12, 14, 16,212,212,228,192, 18, 23, 57, 17,
 23, 57, 49,  0, 47,228,212, 60,236, 50, 18, 57, 48, 75, 83, 88,
  7, 16,  5,237,  7,  5,237,  7,  5,237,  7, 16,  8,237,  7, 16,
  8,201,  7, 16,  5,201, 89, 34,  1, 75,176, 10, 84, 75,176, 11,
 84, 91, 75,176, 12, 84, 91, 75,176, 13, 84, 91, 88,189,  0, 14,
255,192,  0,  1,  0, 14,  0, 14,  0, 64, 56, 17, 55, 56, 89,183,
 31,  0, 75,  0,  2, 30,  0,  1, 93,  0, 93,  9,  1, 33, 19, 33,
  3, 51,  3, 35,  3, 33, 19, 33, 19,  3, 76,253,237,  1,154,111,
  1,182,185,213, 53,213, 53,254,147, 54,253, 96, 65,  4,141,253,
154,  3,174,252, 82,254,233,254,240,  1, 16,  1, 74,  0,  0,  1,
  0, 27,255,227,  5, 39,  5,213,  0, 29,  0,146, 64, 57,  6,  5,
  2,  4,  4, 29,  0, 29,  3,  4,  0,  0, 29, 58,  4, 26,  7, 16,
 94, 17, 93, 20, 29, 93, 26,115,  7,121, 20,115, 13,  2,118,  0,
 83, 13, 96, 30, 29, 17,  3,  0,  4, 23, 16,  2, 10,  1,  4, 23,
 16,  1, 23, 19, 10, 16, 30, 16,212,212,236,192, 17, 18, 57, 17,
 18, 57, 17, 18, 23, 57, 49,  0, 16,228,244,236, 16,238,246,254,
228, 16,245,238, 17, 18, 57, 48, 75, 83, 88,  7, 16,  5,237,  7,
 16,  5,237, 23, 57, 89, 34,  1, 75,176,  9, 84, 75,176, 11, 84,
 91, 75,176, 12, 84, 91, 75,176, 13, 84, 91, 88,189,  0, 30,255,
192,  0,  1,  0, 30,  0, 30,  0, 64, 56, 17, 55, 56, 89,  1, 33,
  3, 33,  7, 62,  1, 51, 50,  4, 21, 16,  0, 33, 34, 38, 39, 19,
 30,  1, 51, 50, 54, 53, 52, 38, 35, 34,  6,  7,  1,106,  3,189,
 55,253,118, 45, 44, 95, 48,229,  1,  2,254,114,254,171,125,236,
116, 59,111,209,108,158,190,144,124, 84,195,116,  5,213,254,229,
231, 12, 13,209,185,254,218,254,167, 49, 50,  1, 47, 72, 68,165,
134, 96,113, 43, 45,  0,  0,  2,  0,102,255,225,  5, 72,  5,238,
  0, 11,  0, 39,  0,114, 64, 33, 19, 22,  0, 12, 94, 13, 93, 16,
  0,115, 22,  6,115, 28, 16,115, 37,100, 28, 96, 40, 19,  9,  3,
 13, 12,  9, 19, 25,  3, 19, 31, 40, 16,212,236,212,236,192,192,
 17, 18, 57, 49,  0, 16,228,244,236, 16,238,214,238, 16,245,238,
 17, 18, 57, 48,  1, 75,176,  9, 84, 88,189,  0, 40,255,192,  0,
  1,  0, 40,  0, 40,  0, 64, 56, 17, 55, 56, 89, 64, 25, 96,  0,
 96,  7, 96,  8, 96,  9, 96, 10, 96, 11, 96, 22, 96, 23, 96, 24,
 96, 25, 96, 26, 96, 27, 12, 93,  1, 34,  6, 21, 20, 22, 51, 50,
 54, 53, 52, 38,  1,  3, 46,  1, 35, 34,  6,  7, 62,  1, 51, 50,
 22, 21, 16,  0, 33, 34,  0, 17, 52, 18, 55, 54, 36, 51, 50, 22,
  2,229,114,146, 90, 80,113,147, 88,  2, 17, 54, 86,162, 81,186,
230, 25, 78,165, 93,184,234,254,151,254,228,255,254,232,124,112,
120,  1, 71,204, 94,178,  2,225,188,148, 89, 99,185,141, 96,102,
  2,205,254,236, 44, 44,200,181, 51, 49,218,169,254,236,254,159,
  1, 33,  1,  8,204,  1,115,134,143,144, 32,  0,  0,  1,  0,160,
  0,  0,  5,141,  5,213,  0,  6,  0, 51, 64, 23,  3,  4,  4,  5,
  4,  5,  4,  2,  3,  2, 58,  5,118,  0, 83,  3,  5,  0,  1,  6,
  1,  4,  7, 16,212,204,196, 17, 57, 57, 49,  0, 47,244,236, 48,
 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237, 89, 34,  1, 33,  7,
  1, 33,  1, 33,  1, 39,  4,102, 45,252,193,254,127,  3, 22,253,
 60,  5,213,219,251,  6,  4,186,  0,  3,  0, 45,255,227,  5, 70,
  5,240,  0, 11,  0, 35,  0, 47,  0,116, 64, 36, 24, 12, 42,115,
  0,  6,115, 30,  0,119, 36,115, 18,100, 30, 96, 48, 24, 45, 27,
 12,  3, 39, 19, 15,  9, 18, 27, 45, 19, 21,  3, 19, 15, 33, 48,
 16,212,196,236,212,236,212,236, 16,238, 17, 57, 17, 18, 57, 49,
  0, 16,228,244,236,228, 16,238, 16,238, 57, 57, 48,  1, 75,176,
 10, 84, 75,176, 11, 84, 91, 75,176, 13, 84, 91, 75,176, 16, 84,
 91, 75,176, 18, 84, 91, 75,176, 19, 84, 91, 88,189,  0, 48,255,
192,  0,  1,  0, 48,  0, 48,  0, 64, 56, 17, 55, 56, 89,  1, 34,
  6, 21, 20, 22, 51, 50, 54, 53, 52, 38, 37, 46,  1, 53, 52, 36,
 33, 50,  4, 21, 20,  6,  7, 30,  1, 21, 20,  0, 33, 34, 36, 53,
 52, 54,  1, 34,  6, 21, 20, 22, 51, 50, 54, 53, 52, 38,  2,176,
117,157,102, 88,119,156,103,254,178,108,107,  1, 77,  1, 38,236,
  1,  4,181,168,122,116,254,153,254,199,247,254,237,211,  2, 51,
102,123, 89, 73,102,123, 89,  2,156,159,116, 83, 97,157,117, 83,
 98,127, 45,144,101,203,232,176,160,142,202, 45, 47,158,121,230,
254,244,197,176,159,239,  2, 24,119, 98, 68, 84,119, 98, 69, 83,
  0,  2,  0, 84,255,225,  5, 55,  5,238,  0, 27,  0, 39,  0,128,
 64, 31,  7, 28, 10,  0, 94,  1, 93,  4, 28,115, 10,  4,115, 25,
 10, 34,115, 16,100, 25, 96, 40,  7, 37, 31, 19, 19, 37, 19, 13,
 40, 16,212,236,212,236, 17, 57, 49,  0, 16,228,244,236,196, 16,
238, 16,238, 16,245,238, 17, 18, 57, 48,  1, 75,176, 11, 84, 88,
189,  0, 40,255,192,  0,  1,  0, 40,  0, 40,  0, 64, 56, 17, 55,
 56, 89,  1, 75,176, 15, 84, 88,189,  0, 40,  0, 64,  0,  1,  0,
 40,  0, 40,255,192, 56, 17, 55, 56, 89, 64, 19,111, 11,111, 12,
111, 13,111, 14,111, 15,111, 36,111, 37,111, 38,111, 39,  9, 93,
 55, 19, 30,  1, 51, 50, 54, 55, 14,  1, 35, 34, 38, 53, 16,  0,
 33, 50,  0, 17, 20,  2,  7,  6,  4, 35, 34, 38,  1, 50, 54, 53,
 52, 38, 35, 34,  6, 21, 20, 22, 84, 53, 87,162, 81,186,230, 24,
 77,164, 93,183,234,  1,105,  1, 28,255,  1, 23,124,113,120,254,
187,204, 95,180,  2,  8,114,146, 87, 81,113,149, 88, 33,  1, 20,
 45, 43,200,181, 51, 49,218,169,  1, 20,  1, 97,254,223,254,248,
203,254,141,135,143,144, 32,  2,237,188,147, 91, 98,186,140, 96,
102,  0,  0,  2,  0, 84,  0,  0,  2,150,  4, 96,  0,  3,  0,  7,
  0, 78, 64, 40,  2,  5,  3,  0,  3,  1,  5,  0,  0,  3,  6,  5,
  7,  4,  7,  5,  5,  4,  4,  7, 58,  2, 84,  0,122,  4, 84,  6,
  6,  5,  2,  3,  1,  3,  0,  0,  4,  0,  7,  8, 16,212,228,212,
228,192, 23, 57, 49,  0, 47,236,244,236, 48, 75, 83, 88,  7, 16,
  5,237,  7, 16,  5,237,  7, 16,  5,237,  7, 16,  5,237, 89, 34,
  1, 33,  3, 33,  3, 33,  3, 33,  1, 45,  1,105, 74,254,151, 67,
  1,104, 76,254,152,  4, 96,254,125,254,166,254,125,  0,  0,  2,
255,184,254,221,  2,150,  4, 96,  0,  5,  0,  9,  0, 90, 64, 46,
  8,  5,  9,  6,  9,  7,  5,  6,  6,  9,  4,  3,  2,  5,  2,  5,
  5,  0,  5,  1,  5,  0,  0,  5, 58,  8, 84,  6,  3,112,  0, 84,
  6,122, 10,  8,  1,  7,  9,  0,  6,  4,  5,  0,  0, 10, 16,212,
228,196,212,228,192, 57, 57, 49,  0, 16,228,252,236, 16,238, 48,
 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237, 17, 23, 57,  7, 16,
  5,237,  7, 16,  5,237, 89, 34, 19, 33,  3,  1, 35, 19, 19, 33,
  3, 33,160,  1,104, 59,254,192,213,172,201,  1,105, 74,254,151,
  1,131,254,207,254,139,  1,117,  4, 14,254,125,  0,  1,  0,217,
  0, 61,  5,219,  4,199,  0,  6,  0, 31, 64, 16,  5,  4,  2,  1,
  0,  5,  3,124,  6,123,  7,  1,  2,  0,  4,  7, 16,212,196, 50,
 57, 49,  0, 16,244,236, 23, 57, 48,  9,  2, 21,  1, 53,  1,  5,
219,252, 60,  3,196,250,254,  5,  2,  3,205,254,180,254,182,250,
  1,207,236,  1,207,  0,  0,  2,  0,217,  1, 39,  5,219,  3,219,
  0,  3,  0,  7,  0, 28, 64, 13,  0,111,  2,125,  6,111,  4,  8,
  5,  1,  4,  0,  8, 16,212, 60,196, 50, 49,  0, 16,212,236,252,
236, 48, 19, 33, 21, 33, 21, 33, 21, 33,217,  5,  2,250,254,  5,
  2,250,254,  3,219,235,220,237,  0,  1,  0,217,  0, 61,  5,219,
  4,199,  0,  6,  0, 31, 64, 16,  6,  5,  3,  2,  0,  5,  4,124,
  1,123,  7,  6,  2,  4,  0,  7, 16,212, 60,196, 57, 49,  0, 16,
244,236, 23, 57, 48, 19, 53,  1, 21,  1, 53,  1,217,  5,  2,250,
254,  3,197,  3,205,250,254, 49,236,254, 49,250,  1, 74,  0,  2,
  0,213,  0,  0,  4,111,  5,240,  0,  3,  0, 33,  0,128, 64, 73,
  2,  5,  3,  0,  3,  1,  5,  0,  0,  3,  4,  5,  6,  5, 27, 28,
 29, 30, 31, 32,  6, 26, 33,  5,  6,  6,  5, 58, 33, 30,  9,  6,
  4, 10, 29,  4, 20, 89, 19, 93, 16,105, 23,  4, 85,  0, 84, 23,
100,  2, 29, 26, 19, 10,  9,  6,  5,  4,  2,  1,  0,  9,  3, 30,
 26, 20, 33,  3, 13, 14, 26,  3, 34, 16,196,212,236, 17, 57, 57,
 17, 57, 17, 23, 57, 17, 57, 49,  0, 47,228,252,236, 16,254,244,
238, 18, 57, 57, 23, 57, 48, 75, 83, 88,  7, 16,  5,237, 17, 23,
 57,  7,  5,237,  7, 16,  5,237,  7, 16,  5,237, 89, 34,  1, 33,
  3, 33,  1, 33, 55, 54, 54, 55, 55, 54, 54, 53, 52, 38, 35, 34,
  6,  7, 19, 54, 54, 51, 50, 22, 21, 20,  6,  7,  7,  6,  6,  7,
  1, 27,  1,104, 70,254,152,  1,203,254,151,  8, 16, 87,131, 74,
 79, 72, 81, 76, 80,201,115, 62,127,210, 97,194,220,106,128, 76,
 80, 57,  8,  1,100,254,156,  1,248, 49, 80,125,102, 58, 61,106,
 54, 57, 61, 67, 66,  1, 58, 42, 40,171,149,119,188,102, 60, 62,
 77, 43,  0,  2,  0, 92,254,160,  7,106,  5,160,  0, 11,  0, 76,
  0, 93, 64, 53, 73, 77, 45, 46, 42, 15, 24,  0,127, 25, 21, 27,
  6,127, 12, 76, 70, 15,126, 42,127, 49, 21,126, 33,127, 61, 87,
 77, 27, 26, 25,  9,  4, 24, 45, 46, 76, 12,  5, 30,  3, 24, 18,
 30, 23, 67, 39, 23, 18, 22, 55, 77, 16,212,236,236,220,236, 16,
238, 17, 23, 57, 23, 57, 49,  0, 16,244,236,236,212,236,252, 60,
 60,196,236, 50, 16,196,238,196, 17, 18, 57, 57, 18, 57, 48,  1,
 34,  6, 21, 20, 22, 51, 50, 54, 53, 52, 38, 19,  6,  6, 35, 34,
 38, 53, 52,  0, 51, 50, 22, 23, 55, 51,  3, 54, 18, 53, 52,  0,
 33, 34,  4,  7,  6,  2, 21, 16,  0, 33, 50, 54, 55, 23,  6,  4,
 35, 34, 38, 39, 38,  2, 53, 52, 18, 55, 54, 36, 51, 50,  4, 23,
 22, 22, 21, 16,  0, 33, 34,  6, 35, 34, 38, 39,  4, 10,106,152,
 81, 77,106,148, 80, 39, 45,150, 90,143,164,  1, 28,197, 83,125,
 20, 24,203,133,151,203,254,183,254,249,196,254,175,118, 92, 96,
  1, 75,  1,  4,118,231,104,109,146,254,226,142,135,250, 98,140,
145,120,114,146,  1,155,237,166,  1, 26,111,105,114,254,103,254,
180,  5, 18,  4,  5,  7,  2,  3, 33,210,145, 84, 88,201,146, 86,
 94,253,213, 75, 83,189,167,221,  1, 66, 84, 69,133,253, 75, 22,
  1, 27,191,213,  1, 14,152,143,110,254,248,142,254,243,254,171,
 87, 83,158, 98, 98, 82, 77,108,  1, 62,201,176,  1, 72,137,176,
189, 93, 92, 89,239,130,254,197,254,118,  2,  1,  1,  0,  0,  2,
255,123,  0,  0,  5,135,  5,213,  0,  7,  0, 10,  0,158, 64, 65,
 10, 18,  8, 10,  5,  6,  5,  9, 18,  6,  5,  0, 18,  6,  5,  7,
 18,  6,  6,  5,  8, 15,  3,  4,  3, 10, 15,  9, 10,  4,  4,  3,
  2, 15,  4,  3,  1, 15,  3,  4,  3, 58, 10,  4,  0,117,  8,  4,
 83,  6,  2, 10,  9,  8,  7,  5,  4,  2,  1,  0,  9, 11,  6,  3,
 11, 16,212,204, 17, 23, 57, 49,  0, 47, 60,228,212,236, 18, 57,
 48, 75, 83, 88,  7, 16,  5,237,  7,  5,237,  7, 16,  8,237,  7,
 16,  5,237,  7, 16,  5,237,  7,  5,237,  7,  5,237,  7, 16,  8,
237, 89, 34,178, 16,  8,  1,  1, 93, 64, 30, 14, 10, 31, 10, 43,
 10, 47, 10, 63, 10,143, 10,191, 10,191, 10,  8,  5,  8,  8, 10,
 31,  9, 43,  9, 41, 10,134,  8,  6, 93,  0, 93,  1, 33,  3, 33,
  1, 33,  1, 33,  1, 33,  3,  3,238,253,172,148,254,117,  3, 76,
  1,184,  1,  8,254,146,254, 18,  1,145, 90,  1, 16,254,240,  5,
213,250, 43,  2, 31,  2, 63,  0,  0,  3,  0, 43,  0,  0,  5,152,
  5,213,  0,  8,  0, 17,  0, 32,  0,104, 64, 58, 17, 18, 26, 25,
 16, 18, 25, 26, 25,  8, 18, 26, 25,  7, 18, 26, 26, 25, 58, 18,
  0,128, 15,133,  6,128, 26, 83,  9,128, 24, 17, 16, 15,  9,  8,
  7,  6,  6,  0, 24, 27,  4, 26, 12, 18,  3, 12, 26, 21,  3, 26,
 30, 26,  2, 25, 25, 33, 16,244,228,212,236,212,236, 18, 57, 17,
 18, 23, 57, 23, 57, 49,  0, 47,236,244,236,244,236, 57, 48, 75,
 83, 88,  7, 16,  5,237,  7,  5,237,  7, 16,  5,237,  7,  5,237,
 89, 34,  1, 50, 54, 53, 52, 38, 35, 35,  3, 19, 50, 54, 53, 52,
 38, 35, 35,  3,  1, 22, 22, 21, 20,  0, 33, 33,  1, 33, 32, 22,
 21, 20,  6,  3, 51,103,116, 81, 76,215, 62,101,132,142, 98,101,
227, 76,  2,172, 98,107,254,153,254,187,253,129,  1, 35,  2, 65,
  1, 10,255,150,  3,147,104, 91, 59, 62,254,196,253,115,126,118,
 75, 72,254,121,  2, 25, 28,149,110,241,254,241,  5,213,156,163,
137,207,  0,  1,  0, 74,255,227,  5,203,  5,240,  0, 28,  0, 74,
 64, 28, 15, 19, 12,  0,  3, 28, 25,117,  3, 16, 19,117, 12,100,
  3, 96, 29, 28, 16, 15,  0, 15, 22, 22, 27,  6, 13, 29, 16,244,
236, 16,192,192, 18, 57, 57, 49,  0, 16,228,244,252,196, 16,254,
196, 18, 57, 17, 18, 57, 48, 64, 14, 12, 16, 12, 17,  2,  6, 16,
  6, 17, 41, 27, 41, 28,  4, 93,  1, 93, 37, 14,  1, 35, 32,  0,
 17, 52, 18, 55, 54, 36, 51, 50, 22, 23,  3, 46,  1, 35, 34,  0,
 17, 20, 22, 51, 50, 54, 55,  4,217,138,254,114,254,211,254,152,
114,111,131,  1,113,213,116,234,121, 62, 96,194,111,231,254,200,
192,169,101,227,141, 70, 49, 50,  1, 74,  1, 16,179,  1, 61,131,
154,166, 55, 56,254,203, 73, 68,254,156,254,245,172,196, 73, 78,
  0,  2,  0, 43,  0,  0,  6, 74,  5,213,  0,  8,  0, 23,  0, 64,
 64, 33,  1, 18, 23,  9, 23,  0, 18,  9, 23, 58,  0,135,  9, 83,
  1,135, 22,  8,  2,  1,  0,  4, 10, 22,  9,  5, 27, 16,  9,  2,
 23, 25, 24, 16,244,228,212,236, 17, 57, 57, 23, 57, 49,  0, 47,
236,244,236, 48, 75, 83, 88,  7,  5,237,  7, 16,  5,237, 89, 34,
  1,  3, 51, 32,  0, 17, 52, 38, 35,  1, 33, 32,  4, 23, 22, 22,
 21, 20,  2,  7,  6,  4, 33, 33,  2,152,179,138,  1, 13,  1, 58,
205,202,254, 47,  1,149,  1, 34,  1, 34, 96, 97, 98,167,151,132,
254,163,254,150,254,106,  4,178,252,113,  1, 46,  1,  1,174,178,
  1, 35, 69, 81, 81,231,146,203,254,153,122,109, 92,  0,  0,  1,
  0, 43,  0,  0,  5, 92,  5,213,  0, 11,  0, 84, 64, 47,  8, 18,
  0, 11,  7, 18, 11,  0, 11,  4, 18,  0, 11,  3, 18,  0,  0, 11,
 58,  4,135,  6,133,  2,135,  0, 83,  8,135, 10, 10,  9,  8,  7,
  6,  5,  4,  3,  2,  9,  1,  0,  0,  2, 11, 25, 12, 16,244,228,
 16,192, 23, 57, 49,  0, 47,236,244,236,244,236, 48, 75, 83, 88,
  7, 16,  5,237,  7,  5,237,  7, 16,  5,237,  7,  5,237, 89, 34,
  1, 33,  3, 33,  3, 33,  3, 33,  3, 33,  3, 33,  1, 78,  4, 14,
 57,253,115, 54,  2,103, 58,253,154, 66,  2,162, 55,251,219,  5,
213,254,221,254,234,254,221,254,170,254,221,  0,  0,  1,  0, 43,
  0,  0,  5, 92,  5,213,  0,  9,  0, 79, 64, 43,  8, 18,  0,  9,
  7, 18,  9,  0,  9,  4, 18,  0,  9,  3, 18,  0,  0,  9, 58,  4,
135,  6,133,  2,135,  0, 83,  8,  8,  7,  6,  5,  4,  3,  2,  7,
  1,  0,  0,  2,  9, 25, 10, 16,244,228, 16,192, 23, 57, 49,  0,
 47,244,236,244,236, 48, 75, 83, 88,  7, 16,  5,237,  7,  5,237,
  7, 16,  5,237,  7,  5,237, 89, 34,  1, 33,  3, 33,  3, 33,  3,
 33,  3, 33,  1, 78,  4, 14, 57,253,115, 54,  2,103, 58,253,154,
123,254,127,  5,213,254,221,254,234,254,221,253,135,  0,  0,  1,
  0, 74,255,227,  6, 57,  5,240,  0, 32,  0,104, 64, 54, 29, 18,
 32,  0, 32, 26, 27,  2, 28, 18,  0,  0, 32, 58, 28, 29, 25, 16,
 31, 15, 19, 12,  0, 25,  3, 29,128, 31, 25,117,  3, 19,117, 12,
100,  3, 96, 31, 33, 31, 30, 29, 28,  4,  0, 22, 32, 16, 15, 22,
 27,  6, 13, 33, 16,244,236,212,196, 50, 17, 57, 23, 57, 49,  0,
 16,196,228,244,236, 16,238, 16,238, 17, 18, 57, 17, 18, 57, 17,
 57, 17, 18, 57, 48, 75, 83, 88,  7, 16,  5,237, 23, 57,  7, 16,
  5,237, 89, 34, 37,  6,  4, 35, 32,  0, 17, 52, 18, 55, 54, 36,
 51, 50,  4, 23,  3, 38, 38, 35, 32,  0, 17, 20, 22, 51, 50, 54,
 55, 19, 35, 19, 33,  5,115,146,254,198,179,254,194,254,148,114,
113,138,  1,119,241,134,  1, 16,132, 59,122,233,118,254,254,254,
188,189,172, 56,112, 57, 57,235, 49,  2, 86,111, 71, 69,  1, 67,
  1, 23,181,  1, 61,131,160,158, 56, 55,254,203, 71, 70,254,168,
254,242,179,198, 15, 16,  1, 34,  1,  2,  0,  1,  0, 43,  0,  0,
  6,135,  5,213,  0, 11,  0,117, 64, 65,  8, 18,  6,  5,  7, 18,
  6,  6,  5,  4, 18,  6,  5,  3, 18,  5,  6,  5, 10, 18,  0, 11,
  9, 18, 11,  0, 11,  2, 18,  0, 11,  1, 18,  0,  0, 11, 58,  2,
135,  8,133,  4,  0, 83, 10,  6, 10,  9,  8,  7,  4,  3,  2,  1,
  8,  0,  6,  2,  5, 28,  0,  2, 11, 25, 12, 16,244,228,244,228,
 17, 23, 57, 49,  0, 47, 60,244, 60,244,236, 48, 75, 83, 88,  7,
 16,  5,237,  7,  5,237,  7, 16,  5,237,  7,  5,237,  7, 16,  5,
237,  7,  5,237,  7, 16,  5,237,  7,  5,237, 89, 34,  1, 33,  3,
 33, 19, 33,  1, 33, 19, 33,  3, 33,  1, 78,  1,129,111,  2, 56,
110,  1,129,254,221,254,127,123,253,201,123,254,127,  5,213,253,
199,  2, 57,250, 43,  2,121,253,135,  0,  0,  1,  0, 43,  0,  0,
  2,207,  5,213,  0,  3,  0, 54, 64, 22,  2, 18,  3,  0,  3,  1,
 18,  0,  0,  3, 58,  0, 83,  2,  2,  1,  0,  0,  2,  3, 25,  4,
 16,244,228, 16,192, 57, 49,  0, 47,228, 48, 75, 83, 88,  7, 16,
  5,237,  7, 16,  5,237, 89, 34,178, 15,  5,  1,  1, 93,  1, 33,
  1, 33,  1, 78,  1,129,254,221,254,127,  5,213,250, 43,  0,  1,
254,172,254,102,  2,207,  5,213,  0, 11,  0,103, 64, 37,  0, 18,
  1,  2,  1,  8,  9, 10,  3,  7, 11, 18,  2,  2,  1, 58, 11,  2,
  0,  7,135,  5,  0, 83, 12,  7,  6,  0, 12,  2,  5, 11,  8,  4,
  1,  6, 12, 16,212,204, 23, 57, 17, 57, 18, 57, 49,  0, 16,228,
212,236, 17, 57, 57, 48, 75, 83, 88,  7, 16,  5,237, 17, 23, 57,
  7, 16,  5,237, 89, 34,  1, 75,176, 13, 84, 75,176, 14, 84, 91,
 88,189,  0, 12,  0, 64,  0,  1,  0, 12,  0, 12,255,192, 56, 17,
 55, 56, 89,  1, 33,  1,  2,  0, 33, 35, 19, 51, 50, 54, 55,  1,
 78,  1,129,254,250, 58,254,173,254,190, 78, 57, 60,119,151, 25,
  5,213,250,188,254,220,254,249,  1, 35,135,129,  0,  1,  0, 43,
  0,  0,  6,178,  5,213,  0, 10,  1, 19, 64, 68,  9, 18,  0, 10,
  8, 18, 10,  0, 10,  8,  3,  9,  8,  5,  6,  5,  7,  3,  6,  6,
  5,  3,  3,  4,  5,  4,  2,  3,  1,  2,  5,  5,  4,  2, 18,  3,
  2,  0, 10,  1, 18,  0,  0, 10, 58,  8,  5,  2,  3,  3,  0, 83,
  9,  6,  9,  8,  5,  2,  1,  5,  0,  6,  4,  0,  2, 10, 25, 11,
 16,244,228,220,196, 17, 23, 57, 49,  0, 47, 60,228, 50, 23, 57,
 48, 75, 83, 88,  7, 16,  5,237,  7,  8,237,  7, 16,  8,237,  7,
 16,  5,237,  7, 16,  5,237,  7, 16,  8,237,  7, 16,  5,237,  7,
  5,237, 89, 34,178, 15,  3,  1,  1, 93, 64,142,  0,  2,  0,  2,
  0,  2,  3,  5,  9,  8, 16,  2, 16,  2, 22,  5, 27,  8, 32,  2,
 32,  2, 38,  5, 45,  8, 48,  2, 59,  8, 70,  2, 74,  8, 84,  2,
 85,  5,101,  2,104,  5,107,  8,118,  2,116,  5,126,  8,132,  2,
128,  2,142,  8,150,  2,144,  2,159,  8, 31,  0,  2,  9,  7, 19,
  2, 25,  3, 31,  3, 28,  4, 28,  7, 35,  2, 41,  3, 38,  4, 40,
  5, 43,  7, 40,  8, 53,  2, 54,  4, 61,  6, 60,  7, 56,  8, 71,
  2, 71,  4, 64,  4, 65,  5, 71,  6, 92,  3, 85,  5,103,  2, 96,
  4,101,  5,109,  6,110,  7,111,  7,112,  4,112,  5,126,  7,132,
  2,138,  8,150,  2,144,  4,152,  8, 39, 93,  0, 93,  1, 33,  3,
  1, 33,  9,  1, 33,  1,  3, 33,  1, 78,  1,129,105,  2,123,  1,
209,252,168,  2,133,254, 60,254, 10,121,254,127,  5,213,253,231,
  2, 25,253, 43,253,  0,  2,111,253,145,  0,  1,  0, 43,  0,  0,
  4,135,  5,213,  0,  5,  0, 73, 64, 27,  2, 18,  5,  0,  5,  1,
 18,  0,  0,  5, 58,  2,135,  0, 83,  4,  4,  2,  1,  3,  3,  0,
  0,  2,  5, 25,  6, 16,244,228, 16,192, 23, 57, 49,  0, 47,228,
236, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237, 89, 34,178,
  7,  4,  1,  1, 93, 64,  9,  4,  3,  5,  4, 16,  3, 16,  4,  4,
 93,  1, 33,  3, 33,  3, 33,  1, 78,  1,129,234,  2,162, 55,251,
219,  5,213,251, 78,254,221,  0,  0,  1,  0, 43,  0,  0,  7,203,
  5,213,  0, 12,  1,  1, 64, 64,  3,  7,  8,  7,  2,  8,  8,  7,
  2,  9, 10,  9,  1, 10, 10,  9,  7, 15,  4,  5,  4,  6, 15,  5,
  5,  4, 11, 15, 12,  0, 12, 10, 15,  0,  0, 12, 58, 10,  8,  7,
  2,  4,  3,  0, 83, 11,  5, 11, 10,  9,  7,  6,  2,  1,  7,  0,
  5,  2,  4,  0,  2, 12, 25, 13, 16,244,228,220,228, 17, 23, 57,
 49,  0, 47, 60,228, 50, 23, 57, 48, 75, 83, 88,  7, 16,  5,237,
  7, 16,  5,237,  7, 16,  5,237,  7, 16,  5,237,  7, 16,  5,201,
  7, 16,  5,201,  7, 16,  5,201,  7, 16,  5,201, 89, 34,178, 15,
  3,  1,  1, 93, 64,126,  2,  7,  6,  8,  6,  9,  7, 10,  0, 10,
 25,  2, 19, 10, 41,  2, 36, 10, 73,  2, 75,  7, 73, 10, 88,  2,
 94,  7, 93, 10,106,  7,111,  7,106, 10,111, 10,122,  7,127,  7,
126, 10,127, 10,138,  2,152,  2,155,  7,168,  7,175,  7, 28,  3,
  1,  8,  2,  6,  3,  7,  8,  8,  9,  6, 10, 22,  1, 24,  2, 22,
  9, 22, 10, 38,  1, 40,  2, 39, 10, 72,  2, 91,  1, 85,  3, 88,
  7, 88, 10,107,  1,101,  3,105,  7,105, 10,125,  1,116,  3,121,
  7,121, 10,137,  2,135,  3,152,  2,149,  3,169,  1,165,  3,169,
  7,168, 10, 34, 93,  0, 93,  1, 33, 19,  1, 33,  1, 33, 19,  1,
 35, 11,  1, 33,  1, 78,  1,217,192,  1,248,  1,236,254,221,254,
147,213,253,250,207,206,213,254,147,  5,213,252,231,  3, 25,250,
 43,  4, 78,252,209,  3, 47,251,178,  0,  0,  1,  0, 43,  0,  0,
  6,135,  5,213,  0,  9,  0,125, 64, 62,  7,  8,  7,  1,  2,  1,
  2,  3,  2,  6,  7,  6,  3, 18,  4,  5,  4,  2, 18,  1,  2,  5,
  5,  4,  8, 18,  9,  0,  9,  7, 18,  6,  7,  0,  0,  9, 58,  7,
  2,  3,  0, 83,  8,  5,  3,  2,  5,  8,  7,  1,  3,  0,  6,  5,
  2,  4, 28,  0,  2,  9, 25, 10, 16,244,228,244,244,196, 17, 23,
 57, 17, 57, 57, 49,  0, 47, 60,228, 50, 57, 57, 48, 75, 83, 88,
  7, 16,  8,237,  7, 16,  5,237,  7, 16,  8,237,  7, 16,  5,237,
  7, 16,  8,201,  7, 16,  8,201, 89, 34,178,  8,  7,  1,  0, 93,
178,  9,  7,  1, 93,  1, 33,  1, 19, 33,  1, 33,  1,  3, 33,  1,
 78,  1,174,  1, 86,201,  1,108,254,221,254, 82,254,170,200,254,
147,  5,213,251,246,  4, 10,250, 43,  4, 10,251,246,  0,  0,  2,
  0, 74,255,227,  6,131,  5,240,  0, 14,  0, 32,  0, 59, 64, 19,
  9,117, 24,  3,117, 15,100, 24, 96, 33,  0, 27, 18, 30,  6, 27,
 27, 13, 33, 16,244,236,244,236, 49,  0, 16,228,244,236, 16,238,
 48,  1, 75,176, 16, 84, 88,189,  0, 33,255,192,  0,  1,  0, 33,
  0, 33,  0, 64, 56, 17, 55, 56, 89,  1, 52, 38, 35, 34,  0, 17,
 20, 22, 51, 50, 54, 55, 62,  1,  3, 32,  0, 17, 20,  2,  7,  6,
  4, 35, 32,  0, 17, 52, 18, 55, 54, 36,  4,236,159,151,200,254,
241,158,141,115,179, 63, 60, 65,254,  1, 42,  1,107,111,106,130,
254,157,232,254,215,254,150,110,107,128,  1, 99,  3,113,176,184,
254,153,254,242,172,190, 97, 95, 91,228,  2,247,254,181,254,245,
182,254,188,129,159,157,  1, 74,  1, 12,183,  1, 68,130,158,156,
  0,  2,  0, 43,  0,  0,  5,193,  5,213,  0, 13,  0, 22,  0, 84,
 64, 45, 15, 18,  0, 13, 14, 18,  0,  0, 13, 12, 18,  0, 13, 11,
 18, 13,  0, 13, 58, 15,117, 10, 14,117,  0, 83, 12, 22, 16, 15,
 14, 12, 11,  6,  1, 10,  0, 19, 27,  4,  0,  2, 13, 25, 23, 16,
244,228,212,236, 17, 57, 57, 23, 57, 49,  0, 47,244,236,212,236,
 48, 75, 83, 88,  7, 16,  5,237,  7,  5,237,  7, 16,  5,237,  7,
  5,237, 89, 34,  1, 33, 50,  4, 21, 20,  6,  7,  6,  6, 35, 35,
  3, 33,  1,  3, 51, 50, 54, 53, 52, 38, 35,  1, 78,  2,127,235,
  1,  9, 88, 82, 89,246,186,254,100,254,127,  2,111, 82,213,136,
144,103, 97,  5,213,215,191,117,211, 79, 85, 77,253,250,  4,190,
254, 95,128,122, 81, 86,  0,  2,  0, 74,254,213,  6,131,  5,240,
  0, 23,  0, 38,  0,107, 64, 42, 22,  4, 23,  0, 23, 19, 20,  2,
 18, 21,  4,  0,  0, 23, 58,  0, 39, 21, 33,117,  3, 27,117, 15,
100,  3, 96, 22, 39, 22, 18, 21,  0, 30, 24, 27, 18, 30, 27,  9,
 13, 39, 16,244,236,212,236, 17, 57, 57, 17, 57, 49,  0, 16,196,
228,244,236, 16,238, 57, 18, 57, 48, 75, 83, 88,  7, 16,  5,237,
 17, 23, 57,  7, 16,  5,237, 89, 34,  1, 75,176, 16, 84, 88,189,
  0, 39,255,192,  0,  1,  0, 39,  0, 39,  0, 64, 56, 17, 55, 56,
 89,  5, 14,  1, 35, 34, 38, 39, 46,  1, 53, 52, 18, 55, 54, 36,
 51, 32,  0, 17, 16,  0,  5, 19, 33,  1, 52, 38, 35, 34,  0, 17,
 20, 22, 51, 50, 54, 55, 62,  1,  2,248, 11, 22, 25,113,200, 82,
110,123,111,106,129,  1, 97,233,  1, 42,  1,107,254,207,254,240,
229,254,145,  1, 52,159,151,200,254,241,158,141,115,179, 63, 60,
 65, 27,  1,  1, 62, 61, 81,251,143,183,  1, 69,129,159,155,254,
181,254,245,254,198,254, 39,108,254,186,  4,156,176,184,254,153,
254,242,172,190, 97, 95, 91,228,  0,  2,  0, 43,  0,  0,  5,123,
  5,213,  0,  8,  0, 28,  0,144, 64, 72, 28, 27, 26,  3, 25, 15,
 22, 23, 22, 24, 15, 23, 23, 22,  8, 18, 12, 11,  7, 18, 12, 12,
 11, 10, 18, 12, 11,  9, 18, 11, 12, 11, 58, 25, 22, 10, 19,  0,
117,  9,  6,117, 12, 83, 23, 10, 22, 23, 28, 25, 24, 10,  9,  8,
  7,  6,  0,  9, 12, 19, 23, 13, 12,  3, 18, 23, 16, 12,  2, 11,
 25, 29, 16,244,228,212,196,236, 17, 57, 17, 57, 17, 23, 57, 17,
 57, 49,  0, 47, 60,244,236,212,236, 57, 18, 57, 57, 48, 75, 83,
 88,  7, 16,  5,237,  7,  5,237,  7, 16,  5,237,  7,  5,237,  7,
 16,  5,237,  7, 16,  5,237, 23, 57, 89, 34,178,  8, 25,  1,  1,
 93,180,  6,  9,  9, 25,  2, 93,  1, 50, 54, 53, 52, 38, 43,  1,
 11,  2, 33,  1, 33, 50, 22, 21, 20,  6,  7, 30,  1, 23, 19, 33,
  3, 46,  1, 35,  2,240,131,135, 93,100,159, 76, 51,111,254,127,
  1, 35,  2, 57,246,254,200,171, 78,104, 39,127,254,129,112, 34,
 97, 92,  3, 63,122,118, 74, 69,254,129,254,246,253,203,  5,213,
184,179,181,234, 17, 16,127,131,254, 88,  1,115,111, 83,  0,  1,
  0, 31,255,227,  5, 82,  5,240,  0, 39,  1,  6, 64, 59, 13, 12,
  2, 14, 11, 15, 31, 30,  7,  8,  9,  3,  6, 10, 15, 30, 31, 30,
 58, 10, 11, 30, 31,  4,  1, 20, 21,136, 24,117, 17,  0,  1,136,
  4,117, 37,100, 17, 96, 40, 11, 27, 14, 31, 34, 30, 10, 27,  7,
  1,  0, 27,  5, 14,  7,  5, 34, 40, 16,212,236,212,236,192,192,
 17, 18, 57, 57, 18, 57, 17, 18, 57, 49,  0, 16,228,244,252,244,
196, 16,254,245,198, 18, 23, 57, 48, 75, 83, 88,  7, 16, 14,237,
 17, 23, 57,  7, 14,237, 17, 23, 57, 89, 34,178,  8,  1,  1,  1,
 93, 64,140, 57,  9, 57, 10, 57, 11, 57, 12, 57, 13, 57, 14, 57,
 29, 57, 30, 57, 31, 57, 32, 57, 33, 73,  9, 73, 10, 73, 11, 73,
 12, 73, 13, 73, 14, 73, 29, 73, 30, 73, 31, 73, 32, 73, 33, 89,
  8, 90,  9, 90, 10, 90, 11, 90, 12, 90, 13, 90, 14, 90, 29, 90,
 30, 90, 31, 90, 32, 90, 33,109,  9,109, 10,109, 11,109, 12,109,
 13,109, 14,107, 19,107, 20,109, 28,109, 29,109, 30,109, 31,109,
 32,109, 33,121,  9,121, 10,121, 11,121, 12,121, 13,121, 14,121,
 28,121, 29,121, 30,121, 31,121, 32,121, 33, 60, 10,  0,  9,  1,
 15, 41, 27,  1, 27,  2, 96, 19, 96, 20, 96, 21, 96, 22,  9, 93,
  0, 93,  1,  3, 46,  1, 35, 34,  6, 21, 20, 22, 31,  1, 30,  1,
 21, 20,  0, 33, 34, 36, 39, 19, 30,  1, 51, 50, 54, 53, 52, 38,
 47,  1, 46,  1, 53, 52,  0, 33, 50, 22,  5, 82, 62,113,220,105,
144,161, 71,111,158,198,185,254,143,254,201,145,254,225,137, 61,
133,251,122,132,165, 74,125,157,174,170,  1,101,  1, 46,121,255,
  5,166,254,196, 56, 55, 90, 80, 51, 57, 27, 39, 50,189,150,243,
254,218, 54, 53,  1, 69, 77, 76,108, 84, 55, 61, 32, 39, 43,186,
148,233,  1, 25, 37,  0,  0,  1,  0, 98,  0,  0,  5,252,  5,213,
  0,  7,  0, 96, 64, 29,  4, 18,  5,  6,  5,  3, 18,  6,  6,  5,
 58,  6,  2,135,  0, 83,  4,  4,  3,  6,  2,  1,  0,  7,  1,  6,
  2,  5,  8, 16,212,244,196,212,196, 16,198, 17, 57, 57, 49,  0,
 47,246,238, 50, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237,
 89, 34,  1, 75,176,  9, 84, 75,176, 10, 84, 91, 75,176, 15, 84,
 91, 88,189,  0,  8,  0, 64,  0,  1,  0,  8,  0,  8,255,192, 56,
 17, 55, 56, 89, 19, 33,  3, 33,  3, 33, 19, 33,156,  5, 96, 57,
254, 16,234,254,127,234,254, 16,  5,213,254,221,251, 78,  4,178,
  0,  1,  0,139,255,227,  6, 84,  5,213,  0, 23,  0,103, 64, 58,
 12, 18, 13, 14, 13,  9, 10,  2, 11, 18, 14, 14, 13,  7,  6,  5,
  4,  3,  5,  8,  2, 18, 23,  0, 23,  1, 18,  0,  0, 23, 58, 23,
 14, 11,  2,  4,  0,  8,135, 17, 96, 12,  0, 83, 24, 23, 14, 12,
 11,  5,  2,  1,  0,  8, 13, 20, 20, 24, 16,196, 16,192, 23, 57,
 49,  0, 16,228, 50,244,236, 17, 23, 57, 48, 75, 83, 88,  7, 16,
  5,237,  7, 16,  5,237, 17, 23, 57,  7, 16,  5,237, 23, 57,  7,
 16,  5,237, 89, 34,  1, 33,  3,  6,  6, 21, 20, 22, 51, 50, 54,
 55, 19, 33,  3,  2,  0, 33, 32, 36, 53, 52, 54, 55,  1, 78,  1,
129,174, 10,  9,105,104,140,150, 36,174,  1,129,174, 65,254,149,
254,174,254,247,254,236, 10, 11,  5,213,252,130, 48, 74, 28, 98,
 97,157,187,  3,127,252,129,254,182,254,215,227,216, 36, 89, 59,
  0,  1,  0,156,  0,  0,  6,184,  5,213,  0,  6,  0,113, 64, 39,
  3, 15,  4,  5,  4,  2, 15,  1,  2,  5,  5,  4,  2, 15,  3,  2,
  6,  0,  6,  1, 15,  0,  0,  6, 58,  2,  3,  0, 83,  5,  6,  5,
  3,  2,  1,  5,  4,  0,  7, 16,212,204, 23, 57, 49,  0, 47,228,
 50, 57, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  8,237,  7, 16,
  8,237,  7, 16,  5,237, 89, 34,178,  8,  3,  1,  1, 93, 64, 28,
  0,  2, 21,  2, 37,  2, 53,  2,  4,  8,  3,  6,  5, 22,  2, 25,
  3, 25,  4, 18,  5, 41,  3, 55,  2, 54,  5,  9, 93,  0, 93, 19,
 33, 19,  1, 33,  1, 33,156,  1,110,183,  2,106,  1,141,252,181,
254, 53,  5,213,251,164,  4, 92,250, 43,  0,  1,  0,219,  0,  0,
  9, 37,  5,213,  0, 12,  1,  7, 64, 74, 10,  4, 11, 10,  4,  5,
  4,  9,  4,  5,  5,  4, 11,  4,  2,  3,  2, 10,  4,  9, 10,  3,
  3,  2,  6, 15,  7,  8,  7,  5, 15,  4,  5,  8,  8,  7,  2, 15,
  3,  2, 12,  0, 12,  1, 15,  0,  0, 12, 58, 10,  5,  2,  3,  6,
  3,  0, 83, 11,  8, 12, 11, 10,  9,  8,  6,  5,  4,  3,  2,  1,
 11,  7,  0, 13, 16,212,204, 23, 57, 49,  0, 47, 60,228, 50, 50,
 23, 57, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  8,237,  7, 16,
  8,237,  7, 16,  5,237,  7, 16,  8,237,  7, 16,  5,237,  7, 16,
  5,237,  7, 16,  8,237, 89, 34,  1, 75,176, 14, 84, 88,189,  0,
 13,  0, 64,  0,  1,  0, 13,  0, 13,255,192, 56, 17, 55, 56, 89,
 64,106, 11, 10, 15, 10, 15, 10, 15, 10, 22,  5, 31, 10, 31, 10,
 31, 10, 47, 10, 47, 10, 63, 10, 63, 10, 79, 10, 79, 10, 89,  2,
 89,  5, 89, 10,140, 10,143, 10, 19,  4,  8, 12,  9, 11, 10,  5,
 11,  0, 11, 25,  3, 17,  8, 24,  9, 26, 10, 16, 11, 38,  2, 37,
  5, 35,  8, 39, 11, 32, 11, 54,  2, 51,  8, 55, 11, 48, 11, 66,
  8, 66, 11, 85,  2, 90,  3, 86,  5, 80,  8, 80, 11,128,  4,128,
  5,128,  6,128,  7,128,  8,134, 10,130, 11, 33, 93,  0, 93, 19,
 33, 19,  1, 33, 19,  1, 33,  1, 33,  3,  1, 33,219,  1,100, 46,
  1,213,  1,110, 49,  1,197,  1,127,253,125,254, 76, 50,254, 29,
254, 66,  5,213,251,195,  4, 61,251,195,  4, 61,250, 43,  4,111,
251,145,  0,  1,255,152,  0,  0,  6,127,  5,213,  0, 11,  0,191,
 64, 73,  3,  4,  4,  3,  0,  1,  0,  2,  4,  1,  1,  0,  0,  4,
  1,  0,  9, 10,  9, 11,  4, 10, 10,  9,  9,  4, 10,  9,  6,  7,
  6,  8,  4,  7,  7,  6,  4,  4,  5,  6,  5,  3,  4,  2,  3,  6,
  6,  5, 58,  9,  6,  3,  0,  4, 10,  7, 83,  4,  1,  9,  8,  7,
  6,  3,  2,  1,  0,  8, 12, 11,  5,  5, 12, 16,196, 16,192, 17,
 23, 57, 49,  0, 47, 60,228, 50, 23, 57, 48, 75, 83, 88,  7, 16,
  8,237,  7, 16,  5,237,  7, 16,  5,237,  7, 16,  8,237,  7, 16,
  5,237,  7, 16,  8,237,  7, 16,  5,237,  7, 16,  8,237, 89, 34,
178,  8, 10,  1,  1, 93, 64, 52, 11,  3, 31,  3, 16,  9, 45,  3,
 36,  9, 60,  3, 50,  9, 76,  3, 67,  9,  9,  3,  4,  8, 10, 23,
  3, 18,  4, 22,  9, 25, 10, 39,  3, 36,  4, 39,  9, 42, 10, 55,
  3, 57,  9, 58, 11, 68,  3, 72,  8, 71,  9, 16, 93,  0, 93,  9,
  1, 33,  3,  1, 33,  9,  1, 33, 19,  1, 33,  3,248,  1,110,254,
121,243,254, 75,254, 97,  2,159,254,158,  1,137,230,  1,153,  1,
162,  2,244,253, 12,  1,244,254, 12,  2,254,  2,215,254, 43,  1,
213,  0,  0,  1,  0,129,  0,  0,  6,121,  5,213,  0,  8,  0,120,
 64, 53,  3, 15,  4,  5,  4,  2, 15,  1,  2,  5,  5,  4,  2, 15,
  3,  2,  8,  0,  8,  1, 15,  0,  0,  8,  6, 18,  7,  8,  7,  5,
 18,  4,  5,  8,  8,  7, 58,  2,  3,  0, 83,  6,  0,  9,  8,  6,
  2,  1,  4,  4,  7,  7,  9, 16,196, 16,192, 23, 57, 18, 57, 49,
  0, 47,228, 50, 57, 48, 75, 83, 88,  7, 16,  8,237,  7, 16,  5,
237,  7, 16,  5,237,  7, 16,  8,237,  7, 16,  8,237,  7, 16,  5,
237, 89, 34,178,  0,  2,  1,  0, 93, 64, 10,  9,  5,  9,  8,  2,
 16,  2, 68,  2,  2, 93,  1, 93, 19, 33, 19,  1, 33,  1,  3, 33,
 19,129,  1,129,254,  1,188,  1,189,253, 31,121,254,127,121,  5,
213,253,215,  2, 41,252,154,253,145,  2,111,  0,  0,  1,255,203,
  0,  0,  5,236,  5,213,  0,  9,  0, 57, 64, 29,  3, 15,  7,  8,
  7,  8, 15,  2,  3,  2, 58,  8,135,  0, 83,  3,135,  5,  9,  8,
  5,  4,  3,  0,  6, 10,  1,  6, 10, 16,212,204, 17, 23, 57, 49,
  0, 47,236,244,236, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,
237, 89, 34,  1, 33,  7,  1, 33,  3, 33, 55,  1, 33,  1,  4,  4,
232, 48,252, 56,  3, 37, 58,250,236, 45,  3,203,253,  8,  5,213,
238,252, 60,254,221,238,  3,196,  0,  1,255,236,254,242,  3,186,
  6, 20,  0,  7,  0, 70, 64, 34,  4,  4,  7,  0,  7,  3,  4,  0,
  0,  7, 58,  4,137,  6,108,  2,137,  0,107,  8,  3,  5,  4,  6,
  0,  2,  1,  0,  5,  6,  0, 31,  7,  8, 16,212,228,212,196, 16,
214,198, 17, 18, 57, 17, 57, 49,  0, 16,252,236,252,236, 48, 75,
 83, 88,  7, 16,  5,237,  7, 16,  5,237, 89, 34,  1, 33,  7, 33,
  1, 33,  7, 33,  1, 78,  2,108, 45,254,234,254,243,  1, 25, 45,
253,150,  6, 20,225,250,160,225,  0,  1,  0,145,255, 66,  2, 53,
  5,213,  0,  3,  0, 24, 64, 10,  0,  1, 83,  4,  2,  3,  0,  0,
  1,  4, 16,212,196, 16,192, 57, 49,  0, 16,244,204, 48,  5,  3,
 51, 19,  1, 88,199,222,198,190,  6,147,249,109,  0,  1,255,199,
254,242,  3,150,  6, 20,  0,  7,  0, 64, 64, 31,  4,  4,  7,  0,
  7,  3,  4,  0,  7, 58,  2,137,  0,108,  4,137,  6,107,  8,  3,
  5,  4,  0,  6,  5,  7, 31,  0,  2,  1,  8, 16,212,196,212,244,
212,196, 17, 57, 17, 57, 49,  0, 16,252,236,252,236, 48, 75, 83,
 88,  7,  5,237,  7, 16,  5,237, 89, 34,  1, 33, 55, 33,  1, 33,
 55, 33,  2, 51,253,148, 43,  1, 24,  1, 13,254,231, 43,  2,109,
254,242,225,  5, 96,225,  0,  1,  0,207,  3,168,  5,229,  5,213,
  0,  6,  0, 24, 64, 10,  3,  4,  1,  0, 83,  7,  3,  1,  5,  7,
 16,212,204, 57, 49,  0, 16,244,204, 50, 57, 48,  1,  1, 35,  1,
  1, 35,  1,  3,213,  2, 16,241,254,102,254,103,242,  2, 16,  5,
213,253,211,  1, 45,254,211,  2, 45,  0,  0,  1,255,236,254, 29,
  4, 20,255, 31,  0,  3,  0, 16,181,  0,  1,  4,  0,  2,  4, 16,
212,204, 49,  0, 16,212,204, 48,  5, 17, 33, 17,  4, 20,251,216,
225,254,254,  1,  2,  0,  0,  1,  1, 12,  4,238,  2,248,  6,102,
  0,  3,  0, 50, 64,  9,  1,139,  0,138,  4,  0,  1,  3,  4, 16,
212,204, 57, 49,  0, 16,244,236, 48,  0, 75,176,  9, 84, 75,176,
 14, 84, 91, 88,189,  0,  4,255,192,  0,  1,  0,  4,  0,  4,  0,
 64, 56, 17, 55, 56, 89,  1, 19, 35,  1,  2, 39,209,197,254,217,
  6,102,254,136,  1,120,  0,  2,  0, 35,255,227,  4,227,  4,123,
  0, 10,  0, 43,  0,243, 64, 99, 30, 29, 28, 27, 26,  5, 31, 25,
  5, 12, 11, 23,  1, 22, 24,  5, 12, 11,  1,  0,  2,  2, 10,  5,
 12, 11,  7,  8,  2,  6,  9,  5, 11, 12, 11, 16, 15,  2, 17, 14,
  5, 12, 11, 13,  5, 12, 12, 11, 58,  9,  6,  0, 25, 34, 23, 14,
 12,  6, 11,  0,150, 23,148,  6,103, 17, 35,145, 34,144, 31,103,
 38,143, 17, 96, 12, 25, 24, 13, 12, 11, 10,  9,  0,  8, 14, 23,
 28,  3, 41, 35,  3, 34,  3, 14, 41, 20, 44, 16,212,196,236,196,
 17, 57, 18, 23, 57, 23, 57, 49,  0, 47,228,244,252,244,236, 16,
238,246,238, 57, 17, 18, 57, 17, 18, 57, 17, 18, 57, 48, 75, 83,
 88,  7, 16,  5,237,  7,  5,237, 17, 23, 57,  7, 16,  5,237, 17,
 23, 57,  7,  5,237, 17, 23, 57,  7,  5,237, 17, 23, 57,  7,  5,
237, 17, 23, 57, 89, 34,178, 59, 34,  1,  1, 93, 64, 56, 51, 33,
 48, 34, 67, 33, 64, 34, 83, 33, 80, 34, 99, 33, 96, 34,148, 33,
144, 34,164, 33,160, 34,180, 33,176, 34, 14, 53, 34, 58, 35, 58,
 36, 75, 35, 75, 36, 91, 35, 91, 36,107, 35,107, 36,155, 35,155,
 36,171, 35,171, 36, 13, 93,  0, 93,  1, 34,  6, 21, 20, 22, 51,
 50, 54, 63,  1, 37,  3, 33, 55, 14,  1, 35, 34, 38, 53, 52, 36,
 33, 51, 55, 62,  1, 53, 52, 38, 35, 34,  6,  7, 19, 62,  1, 51,
 50, 22, 21, 20,  6,  2,162,134,137, 81, 71,110,148, 25,  8,  1,
131,125,254,154, 30, 88,196,115,159,187,  1, 75,  1, 56,211,  4,
  3,  1,125,123,111,208, 97, 54,112,235,126,249,242,  9,  1,248,
 83, 81, 61, 70,133,121, 41,135,253,129,166,100, 95,165,140,214,
227, 28, 14, 12,  5, 66, 67, 46, 46,  1, 17, 28, 29,171,175, 34,
 81,  0,  0,  2,  0, 63,255,227,  5,106,  6, 20,  0, 11,  0, 31,
  0,140, 64, 75,  5,  4,  2,  6,  3,  5, 15, 14,  1,  1,  0,  2,
  5, 15, 14, 13,  5, 15, 14, 30, 31,  2, 29, 12,  5, 14, 15, 14,
 19, 18,  2, 20, 17,  5, 15, 14, 16,  5, 15, 15, 14, 58, 17, 20,
  0, 12, 13,  6,  0,105, 20,  6,105, 29, 96, 20,143, 15,107, 13,
 16, 13,  3,  3, 17, 12, 15,  9, 33, 23, 15, 32, 14, 13, 32, 16,
244,228,212,236, 17, 57, 57, 23, 57, 49,  0, 47,236,228,244,236,
 16,238, 17, 18, 57, 17, 18, 57, 48, 75, 83, 88,  7, 16,  5,237,
  7,  5,237, 17, 23, 57,  7, 16,  5,237, 17, 23, 57,  7,  5,237,
  7,  5,237, 17, 23, 57,  7,  5,237, 17, 23, 57, 89, 34,  1, 34,
  6, 21, 20, 22, 51, 50, 54, 53, 52, 38,  1,  7, 33,  1, 33,  3,
 54, 54, 51, 50, 22, 21, 20,  6,  7,  6,  6, 35, 34, 38,  3, 63,
138,175, 99, 88,135,176, 95,254, 46, 33,254,153,  1, 46,  1,104,
117, 82,180,107,189,220, 77, 72, 91,229,131,115,161,  3,119,255,
204, 92,105,251,196,102,107,253, 43,162,  6, 20,253,168, 98, 93,
240,207,129,244,100,126,130, 93,  0,  1,  0, 76,255,227,  4,166,
  4,123,  0, 28,  0, 51, 64, 28, 14,145, 13,152, 10,105, 17,  0,
145,  1,152,  4,105, 26,143, 17, 96, 29, 13,  1, 14,  0,  7, 19,
  0, 20, 13, 29, 16,244,196,236, 17, 57, 57, 57, 49,  0, 16,228,
244,252,244,236, 16,254,244,238, 48,  1,  3, 38, 38, 35, 34,  6,
 21, 20, 22, 51, 50, 54, 55,  3,  6,  6, 35, 32, 36, 53, 52, 18,
 55, 54, 36, 51, 50, 22,  4,166, 57, 72,140, 67,175,222,138,126,
 84,162, 73, 55, 89,180, 91,254,248,254,227,105, 98,109,  1, 26,
184, 85,168,  4, 61,254,220, 48, 50,235,183,117,129, 50, 49,254,
219, 31, 31,237,218,137,  1,  2,103,113,110, 31,  0,  2,  0, 74,
255,227,  5,203,  6, 20,  0, 11,  0, 31,  0,140, 64, 75,  5,  4,
  2,  6,  3,  5, 15, 14,  1,  1,  0,  2,  5, 15, 14, 19, 18,  2,
 20, 17,  5, 15, 14, 16,  5, 15, 15, 14, 13,  5, 15, 14, 30, 31,
  2, 29, 12,  5, 14, 15, 14, 58, 12, 29,  6, 17, 15,  0,  6,105,
 29,  0,105, 20, 96, 29,143, 13,107, 15, 16, 13,  3,  3, 17, 12,
  9, 15, 32, 14,  9, 33, 23, 13, 32, 16,244,236,212,228, 17, 57,
 57, 23, 57, 49,  0, 47,236,228,244,236, 16,238, 17, 18, 57, 17,
 18, 57, 48, 75, 83, 88,  7, 16,  5,237, 17, 23, 57,  7,  5,237,
  7, 16,  5,237,  7,  5,237, 17, 23, 57,  7,  5,237, 17, 23, 57,
  7,  5,237, 17, 23, 57, 89, 34, 37, 50, 54, 53, 52, 38, 35, 34,
  6, 21, 20, 22,  1, 19, 33,  1, 33, 55,  6,  6, 35, 34, 38, 53,
 52, 54, 55, 54, 54, 51, 50, 22,  2,117,138,173, 97, 87,136,176,
 95,  1,211,116,  1,105,254,209,254,151, 33, 82,180,107,189,220,
 77, 72, 91,229,131,115,161,231,254,205, 93,104,251,196,102,107,
  2,213,  2, 88,249,236,162, 98, 93,240,207,129,244,100,126,130,
 93,  0,  0,  2,  0, 74,255,227,  5, 31,  4,123,  0, 29,  0, 39,
  0, 72, 64, 40,  0, 30,156,  1, 12,145, 11,152,  8,103, 15,  1,
155, 36,103, 24,143, 15, 96, 40,  0,  1, 27, 11, 39, 30,  2,  3,
  5, 12, 11, 33, 14, 11, 27,  5, 14, 18, 13, 40, 16,244,236,212,
196,236, 17, 57, 17, 23, 57, 17, 18, 57, 57, 49,  0, 16,228,244,
236,228, 16,254,244,238, 16,238, 57, 48,  1,  7, 33, 20,  6, 21,
 20, 22, 51, 50, 54, 55,  3,  6,  4, 35, 32, 36, 53, 52, 54, 55,
 54, 36, 51, 50,  4, 21, 20,  6, 37, 54, 54, 53, 52, 38, 35, 34,
  6,  7,  5,  8, 12,252,186,  2,131,131,113,251,138, 55,131,254,
253,134,254,250,254,227, 91, 87,103,  1, 31,175,227,  1, 11, 11,
254,162,  3,  3, 96, 82,105,147, 39,  2,  6, 57,  6, 23,  6,109,
108, 68, 67,254,234, 48, 47,242,221,128,241,100,120,124,242,205,
 40, 89,111, 13, 27, 13, 80, 94,115,112,  0,  1,  0,102,  0,  0,
  4, 82,  6, 20,  0, 19,  0,169, 64, 60, 10,  5, 11, 15, 11,  9,
  5, 15, 11,  6,  5, 15, 11,  2,  3,  4,  3,  1,  5,  5, 15, 15,
 11, 58, 16,  5,  1, 12,  8,105,  6,  1,103,  0,107, 14,  6,122,
 10, 12, 11, 14,  3, 13, 19, 16, 10,  9,  8,  7,  6,  5,  2,  1,
 10,  0, 15, 15, 13, 20, 16,212,196, 16,192, 23, 57, 18, 23, 57,
 49,  0, 47,228, 50,252,236, 16,238, 50, 18, 57, 57, 48, 75, 83,
 88,  7, 16,  5,237, 17, 23, 57,  7,  5,237,  7,  5,237,  7, 16,
  5,237, 89, 34,  1, 75,176, 10, 84, 75,176, 14, 84, 91, 75,176,
 15, 84, 91, 75,176, 17, 84, 91, 75,176, 18, 84, 91, 75,176, 19,
 84, 91, 88,189,  0, 20,  0, 64,  0,  1,  0, 20,  0, 20,255,192,
 56, 17, 55, 56, 89, 64,  9, 96,  7, 96,  8,112,  7,112,  8,  4,
 93,  1,  7, 35, 34,  6, 15,  1, 33,  3, 33,  3, 33, 19, 35, 19,
 51, 55, 62,  1, 51,  4, 82, 47,197, 75, 69, 13, 17,  1, 47, 49,
254,209,168,254,152,168,177, 50,176, 16, 37,234,216,  6, 20,235,
 55, 67, 79,255,  0,252,160,  3, 96,  1,  0, 78,186,172,  0,  2,
  0, 41,254, 70,  5,117,  4,121,  0, 31,  0, 43,  0,164, 64, 89,
 43, 42,  2, 32, 41,  5, 18, 17, 39,  1, 38, 40,  5, 18, 17,  2,
  1,  2,  3,  0,  5, 18, 17, 29, 30,  2, 28, 31,  5, 18, 18, 17,
 16,  5, 18, 17, 13, 14,  2, 12, 15,  5, 17, 18, 17, 58,  0, 38,
  3, 15, 32, 16, 18, 31, 38,  3, 24,145, 25,152, 28,103, 21, 32,
105, 12,143, 16,122, 21,158, 38,105,  3, 41, 16, 15, 31, 18,  0,
  4, 17, 25, 35, 33, 17,  6, 13, 44, 16,244,196,236, 57, 17, 23,
 57, 57, 57, 49,  0, 47,236,228,228,244,236, 16,254,245,238, 17,
 18, 57, 57, 17, 18, 57, 17, 18, 57, 48, 75, 83, 88,  7, 16,  5,
237, 17, 23, 57,  7,  5,237,  7, 16,  5,237, 17, 23, 57,  7,  5,
237, 17, 23, 57,  7,  5,237, 17, 23, 57,  7,  5,237, 17, 23, 57,
 89, 34, 37,  6,  6, 35, 34, 38, 53, 52, 54, 55, 54, 54, 51, 50,
 22, 23, 55, 33,  3,  2,  0, 33, 34, 38, 39, 19, 22, 22, 51, 50,
 54, 55,  3, 34,  6, 21, 20, 22, 51, 50, 54, 53, 52, 38,  3, 88,
 86,178,105,190,221, 77, 72, 88,228,131,118,161, 55, 30,  1,105,
189, 58,254,132,254,174,104,193, 94, 53, 85,170, 89,178,191, 33,
 84,132,175, 94, 90,131,176, 94,190, 98, 92,245,212,113,227,100,
121,127, 92, 99,166,252, 51,254,211,254,224, 32, 33,  1, 23, 54,
 53,152,166,  3,  6,238,180,102,107,237,177,104,109,  0,  0,  1,
  0, 63,  0,  0,  5, 59,  6, 20,  0, 25,  0,143, 64, 76,  8,  7,
  6,  5,  4,  5,  3,  5,  0,  1,  0,  2,  5,  1,  1,  0, 13,  5,
 15, 14, 10, 11,  2,  9, 12,  5, 14, 15, 14, 19, 18,  2, 17,  5,
 15, 14, 16,  5, 15, 15, 14, 58, 17, 20, 12,  3,  0,  1,  9,159,
 20,143, 15,107, 13,  1,  0, 23, 16, 13, 12,  6,  3,  2,  6, 17,
 15,  1, 37, 23, 35, 15, 32, 14, 13, 26, 16,244,228,244,236, 17,
 57, 23, 57, 17, 57, 49,  0, 47, 60,236,244,236, 17, 57, 57, 57,
 17, 57, 48, 75, 83, 88,  7, 16,  5,237,  7,  5,237, 23, 57,  7,
 16,  5,237, 17, 23, 57,  7,  5,237,  7, 16,  5,237,  7, 16,  5,
237, 23, 57, 89, 34,178, 48, 27,  1,  1, 93,  1,  3, 33, 19, 62,
  1, 53, 52, 38, 35, 34,  6,  7,  3, 33,  1, 33,  3, 62,  1, 51,
 50, 22, 21, 20,  6,  5, 41,133,254,153,113, 12, 13, 71, 65,111,
159, 31,108,254,153,  1, 46,  1,104,117, 99,200,109,155,168,  9,
  2,170,253, 86,  2, 72, 57, 79, 23, 64, 70,173,153,253,217,  6,
 20,253,168, 97, 94,162,147, 32, 78,  0,  0,  2,  0, 63,  0,  0,
  2,213,  6, 20,  0,  3,  0,  7,  0, 88, 64, 40,  6,  5,  7,  4,
  7,  5,  5,  4,  4,  7,  2,  5,  3,  0,  3,  1,  5,  0,  3, 58,
  6,161,  0,122,  4,107,  2,  6,  2,  1,  3,  5,  7,  0,  4, 32,
  0,  3, 13,  8, 16,244,196,244,228,192, 23, 57, 49,  0, 47,236,
244,236, 48, 75, 83, 88,  7,  5,237,  7, 16,  5,237,  7, 16,  5,
237,  7, 16,  5,237, 89, 34,178, 31,  9,  1,  1, 93,178,111,  9,
  1, 93,  1, 33,  3, 33,  1, 33,  3, 33,  1, 25,  1,104,219,254,
153,  1, 46,  1,104, 57,254,151,  4, 96,251,160,  6, 20,254,220,
  0,  2,254,250,254, 70,  2,213,  6, 20,  0, 11,  0, 15,  0,149,
 64, 58, 14,  5, 15, 12, 15, 13,  5, 12, 12, 15,  5,  4,  3,  3,
  6,  2,  5, 11,  0, 11,  1,  5,  0, 11, 58, 11,  2,  7, 14,161,
  0,  7,103,  5,158,  0,122, 12,107, 16, 14,  1, 13, 12,  7, 16,
  6,  2, 13, 12,  5,  8,  6, 15,  0, 12,  0, 16, 16,212,212,228,
 46, 46, 46, 16,192,192, 17, 18, 57, 17, 18, 57, 57, 49,  0, 16,
236,228,244,236, 16,237, 18, 57, 57, 48, 75, 83, 88,  7,  5,237,
  7, 16,  5,237, 17, 23, 57,  7, 16,  5,237,  7, 16,  5,237, 89,
 34,  1, 75,176, 12, 84, 75,176, 11, 84, 91, 88,189,  0, 16,  0,
 64,  0,  1,  0, 16,  0, 16,255,192, 56, 17, 55, 56, 89,180, 31,
 17,111, 17,  2, 93,  1, 33,  3, 14,  1, 43,  1, 55, 51, 50, 54,
 55,  1, 33,  3, 33,  1, 25,  1,104,215, 46,251,213,178, 45, 63,
101, 93, 26,  1, 43,  1,104, 57,254,151,  4, 96,251,180,235,227,
235, 91,136,  6,  0,254,220,  0,  0,  1,  0, 63,  0,  0,  5,186,
  6, 20,  0, 10,  0,190, 64, 65,  8,  4,  9,  8,  5,  6,  5,  7,
  4,  6,  6,  5,  3,  4,  5,  4,  2,  5,  5,  4,  9,  5,  0, 10,
  8,  5,  7,  8, 10,  0, 10,  2,  5,  0, 10,  1,  5,  0,  0, 10,
 58,  8,  5,  2,  3,  3,122,  0,107,  9,  6,  9,  8,  5,  2,  1,
  5,  0,  6,  4,  0, 32, 10, 13, 11, 16,244,228,212,196, 17, 23,
 57, 49,  0, 47, 60,236,228, 23, 57, 48, 75, 83, 88,  7, 16,  5,
237,  7,  5,237,  7, 16,  8,237,  7,  5,237,  7, 16,  5,201,  7,
 16,  5,201,  7, 16,  5,237,  7, 16,  8,237, 89, 34,178, 15,  8,
  1,  0, 93, 64, 60, 12,  2, 15,  3, 15,  4, 10,  5,  9,  7,  9,
  8,  5,  9, 41,  7, 69,  2, 81,  2, 88,  3, 99,  2,119,  2,112,
  2,118,  5,122,  6,151,  2,167,  2, 18, 11,  2, 12,  8, 42,  8,
 69,  2, 83,  2,100,  2,112,  2,117,  5,115,  8,144,  2,167,  2,
 11, 93,  1, 93,  1, 33,  3,  1, 33,  9,  1, 33,  1,  3, 33,  1,
109,  1,104,164,  1,227,  1,166,253,117,  1,217,254,103,254,149,
 94,254,153,  6, 20,252,181,  1,151,253,250,253,166,  1,227,254,
 29,  0,  0,  1,  0, 63,  0,  0,  2,213,  6, 20,  0,  3,  0, 54,
 64, 22,  2,  5,  3,  0,  3,  1,  5,  0,  0,  3, 58,  0,107,  2,
  2,  1,  0,  0, 32,  3, 13,  4, 16,244,228, 16,192, 57, 49,  0,
 47,236, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237, 89, 34,
178, 31,  5,  1,  1, 93,  1, 33,  1, 33,  1,109,  1,104,254,209,
254,153,  6, 20,249,236,  0,  1,  0, 63,  0,  0,  7,223,  4,123,
  0, 43,  0,255, 64,120, 32, 31, 30, 29, 28, 27, 26, 25,  8, 33,
 24,  5, 21, 22, 21, 23,  5, 22, 22, 21, 20, 19, 18, 17, 16, 15,
 14, 13,  8, 21, 12,  4,  9, 10,  9, 11,  4, 10, 10,  9, 34,  5,
 35, 36, 35, 31, 32,  2, 30, 33,  5, 36, 35, 40, 39,  2, 41, 38,
  5, 36, 35, 37,  5, 36, 36, 35, 58, 33, 24, 21, 13,  4, 10,  0,
 38, 36,  9, 10, 30, 18,159, 41,  3,143, 36,122, 34, 22, 10, 37,
 34, 33, 27, 24, 23,  6, 36, 22,  9,  6, 13, 11, 10,  0, 38, 36,
 21, 22, 15, 10, 22, 37,  0,  6, 37, 10, 36, 35, 13, 44, 16,244,
196,212,252,212,236, 18, 57, 18, 57, 17, 57, 17, 18, 57, 57, 17,
 57, 17, 18, 23, 57, 49,  0, 47, 60, 60,228,244, 60,236, 50, 17,
 57, 17, 57, 57, 17, 23, 57, 48, 75, 83, 88,  7, 16,  5,237,  7,
  5,237, 17, 23, 57,  7,  5,237, 17, 23, 57,  7, 16,  5,237,  7,
 16,  5,237,  7, 16,  5,237, 17, 23, 57,  7, 16,  5,237,  7, 16,
  5,237, 17, 23, 57, 89, 34,178, 16, 18,  1,  1, 93, 64, 35, 16,
  2, 16,  3, 16,  4, 16,  5, 16,  6, 16,  7, 16,  8, 16,  9, 16,
 10, 16, 11, 16, 12, 16, 13, 16, 14, 16, 15, 16, 16, 16, 17, 47,
 45, 17, 93,  1, 62,  1, 51, 50, 22, 21, 20,  6,  7,  3, 33, 19,
 55, 54, 53, 52, 38, 35, 34,  6,  7,  3, 33, 19, 62,  1, 53, 52,
 38, 35, 34,  6,  7,  3, 33, 19, 33,  7, 62,  1, 51, 50, 22,  5,
  4, 83,211,114,150,173,  9,  9,133,254,151,113,  3, 26, 63, 54,
103,143, 31,108,254,151,115, 15, 12, 62, 55, 99,149, 29,108,254,
153,218,  1,104, 33, 84,190,103,116,166,  3,166,103,110,165,144,
 30, 77, 49,253, 86,  2, 72, 15,124, 35, 55, 64,169,157,253,217,
  2, 72, 75, 77, 22, 56, 63,175,151,253,217,  4, 96,164, 95, 96,
119,  0,  0,  1,  0, 63,  0,  0,  5, 59,  4,123,  0, 25,  0,147,
 64, 78,  8,  7,  6,  5,  4,  5,  3,  5,  0,  1,  0,  2,  5,  1,
  1,  0, 13,  5, 14, 15, 14, 10, 11,  2,  9, 12,  5, 15, 14, 19,
 18,  2, 20, 17,  5, 15, 14, 16,  5, 15, 15, 14, 58, 12,  3,  1,
 17, 15,  0,  1,  9,159, 20,143, 15,122, 13,  1,  0, 23, 16, 13,
 12,  6,  3,  2,  6, 17, 15,  1, 37, 23, 35, 15, 38, 14, 13, 26,
 16,244,228,244,236, 17, 57, 23, 57, 17, 57, 49,  0, 47, 60,228,
244,236, 17, 57, 17, 57, 17, 57, 57, 48, 75, 83, 88,  7, 16,  5,
237,  7,  5,237, 17, 23, 57,  7,  5,237, 17, 23, 57,  7, 16,  5,
237,  7, 16,  5,237,  7, 16,  5,237, 23, 57, 89, 34,178, 48, 27,
  1,  1, 93,  1,  3, 33, 19, 62,  1, 53, 52, 38, 35, 34,  6,  7,
  3, 33, 19, 33,  7, 62,  1, 51, 50, 22, 21, 20,  6,  5, 41,133,
254,153,113, 12, 13, 71, 65,111,159, 31,108,254,153,218,  1,104,
 33, 99,200,109,155,168,  9,  2,170,253, 86,  2, 72, 57, 79, 23,
 64, 70,173,153,253,217,  4, 96,164, 97, 94,162,147, 32, 78,  0,
  0,  2,  0, 74,255,227,  5, 53,  4,123,  0, 11,  0, 29,  0, 41,
 64, 19,  6,105, 21,  0,105, 12,143, 21, 96, 30,  9, 33, 15, 41,
  3, 33, 24, 13, 30, 16,244,236,244,236, 49,  0, 16,228,244,236,
 16,238, 48,178,112, 31,  1,  1, 93,  1, 34,  6, 21, 20, 22, 51,
 50, 54, 53, 52, 38,  3, 50,  4, 21, 20,  6,  7,  6,  4, 35, 34,
 36, 53, 52, 54, 55, 54, 36,  3,  0,139,180, 97, 93,139,180, 97,
 64,250,  1, 30, 90, 86,102,254,234,171,247,254,227, 92, 86,100,
  1, 21,  3,123,252,195,106,111,253,196,105,110,  1,  0,254,219,
127,239, 99,118,120,254,219,126,241,100,116,120,  0,  2,255,236,
254, 86,  5,106,  4,123,  0, 19,  0, 31,  0,150, 64, 77, 25, 24,
  2, 26, 23,  5,  3,  2, 21,  1, 20, 22,  5,  3,  3,  2,  1,  5,
  3,  2, 18, 19,  2, 17,  0,  5,  2,  3,  2,  7,  6,  2,  8,  5,
  5,  3,  2,  4,  5,  3,  3,  2, 58,  0, 26, 17,  5, 20,  3, 26,
105, 17, 20,105,  8,143, 17, 96,  1,162,  3,122, 32, 23,  4,  1,
  3,  5,  0,  3, 29, 33, 11,  3, 32,  2, 32, 16,220,228,212,236,
 17, 57, 57, 23, 57, 49,  0, 16,228,228,228,244,236, 16,238, 17,
 18, 57, 17, 18, 57, 48, 75, 83, 88,  7, 16,  5,237,  7,  5,237,
 17, 23, 57,  7, 16,  5,237, 17, 23, 57,  7,  5,237,  7, 16,  5,
237, 17, 23, 57,  7,  5,237, 17, 23, 57, 89, 34,178, 48, 33,  1,
  1, 93, 37,  3, 33,  1, 33,  7, 62,  1, 51, 50, 22, 21, 20,  6,
  7, 14,  1, 35, 34, 38,  1, 34,  6, 21, 20, 22, 51, 50, 54, 53,
 52, 38,  1,199,115,254,152,  1, 45,  1,104, 33, 82,180,107,189,
220, 77, 72, 91,229,131,115,161,  1, 65,138,175, 99, 88,135,176,
 95,162,253,180,  6, 10,164, 98, 93,240,207,129,244,100,126,130,
 93,  3, 55,255,204, 92,105,251,196,102,107,  0,  0,  2,  0, 74,
254, 86,  5,117,  4,123,  0, 19,  0, 31,  0,145, 64, 78, 25, 24,
  2, 26, 23,  5,  3,  2, 21,  1, 20, 22,  5,  2,  3,  2,  7,  6,
  2,  8,  5,  5,  3,  2,  4,  5,  3,  3,  2,  1,  5,  3,  2, 18,
 19,  2, 17,  0,  5,  2,  3,  2, 58,  5, 20,  8,  0, 26,  1, 20,
105,  8, 26,105, 17,143,  8, 96,  3,162,  1,122, 32, 23,  4,  1,
  3,  5,  0, 29,  3, 32,  2, 29, 33, 11, 13, 32, 16,244,236,212,
228, 17, 57, 57, 23, 57, 49,  0, 16,228,228,228,244,236, 16,238,
 17, 18, 57, 17, 18, 57, 48, 75, 83, 88,  7, 16,  5,237, 17, 23,
 57,  7,  5,237,  7, 16,  5,237,  7,  5,237, 17, 23, 57,  7, 16,
  5,237, 17, 23, 57,  7,  5,237, 17, 23, 57, 89, 34,  1, 55, 33,
  1, 33, 19,  6,  6, 35, 34, 38, 53, 52, 54, 55, 54, 54, 51, 50,
 22,  1, 50, 54, 53, 52, 38, 35, 34,  6, 21, 20, 22,  3,238, 30,
  1,105,254,211,254,151,115, 80,180,107,189,220, 77, 72, 91,229,
131,115,161,254,191,138,173, 97, 87,136,176, 95,  3,188,164,249,
246,  2, 76, 98, 93,240,207,129,244,100,126,130, 93,252,201,254,
205, 93,104,251,196,102,107,  0,  0,  1,  0, 63,  0,  0,  4, 92,
  4,123,  0, 17,  0,146, 64, 54,  7,  5,  8,  9,  8,  4,  5,  2,
  3,  6,  5,  9,  8, 13, 12,  2, 11,  5,  9,  8, 10,  5,  9,  9,
  8, 58, 17, 14, 11,  9,  3,  6,  7,  0,  3,135, 14,143,  9,122,
  7, 11, 10,  7,  6,  0,  5,  9, 17,  9, 38,  8, 13, 18, 16,244,
228,204, 17, 23, 57, 49,  0, 47,228,244,252,196, 17, 57, 17, 18,
 57, 17, 57, 48, 75, 83, 88,  7, 16,  5,237,  7,  5,237, 23, 57,
  7,  5,237, 17, 23, 57,  7, 16,  5,237, 89, 34,178, 32, 17,  1,
  1, 93, 64, 35, 32,  0, 32,  1, 32, 14, 32, 15, 32, 16, 64,  0,
 64,  1, 64, 14, 64, 15, 64, 16, 64, 17, 96,  0, 96,  1, 96, 14,
 96, 15, 96, 16, 96, 17, 17, 93,  1, 46,  1, 35, 34,  6,  7,  3,
 33, 19, 33,  7, 62,  1, 51, 50, 22, 23,  4, 29, 37, 90, 52,137,
181, 32,102,254,153,218,  1,104, 39, 71,213,130, 19, 48, 33,  3,
 47, 21, 22,176,166,253,252,  4, 96,192,106,113,  4,  4,  0,  1,
  0, 20,255,227,  4,123,  4,123,  0, 39,  0,175, 64, 57, 13, 12,
  2, 14, 11,  4, 31, 30,  8,  9,  2,  7, 10,  4, 30, 31, 30, 58,
 10, 11, 30, 31,  4,  1, 20,145, 21,152, 24,103, 17,  0,145,  1,
152,  4,103, 37,143, 17, 96, 40, 30, 10, 31, 11, 27,  7,  1,  0,
 27, 44, 14,  7, 42, 34, 40, 16,212,236,212,236,192,192, 17, 18,
 57, 57, 57, 57, 49,  0, 16,228,244,252,244,236, 16,254,245,238,
 18, 23, 57, 48, 75, 83, 88,  7, 16, 14,237, 17, 23, 57,  7, 14,
237, 17, 23, 57, 89, 34,  1, 75,176, 10, 84, 75,176, 19, 84, 91,
 75,176,  9, 84, 91, 88,189,  0, 40,  0, 64,  0,  1,  0, 40,  0,
 40,255,192, 56, 17, 55, 56, 89, 64, 30,105,  9,106, 10,106, 11,
106, 30,106, 31,106, 32,106, 33,  7, 96, 19, 96, 20, 96, 21, 96,
 22,111, 41,118, 20,118, 21,  7, 93,  0, 93,  1,  3, 46,  1, 35,
 34,  6, 21, 20, 22, 31,  1, 30,  1, 21, 20,  4, 33, 34, 38, 39,
 19, 30,  1, 51, 50, 54, 53, 52, 38, 47,  1, 46,  1, 53, 52, 36,
 33, 50, 22,  4,123, 53,105,208, 93,106,115, 64, 94, 65,217,174,
254,206,254,237,115,240,125, 54, 97,221,116,113,114, 64,100, 65,
192,164,  1, 27,  1,  7,115,223,  4, 61,254,234, 50, 52, 55, 51,
 30, 36, 20, 12, 46,145,129,195,219, 36, 36,  1, 25, 57, 58, 54,
 52, 36, 40, 21, 12, 40,156,138,187,202, 31,  0,  0,  1,  0, 88,
  0,  0,  4, 18,  5,158,  0, 25,  0,162, 64, 62, 11, 10,  9,  8,
  7,  6,  6, 12,  5,  5, 20, 25, 20,  4,  5, 25, 20,  1,  5, 25,
 20,  0,  5, 25, 25, 20, 58, 20,  5, 11, 21,  3,105, 23,  1,122,
 11,105,  0, 13, 23, 22, 26, 25, 24, 21, 20, 14, 13, 12, 11,  8,
  5,  4,  3,  1,  0, 14,  2, 17, 17, 26, 16,196, 16,192, 23, 57,
 18, 57, 57, 49,  0, 47,196,236,244, 60,236, 50, 17, 57, 57, 48,
 75, 83, 88,  7, 16,  5,237,  7,  5,237,  7,  5,237,  7, 16,  5,
237, 17, 23, 57, 89, 34,  1, 75,176, 10, 84, 75,176, 11, 84, 91,
 75,176, 19, 84, 91, 75,176, 20, 84, 91, 75,176, 17, 84, 91, 75,
176,  9, 84, 91, 88,189,  0, 26,  0, 64,  0,  1,  0, 26,  0, 26,
255,192, 56, 17, 55, 56, 89,178, 41, 21,  1, 93,  1,  3, 33,  3,
 33,  3, 14,  1, 21, 20, 22, 59,  1,  3, 33, 34, 38, 53, 52, 54,
 55, 19, 35, 19, 51, 19,  2,225, 61,  1,110, 51,254,146, 92,  4,
  3, 61, 72,185, 51,254,211,162,170,  6,  6, 92,176, 49,178, 62,
  5,158,254,194,255,  0,254, 38, 16, 22, 10, 46, 40,255,  0,136,
128, 28, 64, 33,  1,219,  1,  0,  1, 62,  0,  1,  0,123,255,227,
  5,115,  4, 96,  0, 25,  0,220, 64, 77, 19, 18,  2, 20, 17,  5,
 15, 14, 16,  5, 15, 15, 14, 13,  5, 14, 15, 14, 10, 11,  2, 12,
  5, 15, 15, 14,  8,  7,  6,  5,  4,  5,  9,  3,  5,  0,  1,  0,
  2,  5,  1,  1,  0, 58, 12,  3,  1, 17, 15,  0,  1,  9,159, 20,
 96, 13,  1,122, 15,  0, 23, 16, 13, 12,  6,  3,  2,  6, 17,  1,
 15, 38, 14,  1, 37, 23, 26, 16,212,236,212,228, 17, 57, 23, 57,
 18, 57, 49,  0, 47,228, 50,244,236, 17, 57, 17, 57, 17, 57, 57,
 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237, 17, 23, 57,  7,
 16,  5,237, 23, 57,  7, 16,  5,237,  7, 16,  5,237,  7,  5,237,
 17, 23, 57, 89, 34,  1, 75,176,  9, 84, 75,176, 10, 84, 91, 75,
176, 11, 84, 91, 75,176, 12, 84, 91, 75,176, 13, 84, 91, 75,176,
 14, 84, 91, 75,176, 16, 84, 91, 75,176, 15, 84, 91, 75,176, 17,
 84, 91, 75,176, 18, 84, 91, 75,176, 19, 84, 91, 88,189,  0, 26,
  0, 64,  0,  1,  0, 26,  0, 26,255,192, 56, 17, 55, 56, 89,178,
 48, 27,  1, 93, 27,  1, 33,  3, 14,  1, 21, 20, 22, 51, 50, 54,
 55, 19, 33,  3, 33, 55, 14,  1, 35, 34, 38, 53, 52, 54,139,131,
  1,103,113, 12, 12, 70, 65,111,160, 30,108,  1,103,217,254,151,
 33, 92,202,112,153,168,  8,  1,180,  2,172,253,185, 57, 80, 23,
 63, 70,172,153,  2, 39,251,160,164, 97, 96,162,148, 35, 78,  0,
  0,  1,  0,129,  0,  0,  5,109,  4, 96,  0,  6,  0,162, 64, 38,
  3,  4,  4,  5,  4,  2,  4,  1,  2,  5,  5,  4,  2,  4,  3,  2,
  6,  0,  6,  1,  4,  0,  0,  6, 58,  2,  3,  0,122,  5,  6,  3,
  2,  1,  4,  4,  0,  7, 16,212,204, 23, 57, 49,  0, 47,228, 50,
 57, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  8,237,  7, 16,  8,
237,  7, 16,  5,237, 89, 34,  1, 75,176, 13, 84, 75,176, 14, 84,
 91, 75,176, 15, 84, 91, 75,176, 16, 84, 91, 75,176, 17, 84, 91,
 75,176, 19, 84, 91, 75,176,  9, 84, 91, 75,176, 10, 84, 91, 75,
176, 11, 84, 91, 88,189,  0,  7,  0, 64,  0,  1,  0,  7,  0,  7,
255,192, 56, 17, 55, 56, 89, 64, 20,128,  2,128,  2,  2, 70,  5,
 86,  5,102,  0,102,  1,106,  6,137,  3,137,  6,  7, 93,  0, 93,
 19, 33, 19,  1, 33,  1, 33,129,  1, 74,145,  1,166,  1,107,253,
110,254,133,  4, 96,252,242,  3, 14,251,160,  0,  0,  1,  0,178,
  0,  0,  7,106,  4, 96,  0, 12,  0,208, 64, 70,  5,  6,  5,  9,
 10,  9,  4, 10, 10,  9, 11,  2,  3,  2, 10,  9, 10,  3,  3,  2,
  6,  4,  7,  8,  7,  5,  4,  4,  5,  8,  8,  7,  2,  4,  3,  2,
 12,  0, 12,  1,  4,  0,  0, 12, 58, 10,  5,  2,  3,  6,  3,  0,
122, 11,  8, 12, 11, 10,  9,  8,  6,  5,  4,  3,  2,  1, 11,  7,
  0, 13, 16,212,204, 23, 57, 49,  0, 47, 60,228, 50, 50, 23, 57,
 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  8,237,  7, 16,  8,237,
  7, 16,  5,237,  7, 16,  8,201,  7, 16,  5,201,  7, 16,  5,201,
  7, 16,  8,201, 89, 34,  1, 75,176, 15, 84, 75,176, 18, 84, 91,
 75,176, 19, 84, 91, 75,176,  9, 84, 91, 88,189,  0, 13,  0, 64,
  0,  1,  0, 13,  0, 13,255,192, 56, 17, 55, 56, 89, 64, 40,  3,
  5, 16,  5, 73,  5,  3, 10,  5, 11,  6,  9,  9, 15, 14, 27,  6,
 37,  8, 37, 11, 71,  5, 72,  6, 70, 11, 87, 12,102,  4,104, 12,
120,  3,116,  8,121, 11, 16, 93,  0, 93, 19, 33, 19,  1, 33, 19,
  1, 33,  1, 33,  3,  1, 33,178,  1, 74, 39,  1, 82,  1, 28, 41,
  1, 80,  1, 96,254,  0,254,132, 37,254,170,254,141,  4, 96,252,
254,  3,  2,253,  0,  3,  0,251,160,  3,  2,252,254,  0,  0,  1,
255,172,  0,  0,  5, 94,  4, 96,  0, 11,  0,255, 64, 73,  9,  4,
 10,  9,  6,  7,  6,  8,  4,  7,  7,  6,  6,  4,  7,  6,  3,  4,
  3,  5,  4,  4,  4,  3,  3,  4,  4,  3,  0,  1,  0,  2,  4,  1,
  1,  0, 10,  4, 11,  0, 11,  9,  4,  8,  9,  0,  0, 11, 58,  9,
  6,  3,  0,  4,  4,  1,122, 10,  7,  9,  8,  7,  6,  3,  2,  1,
  0,  8, 12,  5, 11, 11, 12, 16,204, 16,192, 17, 23, 57, 49,  0,
 47, 60,228, 50, 23, 57, 48, 75, 83, 88,  7, 16,  8,237,  7, 16,
  5,237,  7, 16,  5,237,  7, 16,  8,237,  7, 16,  5,237,  7, 16,
  8,237,  7, 16,  5,237,  7, 16,  8,237, 89, 34,  1, 75,176, 15,
 84, 75,176, 17, 84, 91, 75,176, 19, 84, 91, 75,176,  9, 84, 91,
 75,176, 11, 84, 91, 88,189,  0, 12,  0, 64,  0,  1,  0, 12,  0,
 12,255,192, 56, 17, 55, 56, 89, 64, 78,  5,  3, 15,  9, 31,  9,
 40,  0, 37,  3, 41,  6, 43,  9, 49,  3, 71,  3, 74,  9,128,  3,
143,  9, 12, 10,  7, 10,  8, 23,  4, 21,  5, 21,  6, 40,  0, 40,
  4, 39,  6, 41,  7, 43,  8, 42, 11, 54,  0, 53,  3, 71,  0, 69,
  1, 71,  4, 70,  6, 71,  9, 71, 10, 71, 11,107,  5, 99,  8,104,
  9,105, 10,143,  4,128, 10, 26, 93,  0, 93,  9,  1, 33, 19,  1,
 33,  9,  1, 33,  3,  1, 33,  1,197,254,215,  1,116,166,  1, 35,
  1,133,254,  2,  1, 56,254,139,176,254,190,254,123,  2, 61,  2,
 35,254,180,  1, 76,253,223,253,193,  1, 98,254,158,  0,  0,  1,
  0,  0,254, 70,  5,127,  4, 96,  0, 15,  0,199, 64, 67, 15,  4,
  0, 15,  5,  4, 11, 12, 13,  3, 14,  4,  5,  5,  4,  3,  4,  4,
  5,  4,  2,  4,  1,  2,  5,  5,  4,  2,  4,  3,  2, 15,  0, 15,
  1,  4,  0,  0, 15, 58, 14, 10,  2, 16,  5,  0, 10,103,  8,158,
  3,  0,122, 16, 15, 14, 11, 10,  8,  5,  3,  2,  1,  0, 10,  4,
  9, 47,204, 23, 57, 49,  0, 16,228, 50,244,236, 17, 57, 18, 57,
 17, 57, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  8,237,  7, 16,
  8,237,  7, 16,  5,237,  7, 16,  5,237, 23, 57,  7,  8,237, 89,
 34,  1, 75,176, 13, 84, 75,176, 14, 84, 91, 75,176, 15, 84, 91,
 75,176, 16, 84, 91, 75,176, 17, 84, 91, 75,176, 19, 84, 91, 75,
176, 10, 84, 91, 75,176, 11, 84, 91, 88,189,  0, 16,  0, 64,  0,
  1,  0, 16,  0, 16,255,192, 56, 17, 55, 56, 89, 64, 18,  0,  2,
  0,  2,  7, 14,  3, 10,  3, 15, 11, 10, 14, 10, 15, 72, 15,  5,
 93,  0, 93, 19, 33, 19,  1, 33,  1, 14,  1, 43,  1, 55, 51, 50,
 54, 63,  1,135,  1, 82,154,  1,141,  1,127,253, 59,119,202,160,
217, 37,113, 88, 97, 38, 33,  4, 96,252,248,  3,  8,251, 54,207,
129,235, 59, 74, 60,  0,  0,  1,255,238,  0,  0,  4,176,  4, 96,
  0,  9,  0,120, 64, 29,  3, 44,  7,  8,  7,  8, 44,  2,  3,  2,
 58,  8,105,  0,122,  3,105,  5,  9,  8,  5,  4,  3,  0,  6, 10,
  1,  6, 10, 16,212,204, 17, 23, 57, 49,  0, 47,236,244,236, 48,
 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237, 89, 34,  1, 75,176,
 15, 84, 75,176, 16, 84, 91, 75,176, 17, 84, 91, 75,176, 18, 84,
 91, 75,176, 19, 84, 91, 88,189,  0, 10,  0, 64,  0,  1,  0, 10,
  0, 10,255,192, 56, 17, 55, 56, 89, 64, 14, 41,  2, 38,  7,  2,
  4,  3, 15,  8, 26,  8, 47, 11,  4, 93,  0, 93, 19, 33,  7,  1,
 33,  3, 33, 55,  1, 33,223,  3,209, 49,253, 70,  2, 67, 49,252,
 23, 47,  2,188,253,213,  4, 96,250,253,154,255,  0,250,  2,102,
  0,  1,  0,217,254,178,  5, 90,  6, 20,  0, 48,  0,179, 64,103,
 48, 47, 46, 45, 44, 43,  6,  0, 42,  5,  9,  8, 36, 37, 38, 39,
 40,  5, 41,  5,  9,  9,  8, 34, 33,  2, 35, 32,  5, 21, 22, 21,
 27, 28, 29, 30,  4, 26, 31,  5, 22, 22, 21, 58, 31, 21, 27, 17,
  9, 49, 15, 32, 22, 27, 35, 17,  8, 41, 42,  3,  0, 15,137, 17,
  0,137,  1, 27,137, 25,107, 49, 17, 16, 49,  5, 27, 26, 48, 45,
 42, 41, 38, 35, 32,  9,  8,  2,  1, 11,  5, 25, 28, 26, 12, 21,
 22, 31,  4,  0, 26,  5, 49, 16,212,196,196, 23, 57, 17, 57, 57,
 17, 23, 57, 17, 57, 17, 18, 57, 57, 49,  0, 16,252,236,212,236,
212,236, 17, 23, 57, 17, 57, 18, 57, 57, 17, 18, 57, 17, 18, 57,
 57, 48, 75, 83, 88,  7, 16,  5,237, 17, 23, 57,  7, 16,  5,237,
 17, 23, 57,  7, 16,  5,237, 23, 57,  7,  5,237, 17, 23, 57, 89,
 34,  5,  7, 35, 34, 38, 53, 52, 54, 55, 55, 54, 54, 53, 52, 38,
 35, 35, 55, 51, 50, 54, 55, 55, 54, 54, 51, 51,  7, 35, 34,  6,
  7,  7,  6,  6,  7, 22, 22, 21, 20,  6,  7,  7,  6,  6, 21, 20,
 22, 51,  4, 23, 43,218,179,181,  7,  7, 37,  6,  6, 91,117, 64,
 45, 62,141,131, 29, 39, 37,233,219,217, 43, 70,139,103, 28, 33,
 30,118,114, 80, 74,  8,  9, 32,  9,  6, 81,116,109,225,123,123,
 22, 60, 40,193, 30, 55, 22, 88, 72,223,116,150,205,193,175,225,
 87,142,166,156,143, 25, 21, 90, 77, 30, 67, 40,166, 46, 48, 17,
 67, 52,  0,  1,  1,  4,254, 29,  1,231,  6, 29,  0,  3,  0, 17,
182,  1,  0,  4,  0,  7,  2,  4, 16,212,236, 49,  0, 16,212,204,
 48,  1, 17, 35, 17,  1,231,227,  6, 29,248,  0,  8,  0,  0,  1,
  0, 90,254,178,  4,217,  6, 20,  0, 48,  0,188, 64,108,  7,  6,
  2,  8,  5,  5, 43, 44, 43,  0,  1,  2,  3,  4, 48,  4,  5, 44,
 44, 43, 22, 21, 20, 19, 18, 17, 16,  7, 23, 15,  5, 31, 30,  9,
 10, 11, 12, 13,  5,  8, 14,  5, 31, 31, 30, 58, 43, 49, 39, 31,
 15, 21,  8, 39, 14, 30, 37, 21,  4,  5, 44,  3,  0, 39,137, 37,
  0,137, 47, 21,137, 23,107, 49, 39, 38, 27,  0, 48, 31, 30, 24,
 23, 21, 18, 15, 14, 11,  8,  5, 11, 27, 47,  1, 48,  4, 43, 34,
 44,  4, 22, 37, 40, 38, 48, 22, 27, 49, 16,212,196,196,192,192,
192, 18, 23, 57, 17, 57, 57, 17, 23, 57, 17, 57, 17, 18, 57, 49,
  0, 16,252,236,212,236,212,236, 17, 23, 57, 17, 18, 57, 57, 17,
 57, 17, 57, 57, 17, 18, 57, 48, 75, 83, 88,  7, 16,  5,237, 17,
 23, 57,  7,  5,237, 17, 23, 57,  7, 16,  5,237, 17, 23, 57,  7,
 16,  5,237, 17, 23, 57, 89, 34, 23, 51, 50, 54, 55, 55, 54, 54,
 55, 38, 38, 53, 52, 54, 55, 55, 54, 54, 53, 52, 38, 35, 35, 55,
 51, 50, 22, 21, 20,  6,  7,  7,  6,  6, 21, 20, 22, 51, 51,  7,
 35, 34,  6,  7,  7,  6,  6, 35, 35,133, 70,140,103, 27, 33, 30,
119,115, 80, 76,  9,  8, 33,  8,  6, 81,116, 67, 43,219,179,179,
  7,  7, 39,  6,  6, 93,116, 63, 45, 61,141,131, 29, 37, 37,234,
219,217,109, 89,141,166,155,144, 26, 19, 90, 78, 24, 68, 45,166,
 42, 50, 18, 68, 51,225,122,123, 28, 61, 34,205, 30, 54, 22, 88,
 72,223,117,150,192,193,176,  0,  0,  1,  0,217,  1,178,  5,219,
  3, 82,  0, 29,  0, 35, 64, 16,  1, 16, 27, 12,  0, 19,  4,111,
 27, 12,111, 19, 30,  0, 15, 30, 16,212,196, 49,  0, 16,212,236,
220,236, 16,192, 17, 18, 57, 57, 48,  1, 21,  6,  6, 35, 34, 39,
 38, 39, 38, 39, 38, 35, 34,  6,  7, 53, 54, 54, 51, 50, 23, 22,
 23, 22, 23, 22, 51, 50, 54,  5,219,106,179, 96,107,143, 14,  8,
  7, 15,155, 94, 88,172, 98,107,178, 96,107,143, 15,  7,  7, 15,
155, 94, 86,169,  3, 82,244, 80, 69, 58,  6,  3,  3,  6, 61, 77,
 83,244, 80, 69, 58,  6,  3,  3,  6, 61, 75,  0,255,255,255,123,
  0,  0,  5,135,  7,107,  2, 39,  0, 36,  0,  0,  0,  0,  0,  7,
  1,  3,  1, 68,  1,117,  0,  3,255,123,  0,  0,  5,135,  7,109,
  0, 11,  0, 30,  0, 33,  0,211, 64, 80, 33, 15, 31, 33, 12, 13,
 12, 32, 15, 13, 12, 15, 15, 13, 12, 14, 15, 13, 13, 12, 31, 15,
 18, 19, 18, 33, 15, 32, 33, 19, 19, 18, 17, 15, 19, 18, 16, 15,
 18, 19, 18, 58, 33, 19, 12,  3, 15,117, 31,  9, 25,  3, 87, 31,
 17, 13, 16, 17, 31,  3, 34, 22, 12, 28,  6, 19, 22, 33, 32, 15,
 14,  4,  6,  0, 22,  6, 28, 13, 18, 34, 16,212,212,212,196,212,
196, 17, 23, 57, 17, 57, 17, 18, 57, 17, 18, 23, 57, 49,  0, 47,
 60,196,228,212,196, 16,238, 18, 57, 57, 57, 48, 75, 83, 88,  7,
 16,  5,237,  7,  5,237,  7, 16,  8,237,  7, 16,  5,237,  7, 16,
  5,237,  7,  5,237,  7,  5,237,  7, 16,  8,237, 89, 34,178, 29,
  0,  1,  1, 93, 64, 50,  0,  2,  0,  3,  0,  4, 15, 33, 24, 33,
 31, 33, 45, 33, 57, 33, 63, 33, 89, 33,139, 33,186, 33,191, 33,
 13, 10, 32, 10, 33, 18,  0, 21, 31, 27, 32, 27, 33, 40, 18, 42,
 32, 43, 33,137, 33,185, 33, 11, 93,  0, 93,  1, 20, 22, 51, 50,
 54, 53, 52, 38, 35, 34,  6,  5,  1, 33,  3, 33,  3, 33,  1, 46,
  1, 53, 52, 54, 51, 50, 22, 21, 20,  6,  1, 33,  3,  3, 27, 77,
 54, 54, 77, 78, 53, 54, 77,  1,104,  1,  4,254,146, 43,253,172,
148,254,117,  3, 57, 26, 25,167,118,117,167, 26,253,139,  1,145,
 90,  6, 80, 54, 77, 77, 54, 54, 77, 77,214,250, 80,  1, 16,254,
240,  5,178, 37, 77, 44,117,168,168,117, 48, 77,252, 76,  2, 63,
255,255,  0, 74,254,111,  5,203,  5,240,  2, 39,  0, 38,  0,  0,
  0,  0,  0,  7,  0,221,  1,150,  0,  0,255,255,  0, 43,  0,  0,
  5, 92,  7,107,  2, 39,  0, 40,  0,  0,  0,  0,  0,  7,  1,  4,
  1, 27,  1,117,255,255,  0, 43,  0,  0,  6,135,  7,109,  2, 39,
  0, 49,  0,  0,  0,  0,  0,  7,  1,  5,  1,117,  1,117,255,255,
  0, 74,255,227,  6,131,  7,107,  2, 39,  0, 50,  0,  0,  0,  0,
  0,  7,  1,  3,  1,188,  1,117,255,255,  0,139,255,227,  6, 84,
  7,107,  2, 39,  0, 56,  0,  0,  0,  0,  0,  7,  1,  3,  1,109,
  1,117,255,255,  0, 35,255,227,  5,  4,  6,102,  2, 39,  0, 68,
  0,  0,  0,  0,  0,  7,  0,141,  0,180,  0,  0,255,255,  0, 35,
255,227,  4,227,  6,102,  2, 39,  0, 68,  0,  0,  0,  0,  0,  7,
  0, 67,  0,180,  0,  0,255,255,  0, 35,255,227,  4,227,  6,102,
  2, 39,  0, 68,  0,  0,  0,  0,  0,  7,  0,215,  0,180,  0,  0,
255,255,  0, 35,255,227,  4,227,  6, 49,  2, 39,  0, 68,  0,  0,
  0,  0,  0,  7,  0,142,  0,180,  0,  0,255,255,  0, 35,255,227,
  4,227,  6, 57,  2, 39,  0, 68,  0,  0,  0,  0,  0,  7,  0,216,
  0,180,  0,  0,255,255,  0, 35,255,227,  4,227,  7, 16,  2, 39,
  0, 68,  0,  0,  0,  0,  0,  7,  0,220,  0,180,  0,  0,255,255,
  0, 76,254,111,  4,166,  4,123,  2, 39,  0, 70,  0,  0,  0,  0,
  0,  7,  0,221,  0,231,  0,  0,255,255,  0, 74,255,227,  5, 51,
  6,102,  2, 39,  0, 72,  0,  0,  0,  0,  0,  7,  0,141,  0,227,
  0,  0,255,255,  0, 74,255,227,  5, 31,  6,102,  2, 39,  0, 72,
  0,  0,  0,  0,  0,  7,  0, 67,  0,227,  0,  0,255,255,  0, 74,
255,227,  5, 31,  6,102,  2, 39,  0, 72,  0,  0,  0,  0,  0,  7,
  0,215,  0,227,  0,  0,255,255,  0, 74,255,227,  5, 31,  6, 49,
  2, 39,  0, 72,  0,  0,  0,  0,  0,  7,  0,142,  0,227,  0,  0,
255,255,  0, 63,  0,  0,  3,195,  6,102,  2, 39,  0,214,  0,  0,
  0,  0,  0,  7,  0,141,255,115,  0,  0,255,255,  0, 63,  0,  0,
  2,129,  6,102,  2, 39,  0,214,  0,  0,  0,  0,  0,  7,  0, 67,
255,115,  0,  0,255,255,  0, 63,  0,  0,  3, 80,  6,102,  2, 39,
  0,214,  0,  0,  0,  0,  0,  7,  0,215,255,115,  0,  0,255,255,
  0, 63,  0,  0,  3, 82,  6, 49,  2, 39,  0,214,  0,  0,  0,  0,
  0,  7,  0,142,255,115,  0,  0,255,255,  0, 63,  0,  0,  5, 59,
  6, 57,  2, 39,  0, 81,  0,  0,  0,  0,  0,  7,  0,216,  0,217,
  0,  0,255,255,  0, 74,255,227,  5, 53,  6,102,  2, 39,  0, 82,
  0,  0,  0,  0,  0,  7,  0,141,  0,193,  0,  0,255,255,  0, 74,
255,227,  5, 53,  6,102,  2, 39,  0, 82,  0,  0,  0,  0,  0,  7,
  0, 67,  0,193,  0,  0,255,255,  0, 74,255,227,  5, 53,  6,102,
  2, 39,  0, 82,  0,  0,  0,  0,  0,  7,  0,215,  0,193,  0,  0,
255,255,  0, 74,255,227,  5, 53,  6, 49,  2, 39,  0, 82,  0,  0,
  0,  0,  0,  7,  0,142,  0,193,  0,  0,255,255,  0, 74,255,227,
  5, 53,  6, 57,  2, 39,  0, 82,  0,  0,  0,  0,  0,  7,  0,216,
  0,193,  0,  0,255,255,  0,123,255,227,  5,115,  6,102,  2, 39,
  0, 88,  0,  0,  0,  0,  0,  7,  0,141,  0,217,  0,  0,255,255,
  0,123,255,227,  5,115,  6,102,  2, 39,  0, 88,  0,  0,  0,  0,
  0,  7,  0, 67,  0,217,  0,  0,255,255,  0,123,255,227,  5,115,
  6,102,  2, 39,  0, 88,  0,  0,  0,  0,  0,  7,  0,215,  0,217,
  0,  0,255,255,  0,123,255,227,  5,115,  6, 49,  2, 39,  0, 88,
  0,  0,  0,  0,  0,  7,  0,142,  0,217,  0,  0,  0,  1,  0, 78,
255, 59,  4,  8,  5,213,  0, 11,  0, 91, 64, 48,  6,  4,  7,  0,
  7,  5,  4,  0,  7,  2,  4,  0,  7,  1,  4,  0,  0,  7, 58,  8,
  4,165,  2,  6,163,  0, 83, 10,  2,164, 12,  9, 10, 12,  7, 11,
  6,  5,  4,  2,  1,  0,  7,  3,  8,  8,  7, 12, 16,212,196, 16,
192, 23, 57, 17, 18, 57, 57, 49,  0, 16,228, 50,244,236, 16,238,
 50, 48, 75, 83, 88,  7, 16,  5,237,  7,  5,237,  7,  5,237,  7,
 16,  5,237, 89, 34,  1, 33,  3, 33,  7, 33,  3, 33, 19, 33, 55,
 33,  1,231,  1, 74, 74,  1, 33, 45,254,223,209,254,183,207,254,
223, 45,  1, 35,  5,213,254,131,238,251,209,  4, 47,238,  0,  2,
  0,178,  3,100,  3, 76,  5,254,  0, 11,  0, 29,  0, 31, 64, 16,
  6,166, 24,167,  0,166, 12, 30,  9, 45, 18, 46,  3, 45, 27, 30,
 16,212,236,252,236, 49,  0, 16,212,236,252,236, 48,  1, 34,  6,
 21, 20, 22, 51, 50, 54, 53, 52, 38, 39, 50, 22, 23, 22, 22, 21,
 20,  6,  7,  6,  6, 35, 34, 38, 53, 52, 54,  2,  0, 72,100, 99,
 73, 72,100,101, 71, 66,122, 48, 47, 49, 49, 45, 48,124, 68,141,
191,193,  5, 92,100, 72, 72, 98, 99, 71, 72,100,162, 51, 47, 48,
120, 68, 67,121, 45, 48, 51,191,141,141,193,  0,  0,  2,  0,137,
254,199,  4,225,  5,152,  0,  6,  0, 34,  0, 97, 64, 56, 23, 20,
 17,  6, 16, 13,  0, 11,  8, 29, 32,  7,145,  8,152, 11, 17,145,
 16,152, 13,105, 21, 20, 30, 11,105, 32,143, 20, 35, 22, 26, 32,
 31, 30, 21, 20, 17, 16, 13, 12, 11,  8,  6,  0, 13,  7, 23, 29,
  7,  3,  3, 19, 26, 35, 16,212,236, 16,192,192,192, 18, 23, 57,
 18, 57, 49,  0, 16,196,244,236,196, 16,198,252,244,238, 16,245,
238, 17, 57, 17, 18, 57, 17, 18, 57, 17, 18, 57, 48,  1,  6,  6,
 21, 20, 22, 23,  1,  3, 38, 38, 35, 35,  3, 54, 54, 55,  3,  6,
  6,  7,  3, 35, 19, 38, 38, 53, 16,  0, 37, 19, 51,  3, 22, 22,
  2,229,102,123, 57, 52,  2,112, 57, 75,135, 64,  9,128, 89,159,
 71, 56, 72,156, 85, 55,162, 55,201,231,  1,108,  1, 40, 55,162,
 55, 68,146,  3, 88, 46,209,128, 74,109, 26,  3, 53,254,220, 50,
 48,253,104,  2, 49, 48,254,219, 25, 30,  5,254,226,  1, 34, 22,
233,182,  1, 35,  1,146, 34,  1, 35,254,225,  2, 30,  0,  0,  1,
  0, 14,  0,  0,  5,135,  5,240,  0, 27,  0,125, 64, 69, 12, 18,
 17, 22, 17, 11, 18, 22, 17,  8, 18, 22, 17,  5,  6,  2,  4,  7,
 18, 22, 22, 17, 58, 22,  7,  8,  0, 94,  1, 93,  4, 18, 10,103,
  8,  4,115, 25,100, 16, 12,115, 20,  8, 14, 16, 20, 19, 15,  4,
 28, 21, 18, 17, 14, 13, 12, 11, 10,  9,  8,  7,  1,  9,  0, 22,
 22, 17, 28, 16,212,196, 16,192, 23, 57, 18, 57, 57, 17, 23, 57,
 49,  0, 47,196, 50,236, 50,244,236, 16,238, 50, 16,245,238, 18,
 57, 57, 48, 75, 83, 88,  7, 16,  5,237, 17, 23, 57,  7,  5,237,
  7,  5,237,  7, 16,  5,237, 89, 34,  1,  3, 38, 38, 35, 34,  6,
  7,  7, 33,  7, 33,  3, 33,  3, 33, 19, 51, 19, 35, 55, 51, 55,
 18, 36, 33, 50, 22,  5,135, 55, 59,140, 71,125,140, 26, 33,  1,
117, 45,254,137, 64,  2, 29, 51,251,149, 52,225, 63,192, 45,194,
 33, 52,  1, 46,  1, 19, 92,176,  5,186,254,226, 37, 40,123,133,
170,239,254,186,254,246,  1, 10,  1, 70,239,170,  1, 14,249, 27,
  0,  2,255,188,255, 61,  3,244,  5,240,  0, 51,  0, 63,  0,130,
 64, 70, 26, 64, 23,  0, 49,  4, 58, 52, 37, 11,  4, 10, 17, 36,
 43,  4, 27,  1,  4, 27, 30,168, 23,  4,168, 49,100, 23, 64, 36,
 55, 33, 10, 61,  7, 37, 43, 46, 52, 55, 33,  1, 20, 14, 11, 17,
 58,  3, 61,  7, 27, 26, 40,  0, 14, 33, 49, 20,  7, 49, 46, 20,
 61, 48, 14, 55, 48, 46, 40, 64, 16,212,196,236,212,236,196, 16,
238, 16,238, 16,192, 16,192,192, 17, 18, 23, 57, 17, 18, 57, 17,
 18, 57, 17, 57, 57, 17, 18, 57, 17, 18, 57, 49,  0, 16,196,244,
236, 16,254,197, 16,197, 17, 23, 57, 23, 57, 17, 18, 57, 17, 18,
 57, 48,  1,  7, 38, 38, 35, 34,  6, 21, 20, 22, 23, 23, 22, 22,
 21, 20,  6,  7, 22, 22, 21, 20,  4, 35, 34, 38, 39, 55, 22, 22,
 51, 50, 54, 53, 52, 38, 39, 39, 38, 38, 53, 52, 54, 55, 38, 38,
 53, 52, 36, 51, 50, 22,  1,  6,  6, 21, 20, 22, 23, 54, 54, 53,
 52, 38,  3,244, 43, 90,144, 61, 80, 94, 49, 57, 90,175,128,154,
147, 57, 54,254,230,236, 84,180, 95, 48,102,160, 61, 77, 97, 48,
 79,135,119,112,147,141, 52, 50,  1, 21,221, 83,172,254, 33, 80,
 85, 97,163, 80, 88,114,  5,182,227, 40, 38, 61, 50, 30, 50, 26,
 41, 78,151,111,123,190, 58, 36, 88, 54,162,199, 29, 29,237, 43,
 43, 63, 48, 31, 47, 37, 61, 54,147,102,123,191, 59, 41, 92, 53,
156,201, 29,253,131, 21, 89, 62, 61, 86, 64, 27, 91, 56, 61, 93,
  0,  1,  1, 39,  1,145,  3,246,  4, 96,  0, 23,  0, 18,183, 18,
169,  6, 24, 12, 50,  0, 24, 16,212,236, 49,  0, 16,212,236, 48,
  1, 52, 54, 55, 54, 54, 51, 50, 22, 23, 22, 22, 21, 20,  6,  7,
  6,  6, 35, 34, 38, 39, 38, 38,  1, 39, 53, 51, 53,130, 73, 73,
131, 50, 52, 53, 54, 51, 51,131, 74, 73,130, 51, 50, 54,  2,250,
 74,130, 50, 51, 53, 54, 50, 52,129, 73, 74,131, 51, 51, 54, 54,
 51, 51,131,  0,  0,  1,  0,152,255, 59,  4,211,  5,213,  0, 13,
  0, 99, 64, 46, 10,  9,  2, 11,  8,  5,  6,  5,  7,  6,  6,  5,
  2,  3,  4,  3,  1,  4,  4,  3, 58,  4,  8,  0, 83,  6,  2, 14,
  8,  7, 11,  6,  2,  5,  4,  0,  6,  3,  1,  4,  4,  3,  5,  6,
 11, 14, 16,212,212,196,212,196, 16,192, 17, 18, 57, 17, 18, 57,
 17, 18, 57, 57, 49,  0, 16,196, 50,244,196,204, 48, 75, 83, 88,
  7, 16,  5,201,  7, 16,  5,201,  7, 16,  5,201,  7, 16,  5,201,
 17, 23, 57, 89, 34,  1, 33,  1, 35,  1, 35,  1, 35, 19, 38, 38,
 53, 52,  0,  2,203,  2,  8,254,184,190,  1, 43,189,254,211,188,
164,168,182,  1, 57,  5,213,249,102,  6,  7,249,249,  3, 78, 20,
184,148,215,  1, 21,  0,  0,  1,  0, 63,255,227,  5, 84,  6, 20,
  0, 55,  0,170, 64, 94, 20, 19, 18, 17,  4, 21, 16,  4, 38, 37,
 14,  1, 13, 15,  4, 37, 38, 37, 54,  5, 55,  0, 55, 51, 52,  2,
 50, 53,  5,  0,  0, 55, 58, 53, 44, 38, 17, 10,  5, 18, 37,  9,
  0,  4, 50, 27,103, 28, 31,103, 24, 50,103,  3,107, 24, 96, 54,
 54, 55, 38, 37, 41, 34, 18, 47,  9, 21,  6,  0, 53, 27, 28,  4,
 55, 41, 10, 17, 21, 44, 47, 41, 44, 13, 34, 14, 21, 47, 44, 13,
  6, 55, 13, 56, 16,244,212,196,236,212,236, 16,238, 18, 57, 17,
 57, 57, 17, 18, 23, 57, 17, 18, 57, 17, 57, 17, 18, 57, 57, 17,
 57, 49,  0, 47,228,254,238, 16,254,213,238, 18, 23, 57, 23, 57,
 48, 75, 83, 88,  7, 16,  5,237, 17, 23, 57,  7, 16,  5,237,  7,
 16, 14,237, 17, 23, 57,  7, 14,237, 17, 23, 57, 89, 34,  1, 54,
 36, 33, 50, 22, 21, 20,  6,  7,  7,  6,  6, 21, 20, 23, 22, 23,
 23, 22, 22, 21, 20,  4, 35, 34, 38, 39, 55, 22, 22, 51, 50, 54,
 53, 52, 38, 39, 39, 38, 38, 53, 52, 54, 55, 54, 54, 53, 52, 38,
 35, 34,  6,  7,  3, 33,  1, 23, 42,  1, 53,  1, 17,226,235,  5,
  5, 15,151,178,102,  9,  6, 61, 84, 78,254,234,228, 78,151, 74,
 49, 56,111, 52, 82,100, 46, 77, 61, 67, 60,183,173,  1,  1, 82,
 79,102,117, 21,215,254,153,  4, 90,224,218,176,170, 20, 48, 27,
 73,  5, 93, 72, 55, 72,  6,  4, 43, 59,139, 91,193,239, 25, 24,
244, 27, 28, 76, 61, 40, 65, 55, 43, 47,101, 63,138,198, 49,  6,
 16, 15, 67, 70,107,112,251,180,  0,  4,  1, 27,  0,  0,  6,229,
  5,205,  0, 23,  0, 32,  0, 52,  0, 76,  0, 98, 64, 56, 45, 42,
 43, 39, 26,174, 48, 24,174, 33,171,  0,166, 53,173, 12,166, 50,
 43,171, 65, 39, 42, 44,  3, 36, 48, 45, 24, 27,  4, 30, 25, 43,
 36, 18, 33, 30, 49, 25, 56, 51, 30, 55, 36, 52, 18, 45, 59, 54,
  6, 45, 51, 52, 71, 77, 16,212,236,236,252,236,252,236, 16,238,
 50, 17, 57, 17, 18, 57, 17, 18, 23, 57, 17, 23, 57, 49,  0, 47,
236, 50,238,254,238,252,238,214,238, 57, 18, 57, 57, 48,  1, 34,
  6,  7,  6,  6, 21, 20, 22, 23, 22, 22, 51, 50, 54, 55, 54, 54,
 53, 52, 38, 39, 38, 38,  3, 35, 21, 51, 50, 54, 53, 52, 38, 39,
 50, 22, 21, 20,  6,  7, 22, 22, 23, 23, 35, 39, 38, 38, 35, 35,
 17, 35, 17,  1, 50,  4, 23, 22, 18, 21, 20,  2,  7,  6,  4, 35,
 34, 36, 39, 38,  2, 53, 52, 18, 55, 54, 36,  4,  0,121,208, 87,
 87, 87, 87, 87, 86,209,121,123,206, 87, 87, 87, 87, 87, 88,207,
178, 35, 35, 78, 79, 77, 43,176,174,105, 96, 41, 71, 29,111,229,
107, 38, 58, 29, 12,213,  1, 49,152,  1,  7,109,109,108,108,109,
109,254,249,152,152,254,249,109,109,108,108,109,109,  1,  7,  5,
 51, 87, 87, 87,207,122,121,207, 87, 86, 86, 85, 87, 87,207,121,
122,207, 87, 88, 86,254,217,207, 53, 52, 52, 50,138,119,121, 86,
112, 17, 22, 80, 58,221,213, 78, 65,254,156,  3, 68,  1, 55,110,
109,109,254,250,154,152,254,251,109,109,110,110,109,109,  1,  5,
152,154,  1,  6,109,109,110,  0,  0,  3,  1, 27,  0,  0,  6,229,
  5,205,  0, 25,  0, 49,  0, 73,  0, 72, 64, 40, 14, 17, 10,  0,
 23,  4, 13, 10,175, 17,  1,  4,175, 23,171, 26,166, 50,173, 38,
166, 17,171, 62,  7, 55, 20, 44, 45, 13,  0, 52, 56, 54, 32, 45,
 20, 57, 68, 74, 16,212,236,236,252,236, 50,236, 16,238, 49,  0,
 47,236,238,254,238,252,254,197, 16,254,196, 17, 18, 57, 17, 18,
 57, 48,  1, 21, 38, 38, 35, 34,  6, 21, 20, 22, 51, 50, 54, 55,
 21,  6,  6, 35, 34, 38, 53, 52, 54, 51, 50, 22, 39, 34,  6,  7,
  6,  6, 21, 20, 22, 23, 22, 22, 51, 50, 54, 55, 54, 54, 53, 52,
 38, 39, 38, 38, 39, 50,  4, 23, 22, 18, 21, 20,  2,  7,  6,  4,
 35, 34, 36, 39, 38,  2, 53, 52, 18, 55, 54, 36,  5, 43, 57,111,
 57,113,127,126,114, 64,115, 46, 65,131, 62,211,254,254,211, 69,
128,238,121,208, 87, 87, 87, 87, 87, 86,209,121,123,206, 87, 87,
 87, 87, 87, 88,207,121,152,  1,  7,109,109,108,108,109,109,254,
249,152,152,254,249,109,109,108,108,109,109,  1,  7,  4,102,215,
 37, 35,128,114,115,126, 36, 35,213, 22, 23,234,194,195,233, 21,
183, 87, 87, 87,207,122,121,207, 87, 86, 86, 85, 87, 87,207,121,
122,207, 87, 88, 86,154,110,109,109,254,250,154,152,254,251,109,
109,110,110,109,109,  1,  5,152,154,  1,  6,109,109,110,  0,  2,
  1, 39,  3,147,  6, 82,  5,213,  0, 12,  0, 20,  0,118, 64, 62,
  2,  6,  7,  6,  1,  0,  1,  7,  7,  6,  1,  2,  1,  8,  9,  8,
  0,  9,  9,  8, 58,  1,  7,  9,  6, 14,  0,  7, 16, 10,  4, 18,
 14,174, 13,  2,  0, 83, 21,  8,  7,  2,  1,  0,  5,  9,  5, 19,
 59, 17,  5, 58,  3,  9, 58, 11, 13, 59, 17, 58, 15, 21, 16,212,
236,228,212,236,212,236, 16,228, 17, 18, 23, 57, 49,  0, 16,244,
 60, 60,236, 50,212, 60, 60,196, 17, 18, 57, 57, 17, 57, 48, 75,
 83, 88,  7, 16,  5,201,  7, 16,  8,201,  7, 16,  8,201,  7, 16,
  5,201, 89, 34,  1, 23, 55, 51, 17, 35, 17,  3, 35,  3, 17, 35,
 17, 35, 21, 35, 17, 35, 17, 35, 53,  4,129,119,119,227,170,137,
 76,137,172,113,174,172,172,  5,213,227,227,253,190,  1,181,255,
  0,  1,  0,254, 75,  2, 66,143,254, 77,  1,179,143,  0,  0,  1,
  1,209,  4,238,  4, 80,  6,102,  0,  3,  0, 92,183,  2,139,  0,
138,  4,  1,  3,  4, 16,212,204, 49,  0, 16,244,236, 48,  0, 75,
176,  9, 84, 75,176, 14, 84, 91, 88,189,  0,  4,255,192,  0,  1,
  0,  4,  0,  4,  0, 64, 56, 17, 55, 56, 89,  1, 75,176, 13, 84,
 75,176, 12, 84, 91, 88,189,  0,  4,  0, 64,  0,  1,  0,  4,  0,
  4,255,192, 56, 17, 55, 56, 89, 64, 13, 41,  1, 41,  2, 60,  1,
 60,  2, 76,  1, 76,  2,  6, 93,  1, 33,  1, 35,  3, 43,  1, 37,
254, 74,201,  6,102,254,136,  0,  0,  2,  1, 55,  5, 59,  3,223,
  6, 49,  0,  3,  0,  7,  0,117, 64, 18,  6,  2,  4,  0,  8,  6,
  4,  7,  5,  2,  0,  3,  1,  5,  7,  1,  3,  8, 16,212,220,212,
204, 17, 18, 57, 57, 17, 18, 57, 57, 49,  0, 16,212, 60,204, 50,
 48,  0, 75,176, 11, 84, 75,176, 10, 84, 91, 88,189,  0,  8,  0,
 64,  0,  1,  0,  8,  0,  8,255,192, 56, 17, 55, 56, 89, 64, 42,
 15,  4, 15,  5, 15,  6, 15,  7, 32,  1, 32,  2, 32,  5, 32,  6,
 48,  1, 48,  2, 48,  5, 48,  6, 12, 47,  0, 47,  1, 47,  4, 47,
  5, 63,  0, 63,  1, 63,  4, 63,  5,  8, 93,  1, 93,  1, 51,  7,
 35, 37, 51,  7, 35,  1,102,238, 49,236,  1,189,235, 49,235,  6,
 49,246,246,246,  0,  1,  0,217,255,246,  5,219,  5, 12,  0, 19,
  0, 61, 64, 33, 13, 20, 10,  3,  2,  0, 12,  4,  0,111, 18,  6,
125, 14, 10,111, 16,  8, 20, 18, 14, 13, 12,  8,  4,  3,  2,  8,
  9,  5, 15,  0, 20, 16,212, 60,196, 50, 23, 57, 49,  0, 16,212,
 60,236, 50,252, 60,236, 50, 46, 16,192, 57, 17, 18, 57, 48, 19,
 33, 19, 23,  7, 51, 21, 33,  7, 33, 21, 33,  3, 39, 55, 35, 53,
 33, 55, 33,217,  3, 23,252,149,145,235,254, 94,174,  2, 80,252,
234,252,150,146,236,  1,168,176,253,168,  3,219,  1, 49,125,180,
235,220,237,254,207,127,178,237,220,  0,  0,  2,255, 96,  0,  0,
  8,147,  5,213,  0,  3,  0, 19,  0,158, 64, 77, 12, 18, 15,  3,
 15, 11, 18,  3, 15,  8, 18,  3, 15,  7, 18,  3,  3, 15,  1, 15,
  4, 19,  0, 15,  4,  4, 19, 18, 15,  4, 19, 17, 15, 19,  4, 19,
 58,  0,  6,  4,  8,135, 10, 16,117,  1,  6,135, 10,133,  4, 83,
 12,135,  1, 18, 14, 16, 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,
  3,  2,  1, 14, 20,  5, 19, 19, 20, 16,196, 16,192, 17, 23, 57,
 49,  0, 47, 60,196,236,244,228,236, 16,238, 16,238, 17, 18, 57,
 48, 75, 83, 88,  7, 16,  5,237,  7,  5,237,  7, 16,  5,237,  7,
  5,237,  7, 16,  5,237,  7,  5,237,  7,  5,237,  7, 16,  5,237,
 89, 34,178,  7,  3,  1,  1, 93, 64, 13,  0,  0,  8,  3, 18,  0,
 22,  1, 37,  0, 37,  1,  6, 93,  9,  1, 33, 19,  1, 33,  3, 33,
  3, 33,  3, 33,  3, 33,  3, 33, 19, 33,  3, 33,  3,217,254,137,
  1,121,119,254,180,  5,141, 57,253,115, 53,  2,102, 57,253,153,
 65,  2,161, 55,251,219, 68,254, 20,217,254,127,  4,213,253,158,
  2, 98,  1,  0,254,221,254,234,254,221,254,170,254,221,  1, 94,
254,162,  0,  3,255,160,255,178,  7, 43,  6, 43,  0, 10,  0, 40,
  0, 54,  1, 20, 64, 68, 40, 55, 54, 41, 10,  0,  4, 44, 25, 23,
 20,  3, 38, 35, 11, 44, 26, 20,  3, 39, 35, 24, 20, 44,117, 35,
  3,117, 20,100, 35, 96, 55, 26, 50, 24, 29, 25, 39, 55, 14, 54,
 41,  0, 10,  8,  5, 50, 11, 14,  6, 23, 50, 29, 38, 14,  6, 25,
 29, 40, 50, 27, 29,  6, 27, 14, 13, 55, 16,244,236,212,236, 46,
 16,192, 17, 18, 57, 17, 18, 57, 17, 18, 57, 18, 23, 57, 17, 18,
 57, 17, 18, 57, 17, 57, 49,  0, 16,228,244,236, 16,238, 16,192,
 16,192, 17, 18, 57, 18, 57, 17, 57, 17, 18, 57, 57, 18, 23, 57,
 17, 57, 48, 64,145, 32,  0, 32,  1, 32, 21, 32, 22, 32, 23, 32,
 24, 32, 25, 32, 26, 32, 27, 32, 28, 32, 29, 32, 30, 32, 31, 32,
 32, 32, 33, 32, 46, 32, 47, 32, 48, 32, 49, 32, 50, 32, 51, 32,
 52, 32, 53, 32, 54, 64,  0, 64,  1, 64, 21, 64, 22, 64, 23, 64,
 24, 64, 25, 64, 26, 64, 27, 64, 28, 64, 29, 64, 30, 64, 31, 64,
 32, 64, 33, 64, 46, 64, 47, 64, 48, 64, 49, 64, 50, 64, 51, 64,
 52, 64, 53, 64, 54, 80,  0, 80,  1, 80, 21, 80, 22, 80, 23, 80,
 24, 80, 25, 80, 26, 80, 27, 80, 28, 80, 29, 80, 30, 80, 31, 80,
 32, 80, 33, 80, 46, 80, 47, 80, 48, 80, 49, 80, 50, 80, 51, 80,
 52, 80, 53, 80, 54, 72,  1, 93,  1, 46,  1, 35, 34,  0, 17, 20,
 23, 20, 21,  1, 46,  1, 53, 52, 18, 55, 54, 36, 51, 50, 22, 23,
 37, 23,  5, 30,  1, 21, 20,  2,  7,  6,  4, 35, 34, 38, 39,  7,
 39,  1, 30,  1, 51, 50, 54, 55, 62,  1, 53, 52, 39, 38, 39,  4,
172, 40,122, 82,202,254,243,  4,254,185, 42, 42,110,107,129,  1,
 97,233,148,233, 88,  1,  2,102,254,254, 45, 45,111,106,130,254,
156,231,147,236, 92,252,102,  2,123, 39,122, 78,115,179, 63, 60,
 67,  7,  1,  1,  4,104, 57, 56,254,155,254,240, 22, 52,  3,  3,
254,238, 74,157, 80,183,  1, 68,130,159,155, 78, 78,215,123,213,
 76,162, 85,182,254,188,129,158,156, 82, 82,213,123,  1, 70, 59,
 62, 97, 95, 92,229,116, 25, 53,  8,  4,  0,  3,  0,195,  0,186,
  5,233,  4,  8,  0, 11,  0, 23,  0, 47,  0, 66, 64, 35, 12, 15,
  3, 27,  9,  0, 36, 24,  4, 21, 15, 39, 33, 21,177, 45, 27,178,
 15,177, 33,176, 48, 12,  0, 36, 24, 18,  6, 60, 42, 18, 60, 30,
 48, 16,212,236,212,236, 17, 57, 57, 57, 57, 49,  0, 16,252,236,
252, 60,236, 16,192, 17, 18, 23, 57, 17, 57, 17, 57, 48,  1, 22,
 22, 51, 50, 54, 53, 52, 38, 35, 34,  6,  5, 38, 38, 35, 34,  6,
 21, 20, 22, 51, 50, 54, 23,  6,  6, 35, 34, 38, 53, 52, 54, 51,
 50, 22, 23, 54, 54, 51, 50, 22, 21, 20,  6, 35, 34, 38,  3,188,
 43,118, 73, 90,113,103, 76, 72,119,254,241, 43,116, 75, 90,113,
102, 77, 71,122,169, 68,159, 97,139,198,175,140, 90,153, 99, 71,
158, 95,140,197,175,140, 91,150,  2, 49, 67, 68,101, 79, 77,101,
101, 26, 67, 67,100, 79, 77,101,105, 97,130,126,243,179,188,234,
113,143,132,126,242,180,189,235,110,  0,  0,  2,  0,217,  0,  0,
  5,219,  5,  4,  0, 11,  0, 15,  0, 46, 64, 24,  5,179,  7,  3,
111,  0,179,  9,  1, 12,111, 14, 13,  2, 61,  4,  0, 17, 12,  8,
 61, 10,  6, 16, 16,212, 60,236, 50,252, 60,236, 50, 49,  0, 47,
236,212, 60,236,252, 60,236, 48,  1, 17, 33, 21, 33, 17, 35, 17,
 33, 53, 33, 17,  1, 33, 21, 33,  3,209,  2, 10,253,246,238,253,
246,  2, 10,253,246,  5,  2,250,254,  5,  4,254,158,236,254,158,
  1, 98,236,  1, 98,251,234,238,  0,  2,  0,217,  0,  0,  5,219,
  4,168,  0,  3,  0, 10,  0, 39, 64, 20,  9,  8,  6,  5,  4,  5,
 10,  7,  0,111, 10,180,  1,  5,  6,  4,  0,  8,  2, 11, 16,212,
 60,196, 50, 50, 57, 49,  0, 47,228,252,204, 17, 23, 57, 48, 37,
 21, 33, 53,  1,  5,  5, 21,  1, 53,  1,  5,219,250,254,  5,  2,
252,127,  3,129,250,254,  5,  2,238,238,238,  2,198,209,209,243,
  1, 80,235,  1, 78,  0,  0,  2,  0,217,  0,  0,  5,219,  4,168,
  0,  3,  0, 10,  0, 39, 64, 20, 10,  9,  7,  6,  4,  5,  5,  8,
  0,111,  5,180,  2, 10,  6,  1,  8,  4,  0, 11, 16,212, 60, 60,
196, 50, 57, 49,  0, 47,228,252,196, 17, 23, 57, 48, 55, 33, 21,
 33, 17, 53,  1, 21,  1, 53, 37,217,  5,  2,250,254,  5,  2,250,
254,  3,129,238,238,  3,180,244,254,178,235,254,176,243,209,  0,
  0,  1,  0, 12,  0,  0,  6, 10,  5,213,  0, 24,  0,146, 64, 83,
 16,  5, 17, 22, 17, 15,  5, 14, 15, 22, 22, 17, 15,  5, 16, 15,
  8, 13,  8, 14,  5, 13, 13,  8,  2,  5,  3,  8,  3,  1,  5,  8,
  8,  3, 58, 15, 13, 11,  4,  0,181, 23,  6, 20,  9,181, 18, 11,
 16, 13, 83,  2, 24, 23, 20, 19, 18, 15, 14,  2,  1,  0, 10, 17,
  8, 13,  5, 11, 10,  6,  5, 25, 12,  9,  7,  4,  4,  3, 17,  8,
  8,  3, 25, 16,212,196, 16,192, 18, 23, 57, 17, 23, 57, 17, 18,
 23, 57, 49,  0, 47,228, 50,212, 60,252, 60,212, 60,236, 50, 17,
 18, 57, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237,  7, 16,
  5,237,  7, 16,  8,237,  7, 16,  8,237,  7, 16,  5,237, 89, 34,
  1, 33,  3, 33, 19, 33, 55, 33, 55, 39, 33, 55, 33,  3, 33, 19,
  1, 33,  1, 33,  7, 33,  7,  7, 33,  5, 14,254, 58, 82,254,131,
 82,254, 65, 39,  1,189, 14, 29,254,111, 37,  1, 35,215,  1,112,
195,  1,129,  1,149,254, 72,  1, 37, 37,254,104, 59, 18,  1,198,
  1,160,254, 96,  1,160,194, 76, 76,192,  2, 27,254, 12,  1,244,
253,229,192, 76, 76,  0,  0,  1,255,201,254, 84,  5, 92,  4, 96,
  0, 38,  0,154, 64, 87, 13,  5, 14, 15, 14, 10, 11,  2,  9, 12,
  5, 15, 15, 14, 38,  5,  1,  0, 35, 36,  2, 34, 37,  5,  0,  1,
  0,  8,  7,  6,  5,  4,  5,  9,  3,  5,  1,  0,  2,  5,  1,  1,
  0, 58, 24, 21, 15, 12,  3,  5,  1, 25, 31, 37,  3,  9,159, 34,
 28, 96,  0,162, 13,  1,122, 39, 38, 37, 13, 12,  6,  3,  2,  7,
  1, 24, 25, 14, 18, 31,  1, 15, 14,  1, 32,  0, 39, 16,220,244,
212,196, 17, 57, 57, 17, 57, 57, 17, 23, 57, 49,  0, 16,228, 50,
228,244, 60,236, 23, 57, 17, 23, 57, 48, 75, 83, 88,  7, 16,  5,
237,  7,  5,237, 17, 23, 57,  7, 16,  5,237, 17, 23, 57,  7,  5,
237,  7, 16,  5,237, 17, 23, 57,  7, 16,  5,237, 89, 34,  3,  1,
 33,  3,  6,  6, 21, 20, 22, 51, 50, 54, 55, 19, 33,  3,  6,  6,
 21, 20, 22, 51, 50, 54, 55,  7,  6,  6, 35, 34, 38, 39,  6,  6,
 35, 34, 38, 39,  3, 55,  1, 45,  1,104,127,  4,  4, 86, 82,102,
120, 24,127,  1,104,145,  4,  4, 27, 28, 17, 39, 20, 50, 57, 98,
 45, 88, 99, 20, 62,151, 88, 74, 93, 22, 96,254, 84,  6, 12,253,
117, 21, 40, 17, 73, 78,112,117,  2,139,253, 19, 21, 35, 14, 29,
 28, 11, 11,250, 23, 22, 76, 82, 79, 79, 47, 48,254, 18,  0,  2,
  0, 59,255,231,  4, 31,  5, 82,  0, 29,  0, 41,  0, 56, 64, 26,
  0, 39, 33,  9, 27,  6, 39, 21,  6, 15, 33, 27, 15, 21,183, 42,
 12, 36, 24,  3,  0, 30, 18, 36, 24, 42, 16,212,204,220,204, 57,
 57, 17, 18, 57, 49,  0, 16,228,204,220,204, 16,206, 16,206, 17,
 18, 57, 17, 18, 57, 48,  1, 54, 54, 53, 52, 38, 35, 34,  6, 35,
 34, 38, 53, 52, 54, 51, 50, 18, 17, 16,  0, 35, 34, 38, 53, 52,
 18, 51, 50, 22,  7, 52, 38, 35, 34,  2, 21, 20, 22, 51, 50, 18,
  2,254, 21, 22, 59, 39, 35,194, 83, 48, 64,186,127,210,245,254,
187,255,182,234,239,179,101,139, 19, 73, 68, 96,129, 73, 70, 97,
126,  2,172,113,186, 57, 87,122,186, 67, 50, 69,113,254,190,254,
232,254,168,254, 71,233,183,203,  1, 10, 85,243,114,124,254,239,
210,116,120,  1, 15,  0,  0,  1,  0, 41,254,119,  5,147,  5,193,
  0, 11,  0, 48, 64, 24, 10,  4, 12,  2,  5,185,  7,  2,185,  0,
184,  7, 12, 10,  5,  3,  3,  0,  4,  6,  1,  8,  0, 12, 16,212,
196,220,196,196, 17, 23, 57, 49,  0, 16,196,252,236, 16,238, 17,
 18, 57, 57, 48, 19, 33, 17, 33,  1,  1, 33, 17, 33, 53,  1,  1,
 66,  5, 28,252,146,  2,108,253,146,  3,165,250,150,  2,186,253,
 95,  5,193,254,247,253,123,253, 78,254,246,172,  3,  4,  2,178,
  0,  1,  0,150,254,119,  5,178,  5,193,  0,  7,  0, 30, 64, 15,
  6,  2,187,  4,186,  0,184,  8,  3, 63,  1,  5, 63,  0,  8, 16,
212,236,212,236, 49,  0, 16,252,236,236, 50, 48, 19, 33, 17, 33,
 17, 33, 17, 33,150,  5, 28,254,168,253,148,254,168,  5,193,248,
182,  6, 41,249,215,  0,  0,  1,255,221,  0,  0,  5, 74,  4, 68,
  0, 17,  0, 47, 64, 26, 14, 13,  3,  9,  5,  1,  0,  7,  3, 13,
 10,  9,  8,  7,  6,  5,  4,  3,  2,  1, 11, 18, 17,  0, 14, 18,
 16,212,204, 57, 17, 23, 57, 49,  0, 47, 60,212,204, 50, 50, 17,
 57, 57, 48,  1,  7, 35,  3, 33, 19, 35,  3, 33, 19, 35, 34,  6,
  7,  7, 54, 54, 51,  5, 74, 39,176,154,254,225,152,238,151,254,
225,152, 25, 55, 58, 10,213, 29,188,217,  4, 68,224,252,156,  3,
100,252,156,  3,100, 62, 68,  1,199,156,  0,  1,  0, 51,254,139,
  4,176,  6, 20,  0, 44,  0, 58, 64, 32, 42,  0, 35,190,  0,189,
 29,191, 13,190, 19,189,  7,188, 45, 16, 23, 10, 42, 40, 38,  3,
 32,  4, 10, 64, 23, 65, 32, 64,  4, 45, 16,220,236,252,236, 17,
 18, 23, 57, 17, 18, 57, 49,  0, 16,252,236,236,252,236,236, 17,
 57, 48,  5, 50, 19, 54, 55, 18, 18, 51, 50, 22, 21, 20,  6, 35,
 34, 38, 53, 52, 38, 35, 34,  3,  6,  7,  2,  2,  7,  6,  6, 35,
 34, 38, 53, 52, 54, 51, 50, 22, 21, 20,  7, 20, 21, 20, 22,  1,
106, 99, 20,  3,  1, 17,227,236,105,130, 82, 65, 64, 65, 15, 18,
101, 23,  2,  1, 11, 39, 38, 62,195,132,107,129, 84, 70, 60, 65,
  2, 16,248,  2,155,101, 53,  2, 11,  1,204,106, 84, 64, 79, 77,
 74, 38, 22,253,101, 60, 31,254,183,254,225,101,166,166,104, 87,
 65, 78, 72, 67, 12, 12,  2,  1, 24, 19,  0,  3,  0, 88,  1,117,
  4, 55,  5,240,  0,  3,  0, 14,  0, 47,  1, 70, 64,111, 34, 33,
 32, 31, 30,  5, 35, 29, 66, 16, 15, 25, 26, 27,  3, 24, 28, 66,
 16, 15,  6,  5,  4,  3,  7, 14, 66, 16, 15, 11, 12,  2, 10, 13,
 66, 15, 16, 15, 20, 19,  2, 21, 18, 66, 16, 15, 17, 66, 16, 16,
 15, 58, 39, 42, 38, 29, 35, 27, 13,  4, 18, 16, 10, 15,  4, 27,
  2,195,  0,194, 10, 85, 16, 95, 27,193, 21,192, 35,196, 42,100,
 48,  3,  0, 48, 24, 29, 28, 17, 16, 15, 14, 13,  4,  2,  1, 10,
 18, 27, 32,  3, 45, 38, 39,  7, 45,  7, 66, 24, 48, 16,212,236,
196, 18, 57, 57, 17, 23, 57, 23, 57, 17, 18, 57, 57, 49,  0, 16,
244,236,252,228,228,236,252,236, 16,206, 57, 17, 18, 57, 18, 57,
 17, 18, 57, 57, 17, 57, 48, 75, 83, 88,  7, 16,  5,237,  7,  5,
237, 17, 23, 57,  7, 16,  5,237, 17, 23, 57,  7,  5,237, 17, 23,
 57,  7,  5,237, 17, 23, 57,  7,  5,237, 17, 23, 57, 89, 34,178,
  8, 38,  1,  0, 93, 64,120, 79,  4, 64,  5, 64,  6, 64,  7, 64,
  8, 64,  9, 79, 11, 79, 12, 79, 13, 79, 14, 79, 28, 79, 29, 79,
 30, 79, 31, 79, 32, 79, 33, 80,  5, 80,  6, 80,  7, 80,  8, 80,
  9, 95, 11, 95, 12, 95, 13, 95, 28, 95, 29, 95, 30, 95, 31, 95,
 32, 95, 33, 30, 11, 37, 10, 38, 26, 37, 26, 38, 42, 37, 42, 38,
 63,  4, 63,  5, 63, 14, 63, 26, 63, 27, 63, 28, 63, 29, 63, 30,
 63, 31, 58, 37, 60, 38, 75, 37, 75, 38, 89, 37, 89, 38,105, 37,
105, 38,121, 37,121, 38,153, 37,153, 38,169, 37,169, 38, 29, 93,
  1, 93, 19, 33,  7, 33,  1, 34,  6, 21, 20, 22, 51, 50, 54, 63,
  1, 37,  3, 35, 55, 14,  1, 35, 34, 38, 53, 52, 54, 59,  1, 55,
 62,  1, 53, 52, 38, 35, 34,  6,  7, 55, 62,  1, 51, 50, 22, 21,
 20,  6,127,  3, 47, 39,252,209,  2, 92,148,112, 62, 53, 84,130,
 17,  4,  1, 31, 86,248, 25, 66,151,101,125,139,247,243,141,  4,
  1,  1, 77, 76, 88,174, 85, 35, 98,175, 75,186,195,  5,  2, 61,
200,  2,196, 57, 70, 44, 52,113, 88, 22, 84,254, 64,125, 76, 70,
111,100,155,157, 20,  4, 10, 11, 44, 46, 35, 35,180, 28, 28,128,
122, 31, 51,  0,  0,  3,  0, 94,  1,117,  4, 92,  5,240,  0, 11,
  0, 15,  0, 27,  0, 98, 64, 26, 14,195, 12,194, 22,196,  6,192,
 16,196,  0,100, 28, 15, 12, 28,  9, 14, 13, 25, 68,  3, 19, 68,
  9, 28, 16,212,236,212,236, 57, 57, 17, 18, 57, 57, 49,  0, 16,
244,236,252,236,252,236, 48, 64, 44, 64, 18, 64, 19, 64, 20, 79,
 24, 79, 25, 79, 26, 80, 18, 80, 19, 80, 20, 95, 24, 95, 25, 95,
 26, 12, 74, 18, 74, 19, 74, 20, 69, 24, 69, 25, 69, 26, 88, 18,
 88, 19, 88, 20,  9, 93,  1, 93,  1, 50, 22, 21, 20,  0, 35, 34,
 38, 53, 52,  0,  1, 33,  7, 33,  1, 34,  6, 21, 20, 22, 51, 50,
 54, 53, 52, 38,  2,207,183,214,254,217,243,182,218,  1, 42,254,
169,  3, 55, 38,252,200,  2, 88, 99,130, 70, 67, 99,130, 71,  5,
240,181,153,219,254,243,183,151,217,  1, 15,252, 77,200,  3,209,
185,141, 76, 80,184,142, 75, 81,  0,  1,  0, 55,  0,  0,  5,238,
  5,229,  0, 31,  0, 62, 64, 32, 16,  4,  0, 10,203, 26,201, 19,
  0,197, 17,  2, 18, 32, 20, 23, 13,  0,  7,  2,  1,  3, 71,  7,
 70, 29, 16, 71, 13, 70, 23, 32, 16,212,236,236,212,236,236,192,
192, 18, 57, 17, 18, 57, 17, 57, 49,  0, 47, 60,236, 50,252,236,
 17, 57, 57, 48,  1, 33, 17, 33, 17, 54, 18, 53, 52, 38, 35, 34,
  6, 21, 20, 18, 23, 17, 33, 17, 33, 38,  2, 53, 16,  0, 33, 32,
  0, 17, 20,  2,  4,203,  1, 35,253,159,126,132,203,178,177,203,
132,126,253,159,  1, 35,126,122,  1,120,  1, 56,  1, 57,  1,120,
122,  1,  0,255,  0,  1, 35, 86,  1,  7,165,203,233,233,203,164,
254,247, 85,254,221,  1,  0,121,  1, 22,164,  1, 57,  1,121,254,
135,254,199,164,254,234,  0,  3,  0, 35,255,227,  8, 16,  4,123,
  0, 10,  0, 64,  0, 74,  0,212, 64, 84, 55, 64, 53, 17, 61, 11,
 44, 38,  6, 26, 65,  9,  0, 65,156, 27,  0,150, 53, 38,145, 37,
152, 34,  6,103, 53,148, 41, 11,145, 64,144, 71, 61,103, 27,155,
 20, 14,143, 47, 41, 96, 75, 74, 65, 28,  3, 31, 27, 26, 68, 23,
 55, 54, 10,  9,  0,  5,  3, 44, 17, 58, 31, 37, 38, 68, 23, 53,
 58, 64, 11, 50,  3, 31, 58, 68, 14, 23,  3, 14, 50, 75, 16,212,
236,212,236,212,204, 17, 18, 57, 57, 18, 57, 17, 18, 57, 57, 17,
 18, 57, 57, 17, 23, 57, 17, 18, 57, 57, 17, 23, 57, 49,  0, 16,
228, 50,244, 60,228,252, 60,244,236, 16,230,254, 60,244,238, 16,
238, 16,238, 18, 57, 17, 57, 17, 18, 57, 17, 18, 57, 17, 18, 57,
 48, 64, 54, 59, 11, 59, 12, 75, 11, 75, 12, 91, 11, 91, 12,107,
 11,107, 12,157, 11,157, 12,173, 11,173, 12, 12, 50, 63, 48, 64,
 66, 63, 64, 64, 82, 63, 80, 64, 98, 63, 96, 64,146, 63,144, 64,
164, 63,160, 64,180, 63,176, 64, 14, 93,  1, 93,  1, 34,  6, 21,
 20, 22, 51, 50, 54, 63,  1,  1, 62,  1, 51, 50, 22, 23, 62,  1,
 51, 50,  4, 21, 20,  6, 15,  1, 33, 20,  6, 21, 20, 22, 51, 50,
 54, 55,  3,  6,  4, 35, 34, 38, 39, 14,  1, 35, 34, 38, 53, 52,
 36, 33, 51, 55, 62,  1, 53, 52, 38, 35, 34,  6,  7,  5, 62,  1,
 53, 52, 38, 35, 34,  6,  7,  2,162,134,137, 81, 71,110,148, 25,
  8,253,213,117,223,104,149,196, 57, 95,213,130,223,  1, 10, 10,
 10, 14,252,188,  2,131,131,112,249,139, 53,131,254,251,135,173,
236, 66,117,247,138,170,192,  1, 75,  1, 60,205,  6,  3,  1,124,
120,114,207, 94,  5,188,  3,  3, 97, 81,105,149, 37,  1,248, 83,
 81, 61, 70,133,121, 41,  2, 74, 28, 29, 73, 77, 77, 73,244,201,
 45, 92, 47, 57,  6, 23,  6,109,108, 67, 68,254,234, 48, 47,103,
104,105,102,162,141,216,227, 29, 13, 12,  5, 66, 67, 46, 46,135,
 13, 27, 13, 80, 94,116,111,  0,  0,  3,255,221,255,154,  5,154,
  4,199,  0,  6,  0, 36,  0, 43,  0,123, 64, 64, 36, 44, 43, 37,
  6,  0,  4, 40, 21, 19, 16,  3,  7, 34, 40, 31, 22, 16,  3, 35,
 31, 20, 16, 40,105, 31,  3,105, 16,143, 31, 96, 44, 22, 43, 20,
 25, 21, 35, 44, 10, 37,  0, 43,  7, 10,  6, 19, 43, 25, 34, 10,
  6, 21, 25, 36, 43, 33, 25,  6, 33, 10, 13, 44, 16,244,236,212,
236, 46, 16,192, 17, 18, 57, 17, 18, 57, 17, 18, 57, 18, 57, 57,
 17, 18, 57, 17, 18, 57, 17, 57, 49,  0, 16,228,244,236, 16,238,
 16,192, 16,192, 17, 18, 57, 17, 18, 57, 57, 17, 18, 57, 57, 18,
 23, 57, 17, 57, 48,  1, 38, 38, 35, 34,  6,  7,  1, 38, 38, 53,
 52, 54, 55, 54, 36, 51, 50, 22, 23, 55, 23,  7, 22, 22, 21, 20,
  6,  7,  6,  4, 35, 34, 38, 39,  7, 39,  1, 22, 22, 51, 50, 54,
 55,  3,137, 23, 69, 45,140,169, 10,254,215, 39, 39, 91, 87,100,
  1, 21,172,104,172, 68,192, 97,183, 41, 41, 90, 86,101,254,231,
169,109,175, 68,193, 96,  2, 21, 25, 69, 47,141,171,  7,  3, 74,
 24, 25,239,214,254,248, 59,137, 76,126,239,100,117,119, 46, 46,
168,111,162, 59,138, 79,127,239, 99,116,122, 49, 50,172,112,  1,
 17, 28, 28,248,217,  0,  0,  2,  0, 76,255,229,  3,231,  5,213,
  0, 29,  0, 33,  0,135, 64, 77,  0,  5,  2,  1, 23, 24, 25, 26,
 27, 28,  6, 22, 29,  5,  2,  2,  1, 32,  5, 33, 30, 33, 31,  5,
 30, 33, 58, 29, 26,  5,  2,  4,  6, 25, 15,  0, 85, 30, 84, 32,
 16, 89, 15, 93, 12,105, 19, 96, 32, 83, 34, 32, 31,  0,  6,  5,
  2,  1,  7, 30, 25, 22, 16, 29, 30, 26, 22,  9, 30,  0, 33, 15,
  9, 14, 22, 13, 34, 16,244,236,212,212,228, 17, 18, 57, 18, 57,
 57, 18, 57, 18, 23, 57, 49,  0, 16,228,244,252,244,236, 16,254,
237, 17, 57, 57, 23, 57, 48, 75, 83, 88,  7,  5,237,  7, 16,  5,
237,  7, 16,  5,237, 17, 23, 57,  7,  5,237, 89, 34,  1, 33,  7,
  6,  6,  7,  7,  6,  6, 21, 20, 22, 51, 50, 54, 55,  3,  6,  6,
 35, 34, 38, 53, 52, 54, 55, 55, 54, 54, 55, 37, 33, 19, 33,  2,
 29,  1,104, 10, 15, 86,131, 75, 80, 70, 80, 76, 80,203,114, 61,
127,211, 96,195,221,106,127, 76, 83, 56,  8,  1,142,254,151, 70,
  1,104,  3,221, 51, 80,123,102, 60, 61,104, 54, 57, 61, 68, 65,
254,198, 42, 40,171,149,119,188,102, 60, 65, 75, 42,193,  1,100,
  0,  2,  0,141,  0,  0,  3, 25,  5,213,  0,  3,  0,  9,  0, 91,
 64, 47,  4,  5,  5,  6,  5,  7,  8,  2,  6,  9,  5,  6,  6,  5,
  0,  5,  1,  2,  1,  3,  5,  2,  2,  1, 58,  7, 85,  0, 84,  2,
 83,  4,  8,  0,  4,  3,  3,  7,  1,  3,  1,  0,  2,  2,  6,  5,
 10, 16,212,196,244,228,192, 18, 57, 18, 23, 57, 49,  0, 47,244,
252,236, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237,  7, 16,
  5,237, 17, 23, 57,  7, 16,  5,237, 89, 34,  1, 33, 19, 33,  1,
 33, 19, 19, 33,  3,  2,211,254,151, 70,  1,105,254,221,254,151,
113,131,  1,  2, 29,  4,113,  1,100,250, 43,  2, 61,  1,162,254,
 94,  0,  0,  1,  0,217,  1, 31,  5,219,  3,141,  0,  5,  0, 23,
 64, 10,  4,111,  2,  0,  6,  3, 17,  1,  0,  6, 16,212,212,236,
 49,  0, 16,212,196,236, 48, 19, 33, 17, 35, 17, 33,217,  5,  2,
235,251,233,  3,141,253,146,  1,129,  0,  0,  1,  0, 76,255,215,
  5, 90,  6,178,  0, 10,  0,104, 64, 59,  7,  8,  7,  9,  8,  6,
  5,  6,  8,  9,  8,  0,  3,  4,  3, 10,  9, 10,  4,  4,  3, 10,
  0, 10,  5,  6,  5,  9,  8,  9,  6,  6,  5, 58, 10,  9,  8,  7,
  6,  5, 11,  0,205,  2,204,  4, 11, 10,  9,  7,  6,  5,  4,  3,
  0,  8,  1,  8, 11, 16,212,196, 23, 57, 49,  0, 16,196,252,236,
 18, 23, 57, 48, 75, 83, 88,  7, 16,  8,201,  7, 16,  8,201,  7,
 16,  8,201,  7, 16,  5,201,  7, 16,  8,201,  7,  8,201, 89, 34,
  1, 51, 21, 35,  1, 35,  1,  7, 39, 37, 19,  4,131,215, 96,253,
178,119,254,205,145, 37,  1,104,223,  6,178,149,249,186,  3, 78,
 55,129,127,253,133,  0,  0,  1,255,233,254, 86,  5, 74,  6, 20,
  0, 35,  0,139, 64, 78, 32, 31,  2, 33, 30,  5, 12,  7, 29,  5,
 12,  7, 26,  5,  7, 12,  7, 23, 24,  2, 22, 25,  5, 12, 12,  7,
 58, 25, 12, 19, 10,  7, 30,  8,  0, 89,  1, 92,  4, 18, 89, 19,
 92, 22, 26, 10,103,  8, 22,103, 15,  4,103, 33,107, 15, 28,  8,
 36, 30, 29, 28, 27, 26, 25, 19, 11, 10,  9,  8,  7,  1, 13, 36,
 12,  0, 18, 36, 16,212,204, 57, 17, 23, 57, 49,  0, 16,196, 50,
196,252,236, 16,238, 16,238, 50, 16,245,238, 16,245,238, 18, 57,
 57, 17, 18, 57, 57, 48, 75, 83, 88,  7, 16,  5,237, 17, 23, 57,
  7, 16,  5,237,  7,  5,237,  7,  5,237, 17, 23, 57, 89, 34,  1,
  7, 38, 38, 35, 34,  6,  7,  7, 33,  7, 33,  3,  6,  6, 35, 34,
 38, 39, 55, 22, 22, 51, 50, 54, 55, 19, 33, 55, 33, 55, 54, 54,
 51, 50, 22,  5, 74, 49, 40, 68, 38, 90,100, 27, 33,  1, 52, 46,
254,203,135, 42,227,190, 85,143, 63, 48, 40, 74, 35, 90, 99, 28,
117,254,246, 47,  1, 10, 49, 42,229,190, 69,144,  5,240,244, 23,
 20,115,141,168,238,253, 95,207,203, 15, 16,250, 22, 21,112,144,
  2, 77,238,252,206,203, 18,  0,  0,  2,  0,217,  0,225,  5,219,
  4, 35,  0, 29,  0, 59,  0, 67, 64, 33, 46, 31, 57, 42,  1, 16,
 27, 12, 15, 30, 49,  4,  0, 19,  4,111, 27, 12,111, 19, 34,111,
 57, 42,111, 49, 19, 60, 30,  0, 45, 15, 60, 16,212, 60,196, 50,
 49,  0, 16,196,212,236,220,236, 16,238,220,238, 16,192, 17, 18,
 57, 57, 17, 18, 57, 57, 17, 18, 57, 57, 48,  1, 21,  6,  6, 35,
 34, 39, 38, 39, 38, 39, 38, 35, 34,  6,  7, 53, 54, 54, 51, 50,
 23, 22, 23, 22, 23, 22, 51, 50, 54, 19, 21,  6,  6, 35, 34, 39,
 38, 39, 38, 39, 38, 35, 34,  6,  7, 53, 54, 54, 51, 50, 23, 22,
 23, 22, 23, 22, 51, 50, 54,  5,219,106,179, 96,107,143, 14,  8,
  7, 15,155, 94, 88,172, 98,105,179, 97,110,147, 10,  5,  8, 14,
155, 94, 86,169,103,106,179, 96,107,143, 14,  9,  6, 15,155, 94,
 88,172, 98,107,178, 96,107,143, 15,  7,  8, 14,155, 94, 86,169,
  4, 35,244, 80, 69, 58,  6,  3,  3,  6, 61, 77, 83,244, 78, 69,
 59,  4,  2,  3,  6, 61, 75,254,179,244, 80, 69, 58,  6,  4,  2,
  6, 61, 76, 84,244, 80, 69, 58,  6,  3,  3,  5, 62, 75,  0,  2,
  0,  0,  0,  0,  5,147,  5,193,  0,  2,  0,  6,  0, 29, 64, 15,
  0,  3,  1,197,  3,184,  5,  4,  3,  2,  1,  0,  5,  5,  6, 47,
206, 23, 57, 49,  0, 47,238,238, 17, 57, 48,  1,  1, 33,  1, 33,
  1, 33,  2,201,254,186,  2,141,254, 35,  1, 45,  2, 51,250,109,
  4, 86,252,170,  4,193,250, 63,  0,  2,  0,125,  0,137,  4,193,
  4, 39,  0,  6,  0, 13,  0, 52, 64, 28, 12, 10,  9,  5,  3,  2,
  6, 11,  4,  7,  0, 14, 11, 10,  9,  3, 12,  5,  4,  3,  2,  3,
  7,  0,  5,  7, 12, 14, 16,212,196,212,196, 17, 23, 57, 17, 18,
 23, 57, 49,  0, 16,212, 60,204, 50, 23, 57, 48,  1,  7,  5,  5,
  7,  1, 55, 19,  7,  5,  5,  7,  1, 55,  4,193, 50,254,166,  1,
  2, 43,254, 90, 37, 76, 49,254,166,  1,  2, 43,254, 90, 37,  4,
 39,252,229,222,223,  1,113,186,  1,115,252,229,222,223,  1,113,
186,  0,  0,  2,  0,117,  0,135,  4,182,  4, 39,  0,  6,  0, 13,
  0, 52, 64, 27, 10,  9,  3,  2,  4,  7,  0, 11,  4, 14, 11, 10,
  9,  3, 12,  5,  4,  3,  2,  3,  7,  5,  0, 12,  7,  0, 14, 16,
196,212,196, 16,198, 18, 23, 57, 17, 18, 23, 57, 49,  0, 16,212,
 60,204, 50, 23, 57, 48, 55, 55, 37, 37, 55,  1,  7,  3, 55, 37,
 37, 55,  1,  7,117, 49,  1, 88,255,  0, 43,  1,164, 35, 76, 49,
  1, 88,254,254, 45,  1,164, 35,135,254,229,222,223,254,141,186,
254,141,254,229,222,223,254,141,186,  0,  0,  3,  0, 94,  0,  0,
  7,  8,  1,131,  0,  3,  0,  7,  0, 11,  0,121, 64, 61, 10,  5,
 11,  8, 11,  9,  5,  8,  8, 11,  2,  5,  3,  0,  3,  1,  5,  0,
  0,  3,  6,  5,  7,  4,  7,  5,  5,  4,  4,  7, 58,  8,  4,  0,
 84, 10,  6,  2, 10,  9,  8,  6,  5,  4,  3,  2,  1, 11,  0,  9,
  8,  8,  0, 11,  0,  0,  3,  4,  0,  7, 12, 16,212,228,212,228,
212,228, 16,192, 17, 18, 57, 57, 17, 18, 57, 57, 17, 18, 57, 49,
  0, 47, 60, 60,236, 50, 50, 48, 75, 83, 88,  7, 16,  5,237,  7,
 16,  5,237,  7, 16,  5,237,  7, 16,  5,237,  7, 16,  5,237,  7,
 16,  5,237, 89, 34,  1, 33,  3, 33,  1, 33,  3, 33,  1, 33,  3,
 33,  3, 37,  1,104, 75,254,151,253,209,  1,104, 75,254,151,  5,
 66,  1,104, 76,254,152,  1,131,254,125,  1,131,254,125,  1,131,
254,125,255,255,255,123,  0,  0,  5,135,  7,107,  2, 39,  0, 36,
  0,  0,  0,  0,  0,  7,  1,  6,  1, 68,  1,117,255,255,255,123,
  0,  0,  5,135,  7,109,  2, 39,  0, 36,  0,  0,  0,  0,  0,  7,
  1,  5,  1, 68,  1,117,255,255,  0, 74,255,227,  6,131,  7,109,
  2, 39,  0, 50,  0,  0,  0,  0,  0,  7,  1,  5,  1,188,  1,117,
  0,  2,  0, 86,  0,  0,  9, 59,  5,213,  0, 11,  0, 33,  0,128,
 64, 56, 20, 18,  0, 11, 19, 18, 11,  0, 11, 16, 18,  0, 11, 15,
 18,  0,  0, 11, 58, 16,135, 18,133, 14,  0,135, 12, 83, 20, 10,
135, 22, 22, 21, 20, 19, 18, 17, 16, 15, 14, 11, 10,  1,  0, 13,
 13, 24, 33, 13,  7,  7, 27, 27, 13, 34, 16,244,236, 16,192,192,
192, 18, 23, 57, 49,  0, 47,236, 50,244,236, 50,244,236, 48, 75,
 83, 88,  7, 16,  5,237,  7,  5,237,  7, 16,  5,237,  7,  5,237,
 89, 34,178, 15, 22,  1,  1, 93, 64, 21, 15, 13, 15, 14, 15, 21,
  0, 35, 16, 35, 32, 35, 48, 35, 96, 35,112, 35,128, 35, 10, 93,
  1, 35, 34,  6,  7, 14,  1, 21, 20, 22, 59,  1, 19, 33,  3, 33,
  3, 33,  3, 33,  3, 33,  3, 33, 35, 32,  0, 17, 52, 18, 55, 54,
 36, 51,  4,244,105,140,208, 76,113,137,241,255,107,143,  4,104,
 57,253,117, 56,  2,103, 57,253,153, 65,  2,163, 57,251,121, 55,
254,133,254, 96,236,208,128,  1, 59,205,  4,178, 47, 49, 74,250,
135,183,173,  4,178,254,221,254,234,254,221,254,170,254,221,  1,
 46,  1, 17,242,  1,155,122, 73, 70,  0,  0,  3,  0, 74,255,227,
  8,111,  4,123,  0,  9,  0, 51,  0, 63,  0,106, 64, 58, 43, 40,
  6, 28, 22, 18, 10,  0,156, 11, 22,145, 21,152, 18,103, 58,105,
 25, 11,155,  6,103, 52,105, 46, 40,143, 31, 25, 96, 64, 10, 11,
 49, 12,  9,  0,  3,  3, 28, 43, 61, 15, 21, 22, 49,  3, 15, 61,
  3, 14, 49, 55, 33, 34, 13, 64, 16,244,236,212,236,212,204, 17,
 18, 57, 57, 17, 18, 57, 57, 18, 23, 57, 17, 57, 57, 49,  0, 16,
228, 50,244, 60,236,236,228, 16,238,254,244,238, 16,238, 57, 17,
 18, 57, 17, 18, 57, 48,  1, 54, 54, 53, 52, 38, 35, 34,  6,  7,
  5,  7, 33, 20,  6, 21, 20, 22, 51, 50, 54, 55,  3,  6,  4, 35,
 34, 38, 39,  6,  6, 35, 34, 36, 53, 52, 54, 55, 54, 36, 51, 50,
 22, 23, 54, 54, 51, 50,  4, 21, 20,  6,  1, 34,  6, 21, 20, 22,
 51, 50, 54, 53, 52, 38,  7,  6,  3,  3, 96, 82,105,151, 37,  3,
 35, 12,252,186,  2,131,131,112,252,138, 55,131,254,252,136,155,
200, 58, 90,214,137,251,254,225, 91, 85,101,  1, 24,172,140,203,
 64, 94,228,137,223,  1, 11, 12,250,157,139,180, 97, 93,139,180,
 97,  2,170, 13, 27, 13, 80, 94,117,110,164, 57,  6, 23,  6,109,
108, 68, 67,254,234, 48, 47, 78, 82, 82, 78,253,220,127,241, 99,
117,119, 81, 81, 81, 81,244,201, 40, 93,  1, 66,252,195,106,111,
253,196,105,110,  0,  1,255,195,  1,176,  3,246,  2,178,  0,  3,
  0, 27, 64, 12,  2,207,  0,113,  4,  0,  3,  2,  4,  1,  3,  4,
 16,212,204, 17, 57, 18, 57, 49,  0, 16,244,236, 48,  3, 33,  3,
 33, 10,  4,  0, 51,252,  0,  2,178,254,254,  0,  0,  1,255,195,
  1,176,  7,246,  2,178,  0,  3,  0, 27, 64, 12,  2,207,  0,113,
  4,  0,  3,  2,  4,  1,  3,  4, 16,212,204, 17, 57, 18, 57, 49,
  0, 16,244,236, 48,  3, 33,  3, 33, 10,  8,  0, 51,248,  0,  2,
178,254,254,  0,  0,  2,  0,231,  3, 88,  5, 55,  5,213,  0,  5,
  0, 11,  0,102, 64, 52,  4,  3,  2,  5,  2,  5,  5,  0,  5,  1,
  5,  0,  0,  5, 10,  9,  2, 11,  8,  5, 11,  6, 11,  7,  5,  6,
  6, 11, 58,  6,  0,208,  9,  3, 83, 12,  1, 11, 10,  7, 12,  6,
  4,  5,  0,  0, 72, 10, 11,  0,  6, 12, 16,212,228,196,244,244,
196, 17, 18, 57, 17, 18, 57, 49,  0, 16,244, 60,236, 50, 48, 75,
 83, 88,  7, 16,  5,237,  7, 16,  5,237, 17, 23, 57,  7, 16,  5,
237,  7, 16,  5,237, 17, 23, 57, 89, 34,  1, 33, 19,  1, 51,  3,
  1, 33, 19,  1, 51,  3,  4, 88,254,172, 55,  1, 39,213,168,253,
172,254,172, 58,  1, 39,213,170,  3, 88,  1, 29,  1, 96,254,160,
254,227,  1, 29,  1, 96,254,160,  0,  2,  0,150,  3, 88,  4,229,
  5,213,  0,  5,  0, 11,  0, 98, 64, 50,  4,  3,  2,  5,  2,  5,
  5,  0,  5,  1,  5,  0,  0,  5, 10,  9,  2, 11,  8,  5, 11,  6,
 11,  7,  5,  6,  6, 11, 58,  9,  3,208,  6,  0, 83, 12,  7,  5,
  4,  1,  5,  0,  4,  0, 72, 10, 11,  0,  6, 12, 16,212,228,196,
244,196,228,192, 17, 18, 57, 49,  0, 16,244, 60,236, 50, 48, 75,
 83, 88,  7, 16,  5,237,  7, 16,  5,237, 17, 23, 57,  7, 16,  5,
237,  7, 16,  5,237, 17, 23, 57, 89, 34,  1, 33,  3,  1, 35, 19,
  1, 33,  3,  1, 35, 19,  3,145,  1, 84, 55,254,217,213,168,254,
 29,  1, 84, 56,254,215,212,169,  5,213,254,227,254,160,  1, 96,
  1, 29,254,227,254,160,  1, 96,  0,  1,  0,231,  3, 88,  3, 29,
  5,213,  0,  5,  0, 57, 64, 27,  4,  3,  2,  5,  2,  5,  5,  0,
  5,  1,  5,  0,  0,  5, 58,  0,208,  3, 83,  6,  1,  6,  5,  0,
  4,  0,  6, 16,212,196,228, 18, 57, 49,  0, 16,244,236, 48, 75,
 83, 88,  7, 16,  5,237,  7, 16,  5,237, 17, 23, 57, 89, 34,  1,
 33, 19,  1, 51,  3,  2, 59,254,172, 58,  1, 39,213,170,  3, 88,
  1, 29,  1, 96,254,160,  0,  1,  0,150,  3, 88,  2,203,  5,213,
  0,  5,  0, 53, 64, 25,  4,  3,  2,  5,  2,  5,  5,  0,  5,  1,
  5,  0,  5, 58,  3,208,  0, 83,  6,  1,  5,  0,  4,  0,  6, 16,
212,196,228,192, 49,  0, 16,244,236, 48, 75, 83, 88,  7,  5,237,
  7, 16,  5,237, 17, 23, 57, 89, 34,  1, 33,  3,  1, 35, 19,  1,
119,  1, 84, 56,254,215,212,169,  5,213,254,227,254,160,  1, 96,
  0,  3,  0,217,  0, 86,  5,219,  4,174,  0,  3,  0,  7,  0, 11,
  0, 42, 64, 22,  4,209,  6,  2,209,  0, 10,111,  6,  8,110, 12,
  9, 73,  5,  1, 74,  8, 73,  4,  0, 12, 16,212, 60,236,252, 60,
236, 49,  0, 16,244,196,252,212,236, 16,238, 48,  1, 33, 17, 33,
 17, 33, 17, 33,  5, 33, 21, 33,  2,193,  1, 51,254,205,  1, 51,
254,205,254, 24,  5,  2,250,254,  1,139,254,203,  4, 88,254,203,
129,236,  0,  2,  0,  6,254, 35,  3,238,  6,117,  0,  3,  0,  7,
  0,118, 64, 65,  2,  3,  2,  6,  7,  6,  1,  0,  1,  7,  7,  6,
  3,  0,  3,  5,  6,  5,  2,  1,  2,  6,  6,  5,  0,  1,  0,  4,
  5,  4,  3,  2,  3,  5,  5,  4,  1,  2,  1,  7,  4,  7,  0,  3,
  0,  4,  7, 58,  2,  6,  0,  8,  6,  4,  8,  6,  4,  3,  2,  1,
  0,  6,  5,  7,  8, 16,212,196, 23, 57, 49,  0, 16,220,204, 18,
 57, 17, 57, 48, 75, 83, 88,  7,  8,201,  7, 16,  8,201,  7, 16,
  8,201,  7, 16,  8,201,  7, 16,  8,201,  7, 16,  8,201,  7, 16,
  8,201,  7, 16,  8,201, 89, 34,  9,  7,  1,250,254,127,  1,129,
  1,129,254,127,  1,244,254, 12,254, 12,  5,129,252,207,252,199,
  3, 57,  4, 37,251,219,251,211,  4, 45,255,255,  0,  0,254, 70,
  5,127,  6, 49,  2, 39,  0, 92,  0,  0,  0,  0,  0,  7,  0,142,
  0,156,  0,  0,255,255,  0,129,  0,  0,  6,121,  7,107,  2, 39,
  0, 60,  0,  0,  0,  0,  0,  7,  1,  3,  1, 31,  1,117,  0,  1,
253,199,255,227,  3,143,  5,240,  0,  3,  0, 17,182,  0,  2,100,
  4,  3,  1,  4, 16,212,204, 49,  0, 16,228,196, 48,  5, 35,  1,
 51,254,188,245,  4,211,245, 29,  6, 13,  0,  2,  0, 74,  0, 61,
  4,207,  4,197,  0, 35,  0, 47,  0,127, 64, 72, 20, 18, 12, 10,
  4, 21, 15, 30,  0, 28,  2,  4, 33,  9, 27, 21,  3, 29, 33,  1,
 19, 11, 36,  3,211,  1,210, 33,212, 42, 21,211, 11,210, 15, 48,
 28, 20, 19, 29, 27, 21,  4, 24, 18,  2, 48, 10, 30, 12, 18, 11,
  9,  3,  1,  4,  6,  0, 39, 18, 76, 20, 75, 24, 77, 45,  0, 76,
 10, 75,  6, 48, 16,220,236,236, 50,252,236,236, 50, 17, 18, 23,
 57, 18, 57, 57, 17, 18, 57, 17, 18, 23, 57, 17, 57, 49,  0, 16,
212,236,236, 50,252,236,236, 50, 16,192, 17, 18, 57, 17, 18, 57,
 57, 18, 23, 57, 17, 18, 23, 57, 48,  1,  7, 39, 55, 38, 38, 53,
 52, 54, 55, 39, 55, 23, 54, 54, 51, 50, 22, 23, 55, 23,  7, 22,
 22, 21, 20,  6,  7, 23,  7, 39,  6,  6, 35, 34, 38, 55, 50, 54,
 53, 52, 38, 35, 34,  6, 21, 20, 22,  1,178,207,153,207, 28, 28,
 30, 30,209,153,207, 48,108, 61, 54,108, 57,207,152,207, 29, 28,
 29, 30,207,154,207, 46,106, 63, 58,108,166, 91,128,127, 92, 91,
128,126,  1, 12,207,154,207, 49,107, 63, 63,108, 46,205,154,207,
 30, 29, 27, 28,207,154,207, 55,110, 54, 63,105, 47,207,153,206,
 30, 29, 27,182,127, 92, 92,127,127, 92, 93,126,  0,  1,  0,125,
  0,137,  2,215,  4, 39,  0,  6,  0, 29, 64, 14,  5,  3,  2,  3,
  4,  0,  7,  4,  3,  2,  3,  0,  5,  7, 16,212,204, 23, 57, 49,
  0, 16,212,204, 23, 57, 48,  1,  7,  5,  5,  7,  1, 55,  2,215,
 49,254,166,  1,  2, 43,254, 90, 37,  4, 39,252,229,222,223,  1,
113,186,  0,  1,  0, 78,  0,135,  2,166,  4, 39,  0,  6,  0, 27,
 64, 12,  3,  2,  0,  4,  7,  4,  3,  2,  3,  5,  0,  7, 16,212,
204, 23, 57, 49,  0, 16,212,204, 57, 57, 48, 55, 55, 37, 37, 55,
  1,  7, 78, 49,  1, 88,255,  0, 43,  1,164, 35,135,254,229,222,
223,254,141,186,  0,  3,  0,102,  0,  0,  6, 98,  6, 20,  0,  3,
  0,  7,  0, 27,  0,220, 64, 99,  0,  5,  1,  2,  1,  3,  5,  2,
  2,  1,  4,  5,  5,  6,  5,  7,  5,  6,  6,  5, 18,  5, 19, 23,
 19, 17,  5, 23, 19, 14,  5, 23, 19, 10, 11, 12,  3,  9, 13,  5,
 23, 23, 19, 58, 24, 13,  2, 20, 16,105,  2,161,  4,  9,103,  8,
  0,107, 22, 14,  4,122, 18,  6, 20, 19, 22,  3, 21, 27, 24, 18,
 17, 16, 15, 14, 13, 10,  9,  8,  7,  4,  3,  0, 15, 23,  6,  2,
  0,  1, 32,  5, 38,  6, 78, 23, 38, 21, 28, 16,212,228,252,228,
244,228, 17, 18, 23, 57, 17, 23, 57, 49,  0, 47, 60,228, 50, 50,
252, 60,236, 16,237,238, 50, 18, 57, 57, 48, 75, 83, 88,  7, 16,
  5,237, 17, 23, 57,  7,  5,237,  7,  5,237,  7, 16,  5,237,  7,
 16,  5,237,  7, 16,  5,237,  7, 16,  5,237,  7, 16,  5,237, 89,
 34,  1, 75,176, 10, 84, 75,176, 17, 84, 91, 75,176, 18, 84, 91,
 75,176, 19, 84, 91, 88,189,  0, 28,  0, 64,  0,  1,  0, 28,  0,
 28,255,192, 56, 17, 55, 56, 89,181,  0, 29,  1, 63, 29,  1, 93,
  0, 93,  1, 33,  3, 33,  7, 33,  3, 33, 19,  7, 35, 34,  6, 15,
  1, 33,  3, 33,  3, 33, 19, 35, 19, 51, 55, 62,  1, 51,  4,250,
  1,104, 57,254,152, 27,  1,104,219,254,154,133, 47,197, 75, 69,
 13, 17,  1, 47, 49,254,209,168,254,152,168,177, 50,176, 16, 37,
234,216,  6, 20,254,220,144,251,160,  6, 20,235, 55, 67, 79,255,
  0,252,160,  3, 96,  1,  0, 78,186,172,  0,  1,  0,102,  0,  0,
  6, 98,  6, 20,  0, 21,  0,180, 64, 76,  4,  5,  1,  2,  1,  3,
  5,  2,  2,  1, 13,  5, 14, 18, 14, 12,  5, 18, 14,  9,  5, 18,
 14,  5,  6,  7,  3,  4,  8,  5, 18, 18, 14, 58, 19,  8,  4, 15,
 11,105,  9,  4,103,  0,107, 17,  9,122, 13,  2, 14, 17, 15,  3,
 16, 19, 13, 12, 11, 10,  9,  8,  5,  4,  3,  0, 11, 18,  1, 32,
  2, 78, 18, 38, 16, 22, 16,212,228,252,228, 18, 23, 57, 17, 23,
 57, 49,  0, 47, 60,228, 50,252,236, 16,238, 50, 18, 57, 57, 48,
 75, 83, 88,  7, 16,  5,237, 17, 23, 57,  7,  5,237,  7,  5,237,
  7, 16,  5,237,  7, 16,  5,237,  7, 16,  5,237, 89, 34,  1, 75,
176, 10, 84, 75,176, 17, 84, 91, 75,176, 19, 84, 91, 75,176, 18,
 84, 91, 88,189,  0, 22,  0, 64,  0,  1,  0, 22,  0, 22,255,192,
 56, 17, 55, 56, 89,180,  0, 23, 63, 23,  2, 93,  1, 33,  1, 33,
 19, 33, 34,  6, 15,  1, 33,  3, 33,  3, 33, 19, 35, 19, 51, 55,
 62,  1,  3, 63,  3, 35,254,209,254,154,254,254,147, 75, 69, 13,
 17,  1, 47, 49,254,209,168,254,152,168,177, 50,176, 16, 37,234,
  6, 20,249,236,  5, 41, 55, 67, 79,255,  0,252,160,  3, 96,  1,
  0, 78,186,172,  0,  1,255,199,255, 59,  4,  8,  5,213,  0, 19,
  0,128, 64, 70, 10,  4,  0, 11,  9,  4,  0, 11,  6,  4, 11,  0,
 11,  5,  4,  0, 11,  2,  4,  0, 11,  1,  4,  0,  0, 11, 58, 12,
  8, 88, 14,  6, 10,163,  0, 16,  4,165, 18,  2,164,  0, 83, 20,
 14, 13, 17, 18, 20, 12, 15, 11, 19, 10,  9,  8,  7,  6,  5,  4,
  2,  1,  0, 11,  3, 16, 13, 16, 11, 20, 16,212,196, 46, 16,192,
 23, 57, 18, 57, 57, 17, 57, 57, 18, 57, 49,  0, 16,228,244, 60,
236, 50, 16,254,214, 60,238, 50, 48, 75, 83, 88,  7, 16,  5,237,
  7,  5,237,  7,  5,237,  7, 16,  5,237,  7,  5,237,  7,  5,237,
 89, 34,  1, 33,  3, 33,  7, 33,  3, 33,  7, 33,  3, 33, 19, 33,
 55, 33, 19, 33, 55, 33,  1,231,  1, 74, 74,  1, 33, 45,254,221,
 88,  1, 35, 47,254,223, 74,254,181, 73,254,224, 47,  1, 33, 88,
254,223, 45,  1, 33,  5,213,254,131,238,254, 60,238,254,131,  1,
125,238,  1,196,238,  0,  0,  1,  0,172,  2,  6,  2, 96,  3,137,
  0,  3,  0, 47, 64, 21,  2,  5,  3,  0,  3,  1,  5,  0,  3, 58,
  2, 84,  0,  4,  2,  1,  0,  0,  0,  3,  4, 16,212,228, 16,192,
 57, 49,  0, 16,212,236, 48, 75, 83, 88,  7,  5,237,  7, 16,  5,
237, 89, 34, 19, 33,  3, 33,248,  1,104, 76,254,152,  3,137,254,
125,  0,  0,  1,255,186,255,  6,  1,240,  1,131,  0,  5,  0, 53,
 64, 25,  4,  3,  2,  5,  2,  5,  5,  0,  5,  1,  5,  0,  5, 58,
  3,208,  0, 84,  6,  1,  5,  0,  4,  0,  6, 16,212,196,228,192,
 49,  0, 16,252,236, 48, 75, 83, 88,  7,  5,237,  7, 16,  5,237,
 17, 23, 57, 89, 34, 19, 33,  3,  1, 35, 19,156,  1, 84, 56,254,
215,213,170,  1,131,254,227,254,160,  1, 96,  0,  0,  2,255,186,
255,  6,  4, 10,  1,131,  0,  5,  0, 11,  0, 98, 64, 50,  4,  3,
  2,  5,  2,  5,  5,  0,  5,  1,  5,  0,  0,  5, 10,  9,  2, 11,
  8,  5, 11,  6, 11,  7,  5,  6,  6, 11, 58,  9,  3,208,  6,  0,
 84, 12,  7,  5,  4,  1,  5,  0,  4,  0, 72, 10, 11,  0,  6, 12,
 16,212,228,196,244,196,228,192, 17, 18, 57, 49,  0, 16,252, 60,
236, 50, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237, 17, 23,
 57,  7, 16,  5,237,  7, 16,  5,237, 17, 23, 57, 89, 34,  1, 33,
  3,  1, 35, 19,  1, 33,  3,  1, 35, 19,  2,182,  1, 84, 55,254,
217,213,168,254, 29,  1, 84, 56,254,215,213,170,  1,131,254,227,
254,160,  1, 96,  1, 29,254,227,254,160,  1, 96,  0,  7,  0,113,
255,227, 11, 53,  5,240,  0, 11,  0, 23,  0, 35,  0, 47,  0, 51,
  0, 63,  0, 75,  0, 98, 64, 55, 24, 12,101,  0, 70,101, 58, 97,
 64,101, 50, 30, 18,101, 36,  0, 97, 48, 42,  6, 96, 52, 50,100,
 76, 49, 67, 61, 51, 39, 33, 21, 11,  3, 12, 15, 11,  9, 27, 11,
 45, 12, 33, 11,  9, 39, 73, 11, 55, 12, 39, 67, 11, 61, 76, 16,
212,236,196,252,236, 16,197,238,254,238, 16,238,254,238, 17, 18,
 57, 17, 18, 57, 49,  0, 16,228, 50,244, 60, 60,236, 50,236, 50,
 16,238,254,238, 16,238, 50, 48,  1, 50, 22, 21, 20,  0, 35, 34,
 38, 53, 52,  0, 23, 34,  6, 21, 20, 22, 51, 50, 54, 53, 52, 38,
 33, 34,  6, 21, 20, 22, 51, 50, 54, 53, 52, 38, 39, 50, 22, 21,
 20,  0, 35, 34, 38, 53, 52,  0,  1, 35,  1, 51, 33, 50, 22, 21,
 20,  0, 35, 34, 38, 53, 52,  0, 23, 34,  6, 21, 20, 22, 51, 50,
 54, 53, 52, 38,  9,219,156,190,254,246,215,157,189,  1, 11,183,
 86,110, 61, 62, 87,109, 62,252, 36, 86,111, 61, 62, 87,110, 63,
 32,157,189,254,247,214,157,189,  1,  9,252,177,245,  4,211,245,
251,107,156,190,254,245,214,157,189,  1, 11,183, 86,110, 61, 61,
 87,110, 63,  3, 16,171,140,223,254,233,173,141,222,  1, 21,168,
168,133, 87, 87,168,135, 85, 87,168,133, 87, 87,168,135, 85, 87,
168,171,140,224,254,234,173,141,222,  1, 21,252,211,  6, 13,172,
140,223,254,234,170,141,222,  1, 24,168,169,132, 88, 89,170,136,
 84, 88,255,255,255,123,  0,  0,  5,135,  7,107,  2, 39,  0, 36,
  0,  0,  0,  0,  0,  7,  1,  7,  1, 68,  1,117,255,255,  0, 43,
  0,  0,  5, 92,  7,107,  2, 39,  0, 40,  0,  0,  0,  0,  0,  7,
  1,  7,  1, 27,  1,117,255,255,255,123,  0,  0,  5,135,  7,107,
  2, 39,  0, 36,  0,  0,  0,  0,  0,  7,  1,  4,  1, 68,  1,117,
255,255,  0, 43,  0,  0,  5, 92,  7,107,  2, 39,  0, 40,  0,  0,
  0,  0,  0,  7,  1,  3,  1, 27,  1,117,255,255,  0, 43,  0,  0,
  5, 92,  7,107,  2, 39,  0, 40,  0,  0,  0,  0,  0,  7,  1,  6,
  1, 27,  1,117,255,255,  0, 43,  0,  0,  3,149,  7,107,  2, 39,
  0, 44,  0,  0,  0,  0,  0,  7,  1,  4,255,182,  1,117,255,255,
  0, 43,  0,  0,  3,133,  7,107,  2, 39,  0, 44,  0,  0,  0,  0,
  0,  7,  1,  7,255,182,  1,117,255,255,  0, 43,  0,  0,  3,137,
  7,107,  2, 39,  0, 44,  0,  0,  0,  0,  0,  7,  1,  3,255,182,
  1,117,255,255,  0, 43,  0,  0,  2,207,  7,107,  2, 39,  0, 44,
  0,  0,  0,  0,  0,  7,  1,  6,255,182,  1,117,255,255,  0, 74,
255,227,  6,131,  7,107,  2, 39,  0, 50,  0,  0,  0,  0,  0,  7,
  1,  4,  1,188,  1,117,255,255,  0, 74,255,227,  6,131,  7,107,
  2, 39,  0, 50,  0,  0,  0,  0,  0,  7,  1,  7,  1,188,  1,117,
255,255,  0, 74,255,227,  6,131,  7,107,  2, 39,  0, 50,  0,  0,
  0,  0,  0,  7,  1,  6,  1,188,  1,117,255,255,  0,139,255,227,
  6, 84,  7,107,  2, 39,  0, 56,  0,  0,  0,  0,  0,  7,  1,  4,
  1,109,  1,117,255,255,  0,139,255,227,  6, 84,  7,107,  2, 39,
  0, 56,  0,  0,  0,  0,  0,  7,  1,  7,  1,109,  1,117,255,255,
  0,139,255,227,  6, 84,  7,107,  2, 39,  0, 56,  0,  0,  0,  0,
  0,  7,  1,  6,  1,109,  1,117,  0,  1,  0, 63,  0,  0,  2,129,
  4, 96,  0,  3,  0, 48, 64, 22,  2,  5,  3,  0,  3,  1,  5,  0,
  0,  3, 58,  0,122,  2,  2,  1,  0,  0, 38,  3, 13,  4, 16,244,
228, 16,192, 57, 49,  0, 47,228, 48, 75, 83, 88,  7, 16,  5,237,
  7, 16,  5,237, 89, 34,  1, 33,  3, 33,  1, 25,  1,104,219,254,
153,  4, 96,251,160,  0,  0,  1,  0,217,  4,238,  3,221,  6,102,
  0,  6,  0, 56, 64, 12,  4,  5,  2,139,  0,138,  7,  4,  1,  2,
  6,  7, 16,212,204, 57, 57, 49,  0, 16,244,236, 50, 57, 48,  0,
 75,176,  9, 84, 75,176, 14, 84, 91, 88,189,  0,  7,255,192,  0,
  1,  0,  7,  0,  7,  0, 64, 56, 17, 55, 56, 89,  1, 33, 19, 35,
 39,  7, 35,  2, 33,  1,  6,182,178,156,241,197,  6,102,254,136,
225,225,  0,  1,  1, 16,  5, 27,  4,  0,  6, 57,  0, 28,  0,138,
 64, 34, 16, 15, 19, 12,  1,  0, 26,  5, 23, 22, 19, 12,  9,  8,
  5, 19,213, 26,214,  5,213, 12,138, 29, 22, 16, 15,  8,  1,  0,
  6, 23,  9, 29, 16,212,204, 23, 57, 49,  0, 16,244,236,252,236,
 18, 57, 57, 17, 18, 57, 57, 17, 18, 57, 57, 17, 18, 57, 57, 48,
  0, 75,176,  9, 84, 75,176, 14, 84, 91, 88,189,  0, 29,255,192,
  0,  1,  0, 29,  0, 29,  0, 64, 56, 17, 55, 56, 89, 64, 40,  9,
  0,  9,  1,  9,  2,  9,  3, 10, 11, 10, 12, 10, 13, 10, 15, 10,
 16, 10, 17, 10, 18, 10, 19, 10, 20, 15, 21, 15, 22, 15, 23, 15,
 24, 17, 25, 24, 40, 24,  2, 93,  1, 93,  1, 39, 38, 39, 38, 35,
 34,  6,  7, 35, 62,  1, 51, 50, 22, 31,  1, 30,  1, 51, 50, 54,
 55, 51, 14,  1, 35, 34, 38,  2,123, 49,  3,  7, 38, 30, 34, 52,
 10,140, 27,131, 94, 36, 67, 37, 53, 18, 34, 15, 38, 52, 11,139,
 26,130, 94, 34, 60,  5, 84, 37,  2,  5, 30, 69, 60,137,147, 27,
 30, 43, 15, 16, 67, 62,136,148, 23,  0,  0,  1,  1, 61,  5, 88,
  3,217,  6, 20,  0,  3,  0, 44,183,  2,  0,  4,  2,  0,  1,  3,
  4, 16,212,204, 57, 57, 49,  0, 16,212,204, 48,  0, 75,176, 10,
 84, 88,189,  0,  4,  0, 64,  0,  1,  0,  4,  0,  4,255,192, 56,
 17, 55, 56, 89,  1, 33,  7, 33,  1, 98,  2,119, 37,253,137,  6,
 20,188,  0,  1,  1, 84,  5, 29,  3,248,  6, 70,  0, 17,  0,111,
 64, 15,  2,  0,  5, 12,  8,  0, 18,  0, 15,  1,  8,  9,  1, 15,
 18, 16,212,204,212,204, 17, 18, 57, 49,  0, 16,212, 60,212,204,
 17, 57, 48,  0, 75,176, 10, 84, 88,189,  0, 18,  0, 64,  0,  1,
  0, 18,  0, 18,255,192, 56, 17, 55, 56, 89,  0, 75,176, 12, 84,
 88,189,  0, 18,255,192,  0,  1,  0, 18,  0, 18,  0, 64, 56, 17,
 55, 56, 89, 64, 25, 15,  0, 15,  1, 15,  2, 15,  8, 15,  9, 15,
 17, 31,  0, 31,  1, 31,  2, 31,  8, 31,  9, 31, 17, 12, 93,  1,
 51, 21, 20, 22, 51, 50, 54, 55, 51, 14,  1, 35, 34, 38, 53, 52,
 54,  1, 87,142, 86, 80, 81,104, 28,152, 34,205,156,140,141,  1,
  6, 70,  9, 65, 70, 71, 73,143,154,124,121, 21, 21,  0,  0,  1,
  1,233,  5, 59,  3, 45,  6, 49,  0,  3,  0, 75, 64,  9,  2,  0,
  4,  2,  0,  1,  3,  3,  4, 16,196, 16,192, 57, 57, 49,  0, 16,
212,204, 48,  0, 75,176, 10, 84, 75,176, 11, 84, 91, 88,189,  0,
  4,  0, 64,  0,  1,  0,  4,  0,  4,255,192, 56, 17, 55, 56, 89,
 64, 18, 32,  1, 32,  2, 48,  1, 48,  2,  4, 47,  0, 47,  1, 63,
  0, 63,  1,  4, 93,  1, 93,  1, 33,  7, 33,  2, 27,  1, 18, 49,
254,237,  6, 49,246,  0,  0,  2,  1,121,  4,215,  3,178,  7, 16,
  0, 11,  0, 23,  0, 64, 64, 15, 21,210,  3,215, 15,210,  9, 24,
 12, 75,  0, 18, 75,  6, 24, 16,212,236,212,236, 49,  0, 16,212,
236,252,236, 48,  0, 75,176,  9, 84, 75,176, 13, 84, 91, 75,176,
 14, 84, 91, 88,189,  0, 24,255,192,  0,  1,  0, 24,  0, 24,  0,
 64, 56, 17, 55, 56, 89,  1, 20,  6, 35, 34, 38, 53, 52, 54, 51,
 50, 22,  7, 52, 38, 35, 34,  6, 21, 20, 22, 51, 50, 54,  3,178,
165,119,120,165,165,120,119,165,135, 84, 65, 66, 84, 85, 65, 65,
 84,  5,244,120,165,165,120,120,164,164,120, 65, 84, 84, 65, 65,
 85, 84,  0,  1,  0, 45,254,111,  2, 18,  0,  0,  0, 19,  0, 35,
 64, 15, 10,  9, 13,  6,  0,  0, 16,  3, 10,  9, 19,  9,  3, 16,
 20, 16,212,204,196,196, 17, 57, 17, 18, 57, 49,  0, 47,212,204,
212,204, 48, 33, 22, 22, 21, 20,  6, 35, 34, 38, 39, 55, 22, 22,
 51, 50, 54, 53, 52, 38, 39,  1,203, 37, 34,151,137, 49, 97, 51,
 29, 40, 81, 38, 66, 76, 27, 31, 52, 88, 42,104,115, 13, 13,156,
 17, 18, 57, 47, 26, 69, 55,  0,  0,  2,  1, 37,  4,238,  4,129,
  6,102,  0,  3,  0,  7,  0,133, 64, 11,  6,  2,  4,  0,138,  8,
  5,  7,  1,  3,  8, 16,212,220,212,204, 49,  0, 16,244, 60,204,
 50, 48,  1, 75,176,  9, 84, 75,176, 10, 84, 91, 88,189,  0,  8,
255,192,  0,  1,  0,  8,  0,  8,  0, 64, 56, 17, 55, 56, 89,  0,
 75,176,  9, 84, 75,176, 14, 84, 91, 88,189,  0,  8,255,192,  0,
  1,  0,  8,  0,  8,  0, 64, 56, 17, 55, 56, 89, 64, 45,  0,  0,
  0,  1,  0,  2,  0,  3, 16,  0, 16,  1, 16,  2, 16,  3, 22,  5,
 22,  6, 32,  0, 32,  1, 32,  2, 32,  3, 48,  0, 48,  1, 48,  2,
 48,  3, 64,  0, 64,  1, 64,  2, 64,  3, 22,  1, 93,  1, 51,  1,
 35,  1, 51,  1, 35,  2, 16,250,254,201,174,  2, 98,250,254,168,
174,  6,102,254,136,  1,120,254,136,  0,  0,  1,  0,150,254,111,
  2, 70,  0,  0,  0, 19,  0, 64, 64, 15, 10, 11,  7, 14,  0,  0,
 17,  1, 10, 11, 10,  4,  4, 17, 20, 16,212,196, 16,192,192, 18,
 57, 18, 57, 49,  0, 47,212,204,212,204, 48, 64, 25, 73,  0, 73,
  1, 73,  2, 73, 19, 89,  0, 89,  1, 89,  2, 89, 19,105,  0,105,
  1,105,  2,105, 19, 12,  1, 93, 33, 51, 14,  1, 21, 20, 22, 51,
 50, 54, 55,  7, 14,  1, 35, 34, 38, 53, 52, 54,  1, 51,142, 71,
 52, 49, 45, 37, 82, 43, 29, 57, 90, 39,106,111, 74, 74, 80, 28,
 34, 38, 16, 15,152, 13, 13, 69, 66, 65,126,  0,  0,  1,  1, 53,
  4,238,  4, 57,  6,102,  0,  6,  0, 80, 64, 12,  4,  0,139,  5,
  2,138,  7,  4,  1,  6,  2,  7, 16,212,204, 57, 57, 49,  0, 16,
244, 60,236, 57, 48,  0, 75,176,  9, 84, 75,176, 14, 84, 91, 88,
189,  0,  7,255,192,  0,  1,  0,  7,  0,  7,  0, 64, 56, 17, 55,
 56, 89,  1, 75,176, 10, 84, 88,189,  0,  7,  0, 64,  0,  1,  0,
  7,  0,  7,255,192, 56, 17, 55, 56, 89,  1, 33,  3, 51, 23, 55,
 51,  2,240,254,252,183,176,156,244,196,  4,238,  1,120,227,227,
  0,  1,255,209,  0,  0,  4,211,  5,213,  0, 13,  0, 96, 64, 54,
  6, 18,  9,  0,  9,  5, 18,  4,  5,  0,  9,  2, 18,  3,  2,  0,
  9,  1, 18,  0,  0,  9, 58, 12, 11, 10,  4,  3,  2,  6,  0,  6,
135,  0, 83,  8, 11, 14, 10,  9,  8,  6,  4,  3,  2,  1,  6,  7,
  0, 12,  0,  2,  9, 14, 16,212,228, 46, 16,192, 23, 57, 18, 57,
 17, 57, 49,  0, 47,228,236, 17, 23, 57, 48, 75, 83, 88,  7, 16,
  5,237,  7,  8,237,  7,  8,237,  7, 16,  5,237, 89, 34,  1, 33,
  3, 37, 23,  5,  3, 33,  3, 33, 19,  7, 39, 37,  1,154,  1,129,
101,  1, 84,105,254, 12, 78,  2,162, 55,251,219, 98,160,104,  1,
 61,  5,213,253,252,151,210,220,254,105,254,221,  1,246, 74,215,
135,  0,  0,  1,255,242,  0,  0,  3,166,  6, 20,  0, 11,  0,155,
 64, 49,  6,  5,  7,  0,  7,  5,  5,  4,  5,  0,  7,  2,  5,  3,
  2,  0,  7,  1,  5,  0,  0,  7, 58, 10,  9,  8,  4,  3,  2,  6,
  0,107,  6,  9, 12,  8,  7,  6,  3,  2,  1,  4,  4,  0, 10,  0,
 32,  7, 12, 16,212,228, 46, 16,192, 23, 57, 18, 57, 17, 57, 49,
  0, 47,236, 23, 57, 48, 75, 83, 88,  7, 16,  5,237,  7,  8,237,
  7,  8,237,  7, 16,  5,237, 89, 34,  1, 75,176, 20, 84, 75,176,
 19, 84, 91, 75,176, 18, 84, 91, 75,176, 17, 84, 91, 75,176, 15,
 84, 91, 75,176, 14, 84, 91, 75,176, 12, 84, 91, 75,176, 13, 84,
 91, 88,189,  0, 12,  0, 64,  0,  1,  0, 12,  0, 12,255,192, 56,
 17, 55, 56, 89,180, 31, 13, 47, 13,  2, 93,  1, 33,  3, 55, 23,
  5,  3, 33, 19,  7, 39, 37,  1,152,  1,104,102,168,100,254,192,
149,254,151,117,139, 96,  1, 32,  6, 20,253,252, 78,203,145,252,
254,  2, 86, 68,203,135,255,255,  0, 31,255,227,  5, 82,  7,107,
  2, 39,  0, 54,  0,  0,  0,  0,  0,  7,  1,  8,  1, 27,  1,117,
255,255,  0, 20,255,227,  4,155,  6,102,  2, 39,  0, 86,  0,  0,
  0,  0,  0,  7,  0,224,  0, 98,  0,  0,255,255,255,203,  0,  0,
  5,236,  7,107,  2, 39,  0, 61,  0,  0,  0,  0,  0,  7,  1,  8,
  1, 33,  1,117,255,255,255,238,  0,  0,  4,176,  6,102,  2, 39,
  0, 93,  0,  0,  0,  0,  0,  7,  0,224,  0, 84,  0,  0,  0,  2,
  1,  4,254,162,  1,231,  5,152,  0,  3,  0,  7,  0, 28, 64, 12,
  1,  0,  5,  4,  0,  8,  4,  0,  7,  6,  2,  8, 16,212, 60,236,
 50, 49,  0, 16,196,212,196, 16,198, 48,  1, 17, 35, 17, 19, 17,
 35, 17,  1,231,227,227,227,  5,152,253, 10,  2,246,252,  0,253,
 10,  2,246,  0,  0,  2,255,252,  0,  0,  6,109,  5,213,  0, 12,
  0, 31,  0,112, 64, 58,  5, 18, 13, 27,  4, 18, 27, 13, 27,  1,
 18, 13, 27,  0, 18, 13, 13, 27, 58, 30,  1,128, 28,  3,133,  0,
135, 13, 83,  5,135, 26, 30, 32, 31, 28, 27, 12,  6,  5,  4,  3,
  2,  1,  0,  8, 14, 26, 13, 29,  9, 27, 20, 13,  2, 27, 13, 32,
 16,244,228,212,236, 46, 17, 57, 57, 23, 57, 18, 57, 57, 17, 57,
 49,  0, 47,236,244,236,244, 60,236, 50, 48, 75, 83, 88,  7, 16,
  5,237,  7,  5,237,  7, 16,  5,237,  7,  5,237, 89, 34,178,  0,
 33,  1,  1, 93,  1,  3, 51,  3, 35,  3, 51, 32,  0, 17, 52, 38,
 35,  1, 33, 32,  4, 23, 30,  1, 21, 20,  2,  7,  6,  4, 41,  1,
 19, 35, 19, 51,  2,184, 57,246, 51,246, 70,137,  1, 15,  1, 59,
207,203,254, 48,  1,149,  1, 34,  1, 34, 96, 97,100,169,151,132,
254,163,254,149,254,107,125,205, 51,205,  4,178,254,213,254,252,
254,160,  1, 47,  1,  0,174,178,  1, 35, 69, 81, 81,232,145,201,
254,152,123,109, 92,  2,131,  1,  4,  0,  0,  2,  0, 74,255,227,
  5,109,  6, 20,  0, 15,  0, 44,  0,175, 64, 99, 42, 43, 44, 43,
 41, 40, 41, 44, 44, 43, 38, 39, 38, 35, 36, 35, 37, 36, 36, 35,
 39,  4, 16, 40, 38,  4, 37, 38, 16, 40, 35,  4, 36, 35, 40, 16,
 40, 32, 33,  2, 34,  4, 16, 16, 40, 58, 44, 43, 42, 41, 38, 37,
 36, 35,  8, 39, 34,  3, 16, 39,  3,105, 31,  9,105, 25, 96, 31,
 39,107, 45, 42, 43, 44, 41, 16,  3, 19, 12, 37, 36, 28, 39, 38,
 35,  0,  4, 34, 12,  6, 43, 12, 33, 19,  6, 33, 28, 13, 45, 16,
244,236,212,236,192, 17, 18, 57, 23, 57, 18, 57, 57, 17, 18, 23,
 57, 17, 57, 49,  0, 16,236,196,244,236, 16,238, 18, 57, 18, 57,
 18, 23, 57, 48, 75, 83, 88,  7, 16,  5,237, 23, 57,  7, 16,  8,
237,  7,  8,237,  7,  5,237,  7, 16,  4,201,  7, 16,  8,201,  7,
 16,  8,201,  7, 16, 14,201, 89, 34,  1, 38, 38, 35, 34,  6, 21,
 20, 22, 51, 50, 54, 53, 52, 39, 52, 19, 22, 22, 21, 20,  6,  7,
  6,  4, 35, 34, 36, 53, 16,  0, 33, 50, 22, 23, 39,  5, 39, 37,
 39, 33, 23, 37, 23,  5,  3,190, 52,102, 52,140,163,100, 94,140,
180,  4,245, 64, 65, 91, 87,101,254,233,171,241,254,223,  1,108,
  1, 37, 49, 87, 36,151,254,127, 35,  1, 84,137,  1, 96, 82,  1,
129, 35,254,172,  2,231, 27, 27,188,158,109,115,253,198, 13, 40,
  7,  1,106, 92,212,116,130,243,100,116,120,250,205,  1, 24,  1,
 93, 14, 13,215,108,129, 94,198,116,106,127, 94,255,255,  0,129,
  0,  0,  6,121,  7,107,  2, 39,  0, 60,  0,  0,  0,  0,  0,  7,
  1,  4,  1, 31,  1,117,255,255,  0,  0,254, 70,  5,127,  6,102,
  2, 39,  0, 92,  0,  0,  0,  0,  0,  7,  0,141,  0,156,  0,  0,
  0,  2,  0, 43,  0,  0,  5,143,  5,213,  0, 15,  0, 24,  0,106,
 64, 58, 17, 18, 15,  0, 15, 16, 18,  0,  0, 15, 14, 18,  0, 15,
 13, 18, 15,  0, 15,  2, 18,  0, 15,  1, 18,  0,  0, 15, 58, 17,
117, 12, 16,117,  2,  0, 83, 14, 24, 18, 17, 16, 14, 13,  2,  1,
  8,  3, 12,  0, 21, 27,  6,  0,  2, 15, 25, 25, 16,244,228,212,
236, 17, 57, 57, 23, 57, 49,  0, 47,228,212,236,212,236, 48, 75,
 83, 88,  7, 16,  5,237,  7,  5,237,  7, 16,  5,237,  7,  5,237,
  7, 16,  5,237,  7, 16,  5,237, 89, 34,  1, 33,  7, 51, 50,  4,
 21, 20,  6,  7,  6,  6, 35, 35,  3, 33,  1,  3, 51, 50, 54, 53,
 52, 38, 35,  1, 78,  1,129, 43,246,235,  1, 10, 87, 83, 89,249,
184,246, 57,254,127,  2, 66, 80,204,136,145,101, 98,  5,213,223,
215,191,117,209, 79, 86, 78,254,217,  3,225,254, 92,130,122, 82,
 86,  0,  0,  2,255,236,254, 86,  5,106,  6, 20,  0, 19,  0, 31,
  0,145, 64, 76, 25, 24,  2, 26, 23,  5,  2,  3,  2, 21,  1, 20,
 22,  5,  3,  3,  2,  1,  5,  3,  2, 18, 19,  2, 17,  0,  5,  2,
  3,  2,  7,  6,  2,  5,  5,  3,  2,  4,  5,  3,  3,  2, 58,  5,
 20,  8,  0, 26, 17, 20,105,  8, 26,105, 17, 96,  8,143,  1,162,
  3,107, 32,  1, 32, 23,  4,  5,  0,  3, 29, 33, 11,  3,  2, 32,
 16,220,196,212,236, 17, 57, 57, 57, 57, 18, 57, 49,  0, 16,236,
228,228,244,236, 16,238, 17, 18, 57, 17, 18, 57, 48, 75, 83, 88,
  7, 16,  5,237,  7,  5,237, 23, 57,  7, 16,  5,237, 17, 23, 57,
  7,  5,237,  7, 16,  5,237, 17, 23, 57,  7, 16,  5,237, 17, 23,
 57, 89, 34, 37,  3, 33,  1, 33,  3, 54, 54, 51, 50, 22, 21, 20,
  6,  7,  6,  6, 35, 34, 38,  1, 34,  6, 21, 20, 22, 51, 50, 54,
 53, 52, 38,  1,199,115,254,152,  1,129,  1,104,117, 82,180,107,
189,220, 77, 72, 91,229,131,115,161,  1, 65,138,175, 99, 88,135,
176, 95,162,253,180,  7,190,253,168, 98, 93,240,207,129,244,100,
126,130, 93,  3, 55,255,204, 92,105,251,196,102,107,  0,  0,  1,
  0,217,  2, 12,  5,219,  2,248,  0,  3,  0, 18,183,  2,111,  0,
110,  4,  1,  0,  4, 16,212,196, 49,  0, 16,244,236, 48, 19, 33,
 21, 33,217,  5,  2,250,254,  2,248,236,  0,  1,  1,  0,  0, 41,
  5,180,  4,219,  0, 11,  0, 47, 64, 28, 10,  8,  7,  6,  4,  2,
  1,  0,  8,  5,  3, 11,  9, 12, 11, 10,  9,  7,  5,  4,  3,  1,
  8,  2,  0,  8,  6, 12, 16,212, 60,204, 50, 23, 57, 49,  0, 16,
212, 60,204, 50, 23, 57, 48,  9,  2,  7,  1,  1, 39,  1,  1, 55,
  1,  1,  5,180,254, 78,  1,178,168,254, 78,254, 78,168,  1,178,
254, 78,168,  1,178,  1,178,  4, 51,254, 78,254, 80,168,  1,176,
254, 80,168,  1,176,  1,178,168,254, 78,  1,178,  0,  1,  0,137,
  2,156,  3, 41,  5,223,  0, 10,  0,133, 64, 48,  9,  8,  2,  7,
 79,  1,  2,  1,  6, 79,  2,  2,  1, 58,  2,  4,  3,  7,  0,216,
  9,  3,216,  4,  9,217,  5, 98, 11,  6,  9,  7,  3,  8,  5, 10,
  4,  3,  0,  4, 11,  2,  1,  8,  5,  5,  1, 11, 16,212,196, 16,
192, 18, 57, 17, 23, 57, 17, 18, 23, 57, 49,  0, 16,244,236,212,
236, 16,238, 50, 17, 18, 57, 48, 75, 83, 88,  7, 16,  5,237,  7,
 16,  5,237, 23, 50, 89, 34,178, 24,  2,  1,  1, 93, 64, 31,  9,
  2, 10,  3, 10,  4, 24,  2, 26,  3, 26,  4, 41,  3, 41,  4, 57,
  3, 57,  4, 74,  2, 77,  3, 77,  4, 74,  5, 74,  6, 15, 93, 19,
 51, 19,  7, 63,  1, 51,  3, 51,  7, 33,168,205,102,233, 30,244,
219,133,207, 31,253,127,  3, 57,  2,  9, 52,160, 49,253, 90,157,
  0,  1,  0, 92,  2,156,  3,115,  5,240,  0, 24,  0, 99, 64, 33,
 15, 18, 11,  5, 24, 14,  0,216,  2, 14, 11,219,  2,217, 18,100,
 25, 24,  2,  1,  3, 21, 14,  5,  0,  3, 15,  3,  8, 80, 21,  3,
 25, 16,212,212,236, 17, 57, 23, 57, 17, 23, 57, 49,  0, 16,244,
236,252,196, 16,238, 17, 57, 57, 17, 18, 57, 48, 64, 32, 53, 23,
 53, 24, 89,  0, 89, 24,133,  0,149,  0,149, 23,149, 24,165,  0,
165, 23,165, 24, 11,150,  4,166,  4,184,  4,183, 23,  4, 93,  1,
 93,  1, 33,  7, 33, 55,  1, 62,  1, 53, 52, 38, 35, 34,  6,  7,
 55, 62,  1, 51, 50, 22, 21, 20,  6,  7,  1,168,  1,121, 33,253,
 92, 31,  1,110, 80, 78, 65, 58, 68,147, 71, 36, 83,149, 69,149,
159,108,120,  3, 68,168,153,  1, 10, 58, 99, 42, 40, 46, 46, 44,
186, 26, 26,109,100, 79,149, 84,  0,  1,  0, 82,  2,141,  3,106,
  5,240,  0, 40,  0,116, 64, 45, 32, 35, 28,  9, 13,  6,  0, 21,
219, 19, 10, 13,219,  6, 31, 28,219,  6,217, 19,220, 35,100, 41,
 21, 20, 19, 10,  4, 22, 31, 32,  3, 16,  9,  0, 25, 16, 80,  3,
 25, 80, 38,  9, 41, 16,212,212,236,212,236, 18, 57, 17, 18, 23,
 57, 23, 57, 49,  0, 16,244,236,236,252,196, 16,254,197, 16,238,
 57, 17, 18, 57, 17, 18, 57, 48, 64, 31, 32,  0, 32,  1, 32, 18,
 32, 19, 32, 20, 32, 21, 32, 22, 32, 23, 32, 40,176, 18,176, 19,
176, 20,176, 21,176, 22,176, 23, 15, 93,  1, 30,  1, 21, 20,  6,
 35, 34, 38, 39, 55, 30,  1, 51, 50, 54, 53, 52, 38, 43,  1, 55,
 51, 50, 54, 53, 52, 38, 35, 34,  6,  7, 55, 62,  1, 51, 50, 22,
 21, 20,  6,  2,154, 75, 78,234,216, 80,145, 62, 33, 58,119, 60,
109,123, 99,104, 76, 27, 86,106,113, 76, 74, 54,127, 77, 31, 72,
148, 73,155,166,113,  4, 96, 13, 93, 76,137,148, 24, 23,172, 36,
 37, 76, 67, 54, 51,137, 58, 54, 38, 38, 26, 27,166, 17, 18,100,
 93, 81,112,  0,  0,  4,  0,137,255,227,  7,205,  5,240,  0,  2,
  0, 13,  0, 17,  0, 28,  1,  6, 64,110,  1, 13,  3, 13,  0,  2,
  0,  3,  3, 13,  0, 79,  1,  0,  4,  9,  4,  2, 79,  9,  4, 11,
 79,  9,  4, 10, 79,  9,  9,  4, 27, 26,  2, 25, 79, 19, 20, 19,
 24, 79, 20, 20, 19, 58, 20, 22, 21,  0, 27,  5,  1,216,  7, 25,
 18,216, 27, 21,216, 22, 27,217, 23,100, 14, 96,  3,217, 11,  7,
 16,100,  9, 28, 22, 21, 15, 18,  5, 29, 20, 19, 27, 26, 25, 24,
  4, 23,  0, 11, 10,  2,  1,  5, 12, 17,  8,  5,  3,  9,  7,  6,
  4, 23, 19,  9, 12,  4, 19, 29, 16,196,212,196,196, 16,198, 16,
192, 57, 18, 23, 57, 17, 23, 57, 18, 23, 57, 17, 57, 18, 23, 57,
 49,  0, 47,230,196, 50,238,228,246,238,214,238, 16,238, 50, 16,
238, 50, 17, 57, 17, 18, 57, 48, 75, 83, 88,  7, 16,  5,237,  7,
 16,  5,237, 23, 50,  7, 16,  5,237,  7,  5,237,  7,  5,237,  7,
 16,  8,237,  7, 16,  8,201,  7, 16,  5,201, 89, 34,178, 56,  5,
  1,  1, 93, 64, 54, 27,  0, 92,  0,  2,  9, 20,  9, 21,  9, 22,
 26,  0, 26,  2, 25, 20, 25, 21, 25, 22, 41,  2, 42,  3, 41,  5,
 47, 21, 47, 22, 56,  2, 58,  3, 63, 21, 63, 22, 75, 20, 75, 21,
 75, 22, 75, 23, 75, 24, 89,  0, 89,  2, 24, 93,  0, 93,  9,  1,
 51, 19, 51,  3, 51,  7, 35,  7, 35, 55, 33, 55,  1, 35,  1, 51,
  1, 51, 19,  7, 63,  1, 51,  3, 51,  7, 33,  6,164,254,205,239,
 80,250,100,135, 29,137, 33,229, 33,254,120, 33,253,141,245,  4,
211,245,249,109,205,102,233, 30,244,219,133,207, 31,253,127,  2,
139,254,178,  2,  7,253,249,155,162,162,168,254,153,  6, 13,253,
 73,  2,  9, 52,160, 49,253, 90,157,  0,  0,  3,  0,137,255,227,
  8, 14,  5,240,  0, 24,  0, 28,  0, 39,  0,227, 64, 81, 38, 37,
  2, 36, 79, 30, 31, 30, 35, 79, 31, 31, 30, 58, 31, 33, 32, 15,
 29, 11,  5, 24,  0, 14, 11,219, 18, 36, 29,216, 38, 32,216, 33,
 38,217, 34,100,  0,216, 18,217, 25, 96, 27,100,  2, 39, 33, 32,
 26, 29,  5, 40, 31, 30, 38, 37, 36, 35,  3,  0, 14,  5,  8, 34,
 28, 24,  2,  1,  4, 21, 15, 34,  8, 80, 21, 34, 30, 21, 40, 16,
196,212,196, 16,238, 17, 57, 17, 23, 57, 17, 23, 57, 18, 57, 17,
 23, 57, 49,  0, 47,230,228,238,238,246,238,214,238, 16,238, 50,
 16,254,196, 17, 57, 57, 17, 18, 57, 17, 18, 57, 48, 75, 83, 88,
  7, 16,  5,237,  7, 16,  5,237, 23, 50, 89, 34,178, 88,  0,  1,
  1, 93, 64, 72, 86,  4,118,  4,136,  5,150,  4,162,  4,183, 23,
  6, 11, 31, 11, 32, 11, 33, 11, 34, 27, 31, 27, 32, 27, 33, 27,
 34, 42, 32, 42, 33, 58, 32, 58, 33, 75, 32, 75, 33, 89,  0, 91,
  1, 91,  2, 87,  3, 87,  4, 90, 24,133,  0,133, 24,149,  0,150,
 23,149, 24,164,  0,166,  4,164, 23,164, 24, 29, 93,  0, 93, 37,
 33,  7, 33, 55,  1, 62,  1, 53, 52, 38, 35, 34,  6,  7, 55, 62,
  1, 51, 50, 22, 21, 20,  6,  7,  1, 35,  1, 51,  1, 51, 19,  7,
 63,  1, 51,  3, 51,  7, 33,  6, 68,  1,118, 32,253, 94, 31,  1,
110, 81, 77, 66, 57, 68,150, 71, 37, 83,148, 70,149,160,108,119,
251, 61,245,  4,211,245,249,109,205,102,233, 30,244,219,133,207,
 31,253,127,168,168,154,  1, 10, 58, 97, 41, 41, 48, 47, 44,187,
 26, 25,109,100, 79,148, 84,254,151,  6, 13,253, 73,  2,  9, 52,
160, 49,253, 90,157,  0,  0,  4,  0, 90,255,227,  7,211,  5,240,
  0, 40,  0, 43,  0, 54,  0, 58,  1, 19, 64,114, 42, 54, 44, 54,
 41, 43, 41, 44, 44, 54, 41, 79, 42, 41, 45, 50, 45, 43, 79, 50,
 45, 52, 79, 50, 45, 51, 79, 50, 50, 45, 58, 32, 35, 28, 41, 42,
  9, 13,  6,  0, 21, 19, 46, 42,216, 48, 21,219, 19, 10, 13,219,
  6, 31, 28,219,  6,217, 19,220, 57, 35,100, 52, 48, 44,217, 55,
 96, 50, 42, 41, 52, 51, 43,  5, 53, 58, 46, 49,  3, 50, 48, 47,
 45, 56, 21, 20, 19, 10,  5, 22, 31, 32,  3, 16,  9,  0, 25,  3,
 47, 45, 16, 80,  3, 25, 80, 38,  9, 50, 53, 45,  9, 59, 16,196,
212,196,196, 16,214,238,212,238, 16,192, 17, 18, 57, 17, 18, 23,
 57, 23, 57, 17, 18, 57, 18, 23, 57, 17, 23, 57, 49,  0, 47,228,
238,196, 50,246, 60,238,238,254,196, 16,254,197, 16,238, 16,238,
 50, 17, 18, 57, 17, 18, 57, 18, 57, 17, 18, 57, 48, 75, 83, 88,
  7, 16,  5,237,  7,  5,237,  7,  5,237,  7, 16,  8,237,  7, 16,
  8,201,  7, 16,  5,201, 89, 34,178, 32, 40,  1,  0, 93, 64, 58,
 41, 43, 42, 44, 40, 46, 57, 43, 58, 44, 57, 46, 89, 41, 89, 43,
105, 41,105, 43, 10, 32,  0, 32,  1, 32, 18, 32, 19, 32, 20, 32,
 21, 32, 22, 32, 23, 32, 24, 32, 39, 91, 41,108, 41,176, 18,176,
 19,176, 20,176, 21,176, 22,176, 23, 18, 93,  1, 93,  1, 30,  1,
 21, 20,  6, 35, 34, 38, 39, 55, 30,  1, 51, 50, 54, 53, 52, 38,
 43,  1, 55, 51, 50, 54, 53, 52, 38, 35, 34,  6,  7, 55, 62,  1,
 51, 50, 22, 21, 20,  6,  9,  1, 51, 19, 51,  3, 51,  7, 35,  7,
 35, 55, 33, 55,  1, 35,  1, 51,  2,162, 76, 79,233,217, 81,146,
 62, 35, 58,119, 60,109,123, 98,105, 76, 27, 86,106,111, 75, 72,
 56,129, 75, 32, 72,148, 73,155,165,113,  3,166,254,207,239, 80,
248,100,137, 31,137, 31,229, 31,254,123, 30,253,152,246,  4,211,
246,  4, 96, 14, 92, 76,137,148, 24, 23,172, 36, 37, 76, 67, 54,
 51,137, 58, 54, 38, 38, 26, 27,166, 17, 18,100, 93, 81,112,254,
 29,254,178,  2,  7,253,249,155,162,162,168,254,153,  6, 13,  0,
255,255,  0, 74,255,227,  6, 57,  7,107,  2, 39,  0, 42,  0,  0,
  0,  0,  0,  7,  1,  9,  1,131,  1,117,255,255,  0, 41,254, 70,
  5,117,  6, 70,  2, 39,  0, 74,  0,  0,  0,  0,  0,  7,  0,218,
  0,221,  0,  0,255,255,  0, 43,  0,  0,  2,215,  7,107,  2, 39,
  0, 44,  0,  0,  0,  0,  0,  7,  1, 10,255,182,  1,117,255,255,
  0, 31,254,111,  5, 82,  5,240,  2, 39,  0, 54,  0,  0,  0,  0,
  0,  7,  0,221,  0,225,  0,  0,255,255,  0, 20,254,111,  4,123,
  4,123,  2, 39,  0, 86,  0,  0,  0,  0,  0,  7,  0,221,  0, 98,
  0,  0,255,255,  0, 74,255,227,  5,203,  7,107,  2, 39,  0, 38,
  0,  0,  0,  0,  0,  7,  1,  4,  1,207,  1,117,255,255,  0, 76,
255,227,  5, 41,  6,102,  2, 39,  0, 70,  0,  0,  0,  0,  0,  7,
  0,141,  0,217,  0,  0,255,255,  0, 74,255,227,  5,219,  7,107,
  2, 39,  0, 38,  0,  0,  0,  0,  0,  7,  1,  8,  1,207,  1,117,
255,255,  0, 76,255,227,  5, 18,  6,102,  2, 39,  0, 70,  0,  0,
  0,  0,  0,  7,  0,224,  0,217,  0,  0,  0,  2,  0, 74,255,227,
  6,137,  6, 20,  0, 11,  0, 39,  0,183, 64,100,  5,  4,  2,  6,
  3,  5, 23, 18,  1,  1,  0,  2,  5, 23, 23, 18, 17,  5, 23, 18,
 16,  5, 23, 18, 13,  5, 23, 18, 38, 39,  2, 37, 12,  5, 18, 23,
 18, 27, 26,  2, 25,  5, 23, 18, 24,  5, 23, 23, 18, 58, 12, 37,
  6, 25, 23,  0, 19, 15,221, 21, 13,  6,105, 37,  0,105, 28, 96,
 37,143, 17,107, 23, 19, 22, 23, 21, 20, 18, 24, 17, 16, 15, 14,
 13,  3,  7, 25, 12, 23,  9, 20, 23, 32, 18,  9, 33, 31, 13, 40,
 16,244,236,212,228,192, 17, 18, 57, 57, 23, 57, 17, 18, 57, 18,
 57, 57, 49,  0, 47,236,228,244,236, 16,238,221, 60,238, 50, 17,
 18, 57, 17, 18, 57, 48, 75, 83, 88,  7, 16,  5,237,  7,  5,237,
 23, 50,  7, 16,  5,237, 17, 23, 57,  7,  5,237,  7,  5,237,  7,
  5,237,  7, 16,  5,237, 17, 23, 57,  7,  5,237, 17, 23, 57, 89,
 34, 37, 50, 54, 53, 52, 38, 35, 34,  6, 21, 20, 22,  1, 19, 33,
 55, 33, 55, 33,  7, 51,  7, 35,  3, 33, 55,  6,  6, 35, 34, 38,
 53, 52, 54, 55, 54, 54, 51, 50, 22,  2,117,138,173, 97, 87,136,
176, 95,  1,211, 57,254,117, 37,  1,139, 22,  1,105, 23,213, 37,
213,243,254,151, 33, 82,180,107,189,220, 77, 72, 91,229,131,115,
161,231,254,205, 93,104,251,196,102,107,  2,213,  1, 39,189,116,
116,189,251, 29,162, 98, 93,240,207,129,244,100,126,130, 93,  0,
  0,  1,  0, 51,  1,188,  2,225,  2,223,  0,  3,  0, 23, 64, 10,
  2,114,  0,113,  4,  2,  0,  1,  3,  4, 16,212,204, 57, 57, 49,
  0, 16,244,236, 48, 19, 33,  3, 33,109,  2,116, 57,253,139,  2,
223,254,221,  0,  0,  1,  0,172,  2,  6,  2, 96,  3,137,  0,  3,
  0, 47, 64, 21,  2,  5,  3,  0,  3,  1,  5,  0,  3, 58,  2, 84,
  0,  4,  2,  1,  0,  0,  0,  3,  4, 16,212,228, 16,192, 57, 49,
  0, 16,212,236, 48, 75, 83, 88,  7,  5,237,  7, 16,  5,237, 89,
 34, 19, 33,  3, 33,248,  1,104, 76,254,152,  3,137,254,125,  0,
  0,  1,255,172,255,227,  5,127,  5,240,  0, 43,  0,126, 64, 66,
 21, 25, 18,  0, 40,  3, 36,  6,181,  8, 43, 40,115,  3, 22, 25,
115, 18, 28, 14,181, 34,  8, 30, 12, 18,100,  3, 96, 44, 36, 37,
 30, 35, 29, 14,  8, 44,  6, 28, 31, 37, 35, 22,  0, 43,  3, 29,
 21, 12, 34, 15,  3, 37,  9, 13,  6, 29, 35, 37, 19,  7, 13, 21,
  6, 44, 16,212,196,196,196,252,196,196, 17, 18, 57, 18, 23, 57,
 17, 18, 23, 57, 17, 18, 57, 57, 17, 18, 57, 57, 17, 18, 57, 17,
 57, 49,  0, 16,228,228,212, 60,204, 50,236, 50, 16,254,197, 16,
254,196, 16,238, 50, 17, 18, 57, 17, 18, 57, 48, 37,  6,  6, 35,
 34,  0, 39, 35, 55, 51, 54, 54, 55, 35, 55, 51, 54,  0, 51, 50,
 22, 23,  3, 38, 38, 35, 34,  6,  7, 33,  7, 33,  6,  6,  7, 33,
  7, 33, 22, 22, 51, 50, 54, 55,  4,166,124,229,102,246,254,205,
 37,229, 88,139,  2, 11, 12,176, 86,155, 98,  1,150,246,105,211,
108, 55, 82,171,102,112,192, 68,  1,241, 86,254, 29,  7, 10,  3,
  1,182, 88,254,174, 24,155,122, 92,207,104, 70, 49, 50,  1,  8,
242,195, 32, 70, 47,195,231,  1, 17, 55, 56,254,203, 81, 76,124,
117,195, 34, 72, 43,195,119,125, 87, 81,  0,  2,  1, 43,  5,  0,
  3,211,  5,246,  0,  3,  0,  7,  0, 80, 64, 18,  4,  0,  6,  2,
  8,  6,  4,  7,  5,  2,  0,  3,  1,  5,  7,  1,  3,  8, 16,212,
212,212,196, 17, 18, 57, 57, 17, 18, 57, 57, 49,  0, 16,212, 60,
196, 50, 48, 64, 34, 32,  1, 32,  2, 32,  5, 32,  6, 48,  1, 48,
  2, 48,  5, 48,  6,  8, 47,  0, 47,  1, 47,  4, 47,  5, 63,  0,
 63,  1, 63,  4, 63,  5,  8, 93,  1, 93,  1, 51,  7, 35, 37, 51,
  7, 35,  1, 90,236, 47,236,  1,186,238, 49,236,  5,246,246,246,
246,  0,  0,  1,  1,209,  4,238,  3,223,  5,246,  0,  3,  0, 67,
181,  0,  2,  4,  1,  3,  4, 16,212,196, 49,  0, 16,212,196, 48,
  0, 75,176, 12, 84, 88,189,  0,  4,255,192,  0,  1,  0,  4,  0,
  4,  0, 64, 56, 17, 55, 56, 89, 64, 22, 27,  0, 27,  3, 43,  0,
 43,  3,  4, 15,  0, 15,  1, 31,  0, 31,  1, 47,  0, 47,  1,  6,
 93,  1, 93,  1, 33,  1, 35,  2,199,  1, 24,254,193,207,  5,246,
254,248,  0,  1,  1,  2,  4,238,  3,240,  5,248,  0, 27,  0,119,
 64, 26, 15, 14, 18, 11,  1,  0,  7, 21, 11,213,  4, 18,213, 25,
  7, 28, 21, 15, 14,  7,  1,  0,  6, 22,  8, 28, 16,212,196, 23,
 57, 49,  0, 16,212, 60,236,212,236, 50, 18, 57, 57, 17, 18, 57,
 57, 48,  0, 75,176, 12, 84, 88,189,  0, 28,255,192,  0,  1,  0,
 28,  0, 28,  0, 64, 56, 17, 55, 56, 89, 64, 40,  9,  0,  9,  1,
 11, 10, 11, 11, 11, 12, 11, 13, 11, 14, 11, 15, 11, 16, 11, 17,
 11, 18, 15, 19, 15, 20, 15, 21, 15, 22, 15, 23, 16, 25, 23, 41,
 23, 57, 23,  3, 93,  1, 93,  1, 39, 46,  1, 35, 34,  6,  7, 35,
 62,  1, 51, 50, 22, 31,  1, 30,  1, 51, 50, 54, 55, 51, 14,  1,
 35, 34, 38,  2,106, 49, 24, 33, 18, 36, 52, 11,137, 26,131, 95,
 37, 65, 35, 53, 16, 36, 16, 39, 53, 10,138, 26,131, 93, 38, 64,
  5, 33, 37, 19, 13, 64, 56,128,138, 24, 27, 41, 13, 14, 61, 58,
128,138, 22,  0,  0,  1,  1, 96,  4,238,  2,248,  5,246,  0,  3,
  0, 58,182,  0,  1,  4,  0,  1,  3,  4, 16,212,196, 57, 49,  0,
 16,212,196, 48,  0, 75,176, 12, 84, 88,189,  0,  4,255,192,  0,
  1,  0,  4,  0,  4,  0, 64, 56, 17, 55, 56, 89, 64, 13, 15,  0,
 15,  3, 31,  0, 31,  3, 47,  0, 47,  3,  6, 93,  1, 19, 35,  3,
  2,104,144,178,230,  5,246,254,248,  1,  8,  0,  0,  1,  0,231,
  4,238,  3,207,  5,246,  0,  6,  0, 71, 64, 10,  4,  0,  5,  2,
  7,  4,  1,  2,  6,  7, 16,212,196, 57, 57, 49,  0, 16,212, 60,
196, 57, 48,  0, 75,176, 12, 84, 88,189,  0,  7,255,192,  0,  1,
  0,  7,  0,  7,  0, 64, 56, 17, 55, 56, 89, 64, 19, 15,  0, 15,
  1, 15,  4, 31,  0, 31,  1, 31,  4, 47,  0, 47,  1, 47,  4,  9,
 93,  1, 33, 19, 35, 39,  7, 35,  1,219,  1, 92,152,170,164,231,
179,  5,246,254,248,161,161,  0,  0,  1,  1, 51,  4,238,  4, 12,
  5,246,  0,  6,  0, 77, 64, 10,  4,  5,  2,  0,  7,  4,  1,  6,
  2,  7, 16,212,196, 57, 57, 49,  0, 16,212,196, 50, 57, 48,  0,
 75,176, 12, 84, 88,189,  0,  7,255,192,  0,  1,  0,  7,  0,  7,
  0, 64, 56, 17, 55, 56, 89, 64, 25, 15,  2, 15,  3, 15,  5, 15,
  6, 31,  2, 31,  3, 31,  5, 31,  6, 47,  2, 47,  3, 47,  5, 47,
  6, 12, 93,  1, 33,  3, 51, 23, 55, 51,  3, 25,254,163,137,172,
148,231,178,  4,238,  1,  8,162,162,  0,  0,  1,  1, 78,  4,238,
  3,233,  5,246,  0, 14,  0, 51, 64, 11, 14,  7,  0,  4, 11, 15,
  7,  8,  1,  0, 15, 16,212,204,212,204, 49,  0, 16,212,220,196,
 50, 57, 48,  0, 75,176, 12, 84, 88,189,  0, 15,255,192,  0,  1,
  0, 15,  0, 15,  0, 64, 56, 17, 55, 56, 89,  1, 51, 30,  1, 51,
 50, 54, 55, 51, 14,  1, 35, 34, 38, 53,  1, 78,143, 10, 81, 79,
 72,106, 23,153, 39,198,148,136,146,  5,246, 60, 55, 61, 54,129,
135,135,125,  0,  0,  1,  1,223,  5,  0,  3, 33,  5,246,  0,  3,
  0, 62, 64,  9,  0,  2,  4,  2,  0,  1,  3,  3,  4, 16,196, 16,
192, 57, 57, 49,  0, 16,212,196, 48,  0, 75,176, 12, 84, 88,189,
  0,  4,255,192,  0,  1,  0,  4,  0,  4,  0, 64, 56, 17, 55, 56,
 89, 64, 10, 48,  1, 48,  2,  2, 48,  2, 48,  3,  2, 93,  1, 93,
  1, 33,  7, 33,  2, 14,  1, 19, 47,254,237,  5,246,246,  0,  0,
  0,  0,  0,  2,  0,  1,  0,  0,  0,  0,  0, 20,  0,  3,  0,  1,
  0,  0,  1, 26,  0,  0,  1,  6,  0,  0,  1,  0,  0,  0,  0,  0,
  0,  0,  1,  3,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  3,  4,  5,  6,  7,  8,
  9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24,
 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56,
 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72,
 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88,
 89, 90, 91, 92, 93, 94, 95, 96, 97,  0, 98, 99,100,101,102,103,
104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,
120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,
136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,
152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,
168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,
184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,
200,201,202,203,204,205,206,207,208,209,  0,210,211,212,213,214,
215,216,217,218,219,220,221,222,223,224,  0,  4,  2, 62,  0,  0,
  0, 58,  0, 32,  0,  4,  0, 26,  0,126,  0,255,  1,  7,  1, 17,
  1, 31,  1, 49,  1, 66,  1, 83,  1, 97,  1,120,  1,126,  1,146,
  2,199,  2,221,  3,169,  3,192, 32, 38, 32, 48, 32, 58, 32,172,
 33, 34, 34,  6, 34, 30, 34, 43, 34, 72, 34,101, 37,202,251,  2,
255,255,  0,  0,  0, 32,  0,160,  1,  6,  1, 12,  1, 30,  1, 48,
  1, 65,  1, 82,  1, 94,  1,120,  1,125,  1,146,  2,198,  2,216,
  3,169,  3,192, 32, 19, 32, 48, 32, 57, 32,172, 33, 34, 34,  2,
 34, 15, 34, 43, 34, 72, 34, 96, 37,202,251,  1,255,255,255,227,
  0,  0,255,245,  0,  0,255,216,  0,  0,255,160,255, 94,  0,  0,
255, 67,255,104,255, 20,  0,  0,  0,  0,252,246,252,219,  0,  0,
224,150,224,133,224, 86,223,106,  0,  0,  0,  0,222,113,222, 95,
  0,  0,218,239,  5,191,  0,  1,  0,  0,  0, 56,  0,  0,  0,244,
  0,  0,  0,252,  0,  0,  0,  0,  0,250,  0,  0,  0,  0,  0,  0,
  0,250,  0,252,  0,  0,  0,  0,  1,  2,  0,  0,  0,  0,  0,  0,
  0,  0,  1, 32,  1, 40,  0,  0,  0,  0,  1, 66,  0,  0,  0,  0,
  0,  0,  0,172,  0,163,  0,132,  0,133,  0,189,  0,150,  0,231,
  0,134,  0,142,  0,139,  0,157,  0,169,  0,164,  1,  0,  0,138,
  0,217,  0,131,  0,147,  0,241,  0,242,  0,141,  0,151,  0,136,
  0,195,  0,221,  0,240,  0,158,  0,170,  0,243,  0,244,  0,245,
  0,162,  0,173,  0,201,  0,199,  0,174,  0, 98,  0, 99,  0,144,
  0,100,  0,203,  0,101,  0,200,  0,202,  0,207,  0,204,  0,205,
  0,206,  0,232,  0,102,  0,210,  0,208,  0,209,  0,175,  0,103,
  0,239,  0,145,  0,213,  0,211,  0,212,  0,104,  0,234,  0,236,
  0,137,  0,106,  0,105,  0,107,  0,109,  0,108,  0,110,  0,160,
  0,111,  0,113,  0,112,  0,114,  0,115,  0,117,  0,116,  0,118,
  0,119,  0,233,  0,120,  0,122,  0,121,  0,123,  0,125,  0,124,
  0,184,  0,161,  0,127,  0,126,  0,128,  0,129,  0,235,  0,237,
  0,186,  0,253,  0,254,  0,  0,  0,  0,  0,  0,  0,255,  0,248,
  0,214,  0,249,  0,250,  0,227,  0,228,  0,215,  0,224,  0,218,
  0,219,  0,220,  0,223,  0,216,  0,222,  0,178,  0,179,  0,  0,
  0,  0,  0,  0,  0,182,  0,183,  0,196,  0,  0,  0,180,  0,181,
  0,197,  0,  0,  0,130,  0,194,  0,135,  0,  0,  0,  0,  0,  0,
  0,171,  0,152,  0,  0,  0,  0,  0,  0,  0,168,  0,154,  0,  0,
  0,153,  0,238,  0,  0,  0,  0,  0,188,  0,  0,  0,  0,  0,  0,
  1,  1,  0,165,  0,  0,  0,  0,  0,  0,  0,146,  0,143,  0,  0,
  0,  0,  0,  0,  0,148,  0,149,  4,205,  0,102,  0,  0,  0,  0,
  2,201,  0,  0,  2,201,  0,  0,  3,166,  0,141,  4, 43,  0,195,
  5,145,  0,133,  5,145,  0, 55,  8,  4,  0,113,  6,250,  0, 57,
  2,115,  0,195,  3,168,  0,158,  3,168,255,201,  4, 47,  0, 41,
  6,180,  0,217,  3, 10,255,186,  3, 82,  0, 51,  3, 10,  0, 94,
  2,236,255, 59,  5,145,  0, 74,  5,145,  0, 88,  5,145,  0, 16,
  5,145,  0,  0,  5,145,255,254,  5,145,  0, 27,  5,145,  0,102,
  5,145,  0,160,  5,145,  0, 45,  5,145,  0, 84,  3, 51,  0, 84,
  3, 51,255,184,  6,180,  0,217,  6,180,  0,217,  6,180,  0,217,
  4,164,  0,213,  8,  0,  0, 92,  6, 49,255,123,  6, 25,  0, 43,
  5,223,  0, 74,  6,164,  0, 43,  5,119,  0, 43,  5,119,  0, 43,
  6,145,  0, 74,  6,178,  0, 43,  2,250,  0, 43,  2,250,254,172,
  6, 51,  0, 43,  5, 25,  0, 43,  7,246,  0, 43,  6,178,  0, 43,
  6,205,  0, 74,  5,221,  0, 43,  6,205,  0, 74,  6, 41,  0, 43,
  5,195,  0, 31,  5,117,  0, 98,  6,127,  0,139,  6, 49,  0,156,
  8,211,  0,219,  6, 43,255,152,  5,203,  0,129,  5,205,255,203,
  3,168,255,236,  2,236,  0,145,  3,168,255,199,  6,180,  0,207,
  4,  0,255,236,  4,  0,  1, 12,  5,102,  0, 35,  5,186,  0, 63,
  4,190,  0, 76,  5,186,  0, 74,  5,109,  0, 74,  3,123,  0,102,
  5,186,  0, 41,  5,178,  0, 63,  2,190,  0, 63,  2,190,254,250,
  5, 82,  0, 63,  2,190,  0, 63,  8, 86,  0, 63,  5,178,  0, 63,
  5,127,  0, 74,  5,186,255,236,  5,186,  0, 74,  3,242,  0, 63,
  4,195,  0, 20,  3,211,  0, 88,  5,178,  0,123,  5, 55,  0,129,
  7,100,  0,178,  5, 41,255,172,  5, 55,  0,  0,  4,168,255,238,
  5,178,  0,217,  2,236,  1,  4,  5,178,  0, 90,  6,180,  0,217,
  6, 49,255,123,  6, 49,255,123,  5,223,  0, 74,  5,119,  0, 43,
  6,178,  0, 43,  6,205,  0, 74,  6,127,  0,139,  5,102,  0, 35,
  5,102,  0, 35,  5,102,  0, 35,  5,102,  0, 35,  5,102,  0, 35,
  5,102,  0, 35,  4,190,  0, 76,  5,109,  0, 74,  5,109,  0, 74,
  5,109,  0, 74,  5,109,  0, 74,  2,190,  0, 63,  2,190,  0, 63,
  2,190,  0, 63,  2,190,  0, 63,  5,178,  0, 63,  5,127,  0, 74,
  5,127,  0, 74,  5,127,  0, 74,  5,127,  0, 74,  5,127,  0, 74,
  5,178,  0,123,  5,178,  0,123,  5,178,  0,123,  5,178,  0,123,
  4,  0,  0, 78,  4,  0,  0,178,  5,145,  0,137,  5,145,  0, 14,
  4,  0,255,188,  5, 29,  1, 39,  5, 23,  0,152,  5,193,  0, 63,
  8,  0,  1, 27,  8,  0,  1, 27,  8,  0,  1, 39,  4,  0,  1,209,
  4,  0,  1, 55,  6,180,  0,217,  8,174,255, 96,  6,205,255,160,
  6,170,  0,195,  6,180,  0,217,  6,180,  0,217,  6,180,  0,217,
  5,145,  0, 12,  5,227,255,201,  4, 90,  0, 59,  5,190,  0, 41,
  6, 76,  0,150,  5, 39,255,221,  4,225,  0, 51,  4,131,  0, 88,
  4,131,  0, 94,  6, 39,  0, 55,  8, 98,  0, 35,  5,127,255,221,
  4,164,  0, 76,  3,166,  0,141,  6,180,  0,217,  5, 86,  0, 76,
  5,145,255,233,  6,180,  0,217,  5,147,  0,  0,  5, 51,  0,125,
  5, 51,  0,117,  8,  0,  0, 94,  5,145,  0,  0,  6, 49,255,123,
  6, 49,255,123,  6,205,  0, 74,  9, 86,  0, 86,  8,193,  0, 74,
  4,  0,255,195,  8,  0,255,195,  5, 39,  0,231,  5, 39,  0,150,
  3, 10,  0,231,  3, 10,  0,150,  6,180,  0,217,  3,244,  0,  6,
  5, 55,  0,  0,  5,203,  0,129,  1, 86,253,199,  5, 23,  0, 74,
  3, 76,  0,125,  3, 76,  0, 78,  6, 76,  0,102,  6, 76,  0,102,
  4,  0,255,199,  3, 10,  0,172,  3, 10,255,186,  5, 39,255,186,
 11,162,  0,113,  6, 49,255,123,  5,119,  0, 43,  6, 49,255,123,
  5,119,  0, 43,  5,119,  0, 43,  2,250,  0, 43,  2,250,  0, 43,
  2,250,  0, 43,  2,250,  0, 43,  6,205,  0, 74,  6,205,  0, 74,
  6,205,  0, 74,  6,127,  0,139,  6,127,  0,139,  6,127,  0,139,
  2,190,  0, 63,  4,  0,  0,217,  4,  0,  1, 16,  4,  0,  1, 61,
  4,  0,  1, 84,  4,  0,  1,233,  4,  0,  1,121,  4,  0,  0, 45,
  4,  0,  1, 37,  4,  0,  0,150,  4,  0,  1, 53,  5, 72,255,209,
  3,  0,255,242,  5,195,  0, 31,  4,195,  0, 20,  5,205,255,203,
  4,168,255,238,  2,236,  1,  4,  6,195,255,252,  5,127,  0, 74,
  5,203,  0,129,  5, 55,  0,  0,  5,240,  0, 43,  5,186,255,236,
  6,180,  0,217,  6,180,  1,  0,  3,129,  0,137,  3,129,  0, 92,
  3,129,  0, 82,  8,133,  0,137,  8,133,  0,137,  8,133,  0, 90,
  6,145,  0, 74,  5,186,  0, 41,  2,250,  0, 43,  5,195,  0, 31,
  4,195,  0, 20,  5,223,  0, 74,  4,190,  0, 76,  5,223,  0, 74,
  4,190,  0, 76,  5,186,  0, 74,  3, 82,  0, 51,  3, 10,  0,172,
  5,145,255,172,  4,  0,  1, 43,  4,  0,  1,209,  4,  0,  1,  2,
  4,  0,  1, 96,  4,  0,  0,231,  4,  0,  1, 51,  4,  0,  1, 78,
  4,  0,  1,223,  0,  2,  0,  0,255,245,  0,  0,255, 29,  1,  2,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  1, 11,  0,  0,  0,  1,  0,  2,  0,  3,  0,  4,
  0,  5,  0,  6,  0,  7,  0,  8,  0,  9,  0, 10,  0, 11,  0, 12,
  0, 13,  0, 14,  0, 15,  0, 16,  0, 17,  0, 18,  0, 19,  0, 20,
  0, 21,  0, 22,  0, 23,  0, 24,  0, 25,  0, 26,  0, 27,  0, 28,
  0, 29,  0, 30,  0, 31,  0, 32,  0, 33,  0, 34,  0, 35,  0, 36,
  0, 37,  0, 38,  0, 39,  0, 40,  0, 41,  0, 42,  0, 43,  0, 44,
  0, 45,  0, 46,  0, 47,  0, 48,  0, 49,  0, 50,  0, 51,  0, 52,
  0, 53,  0, 54,  0, 55,  0, 56,  0, 57,  0, 58,  0, 59,  0, 60,
  0, 61,  0, 62,  0, 63,  0, 64,  0, 65,  0, 66,  0, 67,  0, 68,
  0, 69,  0, 70,  0, 71,  0, 72,  0, 73,  0, 74,  0, 75,  0, 76,
  0, 77,  0, 78,  0, 79,  0, 80,  0, 81,  0, 82,  0, 83,  0, 84,
  0, 85,  0, 86,  0, 87,  0, 88,  0, 89,  0, 90,  0, 91,  0, 92,
  0, 93,  0, 94,  0, 95,  0, 96,  0, 97,  0, 98,  0, 99,  0,100,
  0,101,  0,102,  0,103,  0,104,  0,105,  0,106,  0,107,  0,108,
  0,109,  0,110,  0,111,  0,112,  0,113,  0,114,  0,115,  0,116,
  0,117,  0,118,  0,119,  0,120,  0,121,  0,122,  0,123,  0,124,
  0,125,  0,126,  0,127,  0,128,  0,129,  0,130,  0,131,  0,132,
  0,133,  0,134,  0,135,  0,136,  0,137,  0,138,  0,139,  0,140,
  0,141,  0,142,  0,143,  0,144,  0,145,  0,146,  0,147,  0,148,
  0,149,  0,150,  0,151,  0,152,  0,153,  0,154,  0,155,  0,156,
  0,157,  0,158,  0,159,  0,160,  0,161,  0,162,  0,163,  0,164,
  0,165,  0,166,  0,167,  0,168,  0,169,  0,170,  0,171,  0,172,
  0,173,  0,174,  0,175,  0,176,  0,177,  0,178,  0,179,  0,180,
  0,181,  0,182,  0,183,  0,184,  0,185,  0,186,  0,187,  0,188,
  0,189,  0,190,  0,191,  0,192,  0,193,  0,194,  0,195,  0,196,
  0,197,  0,198,  0,199,  0,200,  0,201,  0,202,  0,203,  0,204,
  0,205,  0,206,  0,207,  0,208,  0,209,  0,211,  0,212,  0,213,
  0,214,  0,215,  0,216,  0,217,  0,218,  0,219,  0,220,  0,221,
  0,222,  0,223,  0,224,  0,225,  0,226,  0,227,  0,228,  0,229,
  0,230,  0,231,  0,232,  0,233,  0,234,  0,235,  0,236,  0,237,
  0,238,  0,239,  0,240,  0,241,  0,242,  0,243,  0,245,  0,244,
  0,246,  0,248,  0,249,  0,250,  0,251,  0,252,  0,253,  0,254,
  0,255,  1,  0,  1,  1,  1,  2,  1,  3,  1,  4,  1,  5,  1,  6,
  1,  7,  1,  8,  1,  9,  1, 10,  1, 11,  1, 12,  9,115,102,116,
104,121,112,104,101,110, 14,112,101,114,105,111,100, 99,101,110,
116,101,114,101,100,  4, 69,117,114,111,  5, 99, 54, 52, 53, 57,
  5, 99, 54, 52, 54, 48,  5, 99, 54, 52, 54, 49,  5, 99, 54, 52,
 54, 50,  5, 99, 54, 52, 54, 51,  5, 99, 54, 52, 54, 54,  5, 99,
 54, 52, 54, 55,  5, 99, 54, 52, 54, 56,  0,  0,  0,  0,  0, 34,
  0, 34,  0, 34,  0, 34,  0,105,  0,140,  0,242,  1,128,  1,248,
  2,207,  2,231,  3, 23,  3, 69,  3,142,  3,184,  3,229,  3,255,
  4, 37,  4, 74,  4,161,  4,246,  5, 98,  5,213,  6, 71,  6,195,
  7, 62,  7,108,  7,240,  8,113,  8,175,  8,246,  9, 27,  9, 60,
  9, 95,  9,217, 10,127, 10,236, 11, 89, 11,176, 11,255, 12, 70,
 12,135, 12,245, 13, 77, 13,119, 13,198, 14,109, 14,164, 15, 69,
 15,159, 15,248, 16, 75, 16,196, 17, 63, 18,  3, 18, 72, 18,168,
 18,245, 19,153, 20, 25, 20,110, 20,164, 20,220, 20,246, 21, 43,
 21, 77, 21, 99, 21,139, 22, 73, 22,196, 23, 14, 23,137, 23,237,
 24,103, 24,255, 25,117, 25,184, 26, 36, 26,161, 26,203, 27,145,
 28,  8, 28, 78, 28,206, 29, 76, 29,183, 30, 78, 30,205, 31,104,
 31,206, 32, 87, 32,247, 33,123, 33,208, 34,113, 34,135, 35, 44,
 35,110, 35,123, 36, 32, 36, 45, 36, 58, 36, 71, 36, 84, 36, 97,
 36,110, 36,123, 36,136, 36,149, 36,162, 36,175, 36,188, 36,201,
 36,214, 36,227, 36,240, 36,253, 37, 10, 37, 23, 37, 36, 37, 49,
 37, 62, 37, 75, 37, 88, 37,101, 37,114, 37,127, 37,140, 37,153,
 37,166, 37,239, 38, 46, 38,159, 39, 16, 39,176, 39,226, 40, 51,
 40,220, 41,132, 42, 23, 42,119, 42,180, 43,  2, 43, 69, 43,193,
 44,165, 45, 13, 45, 68, 45,115, 45,160, 46, 27, 46,167, 47,  3,
 47, 56, 47, 91, 47,149, 47,245, 48,226, 49, 68, 49,155, 50,116,
 50,251, 51,120, 51,193, 51,221, 52, 43, 52,172, 53, 39, 53, 76,
 53,137, 53,197, 54, 33, 54, 33, 54, 46, 54, 59, 54, 72, 54,197,
 55, 90, 55,118, 55,146, 55,228, 56, 52, 56, 99, 56,144, 56,193,
 57, 21, 57, 34, 57, 47, 57, 69, 57,206, 57,241, 58, 18, 58,181,
 59, 58, 59,163, 59,201, 59,246, 60, 70, 60,233, 60,246, 61,  3,
 61, 16, 61, 29, 61, 42, 61, 55, 61, 68, 61, 81, 61, 94, 61,107,
 61,120, 61,133, 61,146, 61,159, 61,172, 61,211, 62,  1, 62,117,
 62,153, 62,239, 63, 35, 63,105, 63,156, 63,245, 64, 54, 64,112,
 64,193, 65, 43, 65, 56, 65, 69, 65, 82, 65, 95, 65,130, 65,245,
 66,150, 66,163, 66,176, 67, 17, 67,143, 67,165, 67,222, 68, 56,
 68,148, 69, 10, 69,197, 70,123, 71, 96, 71,109, 71,122, 71,135,
 71,148, 71,161, 71,174, 71,187, 71,200, 71,213, 72,112, 72,138,
 72,176, 73, 53, 73,113, 73,161, 74, 10, 74, 54, 74,108, 74,165,
 74,218, 75,  7,  0,  0,  0,  1,  0,  0, 23, 96,  0,  1,  3,227,
 12,  0,  0,  9, 11, 82,  0, 16,  0, 55,254,211,  0, 16,  0, 57,
255,107,  0, 16,  0, 58,255,164,  0, 16,  0, 59,255, 50,  0, 16,
  0, 60,254,173,  0, 16,  0,187,254,173,  0, 16,  0,234,254,173,
  0, 36,  0, 15,  0, 38,  0, 36,  0, 17,  0, 38,  0, 36,  0, 29,
  0, 38,  0, 36,  0, 30,  0, 38,  0, 36,  0, 38,255,193,  0, 36,
  0, 50,255,193,  0, 36,  0, 55,255, 60,  0, 36,  0, 56,255,164,
  0, 36,  0, 57,255,117,  0, 36,  0, 58,255,144,  0, 36,  0, 60,
255, 21,  0, 36,  0, 70,255,193,  0, 36,  0, 71,255,193,  0, 36,
  0, 87,255,144,  0, 36,  0, 89,255,144,  0, 36,  0, 90,255,164,
  0, 36,  0, 92,255,107,  0, 36,  0,100,255,193,  0, 36,  0,103,
255,193,  0, 36,  0,104,255,164,  0, 36,  0,111,255,193,  0, 36,
  0,145,255,193,  0, 36,  0,175,255,193,  0, 36,  0,176,255,193,
  0, 36,  0,181,255,  3,  0, 36,  0,183,255,  3,  0, 36,  0,186,
255,107,  0, 36,  0,187,255, 21,  0, 36,  0,196,  0,104,  0, 36,
  0,197,  0,104,  0, 36,  0,208,255,193,  0, 36,  0,209,255,193,
  0, 36,  0,210,255,193,  0, 36,  0,211,255,164,  0, 36,  0,212,
255,164,  0, 36,  0,213,255,164,  0, 36,  0,234,255, 21,  0, 36,
  0,235,255,107,  0, 36,  0,251,255,193,  0, 36,  0,252,255,193,
  0, 36,  0,253,255,193,  0, 36,  0,254,255,193,  0, 36,  0,255,
255,193,  0, 37,  0, 57,255,173,  0, 37,  0, 58,255,144,  0, 37,
  0, 60,255,144,  0, 37,  0,187,255,144,  0, 37,  0,234,255,144,
  0, 38,  0, 54,255,183,  0, 38,  0,227,255,183,  0, 38,  0,249,
255,183,  0, 39,  0, 16,  0, 38,  0, 39,  0, 60,255, 97,  0, 39,
  0,187,255, 97,  0, 39,  0,196,255,220,  0, 39,  0,197,255,220,
  0, 39,  0,234,255, 97,  0, 41,  0, 15,254, 68,  0, 41,  0, 16,
255,154,  0, 41,  0, 17,254, 60,  0, 41,  0, 29,255,144,  0, 41,
  0, 30,255,144,  0, 41,  0, 36,254,248,  0, 41,  0, 68,255, 21,
  0, 41,  0, 72,255, 97,  0, 41,  0, 82,255, 97,  0, 41,  0, 85,
255, 31,  0, 41,  0, 88,255, 60,  0, 41,  0, 92,255, 68,  0, 41,
  0, 98,254,248,  0, 41,  0,105,255, 21,  0, 41,  0,106,255, 21,
  0, 41,  0,107,255, 21,  0, 41,  0,108,255, 21,  0, 41,  0,109,
255, 21,  0, 41,  0,110,255, 21,  0, 41,  0,112,255, 97,  0, 41,
  0,113,255, 97,  0, 41,  0,114,255, 97,  0, 41,  0,115,255, 97,
  0, 41,  0,121,255, 97,  0, 41,  0,122,255, 97,  0, 41,  0,123,
255, 97,  0, 41,  0,124,255, 97,  0, 41,  0,125,255, 97,  0, 41,
  0,126,255, 60,  0, 41,  0,127,255, 60,  0, 41,  0,128,255, 60,
  0, 41,  0,129,255, 60,  0, 41,  0,160,255, 21,  0, 41,  0,161,
255, 97,  0, 41,  0,173,254,248,  0, 41,  0,174,254,248,  0, 41,
  0,177,255, 97,  0, 41,  0,183,255,220,  0, 41,  0,186,255, 68,
  0, 41,  0,196,254, 60,  0, 41,  0,197,254, 60,  0, 41,  0,199,
254,248,  0, 41,  0,201,254,248,  0, 41,  0,235,255, 68,  0, 42,
  0, 55,255,220,  0, 42,  0, 60,255,173,  0, 42,  0,187,255,173,
  0, 42,  0,234,255,173,  0, 46,  0, 16,255,  3,  0, 46,  0, 38,
255,125,  0, 46,  0, 50,255,125,  0, 46,  0, 56,255,183,  0, 46,
  0, 58,255,201,  0, 46,  0, 72,255,144,  0, 46,  0, 82,255,144,
  0, 46,  0, 88,255,144,  0, 46,  0, 92,255, 50,  0, 46,  0,100,
255,125,  0, 46,  0,103,255,125,  0, 46,  0,104,255,183,  0, 46,
  0,112,255,144,  0, 46,  0,113,255,144,  0, 46,  0,114,255,144,
  0, 46,  0,115,255,144,  0, 46,  0,121,255,144,  0, 46,  0,122,
255,144,  0, 46,  0,123,255,144,  0, 46,  0,124,255,144,  0, 46,
  0,125,255,144,  0, 46,  0,126,255,144,  0, 46,  0,127,255,144,
  0, 46,  0,128,255,144,  0, 46,  0,129,255,144,  0, 46,  0,145,
255,201,  0, 46,  0,161,255,144,  0, 46,  0,175,255,125,  0, 46,
  0,176,255, 78,  0, 46,  0,177,255,144,  0, 46,  0,186,255, 50,
  0, 46,  0,196,  0, 38,  0, 46,  0,197,  0, 38,  0, 46,  0,208,
255,125,  0, 46,  0,209,255,125,  0, 46,  0,210,255,125,  0, 46,
  0,211,255,183,  0, 46,  0,212,255,183,  0, 46,  0,213,255,183,
  0, 46,  0,235,255, 50,  0, 46,  0,251,255,125,  0, 46,  0,253,
255,125,  0, 47,  0, 50,255,183,  0, 47,  0, 55,254,173,  0, 47,
  0, 56,255,144,  0, 47,  0, 57,254,230,  0, 47,  0, 58,255, 78,
  0, 47,  0, 60,254,193,  0, 47,  0, 92,255,  3,  0, 47,  0,103,
255,183,  0, 47,  0,104,255,144,  0, 47,  0,145,255,183,  0, 47,
  0,175,255,183,  0, 47,  0,176,255,183,  0, 47,  0,181,253,240,
  0, 47,  0,183,254,  3,  0, 47,  0,186,255,  3,  0, 47,  0,187,
254,193,  0, 47,  0,208,255,183,  0, 47,  0,209,255,183,  0, 47,
  0,210,255,183,  0, 47,  0,211,255,144,  0, 47,  0,212,255,144,
  0, 47,  0,213,255,144,  0, 47,  0,234,254,193,  0, 47,  0,235,
255,  3,  0, 50,  0, 15,255,211,  0, 50,  0, 16,  0, 38,  0, 50,
  0, 17,255,211,  0, 50,  0, 57,255,183,  0, 50,  0, 59,255,183,
  0, 50,  0, 60,255,107,  0, 50,  0,187,255,107,  0, 50,  0,234,
255,107,  0, 51,  0, 15,253,240,  0, 51,  0, 16,255,220,  0, 51,
  0, 17,253,240,  0, 51,  0, 36,255, 68,  0, 51,  0, 68,255,125,
  0, 51,  0, 72,255,201,  0, 51,  0, 85,255,193,  0, 51,  0, 86,
255,183,  0, 51,  0, 88,255,183,  0, 51,  0, 98,255, 68,  0, 51,
  0,105,255,125,  0, 51,  0,106,255,125,  0, 51,  0,107,255,125,
  0, 51,  0,108,255,125,  0, 51,  0,109,255,125,  0, 51,  0,110,
255,125,  0, 51,  0,112,255,201,  0, 51,  0,113,255,201,  0, 51,
  0,114,255,201,  0, 51,  0,115,255,201,  0, 51,  0,126,255,183,
  0, 51,  0,127,255,183,  0, 51,  0,128,255,183,  0, 51,  0,129,
255,183,  0, 51,  0,160,255,125,  0, 51,  0,173,255, 68,  0, 51,
  0,174,255, 68,  0, 51,  0,181,  0, 38,  0, 51,  0,183,  0, 57,
  0, 51,  0,196,254, 97,  0, 51,  0,197,254, 97,  0, 51,  0,199,
255, 68,  0, 51,  0,201,255, 68,  0, 51,  0,228,255,183,  0, 51,
  0,250,255,183,  0, 52,  0, 16,  0, 38,  0, 53,  0, 15,  0, 38,
  0, 53,  0, 17,  0, 38,  0, 53,  0, 55,255,164,  0, 53,  0, 60,
255, 68,  0, 53,  0, 72,255,154,  0, 53,  0, 82,255,154,  0, 53,
  0, 88,255,144,  0, 53,  0, 92,255,125,  0, 53,  0,112,255,154,
  0, 53,  0,113,255,154,  0, 53,  0,114,255,154,  0, 53,  0,115,
255,154,  0, 53,  0,121,255,154,  0, 53,  0,122,255,154,  0, 53,
  0,123,255,154,  0, 53,  0,124,255,154,  0, 53,  0,125,255,154,
  0, 53,  0,126,255,144,  0, 53,  0,127,255,144,  0, 53,  0,128,
255,144,  0, 53,  0,129,255,144,  0, 53,  0,161,255,154,  0, 53,
  0,177,255,154,  0, 53,  0,186,255,125,  0, 53,  0,187,255, 68,
  0, 53,  0,234,255, 68,  0, 53,  0,235,255,125,  0, 54,  0, 54,
255,183,  0, 54,  0,227,255,183,  0, 54,  0,249,255,183,  0, 55,
  0, 15,254,183,  0, 55,  0, 16,254,211,  0, 55,  0, 17,254,164,
  0, 55,  0, 29,255,144,  0, 55,  0, 30,255,144,  0, 55,  0, 36,
255, 97,  0, 55,  0, 55,  0, 47,  0, 55,  0, 68,255, 13,  0, 55,
  0, 70,254,248,  0, 55,  0, 72,254,248,  0, 55,  0, 82,254,248,
  0, 55,  0, 85,255, 31,  0, 55,  0, 86,255, 13,  0, 55,  0, 88,
254,248,  0, 55,  0, 90,254,230,  0, 55,  0, 92,254,173,  0, 55,
  0, 98,255, 97,  0, 55,  0,105,255, 13,  0, 55,  0,106,255, 13,
  0, 55,  0,107,255, 13,  0, 55,  0,108,255, 13,  0, 55,  0,109,
255, 13,  0, 55,  0,110,255, 13,  0, 55,  0,111,254,248,  0, 55,
  0,112,254,248,  0, 55,  0,113,254,248,  0, 55,  0,114,254,248,
  0, 55,  0,115,254,248,  0, 55,  0,121,254,248,  0, 55,  0,122,
254,248,  0, 55,  0,123,254,248,  0, 55,  0,124,254,248,  0, 55,
  0,125,254,248,  0, 55,  0,126,254,248,  0, 55,  0,127,254,248,
  0, 55,  0,128,254,248,  0, 55,  0,129,254,248,  0, 55,  0,160,
255, 13,  0, 55,  0,161,254,248,  0, 55,  0,173,255, 97,  0, 55,
  0,174,255, 97,  0, 55,  0,177,254,248,  0, 55,  0,186,254,173,
  0, 55,  0,196,254,211,  0, 55,  0,197,254,211,  0, 55,  0,199,
255, 97,  0, 55,  0,201,255, 97,  0, 55,  0,228,255, 13,  0, 55,
  0,235,254,173,  0, 55,  0,250,255, 13,  0, 55,  0,252,254,248,
  0, 55,  0,254,254,248,  0, 56,  0, 36,255,164,  0, 56,  0, 98,
255,164,  0, 56,  0,173,255,164,  0, 56,  0,174,255,164,  0, 56,
  0,199,255,164,  0, 56,  0,201,255,164,  0, 57,  0, 15,254,193,
  0, 57,  0, 16,255,107,  0, 57,  0, 17,254,193,  0, 57,  0, 29,
255,164,  0, 57,  0, 30,255,164,  0, 57,  0, 36,255,117,  0, 57,
  0, 50,255,220,  0, 57,  0, 68,255, 97,  0, 57,  0, 72,255,107,
  0, 57,  0, 76,255,220,  0, 57,  0, 82,255,107,  0, 57,  0, 88,
255,107,  0, 57,  0, 98,255,117,  0, 57,  0,103,255,220,  0, 57,
  0,105,255, 97,  0, 57,  0,106,255, 97,  0, 57,  0,107,255, 97,
  0, 57,  0,108,255, 97,  0, 57,  0,109,255, 97,  0, 57,  0,110,
255, 97,  0, 57,  0,112,255,107,  0, 57,  0,113,255,107,  0, 57,
  0,114,255,107,  0, 57,  0,115,255,107,  0, 57,  0,121,255,107,
  0, 57,  0,122,255,107,  0, 57,  0,123,255,107,  0, 57,  0,124,
255,107,  0, 57,  0,125,255,107,  0, 57,  0,126,255,107,  0, 57,
  0,127,255,107,  0, 57,  0,128,255,107,  0, 57,  0,129,255,107,
  0, 57,  0,145,255,220,  0, 57,  0,160,255, 97,  0, 57,  0,161,
255,107,  0, 57,  0,173,255,117,  0, 57,  0,174,255,117,  0, 57,
  0,175,255,220,  0, 57,  0,176,255,211,  0, 57,  0,177,255,107,
  0, 57,  0,196,254,240,  0, 57,  0,197,254,240,  0, 57,  0,199,
255,117,  0, 57,  0,201,255,117,  0, 57,  0,208,255,220,  0, 57,
  0,209,255,220,  0, 57,  0,210,255,220,  0, 58,  0, 15,255, 78,
  0, 58,  0, 16,255,164,  0, 58,  0, 17,255, 78,  0, 58,  0, 29,
255,193,  0, 58,  0, 30,255,193,  0, 58,  0, 36,255,183,  0, 58,
  0, 68,255,117,  0, 58,  0, 72,255,125,  0, 58,  0, 82,255,144,
  0, 58,  0, 85,255,136,  0, 58,  0, 98,255,183,  0, 58,  0,105,
255,117,  0, 58,  0,106,255,117,  0, 58,  0,107,255,117,  0, 58,
  0,108,255,117,  0, 58,  0,109,255,117,  0, 58,  0,110,255,117,
  0, 58,  0,112,255,125,  0, 58,  0,113,255,125,  0, 58,  0,114,
255,125,  0, 58,  0,115,255,125,  0, 58,  0,121,255,144,  0, 58,
  0,122,255,144,  0, 58,  0,123,255,144,  0, 58,  0,124,255,144,
  0, 58,  0,125,255,144,  0, 58,  0,160,255,117,  0, 58,  0,161,
255,144,  0, 58,  0,173,255,183,  0, 58,  0,174,255,183,  0, 58,
  0,177,255,144,  0, 58,  0,199,255,183,  0, 58,  0,201,255,183,
  0, 59,  0, 16,255, 13,  0, 59,  0, 38,255,183,  0, 59,  0, 50,
255,183,  0, 59,  0, 72,255,125,  0, 59,  0,100,255,183,  0, 59,
  0,103,255,183,  0, 59,  0,112,255,125,  0, 59,  0,113,255,125,
  0, 59,  0,114,255,125,  0, 59,  0,115,255,125,  0, 59,  0,145,
255,183,  0, 59,  0,175,255,183,  0, 59,  0,176,255,144,  0, 59,
  0,208,255,183,  0, 59,  0,209,255,183,  0, 59,  0,210,255,183,
  0, 59,  0,251,255,183,  0, 59,  0,253,255,183,  0, 60,  0, 15,
254,173,  0, 60,  0, 16,254,211,  0, 60,  0, 17,254,173,  0, 60,
  0, 29,255, 78,  0, 60,  0, 30,255, 78,  0, 60,  0, 36,255, 60,
  0, 60,  0, 38,255,183,  0, 60,  0, 50,255,183,  0, 60,  0, 68,
255, 13,  0, 60,  0, 72,254,248,  0, 60,  0, 82,254,248,  0, 60,
  0, 88,255, 31,  0, 60,  0, 98,255, 60,  0, 60,  0,100,255,183,
  0, 60,  0,103,255,183,  0, 60,  0,105,255, 13,  0, 60,  0,106,
255, 13,  0, 60,  0,107,255, 13,  0, 60,  0,108,255, 13,  0, 60,
  0,109,255, 13,  0, 60,  0,110,255, 13,  0, 60,  0,112,254,248,
  0, 60,  0,113,254,248,  0, 60,  0,114,254,248,  0, 60,  0,115,
254,248,  0, 60,  0,121,254,248,  0, 60,  0,122,254,248,  0, 60,
  0,123,254,248,  0, 60,  0,124,254,248,  0, 60,  0,125,254,248,
  0, 60,  0,126,255, 31,  0, 60,  0,127,255, 31,  0, 60,  0,128,
255, 31,  0, 60,  0,129,255, 31,  0, 60,  0,145,255,183,  0, 60,
  0,160,255, 13,  0, 60,  0,161,254,248,  0, 60,  0,173,255, 60,
  0, 60,  0,174,255, 60,  0, 60,  0,175,255,183,  0, 60,  0,176,
255,136,  0, 60,  0,177,254,248,  0, 60,  0,196,254,136,  0, 60,
  0,197,254,107,  0, 60,  0,199,255, 60,  0, 60,  0,201,255, 60,
  0, 60,  0,208,255,183,  0, 60,  0,209,255,183,  0, 60,  0,210,
255,183,  0, 60,  0,251,255,183,  0, 60,  0,253,255,183,  0, 61,
  0, 16,255,107,  0, 68,  0, 92,255,193,  0, 68,  0,186,255,193,
  0, 68,  0,235,255,193,  0, 73,  0, 15,255,144,  0, 73,  0, 16,
255,220,  0, 73,  0, 17,255,144,  0, 73,  0,181,  0, 86,  0, 73,
  0,183,  0,141,  0, 78,  0, 72,255,183,  0, 78,  0, 82,255,183,
  0, 78,  0,112,255,183,  0, 78,  0,113,255,183,  0, 78,  0,114,
255,183,  0, 78,  0,115,255,183,  0, 78,  0,121,255,183,  0, 78,
  0,122,255,183,  0, 78,  0,123,255,183,  0, 78,  0,124,255,183,
  0, 78,  0,125,255,183,  0, 78,  0,161,255,211,  0, 78,  0,177,
255,183,  0, 85,  0, 15,254,211,  0, 85,  0, 17,254,220,  0, 85,
  0,181,  0, 38,  0, 85,  0,183,  0, 86,  0, 89,  0, 15,255, 89,
  0, 89,  0, 17,255, 89,  0, 90,  0, 15,255,125,  0, 90,  0, 17,
255,125,  0, 92,  0, 15,255, 97,  0, 92,  0, 17,255, 68,  0, 98,
  0, 15,  0, 38,  0, 98,  0, 17,  0, 38,  0, 98,  0, 29,  0, 38,
  0, 98,  0, 30,  0, 38,  0, 98,  0, 38,255,193,  0, 98,  0, 50,
255,193,  0, 98,  0, 55,255, 60,  0, 98,  0, 56,255,164,  0, 98,
  0, 57,255,117,  0, 98,  0, 58,255,144,  0, 98,  0, 60,255, 21,
  0, 98,  0, 70,255,193,  0, 98,  0, 71,255,193,  0, 98,  0, 87,
255,144,  0, 98,  0, 89,255,144,  0, 98,  0, 90,255,164,  0, 98,
  0, 92,255,107,  0, 98,  0,100,255,193,  0, 98,  0,103,255,193,
  0, 98,  0,104,255,164,  0, 98,  0,111,255,193,  0, 98,  0,145,
255,193,  0, 98,  0,175,255,193,  0, 98,  0,176,255,193,  0, 98,
  0,181,255,  3,  0, 98,  0,183,255,  3,  0, 98,  0,186,255,107,
  0, 98,  0,187,255, 21,  0, 98,  0,196,  0,104,  0, 98,  0,197,
  0,104,  0, 98,  0,208,255,193,  0, 98,  0,209,255,193,  0, 98,
  0,210,255,193,  0, 98,  0,211,255,164,  0, 98,  0,212,255,164,
  0, 98,  0,213,255,164,  0, 98,  0,234,255, 21,  0, 98,  0,235,
255,107,  0, 98,  0,251,255,193,  0, 98,  0,252,255,193,  0, 98,
  0,253,255,193,  0, 98,  0,254,255,193,  0, 98,  0,255,255,193,
  0,100,  0, 54,255,183,  0,100,  0,227,255,183,  0,100,  0,249,
255,183,  0,103,  0, 15,255,211,  0,103,  0, 16,  0, 38,  0,103,
  0, 17,255,211,  0,103,  0, 57,255,183,  0,103,  0, 59,255,183,
  0,103,  0, 60,255,107,  0,103,  0,187,255,107,  0,103,  0,234,
255,107,  0,104,  0, 36,255,164,  0,104,  0, 98,255,164,  0,104,
  0,173,255,164,  0,104,  0,174,255,164,  0,104,  0,199,255,164,
  0,104,  0,201,255,164,  0,105,  0, 92,255,193,  0,105,  0,186,
255,193,  0,105,  0,235,255,193,  0,106,  0, 92,255,193,  0,106,
  0,186,255,193,  0,106,  0,235,255,193,  0,107,  0, 92,255,193,
  0,107,  0,186,255,193,  0,107,  0,235,255,193,  0,108,  0, 92,
255,193,  0,108,  0,186,255,193,  0,108,  0,235,255,193,  0,109,
  0, 92,255,193,  0,109,  0,186,255,193,  0,109,  0,235,255,193,
  0,110,  0, 92,255,193,  0,110,  0,186,255,193,  0,110,  0,235,
255,193,  0,144,  0, 16,255,220,  0,145,  0, 15,255,211,  0,145,
  0, 16,  0, 38,  0,145,  0, 17,255,211,  0,145,  0, 36,255,220,
  0,145,  0, 57,255,220,  0,145,  0, 59,255,183,  0,145,  0, 60,
255,220,  0,145,  0, 98,255,220,  0,145,  0,173,255,220,  0,145,
  0,174,255,220,  0,145,  0,187,255,220,  0,145,  0,199,255,220,
  0,145,  0,201,255,220,  0,145,  0,234,255,220,  0,173,  0, 15,
  0, 38,  0,173,  0, 17,  0, 38,  0,173,  0, 29,  0, 38,  0,173,
  0, 30,  0, 38,  0,173,  0, 38,255,193,  0,173,  0, 50,255,193,
  0,173,  0, 55,255, 60,  0,173,  0, 56,255,164,  0,173,  0, 57,
255,117,  0,173,  0, 58,255,144,  0,173,  0, 60,255, 21,  0,173,
  0, 70,255,193,  0,173,  0, 71,255,193,  0,173,  0, 87,255,144,
  0,173,  0, 89,255,144,  0,173,  0, 90,255,164,  0,173,  0, 92,
255,107,  0,173,  0,100,255,193,  0,173,  0,103,255,193,  0,173,
  0,104,255,164,  0,173,  0,111,255,193,  0,173,  0,145,255,193,
  0,173,  0,175,255,193,  0,173,  0,176,255,193,  0,173,  0,181,
255,  3,  0,173,  0,183,255,  3,  0,173,  0,186,255,107,  0,173,
  0,187,255, 21,  0,173,  0,196,  0,104,  0,173,  0,197,  0,104,
  0,173,  0,208,255,193,  0,173,  0,209,255,193,  0,173,  0,210,
255,193,  0,173,  0,211,255,164,  0,173,  0,212,255,164,  0,173,
  0,213,255,164,  0,173,  0,234,255, 21,  0,173,  0,235,255,107,
  0,173,  0,251,255,193,  0,173,  0,252,255,193,  0,173,  0,253,
255,193,  0,173,  0,254,255,193,  0,173,  0,255,255,193,  0,174,
  0, 15,  0, 38,  0,174,  0, 17,  0, 38,  0,174,  0, 29,  0, 38,
  0,174,  0, 30,  0, 38,  0,174,  0, 38,255,193,  0,174,  0, 50,
255,193,  0,174,  0, 55,255, 60,  0,174,  0, 56,255,164,  0,174,
  0, 57,255,117,  0,174,  0, 58,255,144,  0,174,  0, 60,255, 21,
  0,174,  0, 70,255,193,  0,174,  0, 71,255,193,  0,174,  0, 87,
255,144,  0,174,  0, 89,255,144,  0,174,  0, 90,255,164,  0,174,
  0, 92,255,107,  0,174,  0,100,255,193,  0,174,  0,103,255,193,
  0,174,  0,104,255,164,  0,174,  0,111,255,193,  0,174,  0,145,
255,193,  0,174,  0,175,255,193,  0,174,  0,176,255,193,  0,174,
  0,181,255,  3,  0,174,  0,183,255,  3,  0,174,  0,186,255,107,
  0,174,  0,187,255, 21,  0,174,  0,196,  0,104,  0,174,  0,197,
  0,104,  0,174,  0,208,255,193,  0,174,  0,209,255,193,  0,174,
  0,210,255,193,  0,174,  0,211,255,164,  0,174,  0,212,255,164,
  0,174,  0,213,255,164,  0,174,  0,234,255, 21,  0,174,  0,235,
255,107,  0,174,  0,251,255,193,  0,174,  0,252,255,193,  0,174,
  0,253,255,193,  0,174,  0,254,255,193,  0,174,  0,255,255,193,
  0,175,  0, 15,255,211,  0,175,  0, 16,  0, 38,  0,175,  0, 17,
255,211,  0,175,  0, 57,255,183,  0,175,  0, 59,255,183,  0,175,
  0, 60,255,107,  0,175,  0,187,255,107,  0,175,  0,234,255,107,
  0,180,  0, 36,254,248,  0,180,  0, 45,255,164,  0,180,  0, 60,
  0, 38,  0,180,  0, 98,254,248,  0,180,  0,144,254,211,  0,180,
  0,173,254,248,  0,180,  0,174,254,248,  0,180,  0,187,  0, 38,
  0,180,  0,199,254,248,  0,180,  0,201,254,248,  0,180,  0,234,
  0, 38,  0,182,  0, 36,254,240,  0,182,  0, 45,255,164,  0,182,
  0, 57,  0, 38,  0,182,  0, 60,  0, 75,  0,182,  0, 98,254,240,
  0,182,  0,144,254,248,  0,182,  0,173,254,240,  0,182,  0,174,
254,240,  0,182,  0,187,  0, 75,  0,182,  0,199,254,240,  0,182,
  0,201,254,240,  0,182,  0,234,  0, 75,  0,186,  0, 15,255, 97,
  0,186,  0, 17,255, 68,  0,187,  0, 15,254,173,  0,187,  0, 16,
254,211,  0,187,  0, 17,254,173,  0,187,  0, 29,255, 78,  0,187,
  0, 30,255, 78,  0,187,  0, 36,255, 60,  0,187,  0, 38,255,183,
  0,187,  0, 50,255,183,  0,187,  0, 68,255, 13,  0,187,  0, 72,
254,248,  0,187,  0, 82,254,248,  0,187,  0, 88,255, 31,  0,187,
  0, 98,255, 60,  0,187,  0,100,255,183,  0,187,  0,103,255,183,
  0,187,  0,105,255, 13,  0,187,  0,106,255, 13,  0,187,  0,107,
255, 13,  0,187,  0,108,255, 13,  0,187,  0,109,255, 13,  0,187,
  0,110,255, 13,  0,187,  0,112,254,248,  0,187,  0,113,254,248,
  0,187,  0,114,254,248,  0,187,  0,115,254,248,  0,187,  0,121,
254,248,  0,187,  0,122,254,248,  0,187,  0,123,254,248,  0,187,
  0,124,254,248,  0,187,  0,125,254,248,  0,187,  0,126,255, 31,
  0,187,  0,127,255, 31,  0,187,  0,128,255, 31,  0,187,  0,129,
255, 31,  0,187,  0,145,255,183,  0,187,  0,160,255, 13,  0,187,
  0,161,254,248,  0,187,  0,173,255, 60,  0,187,  0,174,255, 60,
  0,187,  0,175,255,183,  0,187,  0,176,255,136,  0,187,  0,177,
254,248,  0,187,  0,196,254,136,  0,187,  0,197,254,107,  0,187,
  0,199,255, 60,  0,187,  0,201,255, 60,  0,187,  0,208,255,183,
  0,187,  0,209,255,183,  0,187,  0,210,255,183,  0,187,  0,251,
255,183,  0,187,  0,253,255,183,  0,196,  0, 55,254, 60,  0,196,
  0, 57,254,173,  0,196,  0, 58,255, 31,  0,196,  0, 60,254, 97,
  0,196,  0,187,254, 97,  0,196,  0,234,254, 97,  0,197,  0, 55,
254, 60,  0,197,  0, 57,254,173,  0,197,  0, 58,255, 31,  0,197,
  0, 60,254, 97,  0,197,  0,187,254, 97,  0,197,  0,234,254, 97,
  0,199,  0, 15,  0, 38,  0,199,  0, 17,  0, 38,  0,199,  0, 29,
  0, 38,  0,199,  0, 30,  0, 38,  0,199,  0, 38,255,193,  0,199,
  0, 50,255,193,  0,199,  0, 55,255, 60,  0,199,  0, 56,255,164,
  0,199,  0, 57,255,117,  0,199,  0, 58,255,144,  0,199,  0, 60,
255, 21,  0,199,  0, 70,255,193,  0,199,  0, 71,255,193,  0,199,
  0, 87,255,144,  0,199,  0, 89,255,144,  0,199,  0, 90,255,164,
  0,199,  0, 92,255,107,  0,199,  0,100,255,193,  0,199,  0,103,
255,193,  0,199,  0,104,255,164,  0,199,  0,111,255,193,  0,199,
  0,145,255,193,  0,199,  0,175,255,193,  0,199,  0,176,255,193,
  0,199,  0,181,255,  3,  0,199,  0,183,255,  3,  0,199,  0,186,
255,107,  0,199,  0,187,255, 21,  0,199,  0,196,  0,104,  0,199,
  0,197,  0,104,  0,199,  0,208,255,193,  0,199,  0,209,255,193,
  0,199,  0,210,255,193,  0,199,  0,211,255,164,  0,199,  0,212,
255,164,  0,199,  0,213,255,164,  0,199,  0,234,255, 21,  0,199,
  0,235,255,107,  0,199,  0,251,255,193,  0,199,  0,252,255,193,
  0,199,  0,253,255,193,  0,199,  0,254,255,193,  0,199,  0,255,
255,193,  0,201,  0, 15,  0, 38,  0,201,  0, 17,  0, 38,  0,201,
  0, 29,  0, 38,  0,201,  0, 30,  0, 38,  0,201,  0, 38,255,193,
  0,201,  0, 50,255,193,  0,201,  0, 55,255, 60,  0,201,  0, 56,
255,164,  0,201,  0, 57,255,117,  0,201,  0, 58,255,144,  0,201,
  0, 60,255, 21,  0,201,  0, 70,255,193,  0,201,  0, 71,255,193,
  0,201,  0, 87,255,144,  0,201,  0, 89,255,144,  0,201,  0, 90,
255,164,  0,201,  0, 92,255,107,  0,201,  0,100,255,193,  0,201,
  0,103,255,193,  0,201,  0,104,255,164,  0,201,  0,111,255,193,
  0,201,  0,145,255,193,  0,201,  0,175,255,193,  0,201,  0,176,
255,193,  0,201,  0,181,255,  3,  0,201,  0,183,255,  3,  0,201,
  0,186,255,107,  0,201,  0,187,255, 21,  0,201,  0,196,  0,104,
  0,201,  0,197,  0,104,  0,201,  0,208,255,193,  0,201,  0,209,
255,193,  0,201,  0,210,255,193,  0,201,  0,211,255,164,  0,201,
  0,212,255,164,  0,201,  0,213,255,164,  0,201,  0,234,255, 21,
  0,201,  0,235,255,107,  0,201,  0,251,255,193,  0,201,  0,252,
255,193,  0,201,  0,253,255,193,  0,201,  0,254,255,193,  0,201,
  0,255,255,193,  0,208,  0, 15,255,211,  0,208,  0, 16,  0, 38,
  0,208,  0, 17,255,211,  0,208,  0, 57,255,183,  0,208,  0, 59,
255,183,  0,208,  0, 60,255,107,  0,208,  0,187,255,107,  0,208,
  0,234,255,107,  0,209,  0, 15,255,211,  0,209,  0, 16,  0, 38,
  0,209,  0, 17,255,211,  0,209,  0, 57,255,183,  0,209,  0, 59,
255,183,  0,209,  0, 60,255,107,  0,209,  0,187,255,107,  0,209,
  0,234,255,107,  0,210,  0, 15,255,211,  0,210,  0, 16,  0, 38,
  0,210,  0, 17,255,211,  0,210,  0, 57,255,183,  0,210,  0, 59,
255,183,  0,210,  0, 60,255,107,  0,210,  0,187,255,107,  0,210,
  0,234,255,107,  0,211,  0, 36,255,164,  0,211,  0, 98,255,164,
  0,211,  0,173,255,164,  0,211,  0,174,255,164,  0,211,  0,199,
255,164,  0,211,  0,201,255,164,  0,212,  0, 36,255,164,  0,212,
  0, 98,255,164,  0,212,  0,173,255,164,  0,212,  0,174,255,164,
  0,212,  0,199,255,164,  0,212,  0,201,255,164,  0,213,  0, 36,
255,164,  0,213,  0, 98,255,164,  0,213,  0,173,255,164,  0,213,
  0,174,255,164,  0,213,  0,199,255,164,  0,213,  0,201,255,164,
  0,225,  0, 50,255,183,  0,225,  0, 55,254,173,  0,225,  0, 56,
255,183,  0,225,  0, 57,254,230,  0,225,  0, 58,255, 97,  0,225,
  0, 60,254,193,  0,225,  0, 92,255,  3,  0,225,  0,103,255,183,
  0,225,  0,104,255,183,  0,225,  0,145,255,183,  0,225,  0,175,
255,183,  0,225,  0,176,255,183,  0,225,  0,181,254,248,  0,225,
  0,183,254,248,  0,225,  0,186,255,  3,  0,225,  0,187,254,193,
  0,225,  0,208,255,183,  0,225,  0,209,255,183,  0,225,  0,210,
255,183,  0,225,  0,211,255,183,  0,225,  0,212,255,183,  0,225,
  0,213,255,183,  0,225,  0,234,254,193,  0,225,  0,235,255,  3,
  0,227,  0, 54,255,183,  0,227,  0,227,255,183,  0,227,  0,249,
255,183,  0,229,  0, 16,255,107,  0,232,  0, 16,  0, 38,  0,232,
  0, 60,255, 97,  0,232,  0,187,255, 97,  0,232,  0,196,255,220,
  0,232,  0,197,255,220,  0,232,  0,234,255, 97,  0,234,  0, 15,
254,173,  0,234,  0, 16,254,211,  0,234,  0, 17,254,173,  0,234,
  0, 29,255, 78,  0,234,  0, 30,255, 78,  0,234,  0, 36,255, 60,
  0,234,  0, 38,255,183,  0,234,  0, 50,255,183,  0,234,  0, 68,
255, 13,  0,234,  0, 72,254,248,  0,234,  0, 82,254,248,  0,234,
  0, 88,255, 31,  0,234,  0, 98,255, 60,  0,234,  0,100,255,183,
  0,234,  0,103,255,183,  0,234,  0,105,255, 13,  0,234,  0,106,
255, 13,  0,234,  0,107,255, 13,  0,234,  0,108,255, 13,  0,234,
  0,109,255, 13,  0,234,  0,110,255, 13,  0,234,  0,112,254,248,
  0,234,  0,113,254,248,  0,234,  0,114,254,248,  0,234,  0,115,
254,248,  0,234,  0,121,254,248,  0,234,  0,122,254,248,  0,234,
  0,123,254,248,  0,234,  0,124,254,248,  0,234,  0,125,254,248,
  0,234,  0,126,255, 31,  0,234,  0,127,255, 31,  0,234,  0,128,
255, 31,  0,234,  0,129,255, 31,  0,234,  0,145,255,183,  0,234,
  0,160,255, 13,  0,234,  0,161,254,248,  0,234,  0,173,255, 60,
  0,234,  0,174,255, 60,  0,234,  0,175,255,183,  0,234,  0,176,
255,136,  0,234,  0,177,254,248,  0,234,  0,196,254,136,  0,234,
  0,197,254,107,  0,234,  0,199,255, 60,  0,234,  0,201,255, 60,
  0,234,  0,208,255,183,  0,234,  0,209,255,183,  0,234,  0,210,
255,183,  0,234,  0,251,255,183,  0,234,  0,253,255,183,  0,235,
  0, 15,255, 97,  0,235,  0, 17,255, 68,  0,246,  0, 55,255,220,
  0,246,  0, 60,255,173,  0,246,  0,187,255,173,  0,246,  0,234,
255,173,  0,249,  0, 54,255,183,  0,249,  0,227,255,183,  0,249,
  0,249,255,183,  0,251,  0, 54,255,183,  0,251,  0,227,255,183,
  0,251,  0,249,255,183,  0,253,  0, 54,255,183,  0,253,  0,227,
255,183,  0,253,  0,249,255,183,  0,  1,  0,  0,  1, 11,  0, 77,
  0,  7,  0, 73,  0,  4,  0,  2,  0, 16,  0, 64,  0,  7,  0,  0,
  4, 26,  5,107,  0,  2,  0,  1,  0,  1,  0,  0,  7,109,254, 29,
  0,  0, 11,162,253,199,253,199, 11, 53,  0,  1,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1, 11,  0,  1,  4,149,
  2,188,  0,  5,  0,  4,  5, 71,  4,204,  0,  0,254, 66,  5, 71,
  4,204,  0,  0,  2, 83,  1,  2,  2,102,  8,  2,  2, 11,  8,  3,
  3,  3,  4, 11,  2,  4,128,  0,  0,175, 16,  0, 32, 74,  0,  0,
  0,  0,  0,  0,  0,  0, 66,105,116,115,  0, 33,  0, 32,251,  2,
  6, 20,254, 20,  1,154,  7,109,  1,227,  0,  0,  0,  1,  0,  0,
  0,  0,  0,  0,  0,  1,  0,  0, 66,  0, 29,180,  2,201,  4, 96,
  0,  1, 35, 99,  5,213,  0,  0, 86,101,114, 97, 83, 97,110,115,
 66,100, 79, 98,  0,  0,  0,  0,255,255,255,255, 54,255,255,254,
 54, 50, 56, 74, 48, 48,  7,  0, 64,  0,  0,  0,  0,  0,  0, 20,
  0,  0,  1, 16,  9, 13,  5,  0,  3,  3,  4,  5,  6,  6,  9,  8,
  3,  4,  4,  5,  8,  3,  4,  3,  3,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  4,  4,  8,  8,  8,  5,  9,  7,  7,  7,  7,  6,  6,
  7,  8,  4,  3,  7,  6,  9,  8,  8,  7,  8,  7,  7,  6,  7,  7,
 10,  7,  7,  7,  4,  3,  4,  8,  5,  5,  6,  6,  5,  6,  6,  4,
  6,  6,  3,  3,  6,  3,  9,  6,  6,  6,  6,  4,  5,  4,  6,  6,
  9,  6,  6,  5,  6,  3,  6,  8,  7,  7,  7,  6,  8,  8,  7,  6,
  6,  6,  6,  6,  6,  5,  6,  6,  6,  6,  3,  3,  3,  3,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,  5,  5,  6,  6,  5,  6,  6,  6,
  9,  9,  9,  5,  5,  8, 10,  8,  8,  8,  8,  8,  6,  7,  5,  6,
  7,  6,  5,  5,  5,  7,  9,  6,  5,  4,  8,  6,  6,  8,  6,  6,
  6,  9,  6,  7,  7,  8, 10, 10,  5,  9,  6,  6,  3,  3,  8,  4,
  6,  7,  2,  6,  4,  4,  7,  6,  5,  3,  3,  6, 13,  7,  6,  7,
  6,  6,  4,  4,  4,  4,  8,  8,  8,  7,  7,  7,  3,  5,  5,  5,
  5,  5,  5,  5,  5,  5,  5,  6,  3,  7,  5,  7,  5,  3,  7,  6,
  7,  6,  7,  6,  8,  8,  4,  4,  4, 10, 10, 10,  7,  6,  4,  7,
  5,  7,  5,  7,  5,  6,  4,  3,  6,  5,  5,  5,  5,  5,  5,  5,
  5,  0,  0,  0, 10, 15,  6,  0,  3,  3,  5,  5,  7,  7, 10,  9,
  3,  5,  5,  5,  8,  4,  4,  4,  4,  7,  7,  7,  7,  7,  7,  7,
  7,  7,  7,  4,  4,  8,  8,  8,  6, 10,  8,  8,  7,  8,  7,  7,
  8,  8,  4,  4,  8,  6, 10,  8,  9,  7,  9,  8,  7,  7,  8,  8,
 11,  8,  7,  7,  5,  4,  5,  8,  5,  5,  7,  7,  6,  7,  7,  4,
  7,  7,  4,  4,  7,  4, 10,  7,  7,  7,  7,  5,  6,  5,  7,  7,
  9,  6,  7,  6,  7,  4,  7,  8,  8,  8,  7,  7,  8,  9,  8,  7,
  7,  7,  7,  7,  7,  6,  7,  7,  7,  7,  3,  3,  3,  3,  7,  7,
  7,  7,  7,  7,  7,  7,  7,  7,  5,  5,  7,  7,  5,  6,  6,  7,
 10, 10, 10,  5,  5,  8, 11,  9,  8,  8,  8,  8,  7,  7,  5,  7,
  8,  6,  6,  6,  6,  8, 10,  7,  6,  5,  8,  7,  7,  8,  7,  7,
  7, 10,  7,  8,  8,  9, 11, 11,  5, 10,  6,  6,  4,  4,  8,  5,
  7,  7,  2,  6,  4,  4,  8,  8,  5,  4,  4,  6, 15,  8,  7,  8,
  7,  7,  4,  4,  4,  4,  9,  9,  9,  8,  8,  8,  3,  5,  5,  5,
  5,  5,  5,  5,  5,  5,  5,  7,  5,  7,  6,  7,  6,  4,  8,  7,
  7,  7,  7,  7,  8,  8,  4,  4,  4, 11, 11, 11,  8,  7,  4,  7,
  6,  7,  6,  7,  6,  7,  4,  4,  7,  5,  5,  5,  5,  5,  5,  5,
  5,  0,  0,  0, 11, 16,  7,  0,  4,  4,  5,  6,  8,  8, 11, 10,
  3,  5,  5,  6,  9,  4,  5,  4,  4,  8,  8,  8,  8,  8,  8,  8,
  8,  8,  8,  4,  4,  9,  9,  9,  6, 11,  9,  8,  8,  9,  8,  8,
  9,  9,  4,  4,  9,  7, 11,  9,  9,  8,  9,  8,  8,  8,  9,  9,
 12,  8,  8,  8,  5,  4,  5,  9,  6,  6,  7,  8,  7,  8,  7,  5,
  8,  8,  4,  4,  7,  4, 12,  8,  8,  8,  8,  5,  7,  5,  8,  7,
 10,  7,  7,  7,  8,  4,  8,  9,  9,  9,  8,  8,  9,  9,  9,  7,
  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  4,  4,  4,  4,  8,  8,
  8,  8,  8,  8,  8,  8,  8,  8,  6,  6,  8,  8,  6,  7,  7,  8,
 11, 11, 11,  6,  6,  9, 12,  9,  9,  9,  9,  9,  8,  8,  6,  8,
  9,  7,  7,  6,  6,  8, 12,  8,  6,  5,  9,  7,  8,  9,  8,  7,
  7, 11,  8,  9,  9,  9, 12, 12,  6, 11,  7,  7,  4,  4,  9,  5,
  7,  8,  2,  7,  5,  5,  9,  9,  6,  4,  4,  7, 16,  9,  8,  9,
  8,  8,  4,  4,  4,  4,  9,  9,  9,  9,  9,  9,  4,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  7,  5,  8,  7,  8,  7,  4,  9,  8,
  8,  7,  8,  8,  9,  9,  5,  5,  5, 12, 12, 12,  9,  8,  4,  8,
  7,  8,  7,  8,  7,  8,  5,  4,  8,  6,  6,  6,  6,  6,  6,  6,
  6,  0,  0,  0, 12, 17,  7,  0,  4,  4,  5,  6,  8,  8, 12, 10,
  4,  5,  5,  6, 10,  5,  5,  5,  4,  8,  8,  8,  8,  8,  8,  8,
  8,  8,  8,  5,  5, 10, 10, 10,  7, 12,  9,  9,  9, 10,  8,  8,
 10, 10,  4,  4,  9,  8, 12, 10, 10,  9, 10,  9,  9,  8, 10,  9,
 13,  9,  9,  9,  5,  4,  5, 10,  6,  6,  8,  9,  7,  9,  8,  5,
  9,  8,  4,  4,  8,  4, 13,  8,  8,  8,  9,  6,  7,  6,  8,  8,
 11,  8,  8,  7,  9,  4,  9, 10,  9,  9,  9,  8, 10, 10, 10,  8,
  8,  8,  8,  8,  8,  7,  8,  8,  8,  8,  4,  4,  4,  4,  8,  8,
  8,  8,  8,  8,  8,  8,  8,  8,  6,  6,  8,  8,  6,  8,  8,  9,
 12, 12, 12,  6,  6, 10, 13, 10, 10, 10, 10, 10,  8,  9,  7,  9,
  9,  8,  7,  7,  7,  9, 13,  8,  7,  5, 10,  8,  8, 10,  8,  8,
  8, 12,  8,  9,  9, 10, 13, 13,  6, 12,  8,  8,  5,  5, 10,  6,
  8,  9,  2,  8,  5,  5, 10, 10,  6,  5,  5,  8, 17,  9,  8,  9,
  8,  8,  4,  4,  4,  4, 10, 10, 10, 10, 10, 10,  4,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  8,  5,  9,  7,  9,  7,  4, 10,  8,
  9,  8,  9,  9, 10, 10,  5,  5,  5, 13, 13, 13, 10,  9,  4,  9,
  7,  9,  7,  9,  7,  9,  5,  5,  8,  6,  6,  6,  6,  6,  6,  6,
  6,  0,  0,  0, 13, 19,  8,  0,  5,  5,  6,  7,  9,  9, 13, 11,
  4,  6,  6,  7, 11,  5,  5,  5,  5,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  5,  5, 11, 11, 11,  8, 13, 10, 10, 10, 11,  9,  9,
 11, 11,  5,  5, 10,  8, 13, 11, 11, 10, 11, 10,  9,  9, 11, 10,
 14, 10,  9,  9,  6,  5,  6, 11,  7,  7,  9,  9,  8,  9,  9,  6,
  9,  9,  4,  4,  9,  4, 14,  9,  9,  9,  9,  6,  8,  6,  9,  8,
 12,  8,  8,  8,  9,  5,  9, 11, 10, 10, 10,  9, 11, 11, 11,  9,
  9,  9,  9,  9,  9,  8,  9,  9,  9,  9,  4,  4,  4,  4,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  7,  7,  9,  9,  7,  8,  8,  9,
 13, 13, 13,  7,  7, 11, 14, 11, 11, 11, 11, 11,  9, 10,  7,  9,
 10,  8,  8,  7,  7, 10, 14,  9,  8,  6, 11,  9,  9, 11,  9,  8,
  8, 13,  9, 10, 10, 11, 15, 14,  7, 13,  8,  8,  5,  5, 11,  6,
  8,  9,  2,  8,  5,  5, 10, 10,  7,  5,  5,  8, 19, 10,  9, 10,
  9,  9,  5,  5,  5,  5, 11, 11, 11, 11, 11, 11,  4,  7,  7,  7,
  7,  7,  7,  7,  7,  7,  7,  9,  5,  9,  8,  9,  8,  5, 11,  9,
  9,  8, 10,  9, 11, 11,  6,  6,  6, 14, 14, 14, 11,  9,  5,  9,
  8, 10,  8, 10,  8,  9,  5,  5,  9,  7,  7,  7,  7,  7,  7,  7,
  7,  0,  0,  0, 14, 20,  8,  0,  5,  5,  6,  7, 10, 10, 14, 12,
  4,  6,  6,  7, 12,  5,  6,  5,  5, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10,  6,  6, 12, 12, 12,  8, 14, 11, 11, 10, 12, 10, 10,
 11, 12,  5,  5, 11,  9, 14, 12, 12, 10, 12, 11, 10, 10, 11, 11,
 15, 11, 10, 10,  6,  5,  6, 12,  7,  7,  9, 10,  8, 10, 10,  6,
 10, 10,  5,  5,  9,  5, 15, 10, 10, 10, 10,  7,  8,  7, 10,  9,
 13,  9,  9,  8, 10,  5, 10, 12, 11, 11, 10, 10, 12, 12, 11,  9,
  9,  9,  9,  9,  9,  8, 10, 10, 10, 10,  5,  5,  5,  5, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 10,  7,  7, 10, 10,  7,  9,  9, 10,
 14, 14, 14,  7,  7, 12, 15, 12, 12, 12, 12, 12, 10, 10,  8, 10,
 11,  9,  9,  8,  8, 11, 15, 10,  8,  6, 12,  9, 10, 12, 10,  9,
  9, 14, 10, 11, 11, 12, 16, 15,  7, 14,  9,  9,  5,  5, 12,  7,
  9, 10,  2,  9,  6,  6, 11, 11,  7,  5,  5,  9, 20, 11, 10, 11,
 10, 10,  5,  5,  5,  5, 12, 12, 12, 11, 11, 11,  5,  7,  7,  7,
  7,  7,  7,  7,  7,  7,  7,  9,  5, 10,  8, 10,  8,  5, 12, 10,
 10,  9, 10, 10, 12, 12,  6,  6,  6, 15, 15, 15, 11, 10,  5, 10,
  8, 10,  8, 10,  8, 10,  6,  5, 10,  7,  7,  7,  7,  7,  7,  7,
  7,  0,  0,  0, 15, 22,  9,  0,  5,  5,  7,  8, 10, 10, 15, 13,
  5,  7,  7,  8, 13,  6,  6,  6,  5, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10,  6,  6, 13, 13, 13,  9, 15, 12, 11, 11, 12, 10, 10,
 12, 13,  6,  6, 12, 10, 15, 13, 13, 11, 13, 12, 11, 10, 12, 12,
 17, 12, 11, 11,  7,  5,  7, 13,  8,  8, 10, 11,  9, 11, 10,  7,
 11, 11,  6,  6, 10,  5, 16, 11, 10, 11, 11,  7, 10,  7, 11, 10,
 14, 10, 10,  9, 11,  5, 11, 13, 12, 12, 11, 10, 13, 13, 12, 10,
 10, 10, 10, 10, 10,  9, 10, 10, 10, 10,  5,  5,  5,  5, 11, 10,
 10, 10, 10, 10, 11, 11, 11, 11,  8,  8, 10, 10,  8, 10, 10, 11,
 15, 15, 15,  8,  8, 13, 16, 13, 13, 13, 13, 13, 10, 11,  8, 11,
 12, 10,  9,  8,  8, 12, 16, 10,  9,  7, 13, 10, 10, 13, 10, 10,
 10, 15, 10, 12, 12, 13, 17, 16,  8, 15, 10, 10,  6,  6, 13,  7,
 10, 11,  3, 10,  6,  6, 12, 12,  8,  6,  6, 10, 22, 12, 10, 12,
 10, 10,  6,  6,  6,  6, 13, 13, 13, 12, 12, 12,  5,  8,  8,  8,
  8,  8,  8,  8,  8,  8,  8, 10,  6, 11, 10, 11,  9,  5, 13, 10,
 11, 10, 11, 11, 13, 13,  7,  7,  7, 16, 16, 16, 12, 11,  6, 11,
 10, 11,  9, 11,  9, 11,  6,  6, 10,  8,  8,  8,  8,  8,  8,  8,
  8,  0,  0,  0, 16, 23, 10,  0,  6,  6,  7,  8, 11, 11, 16, 14,
  5,  7,  7,  8, 13,  6,  7,  6,  6, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11,  6,  6, 13, 13, 13,  9, 16, 12, 12, 12, 13, 11, 11,
 13, 13,  6,  6, 12, 10, 16, 13, 14, 12, 14, 12, 12, 11, 13, 12,
 18, 12, 12, 12,  7,  6,  7, 13,  8,  8, 11, 11,  9, 11, 11,  7,
 11, 11,  5,  5, 11,  5, 17, 11, 10, 11, 11,  8, 10,  8, 11, 10,
 15, 10, 10,  9, 11,  6, 11, 13, 12, 12, 12, 11, 13, 14, 13, 11,
 11, 11, 11, 11, 11,  9, 11, 11, 11, 11,  5,  5,  5,  5, 11, 10,
 10, 10, 10, 10, 11, 11, 11, 11,  8,  8, 11, 11,  8, 10, 10, 12,
 16, 16, 16,  8,  8, 13, 17, 14, 13, 13, 13, 13, 11, 12,  9, 11,
 13, 10, 10,  9,  9, 12, 17, 11,  9,  7, 13, 11, 11, 13, 11, 10,
 10, 16, 11, 12, 12, 14, 18, 18,  8, 16, 10, 10,  6,  6, 13,  8,
 10, 12,  3, 10,  7,  7, 13, 13,  8,  6,  6, 10, 23, 12, 11, 12,
 11, 11,  6,  6,  6,  6, 14, 14, 14, 13, 13, 13,  5,  8,  8,  8,
  8,  8,  8,  8,  8,  8,  8, 11,  6, 12, 10, 12,  9,  6, 14, 11,
 12, 10, 12, 11, 13, 13,  7,  7,  7, 17, 17, 17, 13, 11,  6, 12,
 10, 12,  9, 12,  9, 11,  7,  6, 11,  8,  8,  8,  8,  8,  8,  8,
  8,  0,  0,  0, 17, 25, 10,  0,  6,  6,  8,  9, 12, 12, 17, 15,
  5,  8,  8,  9, 14,  6,  7,  6,  6, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12,  7,  7, 14, 14, 14, 10, 17, 13, 13, 12, 14, 12, 12,
 14, 14,  6,  6, 13, 11, 17, 14, 14, 12, 14, 13, 12, 12, 14, 13,
 19, 13, 12, 12,  8,  6,  8, 14,  9,  9, 11, 12, 10, 12, 12,  7,
 12, 12,  6,  6, 11,  6, 18, 12, 12, 12, 12,  8, 10,  8, 12, 11,
 16, 11, 11, 10, 12,  6, 12, 14, 13, 13, 12, 12, 14, 14, 14, 11,
 11, 11, 11, 11, 11, 10, 12, 12, 12, 12,  6,  6,  6,  6, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12,  9,  9, 12, 12,  9, 11, 11, 12,
 17, 17, 17,  9,  9, 14, 18, 14, 14, 14, 14, 14, 12, 13,  9, 12,
 13, 11, 10, 10, 10, 13, 18, 12, 10,  8, 14, 11, 12, 14, 12, 11,
 11, 17, 12, 13, 13, 14, 19, 19,  9, 17, 11, 11,  6,  6, 14,  8,
 11, 12,  3, 11,  7,  7, 13, 13,  9,  6,  6, 11, 25, 13, 12, 13,
 12, 12,  6,  6,  6,  6, 14, 14, 14, 14, 14, 14,  6,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9, 11,  6, 12, 10, 12, 10,  6, 14, 12,
 12, 11, 13, 12, 14, 14,  7,  7,  7, 18, 18, 18, 14, 12,  6, 12,
 10, 12, 10, 12, 10, 12,  7,  6, 12,  9,  9,  9,  9,  9,  9,  9,
  9,  0,  0,  0, 18, 26, 11,  0,  6,  6,  8,  9, 13, 13, 18, 16,
  6,  8,  8,  9, 15,  7,  7,  7,  7, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13,  7,  7, 15, 15, 15, 10, 18, 14, 14, 13, 15, 12, 12,
 15, 15,  7,  7, 14, 11, 18, 15, 15, 13, 15, 14, 13, 12, 15, 14,
 20, 14, 13, 13,  8,  7,  8, 15,  9,  9, 12, 13, 11, 13, 12,  8,
 13, 13,  6,  6, 12,  6, 19, 13, 12, 13, 13,  9, 11,  9, 13, 12,
 17, 12, 12, 10, 13,  7, 13, 15, 14, 14, 13, 12, 15, 15, 15, 12,
 12, 12, 12, 12, 12, 11, 12, 12, 12, 12,  6,  6,  6,  6, 13, 12,
 12, 12, 12, 12, 13, 13, 13, 13,  9,  9, 13, 13,  9, 12, 11, 13,
 18, 18, 18,  9,  9, 15, 20, 15, 15, 15, 15, 15, 13, 13, 10, 13,
 14, 12, 11, 10, 10, 14, 19, 12, 10,  8, 15, 12, 13, 15, 13, 12,
 12, 18, 13, 14, 14, 15, 21, 20,  9, 18, 12, 12,  7,  7, 15,  9,
 12, 13,  3, 11,  7,  7, 14, 14,  9,  7,  7, 12, 26, 14, 12, 14,
 12, 12,  7,  7,  7,  7, 15, 15, 15, 15, 15, 15,  6,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9, 12,  7, 13, 11, 13, 10,  7, 15, 12,
 13, 12, 13, 13, 15, 15,  8,  8,  8, 19, 19, 19, 15, 13,  7, 13,
 11, 13, 11, 13, 11, 13,  7,  7, 13,  9,  9,  9,  9,  9,  9,  9,
  9,  0,  0,  0, 19, 28, 11,  0,  7,  7,  9, 10, 13, 13, 19, 17,
  6,  9,  9, 10, 16,  7,  8,  7,  7, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13,  8,  8, 16, 16, 16, 11, 19, 15, 14, 14, 16, 13, 13,
 16, 16,  7,  7, 15, 12, 19, 16, 16, 14, 16, 15, 14, 13, 15, 15,
 21, 15, 14, 14,  9,  7,  9, 16, 10, 10, 13, 14, 11, 14, 13,  8,
 14, 14,  7,  7, 13,  7, 20, 14, 13, 14, 14,  9, 11,  9, 14, 12,
 18, 12, 12, 11, 14,  7, 14, 16, 15, 15, 14, 13, 16, 16, 15, 13,
 13, 13, 13, 13, 13, 11, 13, 13, 13, 13,  7,  7,  7,  7, 14, 13,
 13, 13, 13, 13, 14, 14, 14, 14, 10, 10, 13, 13, 10, 12, 12, 14,
 19, 19, 19, 10, 10, 16, 21, 16, 16, 16, 16, 16, 13, 14, 10, 14,
 15, 12, 12, 11, 11, 15, 20, 13, 11,  9, 16, 13, 13, 16, 13, 12,
 12, 19, 13, 15, 15, 16, 22, 21, 10, 19, 12, 12,  7,  7, 16,  9,
 12, 14,  3, 12,  8,  8, 15, 15, 10,  7,  7, 12, 28, 15, 13, 15,
 13, 13,  7,  7,  7,  7, 16, 16, 16, 15, 15, 15,  7, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 13,  7, 14, 11, 14, 11,  7, 16, 13,
 14, 12, 14, 14, 16, 16,  8,  8,  8, 20, 20, 20, 16, 14,  7, 14,
 11, 14, 11, 14, 11, 14,  8,  7, 13, 10, 10, 10, 10, 10, 10, 10,
 10,  0,  0,  0, 20, 29, 12,  0,  7,  7,  9, 10, 14, 14, 20, 17,
  6,  9,  9, 10, 17,  8,  8,  8,  7, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14,  8,  8, 17, 17, 17, 12, 20, 15, 15, 15, 17, 14, 14,
 16, 17,  7,  7, 16, 13, 20, 17, 17, 15, 17, 15, 14, 14, 16, 15,
 22, 15, 14, 15,  9,  7,  9, 17, 10, 10, 14, 14, 12, 14, 14,  9,
 14, 14,  7,  7, 13,  7, 21, 14, 14, 14, 14, 10, 12, 10, 14, 13,
 18, 13, 13, 12, 14,  7, 14, 17, 15, 15, 15, 14, 17, 17, 16, 14,
 14, 14, 14, 14, 14, 12, 14, 14, 14, 14,  7,  7,  7,  7, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 10, 10, 14, 14, 10, 13, 13, 14,
 20, 20, 20, 10, 10, 17, 22, 17, 17, 17, 17, 17, 14, 15, 11, 14,
 16, 13, 12, 11, 11, 15, 21, 14, 12,  9, 17, 13, 14, 17, 14, 13,
 13, 20, 14, 15, 15, 17, 23, 22, 10, 20, 13, 13,  8,  8, 17, 10,
 13, 14,  3, 13,  8,  8, 16, 16, 10,  8,  8, 13, 29, 15, 14, 15,
 14, 14,  7,  7,  7,  7, 17, 17, 17, 16, 16, 16,  7, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 13,  8, 14, 12, 15, 12,  7, 17, 14,
 14, 13, 15, 14, 17, 17,  9,  9,  9, 21, 21, 21, 16, 14,  7, 14,
 12, 15, 12, 15, 12, 14,  8,  8, 14, 10, 10, 10, 10, 10, 10, 10,
 10,  0,  0,  0, 21, 31, 13,  0,  7,  7, 10, 11, 15, 15, 21, 18,
  6, 10, 10, 11, 18,  8,  9,  8,  8, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15,  8,  8, 18, 18, 18, 12, 21, 16, 16, 15, 17, 14, 14,
 17, 18,  8,  8, 16, 13, 21, 18, 18, 15, 18, 16, 15, 14, 17, 16,
 23, 16, 15, 15, 10,  8, 10, 18, 11, 11, 14, 15, 12, 15, 14,  9,
 15, 15,  7,  7, 14,  7, 22, 15, 14, 15, 15, 10, 13, 10, 15, 14,
 19, 14, 14, 12, 15,  8, 15, 18, 16, 16, 15, 14, 18, 18, 17, 14,
 14, 14, 14, 14, 14, 12, 14, 14, 14, 14,  7,  7,  7,  7, 15, 14,
 14, 14, 14, 14, 15, 15, 15, 15, 11, 11, 15, 15, 11, 13, 13, 15,
 21, 21, 21, 11, 11, 18, 23, 18, 18, 18, 18, 18, 15, 15, 11, 15,
 17, 14, 13, 12, 12, 16, 22, 14, 12, 10, 18, 14, 15, 18, 15, 14,
 14, 21, 15, 16, 16, 18, 25, 23, 11, 21, 14, 14,  8,  8, 18, 10,
 14, 15,  4, 13,  9,  9, 17, 17, 11,  8,  8, 14, 31, 16, 14, 16,
 14, 14,  8,  8,  8,  8, 18, 18, 18, 17, 17, 17,  7, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 14,  8, 15, 13, 15, 12,  8, 18, 14,
 15, 14, 16, 15, 18, 18,  9,  9,  9, 22, 22, 22, 17, 15,  8, 15,
 13, 15, 12, 15, 12, 15,  9,  8, 15, 11, 11, 11, 11, 11, 11, 11,
 11,  0,  0,  0, 22, 32, 13,  0,  8,  8, 10, 11, 15, 15, 22, 19,
  7, 10, 10, 12, 18,  8,  9,  8,  8, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15,  9,  9, 18, 18, 18, 13, 22, 17, 17, 16, 18, 15, 15,
 18, 18,  8,  8, 17, 14, 22, 18, 19, 16, 19, 17, 16, 15, 18, 17,
 24, 17, 16, 16, 10,  8, 10, 18, 11, 11, 15, 16, 13, 16, 15, 10,
 16, 16,  8,  8, 15,  8, 23, 16, 15, 16, 16, 11, 13, 11, 16, 14,
 20, 14, 14, 13, 16,  8, 16, 18, 17, 17, 16, 15, 18, 19, 18, 15,
 15, 15, 15, 15, 15, 13, 15, 15, 15, 15,  8,  8,  8,  8, 16, 15,
 15, 15, 15, 15, 16, 16, 16, 16, 11, 11, 15, 15, 11, 14, 14, 16,
 22, 22, 22, 11, 11, 18, 24, 19, 18, 18, 18, 18, 15, 16, 12, 16,
 17, 14, 13, 12, 12, 17, 23, 15, 13, 10, 18, 15, 15, 18, 15, 14,
 14, 22, 15, 17, 17, 19, 26, 24, 11, 22, 14, 14,  8,  8, 18, 11,
 14, 16,  4, 14,  9,  9, 17, 17, 11,  8,  8, 14, 32, 17, 15, 17,
 15, 15,  8,  8,  8,  8, 19, 19, 19, 18, 18, 18,  8, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 15,  8, 16, 13, 16, 13,  8, 19, 15,
 16, 14, 16, 16, 18, 18, 10, 10, 10, 23, 23, 23, 18, 16,  8, 16,
 13, 16, 13, 16, 13, 16,  9,  8, 15, 11, 11, 11, 11, 11, 11, 11,
 11,  0,  0,  0, 23, 33, 14,  0,  8,  8, 10, 12, 16, 16, 23, 20,
  7, 11, 11, 12, 19,  9, 10,  9,  8, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16,  9,  9, 19, 19, 19, 13, 23, 18, 18, 17, 19, 16, 16,
 19, 19,  9,  9, 18, 15, 23, 19, 20, 17, 20, 18, 17, 16, 19, 18,
 25, 18, 17, 17, 11,  8, 11, 19, 12, 12, 16, 16, 14, 16, 16, 10,
 16, 16,  8,  8, 15,  8, 24, 16, 16, 16, 16, 11, 14, 11, 16, 15,
 21, 15, 15, 13, 16,  8, 16, 19, 18, 18, 17, 16, 19, 20, 19, 16,
 16, 16, 16, 16, 16, 14, 16, 16, 16, 16,  8,  8,  8,  8, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 12, 12, 16, 16, 12, 15, 15, 17,
 23, 23, 23, 12, 12, 19, 25, 20, 19, 19, 19, 19, 16, 17, 13, 17,
 18, 15, 14, 13, 13, 18, 24, 16, 13, 10, 19, 15, 16, 19, 16, 15,
 15, 23, 16, 18, 18, 20, 27, 25, 12, 23, 15, 15,  9,  9, 19, 11,
 15, 17,  4, 15,  9,  9, 18, 18, 12,  9,  9, 15, 33, 18, 16, 18,
 16, 16,  9,  9,  9,  9, 20, 20, 20, 19, 19, 19,  8, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 15,  9, 17, 14, 17, 13,  8, 19, 16,
 17, 15, 17, 16, 19, 19, 10, 10, 10, 25, 25, 25, 19, 16,  9, 17,
 14, 17, 14, 17, 14, 16, 10,  9, 16, 12, 12, 12, 12, 12, 12, 12,
 12,  0,  0,  0, 24, 35, 14,  0,  8,  8, 11, 13, 17, 17, 24, 21,
  7, 11, 11, 13, 20,  9, 10,  9,  9, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 10, 10, 20, 20, 20, 14, 24, 19, 18, 18, 20, 16, 16,
 20, 20,  9,  9, 19, 15, 24, 20, 20, 18, 20, 18, 17, 16, 19, 19,
 26, 19, 17, 17, 11,  9, 11, 20, 12, 12, 16, 17, 14, 17, 16, 10,
 17, 17,  8,  8, 16,  8, 25, 17, 16, 17, 17, 12, 14, 11, 17, 16,
 22, 15, 16, 14, 17,  9, 17, 20, 19, 19, 18, 16, 20, 20, 19, 16,
 16, 16, 16, 16, 16, 14, 16, 16, 16, 16,  8,  8,  8,  8, 17, 16,
 16, 16, 16, 16, 17, 17, 17, 17, 12, 12, 17, 17, 12, 15, 15, 17,
 24, 24, 24, 12, 12, 20, 26, 20, 20, 20, 20, 20, 17, 18, 13, 17,
 19, 15, 15, 14, 14, 18, 25, 16, 14, 11, 20, 16, 17, 20, 17, 16,
 16, 24, 17, 19, 19, 20, 28, 26, 12, 24, 15, 15,  9,  9, 20, 12,
 16, 17,  4, 15, 10, 10, 19, 19, 12,  9,  9, 15, 35, 19, 16, 19,
 16, 16,  9,  9,  9,  9, 20, 20, 20, 19, 19, 19,  8, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 16,  9, 17, 14, 17, 14,  9, 20, 16,
 17, 16, 18, 17, 20, 20, 11, 11, 11, 26, 26, 26, 20, 17,  9, 17,
 14, 18, 14, 18, 14, 17, 10,  9, 17, 12, 12, 12, 12, 12, 12, 12,
 12,  0,  0,  0, 25, 36, 15,  0,  9,  9, 11, 13, 17, 17, 25, 22,
  8, 11, 11, 13, 21, 10, 10, 10,  9, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 10, 10, 21, 21, 21, 15, 25, 19, 19, 18, 21, 17, 17,
 21, 21,  9,  9, 19, 16, 25, 21, 21, 18, 21, 19, 18, 17, 20, 19,
 28, 19, 18, 18, 11,  9, 11, 21, 13, 13, 17, 18, 15, 18, 17, 11,
 18, 18,  9,  9, 17,  9, 26, 18, 17, 18, 18, 12, 15, 12, 18, 16,
 23, 16, 16, 15, 18,  9, 18, 21, 19, 19, 18, 17, 21, 21, 20, 17,
 17, 17, 17, 17, 17, 15, 17, 17, 17, 17,  9,  9,  9,  9, 18, 17,
 17, 17, 17, 17, 18, 18, 18, 18, 13, 13, 17, 17, 13, 16, 16, 18,
 25, 25, 25, 13, 13, 21, 27, 21, 21, 21, 21, 21, 17, 18, 14, 18,
 20, 16, 15, 14, 14, 19, 26, 17, 15, 11, 21, 17, 17, 21, 17, 16,
 16, 25, 17, 19, 19, 21, 29, 27, 13, 25, 16, 16, 10, 10, 21, 12,
 16, 18,  4, 16, 10, 10, 20, 20, 13, 10, 10, 16, 36, 19, 17, 19,
 17, 17,  9,  9,  9,  9, 21, 21, 21, 20, 20, 20,  9, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 17,  9, 18, 15, 18, 15,  9, 21, 17,
 18, 16, 19, 18, 21, 21, 11, 11, 11, 27, 27, 27, 21, 18,  9, 18,
 15, 18, 15, 18, 15, 18, 10, 10, 17, 13, 13, 13, 13, 13, 13, 13,
 13,  0,  0,  0, 26, 38, 16,  0,  9,  9, 12, 14, 18, 18, 26, 23,
  8, 12, 12, 14, 22, 10, 11, 10, 10, 18, 18, 18, 18, 18, 18, 18,
 18, 18, 18, 10, 10, 22, 22, 22, 15, 26, 20, 20, 19, 22, 18, 18,
 21, 22, 10, 10, 20, 17, 26, 22, 22, 19, 22, 20, 19, 18, 21, 20,
 29, 20, 19, 19, 12, 10, 12, 22, 13, 13, 18, 19, 15, 19, 18, 11,
 19, 19,  9,  9, 17,  9, 27, 19, 18, 19, 19, 13, 15, 12, 19, 17,
 24, 17, 17, 15, 19, 10, 19, 22, 20, 20, 19, 18, 22, 22, 21, 18,
 18, 18, 18, 18, 18, 15, 18, 18, 18, 18,  9,  9,  9,  9, 19, 18,
 18, 18, 18, 18, 19, 19, 19, 19, 13, 13, 18, 18, 13, 17, 17, 19,
 26, 26, 26, 13, 13, 22, 28, 22, 22, 22, 22, 22, 18, 19, 14, 19,
 20, 17, 16, 15, 15, 20, 27, 18, 15, 12, 22, 17, 18, 22, 18, 17,
 17, 26, 18, 20, 20, 22, 30, 28, 13, 26, 17, 17, 10, 10, 22, 13,
 17, 19,  4, 17, 11, 11, 20, 20, 13, 10, 10, 17, 38, 20, 18, 20,
 18, 18, 10, 10, 10, 10, 22, 22, 22, 21, 21, 21,  9, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 17, 10, 19, 15, 19, 15, 10, 22, 18,
 19, 17, 19, 19, 22, 22, 11, 11, 11, 28, 28, 28, 21, 19, 10, 19,
 15, 19, 15, 19, 15, 19, 11, 10, 18, 13, 13, 13, 13, 13, 13, 13,
 13,  0,  0,  0, 27, 39, 16,  0,  9,  9, 12, 14, 19, 19, 27, 24,
  8, 12, 12, 14, 23, 10, 11, 10, 10, 19, 19, 19, 19, 19, 19, 19,
 19, 19, 19, 11, 11, 23, 23, 23, 16, 27, 21, 21, 20, 22, 18, 18,
 22, 23, 10, 10, 21, 17, 27, 23, 23, 20, 23, 21, 19, 18, 22, 21,
 30, 21, 20, 20, 12, 10, 12, 23, 14, 14, 18, 19, 16, 19, 18, 12,
 19, 19,  9,  9, 18,  9, 28, 19, 19, 19, 19, 13, 16, 13, 19, 18,
 25, 17, 18, 16, 19, 10, 19, 23, 21, 21, 20, 18, 23, 23, 22, 18,
 18, 18, 18, 18, 18, 16, 18, 18, 18, 18,  9,  9,  9,  9, 19, 19,
 19, 19, 19, 19, 19, 19, 19, 19, 14, 14, 19, 19, 14, 17, 17, 19,
 27, 27, 27, 14, 14, 23, 29, 23, 22, 23, 23, 23, 19, 20, 15, 19,
 21, 17, 16, 15, 15, 21, 28, 19, 16, 12, 23, 18, 19, 23, 19, 18,
 18, 27, 19, 21, 21, 23, 32, 30, 14, 27, 17, 17, 10, 10, 23, 13,
 18, 20,  5, 17, 11, 11, 21, 21, 14, 10, 10, 17, 39, 21, 18, 21,
 18, 18, 10, 10, 10, 10, 23, 23, 23, 22, 22, 22,  9, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 18, 10, 19, 16, 20, 16, 10, 23, 19,
 20, 18, 20, 19, 23, 23, 12, 12, 12, 29, 29, 29, 22, 19, 10, 19,
 16, 20, 16, 20, 16, 19, 11, 10, 19, 14, 14, 14, 14, 14, 14, 14,
 14,  0,  0,  0, 28, 41, 17,  0, 10, 10, 13, 15, 19, 19, 28, 24,
  9, 13, 13, 15, 23, 11, 12, 11, 10, 19, 19, 19, 19, 19, 19, 19,
 19, 19, 19, 11, 11, 23, 23, 23, 16, 28, 22, 21, 21, 23, 19, 19,
 23, 23, 10, 10, 22, 18, 28, 23, 24, 21, 24, 22, 20, 19, 23, 22,
 31, 22, 20, 20, 13, 10, 13, 23, 14, 14, 19, 20, 17, 20, 19, 12,
 20, 20, 10, 10, 19, 10, 29, 20, 19, 20, 20, 14, 17, 13, 20, 18,
 26, 18, 18, 16, 20, 10, 20, 23, 22, 22, 21, 19, 23, 24, 23, 19,
 19, 19, 19, 19, 19, 17, 19, 19, 19, 19, 10, 10, 10, 10, 20, 19,
 19, 19, 19, 19, 20, 20, 20, 20, 14, 14, 19, 19, 14, 18, 18, 20,
 28, 28, 28, 14, 14, 23, 30, 24, 23, 23, 23, 23, 19, 21, 15, 20,
 22, 18, 17, 16, 16, 22, 29, 19, 16, 13, 23, 19, 19, 23, 20, 18,
 18, 28, 19, 22, 22, 24, 33, 31, 14, 28, 18, 18, 11, 11, 23, 14,
 18, 20,  5, 18, 12, 12, 22, 22, 14, 11, 11, 18, 41, 22, 19, 22,
 19, 19, 10, 10, 10, 10, 24, 24, 24, 23, 23, 23, 10, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 18, 11, 20, 17, 20, 16, 10, 24, 19,
 20, 18, 21, 20, 23, 23, 12, 12, 12, 30, 30, 30, 23, 20, 10, 20,
 17, 21, 17, 21, 17, 20, 12, 11, 19, 14, 14, 14, 14, 14, 14, 14,
 14,  0,  0,  0,  0,  0,  0,  2,  0,  8,  0,  2,255,255,  0,  3,
  0,  1,  0,  0,  0,  2,  0,  0,  7, 34,213,176, 95, 15, 60,245,
  0, 31,  8,  0,  0,  0,  0,  0,186,186, 16,235,  0,  0,  0,  0,
186,194,105, 89,253,199,254, 29, 11, 53,  7,109,  0,  3,  0,  8,
  0,  1,  0,  0,  0,  0,  0,  0
};
static unsigned int TTF_VeraBd_len = 58716;
static unsigned char TTF_VeraBd_dat[] = {

  0,  1,  0,  0,  0, 17,  1,  0,  0,  4,  0, 16, 79, 83, 47, 50,
181,137,247, 61,  0,  0,207, 64,  0,  0,  0, 86, 80, 67, 76, 84,
 20, 44,101,137,  0,  0,207,152,  0,  0,  0, 54, 99,109, 97,112,
164,195,232,160,  0,  0,173,184,  0,  0,  3, 88, 99,118,116, 32,
 62,185, 45,226,  0,  0, 31,  8,  0,  0,  2, 82,102,112,103,109,
198,112, 57, 22,  0,  0, 41,  4,  0,  0,  0,140,103, 97,115,112,
  0,  7,  0,  7,  0,  0,229, 24,  0,  0,  0, 12,103,108,121,102,
 52,222,104,165,  0,  0, 41,144,  0,  0,132, 38,104,100,109,120,
 69, 25,188,250,  0,  0,207,208,  0,  0, 21, 72,104,101, 97,100,
243, 79,171,147,  0,  0,229, 36,  0,  0,  0, 54,104,104,101, 97,
 17, 46,  9, 22,  0,  0,207, 28,  0,  0,  0, 36,104,109,116,120,
121,242,128,174,  0,  0,177, 16,  0,  0,  4, 44,107,101,114,110,
  1,212,  6,234,  0,  0,185,220,  0,  0, 21, 30,108,111, 99, 97,
 88,249,122, 91,  0,  0,183,196,  0,  0,  2, 24,109, 97,120,112,
  7, 29,  8,125,  0,  0,206,252,  0,  0,  0, 32,110, 97,109,101,
183, 89,205,191,  0,  0,  1, 28,  0,  0, 29,235,112,111,115,116,
248,161,120,250,  0,  0,181, 60,  0,  0,  2,134,112,114,101,112,
124, 97,162,231,  0,  0, 33, 92,  0,  0,  7,167,  0,  0,  0, 22,
  1, 14,  0,  1,  0,  0,  0,  0,  0,  0,  0, 58,  0,  0,  0,  1,
  0,  0,  0,  0,  0,  1,  0, 19,  0, 58,  0,  1,  0,  0,  0,  0,
  0,  2,  0,  4,  0, 78,  0,  1,  0,  0,  0,  0,  0,  3,  0, 24,
  0, 58,  0,  1,  0,  0,  0,  0,  0,  4,  0, 24,  0, 58,  0,  1,
  0,  0,  0,  0,  0,  5,  0, 12,  0, 82,  0,  1,  0,  0,  0,  0,
  0,  6,  0, 22,  0, 94,  0,  1,  0,  0,  0,  0,  0,  7,  0, 48,
  0,177,  0,  1,  0,  0,  0,  0,  0,  8,  0, 14,  8,112,  0,  1,
  0,  0,  0,  0,  0, 11,  0, 24,  9,135,  0,  1,  0,  0,  0,  0,
  0, 13,  9, 19,  0,116,  0,  3,  0,  1,  4,  9,  0,  0,  0,116,
  9,159,  0,  3,  0,  1,  4,  9,  0,  1,  0, 38, 10, 19,  0,  3,
  0,  1,  4,  9,  0,  2,  0,  8, 10, 59,  0,  3,  0,  1,  4,  9,
  0,  3,  0, 48, 10, 19,  0,  3,  0,  1,  4,  9,  0,  4,  0, 48,
 10, 19,  0,  3,  0,  1,  4,  9,  0,  5,  0, 24, 10, 67,  0,  3,
  0,  1,  4,  9,  0,  6,  0, 44, 10, 91,  0,  3,  0,  1,  4,  9,
  0,  7,  0, 96, 11,  1,  0,  3,  0,  1,  4,  9,  0,  8,  0, 28,
 26,127,  0,  3,  0,  1,  4,  9,  0, 11,  0, 48, 28,173,  0,  3,
  0,  1,  4,  9,  0, 13, 18, 38, 10,135, 67,111,112,121,114,105,
103,104,116, 32, 40, 99, 41, 32, 50, 48, 48, 51, 32, 98,121, 32,
 66,105,116,115,116,114,101, 97,109, 44, 32, 73,110, 99, 46, 32,
 65,108,108, 32, 82,105,103,104,116,115, 32, 82,101,115,101,114,
118,101,100, 46, 66,105,116,115,116,114,101, 97,109, 32, 86,101,
114, 97, 32, 83, 97,110,115, 32, 66,111,108,100, 82,101,108,101,
 97,115,101, 32, 49, 46, 49, 48, 66,105,116,115,116,114,101, 97,
109, 86,101,114, 97, 83, 97,110,115, 45, 66,111,108,100, 67,111,
112,121,114,105,103,104,116, 32, 40, 99, 41, 32, 50, 48, 48, 51,
 32, 98,121, 32, 66,105,116,115,116,114,101, 97,109, 44, 32, 73,
110, 99, 46, 13, 10, 65,108,108, 32, 82,105,103,104,116,115, 32,
 82,101,115,101,114,118,101,100, 46, 13, 10, 66,105,116,115,116,
114,101, 97,109, 32, 86,101,114, 97, 32,105,115, 32, 97, 32,116,
114, 97,100,101,109, 97,114,107, 32,111,102, 32, 66,105,116,115,
116,114,101, 97,109, 44, 32, 73,110, 99, 46, 13, 10, 13, 10, 80,
101,114,109,105,115,115,105,111,110, 32,105,115, 32,104,101,114,
101, 98,121, 32,103,114, 97,110,116,101,100, 44, 32,102,114,101,
101, 32,111,102, 32, 99,104, 97,114,103,101, 44, 32,116,111, 32,
 97,110,121, 32,112,101,114,115,111,110, 32,111, 98,116, 97,105,
110,105,110,103, 32, 97, 32, 99,111,112,121, 32,111,102, 32,116,
104,101, 32,102,111,110,116,115, 32, 97, 99, 99,111,109,112, 97,
110,121,105,110,103, 32,116,104,105,115, 32,108,105, 99,101,110,
115,101, 32, 40, 34, 70,111,110,116,115, 34, 41, 32, 97,110,100,
 32, 97,115,115,111, 99,105, 97,116,101,100, 32,100,111, 99,117,
109,101,110,116, 97,116,105,111,110, 32,102,105,108,101,115, 32,
 40,116,104,101, 32, 34, 70,111,110,116, 32, 83,111,102,116,119,
 97,114,101, 34, 41, 44, 32,116,111, 32,114,101,112,114,111,100,
117, 99,101, 32, 97,110,100, 32,100,105,115,116,114,105, 98,117,
116,101, 32,116,104,101, 32, 70,111,110,116, 32, 83,111,102,116,
119, 97,114,101, 44, 32,105,110, 99,108,117,100,105,110,103, 32,
119,105,116,104,111,117,116, 32,108,105,109,105,116, 97,116,105,
111,110, 32,116,104,101, 32,114,105,103,104,116,115, 32,116,111,
 32,117,115,101, 44, 32, 99,111,112,121, 44, 32,109,101,114,103,
101, 44, 32,112,117, 98,108,105,115,104, 44, 32,100,105,115,116,
114,105, 98,117,116,101, 44, 32, 97,110,100, 47,111,114, 32,115,
101,108,108, 32, 99,111,112,105,101,115, 32,111,102, 32,116,104,
101, 32, 70,111,110,116, 32, 83,111,102,116,119, 97,114,101, 44,
 32, 97,110,100, 32,116,111, 32,112,101,114,109,105,116, 32,112,
101,114,115,111,110,115, 32,116,111, 32,119,104,111,109, 32,116,
104,101, 32, 70,111,110,116, 32, 83,111,102,116,119, 97,114,101,
 32,105,115, 32,102,117,114,110,105,115,104,101,100, 32,116,111,
 32,100,111, 32,115,111, 44, 32,115,117, 98,106,101, 99,116, 32,
116,111, 32,116,104,101, 32,102,111,108,108,111,119,105,110,103,
 32, 99,111,110,100,105,116,105,111,110,115, 58, 13, 10, 13, 10,
 84,104,101, 32, 97, 98,111,118,101, 32, 99,111,112,121,114,105,
103,104,116, 32, 97,110,100, 32,116,114, 97,100,101,109, 97,114,
107, 32,110,111,116,105, 99,101,115, 32, 97,110,100, 32,116,104,
105,115, 32,112,101,114,109,105,115,115,105,111,110, 32,110,111,
116,105, 99,101, 32,115,104, 97,108,108, 32, 98,101, 32,105,110,
 99,108,117,100,101,100, 32,105,110, 32, 97,108,108, 32, 99,111,
112,105,101,115, 32,111,102, 32,111,110,101, 32,111,114, 32,109,
111,114,101, 32,111,102, 32,116,104,101, 32, 70,111,110,116, 32,
 83,111,102,116,119, 97,114,101, 32,116,121,112,101,102, 97, 99,
101,115, 46, 13, 10, 13, 10, 84,104,101, 32, 70,111,110,116, 32,
 83,111,102,116,119, 97,114,101, 32,109, 97,121, 32, 98,101, 32,
109,111,100,105,102,105,101,100, 44, 32, 97,108,116,101,114,101,
100, 44, 32,111,114, 32, 97,100,100,101,100, 32,116,111, 44, 32,
 97,110,100, 32,105,110, 32,112, 97,114,116,105, 99,117,108, 97,
114, 32,116,104,101, 32,100,101,115,105,103,110,115, 32,111,102,
 32,103,108,121,112,104,115, 32,111,114, 32, 99,104, 97,114, 97,
 99,116,101,114,115, 32,105,110, 32,116,104,101, 32, 70,111,110,
116,115, 32,109, 97,121, 32, 98,101, 32,109,111,100,105,102,105,
101,100, 32, 97,110,100, 32, 97,100,100,105,116,105,111,110, 97,
108, 32,103,108,121,112,104,115, 32,111,114, 32, 99,104, 97,114,
 97, 99,116,101,114,115, 32,109, 97,121, 32, 98,101, 32, 97,100,
100,101,100, 32,116,111, 32,116,104,101, 32, 70,111,110,116,115,
 44, 32,111,110,108,121, 32,105,102, 32,116,104,101, 32,102,111,
110,116,115, 32, 97,114,101, 32,114,101,110, 97,109,101,100, 32,
116,111, 32,110, 97,109,101,115, 32,110,111,116, 32, 99,111,110,
116, 97,105,110,105,110,103, 32,101,105,116,104,101,114, 32,116,
104,101, 32,119,111,114,100,115, 32, 34, 66,105,116,115,116,114,
101, 97,109, 34, 32,111,114, 32,116,104,101, 32,119,111,114,100,
 32, 34, 86,101,114, 97, 34, 46, 13, 10, 13, 10, 84,104,105,115,
 32, 76,105, 99,101,110,115,101, 32, 98,101, 99,111,109,101,115,
 32,110,117,108,108, 32, 97,110,100, 32,118,111,105,100, 32,116,
111, 32,116,104,101, 32,101,120,116,101,110,116, 32, 97,112,112,
108,105, 99, 97, 98,108,101, 32,116,111, 32, 70,111,110,116,115,
 32,111,114, 32, 70,111,110,116, 32, 83,111,102,116,119, 97,114,
101, 32,116,104, 97,116, 32,104, 97,115, 32, 98,101,101,110, 32,
109,111,100,105,102,105,101,100, 32, 97,110,100, 32,105,115, 32,
100,105,115,116,114,105, 98,117,116,101,100, 32,117,110,100,101,
114, 32,116,104,101, 32, 34, 66,105,116,115,116,114,101, 97,109,
 32, 86,101,114, 97, 34, 32,110, 97,109,101,115, 46, 13, 10, 13,
 10, 84,104,101, 32, 70,111,110,116, 32, 83,111,102,116,119, 97,
114,101, 32,109, 97,121, 32, 98,101, 32,115,111,108,100, 32, 97,
115, 32,112, 97,114,116, 32,111,102, 32, 97, 32,108, 97,114,103,
101,114, 32,115,111,102,116,119, 97,114,101, 32,112, 97, 99,107,
 97,103,101, 32, 98,117,116, 32,110,111, 32, 99,111,112,121, 32,
111,102, 32,111,110,101, 32,111,114, 32,109,111,114,101, 32,111,
102, 32,116,104,101, 32, 70,111,110,116, 32, 83,111,102,116,119,
 97,114,101, 32,116,121,112,101,102, 97, 99,101,115, 32,109, 97,
121, 32, 98,101, 32,115,111,108,100, 32, 98,121, 32,105,116,115,
101,108,102, 46, 13, 10, 13, 10, 84, 72, 69, 32, 70, 79, 78, 84,
 32, 83, 79, 70, 84, 87, 65, 82, 69, 32, 73, 83, 32, 80, 82, 79,
 86, 73, 68, 69, 68, 32, 34, 65, 83, 32, 73, 83, 34, 44, 32, 87,
 73, 84, 72, 79, 85, 84, 32, 87, 65, 82, 82, 65, 78, 84, 89, 32,
 79, 70, 32, 65, 78, 89, 32, 75, 73, 78, 68, 44, 32, 69, 88, 80,
 82, 69, 83, 83, 32, 79, 82, 32, 73, 77, 80, 76, 73, 69, 68, 44,
 32, 73, 78, 67, 76, 85, 68, 73, 78, 71, 32, 66, 85, 84, 32, 78,
 79, 84, 32, 76, 73, 77, 73, 84, 69, 68, 32, 84, 79, 32, 65, 78,
 89, 32, 87, 65, 82, 82, 65, 78, 84, 73, 69, 83, 32, 79, 70, 32,
 77, 69, 82, 67, 72, 65, 78, 84, 65, 66, 73, 76, 73, 84, 89, 44,
 32, 70, 73, 84, 78, 69, 83, 83, 32, 70, 79, 82, 32, 65, 32, 80,
 65, 82, 84, 73, 67, 85, 76, 65, 82, 32, 80, 85, 82, 80, 79, 83,
 69, 32, 65, 78, 68, 32, 78, 79, 78, 73, 78, 70, 82, 73, 78, 71,
 69, 77, 69, 78, 84, 32, 79, 70, 32, 67, 79, 80, 89, 82, 73, 71,
 72, 84, 44, 32, 80, 65, 84, 69, 78, 84, 44, 32, 84, 82, 65, 68,
 69, 77, 65, 82, 75, 44, 32, 79, 82, 32, 79, 84, 72, 69, 82, 32,
 82, 73, 71, 72, 84, 46, 32, 73, 78, 32, 78, 79, 32, 69, 86, 69,
 78, 84, 32, 83, 72, 65, 76, 76, 32, 66, 73, 84, 83, 84, 82, 69,
 65, 77, 32, 79, 82, 32, 84, 72, 69, 32, 71, 78, 79, 77, 69, 32,
 70, 79, 85, 78, 68, 65, 84, 73, 79, 78, 32, 66, 69, 32, 76, 73,
 65, 66, 76, 69, 32, 70, 79, 82, 32, 65, 78, 89, 32, 67, 76, 65,
 73, 77, 44, 32, 68, 65, 77, 65, 71, 69, 83, 32, 79, 82, 32, 79,
 84, 72, 69, 82, 32, 76, 73, 65, 66, 73, 76, 73, 84, 89, 44, 32,
 73, 78, 67, 76, 85, 68, 73, 78, 71, 32, 65, 78, 89, 32, 71, 69,
 78, 69, 82, 65, 76, 44, 32, 83, 80, 69, 67, 73, 65, 76, 44, 32,
 73, 78, 68, 73, 82, 69, 67, 84, 44, 32, 73, 78, 67, 73, 68, 69,
 78, 84, 65, 76, 44, 32, 79, 82, 32, 67, 79, 78, 83, 69, 81, 85,
 69, 78, 84, 73, 65, 76, 32, 68, 65, 77, 65, 71, 69, 83, 44, 32,
 87, 72, 69, 84, 72, 69, 82, 32, 73, 78, 32, 65, 78, 32, 65, 67,
 84, 73, 79, 78, 32, 79, 70, 32, 67, 79, 78, 84, 82, 65, 67, 84,
 44, 32, 84, 79, 82, 84, 32, 79, 82, 32, 79, 84, 72, 69, 82, 87,
 73, 83, 69, 44, 32, 65, 82, 73, 83, 73, 78, 71, 32, 70, 82, 79,
 77, 44, 32, 79, 85, 84, 32, 79, 70, 32, 84, 72, 69, 32, 85, 83,
 69, 32, 79, 82, 32, 73, 78, 65, 66, 73, 76, 73, 84, 89, 32, 84,
 79, 32, 85, 83, 69, 32, 84, 72, 69, 32, 70, 79, 78, 84, 32, 83,
 79, 70, 84, 87, 65, 82, 69, 32, 79, 82, 32, 70, 82, 79, 77, 32,
 79, 84, 72, 69, 82, 32, 68, 69, 65, 76, 73, 78, 71, 83, 32, 73,
 78, 32, 84, 72, 69, 32, 70, 79, 78, 84, 32, 83, 79, 70, 84, 87,
 65, 82, 69, 46, 13, 10, 13, 10, 69,120, 99,101,112,116, 32, 97,
115, 32, 99,111,110,116, 97,105,110,101,100, 32,105,110, 32,116,
104,105,115, 32,110,111,116,105, 99,101, 44, 32,116,104,101, 32,
110, 97,109,101,115, 32,111,102, 32, 71,110,111,109,101, 44, 32,
116,104,101, 32, 71,110,111,109,101, 32, 70,111,117,110,100, 97,
116,105,111,110, 44, 32, 97,110,100, 32, 66,105,116,115,116,114,
101, 97,109, 32, 73,110, 99, 46, 44, 32,115,104, 97,108,108, 32,
110,111,116, 32, 98,101, 32,117,115,101,100, 32,105,110, 32, 97,
100,118,101,114,116,105,115,105,110,103, 32,111,114, 32,111,116,
104,101,114,119,105,115,101, 32,116,111, 32,112,114,111,109,111,
116,101, 32,116,104,101, 32,115, 97,108,101, 44, 32,117,115,101,
 32,111,114, 32,111,116,104,101,114, 32,100,101, 97,108,105,110,
103,115, 32,105,110, 32,116,104,105,115, 32, 70,111,110,116, 32,
 83,111,102,116,119, 97,114,101, 32,119,105,116,104,111,117,116,
 32,112,114,105,111,114, 32,119,114,105,116,116,101,110, 32, 97,
117,116,104,111,114,105,122, 97,116,105,111,110, 32,102,114,111,
109, 32,116,104,101, 32, 71,110,111,109,101, 32, 70,111,117,110,
100, 97,116,105,111,110, 32,111,114, 32, 66,105,116,115,116,114,
101, 97,109, 32, 73,110, 99, 46, 44, 32,114,101,115,112,101, 99,
116,105,118,101,108,121, 46, 32, 70,111,114, 32,102,117,114,116,
104,101,114, 32,105,110,102,111,114,109, 97,116,105,111,110, 44,
 32, 99,111,110,116, 97, 99,116, 58, 32,102,111,110,116,115, 32,
 97,116, 32,103,110,111,109,101, 32,100,111,116, 32,111,114,103,
 46,104,116,116,112, 58, 47, 47,119,119,119, 46, 98,105,116,115,
116,114,101, 97,109, 46, 99,111,109,  0, 67,  0,111,  0,112,  0,
121,  0,114,  0,105,  0,103,  0,104,  0,116,  0, 32,  0, 40,  0,
 99,  0, 41,  0, 32,  0, 50,  0, 48,  0, 48,  0, 51,  0, 32,  0,
 98,  0,121,  0, 32,  0, 66,  0,105,  0,116,  0,115,  0,116,  0,
114,  0,101,  0, 97,  0,109,  0, 44,  0, 32,  0, 73,  0,110,  0,
 99,  0, 46,  0, 32,  0, 65,  0,108,  0,108,  0, 32,  0, 82,  0,
105,  0,103,  0,104,  0,116,  0,115,  0, 32,  0, 82,  0,101,  0,
115,  0,101,  0,114,  0,118,  0,101,  0,100,  0, 46,  0, 66,  0,
105,  0,116,  0,115,  0,116,  0,114,  0,101,  0, 97,  0,109,  0,
 32,  0, 86,  0,101,  0,114,  0, 97,  0, 32,  0, 83,  0, 97,  0,
110,  0,115,  0, 32,  0, 66,  0,111,  0,108,  0,100,  0, 82,  0,
101,  0,108,  0,101,  0, 97,  0,115,  0,101,  0, 32,  0, 49,  0,
 46,  0, 49,  0, 48,  0, 66,  0,105,  0,116,  0,115,  0,116,  0,
114,  0,101,  0, 97,  0,109,  0, 86,  0,101,  0,114,  0, 97,  0,
 83,  0, 97,  0,110,  0,115,  0, 45,  0, 66,  0,111,  0,108,  0,
100,  0, 67,  0,111,  0,112,  0,121,  0,114,  0,105,  0,103,  0,
104,  0,116,  0, 32,  0, 40,  0, 99,  0, 41,  0, 32,  0, 50,  0,
 48,  0, 48,  0, 51,  0, 32,  0, 98,  0,121,  0, 32,  0, 66,  0,
105,  0,116,  0,115,  0,116,  0,114,  0,101,  0, 97,  0,109,  0,
 44,  0, 32,  0, 73,  0,110,  0, 99,  0, 46,  0, 13,  0, 10,  0,
 65,  0,108,  0,108,  0, 32,  0, 82,  0,105,  0,103,  0,104,  0,
116,  0,115,  0, 32,  0, 82,  0,101,  0,115,  0,101,  0,114,  0,
118,  0,101,  0,100,  0, 46,  0, 13,  0, 10,  0, 66,  0,105,  0,
116,  0,115,  0,116,  0,114,  0,101,  0, 97,  0,109,  0, 32,  0,
 86,  0,101,  0,114,  0, 97,  0, 32,  0,105,  0,115,  0, 32,  0,
 97,  0, 32,  0,116,  0,114,  0, 97,  0,100,  0,101,  0,109,  0,
 97,  0,114,  0,107,  0, 32,  0,111,  0,102,  0, 32,  0, 66,  0,
105,  0,116,  0,115,  0,116,  0,114,  0,101,  0, 97,  0,109,  0,
 44,  0, 32,  0, 73,  0,110,  0, 99,  0, 46,  0, 13,  0, 10,  0,
 13,  0, 10,  0, 80,  0,101,  0,114,  0,109,  0,105,  0,115,  0,
115,  0,105,  0,111,  0,110,  0, 32,  0,105,  0,115,  0, 32,  0,
104,  0,101,  0,114,  0,101,  0, 98,  0,121,  0, 32,  0,103,  0,
114,  0, 97,  0,110,  0,116,  0,101,  0,100,  0, 44,  0, 32,  0,
102,  0,114,  0,101,  0,101,  0, 32,  0,111,  0,102,  0, 32,  0,
 99,  0,104,  0, 97,  0,114,  0,103,  0,101,  0, 44,  0, 32,  0,
116,  0,111,  0, 32,  0, 97,  0,110,  0,121,  0, 32,  0,112,  0,
101,  0,114,  0,115,  0,111,  0,110,  0, 32,  0,111,  0, 98,  0,
116,  0, 97,  0,105,  0,110,  0,105,  0,110,  0,103,  0, 32,  0,
 97,  0, 32,  0, 99,  0,111,  0,112,  0,121,  0, 32,  0,111,  0,
102,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0,102,  0,111,  0,
110,  0,116,  0,115,  0, 32,  0, 97,  0, 99,  0, 99,  0,111,  0,
109,  0,112,  0, 97,  0,110,  0,121,  0,105,  0,110,  0,103,  0,
 32,  0,116,  0,104,  0,105,  0,115,  0, 32,  0,108,  0,105,  0,
 99,  0,101,  0,110,  0,115,  0,101,  0, 32,  0, 40,  0, 34,  0,
 70,  0,111,  0,110,  0,116,  0,115,  0, 34,  0, 41,  0, 32,  0,
 97,  0,110,  0,100,  0, 32,  0, 97,  0,115,  0,115,  0,111,  0,
 99,  0,105,  0, 97,  0,116,  0,101,  0,100,  0, 32,  0,100,  0,
111,  0, 99,  0,117,  0,109,  0,101,  0,110,  0,116,  0, 97,  0,
116,  0,105,  0,111,  0,110,  0, 32,  0,102,  0,105,  0,108,  0,
101,  0,115,  0, 32,  0, 40,  0,116,  0,104,  0,101,  0, 32,  0,
 34,  0, 70,  0,111,  0,110,  0,116,  0, 32,  0, 83,  0,111,  0,
102,  0,116,  0,119,  0, 97,  0,114,  0,101,  0, 34,  0, 41,  0,
 44,  0, 32,  0,116,  0,111,  0, 32,  0,114,  0,101,  0,112,  0,
114,  0,111,  0,100,  0,117,  0, 99,  0,101,  0, 32,  0, 97,  0,
110,  0,100,  0, 32,  0,100,  0,105,  0,115,  0,116,  0,114,  0,
105,  0, 98,  0,117,  0,116,  0,101,  0, 32,  0,116,  0,104,  0,
101,  0, 32,  0, 70,  0,111,  0,110,  0,116,  0, 32,  0, 83,  0,
111,  0,102,  0,116,  0,119,  0, 97,  0,114,  0,101,  0, 44,  0,
 32,  0,105,  0,110,  0, 99,  0,108,  0,117,  0,100,  0,105,  0,
110,  0,103,  0, 32,  0,119,  0,105,  0,116,  0,104,  0,111,  0,
117,  0,116,  0, 32,  0,108,  0,105,  0,109,  0,105,  0,116,  0,
 97,  0,116,  0,105,  0,111,  0,110,  0, 32,  0,116,  0,104,  0,
101,  0, 32,  0,114,  0,105,  0,103,  0,104,  0,116,  0,115,  0,
 32,  0,116,  0,111,  0, 32,  0,117,  0,115,  0,101,  0, 44,  0,
 32,  0, 99,  0,111,  0,112,  0,121,  0, 44,  0, 32,  0,109,  0,
101,  0,114,  0,103,  0,101,  0, 44,  0, 32,  0,112,  0,117,  0,
 98,  0,108,  0,105,  0,115,  0,104,  0, 44,  0, 32,  0,100,  0,
105,  0,115,  0,116,  0,114,  0,105,  0, 98,  0,117,  0,116,  0,
101,  0, 44,  0, 32,  0, 97,  0,110,  0,100,  0, 47,  0,111,  0,
114,  0, 32,  0,115,  0,101,  0,108,  0,108,  0, 32,  0, 99,  0,
111,  0,112,  0,105,  0,101,  0,115,  0, 32,  0,111,  0,102,  0,
 32,  0,116,  0,104,  0,101,  0, 32,  0, 70,  0,111,  0,110,  0,
116,  0, 32,  0, 83,  0,111,  0,102,  0,116,  0,119,  0, 97,  0,
114,  0,101,  0, 44,  0, 32,  0, 97,  0,110,  0,100,  0, 32,  0,
116,  0,111,  0, 32,  0,112,  0,101,  0,114,  0,109,  0,105,  0,
116,  0, 32,  0,112,  0,101,  0,114,  0,115,  0,111,  0,110,  0,
115,  0, 32,  0,116,  0,111,  0, 32,  0,119,  0,104,  0,111,  0,
109,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0, 70,  0,111,  0,
110,  0,116,  0, 32,  0, 83,  0,111,  0,102,  0,116,  0,119,  0,
 97,  0,114,  0,101,  0, 32,  0,105,  0,115,  0, 32,  0,102,  0,
117,  0,114,  0,110,  0,105,  0,115,  0,104,  0,101,  0,100,  0,
 32,  0,116,  0,111,  0, 32,  0,100,  0,111,  0, 32,  0,115,  0,
111,  0, 44,  0, 32,  0,115,  0,117,  0, 98,  0,106,  0,101,  0,
 99,  0,116,  0, 32,  0,116,  0,111,  0, 32,  0,116,  0,104,  0,
101,  0, 32,  0,102,  0,111,  0,108,  0,108,  0,111,  0,119,  0,
105,  0,110,  0,103,  0, 32,  0, 99,  0,111,  0,110,  0,100,  0,
105,  0,116,  0,105,  0,111,  0,110,  0,115,  0, 58,  0, 13,  0,
 10,  0, 13,  0, 10,  0, 84,  0,104,  0,101,  0, 32,  0, 97,  0,
 98,  0,111,  0,118,  0,101,  0, 32,  0, 99,  0,111,  0,112,  0,
121,  0,114,  0,105,  0,103,  0,104,  0,116,  0, 32,  0, 97,  0,
110,  0,100,  0, 32,  0,116,  0,114,  0, 97,  0,100,  0,101,  0,
109,  0, 97,  0,114,  0,107,  0, 32,  0,110,  0,111,  0,116,  0,
105,  0, 99,  0,101,  0,115,  0, 32,  0, 97,  0,110,  0,100,  0,
 32,  0,116,  0,104,  0,105,  0,115,  0, 32,  0,112,  0,101,  0,
114,  0,109,  0,105,  0,115,  0,115,  0,105,  0,111,  0,110,  0,
 32,  0,110,  0,111,  0,116,  0,105,  0, 99,  0,101,  0, 32,  0,
115,  0,104,  0, 97,  0,108,  0,108,  0, 32,  0, 98,  0,101,  0,
 32,  0,105,  0,110,  0, 99,  0,108,  0,117,  0,100,  0,101,  0,
100,  0, 32,  0,105,  0,110,  0, 32,  0, 97,  0,108,  0,108,  0,
 32,  0, 99,  0,111,  0,112,  0,105,  0,101,  0,115,  0, 32,  0,
111,  0,102,  0, 32,  0,111,  0,110,  0,101,  0, 32,  0,111,  0,
114,  0, 32,  0,109,  0,111,  0,114,  0,101,  0, 32,  0,111,  0,
102,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0, 70,  0,111,  0,
110,  0,116,  0, 32,  0, 83,  0,111,  0,102,  0,116,  0,119,  0,
 97,  0,114,  0,101,  0, 32,  0,116,  0,121,  0,112,  0,101,  0,
102,  0, 97,  0, 99,  0,101,  0,115,  0, 46,  0, 13,  0, 10,  0,
 13,  0, 10,  0, 84,  0,104,  0,101,  0, 32,  0, 70,  0,111,  0,
110,  0,116,  0, 32,  0, 83,  0,111,  0,102,  0,116,  0,119,  0,
 97,  0,114,  0,101,  0, 32,  0,109,  0, 97,  0,121,  0, 32,  0,
 98,  0,101,  0, 32,  0,109,  0,111,  0,100,  0,105,  0,102,  0,
105,  0,101,  0,100,  0, 44,  0, 32,  0, 97,  0,108,  0,116,  0,
101,  0,114,  0,101,  0,100,  0, 44,  0, 32,  0,111,  0,114,  0,
 32,  0, 97,  0,100,  0,100,  0,101,  0,100,  0, 32,  0,116,  0,
111,  0, 44,  0, 32,  0, 97,  0,110,  0,100,  0, 32,  0,105,  0,
110,  0, 32,  0,112,  0, 97,  0,114,  0,116,  0,105,  0, 99,  0,
117,  0,108,  0, 97,  0,114,  0, 32,  0,116,  0,104,  0,101,  0,
 32,  0,100,  0,101,  0,115,  0,105,  0,103,  0,110,  0,115,  0,
 32,  0,111,  0,102,  0, 32,  0,103,  0,108,  0,121,  0,112,  0,
104,  0,115,  0, 32,  0,111,  0,114,  0, 32,  0, 99,  0,104,  0,
 97,  0,114,  0, 97,  0, 99,  0,116,  0,101,  0,114,  0,115,  0,
 32,  0,105,  0,110,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0,
 70,  0,111,  0,110,  0,116,  0,115,  0, 32,  0,109,  0, 97,  0,
121,  0, 32,  0, 98,  0,101,  0, 32,  0,109,  0,111,  0,100,  0,
105,  0,102,  0,105,  0,101,  0,100,  0, 32,  0, 97,  0,110,  0,
100,  0, 32,  0, 97,  0,100,  0,100,  0,105,  0,116,  0,105,  0,
111,  0,110,  0, 97,  0,108,  0, 32,  0,103,  0,108,  0,121,  0,
112,  0,104,  0,115,  0, 32,  0,111,  0,114,  0, 32,  0, 99,  0,
104,  0, 97,  0,114,  0, 97,  0, 99,  0,116,  0,101,  0,114,  0,
115,  0, 32,  0,109,  0, 97,  0,121,  0, 32,  0, 98,  0,101,  0,
 32,  0, 97,  0,100,  0,100,  0,101,  0,100,  0, 32,  0,116,  0,
111,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0, 70,  0,111,  0,
110,  0,116,  0,115,  0, 44,  0, 32,  0,111,  0,110,  0,108,  0,
121,  0, 32,  0,105,  0,102,  0, 32,  0,116,  0,104,  0,101,  0,
 32,  0,102,  0,111,  0,110,  0,116,  0,115,  0, 32,  0, 97,  0,
114,  0,101,  0, 32,  0,114,  0,101,  0,110,  0, 97,  0,109,  0,
101,  0,100,  0, 32,  0,116,  0,111,  0, 32,  0,110,  0, 97,  0,
109,  0,101,  0,115,  0, 32,  0,110,  0,111,  0,116,  0, 32,  0,
 99,  0,111,  0,110,  0,116,  0, 97,  0,105,  0,110,  0,105,  0,
110,  0,103,  0, 32,  0,101,  0,105,  0,116,  0,104,  0,101,  0,
114,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0,119,  0,111,  0,
114,  0,100,  0,115,  0, 32,  0, 34,  0, 66,  0,105,  0,116,  0,
115,  0,116,  0,114,  0,101,  0, 97,  0,109,  0, 34,  0, 32,  0,
111,  0,114,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0,119,  0,
111,  0,114,  0,100,  0, 32,  0, 34,  0, 86,  0,101,  0,114,  0,
 97,  0, 34,  0, 46,  0, 13,  0, 10,  0, 13,  0, 10,  0, 84,  0,
104,  0,105,  0,115,  0, 32,  0, 76,  0,105,  0, 99,  0,101,  0,
110,  0,115,  0,101,  0, 32,  0, 98,  0,101,  0, 99,  0,111,  0,
109,  0,101,  0,115,  0, 32,  0,110,  0,117,  0,108,  0,108,  0,
 32,  0, 97,  0,110,  0,100,  0, 32,  0,118,  0,111,  0,105,  0,
100,  0, 32,  0,116,  0,111,  0, 32,  0,116,  0,104,  0,101,  0,
 32,  0,101,  0,120,  0,116,  0,101,  0,110,  0,116,  0, 32,  0,
 97,  0,112,  0,112,  0,108,  0,105,  0, 99,  0, 97,  0, 98,  0,
108,  0,101,  0, 32,  0,116,  0,111,  0, 32,  0, 70,  0,111,  0,
110,  0,116,  0,115,  0, 32,  0,111,  0,114,  0, 32,  0, 70,  0,
111,  0,110,  0,116,  0, 32,  0, 83,  0,111,  0,102,  0,116,  0,
119,  0, 97,  0,114,  0,101,  0, 32,  0,116,  0,104,  0, 97,  0,
116,  0, 32,  0,104,  0, 97,  0,115,  0, 32,  0, 98,  0,101,  0,
101,  0,110,  0, 32,  0,109,  0,111,  0,100,  0,105,  0,102,  0,
105,  0,101,  0,100,  0, 32,  0, 97,  0,110,  0,100,  0, 32,  0,
105,  0,115,  0, 32,  0,100,  0,105,  0,115,  0,116,  0,114,  0,
105,  0, 98,  0,117,  0,116,  0,101,  0,100,  0, 32,  0,117,  0,
110,  0,100,  0,101,  0,114,  0, 32,  0,116,  0,104,  0,101,  0,
 32,  0, 34,  0, 66,  0,105,  0,116,  0,115,  0,116,  0,114,  0,
101,  0, 97,  0,109,  0, 32,  0, 86,  0,101,  0,114,  0, 97,  0,
 34,  0, 32,  0,110,  0, 97,  0,109,  0,101,  0,115,  0, 46,  0,
 13,  0, 10,  0, 13,  0, 10,  0, 84,  0,104,  0,101,  0, 32,  0,
 70,  0,111,  0,110,  0,116,  0, 32,  0, 83,  0,111,  0,102,  0,
116,  0,119,  0, 97,  0,114,  0,101,  0, 32,  0,109,  0, 97,  0,
121,  0, 32,  0, 98,  0,101,  0, 32,  0,115,  0,111,  0,108,  0,
100,  0, 32,  0, 97,  0,115,  0, 32,  0,112,  0, 97,  0,114,  0,
116,  0, 32,  0,111,  0,102,  0, 32,  0, 97,  0, 32,  0,108,  0,
 97,  0,114,  0,103,  0,101,  0,114,  0, 32,  0,115,  0,111,  0,
102,  0,116,  0,119,  0, 97,  0,114,  0,101,  0, 32,  0,112,  0,
 97,  0, 99,  0,107,  0, 97,  0,103,  0,101,  0, 32,  0, 98,  0,
117,  0,116,  0, 32,  0,110,  0,111,  0, 32,  0, 99,  0,111,  0,
112,  0,121,  0, 32,  0,111,  0,102,  0, 32,  0,111,  0,110,  0,
101,  0, 32,  0,111,  0,114,  0, 32,  0,109,  0,111,  0,114,  0,
101,  0, 32,  0,111,  0,102,  0, 32,  0,116,  0,104,  0,101,  0,
 32,  0, 70,  0,111,  0,110,  0,116,  0, 32,  0, 83,  0,111,  0,
102,  0,116,  0,119,  0, 97,  0,114,  0,101,  0, 32,  0,116,  0,
121,  0,112,  0,101,  0,102,  0, 97,  0, 99,  0,101,  0,115,  0,
 32,  0,109,  0, 97,  0,121,  0, 32,  0, 98,  0,101,  0, 32,  0,
115,  0,111,  0,108,  0,100,  0, 32,  0, 98,  0,121,  0, 32,  0,
105,  0,116,  0,115,  0,101,  0,108,  0,102,  0, 46,  0, 13,  0,
 10,  0, 13,  0, 10,  0, 84,  0, 72,  0, 69,  0, 32,  0, 70,  0,
 79,  0, 78,  0, 84,  0, 32,  0, 83,  0, 79,  0, 70,  0, 84,  0,
 87,  0, 65,  0, 82,  0, 69,  0, 32,  0, 73,  0, 83,  0, 32,  0,
 80,  0, 82,  0, 79,  0, 86,  0, 73,  0, 68,  0, 69,  0, 68,  0,
 32,  0, 34,  0, 65,  0, 83,  0, 32,  0, 73,  0, 83,  0, 34,  0,
 44,  0, 32,  0, 87,  0, 73,  0, 84,  0, 72,  0, 79,  0, 85,  0,
 84,  0, 32,  0, 87,  0, 65,  0, 82,  0, 82,  0, 65,  0, 78,  0,
 84,  0, 89,  0, 32,  0, 79,  0, 70,  0, 32,  0, 65,  0, 78,  0,
 89,  0, 32,  0, 75,  0, 73,  0, 78,  0, 68,  0, 44,  0, 32,  0,
 69,  0, 88,  0, 80,  0, 82,  0, 69,  0, 83,  0, 83,  0, 32,  0,
 79,  0, 82,  0, 32,  0, 73,  0, 77,  0, 80,  0, 76,  0, 73,  0,
 69,  0, 68,  0, 44,  0, 32,  0, 73,  0, 78,  0, 67,  0, 76,  0,
 85,  0, 68,  0, 73,  0, 78,  0, 71,  0, 32,  0, 66,  0, 85,  0,
 84,  0, 32,  0, 78,  0, 79,  0, 84,  0, 32,  0, 76,  0, 73,  0,
 77,  0, 73,  0, 84,  0, 69,  0, 68,  0, 32,  0, 84,  0, 79,  0,
 32,  0, 65,  0, 78,  0, 89,  0, 32,  0, 87,  0, 65,  0, 82,  0,
 82,  0, 65,  0, 78,  0, 84,  0, 73,  0, 69,  0, 83,  0, 32,  0,
 79,  0, 70,  0, 32,  0, 77,  0, 69,  0, 82,  0, 67,  0, 72,  0,
 65,  0, 78,  0, 84,  0, 65,  0, 66,  0, 73,  0, 76,  0, 73,  0,
 84,  0, 89,  0, 44,  0, 32,  0, 70,  0, 73,  0, 84,  0, 78,  0,
 69,  0, 83,  0, 83,  0, 32,  0, 70,  0, 79,  0, 82,  0, 32,  0,
 65,  0, 32,  0, 80,  0, 65,  0, 82,  0, 84,  0, 73,  0, 67,  0,
 85,  0, 76,  0, 65,  0, 82,  0, 32,  0, 80,  0, 85,  0, 82,  0,
 80,  0, 79,  0, 83,  0, 69,  0, 32,  0, 65,  0, 78,  0, 68,  0,
 32,  0, 78,  0, 79,  0, 78,  0, 73,  0, 78,  0, 70,  0, 82,  0,
 73,  0, 78,  0, 71,  0, 69,  0, 77,  0, 69,  0, 78,  0, 84,  0,
 32,  0, 79,  0, 70,  0, 32,  0, 67,  0, 79,  0, 80,  0, 89,  0,
 82,  0, 73,  0, 71,  0, 72,  0, 84,  0, 44,  0, 32,  0, 80,  0,
 65,  0, 84,  0, 69,  0, 78,  0, 84,  0, 44,  0, 32,  0, 84,  0,
 82,  0, 65,  0, 68,  0, 69,  0, 77,  0, 65,  0, 82,  0, 75,  0,
 44,  0, 32,  0, 79,  0, 82,  0, 32,  0, 79,  0, 84,  0, 72,  0,
 69,  0, 82,  0, 32,  0, 82,  0, 73,  0, 71,  0, 72,  0, 84,  0,
 46,  0, 32,  0, 73,  0, 78,  0, 32,  0, 78,  0, 79,  0, 32,  0,
 69,  0, 86,  0, 69,  0, 78,  0, 84,  0, 32,  0, 83,  0, 72,  0,
 65,  0, 76,  0, 76,  0, 32,  0, 66,  0, 73,  0, 84,  0, 83,  0,
 84,  0, 82,  0, 69,  0, 65,  0, 77,  0, 32,  0, 79,  0, 82,  0,
 32,  0, 84,  0, 72,  0, 69,  0, 32,  0, 71,  0, 78,  0, 79,  0,
 77,  0, 69,  0, 32,  0, 70,  0, 79,  0, 85,  0, 78,  0, 68,  0,
 65,  0, 84,  0, 73,  0, 79,  0, 78,  0, 32,  0, 66,  0, 69,  0,
 32,  0, 76,  0, 73,  0, 65,  0, 66,  0, 76,  0, 69,  0, 32,  0,
 70,  0, 79,  0, 82,  0, 32,  0, 65,  0, 78,  0, 89,  0, 32,  0,
 67,  0, 76,  0, 65,  0, 73,  0, 77,  0, 44,  0, 32,  0, 68,  0,
 65,  0, 77,  0, 65,  0, 71,  0, 69,  0, 83,  0, 32,  0, 79,  0,
 82,  0, 32,  0, 79,  0, 84,  0, 72,  0, 69,  0, 82,  0, 32,  0,
 76,  0, 73,  0, 65,  0, 66,  0, 73,  0, 76,  0, 73,  0, 84,  0,
 89,  0, 44,  0, 32,  0, 73,  0, 78,  0, 67,  0, 76,  0, 85,  0,
 68,  0, 73,  0, 78,  0, 71,  0, 32,  0, 65,  0, 78,  0, 89,  0,
 32,  0, 71,  0, 69,  0, 78,  0, 69,  0, 82,  0, 65,  0, 76,  0,
 44,  0, 32,  0, 83,  0, 80,  0, 69,  0, 67,  0, 73,  0, 65,  0,
 76,  0, 44,  0, 32,  0, 73,  0, 78,  0, 68,  0, 73,  0, 82,  0,
 69,  0, 67,  0, 84,  0, 44,  0, 32,  0, 73,  0, 78,  0, 67,  0,
 73,  0, 68,  0, 69,  0, 78,  0, 84,  0, 65,  0, 76,  0, 44,  0,
 32,  0, 79,  0, 82,  0, 32,  0, 67,  0, 79,  0, 78,  0, 83,  0,
 69,  0, 81,  0, 85,  0, 69,  0, 78,  0, 84,  0, 73,  0, 65,  0,
 76,  0, 32,  0, 68,  0, 65,  0, 77,  0, 65,  0, 71,  0, 69,  0,
 83,  0, 44,  0, 32,  0, 87,  0, 72,  0, 69,  0, 84,  0, 72,  0,
 69,  0, 82,  0, 32,  0, 73,  0, 78,  0, 32,  0, 65,  0, 78,  0,
 32,  0, 65,  0, 67,  0, 84,  0, 73,  0, 79,  0, 78,  0, 32,  0,
 79,  0, 70,  0, 32,  0, 67,  0, 79,  0, 78,  0, 84,  0, 82,  0,
 65,  0, 67,  0, 84,  0, 44,  0, 32,  0, 84,  0, 79,  0, 82,  0,
 84,  0, 32,  0, 79,  0, 82,  0, 32,  0, 79,  0, 84,  0, 72,  0,
 69,  0, 82,  0, 87,  0, 73,  0, 83,  0, 69,  0, 44,  0, 32,  0,
 65,  0, 82,  0, 73,  0, 83,  0, 73,  0, 78,  0, 71,  0, 32,  0,
 70,  0, 82,  0, 79,  0, 77,  0, 44,  0, 32,  0, 79,  0, 85,  0,
 84,  0, 32,  0, 79,  0, 70,  0, 32,  0, 84,  0, 72,  0, 69,  0,
 32,  0, 85,  0, 83,  0, 69,  0, 32,  0, 79,  0, 82,  0, 32,  0,
 73,  0, 78,  0, 65,  0, 66,  0, 73,  0, 76,  0, 73,  0, 84,  0,
 89,  0, 32,  0, 84,  0, 79,  0, 32,  0, 85,  0, 83,  0, 69,  0,
 32,  0, 84,  0, 72,  0, 69,  0, 32,  0, 70,  0, 79,  0, 78,  0,
 84,  0, 32,  0, 83,  0, 79,  0, 70,  0, 84,  0, 87,  0, 65,  0,
 82,  0, 69,  0, 32,  0, 79,  0, 82,  0, 32,  0, 70,  0, 82,  0,
 79,  0, 77,  0, 32,  0, 79,  0, 84,  0, 72,  0, 69,  0, 82,  0,
 32,  0, 68,  0, 69,  0, 65,  0, 76,  0, 73,  0, 78,  0, 71,  0,
 83,  0, 32,  0, 73,  0, 78,  0, 32,  0, 84,  0, 72,  0, 69,  0,
 32,  0, 70,  0, 79,  0, 78,  0, 84,  0, 32,  0, 83,  0, 79,  0,
 70,  0, 84,  0, 87,  0, 65,  0, 82,  0, 69,  0, 46,  0, 13,  0,
 10,  0, 13,  0, 10,  0, 69,  0,120,  0, 99,  0,101,  0,112,  0,
116,  0, 32,  0, 97,  0,115,  0, 32,  0, 99,  0,111,  0,110,  0,
116,  0, 97,  0,105,  0,110,  0,101,  0,100,  0, 32,  0,105,  0,
110,  0, 32,  0,116,  0,104,  0,105,  0,115,  0, 32,  0,110,  0,
111,  0,116,  0,105,  0, 99,  0,101,  0, 44,  0, 32,  0,116,  0,
104,  0,101,  0, 32,  0,110,  0, 97,  0,109,  0,101,  0,115,  0,
 32,  0,111,  0,102,  0, 32,  0, 71,  0,110,  0,111,  0,109,  0,
101,  0, 44,  0, 32,  0,116,  0,104,  0,101,  0, 32,  0, 71,  0,
110,  0,111,  0,109,  0,101,  0, 32,  0, 70,  0,111,  0,117,  0,
110,  0,100,  0, 97,  0,116,  0,105,  0,111,  0,110,  0, 44,  0,
 32,  0, 97,  0,110,  0,100,  0, 32,  0, 66,  0,105,  0,116,  0,
115,  0,116,  0,114,  0,101,  0, 97,  0,109,  0, 32,  0, 73,  0,
110,  0, 99,  0, 46,  0, 44,  0, 32,  0,115,  0,104,  0, 97,  0,
108,  0,108,  0, 32,  0,110,  0,111,  0,116,  0, 32,  0, 98,  0,
101,  0, 32,  0,117,  0,115,  0,101,  0,100,  0, 32,  0,105,  0,
110,  0, 32,  0, 97,  0,100,  0,118,  0,101,  0,114,  0,116,  0,
105,  0,115,  0,105,  0,110,  0,103,  0, 32,  0,111,  0,114,  0,
 32,  0,111,  0,116,  0,104,  0,101,  0,114,  0,119,  0,105,  0,
115,  0,101,  0, 32,  0,116,  0,111,  0, 32,  0,112,  0,114,  0,
111,  0,109,  0,111,  0,116,  0,101,  0, 32,  0,116,  0,104,  0,
101,  0, 32,  0,115,  0, 97,  0,108,  0,101,  0, 44,  0, 32,  0,
117,  0,115,  0,101,  0, 32,  0,111,  0,114,  0, 32,  0,111,  0,
116,  0,104,  0,101,  0,114,  0, 32,  0,100,  0,101,  0, 97,  0,
108,  0,105,  0,110,  0,103,  0,115,  0, 32,  0,105,  0,110,  0,
 32,  0,116,  0,104,  0,105,  0,115,  0, 32,  0, 70,  0,111,  0,
110,  0,116,  0, 32,  0, 83,  0,111,  0,102,  0,116,  0,119,  0,
 97,  0,114,  0,101,  0, 32,  0,119,  0,105,  0,116,  0,104,  0,
111,  0,117,  0,116,  0, 32,  0,112,  0,114,  0,105,  0,111,  0,
114,  0, 32,  0,119,  0,114,  0,105,  0,116,  0,116,  0,101,  0,
110,  0, 32,  0, 97,  0,117,  0,116,  0,104,  0,111,  0,114,  0,
105,  0,122,  0, 97,  0,116,  0,105,  0,111,  0,110,  0, 32,  0,
102,  0,114,  0,111,  0,109,  0, 32,  0,116,  0,104,  0,101,  0,
 32,  0, 71,  0,110,  0,111,  0,109,  0,101,  0, 32,  0, 70,  0,
111,  0,117,  0,110,  0,100,  0, 97,  0,116,  0,105,  0,111,  0,
110,  0, 32,  0,111,  0,114,  0, 32,  0, 66,  0,105,  0,116,  0,
115,  0,116,  0,114,  0,101,  0, 97,  0,109,  0, 32,  0, 73,  0,
110,  0, 99,  0, 46,  0, 44,  0, 32,  0,114,  0,101,  0,115,  0,
112,  0,101,  0, 99,  0,116,  0,105,  0,118,  0,101,  0,108,  0,
121,  0, 46,  0, 32,  0, 70,  0,111,  0,114,  0, 32,  0,102,  0,
117,  0,114,  0,116,  0,104,  0,101,  0,114,  0, 32,  0,105,  0,
110,  0,102,  0,111,  0,114,  0,109,  0, 97,  0,116,  0,105,  0,
111,  0,110,  0, 44,  0, 32,  0, 99,  0,111,  0,110,  0,116,  0,
 97,  0, 99,  0,116,  0, 58,  0, 32,  0,102,  0,111,  0,110,  0,
116,  0,115,  0, 32,  0, 97,  0,116,  0, 32,  0,103,  0,110,  0,
111,  0,109,  0,101,  0, 32,  0,100,  0,111,  0,116,  0, 32,  0,
111,  0,114,  0,103,  0, 46,  0,104,  0,116,  0,116,  0,112,  0,
 58,  0, 47,  0, 47,  0,119,  0,119,  0,119,  0, 46,  0, 98,  0,
105,  0,116,  0,115,  0,116,  0,114,  0,101,  0, 97,  0,109,  0,
 46,  0, 99,  0,111,  0,109,  0,  1,102,  1, 51,  1,102,  0,188,
  0,233,  0,  0,  1, 61,  0,162,  0,250,  3, 31,  0,  2,  0,  2,
  0,102,  1,102,  0,  2,  0,  2,  0,172,  1, 84,  0,236,  0,188,
  0, 98,  1,102,  1,129,  4,133,  1, 84,  1,102,  1,109,  4,164,
  0,  2,  1,102,  0,127,  4,205,  0,  0,  0,  2,  1, 51,  0, 98,
  0,113,  0,  0,  0, 37,  4,164,  1,188,  0,186,  0,229,  0,102,
  1,129,  1,141,  5, 72,  5, 90,  1,102,  1,109,  0,  0,  0,  0,
  0,  2,  0,  2,  0,246,  5,195,  1,240,  5, 57,  2, 57,  0, 88,
  4,109,  4, 61,  4,178,  4,129,  4,178,  1,102,  1,117,  4,102,
  4,129,  0,176,  4,102,  4, 57,  2,209,  4,156,  4,123,  4,207,
  4,123,  0, 88,  1, 51,  1,102,  1, 76,  1,102,  1, 76,  0,  2,
  0,172,  0,154,  1, 74,  1, 35,  0,154,  2,154,  1, 68,  1, 25,
  1, 68,  2,205,  0,193,  0,  0,  1,102,  1, 63,  1,154,  1, 59,
  5,203,  5,203,  0,213,  0,213,  1, 80,  0,172,  0,172,  0,119,
  2, 10,  1,199,  1,242,  1, 47,  1, 88,  1,178,  1, 35,  0,246,
  0,246,  1, 31,  1, 47,  1, 53,  2, 53,  1,238,  1,231,  1, 51,
  0,152,  0,209,  3, 88,  5, 10,  0,154,  0,143,  1, 18,  0,152,
  0,188,  0,205,  0,229,  0,229,  0,242,  0,115,  4,  0,  1,102,
  0,143,  5,213,  2, 43,  5,213,  0,195,  0,225,  0,215,  0,229,
  0,  0,  0,106,  1,  2,  0,  0,  0, 29,  3, 45,  5,213,  5,213,
  5,240,  0,168,  0,106,  0,236,  0,225,  1,  2,  5,213,  6, 20,
  7, 33,  4,102,  2,248,  0,236,  1,131,  2,166,  2,248,  1, 35,
  1,  2,  1,  2,  1, 18,  1, 31,  3, 31,  0, 94,  3,205,  4, 96,
  4,199,  4,137,  0,236,  1,188,  0,186,  1,  2,  3, 51,  3, 31,
  3, 66,  3, 51,  3, 92,  1, 18,  1, 31,  5,213,  1,154,  0,154,
  0,225,  6,102,  1,121,  4, 96,  4, 96,  4, 96,  4,123,  0,  0,
  0,236,  2,195,  2,184,  2,205,  0,190,  0,221,  0,213,  0,  0,
  0,106,  2, 92,  2,123,  2,154,  0,221,  1,174,  1,186,  1, 18,
  0,  0,  0,133,  1,174,  4, 96,  7, 98,  4, 27,  0,154,  6,154,
  4, 88,  0,238,  0,154,  2,154,  0,209,  2,205,  1,154,  1, 80,
  5,203,  5,203,  0,139,  0,139,  6, 49,  0,246,  4,  6,  0,240,
  3, 76,  1, 96,  4,168,  0,193,  0,  0,  0, 37,  5,193,  1,  0,
  1, 33,  7, 74,  6, 18,  0,150,  1, 74,  7,131,  0,168,  0,  0,
  3, 55,  0,123,  0, 20,  0,  0,  0,201,  1,  0,  5,193,  5,193,
  5,193,  5,193,  1,  0,  1,  8,  6, 29,  0,150,  4, 39,  3,158,
  0,236,  1,  2,  2,125,  1, 51,  0,152,  0,209,  3, 88,  1,121,
  0,205,  2, 57,  3, 98,  0,156,  0,156,  0,156,  0,147,  1,184,
  0,147,  0,184,  0,115,  0,  0, 20,  0,  0,  0, 65,132,  2,128,
  1, 38,  0,254,  0,  3,  1, 37,  0, 17,  0,  3,  1, 36,  1, 33,
  0, 58,  0,  5,  1, 36,  0,250,  0,  3,  1, 35,  0, 22,  0,  3,
  1, 34,  1, 33,  0, 58,  0,  5,  1, 34,  0,254,  0,  3,  1, 33,
  0, 58,  0,  3,  1, 32,  0,250,  0,  3,  1, 31,  0,187,  0,  3,
  1, 30,  0,100,  0,  3,  1, 29,  0,254,  0,  3,  1, 28,  0, 25,
  0,  3,  1, 27,  0, 30,  0,  3,  1, 26,  0,254,  0,  3,  1, 25,
  0,254,  0,  3,  1, 24,  0,254,  0,  3,  1, 23,  0,254,  0,  3,
  1, 22,  0,254,  0,  3,  1, 21,  1, 20,  0, 14,  0,  5,  1, 21,
  0,254,  0,  3,  1, 20,  0, 14,  0,  3,  1, 19,  0,254,  0,  3,
  1, 18,  0,254,  0,  3,  1, 15,  1, 14,  0,125,  0,  5,  1, 15,
  0,254,  0,  3,  1, 14,  0,125,  0,  3,  1, 13,  1, 12,  0,140,
  0,  5,  1, 13,  0,254,  0,  3,  1, 13,  0,192,  0,  4,  1, 12,
  1, 11,  0, 89,  0,  5,  1, 12,  0,140,  0,  3,  1, 12,  0,128,
  0,  4,  1, 11,  1, 10,  0, 38,  0,  5,  1, 11,  0, 89,  0,  3,
  1, 11,  0, 64,  0,  4,  1, 10,  0, 38,  0,  3,  1,  9,  0,254,
  0,  3,  1,  8,  0,254,  0,  3,  1,  7,  0, 12,  0,  3,  1,  7,
  0,128,  0,  4,  1,  6,178,151, 46,  5, 65, 19,  1,  6,  0,250,
  0,  3,  1,  5,  0,250,  0,  3,  1,  4,  0,254,  0,  3,  1,  3,
  0, 25,  0,  3,  1,  2,  0,250,  0,  3,  1,  1,  0,250,  0,  3,
  1,  0, 64,255,125,  3,255, 62,  3,254,254,  3,252,251, 44,  5,
252,254,  3,251, 44,  3,250,254,  3,249,248, 71,  5,249,125,  3,
248, 71,  3,247,250,  3,246,254,  3,245,254,  3,244,254,  3,243,
187,  3,242,254,  3,241,254,  3,240,254,  3,239, 30,  3,238,254,
  3,237,236, 10,  5,237,254,  3,236, 10,  3,236, 64,  4,235,234,
 10,  5,235, 50,  3,234, 10,  3,233,250,  3,232,145, 22,  5,232,
254,  3,231,250,  3,230,250,  3,229,145, 22,  5,229,254,  3,228,
254,  3,227,254,  3,226,254,  3,225,254,  3,224,254,  3,223,254,
  3,222,250,  3,221,220, 24,  5,221,100,  3,220, 24,  3,219,160,
 30,  5,219,100,  3,218,217, 37,  5,218,250,  3,217, 37,  3,216,
209, 37,  5,216,250,  3,215,214, 20,  5,215, 22,  3,214,213, 16,
  5,214, 20,  3,213, 16,  3,212,211, 11,  5,212, 32,  3,211, 11,
  3,210,209, 37,  5,210,250,  3,209,145, 22,  5,209, 37,  3,208,
148, 12,  5,208, 35,  3,207,206, 20,  5,207, 38,  3,206,205, 18,
  5,206, 20,  3,205, 18,  3,204,145, 22,  5,204, 29,  3,203, 20,
  3,202,201,187,  5,202,254,  3,201,200, 93,  5,201,187,  3,201,
128,  4,200, 64,255,199, 37,  5,200, 93,  3,200, 64,  4,199, 37,
  3,198,254,  3,197,100,  3,196,144, 16,  5,196,254,  3,195, 28,
  3,194,254,  3,193,254,  3,192,191, 58,  5,192,250,  3,191,173,
 27,  5,191, 58,  3,190,189, 26,  5,190, 50,  3,189,188, 17,  5,
189, 26,  3,188,187, 15,  5,188, 17,  3,187,186, 12,  5,187, 15,
  3,186, 12,  3,185,145, 22,  5,185,254,  3,184,254,  3,183, 21,
  3,182, 18,  3,181,254,  3,180,254,  3,179,254,  3,178, 23,  3,
177, 25,  3,176, 22,  3,175,173, 27,  5,175,250,  3,174,173, 27,
  5,174,250,  3,173,145, 22,  5,173, 27,  3,172,145, 22,  5,172,
125,  3,171,254,  3,170, 38,  3,169,254,  3,168,254,  3,167,254,
  3,166,254,  3,165, 10,  3,164,254,  3,163,162, 14,  5,163,254,
  3,162, 14,  3,162, 64,  4,161,160, 30,  5,161,250,  3,160,145,
 22,  5,160, 30,  3,159,145, 22,  5,159,250,  3,158,148, 12,  5,
158, 28,  3,157,254,  3,156,155,187,  5,156,254,  3,155,154, 93,
  5,155,187,  3,155,128,  4,154,143, 37,  5,154, 93,  3,154, 64,
  4,153,254,  3,152,151, 46,  5,152,254,  3,151, 46,  3,150,145,
 22,  5,150, 30, 64,255,  3,149,148, 12,  5,149, 32,  3,148, 12,
  3,147,145, 22,  5,147, 75,  3,146,145, 22,  5,146,254,  3,145,
144, 16,  5,145, 22,  3,144, 16,  3,143, 37,  3,142,254,  3,141,
254,  3,140,254,  3,139,254,  3,138,254,  3,137,254,  3,136,135,
 37,  5,136,254,  3,135, 37,  3,134,254,  3,133,254,  3,132, 50,
  3,131,150,  3,130,254,  3,129,254,  3,128, 25,  3,127, 10,  3,
126,254,  3,125,254,  3,124,254,  3,123,250,  3,122,250,  3,121,
254,  3,119,118,166,  5,119,254,  3,118,166,  3,117,116, 27,  5,
117,250,  3,116, 27,  3,115,250,  3,114,125,  3,113,254,  3,112,
111, 44,  5,111, 44,  3,110,250,  3,109,250,  3,108,250,  3,107,
254,  3,106,254,  3,105,254,  3,104, 99, 12,  5,104, 50,  3,103,
254,  3,102, 50,  3,101,100, 10,  5,101,254,  3,100, 10,  3,100,
 64,  4, 99, 98, 10,  5, 99, 12,  3, 98, 10,  3, 97, 96, 21,  5,
 97,150,  3, 96,  1, 17,  5, 96, 21,  3, 95, 10,  3, 94,254,  3,
 93,254,  3, 92,  1, 17,  5, 92,254,  3, 91, 90, 27,  5, 91,254,
  3, 90,  1, 17,  5, 90, 27,  3, 89,254,  3, 88,250,  3, 87,254,
  3, 86,  1, 17,  5, 64,255, 86,254,  3, 85,254,  3, 84, 30,  3,
 83, 20,  3, 82, 81, 25,  5, 82,250,  3, 81,  1, 17,  5, 81, 25,
  3, 80, 79, 25,  5, 80,250,  3, 79, 78, 17,  5, 79, 25,  3, 78,
 17,  3, 77, 30,  3, 76, 75, 20,  5, 76, 21,  3, 75, 74, 17,  5,
 75, 20,  3, 74, 73, 14,  5, 74, 17,  3, 73, 14,  3, 72,250,  3,
 71, 70, 20,  5, 71, 21,  3, 70, 20,  3, 69,250,  3, 68, 67, 14,
  5, 68, 15,  3, 67, 14,  3, 66, 65, 37,  5, 66,250,  3, 65,  1,
 17,  5, 65, 37,  3, 64, 63, 15,  5, 64,254,  3, 63, 62, 14,  5,
 63, 15,  3, 62, 14,  3, 61, 60, 13,  5, 61, 22,  3, 60, 13,  3,
 59,100,  3, 58,254,  3, 57, 20,  3, 56,254,  3, 55, 19,  3, 54,
 53, 26,  5, 54, 37,  3, 53, 52, 20,  5, 53, 26,  3, 53,192,  4,
 52, 10, 13,  5, 52, 20,  3, 52,128,  4, 51, 50, 12,  5, 51, 20,
  3, 51, 64,  4, 50, 12,  3, 49, 48,166,  5, 49,254,  3, 48,  1,
 17,  5, 48,166,  3, 47, 12,  3, 46, 19,  3, 45, 44, 58,  5, 45,
250,  3, 44, 21, 37,  5, 44, 58,  3, 43,100,  3, 42,100,  3, 41,
254,  3, 40, 21,  3, 39, 23, 17,  5, 39, 30,  3, 38, 32,  3, 37,
 30,  3, 36, 35, 17,  5, 64, 43, 36, 30,  3, 35, 17,  3, 34,  0,
 13,  5, 34,250,  3, 33, 15,  3, 33, 64,  4, 32, 20,  3, 31, 10,
  3, 30, 30,  3, 29, 28, 25,  5, 29, 37,  3, 28, 15, 19,  5, 28,
 25,  3, 28,184,  1,  0, 64,145,  4, 27, 13,  3, 26, 25, 75,  5,
 26,125,  3, 25,  1, 17,  5, 25, 75,  3, 24,254,  3, 23, 17,  3,
 22, 21, 37,  5, 22,250,  3, 21,  1, 17,  5, 21, 37,  3, 20,100,
  3, 19, 17,  3, 18,254,  3, 17,  1, 17,  5, 17,254,  3, 16,100,
  3, 15, 14, 16,  5, 15, 19,  3, 15,192,  4, 14, 16,  3, 14,128,
  4, 13,  1, 17,  5, 13,250,  3, 12, 50,  3, 11, 10, 13,  5, 11,
 22,  3, 11,128,  4, 10, 13,  3, 10, 64,  4,  9,254,  3,  8,254,
  3,  7,254,  3,  6,  5, 10,  5,  6,254,  3,  5, 10,  3,  5, 64,
  4,  4,250,  3,  3,100,  3,  2,  1, 17,  5,  2,254,  3,  1,  0,
 13,  5,  1, 17,  3,  0, 13,  3,  1,184,  1,100,133,141,  1, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43,  0, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
 43, 43, 29,  0,182,  6,  5,  4,  3,  2,  1,  0, 44, 32, 16,176,
  2, 37, 73,100,176, 64, 81, 88, 32,200, 89, 33, 45, 44,176,  2,
 37, 73,100,176, 64, 81, 88, 32,200, 89, 33, 45, 44, 32, 16,  7,
 32,176,  0, 80,176, 13,121, 32,184,255,255, 80, 88,  4, 27,  5,
 89,176,  5, 28,176,  3, 37,  8,176,  4, 37, 35,225, 32,176,  0,
 80,176, 13,121, 32,184,255,255, 80, 88,  4, 27,  5, 89,176,  5,
 28,176,  3, 37,  8,225, 45, 44, 75, 80, 88, 32,184,  1, 40, 69,
 68, 89, 33, 45, 44,176,  2, 37, 69, 96, 68, 45, 44, 75, 83, 88,
176,  2, 37,176,  2, 37, 69, 68, 89, 33, 33, 45, 44, 69, 68, 45,
  0,  2,  0,102,254,150,  4,102,  5,164,  0,  3,  0,  7,  0, 31,
188,  0,  4,  1, 38,  0,  0,  0,  6,  1, 38,182,  1,  8,  5,137,
  2,  4,  0, 47,196,212,236, 49,  0, 16,212,236,212,236, 48, 19,
 17, 33, 17, 37, 33, 17, 33,102,  4,  0,252,115,  3, 27,252,229,
254,150,  7, 14,248,242,114,  6, 41,  0,  0,  2,  1, 31,  0,  0,
  2,135,  5,213,  0,  5,  0,  9,  0, 31, 64, 15,  3,140,  6,139,
  0,141,  8,  4,  3,  7,  1,  2,  6,  0, 10, 16,212, 60,236, 50,
 57, 57, 49,  0, 47,228,252,236, 48,  1, 33, 17,  3, 33,  3, 17,
 33, 17, 33,  1, 31,  1,104, 51,254,254, 51,  1,104,254,152,  5,
213,253,195,254, 94,  1,162,253,204,254,156,  0,  0,  2,  0,195,
  3,170,  3,104,  5,213,  0,  3,  0,  7,  0, 30, 64, 15,  5,  1,
142,  4,  0,141,  8,  0,  4,  2,  4,  4,  6,  3,  8, 16,252,252,
220,236, 49,  0, 16,244, 60,236, 50, 48,  1, 17, 35, 17, 35, 17,
 35, 17,  3,104,237,203,237,  5,213,253,213,  2, 43,253,213,  2,
 43,  0,  0,  2,  0,139,  0,  0,  6, 41,  5,190,  0, 27,  0, 31,
  0, 75, 64, 49, 25,  5,  1,146, 28, 23,  7, 19, 15, 11,146, 30,
 21,  9,  3,  0,143, 17, 13, 31, 30, 29, 28, 27, 26, 24, 23, 22,
 19, 18, 17, 16, 15, 14, 13, 12, 10,  9,  8,  5,  4,  3,  2,  1,
  0, 26,  6, 20, 32, 16,212,204, 23, 57, 49,  0, 47, 60,228, 50,
212, 60, 60,236, 50, 50,212, 60, 60,236, 50, 50, 48,  1,  3, 33,
 19, 51,  3, 33, 21, 33,  3, 33, 21, 33,  3, 35, 19, 33,  3, 35,
 19, 33, 53, 33, 19, 33, 53, 33, 19,  1, 33,  3, 33,  3,143, 96,
  1,  8, 97,221, 97,  1, 21,254,182, 69,  1, 28,254,176, 96,221,
 96,254,248, 96,223, 96,254,233,  1, 72, 70,254,229,  1, 82, 96,
  1, 80,254,248, 70,  1,  8,  5,190,254,127,  1,129,254,127,213,
254,238,215,254,129,  1,127,254,129,  1,127,215,  1, 18,213,  1,
129,253,170,254,238,  0,  0,  3,  0,160,254,211,  5,  6,  6, 20,
  0, 35,  0, 42,  0, 49,  0,115, 64, 63, 28, 10,  6, 37, 27, 24,
 17, 23, 20, 36, 11, 29, 43,  4, 24,  6,  9, 44, 35,  2,  5,150,
  6,149, 44, 23,150, 24,149, 27,147, 18, 20, 44,147,  0,  2, 11,
 40,  1, 29, 47,  0,  5, 14,  6, 40, 36, 17,  9,  3,  1,  7, 43,
 27, 19,  3,  0, 47,  6, 23, 32, 50, 16,212,196,252,212, 23, 60,
252, 23, 60,212,252,196, 17, 18, 57, 17, 18, 57, 49,  0, 47,196,
236,212,196,252,244,236, 16,245,238, 17, 57, 17, 57, 17, 18, 23,
 57, 17, 18, 57, 17, 18, 57, 18, 57, 57, 48,  1, 35,  3, 38, 38,
 39, 17, 22, 22, 23, 17, 39, 38, 38, 53, 52, 54, 55, 55, 51, 21,
 22, 22, 23, 21, 38, 38, 39, 17, 23, 22, 22, 21, 20,  6,  7,  3,
 17,  6,  6, 21, 20, 22, 19, 17, 54, 54, 53, 52, 38,  3, 27,162,
  1,125,234,111,115,235,121, 33,239,201,245,227,  1,162,100,200,
101,100,200,101, 32,254,205,244,247,162, 71, 85, 78,240, 87, 87,
 80,254,211,  1, 45,  5, 46, 41,  1,  6, 59, 63,  4,  1, 55,  6,
 42,180,169,179,201,  9,231,227,  8, 34, 27,254, 42, 47,  5,254,
225,  6, 40,187,183,184,197, 14,  3, 66,  1,  5,  4, 69, 53, 59,
 67,254,177,254,234,  1, 66, 66, 68, 67,  0,  5,  0, 66,255,227,
  7,195,  5,240,  0, 11,  0, 23,  0, 27,  0, 39,  0, 51,  0, 99,
 64, 53, 27, 11, 26, 26, 25, 25, 11, 24, 24, 27, 37,  0,157, 12,
 46,157, 34,153, 40,157, 26,  6,157, 12,153, 24, 18,152, 28, 26,
156, 52, 25, 49, 43, 27,  9,  3,  8, 21,  9,  9,  8, 15, 49,  8,
 31,  9, 43,  8, 15, 37, 52, 16,220,196,236,244,236, 16,238,246,
238, 17, 57, 17, 18, 57, 49,  0, 16,228, 50,244, 60,228,236, 16,
238,246,238, 16,238, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,
237, 89, 34,  1, 34,  6, 21, 20, 22, 51, 50, 54, 53, 52, 38, 39,
 50, 22, 21, 20,  6, 35, 34, 38, 53, 52, 54,  1, 35,  1, 51, 33,
 50, 22, 21, 20,  6, 35, 34, 38, 53, 52, 54, 23, 34,  6, 21, 20,
 22, 51, 50, 54, 53, 52, 38,  6, 51, 71, 78, 77, 72, 72, 76, 77,
 71,186,214,214,186,186,215,215,253, 37,221,  3,165,222,251,141,
186,213,213,186,186,213,213,186, 72, 78, 78, 72, 72, 77, 78,  2,
104,123,114,115,123,123,115,114,123,168,216,189,189,219,219,189,
188,217,252,211,  6, 13,217,189,189,218,218,189,189,217,168,124,
114,115,125,125,115,114,124,  0,  0,  2,  0,123,255,227,  6,164,
  5,240,  0, 38,  0, 48,  1, 54, 64, 89, 12,  1, 13, 11, 15,  9,
  8, 10, 15,  8,  9,  8, 44, 45, 46, 47,  4, 43, 48, 15,  1,  1,
  0, 40,  1, 41, 39, 15,  0,  1,  0, 37, 48, 39,  8,  1,  4,  4,
 11, 45,  9, 20,  0,  4, 30,145, 29, 45,161, 14, 33,159, 29,158,
 26,156, 14,152,  4,  9, 39, 42,  0, 36,  1, 29,  8,  5,  4, 11,
 48, 36, 29, 20, 42, 36, 13, 29, 23,  4,  1,  5,  9, 23, 42, 13,
 17, 12, 49, 16,252,236,196,212,212,236, 16,198,238, 18, 57, 17,
 18, 57, 57, 17, 18, 57, 18, 57, 17, 57, 18, 57, 49,  0, 47,198,
228,246,230,238, 16,238, 16,238, 17, 57, 57, 17, 18, 57, 17, 23,
 57, 48, 75, 83, 88,  7, 16, 14,237, 17, 23, 57,  7, 16, 14,237,
 17, 23, 57,  7, 16,  5,237,  7,  5,237, 17, 23, 57, 89, 34,178,
  8, 39,  1,  0, 93, 64,132,  6,  0, 15,  3, 15,  4,  9,  9, 15,
 10, 14, 11,  9, 39, 11, 48, 22,  0, 31,  3, 31,  4, 25,  9, 29,
 10, 29, 11, 28, 48, 37,  0, 47, 10, 47, 11, 37, 38, 63, 10, 63,
 11, 64,  7, 75, 10, 75, 11, 75, 47, 75, 48, 90,  1, 90,  2, 85,
  7, 90, 10, 90, 11, 85, 40, 92, 46, 92, 48, 88, 50, 95, 50,100,
  0,105,  2,103,  7, 96,  7,105, 10,105, 11,100, 38,128, 50, 44,
  9, 11, 10, 39, 25, 11, 26, 39, 42, 11, 57, 11, 53, 28, 48, 29,
 48, 30, 53, 31, 64,  2, 74, 11, 73, 39, 73, 40, 87,  1, 87,  2,
 92, 11, 91, 39,103,  2,103,  7,108, 11, 21, 93,  1, 93,  9,  1,
 62,  1, 55, 33,  6,  2,  7,  1, 33, 39, 14,  1, 35, 32,  0, 53,
 52, 54, 55, 46,  1, 53, 52, 54, 51, 50, 22, 23, 17, 46,  1, 35,
 34,  6, 21, 20, 22,  3, 14,  1, 21, 20, 22, 51, 50, 54, 55,  3,
 31,  1,153, 53, 55,  5,  1, 55, 15,111, 99,  1, 37,254, 88, 98,
105,232,130,254,249,254,187,143,162, 42, 40,254,211, 91,197,107,
 94,168, 80, 77, 85, 49,151, 65, 66,170,119, 67,116, 50,  3,223,
254, 62, 70,174,110,182,254,228,107,254,190,109, 70, 68,  1, 21,
219,146,225,106, 53,106, 58,163,196, 29, 29,254,234, 48, 46, 59,
 54, 34, 87,254,211, 47,119, 71,115,162, 41, 41,  0,  1,  0,195,
  3,170,  1,176,  5,213,  0,  3,  0, 21, 64, 10,  1,142,  0,141,
  4,  0,  4,  2,  3,  4, 16,252,236, 49,  0, 16,244,236, 48,  1,
 17, 35, 17,  1,176,237,  5,213,253,213,  2, 43,  0,  1,  0,176,
254,242,  3,  4,  6, 18,  0, 13,  0, 31, 64, 15,  0,164,  7,163,
 14,  7,  1,  4,  8,  0, 11, 17,  4, 16, 14, 16,252,252,196, 50,
 18, 57, 57, 49,  0, 16,252,236, 48,  1, 33, 38,  2, 53, 52, 18,
 55, 33,  6,  2, 21, 20, 18,  3,  4,254,215,153,146,147,152,  1,
 41,128,128,127,254,242,247,  1,189,219,219,  1,193,245,237,254,
 59,221,221,254, 58,  0,  0,  1,  0,164,254,242,  2,248,  6, 18,
  0, 13,  0, 28, 64, 13,  0,164,  6,163, 14, 13,  7, 10, 17,  6,
  0,  3, 14, 16,212,196, 50,236, 57, 57, 49,  0, 16,252,236, 48,
 19, 54, 18, 53, 52,  2, 39, 33, 22, 18, 21, 20,  2,  7,164,128,
128,128,128,  1, 41,152,147,146,153,254,242,238,  1,198,221,221,
  1,197,237,245,254, 63,219,219,254, 67,247,  0,  0,  1,  0, 41,
  2, 57,  4,  6,  5,240,  0, 17,  0, 70, 64, 40, 16, 13, 11, 10,
  9,  7,  4,  2,  1,  0, 10, 12,  8,  3,  5,165, 17, 12, 14,156,
 18,  8, 12, 10,  3,  9,  6, 17,  3,  1,  3,  2,  0, 15,  4, 11,
  9, 13,  6, 18, 16,212, 60,196, 50,220, 60,196, 50, 23, 57, 17,
 18, 23, 57, 49,  0, 16,244,196, 50,244,196, 50, 17, 23, 57, 48,
  1,  5,  5,  7, 37, 17, 35, 17,  5, 39, 37, 37, 55,  5, 17, 51,
 17, 37,  4,  6,254,182,  1, 74, 76,254,179,170,254,178, 76,  1,
 78,254,178, 76,  1, 78,170,  1, 77,  4,193,173,174,141,184,254,
168,  1, 88,184,141,174,173,141,182,  1, 88,254,168,182,  0,  1,
  0,217,  0,  0,  5,219,  5,  4,  0, 11,  0, 34, 64, 16,  0,  7,
  3,167,  9,  1,166,  5,  8,  4,  0, 18,  2, 10,  6, 12, 16,212,
 60,196,252, 60,196, 49,  0, 47,244, 60,252, 60,196, 48,  1, 17,
 33, 21, 33, 17, 35, 17, 33, 53, 33, 17,  3,209,  2, 10,253,246,
238,253,246,  2, 10,  5,  4,253,244,236,253,244,  2, 12,236,  2,
 12,  0,  0,  1,  0,109,254,221,  2, 57,  1,131,  0,  5,  0, 25,
 64, 12,  3,169,  0,168,  6,  3,  4,  1,  2,  0, 19,  6, 16,252,
236,212,204, 49,  0, 16,252,236, 48, 19, 33, 17,  3, 35, 19,209,
  1,104,247,213,100,  1,131,254,207,254,139,  1,117,  0,  0,  1,
  0,111,  1,188,  2,227,  2,223,  0,  3,  0, 18,183,  2,171,  0,
170,  4,  1,  0,  4, 16,212,196, 49,  0, 16,244,236, 48, 19, 33,
 17, 33,111,  2,116,253,140,  2,223,254,221,  0,  0,  1,  0,209,
  0,  0,  2, 57,  1,131,  0,  3,  0, 17,183,  0,168,  2,  1,  2,
  0, 19,  4, 16,252,236, 49,  0, 47,236, 48, 19, 33, 17, 33,209,
  1,104,254,152,  1,131,254,125,  0,  1,  0,  0,255, 66,  2,236,
  5,213,  0,  3,  0, 19,183,  2,  0,141,  4,  2,  0,  1,  3, 47,
196, 57, 57, 49,  0, 16,244,204, 48,  1, 51,  1, 35,  2, 14,222,
253,241,221,  5,213,249,109,  0,  0,  2,  0, 98,255,227,  5, 47,
  5,240,  0, 11,  0, 23,  0, 35, 64, 19,  9,172, 15,  3,172, 21,
156, 15,152, 24,  0, 22, 12, 23,  6, 22, 18, 20, 24, 16,252,236,
252,236, 49,  0, 16,228,244,236, 16,238, 48,  1, 16, 38, 35, 34,
  6, 17, 16, 22, 51, 50, 54,  1, 16,  0, 33, 32,  0, 17, 16,  0,
 33, 32,  0,  3,174,105,124,124,106,106,124,123,106,  1,129,254,
192,254,218,254,217,254,192,  1, 64,  1, 39,  1, 38,  1, 64,  2,
236,  1, 24,229,229,254,232,254,229,232,232,  1, 24,254,141,254,
109,  1,147,  1,115,  1,116,  1,147,254,109,  0,  0,  1,  0,231,
  0,  0,  5,  4,  5,213,  0, 10,  0, 40, 64, 21,  3,174,  4,  2,
174,  5,141,  7,  0,174,  9,  8, 24,  6, 26,  3,  0, 24,  5,  1,
 11, 16,212,196,236,196,252,236, 49,  0, 47,236, 50,244,236,212,
236, 48, 19, 33, 17,  5, 17, 37, 33, 17, 33, 17, 33,240,  1, 84,
254,163,  1, 91,  1,110,  1, 84,251,236,  1, 10,  3,197, 72,  1,
  6, 72,251, 53,254,246,  0,  1,  0,162,  0,  0,  4,223,  5,240,
  0, 24,  0,150, 64, 41,  0, 29,  4,  5,  4, 23,  1, 22, 24, 29,
  5,  5,  4, 37,  5, 24,  0, 14,144, 15, 11,172, 18,156,  4,  0,
175,  2, 24, 21,  5,  0, 14,  8, 22, 21,  1, 27, 14,  3, 25, 16,
220,196,252,212,236, 17, 57, 57, 17, 57, 49,  0, 47,236, 50,244,
236,212,236, 17, 57, 57, 48, 75, 83, 88,  7, 16, 14,237, 17, 23,
 57,  7, 16,  5,237, 89, 34,  1, 75,176, 13, 84, 88,189,  0, 25,
  0, 64,  0,  1,  0, 25,  0, 25,255,192, 56, 17, 55, 56, 89, 64,
 38,  2, 23, 42, 22, 42, 23,  3,  3,  0, 14, 23,  5, 24, 23, 23,
 23, 24, 34,  0, 34, 23, 34, 24, 53,  0, 53, 23, 53, 24, 66,  0,
 74,  5, 70, 23, 70, 24, 15, 93,  0, 93,  1, 33, 17, 33, 17,  1,
 62,  1, 53, 52, 38, 35, 34,  6,  7, 17, 62,  1, 51, 32,  4, 21,
 20,  6,  7,  2, 78,  2,145,251,195,  2, 33, 73, 70,141,117, 90,
214,122,130,254,122,  1, 12,  1, 41,126,202,  1, 27,254,229,  1,
 27,  1,225, 66,126, 68,105,128, 77, 76,  1, 72, 43, 45,236,211,
122,211,177,  0,  0,  1,  0,137,255,227,  4,238,  5,240,  0, 40,
  0, 76, 64, 43,  0, 21,172, 19,  9,150, 10,177, 13,172,  6, 32,
150, 31,177, 28,172, 19,176, 35,156,  6,152, 41, 22, 19, 25, 20,
  0, 16, 25, 22, 38, 16, 22,  3, 31, 20, 31, 32,  9, 30, 41, 16,
252,228,196,252,236,212,236, 18, 57, 17, 18, 57, 57, 49,  0, 16,
228,244,228,252,244,236, 16,254,245,238, 16,238, 57, 48,  1, 22,
 22, 21, 20,  4, 33, 34, 38, 39, 17, 22, 22, 51, 50, 54, 53, 52,
 38, 35, 35, 53, 51, 50, 54, 53, 52, 38, 35, 34,  6,  7, 17, 54,
 54, 51, 32,  4, 21, 20,  6,  3,186,151,157,254,172,254,186,115,
231,113,108,213,103,153,163,167,163,154,162,145,142,138,126, 93,
190, 94,114,224,108,  1, 35,  1, 33,138,  3, 37, 39,193,149,222,
231, 37, 37,  1, 41, 54, 55,106, 99,102,105,248, 91, 93, 86, 94,
 42, 41,  1, 26, 32, 32,191,192,131,167,  0,  2,  0, 92,  0,  0,
  5, 51,  5,213,  0,  2,  0, 13,  0, 67, 64, 32,  1, 33, 13,  3,
 13,  0, 33,  3,  3, 13, 37,  0,  3, 11,  7,174,  5,  1,  3,141,
  9,  1, 12, 10,  0, 26,  6,  8,  4, 12, 20, 14, 16,252,212, 60,
196,236, 50, 17, 57, 49,  0, 47,228,212, 60,236, 50, 18, 57, 48,
 75, 83, 88,  7, 16,  4,237,  7, 16,  5,237, 89, 34,  1,  1, 33,
  3, 33, 17, 51, 17, 35, 17, 33, 17, 33, 17,  2,242,254, 90,  1,
166, 64,  1,172,213,213,254,148,253,106,  4,152,253,143,  3,174,
252, 82,254,233,254,240,  1, 16,  1, 74,  0,  1,  0,158,255,227,
  5,  2,  5,213,  0, 29,  0, 61, 64, 34,  4,  7, 29,149, 26,172,
  7, 16,150, 17,149, 20,172,  7,178, 13,  2,175,  0,141, 13,152,
 30,  3, 34,  0,  1, 23, 22, 10, 31,  0, 16, 30, 16,220,196,252,
236,196, 16,238, 49,  0, 16,228,244,236, 16,230,254,245,238, 16,
254,228, 18, 57, 48, 19, 33, 17, 33, 21, 54, 54, 51, 32,  0, 21,
 20,  0, 33, 34, 38, 39, 17, 22, 22, 51, 50, 54, 53, 52, 38, 35,
 34,  6,  7,217,  3,189,253,118, 44, 89, 48,  1, 17,  1, 48,254,
181,254,218,127,249,123,122,219, 97,140,161,161,140, 83,188,108,
  5,213,254,229,231, 12, 13,254,239,244,242,254,238, 49, 50,  1,
 47, 70, 70,137,117,118,136, 43, 45,  0,  0,  2,  0,127,255,227,
  5, 35,  5,238,  0, 11,  0, 36,  0, 55, 64, 31, 19,  0,172, 22,
  6,172, 28, 12,150, 13,149, 16,172, 34,156, 28,152, 37, 12,  9,
 26, 25,  3, 37, 19, 26, 25, 23, 31, 36, 37, 16,252,236,252,228,
 16,238,196, 49,  0, 16,228,244,252,244,236, 16,238,214,238, 57,
 48,  1, 34,  6, 21, 20, 22, 51, 50, 54, 53, 52, 38,  1, 17, 38,
 38, 35, 34,  6,  7, 54, 54, 51, 50,  0, 21, 20,  0, 33, 32,  0,
 17, 16,  0, 33, 50, 22,  2,229,101,101,101,101,102,101,101,  1,
118, 95,168, 80,172,192, 16, 66,154, 91,229,  1, 25,254,198,254,
248,254,221,254,193,  1,117,  1, 69,103,194,  2,225,131,131,131,
131,131,131,131,131,  2,205,254,236, 45, 43,191,188, 49, 49,254,
244,217,240,254,223,  1,137,  1,105,  1,114,  1,167, 32,  0,  1,
  0,137,  0,  0,  4,238,  5,213,  0,  6,  0, 69, 64, 23,  5, 25,
  2,  3,  2,  4, 25,  3,  3,  2, 37,  5,175,  0,141,  3,  5,  4,
  3,  3,  1,  0,  7, 16,220,204, 23, 57, 49,  0, 47,244,236, 48,
 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237, 89, 34,178,  7,  3,
  1,  1, 93, 64, 11,  7,  3, 26,  5, 38,  3, 53,  3, 70,  3,  5,
 93, 19, 33, 21,  1, 33,  1, 33,137,  4,101,253,186,254,137,  2,
 39,253, 49,  5,213,217,251,  4,  4,186,  0,  3,  0,125,255,227,
  5, 18,  5,240,  0, 11,  0, 35,  0, 47,  0, 71, 64, 40, 24, 12,
 39,172,  0,  6,172, 30,  0,176, 45,172, 18,156, 30,152, 48, 24,
 21,  9, 12,  3, 36, 26, 15, 42, 26, 21, 38,  9, 26, 27, 39,  3,
 26, 15, 38, 33, 36, 48, 16,252,228,236,252,236,244,236, 16,238,
 18, 57, 17, 18, 57, 49,  0, 16,228,244,236,228, 16,238, 16,238,
 57, 57, 48,  1, 34,  6, 21, 20, 22, 51, 50, 54, 53, 52, 38, 37,
 38, 38, 53, 52, 36, 33, 32,  4, 21, 20,  6,  7, 22, 22, 21, 20,
  4, 33, 32, 36, 53, 52, 54, 19, 20, 22, 51, 50, 54, 53, 52, 38,
 35, 34,  6,  2,201,108,116,116,108,107,114,114,254,124,136,138,
  1, 26,  1, 17,  1, 15,  1, 26,139,136,152,155,254,217,254,222,
254,221,254,215,155,242, 99, 92, 90, 98, 98, 90, 92, 99,  2,156,
118,110,110,117,117,110,111,117,127, 41,170,127,189,198,197,190,
127,170, 41, 42,189,144,222,227,227,222,144,189,  1, 85, 89, 96,
 96, 89, 89, 95, 96,  0,  0,  2,  0,106,255,227,  5, 14,  5,238,
  0, 24,  0, 36,  0, 55, 64, 31,  7, 25,172, 10,  0,150,  1,149,
  4,172, 22, 10, 31,172, 16,156, 22,152, 37, 28, 37,  7, 26, 19,
 23,  0, 34, 26, 13, 36, 37, 16,252,236,196,252,252,228, 49,  0,
 16,228,244,236,196, 16,254,245,238, 16,238, 57, 48, 55, 17, 22,
 22, 51, 50, 54, 55,  6,  6, 35, 34,  0, 53, 52,  0, 33, 32,  0,
 17, 16,  0, 33, 34, 38,  1, 50, 54, 53, 52, 38, 35, 34,  6, 21,
 20, 22,205, 92,168, 82,172,192, 17, 68,154, 90,229,254,231,  1,
 57,  1,  7,  1, 36,  1, 64,254,138,254,186,105,192,  1,127,101,
102,102,101,101,102,102, 33,  1, 20, 43, 43,191,188, 50, 50,  1,
 11,218,241,  1, 34,254,118,254,152,254,142,254, 89, 31,  2,238,
131,131,130,132,132,130,131,131,  0,  2,  0,229,  0,  0,  2, 78,
  4, 96,  0,  3,  0,  7,  0, 28, 64, 14,  2,168,  0,179,  4,168,
  6,  5,  1,  2,  4,  0, 19,  8, 16,252, 60,236, 50, 49,  0, 47,
236,244,236, 48, 19, 33, 17, 33, 17, 33, 17, 33,229,  1,105,254,
151,  1,105,254,151,  4, 96,254,125,254,166,254,125,  0,  0,  2,
  0,129,254,221,  2, 78,  4, 96,  0,  5,  0,  9,  0, 37, 64, 19,
  8,168,  6,  3,169,  0,168,  6,179, 10,  3,  4,  7,  1,  2,  6,
  0, 19, 10, 16,252, 60,236, 50,212,196, 49,  0, 16,228,252,236,
 16,238, 48, 19, 33, 17,  3, 35, 19, 17, 33, 17, 33,229,  1,105,
248,213,100,  1,105,254,151,  1,131,254,207,254,139,  1,117,  4,
 14,254,125,  0,  0,  1,  0,217,  0, 61,  5,219,  4,199,  0,  6,
  0, 31, 64, 16,  5,  4,  2,  1,  0,  5,  3,181,  6,180,  7,  1,
  2,  0,  4,  7, 16,212,196, 50, 57, 49,  0, 16,244,236, 23, 57,
 48,  9,  2, 21,  1, 53,  1,  5,219,252, 60,  3,196,250,254,  5,
  2,  3,205,254,180,254,182,250,  1,207,236,  1,207,  0,  0,  2,
  0,217,  1, 39,  5,219,  3,219,  0,  3,  0,  7,  0, 28, 64, 13,
  0,167,  2,182,  6,167,  4,  8,  5,  1,  4,  0,  8, 16,212, 60,
196, 50, 49,  0, 16,212,236,252,236, 48, 19, 33, 21, 33, 21, 33,
 21, 33,217,  5,  2,250,254,  5,  2,250,254,  3,219,235,220,237,
  0,  1,  0,217,  0, 61,  5,219,  4,199,  0,  6,  0, 31, 64, 16,
  6,  5,  3,  2,  0,  5,  4,181,  1,180,  7,  6,  2,  4,  0,  7,
 16,212, 60,196, 57, 49,  0, 16,244,236, 23, 57, 48, 19, 53,  1,
 21,  1, 53,  1,217,  5,  2,250,254,  3,197,  3,205,250,254, 49,
236,254, 49,250,  1, 74,  0,  2,  0,141,  0,  0,  4, 31,  5,240,
  0, 29,  0, 33,  0, 72, 64, 39, 29, 26,  5,  2,  4,  6, 25, 15,
  0,140, 30, 16,145, 15,149, 12,161, 19,141, 30,139, 32,  6,  5,
  9,  1, 26, 25,  0,  9,  2, 22, 15, 31,  0,  2, 30,  1, 34, 16,
212, 60,236, 50,212,212,236, 18, 57, 57, 17, 18, 57, 57, 49,  0,
 47,236,244,252,244,236, 16,237, 17, 57, 57, 23, 57, 48,  1, 33,
 53, 52, 54, 55, 55, 54, 54, 53, 52, 38, 35, 34,  6,  7, 17, 54,
 54, 51, 50,  4, 21, 20,  6,  7,  7,  6,  6, 21,  5, 33, 17, 33,
  2,197,254,151, 66,106, 64, 57, 53, 96, 86, 81,188,102,121,200,
 93,244,  1,  0, 78, 94, 64, 68, 42,254,151,  1,105,254,151,  1,
248, 49, 82,127, 98, 58, 52, 92, 46, 70, 79, 67, 66,  1, 58, 42,
 40,199,191, 98,155, 89, 57, 62, 75, 45,193,254,156,  0,  0,  2,
  0,135,254,156,  7,111,  5,160,  0, 11,  0, 77,  0,108, 64, 58,
 12, 15,  3, 52, 48, 76, 77, 51, 15, 24, 25,  9, 27,  3,184, 15,
 51, 48,  9,184, 25, 21, 48,184, 15,183, 55, 36,184, 21,183, 67,
143, 78, 51, 52, 76, 26,  6, 24, 12, 42, 26,  0, 42, 18, 30, 41,
 26, 40, 73, 18, 40, 42, 41, 52, 61, 78, 16,212,196,236,236,212,
236,236, 16,238, 16,254, 60,198, 18, 57, 17, 57, 49,  0, 16,244,
236,236,212,236,236, 16,196,238, 16,196, 16,238, 50, 17, 18, 57,
 17, 18, 57, 57, 17, 57, 17, 18, 57, 48,  1, 20, 22, 51, 50, 54,
 53, 52, 38, 35, 34,  6,  1,  6,  6, 35, 34, 38, 53, 52, 54, 51,
 50, 22, 23, 53, 51, 17, 54, 54, 53, 52, 38, 39, 38, 36, 35, 34,
  6,  7,  6,  2, 21, 20, 18, 23, 22,  4, 51, 50, 54, 55, 23,  6,
  4, 35, 34, 36, 39, 38,  2, 53, 52, 18, 55, 54, 36, 51, 50,  4,
 23, 22, 22, 21, 16,  0, 33, 35,  3, 63,105, 90, 89,106,107, 90,
 88,105,  1,154, 30,133, 89,172,215,216,171, 89,133, 30,209,124,
142, 58, 59, 95,254,227,166,116,212, 90,148,165,107,101,100,  1,
  3,147,126,252, 89,107,125,254,217,152,185,254,184,128,128,134,
136,126,126,  1, 79,180,224,  1,110,123, 75, 77,254,186,254,215,
 39,  2, 27,123,142,143,122,121,141,141,254, 90, 71, 79,249,200,
200,250, 80, 71,131,253, 75, 19,201,157,100,175, 73,122,132, 61,
 59, 98,254,201,181,149,254,251,100, 98,103, 94, 80,162, 97,103,
131,125,125,  1, 73,189,182,  1, 74,125,124,136,171,161, 98,229,
126,254,241,254,212,  0,  0,  2,  0, 10,  0,  0,  6, 39,  5,213,
  0,  7,  0, 10,  1, 16, 64, 64,  0, 29,  6,  5,  7, 29,  6,  6,
  5, 10, 29,  8, 10,  5,  6,  5,  9, 29,  6,  6,  5,  2, 29,  4,
  3,  1, 29,  4,  3,  8, 29,  3,  4,  3, 10, 29,  9, 10,  4,  4,
  3, 37, 10,  4,  0,174,  8,  4,141,  6,  2, 10,  9,  8,  7,  5,
  4,  2,  1,  0,  9,  6,  3, 11, 16,212,196, 23, 57, 49,  0, 47,
 60,228,212,236, 18, 57, 48, 75, 83, 88,  7, 16,  8,237,  7, 16,
  5,237,  7,  5,237,  7,  5,237,  7, 16,  5,237,  7, 16,  8,237,
  7, 16,  5,237,  7,  5,237, 89, 34,  1, 75,176, 10, 84, 88,189,
  0, 11,255,192,  0,  1,  0, 11,  0, 11,  0, 64, 56, 17, 55, 56,
 89, 64,128, 24, 10, 47, 10, 86, 10,102, 10,127,  0,127,  1,127,
  8,127,  9,116, 10,138, 10,159, 10,191, 10,191, 10,207, 10,207,
 10,223, 10, 16, 18,  8, 28,  9, 31, 12, 37,  8, 42,  9, 32, 12,
 73,  4, 70,  5, 71,  8, 72,  9, 88,  3, 89,  4, 86,  5, 87,  6,
104,  3,105,  4,102,  5,103,  6, 96, 12,116,  0,123,  1,122,  4,
117,  5,123,  8,116,  9,137,  4,134,  5,134,  8,137,  9,153,  4,
150,  5,149,  8,154,  9,182,  8,185,  9,203,  0,197,  1,197,  2,
203,  7,194,  8,205,  9,217,  0,214,  1,214,  2,217,  7,213,  8,
218,  9, 47, 93,  0, 93,  1, 33,  3, 33,  1, 33,  1, 33,  1, 33,
  3,  4, 70,253,166, 95,254,125,  2, 41,  1,203,  2, 41,254,125,
253,168,  1,153,204,  1, 16,254,240,  5,213,250, 43,  2, 37,  2,
 82,  0,  0,  3,  0,188,  0,  0,  5,137,  5,213,  0,  8,  0, 17,
  0, 32,  0, 80, 64, 37, 18,  0,185, 15,190,  6,185, 26,141,  9,
185, 24,  6,  0,  7,  3, 18, 30, 12, 15,  9, 24, 27,  4,  7,  3,
 22, 30, 12, 22, 21, 16,  7, 22, 25,  3, 33, 16,252,236, 50,212,
236,212,236, 17, 23, 57, 17, 18, 57, 17, 18, 57, 57, 49,  0, 47,
236,244,236,244,236, 57, 48, 64,  9,  0, 34, 16, 34, 47, 34, 80,
 34,  4,  1, 93,  1, 50, 54, 53, 52, 38, 43,  1, 17, 19, 50, 54,
 53, 52, 38, 43,  1, 17,  1, 30,  1, 21, 20,  4, 41,  1, 17, 33,
 32,  4, 21, 20,  6,  3, 18, 91, 94, 94, 91,213,226,116,117,116,
117,226,  2, 72,124,136,254,220,254,214,253,129,  2, 66,  1, 55,
  1, 23,102,  3,147, 80, 78, 77, 81,254,196,253,115, 98, 99, 97,
 97,254,121,  2, 25, 36,194,141,216,212,  5,213,188,207,109,153,
  0,  1,  0,102,255,227,  5, 92,  5,240,  0, 25,  0, 59, 64, 26,
 12, 16,  9,  0, 22,  3, 13, 16, 25, 22,174,  3, 16,174,  9,156,
  3,152, 26, 19, 45, 12,  0,  6, 43, 26, 16,252,196, 50,236, 49,
  0, 16,228,244,236, 16,254,196, 16,197, 17, 18, 57, 17, 18, 57,
 48,180, 47, 27, 95, 27,  2,  1, 93, 37, 14,  1, 35, 32,  0, 17,
 16,  0, 33, 50, 22, 23, 17, 46,  1, 35, 34,  2, 21, 20, 18, 51,
 50, 54, 55,  5, 92,106,230,125,254,139,254, 76,  1,180,  1,117,
125,230,106,107,208,115,206,236,236,206,115,208,107, 82, 55, 56,
  1,161,  1,101,  1,102,  1,161, 56, 55,254,203, 73, 68,254,248,
232,231,254,248, 68, 73,  0,  2,  0,188,  0,  0,  6, 57,  5,213,
  0,  8,  0, 23,  0, 46, 64, 21,  0,192,  9,141,  1,192, 22,  8,
  2, 22, 10,  0,  5, 45, 16, 46,  0, 22,  9,  3, 24, 16,252,236,
252,236, 17, 57, 57, 57, 57, 49,  0, 47,236,244,236, 48,178, 80,
 25,  1,  1, 93,  1, 17, 51, 50, 54, 53, 52, 38, 35,  1, 33, 32,
  4, 23, 22, 18, 21, 20,  2,  7,  6,  4, 41,  1,  2, 61,138,236,
249,248,237,253,245,  1,150,  1, 84,  1, 77,119,105,102,102,105,
120,254,176,254,176,254,106,  4,178,252,113,234,223,222,232,  1,
 35, 97,116,101,254,248,167,169,254,247,101,116, 97,  0,  0,  1,
  0,188,  0,  0,  4,225,  5,213,  0, 11,  0, 48, 64, 20,  4,192,
  6,190,  2,192,  0,141,  8,192, 10,  1,  5,  9,  7,  3, 22,  0,
  3, 12, 16,252,236, 50,212,196,196, 49,  0, 47,236,244,236,244,
236, 48,182, 16, 13, 80, 13,112, 13,  3,  1, 93, 19, 33, 17, 33,
 17, 33, 17, 33, 17, 33, 17, 33,188,  4, 15,253,114,  2,103,253,
153,  2,164,251,219,  5,213,254,221,254,234,254,221,254,170,254,
221,  0,  0,  1,  0,188,  0,  0,  4,203,  5,213,  0,  9,  0, 43,
 64, 17,  4,192,  6,190,  2,192,  0,141,  8,  5,  1,  7,  3, 22,
  0,  3, 10, 16,252,236, 50,212,196, 49,  0, 47,244,236,244,236,
 48,182, 16, 11, 80, 11,112, 11,  3,  1, 93, 19, 33, 17, 33, 17,
 33, 17, 33, 17, 33,188,  4, 15,253,114,  2,103,253,153,254,127,
  5,213,254,221,254,234,254,221,253,135,  0,  1,  0,102,255,227,
  5,250,  5,240,  0, 29,  0, 75, 64, 37, 25, 26, 22, 12, 16,  9,
  0, 22,  3, 13, 16, 26,185, 28, 22,174,  3, 16,174,  9,156,  3,
152, 28, 30, 27, 25, 49, 12, 51,  0, 47, 19, 45,  6, 43, 30, 16,
252,236,244,228,252,196, 49,  0, 16,196,228,244,236, 16,238, 16,
238, 16,197, 17, 18, 57, 17, 18, 57, 17, 18, 57, 48,178, 95, 31,
  1,  1, 93, 37,  6,  4, 35, 32,  0, 17, 16,  0, 33, 50,  4, 23,
 17, 46,  1, 35, 34,  2, 21, 20, 18, 51, 50, 54, 55, 17, 35, 17,
 33,  5,250,144,254,202,165,254,139,254, 76,  1,188,  1,130,149,
  1, 17,121,125,247,124,230,249,240,221, 60,103, 41,235,  2, 88,
111, 70, 70,  1,161,  1,101,  1,105,  1,158, 56, 55,254,203, 71,
 70,254,255,239,237,254,254, 15, 16,  1, 34,  1,  2,  0,  0,  1,
  0,188,  0,  0,  5,246,  5,213,  0, 11,  0, 62, 64, 19,  2,192,
  8,190,  4,  0,141, 10,  6,  7,  3, 22,  5,  9,  1, 22,  0,  3,
 12, 16,252,236, 50,212,236, 50, 49,  0, 47, 60,244, 60,244,236,
 48, 64, 21, 15,  3, 15,  4, 15,  5, 15,  6, 15,  7, 15,  8, 80,
 13, 96, 13,112, 13,159, 13, 10,  1, 93, 19, 33, 17, 33, 17, 33,
 17, 33, 17, 33, 17, 33,188,  1,129,  2, 56,  1,129,254,127,253,
200,254,127,  5,213,253,199,  2, 57,250, 43,  2,121,253,135,  0,
  0,  1,  0,188,  0,  0,  2, 61,  5,213,  0,  3,  0, 55,183,  0,
193,  2,  1, 22,  0,  3,  4, 16,252,236, 49,  0, 47,236, 48,  1,
 75,176, 15, 84, 75,176, 16, 84, 91, 88,189,  0,  4,255,192,  0,
  1,  0,  4,  0,  4,  0, 64, 56, 17, 55, 56, 89,182, 16,  5, 64,
  5, 80,  5,  3, 93, 19, 33, 17, 33,188,  1,129,254,127,  5,213,
250, 43,  0,  1,255,141,254,102,  2, 61,  5,213,  0, 11,  0, 76,
 64, 19, 11,  2,  0,  7,192,  5,194,  0,141, 12,  5,  8,  6,  1,
 22,  6,  0,  3, 12, 16,252,196,236, 18, 57, 57, 49,  0, 16,228,
252,236, 17, 57, 57, 48,  1, 75,176, 15, 84, 75,176, 16, 84, 91,
 88,189,  0, 12,255,192,  0,  1,  0, 12,  0, 12,  0, 64, 56, 17,
 55, 56, 89,182, 16, 13, 64, 13, 80, 13,  3, 93, 19, 33, 17, 16,
  0, 33, 35, 17, 51, 50, 54, 53,188,  1,129,254,209,254,205, 78,
 60,120,123,  5,213,250,188,254,233,254,236,  1, 35,134,130,  0,
  0,  1,  0,188,  0,  0,  6,113,  5,213,  0, 10,  0,129, 64, 19,
  8,  5,  2,  3,  3,  0,193,  9,  6,  5,  1,  4,  6,  8,  1, 22,
  0,  3, 11, 16,252,236, 50,212,196, 17, 57, 49,  0, 47, 60,236,
 50, 23, 57, 48, 64, 86, 22,  5, 22,  6, 16, 12, 60,  3, 59,  7,
 76,  3, 75,  7, 91,  3, 88,  5, 93,  7,111,  3,103,  5,103,  6,
 96,  6,104,  7, 96, 12,127,  3,120,  7,127,  7,112, 12,133,  4,
134,  6,170,  7, 23, 39,  2, 50,  2, 59,  8, 66,  2, 75,  8, 84,
  2, 89,  5, 88,  8, 95,  8, 96,  2,102,  5,109,  8,112,  2,120,
  5,123,  8,127,  8,138,  5,141,  8,171,  8, 19, 93,  1, 93, 19,
 33, 17,  1, 33,  9,  1, 33,  1, 17, 33,188,  1,129,  2, 43,  1,
191,253, 49,  3, 25,254, 30,253,174,254,127,  5,213,253,223,  2,
 33,253, 61,252,238,  2, 76,253,180,  0,  0,  1,  0,188,  0,  0,
  4,225,  5,213,  0,  5,  0, 23, 64, 11,  2,192,  0,141,  4,  1,
 22,  3,  0,  3,  6, 16,252,196,236, 49,  0, 47,228,236, 48, 19,
 33, 17, 33, 17, 33,188,  1,129,  2,164,251,219,  5,213,251, 78,
254,221,  0,  1,  0,188,  0,  0,  7, 57,  5,213,  0, 12,  0,206,
 64, 51,  3, 54,  7,  8,  7,  2, 54,  1,  2,  8,  8,  7,  2, 54,
  3,  2,  9, 10,  9,  1, 54, 10, 10,  9, 37, 10,  7,  2,  3,  0,
  8,  3,  0,193, 11,  5,  9,  8,  3,  2,  1,  5, 10,  6, 49,  4,
 10, 49,  0,  3, 13, 16,252,236,212,236, 17, 23, 57, 49,  0, 47,
 60,236, 50,196, 17, 23, 57, 48, 75, 83, 88,  7, 16,  5,237,  7,
 16,  8,237,  7, 16,  8,237,  7, 16,  5,237, 89, 34,178, 15,  3,
  1,  1, 93, 64,102,  9,  2, 15,  8, 15,  9, 31,  2, 21,  7, 31,
  8, 31,  9, 21, 10, 43,  2, 63,  2, 72,  2, 79,  2, 76,  7, 76,
 10, 87,  2, 89,  7, 89, 10,104,  2,111,  7,111, 10,149,  2,144,
  8,144,  9,169,  2,176,  7,176, 10, 26,  4,  1,  4,  3,  0, 14,
 22,  1, 25,  3, 16, 14, 42,  1, 37,  3, 58,  1, 53,  3, 79,  1,
 64,  3, 71,  8, 86,  8, 89,  9, 80, 14,104,  1,103,  3,101,  8,
106,  9, 96, 14,133,  8,138,  9,151,  8, 24, 93,  0, 93, 19, 33,
  9,  1, 33, 17, 33, 17,  1, 35,  1, 17, 33,188,  1,234,  1, 84,
  1, 86,  1,233,254,148,254,168,244,254,168,254,147,  5,213,252,
225,  3, 31,250, 43,  4, 68,252,219,  3, 37,251,188,  0,  0,  1,
  0,188,  0,  0,  5,246,  5,213,  0,  9,  0,124, 64, 29,  7, 54,
  1,  2,  1,  2, 54,  6,  7,  6, 37,  7,  2,  3,  0,193,  8,  5,
  6,  1,  7,  2, 49,  4,  7, 49,  0,  3, 10, 16,252,236,212,236,
 17, 57, 57, 49,  0, 47, 60,236, 50, 57, 57, 48, 75, 83, 88,  7,
 16,  4,237,  7, 16,  4,237, 89, 34,178, 15,  7,  1,  0, 93, 64,
 52, 10,  6,  0, 11, 25,  6, 56,  1, 71,  1, 74,  6, 86,  1, 89,
  6, 80, 11,103,  1,104,  6, 96, 11,186,  1,182,  6, 14, 25,  2,
 26,  7, 62,  2, 51,  7, 73,  2, 79,  2, 64,  7, 85,  2, 90,  7,
102,  2,105,  7, 11, 93,  1, 93, 19, 33,  1, 17, 33, 17, 33,  1,
 17, 33,188,  1,174,  2, 31,  1,109,254, 82,253,225,254,147,  5,
213,252,  0,  4,  0,250, 43,  4,  0,252,  0,  0,  0,  2,  0,102,
255,227,  6,102,  5,240,  0, 11,  0, 23,  0, 50, 64, 19,  6,174,
 18,  0,174, 12,156, 18,152, 24,  9, 45, 15, 55,  3, 45, 21, 43,
 24, 16,252,236,252,236, 49,  0, 16,228,244,236, 16,238, 48, 64,
 11,  0, 25, 23, 19, 16, 25, 47, 25, 63, 25,  5,  1, 93,  1, 34,
  2, 21, 20, 18, 51, 50, 18, 53, 52,  2,  3, 32,  0, 17, 16,  0,
 33, 32,  0, 17, 16,  0,  3,102,176,194,194,176,177,194,194,177,
  1,104,  1,152,254,104,254,152,254,153,254,103,  1,153,  4,217,
254,252,236,235,254,252,  1,  4,235,236,  1,  4,  1, 23,254,100,
254,149,254,150,254,100,  1,156,  1,106,  1,107,  1,156,  0,  2,
  0,188,  0,  0,  5,137,  5,213,  0, 10,  0, 19,  0, 49, 64, 22,
 12,174,  7, 11,174,  0,141,  9, 19, 13,  7,  1,  8, 16, 45,  4,
 11,  8, 22,  0,  3, 20, 16,252,236, 50,212,236, 17, 57, 57, 57,
 57, 49,  0, 47,244,236,212,236, 48,178,  0, 21,  1,  1, 93, 19,
 33, 32,  4, 21, 20,  4, 33, 35, 17, 33,  1, 17, 51, 50, 54, 53,
 52, 38, 35,188,  2,127,  1, 29,  1, 49,254,207,254,227,254,254,
127,  1,129,213,112,122,122,112,  5,213,253,234,235,253,253,250,
  4,190,254, 95,109,100,100,108,  0,  2,  0,102,254,213,  6,102,
  5,240,  0, 15,  0, 27,  0, 98, 64, 26, 13, 22,174,  0, 16,174,
  7,156,  0,152, 14, 28, 14, 10,  1, 13, 19, 25, 45, 10, 55, 19,
 45,  4, 43, 28, 16,252,236,252,236, 17, 57, 57, 17, 57, 49,  0,
 16,196,228,244,236, 16,238, 57, 48, 64, 44,  8, 12,  0, 29, 25,
 12, 16, 29, 39,  0, 47, 29, 86, 12, 83, 13,102, 12, 96, 13,119,
 12,119, 13,112, 13, 13,  7, 12, 89, 11, 89, 13, 89, 20, 88, 24,
106, 11,105, 13,120, 12,  8, 93,  1, 93,  5, 35, 32,  0, 17, 16,
  0, 33, 32,  0, 17, 20,  2,  7,  1, 33,  1, 34,  2, 21, 20, 22,
 51, 50, 18, 53, 52,  2,  3,143, 30,254,143,254,102,  1,153,  1,
103,  1,107,  1,149,215,202,  1, 45,254,145,254,227,176,194,190,
180,177,194,194, 27,  1,152,  1,108,  1,107,  1,156,254,104,254,
145,252,254,148, 92,254,176,  6,  4,254,252,236,240,255,  1,  4,
235,236,  1,  4,  0,  2,  0,188,  0,  0,  6,  0,  5,213,  0,  8,
  0, 28,  0,135, 64, 50, 27, 26,  2, 28, 25, 29, 22, 23, 22, 24,
 29, 23, 23, 22, 37, 25, 22, 10, 19,  0,174,  9,  6,174, 12,141,
 23, 10, 22, 19, 24,  3, 16, 28, 25,  6,  0,  4, 13,  7,  3, 22,
 23, 16,  9,  7, 22, 11,  3, 29, 16,252,236, 50,212,196,236, 17,
 57, 23, 57, 17, 23, 57, 49,  0, 47, 60,244,236,212,236, 57, 18,
 57, 57, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237, 17, 23,
 57, 89, 34,178, 24, 28,  1,  1, 93, 64, 31, 27, 24, 27, 25, 26,
 26, 27, 27, 26, 28, 54, 21, 54, 22, 69, 21, 69, 22, 86, 21, 86,
 22, 80, 30,101, 21,101, 22, 96, 30, 15, 93,  1, 50, 54, 53, 52,
 38, 43,  1, 25,  2, 33, 17, 33, 32,  4, 21, 20,  6,  7, 30,  1,
 23, 19, 33,  3, 46,  1, 35,  2,223,121,105,105,121,162,254,127,
  2, 76,  1, 39,  1, 19,143,144, 79,125, 64,209,254,102,182, 55,
113, 94,  3, 63, 90,103,102, 88,254,129,254,246,253,203,  5,213,
198,214,148,190, 45, 18,127,129,254, 88,  1,115,112, 82,  0,  1,
  0,147,255,227,  5, 45,  5,240,  0, 39,  0,167, 64, 42,  0, 37,
  4, 20, 24, 17, 10, 11, 30, 31,  4, 21,  1,195,  4, 21,195, 24,
174, 17,  4,174, 37,156, 17,152, 40, 30, 10, 11, 31, 27,  7,  0,
 27, 25, 14, 20,  7, 25, 34, 40, 16,220,236,196,212,236,196, 17,
 18, 57, 57, 57, 57, 49,  0, 16,228,244,236, 16,254,229, 16,229,
 17, 23, 57, 17, 18, 57, 17, 18, 57, 48, 64, 84,112, 41,  1, 57,
 29, 57, 30, 57, 31, 57, 32, 74, 30, 74, 31, 74, 32, 88, 10, 93,
 29, 92, 30, 94, 31, 94, 32, 90, 33,106, 28,111, 29,111, 30,111,
 31,104, 32,111, 32,110, 33,116, 11,116, 12,116, 13,124, 31,124,
 32,124, 33,150, 11,151, 12,155, 30,154, 31,156, 32,154, 33,166,
 11,166, 12,166, 13,170, 29,170, 30,170, 31,170, 32,170, 33, 40,
 93,  1, 93,  1, 17, 46,  1, 35, 34,  6, 21, 20, 22, 31,  1, 30,
  1, 21, 20,  4, 33, 34, 36, 39, 17, 22,  4, 51, 50, 54, 53, 52,
 38, 47,  1, 46,  1, 53, 52, 36, 33, 50,  4,  4,203,123,234,104,
138,132, 89,117,164,249,210,254,219,254,211,142,254,226,143,143,
  1, 11,124,126,134, 91,136,149,224,207,  1, 32,  1, 14,123,  1,
  4,  5,166,254,196, 55, 56, 76, 80, 60, 67, 24, 33, 50,204,188,
247,241, 54, 53,  1, 69, 76, 77, 84, 78, 70, 76, 30, 33, 48,210,
178,223,240, 37,  0,  1,  0, 10,  0,  0,  5,106,  5,213,  0,  7,
  0, 62, 64, 14,  6,  2,192,  0,141,  4,  1, 56,  3, 22,  0, 56,
  5,  8, 16,212,236,252,236, 49,  0, 47,244,236, 50, 48,  1, 75,
176, 10, 84, 75,176, 14, 84, 91, 88,189,  0,  8,255,192,  0,  1,
  0,  8,  0,  8,  0, 64, 56, 17, 55, 56, 89,178, 64,  9,  1, 93,
 19, 33, 17, 33, 17, 33, 17, 33, 10,  5, 96,254, 17,254,127,254,
 16,  5,213,254,221,251, 78,  4,178,  0,  0,  1,  0,188,255,227,
  5,195,  5,213,  0, 17,  0, 51, 64, 23, 17, 11,  8,  2,  4,  0,
  5,192, 14,152,  9,  0,141, 18,  8, 22, 10, 57,  1, 22,  0,  3,
 18, 16,252,236,252,236, 49,  0, 16,228, 50,244,236, 17, 23, 57,
 48,182, 64, 19,112, 19,159, 19,  3,  1, 93, 19, 33, 17, 20, 22,
 51, 50, 54, 53, 17, 33, 17, 16,  0, 33, 32,  0, 17,188,  1,129,
121,137,138,121,  1,129,254,194,254,186,254,187,254,194,  5,213,
252,129,185,159,159,185,  3,127,252,129,254,195,254,202,  1, 54,
  1, 61,  0,  1,  0, 10,  0,  0,  6, 39,  5,213,  0,  6,  0,152,
 64, 39,  3, 29,  4,  5,  4,  2, 29,  1,  2,  5,  5,  4,  2, 29,
  0,  2,  6,  0,  6,  1, 29,  0,  0,  6, 37,  2,  3,  0,193,  5,
  6,  5,  3,  2,  1,  5,  4,  0,  7, 16,212,196, 23, 57, 49,  0,
 47,236, 50, 57, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  8,237,
  7, 16,  8,237,  7, 16,  5,237, 89, 34,  1, 75,176, 10, 84, 75,
176, 17, 84, 91, 88,189,  0,  7,255,192,  0,  1,  0,  7,  0,  7,
  0, 64, 56, 17, 55, 56, 89, 64, 44,  0,  2, 16,  2, 32,  2,176,
  2,  4,  7,  1,  8,  3, 23,  1, 24,  3, 24,  4, 23,  5, 31,  8,
 32,  8, 71,  0, 71,  1, 72,  3, 72,  4, 69,  5, 74,  6, 87,  1,
 88,  3,143,  8, 17, 93,  0, 93, 19, 33,  9,  1, 33,  1, 33, 10,
  1,131,  1,140,  1,139,  1,131,253,215,254, 53,  5,213,251,178,
  4, 78,250, 43,  0,  1,  0, 61,  0,  0,  8,147,  5,213,  0, 12,
  1,120, 64, 74,  6, 29,  7,  8,  7,  5, 29,  4,  5,  8,  8,  7,
 10, 54, 11, 10,  4,  5,  4,  9, 54,  5,  5,  4, 11, 54,  2,  3,
  2, 10, 54,  9, 10,  3,  3,  2,  2, 29,  3,  2, 12,  0, 12,  1,
 29,  0,  0, 12, 37, 10,  5,  2,  3,  6,  3,  0,193, 11,  8, 12,
 11, 10,  9,  8,  6,  5,  4,  3,  2,  1, 11,  7,  0, 13, 16,212,
204, 23, 57, 49,  0, 47, 60,236, 50, 50, 23, 57, 48, 75, 83, 88,
  7, 16,  5,237,  7, 16,  8,237,  7, 16,  8,237,  7, 16,  5,237,
  7, 16,  5,237,  7, 16,  8,237,  7, 16,  8,237,  7, 16,  5,237,
 89, 34,  1, 75,176,  9, 84, 75,176, 10, 84, 91, 75,176, 11, 84,
 91, 75,176, 12, 84, 91, 88,189,  0, 13,255,192,  0,  1,  0, 13,
  0, 13,  0, 64, 56, 17, 55, 56, 89, 64,204,  3, 10, 21,  2, 16,
  2, 20,  5, 16,  5, 16, 10, 37, 10, 32, 10, 32, 10, 58,  2, 63,
  2, 58,  5, 63,  5, 51, 10, 48, 10, 48, 10, 64, 10, 64, 10, 64,
 10, 94,  2, 94,  5, 97, 10,184,  2,177, 10,176, 10,176, 10, 26,
  5,  2, 10,  5,  9,  8,  9,  9,  5, 11,  6, 12, 22,  2, 24,  3,
 23,  4, 25,  5, 21,  8, 20,  9, 26, 11, 26, 12, 39,  2, 40,  3,
 39,  4, 40,  5, 37,  8, 42, 12, 47, 14, 54,  2, 54,  3, 50,  4,
 50,  5, 48,  6, 48,  7, 48,  8, 50,  9, 52, 10, 54, 11, 63, 14,
 73,  3, 70,  4, 72,  5, 69,  9, 74, 11, 93,  0, 93,  1, 90,  2,
 90,  3, 85,  4, 85,  5, 82,  6, 82,  7, 82,  8, 90,  9, 85, 11,
 93, 12,111,  0,111,  1,111,  2,110,  3,104,  4,104,  7,101,  8,
104,  9,107, 10,110, 11,105, 12,111, 12,119,  3,119,  8,120,  9,
118, 11,120, 12,136,  7,133,  8,137, 12,183,  2,186,  3,182,  4,
184,  5,177,  8,190, 12, 75, 93,  0, 93, 19, 33,  9,  1, 33,  9,
  1, 33,  1, 33,  9,  1, 33, 61,  1,113,  1,  2,  1,  0,  1,115,
  1,  0,  1,  2,  1,110,254,160,254, 68,254,241,254,244,254, 68,
  5,213,251,195,  4, 61,251,195,  4, 61,250, 43,  4,111,251,145,
  0,  1,  0, 39,  0,  0,  6,  2,  5,213,  0, 11,  0,251, 64, 69,
  4, 29,  5,  6,  5,  3, 29,  2,  3,  6,  6,  5, 10, 29, 11,  0,
 11,  9, 29,  8,  9,  0,  0, 11,  9, 29, 10,  9,  6,  7,  6,  8,
 29,  7,  7,  6,  3, 29,  4,  3,  0,  1,  0,  2, 29,  1,  0, 37,
  9,  6,  3,  0,  4, 10,  7,193,  4,  1,  9,  6,  3,  0,  4,  7,
 11,  1,  7,  5, 12, 16,212,196,220,196, 17, 23, 57, 49,  0, 47,
 60,236, 50, 23, 57, 48, 75, 83, 88,  7,  5,237,  7, 16,  8,237,
  7, 16,  5,237,  7, 16,  8,237,  7, 16,  8,237,  7, 16,  5,237,
  7, 16,  8,237,  7, 16,  5,237, 89, 34,  1, 75,176, 10, 84, 75,
176, 15, 84, 91, 75,176, 17, 84, 91, 88,189,  0, 12,255,192,  0,
  1,  0, 12,  0, 12,  0, 64, 56, 17, 55, 56, 89, 64, 88,  8,  3,
 15,  3,  6,  9,  0,  9, 31,  3, 16,  9, 47,  3, 38,  9, 32,  9,
 60,  3, 51,  9, 95,  3, 80,  9,143,  3,128,  9,191,  3,176,  9,
 17,  9,  2,  6,  4,  6,  8,  9, 10, 27,  2, 20,  4, 20,  8, 27,
 10, 43,  0, 43,  2, 37,  4, 36,  6, 37,  8, 43, 10, 58,  2, 53,
  4, 53,  8, 58, 10, 80, 13,101,  0,106,  6,111, 13,185,  2,181,
  4,181,  8,186, 10, 26, 93,  0, 93,  9,  1, 33,  9,  1, 33,  9,
  1, 33,  9,  1, 33,  3,252,  2,  6,254,111,254,163,254,166,254,
109,  2,  6,254, 14,  1,146,  1, 71,  1, 70,  1,148,  2,250,253,
  6,  1,254,254,  2,  2,250,  2,219,254, 31,  1,225,  0,  0,  1,
255,236,  0,  0,  5,223,  5,213,  0,  8,  0,160, 64, 40,  3, 29,
  4,  5,  4,  2, 29,  1,  2,  5,  5,  4,  2, 29,  3,  2,  8,  0,
  8,  1, 29,  0,  0,  8, 37,  2,  3,  0,193,  6,  2,  7,  4, 58,
  5, 22,  0, 58,  7,  9, 16,212,236,252,236, 18, 57, 49,  0, 47,
236, 50, 57, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  8,237,  7,
 16,  8,237,  7, 16,  5,237, 89, 34,  1, 75,176,  9, 84, 75,176,
 13, 84, 91, 75,176, 15, 84, 91, 88,189,  0,  9,255,192,  0,  1,
  0,  9,  0,  9,  0, 64, 56, 17, 55, 56, 89, 64, 44,  0,  2, 16,
  2, 32,  2, 37,  5, 37,  8, 48,  2, 64,  2, 80,  2, 96,  2,176,
  2, 10, 10,  0,  5,  4, 21,  1, 26,  3, 37,  1, 42,  3, 53,  1,
 58,  3, 48, 10, 79, 10,111, 10, 11, 93,  0, 93,  3, 33,  9,  1,
 33,  1, 17, 33, 17, 20,  1,165,  1, 84,  1, 84,  1,166,253,199,
254,127,  5,213,253,236,  2, 20,252,160,253,139,  2,117,  0,  1,
  0, 92,  0,  0,  5,113,  5,213,  0,  9,  0,119, 64, 26,  3, 29,
  7,  8,  7,  8, 29,  2,  3,  2, 37,  8,192,  0,141,  3,192,  5,
  8,  3,  0,  1,  4,  0,  6, 10, 16,212,196,220,196, 17, 57, 57,
 49,  0, 47,236,244,236, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,
  5,237, 89, 34,  1, 75,176,  9, 84, 75,176, 10, 84, 91, 88,189,
  0, 10,255,192,  0,  1,  0, 10,  0, 10,  0, 64, 56, 17, 55, 56,
 89, 64, 31,  5,  3, 11,  8, 21,  3, 26,  8, 37,  3, 41,  8, 54,
  3, 57,  8, 63, 11, 70,  3, 72,  8, 79, 11, 86,  3, 95, 11,111,
 11, 15, 93, 19, 33, 21,  1, 33, 17, 33, 53,  1, 33,115,  4,231,
252,223,  3, 56,250,235,  3, 33,252,246,  5,213,233,252, 55,254,
221,233,  3,201,  0,  1,  0,176,254,242,  3, 29,  6, 20,  0,  7,
  0, 31, 64, 16,  4,196,  6,164,  2,196,  0,163,  8,  5,  1,  3,
 17,  0, 16,  8, 16,252,252,204, 50, 49,  0, 16,252,236,252,236,
 48, 19, 33, 21, 33, 17, 33, 21, 33,176,  2,109,254,231,  1, 25,
253,147,  6, 20,225,250,160,225,  0,  1,  0,  0,255, 66,  2,236,
  5,213,  0,  3,  0, 19,183,  0,  1,141,  4,  2,  0,  3,  1, 47,
196, 57, 57, 49,  0, 16,244,204, 48,  5,  1, 51,  1,  2, 14,253,
242,221,  2, 15,190,  6,147,249,109,  0,  0,  1,  0,139,254,242,
  2,248,  6, 20,  0,  7,  0, 30, 64, 15,  2,196,  0,164,  4,196,
  6,163,  8,  0, 17,  5,  1,  3,  8, 16,212,204, 50,236, 49,  0,
 16,252,236,252,236, 48,  1, 33, 53, 33, 17, 33, 53, 33,  2,248,
253,147,  1, 25,254,231,  2,109,254,242,225,  5, 96,225,  0,  1,
  0,207,  3,168,  5,229,  5,213,  0,  6,  0, 24, 64, 10,  3,  4,
  1,  0,141,  7,  3,  1,  5,  7, 16,212,204, 57, 49,  0, 16,244,
204, 50, 57, 48,  1,  1, 35,  1,  1, 35,  1,  3,213,  2, 16,241,
254,102,254,103,242,  2, 16,  5,213,253,211,  1, 45,254,211,  2,
 45,  0,  0,  1,  0,  0,254, 29,  4,  0,254,219,  0,  3,  0, 14,
180,  0,  1,  4,  0,  2, 47,196, 49,  0, 16,212,204, 48,  1, 21,
 33, 53,  4,  0,252,  0,254,219,190,190,  0,  1,  0, 94,  4,238,
  2,147,  6,102,  0,  3,  0, 78,183,  1,198,  0,197,  4,  1,  3,
  4, 16,212,204, 49,  0, 16,244,236, 48,  0, 75,176,  9, 84, 75,
176, 14, 84, 91, 88,189,  0,  4,255,192,  0,  1,  0,  4,  0,  4,
  0, 64, 56, 17, 55, 56, 89,  1, 75,176,  9, 84, 88,189,  0,  4,
255,192,  0,  1,  0,  4,  0,  4,  0, 64, 56, 17, 55, 56, 89,180,
 26,  2, 26,  3,  2, 93,  9,  1, 35,  1,  1,121,  1, 26,196,254,
143,  6,102,254,136,  1,120,  0,  0,  2,  0, 88,255,227,  4,197,
  4,123,  0, 10,  0, 37,  0,157, 64, 42,  9,  6,  0, 25, 31, 11,
  0,210, 23,207,  6,159, 14,208, 17, 32,204, 31,203, 28,159, 35,
202, 17,152, 12,  0, 35, 23,  3, 24, 13,  9, 13, 11, 61, 31,  3,
 13, 20, 59, 38, 16,252,236,196,244,236, 50, 50, 17, 57, 57, 57,
 49,  0, 47,228,244,252,244,236, 16,230,238,246,238, 57, 18, 57,
 17, 18, 57, 48, 64, 76, 47, 39, 61, 32, 61, 33, 63, 39, 77, 32,
 77, 33, 93, 32, 93, 33,110, 32,110, 33,126, 32,126, 33,112, 39,
140, 32,140, 33,157, 32,157, 33,173, 32,173, 33,189, 32,189, 33,
 21, 50, 30, 48, 31, 67, 30, 64, 31, 83, 30, 80, 31, 99, 30, 96,
 31,133, 30,128, 31,147, 30,144, 31,162, 30,160, 31,178, 30,176,
 31, 16, 93,  1, 93,  1, 34,  6, 21, 20, 22, 51, 50, 54, 61,  1,
 37, 17, 33, 53, 14,  1, 35, 34, 38, 53, 52, 36, 33, 51, 53, 52,
 38, 35, 34,  6,  7, 17, 62,  1, 51, 32,  4,  2,162,112,113, 91,
 81,101,138,  1,105,254,151, 72,180,129,174,217,  1, 15,  1, 34,
211,134,142,115,198, 85,115,232,116,  1, 47,  1, 13,  1,248, 76,
 74, 68, 77,145,109, 41,135,253,129,166,102, 93,203,162,197,184,
 28, 85, 79, 46, 46,  1, 17, 28, 29,239,  0,  2,  0,172,255,227,
  5, 94,  6, 20,  0, 11,  0, 28,  0, 56, 64, 27,  6,161, 12,208,
 15,  0,161, 21,152, 15,202, 27,163, 24,208, 25,  3, 66, 18, 64,
 24, 12,  9, 13, 26, 16, 29, 16,252,236, 50, 50,244,236, 49,  0,
 47,228,236,228,244,236, 16,230,238, 48,180, 79, 30, 96, 30,  2,
  1, 93, 37, 50, 54, 53, 52, 38, 35, 34,  6, 21, 20, 22,  3, 62,
  1, 51, 50,  0, 17, 16,  0, 35, 34, 38, 39, 21, 33, 17, 33,  3,
  0,115,121,121,115,115,123,123,123, 74,180,117,207,  1, 10,254,
246,207,117,180, 74,254,154,  1,102,231,168,160,160,168,169,159,
159,169,  2,213, 98, 93,254,183,254,253,254,253,254,183, 93, 98,
162,  6, 20,  0,  0,  1,  0, 88,255,227,  4, 53,  4,123,  0, 25,
  0, 55, 64, 26,  0,204,  1,212,  4, 14,204, 13,212, 10,161, 17,
  4,161, 23,202, 17,152, 26,  7, 66, 13,  0, 20, 59, 26, 16,252,
196, 50,236, 49,  0, 16,228,244,236, 16,254,244,238, 16,245,238,
 48,180, 95, 27,127, 27,  2,  1, 93,  1, 17, 46,  1, 35, 34,  6,
 21, 20, 22, 51, 50, 54, 55, 17, 14,  1, 35, 32,  0, 17, 16,  0,
 33, 50, 22,  4, 53, 73,147, 79,150,167,167,150, 84,151, 64, 84,
173, 87,254,209,254,170,  1, 86,  1, 47, 88,171,  4, 61,254,220,
 50, 48,175,157,157,175, 50, 49,254,219, 31, 31,  1, 55,  1, 21,
  1, 21,  1, 55, 31,  0,  0,  2,  0, 92,255,227,  5, 14,  6, 20,
  0, 16,  0, 28,  0, 56, 64, 27, 23,161,  0,208, 14, 17,161,  5,
208,  8,152, 14,202,  1,163,  3, 20,  4,  0, 13,  2, 64, 26, 66,
 11, 59, 29, 16,252,236,244,236, 50, 50, 49,  0, 47,236,228,244,
228,236, 16,228,238, 48,180, 79, 30, 96, 30,  2,  1, 93,  1, 17,
 33, 17, 33, 53, 14,  1, 35, 34,  0, 17, 16,  0, 51, 50, 22,  3,
 50, 54, 53, 52, 38, 35, 34,  6, 21, 20, 22,  3,166,  1,104,254,
152, 74,178,117,207,254,246,  1, 10,207,116,179,162,115,121,121,
115,114,121,121,  3,188,  2, 88,249,236,162, 99, 92,  1, 73,  1,
  3,  1,  3,  1, 73, 93,252,201,168,160,160,168,168,160,160,168,
  0,  2,  0, 88,255,227,  5, 10,  4,123,  0, 20,  0, 27,  0, 67,
 64, 33,  0, 21,216,  1,  9,204,  8,212,  5,159, 12,  1,215, 24,
159, 18,202, 12,152, 28, 27, 21,  2,  8, 21, 13,  0, 68,  2, 13,
 15, 59, 28, 16,252,236,244,236,196, 17, 18, 57, 49,  0, 16,228,
244,236,228, 16,254,244,238, 16,238, 57, 48,180, 47, 29, 63, 29,
  2,  1, 93,  1, 21, 33, 30,  1, 51, 50, 54, 55, 17, 14,  1, 35,
 32,  0, 17, 16,  0, 33, 32,  0,  5, 52, 38, 35, 34,  6,  7,  5,
 10,252,187, 13,156,140,113,237,125,127,254,127,254,208,254,175,
  1, 75,  1, 34,  1,  8,  1, 61,254,144,119, 96,104,130, 16,  2,
 51,102,126,126, 67, 68,254,236, 48, 49,  1, 53,  1, 23,  1, 18,
  1, 58,254,194,147,102,125,117,110,  0,  0,  1,  0, 39,  0,  0,
  3,141,  6, 20,  0, 19,  0, 96, 64, 28, 16,  5,  1, 12,  8,161,
  6,  1,159,  0,163, 14,  6,179, 10,  2, 19,  7,  0,  7,  9,  5,
 13, 13, 69, 15, 11, 20, 16,220, 60,236,252, 60,196,196, 18, 57,
 57, 49,  0, 47,228, 50,252,236, 16,238, 50, 18, 57, 57, 48,  1,
 75,176, 13, 84, 75,176, 14, 84, 91, 88,189,  0, 20,255,192,  0,
  1,  0, 20,  0, 20,  0, 64, 56, 17, 55, 56, 89, 64,  9, 16,  7,
 16,  8,128,  7,128,  8,  4, 93,  1, 21, 35, 34,  6, 29,  1, 33,
 17, 33, 17, 33, 17, 35, 17, 51, 53, 52, 54, 51,  3,141,198, 76,
 60,  1, 50,254,206,254,154,178,178,204,214,  6, 20,235, 55, 68,
 78,255,  0,252,160,  3, 96,  1,  0, 78,183,175,  0,  2,  0, 92,
254, 70,  5, 14,  4,121,  0, 28,  0, 40,  0, 75, 64, 38, 28, 15,
  3,  0, 21,204, 22,212, 25,159, 18, 29,161, 12,208,  9,202, 13,
179, 35,161, 18,218,  0,208,  3, 38, 12,  0, 13, 14, 64, 21, 32,
 66,  6, 59, 41, 16,252,236,196,244,236, 50, 50, 49,  0, 47,228,
228,236,228,244,228,236, 16,254,245,238, 17, 18, 57, 57, 48,180,
 79, 42, 96, 42,  2,  1, 93, 37, 14,  1, 35, 34,  0, 53, 52,  0,
 51, 50, 22, 23, 53, 33, 17, 16,  0, 33, 34, 38, 39, 17, 30,  1,
 51, 50, 54, 53,  3, 34,  6, 21, 20, 22, 51, 50, 54, 53, 52, 38,
  3,166, 74,178,117,205,254,244,  1, 12,205,117,178, 74,  1,104,
254,171,254,188,105,196, 99, 94,180, 91,176,164,236,111,124,120,
115,112,124,124,190, 98, 92,  1, 67,250,251,  1, 65, 92, 99,166,
252, 17,254,242,254,227, 32, 33,  1, 23, 54, 53,154,164,  3,  6,
164,150,154,159,164,149,150,164,  0,  1,  0,172,  0,  0,  5, 18,
  6, 20,  0, 23,  0, 53, 64, 24, 13,  4,  0,  1, 10,219, 18,208,
 21,202, 16,163, 14,  1,  2, 13,  0, 71, 17, 13, 13, 15, 16, 24,
 16,252,236, 50,244,236, 49,  0, 47, 60,236,244,228,236, 17, 57,
 57, 57, 48,180, 96, 25,128, 25,  2,  1, 93,  1, 17, 33, 53, 17,
 52, 38, 39, 46,  1, 35, 34,  6, 21, 17, 33, 17, 33, 17, 62,  1,
 51, 50, 22,  5, 18,254,152, 13, 16, 21, 72, 46,112,128,254,154,
  1,102, 81,182,110,194,201,  2,170,253, 86,111,  1,153,147,110,
 26, 35, 39,173,153,253,217,  6, 20,253,168, 98, 93,238,  0,  2,
  0,172,  0,  0,  2, 18,  6, 20,  0,  3,  0,  7,  0, 41, 64, 14,
  6,221,  0,179,  4,163,  2,  5,  1, 13,  4,  0, 16,  8, 16,252,
 60,236, 50, 49,  0, 47,236,244,236, 48, 64,  9, 80,  9, 96,  9,
112,  9,128,  9,  4,  1, 93, 19, 33, 17, 33, 17, 33, 17, 33,172,
  1,102,254,154,  1,102,254,154,  4, 96,251,160,  6, 20,254,220,
  0,  2,255,188,254, 70,  2, 18,  6, 20,  0, 11,  0, 15,  0, 61,
 64, 25, 11,  2,  0,  7,159,  5, 14,221,  0,179,  5,218, 12,163,
 16,  5,  8,  6, 13,  1, 13, 12,  0, 16, 16, 16,252, 60,236, 50,
196, 57, 57, 49,  0, 16,236,228,244,236, 16,238, 17, 57, 57, 48,
 64,  9, 80, 17, 96, 17,112, 17,128, 17,  4,  1, 93, 19, 33, 17,
 20,  6, 43,  1, 53, 51, 50, 54, 53, 17, 33, 17, 33,172,  1,102,
216,205,177, 62,102, 76,  1,102,254,154,  4, 96,251,180,225,237,
235, 92,135,  6,  0,254,220,  0,  0,  1,  0,172,  0,  0,  5,121,
  6, 20,  0, 10,  0,140, 64, 20,  8,  5,  2,  3,  3,179,  0,163,
  9,  6,  5,  1,  4,  6,  8,  1, 13,  0, 16, 11, 16,252,236, 50,
212,196, 17, 57, 49,  0, 47, 60,236,228, 23, 57, 48, 64, 96, 25,
  3, 25,  4, 25,  5, 25,  6, 59,  7, 73,  3, 73,  7, 90,  3, 93,
  6, 88,  7, 95,  7,111,  3,103,  5,127,  3,118,  4,118,  6,123,
  7,136,  3,133,  4,135,  5,139,  7,159,  3,149,  5,150,  6,155,
  7,185,  3, 26, 22,  2, 22,  5, 58,  8, 68,  2, 71,  5, 74,  8,
 86,  2, 93,  8,103,  2, 96,  2,101,  5,119,  2,112,  2,118,  5,
124,  8,135,  2,136,  5,139,  8,146,  2,151,  5,155,  8, 21, 93,
  1, 93, 19, 33, 17,  1, 33,  9,  1, 33,  1, 17, 33,172,  1,102,
  1,156,  1,160,253,221,  2, 78,254, 78,254, 75,254,154,  6, 20,
252,177,  1,155,253,254,253,162,  1,211,254, 45,  0,  1,  0,172,
  0,  0,  2, 18,  6, 20,  0,  3,  0, 30,183,  0,163,  2,  1, 13,
  0, 16,  4, 16,252,236, 49,  0, 47,236, 48, 64,  9, 80,  5, 96,
  5,112,  5,128,  5,  4,  1, 93, 19, 33, 17, 33,172,  1,102,254,
154,  6, 20,249,236,  0,  0,  1,  0,170,  0,  0,  7,180,  4,123,
  0, 37,  0,116, 64, 41, 27, 21, 18,  9,  4,  7,  0, 32,  6,  7,
 24, 15,219, 32,208, 35,  3,202, 30,179, 28, 19,  7,  0, 20, 18,
 12,  8, 13,  6, 72, 20, 13, 18, 72, 31, 27, 13, 29, 16, 38, 16,
252,252, 60,252,236,252,236, 57, 17, 18, 57, 49,  0, 47, 60, 60,
228,244, 60,228,236, 50, 17, 57, 17, 57, 17, 23, 57, 48,  1, 75,
176, 15, 84, 88,189,  0, 38,255,192,  0,  1,  0, 38,  0, 38,  0,
 64, 56, 17, 55, 56, 89, 64, 15, 31, 39, 48, 39, 80, 39,112, 39,
128, 39,144, 39,175, 39,  7, 93,  1, 62,  1, 51, 50, 22, 21, 17,
 33, 17, 62,  1, 53, 52, 38, 35, 34,  6,  7, 17, 33, 17, 52, 38,
 35, 34,  6, 21, 17, 33, 17, 33, 21, 62,  1, 51, 50, 22,  4,186,
 68,187,112,193,202,254,152,  1,  1, 70, 78,102,111,  2,254,152,
 64, 82,103,112,254,152,  1,104, 66,171,103,116,178,  3,166,104,
109,238,227,253, 86,  2, 72, 13, 28, 26,119,107,168,159,253,218,
  2, 72,186,107,169,157,253,217,  4, 96,164, 95, 96,112,  0,  1,
  0,172,  0,  0,  5, 18,  4,123,  0, 23,  0, 53, 64, 24, 13,  4,
  0,  1, 10,219, 18,208, 21,202, 16,179, 14,  1,  2, 13,  0, 71,
 17, 13, 13, 15, 16, 24, 16,252,236, 50,244,236, 49,  0, 47, 60,
228,244,228,236, 17, 57, 57, 57, 48,180, 96, 25,128, 25,  2,  1,
 93,  1, 17, 33, 53, 17, 52, 38, 39, 46,  1, 35, 34,  6, 21, 17,
 33, 17, 33, 21, 62,  1, 51, 50, 22,  5, 18,254,152, 13, 16, 21,
 72, 46,112,128,254,154,  1,102, 81,182,110,194,201,  2,170,253,
 86,111,  1,155,145,110, 26, 35, 39,173,153,253,217,  4, 96,164,
 98, 93,238,  0,  0,  2,  0, 88,255,227,  5, 39,  4,123,  0, 11,
  0, 23,  0, 45, 64, 19,  6,161, 18,  0,161, 12,202, 18,152, 24,
  9, 66, 15, 76,  3, 66, 21, 59, 24, 16,252,236,252,236, 49,  0,
 16,228,244,236, 16,238, 48,182, 55, 19, 63, 25, 71, 19,  3,  1,
 93,  1, 34,  6, 21, 20, 22, 51, 50, 54, 53, 52, 38,  3, 32,  0,
 17, 16,  0, 33, 32,  0, 17, 16,  0,  2,193,119,125,125,119,117,
124,124,117,  1, 33,  1, 69,254,187,254,223,254,222,254,185,  1,
 71,  3,123,171,161,161,171,171,161,161,171,  1,  0,254,200,254,
236,254,236,254,200,  1, 56,  1, 20,  1, 20,  1, 56,  0,  0,  2,
  0,172,254, 86,  5, 94,  4,123,  0, 16,  0, 28,  0, 59, 64, 29,
 23,161,  0,208, 14, 17,161,  5,208,  8,202, 14,152,  1,222,  3,
179, 29, 26, 66, 11, 64, 20,  4,  0, 13,  2, 16, 29, 16,252,236,
 50, 50,244,236, 49,  0, 16,228,228,228,244,228,236, 16,228,238,
 48,180, 79, 30, 96, 30,  2,  1, 93, 37, 17, 33, 17, 33, 21, 62,
  1, 51, 50,  0, 17, 16,  0, 35, 34, 38, 19, 34,  6, 21, 20, 22,
 51, 50, 54, 53, 52, 38,  2, 18,254,154,  1,102, 74,180,117,207,
  1, 10,254,246,207,117,180,164,115,123,123,115,115,121,121,162,
253,180,  6, 10,164, 98, 93,254,183,254,253,254,253,254,183, 93,
  3, 55,169,159,159,169,168,160,160,168,  0,  2,  0, 92,254, 86,
  5, 14,  4,121,  0, 11,  0, 28,  0, 59, 64, 29,  6,161, 12,208,
 15,  0,161, 24,208, 21,202, 25,179, 27,222, 15,152, 29, 24, 12,
  9, 13, 26, 64,  3, 66, 18, 59, 29, 16,252,236,244,236, 50, 50,
 49,  0, 16,228,228,228,244,228,236, 16,230,238, 48,180, 79, 30,
 96, 30,  2,  1, 93,  1, 34,  6, 21, 20, 22, 51, 50, 54, 53, 52,
 38, 19, 14,  1, 35, 34,  0, 17, 16,  0, 51, 50, 22, 23, 53, 33,
 17, 33,  2,186,114,121,121,114,115,121,121,121, 74,178,117,207,
254,246,  1, 10,207,117,178, 74,  1,104,254,152,  3,119,168,160,
160,168,168,160,160,168,253, 43, 99, 92,  1, 73,  1,  3,  1,  3,
  1, 71, 92, 99,166,249,246,  0,  0,  1,  0,172,  0,  0,  3,236,
  4,123,  0, 17,  0, 67, 64, 22, 17, 14,  9,  6,  7,  0,  3,192,
 11,148, 14,202,  9,179,  7, 10,  6, 13,  0,  8, 16, 18, 16,252,
196,236, 50, 49,  0, 47,228,244,228,252,196, 17, 57, 17, 18, 57,
 48,  1, 75,176, 19, 84, 88,189,  0, 18,  0, 64,  0,  1,  0, 18,
  0, 18,255,192, 56, 17, 55, 56, 89,  1, 46,  1, 35, 34,  6, 21,
 17, 33, 17, 33, 21, 62,  1, 51, 50, 22, 23,  3,236, 47, 93, 47,
138,149,254,154,  1,102, 69,179,125, 18, 42, 40,  3, 47, 22, 21,
177,165,253,252,  4, 96,184,110,101,  3,  5,  0,  0,  1,  0,106,
255,227,  4, 98,  4,123,  0, 39,  0,220, 64, 64, 13, 12,  2, 14,
 11, 54, 30, 31, 30,  5,  6,  7,  8,  9,  5,  4, 10, 54, 31, 31,
 30, 37, 10, 11, 30, 31,  4, 21,  0,204,  1,212,  4, 20,204, 21,
212, 24,159, 17,  4,159, 37,202, 17,152, 40, 30, 10, 11, 31, 27,
  7,  0, 83, 27, 82, 14, 20,  7, 80, 34, 77, 40, 16,252,236,196,
212,236,228, 17, 18, 57, 57, 57, 57, 49,  0, 16,228,244,236, 16,
254,245,238, 16,245,238, 18, 23, 57, 48, 75, 83, 88,  7, 16, 14,
237, 17, 23, 57,  7, 16, 14,237, 17, 23, 57, 89, 34,178,  8, 11,
  1,  1, 93, 64, 94,  9,  9,  9, 10,  9, 11, 11, 12, 11, 13,  9,
 15,  5, 35, 26, 12, 26, 13, 26, 14, 24, 15, 44,  8, 46,  9, 46,
 10, 46, 11, 46, 12, 46, 13, 41, 32, 57,  8, 59,  9, 59, 10, 59,
 11, 58, 12, 58, 13, 75,  9, 74, 10, 74, 11, 74, 12, 72, 13,119,
 12,119, 13,186,  8,186,  9,186, 10,186, 11,186, 12,186, 13, 37,
 14,  6, 14,  7, 14,  8, 14,  9, 14, 10, 13, 11, 55, 13, 63, 41,
 95, 41,  9, 93,  0, 93,  1, 17, 46,  1, 35, 34,  6, 21, 20, 22,
 31,  1,  4, 22, 21, 20,  4, 33, 34, 38, 39, 17, 30,  1, 51, 50,
 54, 53, 52, 38, 47,  1, 46,  1, 53, 52, 54, 51, 50, 22,  4, 23,
115,214, 95,102, 99, 75, 97, 63,  1, 19,190,254,248,254,250,111,
237,125,107,225,116,105,106, 73,109, 63,239,192,244,252, 99,218,
  4, 61,254,240, 48, 48, 51, 53, 43, 46, 11,  9, 35,160,171,179,
180, 35, 35,  1, 16, 52, 52, 58, 57, 48, 47, 13,  8, 30,162,165,
178,172, 30,  0,  0,  1,  0, 27,  0,  0,  3,164,  5,158,  0, 19,
  0,120, 64, 26, 14,  5,  8, 15,  3,161, 17,  1,179,  8,161,  0,
 10,  8, 11,  9,  2,  9,  4,  0, 13, 16, 18, 14, 84, 20, 16,252,
 60,196,252, 60,196,196, 18, 57, 57, 49,  0, 47,196,236,244, 60,
236, 50, 17, 57, 57, 48,  1, 75,176, 15, 84, 75,176, 16, 84, 91,
 75,176, 17, 84, 91, 75,176, 18, 84, 91, 88,189,  0, 20,255,192,
  0,  1,  0, 20,  0, 20,  0, 64, 56, 17, 55, 56, 89, 64, 24, 63,
  0, 63, 19,  2,  0,  2,  0,  3, 15, 16, 15, 17, 80,  2, 80,  3,
 80, 21, 96,  2, 96,  3,  9, 93,  0, 93,  1, 17, 33, 17, 33, 17,
 20, 22, 59,  1, 17, 33, 34, 38, 53, 17, 35, 17, 51, 17,  2, 51,
  1,113,254,143, 62, 92,184,254,205,212,177,178,178,  5,158,254,
194,255,  0,254, 37, 78, 55,255,  0,177,212,  1,219,  1,  0,  1,
 62,  0,  0,  1,  0,160,255,227,  5,  6,  4, 96,  0, 25,  0, 59,
 64, 27, 15,  3,  0,  1, 12,219, 20,208, 23,152, 16,  1,179, 18,
  6,  2,  0, 19, 15, 13, 17, 71,  2, 13,  0, 16, 26, 16,252,236,
244,236, 50, 17, 18, 57, 49,  0, 47,228, 50,244,228,236, 17, 57,
 57, 57, 48,180, 96, 27,128, 27,  2,  1, 93, 19, 17, 33, 21, 20,
  2, 21, 20, 22, 23, 30,  1, 51, 50, 54, 53, 17, 33, 17, 33, 53,
 14,  1, 35, 34, 38,160,  1,104,  2, 14, 17, 22, 71, 46,112,128,
  1,102,254,154, 81,181,109,194,203,  1,180,  2,172,112, 91,254,
237, 46,135,119, 27, 35, 38,172,153,  2, 41,251,160,162, 98, 93,
238,  0,  0,  1,  0, 31,  0,  0,  5, 25,  4, 96,  0,  6,  0,232,
 64, 39,  3, 29,  4,  5,  4,  2, 29,  1,  2,  5,  5,  4,  2, 29,
  3,  2,  6,  0,  6,  1, 29,  0,  0,  6, 37,  2,  3,  0,223,  5,
  6,  5,  3,  2,  1,  5,  4,  0,  7, 16,212,196, 23, 57, 49,  0,
 47,236, 50, 57, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  8,237,
  7, 16,  8,237,  7, 16,  5,237, 89, 34,  1, 75,176, 10, 84, 75,
176, 18, 84, 91, 88,189,  0,  7,255,192,  0,  1,  0,  7,  0,  7,
  0, 64, 56, 17, 55, 56, 89, 64,124,  0,  2,  0,  2, 16,  2, 16,
  2, 32,  2, 48,  2, 64,  2, 86,  2,102,  2,128,  2,144,  2,160,
  2,176,  2,176,  2,176,  2,176,  2,192,  2,192,  2,208,  2,208,
  2,224,  2,224,  2,224,  2,240,  2,240,  2, 25,  5,  0,  2,  1,
 13,  3, 10,  4, 21,  0, 19,  1, 28,  3, 26,  4, 38,  0, 36,  1,
 43,  3, 41,  4, 54,  0, 52,  1, 57,  3, 57,  4, 48,  8, 70,  0,
 70,  1, 73,  3, 73,  4, 96,  8,120,  6,135,  1,136,  3,135,  5,
136,  6,150,  0,150,  1,153,  3,153,  4,149,  5,154,  6,168,  3,
182,  1,185,  3, 36, 93,  0, 93, 19, 33,  9,  1, 33,  1, 33, 31,
  1,102,  1, 23,  1, 22,  1,103,254, 71,254,119,  4, 96,252,250,
  3,  6,251,160,  0,  1,  0, 72,  0,  0,  7, 29,  4, 96,  0, 12,
  1,141, 64, 74,  6, 29,  7,  8,  7,  5, 29,  4,  5,  8,  8,  7,
 10, 52, 11, 10,  4,  5,  4,  9, 52,  5,  5,  4, 11, 52,  2,  3,
  2, 10, 52,  9, 10,  3,  3,  2,  2, 29,  3,  2, 12,  0, 12,  1,
 29,  0,  0, 12, 37, 10,  5,  2,  3,  6,  3,  0,223, 11,  8, 12,
 11, 10,  9,  8,  6,  5,  4,  3,  2,  1, 11,  7,  0, 13, 16,212,
204, 23, 57, 49,  0, 47, 60,236, 50, 50, 23, 57, 48, 75, 83, 88,
  7, 16,  5,237,  7, 16,  8,237,  7, 16,  8,237,  7, 16,  5,237,
  7, 16,  5,237,  7, 16,  8,237,  7, 16,  8,237,  7, 16,  5,237,
 89, 34,  1, 75,176, 10, 84, 75,176, 11, 84, 91, 75,176, 12, 84,
 91, 88,189,  0, 13,255,192,  0,  1,  0, 13,  0, 13,  0, 64, 56,
 17, 55, 56, 89, 64,230, 21, 10, 32, 10, 53,  2, 53,  5, 48, 10,
 71, 10, 64, 10, 64, 10, 95, 10,108, 10,127, 10,176,  2,176,  2,
176,  5,176,  5,176, 10,192,  2,192,  5,209, 10,208, 10,224,  2,
224,  5,239, 10, 23, 22,  2, 20,  3, 20,  4, 18,  5, 16,  6, 16,
  7, 16,  8, 18,  9, 20, 10, 22, 11, 38,  1, 36,  2, 43,  5, 41,
  6, 42,  8, 43,  9, 36, 11, 37, 12, 47, 14, 53,  0, 53,  1, 52,
  2, 59,  5, 58,  6, 58,  7, 55,  8, 56, 12, 63, 14, 71,  2, 73,
  3, 70,  4, 72,  5, 71,  8, 72, 12, 89,  3, 86,  4, 86,  8, 91,
  9, 84, 11, 89, 12, 95, 14,102,  2, 96,  4, 98,  5, 96,  6, 96,
  7, 96,  8,100, 10, 96, 11,117,  2,112,  4,115,  5,112,  6,112,
  7,112,  8,116, 10,112, 11,135,  1,136,  6,132,  8,137,  9,134,
 11,139, 12,143, 14,148,  8,155, 12,144, 14,166,  2,169,  3,166,
  4,169,  5,165,  8,169,  9,166, 11,170, 12,182,  1,185,  6,182,
  8,185, 12,198,  1,196,  3,202,  4,201,  6,213,  2,217,  3,215,
  4,218,  5,229,  8,233,  9,230, 11,234, 12, 91, 93,  0, 93, 19,
 33, 27,  1, 33, 27,  1, 33,  1, 33, 11,  1, 33, 72,  1, 92,188,
189,  1, 43,188,189,  1, 92,254,217,254,121,189,188,254,121,  4,
 96,252,252,  3,  4,253,  4,  2,252,251,160,  3,  2,252,254,  0,
  0,  1,  0, 31,  0,  0,  5, 10,  4, 96,  0, 11,  1,132, 64, 70,
 10, 29, 11,  0, 11,  9, 29,  8,  9,  0,  0, 11,  9, 29, 10,  9,
  6,  7,  6,  8, 29,  7,  7,  6,  4, 29,  5,  6,  5,  3, 29,  2,
  3,  6,  6,  5,  3, 29,  4,  3,  0,  1,  0,  2, 29,  1,  1,  0,
 37,  9,  6,  3,  0,  4,  4,  1,223, 10,  7,  9,  6,  3,  0,  4,
  1,  5,  7,  1, 11, 12, 16,212,196,212,196, 17, 23, 57, 49,  0,
 47, 60,236, 50, 23, 57, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,
  8,237,  7, 16,  8,237,  7, 16,  5,237,  7, 16,  5,237,  7, 16,
  8,237,  7, 16,  8,237,  7, 16,  5,237, 89, 34,  1, 75,176, 10,
 84, 75,176, 15, 84, 91, 75,176, 18, 84, 91, 75,176, 20, 84, 91,
 88,189,  0, 12,255,192,  0,  1,  0, 12,  0, 12,  0, 64, 56, 17,
 55, 56, 89, 64,218,  0,  3, 15,  9, 16,  3, 31,  9, 32,  3, 47,
  9, 51,  3, 60,  9, 67,  3, 76,  9, 82,  3, 92,  9, 98,  3,108,
  9,115,  3,122,  9,129,  3,128,  3,141,  9,143,  9,151,  0,144,
  3,144,  3,151,  6,156,  9,159,  9,160,  3,175,  9,176,  3,176,
  3,176,  3,191,  9,191,  9,191,  9,192,  3,192,  3,207,  9,207,
  9,208,  3,208,  3,223,  9,223,  9,224,  3,224,  3,239,  9,239,
  9,247,  0,240,  3,247,  6,255,  9, 50,  3,  2, 12,  4, 12,  8,
  3, 10, 19,  2, 28,  4, 28,  8, 19, 10, 31, 13, 36,  2, 43,  4,
 43,  8, 36, 10, 52,  2, 59,  4, 59,  8, 52, 10, 48, 13, 68,  2,
 75,  4, 75,  8, 68, 10,111, 13,134,  0,128,  2,143,  4,137,  6,
143,  8,128, 10,151,  0,149,  2,154,  4,153,  6,154,  8,150, 10,
167,  6,176,  2,191,  4,191,  8,176, 10,192,  2,207,  4,207,  8,
192, 10,215,  0,208,  2,223,  4,216,  6,223,  8,208, 10,231,  0,
224,  2,239,  4,232,  6,239,  8,224, 10,249,  0,246,  6, 58, 93,
  0, 93,  9,  1, 33, 27,  1, 33,  9,  1, 33, 11,  1, 33,  1,199,
254,108,  1,123,229,232,  1,123,254,108,  1,168,254,133,252,249,
254,133,  2, 61,  2, 35,254,180,  1, 76,253,223,253,193,  1, 98,
254,158,  0,  1,  0, 25,254, 70,  5, 18,  4, 96,  0, 15,  1, 65,
 64, 67, 15, 29,  0, 15,  5,  4, 11, 12, 13,  3, 14, 29,  5,  5,
  4,  3, 29,  4,  5,  4,  2, 29,  1,  2,  5,  5,  4,  2, 29,  3,
  2, 15,  0, 15,  1, 29,  0,  0, 15, 37, 14, 10,  2, 16,  5,  0,
 10,159,  8,218,  3,  0,179, 16, 15, 14, 11,  9,  8,  5,  3,  2,
  1,  9,  4,  0, 16, 16,212,196, 23, 57, 49,  0, 16,228, 50,244,
236, 17, 57, 18, 57, 17, 57, 48, 75, 83, 88,  7, 16,  5,237,  7,
 16,  8,237,  7, 16,  8,237,  7, 16,  5,237,  7, 16,  5,237, 23,
 57,  7,  8,237, 89, 34,  1, 75,176, 10, 84, 75,176, 18, 84, 91,
 75,176, 20, 84, 91, 88,189,  0, 16,255,192,  0,  1,  0, 16,  0,
 16,  0, 64, 56, 17, 55, 56, 89, 64,164,  0,  2,  0,  2, 16,  2,
 16,  2, 32,  2, 64,  2, 80,  2,101,  2,116,  2,134,  2,128,  2,
148,  2,144,  2,160,  2,180,  2,176,  2,176,  2,176,  2,192,  2,
192,  2,212,  2,208,  2,224,  2,224,  2, 24,  4,  1,  9,  3,  5,
  5,  5,  6,  5,  7,  5,  8, 22,  1, 21,  5, 21,  6, 21,  7, 36,
  5, 36,  6, 36,  7, 53,  0, 53,  1, 56,  3, 54,  6, 54,  7, 57,
 14, 57, 15, 69,  0, 69,  1, 74,  3, 74,  4, 69,  5, 69,  6,103,
  2,101,  6,134,  2,134,  5,134,  6,136, 13,136, 14,151,  2,150,
  5,150,  6,153, 13,153, 14,168,  2,170,  3,170,  4,169, 14,169,
 15,181,  1,188,  3,184,  4,176,  9,176, 10,191, 11,185, 13,185,
 14,200,  2,203, 13,203, 14,201, 15,214,  2,229,  2, 57, 93,  0,
 93, 19, 33,  9,  1, 33,  1, 14,  1, 43,  1, 53, 51, 50, 54, 63,
  1, 25,  1,102,  1, 45,  1,  0,  1,102,254, 41, 71,189,155,207,
112, 91, 83, 23, 10,  4, 96,253,  8,  2,248,251, 54,187,149,235,
 58, 75, 31,  0,  0,  1,  0, 92,  0,  0,  4, 70,  4, 96,  0,  9,
  0,158, 64, 26,  8, 29,  2,  3,  2,  3, 29,  7,  8,  7, 37,  8,
161,  0,179,  3,161,  5,  8,  3,  0,  4,  1,  0,  6, 10, 16,212,
196,204, 50, 17, 57, 57, 49,  0, 47,236,244,236, 48, 75, 83, 88,
  7, 16,  5,237,  7, 16,  5,237, 89, 34,  1, 75,176,  9, 84, 75,
176, 10, 84, 91, 88,189,  0, 10,255,192,  0,  1,  0, 10,  0, 10,
  0, 64, 56, 17, 55, 56, 89, 64, 68, 89,  2, 86,  7,105,  2,102,
  7,121,  2,118,  7,132,  7,147,  7,  8,  0,  3, 15,  8, 16,  1,
 16,  2, 16,  3, 16,  4, 16,  5, 16, 11, 38,  3, 41,  8, 47, 11,
 57,  8, 63, 11, 74,  8, 95, 11,142,  8,158,  8,177,  3,189,  8,
192,  3,207,  8,208,  3,223,  8,227,  3,236,  8, 25, 93,  0, 93,
 19, 33, 21,  1, 33, 17, 33, 53,  1, 33,117,  3,209,253,178,  2,
 78,252, 22,  2, 78,253,203,  4, 96,250,253,154,255,  0,250,  2,
102,  0,  0,  1,  1,  0,254,178,  4,178,  6, 20,  0, 36,  0, 94,
 64, 49, 25, 15, 21, 11,  6, 37,  9, 26, 16, 21, 29, 11,  5, 32,
 33,  3,  0,  9,196, 11,225,  0,196,  1,224, 21,196, 19,163, 37,
 29, 25, 12,  9, 10,  5, 36, 22, 19,  2, 20,  0, 32, 25, 17, 10,
 15,  5, 37, 16,212, 60,204,252, 60,196, 50, 57, 57, 57, 57, 17,
 18, 57, 57, 18, 57, 49,  0, 16,252,236,244,236,244,236, 17, 23,
 57, 17, 57, 18, 57, 57, 17, 18, 57, 17, 18, 57, 57, 48,  5, 21,
 35, 34, 38, 53, 53, 52, 38, 35, 35, 53, 51, 50, 54, 53, 53, 52,
 54, 51, 51, 21, 35, 34,  6, 21, 21, 20,  6,  7, 22, 22, 21, 21,
 20, 22, 51,  4,178,217,218,200,108,142, 61, 61,142,108,200,218,
217, 69,141, 85, 90,110,111, 89, 85,141,109,225,176,193,192,150,
117,223,116,150,205,193,175,225, 87,142,166,157,142, 25, 27,142,
156,166,143, 87,  0,  1,  1,  4,254, 29,  1,231,  6, 29,  0,  3,
  0, 17,182,  1,  0,  4,  0,  4,  2,  4, 16,212,236, 49,  0, 16,
212,204, 48,  1, 17, 35, 17,  1,231,227,  6, 29,248,  0,  8,  0,
  0,  1,  1,  0,254,178,  4,178,  6, 20,  0, 36,  0, 96, 64, 50,
 31, 37, 27, 22, 12, 15,  8, 27, 11, 21, 25, 15,  4,  5, 32,  3,
  0, 27,196, 25,225,  0,196, 35,224, 15,196, 17,163, 37, 28, 25,
 26,  8, 21, 15,  1, 35, 18,  4,  0, 26, 31, 21, 17, 16,  0, 11,
  4, 37, 16,212, 60,204, 50,252, 60,204, 17, 18, 57, 57, 57, 57,
 17, 57, 18, 57, 57, 49,  0, 16,252,236,244,236,244,236, 17, 23,
 57, 17, 18, 57, 57, 17, 57, 17, 57, 57, 17, 18, 57, 48,  5, 51,
 50, 54, 53, 53, 52, 54, 55, 38, 38, 53, 53, 52, 38, 35, 35, 53,
 51, 50, 22, 21, 21, 20, 22, 51, 51, 21, 35, 34,  6, 21, 21, 20,
  6, 35, 35,  1,  0, 70,140, 85, 90,111,111, 90, 85,140, 70,217,
218,200,108,142, 61, 61,142,108,200,218,217,109, 87,143,166,156,
142, 27, 25,142,157,166,142, 87,225,175,193,205,150,116,223,117,
150,192,193,176,  0,  1,  0,217,  1,178,  5,219,  3, 82,  0, 29,
  0, 35, 64, 16,  1, 16, 27, 12,  0, 19,  4,167, 27, 12,167, 19,
 30,  0, 15, 30, 16,212,196, 49,  0, 16,212,236,220,236, 16,192,
 17, 18, 57, 57, 48,  1, 21,  6,  6, 35, 34, 39, 38, 39, 38, 39,
 38, 35, 34,  6,  7, 53, 54, 54, 51, 50, 23, 22, 23, 22, 23, 22,
 51, 50, 54,  5,219,106,179, 96,107,143, 14,  8,  7, 15,155, 94,
 88,172, 98,107,178, 96,107,143, 15,  7,  7, 15,155, 94, 86,169,
  3, 82,244, 80, 69, 58,  6,  3,  3,  6, 61, 77, 83,244, 80, 69,
 58,  6,  3,  3,  6, 61, 75,  0,255,255,  0, 10,  0,  0,  6, 39,
  7,107,  2, 39,  0, 36,  0,  0,  0,  0,  0,  7,  1,  3,  1,  0,
  1,117,  0,  3,  0, 10,  0,  0,  6, 39,  7,109,  0, 18,  0, 30,
  0, 33,  1,123, 64, 83,  3, 29,  1,  0,  2, 29,  1,  1,  0, 33,
 29, 31, 33,  0,  1,  0, 32, 29,  1,  1,  0,  5, 29,  7,  6,  4,
 29,  7,  6, 31, 29,  6,  7,  6, 33, 29, 32, 33,  7,  7,  6, 37,
 33,  7,  0, 22,  3,174, 31, 28,226, 13, 22,143, 31,  5,  1, 33,
 19, 32,  0, 25, 16, 31,  7, 19,  5,  4, 10,  6,  3,  2,  1, 25,
 85, 16,  1, 19, 85, 10,  1,  6, 34, 16,212,196,212,236, 16,212,
238, 18, 57, 57, 17, 18, 57, 57, 17, 57, 57, 17, 18, 57, 57, 17,
 57, 49,  0, 47, 60,198,230,214,238, 16,238, 18, 57, 57, 57, 48,
 75, 83, 88,  7, 16,  8,237,  7, 16,  5,237,  7,  5,237,  7,  5,
237,  7, 16,  5,237,  7, 16,  8,237,  7, 16,  5,237,  7,  5,237,
 89, 34,  1, 75,176, 10, 84, 88,189,  0, 34,255,192,  0,  1,  0,
 34,  0, 34,  0, 64, 56, 17, 55, 56, 89, 64,192,  0, 21,  0, 22,
  0, 23, 47, 33, 47, 33, 58, 33,111, 33,127,  3,127,  4,127, 31,
127, 32,182,  9,182, 17,186, 19,183, 20,176, 21,176, 22,176, 23,
183, 24,186, 25,186, 26,191, 27,191, 28,191, 29,186, 30,191, 33,
191, 33, 27,  6,  1,  9,  6, 23,  1, 25,  6, 31, 35, 32,  9, 32,
 10, 32, 11, 47, 15, 47, 16, 47, 17, 32, 19, 32, 20, 47, 24, 47,
 25, 47, 26, 32, 30, 34, 31, 43, 32, 32, 35, 69,  0, 75,  7, 85,
  0, 90,  7, 96,  9, 96, 10, 96, 11,111, 15,111, 16,111, 17, 96,
 19, 96, 20,111, 24,111, 25,111, 26, 96, 30,102, 31,105, 32, 96,
 35,116,  0,117,  3,121,  4,122,  7,123, 31,116, 32,133,  0,138,
  7,133, 31,138, 32,149,  0,154,  7,176,  9,176, 10,176, 11,176,
 12,191, 14,191, 15,191, 16,191, 17,176, 19,176, 20,191, 24,191,
 25,191, 26,183, 29,176, 30,179, 31,188, 32, 68, 93,  0, 93,  9,
  1, 33,  3, 33,  3, 33,  1, 46,  1, 53, 52, 54, 51, 50, 22, 21,
 20,  6, 37, 20, 22, 51, 50, 54, 53, 52, 38, 35, 34,  6,  3, 33,
  3,  4,  8,  2, 31,254,125, 94,253,166, 95,254,125,  2, 31, 23,
 22,167,118,116,168, 22,254,119, 77, 54, 54, 77, 78, 53, 54, 77,
 74,  1,153,204,  5,184,250, 72,  1, 16,254,240,  5,184, 34, 75,
 43,117,168,168,117, 47, 76,123, 54, 77, 77, 54, 54, 77, 77,251,
159,  2, 82,  0,255,255,  0,102,254,111,  5, 92,  5,240,  2, 39,
  0, 38,  0,  0,  0,  0,  0,  7,  0,221,  1,115,  0,  0,255,255,
  0,188,  0,  0,  4,225,  7,107,  2, 39,  0, 40,  0,  0,  0,  0,
  0,  7,  1,  4,  0,180,  1,117,255,255,  0,188,  0,  0,  5,246,
  7,109,  2, 39,  0, 49,  0,  0,  0,  0,  0,  7,  1,  5,  1, 53,
  1,117,255,255,  0,102,255,227,  6,102,  7,107,  2, 39,  0, 50,
  0,  0,  0,  0,  0,  7,  1,  3,  1, 78,  1,117,255,255,  0,188,
255,227,  5,195,  7,107,  2, 39,  0, 56,  0,  0,  0,  0,  0,  7,
  1,  3,  1, 39,  1,117,255,255,  0, 88,255,227,  4,197,  6,102,
  2, 39,  0, 68,  0,  0,  0,  0,  0,  7,  0,141,  0,186,  0,  0,
255,255,  0, 88,255,227,  4,197,  6,102,  2, 39,  0, 68,  0,  0,
  0,  0,  0,  7,  0, 67,  0,186,  0,  0,255,255,  0, 88,255,227,
  4,197,  6,102,  2, 39,  0, 68,  0,  0,  0,  0,  0,  7,  0,215,
  0,186,  0,  0,255,255,  0, 88,255,227,  4,197,  6, 49,  2, 39,
  0, 68,  0,  0,  0,  0,  0,  7,  0,142,  0,186,  0,  0,255,255,
  0, 88,255,227,  4,197,  6, 57,  2, 39,  0, 68,  0,  0,  0,  0,
  0,  7,  0,216,  0,186,  0,  0,255,255,  0, 88,255,227,  4,197,
  7, 27,  2, 39,  0, 68,  0,  0,  0,  0,  0,  7,  0,220,  0,186,
  0,  0,255,255,  0, 88,254,111,  4, 53,  4,123,  2, 39,  0, 70,
  0,  0,  0,  0,  0,  7,  0,221,  0,184,  0,  0,255,255,  0, 88,
255,227,  5, 10,  6,102,  2, 39,  0, 72,  0,  0,  0,  0,  0,  7,
  0,141,  0,217,  0,  0,255,255,  0, 88,255,227,  5, 10,  6,102,
  2, 39,  0, 72,  0,  0,  0,  0,  0,  7,  0, 67,  0,217,  0,  0,
255,255,  0, 88,255,227,  5, 10,  6,102,  2, 39,  0, 72,  0,  0,
  0,  0,  0,  7,  0,215,  0,217,  0,  0,255,255,  0, 88,255,227,
  5, 10,  6, 49,  2, 39,  0, 72,  0,  0,  0,  0,  0,  7,  0,142,
  0,217,  0,  0,255,255,  0,172,  0,  0,  3, 25,  6,102,  2, 39,
  0,214,  0,  0,  0,  0,  0,  7,  0,141,255,119,  0,  0,255,255,
255,213,  0,  0,  2, 18,  6,102,  2, 39,  0,214,  0,  0,  0,  0,
  0,  7,  0, 67,255,119,  0,  0,255,255,255,254,  0,  0,  2,240,
  6,102,  2, 39,  0,214,  0,  0,  0,  0,  0,  7,  0,215,255,119,
  0,  0,255,255,  0, 60,  0,  0,  2,178,  6, 49,  2, 39,  0,214,
  0,  0,  0,  0,  0,  7,  0,142,255,119,  0,  0,255,255,  0,172,
  0,  0,  5, 18,  6, 57,  2, 39,  0, 81,  0,  0,  0,  0,  0,  7,
  0,216,  0,242,  0,  0,255,255,  0, 88,255,227,  5, 39,  6,102,
  2, 39,  0, 82,  0,  0,  0,  0,  0,  7,  0,141,  0,215,  0,  0,
255,255,  0, 88,255,227,  5, 39,  6,102,  2, 39,  0, 82,  0,  0,
  0,  0,  0,  7,  0, 67,  0,215,  0,  0,255,255,  0, 88,255,227,
  5, 39,  6,102,  2, 39,  0, 82,  0,  0,  0,  0,  0,  7,  0,215,
  0,215,  0,  0,255,255,  0, 88,255,227,  5, 39,  6, 49,  2, 39,
  0, 82,  0,  0,  0,  0,  0,  7,  0,142,  0,215,  0,  0,255,255,
  0, 88,255,227,  5, 39,  6, 57,  2, 39,  0, 82,  0,  0,  0,  0,
  0,  7,  0,216,  0,215,  0,  0,255,255,  0,160,255,227,  5,  6,
  6,102,  2, 39,  0, 88,  0,  0,  0,  0,  0,  7,  0,141,  0,242,
  0,  0,255,255,  0,160,255,227,  5,  6,  6,102,  2, 39,  0, 88,
  0,  0,  0,  0,  0,  7,  0, 67,  0,242,  0,  0,255,255,  0,160,
255,227,  5,  6,  6,102,  2, 39,  0, 88,  0,  0,  0,  0,  0,  7,
  0,215,  0,242,  0,  0,255,255,  0,160,255,227,  5,  6,  6, 49,
  2, 39,  0, 88,  0,  0,  0,  0,  0,  7,  0,142,  0,242,  0,  0,
  0,  1,  0, 53,255, 59,  3,195,  5,213,  0, 11,  0, 42, 64, 22,
  8,  4,229,  2,  6,227,  0,141, 10,  2,228, 12,  3, 87,  5,  1,
 86,  9, 87,  7,  0, 12, 16,212, 60,228,252, 60,228, 49,  0, 16,
228, 50,244,236, 16,238, 50, 48,  1, 33, 17, 33, 21, 33, 17, 33,
 17, 33, 53, 33,  1, 86,  1, 74,  1, 35,254,221,254,182,254,223,
  1, 33,  5,213,254,131,238,251,209,  4, 47,238,  0,  2,  0,178,
  3,100,  3, 76,  5,254,  0, 11,  0, 29,  0, 31, 64, 16,  6,230,
 24,231,  0,230, 12, 30,  9, 88, 18, 89,  3, 88, 27, 30, 16,212,
236,252,236, 49,  0, 16,212,236,252,236, 48,  1, 34,  6, 21, 20,
 22, 51, 50, 54, 53, 52, 38, 39, 50, 22, 23, 22, 22, 21, 20,  6,
  7,  6,  6, 35, 34, 38, 53, 52, 54,  2,  0, 72,100, 99, 73, 72,
100,101, 71, 66,122, 48, 47, 49, 49, 45, 48,124, 68,141,191,193,
  5, 92,100, 72, 72, 98, 99, 71, 72,100,162, 51, 47, 48,120, 68,
 67,121, 45, 48, 51,191,141,141,193,  0,  0,  2,  0,174,254,199,
  4,137,  5,152,  0,  6,  0, 35,  0, 87, 64, 46, 24, 20, 17,  6,
 16, 13,  0, 11,  7,204,  8,212, 11, 17,204, 16,212, 13,161, 20,
 31, 11,161, 33, 30,202, 20,152, 22, 36, 20, 11,  7, 32, 21, 12,
  7, 16,  7, 30, 23,  0,  3, 66, 27, 36, 16,212,252,212, 60, 60,
196, 50,236, 50, 50, 17, 57, 57, 49,  0, 16,196,228,244, 60,236,
196, 16,254,244,238, 16,245,238, 18, 57, 17, 18, 57, 17, 18, 57,
 48,  1,  6,  6, 21, 20, 22, 23,  1, 17, 38, 38, 35, 35, 17, 54,
 54, 55, 17,  6,  6, 35, 35, 17, 35, 17, 36,  0, 17, 52,  0, 37,
 17, 51, 19, 22, 22,  2,190, 78, 77, 77, 78,  1,203, 74,143, 65,
 15, 89,151, 57, 83,146, 58, 10,162,254,250,254,246,  1, 14,  1,
  2,162,  1, 71,147,  3, 90, 44,147,108,109,148, 42,  3, 57,254,
220, 48, 50,253,105,  1, 50, 47,254,219, 30, 32,254,228,  1, 32,
 40,  1, 46,  1,  2,244,  1, 35, 35,  1, 31,254,225,  3, 29,  0,
  0,  1,  0,125,  0,  0,  4,231,  5,240,  0, 27,  0, 64, 64, 33,
 22,  7,  8,  0,150,  1,149,  4, 18, 10,159,  8,  4,172, 25,156,
 16, 12,172, 20,  8, 14,  0, 13,  9, 11,  7, 26, 15, 19, 21, 17,
 28, 16,212, 60,196,196,252, 60,196,212,196, 49,  0, 47,196, 50,
236, 50,244,236, 16,238, 50, 16,245,238, 18, 57, 57, 48,  1, 17,
 38, 38, 35, 34,  6, 21, 21, 33, 21, 33, 17, 33, 17, 33, 17, 51,
 17, 35, 53, 51, 53, 16, 54, 33, 50, 22,  4,219, 70,148, 77,118,
113,  1,117,254,139,  2, 26,251,150,227,194,194,254,  1, 19, 92,
181,  5,186,254,226, 39, 38,125,131,170,239,254,186,254,246,  1,
 10,  1, 70,239,170,  1, 15,248, 27,  0,  0,  2,  0, 14,255, 61,
  3,248,  5,240,  0, 51,  0, 63,  0,107, 64, 56, 26, 64, 23,  0,
 49,  4, 58, 52, 11, 17, 37, 43,  4, 27,  1,  4, 27, 30,232, 23,
  4,232, 49,156, 23, 64, 11, 61, 33, 43, 26, 37, 55, 52, 58, 33,
  7, 17, 61,  0,  7, 92, 46, 33, 92, 20, 61, 91,  0, 14, 46, 55,
 91, 26, 40, 64, 16,220,196,236,196,212,196,236,212,236, 16,238,
 17, 18, 57, 17, 18, 57, 57, 18, 57, 17, 57, 17, 18, 57, 49,  0,
 16,196,244,236, 16,254,197, 16,197, 17, 23, 57, 57, 57, 17, 18,
 57, 17, 18, 57, 48,  1, 21, 38, 38, 35, 34,  6, 21, 20, 23, 22,
 23, 22, 22, 21, 20,  6,  7, 22, 22, 21, 20,  6, 35, 34, 38, 39,
 53, 22, 22, 51, 50, 54, 53, 52, 39, 38, 39, 38, 38, 53, 52, 54,
 55, 38, 38, 53, 52, 54, 51, 50, 22,  1,  6,  6, 21, 20, 22, 23,
 54, 54, 53, 52, 38,  3,117, 99,158, 57, 75, 76,188, 26, 13,210,
159,113,117, 77, 75,242,213, 85,181,102,115,182, 57, 65, 78,180,
 36, 19,203,160,111,113, 75, 65,229,201, 84,180,254,154, 68, 67,
123,182, 65, 70,138,  5,182,227, 39, 39, 49, 47, 67, 79, 11,  5,
 89,173,125,117,159, 48, 41,113, 73,145,167, 29, 29,237, 41, 43,
 50, 40, 70, 74, 14,  8, 87,179,130,104,154, 51, 51,111, 75,144,
162, 29,253,133, 28, 76, 50, 67, 98, 66, 23, 79, 52, 67,106,  0,
  0,  1,  1, 39,  1,145,  3,246,  4, 96,  0, 23,  0, 18,183, 18,
233,  6, 24, 12, 93,  0, 24, 16,212,236, 49,  0, 16,212,236, 48,
  1, 52, 54, 55, 54, 54, 51, 50, 22, 23, 22, 22, 21, 20,  6,  7,
  6,  6, 35, 34, 38, 39, 38, 38,  1, 39, 53, 51, 53,130, 73, 73,
131, 50, 52, 53, 54, 51, 51,131, 74, 73,130, 51, 50, 54,  2,250,
 74,130, 50, 51, 53, 54, 50, 52,129, 73, 74,131, 51, 51, 54, 54,
 51, 51,131,  0,  0,  1,  0,129,255, 59,  4,100,  5,213,  0, 13,
  0, 38, 64, 18,  4,  8,  0,141,  6,  2, 14,  0,  5, 11,  7,  1,
 94,  3,  7, 94,  5, 14, 16,212,236,212,236, 16,196, 18, 57, 49,
  0, 16,196, 50,244,196,204, 48,  1, 33, 17, 35, 17, 35, 17, 35,
 17, 38, 38, 53, 52, 36,  2, 92,  2,  8,190,189,190,204,222,  1,
  4,  5,213,249,102,  6,  7,249,249,  3, 78, 25,219,178,190,232,
  0,  1,  0,172,255,227,  5,104,  6, 20,  0, 48,  0,106, 64, 52,
 46, 40, 34, 13,  7,  5, 14, 33,  6,  0,  4, 43, 23,159, 24, 27,
159, 20, 43,159,  3,163, 20,152, 47, 34, 23, 33, 24,  3, 40, 37,
 13, 14, 30,  6, 10, 97, 37, 46, 40, 97,  6, 95, 30, 13, 17, 46,
 13,  0, 16, 49, 16,252,236,212,236,244,236, 16,221,238, 17, 18,
 57, 57, 17, 18, 23, 57, 57, 49,  0, 47,228,254,238, 16,254,213,
238, 18, 23, 57, 23, 57, 48, 64, 13,  0, 23,  0, 24, 47, 50, 79,
 50,112, 50,159, 50,  6,  1, 93, 19, 52, 36, 33, 32,  4, 29,  1,
 14,  1, 21, 20, 22, 31,  1, 30,  1, 21, 20,  6, 35, 34, 38, 39,
 53, 30,  1, 51, 50, 54, 53, 52, 38, 47,  1, 46,  1, 53, 52, 54,
 55, 46,  1, 35, 34,  6, 21, 17, 33,172,  1, 14,  1, 17,  1,  6,
  1, 12,151,144, 49, 93, 69,116,107,229,231, 65,138, 74, 56,115,
 54, 72, 88, 55, 98, 70, 88, 84,139,145,  1, 96, 91,101,102,254,
154,  4, 90,222,220,224,218, 71, 10, 78, 74, 37, 57, 52, 37, 64,
169,117,189,188, 25, 24,244, 27, 28, 72, 57, 47, 68, 55, 39, 49,
135, 90,116,158, 50, 85, 89,110,109,251,180,  0,  0,  4,  1, 27,
  0,  0,  6,229,  5,205,  0, 23,  0, 32,  0, 52,  0, 76,  0, 98,
 64, 56, 45, 42, 43, 39, 26,238, 48, 24,238, 33,235,  0,230, 53,
237, 12,230, 50, 43,235, 65, 39, 42, 44,  3, 36, 48, 45, 24, 27,
  4, 30, 25, 43, 36, 18, 33, 30, 49, 25,103, 51, 30,102, 36, 99,
 18, 88, 59,101,  6, 88, 51, 99, 71, 77, 16,212,236,236,252,236,
252,236, 16,238, 50, 17, 57, 17, 18, 57, 17, 18, 23, 57, 17, 23,
 57, 49,  0, 47,236, 50,238,254,238,252,238,214,238, 57, 18, 57,
 57, 48,  1, 34,  6,  7,  6,  6, 21, 20, 22, 23, 22, 22, 51, 50,
 54, 55, 54, 54, 53, 52, 38, 39, 38, 38,  3, 35, 21, 51, 50, 54,
 53, 52, 38, 39, 50, 22, 21, 20,  6,  7, 22, 22, 23, 23, 35, 39,
 38, 38, 35, 35, 17, 35, 17,  1, 50,  4, 23, 22, 18, 21, 20,  2,
  7,  6,  4, 35, 34, 36, 39, 38,  2, 53, 52, 18, 55, 54, 36,  4,
  0,121,208, 87, 87, 87, 87, 87, 86,209,121,123,206, 87, 87, 87,
 87, 87, 88,207,178, 35, 35, 78, 79, 77, 43,176,174,105, 96, 41,
 71, 29,111,229,107, 38, 58, 29, 12,213,  1, 49,152,  1,  7,109,
109,108,108,109,109,254,249,152,152,254,249,109,109,108,108,109,
109,  1,  7,  5, 51, 87, 87, 87,207,122,121,207, 87, 86, 86, 85,
 87, 87,207,121,122,207, 87, 88, 86,254,217,207, 53, 52, 52, 50,
138,119,121, 86,112, 17, 22, 80, 58,221,213, 78, 65,254,156,  3,
 68,  1, 55,110,109,109,254,250,154,152,254,251,109,109,110,110,
109,109,  1,  5,152,154,  1,  6,109,109,110,  0,  0,  3,  1, 27,
  0,  0,  6,229,  5,205,  0, 25,  0, 49,  0, 73,  0, 72, 64, 40,
 14, 17, 10,  0, 23,  4, 13, 10,239, 17,  1,  4,239, 23,235, 26,
230, 50,237, 38,230, 17,235, 62,  7,102, 20, 44, 88, 13,  0, 99,
 56,101, 32, 88, 20,104, 68, 74, 16,212,236,236,252,236, 50,236,
 16,238, 49,  0, 47,236,238,254,238,252,254,197, 16,254,196, 17,
 18, 57, 17, 18, 57, 48,  1, 21, 38, 38, 35, 34,  6, 21, 20, 22,
 51, 50, 54, 55, 21,  6,  6, 35, 34, 38, 53, 52, 54, 51, 50, 22,
 39, 34,  6,  7,  6,  6, 21, 20, 22, 23, 22, 22, 51, 50, 54, 55,
 54, 54, 53, 52, 38, 39, 38, 38, 39, 50,  4, 23, 22, 18, 21, 20,
  2,  7,  6,  4, 35, 34, 36, 39, 38,  2, 53, 52, 18, 55, 54, 36,
  5, 43, 57,111, 57,113,127,126,114, 64,115, 46, 65,131, 62,211,
254,254,211, 69,128,238,121,208, 87, 87, 87, 87, 87, 86,209,121,
123,206, 87, 87, 87, 87, 87, 88,207,121,152,  1,  7,109,109,108,
108,109,109,254,249,152,152,254,249,109,109,108,108,109,109,  1,
  7,  4,102,215, 37, 35,128,114,115,126, 36, 35,213, 22, 23,234,
194,195,233, 21,183, 87, 87, 87,207,122,121,207, 87, 86, 86, 85,
 87, 87,207,121,122,207, 87, 88, 86,154,110,109,109,254,250,154,
152,254,251,109,109,110,110,109,109,  1,  5,152,154,  1,  6,109,
109,110,  0,  2,  1, 39,  3,147,  6, 82,  5,213,  0, 12,  0, 20,
  0,118, 64, 62,  2,  6,  7,  6,  1,  0,  1,  7,  7,  6,  1,  2,
  1,  8,  9,  8,  0,  9,  9,  8, 37,  1,  7,  9,  6, 14,  0,  7,
 16, 10,  4, 18, 14,238, 13,  2,  0,141, 21,  8,  7,  2,  1,  0,
  5,  9,  5, 19,106, 17,  5,105,  3,  9,105, 11, 13,106, 17,105,
 15, 21, 16,212,236,228,212,236,212,236, 16,228, 17, 18, 23, 57,
 49,  0, 16,244, 60, 60,236, 50,212, 60, 60,196, 17, 18, 57, 57,
 17, 57, 48, 75, 83, 88,  7, 16,  5,201,  7, 16,  8,201,  7, 16,
  8,201,  7, 16,  5,201, 89, 34,  1, 23, 55, 51, 17, 35, 17,  3,
 35,  3, 17, 35, 17, 35, 21, 35, 17, 35, 17, 35, 53,  4,129,119,
119,227,170,137, 76,137,172,113,174,172,172,  5,213,227,227,253,
190,  1,181,255,  0,  1,  0,254, 75,  2, 66,143,254, 77,  1,179,
143,  0,  0,  1,  1,109,  4,238,  3,162,  6,102,  0,  3,  0, 55,
183,  2,198,  0,197,  4,  1,  3,  4, 16,212,204, 49,  0, 16,244,
236, 48,  0, 75,176,  9, 84, 75,176, 14, 84, 91, 88,189,  0,  4,
255,192,  0,  1,  0,  4,  0,  4,  0, 64, 56, 17, 55, 56, 89,180,
 21,  1, 21,  2,  2,  1, 93,  1, 33,  1, 35,  2,135,  1, 27,254,
143,196,  6,102,254,136,  0,  2,  0,197,  5, 59,  3, 59,  6, 49,
  0,  3,  0,  7,  0, 92, 64, 14,  6,  2,241,  4,  0,240,  8,  5,
 18,  4,  1, 18,  0,  8, 16,212,252,212,236, 49,  0, 16,244, 60,
236, 50, 48,  0, 75,176, 10, 84, 75,176, 11, 84, 91, 75,176, 15,
 84, 91, 75,176, 19, 84, 91, 88,189,  0,  8,  0, 64,  0,  1,  0,
  8,  0,  8,255,192, 56, 17, 55, 56, 89,  1, 75,176, 12, 84, 88,
189,  0,  8,255,192,  0,  1,  0,  8,  0,  8,  0, 64, 56, 17, 55,
 56, 89, 19, 51, 21, 35, 37, 51, 21, 35,197,235,235,  1,139,235,
235,  6, 49,246,246,246,  0,  1,  0,217,255,246,  5,219,  5, 12,
  0, 19,  0, 61, 64, 33, 13, 20, 10,  3,  2,  0, 12,  4,  0,167,
 18,  6,182, 14, 10,167, 16,  8, 20, 18, 14, 13, 12,  8,  4,  3,
  2,  8,  9,  5, 15,  0, 20, 16,212, 60,196, 50, 23, 57, 49,  0,
 16,212, 60,236, 50,252, 60,236, 50, 46, 16,192, 57, 17, 18, 57,
 48, 19, 33, 19, 23,  7, 51, 21, 33,  7, 33, 21, 33,  3, 39, 55,
 35, 53, 33, 55, 33,217,  3, 23,252,149,145,235,254, 94,174,  2,
 80,252,234,252,150,146,236,  1,168,176,253,168,  3,219,  1, 49,
125,180,235,220,237,254,207,127,178,237,220,  0,  0,  2,  0,  0,
  0,  0,  8, 25,  5,213,  0,  3,  0, 19,  0,161, 64, 55,  1, 29,
  4, 19,  0, 29,  4,  4, 19, 18, 29,  4, 19, 17, 29, 19,  4, 19,
 37,  0,  6,  4,  8,192, 10, 16,174,  1,  6,192, 10,190,  4,141,
 12,192,  1, 18, 14, 18, 17,  4,  1,  0,  5, 19, 11,  7, 22, 15,
  2,  5,  9, 13, 19, 47,212,196,196,212, 60,236, 50, 18, 23, 57,
 49,  0, 47, 60,196,236,244,228,236, 16,238, 16,238, 17, 18, 57,
 48, 75, 83, 88,  7, 16,  5,237,  7,  5,237,  7, 16,  5,237,  7,
  5,237, 89, 34,  1, 75,176,  9, 84, 75,176, 10, 84, 91, 88,189,
  0, 20,255,192,  0,  1,  0, 20,  0, 20,  0, 64, 56, 17, 55, 56,
 89, 64, 25,  3,  0, 22,  0, 21,  1, 25,  4, 38,  1, 87,  1,134,
  0,134,  1,179,  0,179,  1,181, 17,181, 18, 12, 93,  9,  1, 33,
 17,  1, 33, 17, 33, 17, 33, 17, 33, 17, 33, 17, 33, 17, 33,  3,
 33,  3,123,255,  0,  1,121,254,125,  5,145,253,115,  2,102,253,
154,  2,164,251,219,254, 18,147,254,141,  4,213,253,158,  2, 98,
  1,  0,254,221,254,234,254,221,254,170,254,221,  1, 94,254,162,
  0,  3,  0, 45,255,182,  6,150,  6, 31,  0,  9,  0, 19,  0, 43,
  0,232, 64, 62, 29, 31, 26, 13, 43, 44, 19, 10,  9,  0,  4,  3,
 32, 26, 13, 41, 20,  3, 42, 38, 30, 26,  3,174, 38, 13,174, 26,
156, 38,152, 44, 43, 44, 42, 20, 23, 16, 32, 30, 35, 19, 10,  9,
  0,  4,  6, 41, 23, 16, 29,  6, 31,  6, 45, 35, 55, 16, 45, 23,
 43, 44, 16,252,236,252,236,192, 18, 57, 17, 18, 57, 18, 23, 57,
 17, 57, 57, 17, 18, 57, 57, 17, 57, 49,  0, 16,228,244,236, 16,
238, 16,192, 16,192, 18, 57, 57, 17, 18, 57, 18, 23, 57, 17, 57,
 17, 18, 57, 57, 48, 64,112,  0, 45, 23,  0, 25, 10, 16, 45, 42,
 21, 39, 29, 38, 33, 47, 45, 57, 21, 55, 29, 54, 33, 57, 41, 63,
 45, 71, 29, 89, 21, 86, 28, 84, 33, 89, 40, 89, 41,106, 21,101,
 25,103, 28,101, 33,106, 37,106, 40, 25, 24, 24, 23, 36, 39, 29,
 41, 41, 54, 29, 56, 41, 75, 20, 70, 29, 69, 32, 73, 41, 90, 20,
 94, 21, 83, 28, 86, 29, 86, 32, 84, 33, 86, 34, 91, 40,106,  9,
101, 19,106, 20,108, 21, 97, 28,102, 32, 99, 33,107, 40,120,  9,
153,  9,152, 10,170,  9, 30, 93,  1, 93,  1, 30,  1, 51, 50, 18,
 53, 52, 38, 47,  1, 46,  1, 35, 34,  2, 21, 20, 22, 23,  1, 46,
  1, 53, 16,  0, 33, 50, 22, 23, 55, 23,  7, 30,  1, 21, 16,  0,
 33, 34, 38, 39,  7, 39,  2, 92, 52,131, 83,177,194, 15, 16, 77,
 51,130, 82,176,194, 14, 14,254,234, 74, 74,  1,153,  1,103,154,
248,102,199,113,201, 77, 76,254,104,254,152,153,255,102,202,113,
  1,115, 62, 59,  1,  4,235, 68,117, 49,147, 58, 57,254,252,236,
 64,113, 46,254,234,100,250,151,  1,107,  1,156, 75, 77,199,115,
199, 99,255,154,254,150,254,100, 79, 79,203,113,  0,  3,  0,195,
  0,186,  5,233,  4,  8,  0, 11,  0, 23,  0, 47,  0, 66, 64, 35,
 12, 15,  3, 27,  9,  0, 36, 24,  4, 21, 15, 39, 33, 21,243, 45,
 27,244, 15,243, 33,242, 48, 12,  0, 36, 24, 18,  6,107, 42, 18,
107, 30, 48, 16,212,236,212,236, 17, 57, 57, 57, 57, 49,  0, 16,
252,236,252, 60,236, 16,192, 17, 18, 23, 57, 17, 57, 17, 57, 48,
  1, 22, 22, 51, 50, 54, 53, 52, 38, 35, 34,  6,  5, 38, 38, 35,
 34,  6, 21, 20, 22, 51, 50, 54, 23,  6,  6, 35, 34, 38, 53, 52,
 54, 51, 50, 22, 23, 54, 54, 51, 50, 22, 21, 20,  6, 35, 34, 38,
  3,188, 43,118, 73, 90,113,103, 76, 72,119,254,241, 43,116, 75,
 90,113,102, 77, 71,122,169, 68,159, 97,139,198,175,140, 90,153,
 99, 71,158, 95,140,197,175,140, 91,150,  2, 49, 67, 68,101, 79,
 77,101,101, 26, 67, 67,100, 79, 77,101,105, 97,130,126,243,179,
188,234,113,143,132,126,242,180,189,235,110,  0,  0,  2,  0,217,
  0,  0,  5,219,  5,  4,  0, 11,  0, 15,  0, 46, 64, 24,  5,245,
  7,  3,167,  0,245,  9,  1, 12,167, 14, 13,  2,108,  4,  0, 18,
 12,  8,108, 10,  6, 16, 16,212, 60,236, 50,252, 60,236, 50, 49,
  0, 47,236,212, 60,236,252, 60,236, 48,  1, 17, 33, 21, 33, 17,
 35, 17, 33, 53, 33, 17,  1, 33, 21, 33,  3,209,  2, 10,253,246,
238,253,246,  2, 10,253,246,  5,  2,250,254,  5,  4,254,158,236,
254,158,  1, 98,236,  1, 98,251,234,238,  0,  2,  0,217,  0,  0,
  5,219,  4,168,  0,  3,  0, 10,  0, 39, 64, 20,  9,  8,  6,  5,
  4,  5, 10,  7,  0,167, 10,246,  1,  5,  6,  4,  0,  8,  2, 11,
 16,212, 60,196, 50, 50, 57, 49,  0, 47,228,252,204, 17, 23, 57,
 48, 37, 21, 33, 53,  1,  5,  5, 21,  1, 53,  1,  5,219,250,254,
  5,  2,252,127,  3,129,250,254,  5,  2,238,238,238,  2,198,209,
209,243,  1, 80,235,  1, 78,  0,  0,  2,  0,217,  0,  0,  5,219,
  4,168,  0,  3,  0, 10,  0, 39, 64, 20, 10,  9,  7,  6,  4,  5,
  5,  8,  0,167,  5,246,  2, 10,  6,  1,  8,  4,  0, 11, 16,212,
 60, 60,196, 50, 57, 49,  0, 47,228,252,196, 17, 23, 57, 48, 55,
 33, 21, 33, 17, 53,  1, 21,  1, 53, 37,217,  5,  2,250,254,  5,
  2,250,254,  3,129,238,238,  3,180,244,254,178,235,254,176,243,
209,  0,  0,  1,  0, 25,  0,  0,  5,121,  5,213,  0, 24,  0,180,
 64, 66, 16, 29, 17, 18, 17, 15, 29,  0, 15, 18, 18, 17, 15, 29,
 16, 15, 12, 13, 12, 14, 29, 13, 13, 12, 37, 15, 13, 11,  4,  0,
247, 23,  6, 20,  9,247, 18, 11, 16, 13,141,  2,  9, 12,  5, 15,
  3, 21, 18,  0, 17,110, 19,  0,109, 22,  1, 26, 13,110, 10,  5,
109,  7,  3, 25, 16,212, 60,236, 50,236,252, 60,236, 50,236, 18,
 57, 57, 18, 57, 17, 57, 57, 49,  0, 47,228, 50,212, 60,252, 60,
212, 60,236, 50, 17, 18, 57, 48, 75, 83, 88,  7, 16,  5,237,  7,
 16,  8,237,  7, 16,  8,237,  7, 16,  5,237, 89, 34,178,  0, 15,
  1,  0, 93, 64, 44,  5, 14, 10, 16, 20, 14, 27, 16, 36, 14, 43,
 16, 54, 14, 58, 16, 70, 14, 73, 16, 10, 16, 15, 16, 15, 32, 15,
 32, 15, 48, 15, 64, 15,128, 15,128, 15,144, 15,176, 15,176, 15,
 11, 93,  1, 93,  1, 33, 17, 33, 17, 33, 53, 33, 53, 39, 33, 53,
 33,  1, 33,  9,  1, 33,  1, 33, 21, 33,  7, 21, 33,  5, 78,254,
 57,254,131,254, 58,  1,198, 49,254,107,  1, 36,254,177,  1,143,
  1, 33,  1, 32,  1,144,254,176,  1, 37,254,106, 49,  1,199,  1,
160,254, 96,  1,160,194, 66, 86,192,  2, 27,254, 51,  1,205,253,
229,192, 86, 66,  0,  1,  0,174,254, 84,  5,162,  4, 96,  0, 32,
  0, 58, 64, 33, 18, 15, 12,  9,  3,  5,  1, 19, 25, 31,  3,  6,
219, 28, 22,152, 10,  1,179,  0,222, 33, 25,  9, 13, 18, 11, 31,
  2, 13,  0, 16, 33, 16,252,236, 50,220,196,236, 57, 49,  0, 16,
228,228, 50,244, 60,236, 23, 57, 17, 23, 57, 48, 19, 17, 33, 17,
 20, 22, 51, 50, 54, 53, 17, 33, 17, 20, 22, 51, 50, 54, 55, 21,
  6,  6, 35, 34, 38, 39,  6,  6, 35, 34, 38, 39, 17,174,  1,105,
100,102,103,100,  1,104, 33, 39, 18, 33, 19, 53, 93, 45, 89,113,
 35, 47,135, 89, 74,104, 30,254, 84,  6, 12,253,117,116,113,113,
116,  2,139,253, 19, 71, 56, 10, 12,250, 23, 22, 75, 83, 79, 79,
 47, 48,254, 18,  0,  2,  0, 59,255,231,  4, 31,  5, 82,  0, 29,
  0, 41,  0, 56, 64, 26,  0, 39, 33,  9, 27,  6, 39, 21,  6, 15,
 33, 27, 15, 21,249, 42, 12, 36, 24,  3,  0, 30, 18, 36, 24, 42,
 16,212,204,220,204, 57, 57, 17, 18, 57, 49,  0, 16,228,204,220,
204, 16,206, 16,206, 17, 18, 57, 17, 18, 57, 48,  1, 54, 54, 53,
 52, 38, 35, 34,  6, 35, 34, 38, 53, 52, 54, 51, 50, 18, 17, 16,
  0, 35, 34, 38, 53, 52, 18, 51, 50, 22,  7, 52, 38, 35, 34,  2,
 21, 20, 22, 51, 50, 18,  2,254, 21, 22, 59, 39, 35,194, 83, 48,
 64,186,127,210,245,254,187,255,182,234,239,179,101,139, 19, 73,
 68, 96,129, 73, 70, 97,126,  2,172,113,186, 57, 87,122,186, 67,
 50, 69,113,254,190,254,232,254,168,254, 71,233,183,203,  1, 10,
 85,243,114,124,254,239,210,116,120,  1, 15,  0,  0,  1,  0, 41,
254,119,  5,147,  5,193,  0, 11,  0, 79, 64, 24, 10,  4, 12,  2,
  5,251,  7,  2,251,  0,250,  7, 12, 10,  5,  3,  3,  0,  4,  6,
  1,  8,  0, 12, 16,212,196,220,196,196, 17, 23, 57, 49,  0, 16,
196,252,236, 16,238, 17, 18, 57, 57, 48, 64, 26,  9,  5, 22,  3,
 24,  4, 22,  5, 38,  3, 35,  5, 41, 10,  7, 25,  9, 41,  9, 40,
 10, 41, 11, 56,  9,  5, 93,  1, 93, 19, 33, 17, 33,  9,  1, 33,
 17, 33, 53,  9,  1, 66,  5, 28,252,146,  2,108,253,146,  3,165,
250,150,  2,186,253, 95,  5,193,254,247,253,123,253, 78,254,246,
172,  3,  4,  2,178,  0,  0,  1,  0,150,254,119,  5,178,  5,193,
  0,  7,  0, 30, 64, 15,  6,  2,253,  4,252,  0,250,  8,  3,112,
  1,  5,112,  0,  8, 16,212,236,212,236, 49,  0, 16,252,236,236,
 50, 48, 19, 33, 17, 33, 17, 33, 17, 33,150,  5, 28,254,168,253,
148,254,168,  5,193,248,182,  6, 41,249,215,  0,  0,  1,255,221,
  0,  0,  5, 74,  4, 68,  0, 17,  0, 47, 64, 26, 14, 13,  3,  9,
  5,  1,  0,  7,  3, 13, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1,
 11, 18, 17,  0, 14, 18, 16,212,204, 57, 17, 23, 57, 49,  0, 47,
 60,212,204, 50, 50, 17, 57, 57, 48,  1,  7, 35,  3, 33, 19, 35,
  3, 33, 19, 35, 34,  6,  7,  7, 54, 54, 51,  5, 74, 39,176,154,
254,225,152,238,151,254,225,152, 25, 55, 58, 10,213, 29,188,217,
  4, 68,224,252,156,  3,100,252,156,  3,100, 62, 68,  1,199,156,
  0,  1,  0, 51,254,139,  4,176,  6, 20,  0, 44,  0, 66,178, 42,
  0, 35,184,  1,  0,178,  0,255, 29,186,  1,  1,  0, 13,  1,  0,
 64, 22, 19,255,  7,254, 45, 16, 23, 10, 42, 40, 38,  3, 32,  4,
 10,113, 23,114, 32,113,  4, 45, 16,220,236,252,236, 17, 18, 23,
 57, 17, 18, 57, 49,  0, 16,252,236,236,252,236,236, 17, 57, 48,
  5, 50, 19, 54, 55, 18, 18, 51, 50, 22, 21, 20,  6, 35, 34, 38,
 53, 52, 38, 35, 34,  3,  6,  7,  2,  2,  7,  6,  6, 35, 34, 38,
 53, 52, 54, 51, 50, 22, 21, 20,  7, 20, 21, 20, 22,  1,106, 99,
 20,  3,  1, 17,227,236,105,130, 82, 65, 64, 65, 15, 18,101, 23,
  2,  1, 11, 39, 38, 62,195,132,107,129, 84, 70, 60, 65,  2, 16,
248,  2,155,101, 53,  2, 11,  1,204,106, 84, 64, 79, 77, 74, 38,
 22,253,101, 60, 31,254,183,254,225,101,166,166,104, 87, 65, 78,
 72, 67, 12, 12,  2,  1, 24, 19,  0,  3,  0,158,  1,117,  3,233,
  5,240,  0,  3,  0, 14,  0, 41,  0,159, 64, 16, 36, 39, 32, 13,
 10,  4, 29, 35, 27, 18, 16, 10, 15, 27,  4,  2,184,  1,  8,178,
  0,  4, 27, 65, 14,  1,  7,  0, 16,  1,  6,  0, 10,  1,  2,  0,
  0,  1,  5,  0, 21,  0, 35,  1,  3,  0, 32,  1,  2,  0, 21,  1,
  4, 64, 23, 39,156, 42,  0, 35, 24,  1, 15, 13,  4, 27, 29, 28,
  3,  7, 17,115, 15, 35,  7,115, 24, 42, 16,212,236,196,212,236,
 17, 23, 57, 57, 57, 17, 57, 17, 18, 57, 49,  0, 16,244,228,252,
228, 16,237,238,228,246,206, 16,238, 17, 18, 57, 17, 18, 57, 17,
 18, 57, 17, 18, 57, 17, 18, 57, 48, 64, 29, 63,  4, 63,  5, 59,
  6, 59,  7, 59,  8, 63, 13, 63, 14, 59, 23, 59, 24, 59, 25, 63,
 26, 63, 27, 63, 28, 59, 29, 14, 93, 19, 33, 21, 33,  1, 34,  6,
 21, 20, 22, 51, 50, 54, 61,  1, 37, 17, 35, 53, 14,  1, 35, 34,
 38, 53, 52, 54, 59,  1, 53, 52, 38, 35, 34,  6,  7, 53, 62,  1,
 51, 50, 22,176,  3, 45,252,211,  1,211,133,104, 66, 58, 89,114,
  1, 12,245, 55,140, 94,145,164,210,226,137, 89, 85, 87,166, 79,
 92,169, 75,224,216,  2, 61,200,  2,196, 52, 62, 51, 58,114, 87,
 22, 84,254, 64,127, 76, 72,134,116,141,132, 20, 56, 59, 35, 35,
180, 28, 28,175,  0,  3,  0,117,  1,117,  4, 14,  5,240,  0, 11,
  0, 15,  0, 27,  0, 57, 65, 10,  0, 14,  1,  8,  0, 12,  1,  5,
  0, 22,  1,  2,  0,  6,  1,  4,  0, 16,  1,  2, 64, 14,  0,156,
 28, 12, 19,  9, 13, 25,117,  3, 19,117,  9, 28, 16,212,236,212,
236, 57, 17, 18, 57, 49,  0, 16,244,236,244,236,252,236, 48,  1,
 50, 22, 21, 20,  6, 35, 34, 38, 53, 52, 54,  3, 33, 21, 33,  1,
 34,  6, 21, 20, 22, 51, 50, 54, 53, 52, 38,  2, 66,213,247,246,
214,214,247,247,198,  3, 55,252,201,  1,156, 84, 91, 91, 84, 83,
 91, 91,  5,240,222,190,190,220,220,190,190,222,252, 77,200,  3,
209,126,116,116,124,124,116,116,126,  0,  0,  1,  0, 55,  0,  0,
  5,238,  5,229,  0, 31,  0, 70,179, 16,  4,  0, 10,189,  1, 15,
  0, 26,  1, 13,  0, 19,  0,  0,  1,  9, 64, 22, 17,  2, 18, 32,
 20, 23, 13,  0,  7,  2,  1,  3,120,  7,119, 29, 16,120, 13,119,
 23, 32, 16,212,236,236,212,236,236,192,192, 18, 57, 17, 18, 57,
 17, 57, 49,  0, 47, 60,236, 50,252,236, 17, 57, 57, 48,  1, 33,
 17, 33, 17, 54, 18, 53, 52, 38, 35, 34,  6, 21, 20, 18, 23, 17,
 33, 17, 33, 38,  2, 53, 16,  0, 33, 32,  0, 17, 20,  2,  4,203,
  1, 35,253,159,126,132,203,178,177,203,132,126,253,159,  1, 35,
126,122,  1,120,  1, 56,  1, 57,  1,120,122,  1,  0,255,  0,  1,
 35, 86,  1,  7,165,203,233,233,203,164,254,247, 85,254,221,  1,
  0,121,  1, 22,164,  1, 57,  1,121,254,135,254,199,164,254,234,
  0,  3,  0, 88,255,227,  8,  0,  4,123,  0,  6,  0, 17,  0, 62,
  0,204, 64, 66, 56, 62, 54, 16, 31, 30,  0,  7,210, 54,  0,216,
 31, 39,204, 38,212, 35, 13,159, 54,207, 45, 42, 18,204, 62,203,
 59,  3,159, 31,215, 24, 27, 21,202, 48, 42,152, 63,  7, 16, 10,
  6,  0, 45, 24, 32, 54, 16, 10, 38,  0, 13, 30, 55, 16, 13, 32,
 10, 13, 18, 51, 59, 63, 16,252,196,236,212,252, 60,212,236,196,
 17, 18, 57, 17, 57, 57, 18, 57, 17, 18, 57, 49,  0, 16,228, 50,
244, 60,196,228,252, 60,244,236, 16,196,230,254, 60,244,238, 16,
238, 16,238, 17, 57, 17, 57, 17, 18, 57, 48, 64, 78, 62, 18, 62,
 19, 63, 64, 77, 18, 77, 19, 79, 64, 94, 18, 94, 19, 95, 64,110,
 18,110, 19,111, 64,127, 64,141, 18,141, 19,157, 18,157, 19,144,
 64,173, 18,173, 19,189, 18,189, 19, 22, 50, 61, 48, 62, 66, 61,
 64, 62, 82, 61, 80, 62, 98, 61, 96, 62,131, 61,128, 62,146, 61,
144, 62,164, 61,160, 62,178, 61,176, 62, 16, 93,  1, 93,  1, 52,
 38, 35, 34,  6,  7,  5, 34,  6, 21, 20, 22, 51, 50, 54, 61,  1,
  1, 62,  1, 51, 50, 22, 23, 62,  1, 51, 32,  0, 17, 21, 33, 30,
  1, 51, 50, 54, 55, 17, 14,  1, 35, 34, 36, 39, 14,  1, 35, 34,
 38, 53, 52, 36, 33, 51, 53, 52, 38, 35, 34,  6,  7,  6,143,119,
 96,103,128, 16,253,225,112,113, 91, 81,101,138,253, 94,119,223,
 97,150,217, 71, 77,204,122,  1,  9,  1, 61,252,186, 14,155,141,
113,237,125,127,255,126,179,254,247, 72,101,223,139,194,226,  1,
 15,  1, 34,211,134,142,115,198, 85,  2,170,102,125,117,110,178,
 76, 74, 68, 77,145,109, 41,  2, 74, 28, 29, 77, 79, 77, 79,254,
194,254,246,102,126,126, 67, 68,254,236, 48, 49,107,100,107,100,
197,168,197,184, 28, 85, 79, 46, 46,  0,  0,  3,  0, 78,255,162,
  5, 41,  4,193,  0,  9,  0, 19,  0, 43,  0,184, 64, 62, 31, 29,
 26, 19, 10,  9,  0,  4,  3, 20, 41, 43, 13, 32, 26,  3, 42, 38,
 30, 26, 13,161, 38,  3,161, 26,202, 38,152, 43, 43, 44, 23, 30,
 32, 35, 16, 42, 20, 23, 19, 10,  9,  0,  4,  6, 29, 35, 16, 41,
 23,  6, 31, 16, 66, 35, 76,  6, 66, 23, 59, 44, 16,252,236,252,
236,192, 17, 18, 57, 17, 18, 57, 18, 23, 57, 17, 57, 57, 17, 18,
 57, 57, 17, 18, 57, 49,  0, 47,228,244,236, 16,238, 16,192, 16,
192, 17, 18, 57, 17, 18, 57, 57, 18, 23, 57, 17, 57, 57, 48, 64,
 64, 58,  0, 53, 10, 59, 21, 55, 29, 53, 33, 56, 41, 63, 45, 73,
  0, 70, 10, 75, 21, 71, 29, 68, 33, 72, 41, 91, 21, 86, 29, 84,
 33, 85, 40,105,  0,107, 21,102, 29,101, 33,101, 40, 22, 53, 29,
 58, 41, 69, 29, 74, 41, 85, 29, 94, 40,105, 10,101, 29,109, 40,
  9, 93,  1, 93,  1, 46,  1, 35, 34,  6, 21, 20, 22, 31,  1, 30,
  1, 51, 50, 54, 53, 52, 38, 39,  1, 46,  1, 53, 16,  0, 33, 50,
 22, 23, 55, 23,  7, 30,  1, 21, 16,  0, 33, 34, 38, 39,  7, 39,
  3, 88, 29, 75, 47,119,125,  7,  7, 72, 31, 79, 48,117,124,  7,
  7,253, 59, 67, 68,  1, 71,  1, 34,106,179, 75,147,109,141, 70,
 69,254,187,254,223,108,182, 77,148,112,  3, 68, 28, 27,171,161,
 41, 65, 27,139, 30, 30,171,161, 43, 67, 29,253,228, 78,200,123,
  1, 20,  1, 56, 44, 44,158,101,149, 80,202,126,254,236,254,200,
 45, 45,155, 94,  0,  2,  0,141,255,227,  4, 31,  5,213,  0, 29,
  0, 33,  0, 77, 64, 42, 29, 26,  5,  2,  4,  6, 25,  0, 16,145,
 15,149, 12,  0,140, 30,139, 32, 12,161, 19,152, 32,141, 34,  6,
  5,  9,  1, 26, 25, 22, 31,  0,  2, 30,  1, 15,  9,  2, 22, 34,
 16,220,236,212,212, 60,236, 50, 17, 57, 57, 17, 18, 57, 57, 49,
  0, 16,228,244,236, 16,254,237, 16,244,238, 18, 57, 57, 23, 57,
 48,  1, 33, 21, 20,  6,  7,  7,  6,  6, 21, 20, 22, 51, 50, 54,
 55, 17,  6,  6, 35, 34, 36, 53, 52, 54, 55, 55, 54, 54, 53, 37,
 33, 17, 33,  1,231,  1,105, 65,109, 64, 56, 52, 96, 86, 81,189,
101,119,203, 92,244,255,  0, 78, 94, 64, 68, 42,  1,105,254,151,
  1,105,  3,219, 49, 81,126,100, 58, 51, 92, 47, 70, 80, 68, 66,
254,198, 42, 40,199,190, 99,155, 88, 58, 61, 76, 45,195,  1,100,
  0,  2,  1, 31,  0,  0,  2,135,  5,213,  0,  5,  0,  9,  0, 31,
 64, 15,  2,140,  6,139,  7,141,  0,  3,  2,  8,  4,  2,  6,  0,
 10, 16,220, 60,236, 50, 57, 57, 49,  0, 47,244,252,236, 48, 33,
 17, 19, 33, 19, 17,  1, 17, 33, 17,  1, 31, 51,  1,  2, 51,254,
152,  1,104,  2, 61,  1,162,254, 94,253,195,  4,113,  1,100,254,
156,  0,  0,  1,  0,217,  1, 31,  5,219,  3,141,  0,  5,  0, 23,
 64, 10,  4,167,  2,  0,  6,  3, 18,  1,  0,  6, 16,212,212,236,
 49,  0, 16,212,196,236, 48, 19, 33, 17, 35, 17, 33,217,  5,  2,
235,251,233,  3,141,253,146,  1,129,  0,  0,  1,  0, 76,255,215,
  5, 90,  6,178,  0, 10,  0,110, 64, 42,  7,  8,  7,  9,  8,  6,
  5,  6,  8,  9,  8,  0,  3,  4,  3, 10,  9, 10,  4,  4,  3, 10,
  0, 10,  5,  6,  5,  9,  8,  9,  6,  6,  5, 37, 10,  9,  8,  7,
  6,  5, 11,  0,186,  1, 17,  0,  2,  1, 16, 64, 14,  4, 11, 10,
  9,  7,  6,  5,  4,  3,  0,  8,  1,  8, 11, 16,212,196, 23, 57,
 49,  0, 16,196,252,236, 18, 23, 57, 48, 75, 83, 88,  7, 16,  8,
201,  7, 16,  8,201,  7, 16,  8,201,  7, 16,  5,201,  7, 16,  8,
201,  7,  8,201, 89, 34,  1, 51, 21, 35,  1, 35,  1,  7, 39, 37,
 19,  4,131,215, 96,253,178,119,254,205,145, 37,  1,104,223,  6,
178,149,249,186,  3, 78, 55,129,127,253,133,  0,  0,  1,  0,  6,
254, 86,  5, 55,  6, 20,  0, 35,  0,119, 64, 73, 14, 13, 12, 11,
 10,  9,  8,  7,  6,  5,  4,  3,  2,  1,  0, 35, 34, 33, 32, 31,
 30, 29, 28, 27, 24, 26, 28,  7, 12,  7, 23, 24,  2, 22, 25, 28,
 12, 12,  7, 37, 25, 12, 19, 10,  7, 30,  8,  0,172,  1,148,  4,
 18,172, 19,148, 22, 26, 10,159,  8, 22,159, 15,  4,159, 33,163,
 15,222, 28,  8, 36,  0, 16,196, 50,228,252,236, 16,238, 16,238,
 50, 16,245,238, 16,245,238, 18, 57, 57, 17, 18, 57, 57, 48, 75,
 83, 88,  7, 16,  5,237, 17, 23, 57,  7, 16,  5,237, 23, 50, 89,
 34,  1, 21, 38, 38, 35, 34,  6,  7,  7, 33, 21, 33,  3,  6,  6,
 35, 34, 38, 39, 53, 22, 22, 51, 50, 54, 55, 19, 35, 53, 33, 55,
 54, 54, 51, 50, 22,  5, 55, 46, 84, 42, 90,100, 27, 33,  1, 29,
254,180,133, 41,229,191, 65,133, 68, 46, 85, 41, 89, 99, 29,117,
242,  1, 33, 51, 42,227,190, 66,132,  5,236,254, 29, 28,115,141,
168,238,253, 95,206,204, 20, 21,254, 29, 28,115,141,  2, 77,238,
252,206,203, 20,  0,  2,  0,217,  0,225,  5,219,  4, 35,  0, 29,
  0, 59,  0, 67, 64, 33, 46, 31, 57, 42,  1, 16, 27, 12, 15, 30,
 49,  4,  0, 19,  4,167, 27, 12,167, 19, 34,167, 57, 42,167, 49,
 19, 60, 30,  0, 45, 15, 60, 16,212, 60,196, 50, 49,  0, 16,196,
212,236,220,236, 16,238,220,238, 16,192, 17, 18, 57, 57, 17, 18,
 57, 57, 17, 18, 57, 57, 48,  1, 21,  6,  6, 35, 34, 39, 38, 39,
 38, 39, 38, 35, 34,  6,  7, 53, 54, 54, 51, 50, 23, 22, 23, 22,
 23, 22, 51, 50, 54, 19, 21,  6,  6, 35, 34, 39, 38, 39, 38, 39,
 38, 35, 34,  6,  7, 53, 54, 54, 51, 50, 23, 22, 23, 22, 23, 22,
 51, 50, 54,  5,219,106,179, 96,107,143, 14,  8,  7, 15,155, 94,
 88,172, 98,105,179, 97,110,147, 10,  5,  8, 14,155, 94, 86,169,
103,106,179, 96,107,143, 14,  9,  6, 15,155, 94, 88,172, 98,107,
178, 96,107,143, 15,  7,  8, 14,155, 94, 86,169,  4, 35,244, 80,
 69, 58,  6,  3,  3,  6, 61, 77, 83,244, 78, 69, 59,  4,  2,  3,
  6, 61, 75,254,179,244, 80, 69, 58,  6,  4,  2,  6, 61, 76, 84,
244, 80, 69, 58,  6,  3,  3,  5, 62, 75,  0,  2,  0,  0,  0,  0,
  5,147,  5,193,  0,  2,  0,  6,  0, 32,178,  0,  3,  1,184,  1,
  9, 64, 11,  3,250,  5,  4,  3,  2,  1,  0,  5,  5,  6, 47,206,
 23, 57, 49,  0, 47,238,238, 17, 57, 48,  1,  1, 33,  1, 33,  1,
 33,  2,201,254,186,  2,141,254, 35,  1, 45,  2, 51,250,109,  4,
 86,252,170,  4,193,250, 63,  0,  0,  2,  0,158,  0,137,  4,106,
  4, 39,  0,  6,  0, 13,  0, 53,179,  9,  2, 11,  4,187,  1, 19,
  0,  7,  0,  0,  1, 18, 64, 15, 14,  2, 12,  5,  9,  0, 10,  7,
121, 12,  3,  0,121,  5, 14, 16,212,252, 60,212,236, 50, 17, 57,
 17, 18, 57, 49,  0, 16,244, 60,236, 50, 57, 57, 48,  1, 21,  5,
  5, 21,  1, 53,  1, 21,  5,  5, 21,  1, 53,  2,139,254,219,  1,
 37,254, 19,  3,204,254,220,  1, 36,254, 19,  4, 39,242,221,221,
242,  1,113,186,  1,115,242,221,221,242,  1,113,186,  0,  0,  2,
  0,193,  0,137,  4,141,  4, 39,  0,  6,  0, 13,  0, 53,179, 12,
  5, 10,  3,187,  1, 19,  0,  7,  0,  0,  1, 18, 64, 15, 14,  5,
  8,  1, 12,  7,  1,121,  3,  0,  8,121, 10,  7, 14, 16,212, 60,
252,212, 60,236, 18, 57, 17, 18, 57, 49,  0, 16,244, 60,236, 50,
 57, 57, 48,  1,  1, 21,  1, 53, 45,  2,  1, 21,  1, 53, 37, 37,
  2,160,  1,237,254, 19,  1, 37,254,219,254, 33,  1,235,254, 21,
  1, 36,254,220,  4, 39,254,141,186,254,143,242,221,221,242,254,
141,186,254,143,242,221,221,  0,  0,  3,  0,162,  0,  0,  7, 94,
  1,131,  0,  3,  0,  7,  0, 11,  0, 35, 64, 17,  8,  4,  0,168,
 10,  6,  2,  1,  2,  0,  9,  2,  8,  5,  2,  4, 12, 16,220,252,
212,252,212,236, 49,  0, 47, 60, 60,236, 50, 50, 48,  1, 33, 17,
 33,  1, 33, 17, 33,  1, 33, 17, 33,  5,246,  1,104,254,152,250,
172,  1,104,254,152,  2,170,  1,104,254,152,  1,131,254,125,  1,
131,254,125,  1,131,254,125,  0,255,255,  0, 10,  0,  0,  6, 39,
  7,107,  2, 39,  0, 36,  0,  0,  0,  0,  0,  7,  1,  6,  1,  0,
  1,117,255,255,  0, 10,  0,  0,  6, 39,  7,109,  2, 39,  0, 36,
  0,  0,  0,  0,  0,  7,  1,  5,  1,  0,  1,117,255,255,  0,102,
255,227,  6,102,  7,109,  2, 39,  0, 50,  0,  0,  0,  0,  0,  7,
  1,  5,  1, 78,  1,117,  0,  2,  0,102,255,254,  8,193,  5,215,
  0,  8,  0, 31,  0, 80, 64, 34, 23, 19, 29,  9, 13,192, 15,190,
 11,  0,192,  9,141, 17,  7,192, 19,  7,  1, 20,  9,  4, 16, 12,
 22,  0, 10, 14, 18,  4, 45, 26, 43, 32, 16,252,236,212,196,196,
212,236, 50, 18, 57, 57, 57, 57, 49,  0, 47,236, 50,244,236, 50,
244,236, 16,192, 16,192, 48, 64, 11,  0, 33, 16, 33, 63, 33, 79,
 33, 95, 33,  5,  1, 93,  1, 35, 32,  4, 21, 20,  4, 33, 51,  3,
 33, 17, 33, 17, 33, 17, 33, 17, 33, 17, 33, 34,  6, 35, 32,  0,
 17, 16,  0, 33, 50, 22,  4,156,105,254,223,254,226,  1, 31,  1,
 32,105, 90,  4,104,253,115,  2,102,253,154,  2,164,251,129, 13,
 47, 12,254, 70,254, 38,  1,218,  1,186, 11, 48,  4,178,226,228,
229,228,  4,178,254,221,254,234,254,221,254,170,254,221,  2,  1,
133,  1,105,  1,104,  1,131,  2,  0,  3,  0, 88,255,227,  8, 94,
  4,123,  0,  6,  0, 39,  0, 51,  0,116, 64, 50, 34, 31,  3, 22,
 16, 12,  7,  0,216,  8, 16,204, 15,212, 12,159, 46,161, 19, 40,
161,  8,215,  3,159, 37, 31,202, 25, 19,152, 52,  6,  0, 22, 34,
 49,  9,  0, 13, 15,  7, 49, 13,  9, 43, 66, 28, 59, 52, 16,252,
236,212,252,212,196,236, 17, 18, 57, 57, 18, 57, 49,  0, 16,228,
 50,244, 60,236,228,236, 16,238,254,244,238, 16,238, 57, 17, 18,
 57, 17, 18, 57, 48, 64, 20, 47, 53, 63, 53, 79, 53, 79, 53, 95,
 53,111, 53,111, 53,127, 53,  8, 70, 34,  1, 93,  1, 93,  1, 52,
 38, 35, 34,  6,  7,  5, 21, 33, 30,  1, 51, 50, 54, 55, 17,  6,
  4, 35, 34, 38, 39, 14,  1, 35, 32,  0, 17, 16,  0, 33, 50, 22,
 23, 62,  1, 51, 32,  0, 37, 34,  6, 21, 20, 22, 51, 50, 54, 53,
 52, 38,  6,238,119, 96,104,130, 16,  3, 65,252,187, 13,156,140,
113,237,125,126,255,  0,126,165,214, 72, 82,213,130,254,222,254,
185,  1, 71,  1, 34,134,206, 81, 82,199,135,  1, 22,  1, 66,250,
 99,119,125,125,119,117,124,124,  2,170,102,125,117,110,119,102,
126,126, 67, 68,254,236, 48, 49, 81, 87, 84, 84,  1, 56,  1, 20,
  1, 20,  1, 56, 82, 86, 87, 81,254,198, 58,171,161,161,171,171,
161,161,171,  0,  0,  1,  0,  0,  1,176,  4,  0,  2,178,  0,  3,
  0, 19,185,  0,  2,  1, 21,180,  0,170,  4,  1,  0, 47,198, 49,
  0, 16,244,236, 48, 17, 33, 17, 33,  4,  0,252,  0,  2,178,254,
254,  0,  0,  1,  0,  0,  1,176,  8,  0,  2,178,  0,  3,  0, 19,
185,  0,  2,  1, 21,180,  0,170,  4,  1,  0, 47,204, 49,  0, 16,
244,236, 48, 17, 33, 17, 33,  8,  0,248,  0,  2,178,254,254,  0,
  0,  2,  0,211,  3, 88,  4,133,  5,213,  0,  5,  0, 11,  0, 43,
186,  0,  6,  0,  0,  1, 22, 64, 16,  9,  3,141, 12,  3,  4,  0,
 17,  1,  9, 10,  1,  6, 17,  7, 12, 16,220,252,204,212,204, 16,
254,212,206, 49,  0, 16,244, 60,236, 50, 48,  1, 33, 17, 19, 51,
  3,  1, 33, 17, 19, 51,  3,  4, 33,254,172,227,213,100,254,  6,
254,172,227,213,100,  3, 88,  1, 27,  1, 98,254,158,254,229,  1,
 29,  1, 96,254,160,  0,  0,  2,  0,188,  3, 88,  4,111,  5,213,
  0,  5,  0, 11,  0, 43,186,  0,  9,  0,  3,  1, 22, 64, 16,  6,
  0,141, 12,  9, 10,  7, 17,  6,  1,  3,  4,  1, 17,  0, 12, 16,
220,236,212,204, 16,220,238,212,206, 49,  0, 16,244, 60,236, 50,
 48,  1, 33, 17,  3, 35, 19,  1, 33, 17,  3, 35, 19,  1, 33,  1,
 84,228,213,101,  1,250,  1, 84,228,213,101,  5,213,254,227,254,
160,  1, 96,  1, 29,254,225,254,162,  1, 94,  0,  0,  1,  0,211,
  3, 88,  2,139,  5,213,  0,  5,  0, 27,185,  0,  0,  1, 22, 64,
  9,  3,141,  6,  3,  4,  0, 17,  1,  6, 16,220,252,212,204, 49,
  0, 16,244,236, 48,  1, 33, 17, 19, 51,  3,  2, 39,254,172,227,
213,100,  3, 88,  1, 29,  1, 96,254,160,  0,  1,  0,129,  3, 88,
  2, 57,  5,213,  0,  5,  0, 27,185,  0,  3,  1, 22, 64,  9,  0,
141,  6,  3,  4,  1, 17,  0,  6, 16,220,236,212,204, 49,  0, 16,
244,236, 48, 19, 33, 17,  3, 35, 19,229,  1, 84,227,213,100,  5,
213,254,227,254,160,  1, 96,  0,  0,  3,  0,217,  0, 86,  5,219,
  4,174,  0,  3,  0,  7,  0, 11,  0, 48,188,  0,  4,  1, 23,  0,
  6,  0,  2,  1, 23, 64, 17,  0, 10,167,  6,  8,166, 12,  9,122,
  5,  1,123,  8,122,  4,  0, 12, 16,212, 60,236,252, 60,236, 49,
  0, 16,244,196,252,212,236, 16,238, 48,  1, 33, 17, 33, 17, 33,
 17, 33,  5, 33, 21, 33,  2,193,  1, 51,254,205,  1, 51,254,205,
254, 24,  5,  2,250,254,  1,139,254,203,  4, 88,254,203,129,236,
  0,  2,  0,  6,254, 35,  3,238,  6,117,  0,  3,  0,  7,  0,118,
 64, 65,  2,  3,  2,  6,  7,  6,  1,  0,  1,  7,  7,  6,  3,  0,
  3,  5,  6,  5,  2,  1,  2,  6,  6,  5,  0,  1,  0,  4,  5,  4,
  3,  2,  3,  5,  5,  4,  1,  2,  1,  7,  4,  7,  0,  3,  0,  4,
  7, 37,  2,  6,  0,  8,  6,  4,  8,  6,  4,  3,  2,  1,  0,  6,
  5,  7,  8, 16,212,196, 23, 57, 49,  0, 16,220,204, 18, 57, 17,
 57, 48, 75, 83, 88,  7,  8,201,  7, 16,  8,201,  7, 16,  8,201,
  7, 16,  8,201,  7, 16,  8,201,  7, 16,  8,201,  7, 16,  8,201,
  7, 16,  8,201, 89, 34,  9,  7,  1,250,254,127,  1,129,  1,129,
254,127,  1,244,254, 12,254, 12,  5,129,252,207,252,199,  3, 57,
  4, 37,251,219,251,211,  4, 45,255,255,  0, 25,254, 70,  5, 18,
  6, 49,  2, 39,  0, 92,  0,  0,  0,  0,  0,  7,  0,142,  0,156,
  0,  0,255,255,255,236,  0,  0,  5,223,  7,107,  2, 39,  0, 60,
  0,  0,  0,  0,  0,  7,  1,  3,  0,205,  1,117,  0,  1,254,104,
255,227,  2,238,  5,240,  0,  3,  0, 43, 64, 19,  0, 53,  1,  2,
  1,  2, 53,  3,  0,  3, 37,  0,152,  2,156,  4,  3,  1,  4, 16,
212,204, 49,  0, 16,228,228, 48, 75, 83, 88,  7, 16,  5,237,  7,
 16,  5,237, 89, 34,  7, 35,  1, 51,184,224,  3,166,224, 29,  6,
 13,  0,  0,  2,  0, 74,  0, 61,  4,207,  4,197,  0, 35,  0, 47,
  0,141, 64, 24, 20, 18, 12, 10,  4, 21, 15, 30,  0, 28,  2,  4,
 33,  9, 27, 21,  3, 29, 33,  1, 19, 11, 36,  3, 65, 10,  1, 25,
  0,  1,  1, 24,  0, 33,  1, 26,  0, 42,  0, 21,  1, 25,  0, 11,
  1, 24, 64, 38, 15, 48, 28, 20, 19, 29, 27, 21,  4, 24, 18,  2,
 48, 10, 30, 12, 18, 11,  9,  3,  1,  4,  6,  0, 39, 18,125, 20,
124, 24,126, 45,  0,125, 10,124,  6, 48, 16,220,236,236, 50,252,
236,236, 50, 17, 18, 23, 57, 18, 57, 57, 17, 18, 57, 17, 18, 23,
 57, 17, 57, 49,  0, 16,212,236,236, 50,252,236,236, 50, 16,192,
 17, 18, 57, 17, 18, 57, 57, 18, 23, 57, 17, 18, 23, 57, 48,  1,
  7, 39, 55, 38, 38, 53, 52, 54, 55, 39, 55, 23, 54, 54, 51, 50,
 22, 23, 55, 23,  7, 22, 22, 21, 20,  6,  7, 23,  7, 39,  6,  6,
 35, 34, 38, 55, 50, 54, 53, 52, 38, 35, 34,  6, 21, 20, 22,  1,
178,207,153,207, 28, 28, 30, 30,209,153,207, 48,108, 61, 54,108,
 57,207,152,207, 29, 28, 29, 30,207,154,207, 46,106, 63, 58,108,
166, 91,128,127, 92, 91,128,126,  1, 12,207,154,207, 49,107, 63,
 63,108, 46,205,154,207, 30, 29, 27, 28,207,154,207, 55,110, 54,
 63,105, 47,207,153,206, 30, 29, 27,182,127, 92, 92,127,127, 92,
 93,126,  0,  1,  0,158,  0,137,  2,139,  4, 39,  0,  6,  0, 31,
188,  0,  2,  0,  4,  1, 19,  0,  0,  1, 18,182,  7,  2,  3,  0,
121,  5,  7, 16,212,236, 50, 57, 49,  0, 16,244,236, 57, 48,  1,
 21,  5,  5, 21,  1, 53,  2,139,254,219,  1, 37,254, 19,  4, 39,
242,221,221,242,  1,113,186,  0,  0,  1,  0,193,  0,137,  2,174,
  4, 39,  0,  6,  0, 31,188,  0,  5,  0,  3,  1, 19,  0,  0,  1,
 18,182,  7,  5,  1,121,  3,  0,  7, 16,212, 60,236, 57, 49,  0,
 16,244,236, 57, 48, 19,  1, 21,  1, 53, 37, 37,193,  1,237,254,
 19,  1, 36,254,220,  4, 39,254,141,186,254,143,242,221,221,  0,
  0,  2,  0, 43,  0,  0,  5, 66,  6, 20,  0,  3,  0, 25,  0,117,
 64, 38, 22,  9,  2, 18, 14,161,  2,221, 10,  5,159,  4,  0,163,
 20, 10,179, 16, 12,  6, 25,  9,  4, 13,  0, 13, 11,  1,127, 15,
  9, 13, 19, 69, 21, 17, 84, 26, 16,252, 60,236,236, 50,244, 60,
252, 60,204, 17, 57, 57, 49,  0, 47, 60,228, 50,252, 60,236, 16,
237,238, 50, 18, 57, 57, 48,  1, 75,176, 16, 84, 75,176, 17, 84,
 91, 75,176, 20, 84, 91, 75,176, 15, 84, 91, 88,189,  0, 26,255,
192,  0,  1,  0, 26,  0, 26,  0, 64, 56, 17, 55, 56, 89,180, 64,
 27,128, 27,  2, 93,  1, 33, 17, 33,  3, 21, 35, 34,  6, 29,  1,
 33, 17, 33, 17, 33, 17, 33, 17, 35, 17, 51, 53, 52, 54, 51,  3,
217,  1,105,254,151, 74,198, 75, 58,  2,254,254,151,254,107,254,
151,176,176,204,214,  6, 20,254,220,  1, 36,235, 55, 68, 78,251,
160,  3, 96,252,160,  3, 96,  1,  0, 78,183,175,  0,  1,  0, 39,
  0,  0,  5, 66,  6, 20,  0, 21,  0,108, 64, 33, 19,  8,  4, 15,
 11,161,  9,  4,159,  0,163, 17,  9,179, 13,  2,  5,  0,  8, 10,
  3, 13,  1,127, 12,  8, 13, 16, 69, 18, 14, 84, 22, 16,252, 60,
236,236, 50,244,252,204, 17, 57, 57, 49,  0, 47, 60,228, 50,252,
236, 16,238, 50, 18, 57, 57, 48,  1, 75,176, 20, 84, 75,176, 17,
 84, 91, 75,176, 16, 84, 91, 75,176, 15, 84, 91, 88,189,  0, 22,
255,192,  0,  1,  0, 22,  0, 22,  0, 64, 56, 17, 55, 56, 89,180,
 64, 23,128, 23,  2, 93,  1, 33, 17, 33, 17, 33, 34,  6, 29,  1,
 33, 17, 33, 17, 33, 17, 35, 17, 51, 53, 52, 54,  2,123,  2,199,
254,151,254,238, 76, 60,  1, 25,254,231,254,154,178,178,204,  6,
 20,249,236,  5, 41, 55, 68, 78,255,  0,252,160,  3, 96,  1,  0,
 78,183,175,  0,  0,  1,  0, 51,255, 59,  3,195,  5,213,  0, 19,
  0, 63, 64, 33, 16,  4,229,  2, 12,  8,229, 14,  6, 10,227,  0,
141, 18,  2,228, 20, 13, 20, 17,  7,  3, 87,  9,  5,  1, 86, 17,
 87, 15, 11,  0, 20, 16,212, 60, 60,228,252, 60, 60,228, 50, 17,
 18, 57, 49,  0, 16,228, 50,244,252,212, 60,236, 50, 16,238, 50,
 48,  1, 33, 17, 33, 21, 33, 17, 33, 21, 33, 17, 33, 17, 33, 53,
 33, 17, 33, 53, 33,  1, 86,  1, 74,  1, 35,254,221,  1, 35,254,
221,254,182,254,221,  1, 35,254,223,  1, 33,  5,213,254,131,238,
254, 60,238,254,131,  1,125,238,  1,196,238,  0,  0,  1,  0,209,
  2,  6,  2, 57,  3,137,  0,  3,  0, 18,183,  2,  0,  4,  1,  2,
  0, 19,  4, 16,252,236, 49,  0, 16,212,204, 48, 19, 33, 17, 33,
209,  1,104,254,152,  3,137,254,125,  0,  0,  1,  0,147,255,  6,
  2, 76,  1,131,  0,  5,  0, 27,185,  0,  3,  1, 22, 64,  9,  0,
168,  6,  3,  4,  1, 17,  0,  6, 16,220,236,212,204, 49,  0, 16,
252,236, 48, 19, 33, 17,  3, 35, 19,248,  1, 84,230,211,101,  1,
131,254,227,254,160,  1, 96,  0,  0,  2,  0,147,255,  6,  4, 70,
  1,131,  0,  5,  0, 11,  0, 43,186,  0,  9,  0,  3,  1, 22, 64,
 16,  6,  0,168, 12,  9, 10,  7, 17,  6,  1,  3,  4,  1, 17,  0,
 12, 16,220,236,212,204, 16,220,238,212,206, 49,  0, 16,252, 60,
236, 50, 48, 19, 33, 17,  3, 35, 19,  1, 33, 17,  3, 35, 19,248,
  1, 84,230,211,101,  1,250,  1, 84,228,213,101,  1,131,254,227,
254,160,  1, 96,  1, 29,254,225,254,162,  1, 94,  0,  7,  0, 66,
255,227, 11, 86,  5,240,  0, 11,  0, 23,  0, 35,  0, 47,  0, 51,
  0, 63,  0, 75,  0,124, 64, 67, 51, 11, 50, 50, 49, 49, 11, 48,
 48, 51, 37, 64,  0,157, 12, 30,157, 42,153, 24,157, 36, 70,  6,
157, 52, 12,153, 58, 48, 18,152, 50, 36,156, 76, 51, 73, 67, 49,
 33, 27,  9,  8, 15,  9,  3,  8, 21, 67,  8, 61, 33,  8, 39, 61,
  9, 73,  8, 21, 55, 27,  8, 39,  9, 45, 76, 16,220,228,236,212,
204,236,228, 16,238, 16,238, 16,238,246,238, 17, 18, 57, 17, 18,
 57, 49,  0, 16,228, 50,244, 60, 60,228, 50,236, 50, 16,238,246,
238, 16,238, 50, 48, 75, 83, 88,  7, 16,  5,237,  7, 16,  5,237,
 89, 34,  1, 34,  6, 21, 20, 22, 51, 50, 54, 53, 52, 38, 39, 50,
 22, 21, 20,  6, 35, 34, 38, 53, 52, 54,  1, 34,  6, 21, 20, 22,
 51, 50, 54, 53, 52, 38, 39, 50, 22, 21, 20,  6, 35, 34, 38, 53,
 52, 54,  1, 35,  1, 51,  3, 50, 22, 21, 20,  6, 35, 34, 38, 53,
 52, 54, 23, 34,  6, 21, 20, 22, 51, 50, 54, 53, 52, 38,  9,199,
 72, 78, 78, 72, 71, 76, 76, 71,186,213,214,185,186,216,215,248,
197, 72, 78, 78, 72, 72, 77, 78, 71,186,213,213,186,186,213,213,
  1,135,221,  3,165,222, 17,186,214,214,186,186,215,215,186, 71,
 78, 77, 72, 72, 76, 77,  2,104,123,114,115,123,123,115,114,123,
168,216,189,189,219,219,189,188,217,  2, 56,124,114,115,125,125,
115,114,124,168,217,189,189,218,218,189,189,217,249,243,  6, 13,
253, 32,216,189,189,219,219,189,188,217,168,123,114,115,123,123,
115,114,123,  0,255,255,  0, 10,  0,  0,  6, 39,  7,107,  2, 39,
  0, 36,  0,  0,  0,  0,  0,  7,  1,  7,  1,  0,  1,117,255,255,
  0,188,  0,  0,  4,225,  7,107,  2, 39,  0, 40,  0,  0,  0,  0,
  0,  7,  1,  7,  0,180,  1,117,255,255,  0, 10,  0,  0,  6, 39,
  7,107,  2, 39,  0, 36,  0,  0,  0,  0,  0,  7,  1,  4,  1,  0,
  1,117,255,255,  0,188,  0,  0,  4,225,  7,107,  2, 39,  0, 40,
  0,  0,  0,  0,  0,  7,  1,  3,  0,180,  1,117,255,255,  0,188,
  0,  0,  4,225,  7,107,  2, 39,  0, 40,  0,  0,  0,  0,  0,  7,
  1,  6,  0,180,  1,117,255,255,  0,188,  0,  0,  2,178,  7,107,
  2, 39,  0, 44,  0,  0,  0,  0,  0,  7,  1,  4,255,100,  1,117,
255,255,255,235,  0,  0,  2,221,  7,107,  2, 39,  0, 44,  0,  0,
  0,  0,  0,  7,  1,  7,255,100,  1,117,255,255,  0, 41,  0,  0,
  2,159,  7,107,  2, 39,  0, 44,  0,  0,  0,  0,  0,  7,  1,  3,
255,100,  1,117,255,255,  0, 22,  0,  0,  2, 61,  7,107,  2, 39,
  0, 44,  0,  0,  0,  0,  0,  7,  1,  6,255,100,  1,117,255,255,
  0,102,255,227,  6,102,  7,107,  2, 39,  0, 50,  0,  0,  0,  0,
  0,  7,  1,  4,  1, 78,  1,117,255,255,  0,102,255,227,  6,102,
  7,107,  2, 39,  0, 50,  0,  0,  0,  0,  0,  7,  1,  7,  1, 78,
  1,117,255,255,  0,102,255,227,  6,102,  7,107,  2, 39,  0, 50,
  0,  0,  0,  0,  0,  7,  1,  6,  1, 78,  1,117,255,255,  0,188,
255,227,  5,195,  7,107,  2, 39,  0, 56,  0,  0,  0,  0,  0,  7,
  1,  4,  1, 39,  1,117,255,255,  0,188,255,227,  5,195,  7,107,
  2, 39,  0, 56,  0,  0,  0,  0,  0,  7,  1,  7,  1, 39,  1,117,
255,255,  0,188,255,227,  5,195,  7,107,  2, 39,  0, 56,  0,  0,
  0,  0,  0,  7,  1,  6,  1, 39,  1,117,  0,  1,  0,172,  0,  0,
  2, 18,  4, 96,  0,  3,  0, 30,183,  0,223,  2,  1, 13,  0, 16,
  4, 16,252,236, 49,  0, 47,236, 48, 64,  9, 80,  5, 96,  5,112,
  5,128,  5,  4,  1, 93, 19, 33, 17, 33,172,  1,102,254,154,  4,
 96,251,160,  0,  0,  1,  0,135,  4,238,  3,121,  6,102,  0,  6,
  0, 54, 64, 11,  4,  5,  2,198,  0,197,  7,  4,  2,  6,  7, 16,
212,204, 57, 49,  0, 16,244,236, 50, 57, 48,  0, 75,176,  9, 84,
 75,176, 14, 84, 91, 88,189,  0,  7,255,192,  0,  1,  0,  7,  0,
  7,  0, 64, 56, 17, 55, 56, 89,  1, 51,  1, 35, 39,  7, 35,  1,
135,242,  1,  0,178,199,199,178,  6,102,254,136,225,225,  0,  1,
  0,164,  5, 27,  3, 92,  6, 57,  0, 30,  0,201, 64, 20, 23, 17,
 16,  3, 20, 13,  8,  1,  0,  3, 28,  5, 25, 24, 20, 13, 10,  9,
  5, 20,188,  1, 28,  0, 28,  1, 27,  0,  5,  1, 28, 64, 15, 13,
197, 31, 17,  1, 16,  0,  8, 23,128, 25,  8,128, 10, 31, 16,212,
236,212,236, 17, 57, 57, 57, 57, 49,  0, 16,244,236,252,236, 18,
 57, 57, 17, 18, 57, 57, 17, 18, 23, 57, 17, 18, 23, 57, 48,  0,
 75,176,  9, 84, 75,176, 14, 84, 91, 88,189,  0, 31,255,192,  0,
  1,  0, 31,  0, 31,  0, 64, 56, 17, 55, 56, 89, 64, 84,  9,  0,
  9,  1,  9,  2,  9,  3, 12, 12, 12, 13, 12, 14, 12, 15, 12, 16,
 12, 17, 12, 18, 12, 19, 12, 20, 12, 21, 15, 22, 15, 23, 15, 24,
 15, 25, 15, 26,  9, 30, 26,  0, 26,  1, 26,  2, 26,  3, 26, 12,
 26, 13, 26, 14, 27, 15, 27, 16, 27, 17, 27, 18, 27, 19, 27, 20,
 27, 21, 31, 22, 31, 23, 31, 24, 31, 25, 31, 26, 26, 30, 40, 21,
 11,  1, 93,  1, 93,  1, 39, 38, 39, 38, 35, 34,  6, 29,  1, 35,
 52, 54, 51, 50, 22, 31,  1, 30,  1, 51, 50, 54, 61,  1, 51, 20,
  6, 35, 34, 38,  2,  2, 55,  4,  6, 47, 25, 36, 38,139,103, 93,
 36, 73, 41, 61, 22, 37, 15, 36, 40,139,103, 93, 36, 67,  5, 84,
 37,  2,  4, 31, 62, 59,  8,136,148, 27, 30, 43, 15, 16, 64, 57,
  8,136,148, 24,  0,  1,  0,197,  5, 88,  3, 59,  6, 20,  0,  3,
  0, 69,181,  2,  0,  4,  1,  0,  4, 16,212,196, 49,  0, 16,212,
204, 48,  0, 75,176, 10, 84, 75,176, 14, 84, 91, 88,189,  0,  4,
  0, 64,  0,  1,  0,  4,  0,  4,255,192, 56, 17, 55, 56, 89,  1,
 75,176, 14, 84, 88,189,  0,  4,255,192,  0,  1,  0,  4,  0,  4,
  0, 64, 56, 17, 55, 56, 89, 19, 33, 21, 33,197,  2,118,253,138,
  6, 20,188,  0,  0,  1,  0,176,  5, 29,  3, 80,  6, 70,  0, 13,
  0,105, 64, 12,  4, 11,  7,  0, 14,  7,129,  8,  1,129,  0, 14,
 16,212,236,212,236, 49,  0, 16,212, 60,212,204, 48,  0, 75,176,
 10, 84, 75,176, 15, 84, 91, 75,176, 16, 84, 91, 88,189,  0, 14,
  0, 64,  0,  1,  0, 14,  0, 14,255,192, 56, 17, 55, 56, 89,  0,
 75,176, 12, 84, 88,189,  0, 14,255,192,  0,  1,  0, 14,  0, 14,
  0, 64, 56, 17, 55, 56, 89, 64, 17, 15,  0, 15,  1, 15,  7, 15,
  8, 31,  0, 31,  1, 31,  7, 31,  8,  8, 93, 19, 51, 30,  1, 51,
 50, 54, 55, 51, 14,  1, 35, 34, 38,176,143, 11, 99, 83, 83, 99,
 11,143,  6,174,156,156,174,  6, 70, 70, 74, 74, 70,144,153,153,
  0,  1,  1,119,  5, 59,  2,137,  6, 49,  0,  3,  0, 42,183,  2,
241,  0,  4,  1,130,  0,  4, 16,212,236, 49,  0, 16,212,236, 48,
  0, 75,176, 10, 84, 88,189,  0,  4,  0, 64,  0,  1,  0,  4,  0,
  4,255,192, 56, 17, 55, 56, 89,  1, 33, 21, 33,  1,119,  1, 18,
254,238,  6, 49,246,  0,  0,  2,  0,227,  4,225,  3, 29,  7, 27,
  0, 11,  0, 23,  0, 67,189,  0,  3,  1, 24,  0, 21,  1, 29,  0,
  9,  1, 24, 64, 10, 15, 24,  6,131, 18, 58,  0,131, 12, 24, 16,
212,236,252,236, 49,  0, 16,212,236,252,236, 48,  0, 75,176,  9,
 84, 75,176, 14, 84, 91, 88,189,  0, 24,255,192,  0,  1,  0, 24,
  0, 24,  0, 64, 56, 17, 55, 56, 89,  1, 20, 22, 51, 50, 54, 53,
 52, 38, 35, 34,  6,  7, 52, 54, 51, 50, 22, 21, 20,  6, 35, 34,
 38,  1,125, 77, 54, 55, 76, 77, 54, 55, 76,154,167,118,118,167,
167,118,118,167,  5,254, 55, 76, 77, 54, 54, 77, 77, 54,118,167,
167,118,118,167,167,  0,  0,  1,  1,  6,254,111,  2,203,  0,  0,
  0, 19,  0, 53, 64, 12, 10,  9, 13,  6,  0, 19,  9,  0, 16,  3,
  9, 20, 16,212,212,204, 57, 17, 57, 49,  0, 47,212,204,212,204,
 48,  1, 75,176, 10, 84, 88,189,  0, 20,255,192,  0,  1,  0, 20,
  0, 20,  0, 64, 56, 17, 55, 56, 89, 33, 30,  1, 21, 20,  6, 35,
 34, 38, 47,  1, 30,  1, 51, 50, 54, 53, 52, 38, 39,  2, 90, 58,
 55,123,127, 48,102, 52,  1, 50, 83, 33, 58, 65, 43, 45, 62,106,
 47, 95, 91, 13, 13,152, 16, 15, 46, 40, 26, 82, 60,  0,  0,  2,
  0,193,  4,238,  3,213,  6,102,  0,  3,  0,  7,  0, 69, 64, 18,
  6,  2,  4,  0,197,  8,  4,  6,  5,  0,  2,  5,  6,  7,  2,  1,
  3,  8, 16,212,204,220,220,204,204, 18, 57, 17, 18, 57, 49,  0,
 16,244, 60,204, 50, 48,  0, 75,176,  9, 84, 75,176, 14, 84, 91,
 88,189,  0,  8,255,192,  0,  1,  0,  8,  0,  8,  0, 64, 56, 17,
 55, 56, 89,  1, 51,  3, 35,  1, 51,  1, 35,  1,131,217,248,163,
  2, 45,231,254,240,174,  6,102,254,136,  1,120,254,136,  0,  1,
  1, 86,254,111,  3,  2,  0,  0,  0, 19,  0, 31, 64, 13, 10, 11,
  7, 14,  0,  0, 17,  1, 10,  4, 10, 17, 20, 16,212,196,204, 17,
 57, 17, 57, 49,  0, 47,212,204,212,204, 48, 33, 51,  6,  6, 21,
 20, 22, 51, 50, 54, 55, 21,  6,  6, 35, 34, 38, 53, 52, 54,  1,
197,141, 50, 38, 59, 49, 39, 77, 40, 55, 94, 41,115,123, 54, 67,
 73, 26, 39, 49, 15, 16,156, 11, 11, 92, 86, 53,109,  0,  0,  1,
  0,135,  4,238,  3,121,  6,102,  0,  6,  0, 54, 64, 11,  3,  0,
198,  4,  1,197,  7,  3,  5,  1,  7, 16,212,204, 57, 49,  0, 16,
244, 60,236, 57, 48,  0, 75,176,  9, 84, 75,176, 14, 84, 91, 88,
189,  0,  7,255,192,  0,  1,  0,  7,  0,  7,  0, 64, 56, 17, 55,
 56, 89,  9,  1, 51, 23, 55, 51,  1,  1,135,255,  0,178,199,199,
178,255,  0,  4,238,  1,120,227,227,254,136,  0,  0,  1,255,164,
  0,  0,  4,236,  5,213,  0, 13,  0, 96, 64, 50, 13, 10, 11, 10,
 12, 11, 12, 11, 11, 10,  3,  4,  3,  4,  5,  4,  2,  5,  5,  4,
 37, 12, 11, 10,  4,  3,  2,  6,  0,  6,192,  0,141,  8,  3,  4,
  7,  1, 11, 14,  0, 12,  7,  5,  1, 22,  9,  0,132, 14, 16,252,
 60,252, 60,196, 46, 17, 18, 57, 17, 18, 57, 57, 49,  0, 47,228,
236, 17, 23, 57, 48, 75, 83, 88,  7, 16,  4,201,  7, 16,  8,201,
  7, 16,  8,201,  7, 16,  4,201, 89, 34, 19, 33, 17, 55, 23,  1,
 17, 33, 17, 33, 17,  7, 39, 37,199,  1,129,254,143,254,115,  2,
164,251,219,148,143,  1, 35,  5,213,254, 96,185,193,254,240,254,
  6,254,221,  2, 12,106,190,197,  0,  1,255,219,  0,  0,  3, 31,
  6, 20,  0, 11,  0,126, 64, 45, 11,  8,  9,  8, 10,  9,  9,  8,
  3,  4,  3,  4,  5,  4,  2,  5,  5,  4, 37, 10,  9,  8,  4,  3,
  2,  6,  0,163,  6,  3,  4,  1,  9, 12,  0,  4,  1, 10,  5,  1,
 13,  7,  0, 84, 12, 16,252, 60,236, 50, 46, 16,192, 17, 18, 57,
 17, 18, 57, 49,  0, 47,236, 23, 57, 48, 75, 83, 88,  7, 16,  4,
201,  7, 16,  8,201,  7, 16,  4,201,  7, 16,  4,201, 89, 34,178,
 16, 13,  1,  1, 93, 64, 26,117,  4,116,  5,131,  4,  3, 64, 13,
 80, 13, 96, 13, 96, 13,116,  4,112, 13,112, 13,128,  4,128, 13,
  9, 93,  0, 93, 19, 33, 17, 55, 23,  7, 17, 33, 17,  7, 39, 55,
199,  1,104,129,111,240,254,152,125,111,236,  6, 20,254, 11, 88,
154,164,252,199,  2,129, 86,154,163,  0,255,255,  0,147,255,227,
  5, 45,  7,107,  2, 39,  0, 54,  0,  0,  0,  0,  0,  7,  1,  8,
  0,201,  1,117,255,255,  0,106,255,227,  4, 98,  6,102,  2, 39,
  0, 86,  0,  0,  0,  0,  0,  7,  0,224,  0, 98,  0,  0,255,255,
  0, 92,  0,  0,  5,113,  7,107,  2, 39,  0, 61,  0,  0,  0,  0,
  0,  7,  1,  8,  0,207,  1,117,255,255,  0, 92,  0,  0,  4, 70,
  6,102,  2, 39,  0, 93,  0,  0,  0,  0,  0,  7,  0,224,  0, 84,
  0,  0,  0,  2,  1,  4,254,162,  1,231,  5,152,  0,  3,  0,  7,
  0, 28, 64, 12,  1,  0,  5,  4,  0,  8,  4,  0,  4,  6,  2,  8,
 16,212, 60,236, 50, 49,  0, 16,196,212,196, 16,198, 48,  1, 17,
 35, 17, 19, 17, 35, 17,  1,231,227,227,227,  5,152,253, 10,  2,
246,252,  0,253, 10,  2,246,  0,  0,  2,  0, 33,  0,  0,  6, 76,
  5,213,  0, 12,  0, 31,  0,149, 64, 31, 30,  1,185, 28,  3,  0,
192, 13,141,  5,192, 26, 12,  6, 26, 14,  4,  2,  0,  9, 45, 20,
 46, 29,  4,  0, 22, 27, 13,132, 32, 16,252, 60,236, 50,196,252,
236, 16,196, 23, 57, 49,  0, 47,238,246,238,214, 60,238, 50, 48,
 64, 88,  0, 33, 80, 33, 96, 33,  3, 47,  1, 47,  2, 47,  3, 47,
  4, 47, 28, 47, 29, 47, 30, 47, 31, 79,  1, 79,  2, 79,  3, 79,
  4, 79, 28, 79, 29, 79, 30, 79, 31, 95,  1, 95,  2, 95,  3, 95,
  4, 95, 28, 95, 29, 95, 30, 95, 31,159,  1,159,  2,159,  3,159,
  4,159, 28,159, 29,159, 30,159, 31,191,  1,191,  2,191,  3,191,
  4,191, 28,191, 29,191, 30,191, 31, 40, 93,  1, 93,  1, 17, 51,
 17, 35, 17, 51, 50, 54, 53, 52, 38, 35,  1, 33, 32,  4, 23, 22,
 18, 21, 20,  2,  7,  6,  4, 41,  1, 17, 35, 17, 51,  2, 80,235,
235,137,236,249,248,237,253,246,  1,149,  1, 85,  1, 76,120,104,
103,103,104,121,254,176,254,176,254,107,174,174,  4,178,254,191,
254,252,254,182,234,223,222,232,  1, 35, 97,116,101,254,248,167,
169,254,247,101,116, 97,  2,109,  1,  4,  0,  2,  0, 88,255,227,
  5, 39,  6, 20,  0, 14,  0, 40,  0,245, 64, 89, 38, 39, 40, 39,
 37, 36, 37, 40, 40, 39, 34, 35, 34, 31, 32, 31, 33, 32, 32, 31,
 34, 33, 32,  3, 31, 53, 40, 15, 40, 28, 29,  2, 30, 53, 15, 15,
 40, 37, 40, 39, 38, 37, 34, 33, 32, 31,  8, 35, 30,  3, 15, 35,
  3,161, 27,  9,161, 21,152, 27, 35,163, 41, 15, 39, 38,  3, 18,
 12, 32, 33, 35,  3, 24, 40, 37, 34, 31,  4, 30,  6, 12, 66, 18,
  6, 66, 24, 59, 41, 16,252,236,212,236, 17, 57, 23, 57, 18, 23,
 57, 17, 18, 23, 57, 49,  0, 16,236,196,244,236, 16,238, 18, 57,
 18, 57, 18, 23, 57, 48, 75, 83, 88,  7, 16,  5,237, 23, 57,  7,
 16,  5,237, 23, 50,  7, 16, 14,201,  7, 16,  8,201,  7, 16,  8,
201,  7, 16, 14,201, 89, 34,  1, 75,176, 15, 84, 75,176, 16, 84,
 91, 88,189,  0, 41,  0, 64,  0,  1,  0, 41,  0, 41,255,192, 56,
 17, 55, 56, 89, 64, 54,102, 33,  1, 47, 42, 55, 31, 54, 34, 63,
 42, 79, 42,111,  4,111,  5,111,  6,111,  7,111,  8,111, 22,111,
 23,111, 24,111, 25,111, 26,127,  4,127,  5,127,  6,127,  7,127,
  8,127, 22,127, 23,127, 24,127, 25,127, 26, 25, 93,  0, 93,  1,
 46,  1, 35, 34,  6, 21, 20, 22, 51, 50, 54, 53, 52, 38, 19, 22,
 18, 21, 16,  0, 33, 32,  0, 17, 52,  0, 33, 50, 22, 23, 39,  5,
 39, 37, 39, 33, 23, 37, 23,  5,  3,152, 55,108, 52,117,127,130,
114,117,124, 13,163,117,106,254,187,254,223,254,222,254,185,  1,
 45,  1,  8, 46, 78, 36,190,254,139, 37,  1, 51,188,  1, 96,111,
  1,120, 35,254,197,  2,231, 27, 27,133,121,148,168,171,161, 45,
 92,  1,148,136,254,255,148,254,236,254,200,  1, 56,  1, 20,231,
  1,  9, 13, 14,219,119,129, 97,202,116,114,129, 96,  0,255,255,
255,236,  0,  0,  5,223,  7,107,  2, 39,  0, 60,  0,  0,  0,  0,
  0,  7,  1,  4,  0,205,  1,117,255,255,  0, 25,254, 70,  5, 18,
  6,102,  2, 39,  0, 92,  0,  0,  0,  0,  0,  7,  0,141,  0,156,
  0,  0,  0,  2,  0,188,  0,  0,  5,137,  5,213,  0, 12,  0, 21,
  0,140, 64, 24, 14,174,  0, 13,174,  5,  3,141,  1, 21, 15, 12,
  6,  0, 18, 45,  9, 13,  4,  0, 22,  2,  3, 22, 16,252,236, 50,
 50,212,236, 17, 57, 57, 57, 57, 49,  0, 47,228,212,236,212,236,
 48,  0, 75,176,  9, 84, 75,176, 12, 84, 91, 75,176, 14, 84, 91,
 75,176, 19, 84, 91, 75,176, 20, 84, 91, 88,189,  0, 22,255,192,
  0,  1,  0, 22,  0, 22,  0, 64, 56, 17, 55, 56, 89, 64, 44,  0,
 23,  1,  0,  1,  0,  2,  0,  3,  0,  4, 48,  1, 48,  2, 48,  3,
 48,  4, 80,  1, 80,  2, 80,  3, 80,  4,160,  1,160,  2,160,  3,
160,  4,176,  1,176,  2,176,  3,176,  4, 20, 93,  1, 93,  1, 17,
 33, 17, 33, 17, 51, 32,  4, 21, 20,  4, 33,  3, 17, 51, 50, 54,
 53, 52, 38, 35,  2, 61,254,127,  1,129,254,  1, 29,  1, 49,254,
207,254,227,254,213,112,122,122,112,  1,  2,254,254,  5,213,254,
252,253,235,234,253,  2,186,254, 93,109, 99,101,110,  0,  0,  2,
  0,172,254, 86,  5, 94,  6, 20,  0, 16,  0, 28,  0, 59, 64, 29,
 17,161,  5,208,  8, 23,161,  0,208, 14,152,  8,202,  1,222,  3,
163, 29, 26, 66, 11, 64, 20,  4,  0, 13,  2, 16, 29, 16,252,236,
 50, 50,244,236, 49,  0, 16,236,228,228,244,228,236, 16,230,238,
 48,180, 79, 30, 96, 30,  2,  1, 93, 37, 17, 33, 17, 33, 17, 62,
  1, 51, 50,  0, 17, 16,  0, 35, 34, 38, 19, 34,  6, 21, 20, 22,
 51, 50, 54, 53, 52, 38,  2, 18,254,154,  1,102, 74,180,117,207,
  1, 10,254,246,207,117,180,164,115,123,123,115,115,121,121,162,
253,180,  7,190,253,168, 98, 93,254,183,254,253,254,253,254,183,
 93,  3, 55,169,159,159,169,168,160,160,168,  0,  0,  1,  0,217,
  2, 12,  5,219,  2,248,  0,  3,  0, 18,183,  2,167,  0,166,  4,
  1,  0,  4, 16,212,196, 49,  0, 16,244,236, 48, 19, 33, 21, 33,
217,  5,  2,250,254,  2,248,236,  0,  1,  1,  0,  0, 41,  5,180,
  4,219,  0, 11,  0, 47, 64, 28, 10,  8,  7,  6,  4,  2,  1,  0,
  8,  5,  3, 11,  9, 12, 11, 10,  9,  7,  5,  4,  3,  1,  8,  2,
  0,  8,  6, 12, 16,212, 60,204, 50, 23, 57, 49,  0, 16,212, 60,
204, 50, 23, 57, 48,  9,  2,  7,  1,  1, 39,  1,  1, 55,  1,  1,
  5,180,254, 78,  1,178,168,254, 78,254, 78,168,  1,178,254, 78,
168,  1,178,  1,178,  4, 51,254, 78,254, 80,168,  1,176,254, 80,
168,  1,176,  1,178,168,254, 78,  1,178,  0,  1,  0,123,  2,156,
  3, 14,  5,223,  0, 10,  0, 55,180,  2,  4,  3,  7,  0,190,  1,
 32,  0,  9,  0,  3,  1, 31,  0,  4,  0,  9,  1, 30, 64, 12,  5,
154, 11,  8,133,  6,134,  3,  0,133,  1, 11, 16,212,228,196,252,
228, 49,  0, 16,244,236,212,236, 16,238, 50, 17, 18, 57, 48, 19,
 51, 17,  7, 53, 55, 51, 17, 51, 21, 33,141,207,225,229,226,204,
253,127,  3, 57,  2,  9, 52,160, 49,253, 90,157,  0,  1,  0,109,
  2,156,  3, 14,  5,240,  0, 24,  0, 93, 64, 18,  0,  5,  4, 23,
  1, 22, 24,  5,  5,  4, 37, 15, 18, 11,  5, 24, 14,  0,184,  1,
 32,178,  2, 14, 11,186,  1, 34,  0,  2,  1, 30, 64, 15, 18,156,
 25, 24, 21,  5,  0, 14,  8,136, 21,  1, 14,  3, 25, 16,220,196,
212,212,236, 17, 57, 57, 17, 57, 49,  0, 16,244,236,252,196, 16,
238, 17, 57, 57, 17, 18, 57, 48, 75, 83, 88,  7, 16,  5,201, 17,
 23, 57,  7,  5,201, 89, 34,  1, 33, 21, 33, 53,  1, 54, 54, 53,
 52, 38, 35, 34,  6,  7, 53, 54, 54, 51, 50, 22, 21, 20,  6,  7,
  1,156,  1,114,253, 95,  1, 57, 61, 52, 73, 59, 62,142, 84, 87,
163, 75,158,180, 71,101,  3, 68,168,153,  1, 10, 53, 80, 40, 50,
 62, 45, 47,186, 27, 27,129,111, 72,121, 86,  0,  0,  1,  0, 90,
  2,141,  3, 18,  5,240,  0, 40,  0, 87, 64, 11, 32, 35, 28,  9,
 13,  6,  0, 21, 19, 10, 13,184,  1, 34,178,  6, 31, 28,188,  1,
 34,  0, 19,  1, 35,  0,  6,  1, 30, 64, 19, 35,156, 41, 22, 19,
 25, 20,  0, 16, 25,136, 38, 16,136,  3, 20, 31,  9, 41, 16,220,
196,196,212,236,212,236, 18, 57, 17, 18, 57, 57, 49,  0, 16,244,
236,236,252,196, 16,254,197, 16,206, 57, 17, 18, 57, 17, 18, 57,
 48,  1, 22, 22, 21, 20,  6, 35, 34, 38, 39, 53, 22, 22, 51, 50,
 54, 53, 52, 38, 35, 35, 53, 51, 50, 54, 53, 52, 38, 35, 34,  6,
  7, 53, 54, 54, 51, 50, 22, 21, 20,  6,  2, 80, 92,102,198,201,
 81,148, 68, 66,128, 60, 95,104,107,114, 74, 84, 98, 90, 78, 80,
 52,123, 70, 65,151, 87,167,177, 90,  4, 96, 18,110, 81,129,129,
 23, 22,174, 36, 37, 64, 59, 64, 61,137, 47, 51, 45, 45, 26, 27,
166, 17, 18,112,105, 69, 96,  0,  0,  4,  0,100,255,227,  7,168,
  5,240,  0,  2,  0, 13,  0, 17,  0, 28,  0,155, 64, 26, 17, 11,
 16, 16, 15, 15, 11, 14, 14, 17,  1, 13,  3, 13,  0,  3,  3, 13,
 37, 20, 22, 21,  0, 27,  5,  1,184,  1, 31,178,  7, 25, 18,190,
  1, 31,  0, 27,  0, 21,  1, 31,  0, 22,  0, 27,  1, 30,180, 23,
156, 11,  7,  3,184,  1, 30, 64, 29, 14,152, 16,156,  9, 15, 24,
 19,  1, 12, 17,  0, 12,  6, 10,  0,134,  4, 26,133, 24,134, 18,
133, 21, 19,  8,  4, 29, 16,196, 50,212,196,228,252,228, 16,236,
 50,196,198, 18, 57, 17, 57, 17, 18, 57, 49,  0, 47,230,228,238,
196, 50,246,238,214,238, 16,238, 50, 16,238, 50, 17, 57, 17, 18,
 57, 48, 75, 83, 88,  7, 16,  4,201,  7, 16,  5,201,  7, 16,  5,
237,  7, 16,  5,237, 89, 34,  1,  3, 51,  3, 51, 17, 51, 21, 35,
 21, 35, 53, 33, 53,  1, 35,  1, 51,  1, 51, 17,  7, 53, 55, 51,
 17, 51, 21, 33,  6, 57,239,239, 18,248,137,137,230,254,121,254,
 43,223,  3,166,223,249,244,205,224,230,223,205,253,129,  2,129,
254,188,  2,  7,253,249,155,162,162,168,254,153,  6, 13,253, 73,
  2,  9, 52,160, 49,253, 90,157,  0,  3,  0,100,255,227,  7,229,
  5,240,  0, 24,  0, 28,  0, 39,  0,172, 64, 32, 28, 11, 27, 27,
 26, 26, 11, 25, 25, 28,  0,  5,  4, 23,  1, 22, 24,  5,  5,  4,
 37, 31, 33, 32, 15, 29, 11,  5, 24,  0, 14, 11,184,  1, 36,178,
 18, 36, 29,190,  1, 31,  0, 38,  0, 32,  1, 31,  0, 33,  0, 38,
  1, 30,178, 34,156,  0,186,  1, 31,  0, 18,  1, 30, 64, 32, 25,
152, 27,156,  2, 26, 35, 30, 24, 21, 28,  5,  0,  3, 14,  8,136,
 21, 37,133, 35,134, 29,133, 32, 30, 21,  1, 14,  3, 30, 40, 16,
196,212,196,212,196, 16,196,228,254,228, 16,238, 17, 23, 57, 17,
 57, 17, 18, 57, 49,  0, 47,230,228,238,238,246,238,214,238, 16,
238, 50, 16,254,196, 17, 57, 57, 17, 18, 57, 17, 18, 57, 48, 75,
 83, 88,  7, 16,  5,201, 17, 23, 57,  7,  5,201,  7, 16,  5,237,
  7, 16,  5,237, 89, 34, 37, 33, 21, 33, 53,  1, 54, 54, 53, 52,
 38, 35, 34,  6,  7, 53, 54, 54, 51, 50, 22, 21, 20,  6,  7,  1,
 35,  1, 51,  1, 51, 17,  7, 53, 55, 51, 17, 51, 21, 33,  6,113,
  1,116,253, 93,  1, 59, 62, 51, 74, 60, 62,139, 85, 88,161, 74,
159,179, 73, 99,251,170,223,  3,166,223,249,244,205,224,230,223,
205,253,129,168,168,154,  1, 12, 53, 78, 39, 50, 63, 45, 48,187,
 27, 26,127,111, 72,124, 84,254,149,  6, 13,253, 73,  2,  9, 52,
160, 49,253, 90,157,  0,  0,  4,  0,104,255,227,  7,168,  5,240,
  0, 10,  0, 13,  0, 54,  0, 58,  0,193, 64, 32, 58, 11, 57, 57,
 56, 56, 11, 55, 55, 58, 12, 10,  0, 10, 11,  0,  0, 10, 37, 46,
 49, 42, 23, 27, 11, 20,  2, 14, 35, 33, 12,  2,184,  1, 31,180,
  4, 35, 33, 24, 27,184,  1, 36,178, 20, 45, 42,188,  1, 36,  0,
 20,  1, 30,  0, 33,  1, 35,181, 57, 49,156, 55,152,  0,184,  1,
 30, 64, 36,  8,  4,  6, 36, 56, 39, 34, 12,  9, 58,  7,  1, 33,
 39, 34, 14, 52, 30,  9,  3, 11,  7,134,  1, 39,136, 52, 30,136,
 17, 45, 34, 23,  5,  1, 59, 16,196, 50,212,196,196,212,236,212,
236, 16,238, 50,196,198, 17, 18, 57, 17, 18, 57, 17, 18, 57, 17,
 57, 17, 18, 57, 57, 49,  0, 47,196, 50,238,228,246, 60,238,238,
254,196, 16,254,197, 16,206, 16,238, 50, 17, 18, 57, 17, 18, 57,
 17, 57, 17, 18, 57, 48, 75, 83, 88,  7, 16,  4,201,  7, 16,  5,
201,  7, 16,  5,237,  7, 16,  5,237, 89, 34,  1, 51, 17, 51, 21,
 35, 21, 35, 53, 33, 53,  1,  3, 51,  1, 22, 22, 21, 20,  6, 35,
 34, 38, 39, 53, 22, 22, 51, 50, 54, 53, 52, 38, 35, 35, 53, 51,
 50, 54, 53, 52, 38, 35, 34,  6,  7, 53, 54, 54, 51, 50, 22, 21,
 20,  6, 19, 35,  1, 51,  6, 39,248,137,137,230,254,121,  1,135,
239,239,252, 37, 93,102,199,201, 81,148, 68, 66,128, 60, 95,104,
106,115, 74, 84, 98, 91, 79, 79, 53,122, 71, 65,152, 86,167,177,
 90, 45,223,  3,166,223,  3, 68,253,249,155,162,162,168,  1, 55,
254,188,  3, 35, 18,110, 81,129,129, 23, 22,174, 36, 37, 64, 59,
 64, 61,137, 47, 51, 45, 45, 26, 27,166, 17, 18,112,105, 69, 96,
251,113,  6, 13,255,255,  0,102,255,227,  5,250,  7,107,  2, 39,
  0, 42,  0,  0,  0,  0,  0,  7,  1,  9,  1, 49,  1,117,255,255,
  0, 92,254, 70,  5, 14,  6, 70,  2, 39,  0, 74,  0,  0,  0,  0,
  0,  7,  0,218,  0,221,  0,  0,255,255,  0,188,  0,  0,  2, 61,
  7,107,  2, 39,  0, 44,  0,  0,  0,  0,  0,  7,  1, 10,255,100,
  1,117,255,255,  0,147,254,111,  5, 45,  5,240,  2, 39,  0, 54,
  0,  0,  0,  0,  0,  7,  0,221,  0,221,  0,  0,255,255,  0,106,
254,111,  4, 98,  4,123,  2, 39,  0, 86,  0,  0,  0,  0,  0,  7,
  0,221,  0, 98,  0,  0,255,255,  0,102,255,227,  5, 92,  7,107,
  2, 39,  0, 38,  0,  0,  0,  0,  0,  7,  1,  4,  1,102,  1,117,
255,255,  0, 88,255,227,  4,117,  6,102,  2, 39,  0, 70,  0,  0,
  0,  0,  0,  7,  0,141,  0,211,  0,  0,255,255,  0,102,255,227,
  5, 92,  7,107,  2, 39,  0, 38,  0,  0,  0,  0,  0,  7,  1,  8,
  1,102,  1,117,255,255,  0, 88,255,227,  4, 76,  6,102,  2, 39,
  0, 70,  0,  0,  0,  0,  0,  7,  0,224,  0,211,  0,  0,  0,  2,
  0, 92,255,227,  5,168,  6, 20,  0, 24,  0, 36,  0, 75,186,  0,
  7,  0,  3,  1, 37, 64, 34,  9,  1, 31,161,  0,208, 22, 25,161,
 13,208, 16,152, 22,202,  5,163, 11,  2, 28, 12,  4,  3,  0, 13,
  8, 10,  6, 64, 34, 66, 19, 59, 37, 16,252,236,244, 60,196,252,
 23, 60,196, 49,  0, 47,236,228,244,228,236, 16,228,238,221, 60,
238, 50, 48,178, 79, 38,  1,  1, 93,  1, 17, 33, 53, 33, 53, 33,
 21, 51, 21, 35, 17, 33, 53, 14,  1, 35, 34,  0, 17, 16,  0, 51,
 50, 22,  3, 50, 54, 53, 52, 38, 35, 34,  6, 21, 20, 22,  3,166,
254,186,  1, 70,  1,104,154,154,254,152, 74,178,117,207,254,246,
  1, 10,207,116,179,162,115,121,121,115,114,121,121,  3,188,  1,
 25,205,114,114,205,251, 43,162, 99, 92,  1, 73,  1,  3,  1,  3,
  1, 73, 93,252,201,168,160,160,168,168,160,160,168,  0,  0,  1,
  0,111,  1,188,  2,227,  2,223,  0,  3,  0, 18,183,  2,171,  0,
170,  4,  1,  0,  4, 16,212,196, 49,  0, 16,244,236, 48, 19, 33,
 17, 33,111,  2,116,253,140,  2,223,254,221,  0,  0,  1,  0,209,
  2,  6,  2, 57,  3,137,  0,  3,  0, 18,183,  2,  0,  4,  1,  2,
  0, 19,  4, 16,252,236, 49,  0, 16,212,204, 48, 19, 33, 17, 33,
209,  1,104,254,152,  3,137,254,125,  0,  0,  1,255,217,255,227,
  5,  8,  5,240,  0, 49,  0,114, 64, 59, 24, 28, 21,  0, 46,  3,
 42,  6,247, 40,  8, 31, 17,247, 15, 49, 46,174,  3, 25, 28,174,
 21,156,  3,152, 33, 15, 50, 42, 40, 34,  3, 37, 33, 41, 32, 17,
  8, 50, 15,  9, 12, 43, 31, 41, 18,  6, 12, 32, 41, 37, 22, 16,
  7, 24,  0, 12, 50, 16,212,196, 50,196, 50,252,196,196, 18, 57,
 57, 18, 57, 57, 18, 57, 57, 17, 57, 57, 17, 18, 57, 17, 23, 57,
 49,  0, 16,196, 50,228,244,252,196, 16,254,196, 16,238, 50,221,
 60,238, 50, 17, 18, 57, 17, 18, 57, 48, 37,  6,  6, 35, 32,  0,
 39, 35, 55, 51, 38, 38, 53, 52, 54, 55, 35, 55, 51, 54,  0, 33,
 50, 22, 23, 17, 38, 38, 35, 34,  6,  7, 33,  7, 33,  6,  6, 21,
 20, 22, 23, 33,  7, 33, 22, 22, 51, 50, 54, 55,  5,  8, 95,207,
112,254,250,254,153, 75,217, 88, 98,  1,  1,  1,  1,186, 88,129,
 77,  1,101,  1,  6,112,207, 95, 81,184, 99,127,179, 45,  2, 27,
 86,254, 19,  2,  1,  1,  1,  1,173, 89,254,213, 50,175,126, 99,
181, 84, 82, 55, 56,  1,  5,245,195, 14, 31, 28, 29, 32, 15,195,
246,  1,  2, 56, 55,254,203, 78, 79,123,118,195, 16, 36, 36, 13,
 31, 17,195,122,122, 79, 79,  0,  0,  2,  0,197,  5,  0,  3, 59,
  5,246,  0,  3,  0,  7,  0, 28, 64, 13,  4,  0,241,  6,  2,  8,
  5, 18,  4,  1, 18,  0,  8, 16,212,252,212,236, 49,  0, 16,212,
 60,236, 50, 48, 19, 51, 21, 35, 37, 51, 21, 35,197,235,235,  1,
139,235,235,  5,246,246,246,246,  0,  1,  1,109,  4,238,  3, 78,
  5,246,  0,  3,  0, 56,181,  0,  2,  4,  1,  3,  4, 16,212,196,
 49,  0, 16,212,196, 48,  0, 75,176, 12, 84, 88,189,  0,  4,255,
192,  0,  1,  0,  4,  0,  4,  0, 64, 56, 17, 55, 56, 89, 64, 13,
 15,  0, 15,  1, 31,  0, 31,  1, 47,  0, 47,  1,  6, 93,  1, 33,
  1, 35,  2, 51,  1, 27,254,227,196,  5,246,254,248,  0,  0,  1,
  0,164,  4,238,  3, 92,  5,248,  0, 35,  0,195, 64, 11, 20, 19,
 23, 16,  8,  1,  0,  3,  9, 26, 16,187,  1, 28,  0,  5,  0, 23,
  1, 28, 64, 19, 33,  9, 36, 20,  1, 19,  0, 26, 13, 10,  8, 27,
 26,128, 30,  8,128, 10, 36, 16,212,236,212,236,192, 17, 18, 57,
 18, 57, 57, 57, 57, 49,  0, 16,212, 60,236,212,236, 50, 18, 23,
 57, 17, 18, 57, 57, 48,  0, 75,176, 12, 84, 88,189,  0, 36,255,
192,  0,  1,  0, 36,  0, 36,  0, 64, 56, 17, 55, 56, 89, 64, 92,
  9,  0,  9,  1,  9,  2,  9,  3, 11, 15, 11, 16, 11, 17, 11, 18,
 11, 19,  9, 20, 11, 22, 12, 23, 12, 24, 15, 25, 15, 26, 15, 27,
 15, 28, 15, 29, 15, 30, 15, 31,  9, 35, 26,  0, 26,  1, 26,  2,
 26,  3, 27, 15, 27, 16, 27, 17, 27, 18, 27, 19, 27, 20, 27, 21,
 27, 22, 27, 23, 27, 24, 31, 25, 31, 26, 31, 27, 31, 28, 31, 29,
 31, 30, 31, 31, 26, 35, 43,  6, 14, 22, 14,  2, 93,  1, 93,  1,
 39, 38, 39, 38, 35, 34,  6, 29,  1, 35, 52, 54, 53, 52, 54, 51,
 50, 22, 31,  1, 30,  1, 51, 50, 54, 53, 51, 20,  6, 21, 20,  6,
 35, 34, 38,  2,  2, 56,  3,  7, 45, 28, 32, 40,139,  2,107, 87,
 37, 74, 39, 59, 21, 39, 16, 37, 39,139,  2,107, 87, 38, 70,  5,
 31, 35,  2,  4, 26, 60, 50,  6,  5, 20,  5,106,130, 25, 24, 39,
 14, 15, 60, 57,  6, 20,  5,106,129, 22,  0,  1,  0,178,  4,238,
  2,147,  5,246,  0,  3,  0, 56,181,  0,  1,  4,  1,  3,  4, 16,
212,196, 49,  0, 16,212,196, 48,  0, 75,176, 12, 84, 88,189,  0,
  4,255,192,  0,  1,  0,  4,  0,  4,  0, 64, 56, 17, 55, 56, 89,
 64, 13, 15,  0, 15,  3, 31,  0, 31,  3, 47,  0, 47,  3,  6, 93,
  1, 19, 35,  1,  1,205,198,196,254,227,  5,246,254,248,  1,  8,
  0,  1,  0,135,  4,238,  3,121,  5,246,  0,  6,  0, 69, 64,  9,
  4,  0,  5,  2,  7,  4,  2,  6,  7, 16,212,196, 57, 49,  0, 16,
212, 60,196, 57, 48,  0, 75,176, 12, 84, 88,189,  0,  7,255,192,
  0,  1,  0,  7,  0,  7,  0, 64, 56, 17, 55, 56, 89, 64, 19, 15,
  0, 15,  1, 15,  4, 31,  0, 31,  1, 31,  4, 47,  0, 47,  1, 47,
  4,  9, 93,  1, 33, 19, 35, 39,  7, 35,  1,102,  1, 52,223,178,
199,199,178,  5,246,254,248,161,161,  0,  0,  1,  0,135,  4,238,
  3,121,  5,246,  0,  6,  0, 75, 64,  9,  3,  4,  1,  0,  7,  3,
  5,  1,  7, 16,212,196, 57, 49,  0, 16,212,196, 50, 57, 48,  0,
 75,176, 12, 84, 88,189,  0,  7,255,192,  0,  1,  0,  7,  0,  7,
  0, 64, 56, 17, 55, 56, 89, 64, 25, 15,  1, 15,  2, 15,  4, 15,
  5, 31,  1, 31,  2, 31,  4, 31,  5, 47,  1, 47,  2, 47,  4, 47,
  5, 12, 93,  1,  3, 51, 23, 55, 51,  3,  1,102,223,178,199,199,
178,223,  4,238,  1,  8,162,162,254,248,  0,  1,  0,176,  4,238,
  3, 80,  5,246,  0, 13,  0, 83, 64, 12,  4,  7,  0, 11, 14,  7,
129,  8,  1,129,  0, 14, 16,212,236,212,236, 49,  0, 16,212,196,
 50,204, 48,  0, 75,176, 12, 84, 88,189,  0, 14,255,192,  0,  1,
  0, 14,  0, 14,  0, 64, 56, 17, 55, 56, 89, 64, 29, 15,  0, 15,
  1, 15,  7, 15,  8, 31,  0, 31,  1, 31,  7, 31,  8, 47,  0, 47,
  1, 47,  7, 47,  8, 47,  9, 47, 13, 14, 93, 19, 51, 30,  1, 51,
 50, 54, 55, 51, 14,  1, 35, 34, 38,176,143, 21, 96, 76, 76, 96,
 21,143, 16,172,148,148,172,  5,246, 61, 60, 60, 61,129,135,135,
  0,  1,  1,119,  5,  0,  2,137,  5,246,  0,  3,  0, 42,183,  0,
241,  2,  4,  1,130,  0,  4, 16,212,236, 49,  0, 16,212,236, 48,
  0, 75,176, 12, 84, 88,189,  0,  4,255,192,  0,  1,  0,  4,  0,
  4,  0, 64, 56, 17, 55, 56, 89,  1, 33, 21, 33,  1,119,  1, 18,
254,238,  5,246,246,  0,  0,  0,  0,  0,  0,  2,  0,  1,  0,  0,
  0,  0,  0, 20,  0,  3,  0,  1,  0,  0,  1, 26,  0,  0,  1,  6,
  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  1,  3,  0,  0,  0,  2,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,
  0,  0,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16,
 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96,
 97,  0, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,
112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
208,209,  0,210,211,212,213,214,215,216,217,218,219,220,221,222,
223,224,  0,  4,  2, 62,  0,  0,  0, 58,  0, 32,  0,  4,  0, 26,
  0,126,  0,255,  1,  7,  1, 17,  1, 31,  1, 49,  1, 66,  1, 83,
  1, 97,  1,120,  1,126,  1,146,  2,199,  2,221,  3,169,  3,192,
 32, 38, 32, 48, 32, 58, 32,172, 33, 34, 34,  6, 34, 30, 34, 43,
 34, 72, 34,101, 37,202,251,  2,255,255,  0,  0,  0, 32,  0,160,
  1,  6,  1, 12,  1, 30,  1, 48,  1, 65,  1, 82,  1, 94,  1,120,
  1,125,  1,146,  2,198,  2,216,  3,169,  3,192, 32, 19, 32, 48,
 32, 57, 32,172, 33, 34, 34,  2, 34, 15, 34, 43, 34, 72, 34, 96,
 37,202,251,  1,255,255,255,227,  0,  0,255,245,  0,  0,255,216,
  0,  0,255,160,255, 94,  0,  0,255, 67,255,104,255, 20,  0,  0,
  0,  0,252,246,252,219,  0,  0,224,150,224,133,224, 86,223,106,
  0,  0,  0,  0,222,113,222, 95,  0,  0,218,239,  5,191,  0,  1,
  0,  0,  0, 56,  0,  0,  0,244,  0,  0,  0,252,  0,  0,  0,  0,
  0,250,  0,  0,  0,  0,  0,  0,  0,250,  0,252,  0,  0,  0,  0,
  1,  2,  0,  0,  0,  0,  0,  0,  0,  0,  1, 32,  1, 40,  0,  0,
  0,  0,  1, 66,  0,  0,  0,  0,  0,  0,  0,172,  0,163,  0,132,
  0,133,  0,189,  0,150,  0,231,  0,134,  0,142,  0,139,  0,157,
  0,169,  0,164,  1,  0,  0,138,  0,217,  0,131,  0,147,  0,241,
  0,242,  0,141,  0,151,  0,136,  0,195,  0,221,  0,240,  0,158,
  0,170,  0,243,  0,244,  0,245,  0,162,  0,173,  0,201,  0,199,
  0,174,  0, 98,  0, 99,  0,144,  0,100,  0,203,  0,101,  0,200,
  0,202,  0,207,  0,204,  0,205,  0,206,  0,232,  0,102,  0,210,
  0,208,  0,209,  0,175,  0,103,  0,239,  0,145,  0,213,  0,211,
  0,212,  0,104,  0,234,  0,236,  0,137,  0,106,  0,105,  0,107,
  0,109,  0,108,  0,110,  0,160,  0,111,  0,113,  0,112,  0,114,
  0,115,  0,117,  0,116,  0,118,  0,119,  0,233,  0,120,  0,122,
  0,121,  0,123,  0,125,  0,124,  0,184,  0,161,  0,127,  0,126,
  0,128,  0,129,  0,235,  0,237,  0,186,  0,253,  0,254,  0,  0,
  0,  0,  0,  0,  0,255,  0,248,  0,214,  0,249,  0,250,  0,227,
  0,228,  0,215,  0,224,  0,218,  0,219,  0,220,  0,223,  0,216,
  0,222,  0,178,  0,179,  0,  0,  0,  0,  0,  0,  0,182,  0,183,
  0,196,  0,  0,  0,180,  0,181,  0,197,  0,  0,  0,130,  0,194,
  0,135,  0,  0,  0,  0,  0,  0,  0,171,  0,152,  0,  0,  0,  0,
  0,  0,  0,168,  0,154,  0,  0,  0,153,  0,238,  0,  0,  0,  0,
  0,188,  0,  0,  0,  0,  0,  0,  1,  1,  0,165,  0,  0,  0,  0,
  0,  0,  0,146,  0,143,  0,  0,  0,  0,  0,  0,  0,148,  0,149,
  4,205,  0,102,  0,  0,  0,  0,  2,201,  0,  0,  2,201,  0,  0,
  3,166,  1, 31,  4, 43,  0,195,  6,180,  0,139,  5,145,  0,160,
  8,  4,  0, 66,  6,250,  0,123,  2,115,  0,195,  3,168,  0,176,
  3,168,  0,164,  4, 47,  0, 41,  6,180,  0,217,  3, 10,  0,109,
  3, 82,  0,111,  3, 10,  0,209,  2,236,  0,  0,  5,145,  0, 98,
  5,145,  0,231,  5,145,  0,162,  5,145,  0,137,  5,145,  0, 92,
  5,145,  0,158,  5,145,  0,127,  5,145,  0,137,  5,145,  0,125,
  5,145,  0,106,  3, 51,  0,229,  3, 51,  0,129,  6,180,  0,217,
  6,180,  0,217,  6,180,  0,217,  4,164,  0,141,  8,  0,  0,135,
  6, 49,  0, 10,  6, 25,  0,188,  5,223,  0,102,  6,164,  0,188,
  5,119,  0,188,  5,119,  0,188,  6,145,  0,102,  6,178,  0,188,
  2,250,  0,188,  2,250,255,141,  6, 51,  0,188,  5, 25,  0,188,
  7,246,  0,188,  6,178,  0,188,  6,205,  0,102,  5,221,  0,188,
  6,205,  0,102,  6, 41,  0,188,  5,195,  0,147,  5,117,  0, 10,
  6,127,  0,188,  6, 49,  0, 10,  8,211,  0, 61,  6, 43,  0, 39,
  5,203,255,236,  5,205,  0, 92,  3,168,  0,176,  2,236,  0,  0,
  3,168,  0,139,  6,180,  0,207,  4,  0,  0,  0,  4,  0,  0, 94,
  5,102,  0, 88,  5,186,  0,172,  4,190,  0, 88,  5,186,  0, 92,
  5,109,  0, 88,  3,123,  0, 39,  5,186,  0, 92,  5,178,  0,172,
  2,190,  0,172,  2,190,255,188,  5, 82,  0,172,  2,190,  0,172,
  8, 86,  0,170,  5,178,  0,172,  5,127,  0, 88,  5,186,  0,172,
  5,186,  0, 92,  3,242,  0,172,  4,195,  0,106,  3,211,  0, 27,
  5,178,  0,160,  5, 55,  0, 31,  7,100,  0, 72,  5, 41,  0, 31,
  5, 55,  0, 25,  4,168,  0, 92,  5,178,  1,  0,  2,236,  1,  4,
  5,178,  1,  0,  6,180,  0,217,  6, 49,  0, 10,  6, 49,  0, 10,
  5,223,  0,102,  5,119,  0,188,  6,178,  0,188,  6,205,  0,102,
  6,127,  0,188,  5,102,  0, 88,  5,102,  0, 88,  5,102,  0, 88,
  5,102,  0, 88,  5,102,  0, 88,  5,102,  0, 88,  4,190,  0, 88,
  5,109,  0, 88,  5,109,  0, 88,  5,109,  0, 88,  5,109,  0, 88,
  2,190,  0,172,  2,190,255,213,  2,190,255,254,  2,190,  0, 60,
  5,178,  0,172,  5,127,  0, 88,  5,127,  0, 88,  5,127,  0, 88,
  5,127,  0, 88,  5,127,  0, 88,  5,178,  0,160,  5,178,  0,160,
  5,178,  0,160,  5,178,  0,160,  4,  0,  0, 53,  4,  0,  0,178,
  5,145,  0,174,  5,145,  0,125,  4,  0,  0, 14,  5, 29,  1, 39,
  5, 23,  0,129,  5,193,  0,172,  8,  0,  1, 27,  8,  0,  1, 27,
  8,  0,  1, 39,  4,  0,  1,109,  4,  0,  0,197,  6,180,  0,217,
  8,174,  0,  0,  6,205,  0, 45,  6,170,  0,195,  6,180,  0,217,
  6,180,  0,217,  6,180,  0,217,  5,145,  0, 25,  5,227,  0,174,
  4, 90,  0, 59,  5,190,  0, 41,  6, 76,  0,150,  5, 39,255,221,
  4,225,  0, 51,  4,131,  0,158,  4,131,  0,117,  6, 39,  0, 55,
  8, 98,  0, 88,  5,127,  0, 78,  4,164,  0,141,  3,166,  1, 31,
  6,180,  0,217,  5, 86,  0, 76,  5,145,  0,  6,  6,180,  0,217,
  5,147,  0,  0,  5, 43,  0,158,  5, 43,  0,193,  8,  0,  0,162,
  5,145,  0,  0,  6, 49,  0, 10,  6, 49,  0, 10,  6,205,  0,102,
  9, 86,  0,102,  8,193,  0, 88,  4,  0,  0,  0,  8,  0,  0,  0,
  5, 66,  0,211,  5, 66,  0,188,  3, 10,  0,211,  3, 10,  0,129,
  6,180,  0,217,  3,244,  0,  6,  5, 55,  0, 25,  5,203,255,236,
  1, 86,254,104,  5, 23,  0, 74,  3, 76,  0,158,  3, 76,  0,193,
  5,238,  0, 43,  5,238,  0, 39,  4,  0,  0, 51,  3, 10,  0,209,
  3, 10,  0,147,  5, 66,  0,147, 11,133,  0, 66,  6, 49,  0, 10,
  5,119,  0,188,  6, 49,  0, 10,  5,119,  0,188,  5,119,  0,188,
  2,250,  0,188,  2,250,255,235,  2,250,  0, 41,  2,250,  0, 22,
  6,205,  0,102,  6,205,  0,102,  6,205,  0,102,  6,127,  0,188,
  6,127,  0,188,  6,127,  0,188,  2,190,  0,172,  4,  0,  0,135,
  4,  0,  0,164,  4,  0,  0,197,  4,  0,  0,176,  4,  0,  1,119,
  4,  0,  0,227,  4,  0,  1,  6,  4,  0,  0,193,  4,  0,  1, 86,
  4,  0,  0,135,  5, 35,255,164,  2,248,255,219,  5,195,  0,147,
  4,195,  0,106,  5,205,  0, 92,  4,168,  0, 92,  2,236,  1,  4,
  6,180,  0, 33,  5,127,  0, 88,  5,203,255,236,  5, 55,  0, 25,
  5,231,  0,188,  5,186,  0,172,  6,180,  0,217,  6,180,  1,  0,
  3,129,  0,123,  3,129,  0,109,  3,129,  0, 90,  8, 72,  0,100,
  8, 72,  0,100,  8, 72,  0,104,  6,145,  0,102,  5,186,  0, 92,
  2,250,  0,188,  5,195,  0,147,  4,195,  0,106,  5,223,  0,102,
  4,190,  0, 88,  5,223,  0,102,  4,190,  0, 88,  5,186,  0, 92,
  3, 82,  0,111,  3, 10,  0,209,  5,145,255,217,  4,  0,  0,197,
  4,  0,  1,109,  4,  0,  0,164,  4,  0,  0,178,  4,  0,  0,135,
  4,  0,  0,135,  4,  0,  0,176,  4,  0,  1,119,  0,  2,  0,  0,
  0,  0,  0,  0,255, 29,  1,  2,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1, 11,  0,  0,
  0,  1,  0,  2,  0,  3,  0,  4,  0,  5,  0,  6,  0,  7,  0,  8,
  0,  9,  0, 10,  0, 11,  0, 12,  0, 13,  0, 14,  0, 15,  0, 16,
  0, 17,  0, 18,  0, 19,  0, 20,  0, 21,  0, 22,  0, 23,  0, 24,
  0, 25,  0, 26,  0, 27,  0, 28,  0, 29,  0, 30,  0, 31,  0, 32,
  0, 33,  0, 34,  0, 35,  0, 36,  0, 37,  0, 38,  0, 39,  0, 40,
  0, 41,  0, 42,  0, 43,  0, 44,  0, 45,  0, 46,  0, 47,  0, 48,
  0, 49,  0, 50,  0, 51,  0, 52,  0, 53,  0, 54,  0, 55,  0, 56,
  0, 57,  0, 58,  0, 59,  0, 60,  0, 61,  0, 62,  0, 63,  0, 64,
  0, 65,  0, 66,  0, 67,  0, 68,  0, 69,  0, 70,  0, 71,  0, 72,
  0, 73,  0, 74,  0, 75,  0, 76,  0, 77,  0, 78,  0, 79,  0, 80,
  0, 81,  0, 82,  0, 83,  0, 84,  0, 85,  0, 86,  0, 87,  0, 88,
  0, 89,  0, 90,  0, 91,  0, 92,  0, 93,  0, 94,  0, 95,  0, 96,
  0, 97,  0, 98,  0, 99,  0,100,  0,101,  0,102,  0,103,  0,104,
  0,105,  0,106,  0,107,  0,108,  0,109,  0,110,  0,111,  0,112,
  0,113,  0,114,  0,115,  0,116,  0,117,  0,118,  0,119,  0,120,
  0,121,  0,122,  0,123,  0,124,  0,125,  0,126,  0,127,  0,128,
  0,129,  0,130,  0,131,  0,132,  0,133,  0,134,  0,135,  0,136,
  0,137,  0,138,  0,139,  0,140,  0,141,  0,142,  0,143,  0,144,
  0,145,  0,146,  0,147,  0,148,  0,149,  0,150,  0,151,  0,152,
  0,153,  0,154,  0,155,  0,156,  0,157,  0,158,  0,159,  0,160,
  0,161,  0,162,  0,163,  0,164,  0,165,  0,166,  0,167,  0,168,
  0,169,  0,170,  0,171,  0,172,  0,173,  0,174,  0,175,  0,176,
  0,177,  0,178,  0,179,  0,180,  0,181,  0,182,  0,183,  0,184,
  0,185,  0,186,  0,187,  0,188,  0,189,  0,190,  0,191,  0,192,
  0,193,  0,194,  0,195,  0,196,  0,197,  0,198,  0,199,  0,200,
  0,201,  0,202,  0,203,  0,204,  0,205,  0,206,  0,207,  0,208,
  0,209,  0,211,  0,212,  0,213,  0,214,  0,215,  0,216,  0,217,
  0,218,  0,219,  0,220,  0,221,  0,222,  0,223,  0,224,  0,225,
  0,226,  0,227,  0,228,  0,229,  0,230,  0,231,  0,232,  0,233,
  0,234,  0,235,  0,236,  0,237,  0,238,  0,239,  0,240,  0,241,
  0,242,  0,243,  0,245,  0,244,  0,246,  0,248,  0,249,  0,250,
  0,251,  0,252,  0,253,  0,254,  0,255,  1,  0,  1,  1,  1,  2,
  1,  3,  1,  4,  1,  5,  1,  6,  1,  7,  1,  8,  1,  9,  1, 10,
  1, 11,  1, 12,  9,115,102,116,104,121,112,104,101,110, 14,112,
101,114,105,111,100, 99,101,110,116,101,114,101,100,  4, 69,117,
114,111,  5, 99, 54, 52, 53, 57,  5, 99, 54, 52, 54, 48,  5, 99,
 54, 52, 54, 49,  5, 99, 54, 52, 54, 50,  5, 99, 54, 52, 54, 51,
  5, 99, 54, 52, 54, 54,  5, 99, 54, 52, 54, 55,  5, 99, 54, 52,
 54, 56,  0,  0,  0,  0,  0, 37,  0, 37,  0, 37,  0, 37,  0, 78,
  0,113,  0,211,  1, 93,  1,220,  2,198,  2,222,  3, 11,  3, 54,
  3,127,  3,169,  3,199,  3,222,  3,244,  4, 12,  4, 78,  4,123,
  4,242,  5, 85,  5,149,  5,229,  6, 63,  6,117,  6,227,  7, 60,
  7, 95,  7,138,  7,175,  7,208,  7,243,  8, 79,  8,251,  9,161,
 10,  0, 10, 75, 10,143, 10,193, 10,237, 11, 71, 11,128, 11,169,
 11,232, 12, 69, 12, 97, 12,231, 13, 62, 13,135, 13,196, 14, 42,
 14,159, 15, 50, 15,101, 15,161, 16,  2, 16,224, 17,127, 17,231,
 18, 58, 18, 92, 18,117, 18,151, 18,185, 18,205, 19,  4, 19,141,
 19,218, 20, 35, 20,112, 20,197, 21, 22, 21,124, 21,191, 21,232,
 22, 36, 22,134, 22,163, 23, 23, 23, 90, 23,159, 23,237, 24, 60,
 24,126, 25, 42, 25,137, 25,209, 26, 90, 27, 64, 28, 33, 28,226,
 29, 73, 29,170, 29,192, 30, 34, 30,100, 30,113, 31,106, 31,119,
 31,132, 31,145, 31,158, 31,171, 31,184, 31,197, 31,210, 31,223,
 31,236, 31,249, 32,  6, 32, 19, 32, 32, 32, 45, 32, 58, 32, 71,
 32, 84, 32, 97, 32,110, 32,123, 32,136, 32,149, 32,162, 32,175,
 32,188, 32,201, 32,214, 32,227, 32,240, 33, 30, 33, 93, 33,200,
 34, 21, 34,168, 34,218, 35,  8, 35,134, 36, 46, 36,193, 37, 33,
 37, 75, 37,139, 37,206, 38, 72, 39,  6, 39,110, 39,165, 39,212,
 40,  1, 40,138, 40,218, 41, 54, 41,123, 41,158, 41,216, 42, 60,
 42,202, 43, 21, 43,112, 44, 53, 44,218, 45, 56, 45, 97, 45,125,
 45,206, 46, 66, 46,189, 46,228, 47, 31, 47, 92, 47,140, 47,140,
 47,153, 47,166, 47,179, 48, 20, 48,162, 48,185, 48,208, 49,  3,
 49, 54, 49, 85, 49,116, 49,168, 49,252, 50,  9, 50, 22, 50, 57,
 50,201, 50,236, 51, 16, 51,118, 51,210, 52, 22, 52, 45, 52, 76,
 52,126, 53, 42, 53, 55, 53, 68, 53, 81, 53, 94, 53,107, 53,120,
 53,133, 53,146, 53,159, 53,172, 53,185, 53,198, 53,211, 53,224,
 53,237, 54, 10, 54, 55, 54,202, 54,250, 55, 72, 55,107, 55,179,
 55,239, 56, 39, 56, 87, 56,134, 56,212, 57, 45, 57, 58, 57, 71,
 57, 84, 57, 97, 57,132, 58,  5, 58,199, 58,212, 58,225, 59, 79,
 59,158, 59,180, 59,237, 60, 30, 60,118, 60,220, 61, 92, 61,243,
 62,170, 62,183, 62,196, 62,209, 62,222, 62,235, 62,248, 63,  5,
 63, 18, 63, 31, 63,127, 63,150, 63,173, 64, 52, 64, 84, 64,127,
 65, 21, 65, 64, 65,117, 65,173, 65,240, 66, 19,  0,  0,  0,  1,
  0,  0, 21, 26,  0,  1,  3,130, 12,  0,  0,  9,  9, 12,  0, 16,
  0, 55,254,211,  0, 16,  0, 57,255,107,  0, 16,  0, 58,255,164,
  0, 16,  0, 59,255, 89,  0, 16,  0, 60,254,211,  0, 16,  0,187,
254,211,  0, 16,  0,234,254,211,  0, 36,  0, 15,  0, 38,  0, 36,
  0, 17,  0, 38,  0, 36,  0, 29,  0, 38,  0, 36,  0, 30,  0, 38,
  0, 36,  0, 55,255, 97,  0, 36,  0, 56,255,193,  0, 36,  0, 57,
255,117,  0, 36,  0, 58,255,164,  0, 36,  0, 60,255, 60,  0, 36,
  0, 89,255,183,  0, 36,  0, 92,255,183,  0, 36,  0,104,255,193,
  0, 36,  0,181,255, 68,  0, 36,  0,183,255, 68,  0, 36,  0,186,
255,183,  0, 36,  0,187,255, 60,  0, 36,  0,196,  0,114,  0, 36,
  0,197,  0,114,  0, 36,  0,211,255,193,  0, 36,  0,212,255,193,
  0, 36,  0,213,255,193,  0, 36,  0,234,255, 60,  0, 36,  0,235,
255,183,  0, 37,  0, 57,255,173,  0, 37,  0, 58,255,144,  0, 37,
  0, 60,255,144,  0, 37,  0,187,255,144,  0, 37,  0,234,255,144,
  0, 38,  0, 16,  0, 47,  0, 38,  0, 54,  0, 38,  0, 38,  0,181,
  0, 75,  0, 38,  0,183,  0, 75,  0, 38,  0,227,  0, 38,  0, 38,
  0,249,  0, 38,  0, 39,  0, 16,  0, 38,  0, 39,  0, 60,255,107,
  0, 39,  0,187,255,107,  0, 39,  0,196,255,220,  0, 39,  0,197,
255,220,  0, 39,  0,234,255,107,  0, 41,  0, 15,254,183,  0, 41,
  0, 16,255,193,  0, 41,  0, 17,254,211,  0, 41,  0, 29,255,144,
  0, 41,  0, 30,255,144,  0, 41,  0, 36,255, 21,  0, 41,  0, 68,
255,136,  0, 41,  0, 72,255,173,  0, 41,  0, 82,255,173,  0, 41,
  0, 85,255,125,  0, 41,  0, 88,255,154,  0, 41,  0, 92,255,144,
  0, 41,  0, 98,255, 21,  0, 41,  0,105,255,136,  0, 41,  0,106,
255,136,  0, 41,  0,107,255,136,  0, 41,  0,108,255,136,  0, 41,
  0,109,255,136,  0, 41,  0,110,255,136,  0, 41,  0,112,255,173,
  0, 41,  0,113,255,173,  0, 41,  0,114,255,173,  0, 41,  0,115,
255,173,  0, 41,  0,121,255,173,  0, 41,  0,122,255,173,  0, 41,
  0,123,255,173,  0, 41,  0,124,255,173,  0, 41,  0,125,255,173,
  0, 41,  0,126,255,154,  0, 41,  0,127,255,154,  0, 41,  0,128,
255,154,  0, 41,  0,129,255,154,  0, 41,  0,160,255,136,  0, 41,
  0,161,255,173,  0, 41,  0,173,255, 21,  0, 41,  0,174,255, 21,
  0, 41,  0,177,255,173,  0, 41,  0,183,  0, 38,  0, 41,  0,186,
255,144,  0, 41,  0,196,254,173,  0, 41,  0,197,254,173,  0, 41,
  0,199,255, 21,  0, 41,  0,201,255, 21,  0, 41,  0,235,255,144,
  0, 42,  0, 55,255,220,  0, 42,  0, 60,255,211,  0, 42,  0,187,
255,211,  0, 42,  0,234,255,211,  0, 46,  0, 16,255, 78,  0, 46,
  0, 38,255,164,  0, 46,  0, 50,255,164,  0, 46,  0, 56,255,220,
  0, 46,  0, 72,255,220,  0, 46,  0, 82,255,220,  0, 46,  0, 88,
255,220,  0, 46,  0, 92,255,125,  0, 46,  0,100,255,164,  0, 46,
  0,103,255,164,  0, 46,  0,104,255,220,  0, 46,  0,112,255,220,
  0, 46,  0,113,255,220,  0, 46,  0,114,255,220,  0, 46,  0,115,
255,220,  0, 46,  0,121,255,220,  0, 46,  0,122,255,220,  0, 46,
  0,123,255,220,  0, 46,  0,124,255,220,  0, 46,  0,125,255,220,
  0, 46,  0,126,255,220,  0, 46,  0,127,255,220,  0, 46,  0,128,
255,220,  0, 46,  0,129,255,220,  0, 46,  0,145,255,201,  0, 46,
  0,161,255,220,  0, 46,  0,175,255,164,  0, 46,  0,176,255,154,
  0, 46,  0,177,255,220,  0, 46,  0,186,255,125,  0, 46,  0,196,
  0, 38,  0, 46,  0,197,  0, 38,  0, 46,  0,208,255,164,  0, 46,
  0,209,255,164,  0, 46,  0,210,255,164,  0, 46,  0,211,255,220,
  0, 46,  0,212,255,220,  0, 46,  0,213,255,220,  0, 46,  0,235,
255,125,  0, 46,  0,251,255,164,  0, 46,  0,253,255,164,  0, 47,
  0, 50,255,183,  0, 47,  0, 55,254,173,  0, 47,  0, 56,255,183,
  0, 47,  0, 57,254,230,  0, 47,  0, 58,255, 97,  0, 47,  0, 60,
254,193,  0, 47,  0, 92,255,117,  0, 47,  0,103,255,183,  0, 47,
  0,104,255,183,  0, 47,  0,145,255,183,  0, 47,  0,175,255,183,
  0, 47,  0,176,255,183,  0, 47,  0,181,254, 21,  0, 47,  0,183,
254, 41,  0, 47,  0,186,255,117,  0, 47,  0,187,254,193,  0, 47,
  0,208,255,183,  0, 47,  0,209,255,183,  0, 47,  0,210,255,183,
  0, 47,  0,211,255,183,  0, 47,  0,212,255,183,  0, 47,  0,213,
255,183,  0, 47,  0,234,254,193,  0, 47,  0,235,255,117,  0, 50,
  0, 15,255,211,  0, 50,  0, 16,  0, 38,  0, 50,  0, 17,255,211,
  0, 50,  0, 36,255,201,  0, 50,  0, 57,255,201,  0, 50,  0, 59,
255,183,  0, 50,  0, 60,255,183,  0, 50,  0, 98,255,201,  0, 50,
  0,173,255,201,  0, 50,  0,174,255,201,  0, 50,  0,187,255,183,
  0, 50,  0,199,255,201,  0, 50,  0,201,255,201,  0, 50,  0,234,
255,183,  0, 51,  0, 15,254,136,  0, 51,  0, 16,255,220,  0, 51,
  0, 17,254,136,  0, 51,  0, 36,255, 68,  0, 51,  0, 68,255,201,
  0, 51,  0, 86,255,220,  0, 51,  0, 92,  0, 38,  0, 51,  0, 98,
255, 68,  0, 51,  0,105,255,201,  0, 51,  0,106,255,201,  0, 51,
  0,107,255,201,  0, 51,  0,108,255,201,  0, 51,  0,109,255,201,
  0, 51,  0,110,255,201,  0, 51,  0,160,255,201,  0, 51,  0,173,
255, 68,  0, 51,  0,174,255, 68,  0, 51,  0,181,  0, 38,  0, 51,
  0,183,  0, 57,  0, 51,  0,186,  0, 38,  0, 51,  0,196,254, 97,
  0, 51,  0,197,254, 97,  0, 51,  0,199,255, 68,  0, 51,  0,201,
255, 68,  0, 51,  0,228,255,220,  0, 51,  0,235,  0, 38,  0, 51,
  0,250,255,220,  0, 52,  0, 16,  0, 38,  0, 53,  0, 15,  0, 38,
  0, 53,  0, 17,  0, 38,  0, 53,  0, 55,255,164,  0, 53,  0, 60,
255,144,  0, 53,  0, 92,255,164,  0, 53,  0,186,255,164,  0, 53,
  0,187,255,144,  0, 53,  0,234,255,144,  0, 53,  0,235,255,164,
  0, 54,  0, 54,255,164,  0, 54,  0,227,255,164,  0, 54,  0,249,
255,164,  0, 55,  0, 15,254,220,  0, 55,  0, 16,254,211,  0, 55,
  0, 17,254,201,  0, 55,  0, 29,255,144,  0, 55,  0, 30,255,144,
  0, 55,  0, 36,255, 97,  0, 55,  0, 55,  0, 47,  0, 55,  0, 68,
254,248,  0, 55,  0, 70,254,240,  0, 55,  0, 72,254,240,  0, 55,
  0, 82,254,240,  0, 55,  0, 85,255, 31,  0, 55,  0, 86,254,240,
  0, 55,  0, 88,255, 31,  0, 55,  0, 90,255, 31,  0, 55,  0, 92,
255, 13,  0, 55,  0, 98,255, 97,  0, 55,  0,105,254,248,  0, 55,
  0,106,254,248,  0, 55,  0,107,254,248,  0, 55,  0,108,254,248,
  0, 55,  0,109,254,248,  0, 55,  0,110,254,248,  0, 55,  0,111,
254,240,  0, 55,  0,112,254,240,  0, 55,  0,113,254,240,  0, 55,
  0,114,254,240,  0, 55,  0,115,254,240,  0, 55,  0,121,254,240,
  0, 55,  0,122,254,240,  0, 55,  0,123,254,240,  0, 55,  0,124,
254,240,  0, 55,  0,125,254,240,  0, 55,  0,126,255, 31,  0, 55,
  0,127,255, 31,  0, 55,  0,128,255, 31,  0, 55,  0,129,255, 31,
  0, 55,  0,160,255, 60,  0, 55,  0,161,255, 97,  0, 55,  0,173,
255, 97,  0, 55,  0,174,255, 97,  0, 55,  0,177,255, 97,  0, 55,
  0,186,255, 13,  0, 55,  0,196,254,248,  0, 55,  0,197,254,248,
  0, 55,  0,199,255, 97,  0, 55,  0,201,255, 97,  0, 55,  0,228,
254,240,  0, 55,  0,235,255, 13,  0, 55,  0,250,254,240,  0, 55,
  0,252,254,240,  0, 55,  0,254,254,240,  0, 56,  0, 36,255,193,
  0, 56,  0, 98,255,193,  0, 56,  0,173,255,193,  0, 56,  0,174,
255,193,  0, 56,  0,199,255,193,  0, 56,  0,201,255,193,  0, 57,
  0, 15,254,248,  0, 57,  0, 16,255,107,  0, 57,  0, 17,254,248,
  0, 57,  0, 29,255,164,  0, 57,  0, 30,255,164,  0, 57,  0, 36,
255,117,  0, 57,  0, 50,255,220,  0, 57,  0, 68,255,144,  0, 57,
  0, 72,255,144,  0, 57,  0, 76,255,220,  0, 57,  0, 82,255,144,
  0, 57,  0, 88,255,183,  0, 57,  0, 98,255,117,  0, 57,  0,103,
255,220,  0, 57,  0,105,255,144,  0, 57,  0,106,255,144,  0, 57,
  0,107,255,144,  0, 57,  0,108,255,144,  0, 57,  0,109,255,144,
  0, 57,  0,110,255,144,  0, 57,  0,112,255,144,  0, 57,  0,113,
255,144,  0, 57,  0,114,255,144,  0, 57,  0,115,255,144,  0, 57,
  0,121,255,144,  0, 57,  0,122,255,144,  0, 57,  0,123,255,144,
  0, 57,  0,124,255,144,  0, 57,  0,125,255,144,  0, 57,  0,126,
255,183,  0, 57,  0,127,255,183,  0, 57,  0,128,255,183,  0, 57,
  0,129,255,183,  0, 57,  0,145,255,220,  0, 57,  0,160,255,144,
  0, 57,  0,161,255,144,  0, 57,  0,173,255,117,  0, 57,  0,174,
255,117,  0, 57,  0,175,255,220,  0, 57,  0,176,255,220,  0, 57,
  0,177,255,144,  0, 57,  0,196,255, 31,  0, 57,  0,197,255, 68,
  0, 57,  0,199,255,117,  0, 57,  0,201,255,117,  0, 57,  0,208,
255,220,  0, 57,  0,209,255,220,  0, 57,  0,210,255,220,  0, 58,
  0, 15,255, 89,  0, 58,  0, 16,255,164,  0, 58,  0, 17,255, 89,
  0, 58,  0, 29,255,193,  0, 58,  0, 30,255,193,  0, 58,  0, 36,
255,164,  0, 58,  0, 68,255,183,  0, 58,  0, 72,255,183,  0, 58,
  0, 82,255,183,  0, 58,  0, 85,255,220,  0, 58,  0, 98,255,164,
  0, 58,  0,105,255,183,  0, 58,  0,106,255,183,  0, 58,  0,107,
255,183,  0, 58,  0,108,255,183,  0, 58,  0,109,255,183,  0, 58,
  0,110,255,183,  0, 58,  0,112,255,183,  0, 58,  0,113,255,183,
  0, 58,  0,114,255,183,  0, 58,  0,115,255,183,  0, 58,  0,121,
255,183,  0, 58,  0,122,255,183,  0, 58,  0,123,255,183,  0, 58,
  0,124,255,183,  0, 58,  0,125,255,183,  0, 58,  0,160,255,183,
  0, 58,  0,161,255,183,  0, 58,  0,173,255,164,  0, 58,  0,174,
255,164,  0, 58,  0,177,255,183,  0, 58,  0,199,255,164,  0, 58,
  0,201,255,164,  0, 59,  0, 16,255, 89,  0, 59,  0, 38,255,183,
  0, 59,  0, 50,255,183,  0, 59,  0, 72,255,201,  0, 59,  0,100,
255,183,  0, 59,  0,103,255,183,  0, 59,  0,112,255,201,  0, 59,
  0,113,255,201,  0, 59,  0,114,255,201,  0, 59,  0,115,255,201,
  0, 59,  0,145,255,183,  0, 59,  0,175,255,183,  0, 59,  0,176,
255,183,  0, 59,  0,196,  0, 38,  0, 59,  0,197,  0, 38,  0, 59,
  0,208,255,183,  0, 59,  0,209,255,183,  0, 59,  0,210,255,183,
  0, 59,  0,251,255,183,  0, 59,  0,253,255,183,  0, 60,  0, 15,
254,173,  0, 60,  0, 16,254,211,  0, 60,  0, 17,254,173,  0, 60,
  0, 29,255, 78,  0, 60,  0, 30,255, 78,  0, 60,  0, 36,255, 60,
  0, 60,  0, 38,255,183,  0, 60,  0, 50,255,183,  0, 60,  0, 68,
255, 68,  0, 60,  0, 72,255, 68,  0, 60,  0, 82,255, 68,  0, 60,
  0, 88,255,107,  0, 60,  0, 98,255, 60,  0, 60,  0,100,255,183,
  0, 60,  0,103,255,183,  0, 60,  0,105,255, 68,  0, 60,  0,106,
255, 68,  0, 60,  0,107,255, 68,  0, 60,  0,108,255, 68,  0, 60,
  0,109,255, 68,  0, 60,  0,110,255, 68,  0, 60,  0,112,255, 68,
  0, 60,  0,113,255, 68,  0, 60,  0,114,255, 68,  0, 60,  0,115,
255, 68,  0, 60,  0,121,255, 68,  0, 60,  0,122,255, 68,  0, 60,
  0,123,255, 68,  0, 60,  0,124,255, 68,  0, 60,  0,125,255, 68,
  0, 60,  0,126,255,107,  0, 60,  0,127,255,107,  0, 60,  0,128,
255,107,  0, 60,  0,129,255,107,  0, 60,  0,145,255,220,  0, 60,
  0,160,255, 68,  0, 60,  0,161,255, 68,  0, 60,  0,173,255, 60,
  0, 60,  0,174,255, 60,  0, 60,  0,175,255,183,  0, 60,  0,176,
255,164,  0, 60,  0,177,255, 68,  0, 60,  0,196,254,136,  0, 60,
  0,197,254,211,  0, 60,  0,199,255, 60,  0, 60,  0,201,255, 60,
  0, 60,  0,208,255,183,  0, 60,  0,209,255,183,  0, 60,  0,210,
255,183,  0, 60,  0,251,255,183,  0, 60,  0,253,255,183,  0, 61,
  0, 16,255,220,  0, 68,  0, 92,255,193,  0, 68,  0,186,255,193,
  0, 68,  0,235,255,193,  0, 73,  0, 15,255,144,  0, 73,  0, 16,
255,220,  0, 73,  0, 17,255,144,  0, 73,  0,181,  0, 86,  0, 73,
  0,183,  0,141,  0, 78,  0, 72,255,201,  0, 78,  0, 82,255,201,
  0, 78,  0,112,255,201,  0, 78,  0,113,255,201,  0, 78,  0,114,
255,201,  0, 78,  0,115,255,201,  0, 78,  0,121,255,201,  0, 78,
  0,122,255,201,  0, 78,  0,123,255,201,  0, 78,  0,124,255,201,
  0, 78,  0,125,255,201,  0, 78,  0,161,255,211,  0, 78,  0,177,
255,201,  0, 85,  0, 15,254,211,  0, 85,  0, 17,254,220,  0, 85,
  0,181,  0, 38,  0, 85,  0,183,  0, 86,  0, 89,  0, 15,255, 89,
  0, 89,  0, 17,255, 89,  0, 90,  0, 15,255,125,  0, 90,  0, 17,
255,125,  0, 92,  0, 15,255, 97,  0, 92,  0, 17,255, 68,  0, 98,
  0, 15,  0, 38,  0, 98,  0, 17,  0, 38,  0, 98,  0, 29,  0, 38,
  0, 98,  0, 30,  0, 38,  0, 98,  0, 55,255, 97,  0, 98,  0, 56,
255,193,  0, 98,  0, 57,255,117,  0, 98,  0, 58,255,164,  0, 98,
  0, 60,255, 60,  0, 98,  0, 89,255,183,  0, 98,  0, 92,255,183,
  0, 98,  0,104,255,193,  0, 98,  0,181,255, 68,  0, 98,  0,183,
255, 68,  0, 98,  0,186,255,183,  0, 98,  0,187,255, 60,  0, 98,
  0,196,  0,114,  0, 98,  0,197,  0,114,  0, 98,  0,211,255,193,
  0, 98,  0,212,255,193,  0, 98,  0,213,255,193,  0, 98,  0,234,
255, 60,  0, 98,  0,235,255,183,  0,100,  0, 16,  0, 47,  0,100,
  0, 54,  0, 38,  0,100,  0,181,  0, 75,  0,100,  0,183,  0, 75,
  0,100,  0,227,  0, 38,  0,100,  0,249,  0, 38,  0,103,  0, 15,
255,211,  0,103,  0, 16,  0, 38,  0,103,  0, 17,255,211,  0,103,
  0, 36,255,201,  0,103,  0, 57,255,201,  0,103,  0, 59,255,183,
  0,103,  0, 60,255,183,  0,103,  0, 98,255,201,  0,103,  0,173,
255,201,  0,103,  0,174,255,201,  0,103,  0,187,255,183,  0,103,
  0,199,255,201,  0,103,  0,201,255,201,  0,103,  0,234,255,183,
  0,104,  0, 36,255,193,  0,104,  0, 98,255,193,  0,104,  0,173,
255,193,  0,104,  0,174,255,193,  0,104,  0,199,255,193,  0,104,
  0,201,255,193,  0,105,  0, 92,255,193,  0,105,  0,186,255,193,
  0,105,  0,235,255,193,  0,106,  0, 92,255,193,  0,106,  0,186,
255,193,  0,106,  0,235,255,193,  0,107,  0, 92,255,193,  0,107,
  0,186,255,193,  0,107,  0,235,255,193,  0,108,  0, 92,255,193,
  0,108,  0,186,255,193,  0,108,  0,235,255,193,  0,109,  0, 92,
255,193,  0,109,  0,186,255,193,  0,109,  0,235,255,193,  0,110,
  0, 92,255,193,  0,110,  0,186,255,193,  0,110,  0,235,255,193,
  0,144,  0, 16,255,220,  0,145,  0, 15,255,211,  0,145,  0, 16,
  0, 38,  0,145,  0, 17,255,211,  0,145,  0, 36,255,220,  0,145,
  0, 57,255,220,  0,145,  0, 59,255,183,  0,145,  0, 60,255,220,
  0,145,  0, 98,255,220,  0,145,  0,173,255,220,  0,145,  0,174,
255,220,  0,145,  0,187,255,220,  0,145,  0,199,255,220,  0,145,
  0,201,255,220,  0,145,  0,234,255,220,  0,173,  0, 15,  0, 38,
  0,173,  0, 17,  0, 38,  0,173,  0, 29,  0, 38,  0,173,  0, 30,
  0, 38,  0,173,  0, 55,255, 97,  0,173,  0, 56,255,193,  0,173,
  0, 57,255,117,  0,173,  0, 58,255,164,  0,173,  0, 60,255, 60,
  0,173,  0, 89,255,183,  0,173,  0, 92,255,183,  0,173,  0,104,
255,193,  0,173,  0,181,255, 68,  0,173,  0,183,255, 68,  0,173,
  0,186,255,183,  0,173,  0,187,255, 60,  0,173,  0,196,  0,114,
  0,173,  0,197,  0,114,  0,173,  0,211,255,193,  0,173,  0,212,
255,193,  0,173,  0,213,255,193,  0,173,  0,234,255, 60,  0,173,
  0,235,255,183,  0,174,  0, 15,  0, 38,  0,174,  0, 17,  0, 38,
  0,174,  0, 29,  0, 38,  0,174,  0, 30,  0, 38,  0,174,  0, 55,
255, 97,  0,174,  0, 56,255,193,  0,174,  0, 57,255,117,  0,174,
  0, 58,255,164,  0,174,  0, 60,255, 60,  0,174,  0, 89,255,183,
  0,174,  0, 92,255,183,  0,174,  0,104,255,193,  0,174,  0,181,
255, 68,  0,174,  0,183,255, 68,  0,174,  0,186,255,183,  0,174,
  0,187,255, 60,  0,174,  0,196,  0,114,  0,174,  0,197,  0,114,
  0,174,  0,211,255,193,  0,174,  0,212,255,193,  0,174,  0,213,
255,193,  0,174,  0,234,255, 60,  0,174,  0,235,255,183,  0,175,
  0, 15,255,211,  0,175,  0, 16,  0, 38,  0,175,  0, 17,255,211,
  0,175,  0, 36,255,201,  0,175,  0, 57,255,201,  0,175,  0, 59,
255,183,  0,175,  0, 60,255,183,  0,175,  0, 98,255,201,  0,175,
  0,173,255,201,  0,175,  0,174,255,201,  0,175,  0,187,255,183,
  0,175,  0,199,255,201,  0,175,  0,201,255,201,  0,175,  0,234,
255,183,  0,180,  0, 36,254,248,  0,180,  0, 45,255,164,  0,180,
  0, 60,  0, 38,  0,180,  0, 98,254,248,  0,180,  0,144,254,211,
  0,180,  0,173,254,248,  0,180,  0,174,254,248,  0,180,  0,187,
  0, 38,  0,180,  0,199,254,248,  0,180,  0,201,254,248,  0,180,
  0,234,  0, 38,  0,182,  0, 36,255, 21,  0,182,  0, 45,255,164,
  0,182,  0, 57,  0, 38,  0,182,  0, 60,  0, 75,  0,182,  0, 98,
255, 21,  0,182,  0,144,254,248,  0,182,  0,173,255, 21,  0,182,
  0,174,255, 21,  0,182,  0,187,  0, 75,  0,182,  0,199,255, 21,
  0,182,  0,201,255, 21,  0,182,  0,234,  0, 75,  0,186,  0, 15,
255, 97,  0,186,  0, 17,255, 68,  0,187,  0, 15,254,173,  0,187,
  0, 16,254,211,  0,187,  0, 17,254,173,  0,187,  0, 29,255, 78,
  0,187,  0, 30,255, 78,  0,187,  0, 36,255, 60,  0,187,  0, 38,
255,183,  0,187,  0, 50,255,183,  0,187,  0, 68,255, 68,  0,187,
  0, 72,255, 68,  0,187,  0, 82,255, 68,  0,187,  0, 88,255,107,
  0,187,  0, 98,255, 60,  0,187,  0,100,255,183,  0,187,  0,103,
255,183,  0,187,  0,105,255, 68,  0,187,  0,106,255, 68,  0,187,
  0,107,255, 68,  0,187,  0,108,255, 68,  0,187,  0,109,255, 68,
  0,187,  0,110,255, 68,  0,187,  0,112,255, 68,  0,187,  0,113,
255, 68,  0,187,  0,114,255, 68,  0,187,  0,115,255, 68,  0,187,
  0,121,255, 68,  0,187,  0,122,255, 68,  0,187,  0,123,255, 68,
  0,187,  0,124,255, 68,  0,187,  0,125,255, 68,  0,187,  0,126,
255,107,  0,187,  0,127,255,107,  0,187,  0,128,255,107,  0,187,
  0,129,255,107,  0,187,  0,145,255,220,  0,187,  0,160,255, 68,
  0,187,  0,161,255, 68,  0,187,  0,173,255, 60,  0,187,  0,174,
255, 60,  0,187,  0,175,255,183,  0,187,  0,176,2