## bookmarks.py
## 
## Copyright (C) 2006 Mykola Lynnyk <pydefiner@gmail.com>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##

import pygtk
pygtk.require('2.0')
import gtk
import gobject 

import dialog
import handlers
import mainwindow
import pyNeighborhood

class Bookmarks_Widget:
    
    def instance(self):
        return self
    
    def menuaction_handler_scan(self, parm1, prompt):
        handlers.scan(self, self.mainwindow, prompt)
		
    def menuaction_handler_umount(self, parm1):
        self.mainwindow.umount()

    def menuaction_handler_mount(self, parm1, type, prompt):
        handlers.mount(self, self.mainwindow, type, prompt)
		
    def menuaction_handler_filemngr(self, parm1, label):
        handlers.filemanager(self, self.mainwindow, label)

    def menuaction_handler_remove(self, parm1):
        handlers.remove(self, self.mainwindow)

    def menuaction_handler_edit(self, parm1):
        handlers.edit(self, self.mainwindow)

    def widget_popup(self, type, mounted):
        popup = gtk.Menu()
        separator = gtk.SeparatorMenuItem()
        if type == "host_menu":
            item1 = gtk.ImageMenuItem("SCAN")
            item1.connect("activate", self.menuaction_handler_scan, False)
            item2 = gtk.ImageMenuItem("SCAN_USER")
            item2.connect("activate", self.menuaction_handler_scan, True)
            item3 = gtk.ImageMenuItem(gtk.STOCK_REMOVE)
            item3.connect("activate", self.menuaction_handler_remove)
            item4 = gtk.ImageMenuItem(gtk.STOCK_EDIT)
            item4.connect("activate", self.menuaction_handler_edit)
            popup.append(item1)
            if pyNeighborhood.parser.get_value("enable_default") == "False" and pyNeighborhood.parser.get_value("anonymous") == "False":
                popup.append(item2)
            popup.append(item3)
            popup.append(item4)
        if type == "share_menu":
            if mounted == False:
                # Unmount
                item1 = gtk.ImageMenuItem("UNMOUNT")
                item1.connect("activate", self.menuaction_handler_umount)
                
                # Filemanager
                item2 = gtk.ImageMenuItem("FILEMANAGER")
                menu = gtk.Menu()
                if len(pyNeighborhood.parser.file_managers) > 1:
                    for file_mngr in pyNeighborhood.parser.file_managers:
                        item_file = gtk.MenuItem(file_mngr)
                        item_file.connect("activate", self.menuaction_handler_filemngr, file_mngr)
                        menu.add(item_file)
                        item_file.show()
                    item2.set_submenu(menu)
                else:
                    item2.connect("activate", self.menuaction_handler_filemngr, pyNeighborhood.parser.file_managers[0])

                popup.append(item1)
                popup.append(item2)
            else:
                item1 = gtk.ImageMenuItem("MOUNT")
                if pyNeighborhood.parser.get_value("enable_smb") == "True" and pyNeighborhood.parser.get_value("enable_cifs") == "True":
                    menu = gtk.Menu()
                    item_smb = gtk.MenuItem("as SMB")
                    item_smb.connect("activate", self.menuaction_handler_mount, "SMB", False)
                    item_smb.show()
                    item_cifs = gtk.MenuItem("as CIFS")
                    item_cifs.connect("activate", self.menuaction_handler_mount, "CIFS", False)
                    item_cifs.show()
                    menu.add(item_smb)
                    menu.add(item_cifs)
                    item1.set_submenu(menu)
                if pyNeighborhood.parser.get_value("enable_smb") == "True" and pyNeighborhood.parser.get_value("enable_cifs") == "False":
                    item1.connect("activate", self.menuaction_handler_mount, "SMB", False)
                if pyNeighborhood.parser.get_value("enable_smb") == "False" and pyNeighborhood.parser.get_value("enable_cifs") == "True":
                    item1.connect("activate", self.menuaction_handler_mount, "CIFS", False)

                item2 = gtk.ImageMenuItem("MOUNT_USER")
                if pyNeighborhood.parser.get_value("enable_smb") == "True" and pyNeighborhood.parser.get_value("enable_cifs") == "True":
                    menu_user = gtk.Menu()
                    item_smb_user = gtk.MenuItem("as SMB")
                    item_smb_user.connect("activate", self.menuaction_handler_mount, "SMB", True)
                    item_smb_user.show()
                    item_cifs_user = gtk.MenuItem("as CIFS")
                    item_cifs_user.connect("activate", self.menuaction_handler_mount, "CIFS", True)
                    item_cifs_user.show()
                    menu_user.add(item_smb_user)
                    menu_user.add(item_cifs_user)
                    item2.set_submenu(menu_user)
                if pyNeighborhood.parser.get_value("enable_smb") == "True" and pyNeighborhood.parser.get_value("enable_cifs") == "False":
                    item2.connect("activate", self.menuaction_handler_mount, "SMB", True)
                if pyNeighborhood.parser.get_value("enable_smb") == "False" and pyNeighborhood.parser.get_value("enable_cifs") == "True":
                    item2.connect("activate", self.menuaction_handler_mount, "CIFS", True)

                popup.append(item1)
                if pyNeighborhood.parser.get_value("enable_default") == "False" and pyNeighborhood.parser.get_value("anonymous") == "False":
                    popup.append(item2)

        menu = popup
        return menu

    def select_on_click(self, treeview):
        treestore = treeview.get_selection()
        (model, iter) = treestore.get_selected()
        if self.if_popup == 1:
            if model.iter_parent(iter) == None:
                menu = self.widget_popup("host_menu", False)
            else:
                mountpoint = model.get_value(iter, 3)
                if mountpoint == '':
                    menu = self.widget_popup("share_menu", True)
                else:
                    menu = self.widget_popup("share_menu", False)

            menu.popup(None, None, None, 3, gtk.get_current_event_time())
            menu.show_all()
            self.if_popup = 0

    def button_clicked(self, widget, event):
        if event.type == gtk.gdk._2BUTTON_PRESS and event.button == 1:
            treeselection = self.treeview.get_selection()
            (model, iter) = treeselection.get_selected()
            if iter != None:
                path = model.get_path(iter)
                column = self.treeview.get_column(0)
                if model.iter_parent(iter) == None:
                    handlers.scan(self, self.mainwindow, False)
                else:
                    handlers.mount(self, self.mainwindow, pyNeighborhood.set_default_mount_type(), False)
        if event.type == gtk.gdk.BUTTON_PRESS and event.button == 3:
            self.if_popup = 1

    def Bookmarks(self):
        # bookmarks
        self.column_names = ['Name', 'Comment', 'Mountpoint']

        # if 1, menu pops up
        self.if_popup = 0

        # we'll add some data now - a list of our hosts
        list = pyNeighborhood.hosts.hostslist
        self.hostlist = []
        for item in list:
            self.hostlist.append(item["display"])
        c = 0
        self.piter = []
        for parent in self.hostlist:
            iter = self.treestore.append(None, [ self.hostlist[c], 'host', "", ""])
            self.treestore.set(iter, 2, '')
            c = c + 1

        # create the TreeView using treestore
        tvcolumn = [None] * len(self.column_names)

        # create 3 TreeViewColumns to display the data
        cell = gtk.CellRendererText()
        cell1 = gtk.CellRendererText()
        cellpb = gtk.CellRendererPixbuf()
       	tvcolumn[0] = gtk.TreeViewColumn(self.column_names[0])
       	self.treeview.append_column(tvcolumn[0])

       	tvcolumn[0].pack_start(cellpb, False)
       	tvcolumn[0].pack_start(cell, True)
       	tvcolumn[0].set_attributes(cellpb, stock_id=1)
       	tvcolumn[0].set_attributes(cell, text=0)

       	tvcolumn[0].set_resizable(True)
        for n in range (1, len(self.column_names)):
            tvcolumn[n] = gtk.TreeViewColumn(self.column_names[n])
            self.treeview.append_column(tvcolumn[n])
            tvcolumn[n].pack_start(cell1, True)
            tvcolumn[n].set_attributes(cell1, text=n+1)
            tvcolumn[n].set_resizable(True)

        self.treeview.set_expander_column(self.treeview.get_column(0))

        # create scrollbars
        scrolledwindow = gtk.ScrolledWindow()
        scrolledwindow.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        scrolledwindow.add(self.treeview)

        # make it searchable and connect popups
        self.treeview.set_search_column(0)
        self.treeview.set_enable_search(True)
        self.treeview.connect("cursor-changed", self.select_on_click)
        self.treeview.connect("button_press_event", self.button_clicked)

        return scrolledwindow, self.treestore, self.treeview

    def __init__(self, MainWindow):
        # create a TreeStore with one string column to use as the model
        self.treestore = gtk.TreeStore(str, str, str, str)
        self.treeview = gtk.TreeView(self.treestore)
        self.mainwindow = MainWindow

