## sharmount.py
## 
## Copyright (C) 2005-2006 Mykola Lynnyk <pydefiner@gmail.com>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##

import os
import thread
import string
from os import system, environ, path, getenv, makedirs, mkdir, getcwd

import pyNeighborhood
import checkmount

def fix_string(line):
    parts = line.split(" ")
    final_line = parts[0]
    parts.remove(parts[0])
    for part in parts:
        final_line = string.join([final_line + "\\", " ", part], "")
    
    line = final_line
    parts = line.split('"')
    final_line = parts[0]
    parts.remove(parts[0])
    for part in parts:
        final_line = string.join([final_line + "\\", '"', part], "")

    line = final_line
    parts = line.split("'")
    final_line = parts[0]
    parts.remove(parts[0])
    for part in parts:
        final_line = string.join([final_line + "\\", "'", part], "")

    line = final_line
    parts = line.split("(")
    final_line = parts[0]
    parts.remove(parts[0])
    for part in parts:
        final_line = string.join([final_line + "\\", "(", part], "")

    line = final_line
    parts = line.split(")")
    final_line = parts[0]
    parts.remove(parts[0])
    for part in parts:
        final_line = string.join([final_line + "\\", ")", part], "")
    return final_line

def sharmount(hostname, sharename, mount_point, mount_type):
    # check if mount folder exists. If not, create it
    print "Input mount point: ", mount_point
    mount_dir = pyNeighborhood.parser.get_value("mount_directory")
    if not path.exists(mount_dir):
        try:
            os.makedirs(mount_dir)
        except:
            return
    try:
        os.chdir(mount_dir)
    except:
        return

    list = pyNeighborhood.hosts.find_by_name(hostname)
    if list != None:
        try:
            display = list["display"]
        except: pass 
    if list == None:
        try:
            list = pyNeighborhood.hosts.find_by_ip(hostname)
            display = list["display"]
        except:
            display = hostname

    if not path.exists(mount_dir + "/" + display): 
        try:
            mkdir(display)
        except:
            return
    if not path.exists(mount_dir + "/" + display + "/" + sharename): 
        try:
            os.chdir(mount_dir + "/" + display)
        except:
            return
        mkdir(sharename)
    mount_point = mount_dir + "/" + display + "/" + sharename
    os.chdir(getenv("HOME")+"/.pyNeighborhood")

    if mount_type == "SMB":
        mount_command = pyNeighborhood.parser.get_value("smb_mount")
        mnt_options = pyNeighborhood.parser.get_value("smb_options")
        print "Setting mount command to SMB"
    else:
        mount_command = pyNeighborhood.parser.get_value("cifs_mount")
        mnt_options = pyNeighborhood.parser.get_value("cifs_options")
        print "Setting mount command to CIFS"
    
    if pyNeighborhood.parser.get_value("anonymous") == "True":
        password = string.join(["password=", ""], '')
    else:
        if mount_type == "CIFS":
            password = string.join(["password=", pyNeighborhood.password, ","
                                    "user=",pyNeighborhood.user], '')
        else:                                    
            password = string.join(["password=", pyNeighborhood.password, ","
                                    "username=",pyNeighborhood.user], '')
    if mnt_options != "":
        options = string.join([password, "," , mnt_options], '')
    else:
        options = password
 
    host = string.join(["//", hostname, "/", fix_string(sharename)], '')
    command = string.join([mount_command, host, fix_string(mount_point), '-o', options], ' ')
    print command
    print "Mounting", host, "..."

    msg = os.system(command)
    if msg == 0:
        value = True
    else:
        value = False
    return value

def sharumount(mount_point):
    print mount_point
    mount_dir = pyNeighborhood.parser.get_value("mount_directory")

    if not path.exists(mount_point): 
        error_message = "No such mountpoint"
    else: 
        (hosts, shares, mount_points, type) = checkmount.checkmount()
        i = 0
        for point in mount_points:
            if point == mount_point:
                break
            i = i + 1
        if (type[i] == "SMB"):
            umount_command = pyNeighborhood.parser.get_value("smb_umount")
            print "Setting unmount command to SMB"
        if (type[i] == "CIFS"):
            umount_command = pyNeighborhood.parser.get_value("cifs_umount")
            print "Setting unmount command to CIFS"

        command = string.join([umount_command, " ", fix_string(mount_point)], '')
        print "Unmounting", mount_point, "..."

        msg = os.system(command)
        if msg == 0:
            if pyNeighborhood.parser.get_value("delete_dirs") == "False":
                print "False"
                return True
            else:
                print "True"
                os.removedirs(mount_point)
                if not path.exists(mount_dir):
                    os.makedirs(mount_dir)
                return True
        if msg == 256: 
            return False

def file_mng(mount_point, file_manager):
    print "Mount point: ", mount_point
    mount_dir = pyNeighborhood.parser.get_value("mount_directory")
    print "Mount directory: ", mount_dir
    if not path.exists(mount_point): 
        print "No such mountpoint"
        return

    file_manager_command = string.join([file_manager, fix_string(mount_point)])
    os.popen(file_manager_command)
    return 

