## vim:ts=4:et:nowrap
##
##---------------------------------------------------------------------------##
##
## PySol -- a Python Solitaire game
##
## Copyright (C) 2003 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 2002 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 2001 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 2000 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1999 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1998 Markus Franz Xaver Johannes Oberhumer
## All Rights Reserved.
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.
## If not, write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## Markus F.X.J. Oberhumer
## <markus@oberhumer.com>
## http://www.oberhumer.com/pysol
##
##---------------------------------------------------------------------------##


# imports
import os, sys, Tkinter

# PySol imports
from mfxutil import destruct

# Toolkit imports
from tkconst import TK_DASH_PATCH
from tkwidget import MfxTooltip


# /***********************************************************************
# //
# ************************************************************************/

class _MfxStatusbar:
    def __init__(self, top):
        self.top = top
        self.side = "#init#"
        self._widgets = []
        self._tooltips = []
        #
        self.padx = 0
        self.pady = 0
        #
        # We must create a Canvas and a Frame with these parameters
        # in order to be able to hide the statusbar.
        self.canvas = Tkinter.Canvas(self.top, bd=0, highlightthickness=0)
        ##self.frame = Tkinter.Frame(self.canvas, bd=0, highlightthickness=1)
        self.frame = Tkinter.Frame(self.canvas, bd=1, relief=Tkinter.RAISED)
        self.frame.pack(side=Tkinter.TOP, fill=Tkinter.X, pady=self.pady)
        self.canvas.pack(side=Tkinter.BOTTOM, fill=Tkinter.X)


    # util
    def _createLabel(self, name,
                     text="", relief=Tkinter.SUNKEN,
                     side=Tkinter.LEFT, fill=Tkinter.NONE, padx=-1, expand=0,
                     tooltip=None):
        if padx < 0: padx = self.padx
        label = Tkinter.Label(self.frame, text=text, relief=relief)
        label.pack(side=side, fill=fill, padx=padx, expand=expand)
        setattr(self, name + "_label", label)
        self._widgets.append(label)
        if tooltip:
            b = MfxTooltip(label)
            self._tooltips.append(b)
            b.setText(tooltip)
        return label


    #
    # public methods
    #

    def updateText(self, **kw):
        for k, v in kw.items():
            label = getattr(self, k + "_label")
            label["text"] = str(v)

    def configLabel(self, name, **kw):
        label = getattr(self, name + "_label")
        apply(label.config, (), kw)

    def show(self, side=Tkinter.BOTTOM, resize=0):
        if side in (0, "", "none", "None"):
            side = None
        elif not side in (None, Tkinter.BOTTOM):
            side = Tkinter.BOTTOM
        if self.side == side:
            return 0
        #print "statusbar.show", side, resize
        if resize:
            self.top.wm_geometry("")    # cancel user-specified geometry
        if not side:
            # hide
            self.canvas.pack_propagate(0)
            self.canvas.config(height=0)
        else:
            # show
            self.canvas.pack_propagate(1)
            self.canvas.pack(side=side, fill=Tkinter.X)
        self.side = side
        return 1

    def hide(self, resize=0):
        self.show(None, resize)

    def getSide(self):
        return self.side

    def destroy(self):
        for w in self._tooltips:
            if w: w.destroy()
        self._tooltips = []
        for w in self._widgets:
            if w: w.destroy()
        self._widgets = []


# /***********************************************************************
# //
# ************************************************************************/

class PysolStatusbar(_MfxStatusbar):
    def __init__(self, top):
        _MfxStatusbar.__init__(self, top)
        self._createLabel("moves", tooltip="Number of moves \nin this game")
        self._createLabel("gamenumber", tooltip="Game number")
        self._createLabel("stats", tooltip="Games played: won/lost")
        l = self._createLabel("info", fill=Tkinter.X, expand=0)
        ## FIXME: justify ?
        l.config(text="", justify="left")
        self._widgets[0].grid_configure(column=0, row=0, sticky="ew")
        self._widgets[1].grid_configure(column=1, row=0, sticky="ew")
        self._widgets[2].grid_configure(column=2, row=0, sticky="ew")
        self._widgets[3].grid_configure(column=3, row=0, sticky="ew")
        self.frame.grid_columnconfigure(0, weight=0, minsize=100)
        self.frame.grid_columnconfigure(1, weight=0, minsize=200)
        self.frame.grid_columnconfigure(2, weight=0, minsize=100)
        self.frame.grid_columnconfigure(3, weight=1)


# /***********************************************************************
# //
# ************************************************************************/


class TestStatusbar(PysolStatusbar):
    def __init__(self, top, args):
        PysolStatusbar.__init__(self, top)
        # test some settings
        self.updateText(moves=999, gamenumber="#0123456789ABCDEF0123")
        self.updateText(info="Some info text.")

def statusbar_main(args):
    tk = Tkinter.Tk()
    statusbar = TestStatusbar(tk, args)
    tk.mainloop()
    return 0

if __name__ == "__main__":
    sys.exit(statusbar_main(sys.argv))


