########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Set/Owner.py,v 1.6 2004/09/23 20:53:32 mbrown Exp $
"""
Implementation of '4ss set owner' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command sets the owner of a resource in a 4Suite \
repository. The new owner must be an existing User. If necessary, you \
will be prompted first for credentials and access info to connect to
the repository."""

import sys

from Ft.Server.Client import FtServerClientException
from Ft.Server.Client.Commands import CommandUtil
from Ft.Server.Common import AclConstants, ResourceTypes


def Run(options, args):
    commit = False
    repo = CommandUtil.GetRepository(options, '4ss.set.owner')
    if repo is not None:
        try:
            ownername = args['newowner']
            res = repo.fetchResource(args['path'])
            user = repo.fetchUserOrGroupByName(ownername)
            if user is not None:
                if user.isResourceType(ResourceTypes.ResourceType.USER):
                    res.setOwner(user)
                    commit = True
                else:
                    sys.stderr.write("%s is a Group, not a User.\n" % ownername)
                    sys.stderr.flush()
            else:
                sys.stderr.write("User %s does not exist.\n" % ownername)
                sys.stderr.flush()
        finally:
            try:
                if commit:
                    repo.txCommit()
                else:
                    repo.txRollback()
            except:
                pass


def Register():
    from Ft.Lib.CommandLine import Options, Command, Arguments
    cmd = Command.Command('owner',
                          'Set the owner of a resource in a repository',
                          'username /repo/path/to/doc.xml',
                          __doc__,
                          function=Run,
                          arguments=[Arguments.RequiredArgument('path',
                                                                'path of the resource',
                                                                str),
                                     Arguments.RequiredArgument('newowner',
                                                                'name of the User to set as the new owner',
                                                                str),
                                     ],
                          options=Options.Options([
                                                   ]),
                          fileName=__file__,
                          )
    return cmd

