<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
  <!ENTITY fschema "http://schemas.4suite.org/4ss">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fcore="http://xmlns.4suite.org/4ss/score" xmlns:frdf="http://xmlns.4suite.org/4ss/rdf" xmlns:fhttp="http://xmlns.4suite.org/4ss/http" xmlns:exslt="http://exslt.org/common" xmlns:exslt-set="http://exslt.org/sets" xmlns:exslt-math="http://exslt.org/math" xmlns:exslt-functions="http://exslt.org/functions" xmlns:exslt-date-time="http://exslt.org/dates-and-times" xmlns:dc="&dc;" xmlns:fres="&fres;" xmlns:rdf="&rdf;" xmlns:f="&f;" xmlns:fschema="http://schemas.4suite.org/4ss" extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time">
  <xsl:template name="group-manager">
    <input type="hidden" name="action" value="changeGroup"/>
    <table class="normal" cellpadding="4" cellspacing="1">
      <tr>
        <td colspan="2">
          <span class="blackTitle">Editing a Group ( <xsl:value-of select="/fres:Group/@name"/> )</span>
        </td>
      </tr>
      <tr>
        <th align="center" class="grayBar" colspan="2">Members</th>
      </tr>
      <xsl:for-each select="fcore:get-member-paths($resourcePath)">
        <tr>
          <td class="cellEntry">
            <a href="{.}"/>
            <xsl:value-of select="."/>
          </td>
          <td class="cellEntry">
            <input type="checkbox" name="delete:{.}"/>
          </td>
        </tr>
      </xsl:for-each>
      <tr>
        <td colspan="2" align="middle">
          <input type="submit" value="Remove Member(s)" name="submit"/>
        </td>
      </tr>
      <xsl:variable name="newUserStatements" select="frdf:complete(frdf:any(),'&fschema;#type','&fschema;#user')[Subject != fcore:get-member-paths($resourcePath)]"/>
      <xsl:variable name="newGroupStatements" select="frdf:complete(frdf:any(),'&fschema;#type','&fschema;#group')[Subject != fcore:get-member-paths($resourcePath) and Subject != $resourcePath]"/>
      <xsl:if test="$newUserStatements or $newGroupStatements">
        <tr>
          <td>
            <select name="newUser">
              <xsl:if test="$newUserStatements">
                <optgroup label="Users:">
                  <xsl:for-each select="$newUserStatements">
                    <option value="{./Subject}">
                      <xsl:value-of select="./Subject"/>
                    </option>
                  </xsl:for-each>
                </optgroup>
              </xsl:if>
              <xsl:if test="$newGroupStatements">
                <optgroup label="Groups:">
                  <xsl:for-each select="$newGroupStatements">
                    <option value="{./Subject}">
                      <xsl:value-of select="./Subject"/>
                    </option>
                  </xsl:for-each>
                </optgroup>
              </xsl:if>
            </select>
          </td>
        </tr>
        <tr>
          <td colspan="7" align="middle">
            <input type="submit" value="Add Member" name="submit"/>
          </td>
        </tr>
      </xsl:if>
    </table>
  </xsl:template>
</xsl:stylesheet>
