########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/SCore/ObjectCache.py,v 1.3 2003/01/10 05:39:12 mbrown Exp $
"""
An object cache that has the life span of a transaction

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

class ObjectCache:
    """
    An object cache that has the life span of a transaction
    """

    def __init__(self):

        self._cache = {}

    def getResource(self,path):
        return self._cache.get((path.resourceType,path.absolutePath))

    def registerResource(self,path,obj):
        self._cache[(path.resourceType,path.absolutePath)] = obj

    def unregisterResource(self,path):
        if self._cache.has_key((path.resourceType,path.absolutePath)):
            del self._cache[(path.resourceType,path.absolutePath)]
