########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/SCore/SchematronDocumentImp.py,v 1.8 2003/01/10 05:39:12 mbrown Exp $
"""
SchematronDocument repository resource class

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

import XmlDocumentImp

from Ft.Server.Common import ResourceTypes, SchematronStylesheet
from Ft.Xml.Xslt import StylesheetReader

class SchematronDocumentImp(XmlDocumentImp.XmlDocumentImp):
    """
    Provides implementation specific to a schematron document resource
    """
    resourceType = ResourceTypes.ResourceType.SCHEMATRON_DOCUMENT

    def asSchematron(self):
        self._verifyTx()
        r = StylesheetReader.StylesheetReader()
        return r.fromInstant(self._driver.fetchResourceCache(self._path),
                             self._path.absolutePathAsUri)


    def setContent(self, src):
        XmlDocumentImp.XmlDocumentImp.setContent(self,src)

        sch = SchematronStylesheet.ParseSchematron(src,
                                                   self._path.absolutePathAsUri,
                                                   self._driver).root
        self._driver.setResourceCache(self._path,
                                      sch
                                      )




