########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/__init__.py,v 1.9 2006/09/30 20:15:13 jkloth Exp $
"""
Repository server (direct access) base module

Copyright 2005 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ft.Server import FtServerBaseException, FTSERVER_NAMESPACE

#FTSERVER_SERVER_NS = FTSERVER_NAMESPACE + '/server'
FTSERVER_SERVER_NS = FTSERVER_NAMESPACE

import MessageSource

class FtServerServerException(FtServerBaseException):
    """
    Exception class for errors incurred while using the
    server core APIs
    """
    MessageSource = MessageSource

Error = MessageSource.Error

# Base class for modules used in servers
class Module:

    commands = {}

    handlers = {}

    def __init__(self, log):
        self.log = log
        return


    def initialize(self, parser, config):
        """
        Hook to allow all modules to perform whatever is needed before
        beginning to process configuration entries.
        """
        pass

    def finalize(self, parser, config):
        """
        Hook to allow all modules to perform whatever is needed after
        entries have been read.
        """
        pass

    def loadObject(self, path):
        if '.' not in path:
            raise ValueError("path must be in dotted-form")
        print 'FIXME - load in restricted execution,', path
        parts = path.split('.')
        try:
            module = __import__('.'.join(parts[:-1]), {}, {}, parts[-1:])
        except ImportError:
            raise
        except:
            import sys, traceback
            error = traceback.format_exception_only(*sys.exc_info()[:2])
            raise ImportError(error)
        else:
            return getattr(module, parts[-1])
