<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY bbschema "http://uche.ogbuji.net/example/buyerbase/schema#">
  <!ENTITY bb "http://uche.ogbuji.net/example/buyerbase">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f  "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
]>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-set="http://exslt.org/sets"
  xmlns:exslt-math="http://exslt.org/math"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:exslt-date-time="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;"
  xmlns:fres="&fres;"
  xmlns:bb="&bb;"
  xmlns:rdf="&rdf;"
  xmlns:f="&f;"
  xmlns:xlink='http://www.w3.org/1999/xlink'
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time">

  <!--
File:  cl-container.xslt

Description:

    Used by the 4ss command line when fetch container is called

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/

  -->

  <xsl:output method='text'/>

  <xsl:param name='fres:absolute-path'/>
  <xsl:param name='fres:base-path'/>

  <xsl:template match='/'>
    <xsl:value-of select="concat('Listing of ',$fres:absolute-path,'&#10;')"/>
    <xsl:apply-templates select='fres:Container/fres:Children/fres:ChildReference'/>
    <xsl:value-of select="concat('total: ',count(fres:Container/fres:Children/fres:ChildReference),'&#10;')"/>
  </xsl:template>

  <xsl:template match='fres:ChildReference'>
    <xsl:apply-templates select='document(concat(f:resolve-path($fres:base-path,@xlink:href),";no-traverse"))/fres:MetaData'>
      <xsl:sort select='@path'/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match='fres:MetaData'>
    <xsl:param name='max-size' select='6'/>
    <xsl:param name='max-imt' select='11'/>
    <xsl:param name='max-time' select='18'/>

    <xsl:variable name='display' select='@path'/>
    <xsl:variable name='actual-display'>
      <xsl:choose>
        <xsl:when test='starts-with($display,"/")'>
          <xsl:value-of select='substring-after($display,"/")'/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select='$display'/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:call-template name='add-space'>
      <xsl:with-param name='num' select='$max-imt - string-length(fres:Imt)'/>
    </xsl:call-template>
    <xsl:value-of select='fres:Imt'/>
    <xsl:variable name='size'>
      <xsl:choose>
        <xsl:when test="fres:Size &lt; 1048576">
          <xsl:value-of select='format-number(fres:Size div 1024.0, "#,##0.0kB")'/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select='format-number(fres:Size div 1048576.0, "#,##0.0MB")'/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:call-template name='add-space'>
      <xsl:with-param name='num' select='$max-size - string-length($size)'/>
    </xsl:call-template>
    <xsl:value-of select='concat(" ",$size," ")'/>
    <xsl:variable name='now' select='fres:LastModifiedDate'/>
    <xsl:variable name='time' select='concat(format-number(exslt-date-time:hour-in-day($now),"00"),":",format-number(exslt-date-time:minute-in-hour($now),"00")," ",format-number(exslt-date-time:day-in-month($now),"00"),"-",exslt-date-time:month-abbreviation($now),"-",exslt-date-time:year($now)
    )'/>
    <xsl:value-of select='concat(" ",$time," ")'/>
    <xsl:call-template name='add-space'>
      <xsl:with-param name='num' select='$max-time - string-length($time)'/>
    </xsl:call-template>
    <xsl:value-of select='$actual-display'/>
    <xsl:if test="contains(@type,'#container')">/</xsl:if>
    <xsl:apply-templates select='frdf:complete(f:resolve-path($fres:absolute-path,@path),"http://schemas.4suite.org/4ss#alias.reference",frdf:any())[1]' mode='alias-ref'/>
    <xsl:value-of select="'&#10;'"/>
  </xsl:template>

  <xsl:template match='Statement' mode='alias-ref'>
    <xsl:text> -&gt; </xsl:text>
    <xsl:value-of select='Object'/>
  </xsl:template>

  <xsl:template name='add-space'>
    <xsl:param name='num'/>
    <xsl:if test='$num > 0'>
      <xsl:text> </xsl:text>
      <xsl:call-template name='add-space'>
        <xsl:with-param name='num' select='$num - 1'/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
