from Ft.Server.Common import CreationParams, ResourceTypes
from Ft.Server.Server import FtServerServerException, Error

import test_helper

DOC1=u"""<?xml version = "1"?><foo xmlns:ft = 'foo.com'><ft:name>Chimezie</ft:name><ft:name>Glenn</ft:name></foo>"""
DOC2=u"""<?xml version = "1"?><foo xmlns:ft = 'foo.com'><ft:name>Chimezie</ft:name><ft:name>Uche</ft:name></foo>"""
DOC3=u"""<?xml version = "1"?><foo xmlns:ft = 'foo.com'><ft:name>Mike</ft:name><ft:name>Glenn</ft:name></foo>"""


indexingCreationParams=CreationParams.CreationParams(1) 
nonindexingCreationParams=CreationParams.CreationParams() 

def test_index(tester):
    return 0
    repo = test_helper.GetRepo(tester)
    
    tester.startGroup("MetaXmlServer Document Index")

    tester.startTest("Create an indexing Document Definition")


    maps = [("$uri",'"NAME"',"//ft:name",0)]
    nss = {'ft':'foo.com'}

    ddRoot = repo.fetchResource('/test')
 
    dd = ddRoot.createXPathDocumentDefinition('def1',nss,maps,indexingCreationParams)
    tester.compare(1,dd.getCreationParams().fullTextIndex)
    tester.testDone()
    repo.txCommit()

    repo = test_helper.GetRepo(tester)
    tester.startTest("Adding a MetaXmlDocument w/ previous DD and checking index")

    date=0
    if repo.hasResource('/SwishIndex/_4ss_Swish_Index'):
        date = repo.fetchResourceInformation('_4ss_Swish_Index').lastModifiedDate

    doc = repo.createDocument('/test/testDocument1',DOC1,docDef = '/test/def1')

    tester.compare(ResourceTypes.ResourceType.RAW_FILE, repo.hasResource("/ftss/_4ss_swishIndex"))
    tester.compare(1, repo.fetchResource("/ftss/_4ss_swishIndex").getLastModifiedDate() > 0)
   
    repo.txRollback()
    tester.testDone()
    
    tester.groupDone()    
    return 1

def test_search(tester):

    repo = test_helper.GetRepo(tester)

    tester.startGroup("Simple search on MetaXmlDocument")

    tester.startTest("Adding an indexable MetaXmlDocument")
    testCont=repo.fetchResource('/test')
    doc=testCont.createDocument('testDocument1',DOC1,docDef = 'def1')
    tester.testDone()    

    tester.startTest("Searching for existing content")    
    matches=repo.searchDocuments('Chimezie')
    tester.compare(1,len(matches))
    tester.compare(doc.getAbsolutePath(),matches[0])

    matches=repo.searchDocuments('Chimezie and Glenn')
    tester.compare(1,len(matches))
    tester.compare(doc.getAbsolutePath(),matches[0])
    tester.testDone()    

    tester.startTest("Searching for non-existent content")
    matches=repo.searchDocuments('BloodFire')
    tester.compare(0,len(matches))
    repo.txRollback()
    tester.testDone()
    tester.groupDone()

    repo = test_helper.GetRepo(tester)

    tester.startGroup("Search on multiple MetaXmlDocuments")

    uri1 = repo.createDocument('/test/testDocument1',DOC1,docDef = '/test/def1').getAbsolutePath()
    uri2 = repo.createDocument('/test/testDocument2',DOC2,docDef = '/test/def1').getAbsolutePath()
    uri3 = repo.createDocument('/test/testDocument3',DOC3,docDef = '/test/def1').getAbsolutePath()
    
    tester.startTest("Searching for content in 2 documents")
    matches=repo.searchDocuments('Chimezie')
    tester.compare(2,len(matches))
    tester.compareIn(matches,uri1)
    tester.compareIn(matches,uri2)
    tester.testDone()

    tester.startTest("Searching for content in 1 document")
    matches=repo.searchDocuments('Mike')
    tester.compare(1,len(matches))
    tester.compareIn(matches,uri3)
    tester.testDone()

    tester.startTest("Searching for non-existent content")
    matches=repo.searchDocuments('BumbaClot')
    tester.compare(0,len(matches))
    tester.testDone()    

    repo.txRollback()
    tester.groupDone()
    
def test_reindex(tester):

    repo = test_helper.GetRepo(tester)
    tester.startGroup("Reindex test")

    doc = repo.createDocument('/test/testDocument1',DOC1,docDef = '/test/def1')
    uri = doc.getAbsolutePath()
   
    date = repo.fetchResource("/ftss/_4ss_swishIndex").getLastModifiedDate()

    tester.startTest("Updating a document w/ new content and reindexing")
    #Note this will actuall reindex twice...
    doc.setContent(DOC2)
    repo.reindex()
    tester.compare(1,repo.fetchResource("/ftss/_4ss_swishIndex").getLastModifiedDate() > date)
    tester.testDone()

    tester.startTest("Searching for new content")
    matches=repo.searchDocuments('Uche')
    tester.compare(1,len(matches))
    tester.compare(uri,matches[0])
    tester.testDone()

    tester.startTest("Clearing 'fullTextIndex' bit on Doc Def and reindexing")

    ddRoot = repo.fetchResource('/test')
 
    dd = ddRoot.fetchResource('def1')
    dd.setCreationParams(nonindexingCreationParams)
   
    repo.reindex()
    tester.compare(0,repo.hasResource('/SwishIndex/_4ss_Swish_Index'))
    tester.testDone()

    tester.startTest("Testing search w/ no index")
    tester.compare(0,len(repo.searchDocuments('Chimezie')))
    tester.testDone()
    
    repo.txRollback()
    
    tester.testDone()
    
    tester.groupDone()


    
def test_clean(tester):
    repo = test_helper.GetRepo(tester)
    tester.startTest("Clean Up")
    if repo.hasResource('/test'):
        t = repo.fetchResource('/test')
        t.delete()
    repo.createContainer("/test")
    repo.txCommit()
    tester.testDone()


def Test(tester):
    test_clean(tester)    
    if not test_index(tester):
        return
    test_search(tester)
    test_reindex(tester)
    test_clean(tester)
    
