

import test_helper

from Ft.Server.Common import DocumentReference, ResourceTypes

def test_complete_function(tester):

    sty = """<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
  xmlns:fcore='http://xmlns.4suite.org/4ss/score'
  xmlns:frdf='http://xmlns.4suite.org/4ss/rdf'
  extension-element-prefixes="fcore frdf"
  >
  <xsl:output method='xml'/>
  <xsl:template match="/">
    <xsl:copy-of select='frdf:complete("/test","http://www.w3.org/1999/02/22-rdf-syntax-ns#type",frdf:any())'/>
  </xsl:template>
</xsl:stylesheet>"""

    expected = """<?xml version='1.0' encoding='UTF-8'?>\n<Statement><Subject>/test</Subject><Predicate>http://www.w3.org/1999/02/22-rdf-syntax-ns#type</Predicate><Object>http://schemas.4suite.org/4ss#container</Object></Statement>"""

    tester.startTest("XSLT Extension RDF Complete")

    repo = test_helper.GetRepo(tester)

    test = repo.fetchResource('test')
    test_helper.TestXslt(tester,test,sty,expected)
    repo.txCommit()

    tester.testDone()


def test_complete_element(tester):

    sty = """<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
  xmlns:fcore='http://xmlns.4suite.org/4ss/score'
  xmlns:frdf='http://xmlns.4suite.org/4ss/rdf'
  extension-element-prefixes="fcore frdf"
  >
  <xsl:output method='xml'/>
  <xsl:template match="/">
    <frdf:complete s='/test' p = 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type'/>
  </xsl:template>
</xsl:stylesheet>"""

    expected = """<?xml version='1.0' encoding='UTF-8'?>\n<Statement><Subject>/test</Subject><Predicate>http://www.w3.org/1999/02/22-rdf-syntax-ns#type</Predicate><Object>http://schemas.4suite.org/4ss#container</Object><StatementUri></StatementUri><SourceUri>http://schemas.4suite.org/4ss#system</SourceUri></Statement>"""

    tester.startTest("XSLT Extension RDF Complete Element")

    repo = test_helper.GetRepo(tester)

    test = repo.fetchResource('test')
    test_helper.TestXslt(tester,test,sty,expected)
    repo.txCommit()

    tester.testDone()


def cleanup(tester):

    tester.startTest("Clean Up")
    repo = test_helper.GetRepo(tester)
    if repo.hasResource('/test'):
        t = repo.fetchResource('/test')
        t.delete()
    
    repo.createContainer('test')
    repo.txCommit()
    tester.testDone()




def Test(tester):

    cleanup(tester)
    test_complete_function(tester)
    test_complete_element(tester)

