#ifndef LIGHT_H
#define LIGHT_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

#include "vector.h"
#include "tmatrix.h"
#include <vector>
namespace boost { namespace python {
	class list;
}}

namespace visual {

struct lighting 
{
	double ambient;
	int n_lights;
	static const int max_lights = 8;        // treat as a member
	vector L[max_lights];

  /* All lights are monochrome, directional light sources for now.  The L
     vector points in the direction of the light, and has magnitude equal
     to the intensity of the light. 
     
     Ambient, n_lights, and L are exposed to clients for performance.  In
     an ideal universe, all clients would use the methods below.
   */

	lighting();
	lighting( const lighting& copy, const tmatrix& frame);
	lighting( const lighting& old, boost::python::list);
	boost::python::list as_list();

	double illuminate( const vector& normal);

	double illuminate( double nx, double ny, double nz);
};

} // !namespace visual

#endif
