#
# This file stores the global PythonCAD preferences, and
# is written itself in Python. Copy this file to the file
# '/etc/pythoncad/prefs.py' and it will be loaded and used
# to store global preferences for the program. Whenever
# a new image is opened, that image will use the global
# preferences for setting itself up. Each drawing window
# can then adjust these preferences by using the Preferences
# menus.
#
# When PythonCAD starts, a set of default values for the
# various options any image may set is stored, then the
# '/etc/pythoncad/prefs.py' file is searched for. If it
# is found, the values in the file will override the initial
# set of defaults. Variables defined in this file can
# therefore be commented out without problem.
#
# Any user can copy this file to their home directory and
# store it in a '.pythoncad' directory if they choose. By
# modifying their local preference file the user can add
# new linestyles, new dimension styles, or tailor the
# default configuration of the program to whatever works
# best.
#
# When defining a string value, the string can be in
# any case: 'UPPER', 'lower', or 'MiXeD'. The program will
# convert the string to upper case when testing the values
# entered here. Any time a string is given but the program
# fails to accept it due to case issues is a bug ...
#
# User Prefs
#
# This variable is meant as an adminstrators tool of
# disabling the reading of a preference file in the
# user's home directory. By default PythonCAD will look
# for a file in ${HOME}/.pythoncad/prefs.py after reading
# the global preference file '/etc/pythoncad/prefs.py'.
# If the user_prefs variable is set to False, the search
# for a user's preference file is not done.
#
# The prescence of this variable only makes sense in
# the '/etc/pythoncad.prefs' file.
#
# Valid choices: True, False

user_prefs = True

#
# Units
#
# The basic unit of length in an image.
#
# Valid choices:
# 'millimeters', 'micrometers', 'meters', 'kilometers',
# 'inches', 'feet', 'yards', 'miles'
#

units = 'millimeters'

#
# Chamfer Length
#
# The default chamfer length in an image.
#
# Valid values: Any numerical value 0.0 or greater
#

chamfer_length = 1.5

#
# Fillet Radius
#
# The default fillet radius in an image.
#
# Valid values: Any numerical value 0.0 or greater
#

fillet_radius = 2.0

#
# Leader arrow size
#
# This option sets the default arrow size on leader lines.
#
# Valid values: Any numerical value 0.0 or greater
#

leader_arrow_size = 10.0

#
# Dimension Options
#

#
# Dual Dimension display
#
# This option will set any new dimension object to display
# both possible dimension strings by default.
#
# Valid choices: True, False
#

dim_dual_mode = True

#
# Highlight Points
#
# This option will activate the drawing of small boxes around
# the Point entities in an image.
#
# Valid choices: True, False
#

highlight_points = True

#
# Linetypes
#
# There are several default Linetypes provided in PythonCAD.
# If you want to define more, they are added here.
#
# Each Linetype is defined as a tuple of two objects:
#
# (name, dashlist)
#
# The name is a string or unicode string, and the dash list
# is either 'None' (meaning a solid line), or a list with
# an even number of integer values. Each value pair represents
# the on-off bit pattern in the line.
#
# Examples:
# A dashed linetype called 'dash' with 4 bits on then 4 bits off:
# ('dash', [4, 4])
#
# A dashed linetype called 'dash2' with 10 bits on, 2 off, 6 on, 2 off
# (u'dash2', [10, 2, 6, 2]) # the "u" means unicode ...
#
# Add any new linetypes you wish in the linetypes list variable
#

linetypes = [
    # ('dash', [4, 4]), # dash example above
    # (u'dash2', [10, 2, 6, 2]), # dash2 example above
    ]

#
# Colors
#
# By default PythonCAD starts with eight basic colors defined.
# If you want to add more, here is where to add them.
#
# A Color is defined in one of two ways:
#
# '#xxxxxx' - a hexidecimal string like '#ff00ff'
# (r, g, b) - a tuple with three integers giving the red, green, and
#             blue values. Each value must be 0 <= val <= 255.
#
# Add any new colors you wish to use in the colors list variable

colors = [
    # '#ffffff', # hexidecimal example
    # '#33cc77', # another hex example
    # (100, 50, 30), # tuple example
    # (255, 30, 180), # another tuple example
    ]

#
# Styles
#
# Styles define a common set of properties for objects like
# segments, circles, and arcs. There are eight default styles
# in PythonCAD, and adding more styles can be done here.
#
# Defining a style is done by creating a tuple containing
# four fields:
#
# (name, linetype, color, thickness)
#
# The 'name' field is simply a string or unicode string. The
# 'linetype' field is a two object tuple described above, and
# the 'color' field is described above also. The 'thickness'
# field is a positive float value giving the line thickness.
#
# Examples:
#
# (u'style1', (u'lt1', [10, 4]), '#ffcc99', 0.1)
# A style called 'style1', composed of a linetype called 'lt1'
# which is a dashed line 10 bits on, 4 off, drawn with the
# color '#ffcc99' and 0.1 units thick.
#
# Add any new styles you want to use to the 'styles' list
# variable below. Several examples are included to provide
# a starting guide for creating new styles.
#
#

styles = [
    # (u'style1', (u'lt1', [10, 4]), '#ffcc99', 0.1), # example
    # (u'style2', (u'lt2', [6, 2, 10, 4]), '#cc00ff', 0.3), # another example
    # (u'style3', (u'lt3', [2, 6, 2, 2]), '#8844bb', 0.2), # third example
    ]

#
# Default style
#
# Set this variable to the name of the style you want the
# initial drawing style to be in PythonCAD. If you set this
# variable to None, or comment it out, the default style
# will be a solid white line.

default_style = None

#
# Dimension Styles
#
# A dimension style is a set of parameters that define
# how the dimension looks. Any dimension has a large number
# of attributes that can be set, so a dimension style is
# a way of grouping together these attributes into a common
# set and offering a means of making the dimensions look
# uniform.
#
# Defining a dimension style requires creating a dictionary
# with a certain keys and values. PythonCAD defines a single
# default dimension style, and any new dimension styles that
# are created here use that default style as a base, and the
# values in the new style then override the defaults.
#
# The list of dictionary keys and acceptable values is
# somewhat long. This list is given below with each key
# and the acceptable values for each key listed.
#
# Key: 'DIM_PRIMARY_FONT_FAMILY'
# Values: A string giving the font name
# Default: 'Sans'
#
# Key: 'DIM_PRIMARY_FONT_SIZE'
# Values: A positive integer value
# Default: 12
#
# Key: 'DIM_PRIMARY_TEXT_SIZE'
# Values: A positive float value
# Default: 1.0
#
# Key: 'DIM_PRIMARY_FONT_WEIGHT'
# Values: Either 'Normal', 'Light', 'Bold', or 'Heavy'
# Default: 'Normal'
#
# Key: 'DIM_PRIMARY_FONT_STYLE'
# Values: 'Normal', 'Oblique', or 'Italic'
# Default: 'Normal'
#
# Key: 'DIM_PRIMARY_FONT_COLOR'
# Values: A Color definition (see above), like (255, 255, 255) or '#ffffff'
# Default: '#ffffff'
#
# Key: 'DIM_PRIMARY_PREFIX'
# Value: A string or unicode string
# Default: u''
#
# Key: 'DIM_PRIMARY_SUFFIX'
# Value: A string or unicode string
# Default: u''
#
# Key: 'DIM_PRIMARY_PRECISION'
# Value: An integer value where 0 <= value <= 15
# Default: 3
#
# Key: 'DIM_PRIMARY_UNITS'
# Value: 'Millimeters', 'Micrometers', 'Meters', 'Milometers',
#        'Inches', 'Feet', 'Yards', 'Miles'
# Default: 'Millimeters'
#
# Key: 'DIM_PRIMARY_LEADING_ZERO'
# Value: True or False
# Default: True
#
# Key: 'DIM_PRIMARY_TRAILING_DECIMAL'
# Value: True or False
# Default: True
#
# Key: 'DIM_SECONDARY_FONT_FAMILY'
# Values: A string giving the font name
# Default: 'Sans'
#
# Key: 'DIM_SECONDARY_FONT_SIZE'
# Values: A positive integer value
# Default: 12
#
# Key: 'DIM_SECONDARY_TEXT_SIZE'
# Values: A positive float value
# Default: 1.0
#
# Key: 'DIM_SECONDARY_FONT_WEIGHT'
# Values: Either 'Normal', 'Light', 'Bold', or 'Heavy'
# Default: 'Normal'
#
# Key: 'DIM_SECONDARY_FONT_STYLE'
# Values: 'Normal', 'Oblique', or 'Italic'
# Default: 'Normal'
#
# Key: 'DIM_SECONDARY_FONT_COLOR'
# Values: A Color definition (see above), like (255, 255, 255) or '#ffffff'
# Default: '#ffffff'
#
# Key: 'DIM_SECONDARY_PREFIX'
# Value: A string or unicode string
# Default: u''
#
# Key: 'DIM_SECONDARY_SUFFIX'
# Value: A string or unicode string
# Default: u''
#
# Key: 'DIM_SECONDARY_PRECISION'
# Value: An integer value where 0 <= value <= 15
# Default: u''
#
# Key: 'DIM_SECONDARY_UNITS'
# Value: 'Millimeters', 'Micrometers', 'Meters', 'Milometers',
#        'Inches', 'Feet', 'Yards', 'Miles'
# Default: 'Millimeters'
#
# Key: 'DIM_SECONDARY_LEADING_ZERO'
# Value: True or False
# Default: True
#
# Key: 'DIM_SECONDARY_TRAILING_DECIMAL'
# Value: True or False
# Default: True
#
# Key: 'DIM_OFFSET'
# Value: A float value of 0.0 or greater.
# Default: 1.0
#
# Key: 'DIM_EXTENSION'
# Value: A float value of 0.0 or greater.
# Default: 1.0
#
# Key: 'DIM_COLOR'
# Value: A Color definition (see above), like (255, 255, 255) or '#ffffff'
# Default: (255, 165, 0)
#
# Key: 'DIM_THICKNESS'
# Value: A float value of 0.0 or greater.
# Default: 0.0
#
# Key: 'DIM_POSITION'
# Value: 'Split', 'Above', 'Below'
# Default: 'Split'
#
# Key: 'DIM_ENDPOINT'
# Value: 'No_endpoint' or 'None' or None, 'Arrow', 'Filled_arrow',
#        'Slash', 'Circle'
# Default: None
#
# Key: 'DIM_ENDPOINT_SIZE'
# Value: A float vale of 0.0 or greater.
# Default: 1.0
#
# Key: 'DIM_DUAL_MODE'
# Value: True or False
# Default: False
#
# Key: 'RADIAL_DIM_PRIMARY_PREFIX'
# Value: A string or unicode string
# Default: u''
#
# Key: 'RADIAL_DIM_PRIMARY_SUFFIX'
# Value: A string or unicode string
# Default: u''
#
# Key: 'RADIAL_DIM_SECONDARY_PREFIX'
# Value: A string or unicode string
# Default: u''
#
# Key: 'RADIAL_DIM_SECONDARY_SUFFIX'
# Value: A string or unicode string
# Default: u''
#
# Key: 'RADIAL_DIM_DIA_MODE'
# Value: True or False
# Default: False
#
# Key: 'ANGULAR_DIM_PRIMARY_PREFIX'
# Value: A string or unicode string
# Default: u''
#
# Key: 'ANGULAR_DIM_PRIMARY_SUFFIX'
# Value: A string or unicode string
# Default: u''
#
# Key: 'ANGULAR_DIM_SECONDARY_PREFIX'
# Value: A string or unicode string
# Default: u''
#
# Key: 'ANGULAR_DIM_SECONDARY_SUFFIX'
# Value: A string or unicode string
# Default: u''
#
#
# The keys that begin 'DIM_PRIMARY_' apply are specific to the
# primary dimension in any dimension, and 'DIM_SECONDARY_' are
# specific to the secondary dimension. 'RADIAL_DIM_' and
# 'ANGULAR_DIM_' are obviously applicible to those specific
# dimension types.
#
# 'DIM_OFFSET' is the distance between the dimensioned point and
# the start of the dimension bar, and 'DIM_EXTENSION' is the
# distance between where the dimension crossbar intersects the
# dimension bar and the end of the dimension bar. 'DIM_POSITION'
# will be used in placing the dimension text around the dimension
# crossbar. The names of the keys were chosen to be somewhat
# self explanatory, but they could change in future releases.
#
# As a dimension style is built by overriding the default values,
# creating a new style only requires changing the fields that
# you wish to update. In the example below, the four fields
# 'dim_offset', 'dim_endpoint', 'dim_endpoint_size', and
# 'dim_extension' are modified.

example_dict = {
    'dim_offset' : 5.0,
    'dim_endpoint' : 'filled_arrow',
    'dim_endpoint_size' : 10.0,
    'dim_extension' : 5.0,
    }
#
# here is an example of a dimension style with more changes
#

dimstyle_example_2 = {
    'dim_primary_font_family' : 'Times',
    'dim_primary_text_size' : 24.0,
    'dim_primary_font_color' : '#dd44bb',
    'dim_primary_suffix' : u' mm',
    'dim_primary_precision' : 2,
    'dim_secondary_font_family' : 'Helvetica',
    'dim_secondary_text_size' : 18.0,
    'dim_secondary_font_color' : '#33ee55',
    'dim_secondary_suffix' : u' in.',
    'dim_secondary_units' : 'inches',
    'dim_offset' : 10.0,
    'dim_endpoint' : 'slash',
    'dim_endpoint_size' : 10.0,
    'dim_extension' : 5.0,
    'radial_dim_primary_prefix' : u'R. ',
    'radial_dim_primary_suffix' : u' mm',
    'radial_dim_secondary_prefix' : u'R. ',
    'radial_dim_secondary_suffix' : u' in.',
    'dim_dual_mode' : True,
    }
#
# The creation of the dimension style is done with by creating
# a tuple containing two objects:
#
# (name, dict)
#
# name: The dimension style name
# dict: The dictionary containing the values for the dimension style
#
# Add any dimension styles you create to the dimstyles list below.

dimstyles = [
    # (u'example_dimstyle', example_dict), # example
    # (u'ex2' , dimstyle_example_2), # another example
    ]

#
# Default dimension style
#
# Set this variable to the name of the dimension style you
# want PythonCAD to use by default. If you define this variable
# to None, or comment it out, the default dimension style
# is used.

default_dimstyle = None

#
# Text styles
#
# A text style defines a common set of text attributes
# that are used to define visual elements of some text.
# A single text style is defined in PythonCAD, so if you
# want more text styles here is where to add them.
#
# Defining a text style is done by creating a tuple containing
# six fields:
#
# (name, family, size, style, weight, color)
#
# The 'name' field is the name of the text style, and can be
# used to reference it. The 'family' field is the font family,
# like 'Sans' or 'Times'. The 'size' field is the text size as
# a float. The style can be either 'normal, 'oblique', or 'italic'.
# The 'weight' can be one of 'normal', 'light', 'bold', or 'heavy',
# and the color is a color definition (see above).
#
# Examples:
#
# ('default', 'sans', 10.0, 'normal', 'normal', '#ff00cc')
# A Sans format of color #ff00cc called 'default' that will
# draw the text 10.0 units tall.
#
# ('fancy', 'helvetica', 20, 'italic', 'bold', '#ffff00')
# A bold, italicized Helvetica of color #ffff00 called 'fancy'
# drawing the text 20.0 units tall.
#
# Defining fonts style (and font handling) is still in the
# earliest stages in PythonCAD, so the sections dealing with
# text will most like change ...
#
# Add more text styles you wish to use here
#

textstyles = [
    # ('default', 'sans', 10.0, 'normal', 'normal', '#ff00cc') # example
    ]

#
# Default text style
#
# Set this variable to the name of the text style you
# want PythonCAD to use by default. If you define this variable
# to None, or comment it out, the default text style is used
#

default_textstyle = None

#
# Text properties
#
# In addition to setting the text styles, some default font properties
# can be set in this file. In setting one of the following values, the
# value defined in the default textstyle will be overriden.
#
# The examples below are all commented out. Uncomment the ones you
# want to override the default style info.
#
# Default font family
#
# font_family = 'Sans' # uncomment this to set the default font family
#
# Default font size
# This value must be an integer greater than 0.
#
# font_size = 18 # uncomment this to set the default font size
#
# Default text size
# This value must be an float greater than 0.
#
# text_size = 18.0 # uncomment this to set the default text size
#
# Default font weight
# This can be 'normal', 'light', 'bold', or 'heavy'.
#
# font_weight = 'normal' # uncomment this to set the default font weight
#
# Default font style
# This can be 'normal', 'italic', or 'oblique'.
#
# font_style = 'normal' # uncomment this to set the default font style
#
# Default font color
# This must be a color definition.
#
# font_color = '#ff00ff' # uncomment this to set the default font color

#
# Miscellaneous options
#
# Autosplitting
#
# This option will activate the automatic splitting of segments,
# circles, and arcs if a new point is added directly on the object.
#
# Valid choices: True, False
#

autosplit = True
