/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson   *
 *   nq@altern.org   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEEDITDATASETDIALOG_H
#define QALCULATEEDITDATASETDIALOG_H

#include <kdialogbase.h>
#include <qmap.h>
#include <qvaluevector.h>

class KLineEdit;
class QCheckBox;
class KComboBox;
class QPushButton;
class MathStructure;
class QalculateEditNamesDialog;
class DataSet;
class KListView;
class QTextEdit;
class DataProperty;
class QTabWidget;
class UserFunction;
class QalculateEditDataPropertyDialog;
class QalculateEditDataPropertyNamesDialog;
class QLineEdit;

/**
@author Niklas Knutsson
*/
class QalculateEditDataSetDialog : public KDialogBase {

	Q_OBJECT

public:

	QalculateEditDataSetDialog(QWidget *parent = 0, const char *name = 0);
	virtual ~QalculateEditDataSetDialog();

	DataSet *editDataSet(DataSet *ds = NULL);
	void updateDatasetPropertyList();

	QalculateEditNamesDialog *names_edit_dialog;
	QalculateEditDataPropertyDialog *property_edit_dialog;
	DataSet *edited_dataset;
	KLineEdit *objectArgumentEdit, *propertyArgumentEdit, *defaultPropertyEdit, *nameEdit, *titleEdit, *fileEdit;
	QLabel *namesLabel;
	KListView *propertiesView;
	QTextEdit *descriptionEdit, *copyrightEdit;
	QPushButton *namesButton, *newPropertyButton, *editPropertyButton, *deletePropertyButton;
	QTabWidget *tabs;
	QMap<QListViewItem*, DataProperty*> propertiesItems;
	QValueVector<DataProperty*> tmp_props;
	QValueVector<DataProperty*> tmp_props_orig;

public slots:

	void propertySelectionChanged();
	void editNames();
	void newProperty();
	void editProperty();
	void deleteProperty();
	void nameChanged(const QString&);
	
protected slots:
	
	void slotOk();

};

class QalculateEditDataPropertyDialog : public KDialogBase {

	Q_OBJECT

public:

	QalculateEditDataPropertyDialog(QWidget *parent = 0, const char *name = 0);
	~QalculateEditDataPropertyDialog();

	bool editDataProperty(DataProperty *dp, bool newdp = false);

	QalculateEditDataPropertyNamesDialog *names_edit_dialog;
	DataProperty *edited_property;
	KComboBox *typeCombo;
	KLineEdit *nameEdit, *titleEdit, *unitEdit;
	QLabel *namesLabel;
	QCheckBox *hideButton, *keyButton, *approximateButton, *caseButton, *bracketsButton;
	QPushButton *namesButton;
	QTextEdit *descriptionEdit;

public slots:

	void editNames();
	
protected slots:	
	
	void slotOk();

};

class QalculateEditDataPropertyNamesDialog : public KDialog {

	Q_OBJECT

public:

	QalculateEditDataPropertyNamesDialog(QWidget *parent = 0, const char *name = 0);
	~QalculateEditDataPropertyNamesDialog();

	void saveNames(DataProperty *item, const QString &str = QString::null);
	void setNames(DataProperty *item = NULL, const QString &namestr = QString::null, bool names_edited = false);
	bool isEmpty();
	void setNamesLE(QLineEdit *entry, QLabel *label);

	KListView* namesView;
	QPushButton* newButton;
	QPushButton* deleteButton;
	QPushButton* buttonClose;
	int i_type;

public slots:

	void itemClicked(QListViewItem*, const QPoint&, int);
	void newName();
	void deleteName();
	void nameSelectionChanged();

};

#endif
