/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson   *
 *   nq@altern.org   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEEDITFUNCTIONDIALOG_H
#define QALCULATEEDITFUNCTIONDIALOG_H

#include <kdialogbase.h>
#include <qmap.h>

class QLabel;
class KComboBox;
class KLineEdit;
class QCheckBox;
class QPushButton;
class MathStructure;
class QalculateEditNamesDialog;
class QalculateEditSubFunctionsDialog;
class QalculateEditArgumentDialog;
class MathFunction;
class KListView;
class QTextEdit;
class Argument;
class QTabWidget;
class UserFunction;

/**
@author Niklas Knutsson
*/
class QalculateEditFunctionDialog : public KDialogBase {

	Q_OBJECT

public:

	QalculateEditFunctionDialog(QWidget *parent = 0, const char *name = 0);
	virtual ~QalculateEditFunctionDialog();

	MathFunction *editFunction(QString category = QString::null, MathFunction *f = NULL);

	QalculateEditNamesDialog *names_edit_dialog;
	QalculateEditSubFunctionsDialog *subfunctions_edit_dialog;
	QalculateEditArgumentDialog *argument_edit_dialog;
	MathFunction *edited_function;
	KComboBox *categoryCombo;
	KLineEdit *conditionEdit, *nameEdit, *titleEdit;
	QLabel *namesLabel;
	QCheckBox *hideButton;
	KListView *argumentsView;
	QTextEdit *descriptionEdit, *expressionEdit;
	QPushButton *namesButton, *subFunctionsButton, *newArgumentButton, *editArgumentButton, *deleteArgumentButton;
	QTabWidget *tabs;
	QMap<QListViewItem*, Argument*> argumentsItems;
	QMap<QListViewItem*, bool> argumentsItemsEdited;

public slots:

	void argumentSelectionChanged();
	void argumentRenamed(QListViewItem*, const QString&, int);
	void editNames();
	void newArgument();
	void editArgument();
	void deleteArgument();
	void editSubFunctions();
	void nameChanged(const QString&);

protected slots:
	
	void slotHelp();
	void slotOk();

};

class QalculateEditSubFunctionsDialog : public KDialog {

	Q_OBJECT

public:

	QalculateEditSubFunctionsDialog(QWidget *parent = 0, const char *name = 0);
	virtual ~QalculateEditSubFunctionsDialog();

	void saveSubFunctions(UserFunction *f);
	void setSubFunctions(UserFunction *f = NULL, bool edited = false);
	bool isEmpty();

	KListView* subFunctionsView;
	QPushButton* newButton;
	QPushButton* deleteButton;
	QPushButton* buttonClose;

public slots:

	void itemClicked(QListViewItem*, const QPoint&, int);
	void newSubFunction();
	void deleteSubFunction();
	void selectionChanged();

};

class QalculateEditArgumentDialog : public KDialogBase {

	Q_OBJECT

public:

	QalculateEditArgumentDialog(QWidget *parent = 0, const char *name = 0);
	virtual ~QalculateEditArgumentDialog();

	Argument *editArgument(Argument *arg = NULL);

	KComboBox *typeCombo;
	KLineEdit *nameEdit, *conditionEdit, *maxEdit, *minEdit;
	QCheckBox *conditionButton, *matrixButton, *zeroButton, *complexButton, *maxButton, *minButton, *maxIncludeEqualsButton, *minIncludeEqualsButton, *testButton;

public slots:

	void maxEnabled(bool);
	void minEnabled(bool);
	void typeChanged(int);

};


#endif
