/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson   *
 *   nq@altern.org   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEEDITNAMESDIALOG_H
#define QALCULATEEDITNAMESDIALOG_H

#include <kdialog.h>

class ExpressionItem;
class KListView;
class QPushButton;
class QLineEdit;
class QLabel;
class QListViewItem;

/**
@author Niklas Knutsson
*/
class QalculateEditNamesDialog : public KDialog {

	Q_OBJECT

public:

	QalculateEditNamesDialog(int item_type, QWidget *parent = 0, const char *name = 0);
	virtual ~QalculateEditNamesDialog();

	void saveNames(ExpressionItem *item, const QString &str = QString::null);
	void setNames(ExpressionItem *item = NULL, const QString &namestr = QString::null, bool names_edited = false);
	bool isEmpty();
	void setNamesLE(QLineEdit *entry, QLabel *label);

	KListView* namesView;
	QPushButton* newButton;
	QPushButton* deleteButton;
	QPushButton* buttonClose;
	int i_type;

public slots:

	virtual void itemClicked(QListViewItem*, const QPoint&, int);
	virtual void newName();
	virtual void deleteName();
	virtual void nameChanged(const QString&);
	virtual void nameSelectionChanged();

};

#endif
