/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: rulenameedit.cpp 330 2005-10-02 14:05:27Z cstim $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "rulenameedit.h"

#include <qwidget.h>
#include <qstring.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>

#include <gwenhywfar/debug.h>






RuleNameEdit::RuleNameEdit(const QString &title,
                           const char *name,
                           const char *shortDescr,
                           QWidget* parent,
                           const char *wname,
                           bool modal,
                           WFlags fl)
:RuleNameEditUI(parent, wname, modal, fl) {
  if (!title.isEmpty())
    setCaption(title);
  if (name)
    nameEdit->setText(QString::fromUtf8(name));
  if (shortDescr)
    shortEdit->setText(QString::fromUtf8(name));

  QObject::connect(nameEdit, SIGNAL(textChanged(const QString &)),
                   this, SLOT(slotNameChanged(const QString &)));

}



RuleNameEdit::~RuleNameEdit(){
}



QString RuleNameEdit::getName(){
  return nameEdit->text();
}



QString RuleNameEdit::getShortDescription(){
  return shortEdit->text();
}



void RuleNameEdit::slotNameChanged(const QString &qs) {
  okButton->setEnabled(!qs.isEmpty());
}












