/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: account.h 388 2006-03-08 15:38:34Z aquamaniac $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifndef KBANKING_ACCOUNT_H
#define KBANKING_ACCOUNT_H

#include <aqbanking/accstatus.h>
#include <aqbanking/account.h>

#include <string>
#include <list>

class App;

class Account;


#include "transaction.h"
#include "transfer.h"
#include "standingorder.h"
#include "xastorage.h"
#include "refpointer.h"


/**
 *
 */
class Account {
public:
  Account(App *app);
  Account(App *app, const AB_ACCOUNT *a);
  Account(const Account &a);
  virtual ~Account();

  void updateFromBankingAccount(const AB_ACCOUNT *a);

  bool fromDb(GWEN_DB_NODE *db);
  bool toDb(GWEN_DB_NODE *db);

  const std::string &getCountry() const;
  void setCountry(const std::string &s);

  const std::string &getBankCode() const;
  void setBankCode(const std::string &s);

  const std::string &getAccountNumber() const;
  void setAccountNumber(const std::string &s);

  const std::string &getBankName() const;
  void setBankName(const std::string &s);

  const std::string &getAccountName() const;
  void setAccountName(const std::string &s);

  const std::string &getOwnerName() const;
  void setOwnerName(const std::string &s);

  GWEN_TYPE_UINT32 getBankingId() const;
  void setBankingId(GWEN_TYPE_UINT32 i);

  const AB_ACCOUNT_STATUS *getAccountStatus() const;
  void setAccountStatus(const AB_ACCOUNT_STATUS *s);

  const std::list<RefPointer<Transaction> > &getTransactions();

  /* deprecated ! */
  bool loadTransactions(GWEN_TIME *fromDate,
                        GWEN_TIME *toDate,
                        std::list<Transaction> &tl);

  bool loadTransactions(GWEN_TIME *fromDate,
                        GWEN_TIME *toDate,
                        std::list<RefPointer<Transaction> > &tl);

  bool saveTransaction(const Transaction *t);
  bool saveTransactions();

  bool addTransaction(RefPointer<Transaction> t);
  bool removeTransaction(const Transaction *t);

  void infoTransactionsChanged();

  App *getApi() const;

  AH_STORAGE *getStorage();

  const GWEN_TIME *getLastTransactionDate();

  std::list<RefPointer<Transfer> > &getTransfers();
  void addTransfer(RefPointer<Transfer> t);

  std::list<RefPointer<StandingOrder> > &getStandingOrders();
  void addStandingOrder(RefPointer<StandingOrder> t);
  void clearStandingOrders();

  std::list<RefPointer<Transfer> > &getDatedTransfers();
  void addDatedTransfer(RefPointer<Transfer> t);
  void clearDatedTransfers();

  bool getOptionUpdateTransactions() const;
  void setOptionUpdateTransactions(bool b);

  bool getOptionUpdateBalance() const;
  void setOptionUpdateBalance(bool b);

  bool getOptionUpdateStandingOrders() const;
  void setOptionUpdateStandingOrders(bool b);

  bool getOptionUpdateDatedTransfers() const;
  void setOptionUpdateDatedTransfers(bool b);

  bool getOptionUpdatePending() const;
  void setOptionUpdatePending(bool b);

  bool getOptionExcludeFromGlobalCall() const;
  void setOptionExcludeFromGlobalCall(bool b);

private:
  std::string _country;
  std::string _bankCode;
  std::string _accountNumber;
  std::string _bankName;
  std::string _accountName;
  std::string _ownerName;
  std::list<RefPointer<Transaction> > _transactions;
  std::list<RefPointer<Transfer> > _transfers;
  std::list<RefPointer<StandingOrder> > _standingOrders;
  std::list<RefPointer<Transfer> > _datedTransfers;

  AB_ACCOUNT_STATUS *_accountStatus;
  GWEN_TYPE_UINT32 _bankingId;
  App *_banking;

  bool _optionUpdateTransactions;
  bool _optionUpdateBalance;
  bool _optionUpdateStandingOrders;
  bool _optionUpdateDatedTransfers;
  bool _optionUpdatePending;
  bool _optionExcludeFromGlobalCall;

  AH_STORAGE *_storage;
  GWEN_TIME *_lastTransactionDate;


  bool _loadTransactions(unsigned int fromYear=0,
                         unsigned int fromMonth=0,
                         unsigned int fromDay=0);
  /**
   * @param l list of transactions to merge, may even contain duplicates.
   * This list is expected to be sorted by date.
   * @param fix if true then days in the past will be fixed (e.g. marked
   * as immutable)
   * @param force if true then the <i>fixed</i> flag in the storage of each
   * day is ignored.
   */
  bool _saveTransactions(const std::list<Transaction> &l,
                                  bool fix, bool force);


};





#endif /* KBANKING_ACCOUNT_H */


