/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: timport.h 388 2006-03-08 15:38:34Z aquamaniac $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifndef KBANKING_TIMPORT_H
#define KBANKING_TIMPORT_H

class TransactionImporter;
class App;
class Account;
class Payee;
class Category;


#define TRANSACTION_IMPORTER_FLAGS_COMPLETE_DAYS  0x00000001
#define TRANSACTION_IMPORTER_FLAGS_OVERWRITE_DAYS 0x00000002
#define TRANSACTION_IMPORTER_FLAGS_ASK_ALL_DUPES  0x00000004
#define TRANSACTION_IMPORTER_FLAGS_FUZZY          0x00000008


#include "transaction.h"
#include "refpointer.h"
#include <list>
#include <string>
#include <gwenhywfar/gwentime.h>
#include <aqbanking/imexporter.h>


class TransactionImporter {
public:
  typedef enum {
    SourceType_Backend=0,
    SourceType_ImExporter
  } SourceType;

  typedef enum {
    DupeCheck_Error=-1,
    DupeCheck_DismissNew,
    DupeCheck_AddNew,
    DupeCheck_RemoveOld,
    DupeCheck_ReplaceOld
  } DupeCheckResult;

public:
  TransactionImporter(App *kb,
                      AB_IMEXPORTER_CONTEXT *ctx,
                      GWEN_TYPE_UINT32 flags);
  virtual ~TransactionImporter();

  bool importContext();

protected:
  class DayData {
  public:
    DayData(int year, int month, int d);
    DayData(const DayData &d);
    ~DayData();
    void addTransaction(RefPointer<Transaction> t);

    int getYear() const { return _year; };
    int getMonth() const { return _month;} ;
    int getDay() const { return _day;} ;
    void replaceTransactions(std::list<RefPointer<Transaction> > *tl);
    std::list<RefPointer<Transaction> > *getTransactions() { return _transactions;};

  private:
    int _year;
    int _month;
    int _day;
    std::list<RefPointer<Transaction> > *_transactions;
  };

  class AccountData {
  public:
    AccountData(Account *a);
    AccountData(const AccountData &d);
    ~AccountData();

    const std::string &accountNumber();
    const std::string &bankCode();
    DayData *getNewDayData(int year, int month, int d);

    std::list<DayData*> &getNewDayList() { return _newDayList;};
    Account *account() { return _account;};

  private:
    Account *_account;
    std::list<DayData*> _newDayList;
    };

  bool importTransactions();
  bool importAccounts();
  bool importStandingOrders();
  bool importDatedTransfers();
  AccountData *getAccountData(const char *bankCode,
                              const char *accountNumber);

  bool sortNewTransactions();

  virtual DupeCheckResult
    checkForDuplicate(Account *a,
                      RefPointer<Transaction> tnew,
                      RefPointer<Transaction> told,
                      std::list<RefPointer<Transaction> > &dnl,
                      std::list<RefPointer<Transaction> > &dol,
                      bool &dontAskAgain,
                      DupeCheckResult lastRv);

  virtual Account *askUserForAccount(const std::string &bankCode,
                                     const std::string &accountNumber);
  virtual GWEN_TIME *askUserForDate(const Transaction *t,
                                    const GWEN_TIME *lastDate);

  virtual DupeCheckResult
    askUserForDuplicate(Account *a,
                        RefPointer<Transaction> tnew,
                        RefPointer<Transaction> told,
                        const std::list<RefPointer<Transaction> > &dnl,
                        const std::list<RefPointer<Transaction> > &dol,
                        bool &dontAskAgain);
  virtual Payee *askUserForPayee(RefPointer<Transaction> t,
                                 bool &aborted,
                                 bool &askNoMore);

  virtual Category *askUserForCategory(RefPointer<Transaction> t,
                                       bool &aborted,
                                       bool &askNoMore);

  virtual bool
    presentTransactionsToUser(std::list<RefPointer<Transaction> > &toAdd,
                              std::list<RefPointer<Transaction> > &toDel);

private:
  App *_app;
  AB_IMEXPORTER_CONTEXT *_context;
  std::list<RefPointer<Transaction> > _toImport;
  std::list<AccountData*> _accountDataList;
  std::list<RefPointer<Transaction> > _toAdd;
  std::list<RefPointer<Transaction> > _toDel;

  GWEN_TYPE_UINT32 _flags;

  bool _checkDay(Account *a, TransactionImporter::DayData *d,
                 bool &askNoMore,
                 TransactionImporter::DupeCheckResult &lastRv);
  bool _checkTransactions();
  bool _assignCatsAndPayees();

  bool _adjustPCValues(std::list<RefPointer<Transaction> > &tl, bool add);

  bool _collapseSplits(AB_TRANSACTION *t,
                       const std::string &bankCode,
                       const std::string &accountId);

  AB_ACCOUNT_STATUS *_getBestBalance(AB_IMEXPORTER_ACCOUNTINFO *ai,
                                     bool noted);

};











#endif


