/***************************************************************************
  hop.cpp
  -------------------
  A hop class
  -------------------
  Copyright 1999-2006, David Johnson
  Please see the header file for copyright and license information
 ***************************************************************************/

#include "hop.h"

//////////////////////////////////////////////////////////////////////////////
// Hop()
// -----
// constructor

Hop::Hop()
    : name_("Generic"), weight_(), form_( QString::null), alpha_(0.0), time_(0)
{ ; }

Hop::Hop(const QString &name, const Weight &weight, const QString &form,
         const double &alpha, const unsigned &time)
    : name_(name), weight_(weight), form_(form), alpha_(alpha), time_(time)
      
{
    recalc();
}

Hop::~Hop() { ; }

//////////////////////////////////////////////////////////////////////////////
// Hop(const Hop &)
// ----------------
// Copy constructor

Hop::Hop(const Hop &h)
    : name_(h.name_), weight_(h.weight_), form_(h.form_), alpha_(h.alpha_),
      time_(h.time_), hbu_(h.hbu_)
{ ; }

//////////////////////////////////////////////////////////////////////////////
// operator=()
// -----------
// Assignment operator

Hop Hop::operator=(const Hop &h)
{
    if (this != &h) {
        name_ = h.name_;
        weight_ = h.weight_;
        form_ = h.form_;
        alpha_ = h.alpha_;
        time_ = h.time_;
        hbu_ = h.hbu_;
    }
    return *this;
}

//////////////////////////////////////////////////////////////////////////////
// operator==()
// ------------
// Equivalence operator

bool Hop::operator==(const Hop &h) const
{
    return (name_ == h.name_)
        && (weight_ == h.weight_)
        && (form_ == h.form_)
        && (alpha_ == h.alpha_)
        && (time_ == h.time_);
}

///////////////////////////////////////////////////////////////////////////////
// recalc()
// --------
// Recalculate internal values

void Hop::recalc()
{
    hbu_ = 0.75 * alpha_ * weight_.amount(Weight::ounce);
}
