/* qcam-simple.c -- a simple driver for the Connectix QuickCam */

/* Version 0.3, January 6, 1996 */


/******************************************************************

Copyright (C) 1996 by Scott Laird

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL SCOTT LAIRD BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include <unistd.h>

#include "qcam.h"

int main(int argc, char **argv)
{
  scanbuf *scan;
  struct qcam *q;

  /* Read defaults */

  q=qc_init();
  qc_initfile(q, 0);

  /* Force 80x60@4bpp mode */

  if (qc_setresolution(q,80,60))
    fprintf(stderr,"Bad resolution.\n");

  if (qc_setbitdepth(q,4))
    fprintf(stderr,"Bad bit depth.\n");

  /* Attempt to get permission to access IO ports.  Must be root */

  if (qc_open(q)) {
    perror("Can't get I/O permission");
    exit(1);
  }

  /* Program the QuickCam for this resolution. */

  qc_set(q);

  /* Scan one image and write to stdout. */

  scan=qc_scan(q);
  qc_writepgm(q,stdout,scan);
  free(scan);

  /* Release IO privileges */
  qc_close(q);

  return 0;
}
