/*
 * qdacco: offline Dacco Catalan <-> English dictionary
 * Copyright (C) 2005-2006 Carles Pina i estany <carles@pina.cat>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 or any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
*/

   #include "StructureParser.h"

   #include <stdio.h>
   #include <qstring.h>  

    int pdebug_;

    bool StructureParser::startDocument()
    {
	wd.setPdebug(pdebug_);
   	//WordDataQueue queuelist(10);
   	//wordqueue.setAutoDelete(TRUE);   (Ull! Tret per Qt4!)
	after_word = 0;
	return TRUE;
    }

    bool StructureParser::startElement( const QString&, const QString&,
                                        const QString& qName,
                                        const QXmlAttributes& attributes)
    {
	//To avoid else blocks, we initialize everything to FALSE
	//no needed to initilize, only to make easier to read

	catexamp=FALSE; engexamp=FALSE;
	entrada=FALSE; translation=FALSE;
	example=FALSE; 
	engnote=FALSE; catnote=FALSE;
	picture=FALSE;
	plural=FALSE; femplural=FALSE;
	synonyms=FALSE;

	catexamp=(qName=="catexamp");

	engexamp=(qName=="engexamp");

	example=(qName=="example");

	engnote=(qName=="engnote");

	catnote=(qName=="catnote");

	plural=(qName=="plural");

	femplural=(qName=="femplural");

	synonyms=(qName=="synonyms");
	
	qgender_=attributes.value("gender");	
	
	qpicture_=attributes.value("picture");

	qflickr_=attributes.value("flickr");

	entrada = (qName=="Entry");

	if (qName == "translation") {
		translation = TRUE;
	}

	if (qName == "adjectives") {qtipus_="adj";}
	if (qName == "adverbs") {qtipus_="adv";}
	if (qName == "exclamations") {qtipus_="excl";}
	if (qName == "nouns") {qtipus_="n";}
	if (qName == "prepositions") {qtipus_="prep";}
	if (qName == "pronouns") {qtipus_="pron";}
	if (qName == "verbs") {qtipus_="v";}


        return TRUE;
    }

    bool StructureParser::endElement( const QString&, const QString&, const QString& qName)
    {
     	
	if (trobat && qName=="translation") {
		wd.incNum();
		if (pdebug_) printf("Increment incNum\n");
	}	
	if (trobat && qName=="Entry") {	//ja sortim de la paraula
		trobat=FALSE;
	}
	return TRUE;
    }

bool StructureParser::characters ( const QString & ch ) {
	if (entrada) {
		if (after_word <= 10) {
			wordqueue.enqueue(QString(ch));
		}

		if (wordqueue.count()>20) {
			wordqueue.dequeue();
		}

		if (ch.localeAwareCompare(paraula)>0) {
			after_word++;
		}
	}

	if (entrada && ch==paraula) {
		trobat=TRUE;
	}
	
	if (entrada && ch!=paraula) {
		trobat=FALSE;
	}

	if (trobat && catexamp) {
		wd.putCatexamp(ch);
	}

	if (trobat && engexamp) {
		wd.putEngexamp(ch);
	}

	if (trobat && example) {
		wd.putExample(ch);
	}

	
	if (trobat && translation) {
		wd.putDefinition(ch);
   	
		wd.putGender(qgender_);
		wd.putTipus(qtipus_);
		if (!qpicture_.isEmpty()) {
			wd.putPicture(qpicture_);
		}
		if (!qflickr_.isEmpty()) {
			wd.putFlickr(qflickr_);
		}
	}

	if (trobat && engnote) {
		wd.putEngnote(ch);
	}

	if (trobat && catnote) {
		wd.putCatnote(ch);
	}

	if (trobat && plural) {
		wd.putPlural(ch);
	}

	if (trobat && femplural) {
		wd.putFemplural(ch);
	}

	if (trobat && synonyms) {
		wd.putSynonyms(ch);
	}

	return TRUE;

    }

   void StructureParser::setParaula(const QString &s) {
		paraula=s;
   }

   WordData StructureParser::getWordData() {
 		return wd;
   }

   void StructureParser::setPdebug(int i) {
		pdebug_=i;
   }

   int StructureParser::ensenyarLlistat() {
		while (!wordqueue.isEmpty()) {
			if (pdebug_) ("Llista: %s\n",qPrintable(wordqueue.head()));
			wordqueue.dequeue();
		}
		return 0;
   }

   QQueue<QString> StructureParser::getWordQueue() {
	return wordqueue;
   }

   bool StructureParser::esBuida() {
	   return wordqueue.isEmpty();
   }

   QString StructureParser::seguent() {
	   QString ret = wordqueue.head();
	   wordqueue.dequeue();
	   return ret;
   }
