#include <stdio.h>
#include <stdlib.h>
#include <qstring.h>
#include <qlabel.h>
#include <qslider.h> 
#include <qhbox.h>
#include <qvbox.h>
#include <qpushbutton.h>
#include <qprocess.h>
#include <alsa/asoundlib.h>
#include "gui.h"

Gui::Gui(int controller_count, int p_channel, int p_offset, QWidget *parent, const char *name) : QHBox(parent, name) {

  int l1;
  QString qs;
  char *portname;

  channel = p_channel;
  offset = p_offset;
  if (snd_seq_open(&seq_handle, "default", SND_SEQ_OPEN_DUPLEX, 0) < 0) {
    fprintf(stderr, "Error opening ALSA sequencer.\n");
  }
  snd_seq_set_client_name(seq_handle, "qMidiControl");
  portname = strdup("qMidiControl");
  if ((port_out = snd_seq_create_simple_port(seq_handle, portname,
      SND_SEQ_PORT_CAP_READ|SND_SEQ_PORT_CAP_SUBS_READ,
      SND_SEQ_PORT_TYPE_APPLICATION)) < 0) {
    fprintf(stderr, "Error creating sequencer port.\n");
  }
  setSpacing(10);
  setMargin(10);
  aboutWidget = new QMessageBox(this); 
  for (l1 = 0; l1 < controller_count; l1++) {
    QVBox *sliderBox = new QVBox(this);
    sliderBox->setSpacing(5);
    QSlider *slider = new QSlider(0, 127, 10, 127, Qt::Vertical, sliderBox);
    slider->setTickInterval(13);
    slider->setTickmarks(QSlider::Left);
    sliderList.append(slider);
    QLabel *numLabel = new QLabel(sliderBox);
    qs.sprintf("%2d", l1 + offset);
    numLabel->setText(qs);
    QObject::connect(slider, SIGNAL(valueChanged(int)), this, SLOT(updateValue(int)));
  }  
  free(portname);
}

Gui::~Gui() {
  
}

void Gui::displayAbout() {
 
    aboutWidget->about(this, "About QMidiControl", aboutText);
    aboutWidget->raise();
}

void Gui::updateValue(int val) {

  snd_seq_event_t ev;
  int l1;
  QSlider *senderSlider;
  
  senderSlider = (QSlider *)sender();
  for (l1 = 0; l1 < sliderList.count(); l1++) {
    if (sliderList.at(l1) == senderSlider) {
      break;
    }
  }
  snd_seq_ev_clear(&ev);
  snd_seq_ev_set_subs(&ev);
  snd_seq_ev_set_direct(&ev);
  snd_seq_ev_set_source(&ev, port_out);
  ev.type = SND_SEQ_EVENT_CONTROLLER;
  ev.data.control.channel = channel;
  ev.data.control.param = l1 + offset;
  ev.data.control.value = 127 - val;
  snd_seq_event_output_direct(seq_handle, &ev);
}
