#ifndef GUI_H
#define GUI_H

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <qstring.h>
#include <qlabel.h>
#include <qslider.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qmessagebox.h>
#include <qlist.h>
#include <alsa/asoundlib.h>

const QString aboutText = "QMidiControl 0.0.1\nby Matthias Nagorni\n(c)2002 SuSE AG Nuremberg\n\n"
                          "QMidiControl is licensed under the GPL.\n";
                                                                                     
class Gui : public QHBox
{
  Q_OBJECT

  private:
    QMessageBox *aboutWidget;
    QList<QSlider> sliderList;
    snd_seq_t *seq_handle;
    int port_out, channel, offset;

  public:
    Gui(int controller_count, int p_channel, int p_offset, QWidget* parent=0, const char *name=0);
    ~Gui();
 
  public slots: 
    void displayAbout();
    void updateValue(int val);
};
  
#endif
