/***************************************************************************
                          gammadialog.cpp  -  description
                             -------------------
    begin                : Wed Jan 23 2002
    copyright            : (C) 2002 by Michael Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "gammadialog.h"
#include "quiteinsane/qdoublespinbox.h"
#include "quiteinsane/qxmlconfig.h"

#include <math.h>

#include <qapplication.h>
#include <qhbox.h>
#include <qimage.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qnamespace.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <qspinbox.h>
#include <qtabwidget.h>
#include <qvbox.h>


GammaDialog::GammaDialog(int preview_size,QImage* image,QWidget* parent)
            :ImageFilterDialog(preview_size,image,parent)
{
  mMasterArray.resize(256);
  mRedArray.resize(256);
  mGreenArray.resize(256);
  mBlueArray.resize(256);
  for(int i=0;i<256;i++)
  {
    mMasterArray[i] = i;
    mRedArray[i] = i;
    mGreenArray[i] = i;
    mBlueArray[i] = i;
  }
  initControls();
}
GammaDialog::~GammaDialog()
{
}
/** No descriptions */
void GammaDialog::initControls()
{
  int g_master = xmlConfig->intValue("FILTER_GAMMA_MASTER",100);
  int g_red = xmlConfig->intValue("FILTER_GAMMA_RED",100);
  int g_green = xmlConfig->intValue("FILTER_GAMMA_GREEN",100);
  int g_blue = xmlConfig->intValue("FILTER_GAMMA_BLUE",100);
  bool c_up = xmlConfig->boolValue("FILTER_GAMMA_CONTINOUS_UPDATE",false);

  QVBox* vb = controlsVBox();
  if(!vb)
    return;
  setTitle(tr("Gamma"));
  setCaption(tr("Gamma"));
  //master
  QHBox* mhb = new QHBox(vb);
  mhb->setSpacing(5);
  new QLabel(tr("Value"),mhb);
  mpMasterSpin = new QDoubleSpinBox(mhb);
  mpMasterSpin->setRange(20,400);
  mpMasterSpin->setValue(g_master);
  //red
  QHBox* rhb = new QHBox(vb);
  rhb->setSpacing(5);
  new QLabel(tr("Red"),rhb);
  mpRedSpin = new QDoubleSpinBox(rhb);
  mpRedSpin->setRange(20,400);
  mpRedSpin->setValue(g_red);
  //green
  QHBox* ghb = new QHBox(vb);
  ghb->setSpacing(5);
  new QLabel(tr("Green"),ghb);
  mpGreenSpin = new QDoubleSpinBox(ghb);
  mpGreenSpin->setRange(20,400);
  mpGreenSpin->setValue(g_green);
  //blue
  QHBox* bhb = new QHBox(vb);
  bhb->setSpacing(5);
  new QLabel(tr("Blue"),bhb);
  mpBlueSpin = new QDoubleSpinBox(bhb);
  mpBlueSpin->setRange(20,400);
  mpBlueSpin->setValue(g_blue);
  //resetButton
  mpResetButton = new QPushButton(tr("Reset"),vb);
  //dummy
  QWidget* dummy = new QWidget(vb);
  vb->setStretchFactor(dummy,1);

  connect(mpResetButton,SIGNAL(clicked()),
          this,SLOT(slotReset()));
  connect(mpMasterSpin,SIGNAL(valueChanged(int)),
          this,SLOT(slotMasterChanged(int)));
  connect(mpRedSpin,SIGNAL(valueChanged(int)),
          this,SLOT(slotRedChanged(int)));
  connect(mpGreenSpin,SIGNAL(valueChanged(int)),
          this,SLOT(slotGreenChanged(int)));
  connect(mpBlueSpin,SIGNAL(valueChanged(int)),
          this,SLOT(slotBlueChanged(int)));
  //set values
  slotMasterChanged(g_master);
  slotRedChanged(g_red);
  slotGreenChanged(g_green);
  slotBlueChanged(g_blue);
  setContinousUpdate(c_up);
  setFixedSize(minimumSizeHint());
}
/** No descriptions */
bool GammaDialog::apply(QImage* image,bool emit_progress)
{
  int x,y;
  QRgb rgb_val;
  int progress,progresscnt;
  progress = image->width() * image->height();
  progresscnt = 0;
  int old_p = 0;

  if(image->isNull() || image->depth()<8) return false;
  if(image->numColors() > 0)
  {
    //has palette
    int num;
    for(num=0;num<image->numColors();num++)
    {
      rgb_val = image->color(num);
      image->setColor(num,qRgba(mMasterArray[mRedArray[qRed(rgb_val)]],
                                mMasterArray[mGreenArray[qGreen(rgb_val)]],
                                mMasterArray[mBlueArray[qBlue(rgb_val)]],
                                qAlpha(rgb_val)));
    }
  }
  else
  {
    for (y=0; y < image->height(); y++)
    {
      for (x=0; x < image->width(); x++)
      {
        rgb_val = image->pixel(x,y);
        image->setPixel(x,y,qRgba(mMasterArray[mRedArray[qRed(rgb_val)]],
                                  mMasterArray[mGreenArray[qGreen(rgb_val)]],
                                  mMasterArray[mBlueArray[qBlue(rgb_val)]],
                                  qAlpha(rgb_val)));
        if(emit_progress)
        {
          if(stopped())
            return false;
          ++progresscnt;
          int p = int(100.0*double(progresscnt)/double(progress));
          if((p % 5 == 0) && (p > old_p))
          {
            old_p = p;
            emit signalFilterProgress(p);
            qApp->processEvents();
          }
        }
      }
    }
  }
  return true;
}
/**  */
void GammaDialog::slotMasterChanged(int value)
{
  double s;
  int gval;
  unsigned int i;

  double gamma = double(value)/100.0;

  s = 256.0/pow(256.0,1.0/gamma);
  for(i=0;i<256;i++)
  {
    gval = int(pow(double(i),1.0/gamma)*s);
    mMasterArray[i] = gval;
  }
  updatePreview();
}
/**  */
void GammaDialog::slotRedChanged(int value)
{
  double s;
  int gval;
  unsigned int i;

  double gamma = double(value)/100.0;

  s = 256.0/pow(256.0,1.0/gamma);
  for(i=0;i<256;i++)
  {
    gval = int(pow(double(i),1.0/gamma)*s);
    mRedArray[i] = gval;
  }
  updatePreview();
}
/**  */
void GammaDialog::slotGreenChanged(int value)
{
  double s;
  int gval;
  unsigned int i;

  double gamma = double(value)/100.0;

  s = 256.0/pow(256.0,1.0/gamma);
  for(i=0;i<256;i++)
  {
    gval = int(pow(double(i),1.0/gamma)*s);
    mGreenArray[i] = gval;
  }
  updatePreview();
}
/**  */
void GammaDialog::slotBlueChanged(int value)
{
  double s;
  int gval;
  unsigned int i;

  double gamma = double(value)/100.0;

  s = 256.0/pow(256.0,1.0/gamma);
  for(i=0;i<256;i++)
  {
    gval = int(pow(double(i),1.0/gamma)*s);
    mBlueArray[i] = gval;
  }
  updatePreview();
}
/** No descriptions */
void GammaDialog::saveConfig()
{
  xmlConfig->setIntValue("FILTER_GAMMA_MASTER",
                         mpMasterSpin->value());
  xmlConfig->setIntValue("FILTER_GAMMA_RED",
                         mpRedSpin->value());
  xmlConfig->setIntValue("FILTER_GAMMA_GREEN",
                         mpGreenSpin->value());
  xmlConfig->setIntValue("FILTER_GAMMA_BLUE",
                         mpBlueSpin->value());
  xmlConfig->setBoolValue("FILTER_GAMMA_CONTINOUS_UPDATE",
                          continousUpdate());
}
/** No descriptions */
void GammaDialog::slotReset()
{
  mpMasterSpin->setValue(100);
  mpRedSpin->setValue(100);
  mpGreenSpin->setValue(100);
  mpBlueSpin->setValue(100);
}
