/***************************************************************************
                          posterizedialog.cpp  -  description
                             -------------------
    begin                : Wed Jan 23 2002
    copyright            : (C) 2002 by Michael Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*****************************************************************************
 * The algorithm used in this class is taken from the Gimp 1.2.0             *
 * Original filename: lut_func.c                                             *
 * Original copyright message:                                               *
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis                       *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program; if not, write to the Free Software               *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.*
 *****************************************************************************/

#include "posterizedialog.h"
#include "quiteinsane/qxmlconfig.h"
#include "quiteinsane/sliderspin.h"

#include <math.h>

#include <qapplication.h>
#include <qhbox.h>
#include <qimage.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qnamespace.h>
#include <qpixmap.h>
#include <qvbox.h>

PosterizeDialog::PosterizeDialog(int preview_size,QImage* image,QWidget* parent)
                :ImageFilterDialog(preview_size,image,parent)
{
  mPosterizeArray.resize(256);
  for(int i=0;i<256;i++)
    mPosterizeArray[i] = i;
  initControls();
}
PosterizeDialog::~PosterizeDialog()
{
}
/** No descriptions */
void PosterizeDialog::initControls()
{
  int value = xmlConfig->intValue("FILTER_POSTERIZE_VALUE",3);
  bool c_up = xmlConfig->boolValue("FILTER_POSTERIZE_CONTINOUS_UPDATE",false);

  QVBox* vb = controlsVBox();
  if(!vb)
    return;
  setTitle(tr("Posterize"));
  setCaption(tr("Posterize"));
  //brightness
  mpPosterizeSlider = new SliderSpin(2,255,value,tr("Value"),vb);
  mpPosterizeSlider->setMinimumWidth(150);
  //dummy
  QWidget* dummy = new QWidget(vb);
  vb->setStretchFactor(dummy,1);

  connect(mpPosterizeSlider,SIGNAL(signalValueChanged(int)),
          this,SLOT(slotPosterizeChanged(int)));
  slotPosterizeChanged(value);
  setContinousUpdate(c_up);
  setFixedSize(minimumSizeHint());
}
/** No descriptions */
bool PosterizeDialog::apply(QImage* image,bool emit_progress)
{
  if(!image)
    return false;
  int x,y;
  QRgb rgb_val;
  int progress,progresscnt;
  progress = image->width() * image->height();
  progresscnt = 0;
  int old_p = 0;

  if(image->isNull() || image->depth()<8) return false;
  if(image->numColors() > 0)
  {
    //has palette
    int num;
    for(num=0;num<image->numColors();num++)
    {
      rgb_val = image->color(num);
      image->setColor(num,qRgba(mPosterizeArray[qRed(rgb_val)],
                                mPosterizeArray[qGreen(rgb_val)],
                                mPosterizeArray[qBlue(rgb_val)],
                                qAlpha(rgb_val)));
    }
  }
  else
  {
    for (y=0; y < image->height(); y++)
    {
      for (x=0; x < image->width(); x++)
      {
        rgb_val = image->pixel(x,y);
        image->setPixel(x,y,qRgba(mPosterizeArray[qRed(rgb_val)],
                                  mPosterizeArray[qGreen(rgb_val)],
                                  mPosterizeArray[qBlue(rgb_val)],
                                  qAlpha(rgb_val)));
        if(emit_progress)
        {
          if(stopped())
            return false;
          ++progresscnt;
          int p = int(100.0*double(progresscnt)/double(progress));
          if((p % 5 == 0) && (p > old_p))
          {
            old_p = p;
            emit signalFilterProgress(p);
            qApp->processEvents();
          }
        }
      }
    }
  }
  return true;
}
/**  */
void PosterizeDialog::slotPosterizeChanged(int value)
{
	int cnt;
  double interval,half_interval;

  interval = 255.0 / (double) (value - 1);
  half_interval = interval / 2.0;

	for (cnt=0;cnt < 256;cnt++)
  {
    mPosterizeArray[cnt] = (unsigned char)(int((double(cnt) + half_interval) / interval) * interval);
    if(mPosterizeArray[cnt] > 255) mPosterizeArray[cnt] = 255;
    if(mPosterizeArray[cnt] < 0) mPosterizeArray[cnt] = 0;
  }

  updatePreview();
}
/** No descriptions */
void PosterizeDialog::saveConfig()
{
  xmlConfig->setIntValue("FILTER_POSTERIZE_VALUE",
                         mpPosterizeSlider->value());
  xmlConfig->setBoolValue("FILTER_POSTERIZE_CONTINOUS_UPDATE",
                          continousUpdate());
}
