/***************************************************************************
                          qoptionscrollview.cpp  -  description
                             -------------------
    begin                : Thu Jul 20 2000
    copyright            : (C) 2000 by M. Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2 as     *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 ***************************************************************************/

#include "qoptionscrollview.h"
#include <qsizepolicy.h>
#include <qwidget.h>
#include <qlayout.h>

QOptionScrollView::QOptionScrollView(QWidget * parent, const char * name,WFlags f)
                  :QScrollView(parent,name,f)
{
  setHScrollBarMode(AlwaysOff);
  viewport()->setBackgroundMode(QWidget::PaletteBackground);
  mpMainWidget = new QWidget(viewport());
  mpMainLayout = new QVBoxLayout(mpMainWidget);
  addChild(mpMainWidget);
}
QOptionScrollView::~QOptionScrollView()
{
}

/**  */
void QOptionScrollView::viewportResizeEvent(QResizeEvent* qre)
{
  QScrollView::viewportResizeEvent(qre);
  if((mpMainWidget->sizeHint().isValid()==TRUE)&&(visibleWidth()>0))
  {
    mpMainWidget->setFixedWidth(visibleWidth());//,m_pMemberBox->height());
  }
}
/**  */
QWidget* QOptionScrollView::getMainWidget()
{
  return mpMainWidget;
}

void QOptionScrollView::addWidget(QWidget* qw,int stretch)
{
  mpMainLayout->addWidget(qw,stretch);
}
