/***************************************************************************
                          qscandialog.h  -  description
                             -------------------
    begin                : Thu Jun 22 2000
    copyright            : (C) 2000 by M. Herder
    email                : http://quiteinsane.sf.net/contact.html
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2 as     *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 ***************************************************************************/

#ifndef QScanDialog_H
#define QScanDialog_H

#include <qarray.h>
#ifdef USE_QT3
#include <qptrlist.h>
#else
#include <qlist.h>
#endif
#include <qlistview.h>
#include <qmap.h>
#include <qnamespace.h>
#include <qwidget.h>
#include "qscanner.h"
#include "qextensionwidget.h"
#include "quiteinsanenamespace.h"
/**
  *@author M. Herder
  */
//forward declarations
class ImageHistoryBrowser;
class PreviewWidget;
class QCheckBox;
class QComboBox;
class QDialog;
class QDragLabel;
class QFileListWidget;
class QGridLayout;
class QGroupBox;
class QHBox;
class QVBox;
class QHTMLView;
class QLabel;
class QLineEdit;
class QMultiScan;
class QOptionScrollView;
class QProcess;
class QRect;
class QSaneOption;
class QScanner;
class QScrollBarOption;
class QTabWidget;
class QToolButton;
class QVBox;
class QVBoxLayout;
class QWidget;
class SaneWidgetHolder;
class ScanArea;

class QScanDialog : public QDialog
{
   Q_OBJECT
public:
	QScanDialog(QScanner* s,QWidget *parent=0, const char *name=0);
  ~QScanDialog();
  /**  */
  QIN::Status status();
  /** No descriptions */
#ifdef USE_QT3
  QPtrList<QImage> imageList();
#else
  QList<QImage> imageList();
#endif
  /** No descriptions */
  void enableMultiSelection(bool state);
protected:
  /**  */
  virtual void resizeEvent(QResizeEvent* e);
  /**  */
  void showEvent(QShowEvent* se);
private:
  QMap<QString,QString> mCommandMap;
  QPushButton* mpDeviceButton;
  QPushButton* mpQuitButton;
  QPushButton* mpAboutButton;
  QPushButton* mpScanButton;
  QPushButton* mpOptionsButton;
  QPushButton* mpPreviewButton;
  PreviewWidget *mpPreviewWidget;
  /**  */
#ifdef USE_QT3
  QPtrList<QImage> mImageList;
#else
  QList<QImage> mImageList;
#endif
  /**  */
  QArray <SaneWidgetHolder *> mOptionWidgets;
  /**  */
  QScanner* mpScanner;
  /**  */
  QHBox* mpInfoHBox;
  /**  */
  QHBox* mpButtonHBox1;
  /**  */
  QHBox* mpButtonHBox2;
  /**  */
  QScrollBarOption* mpTlxOption;
  /**  */
  QScrollBarOption* mpTlyOption;
  /**  */
  QScrollBarOption* mpBrxOption;
  /**  */
  QScrollBarOption* mpBryOption;
  /**  */
  QToolButton* mpWhatsThisButton;
  /**  */
  QMultiScan* mpMultiScanWidget;
  /**  */
  QPushButton* mpMultiScanButton;
  /**  */
  QTabWidget* mpOptionTabWidget;
  /**  */
  QOptionScrollView* mpOptionScrollView;
  /** */
  QArray <QWidget*> mOptionSubArray;
//  /**  */
  QGridLayout* mpMainLayout;
  /**  */
  QArray <QGroupBox*> mGroupBoxArray;
  /**  */
  QLabel* mpLabelImageInfo;
  /**  */
  QPushButton* mpViewerButton;
  /**  */
  QPushButton* mpHelpButton;
  QString mDeviceName;
  /**  */
  QHTMLView* mpHelpViewer;
  /**  */
  QIN::Status mStatus;
  /**  */
  QIN::Layout mLayout;
  /**  */
  QIN::MetricSystem mMetricSystem;
  /**  */
  int mShowCnt;
  /**  */
  QWidgetStack* mpOptionWidgetStack;
  /**  */
  QWidget* mpOptionListWidget;
  /**  */
  QListView* mpOptionListView;
  /**  */
  QVBox* mpSeparator;
private: //methods
  bool mMultiSelectionMode;
  /**  */
	QIN::Status initDialog();
  /**  */
  void changeLayout(QIN::Layout l);
  /** Do a scan with the current settings. Return false
if an error occurs. Otherwise true is returned and the
image is saved to .scantemp.pnm.*/
  bool scanImage(bool pre = false,bool adf_warning=true,QWidget* parent=0);
  /**  */
  bool scanPreviewImage(double tlx=0.0,double tly=0.0,
                        double brx=1.0,double bry=1.0,int res=50);
  /**  */
  void createOptionWidget();
  /**  */
  void setAllOptions();
  /**  */
  void createWhatsThisHelp();
  /**  */
  QGroupBox* createOptionGroupBox(QString title,int firstoption,int lastoption);
  /**  */
  void createPreviewWidget();
  /** No descriptions */
  void resizeScanArea();
  /** No descriptions */
  void setPreviewRange();
  /** No descriptions */
  void enableGUI(bool enable,bool preview_scan = false);
  /** No descriptions */
  QSaneOption* createSaneOptionWidget(QWidget* parent,int opt_num);
  /** No descriptions */
  void checkOptionValidity(int opt_num);
public slots:
  /**  */
  void slotUserSize(int);
  /**  */
  void slotOptionChanged(int num);
  /**  */
  void slotPreviewSize(QRect rect);
  /**  */
  void slotResizeScanRect();
  /**  */
  void slotSetPredefinedSize(ScanArea* sca);
  /** No descriptions */
  void reject();
  /** No descriptions */
  void accept();
private slots:
  /**  */
  void slotScan();
  /**  */
  void slotPreview(double tlx,double tly,double brx,double bry,int res);
  /**  */
  void slotReloadOptions();
  /**  */
  void slotShowOptionsWidget();
  /**  */
  void slotShowPreviewWidget();
  /**  */
  void slotAbout();
  /**  */
  void slotImageInfo();
//  void slotSaveModeChanged(QIN::SaveMode smode);
  /** This slot is called, when setting an option results
in an return value SANE_INFO_INEXACT.
This normally happens, when the value set in
the backend  is different from the requested value. */
  void slotInfoInexact(int num);
  /**  */
  void slotAutoMode(int num,bool b);
  /**  */
  void slotDeviceSettings();
  /**  */
  void slotRaiseOptionWidget(QListViewItem* lvi);
  /**  */
  void slotImageSettings();
  /**  */
  void slotChangeFilename();
  /** No descriptions */
  void slotMultiSelectionMode(bool state);
  /** No descriptions */
  void slotEnableScanAreaOptions(bool on);
signals:
  /** */
  void signalQuit();
  /**  */
  void signalNewImage();
  /**  */
  void signalInternalScanReady();
  /**  */
  void signalMetricSystem(QIN::MetricSystem ms);
};

#endif

