/* 
Remote Access Session v0.7 main.c - Code By Angel Ramos <seamus@salix.org>
*/

#include "raccess.h"

main (int argc, char **argv)	{
	int c;
	int osdetect = 0;
	int onlyscan = 0;
	char *host;
	
	netscan = 0;	
	while ((c = getopt (argc, argv, "osn")) != -1)	{
		switch (c)	{
			case 'o':
				osdetect = 1;
				break;
			case 's':
				onlyscan = 1;
				break;
			case 'n':
				netscan = 1;
				break;
			default:	
				usage (argv[0]);
		}
	}
	c = (argc - 1);
	if (optind >= argc)	{
		usage (argv[0]);
	}
	info ();
	if (netscan == 1)	{
		while (netscan == 1)	{
			host = extract_host (argv[c]);
			fileheader (host);
			scanhost (host, osdetect, onlyscan);
			if (onlyscan == 0)	{
				filequest (argv [c]);
			}
		}
	}	
	else	{
		fileheader (argv[c]);
		scanhost (argv[c], osdetect, onlyscan);
		filequest (argv[c]);
	}
}

void info ()	{
	system ("clear");
	printf ("\nRemote Access Session v0.7 - Code by Angel Ramos <seamus@salix.org>\n");
	printf ("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n");
}
	
void usage (char *arg)	{
	printf ("\nRemote Access Session v0.7 By Angel Ramos <seamus@salix.org>\n");
	printf ("Please use: %s [options] <host_to_attack>\n", arg);
	printf ("Options:\n");
	printf ("	-o: Try to detect the remote OS (root account only)\n");
	printf ("	-s: Single scan of services, not run exploits\n");
	printf ("	-n: Network scan mode\n"); 
	printf ("	    The format of the host must be a.b.c.d/netmask on this mode\n");
	printf ("	    For example: 127.0.0.0/24\n\n");
	exit (1);
}	 
 
