/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: dlink.h,v 1.13.2.1 2004/12/07 03:04:35 pneumatus Exp $
 */

#ifndef	__dlink_include__
#define	__dlink_include__

typedef struct _dlink_node dlink_node;
typedef struct _dlink_list dlink_list;

struct _dlink_node {
	dlink_node *next;
	dlink_node *prev;
	void *data;
};

struct _dlink_list {
	dlink_node *head;
	dlink_node *tail;
	unsigned long length;
};

#define DLINK_LIST_INIT { NULL, NULL, 0 }

#define DLINK_FOREACH(lst, ln) \
	for (ln = (lst); ln != NULL; ln = ln->next)

#define DLINK_FOREACH_PREV(lst, ln) \
	for (ln = (lst); ln != NULL; ln = ln->prev)

#define DLINK_FOREACH_DATA(lst, ln, d, dt) \
	for (ln = (lst), d = ln ? (dt *)ln->data : NULL; \
	  ln != NULL; \
	  ln = ln->next, d = ln ? (dt *)ln->data : NULL)

#define DLINK_FOREACH_PREV_DATA(lst, ln, d, dt) \
	for (ln = (lst), d = ln ? (dt *)ln->data : NULL; \
	  ln != NULL; \
	  ln = ln->prev, d = ln ? (dt *)ln->data : NULL)

#define DLINK_FOREACH_SAFE(lst, ln, nxt) \
	for (ln = (lst), nxt = ln ? ln->next : NULL; \
	  ln != NULL; \
	  ln = nxt, nxt = ln ? ln->next : NULL)

#define DLINK_FOREACH_PREV_SAFE(lst, ln, prv) \
	for (ln = (lst), prv = ln ? ln->prev : NULL; \
	  ln != NULL; \
	  ln = prv, prv = ln ? ln->next : NULL)

#define DLINK_FOREACH_SAFE_DATA(lst, ln, nxt, d, dt) \
	for (ln = (lst), nxt = ln ? ln->next : NULL, d = ln ? (dt *)ln->data : NULL; \
	  ln != NULL; \
	  ln = nxt, nxt = ln ? ln->next : NULL, d = ln ? (dt *)ln->data : NULL)

#define DLINK_FOREACH_PREV_SAFE_DATA(lst, ln, prv, d, dt) \
	for (ln = (lst), prv = ln ? ln->prev : NULL, d = ln ? (dt *)ln->data : NULL; \
	  ln != NULL; \
	  ln = prv, prv = ln ? ln->prev : NULL, d = ln ? (dt *)ln->data : NULL)

#define dlink_length(lst)	((lst)->length)

extern dlink_list lunknown_list;
extern dlink_list lclient_list;
extern dlink_list lserver_list;
extern dlink_list oper_list;
extern dlink_list listingcli_list;
extern dlink_list listener_list;
extern dlink_list connauth_list;

extern void dlink_init();

extern dlink_node *dlink_find(dlink_list *, void *);
extern dlink_node *dlink_add_node(dlink_list *, dlink_node *, void *);
extern dlink_node *dlink_add(dlink_list *, void *);
extern dlink_node *dlink_add_tail(dlink_list *, void *);
extern void dlink_del(dlink_list *, void *, dlink_node *);
extern dlink_node *dlink_del_nofree(dlink_list *, void *, dlink_node *);

#endif /* __dlink_include__ */
