/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: fd.h,v 1.24.2.1 2004/12/07 03:04:36 pneumatus Exp $
 */

#ifndef __fd_include__
#define __fd_include__

enum {
	ENGINE_OK,
	ENGINE_ERR_DNS,
	ENGINE_ERR_BIND,
	ENGINE_ERR_CONNECT,
	ENGINE_ERR_TIMEOUT,
	ENGINE_ERR_HANDSHAKE,
	ENGINE_ERR_FLUSH,
	ENGINE_ERROR
};

typedef void FDCB(int, void *, int);

typedef struct _fd_stat fd_stat;
typedef struct _fd_callback fd_callback;
typedef struct _fd_entry fd_entry;

struct _fd_stat {
	int highest;
	int count;
};

struct _fd_callback {
	FDCB *handler;
	void *data;
};

struct _fd_entry {
	int fd;
	unsigned open : 1;

#if defined(USE_POLL) || defined(USE_RTSIGIO)
	int index;
#endif
#if defined(USE_EPOLL)
	unsigned int epoll_state;
#endif

	fd_callback read;
	fd_callback write;
	fd_callback connect;
	fd_callback timeout;
	fd_callback flush;

	time_t timeout_time;
	time_t flush_time;
	struct sockaddr_in ip;
	DNSQuery *dns_query;
};

/* kludges to make life a little easier */
#define SetCallback(cb,h,d)	(cb).handler = (h); (cb).data = (d)
#define GetCallback(cb,h,d)	(h) = ((cb).handler != NULL) ? (cb).handler : NULL; (d) = ((cb).handler != NULL) ? (cb).data : NULL
#define ClrCallback(cb)		(cb).handler = NULL; (cb).data = NULL
#define TheCallback(cb)		(cb).handler

#define FD_UNUSED	-1 /* This slot is available */

#define FDEV_READ	0x1 /* We want to perform a read */
#define FDEV_WRITE	0x2 /* We want to perform a write */

extern fd_entry fd_table[MAXCONNECTIONS];
extern fd_stat fds;

extern void fd_init();
extern void fd_open(int);
extern void fd_close(int);

extern int engine_open(int, int);
extern int engine_accept(int fd, struct sockaddr_in *);

extern void engine_set_call(int, unsigned short, FDCB *, void *, time_t);
extern void engine_set_timeout(int fd, time_t, FDCB *, void *);
extern void engine_set_flush(int fd, time_t, FDCB *, void *);

extern void engine_read_packet(int, void *, int);
extern void engine_send_queued(aClient *);
extern void engine_connect_tcp(int, const char *, int, struct sockaddr *, int, FDCB *, void *, int);

extern void engine_write_error(aClient *, char *, int);
extern void engine_connect_error(aClient *, int, int);

extern void engine_preinit();
extern void engine_init();
extern void engine_do_netio(time_t);
extern void engine_check_timeouts();
extern int engine_ignore_errno(int);
extern const char *engine_strerror(int);

#ifdef USE_RTSIGIO
extern void setup_sigio_fd(int);
#endif

#endif /* __fd_include__ */
