/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: hash.h,v 1.4.4.1 2004/12/07 03:04:37 pneumatus Exp $
 */

#ifndef	__hash_include__
#define __hash_include__

typedef struct hashentry {
	int hits;
	int links;
	void *list;
} aHashEntry;

#define BITS_PER_COL 3
#define BITS_PER_COL_MASK 0x7
#define MAX_SUB (1 << BITS_PER_COL)

#define U_MAX_INITIAL 8192
#define U_MAX_INITIAL_MASK (U_MAX_INITIAL - 1)
#define U_MAX (U_MAX_INITIAL * MAX_SUB)

#define CH_MAX_INITIAL 2048
#define CH_MAX_INITIAL_MASK (CH_MAX_INITIAL - 1)
#define CH_MAX (CH_MAX_INITIAL * MAX_SUB)

#define WW_MAX_INITIAL 16
#define WW_MAX_INITIAL_MASK (WW_MAX_INITIAL - 1)
#define WW_MAX (WW_MAX_INITIAL * MAX_SUB)

#define WATCHHASHSIZE 10007

extern unsigned int hash_whowas_name(char *);

#endif /* __hash_include__ */
