/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: modules.h,v 1.32.2.1 2004/12/07 03:04:37 pneumatus Exp $
 */

#ifndef __modules_include__
#define __modules_include__

#include "config.h"
#include "setup.h"

#define MODULE_VERSION	6	/* Current version */

#ifndef STATIC_MODULES

enum {
	MOD_ERR_NOT_LOADED = 0,
	MOD_ERR_ALREADY_LOADED,
	MOD_ERR_HEADER_MISSING,
	MOD_ERR_HEADER_INVALID,
	MOD_ERR_BAD_VERSION,
	MOD_ERR_LOAD_MISSING,
	MOD_ERR_UNLOAD_MISSING,
	MOD_ERR_PERM,
	MOD_ERR_LOAD_FAILED,
	MOD_ERR_UNLOAD_FAILED
};

extern void load_modules_from_path(char *);
extern int do_module(char *, char *, aClient *);
extern void *get_symbol_from_source(char *, char *);
extern void load_all_modules();
extern void unload_all_modules();
#endif /* STATIC_MODULES */

extern void init_modules();
extern void do_module_list(aClient *);

extern int module_load(), module_unload();

#define MOD_UNKNOWN -3
#define MOD_FAILURE -2
#define MOD_SUCCESS -1

#define MOD_FLAG_NONE		0x0000	/* No flags */
#define MOD_FLAG_PERM		0x0001	/* Cannot be unloaded (can be reloaded though) */

#define MOD_SET_FLAG(x, y)	((x)->flags |= (y))
#define MOD_REM_FLAG(x, y)	((x)->flags &= ~(y))

#if !defined(STATIC_MODULES) && !defined(DYNAMIC_WRAPPER)
#define find_symbol(x, y)	get_symbol_from_source(#x, y)
#define MOD_HEADER(x)		module_header
#define MOD_LOAD(x)		module_load
#define MOD_UNLOAD(x)		module_unload
#else
#define find_symbol(x, y)	x
#define do_module(x, y, z)	MOD_SUCCESS
#define MOD_HEADER(x)		x##_header
#define MOD_LOAD(x)		x##_load
#define MOD_UNLOAD(x)		x##_unload
#endif /* STATIC_MODULES */

#define MOD(x)			extern Module x##_header; \
				extern int x##_load(), x##_unload()

/*
 * FIXME - These should really be in their respective
 * modules, but mehhh... what'cha gunna do?
 */
MOD(commands);
MOD(aliases);
MOD(antidrone);
MOD(m_accept);
MOD(m_admin);
MOD(m_akill);
MOD(m_away);
MOD(m_burst);
MOD(m_capab);
MOD(m_chatops);
MOD(m_close);
MOD(m_connect);
MOD(m_dalinfo);
MOD(m_dccallow);
MOD(m_die);
MOD(m_dkey);
MOD(m_error);
MOD(m_globops);
MOD(m_gnotice);
MOD(m_htm);
MOD(m_info);
MOD(m_invite);
MOD(m_ison);
MOD(m_join);
MOD(m_kick);
MOD(m_kill);
MOD(m_kline);
MOD(m_knock);
MOD(m_links);
MOD(m_list);
MOD(m_locops);
MOD(m_lusers);
MOD(m_map);
MOD(m_message);
MOD(m_mkpasswd);
MOD(m_mode);
MOD(m_motd);
MOD(m_myid);
MOD(m_names);
MOD(m_nick);
MOD(m_oper);
MOD(m_opermotd);
MOD(m_part);
MOD(m_pass);
MOD(m_ping);
MOD(m_pong);
MOD(m_quit);
MOD(m_rakill);
MOD(m_rehash);
MOD(m_restart);
MOD(m_rules);
MOD(m_sajoin);
MOD(m_sakick);
MOD(m_samode);
MOD(m_satopic);
MOD(m_server);
MOD(m_sgline);
MOD(m_silence);
MOD(m_sjoin);
MOD(m_snick);
MOD(m_sqline);
MOD(m_squit);
MOD(m_stats);
MOD(m_svinfo);
MOD(m_svshold);
MOD(m_svskill);
MOD(m_svsmode);
MOD(m_svsnick);
MOD(m_svsnoop);
MOD(m_szline);
MOD(m_time);
MOD(m_topic);
MOD(m_trace);
MOD(m_unkline);
MOD(m_unsgline);
MOD(m_unsqline);
MOD(m_unszline);
MOD(m_user);
MOD(m_userhost);
MOD(m_version);
MOD(m_vhost);
MOD(m_wallops);
MOD(m_watch);
MOD(m_who);
MOD(m_whois);
MOD(m_whowas);
MOD(m_zline);

#include "hook.h"

extern Command *register_command(Module *, msg_ptr *, int (*)());
extern Event *register_event(Module *, char *, void (*)(), void *, time_t, int);
extern Hook *register_hook(Module *, char *);
extern HookEvent *register_hook_event(Module *, Hook *, int (*)());
extern xMode *register_user_mode(Module *, char, long *, unsigned int);

extern void clear_objects(Module *);

#endif /* __modules_include__ */
