/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: ssl.h,v 1.14.2.1 2004/12/07 03:04:53 pneumatus Exp $
 */

#ifndef __ssl_include__
#define __ssl_include__

#include "setup.h"

#ifdef USE_OPENSSL

#include <unistd.h>

#include <openssl/rand.h>
#include <openssl/err.h>
#include <openssl/bn.h>
#include <openssl/crypto.h>
#include <openssl/rsa.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/ssl.h>
#include <openssl/evp.h>
#include <openssl/md5.h>
#include <openssl/dh.h>
#include <openssl/ripemd.h>

#define RC4_BUF_SIZE 16384

extern char rc4buf[RC4_BUF_SIZE];

enum {
	SAFE_SSL_READ = 1,
	SAFE_SSL_WRITE,
	SAFE_SSL_ACCEPT
};

enum {
	ERR_SSL_SUCCESS = 0,
	ERR_SSL_CTX_NEW,
	ERR_SSL_CTX_USE_CERT,
	ERR_SSL_CTX_USE_KEY,
	ERR_SSL_CTX_CHECK_KEY
};

#define KEY_BITS	512
#define RAND_BITS	KEY_BITS
#define RAND_BYTES	(RAND_BITS / 8)
#define RAND_BYTES_HEX	((RAND_BYTES * 2) + 1)

#define PRIME_BITS	1024
#define PRIME_BYTES	(PRIME_BITS / 8)
#define PRIME_BYTES_HEX	((PRIME_BYTES * 2) + 1)

typedef struct session_info SessionInfo;
typedef struct rc4_state RC4_state;
typedef unsigned char RC4_byte;
typedef unsigned int RC4_word;

struct session_info {
	DH *dh;
	char *session_shared;
	int session_shared_length;
};

struct rc4_state {
	RC4_byte mstate[256];
	RC4_byte x;
	RC4_byte y;
};

extern int init_dh();
extern void dh_end_session(void *);
extern void *dh_start_session();
extern char *dh_get_s_public(char *, int, void *);
extern int dh_get_s_shared(char *, int *, void *);
extern int dh_generate_shared(void *, char *);
extern int dh_hexstr_to_raw(char *, unsigned char *, int *);
extern void rc4_process_stream_to_buf(void *, const unsigned char *, unsigned char *, unsigned int);
extern void rc4_process_stream(void *, unsigned char *, unsigned int);
extern void *rc4_initstate(unsigned char *, int);
extern void rc4_destroystate(void *);

#include "struct.h"

extern char *init_ssl();
extern char *ssl_get_cipher_info(SSL *);
extern SSL *ssl_do_handshake(int, char *);
extern int safe_SSL_accept(SSL *, int, char *);
extern int safe_SSL_read(aClient *, void *, size_t);
extern int safe_SSL_write(aClient *, const void *, size_t);
extern int SSL_smart_shutdown(SSL *);

#endif

#endif /* __ssl_include__ */
