/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_burst.c,v 1.25.2.3 2005/05/02 00:53:18 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_burst) = {
	"m_burst",
	"BURST and NBURST protocols",
	6, "$Revision: 1.25.2.3 $"
};

int MOD_LOAD(m_burst)()
{
	if (register_command(&MOD_HEADER(m_burst), &CMD_BURST, m_burst) == NULL) {
		return MOD_FAILURE;
	}
	if (register_command(&MOD_HEADER(m_burst), &CMD_NBURST, m_nburst) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_burst)()
{
	return MOD_SUCCESS;
}

/*
 * m_burst
 *	parv[0] = sender prefix
 *	parv[1] = SendQ if an EOB
 */
int m_burst(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	if (!IsServer(sptr) || sptr != cptr || parc > 2 || !CapBURST(sptr)) {
		return 0;
	}
	if (parc == 2) {
		ClearRecvEOB(sptr);
		if (SentSOB(sptr) || SendingBurst(sptr)) {
			return 0;
		}

		send_gnotice("synch to %s in %d %s at %s sendq", *parv, timeofday - sptr->firsttime,
			timeofday - sptr->firsttime == 1 ? "sec" : "secs", parv[1]);
		sendto_serv_msg_butone(NULL, &me, &CMD_GNOTICE, ":synch to %s in %d %s at %s sendq",
			*parv, timeofday - sptr->firsttime,
			timeofday - sptr->firsttime == 1 ? "sec" : "secs", parv[1]);
	}
	else {
		SetRecvEOB(sptr);
	}
	return 0;
}

/*
 * m_nburst
 * 	parv[0] = sender prefix
 */
int m_nburst(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	if (!IsServer(sptr)) {
		return 0;
	}
	ASSERT(CapNBURST(cptr));
	
	SetGotNBurst(sptr);
	sendto_serv_capab_msg_butone(cptr, sptr, CAP_NBURST, NO_CAPS, &CMD_NBURST, "");
	return 0;
}
