/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_close.c,v 1.18.2.2 2005/01/15 23:53:33 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_close) = {
	"m_close",
	"/CLOSE command",
	6, "$Revision: 1.18.2.2 $"
};

int MOD_LOAD(m_close)()
{
	if (register_command(&MOD_HEADER(m_close), &CMD_CLOSE, m_close) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_close)()
{
	return MOD_SUCCESS;
}

/*
 * m_close
 *	parv[0] = sender prefix
 */
int m_close(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	dlink_node *node, *next = NULL;
	aClient *acptr;
	int closed = 0;

	if (!MyConnect(sptr) || !HasMode(sptr, UMODE_OPER)) {
		send_me_numericNA(sptr, ERR_NOPRIVILEGES);
		return 0;
	}

	DLINK_FOREACH_SAFE_DATA(lunknown_list.head, node, next, acptr, aClient) {
		send_me_numeric(sptr, RPL_CLOSING, get_client_name(acptr, TRUE), acptr->status);
		exit_client(acptr, acptr, &me, "Oper Closing");
		closed++;
	}

	send_me_numeric(sptr, RPL_CLOSEEND, closed);
	return 0;
}
