/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_invite.c,v 1.27.2.4 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_invite) = {
	"m_invite",
	"/INVITE command",
	6, "$Revision: 1.27.2.4 $"
};

int MOD_LOAD(m_invite)()
{
	if (register_command(&MOD_HEADER(m_invite), &CMD_INVITE, m_invite) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_invite)()
{
	return MOD_SUCCESS;
}

/*
 * m_invite
 *	parv[0] = sender prefix
 *	parv[1] = user to invite
 *	parv[2] = channel
 */
int m_invite(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	aClient *acptr;
	aChannel *chptr = NULL;

	if (parc < 3 || BadPtr(parv[2])) {
		send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "INVITE");
		return 0;
	}

	if ((acptr = IsServer(cptr) ? find_person_target(parv[1]) : find_person(parv[1], NULL)) == NULL) {
		target_left(sptr, parv[1], MSG_INVITE, parv[2]);
		return 0;
	}

	if (MyClient(sptr)) {
		if (!check_channel_name(sptr, parv[2])) {
			send_me_numeric(sptr, ERR_BADCHANNAME, parv[2]);
			return 0;
		}
		if ((chptr = find_channel(parv[2], NULL)) == NULL) {
			send_me_numeric(sptr, ERR_NOSUCHCHANNEL, parv[2]);
			return 0;
		}

		if (IsMember(acptr, chptr)) {
			send_me_numeric(sptr, ERR_USERONCHANNEL, parv[1], parv[2]);
			return 0;
		}
		
		if ((*chptr->chname == '&') && !MyClient(acptr)) {
			send_me_numeric(sptr, ERR_USERNOTONSERV, acptr->name);
			return 0;
		}

		if (!IsULine(sptr)) {
			if (!is_chanop(sptr, chptr) && !is_halfop(sptr, chptr)) {
				send_me_numeric(sptr, ERR_CHANOPRIVSNEEDED, chptr->chname);
				return 0;
			}
			if (!IsMember(sptr, chptr) && !IsULine(sptr)) {
				send_me_numeric(sptr, ERR_NOTONCHANNEL, parv[2]);
				return 0;
			}
		}

		send_me_numeric(sptr, RPL_INVITING, acptr->name, chptr->chname);

		if (!BadPtr(acptr->user->away)) {
			send_me_numeric(sptr, RPL_AWAY, acptr->name, acptr->user->away);
		}
	}

	if (MyClient(acptr)) {
		if (!MyClient(sptr) || (chptr == NULL)) {
			if ((chptr = find_channel(parv[2], NULL)) == NULL) {
				return 0;
			}
			if (IsMember(acptr, chptr)) {
				return 0;
			}
		}

		add_invite(acptr, chptr);

		sendto_one_client_prefixed(acptr, sptr, &CMD_INVITE, ":%s", chptr->chname);
		sendto_channel_msg_butone(NULL, &me, chptr, CMODE_CHANOP, &CMD_NOTICE,
			"@%s :%s invited %s into channel %s.", chptr->chname, sptr->name,
			acptr->name, chptr->chname);
	}
	else {
		sendto_one_client(acptr, sptr, &CMD_INVITE, ":%s", parv[2]);
	}
	return 0;
}
