/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_mkpasswd.c,v 1.25.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_mkpasswd) = {
	"m_mkpasswd",
	"/MKPASSWD command",
	6, "$Revision: 1.25.2.2 $"
};

int MOD_LOAD(m_mkpasswd)()
{
	if (register_command(&MOD_HEADER(m_mkpasswd), &CMD_MKPASSWD, m_mkpasswd) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_mkpasswd)()
{
	return MOD_SUCCESS;
}

/*
 * m_mkpasswd
 *	parv[0] = sender prefix
 *	parv[1] = type
 *	parv[2] = string
 */
int m_mkpasswd(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	if (!HasMode(sptr, UMODE_OPER)) {
		send_me_numericNA(sptr, ERR_NOPRIVILEGES);
		return 0;
	}
	if (parc < 3 || *parv[1] == '\0') {
		send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "MKPASSWD");
		return 0;
	}

	make_auth_passwd(sptr, parv[1], parv[2]);
	return 0;
}
