/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_unsgline.c,v 1.23.2.2 2005/01/15 23:53:31 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "user_ban.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_unsgline) = {
	"m_unsgline",
	"/UNSGLINE command",
	6, "$Revision: 1.23.2.2 $"
};

int MOD_LOAD(m_unsgline)()
{
	if (register_command(&MOD_HEADER(m_unsgline), &CMD_UNSGLINE, m_unsgline) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_unsgline)()
{
	return MOD_SUCCESS;
}

int m_unsgline(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	int matchit = 0;
	char *mask;

	if (!(IsServer(sptr) || IsULine(sptr))) {
		return 0;
	}
	if (parc < 2) {
		return 0;
	}

	if (parc == 3) {
		matchit = atoi(parv[1]);
		mask = parv[2];
	}
	else {
		mask = parv[1];
	}

	remove_simbans_match_mask(SBAN_GCOS|BAN_NETWORK, mask, matchit);

	if (parc == 3) {
		sendto_serv_msg_butone(cptr, sptr, &CMD_UNSGLINE, "%d :%s", matchit, mask);
	}
	else {
		sendto_serv_msg_butone(cptr, sptr, &CMD_UNSGLINE, ":%s", mask);
	}

	return 0;
}
