/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_version.c,v 1.36.2.3 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "patchlevel.h"
#include "isupport.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

extern char server_options[];

Module MOD_HEADER(m_version) = {
	"m_version",
	"/VERSION command",
	6, "$Revision: 1.36.2.3 $"
};

int MOD_LOAD(m_version)()
{
	if (register_command(&MOD_HEADER(m_version), &CMD_VERSION, m_version) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_version)()
{
	return MOD_SUCCESS;
}

/*
 * m_version
 *	parv[0] = sender prefix
 *	parv[1] = remote server
 */
int m_version(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	static time_t last_used = 0L;

	if (use_or_deliver(cptr, sptr, &CMD_VERSION, ":%s", 1, parc, parv) != HUNTED_ISME) {
		return 0;
	}
	if (!HasMode(sptr, UMODE_OPER)) {
		if (FloodConfig.pace_wait_simple && (last_used + FloodConfig.pace_wait_simple > timeofday)) {
			send_me_numericNA(sptr, RPL_LOAD2HI);
			return 0;
		}
		else {
			last_used = timeofday;
		}
		if (GeneralConfig.spy_notices && IsPerson(sptr)) {
			sendto_realops_lev(SPY_LEV, "VERSION requested by %s (%s@%s) [%s]", sptr->name,
				sptr->username, MaskedHost(sptr), sptr->user->server);
		}
	}

	send_me_numeric(sptr, RPL_VERSION, ircd_version, revision, me.name, server_options, TS_CURRENT);

	if (MyClient(sptr)) {
		send_me_numeric(sptr, RPL_ISUPPORT, isupport_buf[0]);
		send_me_numeric(sptr, RPL_ISUPPORT, isupport_buf[1]);
	}

	return 0;
}
