/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_vhost.c,v 1.44.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_vhost) = {
	"m_vhost",
	"VHOST protocol",
	6, "$Revision: 1.44.2.2 $"
};

int MOD_LOAD(m_vhost)()
{
	if (register_command(&MOD_HEADER(m_vhost), &CMD_VHOST, m_vhost) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_vhost)()
{
	return MOD_SUCCESS;
}

/*
 * m_vhost
 *	parv[0] = sender prefix
 *	parv[1] = client
 *	parv[2] = vhost
 */
int m_vhost(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	aClient *acptr;
	
	if (!IsServer(sptr)) {
		return 0;
	}
	if (!CapVHOST(cptr)) {
		ircdlog(LOG_ERROR, "Ignoring VHOST from non-VHOST capable uplink: %s", cptr->name);
		return 0;
	}

	if (parc < 3 || BadPtr(parv[2])) {
		ircdlog(LOG_ERROR, "Got VHOST with wrong parameter count: parc=%d", parc);
		return 0;
	}

	if ((acptr = find_person_target(parv[1])) != NULL) {		
		AddMode(acptr, UMODE_MASKED);
		strncpyzt(acptr->user->maskedhost, parv[2], HOSTLEN + 1);
	}

	sendto_serv_capab_msg_butone(cptr, sptr, CAP_VHOST, ID_CAPS, &CMD_VHOST,
		"%s %s", acptr->name, acptr->user->maskedhost);
	sendto_serv_capab_msg_butone(cptr, sptr, CAP_VHOST|ID_CAPS, NO_CAPS, &CMD_VHOST,
		"%s %s", get_id(acptr), acptr->user->maskedhost);

	return 0;
}
