/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_whowas.c,v 1.25.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

extern char *canonize(char *);
extern void init_whowas();
extern unsigned int hash_whowas_name(char *);
extern aWhowas WHOWAS[NICKNAMEHISTORYLENGTH];
extern aWhowas *WHOWASHASH[WW_MAX];

Module MOD_HEADER(m_whowas) = {
	"m_whowas",
	"/WHOWAS command",
	6, "$Revision: 1.25.2.2 $"
};

int MOD_LOAD(m_whowas)()
{
	if (register_command(&MOD_HEADER(m_whowas), &CMD_WHOWAS, m_whowas) == NULL) {
		return MOD_FAILURE;
	}
	init_whowas();
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_whowas)()
{
	return MOD_SUCCESS;
}

/*
 * m_whowas
 *	parv[0] = sender prefix
 *	parv[1] = nickname queried
 */
int m_whowas(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	aWhowas *tmp = NULL;
	int cur = 0, found = 0, max = -1;
	char *p, *nick, *s;
	static time_t last_used = 0L;

	if (parc < 2) {
		send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "WHOWAS");
		return 0;
	}
	if (parc > 2) {
		max = atoi(parv[2]);
	}

	if (!HasMode(sptr, UMODE_OPER)) {
		if (FloodConfig.pace_wait_intense > 0 && (last_used + FloodConfig.pace_wait_intense > timeofday)) {
			send_me_numericNA(sptr, RPL_LOAD2HI);
			return 0;
		}
		else {
			last_used = timeofday;
		}
	}
	if (parc > 3) {
		if (use_or_deliver(cptr, sptr, &CMD_WHOWAS, "%s %s :%s", 3, parc, parv)) {
			return 0;
		}
	}

	parv[1] = canonize(parv[1]);
	if (!MyConnect(sptr) && max > 20) {
		max = 20;
	}
	for (s = parv[1]; (nick = strtoken(&p, s, ",")) != NULL; s = NULL) {
		found = 0;
		for (tmp = WHOWASHASH[hash_whowas_name(nick)]; tmp != NULL; tmp = tmp->next) {
			if (!mycmp(nick, tmp->name)) {
				send_me_numeric(sptr, RPL_WHOWASUSER, tmp->name, tmp->username,
					tmp->maskedhost, tmp->realname);
				if (HasMode(sptr, UMODE_OPER)) {
					send_me_numeric(sptr, RPL_WHOWASHOST, tmp->name,
						tmp->hostname);
				}
				send_me_numeric(sptr, RPL_WHOISSERVER, tmp->name, tmp->servername,
					myctime(tmp->logoff));
				cur++;
				found++;
			}
			if (max > 0 && cur > max) {
				break;
			}
		}
		if (!found) {
			send_me_numeric(sptr, ERR_WASNOSUCHNICK, nick);
		}
		if (p != NULL) {
			p[-1] = ',';
		}
	}
	send_me_numeric(sptr, RPL_ENDOFWHOWAS, parv[1]);
	return 0;
}
