/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: ircd_signal.c,v 1.22.2.2 2005/07/09 15:09:23 amcwilliam Exp $
 */

#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "h.h"
#include "setup.h"
#include "hook.h"
#include <signal.h>

static void dummy_handler()
{
	/* Nothing */
}

static void sigterm_handler()
{
	ircdlog(LOG_DEFAULT, "Server shutting down due to SIGTERM, deleting pid");
	unlink(PID_FILE);
	exit(EXIT_SUCCESS);
}

static void sighup_handler()
{
	sendto_realops("Received signal SIGHUP, reloading ircd.conf.");
	ircdlog(LOG_DEFAULT, "Received SIGHUP, reloading ircd.conf.");
	Internal.do_rehash = 1;
}

#ifndef STATIC_MODULES
static void sigusr1_handler()
{
	sendto_realops("Received signal SIGUSR1, reloading modules.");
	ircdlog(LOG_DEFAULT, "Received SIGUSR1, reloading modules.");
	Internal.do_module_rehash = 1;
}
#endif

static void sigint_handler()
{
	static int been_here = 0;

	if (Internal.run_in_terminal) {
		ircdlog(LOG_DEFAULT, "Server exiting on SIGINT");
		exit(EXIT_SUCCESS);
	}

	if (!been_here) {
		ircdlog(LOG_DEFAULT, "Server restarting on SIGINT");
		been_here = 1;
		server_reboot();
	}
}

void server_die()
{
	sigterm_handler();
}

void init_signal()
{
	struct sigaction act;

	act.sa_handler = SIG_IGN;
	act.sa_flags = 0;

	sigemptyset(&act.sa_mask);
	sigaddset(&act.sa_mask, SIGPIPE);
	sigaddset(&act.sa_mask, SIGALRM);
#ifdef SIGWINCH
	sigaddset(&act.sa_mask, SIGWINCH);
	sigaction(SIGWINCH, &act, NULL);
#endif
	sigaction(SIGPIPE, &act, NULL);
	act.sa_handler = dummy_handler;
	sigaction(SIGALRM, &act, NULL);

	act.sa_handler = sighup_handler;
	sigemptyset(&act.sa_mask);
	sigaddset(&act.sa_mask, SIGHUP);
	sigaction(SIGHUP, &act, NULL);

#ifndef STATIC_MODULES
	act.sa_handler = sigusr1_handler;
	sigemptyset(&act.sa_mask);
	sigaddset(&act.sa_mask, SIGUSR1);
	sigaction(SIGUSR1, &act, NULL);
#endif

	act.sa_handler = sigint_handler;
	sigaddset(&act.sa_mask, SIGINT);
	sigaction(SIGINT, &act, NULL);

	act.sa_handler = sigterm_handler;
	sigaddset(&act.sa_mask, SIGTERM);
	sigaction(SIGTERM, &act, NULL);
}
