/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: s_numeric.c,v 1.8.2.1 2004/12/07 03:05:37 pneumatus Exp $
 */

#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "channel.h"
#include "h.h"
#include "memory.h"

static char buf[1024];

int do_numeric(int numeric, aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	aClient *acptr;
	aChannel *chptr;
	char *nick, *p, numbuf[16];
	int i, len = 0;
	msg_ptr msg;

	if (parc < 1 || !IsServer(sptr)) {
		return 0;
	}
	if (numeric < 100) {
		numeric += 100;
	}

	ircsprintf(numbuf, "%d", numeric);
	msg.msg_str = numbuf;
	msg.tok_str = NULL;
	msg.flags = 0;

	buf[len] = '\0';
	if (parc > 1) {
		for (i = 2; i < (parc - 1); i++) {
			if (len > 0) {
				buf[len++] = ' ';
			}
			for (p = parv[i]; *p != '\0'; p++) {
				buf[len++] = *p;
			}
		}

		buf[len++] = ' ';
		buf[len++] = ':';

		for (p = parv[parc - 1]; *p != '\0'; p++) {
			buf[len++] = *p;
		}
		buf[len] = '\0';
	}
	for (p = NULL; (nick = strtoken(&p, parv[1], ",")) != NULL; parv[1] = NULL) {
		if ((acptr = find_target(nick)) != NULL) {
			if (!IsMe(acptr) && acptr->from != cptr) {
				sendto_one_client_prefixed(acptr, sptr, &msg, "%s", buf);
			}
		}
		else if ((chptr = find_channel(nick, NULL)) != NULL) {
			sendto_channel_msg_butone(cptr, sptr, chptr, ALL_MEMBERS, &msg, "%s", buf);
		}
	}
	return 0;
}
