/*
   Name: $RCSfile: list.h,v $
   Author: Alan Moran
   $Date: 2005/08/05 21:33:20 $
   $Revision: 1.7 $
   $Id: list.h,v 1.7 2005/08/05 21:33:20 nloyola Exp $

   Description:
   Function prototypes and macros to support linked lists.

   Legal Notice:

   This program is free software; you can redistribute it and/or
   modify it under the terms of the license contained in the
   COPYING file that comes with this distribution.

 */

/** \file list.h */

#ifndef INCLUDE_LIST_H
#define INCLUDE_LIST_H

BEGIN_C_DECLS

#include "strutil.h"

/**
   Use rpl_list_node in a structure to create linked lists of that structure.
 */
typedef struct rpl_list_node_s {
    void *                   data_ptr;
    struct rpl_list_node_s * next;
    struct rpl_list_node_s * prev;
} rpl_list_node;

/**
   Contains a doubly linked list.
 */
typedef struct
{
    rpl_list_node * first;
    rpl_list_node * last;
    unsigned        count;
} rpl_list;

/**
   Used to insert items into a linked list.
*/
typedef enum
{
    RPL_LIST_INSERT_BEFORE, /**< inserts new node before selected node */
    RPL_LIST_INSERT_AFTER,  /**< inserts new node after selected node */
} RPL_LIST_INSERT_POS;

void            rpl_list_init(rpl_list * list_p);

rpl_list_node * rpl_list_prepend(rpl_list *      list_p,
                                 rpl_list_node * node_p,
                                 void *          data_ptr);

rpl_list_node * rpl_list_append(rpl_list *      list_p,
                                 rpl_list_node *node_p,
                                 void *         data_ptr);

void            rpl_list_insert (rpl_list *          list_p,
                                 rpl_list_node *     node_p,
                                 RPL_LIST_INSERT_POS position,
                                 rpl_list_node *     new_node_p,
                                 void *              data_ptr);

void *          rpl_list_first (rpl_list * list_p);
void *          rpl_list_last (rpl_list * list_p);
void *          rpl_list_next (rpl_list_node * node_p);
void *          rpl_list_prev (rpl_list_node * node_p);

unsigned        rpl_list_count(rpl_list * list_p);
void            rpl_list_remove(rpl_list * list_p, rpl_list_node * node_p);

END_C_DECLS

#endif
