#ifndef INCLUDE_RPL_REGEX_H
#define INCLUDE_RPL_REGEX_H

/*
   Name: $RCSfile: regex.h,v $
   Author: Nelson Loyola
   $Date: 2005/07/15 14:38:56 $
   $Revision: 1.2 $
   $Id: regex.h,v 1.2 2005/07/15 14:38:56 nloyola Exp $

   Description:
   Wrapper code for PCRE.

   Legal Notice:

   This program is free software; you can redistribute it and/or
   modify it under the terms of the license contained in the
   COPYING file that comes with this distribution.

 */

/**
   @file

   @brief Definitions used by regular expression module.

*/

#include "globals.h"
#include "strutil.h"

BEGIN_C_DECLS

/**
  @brief Flags used to create a regular expression.

*/
typedef enum
{
   RPL_REGEX_FLAG_NONE        = 0, /**< No flags. */
   RPL_REGEX_FLAG_GLOBAL      = 1, /**< Peforms processing on all occurances. */
   RPL_REGEX_FLAG_IGNORE_CASE = 2, /**< Ignores capitalization. */
   RPL_REGEX_FLAG_MULTILINE   = 4  /**< Performs multiple line processing. */
} RPL_REGEX_FLAG;

typedef struct rpl_regex_s rpl_regex_t;

rpl_regex_t * rpl_regex_create (rpl_str_t pattern, unsigned flags);
void          rpl_regex_destroy (rpl_regex_t * re_p);
unsigned      rpl_regex_match (rpl_regex_t * re_p,
                               rpl_str_t      str,
                               int           offset);
rpl_str_t     rpl_regex_capture (rpl_regex_t * re_p,
                                 unsigned      substr_num);
void          rpl_regex_capture_info (rpl_regex_t * re_p,
                                      unsigned      substr_num,
                                      int          *start_pos_p,
                                      int          *end_pos_p);
unsigned      rpl_regex_capture_substr_num (rpl_regex_t * re_p);

rpl_str_t     rpl_regex_replace (rpl_regex_t * re_p,
                                 rpl_str_t      str,
                                 rpl_str_t      replace_str);



END_C_DECLS

#endif /* INCLUDE_RPL_REGEX_H */
