/*
   Name: $RCSfile: str_list.c,v $
   Author: Alan Moran
   $Date: 2005/08/05 21:33:20 $
   $Revision: 1.1 $
   $Id: str_list.c,v 1.1 2005/08/05 21:33:20 nloyola Exp $

   Legal Notice:

   This program is free software; you can redistribute it and/or
   modify it under the terms of the license contained in the
   COPYING file that comes with this distribution.

 */

/**
   @file

   @brief Implementation to support linked lists of strings.
*/

#include "globals.h"

/**
   Allocates memory for a new node containing the string.

   @param str The string the node is to contain.
*/
rpl_str_list_node * rpl_str_list_create_node (rpl_str_t str)
{
    size_t len;
    rpl_str_list_node * node_p;

    assert (str != NULL);
    node_p = (rpl_str_list_node *) rpl_me_malloc (sizeof (rpl_str_list_node));
    assert (node_p != NULL);
    len = strlen (str);
    node_p->str = (rpl_str_t) rpl_me_malloc (len + 1);
    bzero (node_p->str, len + 1);
    strncpy (node_p->str, str, len);
    return node_p;
}

/**
   Free up the resources used by a single node in a string list.

   @param node_p Pointer to the node.
*/
void rpl_str_list_destroy_node (rpl_str_list_node * node_p)
{
    assert (node_p != NULL);
    rpl_me_free (node_p->str);
    rpl_me_free (node_p);
}

/**
   Free up the resources used by a string list.

   @param list_p Pointer to the list.
*/
void rpl_str_list_destroy (rpl_list * list_p)
{
    rpl_str_list_node * curr_p = rpl_list_first (list_p);

    while (curr_p != NULL)
    {
        rpl_list_remove (list_p, &curr_p->node);
        rpl_str_list_destroy_node (curr_p);
        curr_p = rpl_list_first (list_p);
    }
}
