/***************************************************************************
    file	         : kb_dummy.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<time.h>
#include	<sys/types.h>

#ifdef 		_WIN32
#include 	<windows.h>
#endif

#include	<qarray.h>
#include	<qstring.h>
#include	<qdict.h>
#include	<qintdict.h>



#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_databuffer.h"
#include	"kb_database.h"
#include	"kb_serverinfo.h"
#include	"kb_build.h"

#include	"kb_library.h"

struct	DummyTypeMap
{	int		ident		;	/* Dummy identifier	*/
	KB::IType	itype		;	/* Internal type	*/
	char		mtype	[16]	;	/* Dummy type name	*/
	uint		flags		;	/* Various flags	*/
}	;



#define	FIELD_TYPE_UNSET	(-1)

static	DummyTypeMap	typeMap[] =
{
/*	ident			itype		mtype		flags		*/
{	0,			KB::ITFixed,	"Integer",	0			},
{	1,			KB::ITFloat,	"Float",	FF_LENGTH|FF_PREC	},

{	2,			KB::ITDate,	"Date",		0			},
{	3,		 	KB::ITTime,	"Time",		0			},
{	4,		 	KB::ITDateTime,	"DateTime",	0			},

{	5,			KB::ITString,	"Char",		FF_LENGTH		},
{	6,			KB::ITString,	"VarChar",	FF_LENGTH		},

{	7,			KB::ITBinary,	"Binary",	0			}
}	;




/*  KBDummyType								*/
/*  -----------								*/

class	KBDummyType : public KBType
{
	DummyTypeMap	*m_typeInfo	;

public	:

	KBDummyType  (DummyTypeMap *, uint, uint, bool) ;

	virtual	bool    isValid      (const QString &, KBError  &, const QString & = QString::null) ;
	virtual	void	getQueryText (KBDataArray   *, KBShared *, KBDataBuffer  &) ;
}	;



/*  KBDummy								*/
/*  -------								*/
/*  Implementation class for insertface to the Dummy database		*/

class	KBDummy : public KBServer
{
	bool		doListTables 	(KBTableDetailsList &, uint) ;

	virtual	bool	 	doConnect    	(KBServerInfo  *) ;
	virtual	bool		doListFields 	(KBTableSpec   &) ;
	virtual	bool		doCreateTable	(KBTableSpec   &,  bool) ;
	virtual	bool		doRenameTable	(cchar *, cchar *, bool) ;
	virtual	bool		doDropTable  	(cchar *,	   bool) ;

public	:

	KBDummy	() ;
virtual~KBDummy () ;


	virtual	KBSQLSelect	*qrySelect 	(bool, const QString &) ;
	virtual	KBSQLUpdate	*qryUpdate 	(bool, const QString &, const QString &) ;
	virtual	KBSQLInsert	*qryInsert 	(bool, const QString &, const QString &) ;
	virtual	KBSQLDelete	*qryDelete 	(bool, const QString &, const QString &) ;

	virtual	bool		command		(bool, const QString &, uint, KBValue *, KBSQLSelect ** = 0) ;


	virtual	QString		listTypes	() ;
	virtual	bool		tableExists	(const QString &, bool &) ;
}	;


/*  KBDummyQrySelect							*/
/*  ----------------							*/
/*  Implementation class for select queries on the Dummy database	*/

class	KBDummyQrySelect : public KBSQLSelect
{
	KBDummy		*m_server	;
	uint		m_crow		;
	ulong		*m_lengths	;


public	:
	KBDummyQrySelect (KBDummy *, bool, const QString &) ;
virtual~KBDummyQrySelect () ;

	virtual	bool	execute		(uint, const KBValue * ) ;
	virtual	KBValue	getField	(uint, uint, KBValue::VTrans) ;
	virtual	QString	getFieldName	(uint) ;
}	;


/*  KBDummyQryUpdate							*/
/*  ----------------							*/
/*  Implementation class for update queries on the Dummy database	*/

class	KBDummyQryUpdate : public KBSQLUpdate
{
	KBDummy	*m_server	;

public	:
	KBDummyQryUpdate (KBDummy *, bool, const QString &, const QString &) ;
virtual~KBDummyQryUpdate () ;

	virtual	bool	execute	 (uint, const KBValue * ) ;

}	;

/*  KBDummyQryInsert							*/
/*  ----------------							*/
/*  Implementation class for insert queries on the Dummy database	*/

class	KBDummyQryInsert : public KBSQLInsert
{
	KBDummy		*m_server	;
	QString		m_autocol	;
	KBValue		m_newKey	;

public	:
	KBDummyQryInsert (KBDummy *, bool, const QString &, const QString &) ;
virtual~KBDummyQryInsert () ;

	virtual	bool	execute	  (uint, const KBValue *) ;
	virtual	bool	getNewKey (const QString &, KBValue &, bool) ;
}	;

/*  KBDummyQryDelete							*/
/*  ----------------							*/
/*  Implementation class for delete queries on the Dummy database	*/

class	KBDummyQryDelete : public KBSQLDelete
{
	KBDummy		*m_server	;

public	:
	KBDummyQryDelete (KBDummy *, bool, const QString &, const QString &) ;
virtual~KBDummyQryDelete () ;

	virtual	bool	execute	 (uint, const KBValue * ) ;
}	;


static	QIntDict<DummyTypeMap>	dIdentToType	;
static	QDict	<KBDummyType >	typesDict	;

/*  ------------------------------------------------------------------  */

/*  KBDummyType								*/
/*  KBDummyType	: Constructor for Dummy type object			*/
/*  typeInfo	: DummyTypeMap * : Type information			*/
/*  length	: uint		 : Underlying database length		*/
/*  prec	: uint		 : Underlying database precision	*/
/*  nullOK	: bool		 : True if null is OK			*/
/*  (returns)	: KBDummyType	 :					*/

KBDummyType::KBDummyType
	(	DummyTypeMap	*typeInfo,
		uint	  	length,
		uint		prec,
		bool	  	nullOK
	)
	:
	KBType
	(	typeInfo == 0 ? KB::ITUnknown : typeInfo->itype,
		length,
		prec,
		nullOK
	),
	m_typeInfo	(typeInfo)
{
}

/*  KBDummyType								*/
/*  isValid	: Test if value is valid for type			*/
/*  value	: const QString & : Value to check			*/
/*  pError	: KBValue &	  : Error return			*/
/*  where	: const QString & : Caller				*/
/*  (returns)	: bool		  : Valid				*/

bool	KBDummyType::isValid
	(	const QString	 &value,
		KBError		 &pError,
		const QString	&where
	)
{
	/* *** Specific type checking					*/
	return	KBType::isValid (value, pError, where) ;
}

/*  KBDummyType								*/
/*  getQueryText							*/
/*  value	: KBDataArray  * : Raw text of value to convert		*/
/*  d		: KBShared     * : Decoded representation		*/
/*  buffer	: KBDataBuffer & : Results buffer			*/
/*  (returns)	: void		 :					*/

void	KBDummyType::getQueryText
	(	KBDataArray	*value,
		KBShared	*d,
		KBDataBuffer	&buffer
	)
{
	/* **** Stuff like binary escaping				*/
	KBType::getQueryText (value, d, buffer) ;
}





/*  ------------------------------------------------------------------  */

/*  KBDummy								*/
/*  KBDummy	: Constructor for Dummy database connection class	*/
/*  (returns)	: KBServer	:					*/

KBDummy::KBDummy ()
	:
	KBServer ()
{
}

/*  KBDummy								*/
/*  ~KBDummy	: Destructor for Dummy database connection class	*/
/*  (returns)	:		:					*/

KBDummy::~KBDummy ()
{
}

/*  KBDummy								*/
/*  doConnect	: Open connection to database				*/
/*  svInfo	: KBServerInfo *: Server information			*/
/*  (returns)	: bool		: Success				*/

bool	KBDummy::doConnect
	(	KBServerInfo	*
	)
{
	return	true	;
}

/*  KBDummy								*/
/*  qrySelect	: Open a select query					*/
/*  data	: bool		  : Query for data			*/
/*  select	: const QString&: Select query				*/
/*  (returns)	: KBSQLSelect * : Select query class or NULL on error	*/

KBSQLSelect
	*KBDummy::qrySelect
	(	bool		data,
		const QString	&select
	)
{
	return	new KBDummyQrySelect (this, data, select) ;
}


/*  KBDummy								*/
/*  qryUpdate	: Open an update query					*/
/*  data	: bool		  : Query for data			*/
/*  update	: const QString & : Update query			*/
/*  tabName	: const QString & : Table being updated			*/
/*  (returns)	: KNQryUpdate *   : Update query class or NULL on error	*/

KBSQLUpdate
	*KBDummy::qryUpdate
	(	bool		data,
		const QString	&update,
		const QString	&tabName
	)
{
	return	new KBDummyQryUpdate (this, data, update, tabName) ;
}

/*  KBDummy								*/
/*  qryInsert	: Open an insert query					*/
/*  data	: bool		  : Query for data			*/
/*  insert	: const QString & : Insert query			*/
/*  tabName	: const QString & : Table being updated			*/
/*  (returns)	: KNQryInsert *   : Insert query class or NULL on error	*/

KBSQLInsert
	*KBDummy::qryInsert
	(	bool		data,
		const QString	&insert,
		const QString	&tabName
	)
{
	return	new KBDummyQryInsert (this, data, insert, tabName) ;
}

/*  KBDummy								*/
/*  qryDelete	: Open an delete query					*/
/*  data	: bool		  : Query for data			*/
/*  _delete	: const QString & : Delete query			*/
/*  tabName	: const QString & : Table being updated			*/
/*  (returns)	: KNQryDelete *   : Delete query class or NULL on error	*/

KBSQLDelete
	*KBDummy::qryDelete
	(	bool		data,
		const QString	&_delete,
		const QString	&tabName
	)
{
	return	new KBDummyQryDelete (this, data, _delete, tabName) ;
}

/*  KBDummy								*/
/*  command	: Execute arbitrary SQL					*/
/*  data	: bool		  : Querying for data			*/
/*  rawqry	: const QString & : Query text				*/
/*  nvals	: uint		  : Number of substitution values	*/
/*  values	: KBValue *	  : Substitution values			*/
/*  select	: KBSQLSelect **  : Return for result queries		*/
/*  (returns)	: bool		  : Success				*/

bool	KBDummy::command
	(	bool		,
		const QString	&,
		uint		,
		KBValue		*,
		KBSQLSelect	**
	)
{
	m_lError = KBError
		   (	KBError::Error,
			"Not implemented",
			"create",
			__ERRLOCN
		   )	;

	return	false	;
}

/*  KBDummy								*/
/*  listTypes	: Get list of types with information flags		*/
/*  (returns)	: QString	: List as bar-separated string		*/

QString	KBDummy::listTypes ()
{
	static	QString	typeList ;

	if (typeList.isNull())
	{
		typeList = "Primary Key,0|Foreign Key,0" ;

		for (uint idx = 0 ; idx < sizeof(typeMap)/sizeof(DummyTypeMap) ; idx += 1)
		{
			DummyTypeMap *m = &typeMap[idx] ;

			if ((m->flags & FF_NOCREATE) == 0)
				typeList += QString("|%1,%2").arg(m->mtype).arg(m->flags) ;
		}
	}

	return	typeList ;
}

/*  KBDummy								*/
/*  tableExists	: See if named table exists				*/
/*  table	: const QString & : Table name				*/
/*  exists	: bool &	  : True if table exists		*/
/*  (returns)	: bool		  : Success				*/

bool	KBDummy::tableExists
	(	const QString	&,
		bool		&exists
	)
{
	exists = false	; 
	return	 true	;
}

/*  KBDummy								*/
/*  doListTables: List tables in database				*/
/*  tabList	: KBTableDetailsList &					*/
/*				: Result list				*/
/*  type	: uint		: Type flags				*/
/*  (returns)	: bool		: Success				*/

bool	KBDummy::doListTables
	(	KBTableDetailsList	&,
		uint
	)
{
	return	true ;
}

/*  KBDummy								*/
/*  doListFields: List fields in table					*/
/*  tabSpec	: KBTableSpec &	: Table specification			*/
/*  (returns)	: bool		: Success				*/

bool	KBDummy::doListFields
	(	KBTableSpec	&
	)
{
	return	true ;
}

/*  KBDummy								*/
/*  doCreateTable: Create a new table					*/
/*  tabSpec	 : KBTableSpec &: Table specification			*/
/*  (returns)	 : bool		: Success				*/

bool	KBDummy::doCreateTable
	(	KBTableSpec	&,
		bool
	)
{
	m_lError = KBError
		   (	KBError::Error,
			"Not implemented",
			"create",
			__ERRLOCN
		   )	;
	return	false	;
}

/*  KBDummy								*/
/*  doRenameTable: Rename a  table					*/
/*  oldName	 : cchar *	: Current table name			*/
/*  newName	 : cchar *	: New table name			*/
/*  assoc	 : bool		: Rename associated stuff - none here	*/
/*  (returns)	 : bool		: Success				*/

bool	KBDummy::doRenameTable
	(	cchar	*,
		cchar	*,
		bool
	)
{
	m_lError = KBError
		   (	KBError::Error,
			"Not implemented",
			"rename",
			__ERRLOCN
		   )	;
	return	false	;
}

/*  KBDummy								*/
/*  doDropTable	: Drop a table						*/
/*  table	: cchar *	: Table name				*/
/*  assoc	: bool		: Drop associated stuff - none here	*/
/*  (returns)	: bool		: Success				*/

bool	KBDummy::doDropTable
	(	cchar	*,
		bool
	)
{
	m_lError = KBError
		   (	KBError::Error,
			"Not implemented",
			"drop",
			__ERRLOCN
		   )	;
	return	false	;
}


/*  ------------------------------------------------------------------- */

/*  KBDummyQrySelect							*/
/*  KBDummyQrySelect							*/
/*		: Constructor for select query object			*/
/*  server	: KBDummy *	  : Server connection object		*/
/*  data	: bool		  : Query for data			*/
/*  query	: const QString & : Select query			*/
/*  (returns)	: KBDummyQrySelect:					*/

KBDummyQrySelect::KBDummyQrySelect
	(	KBDummy		*server,
		bool		data,
		const QString	&query
	)	
	:
	KBSQLSelect	(server, data, query),
	m_server	(server)
{
	m_nRows		= 0 ;
	m_nFields	= 0 ;
	m_crow	 	= 0 ;
	m_lengths	= 0 ;
}

/*  KBDummyQrySelect							*/
/*  ~KBDummyQrySelect							*/
/*		: Destructor for select query object			*/
/*  (returns)	:		:					*/

KBDummyQrySelect::~KBDummyQrySelect ()
{
}

/*  KBDummyQrySelect							*/
/*  execute	: Execute query						*/
/*  nvals	: uint		: Number of substitution values		*/
/*  values	: KBValue *	: Substitution values			*/
/*  (returns)	: bool		: Success				*/

bool	KBDummyQrySelect::execute
	(	uint		,
		const KBValue	*
	)
{
	m_lError = KBError
		   (	KBError::Error,
			"Not implemented",
			"select",
			__ERRLOCN
		   )	;
	return	false	;
}

/*  KBDummyQrySelect							*/
/*  getField	: Get a specified field from the query results		*/
/*  qrow	: uint		: Row number				*/
/*  qcol	: uint		: Column number				*/
/*  (returns)	: KBValue	: Value					*/

KBValue	KBDummyQrySelect::getField
	(	uint		qrow,
		uint		qcol,
		KBValue::VTrans
	)
{
	/* First check that the request is within the range of rows	*/
	/* and fields returned by the query.				*/
	if ((int)qrow >= m_nRows  ) return KBValue() ;
	if (     qcol >= m_nFields) return KBValue() ;

	return	KBValue() ;
}

/*  KBDummyQrySelect							*/
/*  getFieldname: Get a specified field name from the query results	*/
/*  qcol	: uint		: Column number				*/
/*  (returns)	: QString	: Name					*/

QString	KBDummyQrySelect::getFieldName
	(	uint	qcol
	)
{
	/* First check that the request is within the range of rows	*/
	/* and fields returned by the query.				*/
	if (qcol >= m_nFields) return QString() ;

	return	QString::null ;
}


/*  KBDummyQryUpdate							*/
/*  KBDummyQryUpdate							*/
/*		: Constructor for update query object			*/
/*  server	: KBDummy *	  : Server connection object		*/
/*  data	: bool		  : Query for data			*/
/*  query	: const QString & : Update query			*/
/*  tabName	: const QString & : Table being updated			*/
/*  (returns)	: KBDummyQryUpdate:					*/

KBDummyQryUpdate::KBDummyQryUpdate
	(	KBDummy		*server,
		bool		data,
		const QString	&query,
		const QString	&tabName
	)	
	:
	KBSQLUpdate (server, data, query, tabName),
	m_server    (server)
{
	m_nRows	= 0 ;
}

/*  KBDummyQryUpdate							*/
/*  execute	: Execute query						*/
/*  nvals	: uint		: Number of substitution values		*/
/*  values	: KBValue *	: Substitution values			*/
/*  (returns)	: bool		: Success				*/

bool	KBDummyQryUpdate::execute
	(	uint		,
		const KBValue	*
	)
{
	m_lError = KBError
		   (	KBError::Error,
			"Not implemented",
			"update",
			__ERRLOCN
		   )	;
	return	false	;
}

/*  KBDummyQryUpdate							*/
/*  ~KBDummyQryUpdate							*/
/*		: Destructor for update query object			*/
/*  (returns)	:		:					*/

KBDummyQryUpdate::~KBDummyQryUpdate ()
{
}


/*  KBDummyQryInsert							*/
/*  KBDummyQryInsert							*/
/*		: Constructor for insert query object			*/
/*  server	: KBDummy *	  : Server connection object		*/
/*  data	: bool		  : Query for data			*/
/*  tabName	: const QString & : Table being updated			*/
/*  query	: const QString & : Insert query			*/
/*  (returns)	: KBDummyQryInsert:					*/

KBDummyQryInsert::KBDummyQryInsert
	(	KBDummy		*server,
		bool		data,
		const QString	&query,
		const QString	&tabName
	)	
	:
	KBSQLInsert (server, data, query, tabName),
	m_server    (server)
{
	m_nRows	= 0 ;
}

/*  KBDummyQryInsert							*/
/*  ~KBDummyQryInsert							*/
/*		: Destructor for insert query object			*/
/*  (returns)	:		:					*/

KBDummyQryInsert::~KBDummyQryInsert ()
{
}

/*  KBDummyQryInsert							*/
/*  execute	: Execute query						*/
/*  nvals	: uint		: Number of substitution values		*/
/*  values	: KBValue *	: Substitution values			*/
/*  (returns)	: bool		: Success				*/

bool	KBDummyQryInsert::execute
	(	uint		,
		const KBValue	*
	)
{
	m_lError = KBError
		   (	KBError::Error,
			"Not implemented",
			"insert",
			__ERRLOCN
		   )	;
	return	false	;
}

/*  KBDummyQryInsert							*/
/*  getNewKey	: Get new insert key					*/
/*  primary	: const QString & : Key column name			*/
/*  _newKey	: KBValue &	  : New key				*/
/*  prior	: bool		  : Pre-insert call			*/
/*  (returns)	: bool		  : Success				*/

bool	KBDummyQryInsert::getNewKey
	(	const QString	&,
		KBValue		&,
		bool		
	)
{
	return	false	;
}

/*  KBDummyQryDelete							*/
/*  KBDummyQryDelete							*/
/*		: Constructor for delete query object			*/
/*  server	: KBDummy *	  : Server connection object		*/
/*  data	: bool		  : Query for data			*/
/*  query	: const QString & : Delete query			*/
/*  tabName	: const QString & : Table being updated			*/
/*  (returns)	: KBDummyQryDelete:					*/

KBDummyQryDelete::KBDummyQryDelete
	(	KBDummy		*server,
		bool		data,
		const QString	&query,
		const QString	&tabName
	)	
	:
	KBSQLDelete (server, data, query, tabName),
	m_server    (server)
{
	m_nRows	= 0 ;
}

/*  KBDummyQryDelete							*/
/*  ~KBDummyQryDelete							*/
/*		: Destructor for delete query object			*/
/*  (returns)	:		:					*/

KBDummyQryDelete::~KBDummyQryDelete ()
{
}

/*  KBDummyQryDelete							*/
/*  execute	: Execute query						*/
/*  nvals	: uint		: Number of substitution values		*/
/*  values	: KBValue *	: Substitution values			*/
/*  (returns)	: bool		: Success				*/

bool	KBDummyQryDelete::execute
	(	uint		,
		const KBValue	*
	)
{
	m_lError = KBError
		   (	KBError::Error,
			"Not implemented",
			"delete",
			__ERRLOCN
		   )	;
	return	false	;
}


#ifndef _WIN32
KBFACTORY
(	KBDummyFactory,
	"driver_dummy"
)

KBFACTORYIMPL
(	KBDummyFactory,
	driver_dummy,
	"Rekall dummy driver",
	"Plugin",
	"0",
	"7",
	"0"
)
#else
class	KBDummyFactory : public KBFactory
{
public:
	inline	KBDummyFactory() : KBFactory ()
	{
	}
	virtual	QObject	*create(QObject * = 0, const char *	= 0, const char * = 0, 
		const QStringList &	= QStringList());
};

extern	"C"	__declspec(dllexport) void *init_libkbase_driver_Dummy()
{							
	return	new KBDummyFactory;				
}							
#endif

QObject	*KBDummyFactory::create
	(	QObject		  *parent,
		cchar		  *object,
		cchar		  *,
		const QStringList &
	)
{
	if (dIdentToType.count() == 0)
		for (uint idx = 0 ; idx < sizeof(typeMap)/sizeof(DummyTypeMap) ; idx += 1)
			if (typeMap[idx].ident != FIELD_TYPE_UNSET)
			{
				DummyTypeMap *m = &typeMap[idx] ;
				dIdentToType.insert (m->ident, m) ;
			}

	if ((parent != 0) && !parent->inherits ("QWidget"))
	{
		fprintf	(stderr, "KBDummyFactory: parent does not inherit QWidget\n") ;
		return	0  ;
	}

	if (strcmp (object, "driver"  ) == 0) return new KBDummy () ;

	if (strcmp (object, "advanced") == 0) return 0 ;

	return	0 ;
}

cchar	*KBDummyFactory::ident ()
{
	return	__KB_BUILD_IDENT	;
}
